#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef COM_BOSCH_CM_ASF_LANG_CCA_CONNECTORS_H
#define COM_BOSCH_CM_ASF_LANG_CCA_CONNECTORS_H

#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include <cstring>

/**
 * If the meaning of "Connectors" isn't clear, then there should be a description here.
 */

namespace com {
namespace bosch {
namespace cm {
namespace asf {
namespace lang {
namespace cca {
namespace Connectors {

ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 0;

static const int VERSION_MINOR = 1;

static const int VERSION_PATCH = 0;

// forward declarations
class CcaConnector;


/**
 * The CcaConnector connects ASF to CCA by specifying an application id.
 */
class CcaConnector {
public:

    /**
     * Default constructor
     */
    inline  CcaConnector ();

    /**
     * Copy constructor
     */
    inline  CcaConnector (const CcaConnector &rhs);

    /**
     * All fields constructor
     */
    inline  CcaConnector (uint16 applicationId_, uint16 maxMessages_);

    /**
     * Destructor
     */
    inline  ~CcaConnector();

    /**
     * Assignment operator
     */
    inline CcaConnector& operator = (const CcaConnector& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CcaConnector& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CcaConnector& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CcaConnector& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CcaConnector& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "applicationId"

    static const int kApplicationId = 0;

    /**
     * Clears the field "applicationId".
     *
     * The field will be set to its default value. The hasApplicationId()
     * method will return false.
     */
    inline void clearApplicationId();

    /**
     * Checks whether the field "applicationId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setApplicationId()). Otherwise it will return false.
     */
    inline bool hasApplicationId () const;

    /**
     * Returns the value of the member "applicationId".
     *
     * The CCA id of the application (must be unique in a system).
     *
     * ASF creates a OSAL queue for the given application with the name
     * "mbox_" followed by the application id. This queue is used to
     * receive CCA messages.
     *
     * @return The value of the field "applicationId"
     */
    inline uint16 getApplicationId () const;

    /**
     * Sets the value of the member "applicationId".
     *
     * The CCA id of the application (must be unique in a system).
     *
     * ASF creates a OSAL queue for the given application with the name
     * "mbox_" followed by the application id. This queue is used to
     * receive CCA messages.
     *
     * @param applicationId The value which will be set
     */
    inline void setApplicationId (uint16 applicationId_);

    // API of field "maxMessages"

    static const int kMaxMessages = 1;

    /**
     * Clears the field "maxMessages".
     *
     * The field will be set to its default value. The hasMaxMessages()
     * method will return false.
     */
    inline void clearMaxMessages();

    /**
     * Checks whether the field "maxMessages" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMaxMessages()). Otherwise it will return false.
     */
    inline bool hasMaxMessages () const;

    /**
     * Returns the value of the member "maxMessages".
     *
     * Specifies the maximum number of messages in the OSAL queue
     * (default value is 100).
     *
     * @return The value of the field "maxMessages"
     */
    inline uint16 getMaxMessages () const;

    /**
     * Sets the value of the member "maxMessages".
     *
     * Specifies the maximum number of messages in the OSAL queue
     * (default value is 100).
     *
     * @param maxMessages The value which will be set
     */
    inline void setMaxMessages (uint16 maxMessages_);

    static const CcaConnector &getDefaultInstance();

private:

    inline void set_has_applicationId ();

    inline void clear_has_applicationId ();

    inline void set_has_maxMessages ();

    inline void clear_has_maxMessages ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _applicationId;

    uint16 _maxMessages;

};

inline  CcaConnector::CcaConnector ()  :
    _applicationId (0u),
    _maxMessages (100u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CcaConnector::CcaConnector (const CcaConnector &rhs)  :
    _applicationId (0u),
    _maxMessages (100u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CcaConnector::CcaConnector (uint16 applicationId_, uint16 maxMessages_)  :
    _applicationId (applicationId_),
    _maxMessages (maxMessages_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CcaConnector::~CcaConnector() {
}

inline CcaConnector& CcaConnector::operator = (const CcaConnector& rhs) {
    if( this != &rhs ) {
        if (rhs.hasApplicationId()) {
            setApplicationId(rhs.getApplicationId());
        } else {
            clearApplicationId();
        }
        if (rhs.hasMaxMessages()) {
            setMaxMessages(rhs.getMaxMessages());
        } else {
            clearMaxMessages();
        }
    }
    return *this;
}

inline bool CcaConnector::operator == (const CcaConnector& rhs) const {
    return (((!hasApplicationId() && !rhs.hasApplicationId()) || getApplicationId() == rhs.getApplicationId()) &&
        ((!hasMaxMessages() && !rhs.hasMaxMessages()) || getMaxMessages() == rhs.getMaxMessages()));
}

inline bool CcaConnector::operator != (const CcaConnector& rhs) const {
    return ! (*this == rhs);
}

inline bool CcaConnector::operator < (const CcaConnector& rhs) const {
    if (hasApplicationId() || rhs.hasApplicationId()) {
        if (getApplicationId() < rhs.getApplicationId()) return true;
        if (getApplicationId() > rhs.getApplicationId()) return false;
    }
    if (hasMaxMessages() || rhs.hasMaxMessages()) {
        if (getMaxMessages() < rhs.getMaxMessages()) return true;
        if (getMaxMessages() > rhs.getMaxMessages()) return false;
    }
    return false;
}

inline bool CcaConnector::operator > (const CcaConnector& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CcaConnector::clear() {
    clearApplicationId();
    clearMaxMessages();
}

inline void CcaConnector::clearApplicationId() {
    if (hasApplicationId()) {
         clear_has_applicationId();
        _applicationId = 0u;
     }
}

inline bool CcaConnector::hasApplicationId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 CcaConnector::getApplicationId () const {
    return _applicationId;
}

inline void CcaConnector::setApplicationId (uint16 applicationId_) {
    set_has_applicationId();
    this->_applicationId = applicationId_;
}

inline void CcaConnector::clearMaxMessages() {
    if (hasMaxMessages()) {
         clear_has_maxMessages();
        _maxMessages = 100u;
     }
}

inline bool CcaConnector::hasMaxMessages () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 CcaConnector::getMaxMessages () const {
    return _maxMessages;
}

inline void CcaConnector::setMaxMessages (uint16 maxMessages_) {
    set_has_maxMessages();
    this->_maxMessages = maxMessages_;
}

inline void CcaConnector::set_has_applicationId () {
    _has_bits_[0] |= 1u << 0;
}

inline void CcaConnector::clear_has_applicationId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void CcaConnector::set_has_maxMessages () {
    _has_bits_[0] |= 1u << 1;
}

inline void CcaConnector::clear_has_maxMessages () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace Connectors
} // namespace cca
} // namespace lang
} // namespace asf
} // namespace cm
} // namespace bosch
} // namespace com

#endif // COM_BOSCH_CM_ASF_LANG_CCA_CONNECTORS_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
