/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2016
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     ThreadTypes.h
 *
 *\par Copyright:
 *(c) 2012-2016 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/

#ifndef ASF_THREAD_TYPES_H
#define ASF_THREAD_TYPES_H

#include "asf/core/FormatPrinting.h"

// This file includes the native thread handle type. It is platform specific by intention.

// This file needs to be adjusted in future when more thread implementations
// for different platforms are added. Right now we only have the pthread based PosixThread
// implementation. Therefore no conditions are in place to switch the thread implementation.

#include <pthread.h>

#ifdef _MSC_VER
#define THREAD_T_PRINT_ARGUMENT(x) x.p
#define THREAD_T_FORMAT ASF_PRINT_PTR_WIDTH "p"
#else
#define THREAD_T_PRINT_ARGUMENT(x) x
#define THREAD_T_FORMAT ASF_PRINT_PTR_WIDTH "lx"
#endif

namespace asf {
namespace threading {

typedef pthread_t thread_t;  // native handle of threads
}
}  // namespace asf

#endif
