/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     PrimitivesWriter.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.perick@de.bosch.com
 *          christoph.kulla@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2012 Robert Bosch Car Multimedia GmbH
 *
 *\par History:
 * See history of revision control system
 ***************************************************************************/

#ifndef ASF_STREAM_PRIMITIVESWRITER_H
#define ASF_STREAM_PRIMITIVESWRITER_H

#include "asf/core.h"
#include "asf/core/Blob.h"
#include "asf/core/Logger.h"
#include "asf/stream/OutputStreamIF.h"

namespace asf {
namespace stream {

// TODO: this should be a template to get rid of the virtual write calls
// code size may be critical then?

/**
 * A PrimitivesWriter is used to serialize data structures. It can write
 * all kinds of primitive data types to an OutputStreamIF.
 */
class PrimitivesWriter {
public:
    PrimitivesWriter(OutputStreamIF& stream_) : _stream(stream_) {}

    bool operator<<(const bool& value) {
        size_t bytesWritten = _stream.write((void*)&value, sizeof(value));
        return bytesWritten == sizeof(value);
    }

    bool operator<<(const uint8& value) {
        size_t bytesWritten = _stream.write((void*)&value, sizeof(value));
        return bytesWritten == sizeof(value);
    }

    bool operator<<(const uint16& value) {
        size_t bytesWritten = _stream.write((void*)&value, sizeof(value));
        return bytesWritten == sizeof(value);
    }

    bool operator<<(const uint32& value) {
        size_t bytesWritten = _stream.write((void*)&value, sizeof(value));
        return bytesWritten == sizeof(value);
    }

    bool operator<<(const uint64& value) {
        size_t bytesWritten = _stream.write((void*)&value, sizeof(value));
        return bytesWritten == sizeof(value);
    }

    bool operator<<(const int8& value) {
        size_t bytesWritten = _stream.write((void*)&value, sizeof(value));
        return bytesWritten == sizeof(value);
    }

    bool operator<<(const int16& value) {
        size_t bytesWritten = _stream.write((void*)&value, sizeof(value));
        return bytesWritten == sizeof(value);
    }

    bool operator<<(const int32& value) {
        size_t bytesWritten = _stream.write((void*)&value, sizeof(value));
        return bytesWritten == sizeof(value);
    }

    bool operator<<(const int64& value) {
        size_t bytesWritten = _stream.write((void*)&value, sizeof(value));
        return bytesWritten == sizeof(value);
    }

    bool operator<<(const float& value) {
        size_t bytesWritten = _stream.write((void*)&value, sizeof(value));
        return bytesWritten == sizeof(value);
    }

    bool operator<<(const double& value) {
        size_t bytesWritten = _stream.write((void*)&value, sizeof(value));
        return bytesWritten == sizeof(value);
    }

    bool operator<<(const ::asf::core::Blob& value) {
        ::asf::core::Logger _logger = ::asf::core::Logger::_systemLogger;
        LOG_ASSERT(value.getSize() <= UINT32_MAX);
        uint32 length = static_cast< uint32 >(
            value.getSize());  // the size is encoded as a 32 bit value in cmsbin format
        if (*this << length) {
            if (length > 0) {
                size_t bytesWritten = _stream.write(value.getBytes(), length);
                return bytesWritten == length;
            }
            return true;
        }
        return false;
    }

    bool operator<<(const std::string& value) {
        ::asf::core::Logger _logger = ::asf::core::Logger::_systemLogger;
        LOG_ASSERT(value.length() <= UINT32_MAX);
        uint32 length = static_cast< uint32 >(
            value.length());  // the length is encoded as a 32 bit value in cmsbin format
        if (*this << length) {
            if (length > 0) {
                size_t bytesWritten = _stream.write((void*)value.c_str(), length);
                return bytesWritten == length;
            }
            return true;
        }
        return false;
    }

    bool operator<<(const ::asf::core::Char& value) { return *this << value.getChar(); }

    bool writeBuffer(const void* buffer, size_t length) {
        size_t bytesWritten = _stream.write(buffer, length);
        return bytesWritten == length;
    }

private:
    OutputStreamIF& _stream;
};
}  // namespace stream
}  // namespace asf

#endif
