/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     PrimitivesReader.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.perick@de.bosch.com
 *          christoph.kulla@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2012 Robert Bosch Car Multimedia GmbH
 *
 *\par History:
 * See history of revision control system
 ***************************************************************************/

#ifndef ASF_STREAM_PRIMITIVESREADER_H
#define ASF_STREAM_PRIMITIVESREADER_H

#include "asf/core.h"
#include "asf/core/Blob.h"
#include "asf/stream/InputStreamIF.h"

namespace asf {
namespace stream {

// TODO: this should be a template to get rid of the virtual write calls
// code size may be critical then?

/**
 * A PrimitivesReader is used to deserialize data structures. It can read
 * all kinds of primitive data types from an InputStreamIF.
 */
class PrimitivesReader {
public:
    PrimitivesReader(InputStreamIF& stream_) : _stream(stream_) {}

    bool operator>>(bool& value) {
        size_t bytesRead = _stream.read((void*)&value, sizeof(value));
        return bytesRead == sizeof(value);
    }

    bool operator>>(uint8& value) {
        size_t bytesRead = _stream.read((void*)&value, sizeof(value));
        return bytesRead == sizeof(value);
    }

    bool operator>>(uint16& value) {
        size_t bytesRead = _stream.read((void*)&value, sizeof(value));
        return bytesRead == sizeof(value);
    }

    bool operator>>(uint32& value) {
        size_t bytesRead = _stream.read((void*)&value, sizeof(value));
        return bytesRead == sizeof(value);
    }

    bool operator>>(uint64& value) {
        size_t bytesRead = _stream.read((void*)&value, sizeof(value));
        return bytesRead == sizeof(value);
    }

    bool operator>>(int8& value) {
        size_t bytesRead = _stream.read((void*)&value, sizeof(value));
        return bytesRead == sizeof(value);
    }

    bool operator>>(int16& value) {
        size_t bytesRead = _stream.read((void*)&value, sizeof(value));
        return bytesRead == sizeof(value);
    }

    bool operator>>(int32& value) {
        size_t bytesRead = _stream.read((void*)&value, sizeof(value));
        return bytesRead == sizeof(value);
    }

    bool operator>>(int64& value) {
        size_t bytesRead = _stream.read((void*)&value, sizeof(value));
        return bytesRead == sizeof(value);
    }

    bool operator>>(float& value) {
        size_t bytesRead = _stream.read((void*)&value, sizeof(value));
        return bytesRead == sizeof(value);
    }

    bool operator>>(double& value) {
        size_t bytesRead = _stream.read((void*)&value, sizeof(value));
        return bytesRead == sizeof(value);
    }

    bool operator>>(::asf::core::Blob& value) {
        uint32 length = 0;
        size_t bytesRead = _stream.read((void*)&length, 4);
        if (bytesRead == 4) {
            value.setSize(length);
            if (length > 0) {
                bytesRead = _stream.read((void*)value.getBytes(), length);
                return bytesRead == length;
            }
            value.setSize(0);
            return true;
        }
        return false;
    }

    bool operator>>(std::string& value) {
        uint32 length = 0;  // string length is encoded as a 4-byte value
        size_t bytesRead = _stream.read((void*)&length, 4);
        if (bytesRead == 4) {
            if (length > 0) {
                value.resize(length);
                bytesRead = _stream.read((void*)value.c_str(), length);
                return bytesRead == length;
            }
            value.assign("");
            return true;
        }
        return false;
    }

    bool operator>>(::asf::core::Char& value) { return *this >> value.getCharMutable(); }

    bool readBuffer(void* buffer, size_t length) {
        size_t bytesRead = _stream.read(buffer, length);
        return bytesRead == length;
    }

private:
    InputStreamIF& _stream;
};
}  // namespace stream
}  // namespace asf

#endif
