/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     OutputStreamIF.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.perick@de.bosch.com
 *          christoph.kulla@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2012 Robert Bosch Car Multimedia GmbH
 *
 *\par History:
 * See history of revision control system
 ***************************************************************************/

#ifndef ASF_STREAM_OUTPUTSTREAMIF_H
#define ASF_STREAM_OUTPUTSTREAMIF_H

namespace asf {
namespace stream {

/**
 * A client can write a chunk of memory to a OutpuStreamIF.
 */
class OutputStreamIF {
public:
    virtual ~OutputStreamIF() {}

    /**
     * Writes a chunk to the stream of the specified size. The return
     * value reflects the number of bytes which were actually written. If
     * the return value is less then size, no more data can be written
     * to the stream.
     */
    virtual size_t write(const void* buffer, size_t size) = 0;
};
}  // namespace stream
}  // namespace asf

#endif
