/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     FourBytePaddingInputStream.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.kulla@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2012 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/

#ifndef ASF_STREAM_FOURBYTEPADDINGINPUTSTREAM_H
#define ASF_STREAM_FOURBYTEPADDINGINPUTSTREAM_H

#include "asf/core/Types.h"
#include "asf/stream/InputStreamIF.h"

namespace asf {
namespace stream {

/**
 * A stream which reads data from another stream. Every time a chunk is read
 * the stream moves forward to a 4 byte aligned address.
 *
 * TODO: replace this class with a PackedInputStream where data is aligned
 * with the next element (e.g. 2 2-bytes reads result in 4 bytes, a 1-byte and
 * 4-byte read results in 8 bytes, the 4-byte has to start at an even address).
 */
class FourBytePaddingInputStream : public InputStreamIF {
public:
    FourBytePaddingInputStream(InputStreamIF& delegate) : _delegate(delegate) {}

    virtual size_t read(void* buffer, size_t size) {
        size_t rv = _delegate.read(buffer, size);
        if (rv == size) {
            unsigned int padding = size % 4;
            switch (padding) {
            case 0:
                break;
            case 1: {
                uint32 t = 0;
                // FIXME: what happens if this read fails?
                _delegate.read(&t, 3);
            } break;
            case 2: {
                uint16 t = 0;
                _delegate.read(&t, 2);
            } break;
            case 3: {
                uint8 t = 0;
                _delegate.read(&t, 1);
            } break;
            }
        }
        return rv;
    }

private:
    InputStreamIF& _delegate;
};
}  // namespace stream
}  // namespace asf

#endif
