#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ASF_DBUS_ORG_FREEDESKTOP_DBUS_H
#define ASF_DBUS_ORG_FREEDESKTOP_DBUS_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstddef>
#include <cstring>
#include <map>
#include <string>

/**
 * If the meaning of "DBus" isn't clear, then there should be a description here.
 */

namespace asf {
namespace dbus {
namespace org {
namespace freedesktop {
namespace DBus {

// method IDs
static const uint16 ID_Hello = 0;
static const uint16 ID_RequestName = 1;
static const uint16 ID_ReleaseName = 2;
static const uint16 ID_StartServiceByName = 3;
static const uint16 ID_UpdateActivationEnvironment = 4;
static const uint16 ID_AddMatch = 5;
static const uint16 ID_RemoveMatch = 6;
static const uint16 ID_NameHasOwner = 7;
static const uint16 ID_GetNameOwner = 8;

// signal IDs
static const uint16 ID_NameOwnerChanged = 9;
static const uint16 ID_NameAcquired = 10;

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class HelloResponse;

class RequestNameRequest;

class RequestNameResponse;

class ReleaseNameRequest;

class ReleaseNameResponse;

class StartServiceByNameRequest;

class StartServiceByNameResponse;

class UpdateActivationEnvironmentRequest;

class AddMatchRequest;

class RemoveMatchRequest;

class NameHasOwnerRequest;

class NameHasOwnerResponse;

class GetNameOwnerRequest;

class GetNameOwnerResponse;

class NameOwnerChangedSignal;

class NameAcquiredSignal;

// type definitions
/**
 * If the meaning of "HelloRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage HelloRequest;

/**
 * If the meaning of "HelloError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError HelloError;

/**
 * If the meaning of "RequestNameError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequestNameError;

/**
 * If the meaning of "ReleaseNameError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReleaseNameError;

/**
 * If the meaning of "StartServiceByNameError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StartServiceByNameError;

/**
 * If the meaning of "UpdateActivationEnvironmentResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage UpdateActivationEnvironmentResponse;

/**
 * If the meaning of "UpdateActivationEnvironmentError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UpdateActivationEnvironmentError;

/**
 * If the meaning of "AddMatchResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage AddMatchResponse;

/**
 * If the meaning of "AddMatchError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AddMatchError;

/**
 * If the meaning of "RemoveMatchResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RemoveMatchResponse;

/**
 * If the meaning of "RemoveMatchError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RemoveMatchError;

/**
 * If the meaning of "NameHasOwnerError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError NameHasOwnerError;

/**
 * If the meaning of "GetNameOwnerError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetNameOwnerError;

/**
 * If the meaning of "NameOwnerChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError NameOwnerChangedError;

/**
 * If the meaning of "NameAcquiredError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError NameAcquiredError;


/**
 * If the meaning of "HelloResponse" isn't clear, then there should be a description here.
 */
class HelloResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HelloResponse ();

    /**
     * Copy constructor
     */
    inline  HelloResponse (const HelloResponse &rhs);

    /**
     * All fields constructor
     */
    inline  HelloResponse (const ::std::string& arg1_);

    /**
     * Destructor
     */
    inline virtual  ~HelloResponse();

    /**
     * Assignment operator
     */
    inline HelloResponse& operator = (const HelloResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HelloResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HelloResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HelloResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HelloResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "arg1"

    static const int kArg1 = 0;

    /**
     * Clears the field "arg1".
     *
     * The field will be set to its default value. The hasArg1()
     * method will return false.
     */
    inline void clearArg1();

    /**
     * Checks whether the field "arg1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArg1()). Otherwise it will return false.
     */
    inline bool hasArg1 () const;

    /**
     * Returns the value of the member "arg1".
     *
     * If the meaning of "arg1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "arg1"
     */
    inline const ::std::string& getArg1 () const;

    /**
     * Retrieves the value of the field "arg1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "arg1".
     */
    inline ::std::string& getArg1Mutable ();

    /**
     * Sets the value of the member "arg1".
     *
     * If the meaning of "arg1" isn't clear, then there should be a description here.
     *
     * @param arg1 The value which will be set
     */
    inline void setArg1 (const ::std::string& arg1_);

    /**
     * Sets the value of the member "arg1".
     *
     * If the meaning of "arg1" isn't clear, then there should be a description here.
     *
     * @param arg1 The value which will be set
     */
    inline void setArg1 (const char* arg1_);

    /**
     * Sets the value of the member "arg1".
     *
     * If the meaning of "arg1" isn't clear, then there should be a description here.
     *
     * @param arg1 The value which will be set
     */
    inline void setArg1 (const char* value, size_t size);

    static const HelloResponse &getDefaultInstance();

private:

    inline void set_has_arg1 ();

    inline void clear_has_arg1 ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _arg1;

};

/**
 * If the meaning of "RequestNameRequest" isn't clear, then there should be a description here.
 */
class RequestNameRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestNameRequest ();

    /**
     * Copy constructor
     */
    inline  RequestNameRequest (const RequestNameRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RequestNameRequest (const ::std::string& arg1_, uint32 arg2_);

    /**
     * Destructor
     */
    inline virtual  ~RequestNameRequest();

    /**
     * Assignment operator
     */
    inline RequestNameRequest& operator = (const RequestNameRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestNameRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestNameRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestNameRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestNameRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "arg1"

    static const int kArg1 = 0;

    /**
     * Clears the field "arg1".
     *
     * The field will be set to its default value. The hasArg1()
     * method will return false.
     */
    inline void clearArg1();

    /**
     * Checks whether the field "arg1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArg1()). Otherwise it will return false.
     */
    inline bool hasArg1 () const;

    /**
     * Returns the value of the member "arg1".
     *
     * If the meaning of "arg1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "arg1"
     */
    inline const ::std::string& getArg1 () const;

    /**
     * Retrieves the value of the field "arg1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "arg1".
     */
    inline ::std::string& getArg1Mutable ();

    /**
     * Sets the value of the member "arg1".
     *
     * If the meaning of "arg1" isn't clear, then there should be a description here.
     *
     * @param arg1 The value which will be set
     */
    inline void setArg1 (const ::std::string& arg1_);

    /**
     * Sets the value of the member "arg1".
     *
     * If the meaning of "arg1" isn't clear, then there should be a description here.
     *
     * @param arg1 The value which will be set
     */
    inline void setArg1 (const char* arg1_);

    /**
     * Sets the value of the member "arg1".
     *
     * If the meaning of "arg1" isn't clear, then there should be a description here.
     *
     * @param arg1 The value which will be set
     */
    inline void setArg1 (const char* value, size_t size);

    // API of field "arg2"

    static const int kArg2 = 1;

    /**
     * Clears the field "arg2".
     *
     * The field will be set to its default value. The hasArg2()
     * method will return false.
     */
    inline void clearArg2();

    /**
     * Checks whether the field "arg2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArg2()). Otherwise it will return false.
     */
    inline bool hasArg2 () const;

    /**
     * Returns the value of the member "arg2".
     *
     * If the meaning of "arg2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "arg2"
     */
    inline uint32 getArg2 () const;

    /**
     * Sets the value of the member "arg2".
     *
     * If the meaning of "arg2" isn't clear, then there should be a description here.
     *
     * @param arg2 The value which will be set
     */
    inline void setArg2 (uint32 arg2_);

    static const RequestNameRequest &getDefaultInstance();

private:

    inline void set_has_arg1 ();

    inline void clear_has_arg1 ();

    inline void set_has_arg2 ();

    inline void clear_has_arg2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _arg1;

    uint32 _arg2;

};

/**
 * If the meaning of "RequestNameResponse" isn't clear, then there should be a description here.
 */
class RequestNameResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestNameResponse ();

    /**
     * Copy constructor
     */
    inline  RequestNameResponse (const RequestNameResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RequestNameResponse (uint32 arg1_);

    /**
     * Destructor
     */
    inline virtual  ~RequestNameResponse();

    /**
     * Assignment operator
     */
    inline RequestNameResponse& operator = (const RequestNameResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestNameResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestNameResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestNameResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestNameResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "arg1"

    static const int kArg1 = 0;

    /**
     * Clears the field "arg1".
     *
     * The field will be set to its default value. The hasArg1()
     * method will return false.
     */
    inline void clearArg1();

    /**
     * Checks whether the field "arg1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArg1()). Otherwise it will return false.
     */
    inline bool hasArg1 () const;

    /**
     * Returns the value of the member "arg1".
     *
     * If the meaning of "arg1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "arg1"
     */
    inline uint32 getArg1 () const;

    /**
     * Sets the value of the member "arg1".
     *
     * If the meaning of "arg1" isn't clear, then there should be a description here.
     *
     * @param arg1 The value which will be set
     */
    inline void setArg1 (uint32 arg1_);

    static const RequestNameResponse &getDefaultInstance();

private:

    inline void set_has_arg1 ();

    inline void clear_has_arg1 ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _arg1;

};

/**
 * If the meaning of "ReleaseNameRequest" isn't clear, then there should be a description here.
 */
class ReleaseNameRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReleaseNameRequest ();

    /**
     * Copy constructor
     */
    inline  ReleaseNameRequest (const ReleaseNameRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReleaseNameRequest (const ::std::string& arg1_);

    /**
     * Destructor
     */
    inline virtual  ~ReleaseNameRequest();

    /**
     * Assignment operator
     */
    inline ReleaseNameRequest& operator = (const ReleaseNameRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReleaseNameRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReleaseNameRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReleaseNameRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReleaseNameRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "arg1"

    static const int kArg1 = 0;

    /**
     * Clears the field "arg1".
     *
     * The field will be set to its default value. The hasArg1()
     * method will return false.
     */
    inline void clearArg1();

    /**
     * Checks whether the field "arg1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArg1()). Otherwise it will return false.
     */
    inline bool hasArg1 () const;

    /**
     * Returns the value of the member "arg1".
     *
     * If the meaning of "arg1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "arg1"
     */
    inline const ::std::string& getArg1 () const;

    /**
     * Retrieves the value of the field "arg1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "arg1".
     */
    inline ::std::string& getArg1Mutable ();

    /**
     * Sets the value of the member "arg1".
     *
     * If the meaning of "arg1" isn't clear, then there should be a description here.
     *
     * @param arg1 The value which will be set
     */
    inline void setArg1 (const ::std::string& arg1_);

    /**
     * Sets the value of the member "arg1".
     *
     * If the meaning of "arg1" isn't clear, then there should be a description here.
     *
     * @param arg1 The value which will be set
     */
    inline void setArg1 (const char* arg1_);

    /**
     * Sets the value of the member "arg1".
     *
     * If the meaning of "arg1" isn't clear, then there should be a description here.
     *
     * @param arg1 The value which will be set
     */
    inline void setArg1 (const char* value, size_t size);

    static const ReleaseNameRequest &getDefaultInstance();

private:

    inline void set_has_arg1 ();

    inline void clear_has_arg1 ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _arg1;

};

/**
 * If the meaning of "ReleaseNameResponse" isn't clear, then there should be a description here.
 */
class ReleaseNameResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReleaseNameResponse ();

    /**
     * Copy constructor
     */
    inline  ReleaseNameResponse (const ReleaseNameResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ReleaseNameResponse (uint32 arg1_);

    /**
     * Destructor
     */
    inline virtual  ~ReleaseNameResponse();

    /**
     * Assignment operator
     */
    inline ReleaseNameResponse& operator = (const ReleaseNameResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReleaseNameResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReleaseNameResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReleaseNameResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReleaseNameResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "arg1"

    static const int kArg1 = 0;

    /**
     * Clears the field "arg1".
     *
     * The field will be set to its default value. The hasArg1()
     * method will return false.
     */
    inline void clearArg1();

    /**
     * Checks whether the field "arg1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArg1()). Otherwise it will return false.
     */
    inline bool hasArg1 () const;

    /**
     * Returns the value of the member "arg1".
     *
     * If the meaning of "arg1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "arg1"
     */
    inline uint32 getArg1 () const;

    /**
     * Sets the value of the member "arg1".
     *
     * If the meaning of "arg1" isn't clear, then there should be a description here.
     *
     * @param arg1 The value which will be set
     */
    inline void setArg1 (uint32 arg1_);

    static const ReleaseNameResponse &getDefaultInstance();

private:

    inline void set_has_arg1 ();

    inline void clear_has_arg1 ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _arg1;

};

/**
 * If the meaning of "StartServiceByNameRequest" isn't clear, then there should be a description here.
 */
class StartServiceByNameRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartServiceByNameRequest ();

    /**
     * Copy constructor
     */
    inline  StartServiceByNameRequest (const StartServiceByNameRequest &rhs);

    /**
     * All fields constructor
     */
    inline  StartServiceByNameRequest (const ::std::string& arg1_, uint32 arg2_);

    /**
     * Destructor
     */
    inline virtual  ~StartServiceByNameRequest();

    /**
     * Assignment operator
     */
    inline StartServiceByNameRequest& operator = (const StartServiceByNameRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartServiceByNameRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartServiceByNameRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartServiceByNameRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartServiceByNameRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "arg1"

    static const int kArg1 = 0;

    /**
     * Clears the field "arg1".
     *
     * The field will be set to its default value. The hasArg1()
     * method will return false.
     */
    inline void clearArg1();

    /**
     * Checks whether the field "arg1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArg1()). Otherwise it will return false.
     */
    inline bool hasArg1 () const;

    /**
     * Returns the value of the member "arg1".
     *
     * If the meaning of "arg1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "arg1"
     */
    inline const ::std::string& getArg1 () const;

    /**
     * Retrieves the value of the field "arg1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "arg1".
     */
    inline ::std::string& getArg1Mutable ();

    /**
     * Sets the value of the member "arg1".
     *
     * If the meaning of "arg1" isn't clear, then there should be a description here.
     *
     * @param arg1 The value which will be set
     */
    inline void setArg1 (const ::std::string& arg1_);

    /**
     * Sets the value of the member "arg1".
     *
     * If the meaning of "arg1" isn't clear, then there should be a description here.
     *
     * @param arg1 The value which will be set
     */
    inline void setArg1 (const char* arg1_);

    /**
     * Sets the value of the member "arg1".
     *
     * If the meaning of "arg1" isn't clear, then there should be a description here.
     *
     * @param arg1 The value which will be set
     */
    inline void setArg1 (const char* value, size_t size);

    // API of field "arg2"

    static const int kArg2 = 1;

    /**
     * Clears the field "arg2".
     *
     * The field will be set to its default value. The hasArg2()
     * method will return false.
     */
    inline void clearArg2();

    /**
     * Checks whether the field "arg2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArg2()). Otherwise it will return false.
     */
    inline bool hasArg2 () const;

    /**
     * Returns the value of the member "arg2".
     *
     * If the meaning of "arg2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "arg2"
     */
    inline uint32 getArg2 () const;

    /**
     * Sets the value of the member "arg2".
     *
     * If the meaning of "arg2" isn't clear, then there should be a description here.
     *
     * @param arg2 The value which will be set
     */
    inline void setArg2 (uint32 arg2_);

    static const StartServiceByNameRequest &getDefaultInstance();

private:

    inline void set_has_arg1 ();

    inline void clear_has_arg1 ();

    inline void set_has_arg2 ();

    inline void clear_has_arg2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _arg1;

    uint32 _arg2;

};

/**
 * If the meaning of "StartServiceByNameResponse" isn't clear, then there should be a description here.
 */
class StartServiceByNameResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartServiceByNameResponse ();

    /**
     * Copy constructor
     */
    inline  StartServiceByNameResponse (const StartServiceByNameResponse &rhs);

    /**
     * All fields constructor
     */
    inline  StartServiceByNameResponse (uint32 arg1_);

    /**
     * Destructor
     */
    inline virtual  ~StartServiceByNameResponse();

    /**
     * Assignment operator
     */
    inline StartServiceByNameResponse& operator = (const StartServiceByNameResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartServiceByNameResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartServiceByNameResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartServiceByNameResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartServiceByNameResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "arg1"

    static const int kArg1 = 0;

    /**
     * Clears the field "arg1".
     *
     * The field will be set to its default value. The hasArg1()
     * method will return false.
     */
    inline void clearArg1();

    /**
     * Checks whether the field "arg1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArg1()). Otherwise it will return false.
     */
    inline bool hasArg1 () const;

    /**
     * Returns the value of the member "arg1".
     *
     * If the meaning of "arg1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "arg1"
     */
    inline uint32 getArg1 () const;

    /**
     * Sets the value of the member "arg1".
     *
     * If the meaning of "arg1" isn't clear, then there should be a description here.
     *
     * @param arg1 The value which will be set
     */
    inline void setArg1 (uint32 arg1_);

    static const StartServiceByNameResponse &getDefaultInstance();

private:

    inline void set_has_arg1 ();

    inline void clear_has_arg1 ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _arg1;

};

/**
 * If the meaning of "UpdateActivationEnvironmentRequest" isn't clear, then there should be a description here.
 */
class UpdateActivationEnvironmentRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateActivationEnvironmentRequest ();

    /**
     * Copy constructor
     */
    inline  UpdateActivationEnvironmentRequest (const UpdateActivationEnvironmentRequest &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateActivationEnvironmentRequest (const ::std::map< ::std::string, ::std::string >& arg1_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateActivationEnvironmentRequest();

    /**
     * Assignment operator
     */
    inline UpdateActivationEnvironmentRequest& operator = (const UpdateActivationEnvironmentRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateActivationEnvironmentRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateActivationEnvironmentRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateActivationEnvironmentRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateActivationEnvironmentRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "arg1"

    static const int kArg1 = 0;

    /**
     * Clears the field "arg1".
     *
     * The field will be set to its default value. The hasArg1()
     * method will return false.
     */
    inline void clearArg1();

    /**
     * Checks whether the field "arg1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArg1()). Otherwise it will return false.
     */
    inline bool hasArg1 () const;

    /**
     * Returns the value of the member "arg1".
     *
     * If the meaning of "arg1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "arg1"
     */
    inline const ::std::map< ::std::string, ::std::string >& getArg1 () const;

    /**
     * Retrieves the value of the field "arg1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "arg1".
     */
    inline ::std::map< ::std::string, ::std::string >& getArg1Mutable ();

    /**
     * Sets the value of the member "arg1".
     *
     * If the meaning of "arg1" isn't clear, then there should be a description here.
     *
     * @param arg1 The value which will be set
     */
    inline void setArg1 (const ::std::map< ::std::string, ::std::string >& arg1_);

    static const UpdateActivationEnvironmentRequest &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::std::string >& getStringToStringMap_DefaultInstance ();

    inline void set_has_arg1 ();

    inline void clear_has_arg1 ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::map< ::std::string, ::std::string > _arg1;

};

/**
 * If the meaning of "AddMatchRequest" isn't clear, then there should be a description here.
 */
class AddMatchRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddMatchRequest ();

    /**
     * Copy constructor
     */
    inline  AddMatchRequest (const AddMatchRequest &rhs);

    /**
     * All fields constructor
     */
    inline  AddMatchRequest (const ::std::string& arg1_);

    /**
     * Destructor
     */
    inline virtual  ~AddMatchRequest();

    /**
     * Assignment operator
     */
    inline AddMatchRequest& operator = (const AddMatchRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddMatchRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddMatchRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddMatchRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddMatchRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "arg1"

    static const int kArg1 = 0;

    /**
     * Clears the field "arg1".
     *
     * The field will be set to its default value. The hasArg1()
     * method will return false.
     */
    inline void clearArg1();

    /**
     * Checks whether the field "arg1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArg1()). Otherwise it will return false.
     */
    inline bool hasArg1 () const;

    /**
     * Returns the value of the member "arg1".
     *
     * If the meaning of "arg1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "arg1"
     */
    inline const ::std::string& getArg1 () const;

    /**
     * Retrieves the value of the field "arg1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "arg1".
     */
    inline ::std::string& getArg1Mutable ();

    /**
     * Sets the value of the member "arg1".
     *
     * If the meaning of "arg1" isn't clear, then there should be a description here.
     *
     * @param arg1 The value which will be set
     */
    inline void setArg1 (const ::std::string& arg1_);

    /**
     * Sets the value of the member "arg1".
     *
     * If the meaning of "arg1" isn't clear, then there should be a description here.
     *
     * @param arg1 The value which will be set
     */
    inline void setArg1 (const char* arg1_);

    /**
     * Sets the value of the member "arg1".
     *
     * If the meaning of "arg1" isn't clear, then there should be a description here.
     *
     * @param arg1 The value which will be set
     */
    inline void setArg1 (const char* value, size_t size);

    static const AddMatchRequest &getDefaultInstance();

private:

    inline void set_has_arg1 ();

    inline void clear_has_arg1 ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _arg1;

};

/**
 * If the meaning of "RemoveMatchRequest" isn't clear, then there should be a description here.
 */
class RemoveMatchRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemoveMatchRequest ();

    /**
     * Copy constructor
     */
    inline  RemoveMatchRequest (const RemoveMatchRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RemoveMatchRequest (const ::std::string& arg1_);

    /**
     * Destructor
     */
    inline virtual  ~RemoveMatchRequest();

    /**
     * Assignment operator
     */
    inline RemoveMatchRequest& operator = (const RemoveMatchRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoveMatchRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoveMatchRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoveMatchRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoveMatchRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "arg1"

    static const int kArg1 = 0;

    /**
     * Clears the field "arg1".
     *
     * The field will be set to its default value. The hasArg1()
     * method will return false.
     */
    inline void clearArg1();

    /**
     * Checks whether the field "arg1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArg1()). Otherwise it will return false.
     */
    inline bool hasArg1 () const;

    /**
     * Returns the value of the member "arg1".
     *
     * If the meaning of "arg1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "arg1"
     */
    inline const ::std::string& getArg1 () const;

    /**
     * Retrieves the value of the field "arg1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "arg1".
     */
    inline ::std::string& getArg1Mutable ();

    /**
     * Sets the value of the member "arg1".
     *
     * If the meaning of "arg1" isn't clear, then there should be a description here.
     *
     * @param arg1 The value which will be set
     */
    inline void setArg1 (const ::std::string& arg1_);

    /**
     * Sets the value of the member "arg1".
     *
     * If the meaning of "arg1" isn't clear, then there should be a description here.
     *
     * @param arg1 The value which will be set
     */
    inline void setArg1 (const char* arg1_);

    /**
     * Sets the value of the member "arg1".
     *
     * If the meaning of "arg1" isn't clear, then there should be a description here.
     *
     * @param arg1 The value which will be set
     */
    inline void setArg1 (const char* value, size_t size);

    static const RemoveMatchRequest &getDefaultInstance();

private:

    inline void set_has_arg1 ();

    inline void clear_has_arg1 ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _arg1;

};

/**
 * If the meaning of "NameHasOwnerRequest" isn't clear, then there should be a description here.
 */
class NameHasOwnerRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NameHasOwnerRequest ();

    /**
     * Copy constructor
     */
    inline  NameHasOwnerRequest (const NameHasOwnerRequest &rhs);

    /**
     * All fields constructor
     */
    inline  NameHasOwnerRequest (const ::std::string& name_);

    /**
     * Destructor
     */
    inline virtual  ~NameHasOwnerRequest();

    /**
     * Assignment operator
     */
    inline NameHasOwnerRequest& operator = (const NameHasOwnerRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NameHasOwnerRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NameHasOwnerRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NameHasOwnerRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NameHasOwnerRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    static const NameHasOwnerRequest &getDefaultInstance();

private:

    inline void set_has_name ();

    inline void clear_has_name ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _name;

};

/**
 * If the meaning of "NameHasOwnerResponse" isn't clear, then there should be a description here.
 */
class NameHasOwnerResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NameHasOwnerResponse ();

    /**
     * Copy constructor
     */
    inline  NameHasOwnerResponse (const NameHasOwnerResponse &rhs);

    /**
     * All fields constructor
     */
    inline  NameHasOwnerResponse (bool data_);

    /**
     * Destructor
     */
    inline virtual  ~NameHasOwnerResponse();

    /**
     * Assignment operator
     */
    inline NameHasOwnerResponse& operator = (const NameHasOwnerResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NameHasOwnerResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NameHasOwnerResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NameHasOwnerResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NameHasOwnerResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline bool getData () const;

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (bool data_);

    static const NameHasOwnerResponse &getDefaultInstance();

private:

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _data;

};

/**
 * If the meaning of "GetNameOwnerRequest" isn't clear, then there should be a description here.
 */
class GetNameOwnerRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetNameOwnerRequest ();

    /**
     * Copy constructor
     */
    inline  GetNameOwnerRequest (const GetNameOwnerRequest &rhs);

    /**
     * All fields constructor
     */
    inline  GetNameOwnerRequest (const ::std::string& busname_);

    /**
     * Destructor
     */
    inline virtual  ~GetNameOwnerRequest();

    /**
     * Assignment operator
     */
    inline GetNameOwnerRequest& operator = (const GetNameOwnerRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetNameOwnerRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetNameOwnerRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetNameOwnerRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetNameOwnerRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "busname"

    static const int kBusname = 0;

    /**
     * Clears the field "busname".
     *
     * The field will be set to its default value. The hasBusname()
     * method will return false.
     */
    inline void clearBusname();

    /**
     * Checks whether the field "busname" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBusname()). Otherwise it will return false.
     */
    inline bool hasBusname () const;

    /**
     * Returns the value of the member "busname".
     *
     * If the meaning of "busname" isn't clear, then there should be a description here.
     *
     * @return The value of the field "busname"
     */
    inline const ::std::string& getBusname () const;

    /**
     * Retrieves the value of the field "busname" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "busname".
     */
    inline ::std::string& getBusnameMutable ();

    /**
     * Sets the value of the member "busname".
     *
     * If the meaning of "busname" isn't clear, then there should be a description here.
     *
     * @param busname The value which will be set
     */
    inline void setBusname (const ::std::string& busname_);

    /**
     * Sets the value of the member "busname".
     *
     * If the meaning of "busname" isn't clear, then there should be a description here.
     *
     * @param busname The value which will be set
     */
    inline void setBusname (const char* busname_);

    /**
     * Sets the value of the member "busname".
     *
     * If the meaning of "busname" isn't clear, then there should be a description here.
     *
     * @param busname The value which will be set
     */
    inline void setBusname (const char* value, size_t size);

    static const GetNameOwnerRequest &getDefaultInstance();

private:

    inline void set_has_busname ();

    inline void clear_has_busname ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _busname;

};

/**
 * If the meaning of "GetNameOwnerResponse" isn't clear, then there should be a description here.
 */
class GetNameOwnerResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetNameOwnerResponse ();

    /**
     * Copy constructor
     */
    inline  GetNameOwnerResponse (const GetNameOwnerResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetNameOwnerResponse (const ::std::string& uniqueid_);

    /**
     * Destructor
     */
    inline virtual  ~GetNameOwnerResponse();

    /**
     * Assignment operator
     */
    inline GetNameOwnerResponse& operator = (const GetNameOwnerResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetNameOwnerResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetNameOwnerResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetNameOwnerResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetNameOwnerResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "uniqueid"

    static const int kUniqueid = 0;

    /**
     * Clears the field "uniqueid".
     *
     * The field will be set to its default value. The hasUniqueid()
     * method will return false.
     */
    inline void clearUniqueid();

    /**
     * Checks whether the field "uniqueid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUniqueid()). Otherwise it will return false.
     */
    inline bool hasUniqueid () const;

    /**
     * Returns the value of the member "uniqueid".
     *
     * If the meaning of "uniqueid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "uniqueid"
     */
    inline const ::std::string& getUniqueid () const;

    /**
     * Retrieves the value of the field "uniqueid" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "uniqueid".
     */
    inline ::std::string& getUniqueidMutable ();

    /**
     * Sets the value of the member "uniqueid".
     *
     * If the meaning of "uniqueid" isn't clear, then there should be a description here.
     *
     * @param uniqueid The value which will be set
     */
    inline void setUniqueid (const ::std::string& uniqueid_);

    /**
     * Sets the value of the member "uniqueid".
     *
     * If the meaning of "uniqueid" isn't clear, then there should be a description here.
     *
     * @param uniqueid The value which will be set
     */
    inline void setUniqueid (const char* uniqueid_);

    /**
     * Sets the value of the member "uniqueid".
     *
     * If the meaning of "uniqueid" isn't clear, then there should be a description here.
     *
     * @param uniqueid The value which will be set
     */
    inline void setUniqueid (const char* value, size_t size);

    static const GetNameOwnerResponse &getDefaultInstance();

private:

    inline void set_has_uniqueid ();

    inline void clear_has_uniqueid ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _uniqueid;

};

/**
 * If the meaning of "NameOwnerChangedSignal" isn't clear, then there should be a description here.
 */
class NameOwnerChangedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NameOwnerChangedSignal ();

    /**
     * Copy constructor
     */
    inline  NameOwnerChangedSignal (const NameOwnerChangedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  NameOwnerChangedSignal (const ::std::string& name_, const ::std::string& old_, const ::std::string& new_);

    /**
     * Destructor
     */
    inline virtual  ~NameOwnerChangedSignal();

    /**
     * Assignment operator
     */
    inline NameOwnerChangedSignal& operator = (const NameOwnerChangedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NameOwnerChangedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NameOwnerChangedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NameOwnerChangedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NameOwnerChangedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "old"

    static const int kOld = 1;

    /**
     * Clears the field "old".
     *
     * The field will be set to its default value. The hasOld()
     * method will return false.
     */
    inline void clearOld();

    /**
     * Checks whether the field "old" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOld()). Otherwise it will return false.
     */
    inline bool hasOld () const;

    /**
     * Returns the value of the member "old".
     *
     * If the meaning of "old" isn't clear, then there should be a description here.
     *
     * @return The value of the field "old"
     */
    inline const ::std::string& getOld () const;

    /**
     * Retrieves the value of the field "old" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "old".
     */
    inline ::std::string& getOldMutable ();

    /**
     * Sets the value of the member "old".
     *
     * If the meaning of "old" isn't clear, then there should be a description here.
     *
     * @param old The value which will be set
     */
    inline void setOld (const ::std::string& old_);

    /**
     * Sets the value of the member "old".
     *
     * If the meaning of "old" isn't clear, then there should be a description here.
     *
     * @param old The value which will be set
     */
    inline void setOld (const char* old_);

    /**
     * Sets the value of the member "old".
     *
     * If the meaning of "old" isn't clear, then there should be a description here.
     *
     * @param old The value which will be set
     */
    inline void setOld (const char* value, size_t size);

    // API of field "new"

    static const int kNew = 2;

    /**
     * Clears the field "new_".
     *
     * The field will be set to its default value. The hasNew()
     * method will return false.
     */
    inline void clearNew();

    /**
     * Checks whether the field "new" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNew()). Otherwise it will return false.
     */
    inline bool hasNew () const;

    /**
     * Returns the value of the member "new".
     *
     * If the meaning of "new" isn't clear, then there should be a description here.
     *
     * @return The value of the field "new_"
     */
    inline const ::std::string& getNew () const;

    /**
     * Retrieves the value of the field "new" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "new".
     */
    inline ::std::string& getNewMutable ();

    /**
     * Sets the value of the member "new".
     *
     * If the meaning of "new" isn't clear, then there should be a description here.
     *
     * @param new_ The value which will be set
     */
    inline void setNew (const ::std::string& new_);

    /**
     * Sets the value of the member "new".
     *
     * If the meaning of "new" isn't clear, then there should be a description here.
     *
     * @param new_ The value which will be set
     */
    inline void setNew (const char* new_);

    /**
     * Sets the value of the member "new".
     *
     * If the meaning of "new" isn't clear, then there should be a description here.
     *
     * @param new_ The value which will be set
     */
    inline void setNew (const char* value, size_t size);

    static const NameOwnerChangedSignal &getDefaultInstance();

private:

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_old ();

    inline void clear_has_old ();

    inline void set_has_new ();

    inline void clear_has_new ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _name;

    ::std::string _old;

    ::std::string _new;

};

/**
 * If the meaning of "NameAcquiredSignal" isn't clear, then there should be a description here.
 */
class NameAcquiredSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NameAcquiredSignal ();

    /**
     * Copy constructor
     */
    inline  NameAcquiredSignal (const NameAcquiredSignal &rhs);

    /**
     * All fields constructor
     */
    inline  NameAcquiredSignal (const ::std::string& name_);

    /**
     * Destructor
     */
    inline virtual  ~NameAcquiredSignal();

    /**
     * Assignment operator
     */
    inline NameAcquiredSignal& operator = (const NameAcquiredSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NameAcquiredSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NameAcquiredSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NameAcquiredSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NameAcquiredSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    static const NameAcquiredSignal &getDefaultInstance();

private:

    inline void set_has_name ();

    inline void clear_has_name ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _name;

};

inline  HelloResponse::HelloResponse ()  :
    _arg1 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  HelloResponse::HelloResponse (const HelloResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _arg1 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  HelloResponse::HelloResponse (const ::std::string& arg1_)  :
    _arg1 (arg1_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (arg1_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  HelloResponse::~HelloResponse() {
}

inline HelloResponse& HelloResponse::operator = (const HelloResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasArg1()) {
            setArg1(rhs.getArg1());
        } else {
            clearArg1();
        }
    }
    return *this;
}

inline bool HelloResponse::operator == (const HelloResponse& rhs) const {
    return (((!hasArg1() && !rhs.hasArg1()) || getArg1() == rhs.getArg1()));
}

inline bool HelloResponse::operator != (const HelloResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool HelloResponse::operator < (const HelloResponse& rhs) const {
    if (hasArg1() || rhs.hasArg1()) {
        if (getArg1() < rhs.getArg1()) return true;
        if (getArg1() > rhs.getArg1()) return false;
    }
    return false;
}

inline ::asf::core::Payload* HelloResponse::clone() {
    return new HelloResponse(*this);
}

inline bool HelloResponse::operator > (const HelloResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void HelloResponse::clear() {
    clearArg1();
}

inline void HelloResponse::clearArg1() {
    if (hasArg1()) {
         clear_has_arg1();
        _arg1.clear();
     }
}

inline bool HelloResponse::hasArg1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& HelloResponse::getArg1 () const {
    return _arg1;
}

inline ::std::string& HelloResponse::getArg1Mutable () {
    set_has_arg1();
    return _arg1;
}

inline void HelloResponse::setArg1 (const ::std::string& arg1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (arg1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_arg1();
    this->_arg1 = arg1_;
}

inline void HelloResponse::setArg1 (const char* arg1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (arg1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_arg1();
    this->_arg1.assign(arg1_);
}

inline void HelloResponse::setArg1 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_arg1();
    this->_arg1.assign(value, size);
}

inline void HelloResponse::set_has_arg1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void HelloResponse::clear_has_arg1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RequestNameRequest::RequestNameRequest ()  :
    _arg1 (),
    _arg2 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestNameRequest::RequestNameRequest (const RequestNameRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _arg1 (),
    _arg2 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestNameRequest::RequestNameRequest (const ::std::string& arg1_, uint32 arg2_)  :
    _arg1 (arg1_),
    _arg2 (arg2_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (arg1_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestNameRequest::~RequestNameRequest() {
}

inline RequestNameRequest& RequestNameRequest::operator = (const RequestNameRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasArg1()) {
            setArg1(rhs.getArg1());
        } else {
            clearArg1();
        }
        if (rhs.hasArg2()) {
            setArg2(rhs.getArg2());
        } else {
            clearArg2();
        }
    }
    return *this;
}

inline bool RequestNameRequest::operator == (const RequestNameRequest& rhs) const {
    return (((!hasArg1() && !rhs.hasArg1()) || getArg1() == rhs.getArg1()) &&
        ((!hasArg2() && !rhs.hasArg2()) || getArg2() == rhs.getArg2()));
}

inline bool RequestNameRequest::operator != (const RequestNameRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestNameRequest::operator < (const RequestNameRequest& rhs) const {
    if (hasArg1() || rhs.hasArg1()) {
        if (getArg1() < rhs.getArg1()) return true;
        if (getArg1() > rhs.getArg1()) return false;
    }
    if (hasArg2() || rhs.hasArg2()) {
        if (getArg2() < rhs.getArg2()) return true;
        if (getArg2() > rhs.getArg2()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestNameRequest::clone() {
    return new RequestNameRequest(*this);
}

inline bool RequestNameRequest::operator > (const RequestNameRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestNameRequest::clear() {
    clearArg1();
    clearArg2();
}

inline void RequestNameRequest::clearArg1() {
    if (hasArg1()) {
         clear_has_arg1();
        _arg1.clear();
     }
}

inline bool RequestNameRequest::hasArg1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RequestNameRequest::getArg1 () const {
    return _arg1;
}

inline ::std::string& RequestNameRequest::getArg1Mutable () {
    set_has_arg1();
    return _arg1;
}

inline void RequestNameRequest::setArg1 (const ::std::string& arg1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (arg1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_arg1();
    this->_arg1 = arg1_;
}

inline void RequestNameRequest::setArg1 (const char* arg1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (arg1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_arg1();
    this->_arg1.assign(arg1_);
}

inline void RequestNameRequest::setArg1 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_arg1();
    this->_arg1.assign(value, size);
}

inline void RequestNameRequest::clearArg2() {
    if (hasArg2()) {
         clear_has_arg2();
        _arg2 = 0u;
     }
}

inline bool RequestNameRequest::hasArg2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 RequestNameRequest::getArg2 () const {
    return _arg2;
}

inline void RequestNameRequest::setArg2 (uint32 arg2_) {
    set_has_arg2();
    this->_arg2 = arg2_;
}

inline void RequestNameRequest::set_has_arg1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestNameRequest::clear_has_arg1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RequestNameRequest::set_has_arg2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void RequestNameRequest::clear_has_arg2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  RequestNameResponse::RequestNameResponse ()  :
    _arg1 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestNameResponse::RequestNameResponse (const RequestNameResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _arg1 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestNameResponse::RequestNameResponse (uint32 arg1_)  :
    _arg1 (arg1_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestNameResponse::~RequestNameResponse() {
}

inline RequestNameResponse& RequestNameResponse::operator = (const RequestNameResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasArg1()) {
            setArg1(rhs.getArg1());
        } else {
            clearArg1();
        }
    }
    return *this;
}

inline bool RequestNameResponse::operator == (const RequestNameResponse& rhs) const {
    return (((!hasArg1() && !rhs.hasArg1()) || getArg1() == rhs.getArg1()));
}

inline bool RequestNameResponse::operator != (const RequestNameResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestNameResponse::operator < (const RequestNameResponse& rhs) const {
    if (hasArg1() || rhs.hasArg1()) {
        if (getArg1() < rhs.getArg1()) return true;
        if (getArg1() > rhs.getArg1()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestNameResponse::clone() {
    return new RequestNameResponse(*this);
}

inline bool RequestNameResponse::operator > (const RequestNameResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestNameResponse::clear() {
    clearArg1();
}

inline void RequestNameResponse::clearArg1() {
    if (hasArg1()) {
         clear_has_arg1();
        _arg1 = 0u;
     }
}

inline bool RequestNameResponse::hasArg1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 RequestNameResponse::getArg1 () const {
    return _arg1;
}

inline void RequestNameResponse::setArg1 (uint32 arg1_) {
    set_has_arg1();
    this->_arg1 = arg1_;
}

inline void RequestNameResponse::set_has_arg1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestNameResponse::clear_has_arg1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReleaseNameRequest::ReleaseNameRequest ()  :
    _arg1 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReleaseNameRequest::ReleaseNameRequest (const ReleaseNameRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _arg1 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReleaseNameRequest::ReleaseNameRequest (const ::std::string& arg1_)  :
    _arg1 (arg1_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (arg1_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReleaseNameRequest::~ReleaseNameRequest() {
}

inline ReleaseNameRequest& ReleaseNameRequest::operator = (const ReleaseNameRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasArg1()) {
            setArg1(rhs.getArg1());
        } else {
            clearArg1();
        }
    }
    return *this;
}

inline bool ReleaseNameRequest::operator == (const ReleaseNameRequest& rhs) const {
    return (((!hasArg1() && !rhs.hasArg1()) || getArg1() == rhs.getArg1()));
}

inline bool ReleaseNameRequest::operator != (const ReleaseNameRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ReleaseNameRequest::operator < (const ReleaseNameRequest& rhs) const {
    if (hasArg1() || rhs.hasArg1()) {
        if (getArg1() < rhs.getArg1()) return true;
        if (getArg1() > rhs.getArg1()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReleaseNameRequest::clone() {
    return new ReleaseNameRequest(*this);
}

inline bool ReleaseNameRequest::operator > (const ReleaseNameRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReleaseNameRequest::clear() {
    clearArg1();
}

inline void ReleaseNameRequest::clearArg1() {
    if (hasArg1()) {
         clear_has_arg1();
        _arg1.clear();
     }
}

inline bool ReleaseNameRequest::hasArg1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ReleaseNameRequest::getArg1 () const {
    return _arg1;
}

inline ::std::string& ReleaseNameRequest::getArg1Mutable () {
    set_has_arg1();
    return _arg1;
}

inline void ReleaseNameRequest::setArg1 (const ::std::string& arg1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (arg1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_arg1();
    this->_arg1 = arg1_;
}

inline void ReleaseNameRequest::setArg1 (const char* arg1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (arg1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_arg1();
    this->_arg1.assign(arg1_);
}

inline void ReleaseNameRequest::setArg1 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_arg1();
    this->_arg1.assign(value, size);
}

inline void ReleaseNameRequest::set_has_arg1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReleaseNameRequest::clear_has_arg1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReleaseNameResponse::ReleaseNameResponse ()  :
    _arg1 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReleaseNameResponse::ReleaseNameResponse (const ReleaseNameResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _arg1 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReleaseNameResponse::ReleaseNameResponse (uint32 arg1_)  :
    _arg1 (arg1_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReleaseNameResponse::~ReleaseNameResponse() {
}

inline ReleaseNameResponse& ReleaseNameResponse::operator = (const ReleaseNameResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasArg1()) {
            setArg1(rhs.getArg1());
        } else {
            clearArg1();
        }
    }
    return *this;
}

inline bool ReleaseNameResponse::operator == (const ReleaseNameResponse& rhs) const {
    return (((!hasArg1() && !rhs.hasArg1()) || getArg1() == rhs.getArg1()));
}

inline bool ReleaseNameResponse::operator != (const ReleaseNameResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ReleaseNameResponse::operator < (const ReleaseNameResponse& rhs) const {
    if (hasArg1() || rhs.hasArg1()) {
        if (getArg1() < rhs.getArg1()) return true;
        if (getArg1() > rhs.getArg1()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReleaseNameResponse::clone() {
    return new ReleaseNameResponse(*this);
}

inline bool ReleaseNameResponse::operator > (const ReleaseNameResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReleaseNameResponse::clear() {
    clearArg1();
}

inline void ReleaseNameResponse::clearArg1() {
    if (hasArg1()) {
         clear_has_arg1();
        _arg1 = 0u;
     }
}

inline bool ReleaseNameResponse::hasArg1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 ReleaseNameResponse::getArg1 () const {
    return _arg1;
}

inline void ReleaseNameResponse::setArg1 (uint32 arg1_) {
    set_has_arg1();
    this->_arg1 = arg1_;
}

inline void ReleaseNameResponse::set_has_arg1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReleaseNameResponse::clear_has_arg1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StartServiceByNameRequest::StartServiceByNameRequest ()  :
    _arg1 (),
    _arg2 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartServiceByNameRequest::StartServiceByNameRequest (const StartServiceByNameRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _arg1 (),
    _arg2 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartServiceByNameRequest::StartServiceByNameRequest (const ::std::string& arg1_, uint32 arg2_)  :
    _arg1 (arg1_),
    _arg2 (arg2_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (arg1_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartServiceByNameRequest::~StartServiceByNameRequest() {
}

inline StartServiceByNameRequest& StartServiceByNameRequest::operator = (const StartServiceByNameRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasArg1()) {
            setArg1(rhs.getArg1());
        } else {
            clearArg1();
        }
        if (rhs.hasArg2()) {
            setArg2(rhs.getArg2());
        } else {
            clearArg2();
        }
    }
    return *this;
}

inline bool StartServiceByNameRequest::operator == (const StartServiceByNameRequest& rhs) const {
    return (((!hasArg1() && !rhs.hasArg1()) || getArg1() == rhs.getArg1()) &&
        ((!hasArg2() && !rhs.hasArg2()) || getArg2() == rhs.getArg2()));
}

inline bool StartServiceByNameRequest::operator != (const StartServiceByNameRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool StartServiceByNameRequest::operator < (const StartServiceByNameRequest& rhs) const {
    if (hasArg1() || rhs.hasArg1()) {
        if (getArg1() < rhs.getArg1()) return true;
        if (getArg1() > rhs.getArg1()) return false;
    }
    if (hasArg2() || rhs.hasArg2()) {
        if (getArg2() < rhs.getArg2()) return true;
        if (getArg2() > rhs.getArg2()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StartServiceByNameRequest::clone() {
    return new StartServiceByNameRequest(*this);
}

inline bool StartServiceByNameRequest::operator > (const StartServiceByNameRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartServiceByNameRequest::clear() {
    clearArg1();
    clearArg2();
}

inline void StartServiceByNameRequest::clearArg1() {
    if (hasArg1()) {
         clear_has_arg1();
        _arg1.clear();
     }
}

inline bool StartServiceByNameRequest::hasArg1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& StartServiceByNameRequest::getArg1 () const {
    return _arg1;
}

inline ::std::string& StartServiceByNameRequest::getArg1Mutable () {
    set_has_arg1();
    return _arg1;
}

inline void StartServiceByNameRequest::setArg1 (const ::std::string& arg1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (arg1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_arg1();
    this->_arg1 = arg1_;
}

inline void StartServiceByNameRequest::setArg1 (const char* arg1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (arg1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_arg1();
    this->_arg1.assign(arg1_);
}

inline void StartServiceByNameRequest::setArg1 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_arg1();
    this->_arg1.assign(value, size);
}

inline void StartServiceByNameRequest::clearArg2() {
    if (hasArg2()) {
         clear_has_arg2();
        _arg2 = 0u;
     }
}

inline bool StartServiceByNameRequest::hasArg2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 StartServiceByNameRequest::getArg2 () const {
    return _arg2;
}

inline void StartServiceByNameRequest::setArg2 (uint32 arg2_) {
    set_has_arg2();
    this->_arg2 = arg2_;
}

inline void StartServiceByNameRequest::set_has_arg1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartServiceByNameRequest::clear_has_arg1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void StartServiceByNameRequest::set_has_arg2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void StartServiceByNameRequest::clear_has_arg2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  StartServiceByNameResponse::StartServiceByNameResponse ()  :
    _arg1 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartServiceByNameResponse::StartServiceByNameResponse (const StartServiceByNameResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _arg1 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartServiceByNameResponse::StartServiceByNameResponse (uint32 arg1_)  :
    _arg1 (arg1_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartServiceByNameResponse::~StartServiceByNameResponse() {
}

inline StartServiceByNameResponse& StartServiceByNameResponse::operator = (const StartServiceByNameResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasArg1()) {
            setArg1(rhs.getArg1());
        } else {
            clearArg1();
        }
    }
    return *this;
}

inline bool StartServiceByNameResponse::operator == (const StartServiceByNameResponse& rhs) const {
    return (((!hasArg1() && !rhs.hasArg1()) || getArg1() == rhs.getArg1()));
}

inline bool StartServiceByNameResponse::operator != (const StartServiceByNameResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool StartServiceByNameResponse::operator < (const StartServiceByNameResponse& rhs) const {
    if (hasArg1() || rhs.hasArg1()) {
        if (getArg1() < rhs.getArg1()) return true;
        if (getArg1() > rhs.getArg1()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StartServiceByNameResponse::clone() {
    return new StartServiceByNameResponse(*this);
}

inline bool StartServiceByNameResponse::operator > (const StartServiceByNameResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartServiceByNameResponse::clear() {
    clearArg1();
}

inline void StartServiceByNameResponse::clearArg1() {
    if (hasArg1()) {
         clear_has_arg1();
        _arg1 = 0u;
     }
}

inline bool StartServiceByNameResponse::hasArg1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 StartServiceByNameResponse::getArg1 () const {
    return _arg1;
}

inline void StartServiceByNameResponse::setArg1 (uint32 arg1_) {
    set_has_arg1();
    this->_arg1 = arg1_;
}

inline void StartServiceByNameResponse::set_has_arg1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartServiceByNameResponse::clear_has_arg1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  UpdateActivationEnvironmentRequest::UpdateActivationEnvironmentRequest ()  :
    _arg1 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UpdateActivationEnvironmentRequest::UpdateActivationEnvironmentRequest (const UpdateActivationEnvironmentRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _arg1 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UpdateActivationEnvironmentRequest::UpdateActivationEnvironmentRequest (const ::std::map< ::std::string, ::std::string >& arg1_)  :
    _arg1 (arg1_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UpdateActivationEnvironmentRequest::~UpdateActivationEnvironmentRequest() {
}

inline UpdateActivationEnvironmentRequest& UpdateActivationEnvironmentRequest::operator = (const UpdateActivationEnvironmentRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasArg1()) {
            setArg1(rhs.getArg1());
        } else {
            clearArg1();
        }
    }
    return *this;
}

inline bool UpdateActivationEnvironmentRequest::operator == (const UpdateActivationEnvironmentRequest& rhs) const {
    return (((!hasArg1() && !rhs.hasArg1()) || getArg1() == rhs.getArg1()));
}

inline bool UpdateActivationEnvironmentRequest::operator != (const UpdateActivationEnvironmentRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool UpdateActivationEnvironmentRequest::operator < (const UpdateActivationEnvironmentRequest& rhs) const {
    if (hasArg1() || rhs.hasArg1()) {
        if (getArg1() < rhs.getArg1()) return true;
        if (getArg1() > rhs.getArg1()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UpdateActivationEnvironmentRequest::clone() {
    return new UpdateActivationEnvironmentRequest(*this);
}

inline bool UpdateActivationEnvironmentRequest::operator > (const UpdateActivationEnvironmentRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UpdateActivationEnvironmentRequest::clear() {
    clearArg1();
}

inline void UpdateActivationEnvironmentRequest::clearArg1() {
    if (hasArg1()) {
         clear_has_arg1();
        _arg1.clear();
     }
}

inline bool UpdateActivationEnvironmentRequest::hasArg1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::map< ::std::string, ::std::string >& UpdateActivationEnvironmentRequest::getArg1 () const {
    return _arg1;
}

inline ::std::map< ::std::string, ::std::string >& UpdateActivationEnvironmentRequest::getArg1Mutable () {
    set_has_arg1();
    return _arg1;
}

inline void UpdateActivationEnvironmentRequest::setArg1 (const ::std::map< ::std::string, ::std::string >& arg1_) {
    set_has_arg1();
    this->_arg1 = arg1_;
}

inline void UpdateActivationEnvironmentRequest::set_has_arg1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void UpdateActivationEnvironmentRequest::clear_has_arg1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AddMatchRequest::AddMatchRequest ()  :
    _arg1 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AddMatchRequest::AddMatchRequest (const AddMatchRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _arg1 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AddMatchRequest::AddMatchRequest (const ::std::string& arg1_)  :
    _arg1 (arg1_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (arg1_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AddMatchRequest::~AddMatchRequest() {
}

inline AddMatchRequest& AddMatchRequest::operator = (const AddMatchRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasArg1()) {
            setArg1(rhs.getArg1());
        } else {
            clearArg1();
        }
    }
    return *this;
}

inline bool AddMatchRequest::operator == (const AddMatchRequest& rhs) const {
    return (((!hasArg1() && !rhs.hasArg1()) || getArg1() == rhs.getArg1()));
}

inline bool AddMatchRequest::operator != (const AddMatchRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool AddMatchRequest::operator < (const AddMatchRequest& rhs) const {
    if (hasArg1() || rhs.hasArg1()) {
        if (getArg1() < rhs.getArg1()) return true;
        if (getArg1() > rhs.getArg1()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AddMatchRequest::clone() {
    return new AddMatchRequest(*this);
}

inline bool AddMatchRequest::operator > (const AddMatchRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AddMatchRequest::clear() {
    clearArg1();
}

inline void AddMatchRequest::clearArg1() {
    if (hasArg1()) {
         clear_has_arg1();
        _arg1.clear();
     }
}

inline bool AddMatchRequest::hasArg1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& AddMatchRequest::getArg1 () const {
    return _arg1;
}

inline ::std::string& AddMatchRequest::getArg1Mutable () {
    set_has_arg1();
    return _arg1;
}

inline void AddMatchRequest::setArg1 (const ::std::string& arg1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (arg1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_arg1();
    this->_arg1 = arg1_;
}

inline void AddMatchRequest::setArg1 (const char* arg1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (arg1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_arg1();
    this->_arg1.assign(arg1_);
}

inline void AddMatchRequest::setArg1 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_arg1();
    this->_arg1.assign(value, size);
}

inline void AddMatchRequest::set_has_arg1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void AddMatchRequest::clear_has_arg1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RemoveMatchRequest::RemoveMatchRequest ()  :
    _arg1 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoveMatchRequest::RemoveMatchRequest (const RemoveMatchRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _arg1 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoveMatchRequest::RemoveMatchRequest (const ::std::string& arg1_)  :
    _arg1 (arg1_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (arg1_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemoveMatchRequest::~RemoveMatchRequest() {
}

inline RemoveMatchRequest& RemoveMatchRequest::operator = (const RemoveMatchRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasArg1()) {
            setArg1(rhs.getArg1());
        } else {
            clearArg1();
        }
    }
    return *this;
}

inline bool RemoveMatchRequest::operator == (const RemoveMatchRequest& rhs) const {
    return (((!hasArg1() && !rhs.hasArg1()) || getArg1() == rhs.getArg1()));
}

inline bool RemoveMatchRequest::operator != (const RemoveMatchRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoveMatchRequest::operator < (const RemoveMatchRequest& rhs) const {
    if (hasArg1() || rhs.hasArg1()) {
        if (getArg1() < rhs.getArg1()) return true;
        if (getArg1() > rhs.getArg1()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RemoveMatchRequest::clone() {
    return new RemoveMatchRequest(*this);
}

inline bool RemoveMatchRequest::operator > (const RemoveMatchRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoveMatchRequest::clear() {
    clearArg1();
}

inline void RemoveMatchRequest::clearArg1() {
    if (hasArg1()) {
         clear_has_arg1();
        _arg1.clear();
     }
}

inline bool RemoveMatchRequest::hasArg1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RemoveMatchRequest::getArg1 () const {
    return _arg1;
}

inline ::std::string& RemoveMatchRequest::getArg1Mutable () {
    set_has_arg1();
    return _arg1;
}

inline void RemoveMatchRequest::setArg1 (const ::std::string& arg1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (arg1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_arg1();
    this->_arg1 = arg1_;
}

inline void RemoveMatchRequest::setArg1 (const char* arg1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (arg1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_arg1();
    this->_arg1.assign(arg1_);
}

inline void RemoveMatchRequest::setArg1 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_arg1();
    this->_arg1.assign(value, size);
}

inline void RemoveMatchRequest::set_has_arg1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemoveMatchRequest::clear_has_arg1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  NameHasOwnerRequest::NameHasOwnerRequest ()  :
    _name ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NameHasOwnerRequest::NameHasOwnerRequest (const NameHasOwnerRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _name ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NameHasOwnerRequest::NameHasOwnerRequest (const ::std::string& name_)  :
    _name (name_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NameHasOwnerRequest::~NameHasOwnerRequest() {
}

inline NameHasOwnerRequest& NameHasOwnerRequest::operator = (const NameHasOwnerRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
    }
    return *this;
}

inline bool NameHasOwnerRequest::operator == (const NameHasOwnerRequest& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()));
}

inline bool NameHasOwnerRequest::operator != (const NameHasOwnerRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool NameHasOwnerRequest::operator < (const NameHasOwnerRequest& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* NameHasOwnerRequest::clone() {
    return new NameHasOwnerRequest(*this);
}

inline bool NameHasOwnerRequest::operator > (const NameHasOwnerRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NameHasOwnerRequest::clear() {
    clearName();
}

inline void NameHasOwnerRequest::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool NameHasOwnerRequest::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& NameHasOwnerRequest::getName () const {
    return _name;
}

inline ::std::string& NameHasOwnerRequest::getNameMutable () {
    set_has_name();
    return _name;
}

inline void NameHasOwnerRequest::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void NameHasOwnerRequest::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void NameHasOwnerRequest::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void NameHasOwnerRequest::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void NameHasOwnerRequest::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  NameHasOwnerResponse::NameHasOwnerResponse ()  :
    _data (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NameHasOwnerResponse::NameHasOwnerResponse (const NameHasOwnerResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _data (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NameHasOwnerResponse::NameHasOwnerResponse (bool data_)  :
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NameHasOwnerResponse::~NameHasOwnerResponse() {
}

inline NameHasOwnerResponse& NameHasOwnerResponse::operator = (const NameHasOwnerResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool NameHasOwnerResponse::operator == (const NameHasOwnerResponse& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool NameHasOwnerResponse::operator != (const NameHasOwnerResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool NameHasOwnerResponse::operator < (const NameHasOwnerResponse& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* NameHasOwnerResponse::clone() {
    return new NameHasOwnerResponse(*this);
}

inline bool NameHasOwnerResponse::operator > (const NameHasOwnerResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NameHasOwnerResponse::clear() {
    clearData();
}

inline void NameHasOwnerResponse::clearData() {
    if (hasData()) {
         clear_has_data();
        _data = false;
     }
}

inline bool NameHasOwnerResponse::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool NameHasOwnerResponse::getData () const {
    return _data;
}

inline void NameHasOwnerResponse::setData (bool data_) {
    set_has_data();
    this->_data = data_;
}

inline void NameHasOwnerResponse::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void NameHasOwnerResponse::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetNameOwnerRequest::GetNameOwnerRequest ()  :
    _busname ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetNameOwnerRequest::GetNameOwnerRequest (const GetNameOwnerRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _busname ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetNameOwnerRequest::GetNameOwnerRequest (const ::std::string& busname_)  :
    _busname (busname_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (busname_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetNameOwnerRequest::~GetNameOwnerRequest() {
}

inline GetNameOwnerRequest& GetNameOwnerRequest::operator = (const GetNameOwnerRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBusname()) {
            setBusname(rhs.getBusname());
        } else {
            clearBusname();
        }
    }
    return *this;
}

inline bool GetNameOwnerRequest::operator == (const GetNameOwnerRequest& rhs) const {
    return (((!hasBusname() && !rhs.hasBusname()) || getBusname() == rhs.getBusname()));
}

inline bool GetNameOwnerRequest::operator != (const GetNameOwnerRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool GetNameOwnerRequest::operator < (const GetNameOwnerRequest& rhs) const {
    if (hasBusname() || rhs.hasBusname()) {
        if (getBusname() < rhs.getBusname()) return true;
        if (getBusname() > rhs.getBusname()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetNameOwnerRequest::clone() {
    return new GetNameOwnerRequest(*this);
}

inline bool GetNameOwnerRequest::operator > (const GetNameOwnerRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetNameOwnerRequest::clear() {
    clearBusname();
}

inline void GetNameOwnerRequest::clearBusname() {
    if (hasBusname()) {
         clear_has_busname();
        _busname.clear();
     }
}

inline bool GetNameOwnerRequest::hasBusname () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& GetNameOwnerRequest::getBusname () const {
    return _busname;
}

inline ::std::string& GetNameOwnerRequest::getBusnameMutable () {
    set_has_busname();
    return _busname;
}

inline void GetNameOwnerRequest::setBusname (const ::std::string& busname_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (busname_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_busname();
    this->_busname = busname_;
}

inline void GetNameOwnerRequest::setBusname (const char* busname_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (busname_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_busname();
    this->_busname.assign(busname_);
}

inline void GetNameOwnerRequest::setBusname (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_busname();
    this->_busname.assign(value, size);
}

inline void GetNameOwnerRequest::set_has_busname () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetNameOwnerRequest::clear_has_busname () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetNameOwnerResponse::GetNameOwnerResponse ()  :
    _uniqueid ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetNameOwnerResponse::GetNameOwnerResponse (const GetNameOwnerResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _uniqueid ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetNameOwnerResponse::GetNameOwnerResponse (const ::std::string& uniqueid_)  :
    _uniqueid (uniqueid_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (uniqueid_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetNameOwnerResponse::~GetNameOwnerResponse() {
}

inline GetNameOwnerResponse& GetNameOwnerResponse::operator = (const GetNameOwnerResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasUniqueid()) {
            setUniqueid(rhs.getUniqueid());
        } else {
            clearUniqueid();
        }
    }
    return *this;
}

inline bool GetNameOwnerResponse::operator == (const GetNameOwnerResponse& rhs) const {
    return (((!hasUniqueid() && !rhs.hasUniqueid()) || getUniqueid() == rhs.getUniqueid()));
}

inline bool GetNameOwnerResponse::operator != (const GetNameOwnerResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetNameOwnerResponse::operator < (const GetNameOwnerResponse& rhs) const {
    if (hasUniqueid() || rhs.hasUniqueid()) {
        if (getUniqueid() < rhs.getUniqueid()) return true;
        if (getUniqueid() > rhs.getUniqueid()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetNameOwnerResponse::clone() {
    return new GetNameOwnerResponse(*this);
}

inline bool GetNameOwnerResponse::operator > (const GetNameOwnerResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetNameOwnerResponse::clear() {
    clearUniqueid();
}

inline void GetNameOwnerResponse::clearUniqueid() {
    if (hasUniqueid()) {
         clear_has_uniqueid();
        _uniqueid.clear();
     }
}

inline bool GetNameOwnerResponse::hasUniqueid () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& GetNameOwnerResponse::getUniqueid () const {
    return _uniqueid;
}

inline ::std::string& GetNameOwnerResponse::getUniqueidMutable () {
    set_has_uniqueid();
    return _uniqueid;
}

inline void GetNameOwnerResponse::setUniqueid (const ::std::string& uniqueid_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (uniqueid_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_uniqueid();
    this->_uniqueid = uniqueid_;
}

inline void GetNameOwnerResponse::setUniqueid (const char* uniqueid_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (uniqueid_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_uniqueid();
    this->_uniqueid.assign(uniqueid_);
}

inline void GetNameOwnerResponse::setUniqueid (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_uniqueid();
    this->_uniqueid.assign(value, size);
}

inline void GetNameOwnerResponse::set_has_uniqueid () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetNameOwnerResponse::clear_has_uniqueid () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  NameOwnerChangedSignal::NameOwnerChangedSignal ()  :
    _name (),
    _old (),
    _new ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NameOwnerChangedSignal::NameOwnerChangedSignal (const NameOwnerChangedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _name (),
    _old (),
    _new ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NameOwnerChangedSignal::NameOwnerChangedSignal (const ::std::string& name_, const ::std::string& old_, const ::std::string& new_)  :
    _name (name_),
    _old (old_),
    _new (new_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (old_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (new_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NameOwnerChangedSignal::~NameOwnerChangedSignal() {
}

inline NameOwnerChangedSignal& NameOwnerChangedSignal::operator = (const NameOwnerChangedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasOld()) {
            setOld(rhs.getOld());
        } else {
            clearOld();
        }
        if (rhs.hasNew()) {
            setNew(rhs.getNew());
        } else {
            clearNew();
        }
    }
    return *this;
}

inline bool NameOwnerChangedSignal::operator == (const NameOwnerChangedSignal& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasOld() && !rhs.hasOld()) || getOld() == rhs.getOld()) &&
        ((!hasNew() && !rhs.hasNew()) || getNew() == rhs.getNew()));
}

inline bool NameOwnerChangedSignal::operator != (const NameOwnerChangedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool NameOwnerChangedSignal::operator < (const NameOwnerChangedSignal& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasOld() || rhs.hasOld()) {
        if (getOld() < rhs.getOld()) return true;
        if (getOld() > rhs.getOld()) return false;
    }
    if (hasNew() || rhs.hasNew()) {
        if (getNew() < rhs.getNew()) return true;
        if (getNew() > rhs.getNew()) return false;
    }
    return false;
}

inline ::asf::core::Payload* NameOwnerChangedSignal::clone() {
    return new NameOwnerChangedSignal(*this);
}

inline bool NameOwnerChangedSignal::operator > (const NameOwnerChangedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NameOwnerChangedSignal::clear() {
    clearName();
    clearOld();
    clearNew();
}

inline void NameOwnerChangedSignal::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool NameOwnerChangedSignal::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& NameOwnerChangedSignal::getName () const {
    return _name;
}

inline ::std::string& NameOwnerChangedSignal::getNameMutable () {
    set_has_name();
    return _name;
}

inline void NameOwnerChangedSignal::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void NameOwnerChangedSignal::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void NameOwnerChangedSignal::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void NameOwnerChangedSignal::clearOld() {
    if (hasOld()) {
         clear_has_old();
        _old.clear();
     }
}

inline bool NameOwnerChangedSignal::hasOld () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& NameOwnerChangedSignal::getOld () const {
    return _old;
}

inline ::std::string& NameOwnerChangedSignal::getOldMutable () {
    set_has_old();
    return _old;
}

inline void NameOwnerChangedSignal::setOld (const ::std::string& old_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (old_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_old();
    this->_old = old_;
}

inline void NameOwnerChangedSignal::setOld (const char* old_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (old_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_old();
    this->_old.assign(old_);
}

inline void NameOwnerChangedSignal::setOld (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_old();
    this->_old.assign(value, size);
}

inline void NameOwnerChangedSignal::clearNew() {
    if (hasNew()) {
         clear_has_new();
        _new.clear();
     }
}

inline bool NameOwnerChangedSignal::hasNew () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& NameOwnerChangedSignal::getNew () const {
    return _new;
}

inline ::std::string& NameOwnerChangedSignal::getNewMutable () {
    set_has_new();
    return _new;
}

inline void NameOwnerChangedSignal::setNew (const ::std::string& new_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (new_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_new();
    this->_new = new_;
}

inline void NameOwnerChangedSignal::setNew (const char* new_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (new_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_new();
    this->_new.assign(new_);
}

inline void NameOwnerChangedSignal::setNew (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_new();
    this->_new.assign(value, size);
}

inline void NameOwnerChangedSignal::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void NameOwnerChangedSignal::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void NameOwnerChangedSignal::set_has_old () {
    _has_bits_[0] |= 1u << 1;
}

inline void NameOwnerChangedSignal::clear_has_old () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void NameOwnerChangedSignal::set_has_new () {
    _has_bits_[0] |= 1u << 2;
}

inline void NameOwnerChangedSignal::clear_has_new () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  NameAcquiredSignal::NameAcquiredSignal ()  :
    _name ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NameAcquiredSignal::NameAcquiredSignal (const NameAcquiredSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _name ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NameAcquiredSignal::NameAcquiredSignal (const ::std::string& name_)  :
    _name (name_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NameAcquiredSignal::~NameAcquiredSignal() {
}

inline NameAcquiredSignal& NameAcquiredSignal::operator = (const NameAcquiredSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
    }
    return *this;
}

inline bool NameAcquiredSignal::operator == (const NameAcquiredSignal& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()));
}

inline bool NameAcquiredSignal::operator != (const NameAcquiredSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool NameAcquiredSignal::operator < (const NameAcquiredSignal& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* NameAcquiredSignal::clone() {
    return new NameAcquiredSignal(*this);
}

inline bool NameAcquiredSignal::operator > (const NameAcquiredSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NameAcquiredSignal::clear() {
    clearName();
}

inline void NameAcquiredSignal::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool NameAcquiredSignal::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& NameAcquiredSignal::getName () const {
    return _name;
}

inline ::std::string& NameAcquiredSignal::getNameMutable () {
    set_has_name();
    return _name;
}

inline void NameAcquiredSignal::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void NameAcquiredSignal::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void NameAcquiredSignal::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void NameAcquiredSignal::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void NameAcquiredSignal::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace DBus
} // namespace freedesktop
} // namespace org
} // namespace dbus
} // namespace asf

#endif // ASF_DBUS_ORG_FREEDESKTOP_DBUS_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
