/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2013
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     DBusAssert.h
 *\brief
 *
 *\author   CM-AI/EAR-S
 *          stefan.baron3@de.bosch.com
 *
 *\par Copyright:
 *(c) 2013-2013 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_DBUS_DBUSLOGGER_H
#define ASF_DBUS_DBUSLOGGER_H

#include "asf/core/Logger.h"

#define DBUS_ASSERT(expr)                                                                \
    {                                                                                    \
        dbus_bool_t _ret = expr;                                                         \
        (void)_ret;                                                                      \
        LOG_ASSERT_FATAL_MSG_STATIC(_ret, "D-Bus serialization failed, out of memory."); \
    }

#endif  // ASF_DBUS_DBUSLOGGER_H
