/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ASF_CORECONST_H
#define ASF_CORECONST_H

#include <cstddef>

/**
 * Types core
 *
 * Initial version - christoph.kulla@de.bosch.com
 */

namespace asf {
namespace core {

/**
 * The enumeration ServiceState represents the possible states of a service in ASF
 * from the clients perspective. This state definition is used across all service
 * technologies supported by ASF.
 *
 * Please note that the supported states may vary between the service technologies
 * supported by ASF. You'll find informations about the supported states of specific
 * service technologies in the ASF documentation.
 */
enum ServiceState {

    /**
     * A service is in state Disconnected when there is no connection to the
     * service provider.
     */
    ServiceState__Disconnected,
    /**
     * A service is in state Available when there is a connection to the service
     * provider and the service is functional. A client can make use of the service.
     */
    ServiceState__Available,
    /**
     * A service is in state Suspended when there is a connection to the service
     * provider but the the service is suspended (not functional, paused etc.).
     *
     * A service provider (such as a CCA application) will usually remember all property
     * notifications when a service is Suspended. When the service becomes Available
     * later properties will send notifications to previously registered clients.
     * Please note that this will not happen when the service becomes Disconnected
     * and then Available again.
     */
    ServiceState__Suspended

};

bool ServiceState_Parse (const char *str, size_t length, ServiceState &value);

const char* ServiceState_Name (ServiceState value);

bool ServiceState_IsValid (ServiceState value);

/**
 * If the meaning of "Reason" isn't clear, then there should be a description here.
 */
enum TimerPayload_Reason {

    /**
     * Signals intermediate timer callback invocations. More callback
     * invocations will happen.
     */
    TimerPayload_Reason__Repeat,
    /**
     * Signals the final timer callback invocation. No more callback
     * invocations will happen.
     */
    TimerPayload_Reason__Completed

};

bool TimerPayload_Reason_Parse (const char *str, size_t length, TimerPayload_Reason &value);

const char* TimerPayload_Reason_Name (TimerPayload_Reason value);

bool TimerPayload_Reason_IsValid (TimerPayload_Reason value);

} // namespace core
} // namespace asf

#endif // ASF_CORECONST_H
