/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     Blob.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.kulla@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2012 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_CORE_NULLABLE_H
#define ASF_CORE_NULLABLE_H

#include "asf/core/Types.h"

#include <cassert>
#include <cstring>

namespace asf {
namespace core {

template < class T >
class nullable {
public:
    nullable() : _hasValue(false), _t() {}

    nullable(const T& t) : _hasValue(true), _t(t) {}

    nullable(const nullable< T >& t) : _hasValue(t._hasValue), _t(t._t) {}

    nullable< T >& operator=(const T& rhs) {
        _hasValue = true;
        _t = rhs;
        return *this;
    }

    nullable< T >& operator=(const nullable< T >& rhs) {
        if (this != &rhs) {
            _hasValue = rhs._hasValue;
            if (rhs._hasValue) {
                _t = rhs._t;
            }
        }
        return *this;
    }

    const T& get() const {
        assert(_hasValue == true);
        return _t;
    }

    T& get() {
        assert(_hasValue == true);
        return _t;
    }

    const T& getValueOr(const T& _default) const {
        if (_hasValue) {
            return _t;
        } else {
            return _default;
        }
    }

    bool hasValue() const { return _hasValue; }

    bool operator!() const { return !hasValue(); }

private:
    bool _hasValue;

    T _t;
};
#if defined(__GNUC__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
template < class T >
inline bool operator==(nullable< T > const& x, nullable< T > const& y) {
    return (!x && !y) || (!!x && !!y && x.get() == y.get());
}
#if defined(__GNUC__)
#pragma GCC diagnostic pop
#endif

template < class T >
inline bool operator!=(nullable< T > const& x, nullable< T > const& y) {
    return !(x == y);
}

template < class T >
inline bool operator<(nullable< T > const& x, nullable< T > const& y) {
    return (!x && !!y) || (!!x && !!y && x.get() < y.get());
}

template < class T >
inline bool operator>(nullable< T > const& x, nullable< T > const& y) {
    return (!(x < y) && x != y);
}

template < class T >
inline bool operator<=(nullable< T > const& x, nullable< T > const& y) {
    return !(y < x);
}

template < class T >
inline bool operator>=(nullable< T > const& x, nullable< T > const& y) {
    return !(x < y);
}

}  // namespace core
}  // namespace asf

#endif  // ASF_CORE_NULLABLE_H
