/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     StubDelegateBase.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2013 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_CORE_STUBDELEGATEBASE_H
#define ASF_CORE_STUBDELEGATEBASE_H

#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"

namespace asf {
namespace core {

/**
 * Do make use of this logger macros in any class which is derived from StubDelegateBase!
 * It enables to find out the originator of the delegate stub.
 */
#define LOG_DEBUG_STUB(FORMAT, ...) LOG_DEBUG(FORMAT ", stub=%p", ##__VA_ARGS__, getStub())
#define LOG_INFO_STUB(FORMAT, ...) LOG_INFO(FORMAT ", stub=%p", ##__VA_ARGS__, getStub())
#define LOG_WARN_STUB(FORMAT, ...) LOG_WARN(FORMAT ", stub=%p", ##__VA_ARGS__, getStub())
#define LOG_ERROR_STUB(FORMAT, ...) LOG_ERROR(FORMAT ", stub=%p", ##__VA_ARGS__, getStub())
#define LOG_FATAL_STUB(FORMAT, ...) LOG_FATAL(FORMAT ", stub=%p", ##__VA_ARGS__, getStub())

class Stub;
class ConnectionIF;

class StubDelegateBase {
public:
    StubDelegateBase(Stub* stub, bool verifyPort = true);

    virtual ~StubDelegateBase();

    ::asf::core::Stub* getStub() const { return _stub; }

    ProvidedPort* getProvidedPort() const { return _providedPort; }

    ComponentDescription* getComponentDescription();

    virtual void disconnected(ConnectionIFSharedPtr /*remote*/) {}

protected:
    ::asf::core::Stub* _stub;

private:
    ProvidedPort* _providedPort;

    ComponentDescription* _componentDescription;

    DECLARE_CLASS_LOGGER();
};

}  // namespace core
}  // namespace asf

#endif  // ASF_CORE_STUBDELEGATEBASE_H
