/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2013
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     RequiredPort.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2013-2013 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_CORE_REQUIREDPORT_H
#define ASF_CORE_REQUIREDPORT_H

#include <boost/weak_ptr.hpp>
#include <string>
#include <vector>
#include "asf/core/ComponentPort.h"
#include "asf/core/Logger.h"
#include "asf/core/Proxy.h"
#include "asf/core/Types.h"

namespace asf {
namespace core {

class ProxyDelegateBase;

class ImportedPort;

class ProvidedPort;

class ComponentDescription;

class RequiredPort : public ComponentPort {
public:
    enum BoundedPortType {
        E_PORT_TYPE_UNDEFINED = 0,
        E_PORT_TYPE_LOCAL,
        E_PORT_TYPE_IMPORT,
        E_PORT_TYPE_IMPORT_RUNTIME
    };

    RequiredPort(const std::string& serviceName,
                 const std::string& portName,
                 bool isRuntimePort = false);

    virtual ~RequiredPort();

    void setImportedPort(::asf::core::ImportedPort* importedPort);

    void setLocalPort(::asf::core::ProvidedPort* localPort);

    void setComponentDescription(ComponentDescription* componentDescription) {
        _componentDescription = componentDescription;
    }

    bool isImportedPort() const { return (_boundedPortType == E_PORT_TYPE_IMPORT); }

    bool isLocalPort() const { return (_boundedPortType == E_PORT_TYPE_LOCAL); }

    ImportedPort* getImportedPort();

    ProvidedPort* getLocalPort();

    bool isRuntimePort() const { return (_boundedPortType == E_PORT_TYPE_IMPORT_RUNTIME); }

    ::boost::shared_ptr< Proxy > attachProxy(const ::boost::shared_ptr< Proxy >& proxy);

    ::boost::shared_ptr< Proxy > getProxy(const ::asf::core::ServiceAvailableIF& serviceAvailable);

    size_t getProxyCount() const { return _weakProxies.size(); }

private:
    void deleteZombies();

    ComponentDescription* _componentDescription;

    BoundedPortType _boundedPortType;

    ComponentPort* _port;

    std::vector< ::boost::weak_ptr< Proxy > > _weakProxies;

    DECLARE_CLASS_LOGGER();
};

}  // namespace core
}  // namespace asf

#endif  // ASF_CORE_REQUIREDPORT_H
