/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2009
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/

/*!
 *\file     Internal.h
 *\brief
 *
 *\author   CM-AIPJ/CF15
 *          christoph.kulla@de.bosch.com
 *
 *\par Copyright:
 *(c) 20012 Robert Bosch Car Multimedia GmbH
 *
 *\par History:
 * See history of revision control system
 ***************************************************************************/

#ifndef ASF_CORE_INTERNAL_H
#define ASF_CORE_INTERNAL_H

#include <string>
#include "asf/core/Blob.h"
#include "asf/core/HookContainer.h"

namespace asf {
namespace core {

extern const ::std::string theEmptyString;

extern const ::asf::core::Blob theEmptyBlob;

class Char;  // defined in core.cmt as a structure with a string field

extern const ::asf::core::Char theEmptyChar;

/**
 * Registers a void function to be run at end of the process.
 *
 * The higher the priority the later the function is executed during shutdown.
 */
void registerShutdownHook(HookContainer::VoidFunctionPtr shutdownHook, int priority = 0);

}  // namespace core
}  // namespace asf

#endif  // ASF_CORE_INTERNAL_H
