/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2014
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/

/*!
 *\file     HookContainer.h
 *\brief
 *
 *\author   CM-AIPJ/ECA
 *          christoph.kulla@de.bosch.com
 *
 *\par Copyright:
 *(c) 20012 Robert Bosch Car Multimedia GmbH
 *
 *\par History:
 * See history of revision control system
 ***************************************************************************/
#ifndef ASF_CORE_HOOKCONTAINER_H_
#define ASF_CORE_HOOKCONTAINER_H_

#include <vector>

namespace asf {
namespace core {

/**
 * A HookContainer can store several function pointers to functions which will
 * be executed at the end of the life time of the container.
 */
class HookContainer {
public:
    typedef void (*VoidFunctionPtr)();

    struct Hook {
        int priority;
        VoidFunctionPtr function;
    };

    /**
     * Registers a void function to be run at end of the lifetime
     * of the HookContainer.
     *
     * @param priority The higher the priority the later the function
     * is executed during shutdown.
     */
    void add(VoidFunctionPtr function, int priority = 0);

    /**
     * Runs all registered hooks
     */
    void runHooks();

private:
    ::std::vector< Hook > hooks;
};

}  // namespace core
}  // namespace asf

#endif  // ASF_CORE_HOOKCONTAINER_H
