/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2016
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     FormatPrinting.h
 *\brief    Macros to print pointer on different CPU types
 *
 *\par Copyright:
 *(c) 2012-2016 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/

#ifndef ASF_FORMAT_PRINTING_H
#define ASF_FORMAT_PRINTING_H

// request format macros of the ISO C99 standard
#ifndef __STDC_FORMAT_MACROS
#define __STDC_FORMAT_MACROS
#endif

#include <inttypes.h>  // defines PRIxPTR

#include "CpuArchitecture.h"

#ifdef _MSC_VER
#define ASF_PRINT_SIZE_T "Iu"
#define ASF_PRINT_SSIZE_T "Id"
#elif defined(__GNUC__) || defined(__ghs__)
#define ASF_PRINT_SIZE_T "zu"
#define ASF_PRINT_SSIZE_T "zd"
#else
#error "ASF_PRINT_SIZE_T and ASF_PRINT_SSIZE_T are not defined"
#endif

#ifdef ASF_32
#define ASF_PRINT_PTR_WIDTH "8"
#else
#ifdef ASF_64
#define ASF_PRINT_PTR_WIDTH "16"
#else
#error "Can't define ASF_PRINT_PTR_WIDTH"
#endif
#endif

// ASF_FIXED_WIDTH_PRIxPTR is a printf format specifier to print a pointer in hexadecimal with fixed
// width
// of your CPU WIDTH (8=32-bit, 16=64-bit), e.g. 00001234
#define ASF_FIXED_WIDTH_PRIxPTR "0" ASF_PRINT_PTR_WIDTH PRIxPTR

#endif
