/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/

/*!
 *\file     ConnectionIF.h
 *\brief
 *
 *\author   CM-PS/ETC1-PEC2HI
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2012 Robert Bosch Car Multimedia GmbH
 *
 *\par History:
 * See history of revision control system
 ***************************************************************************/
#ifndef ASF_CORE_CONNECTION_H
#define ASF_CORE_CONNECTION_H

#include "asf/core/Types.h"

#include <boost/shared_ptr.hpp>

namespace asf {
namespace core {

class ConnectionIF {
public:
    virtual ~ConnectionIF() {}

    virtual ssize_t sendData(size_t size, const uint8* pu8Data) = 0;

    virtual ::asf::identifier_t getConnectionId() = 0;
};

typedef ::boost::shared_ptr< ::asf::core::ConnectionIF > ConnectionIFSharedPtr;

}  // namespace core
}  // namespace asf

#endif  // ASF_CORE_CONNECTION_H
