/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     ComponentMessageAdapter.h
 *\brief
 *
 *\author   CM-AI/PJ-CF11.1
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2013-2013 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_CORE_COMPONENTMESSAGEADAPTER_H
#define ASF_CORE_COMPONENTMESSAGEADAPTER_H

#include "asf/core/Blob.h"
#include "asf/core/ConnectionMessage.h"
#include "asf/core/ServiceMessage.h"
#include "asf/core/Types.h"
#include "asf/threading/Guard.h"
#include "asf/threading/Mutex.h"

namespace asf {
namespace core {

class CommunicationStack;
class ConnectionIF;
class ApplicationBinderIF;

class ProvidedPort;
class RequiredPort;
class ExportedPort;
class ImportedPort;

class ComponentMessageAdapter {
public:
    ComponentMessageAdapter();

    virtual ~ComponentMessageAdapter() {}

    /**
     * Creates a ServiceMessage object from the passed memory buffer. Each service
     * technology will return a different kind of ServiceMessage. This is the source
     * of messages which are placed in the internal ASF message queues.
     *
     * @returns the message which was created, or null if no message was created
     */
    virtual ServiceMessage* createServiceMessage(
        const ::boost::shared_ptr< ::asf::core::Blob >& blobMessage,
        CommunicationStack* comStack,
        ConnectionIFSharedPtr connection) = 0;

    virtual ConnectionMessage* createConnectionMessage(ConnectionIFSharedPtr connection,
                                                       bool isStub,
                                                       bool isConnected) = 0;

    static void sendMessage(::asf::core::ComponentMessage& msg);

    static CommunicationStack* getProxyComStack(const std::string& scheme);

    static bool bind(ProvidedPort& providedPort, ExportedPort& exportedPort);

    static bool bind(RequiredPort& requiredPort, ImportedPort& importedPort);

    static bool bind(RequiredPort& requiredPort, ProvidedPort& providedPort);

    ProvidedPort* findProvidedPort(const std::string& serviceName,
                                   const std::string& portName) const;

    // To inject a application mock. (only for tests)
    static void setApplication(::asf::core::ApplicationBinderIF* appBinder);

    static void resetAppBinder();

    static ApplicationBinderIF* _appBinder;

private:
    static ApplicationBinderIF* getAppBinder();
};

}  // namespace core
}  // namespace asf

#endif  // ASF_CORE_COMPONENTMESSAGEADAPTER_H
