/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     CommunicationStack.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2017 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_CORE_COMMUNICATIONSTACK_H
#define ASF_CORE_COMMUNICATIONSTACK_H

#include <string>
#include "asf/core/IncomingOutgoingIF.h"
#include "asf/core/Types.h"

namespace asf {
namespace core {

class ComponentMessageAdapter;

class Application;

class CommunicationStack : public IncomingIF {
public:
    CommunicationStack(ComponentMessageAdapter& messageFactory,
                       Application* pApp,
                       const std::string& scheme);

    virtual ~CommunicationStack() {
        _pOutgoing = 0;
        _pApplication = 0;
    };

    // FIXME: add return code to signal an error
    void sendRawData(ConnectionIFSharedPtr connection, size_t size, uint8* pRawData);

    ::asf::core::ComponentMessageAdapter* getAdapter() const { return &_messageAdapter; };

    void setOutgoingIF(OutgoingIF* pOutgoing);

    void onConnected(ConnectionIFSharedPtr connection) = 0;

    void onDisconnected(ConnectionIFSharedPtr connection) = 0;

    virtual ConnectionIFSharedPtr connectServer(const std::string& address) {
        return _pOutgoing->connectServer(address);
    }

    virtual void disconnectServer(::asf::core::ConnectionIFSharedPtr connection) {
        _pOutgoing->disconnectServer(connection);
    }

    void onReceivedData(ConnectionIFSharedPtr connection, size_t size, const uint8* pData);

    void onError(ConnectionIFSharedPtr connection, enError err);

    bool isType(const std::string& scheme) const { return (_scheme.compare(scheme) == 0); }

    /**
     * Scheme that the communication stack handles
     */
    const std::string& getScheme() const { return _scheme; }

private:
    OutgoingIF* _pOutgoing;

    std::string _scheme;

protected:
    ComponentMessageAdapter& _messageAdapter;

    Application* _pApplication;
};

class StubCommunicationStack : public CommunicationStack {
public:
    StubCommunicationStack(ComponentMessageAdapter& messageFactory,
                           Application* pApp,
                           const std::string& scheme);

    virtual ~StubCommunicationStack(){};

    void onConnected(ConnectionIFSharedPtr connection);

    void onDisconnected(ConnectionIFSharedPtr connection);
};

class ProxyCommunicationStack : public CommunicationStack {
public:
    ProxyCommunicationStack(ComponentMessageAdapter& messageFactory,
                            Application* pApp,
                            const std::string& scheme);

    virtual ~ProxyCommunicationStack(){};

    void onConnected(ConnectionIFSharedPtr connection);

    void onDisconnected(ConnectionIFSharedPtr connection);
};

}  // namespace core
}  // namespace asf

#endif  // ASF_CORE_COMMUNICATIONSTACK_H
