/*********************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2019
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 *********************************************************************/

#ifndef CALL_PTHREAD_NO_LOGGING_H
#define CALL_PTHREAD_NO_LOGGING_H

// In contrast to CallPthread.h this file define CALL_PTHREAD without using the
// ASF logging API.
//
// for more documentation please take a look at CallPthread.h

#include <errno.h>

#ifndef NDEBUG
#include <assert.h>

#define CALL_PTHREAD(statement) \
    {                           \
        int status = statement; \
        assert(status == 0);    \
    }

#define CALL_PTHREAD_IGNORE_EBUSY(statement)    \
    {                                           \
        int status = statement;                 \
        assert(status == 0 || status == EBUSY); \
    }
#else
#define CALL_PTHREAD(statement) ((void)(statement))

#define CALL_PTHREAD_IGNORE_EBUSY(statement) ((void)statement)

#endif

#endif  // CALL_PTHREAD_NO_LOGGING_H
