#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ASF_CORE_H
#define ASF_CORE_H

#include "asf/core/Internal.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/coreConst.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * Types core
 *
 * Initial version - christoph.kulla@de.bosch.com
 */

namespace asf {
namespace core {

ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 0;

static const int VERSION_MINOR = 1;

static const int VERSION_PATCH = 0;

// forward declarations
class Char;

class ServiceStateChange;

class Version;

class BuildInfo_CMakeInfo;

class BuildInfo_GitInfo;

class BuildInfo_HostInfo;

class BuildInfo_DockerInfo;

class BuildInfo_JenkinsInfo;

class BuildInfo;

class LibraryInfo;

class TimerPayload;


/**
 * A C++ representation of a single character.
 *
 * We used a structure here because we can't map string and
 * char to std::string, as this leads to an overriding collision
 * see NAVARCH-213.
 */
class Char {
public:

    /**
     * Default constructor
     */
    inline  Char ();

    /**
     * Copy constructor
     */
    inline  Char (const Char &rhs);

    /**
     * All fields constructor
     */
    inline  Char (const ::std::string& char_);

    /**
     * Destructor
     */
    inline  ~Char();

    /**
     * Assignment operator
     */
    inline Char& operator = (const Char& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Char& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Char& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Char& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Char& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "char"

    static const int kChar = 0;

    /**
     * Clears the field "char_".
     *
     * The field will be set to its default value. The hasChar()
     * method will return false.
     */
    inline void clearChar();

    /**
     * Checks whether the field "char" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChar()). Otherwise it will return false.
     */
    inline bool hasChar () const;

    /**
     * Returns the value of the member "char".
     *
     * If the meaning of "char" isn't clear, then there should be a description here.
     *
     * @return The value of the field "char_"
     */
    inline const ::std::string& getChar () const;

    /**
     * Retrieves the value of the field "char" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "char".
     */
    inline ::std::string& getCharMutable ();

    /**
     * Sets the value of the member "char".
     *
     * If the meaning of "char" isn't clear, then there should be a description here.
     *
     * @param char_ The value which will be set
     */
    inline void setChar (const ::std::string& char_);

    /**
     * Sets the value of the member "char".
     *
     * If the meaning of "char" isn't clear, then there should be a description here.
     *
     * @param char_ The value which will be set
     */
    inline void setChar (const char* char_);

    /**
     * Sets the value of the member "char".
     *
     * If the meaning of "char" isn't clear, then there should be a description here.
     *
     * @param char_ The value which will be set
     */
    inline void setChar (const char* value, size_t size);

    /**
     * Release the object stored in the field "char".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "char"
     */
    inline ::std::string* releaseChar();

    /**
     * Replace the field "char".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceChar (::std::string* char_);

    static const Char &getDefaultInstance();

private:

    inline void set_has_char ();

    inline void clear_has_char ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string* _char;

};

/**
 * The ServiceStateChange structure represents a state transition of a service.
 * It used by ASF to pass a state change of a service to the user with the help
 * of the ServiceAvailableIF.
 */
class ServiceStateChange {
public:

    /**
     * Default constructor
     */
    inline  ServiceStateChange ();

    /**
     * Copy constructor
     */
    inline  ServiceStateChange (const ServiceStateChange &rhs);

    /**
     * All fields constructor
     */
    inline  ServiceStateChange (ServiceState previousState_, ServiceState currentState_);

    /**
     * Destructor
     */
    inline  ~ServiceStateChange();

    /**
     * Assignment operator
     */
    inline ServiceStateChange& operator = (const ServiceStateChange& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ServiceStateChange& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ServiceStateChange& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ServiceStateChange& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ServiceStateChange& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "previousState"

    static const int kPreviousState = 0;

    /**
     * Clears the field "previousState".
     *
     * The field will be set to its default value. The hasPreviousState()
     * method will return false.
     */
    inline void clearPreviousState();

    /**
     * Checks whether the field "previousState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPreviousState()). Otherwise it will return false.
     */
    inline bool hasPreviousState () const;

    /**
     * Returns the value of the member "previousState".
     *
     * If the meaning of "previousState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "previousState"
     */
    inline ServiceState getPreviousState () const;

    /**
     * Sets the value of the member "previousState".
     *
     * If the meaning of "previousState" isn't clear, then there should be a description here.
     *
     * @param previousState The value which will be set
     */
    inline void setPreviousState (ServiceState previousState_);

    // API of field "currentState"

    static const int kCurrentState = 1;

    /**
     * Clears the field "currentState".
     *
     * The field will be set to its default value. The hasCurrentState()
     * method will return false.
     */
    inline void clearCurrentState();

    /**
     * Checks whether the field "currentState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentState()). Otherwise it will return false.
     */
    inline bool hasCurrentState () const;

    /**
     * Returns the value of the member "currentState".
     *
     * If the meaning of "currentState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "currentState"
     */
    inline ServiceState getCurrentState () const;

    /**
     * Sets the value of the member "currentState".
     *
     * If the meaning of "currentState" isn't clear, then there should be a description here.
     *
     * @param currentState The value which will be set
     */
    inline void setCurrentState (ServiceState currentState_);

    static const ServiceStateChange &getDefaultInstance();

private:

    inline void set_has_previousState ();

    inline void clear_has_previousState ();

    inline void set_has_currentState ();

    inline void clear_has_currentState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ServiceState _previousState;

    ServiceState _currentState;

};

/**
 * If the meaning of "Version" isn't clear, then there should be a description here.
 */
class Version {
public:

    /**
     * Default constructor
     */
    inline  Version ();

    /**
     * Copy constructor
     */
    inline  Version (const Version &rhs);

    /**
     * All fields constructor
     */
    inline  Version (uint32 major_, uint32 minor_, uint32 patch_, const ::std::string& qualifier_);

    /**
     * Destructor
     */
    inline  ~Version();

    /**
     * Assignment operator
     */
    inline Version& operator = (const Version& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Version& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Version& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Version& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Version& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "major"

    static const int kMajor = 0;

    /**
     * Clears the field "major".
     *
     * The field will be set to its default value. The hasMajor()
     * method will return false.
     */
    inline void clearMajor();

    /**
     * Checks whether the field "major" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMajor()). Otherwise it will return false.
     */
    inline bool hasMajor () const;

    /**
     * Returns the value of the member "major".
     *
     * If the meaning of "major" isn't clear, then there should be a description here.
     *
     * @return The value of the field "major"
     */
    inline uint32 getMajor () const;

    /**
     * Sets the value of the member "major".
     *
     * If the meaning of "major" isn't clear, then there should be a description here.
     *
     * @param major The value which will be set
     */
    inline void setMajor (uint32 major_);

    // API of field "minor"

    static const int kMinor = 1;

    /**
     * Clears the field "minor".
     *
     * The field will be set to its default value. The hasMinor()
     * method will return false.
     */
    inline void clearMinor();

    /**
     * Checks whether the field "minor" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMinor()). Otherwise it will return false.
     */
    inline bool hasMinor () const;

    /**
     * Returns the value of the member "minor".
     *
     * If the meaning of "minor" isn't clear, then there should be a description here.
     *
     * @return The value of the field "minor"
     */
    inline uint32 getMinor () const;

    /**
     * Sets the value of the member "minor".
     *
     * If the meaning of "minor" isn't clear, then there should be a description here.
     *
     * @param minor The value which will be set
     */
    inline void setMinor (uint32 minor_);

    // API of field "patch"

    static const int kPatch = 2;

    /**
     * Clears the field "patch".
     *
     * The field will be set to its default value. The hasPatch()
     * method will return false.
     */
    inline void clearPatch();

    /**
     * Checks whether the field "patch" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPatch()). Otherwise it will return false.
     */
    inline bool hasPatch () const;

    /**
     * Returns the value of the member "patch".
     *
     * If the meaning of "patch" isn't clear, then there should be a description here.
     *
     * @return The value of the field "patch"
     */
    inline uint32 getPatch () const;

    /**
     * Sets the value of the member "patch".
     *
     * If the meaning of "patch" isn't clear, then there should be a description here.
     *
     * @param patch The value which will be set
     */
    inline void setPatch (uint32 patch_);

    // API of field "qualifier"

    static const int kQualifier = 3;

    /**
     * Clears the field "qualifier".
     *
     * The field will be set to its default value. The hasQualifier()
     * method will return false.
     */
    inline void clearQualifier();

    /**
     * Checks whether the field "qualifier" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setQualifier()). Otherwise it will return false.
     */
    inline bool hasQualifier () const;

    /**
     * Returns the value of the member "qualifier".
     *
     * If the meaning of "qualifier" isn't clear, then there should be a description here.
     *
     * @return The value of the field "qualifier"
     */
    inline const ::std::string& getQualifier () const;

    /**
     * Retrieves the value of the field "qualifier" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "qualifier".
     */
    inline ::std::string& getQualifierMutable ();

    /**
     * Sets the value of the member "qualifier".
     *
     * If the meaning of "qualifier" isn't clear, then there should be a description here.
     *
     * @param qualifier The value which will be set
     */
    inline void setQualifier (const ::std::string& qualifier_);

    /**
     * Sets the value of the member "qualifier".
     *
     * If the meaning of "qualifier" isn't clear, then there should be a description here.
     *
     * @param qualifier The value which will be set
     */
    inline void setQualifier (const char* qualifier_);

    /**
     * Sets the value of the member "qualifier".
     *
     * If the meaning of "qualifier" isn't clear, then there should be a description here.
     *
     * @param qualifier The value which will be set
     */
    inline void setQualifier (const char* value, size_t size);

    /**
     * Release the object stored in the field "qualifier".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "qualifier"
     */
    inline ::std::string* releaseQualifier();

    /**
     * Replace the field "qualifier".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceQualifier (::std::string* qualifier_);

    static const Version &getDefaultInstance();

private:

    inline void set_has_major ();

    inline void clear_has_major ();

    inline void set_has_minor ();

    inline void clear_has_minor ();

    inline void set_has_patch ();

    inline void clear_has_patch ();

    inline void set_has_qualifier ();

    inline void clear_has_qualifier ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _major;

    uint32 _minor;

    uint32 _patch;

    ::std::string* _qualifier;

};

/**
 * If the meaning of "CMakeInfo" isn't clear, then there should be a description here.
 */
class BuildInfo_CMakeInfo {
public:

    /**
     * Default constructor
     */
    inline  BuildInfo_CMakeInfo ();

    /**
     * Copy constructor
     */
    inline  BuildInfo_CMakeInfo (const BuildInfo_CMakeInfo &rhs);

    /**
     * All fields constructor
     */
    inline  BuildInfo_CMakeInfo (const ::std::string& CMAKE_BINARY_DIR_, const ::std::string& CMAKE_SOURCE_DIR_, const ::std::string& CMAKE_VERSION_, const ::std::string& BUILD_VARIANT_, const ::std::string& COMPILER_, const ::std::string& COMPILER_FLAGS_, const ::std::string& CMAKE_EXE_LINKER_FLAGS_, const ::std::string& CMAKE_SHARED_LINKER_FLAGS_, const ::std::string& CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS_, const ::std::string& CMAKE_TOOLCHAIN_FILE_);

    /**
     * Destructor
     */
    inline  ~BuildInfo_CMakeInfo();

    /**
     * Assignment operator
     */
    inline BuildInfo_CMakeInfo& operator = (const BuildInfo_CMakeInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BuildInfo_CMakeInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BuildInfo_CMakeInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BuildInfo_CMakeInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BuildInfo_CMakeInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CMAKE_BINARY_DIR"

    static const int kCMAKE_BINARY_DIR = 0;

    /**
     * Clears the field "CMAKE_BINARY_DIR".
     *
     * The field will be set to its default value. The hasCMAKE_BINARY_DIR()
     * method will return false.
     */
    inline void clearCMAKE_BINARY_DIR();

    /**
     * Checks whether the field "CMAKE_BINARY_DIR" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCMAKE_BINARY_DIR()). Otherwise it will return false.
     */
    inline bool hasCMAKE_BINARY_DIR () const;

    /**
     * Returns the value of the member "CMAKE_BINARY_DIR".
     *
     * If the meaning of "CMAKE_BINARY_DIR" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CMAKE_BINARY_DIR"
     */
    inline const ::std::string& getCMAKE_BINARY_DIR () const;

    /**
     * Retrieves the value of the field "CMAKE_BINARY_DIR" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CMAKE_BINARY_DIR".
     */
    inline ::std::string& getCMAKE_BINARY_DIRMutable ();

    /**
     * Sets the value of the member "CMAKE_BINARY_DIR".
     *
     * If the meaning of "CMAKE_BINARY_DIR" isn't clear, then there should be a description here.
     *
     * @param CMAKE_BINARY_DIR The value which will be set
     */
    inline void setCMAKE_BINARY_DIR (const ::std::string& CMAKE_BINARY_DIR_);

    /**
     * Sets the value of the member "CMAKE_BINARY_DIR".
     *
     * If the meaning of "CMAKE_BINARY_DIR" isn't clear, then there should be a description here.
     *
     * @param CMAKE_BINARY_DIR The value which will be set
     */
    inline void setCMAKE_BINARY_DIR (const char* CMAKE_BINARY_DIR_);

    /**
     * Sets the value of the member "CMAKE_BINARY_DIR".
     *
     * If the meaning of "CMAKE_BINARY_DIR" isn't clear, then there should be a description here.
     *
     * @param CMAKE_BINARY_DIR The value which will be set
     */
    inline void setCMAKE_BINARY_DIR (const char* value, size_t size);

    /**
     * Release the object stored in the field "CMAKE_BINARY_DIR".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "CMAKE_BINARY_DIR"
     */
    inline ::std::string* releaseCMAKE_BINARY_DIR();

    /**
     * Replace the field "CMAKE_BINARY_DIR".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCMAKE_BINARY_DIR (::std::string* CMAKE_BINARY_DIR_);

    // API of field "CMAKE_SOURCE_DIR"

    static const int kCMAKE_SOURCE_DIR = 1;

    /**
     * Clears the field "CMAKE_SOURCE_DIR".
     *
     * The field will be set to its default value. The hasCMAKE_SOURCE_DIR()
     * method will return false.
     */
    inline void clearCMAKE_SOURCE_DIR();

    /**
     * Checks whether the field "CMAKE_SOURCE_DIR" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCMAKE_SOURCE_DIR()). Otherwise it will return false.
     */
    inline bool hasCMAKE_SOURCE_DIR () const;

    /**
     * Returns the value of the member "CMAKE_SOURCE_DIR".
     *
     * If the meaning of "CMAKE_SOURCE_DIR" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CMAKE_SOURCE_DIR"
     */
    inline const ::std::string& getCMAKE_SOURCE_DIR () const;

    /**
     * Retrieves the value of the field "CMAKE_SOURCE_DIR" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CMAKE_SOURCE_DIR".
     */
    inline ::std::string& getCMAKE_SOURCE_DIRMutable ();

    /**
     * Sets the value of the member "CMAKE_SOURCE_DIR".
     *
     * If the meaning of "CMAKE_SOURCE_DIR" isn't clear, then there should be a description here.
     *
     * @param CMAKE_SOURCE_DIR The value which will be set
     */
    inline void setCMAKE_SOURCE_DIR (const ::std::string& CMAKE_SOURCE_DIR_);

    /**
     * Sets the value of the member "CMAKE_SOURCE_DIR".
     *
     * If the meaning of "CMAKE_SOURCE_DIR" isn't clear, then there should be a description here.
     *
     * @param CMAKE_SOURCE_DIR The value which will be set
     */
    inline void setCMAKE_SOURCE_DIR (const char* CMAKE_SOURCE_DIR_);

    /**
     * Sets the value of the member "CMAKE_SOURCE_DIR".
     *
     * If the meaning of "CMAKE_SOURCE_DIR" isn't clear, then there should be a description here.
     *
     * @param CMAKE_SOURCE_DIR The value which will be set
     */
    inline void setCMAKE_SOURCE_DIR (const char* value, size_t size);

    /**
     * Release the object stored in the field "CMAKE_SOURCE_DIR".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "CMAKE_SOURCE_DIR"
     */
    inline ::std::string* releaseCMAKE_SOURCE_DIR();

    /**
     * Replace the field "CMAKE_SOURCE_DIR".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCMAKE_SOURCE_DIR (::std::string* CMAKE_SOURCE_DIR_);

    // API of field "CMAKE_VERSION"

    static const int kCMAKE_VERSION = 2;

    /**
     * Clears the field "CMAKE_VERSION".
     *
     * The field will be set to its default value. The hasCMAKE_VERSION()
     * method will return false.
     */
    inline void clearCMAKE_VERSION();

    /**
     * Checks whether the field "CMAKE_VERSION" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCMAKE_VERSION()). Otherwise it will return false.
     */
    inline bool hasCMAKE_VERSION () const;

    /**
     * Returns the value of the member "CMAKE_VERSION".
     *
     * If the meaning of "CMAKE_VERSION" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CMAKE_VERSION"
     */
    inline const ::std::string& getCMAKE_VERSION () const;

    /**
     * Retrieves the value of the field "CMAKE_VERSION" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CMAKE_VERSION".
     */
    inline ::std::string& getCMAKE_VERSIONMutable ();

    /**
     * Sets the value of the member "CMAKE_VERSION".
     *
     * If the meaning of "CMAKE_VERSION" isn't clear, then there should be a description here.
     *
     * @param CMAKE_VERSION The value which will be set
     */
    inline void setCMAKE_VERSION (const ::std::string& CMAKE_VERSION_);

    /**
     * Sets the value of the member "CMAKE_VERSION".
     *
     * If the meaning of "CMAKE_VERSION" isn't clear, then there should be a description here.
     *
     * @param CMAKE_VERSION The value which will be set
     */
    inline void setCMAKE_VERSION (const char* CMAKE_VERSION_);

    /**
     * Sets the value of the member "CMAKE_VERSION".
     *
     * If the meaning of "CMAKE_VERSION" isn't clear, then there should be a description here.
     *
     * @param CMAKE_VERSION The value which will be set
     */
    inline void setCMAKE_VERSION (const char* value, size_t size);

    /**
     * Release the object stored in the field "CMAKE_VERSION".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "CMAKE_VERSION"
     */
    inline ::std::string* releaseCMAKE_VERSION();

    /**
     * Replace the field "CMAKE_VERSION".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCMAKE_VERSION (::std::string* CMAKE_VERSION_);

    // API of field "BUILD_VARIANT"

    static const int kBUILD_VARIANT = 3;

    /**
     * Clears the field "BUILD_VARIANT".
     *
     * The field will be set to its default value. The hasBUILD_VARIANT()
     * method will return false.
     */
    inline void clearBUILD_VARIANT();

    /**
     * Checks whether the field "BUILD_VARIANT" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBUILD_VARIANT()). Otherwise it will return false.
     */
    inline bool hasBUILD_VARIANT () const;

    /**
     * Returns the value of the member "BUILD_VARIANT".
     *
     * If the meaning of "BUILD_VARIANT" isn't clear, then there should be a description here.
     *
     * @return The value of the field "BUILD_VARIANT"
     */
    inline const ::std::string& getBUILD_VARIANT () const;

    /**
     * Retrieves the value of the field "BUILD_VARIANT" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "BUILD_VARIANT".
     */
    inline ::std::string& getBUILD_VARIANTMutable ();

    /**
     * Sets the value of the member "BUILD_VARIANT".
     *
     * If the meaning of "BUILD_VARIANT" isn't clear, then there should be a description here.
     *
     * @param BUILD_VARIANT The value which will be set
     */
    inline void setBUILD_VARIANT (const ::std::string& BUILD_VARIANT_);

    /**
     * Sets the value of the member "BUILD_VARIANT".
     *
     * If the meaning of "BUILD_VARIANT" isn't clear, then there should be a description here.
     *
     * @param BUILD_VARIANT The value which will be set
     */
    inline void setBUILD_VARIANT (const char* BUILD_VARIANT_);

    /**
     * Sets the value of the member "BUILD_VARIANT".
     *
     * If the meaning of "BUILD_VARIANT" isn't clear, then there should be a description here.
     *
     * @param BUILD_VARIANT The value which will be set
     */
    inline void setBUILD_VARIANT (const char* value, size_t size);

    /**
     * Release the object stored in the field "BUILD_VARIANT".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "BUILD_VARIANT"
     */
    inline ::std::string* releaseBUILD_VARIANT();

    /**
     * Replace the field "BUILD_VARIANT".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceBUILD_VARIANT (::std::string* BUILD_VARIANT_);

    // API of field "COMPILER"

    static const int kCOMPILER = 4;

    /**
     * Clears the field "COMPILER".
     *
     * The field will be set to its default value. The hasCOMPILER()
     * method will return false.
     */
    inline void clearCOMPILER();

    /**
     * Checks whether the field "COMPILER" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCOMPILER()). Otherwise it will return false.
     */
    inline bool hasCOMPILER () const;

    /**
     * Returns the value of the member "COMPILER".
     *
     * If the meaning of "COMPILER" isn't clear, then there should be a description here.
     *
     * @return The value of the field "COMPILER"
     */
    inline const ::std::string& getCOMPILER () const;

    /**
     * Retrieves the value of the field "COMPILER" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "COMPILER".
     */
    inline ::std::string& getCOMPILERMutable ();

    /**
     * Sets the value of the member "COMPILER".
     *
     * If the meaning of "COMPILER" isn't clear, then there should be a description here.
     *
     * @param COMPILER The value which will be set
     */
    inline void setCOMPILER (const ::std::string& COMPILER_);

    /**
     * Sets the value of the member "COMPILER".
     *
     * If the meaning of "COMPILER" isn't clear, then there should be a description here.
     *
     * @param COMPILER The value which will be set
     */
    inline void setCOMPILER (const char* COMPILER_);

    /**
     * Sets the value of the member "COMPILER".
     *
     * If the meaning of "COMPILER" isn't clear, then there should be a description here.
     *
     * @param COMPILER The value which will be set
     */
    inline void setCOMPILER (const char* value, size_t size);

    /**
     * Release the object stored in the field "COMPILER".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "COMPILER"
     */
    inline ::std::string* releaseCOMPILER();

    /**
     * Replace the field "COMPILER".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCOMPILER (::std::string* COMPILER_);

    // API of field "COMPILER_FLAGS"

    static const int kCOMPILER_FLAGS = 5;

    /**
     * Clears the field "COMPILER_FLAGS".
     *
     * The field will be set to its default value. The hasCOMPILER_FLAGS()
     * method will return false.
     */
    inline void clearCOMPILER_FLAGS();

    /**
     * Checks whether the field "COMPILER_FLAGS" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCOMPILER_FLAGS()). Otherwise it will return false.
     */
    inline bool hasCOMPILER_FLAGS () const;

    /**
     * Returns the value of the member "COMPILER_FLAGS".
     *
     * If the meaning of "COMPILER_FLAGS" isn't clear, then there should be a description here.
     *
     * @return The value of the field "COMPILER_FLAGS"
     */
    inline const ::std::string& getCOMPILER_FLAGS () const;

    /**
     * Retrieves the value of the field "COMPILER_FLAGS" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "COMPILER_FLAGS".
     */
    inline ::std::string& getCOMPILER_FLAGSMutable ();

    /**
     * Sets the value of the member "COMPILER_FLAGS".
     *
     * If the meaning of "COMPILER_FLAGS" isn't clear, then there should be a description here.
     *
     * @param COMPILER_FLAGS The value which will be set
     */
    inline void setCOMPILER_FLAGS (const ::std::string& COMPILER_FLAGS_);

    /**
     * Sets the value of the member "COMPILER_FLAGS".
     *
     * If the meaning of "COMPILER_FLAGS" isn't clear, then there should be a description here.
     *
     * @param COMPILER_FLAGS The value which will be set
     */
    inline void setCOMPILER_FLAGS (const char* COMPILER_FLAGS_);

    /**
     * Sets the value of the member "COMPILER_FLAGS".
     *
     * If the meaning of "COMPILER_FLAGS" isn't clear, then there should be a description here.
     *
     * @param COMPILER_FLAGS The value which will be set
     */
    inline void setCOMPILER_FLAGS (const char* value, size_t size);

    /**
     * Release the object stored in the field "COMPILER_FLAGS".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "COMPILER_FLAGS"
     */
    inline ::std::string* releaseCOMPILER_FLAGS();

    /**
     * Replace the field "COMPILER_FLAGS".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCOMPILER_FLAGS (::std::string* COMPILER_FLAGS_);

    // API of field "CMAKE_EXE_LINKER_FLAGS"

    static const int kCMAKE_EXE_LINKER_FLAGS = 6;

    /**
     * Clears the field "CMAKE_EXE_LINKER_FLAGS".
     *
     * The field will be set to its default value. The hasCMAKE_EXE_LINKER_FLAGS()
     * method will return false.
     */
    inline void clearCMAKE_EXE_LINKER_FLAGS();

    /**
     * Checks whether the field "CMAKE_EXE_LINKER_FLAGS" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCMAKE_EXE_LINKER_FLAGS()). Otherwise it will return false.
     */
    inline bool hasCMAKE_EXE_LINKER_FLAGS () const;

    /**
     * Returns the value of the member "CMAKE_EXE_LINKER_FLAGS".
     *
     * If the meaning of "CMAKE_EXE_LINKER_FLAGS" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CMAKE_EXE_LINKER_FLAGS"
     */
    inline const ::std::string& getCMAKE_EXE_LINKER_FLAGS () const;

    /**
     * Retrieves the value of the field "CMAKE_EXE_LINKER_FLAGS" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CMAKE_EXE_LINKER_FLAGS".
     */
    inline ::std::string& getCMAKE_EXE_LINKER_FLAGSMutable ();

    /**
     * Sets the value of the member "CMAKE_EXE_LINKER_FLAGS".
     *
     * If the meaning of "CMAKE_EXE_LINKER_FLAGS" isn't clear, then there should be a description here.
     *
     * @param CMAKE_EXE_LINKER_FLAGS The value which will be set
     */
    inline void setCMAKE_EXE_LINKER_FLAGS (const ::std::string& CMAKE_EXE_LINKER_FLAGS_);

    /**
     * Sets the value of the member "CMAKE_EXE_LINKER_FLAGS".
     *
     * If the meaning of "CMAKE_EXE_LINKER_FLAGS" isn't clear, then there should be a description here.
     *
     * @param CMAKE_EXE_LINKER_FLAGS The value which will be set
     */
    inline void setCMAKE_EXE_LINKER_FLAGS (const char* CMAKE_EXE_LINKER_FLAGS_);

    /**
     * Sets the value of the member "CMAKE_EXE_LINKER_FLAGS".
     *
     * If the meaning of "CMAKE_EXE_LINKER_FLAGS" isn't clear, then there should be a description here.
     *
     * @param CMAKE_EXE_LINKER_FLAGS The value which will be set
     */
    inline void setCMAKE_EXE_LINKER_FLAGS (const char* value, size_t size);

    /**
     * Release the object stored in the field "CMAKE_EXE_LINKER_FLAGS".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "CMAKE_EXE_LINKER_FLAGS"
     */
    inline ::std::string* releaseCMAKE_EXE_LINKER_FLAGS();

    /**
     * Replace the field "CMAKE_EXE_LINKER_FLAGS".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCMAKE_EXE_LINKER_FLAGS (::std::string* CMAKE_EXE_LINKER_FLAGS_);

    // API of field "CMAKE_SHARED_LINKER_FLAGS"

    static const int kCMAKE_SHARED_LINKER_FLAGS = 7;

    /**
     * Clears the field "CMAKE_SHARED_LINKER_FLAGS".
     *
     * The field will be set to its default value. The hasCMAKE_SHARED_LINKER_FLAGS()
     * method will return false.
     */
    inline void clearCMAKE_SHARED_LINKER_FLAGS();

    /**
     * Checks whether the field "CMAKE_SHARED_LINKER_FLAGS" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCMAKE_SHARED_LINKER_FLAGS()). Otherwise it will return false.
     */
    inline bool hasCMAKE_SHARED_LINKER_FLAGS () const;

    /**
     * Returns the value of the member "CMAKE_SHARED_LINKER_FLAGS".
     *
     * If the meaning of "CMAKE_SHARED_LINKER_FLAGS" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CMAKE_SHARED_LINKER_FLAGS"
     */
    inline const ::std::string& getCMAKE_SHARED_LINKER_FLAGS () const;

    /**
     * Retrieves the value of the field "CMAKE_SHARED_LINKER_FLAGS" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CMAKE_SHARED_LINKER_FLAGS".
     */
    inline ::std::string& getCMAKE_SHARED_LINKER_FLAGSMutable ();

    /**
     * Sets the value of the member "CMAKE_SHARED_LINKER_FLAGS".
     *
     * If the meaning of "CMAKE_SHARED_LINKER_FLAGS" isn't clear, then there should be a description here.
     *
     * @param CMAKE_SHARED_LINKER_FLAGS The value which will be set
     */
    inline void setCMAKE_SHARED_LINKER_FLAGS (const ::std::string& CMAKE_SHARED_LINKER_FLAGS_);

    /**
     * Sets the value of the member "CMAKE_SHARED_LINKER_FLAGS".
     *
     * If the meaning of "CMAKE_SHARED_LINKER_FLAGS" isn't clear, then there should be a description here.
     *
     * @param CMAKE_SHARED_LINKER_FLAGS The value which will be set
     */
    inline void setCMAKE_SHARED_LINKER_FLAGS (const char* CMAKE_SHARED_LINKER_FLAGS_);

    /**
     * Sets the value of the member "CMAKE_SHARED_LINKER_FLAGS".
     *
     * If the meaning of "CMAKE_SHARED_LINKER_FLAGS" isn't clear, then there should be a description here.
     *
     * @param CMAKE_SHARED_LINKER_FLAGS The value which will be set
     */
    inline void setCMAKE_SHARED_LINKER_FLAGS (const char* value, size_t size);

    /**
     * Release the object stored in the field "CMAKE_SHARED_LINKER_FLAGS".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "CMAKE_SHARED_LINKER_FLAGS"
     */
    inline ::std::string* releaseCMAKE_SHARED_LINKER_FLAGS();

    /**
     * Replace the field "CMAKE_SHARED_LINKER_FLAGS".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCMAKE_SHARED_LINKER_FLAGS (::std::string* CMAKE_SHARED_LINKER_FLAGS_);

    // API of field "CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS"

    static const int kCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS = 8;

    /**
     * Clears the field "CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS".
     *
     * The field will be set to its default value. The hasCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS()
     * method will return false.
     */
    inline void clearCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS();

    /**
     * Checks whether the field "CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS()). Otherwise it will return false.
     */
    inline bool hasCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS () const;

    /**
     * Returns the value of the member "CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS".
     *
     * If the meaning of "CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS"
     */
    inline const ::std::string& getCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS () const;

    /**
     * Retrieves the value of the field "CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS".
     */
    inline ::std::string& getCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGSMutable ();

    /**
     * Sets the value of the member "CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS".
     *
     * If the meaning of "CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS" isn't clear, then there should be a description here.
     *
     * @param CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS The value which will be set
     */
    inline void setCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS (const ::std::string& CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS_);

    /**
     * Sets the value of the member "CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS".
     *
     * If the meaning of "CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS" isn't clear, then there should be a description here.
     *
     * @param CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS The value which will be set
     */
    inline void setCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS (const char* CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS_);

    /**
     * Sets the value of the member "CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS".
     *
     * If the meaning of "CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS" isn't clear, then there should be a description here.
     *
     * @param CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS The value which will be set
     */
    inline void setCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS (const char* value, size_t size);

    /**
     * Release the object stored in the field "CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS"
     */
    inline ::std::string* releaseCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS();

    /**
     * Replace the field "CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS (::std::string* CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS_);

    // API of field "CMAKE_TOOLCHAIN_FILE"

    static const int kCMAKE_TOOLCHAIN_FILE = 9;

    /**
     * Clears the field "CMAKE_TOOLCHAIN_FILE".
     *
     * The field will be set to its default value. The hasCMAKE_TOOLCHAIN_FILE()
     * method will return false.
     */
    inline void clearCMAKE_TOOLCHAIN_FILE();

    /**
     * Checks whether the field "CMAKE_TOOLCHAIN_FILE" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCMAKE_TOOLCHAIN_FILE()). Otherwise it will return false.
     */
    inline bool hasCMAKE_TOOLCHAIN_FILE () const;

    /**
     * Returns the value of the member "CMAKE_TOOLCHAIN_FILE".
     *
     * If the meaning of "CMAKE_TOOLCHAIN_FILE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CMAKE_TOOLCHAIN_FILE"
     */
    inline const ::std::string& getCMAKE_TOOLCHAIN_FILE () const;

    /**
     * Retrieves the value of the field "CMAKE_TOOLCHAIN_FILE" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CMAKE_TOOLCHAIN_FILE".
     */
    inline ::std::string& getCMAKE_TOOLCHAIN_FILEMutable ();

    /**
     * Sets the value of the member "CMAKE_TOOLCHAIN_FILE".
     *
     * If the meaning of "CMAKE_TOOLCHAIN_FILE" isn't clear, then there should be a description here.
     *
     * @param CMAKE_TOOLCHAIN_FILE The value which will be set
     */
    inline void setCMAKE_TOOLCHAIN_FILE (const ::std::string& CMAKE_TOOLCHAIN_FILE_);

    /**
     * Sets the value of the member "CMAKE_TOOLCHAIN_FILE".
     *
     * If the meaning of "CMAKE_TOOLCHAIN_FILE" isn't clear, then there should be a description here.
     *
     * @param CMAKE_TOOLCHAIN_FILE The value which will be set
     */
    inline void setCMAKE_TOOLCHAIN_FILE (const char* CMAKE_TOOLCHAIN_FILE_);

    /**
     * Sets the value of the member "CMAKE_TOOLCHAIN_FILE".
     *
     * If the meaning of "CMAKE_TOOLCHAIN_FILE" isn't clear, then there should be a description here.
     *
     * @param CMAKE_TOOLCHAIN_FILE The value which will be set
     */
    inline void setCMAKE_TOOLCHAIN_FILE (const char* value, size_t size);

    /**
     * Release the object stored in the field "CMAKE_TOOLCHAIN_FILE".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "CMAKE_TOOLCHAIN_FILE"
     */
    inline ::std::string* releaseCMAKE_TOOLCHAIN_FILE();

    /**
     * Replace the field "CMAKE_TOOLCHAIN_FILE".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCMAKE_TOOLCHAIN_FILE (::std::string* CMAKE_TOOLCHAIN_FILE_);

    static const BuildInfo_CMakeInfo &getDefaultInstance();

private:

    inline void set_has_CMAKE_BINARY_DIR ();

    inline void clear_has_CMAKE_BINARY_DIR ();

    inline void set_has_CMAKE_SOURCE_DIR ();

    inline void clear_has_CMAKE_SOURCE_DIR ();

    inline void set_has_CMAKE_VERSION ();

    inline void clear_has_CMAKE_VERSION ();

    inline void set_has_BUILD_VARIANT ();

    inline void clear_has_BUILD_VARIANT ();

    inline void set_has_COMPILER ();

    inline void clear_has_COMPILER ();

    inline void set_has_COMPILER_FLAGS ();

    inline void clear_has_COMPILER_FLAGS ();

    inline void set_has_CMAKE_EXE_LINKER_FLAGS ();

    inline void clear_has_CMAKE_EXE_LINKER_FLAGS ();

    inline void set_has_CMAKE_SHARED_LINKER_FLAGS ();

    inline void clear_has_CMAKE_SHARED_LINKER_FLAGS ();

    inline void set_has_CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS ();

    inline void clear_has_CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS ();

    inline void set_has_CMAKE_TOOLCHAIN_FILE ();

    inline void clear_has_CMAKE_TOOLCHAIN_FILE ();

    uint32 _has_bits_[ (10 + 31) / 32];

    ::std::string* _CMAKE_BINARY_DIR;

    ::std::string* _CMAKE_SOURCE_DIR;

    ::std::string* _CMAKE_VERSION;

    ::std::string* _BUILD_VARIANT;

    ::std::string* _COMPILER;

    ::std::string* _COMPILER_FLAGS;

    ::std::string* _CMAKE_EXE_LINKER_FLAGS;

    ::std::string* _CMAKE_SHARED_LINKER_FLAGS;

    ::std::string* _CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS;

    ::std::string* _CMAKE_TOOLCHAIN_FILE;

};

/**
 * If the meaning of "GitInfo" isn't clear, then there should be a description here.
 */
class BuildInfo_GitInfo {
public:

    /**
     * Default constructor
     */
    inline  BuildInfo_GitInfo ();

    /**
     * Copy constructor
     */
    inline  BuildInfo_GitInfo (const BuildInfo_GitInfo &rhs);

    /**
     * All fields constructor
     */
    inline  BuildInfo_GitInfo (const ::std::string& remoteRepo_, const ::std::string& branchName_, const ::std::string& commitId_, bool isDirty_);

    /**
     * Destructor
     */
    inline  ~BuildInfo_GitInfo();

    /**
     * Assignment operator
     */
    inline BuildInfo_GitInfo& operator = (const BuildInfo_GitInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BuildInfo_GitInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BuildInfo_GitInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BuildInfo_GitInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BuildInfo_GitInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "remoteRepo"

    static const int kRemoteRepo = 0;

    /**
     * Clears the field "remoteRepo".
     *
     * The field will be set to its default value. The hasRemoteRepo()
     * method will return false.
     */
    inline void clearRemoteRepo();

    /**
     * Checks whether the field "remoteRepo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRemoteRepo()). Otherwise it will return false.
     */
    inline bool hasRemoteRepo () const;

    /**
     * Returns the value of the member "remoteRepo".
     *
     * If the meaning of "remoteRepo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "remoteRepo"
     */
    inline const ::std::string& getRemoteRepo () const;

    /**
     * Retrieves the value of the field "remoteRepo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "remoteRepo".
     */
    inline ::std::string& getRemoteRepoMutable ();

    /**
     * Sets the value of the member "remoteRepo".
     *
     * If the meaning of "remoteRepo" isn't clear, then there should be a description here.
     *
     * @param remoteRepo The value which will be set
     */
    inline void setRemoteRepo (const ::std::string& remoteRepo_);

    /**
     * Sets the value of the member "remoteRepo".
     *
     * If the meaning of "remoteRepo" isn't clear, then there should be a description here.
     *
     * @param remoteRepo The value which will be set
     */
    inline void setRemoteRepo (const char* remoteRepo_);

    /**
     * Sets the value of the member "remoteRepo".
     *
     * If the meaning of "remoteRepo" isn't clear, then there should be a description here.
     *
     * @param remoteRepo The value which will be set
     */
    inline void setRemoteRepo (const char* value, size_t size);

    /**
     * Release the object stored in the field "remoteRepo".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "remoteRepo"
     */
    inline ::std::string* releaseRemoteRepo();

    /**
     * Replace the field "remoteRepo".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceRemoteRepo (::std::string* remoteRepo_);

    // API of field "branchName"

    static const int kBranchName = 1;

    /**
     * Clears the field "branchName".
     *
     * The field will be set to its default value. The hasBranchName()
     * method will return false.
     */
    inline void clearBranchName();

    /**
     * Checks whether the field "branchName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBranchName()). Otherwise it will return false.
     */
    inline bool hasBranchName () const;

    /**
     * Returns the value of the member "branchName".
     *
     * If the meaning of "branchName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "branchName"
     */
    inline const ::std::string& getBranchName () const;

    /**
     * Retrieves the value of the field "branchName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "branchName".
     */
    inline ::std::string& getBranchNameMutable ();

    /**
     * Sets the value of the member "branchName".
     *
     * If the meaning of "branchName" isn't clear, then there should be a description here.
     *
     * @param branchName The value which will be set
     */
    inline void setBranchName (const ::std::string& branchName_);

    /**
     * Sets the value of the member "branchName".
     *
     * If the meaning of "branchName" isn't clear, then there should be a description here.
     *
     * @param branchName The value which will be set
     */
    inline void setBranchName (const char* branchName_);

    /**
     * Sets the value of the member "branchName".
     *
     * If the meaning of "branchName" isn't clear, then there should be a description here.
     *
     * @param branchName The value which will be set
     */
    inline void setBranchName (const char* value, size_t size);

    /**
     * Release the object stored in the field "branchName".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "branchName"
     */
    inline ::std::string* releaseBranchName();

    /**
     * Replace the field "branchName".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceBranchName (::std::string* branchName_);

    // API of field "commitId"

    static const int kCommitId = 2;

    /**
     * Clears the field "commitId".
     *
     * The field will be set to its default value. The hasCommitId()
     * method will return false.
     */
    inline void clearCommitId();

    /**
     * Checks whether the field "commitId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCommitId()). Otherwise it will return false.
     */
    inline bool hasCommitId () const;

    /**
     * Returns the value of the member "commitId".
     *
     * If the meaning of "commitId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "commitId"
     */
    inline const ::std::string& getCommitId () const;

    /**
     * Retrieves the value of the field "commitId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "commitId".
     */
    inline ::std::string& getCommitIdMutable ();

    /**
     * Sets the value of the member "commitId".
     *
     * If the meaning of "commitId" isn't clear, then there should be a description here.
     *
     * @param commitId The value which will be set
     */
    inline void setCommitId (const ::std::string& commitId_);

    /**
     * Sets the value of the member "commitId".
     *
     * If the meaning of "commitId" isn't clear, then there should be a description here.
     *
     * @param commitId The value which will be set
     */
    inline void setCommitId (const char* commitId_);

    /**
     * Sets the value of the member "commitId".
     *
     * If the meaning of "commitId" isn't clear, then there should be a description here.
     *
     * @param commitId The value which will be set
     */
    inline void setCommitId (const char* value, size_t size);

    /**
     * Release the object stored in the field "commitId".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "commitId"
     */
    inline ::std::string* releaseCommitId();

    /**
     * Replace the field "commitId".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCommitId (::std::string* commitId_);

    // API of field "isDirty"

    static const int kIsDirty = 3;

    /**
     * Clears the field "isDirty".
     *
     * The field will be set to its default value. The hasIsDirty()
     * method will return false.
     */
    inline void clearIsDirty();

    /**
     * Checks whether the field "isDirty" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsDirty()). Otherwise it will return false.
     */
    inline bool hasIsDirty () const;

    /**
     * Returns the value of the member "isDirty".
     *
     * If the meaning of "isDirty" isn't clear, then there should be a description here.
     *
     * @return The value of the field "isDirty"
     */
    inline bool getIsDirty () const;

    /**
     * Sets the value of the member "isDirty".
     *
     * If the meaning of "isDirty" isn't clear, then there should be a description here.
     *
     * @param isDirty The value which will be set
     */
    inline void setIsDirty (bool isDirty_);

    static const BuildInfo_GitInfo &getDefaultInstance();

private:

    inline void set_has_remoteRepo ();

    inline void clear_has_remoteRepo ();

    inline void set_has_branchName ();

    inline void clear_has_branchName ();

    inline void set_has_commitId ();

    inline void clear_has_commitId ();

    inline void set_has_isDirty ();

    inline void clear_has_isDirty ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string* _remoteRepo;

    ::std::string* _branchName;

    ::std::string* _commitId;

    bool _isDirty;

};

/**
 * If the meaning of "HostInfo" isn't clear, then there should be a description here.
 */
class BuildInfo_HostInfo {
public:

    /**
     * Default constructor
     */
    inline  BuildInfo_HostInfo ();

    /**
     * Copy constructor
     */
    inline  BuildInfo_HostInfo (const BuildInfo_HostInfo &rhs);

    /**
     * All fields constructor
     */
    inline  BuildInfo_HostInfo (const ::std::string& host_, const ::std::string& uname_, const ::std::string& userName_, const ::std::string& timeStamp_);

    /**
     * Destructor
     */
    inline  ~BuildInfo_HostInfo();

    /**
     * Assignment operator
     */
    inline BuildInfo_HostInfo& operator = (const BuildInfo_HostInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BuildInfo_HostInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BuildInfo_HostInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BuildInfo_HostInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BuildInfo_HostInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "host"

    static const int kHost = 0;

    /**
     * Clears the field "host".
     *
     * The field will be set to its default value. The hasHost()
     * method will return false.
     */
    inline void clearHost();

    /**
     * Checks whether the field "host" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHost()). Otherwise it will return false.
     */
    inline bool hasHost () const;

    /**
     * Returns the value of the member "host".
     *
     * If the meaning of "host" isn't clear, then there should be a description here.
     *
     * @return The value of the field "host"
     */
    inline const ::std::string& getHost () const;

    /**
     * Retrieves the value of the field "host" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "host".
     */
    inline ::std::string& getHostMutable ();

    /**
     * Sets the value of the member "host".
     *
     * If the meaning of "host" isn't clear, then there should be a description here.
     *
     * @param host The value which will be set
     */
    inline void setHost (const ::std::string& host_);

    /**
     * Sets the value of the member "host".
     *
     * If the meaning of "host" isn't clear, then there should be a description here.
     *
     * @param host The value which will be set
     */
    inline void setHost (const char* host_);

    /**
     * Sets the value of the member "host".
     *
     * If the meaning of "host" isn't clear, then there should be a description here.
     *
     * @param host The value which will be set
     */
    inline void setHost (const char* value, size_t size);

    /**
     * Release the object stored in the field "host".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "host"
     */
    inline ::std::string* releaseHost();

    /**
     * Replace the field "host".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceHost (::std::string* host_);

    // API of field "uname"

    static const int kUname = 1;

    /**
     * Clears the field "uname".
     *
     * The field will be set to its default value. The hasUname()
     * method will return false.
     */
    inline void clearUname();

    /**
     * Checks whether the field "uname" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUname()). Otherwise it will return false.
     */
    inline bool hasUname () const;

    /**
     * Returns the value of the member "uname".
     *
     * If the meaning of "uname" isn't clear, then there should be a description here.
     *
     * @return The value of the field "uname"
     */
    inline const ::std::string& getUname () const;

    /**
     * Retrieves the value of the field "uname" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "uname".
     */
    inline ::std::string& getUnameMutable ();

    /**
     * Sets the value of the member "uname".
     *
     * If the meaning of "uname" isn't clear, then there should be a description here.
     *
     * @param uname The value which will be set
     */
    inline void setUname (const ::std::string& uname_);

    /**
     * Sets the value of the member "uname".
     *
     * If the meaning of "uname" isn't clear, then there should be a description here.
     *
     * @param uname The value which will be set
     */
    inline void setUname (const char* uname_);

    /**
     * Sets the value of the member "uname".
     *
     * If the meaning of "uname" isn't clear, then there should be a description here.
     *
     * @param uname The value which will be set
     */
    inline void setUname (const char* value, size_t size);

    /**
     * Release the object stored in the field "uname".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "uname"
     */
    inline ::std::string* releaseUname();

    /**
     * Replace the field "uname".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceUname (::std::string* uname_);

    // API of field "userName"

    static const int kUserName = 2;

    /**
     * Clears the field "userName".
     *
     * The field will be set to its default value. The hasUserName()
     * method will return false.
     */
    inline void clearUserName();

    /**
     * Checks whether the field "userName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUserName()). Otherwise it will return false.
     */
    inline bool hasUserName () const;

    /**
     * Returns the value of the member "userName".
     *
     * If the meaning of "userName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "userName"
     */
    inline const ::std::string& getUserName () const;

    /**
     * Retrieves the value of the field "userName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "userName".
     */
    inline ::std::string& getUserNameMutable ();

    /**
     * Sets the value of the member "userName".
     *
     * If the meaning of "userName" isn't clear, then there should be a description here.
     *
     * @param userName The value which will be set
     */
    inline void setUserName (const ::std::string& userName_);

    /**
     * Sets the value of the member "userName".
     *
     * If the meaning of "userName" isn't clear, then there should be a description here.
     *
     * @param userName The value which will be set
     */
    inline void setUserName (const char* userName_);

    /**
     * Sets the value of the member "userName".
     *
     * If the meaning of "userName" isn't clear, then there should be a description here.
     *
     * @param userName The value which will be set
     */
    inline void setUserName (const char* value, size_t size);

    /**
     * Release the object stored in the field "userName".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "userName"
     */
    inline ::std::string* releaseUserName();

    /**
     * Replace the field "userName".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceUserName (::std::string* userName_);

    // API of field "timeStamp"

    static const int kTimeStamp = 3;

    /**
     * Clears the field "timeStamp".
     *
     * The field will be set to its default value. The hasTimeStamp()
     * method will return false.
     */
    inline void clearTimeStamp();

    /**
     * Checks whether the field "timeStamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTimeStamp()). Otherwise it will return false.
     */
    inline bool hasTimeStamp () const;

    /**
     * Returns the value of the member "timeStamp".
     *
     * If the meaning of "timeStamp" isn't clear, then there should be a description here.
     *
     * @return The value of the field "timeStamp"
     */
    inline const ::std::string& getTimeStamp () const;

    /**
     * Retrieves the value of the field "timeStamp" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "timeStamp".
     */
    inline ::std::string& getTimeStampMutable ();

    /**
     * Sets the value of the member "timeStamp".
     *
     * If the meaning of "timeStamp" isn't clear, then there should be a description here.
     *
     * @param timeStamp The value which will be set
     */
    inline void setTimeStamp (const ::std::string& timeStamp_);

    /**
     * Sets the value of the member "timeStamp".
     *
     * If the meaning of "timeStamp" isn't clear, then there should be a description here.
     *
     * @param timeStamp The value which will be set
     */
    inline void setTimeStamp (const char* timeStamp_);

    /**
     * Sets the value of the member "timeStamp".
     *
     * If the meaning of "timeStamp" isn't clear, then there should be a description here.
     *
     * @param timeStamp The value which will be set
     */
    inline void setTimeStamp (const char* value, size_t size);

    /**
     * Release the object stored in the field "timeStamp".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "timeStamp"
     */
    inline ::std::string* releaseTimeStamp();

    /**
     * Replace the field "timeStamp".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTimeStamp (::std::string* timeStamp_);

    static const BuildInfo_HostInfo &getDefaultInstance();

private:

    inline void set_has_host ();

    inline void clear_has_host ();

    inline void set_has_uname ();

    inline void clear_has_uname ();

    inline void set_has_userName ();

    inline void clear_has_userName ();

    inline void set_has_timeStamp ();

    inline void clear_has_timeStamp ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string* _host;

    ::std::string* _uname;

    ::std::string* _userName;

    ::std::string* _timeStamp;

};

/**
 * If the meaning of "DockerInfo" isn't clear, then there should be a description here.
 */
class BuildInfo_DockerInfo {
public:

    /**
     * Default constructor
     */
    inline  BuildInfo_DockerInfo ();

    /**
     * Copy constructor
     */
    inline  BuildInfo_DockerInfo (const BuildInfo_DockerInfo &rhs);

    /**
     * All fields constructor
     */
    inline  BuildInfo_DockerInfo (const ::std::string& dockerHost_, const ::std::string& dockerHostUser_, const ::std::string& dockerImage_);

    /**
     * Destructor
     */
    inline  ~BuildInfo_DockerInfo();

    /**
     * Assignment operator
     */
    inline BuildInfo_DockerInfo& operator = (const BuildInfo_DockerInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BuildInfo_DockerInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BuildInfo_DockerInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BuildInfo_DockerInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BuildInfo_DockerInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "dockerHost"

    static const int kDockerHost = 0;

    /**
     * Clears the field "dockerHost".
     *
     * The field will be set to its default value. The hasDockerHost()
     * method will return false.
     */
    inline void clearDockerHost();

    /**
     * Checks whether the field "dockerHost" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDockerHost()). Otherwise it will return false.
     */
    inline bool hasDockerHost () const;

    /**
     * Returns the value of the member "dockerHost".
     *
     * If the meaning of "dockerHost" isn't clear, then there should be a description here.
     *
     * @return The value of the field "dockerHost"
     */
    inline const ::std::string& getDockerHost () const;

    /**
     * Retrieves the value of the field "dockerHost" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "dockerHost".
     */
    inline ::std::string& getDockerHostMutable ();

    /**
     * Sets the value of the member "dockerHost".
     *
     * If the meaning of "dockerHost" isn't clear, then there should be a description here.
     *
     * @param dockerHost The value which will be set
     */
    inline void setDockerHost (const ::std::string& dockerHost_);

    /**
     * Sets the value of the member "dockerHost".
     *
     * If the meaning of "dockerHost" isn't clear, then there should be a description here.
     *
     * @param dockerHost The value which will be set
     */
    inline void setDockerHost (const char* dockerHost_);

    /**
     * Sets the value of the member "dockerHost".
     *
     * If the meaning of "dockerHost" isn't clear, then there should be a description here.
     *
     * @param dockerHost The value which will be set
     */
    inline void setDockerHost (const char* value, size_t size);

    /**
     * Release the object stored in the field "dockerHost".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "dockerHost"
     */
    inline ::std::string* releaseDockerHost();

    /**
     * Replace the field "dockerHost".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceDockerHost (::std::string* dockerHost_);

    // API of field "dockerHostUser"

    static const int kDockerHostUser = 1;

    /**
     * Clears the field "dockerHostUser".
     *
     * The field will be set to its default value. The hasDockerHostUser()
     * method will return false.
     */
    inline void clearDockerHostUser();

    /**
     * Checks whether the field "dockerHostUser" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDockerHostUser()). Otherwise it will return false.
     */
    inline bool hasDockerHostUser () const;

    /**
     * Returns the value of the member "dockerHostUser".
     *
     * If the meaning of "dockerHostUser" isn't clear, then there should be a description here.
     *
     * @return The value of the field "dockerHostUser"
     */
    inline const ::std::string& getDockerHostUser () const;

    /**
     * Retrieves the value of the field "dockerHostUser" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "dockerHostUser".
     */
    inline ::std::string& getDockerHostUserMutable ();

    /**
     * Sets the value of the member "dockerHostUser".
     *
     * If the meaning of "dockerHostUser" isn't clear, then there should be a description here.
     *
     * @param dockerHostUser The value which will be set
     */
    inline void setDockerHostUser (const ::std::string& dockerHostUser_);

    /**
     * Sets the value of the member "dockerHostUser".
     *
     * If the meaning of "dockerHostUser" isn't clear, then there should be a description here.
     *
     * @param dockerHostUser The value which will be set
     */
    inline void setDockerHostUser (const char* dockerHostUser_);

    /**
     * Sets the value of the member "dockerHostUser".
     *
     * If the meaning of "dockerHostUser" isn't clear, then there should be a description here.
     *
     * @param dockerHostUser The value which will be set
     */
    inline void setDockerHostUser (const char* value, size_t size);

    /**
     * Release the object stored in the field "dockerHostUser".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "dockerHostUser"
     */
    inline ::std::string* releaseDockerHostUser();

    /**
     * Replace the field "dockerHostUser".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceDockerHostUser (::std::string* dockerHostUser_);

    // API of field "dockerImage"

    static const int kDockerImage = 2;

    /**
     * Clears the field "dockerImage".
     *
     * The field will be set to its default value. The hasDockerImage()
     * method will return false.
     */
    inline void clearDockerImage();

    /**
     * Checks whether the field "dockerImage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDockerImage()). Otherwise it will return false.
     */
    inline bool hasDockerImage () const;

    /**
     * Returns the value of the member "dockerImage".
     *
     * If the meaning of "dockerImage" isn't clear, then there should be a description here.
     *
     * @return The value of the field "dockerImage"
     */
    inline const ::std::string& getDockerImage () const;

    /**
     * Retrieves the value of the field "dockerImage" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "dockerImage".
     */
    inline ::std::string& getDockerImageMutable ();

    /**
     * Sets the value of the member "dockerImage".
     *
     * If the meaning of "dockerImage" isn't clear, then there should be a description here.
     *
     * @param dockerImage The value which will be set
     */
    inline void setDockerImage (const ::std::string& dockerImage_);

    /**
     * Sets the value of the member "dockerImage".
     *
     * If the meaning of "dockerImage" isn't clear, then there should be a description here.
     *
     * @param dockerImage The value which will be set
     */
    inline void setDockerImage (const char* dockerImage_);

    /**
     * Sets the value of the member "dockerImage".
     *
     * If the meaning of "dockerImage" isn't clear, then there should be a description here.
     *
     * @param dockerImage The value which will be set
     */
    inline void setDockerImage (const char* value, size_t size);

    /**
     * Release the object stored in the field "dockerImage".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "dockerImage"
     */
    inline ::std::string* releaseDockerImage();

    /**
     * Replace the field "dockerImage".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceDockerImage (::std::string* dockerImage_);

    static const BuildInfo_DockerInfo &getDefaultInstance();

private:

    inline void set_has_dockerHost ();

    inline void clear_has_dockerHost ();

    inline void set_has_dockerHostUser ();

    inline void clear_has_dockerHostUser ();

    inline void set_has_dockerImage ();

    inline void clear_has_dockerImage ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string* _dockerHost;

    ::std::string* _dockerHostUser;

    ::std::string* _dockerImage;

};

/**
 * If the meaning of "JenkinsInfo" isn't clear, then there should be a description here.
 */
class BuildInfo_JenkinsInfo {
public:

    /**
     * Default constructor
     */
    inline  BuildInfo_JenkinsInfo ();

    /**
     * Copy constructor
     */
    inline  BuildInfo_JenkinsInfo (const BuildInfo_JenkinsInfo &rhs);

    /**
     * All fields constructor
     */
    inline  BuildInfo_JenkinsInfo (const ::std::string& jenkinsUrl_, const ::std::string& jobName_, const ::std::string& buildNumber_);

    /**
     * Destructor
     */
    inline  ~BuildInfo_JenkinsInfo();

    /**
     * Assignment operator
     */
    inline BuildInfo_JenkinsInfo& operator = (const BuildInfo_JenkinsInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BuildInfo_JenkinsInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BuildInfo_JenkinsInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BuildInfo_JenkinsInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BuildInfo_JenkinsInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jenkinsUrl"

    static const int kJenkinsUrl = 0;

    /**
     * Clears the field "jenkinsUrl".
     *
     * The field will be set to its default value. The hasJenkinsUrl()
     * method will return false.
     */
    inline void clearJenkinsUrl();

    /**
     * Checks whether the field "jenkinsUrl" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJenkinsUrl()). Otherwise it will return false.
     */
    inline bool hasJenkinsUrl () const;

    /**
     * Returns the value of the member "jenkinsUrl".
     *
     * If the meaning of "jenkinsUrl" isn't clear, then there should be a description here.
     *
     * @return The value of the field "jenkinsUrl"
     */
    inline const ::std::string& getJenkinsUrl () const;

    /**
     * Retrieves the value of the field "jenkinsUrl" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jenkinsUrl".
     */
    inline ::std::string& getJenkinsUrlMutable ();

    /**
     * Sets the value of the member "jenkinsUrl".
     *
     * If the meaning of "jenkinsUrl" isn't clear, then there should be a description here.
     *
     * @param jenkinsUrl The value which will be set
     */
    inline void setJenkinsUrl (const ::std::string& jenkinsUrl_);

    /**
     * Sets the value of the member "jenkinsUrl".
     *
     * If the meaning of "jenkinsUrl" isn't clear, then there should be a description here.
     *
     * @param jenkinsUrl The value which will be set
     */
    inline void setJenkinsUrl (const char* jenkinsUrl_);

    /**
     * Sets the value of the member "jenkinsUrl".
     *
     * If the meaning of "jenkinsUrl" isn't clear, then there should be a description here.
     *
     * @param jenkinsUrl The value which will be set
     */
    inline void setJenkinsUrl (const char* value, size_t size);

    /**
     * Release the object stored in the field "jenkinsUrl".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "jenkinsUrl"
     */
    inline ::std::string* releaseJenkinsUrl();

    /**
     * Replace the field "jenkinsUrl".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceJenkinsUrl (::std::string* jenkinsUrl_);

    // API of field "jobName"

    static const int kJobName = 1;

    /**
     * Clears the field "jobName".
     *
     * The field will be set to its default value. The hasJobName()
     * method will return false.
     */
    inline void clearJobName();

    /**
     * Checks whether the field "jobName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJobName()). Otherwise it will return false.
     */
    inline bool hasJobName () const;

    /**
     * Returns the value of the member "jobName".
     *
     * If the meaning of "jobName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "jobName"
     */
    inline const ::std::string& getJobName () const;

    /**
     * Retrieves the value of the field "jobName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jobName".
     */
    inline ::std::string& getJobNameMutable ();

    /**
     * Sets the value of the member "jobName".
     *
     * If the meaning of "jobName" isn't clear, then there should be a description here.
     *
     * @param jobName The value which will be set
     */
    inline void setJobName (const ::std::string& jobName_);

    /**
     * Sets the value of the member "jobName".
     *
     * If the meaning of "jobName" isn't clear, then there should be a description here.
     *
     * @param jobName The value which will be set
     */
    inline void setJobName (const char* jobName_);

    /**
     * Sets the value of the member "jobName".
     *
     * If the meaning of "jobName" isn't clear, then there should be a description here.
     *
     * @param jobName The value which will be set
     */
    inline void setJobName (const char* value, size_t size);

    /**
     * Release the object stored in the field "jobName".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "jobName"
     */
    inline ::std::string* releaseJobName();

    /**
     * Replace the field "jobName".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceJobName (::std::string* jobName_);

    // API of field "buildNumber"

    static const int kBuildNumber = 2;

    /**
     * Clears the field "buildNumber".
     *
     * The field will be set to its default value. The hasBuildNumber()
     * method will return false.
     */
    inline void clearBuildNumber();

    /**
     * Checks whether the field "buildNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBuildNumber()). Otherwise it will return false.
     */
    inline bool hasBuildNumber () const;

    /**
     * Returns the value of the member "buildNumber".
     *
     * If the meaning of "buildNumber" isn't clear, then there should be a description here.
     *
     * @return The value of the field "buildNumber"
     */
    inline const ::std::string& getBuildNumber () const;

    /**
     * Retrieves the value of the field "buildNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "buildNumber".
     */
    inline ::std::string& getBuildNumberMutable ();

    /**
     * Sets the value of the member "buildNumber".
     *
     * If the meaning of "buildNumber" isn't clear, then there should be a description here.
     *
     * @param buildNumber The value which will be set
     */
    inline void setBuildNumber (const ::std::string& buildNumber_);

    /**
     * Sets the value of the member "buildNumber".
     *
     * If the meaning of "buildNumber" isn't clear, then there should be a description here.
     *
     * @param buildNumber The value which will be set
     */
    inline void setBuildNumber (const char* buildNumber_);

    /**
     * Sets the value of the member "buildNumber".
     *
     * If the meaning of "buildNumber" isn't clear, then there should be a description here.
     *
     * @param buildNumber The value which will be set
     */
    inline void setBuildNumber (const char* value, size_t size);

    /**
     * Release the object stored in the field "buildNumber".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "buildNumber"
     */
    inline ::std::string* releaseBuildNumber();

    /**
     * Replace the field "buildNumber".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceBuildNumber (::std::string* buildNumber_);

    static const BuildInfo_JenkinsInfo &getDefaultInstance();

private:

    inline void set_has_jenkinsUrl ();

    inline void clear_has_jenkinsUrl ();

    inline void set_has_jobName ();

    inline void clear_has_jobName ();

    inline void set_has_buildNumber ();

    inline void clear_has_buildNumber ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string* _jenkinsUrl;

    ::std::string* _jobName;

    ::std::string* _buildNumber;

};

/**
 * ASF build information fetched during the build with help of CMake
 */
class BuildInfo {
public:

    typedef BuildInfo_CMakeInfo CMakeInfo;

    typedef BuildInfo_GitInfo GitInfo;

    typedef BuildInfo_HostInfo HostInfo;

    typedef BuildInfo_DockerInfo DockerInfo;

    typedef BuildInfo_JenkinsInfo JenkinsInfo;

    /**
     * Default constructor
     */
    inline  BuildInfo ();

    /**
     * Copy constructor
     */
    inline  BuildInfo (const BuildInfo &rhs);

    /**
     * All fields constructor
     */
    inline  BuildInfo (const BuildInfo_CMakeInfo& cmakeInfo_, const BuildInfo_GitInfo& gitInfo_, const BuildInfo_HostInfo& hostInfo_, const BuildInfo_DockerInfo& dockerInfo_, const BuildInfo_JenkinsInfo& jenkinsInfo_);

    /**
     * Destructor
     */
    inline  ~BuildInfo();

    /**
     * Assignment operator
     */
    inline BuildInfo& operator = (const BuildInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BuildInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BuildInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BuildInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BuildInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "cmakeInfo"

    static const int kCmakeInfo = 0;

    /**
     * Clears the field "cmakeInfo".
     *
     * The field will be set to its default value. The hasCmakeInfo()
     * method will return false.
     */
    inline void clearCmakeInfo();

    /**
     * Checks whether the field "cmakeInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCmakeInfo()). Otherwise it will return false.
     */
    inline bool hasCmakeInfo () const;

    /**
     * Returns the value of the member "cmakeInfo".
     *
     * If the meaning of "cmakeInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "cmakeInfo"
     */
    inline const BuildInfo_CMakeInfo& getCmakeInfo () const;

    /**
     * Retrieves the value of the field "cmakeInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "cmakeInfo".
     */
    inline BuildInfo_CMakeInfo& getCmakeInfoMutable ();

    /**
     * Sets the value of the member "cmakeInfo".
     *
     * If the meaning of "cmakeInfo" isn't clear, then there should be a description here.
     *
     * @param cmakeInfo The value which will be set
     */
    inline void setCmakeInfo (const BuildInfo_CMakeInfo& cmakeInfo_);

    /**
     * Release the object stored in the field "cmakeInfo".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "cmakeInfo"
     */
    inline BuildInfo_CMakeInfo* releaseCmakeInfo();

    /**
     * Replace the field "cmakeInfo".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCmakeInfo (BuildInfo_CMakeInfo* cmakeInfo_);

    // API of field "gitInfo"

    static const int kGitInfo = 1;

    /**
     * Clears the field "gitInfo".
     *
     * The field will be set to its default value. The hasGitInfo()
     * method will return false.
     */
    inline void clearGitInfo();

    /**
     * Checks whether the field "gitInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGitInfo()). Otherwise it will return false.
     */
    inline bool hasGitInfo () const;

    /**
     * Returns the value of the member "gitInfo".
     *
     * If the meaning of "gitInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "gitInfo"
     */
    inline const BuildInfo_GitInfo& getGitInfo () const;

    /**
     * Retrieves the value of the field "gitInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "gitInfo".
     */
    inline BuildInfo_GitInfo& getGitInfoMutable ();

    /**
     * Sets the value of the member "gitInfo".
     *
     * If the meaning of "gitInfo" isn't clear, then there should be a description here.
     *
     * @param gitInfo The value which will be set
     */
    inline void setGitInfo (const BuildInfo_GitInfo& gitInfo_);

    /**
     * Release the object stored in the field "gitInfo".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "gitInfo"
     */
    inline BuildInfo_GitInfo* releaseGitInfo();

    /**
     * Replace the field "gitInfo".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceGitInfo (BuildInfo_GitInfo* gitInfo_);

    // API of field "hostInfo"

    static const int kHostInfo = 2;

    /**
     * Clears the field "hostInfo".
     *
     * The field will be set to its default value. The hasHostInfo()
     * method will return false.
     */
    inline void clearHostInfo();

    /**
     * Checks whether the field "hostInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHostInfo()). Otherwise it will return false.
     */
    inline bool hasHostInfo () const;

    /**
     * Returns the value of the member "hostInfo".
     *
     * If the meaning of "hostInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "hostInfo"
     */
    inline const BuildInfo_HostInfo& getHostInfo () const;

    /**
     * Retrieves the value of the field "hostInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "hostInfo".
     */
    inline BuildInfo_HostInfo& getHostInfoMutable ();

    /**
     * Sets the value of the member "hostInfo".
     *
     * If the meaning of "hostInfo" isn't clear, then there should be a description here.
     *
     * @param hostInfo The value which will be set
     */
    inline void setHostInfo (const BuildInfo_HostInfo& hostInfo_);

    /**
     * Release the object stored in the field "hostInfo".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "hostInfo"
     */
    inline BuildInfo_HostInfo* releaseHostInfo();

    /**
     * Replace the field "hostInfo".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceHostInfo (BuildInfo_HostInfo* hostInfo_);

    // API of field "dockerInfo"

    static const int kDockerInfo = 3;

    /**
     * Clears the field "dockerInfo".
     *
     * The field will be set to its default value. The hasDockerInfo()
     * method will return false.
     */
    inline void clearDockerInfo();

    /**
     * Checks whether the field "dockerInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDockerInfo()). Otherwise it will return false.
     */
    inline bool hasDockerInfo () const;

    /**
     * Returns the value of the member "dockerInfo".
     *
     * If the meaning of "dockerInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "dockerInfo"
     */
    inline const BuildInfo_DockerInfo& getDockerInfo () const;

    /**
     * Retrieves the value of the field "dockerInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "dockerInfo".
     */
    inline BuildInfo_DockerInfo& getDockerInfoMutable ();

    /**
     * Sets the value of the member "dockerInfo".
     *
     * If the meaning of "dockerInfo" isn't clear, then there should be a description here.
     *
     * @param dockerInfo The value which will be set
     */
    inline void setDockerInfo (const BuildInfo_DockerInfo& dockerInfo_);

    /**
     * Release the object stored in the field "dockerInfo".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "dockerInfo"
     */
    inline BuildInfo_DockerInfo* releaseDockerInfo();

    /**
     * Replace the field "dockerInfo".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceDockerInfo (BuildInfo_DockerInfo* dockerInfo_);

    // API of field "jenkinsInfo"

    static const int kJenkinsInfo = 4;

    /**
     * Clears the field "jenkinsInfo".
     *
     * The field will be set to its default value. The hasJenkinsInfo()
     * method will return false.
     */
    inline void clearJenkinsInfo();

    /**
     * Checks whether the field "jenkinsInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJenkinsInfo()). Otherwise it will return false.
     */
    inline bool hasJenkinsInfo () const;

    /**
     * Returns the value of the member "jenkinsInfo".
     *
     * If the meaning of "jenkinsInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "jenkinsInfo"
     */
    inline const BuildInfo_JenkinsInfo& getJenkinsInfo () const;

    /**
     * Retrieves the value of the field "jenkinsInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jenkinsInfo".
     */
    inline BuildInfo_JenkinsInfo& getJenkinsInfoMutable ();

    /**
     * Sets the value of the member "jenkinsInfo".
     *
     * If the meaning of "jenkinsInfo" isn't clear, then there should be a description here.
     *
     * @param jenkinsInfo The value which will be set
     */
    inline void setJenkinsInfo (const BuildInfo_JenkinsInfo& jenkinsInfo_);

    /**
     * Release the object stored in the field "jenkinsInfo".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "jenkinsInfo"
     */
    inline BuildInfo_JenkinsInfo* releaseJenkinsInfo();

    /**
     * Replace the field "jenkinsInfo".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceJenkinsInfo (BuildInfo_JenkinsInfo* jenkinsInfo_);

    static const BuildInfo &getDefaultInstance();

private:

    inline void set_has_cmakeInfo ();

    inline void clear_has_cmakeInfo ();

    inline void set_has_gitInfo ();

    inline void clear_has_gitInfo ();

    inline void set_has_hostInfo ();

    inline void clear_has_hostInfo ();

    inline void set_has_dockerInfo ();

    inline void clear_has_dockerInfo ();

    inline void set_has_jenkinsInfo ();

    inline void clear_has_jenkinsInfo ();

    uint32 _has_bits_[ (5 + 31) / 32];

    BuildInfo_CMakeInfo* _cmakeInfo;

    BuildInfo_GitInfo* _gitInfo;

    BuildInfo_HostInfo* _hostInfo;

    BuildInfo_DockerInfo* _dockerInfo;

    BuildInfo_JenkinsInfo* _jenkinsInfo;

};

/**
 * If the meaning of "LibraryInfo" isn't clear, then there should be a description here.
 */
class LibraryInfo {
public:

    /**
     * Default constructor
     */
    inline  LibraryInfo ();

    /**
     * Copy constructor
     */
    inline  LibraryInfo (const LibraryInfo &rhs);

    /**
     * All fields constructor
     */
    inline  LibraryInfo (const ::std::string& libraryName_, const Version& libraryVersion_, const BuildInfo& buildInfo_);

    /**
     * Destructor
     */
    inline  ~LibraryInfo();

    /**
     * Assignment operator
     */
    inline LibraryInfo& operator = (const LibraryInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LibraryInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LibraryInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LibraryInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LibraryInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "libraryName"

    static const int kLibraryName = 0;

    /**
     * Clears the field "libraryName".
     *
     * The field will be set to its default value. The hasLibraryName()
     * method will return false.
     */
    inline void clearLibraryName();

    /**
     * Checks whether the field "libraryName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLibraryName()). Otherwise it will return false.
     */
    inline bool hasLibraryName () const;

    /**
     * Returns the value of the member "libraryName".
     *
     * If the meaning of "libraryName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "libraryName"
     */
    inline const ::std::string& getLibraryName () const;

    /**
     * Retrieves the value of the field "libraryName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "libraryName".
     */
    inline ::std::string& getLibraryNameMutable ();

    /**
     * Sets the value of the member "libraryName".
     *
     * If the meaning of "libraryName" isn't clear, then there should be a description here.
     *
     * @param libraryName The value which will be set
     */
    inline void setLibraryName (const ::std::string& libraryName_);

    /**
     * Sets the value of the member "libraryName".
     *
     * If the meaning of "libraryName" isn't clear, then there should be a description here.
     *
     * @param libraryName The value which will be set
     */
    inline void setLibraryName (const char* libraryName_);

    /**
     * Sets the value of the member "libraryName".
     *
     * If the meaning of "libraryName" isn't clear, then there should be a description here.
     *
     * @param libraryName The value which will be set
     */
    inline void setLibraryName (const char* value, size_t size);

    /**
     * Release the object stored in the field "libraryName".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "libraryName"
     */
    inline ::std::string* releaseLibraryName();

    /**
     * Replace the field "libraryName".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceLibraryName (::std::string* libraryName_);

    // API of field "libraryVersion"

    static const int kLibraryVersion = 1;

    /**
     * Clears the field "libraryVersion".
     *
     * The field will be set to its default value. The hasLibraryVersion()
     * method will return false.
     */
    inline void clearLibraryVersion();

    /**
     * Checks whether the field "libraryVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLibraryVersion()). Otherwise it will return false.
     */
    inline bool hasLibraryVersion () const;

    /**
     * Returns the value of the member "libraryVersion".
     *
     * If the meaning of "libraryVersion" isn't clear, then there should be a description here.
     *
     * @return The value of the field "libraryVersion"
     */
    inline const Version& getLibraryVersion () const;

    /**
     * Retrieves the value of the field "libraryVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "libraryVersion".
     */
    inline Version& getLibraryVersionMutable ();

    /**
     * Sets the value of the member "libraryVersion".
     *
     * If the meaning of "libraryVersion" isn't clear, then there should be a description here.
     *
     * @param libraryVersion The value which will be set
     */
    inline void setLibraryVersion (const Version& libraryVersion_);

    /**
     * Release the object stored in the field "libraryVersion".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "libraryVersion"
     */
    inline Version* releaseLibraryVersion();

    /**
     * Replace the field "libraryVersion".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceLibraryVersion (Version* libraryVersion_);

    // API of field "buildInfo"

    static const int kBuildInfo = 2;

    /**
     * Clears the field "buildInfo".
     *
     * The field will be set to its default value. The hasBuildInfo()
     * method will return false.
     */
    inline void clearBuildInfo();

    /**
     * Checks whether the field "buildInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBuildInfo()). Otherwise it will return false.
     */
    inline bool hasBuildInfo () const;

    /**
     * Returns the value of the member "buildInfo".
     *
     * If the meaning of "buildInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "buildInfo"
     */
    inline const BuildInfo& getBuildInfo () const;

    /**
     * Retrieves the value of the field "buildInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "buildInfo".
     */
    inline BuildInfo& getBuildInfoMutable ();

    /**
     * Sets the value of the member "buildInfo".
     *
     * If the meaning of "buildInfo" isn't clear, then there should be a description here.
     *
     * @param buildInfo The value which will be set
     */
    inline void setBuildInfo (const BuildInfo& buildInfo_);

    /**
     * Release the object stored in the field "buildInfo".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "buildInfo"
     */
    inline BuildInfo* releaseBuildInfo();

    /**
     * Replace the field "buildInfo".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceBuildInfo (BuildInfo* buildInfo_);

    static const LibraryInfo &getDefaultInstance();

private:

    inline void set_has_libraryName ();

    inline void clear_has_libraryName ();

    inline void set_has_libraryVersion ();

    inline void clear_has_libraryVersion ();

    inline void set_has_buildInfo ();

    inline void clear_has_buildInfo ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string* _libraryName;

    Version* _libraryVersion;

    BuildInfo* _buildInfo;

};

/**
 * The TimerPayload carries the payload of a timer message (see asf/core/Timer.h)
 */
class TimerPayload  : public ::asf::core::Payload {
public:

    typedef TimerPayload_Reason Reason;

    static const Reason Reason__Repeat = TimerPayload_Reason__Repeat;
    static const Reason Reason__Completed = TimerPayload_Reason__Completed;

    static inline const char* Reason_Name(Reason value) {
        return TimerPayload_Reason_Name(value);
    }

    static inline bool Reason_Parse(const char *str, size_t length, Reason &value) {
        return TimerPayload_Reason_Parse(str, length, value);
    }

    static inline bool Reason_IsValid(Reason value) {
        return TimerPayload_Reason_IsValid(value);
    }

    /**
     * Default constructor
     */
    inline  TimerPayload ();

    /**
     * Copy constructor
     */
    inline  TimerPayload (const TimerPayload &rhs);

    /**
     * All fields constructor
     */
    inline  TimerPayload (TimerPayload_Reason reason_, uint32 repeatCount_);

    /**
     * Destructor
     */
    inline virtual  ~TimerPayload();

    /**
     * Assignment operator
     */
    inline TimerPayload& operator = (const TimerPayload& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TimerPayload& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TimerPayload& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TimerPayload& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TimerPayload& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "reason"

    static const int kReason = 0;

    /**
     * Clears the field "reason".
     *
     * The field will be set to its default value. The hasReason()
     * method will return false.
     */
    inline void clearReason();

    /**
     * Checks whether the field "reason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReason()). Otherwise it will return false.
     */
    inline bool hasReason () const;

    /**
     * Returns the value of the member "reason".
     *
     * If the meaning of "reason" isn't clear, then there should be a description here.
     *
     * @return The value of the field "reason"
     */
    inline TimerPayload_Reason getReason () const;

    /**
     * Sets the value of the member "reason".
     *
     * If the meaning of "reason" isn't clear, then there should be a description here.
     *
     * @param reason The value which will be set
     */
    inline void setReason (TimerPayload_Reason reason_);

    // API of field "repeatCount"

    static const int kRepeatCount = 1;

    /**
     * Clears the field "repeatCount".
     *
     * The field will be set to its default value. The hasRepeatCount()
     * method will return false.
     */
    inline void clearRepeatCount();

    /**
     * Checks whether the field "repeatCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRepeatCount()). Otherwise it will return false.
     */
    inline bool hasRepeatCount () const;

    /**
     * Returns the value of the member "repeatCount".
     *
     * The repeatCount signals how often the timer expired since starting
     *
     * @return The value of the field "repeatCount"
     */
    inline uint32 getRepeatCount () const;

    /**
     * Sets the value of the member "repeatCount".
     *
     * The repeatCount signals how often the timer expired since starting
     *
     * @param repeatCount The value which will be set
     */
    inline void setRepeatCount (uint32 repeatCount_);

    static const TimerPayload &getDefaultInstance();

private:

    inline void set_has_reason ();

    inline void clear_has_reason ();

    inline void set_has_repeatCount ();

    inline void clear_has_repeatCount ();

    uint32 _has_bits_[ (2 + 31) / 32];

    TimerPayload_Reason _reason;

    uint32 _repeatCount;

};

inline  Char::Char ()  :
    _char (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Char::Char (const Char &rhs)  :
    _char (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Char::Char (const ::std::string& char_)  :
    _char (new ::std::string(char_))
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (char_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Char::~Char() {
    delete _char;
}

inline Char& Char::operator = (const Char& rhs) {
    if( this != &rhs ) {
        if (rhs.hasChar()) {
            setChar(rhs.getChar());
        } else {
            clearChar();
        }
    }
    return *this;
}

inline bool Char::operator == (const Char& rhs) const {
    return (((!hasChar() && !rhs.hasChar()) || getChar() == rhs.getChar()));
}

inline bool Char::operator != (const Char& rhs) const {
    return ! (*this == rhs);
}

inline bool Char::operator < (const Char& rhs) const {
    if (hasChar() || rhs.hasChar()) {
        if (getChar() < rhs.getChar()) return true;
        if (getChar() > rhs.getChar()) return false;
    }
    return false;
}

inline bool Char::operator > (const Char& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Char::clear() {
    clearChar();
}

inline void Char::clearChar() {
    if (hasChar()) {
         clear_has_char();
        if (_char != NULL) {
            _char->clear();
        }
     }
}

inline bool Char::hasChar () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& Char::getChar () const {
    if (_char == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_char;
}

inline ::std::string& Char::getCharMutable () {
    set_has_char();
    if (_char == NULL) {
        _char = new ::std::string ();
        if (!_char)
            std::abort();
    }
    return *_char;
}

inline void Char::setChar (const ::std::string& char_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (char_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_char();
    if (this->_char == NULL) {
        this->_char = new ::std::string (char_);
        if (!this->_char)
            std::abort();
    } else {
        *this->_char = char_;
    }
}

inline void Char::setChar (const char* char_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (char_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_char();
    if (this->_char == NULL) {
        this->_char = new ::std::string (char_);
        if (!this->_char)
            std::abort();
    } else {
        this->_char->assign(char_);
    }
}

inline void Char::setChar (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_char();
    if (this->_char == NULL) {
        this->_char = new ::std::string (value, size);
        if (!this->_char)
            std::abort();
    } else {
        this->_char->assign(value, size);
    }
}

inline ::std::string* Char::releaseChar() {
    clear_has_char();
    ::std::string* temp = _char;
    this->_char = NULL;
    return temp;
}

inline void Char::replaceChar (::std::string* char_) {
    set_has_char();
    if (this->_char != char_) {
        if (this->_char != NULL) {
            delete this->_char;
        }
        this->_char = char_;
    }
}

inline void Char::set_has_char () {
    _has_bits_[0] |= 1u << 0;
}

inline void Char::clear_has_char () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ServiceStateChange::ServiceStateChange ()  :
    _previousState (::asf::core::ServiceState__Disconnected),
    _currentState (::asf::core::ServiceState__Disconnected)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ServiceStateChange::ServiceStateChange (const ServiceStateChange &rhs)  :
    _previousState (::asf::core::ServiceState__Disconnected),
    _currentState (::asf::core::ServiceState__Disconnected)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ServiceStateChange::ServiceStateChange (ServiceState previousState_, ServiceState currentState_)  :
    _previousState (previousState_),
    _currentState (currentState_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(ServiceState_IsValid(previousState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", previousState_, "ServiceState", "previousState", "ServiceStateChange");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(ServiceState_IsValid(currentState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", currentState_, "ServiceState", "currentState", "ServiceStateChange");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ServiceStateChange::~ServiceStateChange() {
}

inline ServiceStateChange& ServiceStateChange::operator = (const ServiceStateChange& rhs) {
    if( this != &rhs ) {
        if (rhs.hasPreviousState()) {
            setPreviousState(rhs.getPreviousState());
        } else {
            clearPreviousState();
        }
        if (rhs.hasCurrentState()) {
            setCurrentState(rhs.getCurrentState());
        } else {
            clearCurrentState();
        }
    }
    return *this;
}

inline bool ServiceStateChange::operator == (const ServiceStateChange& rhs) const {
    return (((!hasPreviousState() && !rhs.hasPreviousState()) || getPreviousState() == rhs.getPreviousState()) &&
        ((!hasCurrentState() && !rhs.hasCurrentState()) || getCurrentState() == rhs.getCurrentState()));
}

inline bool ServiceStateChange::operator != (const ServiceStateChange& rhs) const {
    return ! (*this == rhs);
}

inline bool ServiceStateChange::operator < (const ServiceStateChange& rhs) const {
    if (hasPreviousState() || rhs.hasPreviousState()) {
        if ((uint32)getPreviousState() < (uint32)rhs.getPreviousState()) return true;
        if ((uint32)getPreviousState() > (uint32)rhs.getPreviousState()) return false;
    }
    if (hasCurrentState() || rhs.hasCurrentState()) {
        if ((uint32)getCurrentState() < (uint32)rhs.getCurrentState()) return true;
        if ((uint32)getCurrentState() > (uint32)rhs.getCurrentState()) return false;
    }
    return false;
}

inline bool ServiceStateChange::operator > (const ServiceStateChange& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ServiceStateChange::clear() {
    clearPreviousState();
    clearCurrentState();
}

inline void ServiceStateChange::clearPreviousState() {
    if (hasPreviousState()) {
         clear_has_previousState();
        _previousState = ::asf::core::ServiceState__Disconnected;
     }
}

inline bool ServiceStateChange::hasPreviousState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ServiceState ServiceStateChange::getPreviousState () const {
    return _previousState;
}

inline void ServiceStateChange::setPreviousState (ServiceState previousState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(ServiceState_IsValid(previousState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", previousState_, "ServiceState", "previousState", "ServiceStateChange");
    }
    set_has_previousState();
    this->_previousState = previousState_;
}

inline void ServiceStateChange::clearCurrentState() {
    if (hasCurrentState()) {
         clear_has_currentState();
        _currentState = ::asf::core::ServiceState__Disconnected;
     }
}

inline bool ServiceStateChange::hasCurrentState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ServiceState ServiceStateChange::getCurrentState () const {
    return _currentState;
}

inline void ServiceStateChange::setCurrentState (ServiceState currentState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(ServiceState_IsValid(currentState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", currentState_, "ServiceState", "currentState", "ServiceStateChange");
    }
    set_has_currentState();
    this->_currentState = currentState_;
}

inline void ServiceStateChange::set_has_previousState () {
    _has_bits_[0] |= 1u << 0;
}

inline void ServiceStateChange::clear_has_previousState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ServiceStateChange::set_has_currentState () {
    _has_bits_[0] |= 1u << 1;
}

inline void ServiceStateChange::clear_has_currentState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  Version::Version ()  :
    _major (0u),
    _minor (0u),
    _patch (0u),
    _qualifier (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Version::Version (const Version &rhs)  :
    _major (0u),
    _minor (0u),
    _patch (0u),
    _qualifier (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Version::Version (uint32 major_, uint32 minor_, uint32 patch_, const ::std::string& qualifier_)  :
    _major (major_),
    _minor (minor_),
    _patch (patch_),
    _qualifier (new ::std::string(qualifier_))
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (qualifier_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Version::~Version() {
    delete _qualifier;
}

inline Version& Version::operator = (const Version& rhs) {
    if( this != &rhs ) {
        if (rhs.hasMajor()) {
            setMajor(rhs.getMajor());
        } else {
            clearMajor();
        }
        if (rhs.hasMinor()) {
            setMinor(rhs.getMinor());
        } else {
            clearMinor();
        }
        if (rhs.hasPatch()) {
            setPatch(rhs.getPatch());
        } else {
            clearPatch();
        }
        if (rhs.hasQualifier()) {
            setQualifier(rhs.getQualifier());
        } else {
            clearQualifier();
        }
    }
    return *this;
}

inline bool Version::operator == (const Version& rhs) const {
    return (((!hasMajor() && !rhs.hasMajor()) || getMajor() == rhs.getMajor()) &&
        ((!hasMinor() && !rhs.hasMinor()) || getMinor() == rhs.getMinor()) &&
        ((!hasPatch() && !rhs.hasPatch()) || getPatch() == rhs.getPatch()) &&
        ((!hasQualifier() && !rhs.hasQualifier()) || getQualifier() == rhs.getQualifier()));
}

inline bool Version::operator != (const Version& rhs) const {
    return ! (*this == rhs);
}

inline bool Version::operator < (const Version& rhs) const {
    if (hasMajor() || rhs.hasMajor()) {
        if (getMajor() < rhs.getMajor()) return true;
        if (getMajor() > rhs.getMajor()) return false;
    }
    if (hasMinor() || rhs.hasMinor()) {
        if (getMinor() < rhs.getMinor()) return true;
        if (getMinor() > rhs.getMinor()) return false;
    }
    if (hasPatch() || rhs.hasPatch()) {
        if (getPatch() < rhs.getPatch()) return true;
        if (getPatch() > rhs.getPatch()) return false;
    }
    if (hasQualifier() || rhs.hasQualifier()) {
        if (getQualifier() < rhs.getQualifier()) return true;
        if (getQualifier() > rhs.getQualifier()) return false;
    }
    return false;
}

inline bool Version::operator > (const Version& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Version::clear() {
    clearMajor();
    clearMinor();
    clearPatch();
    clearQualifier();
}

inline void Version::clearMajor() {
    if (hasMajor()) {
         clear_has_major();
        _major = 0u;
     }
}

inline bool Version::hasMajor () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 Version::getMajor () const {
    return _major;
}

inline void Version::setMajor (uint32 major_) {
    set_has_major();
    this->_major = major_;
}

inline void Version::clearMinor() {
    if (hasMinor()) {
         clear_has_minor();
        _minor = 0u;
     }
}

inline bool Version::hasMinor () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 Version::getMinor () const {
    return _minor;
}

inline void Version::setMinor (uint32 minor_) {
    set_has_minor();
    this->_minor = minor_;
}

inline void Version::clearPatch() {
    if (hasPatch()) {
         clear_has_patch();
        _patch = 0u;
     }
}

inline bool Version::hasPatch () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 Version::getPatch () const {
    return _patch;
}

inline void Version::setPatch (uint32 patch_) {
    set_has_patch();
    this->_patch = patch_;
}

inline void Version::clearQualifier() {
    if (hasQualifier()) {
         clear_has_qualifier();
        if (_qualifier != NULL) {
            _qualifier->clear();
        }
     }
}

inline bool Version::hasQualifier () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& Version::getQualifier () const {
    if (_qualifier == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_qualifier;
}

inline ::std::string& Version::getQualifierMutable () {
    set_has_qualifier();
    if (_qualifier == NULL) {
        _qualifier = new ::std::string ();
        if (!_qualifier)
            std::abort();
    }
    return *_qualifier;
}

inline void Version::setQualifier (const ::std::string& qualifier_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (qualifier_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_qualifier();
    if (this->_qualifier == NULL) {
        this->_qualifier = new ::std::string (qualifier_);
        if (!this->_qualifier)
            std::abort();
    } else {
        *this->_qualifier = qualifier_;
    }
}

inline void Version::setQualifier (const char* qualifier_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (qualifier_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_qualifier();
    if (this->_qualifier == NULL) {
        this->_qualifier = new ::std::string (qualifier_);
        if (!this->_qualifier)
            std::abort();
    } else {
        this->_qualifier->assign(qualifier_);
    }
}

inline void Version::setQualifier (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_qualifier();
    if (this->_qualifier == NULL) {
        this->_qualifier = new ::std::string (value, size);
        if (!this->_qualifier)
            std::abort();
    } else {
        this->_qualifier->assign(value, size);
    }
}

inline ::std::string* Version::releaseQualifier() {
    clear_has_qualifier();
    ::std::string* temp = _qualifier;
    this->_qualifier = NULL;
    return temp;
}

inline void Version::replaceQualifier (::std::string* qualifier_) {
    set_has_qualifier();
    if (this->_qualifier != qualifier_) {
        if (this->_qualifier != NULL) {
            delete this->_qualifier;
        }
        this->_qualifier = qualifier_;
    }
}

inline void Version::set_has_major () {
    _has_bits_[0] |= 1u << 0;
}

inline void Version::clear_has_major () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Version::set_has_minor () {
    _has_bits_[0] |= 1u << 1;
}

inline void Version::clear_has_minor () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void Version::set_has_patch () {
    _has_bits_[0] |= 1u << 2;
}

inline void Version::clear_has_patch () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void Version::set_has_qualifier () {
    _has_bits_[0] |= 1u << 3;
}

inline void Version::clear_has_qualifier () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  BuildInfo_CMakeInfo::BuildInfo_CMakeInfo ()  :
    _CMAKE_BINARY_DIR (NULL),
    _CMAKE_SOURCE_DIR (NULL),
    _CMAKE_VERSION (NULL),
    _BUILD_VARIANT (NULL),
    _COMPILER (NULL),
    _COMPILER_FLAGS (NULL),
    _CMAKE_EXE_LINKER_FLAGS (NULL),
    _CMAKE_SHARED_LINKER_FLAGS (NULL),
    _CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS (NULL),
    _CMAKE_TOOLCHAIN_FILE (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BuildInfo_CMakeInfo::BuildInfo_CMakeInfo (const BuildInfo_CMakeInfo &rhs)  :
    _CMAKE_BINARY_DIR (NULL),
    _CMAKE_SOURCE_DIR (NULL),
    _CMAKE_VERSION (NULL),
    _BUILD_VARIANT (NULL),
    _COMPILER (NULL),
    _COMPILER_FLAGS (NULL),
    _CMAKE_EXE_LINKER_FLAGS (NULL),
    _CMAKE_SHARED_LINKER_FLAGS (NULL),
    _CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS (NULL),
    _CMAKE_TOOLCHAIN_FILE (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BuildInfo_CMakeInfo::BuildInfo_CMakeInfo (const ::std::string& CMAKE_BINARY_DIR_, const ::std::string& CMAKE_SOURCE_DIR_, const ::std::string& CMAKE_VERSION_, const ::std::string& BUILD_VARIANT_, const ::std::string& COMPILER_, const ::std::string& COMPILER_FLAGS_, const ::std::string& CMAKE_EXE_LINKER_FLAGS_, const ::std::string& CMAKE_SHARED_LINKER_FLAGS_, const ::std::string& CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS_, const ::std::string& CMAKE_TOOLCHAIN_FILE_)  :
    _CMAKE_BINARY_DIR (new ::std::string(CMAKE_BINARY_DIR_)),
    _CMAKE_SOURCE_DIR (new ::std::string(CMAKE_SOURCE_DIR_)),
    _CMAKE_VERSION (new ::std::string(CMAKE_VERSION_)),
    _BUILD_VARIANT (new ::std::string(BUILD_VARIANT_)),
    _COMPILER (new ::std::string(COMPILER_)),
    _COMPILER_FLAGS (new ::std::string(COMPILER_FLAGS_)),
    _CMAKE_EXE_LINKER_FLAGS (new ::std::string(CMAKE_EXE_LINKER_FLAGS_)),
    _CMAKE_SHARED_LINKER_FLAGS (new ::std::string(CMAKE_SHARED_LINKER_FLAGS_)),
    _CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS (new ::std::string(CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS_)),
    _CMAKE_TOOLCHAIN_FILE (new ::std::string(CMAKE_TOOLCHAIN_FILE_))
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CMAKE_BINARY_DIR_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CMAKE_SOURCE_DIR_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CMAKE_VERSION_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (BUILD_VARIANT_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (COMPILER_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (COMPILER_FLAGS_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CMAKE_EXE_LINKER_FLAGS_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CMAKE_SHARED_LINKER_FLAGS_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CMAKE_TOOLCHAIN_FILE_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BuildInfo_CMakeInfo::~BuildInfo_CMakeInfo() {
    delete _CMAKE_BINARY_DIR;
    delete _CMAKE_SOURCE_DIR;
    delete _CMAKE_VERSION;
    delete _BUILD_VARIANT;
    delete _COMPILER;
    delete _COMPILER_FLAGS;
    delete _CMAKE_EXE_LINKER_FLAGS;
    delete _CMAKE_SHARED_LINKER_FLAGS;
    delete _CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS;
    delete _CMAKE_TOOLCHAIN_FILE;
}

inline BuildInfo_CMakeInfo& BuildInfo_CMakeInfo::operator = (const BuildInfo_CMakeInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasCMAKE_BINARY_DIR()) {
            setCMAKE_BINARY_DIR(rhs.getCMAKE_BINARY_DIR());
        } else {
            clearCMAKE_BINARY_DIR();
        }
        if (rhs.hasCMAKE_SOURCE_DIR()) {
            setCMAKE_SOURCE_DIR(rhs.getCMAKE_SOURCE_DIR());
        } else {
            clearCMAKE_SOURCE_DIR();
        }
        if (rhs.hasCMAKE_VERSION()) {
            setCMAKE_VERSION(rhs.getCMAKE_VERSION());
        } else {
            clearCMAKE_VERSION();
        }
        if (rhs.hasBUILD_VARIANT()) {
            setBUILD_VARIANT(rhs.getBUILD_VARIANT());
        } else {
            clearBUILD_VARIANT();
        }
        if (rhs.hasCOMPILER()) {
            setCOMPILER(rhs.getCOMPILER());
        } else {
            clearCOMPILER();
        }
        if (rhs.hasCOMPILER_FLAGS()) {
            setCOMPILER_FLAGS(rhs.getCOMPILER_FLAGS());
        } else {
            clearCOMPILER_FLAGS();
        }
        if (rhs.hasCMAKE_EXE_LINKER_FLAGS()) {
            setCMAKE_EXE_LINKER_FLAGS(rhs.getCMAKE_EXE_LINKER_FLAGS());
        } else {
            clearCMAKE_EXE_LINKER_FLAGS();
        }
        if (rhs.hasCMAKE_SHARED_LINKER_FLAGS()) {
            setCMAKE_SHARED_LINKER_FLAGS(rhs.getCMAKE_SHARED_LINKER_FLAGS());
        } else {
            clearCMAKE_SHARED_LINKER_FLAGS();
        }
        if (rhs.hasCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS()) {
            setCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS(rhs.getCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS());
        } else {
            clearCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS();
        }
        if (rhs.hasCMAKE_TOOLCHAIN_FILE()) {
            setCMAKE_TOOLCHAIN_FILE(rhs.getCMAKE_TOOLCHAIN_FILE());
        } else {
            clearCMAKE_TOOLCHAIN_FILE();
        }
    }
    return *this;
}

inline bool BuildInfo_CMakeInfo::operator == (const BuildInfo_CMakeInfo& rhs) const {
    return (((!hasCMAKE_BINARY_DIR() && !rhs.hasCMAKE_BINARY_DIR()) || getCMAKE_BINARY_DIR() == rhs.getCMAKE_BINARY_DIR()) &&
        ((!hasCMAKE_SOURCE_DIR() && !rhs.hasCMAKE_SOURCE_DIR()) || getCMAKE_SOURCE_DIR() == rhs.getCMAKE_SOURCE_DIR()) &&
        ((!hasCMAKE_VERSION() && !rhs.hasCMAKE_VERSION()) || getCMAKE_VERSION() == rhs.getCMAKE_VERSION()) &&
        ((!hasBUILD_VARIANT() && !rhs.hasBUILD_VARIANT()) || getBUILD_VARIANT() == rhs.getBUILD_VARIANT()) &&
        ((!hasCOMPILER() && !rhs.hasCOMPILER()) || getCOMPILER() == rhs.getCOMPILER()) &&
        ((!hasCOMPILER_FLAGS() && !rhs.hasCOMPILER_FLAGS()) || getCOMPILER_FLAGS() == rhs.getCOMPILER_FLAGS()) &&
        ((!hasCMAKE_EXE_LINKER_FLAGS() && !rhs.hasCMAKE_EXE_LINKER_FLAGS()) || getCMAKE_EXE_LINKER_FLAGS() == rhs.getCMAKE_EXE_LINKER_FLAGS()) &&
        ((!hasCMAKE_SHARED_LINKER_FLAGS() && !rhs.hasCMAKE_SHARED_LINKER_FLAGS()) || getCMAKE_SHARED_LINKER_FLAGS() == rhs.getCMAKE_SHARED_LINKER_FLAGS()) &&
        ((!hasCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS() && !rhs.hasCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS()) || getCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS() == rhs.getCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS()) &&
        ((!hasCMAKE_TOOLCHAIN_FILE() && !rhs.hasCMAKE_TOOLCHAIN_FILE()) || getCMAKE_TOOLCHAIN_FILE() == rhs.getCMAKE_TOOLCHAIN_FILE()));
}

inline bool BuildInfo_CMakeInfo::operator != (const BuildInfo_CMakeInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool BuildInfo_CMakeInfo::operator < (const BuildInfo_CMakeInfo& rhs) const {
    if (hasCMAKE_BINARY_DIR() || rhs.hasCMAKE_BINARY_DIR()) {
        if (getCMAKE_BINARY_DIR() < rhs.getCMAKE_BINARY_DIR()) return true;
        if (getCMAKE_BINARY_DIR() > rhs.getCMAKE_BINARY_DIR()) return false;
    }
    if (hasCMAKE_SOURCE_DIR() || rhs.hasCMAKE_SOURCE_DIR()) {
        if (getCMAKE_SOURCE_DIR() < rhs.getCMAKE_SOURCE_DIR()) return true;
        if (getCMAKE_SOURCE_DIR() > rhs.getCMAKE_SOURCE_DIR()) return false;
    }
    if (hasCMAKE_VERSION() || rhs.hasCMAKE_VERSION()) {
        if (getCMAKE_VERSION() < rhs.getCMAKE_VERSION()) return true;
        if (getCMAKE_VERSION() > rhs.getCMAKE_VERSION()) return false;
    }
    if (hasBUILD_VARIANT() || rhs.hasBUILD_VARIANT()) {
        if (getBUILD_VARIANT() < rhs.getBUILD_VARIANT()) return true;
        if (getBUILD_VARIANT() > rhs.getBUILD_VARIANT()) return false;
    }
    if (hasCOMPILER() || rhs.hasCOMPILER()) {
        if (getCOMPILER() < rhs.getCOMPILER()) return true;
        if (getCOMPILER() > rhs.getCOMPILER()) return false;
    }
    if (hasCOMPILER_FLAGS() || rhs.hasCOMPILER_FLAGS()) {
        if (getCOMPILER_FLAGS() < rhs.getCOMPILER_FLAGS()) return true;
        if (getCOMPILER_FLAGS() > rhs.getCOMPILER_FLAGS()) return false;
    }
    if (hasCMAKE_EXE_LINKER_FLAGS() || rhs.hasCMAKE_EXE_LINKER_FLAGS()) {
        if (getCMAKE_EXE_LINKER_FLAGS() < rhs.getCMAKE_EXE_LINKER_FLAGS()) return true;
        if (getCMAKE_EXE_LINKER_FLAGS() > rhs.getCMAKE_EXE_LINKER_FLAGS()) return false;
    }
    if (hasCMAKE_SHARED_LINKER_FLAGS() || rhs.hasCMAKE_SHARED_LINKER_FLAGS()) {
        if (getCMAKE_SHARED_LINKER_FLAGS() < rhs.getCMAKE_SHARED_LINKER_FLAGS()) return true;
        if (getCMAKE_SHARED_LINKER_FLAGS() > rhs.getCMAKE_SHARED_LINKER_FLAGS()) return false;
    }
    if (hasCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS() || rhs.hasCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS()) {
        if (getCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS() < rhs.getCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS()) return true;
        if (getCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS() > rhs.getCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS()) return false;
    }
    if (hasCMAKE_TOOLCHAIN_FILE() || rhs.hasCMAKE_TOOLCHAIN_FILE()) {
        if (getCMAKE_TOOLCHAIN_FILE() < rhs.getCMAKE_TOOLCHAIN_FILE()) return true;
        if (getCMAKE_TOOLCHAIN_FILE() > rhs.getCMAKE_TOOLCHAIN_FILE()) return false;
    }
    return false;
}

inline bool BuildInfo_CMakeInfo::operator > (const BuildInfo_CMakeInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BuildInfo_CMakeInfo::clear() {
    clearCMAKE_BINARY_DIR();
    clearCMAKE_SOURCE_DIR();
    clearCMAKE_VERSION();
    clearBUILD_VARIANT();
    clearCOMPILER();
    clearCOMPILER_FLAGS();
    clearCMAKE_EXE_LINKER_FLAGS();
    clearCMAKE_SHARED_LINKER_FLAGS();
    clearCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS();
    clearCMAKE_TOOLCHAIN_FILE();
}

inline void BuildInfo_CMakeInfo::clearCMAKE_BINARY_DIR() {
    if (hasCMAKE_BINARY_DIR()) {
         clear_has_CMAKE_BINARY_DIR();
        if (_CMAKE_BINARY_DIR != NULL) {
            _CMAKE_BINARY_DIR->clear();
        }
     }
}

inline bool BuildInfo_CMakeInfo::hasCMAKE_BINARY_DIR () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& BuildInfo_CMakeInfo::getCMAKE_BINARY_DIR () const {
    if (_CMAKE_BINARY_DIR == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_CMAKE_BINARY_DIR;
}

inline ::std::string& BuildInfo_CMakeInfo::getCMAKE_BINARY_DIRMutable () {
    set_has_CMAKE_BINARY_DIR();
    if (_CMAKE_BINARY_DIR == NULL) {
        _CMAKE_BINARY_DIR = new ::std::string ();
        if (!_CMAKE_BINARY_DIR)
            std::abort();
    }
    return *_CMAKE_BINARY_DIR;
}

inline void BuildInfo_CMakeInfo::setCMAKE_BINARY_DIR (const ::std::string& CMAKE_BINARY_DIR_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CMAKE_BINARY_DIR_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CMAKE_BINARY_DIR();
    if (this->_CMAKE_BINARY_DIR == NULL) {
        this->_CMAKE_BINARY_DIR = new ::std::string (CMAKE_BINARY_DIR_);
        if (!this->_CMAKE_BINARY_DIR)
            std::abort();
    } else {
        *this->_CMAKE_BINARY_DIR = CMAKE_BINARY_DIR_;
    }
}

inline void BuildInfo_CMakeInfo::setCMAKE_BINARY_DIR (const char* CMAKE_BINARY_DIR_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CMAKE_BINARY_DIR_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CMAKE_BINARY_DIR();
    if (this->_CMAKE_BINARY_DIR == NULL) {
        this->_CMAKE_BINARY_DIR = new ::std::string (CMAKE_BINARY_DIR_);
        if (!this->_CMAKE_BINARY_DIR)
            std::abort();
    } else {
        this->_CMAKE_BINARY_DIR->assign(CMAKE_BINARY_DIR_);
    }
}

inline void BuildInfo_CMakeInfo::setCMAKE_BINARY_DIR (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CMAKE_BINARY_DIR();
    if (this->_CMAKE_BINARY_DIR == NULL) {
        this->_CMAKE_BINARY_DIR = new ::std::string (value, size);
        if (!this->_CMAKE_BINARY_DIR)
            std::abort();
    } else {
        this->_CMAKE_BINARY_DIR->assign(value, size);
    }
}

inline ::std::string* BuildInfo_CMakeInfo::releaseCMAKE_BINARY_DIR() {
    clear_has_CMAKE_BINARY_DIR();
    ::std::string* temp = _CMAKE_BINARY_DIR;
    this->_CMAKE_BINARY_DIR = NULL;
    return temp;
}

inline void BuildInfo_CMakeInfo::replaceCMAKE_BINARY_DIR (::std::string* CMAKE_BINARY_DIR_) {
    set_has_CMAKE_BINARY_DIR();
    if (this->_CMAKE_BINARY_DIR != CMAKE_BINARY_DIR_) {
        if (this->_CMAKE_BINARY_DIR != NULL) {
            delete this->_CMAKE_BINARY_DIR;
        }
        this->_CMAKE_BINARY_DIR = CMAKE_BINARY_DIR_;
    }
}

inline void BuildInfo_CMakeInfo::clearCMAKE_SOURCE_DIR() {
    if (hasCMAKE_SOURCE_DIR()) {
         clear_has_CMAKE_SOURCE_DIR();
        if (_CMAKE_SOURCE_DIR != NULL) {
            _CMAKE_SOURCE_DIR->clear();
        }
     }
}

inline bool BuildInfo_CMakeInfo::hasCMAKE_SOURCE_DIR () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& BuildInfo_CMakeInfo::getCMAKE_SOURCE_DIR () const {
    if (_CMAKE_SOURCE_DIR == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_CMAKE_SOURCE_DIR;
}

inline ::std::string& BuildInfo_CMakeInfo::getCMAKE_SOURCE_DIRMutable () {
    set_has_CMAKE_SOURCE_DIR();
    if (_CMAKE_SOURCE_DIR == NULL) {
        _CMAKE_SOURCE_DIR = new ::std::string ();
        if (!_CMAKE_SOURCE_DIR)
            std::abort();
    }
    return *_CMAKE_SOURCE_DIR;
}

inline void BuildInfo_CMakeInfo::setCMAKE_SOURCE_DIR (const ::std::string& CMAKE_SOURCE_DIR_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CMAKE_SOURCE_DIR_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CMAKE_SOURCE_DIR();
    if (this->_CMAKE_SOURCE_DIR == NULL) {
        this->_CMAKE_SOURCE_DIR = new ::std::string (CMAKE_SOURCE_DIR_);
        if (!this->_CMAKE_SOURCE_DIR)
            std::abort();
    } else {
        *this->_CMAKE_SOURCE_DIR = CMAKE_SOURCE_DIR_;
    }
}

inline void BuildInfo_CMakeInfo::setCMAKE_SOURCE_DIR (const char* CMAKE_SOURCE_DIR_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CMAKE_SOURCE_DIR_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CMAKE_SOURCE_DIR();
    if (this->_CMAKE_SOURCE_DIR == NULL) {
        this->_CMAKE_SOURCE_DIR = new ::std::string (CMAKE_SOURCE_DIR_);
        if (!this->_CMAKE_SOURCE_DIR)
            std::abort();
    } else {
        this->_CMAKE_SOURCE_DIR->assign(CMAKE_SOURCE_DIR_);
    }
}

inline void BuildInfo_CMakeInfo::setCMAKE_SOURCE_DIR (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CMAKE_SOURCE_DIR();
    if (this->_CMAKE_SOURCE_DIR == NULL) {
        this->_CMAKE_SOURCE_DIR = new ::std::string (value, size);
        if (!this->_CMAKE_SOURCE_DIR)
            std::abort();
    } else {
        this->_CMAKE_SOURCE_DIR->assign(value, size);
    }
}

inline ::std::string* BuildInfo_CMakeInfo::releaseCMAKE_SOURCE_DIR() {
    clear_has_CMAKE_SOURCE_DIR();
    ::std::string* temp = _CMAKE_SOURCE_DIR;
    this->_CMAKE_SOURCE_DIR = NULL;
    return temp;
}

inline void BuildInfo_CMakeInfo::replaceCMAKE_SOURCE_DIR (::std::string* CMAKE_SOURCE_DIR_) {
    set_has_CMAKE_SOURCE_DIR();
    if (this->_CMAKE_SOURCE_DIR != CMAKE_SOURCE_DIR_) {
        if (this->_CMAKE_SOURCE_DIR != NULL) {
            delete this->_CMAKE_SOURCE_DIR;
        }
        this->_CMAKE_SOURCE_DIR = CMAKE_SOURCE_DIR_;
    }
}

inline void BuildInfo_CMakeInfo::clearCMAKE_VERSION() {
    if (hasCMAKE_VERSION()) {
         clear_has_CMAKE_VERSION();
        if (_CMAKE_VERSION != NULL) {
            _CMAKE_VERSION->clear();
        }
     }
}

inline bool BuildInfo_CMakeInfo::hasCMAKE_VERSION () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& BuildInfo_CMakeInfo::getCMAKE_VERSION () const {
    if (_CMAKE_VERSION == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_CMAKE_VERSION;
}

inline ::std::string& BuildInfo_CMakeInfo::getCMAKE_VERSIONMutable () {
    set_has_CMAKE_VERSION();
    if (_CMAKE_VERSION == NULL) {
        _CMAKE_VERSION = new ::std::string ();
        if (!_CMAKE_VERSION)
            std::abort();
    }
    return *_CMAKE_VERSION;
}

inline void BuildInfo_CMakeInfo::setCMAKE_VERSION (const ::std::string& CMAKE_VERSION_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CMAKE_VERSION_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CMAKE_VERSION();
    if (this->_CMAKE_VERSION == NULL) {
        this->_CMAKE_VERSION = new ::std::string (CMAKE_VERSION_);
        if (!this->_CMAKE_VERSION)
            std::abort();
    } else {
        *this->_CMAKE_VERSION = CMAKE_VERSION_;
    }
}

inline void BuildInfo_CMakeInfo::setCMAKE_VERSION (const char* CMAKE_VERSION_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CMAKE_VERSION_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CMAKE_VERSION();
    if (this->_CMAKE_VERSION == NULL) {
        this->_CMAKE_VERSION = new ::std::string (CMAKE_VERSION_);
        if (!this->_CMAKE_VERSION)
            std::abort();
    } else {
        this->_CMAKE_VERSION->assign(CMAKE_VERSION_);
    }
}

inline void BuildInfo_CMakeInfo::setCMAKE_VERSION (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CMAKE_VERSION();
    if (this->_CMAKE_VERSION == NULL) {
        this->_CMAKE_VERSION = new ::std::string (value, size);
        if (!this->_CMAKE_VERSION)
            std::abort();
    } else {
        this->_CMAKE_VERSION->assign(value, size);
    }
}

inline ::std::string* BuildInfo_CMakeInfo::releaseCMAKE_VERSION() {
    clear_has_CMAKE_VERSION();
    ::std::string* temp = _CMAKE_VERSION;
    this->_CMAKE_VERSION = NULL;
    return temp;
}

inline void BuildInfo_CMakeInfo::replaceCMAKE_VERSION (::std::string* CMAKE_VERSION_) {
    set_has_CMAKE_VERSION();
    if (this->_CMAKE_VERSION != CMAKE_VERSION_) {
        if (this->_CMAKE_VERSION != NULL) {
            delete this->_CMAKE_VERSION;
        }
        this->_CMAKE_VERSION = CMAKE_VERSION_;
    }
}

inline void BuildInfo_CMakeInfo::clearBUILD_VARIANT() {
    if (hasBUILD_VARIANT()) {
         clear_has_BUILD_VARIANT();
        if (_BUILD_VARIANT != NULL) {
            _BUILD_VARIANT->clear();
        }
     }
}

inline bool BuildInfo_CMakeInfo::hasBUILD_VARIANT () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& BuildInfo_CMakeInfo::getBUILD_VARIANT () const {
    if (_BUILD_VARIANT == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_BUILD_VARIANT;
}

inline ::std::string& BuildInfo_CMakeInfo::getBUILD_VARIANTMutable () {
    set_has_BUILD_VARIANT();
    if (_BUILD_VARIANT == NULL) {
        _BUILD_VARIANT = new ::std::string ();
        if (!_BUILD_VARIANT)
            std::abort();
    }
    return *_BUILD_VARIANT;
}

inline void BuildInfo_CMakeInfo::setBUILD_VARIANT (const ::std::string& BUILD_VARIANT_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (BUILD_VARIANT_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_BUILD_VARIANT();
    if (this->_BUILD_VARIANT == NULL) {
        this->_BUILD_VARIANT = new ::std::string (BUILD_VARIANT_);
        if (!this->_BUILD_VARIANT)
            std::abort();
    } else {
        *this->_BUILD_VARIANT = BUILD_VARIANT_;
    }
}

inline void BuildInfo_CMakeInfo::setBUILD_VARIANT (const char* BUILD_VARIANT_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (BUILD_VARIANT_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_BUILD_VARIANT();
    if (this->_BUILD_VARIANT == NULL) {
        this->_BUILD_VARIANT = new ::std::string (BUILD_VARIANT_);
        if (!this->_BUILD_VARIANT)
            std::abort();
    } else {
        this->_BUILD_VARIANT->assign(BUILD_VARIANT_);
    }
}

inline void BuildInfo_CMakeInfo::setBUILD_VARIANT (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_BUILD_VARIANT();
    if (this->_BUILD_VARIANT == NULL) {
        this->_BUILD_VARIANT = new ::std::string (value, size);
        if (!this->_BUILD_VARIANT)
            std::abort();
    } else {
        this->_BUILD_VARIANT->assign(value, size);
    }
}

inline ::std::string* BuildInfo_CMakeInfo::releaseBUILD_VARIANT() {
    clear_has_BUILD_VARIANT();
    ::std::string* temp = _BUILD_VARIANT;
    this->_BUILD_VARIANT = NULL;
    return temp;
}

inline void BuildInfo_CMakeInfo::replaceBUILD_VARIANT (::std::string* BUILD_VARIANT_) {
    set_has_BUILD_VARIANT();
    if (this->_BUILD_VARIANT != BUILD_VARIANT_) {
        if (this->_BUILD_VARIANT != NULL) {
            delete this->_BUILD_VARIANT;
        }
        this->_BUILD_VARIANT = BUILD_VARIANT_;
    }
}

inline void BuildInfo_CMakeInfo::clearCOMPILER() {
    if (hasCOMPILER()) {
         clear_has_COMPILER();
        if (_COMPILER != NULL) {
            _COMPILER->clear();
        }
     }
}

inline bool BuildInfo_CMakeInfo::hasCOMPILER () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& BuildInfo_CMakeInfo::getCOMPILER () const {
    if (_COMPILER == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_COMPILER;
}

inline ::std::string& BuildInfo_CMakeInfo::getCOMPILERMutable () {
    set_has_COMPILER();
    if (_COMPILER == NULL) {
        _COMPILER = new ::std::string ();
        if (!_COMPILER)
            std::abort();
    }
    return *_COMPILER;
}

inline void BuildInfo_CMakeInfo::setCOMPILER (const ::std::string& COMPILER_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (COMPILER_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_COMPILER();
    if (this->_COMPILER == NULL) {
        this->_COMPILER = new ::std::string (COMPILER_);
        if (!this->_COMPILER)
            std::abort();
    } else {
        *this->_COMPILER = COMPILER_;
    }
}

inline void BuildInfo_CMakeInfo::setCOMPILER (const char* COMPILER_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (COMPILER_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_COMPILER();
    if (this->_COMPILER == NULL) {
        this->_COMPILER = new ::std::string (COMPILER_);
        if (!this->_COMPILER)
            std::abort();
    } else {
        this->_COMPILER->assign(COMPILER_);
    }
}

inline void BuildInfo_CMakeInfo::setCOMPILER (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_COMPILER();
    if (this->_COMPILER == NULL) {
        this->_COMPILER = new ::std::string (value, size);
        if (!this->_COMPILER)
            std::abort();
    } else {
        this->_COMPILER->assign(value, size);
    }
}

inline ::std::string* BuildInfo_CMakeInfo::releaseCOMPILER() {
    clear_has_COMPILER();
    ::std::string* temp = _COMPILER;
    this->_COMPILER = NULL;
    return temp;
}

inline void BuildInfo_CMakeInfo::replaceCOMPILER (::std::string* COMPILER_) {
    set_has_COMPILER();
    if (this->_COMPILER != COMPILER_) {
        if (this->_COMPILER != NULL) {
            delete this->_COMPILER;
        }
        this->_COMPILER = COMPILER_;
    }
}

inline void BuildInfo_CMakeInfo::clearCOMPILER_FLAGS() {
    if (hasCOMPILER_FLAGS()) {
         clear_has_COMPILER_FLAGS();
        if (_COMPILER_FLAGS != NULL) {
            _COMPILER_FLAGS->clear();
        }
     }
}

inline bool BuildInfo_CMakeInfo::hasCOMPILER_FLAGS () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& BuildInfo_CMakeInfo::getCOMPILER_FLAGS () const {
    if (_COMPILER_FLAGS == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_COMPILER_FLAGS;
}

inline ::std::string& BuildInfo_CMakeInfo::getCOMPILER_FLAGSMutable () {
    set_has_COMPILER_FLAGS();
    if (_COMPILER_FLAGS == NULL) {
        _COMPILER_FLAGS = new ::std::string ();
        if (!_COMPILER_FLAGS)
            std::abort();
    }
    return *_COMPILER_FLAGS;
}

inline void BuildInfo_CMakeInfo::setCOMPILER_FLAGS (const ::std::string& COMPILER_FLAGS_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (COMPILER_FLAGS_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_COMPILER_FLAGS();
    if (this->_COMPILER_FLAGS == NULL) {
        this->_COMPILER_FLAGS = new ::std::string (COMPILER_FLAGS_);
        if (!this->_COMPILER_FLAGS)
            std::abort();
    } else {
        *this->_COMPILER_FLAGS = COMPILER_FLAGS_;
    }
}

inline void BuildInfo_CMakeInfo::setCOMPILER_FLAGS (const char* COMPILER_FLAGS_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (COMPILER_FLAGS_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_COMPILER_FLAGS();
    if (this->_COMPILER_FLAGS == NULL) {
        this->_COMPILER_FLAGS = new ::std::string (COMPILER_FLAGS_);
        if (!this->_COMPILER_FLAGS)
            std::abort();
    } else {
        this->_COMPILER_FLAGS->assign(COMPILER_FLAGS_);
    }
}

inline void BuildInfo_CMakeInfo::setCOMPILER_FLAGS (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_COMPILER_FLAGS();
    if (this->_COMPILER_FLAGS == NULL) {
        this->_COMPILER_FLAGS = new ::std::string (value, size);
        if (!this->_COMPILER_FLAGS)
            std::abort();
    } else {
        this->_COMPILER_FLAGS->assign(value, size);
    }
}

inline ::std::string* BuildInfo_CMakeInfo::releaseCOMPILER_FLAGS() {
    clear_has_COMPILER_FLAGS();
    ::std::string* temp = _COMPILER_FLAGS;
    this->_COMPILER_FLAGS = NULL;
    return temp;
}

inline void BuildInfo_CMakeInfo::replaceCOMPILER_FLAGS (::std::string* COMPILER_FLAGS_) {
    set_has_COMPILER_FLAGS();
    if (this->_COMPILER_FLAGS != COMPILER_FLAGS_) {
        if (this->_COMPILER_FLAGS != NULL) {
            delete this->_COMPILER_FLAGS;
        }
        this->_COMPILER_FLAGS = COMPILER_FLAGS_;
    }
}

inline void BuildInfo_CMakeInfo::clearCMAKE_EXE_LINKER_FLAGS() {
    if (hasCMAKE_EXE_LINKER_FLAGS()) {
         clear_has_CMAKE_EXE_LINKER_FLAGS();
        if (_CMAKE_EXE_LINKER_FLAGS != NULL) {
            _CMAKE_EXE_LINKER_FLAGS->clear();
        }
     }
}

inline bool BuildInfo_CMakeInfo::hasCMAKE_EXE_LINKER_FLAGS () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::std::string& BuildInfo_CMakeInfo::getCMAKE_EXE_LINKER_FLAGS () const {
    if (_CMAKE_EXE_LINKER_FLAGS == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_CMAKE_EXE_LINKER_FLAGS;
}

inline ::std::string& BuildInfo_CMakeInfo::getCMAKE_EXE_LINKER_FLAGSMutable () {
    set_has_CMAKE_EXE_LINKER_FLAGS();
    if (_CMAKE_EXE_LINKER_FLAGS == NULL) {
        _CMAKE_EXE_LINKER_FLAGS = new ::std::string ();
        if (!_CMAKE_EXE_LINKER_FLAGS)
            std::abort();
    }
    return *_CMAKE_EXE_LINKER_FLAGS;
}

inline void BuildInfo_CMakeInfo::setCMAKE_EXE_LINKER_FLAGS (const ::std::string& CMAKE_EXE_LINKER_FLAGS_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CMAKE_EXE_LINKER_FLAGS_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CMAKE_EXE_LINKER_FLAGS();
    if (this->_CMAKE_EXE_LINKER_FLAGS == NULL) {
        this->_CMAKE_EXE_LINKER_FLAGS = new ::std::string (CMAKE_EXE_LINKER_FLAGS_);
        if (!this->_CMAKE_EXE_LINKER_FLAGS)
            std::abort();
    } else {
        *this->_CMAKE_EXE_LINKER_FLAGS = CMAKE_EXE_LINKER_FLAGS_;
    }
}

inline void BuildInfo_CMakeInfo::setCMAKE_EXE_LINKER_FLAGS (const char* CMAKE_EXE_LINKER_FLAGS_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CMAKE_EXE_LINKER_FLAGS_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CMAKE_EXE_LINKER_FLAGS();
    if (this->_CMAKE_EXE_LINKER_FLAGS == NULL) {
        this->_CMAKE_EXE_LINKER_FLAGS = new ::std::string (CMAKE_EXE_LINKER_FLAGS_);
        if (!this->_CMAKE_EXE_LINKER_FLAGS)
            std::abort();
    } else {
        this->_CMAKE_EXE_LINKER_FLAGS->assign(CMAKE_EXE_LINKER_FLAGS_);
    }
}

inline void BuildInfo_CMakeInfo::setCMAKE_EXE_LINKER_FLAGS (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CMAKE_EXE_LINKER_FLAGS();
    if (this->_CMAKE_EXE_LINKER_FLAGS == NULL) {
        this->_CMAKE_EXE_LINKER_FLAGS = new ::std::string (value, size);
        if (!this->_CMAKE_EXE_LINKER_FLAGS)
            std::abort();
    } else {
        this->_CMAKE_EXE_LINKER_FLAGS->assign(value, size);
    }
}

inline ::std::string* BuildInfo_CMakeInfo::releaseCMAKE_EXE_LINKER_FLAGS() {
    clear_has_CMAKE_EXE_LINKER_FLAGS();
    ::std::string* temp = _CMAKE_EXE_LINKER_FLAGS;
    this->_CMAKE_EXE_LINKER_FLAGS = NULL;
    return temp;
}

inline void BuildInfo_CMakeInfo::replaceCMAKE_EXE_LINKER_FLAGS (::std::string* CMAKE_EXE_LINKER_FLAGS_) {
    set_has_CMAKE_EXE_LINKER_FLAGS();
    if (this->_CMAKE_EXE_LINKER_FLAGS != CMAKE_EXE_LINKER_FLAGS_) {
        if (this->_CMAKE_EXE_LINKER_FLAGS != NULL) {
            delete this->_CMAKE_EXE_LINKER_FLAGS;
        }
        this->_CMAKE_EXE_LINKER_FLAGS = CMAKE_EXE_LINKER_FLAGS_;
    }
}

inline void BuildInfo_CMakeInfo::clearCMAKE_SHARED_LINKER_FLAGS() {
    if (hasCMAKE_SHARED_LINKER_FLAGS()) {
         clear_has_CMAKE_SHARED_LINKER_FLAGS();
        if (_CMAKE_SHARED_LINKER_FLAGS != NULL) {
            _CMAKE_SHARED_LINKER_FLAGS->clear();
        }
     }
}

inline bool BuildInfo_CMakeInfo::hasCMAKE_SHARED_LINKER_FLAGS () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::std::string& BuildInfo_CMakeInfo::getCMAKE_SHARED_LINKER_FLAGS () const {
    if (_CMAKE_SHARED_LINKER_FLAGS == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_CMAKE_SHARED_LINKER_FLAGS;
}

inline ::std::string& BuildInfo_CMakeInfo::getCMAKE_SHARED_LINKER_FLAGSMutable () {
    set_has_CMAKE_SHARED_LINKER_FLAGS();
    if (_CMAKE_SHARED_LINKER_FLAGS == NULL) {
        _CMAKE_SHARED_LINKER_FLAGS = new ::std::string ();
        if (!_CMAKE_SHARED_LINKER_FLAGS)
            std::abort();
    }
    return *_CMAKE_SHARED_LINKER_FLAGS;
}

inline void BuildInfo_CMakeInfo::setCMAKE_SHARED_LINKER_FLAGS (const ::std::string& CMAKE_SHARED_LINKER_FLAGS_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CMAKE_SHARED_LINKER_FLAGS_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CMAKE_SHARED_LINKER_FLAGS();
    if (this->_CMAKE_SHARED_LINKER_FLAGS == NULL) {
        this->_CMAKE_SHARED_LINKER_FLAGS = new ::std::string (CMAKE_SHARED_LINKER_FLAGS_);
        if (!this->_CMAKE_SHARED_LINKER_FLAGS)
            std::abort();
    } else {
        *this->_CMAKE_SHARED_LINKER_FLAGS = CMAKE_SHARED_LINKER_FLAGS_;
    }
}

inline void BuildInfo_CMakeInfo::setCMAKE_SHARED_LINKER_FLAGS (const char* CMAKE_SHARED_LINKER_FLAGS_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CMAKE_SHARED_LINKER_FLAGS_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CMAKE_SHARED_LINKER_FLAGS();
    if (this->_CMAKE_SHARED_LINKER_FLAGS == NULL) {
        this->_CMAKE_SHARED_LINKER_FLAGS = new ::std::string (CMAKE_SHARED_LINKER_FLAGS_);
        if (!this->_CMAKE_SHARED_LINKER_FLAGS)
            std::abort();
    } else {
        this->_CMAKE_SHARED_LINKER_FLAGS->assign(CMAKE_SHARED_LINKER_FLAGS_);
    }
}

inline void BuildInfo_CMakeInfo::setCMAKE_SHARED_LINKER_FLAGS (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CMAKE_SHARED_LINKER_FLAGS();
    if (this->_CMAKE_SHARED_LINKER_FLAGS == NULL) {
        this->_CMAKE_SHARED_LINKER_FLAGS = new ::std::string (value, size);
        if (!this->_CMAKE_SHARED_LINKER_FLAGS)
            std::abort();
    } else {
        this->_CMAKE_SHARED_LINKER_FLAGS->assign(value, size);
    }
}

inline ::std::string* BuildInfo_CMakeInfo::releaseCMAKE_SHARED_LINKER_FLAGS() {
    clear_has_CMAKE_SHARED_LINKER_FLAGS();
    ::std::string* temp = _CMAKE_SHARED_LINKER_FLAGS;
    this->_CMAKE_SHARED_LINKER_FLAGS = NULL;
    return temp;
}

inline void BuildInfo_CMakeInfo::replaceCMAKE_SHARED_LINKER_FLAGS (::std::string* CMAKE_SHARED_LINKER_FLAGS_) {
    set_has_CMAKE_SHARED_LINKER_FLAGS();
    if (this->_CMAKE_SHARED_LINKER_FLAGS != CMAKE_SHARED_LINKER_FLAGS_) {
        if (this->_CMAKE_SHARED_LINKER_FLAGS != NULL) {
            delete this->_CMAKE_SHARED_LINKER_FLAGS;
        }
        this->_CMAKE_SHARED_LINKER_FLAGS = CMAKE_SHARED_LINKER_FLAGS_;
    }
}

inline void BuildInfo_CMakeInfo::clearCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS() {
    if (hasCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS()) {
         clear_has_CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS();
        if (_CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS != NULL) {
            _CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS->clear();
        }
     }
}

inline bool BuildInfo_CMakeInfo::hasCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::std::string& BuildInfo_CMakeInfo::getCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS () const {
    if (_CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS;
}

inline ::std::string& BuildInfo_CMakeInfo::getCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGSMutable () {
    set_has_CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS();
    if (_CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS == NULL) {
        _CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS = new ::std::string ();
        if (!_CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS)
            std::abort();
    }
    return *_CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS;
}

inline void BuildInfo_CMakeInfo::setCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS (const ::std::string& CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS();
    if (this->_CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS == NULL) {
        this->_CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS = new ::std::string (CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS_);
        if (!this->_CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS)
            std::abort();
    } else {
        *this->_CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS = CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS_;
    }
}

inline void BuildInfo_CMakeInfo::setCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS (const char* CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS();
    if (this->_CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS == NULL) {
        this->_CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS = new ::std::string (CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS_);
        if (!this->_CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS)
            std::abort();
    } else {
        this->_CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS->assign(CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS_);
    }
}

inline void BuildInfo_CMakeInfo::setCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS();
    if (this->_CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS == NULL) {
        this->_CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS = new ::std::string (value, size);
        if (!this->_CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS)
            std::abort();
    } else {
        this->_CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS->assign(value, size);
    }
}

inline ::std::string* BuildInfo_CMakeInfo::releaseCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS() {
    clear_has_CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS();
    ::std::string* temp = _CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS;
    this->_CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS = NULL;
    return temp;
}

inline void BuildInfo_CMakeInfo::replaceCMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS (::std::string* CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS_) {
    set_has_CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS();
    if (this->_CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS != CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS_) {
        if (this->_CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS != NULL) {
            delete this->_CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS;
        }
        this->_CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS = CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS_;
    }
}

inline void BuildInfo_CMakeInfo::clearCMAKE_TOOLCHAIN_FILE() {
    if (hasCMAKE_TOOLCHAIN_FILE()) {
         clear_has_CMAKE_TOOLCHAIN_FILE();
        if (_CMAKE_TOOLCHAIN_FILE != NULL) {
            _CMAKE_TOOLCHAIN_FILE->clear();
        }
     }
}

inline bool BuildInfo_CMakeInfo::hasCMAKE_TOOLCHAIN_FILE () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline const ::std::string& BuildInfo_CMakeInfo::getCMAKE_TOOLCHAIN_FILE () const {
    if (_CMAKE_TOOLCHAIN_FILE == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_CMAKE_TOOLCHAIN_FILE;
}

inline ::std::string& BuildInfo_CMakeInfo::getCMAKE_TOOLCHAIN_FILEMutable () {
    set_has_CMAKE_TOOLCHAIN_FILE();
    if (_CMAKE_TOOLCHAIN_FILE == NULL) {
        _CMAKE_TOOLCHAIN_FILE = new ::std::string ();
        if (!_CMAKE_TOOLCHAIN_FILE)
            std::abort();
    }
    return *_CMAKE_TOOLCHAIN_FILE;
}

inline void BuildInfo_CMakeInfo::setCMAKE_TOOLCHAIN_FILE (const ::std::string& CMAKE_TOOLCHAIN_FILE_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CMAKE_TOOLCHAIN_FILE_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CMAKE_TOOLCHAIN_FILE();
    if (this->_CMAKE_TOOLCHAIN_FILE == NULL) {
        this->_CMAKE_TOOLCHAIN_FILE = new ::std::string (CMAKE_TOOLCHAIN_FILE_);
        if (!this->_CMAKE_TOOLCHAIN_FILE)
            std::abort();
    } else {
        *this->_CMAKE_TOOLCHAIN_FILE = CMAKE_TOOLCHAIN_FILE_;
    }
}

inline void BuildInfo_CMakeInfo::setCMAKE_TOOLCHAIN_FILE (const char* CMAKE_TOOLCHAIN_FILE_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CMAKE_TOOLCHAIN_FILE_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CMAKE_TOOLCHAIN_FILE();
    if (this->_CMAKE_TOOLCHAIN_FILE == NULL) {
        this->_CMAKE_TOOLCHAIN_FILE = new ::std::string (CMAKE_TOOLCHAIN_FILE_);
        if (!this->_CMAKE_TOOLCHAIN_FILE)
            std::abort();
    } else {
        this->_CMAKE_TOOLCHAIN_FILE->assign(CMAKE_TOOLCHAIN_FILE_);
    }
}

inline void BuildInfo_CMakeInfo::setCMAKE_TOOLCHAIN_FILE (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CMAKE_TOOLCHAIN_FILE();
    if (this->_CMAKE_TOOLCHAIN_FILE == NULL) {
        this->_CMAKE_TOOLCHAIN_FILE = new ::std::string (value, size);
        if (!this->_CMAKE_TOOLCHAIN_FILE)
            std::abort();
    } else {
        this->_CMAKE_TOOLCHAIN_FILE->assign(value, size);
    }
}

inline ::std::string* BuildInfo_CMakeInfo::releaseCMAKE_TOOLCHAIN_FILE() {
    clear_has_CMAKE_TOOLCHAIN_FILE();
    ::std::string* temp = _CMAKE_TOOLCHAIN_FILE;
    this->_CMAKE_TOOLCHAIN_FILE = NULL;
    return temp;
}

inline void BuildInfo_CMakeInfo::replaceCMAKE_TOOLCHAIN_FILE (::std::string* CMAKE_TOOLCHAIN_FILE_) {
    set_has_CMAKE_TOOLCHAIN_FILE();
    if (this->_CMAKE_TOOLCHAIN_FILE != CMAKE_TOOLCHAIN_FILE_) {
        if (this->_CMAKE_TOOLCHAIN_FILE != NULL) {
            delete this->_CMAKE_TOOLCHAIN_FILE;
        }
        this->_CMAKE_TOOLCHAIN_FILE = CMAKE_TOOLCHAIN_FILE_;
    }
}

inline void BuildInfo_CMakeInfo::set_has_CMAKE_BINARY_DIR () {
    _has_bits_[0] |= 1u << 0;
}

inline void BuildInfo_CMakeInfo::clear_has_CMAKE_BINARY_DIR () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void BuildInfo_CMakeInfo::set_has_CMAKE_SOURCE_DIR () {
    _has_bits_[0] |= 1u << 1;
}

inline void BuildInfo_CMakeInfo::clear_has_CMAKE_SOURCE_DIR () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void BuildInfo_CMakeInfo::set_has_CMAKE_VERSION () {
    _has_bits_[0] |= 1u << 2;
}

inline void BuildInfo_CMakeInfo::clear_has_CMAKE_VERSION () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void BuildInfo_CMakeInfo::set_has_BUILD_VARIANT () {
    _has_bits_[0] |= 1u << 3;
}

inline void BuildInfo_CMakeInfo::clear_has_BUILD_VARIANT () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void BuildInfo_CMakeInfo::set_has_COMPILER () {
    _has_bits_[0] |= 1u << 4;
}

inline void BuildInfo_CMakeInfo::clear_has_COMPILER () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void BuildInfo_CMakeInfo::set_has_COMPILER_FLAGS () {
    _has_bits_[0] |= 1u << 5;
}

inline void BuildInfo_CMakeInfo::clear_has_COMPILER_FLAGS () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void BuildInfo_CMakeInfo::set_has_CMAKE_EXE_LINKER_FLAGS () {
    _has_bits_[0] |= 1u << 6;
}

inline void BuildInfo_CMakeInfo::clear_has_CMAKE_EXE_LINKER_FLAGS () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void BuildInfo_CMakeInfo::set_has_CMAKE_SHARED_LINKER_FLAGS () {
    _has_bits_[0] |= 1u << 7;
}

inline void BuildInfo_CMakeInfo::clear_has_CMAKE_SHARED_LINKER_FLAGS () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void BuildInfo_CMakeInfo::set_has_CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS () {
    _has_bits_[0] |= 1u << 8;
}

inline void BuildInfo_CMakeInfo::clear_has_CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void BuildInfo_CMakeInfo::set_has_CMAKE_TOOLCHAIN_FILE () {
    _has_bits_[0] |= 1u << 9;
}

inline void BuildInfo_CMakeInfo::clear_has_CMAKE_TOOLCHAIN_FILE () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline  BuildInfo_GitInfo::BuildInfo_GitInfo ()  :
    _remoteRepo (NULL),
    _branchName (NULL),
    _commitId (NULL),
    _isDirty (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BuildInfo_GitInfo::BuildInfo_GitInfo (const BuildInfo_GitInfo &rhs)  :
    _remoteRepo (NULL),
    _branchName (NULL),
    _commitId (NULL),
    _isDirty (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BuildInfo_GitInfo::BuildInfo_GitInfo (const ::std::string& remoteRepo_, const ::std::string& branchName_, const ::std::string& commitId_, bool isDirty_)  :
    _remoteRepo (new ::std::string(remoteRepo_)),
    _branchName (new ::std::string(branchName_)),
    _commitId (new ::std::string(commitId_)),
    _isDirty (isDirty_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (remoteRepo_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (branchName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (commitId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BuildInfo_GitInfo::~BuildInfo_GitInfo() {
    delete _remoteRepo;
    delete _branchName;
    delete _commitId;
}

inline BuildInfo_GitInfo& BuildInfo_GitInfo::operator = (const BuildInfo_GitInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasRemoteRepo()) {
            setRemoteRepo(rhs.getRemoteRepo());
        } else {
            clearRemoteRepo();
        }
        if (rhs.hasBranchName()) {
            setBranchName(rhs.getBranchName());
        } else {
            clearBranchName();
        }
        if (rhs.hasCommitId()) {
            setCommitId(rhs.getCommitId());
        } else {
            clearCommitId();
        }
        if (rhs.hasIsDirty()) {
            setIsDirty(rhs.getIsDirty());
        } else {
            clearIsDirty();
        }
    }
    return *this;
}

inline bool BuildInfo_GitInfo::operator == (const BuildInfo_GitInfo& rhs) const {
    return (((!hasRemoteRepo() && !rhs.hasRemoteRepo()) || getRemoteRepo() == rhs.getRemoteRepo()) &&
        ((!hasBranchName() && !rhs.hasBranchName()) || getBranchName() == rhs.getBranchName()) &&
        ((!hasCommitId() && !rhs.hasCommitId()) || getCommitId() == rhs.getCommitId()) &&
        ((!hasIsDirty() && !rhs.hasIsDirty()) || getIsDirty() == rhs.getIsDirty()));
}

inline bool BuildInfo_GitInfo::operator != (const BuildInfo_GitInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool BuildInfo_GitInfo::operator < (const BuildInfo_GitInfo& rhs) const {
    if (hasRemoteRepo() || rhs.hasRemoteRepo()) {
        if (getRemoteRepo() < rhs.getRemoteRepo()) return true;
        if (getRemoteRepo() > rhs.getRemoteRepo()) return false;
    }
    if (hasBranchName() || rhs.hasBranchName()) {
        if (getBranchName() < rhs.getBranchName()) return true;
        if (getBranchName() > rhs.getBranchName()) return false;
    }
    if (hasCommitId() || rhs.hasCommitId()) {
        if (getCommitId() < rhs.getCommitId()) return true;
        if (getCommitId() > rhs.getCommitId()) return false;
    }
    if (hasIsDirty() || rhs.hasIsDirty()) {
        if (getIsDirty() < rhs.getIsDirty()) return true;
        if (getIsDirty() > rhs.getIsDirty()) return false;
    }
    return false;
}

inline bool BuildInfo_GitInfo::operator > (const BuildInfo_GitInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BuildInfo_GitInfo::clear() {
    clearRemoteRepo();
    clearBranchName();
    clearCommitId();
    clearIsDirty();
}

inline void BuildInfo_GitInfo::clearRemoteRepo() {
    if (hasRemoteRepo()) {
         clear_has_remoteRepo();
        if (_remoteRepo != NULL) {
            _remoteRepo->clear();
        }
     }
}

inline bool BuildInfo_GitInfo::hasRemoteRepo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& BuildInfo_GitInfo::getRemoteRepo () const {
    if (_remoteRepo == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_remoteRepo;
}

inline ::std::string& BuildInfo_GitInfo::getRemoteRepoMutable () {
    set_has_remoteRepo();
    if (_remoteRepo == NULL) {
        _remoteRepo = new ::std::string ();
        if (!_remoteRepo)
            std::abort();
    }
    return *_remoteRepo;
}

inline void BuildInfo_GitInfo::setRemoteRepo (const ::std::string& remoteRepo_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (remoteRepo_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_remoteRepo();
    if (this->_remoteRepo == NULL) {
        this->_remoteRepo = new ::std::string (remoteRepo_);
        if (!this->_remoteRepo)
            std::abort();
    } else {
        *this->_remoteRepo = remoteRepo_;
    }
}

inline void BuildInfo_GitInfo::setRemoteRepo (const char* remoteRepo_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (remoteRepo_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_remoteRepo();
    if (this->_remoteRepo == NULL) {
        this->_remoteRepo = new ::std::string (remoteRepo_);
        if (!this->_remoteRepo)
            std::abort();
    } else {
        this->_remoteRepo->assign(remoteRepo_);
    }
}

inline void BuildInfo_GitInfo::setRemoteRepo (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_remoteRepo();
    if (this->_remoteRepo == NULL) {
        this->_remoteRepo = new ::std::string (value, size);
        if (!this->_remoteRepo)
            std::abort();
    } else {
        this->_remoteRepo->assign(value, size);
    }
}

inline ::std::string* BuildInfo_GitInfo::releaseRemoteRepo() {
    clear_has_remoteRepo();
    ::std::string* temp = _remoteRepo;
    this->_remoteRepo = NULL;
    return temp;
}

inline void BuildInfo_GitInfo::replaceRemoteRepo (::std::string* remoteRepo_) {
    set_has_remoteRepo();
    if (this->_remoteRepo != remoteRepo_) {
        if (this->_remoteRepo != NULL) {
            delete this->_remoteRepo;
        }
        this->_remoteRepo = remoteRepo_;
    }
}

inline void BuildInfo_GitInfo::clearBranchName() {
    if (hasBranchName()) {
         clear_has_branchName();
        if (_branchName != NULL) {
            _branchName->clear();
        }
     }
}

inline bool BuildInfo_GitInfo::hasBranchName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& BuildInfo_GitInfo::getBranchName () const {
    if (_branchName == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_branchName;
}

inline ::std::string& BuildInfo_GitInfo::getBranchNameMutable () {
    set_has_branchName();
    if (_branchName == NULL) {
        _branchName = new ::std::string ();
        if (!_branchName)
            std::abort();
    }
    return *_branchName;
}

inline void BuildInfo_GitInfo::setBranchName (const ::std::string& branchName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (branchName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_branchName();
    if (this->_branchName == NULL) {
        this->_branchName = new ::std::string (branchName_);
        if (!this->_branchName)
            std::abort();
    } else {
        *this->_branchName = branchName_;
    }
}

inline void BuildInfo_GitInfo::setBranchName (const char* branchName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (branchName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_branchName();
    if (this->_branchName == NULL) {
        this->_branchName = new ::std::string (branchName_);
        if (!this->_branchName)
            std::abort();
    } else {
        this->_branchName->assign(branchName_);
    }
}

inline void BuildInfo_GitInfo::setBranchName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_branchName();
    if (this->_branchName == NULL) {
        this->_branchName = new ::std::string (value, size);
        if (!this->_branchName)
            std::abort();
    } else {
        this->_branchName->assign(value, size);
    }
}

inline ::std::string* BuildInfo_GitInfo::releaseBranchName() {
    clear_has_branchName();
    ::std::string* temp = _branchName;
    this->_branchName = NULL;
    return temp;
}

inline void BuildInfo_GitInfo::replaceBranchName (::std::string* branchName_) {
    set_has_branchName();
    if (this->_branchName != branchName_) {
        if (this->_branchName != NULL) {
            delete this->_branchName;
        }
        this->_branchName = branchName_;
    }
}

inline void BuildInfo_GitInfo::clearCommitId() {
    if (hasCommitId()) {
         clear_has_commitId();
        if (_commitId != NULL) {
            _commitId->clear();
        }
     }
}

inline bool BuildInfo_GitInfo::hasCommitId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& BuildInfo_GitInfo::getCommitId () const {
    if (_commitId == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_commitId;
}

inline ::std::string& BuildInfo_GitInfo::getCommitIdMutable () {
    set_has_commitId();
    if (_commitId == NULL) {
        _commitId = new ::std::string ();
        if (!_commitId)
            std::abort();
    }
    return *_commitId;
}

inline void BuildInfo_GitInfo::setCommitId (const ::std::string& commitId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (commitId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_commitId();
    if (this->_commitId == NULL) {
        this->_commitId = new ::std::string (commitId_);
        if (!this->_commitId)
            std::abort();
    } else {
        *this->_commitId = commitId_;
    }
}

inline void BuildInfo_GitInfo::setCommitId (const char* commitId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (commitId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_commitId();
    if (this->_commitId == NULL) {
        this->_commitId = new ::std::string (commitId_);
        if (!this->_commitId)
            std::abort();
    } else {
        this->_commitId->assign(commitId_);
    }
}

inline void BuildInfo_GitInfo::setCommitId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_commitId();
    if (this->_commitId == NULL) {
        this->_commitId = new ::std::string (value, size);
        if (!this->_commitId)
            std::abort();
    } else {
        this->_commitId->assign(value, size);
    }
}

inline ::std::string* BuildInfo_GitInfo::releaseCommitId() {
    clear_has_commitId();
    ::std::string* temp = _commitId;
    this->_commitId = NULL;
    return temp;
}

inline void BuildInfo_GitInfo::replaceCommitId (::std::string* commitId_) {
    set_has_commitId();
    if (this->_commitId != commitId_) {
        if (this->_commitId != NULL) {
            delete this->_commitId;
        }
        this->_commitId = commitId_;
    }
}

inline void BuildInfo_GitInfo::clearIsDirty() {
    if (hasIsDirty()) {
         clear_has_isDirty();
        _isDirty = false;
     }
}

inline bool BuildInfo_GitInfo::hasIsDirty () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool BuildInfo_GitInfo::getIsDirty () const {
    return _isDirty;
}

inline void BuildInfo_GitInfo::setIsDirty (bool isDirty_) {
    set_has_isDirty();
    this->_isDirty = isDirty_;
}

inline void BuildInfo_GitInfo::set_has_remoteRepo () {
    _has_bits_[0] |= 1u << 0;
}

inline void BuildInfo_GitInfo::clear_has_remoteRepo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void BuildInfo_GitInfo::set_has_branchName () {
    _has_bits_[0] |= 1u << 1;
}

inline void BuildInfo_GitInfo::clear_has_branchName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void BuildInfo_GitInfo::set_has_commitId () {
    _has_bits_[0] |= 1u << 2;
}

inline void BuildInfo_GitInfo::clear_has_commitId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void BuildInfo_GitInfo::set_has_isDirty () {
    _has_bits_[0] |= 1u << 3;
}

inline void BuildInfo_GitInfo::clear_has_isDirty () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  BuildInfo_HostInfo::BuildInfo_HostInfo ()  :
    _host (NULL),
    _uname (NULL),
    _userName (NULL),
    _timeStamp (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BuildInfo_HostInfo::BuildInfo_HostInfo (const BuildInfo_HostInfo &rhs)  :
    _host (NULL),
    _uname (NULL),
    _userName (NULL),
    _timeStamp (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BuildInfo_HostInfo::BuildInfo_HostInfo (const ::std::string& host_, const ::std::string& uname_, const ::std::string& userName_, const ::std::string& timeStamp_)  :
    _host (new ::std::string(host_)),
    _uname (new ::std::string(uname_)),
    _userName (new ::std::string(userName_)),
    _timeStamp (new ::std::string(timeStamp_))
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (host_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (uname_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (userName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (timeStamp_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BuildInfo_HostInfo::~BuildInfo_HostInfo() {
    delete _host;
    delete _uname;
    delete _userName;
    delete _timeStamp;
}

inline BuildInfo_HostInfo& BuildInfo_HostInfo::operator = (const BuildInfo_HostInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasHost()) {
            setHost(rhs.getHost());
        } else {
            clearHost();
        }
        if (rhs.hasUname()) {
            setUname(rhs.getUname());
        } else {
            clearUname();
        }
        if (rhs.hasUserName()) {
            setUserName(rhs.getUserName());
        } else {
            clearUserName();
        }
        if (rhs.hasTimeStamp()) {
            setTimeStamp(rhs.getTimeStamp());
        } else {
            clearTimeStamp();
        }
    }
    return *this;
}

inline bool BuildInfo_HostInfo::operator == (const BuildInfo_HostInfo& rhs) const {
    return (((!hasHost() && !rhs.hasHost()) || getHost() == rhs.getHost()) &&
        ((!hasUname() && !rhs.hasUname()) || getUname() == rhs.getUname()) &&
        ((!hasUserName() && !rhs.hasUserName()) || getUserName() == rhs.getUserName()) &&
        ((!hasTimeStamp() && !rhs.hasTimeStamp()) || getTimeStamp() == rhs.getTimeStamp()));
}

inline bool BuildInfo_HostInfo::operator != (const BuildInfo_HostInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool BuildInfo_HostInfo::operator < (const BuildInfo_HostInfo& rhs) const {
    if (hasHost() || rhs.hasHost()) {
        if (getHost() < rhs.getHost()) return true;
        if (getHost() > rhs.getHost()) return false;
    }
    if (hasUname() || rhs.hasUname()) {
        if (getUname() < rhs.getUname()) return true;
        if (getUname() > rhs.getUname()) return false;
    }
    if (hasUserName() || rhs.hasUserName()) {
        if (getUserName() < rhs.getUserName()) return true;
        if (getUserName() > rhs.getUserName()) return false;
    }
    if (hasTimeStamp() || rhs.hasTimeStamp()) {
        if (getTimeStamp() < rhs.getTimeStamp()) return true;
        if (getTimeStamp() > rhs.getTimeStamp()) return false;
    }
    return false;
}

inline bool BuildInfo_HostInfo::operator > (const BuildInfo_HostInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BuildInfo_HostInfo::clear() {
    clearHost();
    clearUname();
    clearUserName();
    clearTimeStamp();
}

inline void BuildInfo_HostInfo::clearHost() {
    if (hasHost()) {
         clear_has_host();
        if (_host != NULL) {
            _host->clear();
        }
     }
}

inline bool BuildInfo_HostInfo::hasHost () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& BuildInfo_HostInfo::getHost () const {
    if (_host == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_host;
}

inline ::std::string& BuildInfo_HostInfo::getHostMutable () {
    set_has_host();
    if (_host == NULL) {
        _host = new ::std::string ();
        if (!_host)
            std::abort();
    }
    return *_host;
}

inline void BuildInfo_HostInfo::setHost (const ::std::string& host_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (host_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_host();
    if (this->_host == NULL) {
        this->_host = new ::std::string (host_);
        if (!this->_host)
            std::abort();
    } else {
        *this->_host = host_;
    }
}

inline void BuildInfo_HostInfo::setHost (const char* host_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (host_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_host();
    if (this->_host == NULL) {
        this->_host = new ::std::string (host_);
        if (!this->_host)
            std::abort();
    } else {
        this->_host->assign(host_);
    }
}

inline void BuildInfo_HostInfo::setHost (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_host();
    if (this->_host == NULL) {
        this->_host = new ::std::string (value, size);
        if (!this->_host)
            std::abort();
    } else {
        this->_host->assign(value, size);
    }
}

inline ::std::string* BuildInfo_HostInfo::releaseHost() {
    clear_has_host();
    ::std::string* temp = _host;
    this->_host = NULL;
    return temp;
}

inline void BuildInfo_HostInfo::replaceHost (::std::string* host_) {
    set_has_host();
    if (this->_host != host_) {
        if (this->_host != NULL) {
            delete this->_host;
        }
        this->_host = host_;
    }
}

inline void BuildInfo_HostInfo::clearUname() {
    if (hasUname()) {
         clear_has_uname();
        if (_uname != NULL) {
            _uname->clear();
        }
     }
}

inline bool BuildInfo_HostInfo::hasUname () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& BuildInfo_HostInfo::getUname () const {
    if (_uname == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_uname;
}

inline ::std::string& BuildInfo_HostInfo::getUnameMutable () {
    set_has_uname();
    if (_uname == NULL) {
        _uname = new ::std::string ();
        if (!_uname)
            std::abort();
    }
    return *_uname;
}

inline void BuildInfo_HostInfo::setUname (const ::std::string& uname_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (uname_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_uname();
    if (this->_uname == NULL) {
        this->_uname = new ::std::string (uname_);
        if (!this->_uname)
            std::abort();
    } else {
        *this->_uname = uname_;
    }
}

inline void BuildInfo_HostInfo::setUname (const char* uname_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (uname_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_uname();
    if (this->_uname == NULL) {
        this->_uname = new ::std::string (uname_);
        if (!this->_uname)
            std::abort();
    } else {
        this->_uname->assign(uname_);
    }
}

inline void BuildInfo_HostInfo::setUname (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_uname();
    if (this->_uname == NULL) {
        this->_uname = new ::std::string (value, size);
        if (!this->_uname)
            std::abort();
    } else {
        this->_uname->assign(value, size);
    }
}

inline ::std::string* BuildInfo_HostInfo::releaseUname() {
    clear_has_uname();
    ::std::string* temp = _uname;
    this->_uname = NULL;
    return temp;
}

inline void BuildInfo_HostInfo::replaceUname (::std::string* uname_) {
    set_has_uname();
    if (this->_uname != uname_) {
        if (this->_uname != NULL) {
            delete this->_uname;
        }
        this->_uname = uname_;
    }
}

inline void BuildInfo_HostInfo::clearUserName() {
    if (hasUserName()) {
         clear_has_userName();
        if (_userName != NULL) {
            _userName->clear();
        }
     }
}

inline bool BuildInfo_HostInfo::hasUserName () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& BuildInfo_HostInfo::getUserName () const {
    if (_userName == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_userName;
}

inline ::std::string& BuildInfo_HostInfo::getUserNameMutable () {
    set_has_userName();
    if (_userName == NULL) {
        _userName = new ::std::string ();
        if (!_userName)
            std::abort();
    }
    return *_userName;
}

inline void BuildInfo_HostInfo::setUserName (const ::std::string& userName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (userName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_userName();
    if (this->_userName == NULL) {
        this->_userName = new ::std::string (userName_);
        if (!this->_userName)
            std::abort();
    } else {
        *this->_userName = userName_;
    }
}

inline void BuildInfo_HostInfo::setUserName (const char* userName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (userName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_userName();
    if (this->_userName == NULL) {
        this->_userName = new ::std::string (userName_);
        if (!this->_userName)
            std::abort();
    } else {
        this->_userName->assign(userName_);
    }
}

inline void BuildInfo_HostInfo::setUserName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_userName();
    if (this->_userName == NULL) {
        this->_userName = new ::std::string (value, size);
        if (!this->_userName)
            std::abort();
    } else {
        this->_userName->assign(value, size);
    }
}

inline ::std::string* BuildInfo_HostInfo::releaseUserName() {
    clear_has_userName();
    ::std::string* temp = _userName;
    this->_userName = NULL;
    return temp;
}

inline void BuildInfo_HostInfo::replaceUserName (::std::string* userName_) {
    set_has_userName();
    if (this->_userName != userName_) {
        if (this->_userName != NULL) {
            delete this->_userName;
        }
        this->_userName = userName_;
    }
}

inline void BuildInfo_HostInfo::clearTimeStamp() {
    if (hasTimeStamp()) {
         clear_has_timeStamp();
        if (_timeStamp != NULL) {
            _timeStamp->clear();
        }
     }
}

inline bool BuildInfo_HostInfo::hasTimeStamp () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& BuildInfo_HostInfo::getTimeStamp () const {
    if (_timeStamp == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_timeStamp;
}

inline ::std::string& BuildInfo_HostInfo::getTimeStampMutable () {
    set_has_timeStamp();
    if (_timeStamp == NULL) {
        _timeStamp = new ::std::string ();
        if (!_timeStamp)
            std::abort();
    }
    return *_timeStamp;
}

inline void BuildInfo_HostInfo::setTimeStamp (const ::std::string& timeStamp_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (timeStamp_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_timeStamp();
    if (this->_timeStamp == NULL) {
        this->_timeStamp = new ::std::string (timeStamp_);
        if (!this->_timeStamp)
            std::abort();
    } else {
        *this->_timeStamp = timeStamp_;
    }
}

inline void BuildInfo_HostInfo::setTimeStamp (const char* timeStamp_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (timeStamp_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_timeStamp();
    if (this->_timeStamp == NULL) {
        this->_timeStamp = new ::std::string (timeStamp_);
        if (!this->_timeStamp)
            std::abort();
    } else {
        this->_timeStamp->assign(timeStamp_);
    }
}

inline void BuildInfo_HostInfo::setTimeStamp (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_timeStamp();
    if (this->_timeStamp == NULL) {
        this->_timeStamp = new ::std::string (value, size);
        if (!this->_timeStamp)
            std::abort();
    } else {
        this->_timeStamp->assign(value, size);
    }
}

inline ::std::string* BuildInfo_HostInfo::releaseTimeStamp() {
    clear_has_timeStamp();
    ::std::string* temp = _timeStamp;
    this->_timeStamp = NULL;
    return temp;
}

inline void BuildInfo_HostInfo::replaceTimeStamp (::std::string* timeStamp_) {
    set_has_timeStamp();
    if (this->_timeStamp != timeStamp_) {
        if (this->_timeStamp != NULL) {
            delete this->_timeStamp;
        }
        this->_timeStamp = timeStamp_;
    }
}

inline void BuildInfo_HostInfo::set_has_host () {
    _has_bits_[0] |= 1u << 0;
}

inline void BuildInfo_HostInfo::clear_has_host () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void BuildInfo_HostInfo::set_has_uname () {
    _has_bits_[0] |= 1u << 1;
}

inline void BuildInfo_HostInfo::clear_has_uname () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void BuildInfo_HostInfo::set_has_userName () {
    _has_bits_[0] |= 1u << 2;
}

inline void BuildInfo_HostInfo::clear_has_userName () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void BuildInfo_HostInfo::set_has_timeStamp () {
    _has_bits_[0] |= 1u << 3;
}

inline void BuildInfo_HostInfo::clear_has_timeStamp () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  BuildInfo_DockerInfo::BuildInfo_DockerInfo ()  :
    _dockerHost (NULL),
    _dockerHostUser (NULL),
    _dockerImage (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BuildInfo_DockerInfo::BuildInfo_DockerInfo (const BuildInfo_DockerInfo &rhs)  :
    _dockerHost (NULL),
    _dockerHostUser (NULL),
    _dockerImage (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BuildInfo_DockerInfo::BuildInfo_DockerInfo (const ::std::string& dockerHost_, const ::std::string& dockerHostUser_, const ::std::string& dockerImage_)  :
    _dockerHost (new ::std::string(dockerHost_)),
    _dockerHostUser (new ::std::string(dockerHostUser_)),
    _dockerImage (new ::std::string(dockerImage_))
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (dockerHost_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (dockerHostUser_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (dockerImage_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BuildInfo_DockerInfo::~BuildInfo_DockerInfo() {
    delete _dockerHost;
    delete _dockerHostUser;
    delete _dockerImage;
}

inline BuildInfo_DockerInfo& BuildInfo_DockerInfo::operator = (const BuildInfo_DockerInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasDockerHost()) {
            setDockerHost(rhs.getDockerHost());
        } else {
            clearDockerHost();
        }
        if (rhs.hasDockerHostUser()) {
            setDockerHostUser(rhs.getDockerHostUser());
        } else {
            clearDockerHostUser();
        }
        if (rhs.hasDockerImage()) {
            setDockerImage(rhs.getDockerImage());
        } else {
            clearDockerImage();
        }
    }
    return *this;
}

inline bool BuildInfo_DockerInfo::operator == (const BuildInfo_DockerInfo& rhs) const {
    return (((!hasDockerHost() && !rhs.hasDockerHost()) || getDockerHost() == rhs.getDockerHost()) &&
        ((!hasDockerHostUser() && !rhs.hasDockerHostUser()) || getDockerHostUser() == rhs.getDockerHostUser()) &&
        ((!hasDockerImage() && !rhs.hasDockerImage()) || getDockerImage() == rhs.getDockerImage()));
}

inline bool BuildInfo_DockerInfo::operator != (const BuildInfo_DockerInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool BuildInfo_DockerInfo::operator < (const BuildInfo_DockerInfo& rhs) const {
    if (hasDockerHost() || rhs.hasDockerHost()) {
        if (getDockerHost() < rhs.getDockerHost()) return true;
        if (getDockerHost() > rhs.getDockerHost()) return false;
    }
    if (hasDockerHostUser() || rhs.hasDockerHostUser()) {
        if (getDockerHostUser() < rhs.getDockerHostUser()) return true;
        if (getDockerHostUser() > rhs.getDockerHostUser()) return false;
    }
    if (hasDockerImage() || rhs.hasDockerImage()) {
        if (getDockerImage() < rhs.getDockerImage()) return true;
        if (getDockerImage() > rhs.getDockerImage()) return false;
    }
    return false;
}

inline bool BuildInfo_DockerInfo::operator > (const BuildInfo_DockerInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BuildInfo_DockerInfo::clear() {
    clearDockerHost();
    clearDockerHostUser();
    clearDockerImage();
}

inline void BuildInfo_DockerInfo::clearDockerHost() {
    if (hasDockerHost()) {
         clear_has_dockerHost();
        if (_dockerHost != NULL) {
            _dockerHost->clear();
        }
     }
}

inline bool BuildInfo_DockerInfo::hasDockerHost () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& BuildInfo_DockerInfo::getDockerHost () const {
    if (_dockerHost == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_dockerHost;
}

inline ::std::string& BuildInfo_DockerInfo::getDockerHostMutable () {
    set_has_dockerHost();
    if (_dockerHost == NULL) {
        _dockerHost = new ::std::string ();
        if (!_dockerHost)
            std::abort();
    }
    return *_dockerHost;
}

inline void BuildInfo_DockerInfo::setDockerHost (const ::std::string& dockerHost_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (dockerHost_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_dockerHost();
    if (this->_dockerHost == NULL) {
        this->_dockerHost = new ::std::string (dockerHost_);
        if (!this->_dockerHost)
            std::abort();
    } else {
        *this->_dockerHost = dockerHost_;
    }
}

inline void BuildInfo_DockerInfo::setDockerHost (const char* dockerHost_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (dockerHost_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_dockerHost();
    if (this->_dockerHost == NULL) {
        this->_dockerHost = new ::std::string (dockerHost_);
        if (!this->_dockerHost)
            std::abort();
    } else {
        this->_dockerHost->assign(dockerHost_);
    }
}

inline void BuildInfo_DockerInfo::setDockerHost (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_dockerHost();
    if (this->_dockerHost == NULL) {
        this->_dockerHost = new ::std::string (value, size);
        if (!this->_dockerHost)
            std::abort();
    } else {
        this->_dockerHost->assign(value, size);
    }
}

inline ::std::string* BuildInfo_DockerInfo::releaseDockerHost() {
    clear_has_dockerHost();
    ::std::string* temp = _dockerHost;
    this->_dockerHost = NULL;
    return temp;
}

inline void BuildInfo_DockerInfo::replaceDockerHost (::std::string* dockerHost_) {
    set_has_dockerHost();
    if (this->_dockerHost != dockerHost_) {
        if (this->_dockerHost != NULL) {
            delete this->_dockerHost;
        }
        this->_dockerHost = dockerHost_;
    }
}

inline void BuildInfo_DockerInfo::clearDockerHostUser() {
    if (hasDockerHostUser()) {
         clear_has_dockerHostUser();
        if (_dockerHostUser != NULL) {
            _dockerHostUser->clear();
        }
     }
}

inline bool BuildInfo_DockerInfo::hasDockerHostUser () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& BuildInfo_DockerInfo::getDockerHostUser () const {
    if (_dockerHostUser == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_dockerHostUser;
}

inline ::std::string& BuildInfo_DockerInfo::getDockerHostUserMutable () {
    set_has_dockerHostUser();
    if (_dockerHostUser == NULL) {
        _dockerHostUser = new ::std::string ();
        if (!_dockerHostUser)
            std::abort();
    }
    return *_dockerHostUser;
}

inline void BuildInfo_DockerInfo::setDockerHostUser (const ::std::string& dockerHostUser_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (dockerHostUser_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_dockerHostUser();
    if (this->_dockerHostUser == NULL) {
        this->_dockerHostUser = new ::std::string (dockerHostUser_);
        if (!this->_dockerHostUser)
            std::abort();
    } else {
        *this->_dockerHostUser = dockerHostUser_;
    }
}

inline void BuildInfo_DockerInfo::setDockerHostUser (const char* dockerHostUser_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (dockerHostUser_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_dockerHostUser();
    if (this->_dockerHostUser == NULL) {
        this->_dockerHostUser = new ::std::string (dockerHostUser_);
        if (!this->_dockerHostUser)
            std::abort();
    } else {
        this->_dockerHostUser->assign(dockerHostUser_);
    }
}

inline void BuildInfo_DockerInfo::setDockerHostUser (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_dockerHostUser();
    if (this->_dockerHostUser == NULL) {
        this->_dockerHostUser = new ::std::string (value, size);
        if (!this->_dockerHostUser)
            std::abort();
    } else {
        this->_dockerHostUser->assign(value, size);
    }
}

inline ::std::string* BuildInfo_DockerInfo::releaseDockerHostUser() {
    clear_has_dockerHostUser();
    ::std::string* temp = _dockerHostUser;
    this->_dockerHostUser = NULL;
    return temp;
}

inline void BuildInfo_DockerInfo::replaceDockerHostUser (::std::string* dockerHostUser_) {
    set_has_dockerHostUser();
    if (this->_dockerHostUser != dockerHostUser_) {
        if (this->_dockerHostUser != NULL) {
            delete this->_dockerHostUser;
        }
        this->_dockerHostUser = dockerHostUser_;
    }
}

inline void BuildInfo_DockerInfo::clearDockerImage() {
    if (hasDockerImage()) {
         clear_has_dockerImage();
        if (_dockerImage != NULL) {
            _dockerImage->clear();
        }
     }
}

inline bool BuildInfo_DockerInfo::hasDockerImage () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& BuildInfo_DockerInfo::getDockerImage () const {
    if (_dockerImage == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_dockerImage;
}

inline ::std::string& BuildInfo_DockerInfo::getDockerImageMutable () {
    set_has_dockerImage();
    if (_dockerImage == NULL) {
        _dockerImage = new ::std::string ();
        if (!_dockerImage)
            std::abort();
    }
    return *_dockerImage;
}

inline void BuildInfo_DockerInfo::setDockerImage (const ::std::string& dockerImage_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (dockerImage_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_dockerImage();
    if (this->_dockerImage == NULL) {
        this->_dockerImage = new ::std::string (dockerImage_);
        if (!this->_dockerImage)
            std::abort();
    } else {
        *this->_dockerImage = dockerImage_;
    }
}

inline void BuildInfo_DockerInfo::setDockerImage (const char* dockerImage_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (dockerImage_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_dockerImage();
    if (this->_dockerImage == NULL) {
        this->_dockerImage = new ::std::string (dockerImage_);
        if (!this->_dockerImage)
            std::abort();
    } else {
        this->_dockerImage->assign(dockerImage_);
    }
}

inline void BuildInfo_DockerInfo::setDockerImage (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_dockerImage();
    if (this->_dockerImage == NULL) {
        this->_dockerImage = new ::std::string (value, size);
        if (!this->_dockerImage)
            std::abort();
    } else {
        this->_dockerImage->assign(value, size);
    }
}

inline ::std::string* BuildInfo_DockerInfo::releaseDockerImage() {
    clear_has_dockerImage();
    ::std::string* temp = _dockerImage;
    this->_dockerImage = NULL;
    return temp;
}

inline void BuildInfo_DockerInfo::replaceDockerImage (::std::string* dockerImage_) {
    set_has_dockerImage();
    if (this->_dockerImage != dockerImage_) {
        if (this->_dockerImage != NULL) {
            delete this->_dockerImage;
        }
        this->_dockerImage = dockerImage_;
    }
}

inline void BuildInfo_DockerInfo::set_has_dockerHost () {
    _has_bits_[0] |= 1u << 0;
}

inline void BuildInfo_DockerInfo::clear_has_dockerHost () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void BuildInfo_DockerInfo::set_has_dockerHostUser () {
    _has_bits_[0] |= 1u << 1;
}

inline void BuildInfo_DockerInfo::clear_has_dockerHostUser () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void BuildInfo_DockerInfo::set_has_dockerImage () {
    _has_bits_[0] |= 1u << 2;
}

inline void BuildInfo_DockerInfo::clear_has_dockerImage () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  BuildInfo_JenkinsInfo::BuildInfo_JenkinsInfo ()  :
    _jenkinsUrl (NULL),
    _jobName (NULL),
    _buildNumber (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BuildInfo_JenkinsInfo::BuildInfo_JenkinsInfo (const BuildInfo_JenkinsInfo &rhs)  :
    _jenkinsUrl (NULL),
    _jobName (NULL),
    _buildNumber (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BuildInfo_JenkinsInfo::BuildInfo_JenkinsInfo (const ::std::string& jenkinsUrl_, const ::std::string& jobName_, const ::std::string& buildNumber_)  :
    _jenkinsUrl (new ::std::string(jenkinsUrl_)),
    _jobName (new ::std::string(jobName_)),
    _buildNumber (new ::std::string(buildNumber_))
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jenkinsUrl_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jobName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (buildNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BuildInfo_JenkinsInfo::~BuildInfo_JenkinsInfo() {
    delete _jenkinsUrl;
    delete _jobName;
    delete _buildNumber;
}

inline BuildInfo_JenkinsInfo& BuildInfo_JenkinsInfo::operator = (const BuildInfo_JenkinsInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasJenkinsUrl()) {
            setJenkinsUrl(rhs.getJenkinsUrl());
        } else {
            clearJenkinsUrl();
        }
        if (rhs.hasJobName()) {
            setJobName(rhs.getJobName());
        } else {
            clearJobName();
        }
        if (rhs.hasBuildNumber()) {
            setBuildNumber(rhs.getBuildNumber());
        } else {
            clearBuildNumber();
        }
    }
    return *this;
}

inline bool BuildInfo_JenkinsInfo::operator == (const BuildInfo_JenkinsInfo& rhs) const {
    return (((!hasJenkinsUrl() && !rhs.hasJenkinsUrl()) || getJenkinsUrl() == rhs.getJenkinsUrl()) &&
        ((!hasJobName() && !rhs.hasJobName()) || getJobName() == rhs.getJobName()) &&
        ((!hasBuildNumber() && !rhs.hasBuildNumber()) || getBuildNumber() == rhs.getBuildNumber()));
}

inline bool BuildInfo_JenkinsInfo::operator != (const BuildInfo_JenkinsInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool BuildInfo_JenkinsInfo::operator < (const BuildInfo_JenkinsInfo& rhs) const {
    if (hasJenkinsUrl() || rhs.hasJenkinsUrl()) {
        if (getJenkinsUrl() < rhs.getJenkinsUrl()) return true;
        if (getJenkinsUrl() > rhs.getJenkinsUrl()) return false;
    }
    if (hasJobName() || rhs.hasJobName()) {
        if (getJobName() < rhs.getJobName()) return true;
        if (getJobName() > rhs.getJobName()) return false;
    }
    if (hasBuildNumber() || rhs.hasBuildNumber()) {
        if (getBuildNumber() < rhs.getBuildNumber()) return true;
        if (getBuildNumber() > rhs.getBuildNumber()) return false;
    }
    return false;
}

inline bool BuildInfo_JenkinsInfo::operator > (const BuildInfo_JenkinsInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BuildInfo_JenkinsInfo::clear() {
    clearJenkinsUrl();
    clearJobName();
    clearBuildNumber();
}

inline void BuildInfo_JenkinsInfo::clearJenkinsUrl() {
    if (hasJenkinsUrl()) {
         clear_has_jenkinsUrl();
        if (_jenkinsUrl != NULL) {
            _jenkinsUrl->clear();
        }
     }
}

inline bool BuildInfo_JenkinsInfo::hasJenkinsUrl () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& BuildInfo_JenkinsInfo::getJenkinsUrl () const {
    if (_jenkinsUrl == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_jenkinsUrl;
}

inline ::std::string& BuildInfo_JenkinsInfo::getJenkinsUrlMutable () {
    set_has_jenkinsUrl();
    if (_jenkinsUrl == NULL) {
        _jenkinsUrl = new ::std::string ();
        if (!_jenkinsUrl)
            std::abort();
    }
    return *_jenkinsUrl;
}

inline void BuildInfo_JenkinsInfo::setJenkinsUrl (const ::std::string& jenkinsUrl_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jenkinsUrl_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jenkinsUrl();
    if (this->_jenkinsUrl == NULL) {
        this->_jenkinsUrl = new ::std::string (jenkinsUrl_);
        if (!this->_jenkinsUrl)
            std::abort();
    } else {
        *this->_jenkinsUrl = jenkinsUrl_;
    }
}

inline void BuildInfo_JenkinsInfo::setJenkinsUrl (const char* jenkinsUrl_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jenkinsUrl_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jenkinsUrl();
    if (this->_jenkinsUrl == NULL) {
        this->_jenkinsUrl = new ::std::string (jenkinsUrl_);
        if (!this->_jenkinsUrl)
            std::abort();
    } else {
        this->_jenkinsUrl->assign(jenkinsUrl_);
    }
}

inline void BuildInfo_JenkinsInfo::setJenkinsUrl (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jenkinsUrl();
    if (this->_jenkinsUrl == NULL) {
        this->_jenkinsUrl = new ::std::string (value, size);
        if (!this->_jenkinsUrl)
            std::abort();
    } else {
        this->_jenkinsUrl->assign(value, size);
    }
}

inline ::std::string* BuildInfo_JenkinsInfo::releaseJenkinsUrl() {
    clear_has_jenkinsUrl();
    ::std::string* temp = _jenkinsUrl;
    this->_jenkinsUrl = NULL;
    return temp;
}

inline void BuildInfo_JenkinsInfo::replaceJenkinsUrl (::std::string* jenkinsUrl_) {
    set_has_jenkinsUrl();
    if (this->_jenkinsUrl != jenkinsUrl_) {
        if (this->_jenkinsUrl != NULL) {
            delete this->_jenkinsUrl;
        }
        this->_jenkinsUrl = jenkinsUrl_;
    }
}

inline void BuildInfo_JenkinsInfo::clearJobName() {
    if (hasJobName()) {
         clear_has_jobName();
        if (_jobName != NULL) {
            _jobName->clear();
        }
     }
}

inline bool BuildInfo_JenkinsInfo::hasJobName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& BuildInfo_JenkinsInfo::getJobName () const {
    if (_jobName == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_jobName;
}

inline ::std::string& BuildInfo_JenkinsInfo::getJobNameMutable () {
    set_has_jobName();
    if (_jobName == NULL) {
        _jobName = new ::std::string ();
        if (!_jobName)
            std::abort();
    }
    return *_jobName;
}

inline void BuildInfo_JenkinsInfo::setJobName (const ::std::string& jobName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jobName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jobName();
    if (this->_jobName == NULL) {
        this->_jobName = new ::std::string (jobName_);
        if (!this->_jobName)
            std::abort();
    } else {
        *this->_jobName = jobName_;
    }
}

inline void BuildInfo_JenkinsInfo::setJobName (const char* jobName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jobName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jobName();
    if (this->_jobName == NULL) {
        this->_jobName = new ::std::string (jobName_);
        if (!this->_jobName)
            std::abort();
    } else {
        this->_jobName->assign(jobName_);
    }
}

inline void BuildInfo_JenkinsInfo::setJobName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jobName();
    if (this->_jobName == NULL) {
        this->_jobName = new ::std::string (value, size);
        if (!this->_jobName)
            std::abort();
    } else {
        this->_jobName->assign(value, size);
    }
}

inline ::std::string* BuildInfo_JenkinsInfo::releaseJobName() {
    clear_has_jobName();
    ::std::string* temp = _jobName;
    this->_jobName = NULL;
    return temp;
}

inline void BuildInfo_JenkinsInfo::replaceJobName (::std::string* jobName_) {
    set_has_jobName();
    if (this->_jobName != jobName_) {
        if (this->_jobName != NULL) {
            delete this->_jobName;
        }
        this->_jobName = jobName_;
    }
}

inline void BuildInfo_JenkinsInfo::clearBuildNumber() {
    if (hasBuildNumber()) {
         clear_has_buildNumber();
        if (_buildNumber != NULL) {
            _buildNumber->clear();
        }
     }
}

inline bool BuildInfo_JenkinsInfo::hasBuildNumber () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& BuildInfo_JenkinsInfo::getBuildNumber () const {
    if (_buildNumber == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_buildNumber;
}

inline ::std::string& BuildInfo_JenkinsInfo::getBuildNumberMutable () {
    set_has_buildNumber();
    if (_buildNumber == NULL) {
        _buildNumber = new ::std::string ();
        if (!_buildNumber)
            std::abort();
    }
    return *_buildNumber;
}

inline void BuildInfo_JenkinsInfo::setBuildNumber (const ::std::string& buildNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (buildNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_buildNumber();
    if (this->_buildNumber == NULL) {
        this->_buildNumber = new ::std::string (buildNumber_);
        if (!this->_buildNumber)
            std::abort();
    } else {
        *this->_buildNumber = buildNumber_;
    }
}

inline void BuildInfo_JenkinsInfo::setBuildNumber (const char* buildNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (buildNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_buildNumber();
    if (this->_buildNumber == NULL) {
        this->_buildNumber = new ::std::string (buildNumber_);
        if (!this->_buildNumber)
            std::abort();
    } else {
        this->_buildNumber->assign(buildNumber_);
    }
}

inline void BuildInfo_JenkinsInfo::setBuildNumber (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_buildNumber();
    if (this->_buildNumber == NULL) {
        this->_buildNumber = new ::std::string (value, size);
        if (!this->_buildNumber)
            std::abort();
    } else {
        this->_buildNumber->assign(value, size);
    }
}

inline ::std::string* BuildInfo_JenkinsInfo::releaseBuildNumber() {
    clear_has_buildNumber();
    ::std::string* temp = _buildNumber;
    this->_buildNumber = NULL;
    return temp;
}

inline void BuildInfo_JenkinsInfo::replaceBuildNumber (::std::string* buildNumber_) {
    set_has_buildNumber();
    if (this->_buildNumber != buildNumber_) {
        if (this->_buildNumber != NULL) {
            delete this->_buildNumber;
        }
        this->_buildNumber = buildNumber_;
    }
}

inline void BuildInfo_JenkinsInfo::set_has_jenkinsUrl () {
    _has_bits_[0] |= 1u << 0;
}

inline void BuildInfo_JenkinsInfo::clear_has_jenkinsUrl () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void BuildInfo_JenkinsInfo::set_has_jobName () {
    _has_bits_[0] |= 1u << 1;
}

inline void BuildInfo_JenkinsInfo::clear_has_jobName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void BuildInfo_JenkinsInfo::set_has_buildNumber () {
    _has_bits_[0] |= 1u << 2;
}

inline void BuildInfo_JenkinsInfo::clear_has_buildNumber () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  BuildInfo::BuildInfo ()  :
    _cmakeInfo (NULL),
    _gitInfo (NULL),
    _hostInfo (NULL),
    _dockerInfo (NULL),
    _jenkinsInfo (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BuildInfo::BuildInfo (const BuildInfo &rhs)  :
    _cmakeInfo (NULL),
    _gitInfo (NULL),
    _hostInfo (NULL),
    _dockerInfo (NULL),
    _jenkinsInfo (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BuildInfo::BuildInfo (const BuildInfo_CMakeInfo& cmakeInfo_, const BuildInfo_GitInfo& gitInfo_, const BuildInfo_HostInfo& hostInfo_, const BuildInfo_DockerInfo& dockerInfo_, const BuildInfo_JenkinsInfo& jenkinsInfo_)  :
    _cmakeInfo (new BuildInfo_CMakeInfo(cmakeInfo_)),
    _gitInfo (new BuildInfo_GitInfo(gitInfo_)),
    _hostInfo (new BuildInfo_HostInfo(hostInfo_)),
    _dockerInfo (new BuildInfo_DockerInfo(dockerInfo_)),
    _jenkinsInfo (new BuildInfo_JenkinsInfo(jenkinsInfo_))
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BuildInfo::~BuildInfo() {
    delete _cmakeInfo;
    delete _gitInfo;
    delete _hostInfo;
    delete _dockerInfo;
    delete _jenkinsInfo;
}

inline BuildInfo& BuildInfo::operator = (const BuildInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasCmakeInfo()) {
            setCmakeInfo(rhs.getCmakeInfo());
        } else {
            clearCmakeInfo();
        }
        if (rhs.hasGitInfo()) {
            setGitInfo(rhs.getGitInfo());
        } else {
            clearGitInfo();
        }
        if (rhs.hasHostInfo()) {
            setHostInfo(rhs.getHostInfo());
        } else {
            clearHostInfo();
        }
        if (rhs.hasDockerInfo()) {
            setDockerInfo(rhs.getDockerInfo());
        } else {
            clearDockerInfo();
        }
        if (rhs.hasJenkinsInfo()) {
            setJenkinsInfo(rhs.getJenkinsInfo());
        } else {
            clearJenkinsInfo();
        }
    }
    return *this;
}

inline bool BuildInfo::operator == (const BuildInfo& rhs) const {
    return (((!hasCmakeInfo() && !rhs.hasCmakeInfo()) || getCmakeInfo() == rhs.getCmakeInfo()) &&
        ((!hasGitInfo() && !rhs.hasGitInfo()) || getGitInfo() == rhs.getGitInfo()) &&
        ((!hasHostInfo() && !rhs.hasHostInfo()) || getHostInfo() == rhs.getHostInfo()) &&
        ((!hasDockerInfo() && !rhs.hasDockerInfo()) || getDockerInfo() == rhs.getDockerInfo()) &&
        ((!hasJenkinsInfo() && !rhs.hasJenkinsInfo()) || getJenkinsInfo() == rhs.getJenkinsInfo()));
}

inline bool BuildInfo::operator != (const BuildInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool BuildInfo::operator < (const BuildInfo& rhs) const {
    if (hasCmakeInfo() || rhs.hasCmakeInfo()) {
        if (getCmakeInfo() < rhs.getCmakeInfo()) return true;
        if (getCmakeInfo() > rhs.getCmakeInfo()) return false;
    }
    if (hasGitInfo() || rhs.hasGitInfo()) {
        if (getGitInfo() < rhs.getGitInfo()) return true;
        if (getGitInfo() > rhs.getGitInfo()) return false;
    }
    if (hasHostInfo() || rhs.hasHostInfo()) {
        if (getHostInfo() < rhs.getHostInfo()) return true;
        if (getHostInfo() > rhs.getHostInfo()) return false;
    }
    if (hasDockerInfo() || rhs.hasDockerInfo()) {
        if (getDockerInfo() < rhs.getDockerInfo()) return true;
        if (getDockerInfo() > rhs.getDockerInfo()) return false;
    }
    if (hasJenkinsInfo() || rhs.hasJenkinsInfo()) {
        if (getJenkinsInfo() < rhs.getJenkinsInfo()) return true;
        if (getJenkinsInfo() > rhs.getJenkinsInfo()) return false;
    }
    return false;
}

inline bool BuildInfo::operator > (const BuildInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BuildInfo::clear() {
    clearCmakeInfo();
    clearGitInfo();
    clearHostInfo();
    clearDockerInfo();
    clearJenkinsInfo();
}

inline void BuildInfo::clearCmakeInfo() {
    if (hasCmakeInfo()) {
         clear_has_cmakeInfo();
        if (_cmakeInfo != NULL) {
            _cmakeInfo->clear();
        }
     }
}

inline bool BuildInfo::hasCmakeInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const BuildInfo_CMakeInfo& BuildInfo::getCmakeInfo () const {
    if (_cmakeInfo == NULL) {
        return BuildInfo_CMakeInfo::getDefaultInstance();
    }
    return *_cmakeInfo;
}

inline BuildInfo_CMakeInfo& BuildInfo::getCmakeInfoMutable () {
    set_has_cmakeInfo();
    if (_cmakeInfo == NULL) {
        _cmakeInfo = new BuildInfo_CMakeInfo ();
        if (!_cmakeInfo)
            std::abort();
    }
    return *_cmakeInfo;
}

inline void BuildInfo::setCmakeInfo (const BuildInfo_CMakeInfo& cmakeInfo_) {
    set_has_cmakeInfo();
    if (this->_cmakeInfo == NULL) {
        this->_cmakeInfo = new BuildInfo_CMakeInfo (cmakeInfo_);
        if (!this->_cmakeInfo)
            std::abort();
    } else {
        *this->_cmakeInfo = cmakeInfo_;
    }
}

inline BuildInfo_CMakeInfo* BuildInfo::releaseCmakeInfo() {
    clear_has_cmakeInfo();
    BuildInfo_CMakeInfo* temp = _cmakeInfo;
    this->_cmakeInfo = NULL;
    return temp;
}

inline void BuildInfo::replaceCmakeInfo (BuildInfo_CMakeInfo* cmakeInfo_) {
    set_has_cmakeInfo();
    if (this->_cmakeInfo != cmakeInfo_) {
        if (this->_cmakeInfo != NULL) {
            delete this->_cmakeInfo;
        }
        this->_cmakeInfo = cmakeInfo_;
    }
}

inline void BuildInfo::clearGitInfo() {
    if (hasGitInfo()) {
         clear_has_gitInfo();
        if (_gitInfo != NULL) {
            _gitInfo->clear();
        }
     }
}

inline bool BuildInfo::hasGitInfo () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const BuildInfo_GitInfo& BuildInfo::getGitInfo () const {
    if (_gitInfo == NULL) {
        return BuildInfo_GitInfo::getDefaultInstance();
    }
    return *_gitInfo;
}

inline BuildInfo_GitInfo& BuildInfo::getGitInfoMutable () {
    set_has_gitInfo();
    if (_gitInfo == NULL) {
        _gitInfo = new BuildInfo_GitInfo ();
        if (!_gitInfo)
            std::abort();
    }
    return *_gitInfo;
}

inline void BuildInfo::setGitInfo (const BuildInfo_GitInfo& gitInfo_) {
    set_has_gitInfo();
    if (this->_gitInfo == NULL) {
        this->_gitInfo = new BuildInfo_GitInfo (gitInfo_);
        if (!this->_gitInfo)
            std::abort();
    } else {
        *this->_gitInfo = gitInfo_;
    }
}

inline BuildInfo_GitInfo* BuildInfo::releaseGitInfo() {
    clear_has_gitInfo();
    BuildInfo_GitInfo* temp = _gitInfo;
    this->_gitInfo = NULL;
    return temp;
}

inline void BuildInfo::replaceGitInfo (BuildInfo_GitInfo* gitInfo_) {
    set_has_gitInfo();
    if (this->_gitInfo != gitInfo_) {
        if (this->_gitInfo != NULL) {
            delete this->_gitInfo;
        }
        this->_gitInfo = gitInfo_;
    }
}

inline void BuildInfo::clearHostInfo() {
    if (hasHostInfo()) {
         clear_has_hostInfo();
        if (_hostInfo != NULL) {
            _hostInfo->clear();
        }
     }
}

inline bool BuildInfo::hasHostInfo () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const BuildInfo_HostInfo& BuildInfo::getHostInfo () const {
    if (_hostInfo == NULL) {
        return BuildInfo_HostInfo::getDefaultInstance();
    }
    return *_hostInfo;
}

inline BuildInfo_HostInfo& BuildInfo::getHostInfoMutable () {
    set_has_hostInfo();
    if (_hostInfo == NULL) {
        _hostInfo = new BuildInfo_HostInfo ();
        if (!_hostInfo)
            std::abort();
    }
    return *_hostInfo;
}

inline void BuildInfo::setHostInfo (const BuildInfo_HostInfo& hostInfo_) {
    set_has_hostInfo();
    if (this->_hostInfo == NULL) {
        this->_hostInfo = new BuildInfo_HostInfo (hostInfo_);
        if (!this->_hostInfo)
            std::abort();
    } else {
        *this->_hostInfo = hostInfo_;
    }
}

inline BuildInfo_HostInfo* BuildInfo::releaseHostInfo() {
    clear_has_hostInfo();
    BuildInfo_HostInfo* temp = _hostInfo;
    this->_hostInfo = NULL;
    return temp;
}

inline void BuildInfo::replaceHostInfo (BuildInfo_HostInfo* hostInfo_) {
    set_has_hostInfo();
    if (this->_hostInfo != hostInfo_) {
        if (this->_hostInfo != NULL) {
            delete this->_hostInfo;
        }
        this->_hostInfo = hostInfo_;
    }
}

inline void BuildInfo::clearDockerInfo() {
    if (hasDockerInfo()) {
         clear_has_dockerInfo();
        if (_dockerInfo != NULL) {
            _dockerInfo->clear();
        }
     }
}

inline bool BuildInfo::hasDockerInfo () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const BuildInfo_DockerInfo& BuildInfo::getDockerInfo () const {
    if (_dockerInfo == NULL) {
        return BuildInfo_DockerInfo::getDefaultInstance();
    }
    return *_dockerInfo;
}

inline BuildInfo_DockerInfo& BuildInfo::getDockerInfoMutable () {
    set_has_dockerInfo();
    if (_dockerInfo == NULL) {
        _dockerInfo = new BuildInfo_DockerInfo ();
        if (!_dockerInfo)
            std::abort();
    }
    return *_dockerInfo;
}

inline void BuildInfo::setDockerInfo (const BuildInfo_DockerInfo& dockerInfo_) {
    set_has_dockerInfo();
    if (this->_dockerInfo == NULL) {
        this->_dockerInfo = new BuildInfo_DockerInfo (dockerInfo_);
        if (!this->_dockerInfo)
            std::abort();
    } else {
        *this->_dockerInfo = dockerInfo_;
    }
}

inline BuildInfo_DockerInfo* BuildInfo::releaseDockerInfo() {
    clear_has_dockerInfo();
    BuildInfo_DockerInfo* temp = _dockerInfo;
    this->_dockerInfo = NULL;
    return temp;
}

inline void BuildInfo::replaceDockerInfo (BuildInfo_DockerInfo* dockerInfo_) {
    set_has_dockerInfo();
    if (this->_dockerInfo != dockerInfo_) {
        if (this->_dockerInfo != NULL) {
            delete this->_dockerInfo;
        }
        this->_dockerInfo = dockerInfo_;
    }
}

inline void BuildInfo::clearJenkinsInfo() {
    if (hasJenkinsInfo()) {
         clear_has_jenkinsInfo();
        if (_jenkinsInfo != NULL) {
            _jenkinsInfo->clear();
        }
     }
}

inline bool BuildInfo::hasJenkinsInfo () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const BuildInfo_JenkinsInfo& BuildInfo::getJenkinsInfo () const {
    if (_jenkinsInfo == NULL) {
        return BuildInfo_JenkinsInfo::getDefaultInstance();
    }
    return *_jenkinsInfo;
}

inline BuildInfo_JenkinsInfo& BuildInfo::getJenkinsInfoMutable () {
    set_has_jenkinsInfo();
    if (_jenkinsInfo == NULL) {
        _jenkinsInfo = new BuildInfo_JenkinsInfo ();
        if (!_jenkinsInfo)
            std::abort();
    }
    return *_jenkinsInfo;
}

inline void BuildInfo::setJenkinsInfo (const BuildInfo_JenkinsInfo& jenkinsInfo_) {
    set_has_jenkinsInfo();
    if (this->_jenkinsInfo == NULL) {
        this->_jenkinsInfo = new BuildInfo_JenkinsInfo (jenkinsInfo_);
        if (!this->_jenkinsInfo)
            std::abort();
    } else {
        *this->_jenkinsInfo = jenkinsInfo_;
    }
}

inline BuildInfo_JenkinsInfo* BuildInfo::releaseJenkinsInfo() {
    clear_has_jenkinsInfo();
    BuildInfo_JenkinsInfo* temp = _jenkinsInfo;
    this->_jenkinsInfo = NULL;
    return temp;
}

inline void BuildInfo::replaceJenkinsInfo (BuildInfo_JenkinsInfo* jenkinsInfo_) {
    set_has_jenkinsInfo();
    if (this->_jenkinsInfo != jenkinsInfo_) {
        if (this->_jenkinsInfo != NULL) {
            delete this->_jenkinsInfo;
        }
        this->_jenkinsInfo = jenkinsInfo_;
    }
}

inline void BuildInfo::set_has_cmakeInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void BuildInfo::clear_has_cmakeInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void BuildInfo::set_has_gitInfo () {
    _has_bits_[0] |= 1u << 1;
}

inline void BuildInfo::clear_has_gitInfo () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void BuildInfo::set_has_hostInfo () {
    _has_bits_[0] |= 1u << 2;
}

inline void BuildInfo::clear_has_hostInfo () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void BuildInfo::set_has_dockerInfo () {
    _has_bits_[0] |= 1u << 3;
}

inline void BuildInfo::clear_has_dockerInfo () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void BuildInfo::set_has_jenkinsInfo () {
    _has_bits_[0] |= 1u << 4;
}

inline void BuildInfo::clear_has_jenkinsInfo () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  LibraryInfo::LibraryInfo ()  :
    _libraryName (NULL),
    _libraryVersion (NULL),
    _buildInfo (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LibraryInfo::LibraryInfo (const LibraryInfo &rhs)  :
    _libraryName (NULL),
    _libraryVersion (NULL),
    _buildInfo (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LibraryInfo::LibraryInfo (const ::std::string& libraryName_, const Version& libraryVersion_, const BuildInfo& buildInfo_)  :
    _libraryName (new ::std::string(libraryName_)),
    _libraryVersion (new Version(libraryVersion_)),
    _buildInfo (new BuildInfo(buildInfo_))
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (libraryName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  LibraryInfo::~LibraryInfo() {
    delete _libraryName;
    delete _libraryVersion;
    delete _buildInfo;
}

inline LibraryInfo& LibraryInfo::operator = (const LibraryInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasLibraryName()) {
            setLibraryName(rhs.getLibraryName());
        } else {
            clearLibraryName();
        }
        if (rhs.hasLibraryVersion()) {
            setLibraryVersion(rhs.getLibraryVersion());
        } else {
            clearLibraryVersion();
        }
        if (rhs.hasBuildInfo()) {
            setBuildInfo(rhs.getBuildInfo());
        } else {
            clearBuildInfo();
        }
    }
    return *this;
}

inline bool LibraryInfo::operator == (const LibraryInfo& rhs) const {
    return (((!hasLibraryName() && !rhs.hasLibraryName()) || getLibraryName() == rhs.getLibraryName()) &&
        ((!hasLibraryVersion() && !rhs.hasLibraryVersion()) || getLibraryVersion() == rhs.getLibraryVersion()) &&
        ((!hasBuildInfo() && !rhs.hasBuildInfo()) || getBuildInfo() == rhs.getBuildInfo()));
}

inline bool LibraryInfo::operator != (const LibraryInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool LibraryInfo::operator < (const LibraryInfo& rhs) const {
    if (hasLibraryName() || rhs.hasLibraryName()) {
        if (getLibraryName() < rhs.getLibraryName()) return true;
        if (getLibraryName() > rhs.getLibraryName()) return false;
    }
    if (hasLibraryVersion() || rhs.hasLibraryVersion()) {
        if (getLibraryVersion() < rhs.getLibraryVersion()) return true;
        if (getLibraryVersion() > rhs.getLibraryVersion()) return false;
    }
    if (hasBuildInfo() || rhs.hasBuildInfo()) {
        if (getBuildInfo() < rhs.getBuildInfo()) return true;
        if (getBuildInfo() > rhs.getBuildInfo()) return false;
    }
    return false;
}

inline bool LibraryInfo::operator > (const LibraryInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LibraryInfo::clear() {
    clearLibraryName();
    clearLibraryVersion();
    clearBuildInfo();
}

inline void LibraryInfo::clearLibraryName() {
    if (hasLibraryName()) {
         clear_has_libraryName();
        if (_libraryName != NULL) {
            _libraryName->clear();
        }
     }
}

inline bool LibraryInfo::hasLibraryName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& LibraryInfo::getLibraryName () const {
    if (_libraryName == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_libraryName;
}

inline ::std::string& LibraryInfo::getLibraryNameMutable () {
    set_has_libraryName();
    if (_libraryName == NULL) {
        _libraryName = new ::std::string ();
        if (!_libraryName)
            std::abort();
    }
    return *_libraryName;
}

inline void LibraryInfo::setLibraryName (const ::std::string& libraryName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (libraryName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_libraryName();
    if (this->_libraryName == NULL) {
        this->_libraryName = new ::std::string (libraryName_);
        if (!this->_libraryName)
            std::abort();
    } else {
        *this->_libraryName = libraryName_;
    }
}

inline void LibraryInfo::setLibraryName (const char* libraryName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (libraryName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_libraryName();
    if (this->_libraryName == NULL) {
        this->_libraryName = new ::std::string (libraryName_);
        if (!this->_libraryName)
            std::abort();
    } else {
        this->_libraryName->assign(libraryName_);
    }
}

inline void LibraryInfo::setLibraryName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_libraryName();
    if (this->_libraryName == NULL) {
        this->_libraryName = new ::std::string (value, size);
        if (!this->_libraryName)
            std::abort();
    } else {
        this->_libraryName->assign(value, size);
    }
}

inline ::std::string* LibraryInfo::releaseLibraryName() {
    clear_has_libraryName();
    ::std::string* temp = _libraryName;
    this->_libraryName = NULL;
    return temp;
}

inline void LibraryInfo::replaceLibraryName (::std::string* libraryName_) {
    set_has_libraryName();
    if (this->_libraryName != libraryName_) {
        if (this->_libraryName != NULL) {
            delete this->_libraryName;
        }
        this->_libraryName = libraryName_;
    }
}

inline void LibraryInfo::clearLibraryVersion() {
    if (hasLibraryVersion()) {
         clear_has_libraryVersion();
        if (_libraryVersion != NULL) {
            _libraryVersion->clear();
        }
     }
}

inline bool LibraryInfo::hasLibraryVersion () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const Version& LibraryInfo::getLibraryVersion () const {
    if (_libraryVersion == NULL) {
        return Version::getDefaultInstance();
    }
    return *_libraryVersion;
}

inline Version& LibraryInfo::getLibraryVersionMutable () {
    set_has_libraryVersion();
    if (_libraryVersion == NULL) {
        _libraryVersion = new Version ();
        if (!_libraryVersion)
            std::abort();
    }
    return *_libraryVersion;
}

inline void LibraryInfo::setLibraryVersion (const Version& libraryVersion_) {
    set_has_libraryVersion();
    if (this->_libraryVersion == NULL) {
        this->_libraryVersion = new Version (libraryVersion_);
        if (!this->_libraryVersion)
            std::abort();
    } else {
        *this->_libraryVersion = libraryVersion_;
    }
}

inline Version* LibraryInfo::releaseLibraryVersion() {
    clear_has_libraryVersion();
    Version* temp = _libraryVersion;
    this->_libraryVersion = NULL;
    return temp;
}

inline void LibraryInfo::replaceLibraryVersion (Version* libraryVersion_) {
    set_has_libraryVersion();
    if (this->_libraryVersion != libraryVersion_) {
        if (this->_libraryVersion != NULL) {
            delete this->_libraryVersion;
        }
        this->_libraryVersion = libraryVersion_;
    }
}

inline void LibraryInfo::clearBuildInfo() {
    if (hasBuildInfo()) {
         clear_has_buildInfo();
        if (_buildInfo != NULL) {
            _buildInfo->clear();
        }
     }
}

inline bool LibraryInfo::hasBuildInfo () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const BuildInfo& LibraryInfo::getBuildInfo () const {
    if (_buildInfo == NULL) {
        return BuildInfo::getDefaultInstance();
    }
    return *_buildInfo;
}

inline BuildInfo& LibraryInfo::getBuildInfoMutable () {
    set_has_buildInfo();
    if (_buildInfo == NULL) {
        _buildInfo = new BuildInfo ();
        if (!_buildInfo)
            std::abort();
    }
    return *_buildInfo;
}

inline void LibraryInfo::setBuildInfo (const BuildInfo& buildInfo_) {
    set_has_buildInfo();
    if (this->_buildInfo == NULL) {
        this->_buildInfo = new BuildInfo (buildInfo_);
        if (!this->_buildInfo)
            std::abort();
    } else {
        *this->_buildInfo = buildInfo_;
    }
}

inline BuildInfo* LibraryInfo::releaseBuildInfo() {
    clear_has_buildInfo();
    BuildInfo* temp = _buildInfo;
    this->_buildInfo = NULL;
    return temp;
}

inline void LibraryInfo::replaceBuildInfo (BuildInfo* buildInfo_) {
    set_has_buildInfo();
    if (this->_buildInfo != buildInfo_) {
        if (this->_buildInfo != NULL) {
            delete this->_buildInfo;
        }
        this->_buildInfo = buildInfo_;
    }
}

inline void LibraryInfo::set_has_libraryName () {
    _has_bits_[0] |= 1u << 0;
}

inline void LibraryInfo::clear_has_libraryName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void LibraryInfo::set_has_libraryVersion () {
    _has_bits_[0] |= 1u << 1;
}

inline void LibraryInfo::clear_has_libraryVersion () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void LibraryInfo::set_has_buildInfo () {
    _has_bits_[0] |= 1u << 2;
}

inline void LibraryInfo::clear_has_buildInfo () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  TimerPayload::TimerPayload ()  :
    _reason (::asf::core::TimerPayload::Reason__Repeat),
    _repeatCount (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TimerPayload::TimerPayload (const TimerPayload &rhs)  :
    ::asf::core::Payload(rhs),
    _reason (::asf::core::TimerPayload::Reason__Repeat),
    _repeatCount (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TimerPayload::TimerPayload (TimerPayload_Reason reason_, uint32 repeatCount_)  :
    _reason (reason_),
    _repeatCount (repeatCount_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(TimerPayload_Reason_IsValid(reason_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", reason_, "Reason", "reason", "TimerPayload");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TimerPayload::~TimerPayload() {
}

inline TimerPayload& TimerPayload::operator = (const TimerPayload& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasReason()) {
            setReason(rhs.getReason());
        } else {
            clearReason();
        }
        if (rhs.hasRepeatCount()) {
            setRepeatCount(rhs.getRepeatCount());
        } else {
            clearRepeatCount();
        }
    }
    return *this;
}

inline bool TimerPayload::operator == (const TimerPayload& rhs) const {
    return (((!hasReason() && !rhs.hasReason()) || getReason() == rhs.getReason()) &&
        ((!hasRepeatCount() && !rhs.hasRepeatCount()) || getRepeatCount() == rhs.getRepeatCount()));
}

inline bool TimerPayload::operator != (const TimerPayload& rhs) const {
    return ! (*this == rhs);
}

inline bool TimerPayload::operator < (const TimerPayload& rhs) const {
    if (hasReason() || rhs.hasReason()) {
        if ((uint32)getReason() < (uint32)rhs.getReason()) return true;
        if ((uint32)getReason() > (uint32)rhs.getReason()) return false;
    }
    if (hasRepeatCount() || rhs.hasRepeatCount()) {
        if (getRepeatCount() < rhs.getRepeatCount()) return true;
        if (getRepeatCount() > rhs.getRepeatCount()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TimerPayload::clone() {
    return new TimerPayload(*this);
}

inline bool TimerPayload::operator > (const TimerPayload& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TimerPayload::clear() {
    clearReason();
    clearRepeatCount();
}

inline void TimerPayload::clearReason() {
    if (hasReason()) {
         clear_has_reason();
        _reason = ::asf::core::TimerPayload::Reason__Repeat;
     }
}

inline bool TimerPayload::hasReason () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline TimerPayload_Reason TimerPayload::getReason () const {
    return _reason;
}

inline void TimerPayload::setReason (TimerPayload_Reason reason_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(TimerPayload_Reason_IsValid(reason_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", reason_, "Reason", "reason", "TimerPayload");
    }
    set_has_reason();
    this->_reason = reason_;
}

inline void TimerPayload::clearRepeatCount() {
    if (hasRepeatCount()) {
         clear_has_repeatCount();
        _repeatCount = 0u;
     }
}

inline bool TimerPayload::hasRepeatCount () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 TimerPayload::getRepeatCount () const {
    return _repeatCount;
}

inline void TimerPayload::setRepeatCount (uint32 repeatCount_) {
    set_has_repeatCount();
    this->_repeatCount = repeatCount_;
}

inline void TimerPayload::set_has_reason () {
    _has_bits_[0] |= 1u << 0;
}

inline void TimerPayload::clear_has_reason () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void TimerPayload::set_has_repeatCount () {
    _has_bits_[0] |= 1u << 1;
}

inline void TimerPayload::clear_has_repeatCount () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace core
} // namespace asf

#endif // ASF_CORE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
