#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ASF_CMS_CMSTYPES_H
#define ASF_CMS_CMSTYPES_H

#include "asf/cms/CmsTypesConst.h"
#include "asf/core/Internal.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * If the meaning of "CmsTypes" isn't clear, then there should be a description here.
 */

namespace asf {
namespace cms {
namespace CmsTypes {

ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 0;

static const int VERSION_MINOR = 1;

static const int VERSION_PATCH = 0;

// forward declarations
class CmsMessageHeader;

class BaseError;

class DefaultMessage;


/**
 * If the meaning of "CmsMessageHeader" isn't clear, then there should be a description here.
 */
class CmsMessageHeader {
public:

    typedef CmsMessageHeader_CmsMessageType CmsMessageType;

    static const CmsMessageType CmsMessageType__Request = CmsMessageHeader_CmsMessageType__Request;
    static const CmsMessageType CmsMessageType__Response = CmsMessageHeader_CmsMessageType__Response;
    static const CmsMessageType CmsMessageType__Get = CmsMessageHeader_CmsMessageType__Get;
    static const CmsMessageType CmsMessageType__Register = CmsMessageHeader_CmsMessageType__Register;
    static const CmsMessageType CmsMessageType__RegisterEventConfirmation = CmsMessageHeader_CmsMessageType__RegisterEventConfirmation;
    static const CmsMessageType CmsMessageType__Deregister = CmsMessageHeader_CmsMessageType__Deregister;
    static const CmsMessageType CmsMessageType__Notify = CmsMessageHeader_CmsMessageType__Notify;
    static const CmsMessageType CmsMessageType__RequestError = CmsMessageHeader_CmsMessageType__RequestError;
    static const CmsMessageType CmsMessageType__RegisterError = CmsMessageHeader_CmsMessageType__RegisterError;
    static const CmsMessageType CmsMessageType__GetError = CmsMessageHeader_CmsMessageType__GetError;
    static const CmsMessageType CmsMessageType__OnewayRequest = CmsMessageHeader_CmsMessageType__OnewayRequest;
    static const CmsMessageType CmsMessageType__ServiceRegister = CmsMessageHeader_CmsMessageType__ServiceRegister;
    static const CmsMessageType CmsMessageType__ServiceDeregister = CmsMessageHeader_CmsMessageType__ServiceDeregister;
    static const CmsMessageType CmsMessageType__ServiceAvailable = CmsMessageHeader_CmsMessageType__ServiceAvailable;
    static const CmsMessageType CmsMessageType__ServiceDisconnected = CmsMessageHeader_CmsMessageType__ServiceDisconnected;
    static const CmsMessageType CmsMessageType__Set = CmsMessageHeader_CmsMessageType__Set;
    static const CmsMessageType CmsMessageType__SetError = CmsMessageHeader_CmsMessageType__SetError;
    static const CmsMessageType CmsMessageType__Abort = CmsMessageHeader_CmsMessageType__Abort;
    static const CmsMessageType CmsMessageType__Progress = CmsMessageHeader_CmsMessageType__Progress;

    static inline const char* CmsMessageType_Name(CmsMessageType value) {
        return CmsMessageHeader_CmsMessageType_Name(value);
    }

    static inline bool CmsMessageType_Parse(const char *str, size_t length, CmsMessageType &value) {
        return CmsMessageHeader_CmsMessageType_Parse(str, length, value);
    }

    static inline bool CmsMessageType_IsValid(CmsMessageType value) {
        return CmsMessageHeader_CmsMessageType_IsValid(value);
    }

    /**
     * Default constructor
     */
    inline  CmsMessageHeader ();

    /**
     * Copy constructor
     */
    inline  CmsMessageHeader (const CmsMessageHeader &rhs);

    /**
     * All fields constructor
     */
    inline  CmsMessageHeader (CmsMessageHeader_CmsMessageType messageType_, const ::std::string& serviceId_, const ::std::string& functionId_, uint32 cct_, uint32 clientId_);

    /**
     * Destructor
     */
    inline  ~CmsMessageHeader();

    /**
     * Assignment operator
     */
    inline CmsMessageHeader& operator = (const CmsMessageHeader& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CmsMessageHeader& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CmsMessageHeader& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CmsMessageHeader& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CmsMessageHeader& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "messageType"

    static const int kMessageType = 0;

    /**
     * Clears the field "messageType".
     *
     * The field will be set to its default value. The hasMessageType()
     * method will return false.
     */
    inline void clearMessageType();

    /**
     * Checks whether the field "messageType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMessageType()). Otherwise it will return false.
     */
    inline bool hasMessageType () const;

    /**
     * Returns the value of the member "messageType".
     *
     * The message type describes the kind of a message. See the corresponding enumeration for
     * available message types.
     *
     * @return The value of the field "messageType"
     */
    inline CmsMessageHeader_CmsMessageType getMessageType () const;

    /**
     * Sets the value of the member "messageType".
     *
     * The message type describes the kind of a message. See the corresponding enumeration for
     * available message types.
     *
     * @param messageType The value which will be set
     */
    inline void setMessageType (CmsMessageHeader_CmsMessageType messageType_);

    // API of field "serviceId"

    static const int kServiceId = 1;

    /**
     * Clears the field "serviceId".
     *
     * The field will be set to its default value. The hasServiceId()
     * method will return false.
     */
    inline void clearServiceId();

    /**
     * Checks whether the field "serviceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceId()). Otherwise it will return false.
     */
    inline bool hasServiceId () const;

    /**
     * Returns the value of the member "serviceId".
     *
     * The Service Id identifies a service instance. With help of the service id the server side
     * will determine the service instance which processes the message.
     *
     * @return The value of the field "serviceId"
     */
    inline const ::std::string& getServiceId () const;

    /**
     * Retrieves the value of the field "serviceId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "serviceId".
     */
    inline ::std::string& getServiceIdMutable ();

    /**
     * Sets the value of the member "serviceId".
     *
     * The Service Id identifies a service instance. With help of the service id the server side
     * will determine the service instance which processes the message.
     *
     * @param serviceId The value which will be set
     */
    inline void setServiceId (const ::std::string& serviceId_);

    /**
     * Sets the value of the member "serviceId".
     *
     * The Service Id identifies a service instance. With help of the service id the server side
     * will determine the service instance which processes the message.
     *
     * @param serviceId The value which will be set
     */
    inline void setServiceId (const char* serviceId_);

    /**
     * Sets the value of the member "serviceId".
     *
     * The Service Id identifies a service instance. With help of the service id the server side
     * will determine the service instance which processes the message.
     *
     * @param serviceId The value which will be set
     */
    inline void setServiceId (const char* value, size_t size);

    /**
     * Release the object stored in the field "serviceId".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "serviceId"
     */
    inline ::std::string* releaseServiceId();

    /**
     * Replace the field "serviceId".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceServiceId (::std::string* serviceId_);

    // API of field "functionId"

    static const int kFunctionId = 2;

    /**
     * Clears the field "functionId".
     *
     * The field will be set to its default value. The hasFunctionId()
     * method will return false.
     */
    inline void clearFunctionId();

    /**
     * Checks whether the field "functionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFunctionId()). Otherwise it will return false.
     */
    inline bool hasFunctionId () const;

    /**
     * Returns the value of the member "functionId".
     *
     * The Function Id identifies a service element from the service identified by the field serviceId.
     * A service element is either a request, property or an event.
     *
     * @return The value of the field "functionId"
     */
    inline const ::std::string& getFunctionId () const;

    /**
     * Retrieves the value of the field "functionId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "functionId".
     */
    inline ::std::string& getFunctionIdMutable ();

    /**
     * Sets the value of the member "functionId".
     *
     * The Function Id identifies a service element from the service identified by the field serviceId.
     * A service element is either a request, property or an event.
     *
     * @param functionId The value which will be set
     */
    inline void setFunctionId (const ::std::string& functionId_);

    /**
     * Sets the value of the member "functionId".
     *
     * The Function Id identifies a service element from the service identified by the field serviceId.
     * A service element is either a request, property or an event.
     *
     * @param functionId The value which will be set
     */
    inline void setFunctionId (const char* functionId_);

    /**
     * Sets the value of the member "functionId".
     *
     * The Function Id identifies a service element from the service identified by the field serviceId.
     * A service element is either a request, property or an event.
     *
     * @param functionId The value which will be set
     */
    inline void setFunctionId (const char* value, size_t size);

    /**
     * Release the object stored in the field "functionId".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "functionId"
     */
    inline ::std::string* releaseFunctionId();

    /**
     * Replace the field "functionId".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceFunctionId (::std::string* functionId_);

    // API of field "cct"

    static const int kCct = 3;

    /**
     * Clears the field "cct".
     *
     * The field will be set to its default value. The hasCct()
     * method will return false.
     */
    inline void clearCct();

    /**
     * Checks whether the field "cct" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCct()). Otherwise it will return false.
     */
    inline bool hasCct () const;

    /**
     * Returns the value of the member "cct".
     *
     * The Client Completion Token (cct) helps to match server side replies to previous client
     * request messages.
     *
     * Whenever the server receives a message it will store the cct. When a reply messages is created
     * the cct is remembered and stored inside this outgoing message.
     *
     * @return The value of the field "cct"
     */
    inline uint32 getCct () const;

    /**
     * Sets the value of the member "cct".
     *
     * The Client Completion Token (cct) helps to match server side replies to previous client
     * request messages.
     *
     * Whenever the server receives a message it will store the cct. When a reply messages is created
     * the cct is remembered and stored inside this outgoing message.
     *
     * @param cct The value which will be set
     */
    inline void setCct (uint32 cct_);

    // API of field "clientId"

    static const int kClientId = 4;

    /**
     * Clears the field "clientId".
     *
     * The field will be set to its default value. The hasClientId()
     * method will return false.
     */
    inline void clearClientId();

    /**
     * Checks whether the field "clientId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClientId()). Otherwise it will return false.
     */
    inline bool hasClientId () const;

    /**
     * Returns the value of the member "clientId".
     *
     * The clientId identifies the client inside an application. When the server replies to a
     * message the same client id will be passed back.
     *
     * @return The value of the field "clientId"
     */
    inline uint32 getClientId () const;

    /**
     * Sets the value of the member "clientId".
     *
     * The clientId identifies the client inside an application. When the server replies to a
     * message the same client id will be passed back.
     *
     * @param clientId The value which will be set
     */
    inline void setClientId (uint32 clientId_);

    static const CmsMessageHeader &getDefaultInstance();

private:

    inline void set_has_messageType ();

    inline void clear_has_messageType ();

    inline void set_has_serviceId ();

    inline void clear_has_serviceId ();

    inline void set_has_functionId ();

    inline void clear_has_functionId ();

    inline void set_has_cct ();

    inline void clear_has_cct ();

    inline void set_has_clientId ();

    inline void clear_has_clientId ();

    uint32 _has_bits_[ (5 + 31) / 32];

    CmsMessageHeader_CmsMessageType _messageType;

    ::std::string* _serviceId;

    ::std::string* _functionId;

    uint32 _cct;

    uint32 _clientId;

};

/**
 * If the meaning of "BaseError" isn't clear, then there should be a description here.
 */
class BaseError  : public ::asf::core::Payload {
public:

    enum BaseErrorField {
        E_SYSTEM_ERROR
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "systemError".
     */
    inline  BaseError ();

   /**
     * Copy constructor
     */
    inline  BaseError (const BaseError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~BaseError();

    /**
     * Assigns a new value to this object.
     */
    inline BaseError& operator = (const BaseError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BaseError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BaseError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BaseError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BaseError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline BaseError::BaseErrorField getField () const;

    inline void setField(BaseError::BaseErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "systemError"

    static const int kSystemError = 0;

    /**
     * Returns true if the field "systemError" has a value.
     *
     * If the meaning of "systemError" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemError", otherwise false
     */
    inline bool hasSystemError () const;

    /**
     * Returns the value of field "systemError".It is only valid to call this
     * method if hasSystemError() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "systemError" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline SystemError getSystemError() const ;

    /**
     * Sets the value of the field "systemError". A field which was previously
     * set will be cleared.
     *
     * If the meaning of "systemError" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemError (SystemError value);

    static const BaseError &getDefaultInstance();

private:

    inline void cloneData (const BaseError& rhs);

    inline void deleteData ();

    BaseErrorField __field;

    union {
        int32 systemError_;
        // extra fields due to @FixedWidthUnion
        uintptr_t __uintptr_t__; // force the union to be of the size of pointer
        int64 __int64__; // force the union to be of the size of a int64 (corner case for 32 bit).
    } _data;

};

/**
 * If the meaning of "DefaultMessage" isn't clear, then there should be a description here.
 */
class DefaultMessage  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DefaultMessage ();

    /**
     * Copy constructor
     */
    inline  DefaultMessage (const DefaultMessage &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DefaultMessage();

    /**
     * Assignment operator
     */
    inline DefaultMessage& operator = (const DefaultMessage& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DefaultMessage& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DefaultMessage& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DefaultMessage& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DefaultMessage& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DefaultMessage &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

inline  CmsMessageHeader::CmsMessageHeader ()  :
    _messageType (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request),
    _serviceId (NULL),
    _functionId (NULL),
    _cct (0u),
    _clientId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CmsMessageHeader::CmsMessageHeader (const CmsMessageHeader &rhs)  :
    _messageType (::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request),
    _serviceId (NULL),
    _functionId (NULL),
    _cct (0u),
    _clientId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CmsMessageHeader::CmsMessageHeader (CmsMessageHeader_CmsMessageType messageType_, const ::std::string& serviceId_, const ::std::string& functionId_, uint32 cct_, uint32 clientId_)  :
    _messageType (messageType_),
    _serviceId (new ::std::string(serviceId_)),
    _functionId (new ::std::string(functionId_)),
    _cct (cct_),
    _clientId (clientId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(CmsMessageHeader_CmsMessageType_IsValid(messageType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", messageType_, "CmsMessageType", "messageType", "CmsMessageHeader");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (serviceId_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (functionId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CmsMessageHeader::~CmsMessageHeader() {
    delete _serviceId;
    delete _functionId;
}

inline CmsMessageHeader& CmsMessageHeader::operator = (const CmsMessageHeader& rhs) {
    if( this != &rhs ) {
        if (rhs.hasMessageType()) {
            setMessageType(rhs.getMessageType());
        } else {
            clearMessageType();
        }
        if (rhs.hasServiceId()) {
            setServiceId(rhs.getServiceId());
        } else {
            clearServiceId();
        }
        if (rhs.hasFunctionId()) {
            setFunctionId(rhs.getFunctionId());
        } else {
            clearFunctionId();
        }
        if (rhs.hasCct()) {
            setCct(rhs.getCct());
        } else {
            clearCct();
        }
        if (rhs.hasClientId()) {
            setClientId(rhs.getClientId());
        } else {
            clearClientId();
        }
    }
    return *this;
}

inline bool CmsMessageHeader::operator == (const CmsMessageHeader& rhs) const {
    return (((!hasMessageType() && !rhs.hasMessageType()) || getMessageType() == rhs.getMessageType()) &&
        ((!hasServiceId() && !rhs.hasServiceId()) || getServiceId() == rhs.getServiceId()) &&
        ((!hasFunctionId() && !rhs.hasFunctionId()) || getFunctionId() == rhs.getFunctionId()) &&
        ((!hasCct() && !rhs.hasCct()) || getCct() == rhs.getCct()) &&
        ((!hasClientId() && !rhs.hasClientId()) || getClientId() == rhs.getClientId()));
}

inline bool CmsMessageHeader::operator != (const CmsMessageHeader& rhs) const {
    return ! (*this == rhs);
}

inline bool CmsMessageHeader::operator < (const CmsMessageHeader& rhs) const {
    if (hasMessageType() || rhs.hasMessageType()) {
        if ((uint32)getMessageType() < (uint32)rhs.getMessageType()) return true;
        if ((uint32)getMessageType() > (uint32)rhs.getMessageType()) return false;
    }
    if (hasServiceId() || rhs.hasServiceId()) {
        if (getServiceId() < rhs.getServiceId()) return true;
        if (getServiceId() > rhs.getServiceId()) return false;
    }
    if (hasFunctionId() || rhs.hasFunctionId()) {
        if (getFunctionId() < rhs.getFunctionId()) return true;
        if (getFunctionId() > rhs.getFunctionId()) return false;
    }
    if (hasCct() || rhs.hasCct()) {
        if (getCct() < rhs.getCct()) return true;
        if (getCct() > rhs.getCct()) return false;
    }
    if (hasClientId() || rhs.hasClientId()) {
        if (getClientId() < rhs.getClientId()) return true;
        if (getClientId() > rhs.getClientId()) return false;
    }
    return false;
}

inline bool CmsMessageHeader::operator > (const CmsMessageHeader& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CmsMessageHeader::clear() {
    clearMessageType();
    clearServiceId();
    clearFunctionId();
    clearCct();
    clearClientId();
}

inline void CmsMessageHeader::clearMessageType() {
    if (hasMessageType()) {
         clear_has_messageType();
        _messageType = ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request;
     }
}

inline bool CmsMessageHeader::hasMessageType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline CmsMessageHeader_CmsMessageType CmsMessageHeader::getMessageType () const {
    return _messageType;
}

inline void CmsMessageHeader::setMessageType (CmsMessageHeader_CmsMessageType messageType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(CmsMessageHeader_CmsMessageType_IsValid(messageType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", messageType_, "CmsMessageType", "messageType", "CmsMessageHeader");
    }
    set_has_messageType();
    this->_messageType = messageType_;
}

inline void CmsMessageHeader::clearServiceId() {
    if (hasServiceId()) {
         clear_has_serviceId();
        if (_serviceId != NULL) {
            _serviceId->clear();
        }
     }
}

inline bool CmsMessageHeader::hasServiceId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& CmsMessageHeader::getServiceId () const {
    if (_serviceId == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_serviceId;
}

inline ::std::string& CmsMessageHeader::getServiceIdMutable () {
    set_has_serviceId();
    if (_serviceId == NULL) {
        _serviceId = new ::std::string ();
        CHECK_ALLOCATION( _serviceId );
    }
    return *_serviceId;
}

inline void CmsMessageHeader::setServiceId (const ::std::string& serviceId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (serviceId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_serviceId();
    if (this->_serviceId == NULL) {
        this->_serviceId = new ::std::string (serviceId_);
        CHECK_ALLOCATION( this->_serviceId );
    } else {
        *this->_serviceId = serviceId_;
    }
}

inline void CmsMessageHeader::setServiceId (const char* serviceId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (serviceId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_serviceId();
    if (this->_serviceId == NULL) {
        this->_serviceId = new ::std::string (serviceId_);
        CHECK_ALLOCATION( this->_serviceId );
    } else {
        this->_serviceId->assign(serviceId_);
    }
}

inline void CmsMessageHeader::setServiceId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_serviceId();
    if (this->_serviceId == NULL) {
        this->_serviceId = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_serviceId );
    } else {
        this->_serviceId->assign(value, size);
    }
}

inline ::std::string* CmsMessageHeader::releaseServiceId() {
    clear_has_serviceId();
    ::std::string* temp = _serviceId;
    this->_serviceId = NULL;
    return temp;
}

inline void CmsMessageHeader::replaceServiceId (::std::string* serviceId_) {
    set_has_serviceId();
    if (this->_serviceId != serviceId_) {
        if (this->_serviceId != NULL) {
            delete this->_serviceId;
        }
        this->_serviceId = serviceId_;
    }
}

inline void CmsMessageHeader::clearFunctionId() {
    if (hasFunctionId()) {
         clear_has_functionId();
        if (_functionId != NULL) {
            _functionId->clear();
        }
     }
}

inline bool CmsMessageHeader::hasFunctionId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& CmsMessageHeader::getFunctionId () const {
    if (_functionId == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_functionId;
}

inline ::std::string& CmsMessageHeader::getFunctionIdMutable () {
    set_has_functionId();
    if (_functionId == NULL) {
        _functionId = new ::std::string ();
        CHECK_ALLOCATION( _functionId );
    }
    return *_functionId;
}

inline void CmsMessageHeader::setFunctionId (const ::std::string& functionId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (functionId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_functionId();
    if (this->_functionId == NULL) {
        this->_functionId = new ::std::string (functionId_);
        CHECK_ALLOCATION( this->_functionId );
    } else {
        *this->_functionId = functionId_;
    }
}

inline void CmsMessageHeader::setFunctionId (const char* functionId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (functionId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_functionId();
    if (this->_functionId == NULL) {
        this->_functionId = new ::std::string (functionId_);
        CHECK_ALLOCATION( this->_functionId );
    } else {
        this->_functionId->assign(functionId_);
    }
}

inline void CmsMessageHeader::setFunctionId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_functionId();
    if (this->_functionId == NULL) {
        this->_functionId = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_functionId );
    } else {
        this->_functionId->assign(value, size);
    }
}

inline ::std::string* CmsMessageHeader::releaseFunctionId() {
    clear_has_functionId();
    ::std::string* temp = _functionId;
    this->_functionId = NULL;
    return temp;
}

inline void CmsMessageHeader::replaceFunctionId (::std::string* functionId_) {
    set_has_functionId();
    if (this->_functionId != functionId_) {
        if (this->_functionId != NULL) {
            delete this->_functionId;
        }
        this->_functionId = functionId_;
    }
}

inline void CmsMessageHeader::clearCct() {
    if (hasCct()) {
         clear_has_cct();
        _cct = 0u;
     }
}

inline bool CmsMessageHeader::hasCct () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 CmsMessageHeader::getCct () const {
    return _cct;
}

inline void CmsMessageHeader::setCct (uint32 cct_) {
    set_has_cct();
    this->_cct = cct_;
}

inline void CmsMessageHeader::clearClientId() {
    if (hasClientId()) {
         clear_has_clientId();
        _clientId = 0u;
     }
}

inline bool CmsMessageHeader::hasClientId () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint32 CmsMessageHeader::getClientId () const {
    return _clientId;
}

inline void CmsMessageHeader::setClientId (uint32 clientId_) {
    set_has_clientId();
    this->_clientId = clientId_;
}

inline void CmsMessageHeader::set_has_messageType () {
    _has_bits_[0] |= 1u << 0;
}

inline void CmsMessageHeader::clear_has_messageType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void CmsMessageHeader::set_has_serviceId () {
    _has_bits_[0] |= 1u << 1;
}

inline void CmsMessageHeader::clear_has_serviceId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void CmsMessageHeader::set_has_functionId () {
    _has_bits_[0] |= 1u << 2;
}

inline void CmsMessageHeader::clear_has_functionId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void CmsMessageHeader::set_has_cct () {
    _has_bits_[0] |= 1u << 3;
}

inline void CmsMessageHeader::clear_has_cct () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void CmsMessageHeader::set_has_clientId () {
    _has_bits_[0] |= 1u << 4;
}

inline void CmsMessageHeader::clear_has_clientId () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  BaseError::BaseError () :
    __field (E_SYSTEM_ERROR),
    _data()
{
    _data.systemError_ = ::asf::cms::CmsTypes::SystemError__Undefined;
}

inline  BaseError::BaseError (const BaseError& rhs) :
::asf::core::Payload(rhs),
    __field (E_SYSTEM_ERROR),
    _data()
{
    _data.systemError_ = ::asf::cms::CmsTypes::SystemError__Undefined;
    *this = rhs;
}

inline  BaseError::~BaseError() {
    deleteData ();
}

inline BaseError& BaseError::operator = (const BaseError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool BaseError::operator == (const BaseError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_SYSTEM_ERROR:
            return (getSystemError() == rhs.getSystemError());
        default:
            return false;
        }
    }
    return false;
}

inline bool BaseError::operator != (const BaseError& rhs) const {
    return ! (*this == rhs);
}

inline bool BaseError::operator < (const BaseError& rhs) const  {
    if (hasSystemError() && rhs.hasSystemError()) {
        if ((uint32)getSystemError() < (uint32)rhs.getSystemError()) return true;
        if ((uint32)getSystemError() > (uint32)rhs.getSystemError()) return false;
    } else {
        if (hasSystemError() && !rhs.hasSystemError())
            return true;
        else if (!hasSystemError() && rhs.hasSystemError())
            return false;
    }

    return false;
}

inline bool BaseError::operator > (const BaseError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline BaseError::BaseErrorField BaseError::getField () const {
    return __field;
}

inline void BaseError::setField(BaseError::BaseErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_SYSTEM_ERROR:
        _data.systemError_ = ::asf::cms::CmsTypes::SystemError__Undefined;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* BaseError::clone() {
    return new BaseError(*this);
}

inline bool BaseError::hasSystemError () const {
    return __field == E_SYSTEM_ERROR;
}

inline SystemError BaseError::getSystemError() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemError(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemError", "BaseError", getField());
    }
    return (SystemError) _data.systemError_;
}

inline void BaseError::setSystemError (SystemError value) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(SystemError_IsValid(value), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemError", "systemError", "BaseError");
    }
    if (__field != E_SYSTEM_ERROR) {
        deleteData ();
        __field = E_SYSTEM_ERROR;
    }
    _data.systemError_ = (int32)value;
}

inline void BaseError::cloneData (const BaseError& rhs) {
    switch (rhs.__field) {
    case E_SYSTEM_ERROR:
        _data.systemError_ = rhs._data.systemError_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void BaseError::deleteData () {
}

inline  DefaultMessage::DefaultMessage () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DefaultMessage::DefaultMessage (const DefaultMessage &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DefaultMessage::~DefaultMessage() {
}

inline DefaultMessage& DefaultMessage::operator = (const DefaultMessage& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool DefaultMessage::operator == (const DefaultMessage& ) const {
    return true;
}

inline bool DefaultMessage::operator != (const DefaultMessage& rhs) const {
    return ! (*this == rhs);
}

inline bool DefaultMessage::operator < (const DefaultMessage& ) const {
    return false;
}

inline ::asf::core::Payload* DefaultMessage::clone() {
    return new DefaultMessage(*this);
}

inline bool DefaultMessage::operator > (const DefaultMessage& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DefaultMessage::clear() {
}

} // namespace CmsTypes
} // namespace cms
} // namespace asf

#endif // ASF_CMS_CMSTYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
