/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2017
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     CmsServiceConnector.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2017 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_CMS_CMSSERVICECONNECTOR_H
#define ASF_CMS_CMSSERVICECONNECTOR_H

#include <cassert>
#include <iostream>
#include <map>
#include <vector>
#include "asf/cms/CmsMessage.h"
#include "asf/cms/CmsStubDelegate.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/threading/Mutex.h"

namespace asf {
namespace cms {

class CmsServiceConnector {
public:
    typedef void (CmsServiceConnector::*MsgFunction)(::asf::cms::CmsMessage& msg);
    typedef std::map< std::string, MsgFunction > MsgFunctionMap;
    typedef std::pair< std::string, MsgFunction > MsgFunctionPair;

    CmsServiceConnector() : _stub(0), _stubDelegate(0) { init(); }

    virtual ~CmsServiceConnector() {
        _stub = 0;
        _stubDelegate = 0;
    }

    const std::string& getServiceId() const {
        if (_stubDelegate != 0) {
            return _stubDelegate->getServiceId();
        }
        return _noServiceId;
    }

    void setServiceStub(CmsStubDelegate& stubDelegate) {
        _stubDelegate = &stubDelegate;
        _stub = stubDelegate.getStub();
    }

    void process(CmsMessage& msg) {
        LOG_ASSERT_FATAL(_stubDelegate);
        _stubDelegate->process(msg);
    }

    void disconnected(::asf::core::ConnectionIFSharedPtr remote) {
        LOG_ASSERT_FATAL(_stubDelegate);
        _stubDelegate->disconnected(remote);
    }

    void dispatch(CmsMessage& msg);

    bool addFunction(CmsTypes::CmsMessageHeader::CmsMessageType type,
                     const std::string& functionId,
                     MsgFunction func);

protected:
    ::asf::core::Stub* _stub;  // user stub (instance of the hand crafted stub implementation)

private:
    CmsStubDelegate* _stubDelegate;

    MsgFunctionMap _getMap;

    MsgFunctionMap _setMap;

    MsgFunctionMap _requestMap;

    MsgFunctionMap _registerMap;

    MsgFunctionMap _deregisterMap;

    MsgFunctionMap _abortMap;

    std::map< int32, MsgFunctionMap* > _mapToMsgType;

    MsgFunctionMap* getMapFromMessageType(CmsTypes::CmsMessageHeader::CmsMessageType type);

    void init();

    DECLARE_CLASS_LOGGER();

    static const std::string _noServiceId;
};

}  // namespace cms
}  // namespace asf

#endif  // ASF_CMS_CMSSERVICECONNECTOR_H
