/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2014
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     CmsProvidedPortListener.h
 *\brief
 *
 *\author   CM-AI/ECA2
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2014-2014 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_CMS_CMSPROVIDEDPORTLISTENER_H
#define ASF_CMS_CMSPROVIDEDPORTLISTENER_H

#include <set>
#include "asf/cms/CmsMessage.h"
#include "asf/core/ProvidedPort.h"

namespace asf {
namespace cms {

struct CmsMessageClientLessThan {
    bool operator()(const CmsMessage& lhs, const CmsMessage& rhs) const {
        return (lhs.getHeader().getClientId() < rhs.getHeader().getClientId() ||
                (lhs.getHeader().getClientId() == rhs.getHeader().getClientId() &&
                 lhs.getRemoteConnection() < rhs.getRemoteConnection()));
    }
};

class CmsProvidedPortListener : public ::asf::core::ProvidedPortListener {
public:
    CmsProvidedPortListener();

    virtual ~CmsProvidedPortListener() {}

    virtual void onServiceMessage(::asf::core::ServiceMessage& msg,
                                  ::asf::core::ProvidedPort& providedPort);

    virtual void onStubConnected();

    virtual void onStubDisconnected();

    virtual void onClientDisconnected(::asf::core::ConnectionIFSharedPtr connection);

private:
    // The CmsMessage identifies a client by the clientId and remote connection
    typedef ::std::set< CmsMessage, CmsMessageClientLessThan > ClientRegistrySet;

    ClientRegistrySet _clientRegistry;

    DECLARE_CLASS_LOGGER();
};

}  // namespace cms
}  // namespace asf

#endif  // ASF_CMS_CMSPROVIDEDPORTLISTENER_H
