/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2013
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     CmsImportedPort.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2013-2013 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_CMS_CMSIMPORTEDPORT_H
#define ASF_CMS_CMSIMPORTEDPORT_H

#include <string>
#include "asf/core/ImportedPort.h"
#include "asf/core/Types.h"
#include "asf/core/Uri.h"

namespace asf {
namespace cms {

class CmsImportedPort : public ::asf::core::ImportedPort {
public:
    CmsImportedPort(const std::string& exportedPortName, const std::string& uri)
        : ImportedPort("", ""), _exportedPortName(exportedPortName), _address(uri) {}

    virtual ~CmsImportedPort() {}

    const ::asf::core::Uri& getAddress() const { return _address; }

    const std::string& getExportedPortName() const { return _exportedPortName; }

private:
    std::string _exportedPortName;  // similar to serviceId in CMS message header

    ::asf::core::Uri _address;
};

}  // namespace cms
}  // namespace asf

#endif  // ASF_CMS_CMSIMPORTEDPORT_H
