/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     CmsHeaderEncoderBin.h
 *\brief    Adds the CmsBin header to outgoing messages and deserializes it
 *          on incoming messages.
 *
 *\author   CM-AI/PJ-CF15
 *          FIXED-TERM.franz.gregor@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2012 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_CMS_CMSHEADERENCODERBIN_H
#define ASF_CMS_CMSHEADERENCODERBIN_H

#include "asf/cms/CmsHeaderEncoderIF.h"
#include "asf/cms/CmsMessage.h"
#include "asf/core/Types.h"

namespace asf {
namespace cms {

class CmsHeaderEncoderBin : public CmsHeaderEncoderIF {
public:
    CmsHeaderEncoderBin() {}

    virtual ~CmsHeaderEncoderBin() {}

    bool deserialize(CmsMessage& msg);

    bool serialize(CmsMessage& msg);
};

}  // namespace cms
}  // namespace asf

#endif  // ASF_CMS_CMSHEADERENCODERBIN_H
