/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2013
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     CmsExports.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2013-2013 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_CMS_CMSEXPORTS_H
#define ASF_CMS_CMSEXPORTS_H

#include <map>
#include <string>
#include "asf/cms/CmsExportedPort.h"
#include "asf/cms/CmsMessage.h"
#include "asf/cms/CmsServiceConnector.h"
#include "asf/cms/CmsServiceStreamer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"

namespace asf {
namespace cms {

class CmsExports {
public:
    CmsExports() {}

    virtual ~CmsExports() {}

    CmsExportedPort& addExport(const std::string& serviceName, const std::string& exportName);

    bool isAvailable(CmsMessage& msg);

    CmsExportedPort* getExport(const std::string& exportName);

private:
    typedef std::map< std::string, CmsExportedPort > ExportMap;

    typedef std::pair< std::string, CmsExportedPort > ExportPair;

    ExportMap _exports;

    DECLARE_CLASS_LOGGER();
};

}  // namespace cms
}  // namespace asf

#endif  // ASF_CMS_CMSEXPORTS_H
