/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2013
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     CmsExportedPort.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2013-2013 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_CMS_CMSEXPORTEDPORT_H
#define ASF_CMS_CMSEXPORTEDPORT_H

#include <string>
#include "asf/cms/CmsServiceConnector.h"
#include "asf/cms/CmsServiceStreamer.h"
#include "asf/core/ExportedPort.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"

namespace asf {
namespace cms {

class CmsExportedPort : public ::asf::core::ExportedPort {
public:
    CmsExportedPort(const std::string& serviceName, const std::string& portName)
        : ExportedPort(serviceName, portName) {}

    virtual ~CmsExportedPort() {}

    void setStreamer(const ::boost::shared_ptr< CmsServiceStreamer >& streamer) {
        _streamer = streamer;
    }

    CmsServiceStreamer& getStreamer() const {
        LOG_SYSTEM_ASSERT_FATAL(_streamer);
        return *_streamer;
    }

private:
    ::boost::shared_ptr< CmsServiceStreamer > _streamer;
};

}  // namespace cms
}  // namespace asf

#endif  // ASF_CMS_CMSEXPORTEDPORT_H
