#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ASF_CCA_CCATYPES_H
#define ASF_CCA_CCATYPES_H

#include "asf/cca/CcaTypesConst.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include <cstring>

/**
 * This type collection specifies the cca message headers as described in
 * "CCA Services - Definition and Use", 02.01, 2011-09-20, see
 * https://hi-dms.de.bosch.com/docushare/dsweb/Get/Document-182610/cca_services_v02.01_english_draft.doc
 */

namespace asf {
namespace cca {
namespace CcaTypes {

ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 2;

static const int VERSION_MINOR = 1;

static const int VERSION_PATCH = 0;

// forward declarations
class PowerMessage;

class ServiceRegister;

class ServiceUnregister;

class ServiceRegisterConfirmation;

class ServiceStatus;

class ServiceData;

class SrvSupplierRegister;

class SrvSupplierStatus;

class AppInfoRegister;

class AppInfoStatus;

class CcaMessageExtension;

class CcaMessageHeader;

class DefaultError;

class DefaultMessage;

// type definitions
/**
 * This message is sent for unregistering a client for the service supplier
 * status message. The client specifies the service.
 */
typedef SrvSupplierRegister SrvSupplierUnregister;

/**
 * If the meaning of "AppInfoUnregister" isn't clear, then there should be a description here.
 */
typedef AppInfoRegister AppInfoUnregister;


/**
 * This message is sent for changing the application states. A detailed description is
 * found in: "Implementation hand book LPX-PRoxy V0.16 (Bruns)". Sending of application
 * status changes occur through the so called PowerMessage messages.
 */
class PowerMessage {
public:

    /**
     * Default constructor
     */
    inline  PowerMessage ();

    /**
     * Copy constructor
     */
    inline  PowerMessage (const PowerMessage &rhs);

    /**
     * All fields constructor
     */
    inline  PowerMessage (uint16 powerType_, uint16 reserved_, uint32 data1_, uint32 data2_);

    /**
     * Destructor
     */
    inline  ~PowerMessage();

    /**
     * Assignment operator
     */
    inline PowerMessage& operator = (const PowerMessage& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PowerMessage& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PowerMessage& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PowerMessage& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PowerMessage& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "powerType"

    static const int kPowerType = 0;

    /**
     * Clears the field "powerType".
     *
     * The field will be set to its default value. The hasPowerType()
     * method will return false.
     */
    inline void clearPowerType();

    /**
     * Checks whether the field "powerType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPowerType()). Otherwise it will return false.
     */
    inline bool hasPowerType () const;

    /**
     * Returns the value of the member "powerType".
     *
     * If the meaning of "powerType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "powerType"
     */
    inline uint16 getPowerType () const;

    /**
     * Sets the value of the member "powerType".
     *
     * If the meaning of "powerType" isn't clear, then there should be a description here.
     *
     * @param powerType The value which will be set
     */
    inline void setPowerType (uint16 powerType_);

    // API of field "reserved"

    static const int kReserved = 1;

    /**
     * Clears the field "reserved".
     *
     * The field will be set to its default value. The hasReserved()
     * method will return false.
     */
    inline void clearReserved();

    /**
     * Checks whether the field "reserved" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReserved()). Otherwise it will return false.
     */
    inline bool hasReserved () const;

    /**
     * Returns the value of the member "reserved".
     *
     * If the meaning of "reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "reserved"
     */
    inline uint16 getReserved () const;

    /**
     * Sets the value of the member "reserved".
     *
     * If the meaning of "reserved" isn't clear, then there should be a description here.
     *
     * @param reserved The value which will be set
     */
    inline void setReserved (uint16 reserved_);

    // API of field "data1"

    static const int kData1 = 2;

    /**
     * Clears the field "data1".
     *
     * The field will be set to its default value. The hasData1()
     * method will return false.
     */
    inline void clearData1();

    /**
     * Checks whether the field "data1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData1()). Otherwise it will return false.
     */
    inline bool hasData1 () const;

    /**
     * Returns the value of the member "data1".
     *
     * If the meaning of "data1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data1"
     */
    inline uint32 getData1 () const;

    /**
     * Sets the value of the member "data1".
     *
     * If the meaning of "data1" isn't clear, then there should be a description here.
     *
     * @param data1 The value which will be set
     */
    inline void setData1 (uint32 data1_);

    // API of field "data2"

    static const int kData2 = 3;

    /**
     * Clears the field "data2".
     *
     * The field will be set to its default value. The hasData2()
     * method will return false.
     */
    inline void clearData2();

    /**
     * Checks whether the field "data2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData2()). Otherwise it will return false.
     */
    inline bool hasData2 () const;

    /**
     * Returns the value of the member "data2".
     *
     * If the meaning of "data2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data2"
     */
    inline uint32 getData2 () const;

    /**
     * Sets the value of the member "data2".
     *
     * If the meaning of "data2" isn't clear, then there should be a description here.
     *
     * @param data2 The value which will be set
     */
    inline void setData2 (uint32 data2_);

    static const PowerMessage &getDefaultInstance();

private:

    inline void set_has_powerType ();

    inline void clear_has_powerType ();

    inline void set_has_reserved ();

    inline void clear_has_reserved ();

    inline void set_has_data1 ();

    inline void clear_has_data1 ();

    inline void set_has_data2 ();

    inline void clear_has_data2 ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint16 _powerType;

    uint16 _reserved;

    uint32 _data1;

    uint32 _data2;

};

/**
 * This message is sent for registering a client to a server. The service decides based
 * on the version (major, minor), whether the registration is successfully carried out.
 */
class ServiceRegister {
public:

    /**
     * Default constructor
     */
    inline  ServiceRegister ();

    /**
     * Copy constructor
     */
    inline  ServiceRegister (const ServiceRegister &rhs);

    /**
     * All fields constructor
     */
    inline  ServiceRegister (uint16 serviceId_, uint16 majorVersion_, uint16 minorVersion_);

    /**
     * Destructor
     */
    inline  ~ServiceRegister();

    /**
     * Assignment operator
     */
    inline ServiceRegister& operator = (const ServiceRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ServiceRegister& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ServiceRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ServiceRegister& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ServiceRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "serviceId"

    static const int kServiceId = 0;

    /**
     * Clears the field "serviceId".
     *
     * The field will be set to its default value. The hasServiceId()
     * method will return false.
     */
    inline void clearServiceId();

    /**
     * Checks whether the field "serviceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceId()). Otherwise it will return false.
     */
    inline bool hasServiceId () const;

    /**
     * Returns the value of the member "serviceId".
     *
     * Service Identifier
     *
     * @return The value of the field "serviceId"
     */
    inline uint16 getServiceId () const;

    /**
     * Sets the value of the member "serviceId".
     *
     * Service Identifier
     *
     * @param serviceId The value which will be set
     */
    inline void setServiceId (uint16 serviceId_);

    // API of field "majorVersion"

    static const int kMajorVersion = 1;

    /**
     * Clears the field "majorVersion".
     *
     * The field will be set to its default value. The hasMajorVersion()
     * method will return false.
     */
    inline void clearMajorVersion();

    /**
     * Checks whether the field "majorVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMajorVersion()). Otherwise it will return false.
     */
    inline bool hasMajorVersion () const;

    /**
     * Returns the value of the member "majorVersion".
     *
     * Required major version number of the service
     *
     * @return The value of the field "majorVersion"
     */
    inline uint16 getMajorVersion () const;

    /**
     * Sets the value of the member "majorVersion".
     *
     * Required major version number of the service
     *
     * @param majorVersion The value which will be set
     */
    inline void setMajorVersion (uint16 majorVersion_);

    // API of field "minorVersion"

    static const int kMinorVersion = 2;

    /**
     * Clears the field "minorVersion".
     *
     * The field will be set to its default value. The hasMinorVersion()
     * method will return false.
     */
    inline void clearMinorVersion();

    /**
     * Checks whether the field "minorVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMinorVersion()). Otherwise it will return false.
     */
    inline bool hasMinorVersion () const;

    /**
     * Returns the value of the member "minorVersion".
     *
     * Required minor version number of the service
     *
     * @return The value of the field "minorVersion"
     */
    inline uint16 getMinorVersion () const;

    /**
     * Sets the value of the member "minorVersion".
     *
     * Required minor version number of the service
     *
     * @param minorVersion The value which will be set
     */
    inline void setMinorVersion (uint16 minorVersion_);

    static const ServiceRegister &getDefaultInstance();

private:

    inline void set_has_serviceId ();

    inline void clear_has_serviceId ();

    inline void set_has_majorVersion ();

    inline void clear_has_majorVersion ();

    inline void set_has_minorVersion ();

    inline void clear_has_minorVersion ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _serviceId;

    uint16 _majorVersion;

    uint16 _minorVersion;

};

/**
 * This message is used to deregister a service. The client must ensure, that the
 * tuple (SourceAppId, SourceSubIds, ServiceId, RegisterId) corresponds to the data
 * which is used for registration and confirmation. A deletion of all registrations
 * of a client is not possible by just one message.
 */
class ServiceUnregister {
public:

    /**
     * Default constructor
     */
    inline  ServiceUnregister ();

    /**
     * Copy constructor
     */
    inline  ServiceUnregister (const ServiceUnregister &rhs);

    /**
     * All fields constructor
     */
    inline  ServiceUnregister (uint16 serviceId_, uint16 registerId_);

    /**
     * Destructor
     */
    inline  ~ServiceUnregister();

    /**
     * Assignment operator
     */
    inline ServiceUnregister& operator = (const ServiceUnregister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ServiceUnregister& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ServiceUnregister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ServiceUnregister& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ServiceUnregister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "serviceId"

    static const int kServiceId = 0;

    /**
     * Clears the field "serviceId".
     *
     * The field will be set to its default value. The hasServiceId()
     * method will return false.
     */
    inline void clearServiceId();

    /**
     * Checks whether the field "serviceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceId()). Otherwise it will return false.
     */
    inline bool hasServiceId () const;

    /**
     * Returns the value of the member "serviceId".
     *
     * Service Identifier
     *
     * @return The value of the field "serviceId"
     */
    inline uint16 getServiceId () const;

    /**
     * Sets the value of the member "serviceId".
     *
     * Service Identifier
     *
     * @param serviceId The value which will be set
     */
    inline void setServiceId (uint16 serviceId_);

    // API of field "registerId"

    static const int kRegisterId = 1;

    /**
     * Clears the field "registerId".
     *
     * The field will be set to its default value. The hasRegisterId()
     * method will return false.
     */
    inline void clearRegisterId();

    /**
     * Checks whether the field "registerId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegisterId()). Otherwise it will return false.
     */
    inline bool hasRegisterId () const;

    /**
     * Returns the value of the member "registerId".
     *
     * Register Identification
     *
     * @return The value of the field "registerId"
     */
    inline uint16 getRegisterId () const;

    /**
     * Sets the value of the member "registerId".
     *
     * Register Identification
     *
     * @param registerId The value which will be set
     */
    inline void setRegisterId (uint16 registerId_);

    static const ServiceUnregister &getDefaultInstance();

private:

    inline void set_has_serviceId ();

    inline void clear_has_serviceId ();

    inline void set_has_registerId ();

    inline void clear_has_registerId ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _serviceId;

    uint16 _registerId;

};

/**
 * This message is sent from the server to the client as a response to the
 * registration of a service.
 */
class ServiceRegisterConfirmation {
public:

    /**
     * Default constructor
     */
    inline  ServiceRegisterConfirmation ();

    /**
     * Copy constructor
     */
    inline  ServiceRegisterConfirmation (const ServiceRegisterConfirmation &rhs);

    /**
     * All fields constructor
     */
    inline  ServiceRegisterConfirmation (uint16 serviceId_, uint16 registerId_, RegistrationStatus status_, uint8 reserverd_, uint16 majorVersion_, uint16 minorVersion_, uint16 patchVersion_);

    /**
     * Destructor
     */
    inline  ~ServiceRegisterConfirmation();

    /**
     * Assignment operator
     */
    inline ServiceRegisterConfirmation& operator = (const ServiceRegisterConfirmation& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ServiceRegisterConfirmation& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ServiceRegisterConfirmation& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ServiceRegisterConfirmation& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ServiceRegisterConfirmation& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "serviceId"

    static const int kServiceId = 0;

    /**
     * Clears the field "serviceId".
     *
     * The field will be set to its default value. The hasServiceId()
     * method will return false.
     */
    inline void clearServiceId();

    /**
     * Checks whether the field "serviceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceId()). Otherwise it will return false.
     */
    inline bool hasServiceId () const;

    /**
     * Returns the value of the member "serviceId".
     *
     * Service Identifier
     *
     * @return The value of the field "serviceId"
     */
    inline uint16 getServiceId () const;

    /**
     * Sets the value of the member "serviceId".
     *
     * Service Identifier
     *
     * @param serviceId The value which will be set
     */
    inline void setServiceId (uint16 serviceId_);

    // API of field "registerId"

    static const int kRegisterId = 1;

    /**
     * Clears the field "registerId".
     *
     * The field will be set to its default value. The hasRegisterId()
     * method will return false.
     */
    inline void clearRegisterId();

    /**
     * Checks whether the field "registerId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegisterId()). Otherwise it will return false.
     */
    inline bool hasRegisterId () const;

    /**
     * Returns the value of the member "registerId".
     *
     * Register Identification
     *
     * @return The value of the field "registerId"
     */
    inline uint16 getRegisterId () const;

    /**
     * Sets the value of the member "registerId".
     *
     * Register Identification
     *
     * @param registerId The value which will be set
     */
    inline void setRegisterId (uint16 registerId_);

    // API of field "status"

    static const int kStatus = 2;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * Status of registration
     *
     * @return The value of the field "status"
     */
    inline RegistrationStatus getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * Status of registration
     *
     * @param status The value which will be set
     */
    inline void setStatus (RegistrationStatus status_);

    // API of field "reserverd"

    static const int kReserverd = 3;

    /**
     * Clears the field "reserverd".
     *
     * The field will be set to its default value. The hasReserverd()
     * method will return false.
     */
    inline void clearReserverd();

    /**
     * Checks whether the field "reserverd" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReserverd()). Otherwise it will return false.
     */
    inline bool hasReserverd () const;

    /**
     * Returns the value of the member "reserverd".
     *
     * If the meaning of "reserverd" isn't clear, then there should be a description here.
     *
     * @return The value of the field "reserverd"
     */
    inline uint8 getReserverd () const;

    /**
     * Sets the value of the member "reserverd".
     *
     * If the meaning of "reserverd" isn't clear, then there should be a description here.
     *
     * @param reserverd The value which will be set
     */
    inline void setReserverd (uint8 reserverd_);

    // API of field "majorVersion"

    static const int kMajorVersion = 4;

    /**
     * Clears the field "majorVersion".
     *
     * The field will be set to its default value. The hasMajorVersion()
     * method will return false.
     */
    inline void clearMajorVersion();

    /**
     * Checks whether the field "majorVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMajorVersion()). Otherwise it will return false.
     */
    inline bool hasMajorVersion () const;

    /**
     * Returns the value of the member "majorVersion".
     *
     * Major version of the service
     *
     * @return The value of the field "majorVersion"
     */
    inline uint16 getMajorVersion () const;

    /**
     * Sets the value of the member "majorVersion".
     *
     * Major version of the service
     *
     * @param majorVersion The value which will be set
     */
    inline void setMajorVersion (uint16 majorVersion_);

    // API of field "minorVersion"

    static const int kMinorVersion = 5;

    /**
     * Clears the field "minorVersion".
     *
     * The field will be set to its default value. The hasMinorVersion()
     * method will return false.
     */
    inline void clearMinorVersion();

    /**
     * Checks whether the field "minorVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMinorVersion()). Otherwise it will return false.
     */
    inline bool hasMinorVersion () const;

    /**
     * Returns the value of the member "minorVersion".
     *
     * Minor version of the service
     *
     * @return The value of the field "minorVersion"
     */
    inline uint16 getMinorVersion () const;

    /**
     * Sets the value of the member "minorVersion".
     *
     * Minor version of the service
     *
     * @param minorVersion The value which will be set
     */
    inline void setMinorVersion (uint16 minorVersion_);

    // API of field "patchVersion"

    static const int kPatchVersion = 6;

    /**
     * Clears the field "patchVersion".
     *
     * The field will be set to its default value. The hasPatchVersion()
     * method will return false.
     */
    inline void clearPatchVersion();

    /**
     * Checks whether the field "patchVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPatchVersion()). Otherwise it will return false.
     */
    inline bool hasPatchVersion () const;

    /**
     * Returns the value of the member "patchVersion".
     *
     * Patch version of the service
     *
     * @return The value of the field "patchVersion"
     */
    inline uint16 getPatchVersion () const;

    /**
     * Sets the value of the member "patchVersion".
     *
     * Patch version of the service
     *
     * @param patchVersion The value which will be set
     */
    inline void setPatchVersion (uint16 patchVersion_);

    static const ServiceRegisterConfirmation &getDefaultInstance();

private:

    inline void set_has_serviceId ();

    inline void clear_has_serviceId ();

    inline void set_has_registerId ();

    inline void clear_has_registerId ();

    inline void set_has_status ();

    inline void clear_has_status ();

    inline void set_has_reserverd ();

    inline void clear_has_reserverd ();

    inline void set_has_majorVersion ();

    inline void clear_has_majorVersion ();

    inline void set_has_minorVersion ();

    inline void clear_has_minorVersion ();

    inline void set_has_patchVersion ();

    inline void clear_has_patchVersion ();

    uint32 _has_bits_[ (7 + 31) / 32];

    uint16 _serviceId;

    uint16 _registerId;

    RegistrationStatus _status;

    uint8 _reserverd;

    uint16 _majorVersion;

    uint16 _minorVersion;

    uint16 _patchVersion;

};

/**
 * This message is spontaneously sent form the server to the client to indicate
 * the availability of the service of a client. This message Id will be sent only if there
 * is a change in the availability.
 */
class ServiceStatus {
public:

    /**
     * Default constructor
     */
    inline  ServiceStatus ();

    /**
     * Copy constructor
     */
    inline  ServiceStatus (const ServiceStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ServiceStatus (uint16 serviceId_, uint16 registerId_, AvailabilityState state_, uint8 reserverd_);

    /**
     * Destructor
     */
    inline  ~ServiceStatus();

    /**
     * Assignment operator
     */
    inline ServiceStatus& operator = (const ServiceStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ServiceStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ServiceStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ServiceStatus& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ServiceStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "serviceId"

    static const int kServiceId = 0;

    /**
     * Clears the field "serviceId".
     *
     * The field will be set to its default value. The hasServiceId()
     * method will return false.
     */
    inline void clearServiceId();

    /**
     * Checks whether the field "serviceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceId()). Otherwise it will return false.
     */
    inline bool hasServiceId () const;

    /**
     * Returns the value of the member "serviceId".
     *
     * Service Identifier
     *
     * @return The value of the field "serviceId"
     */
    inline uint16 getServiceId () const;

    /**
     * Sets the value of the member "serviceId".
     *
     * Service Identifier
     *
     * @param serviceId The value which will be set
     */
    inline void setServiceId (uint16 serviceId_);

    // API of field "registerId"

    static const int kRegisterId = 1;

    /**
     * Clears the field "registerId".
     *
     * The field will be set to its default value. The hasRegisterId()
     * method will return false.
     */
    inline void clearRegisterId();

    /**
     * Checks whether the field "registerId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegisterId()). Otherwise it will return false.
     */
    inline bool hasRegisterId () const;

    /**
     * Returns the value of the member "registerId".
     *
     * Register Identification
     *
     * @return The value of the field "registerId"
     */
    inline uint16 getRegisterId () const;

    /**
     * Sets the value of the member "registerId".
     *
     * Register Identification
     *
     * @param registerId The value which will be set
     */
    inline void setRegisterId (uint16 registerId_);

    // API of field "state"

    static const int kState = 2;

    /**
     * Clears the field "state".
     *
     * The field will be set to its default value. The hasState()
     * method will return false.
     */
    inline void clearState();

    /**
     * Checks whether the field "state" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState()). Otherwise it will return false.
     */
    inline bool hasState () const;

    /**
     * Returns the value of the member "state".
     *
     * Status of registration
     *
     * @return The value of the field "state"
     */
    inline AvailabilityState getState () const;

    /**
     * Sets the value of the member "state".
     *
     * Status of registration
     *
     * @param state The value which will be set
     */
    inline void setState (AvailabilityState state_);

    // API of field "reserverd"

    static const int kReserverd = 3;

    /**
     * Clears the field "reserverd".
     *
     * The field will be set to its default value. The hasReserverd()
     * method will return false.
     */
    inline void clearReserverd();

    /**
     * Checks whether the field "reserverd" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReserverd()). Otherwise it will return false.
     */
    inline bool hasReserverd () const;

    /**
     * Returns the value of the member "reserverd".
     *
     * If the meaning of "reserverd" isn't clear, then there should be a description here.
     *
     * @return The value of the field "reserverd"
     */
    inline uint8 getReserverd () const;

    /**
     * Sets the value of the member "reserverd".
     *
     * If the meaning of "reserverd" isn't clear, then there should be a description here.
     *
     * @param reserverd The value which will be set
     */
    inline void setReserverd (uint8 reserverd_);

    static const ServiceStatus &getDefaultInstance();

private:

    inline void set_has_serviceId ();

    inline void clear_has_serviceId ();

    inline void set_has_registerId ();

    inline void clear_has_registerId ();

    inline void set_has_state ();

    inline void clear_has_state ();

    inline void set_has_reserverd ();

    inline void clear_has_reserverd ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint16 _serviceId;

    uint16 _registerId;

    AvailabilityState _state;

    uint8 _reserverd;

};

/**
 * This message helps in manipulation of properties in the method call. It
 * is also used by the server(response) along with the client (query). This
 * extended message header is linked directly with data domain. Its formatting
 * is application dependent and is to be defined in the interface definition
 * of the corresponding application.
 *
 * The fields ServiceId, RegisterId, CommandCounter, FunctionId and ACT that
 * are set by the call from the client are taken over in the response from the
 * the server. The field StreamCounter are set to their corresponding values
 * from the server. The field OpCode is set both by the client and the server
 * and are differentiated in the query and response.
 *
 * The so called Asynchronous Completion Token (ACT) can be set by the client
 * among others of many queries are sent to one or many servers and waited
 * synchronously for a response. The server returns the token unchanged in
 * the response and with this, helps the client in simple assignment.
 */
class ServiceData {
public:

    typedef ServiceData_OpCode OpCode;

    static const OpCode OpCode__Set = ServiceData_OpCode__Set;
    static const OpCode OpCode__Get = ServiceData_OpCode__Get;
    static const OpCode OpCode__MethodStart = ServiceData_OpCode__MethodStart;
    static const OpCode OpCode__UpReg = ServiceData_OpCode__UpReg;
    static const OpCode OpCode__RelUpReg = ServiceData_OpCode__RelUpReg;
    static const OpCode OpCode__MethodAbort = ServiceData_OpCode__MethodAbort;
    static const OpCode OpCode__Status = ServiceData_OpCode__Status;
    static const OpCode OpCode__MethodResult = ServiceData_OpCode__MethodResult;
    static const OpCode OpCode__Error = ServiceData_OpCode__Error;
    static const OpCode OpCode__AbortResult = ServiceData_OpCode__AbortResult;
    static const OpCode OpCode__MethodResultFirst = ServiceData_OpCode__MethodResultFirst;
    static const OpCode OpCode__MethodResultMiddle = ServiceData_OpCode__MethodResultMiddle;
    static const OpCode OpCode__MethodResultLast = ServiceData_OpCode__MethodResultLast;
    static const OpCode OpCode__ClientPortAck = ServiceData_OpCode__ClientPortAck;
    static const OpCode OpCode__ServerPortAck = ServiceData_OpCode__ServerPortAck;
    static const OpCode OpCode__Increment = ServiceData_OpCode__Increment;
    static const OpCode OpCode__Decrement = ServiceData_OpCode__Decrement;
    static const OpCode OpCode__PureSet = ServiceData_OpCode__PureSet;

    static inline const char* OpCode_Name(OpCode value) {
        return ServiceData_OpCode_Name(value);
    }

    static inline bool OpCode_Parse(const char *str, size_t length, OpCode &value) {
        return ServiceData_OpCode_Parse(str, length, value);
    }

    static inline bool OpCode_IsValid(OpCode value) {
        return ServiceData_OpCode_IsValid(value);
    }

    /**
     * Default constructor
     */
    inline  ServiceData ();

    /**
     * Copy constructor
     */
    inline  ServiceData (const ServiceData &rhs);

    /**
     * All fields constructor
     */
    inline  ServiceData (uint16 serviceId_, uint16 registerId_, uint16 functionId_, ServiceData_OpCode opCode_, uint8 act_, uint16 commandCounter_, uint8 streamType_, uint8 streamCounter_);

    /**
     * Destructor
     */
    inline  ~ServiceData();

    /**
     * Assignment operator
     */
    inline ServiceData& operator = (const ServiceData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ServiceData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ServiceData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ServiceData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ServiceData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "serviceId"

    static const int kServiceId = 0;

    /**
     * Clears the field "serviceId".
     *
     * The field will be set to its default value. The hasServiceId()
     * method will return false.
     */
    inline void clearServiceId();

    /**
     * Checks whether the field "serviceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceId()). Otherwise it will return false.
     */
    inline bool hasServiceId () const;

    /**
     * Returns the value of the member "serviceId".
     *
     * Service Identifier
     *
     * @return The value of the field "serviceId"
     */
    inline uint16 getServiceId () const;

    /**
     * Sets the value of the member "serviceId".
     *
     * Service Identifier
     *
     * @param serviceId The value which will be set
     */
    inline void setServiceId (uint16 serviceId_);

    // API of field "registerId"

    static const int kRegisterId = 1;

    /**
     * Clears the field "registerId".
     *
     * The field will be set to its default value. The hasRegisterId()
     * method will return false.
     */
    inline void clearRegisterId();

    /**
     * Checks whether the field "registerId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegisterId()). Otherwise it will return false.
     */
    inline bool hasRegisterId () const;

    /**
     * Returns the value of the member "registerId".
     *
     * Register Identification
     *
     * @return The value of the field "registerId"
     */
    inline uint16 getRegisterId () const;

    /**
     * Sets the value of the member "registerId".
     *
     * Register Identification
     *
     * @param registerId The value which will be set
     */
    inline void setRegisterId (uint16 registerId_);

    // API of field "functionId"

    static const int kFunctionId = 2;

    /**
     * Clears the field "functionId".
     *
     * The field will be set to its default value. The hasFunctionId()
     * method will return false.
     */
    inline void clearFunctionId();

    /**
     * Checks whether the field "functionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFunctionId()). Otherwise it will return false.
     */
    inline bool hasFunctionId () const;

    /**
     * Returns the value of the member "functionId".
     *
     * Function Identifier
     *
     * @return The value of the field "functionId"
     */
    inline uint16 getFunctionId () const;

    /**
     * Sets the value of the member "functionId".
     *
     * Function Identifier
     *
     * @param functionId The value which will be set
     */
    inline void setFunctionId (uint16 functionId_);

    // API of field "opCode"

    static const int kOpCode = 3;

    /**
     * Clears the field "opCode".
     *
     * The field will be set to its default value. The hasOpCode()
     * method will return false.
     */
    inline void clearOpCode();

    /**
     * Checks whether the field "opCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOpCode()). Otherwise it will return false.
     */
    inline bool hasOpCode () const;

    /**
     * Returns the value of the member "opCode".
     *
     * Code of the function
     *
     * @return The value of the field "opCode"
     */
    inline ServiceData_OpCode getOpCode () const;

    /**
     * Sets the value of the member "opCode".
     *
     * Code of the function
     *
     * @param opCode The value which will be set
     */
    inline void setOpCode (ServiceData_OpCode opCode_);

    // API of field "act"

    static const int kAct = 4;

    /**
     * Clears the field "act".
     *
     * The field will be set to its default value. The hasAct()
     * method will return false.
     */
    inline void clearAct();

    /**
     * Checks whether the field "act" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAct()). Otherwise it will return false.
     */
    inline bool hasAct () const;

    /**
     * Returns the value of the member "act".
     *
     * The asynchronous completion token can be set by the client and is taken over
     * in the response without the interpretation of the server. The behavior in case
     * of spontaneous changes is Identical to "Command Counter".
     *
     * @return The value of the field "act"
     */
    inline uint8 getAct () const;

    /**
     * Sets the value of the member "act".
     *
     * The asynchronous completion token can be set by the client and is taken over
     * in the response without the interpretation of the server. The behavior in case
     * of spontaneous changes is Identical to "Command Counter".
     *
     * @param act The value which will be set
     */
    inline void setAct (uint8 act_);

    // API of field "commandCounter"

    static const int kCommandCounter = 5;

    /**
     * Clears the field "commandCounter".
     *
     * The field will be set to its default value. The hasCommandCounter()
     * method will return false.
     */
    inline void clearCommandCounter();

    /**
     * Checks whether the field "commandCounter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCommandCounter()). Otherwise it will return false.
     */
    inline bool hasCommandCounter () const;

    /**
     * Returns the value of the member "commandCounter".
     *
     * This counter contains an assignment number, which is set by the client and is
     * taken over by the server as a response. The client should ensure that in case
     * of many similar queries, the server can use the counter as distinctive feature.
     * If the client sends a message (with the opCode Set, Get or MethodStart), before
     * the existing responses have arrived then the tuple (RegisterId, ServiceId,
     * FunctionId, command counter) must be unique. When a method is cancelled through
     * the client with the OpCode MethodAbort, then the command counter should get the
     * value by calling the method MethodStart. Messages with the OpCode Status contain
     * the command counter value of corresponding start message of the client. In a
     * spontaneous notification the command counter value is equal to the original
     * UpReg message. The status message or Error message which are sent as responses
     * contain the command counter value of the starting message of the corresponding
     * RelUpReg message.
     *
     * @return The value of the field "commandCounter"
     */
    inline uint16 getCommandCounter () const;

    /**
     * Sets the value of the member "commandCounter".
     *
     * This counter contains an assignment number, which is set by the client and is
     * taken over by the server as a response. The client should ensure that in case
     * of many similar queries, the server can use the counter as distinctive feature.
     * If the client sends a message (with the opCode Set, Get or MethodStart), before
     * the existing responses have arrived then the tuple (RegisterId, ServiceId,
     * FunctionId, command counter) must be unique. When a method is cancelled through
     * the client with the OpCode MethodAbort, then the command counter should get the
     * value by calling the method MethodStart. Messages with the OpCode Status contain
     * the command counter value of corresponding start message of the client. In a
     * spontaneous notification the command counter value is equal to the original
     * UpReg message. The status message or Error message which are sent as responses
     * contain the command counter value of the starting message of the corresponding
     * RelUpReg message.
     *
     * @param commandCounter The value which will be set
     */
    inline void setCommandCounter (uint16 commandCounter_);

    // API of field "streamType"

    static const int kStreamType = 6;

    /**
     * Clears the field "streamType".
     *
     * The field will be set to its default value. The hasStreamType()
     * method will return false.
     */
    inline void clearStreamType();

    /**
     * Checks whether the field "streamType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStreamType()). Otherwise it will return false.
     */
    inline bool hasStreamType () const;

    /**
     * Returns the value of the member "streamType".
     *
     * Reserved, don't use
     *
     * @return The value of the field "streamType"
     */
    inline uint8 getStreamType () const;

    /**
     * Sets the value of the member "streamType".
     *
     * Reserved, don't use
     *
     * @param streamType The value which will be set
     */
    inline void setStreamType (uint8 streamType_);

    // API of field "streamCounter"

    static const int kStreamCounter = 7;

    /**
     * Clears the field "streamCounter".
     *
     * The field will be set to its default value. The hasStreamCounter()
     * method will return false.
     */
    inline void clearStreamCounter();

    /**
     * Checks whether the field "streamCounter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStreamCounter()). Otherwise it will return false.
     */
    inline bool hasStreamCounter () const;

    /**
     * Returns the value of the member "streamCounter".
     *
     * Stream counter for numbering the streaming messages. The streamCounter must
     * be set to the value 0 when transferring the first data block. The counter is
     * incremented by one for the following blocks. In case the counter overruns,
     * then the numbering is begin again with 0.
     *
     * @return The value of the field "streamCounter"
     */
    inline uint8 getStreamCounter () const;

    /**
     * Sets the value of the member "streamCounter".
     *
     * Stream counter for numbering the streaming messages. The streamCounter must
     * be set to the value 0 when transferring the first data block. The counter is
     * incremented by one for the following blocks. In case the counter overruns,
     * then the numbering is begin again with 0.
     *
     * @param streamCounter The value which will be set
     */
    inline void setStreamCounter (uint8 streamCounter_);

    static const ServiceData &getDefaultInstance();

private:

    inline void set_has_serviceId ();

    inline void clear_has_serviceId ();

    inline void set_has_registerId ();

    inline void clear_has_registerId ();

    inline void set_has_functionId ();

    inline void clear_has_functionId ();

    inline void set_has_opCode ();

    inline void clear_has_opCode ();

    inline void set_has_act ();

    inline void clear_has_act ();

    inline void set_has_commandCounter ();

    inline void clear_has_commandCounter ();

    inline void set_has_streamType ();

    inline void clear_has_streamType ();

    inline void set_has_streamCounter ();

    inline void clear_has_streamCounter ();

    uint32 _has_bits_[ (8 + 31) / 32];

    uint16 _serviceId;

    uint16 _registerId;

    uint16 _functionId;

    ServiceData_OpCode _opCode;

    uint8 _act;

    uint16 _commandCounter;

    uint8 _streamType;

    uint8 _streamCounter;

};

/**
 * This message is sent for registering a client for service supplier status messages.
 * The client specifies the service of interest.
 */
class SrvSupplierRegister {
public:

    /**
     * Default constructor
     */
    inline  SrvSupplierRegister ();

    /**
     * Copy constructor
     */
    inline  SrvSupplierRegister (const SrvSupplierRegister &rhs);

    /**
     * All fields constructor
     */
    inline  SrvSupplierRegister (uint16 serviceId_);

    /**
     * Destructor
     */
    inline  ~SrvSupplierRegister();

    /**
     * Assignment operator
     */
    inline SrvSupplierRegister& operator = (const SrvSupplierRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SrvSupplierRegister& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SrvSupplierRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SrvSupplierRegister& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SrvSupplierRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "serviceId"

    static const int kServiceId = 0;

    /**
     * Clears the field "serviceId".
     *
     * The field will be set to its default value. The hasServiceId()
     * method will return false.
     */
    inline void clearServiceId();

    /**
     * Checks whether the field "serviceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceId()). Otherwise it will return false.
     */
    inline bool hasServiceId () const;

    /**
     * Returns the value of the member "serviceId".
     *
     * Service Identifier
     *
     * @return The value of the field "serviceId"
     */
    inline uint16 getServiceId () const;

    /**
     * Sets the value of the member "serviceId".
     *
     * Service Identifier
     *
     * @param serviceId The value which will be set
     */
    inline void setServiceId (uint16 serviceId_);

    static const SrvSupplierRegister &getDefaultInstance();

private:

    inline void set_has_serviceId ();

    inline void clear_has_serviceId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _serviceId;

};

/**
 * This message informs a registered application about the availability of another
 * application which provides the requested service
 */
class SrvSupplierStatus {
public:

    typedef SrvSupplierStatus_Status Status;

    static const Status Status__Unavailable = SrvSupplierStatus_Status__Unavailable;
    static const Status Status__Available = SrvSupplierStatus_Status__Available;
    static const Status Status__Unknown = SrvSupplierStatus_Status__Unknown;

    static inline const char* Status_Name(Status value) {
        return SrvSupplierStatus_Status_Name(value);
    }

    static inline bool Status_Parse(const char *str, size_t length, Status &value) {
        return SrvSupplierStatus_Status_Parse(str, length, value);
    }

    static inline bool Status_IsValid(Status value) {
        return SrvSupplierStatus_Status_IsValid(value);
    }

    /**
     * Default constructor
     */
    inline  SrvSupplierStatus ();

    /**
     * Copy constructor
     */
    inline  SrvSupplierStatus (const SrvSupplierStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SrvSupplierStatus (uint16 serviceId_, uint16 appId_, SrvSupplierStatus_Status status_);

    /**
     * Destructor
     */
    inline  ~SrvSupplierStatus();

    /**
     * Assignment operator
     */
    inline SrvSupplierStatus& operator = (const SrvSupplierStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SrvSupplierStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SrvSupplierStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SrvSupplierStatus& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SrvSupplierStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "serviceId"

    static const int kServiceId = 0;

    /**
     * Clears the field "serviceId".
     *
     * The field will be set to its default value. The hasServiceId()
     * method will return false.
     */
    inline void clearServiceId();

    /**
     * Checks whether the field "serviceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceId()). Otherwise it will return false.
     */
    inline bool hasServiceId () const;

    /**
     * Returns the value of the member "serviceId".
     *
     * Service Identifier
     *
     * @return The value of the field "serviceId"
     */
    inline uint16 getServiceId () const;

    /**
     * Sets the value of the member "serviceId".
     *
     * Service Identifier
     *
     * @param serviceId The value which will be set
     */
    inline void setServiceId (uint16 serviceId_);

    // API of field "appId"

    static const int kAppId = 1;

    /**
     * Clears the field "appId".
     *
     * The field will be set to its default value. The hasAppId()
     * method will return false.
     */
    inline void clearAppId();

    /**
     * Checks whether the field "appId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppId()). Otherwise it will return false.
     */
    inline bool hasAppId () const;

    /**
     * Returns the value of the member "appId".
     *
     * Application Id of the application which offers the requested service.
     * This field can be InvalIdAppId (0xFFFF) if there is currently no
     * application known which offers the requested service.
     *
     * @return The value of the field "appId"
     */
    inline uint16 getAppId () const;

    /**
     * Sets the value of the member "appId".
     *
     * Application Id of the application which offers the requested service.
     * This field can be InvalIdAppId (0xFFFF) if there is currently no
     * application known which offers the requested service.
     *
     * @param appId The value which will be set
     */
    inline void setAppId (uint16 appId_);

    // API of field "status"

    static const int kStatus = 2;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * Status of the service
     *
     * @return The value of the field "status"
     */
    inline SrvSupplierStatus_Status getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * Status of the service
     *
     * @param status The value which will be set
     */
    inline void setStatus (SrvSupplierStatus_Status status_);

    static const SrvSupplierStatus &getDefaultInstance();

private:

    inline void set_has_serviceId ();

    inline void clear_has_serviceId ();

    inline void set_has_appId ();

    inline void clear_has_appId ();

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _serviceId;

    uint16 _appId;

    SrvSupplierStatus_Status _status;

};

/**
 * This message is sent for registering an application for ApplicationStatus messages
 * for other applications.
 */
class AppInfoRegister {
public:

    /**
     * Default constructor
     */
    inline  AppInfoRegister ();

    /**
     * Copy constructor
     */
    inline  AppInfoRegister (const AppInfoRegister &rhs);

    /**
     * All fields constructor
     */
    inline  AppInfoRegister (uint16 appId_);

    /**
     * Destructor
     */
    inline  ~AppInfoRegister();

    /**
     * Assignment operator
     */
    inline AppInfoRegister& operator = (const AppInfoRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AppInfoRegister& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AppInfoRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AppInfoRegister& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AppInfoRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "appId"

    static const int kAppId = 0;

    /**
     * Clears the field "appId".
     *
     * The field will be set to its default value. The hasAppId()
     * method will return false.
     */
    inline void clearAppId();

    /**
     * Checks whether the field "appId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppId()). Otherwise it will return false.
     */
    inline bool hasAppId () const;

    /**
     * Returns the value of the member "appId".
     *
     * Application Id of the application which is of interest
     *
     * @return The value of the field "appId"
     */
    inline uint16 getAppId () const;

    /**
     * Sets the value of the member "appId".
     *
     * Application Id of the application which is of interest
     *
     * @param appId The value which will be set
     */
    inline void setAppId (uint16 appId_);

    static const AppInfoRegister &getDefaultInstance();

private:

    inline void set_has_appId ();

    inline void clear_has_appId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _appId;

};

/**
 * This message is sent for registering an application for ApplicationStatus messages
 * for other applications.
 */
class AppInfoStatus {
public:

    typedef AppInfoStatus_Status Status;

    static const Status Status__Unavailable = AppInfoStatus_Status__Unavailable;
    static const Status Status__Available = AppInfoStatus_Status__Available;
    static const Status Status__Unknown = AppInfoStatus_Status__Unknown;
    static const Status Status__RegistrationError = AppInfoStatus_Status__RegistrationError;

    static inline const char* Status_Name(Status value) {
        return AppInfoStatus_Status_Name(value);
    }

    static inline bool Status_Parse(const char *str, size_t length, Status &value) {
        return AppInfoStatus_Status_Parse(str, length, value);
    }

    static inline bool Status_IsValid(Status value) {
        return AppInfoStatus_Status_IsValid(value);
    }

    /**
     * Default constructor
     */
    inline  AppInfoStatus ();

    /**
     * Copy constructor
     */
    inline  AppInfoStatus (const AppInfoStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AppInfoStatus (uint16 appId_, AppInfoStatus_Status status_);

    /**
     * Destructor
     */
    inline  ~AppInfoStatus();

    /**
     * Assignment operator
     */
    inline AppInfoStatus& operator = (const AppInfoStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AppInfoStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AppInfoStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AppInfoStatus& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AppInfoStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "appId"

    static const int kAppId = 0;

    /**
     * Clears the field "appId".
     *
     * The field will be set to its default value. The hasAppId()
     * method will return false.
     */
    inline void clearAppId();

    /**
     * Checks whether the field "appId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppId()). Otherwise it will return false.
     */
    inline bool hasAppId () const;

    /**
     * Returns the value of the member "appId".
     *
     * Application Id of the application which is of interest
     *
     * @return The value of the field "appId"
     */
    inline uint16 getAppId () const;

    /**
     * Sets the value of the member "appId".
     *
     * Application Id of the application which is of interest
     *
     * @param appId The value which will be set
     */
    inline void setAppId (uint16 appId_);

    // API of field "status"

    static const int kStatus = 1;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * Status of the application
     *
     * @return The value of the field "status"
     */
    inline AppInfoStatus_Status getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * Status of the application
     *
     * @param status The value which will be set
     */
    inline void setStatus (AppInfoStatus_Status status_);

    static const AppInfoStatus &getDefaultInstance();

private:

    inline void set_has_appId ();

    inline void clear_has_appId ();

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _appId;

    AppInfoStatus_Status _status;

};

/**
 * If the meaning of "CcaMessageExtension" isn't clear, then there should be a description here.
 */
class CcaMessageExtension {
public:

    enum CcaMessageExtensionField {
        E_POWER_MESSAGE = 64,
        E_SERVICE_REGISTER = 65,
        E_SERVICE_UNREGISTER = 66,
        E_SERVICE_REGISTER_CONFIRMATION = 67,
        E_SERVICE_STATUS = 68,
        E_SERVICE_DATA = 69,
        E_SRV_SUPPLIER_REGISTER = 70,
        E_SRV_SUPPLIER_STATUS = 71,
        E_SRV_SUPPLIER_UNREGISTER = 72,
        E_APP_INFO_REGISTER = 73,
        E_APP_INFO_STATUS = 80,
        E_APP_INFO_UNREGISTER = 81
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "powerMessage".
     */
    inline  CcaMessageExtension ();

   /**
     * Copy constructor
     */
    inline  CcaMessageExtension (const CcaMessageExtension& rhs);

    /**
     * Destructor
     */
    inline  ~CcaMessageExtension();

    /**
     * Assigns a new value to this object.
     */
    inline CcaMessageExtension& operator = (const CcaMessageExtension& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CcaMessageExtension& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CcaMessageExtension& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CcaMessageExtension& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CcaMessageExtension& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline CcaMessageExtension::CcaMessageExtensionField getField () const;

    inline void setField(CcaMessageExtension::CcaMessageExtensionField field);

    // ---- Field accessors -------------------------------------------

    // API of field "powerMessage"

    static const int kPowerMessage = 64;

    /**
     * Returns true if the field "powerMessage" has a value.
     *
     * If the meaning of "powerMessage" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "powerMessage", otherwise false
     */
    inline bool hasPowerMessage () const;

    /**
     * Returns the value of field "powerMessage".It is only valid to call this
     * method if hasPowerMessage() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "powerMessage" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const PowerMessage& getPowerMessage() const ;

    /**
     * Retrieves the value of the field "powerMessage" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isPowerMessage() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline PowerMessage& getPowerMessageMutable();

    /**
     * Release the object stored in the field "powerMessage".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "powerMessage" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "powerMessage"
     */
    inline PowerMessage* releasePowerMessage();

    /**
     * Replace the field "powerMessage".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replacePowerMessage (PowerMessage* powerMessage);

    /**
     * Sets the value of the field "powerMessage". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "powerMessage" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setPowerMessage (const PowerMessage& value);

    // API of field "serviceRegister"

    static const int kServiceRegister = 65;

    /**
     * Returns true if the field "serviceRegister" has a value.
     *
     * If the meaning of "serviceRegister" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "serviceRegister", otherwise false
     */
    inline bool hasServiceRegister () const;

    /**
     * Returns the value of field "serviceRegister".It is only valid to call
     * this method if hasServiceRegister() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "serviceRegister" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ServiceRegister& getServiceRegister() const ;

    /**
     * Retrieves the value of the field "serviceRegister" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isServiceRegister() returns
     * true. Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ServiceRegister& getServiceRegisterMutable();

    /**
     * Release the object stored in the field "serviceRegister".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "serviceRegister" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "serviceRegister"
     */
    inline ServiceRegister* releaseServiceRegister();

    /**
     * Replace the field "serviceRegister".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceServiceRegister (ServiceRegister* serviceRegister);

    /**
     * Sets the value of the field "serviceRegister". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "serviceRegister" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setServiceRegister (const ServiceRegister& value);

    // API of field "serviceUnregister"

    static const int kServiceUnregister = 66;

    /**
     * Returns true if the field "serviceUnregister" has a value.
     *
     * If the meaning of "serviceUnregister" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "serviceUnregister", otherwise false
     */
    inline bool hasServiceUnregister () const;

    /**
     * Returns the value of field "serviceUnregister".It is only valid to call
     * this method if hasServiceUnregister() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "serviceUnregister" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ServiceUnregister& getServiceUnregister() const ;

    /**
     * Retrieves the value of the field "serviceUnregister" as a mutable
     * object. Any modifications on the returned object will affect the
     * containing object.
     *
     * It is only valid to call this method if isServiceUnregister() returns
     * true. Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ServiceUnregister& getServiceUnregisterMutable();

    /**
     * Release the object stored in the field "serviceUnregister".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "serviceUnregister" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "serviceUnregister"
     */
    inline ServiceUnregister* releaseServiceUnregister();

    /**
     * Replace the field "serviceUnregister".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceServiceUnregister (ServiceUnregister* serviceUnregister);

    /**
     * Sets the value of the field "serviceUnregister". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "serviceUnregister" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setServiceUnregister (const ServiceUnregister& value);

    // API of field "serviceRegisterConfirmation"

    static const int kServiceRegisterConfirmation = 67;

    /**
     * Returns true if the field "serviceRegisterConfirmation" has a value.
     *
     * If the meaning of "serviceRegisterConfirmation" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "serviceRegisterConfirmation", otherwise false
     */
    inline bool hasServiceRegisterConfirmation () const;

    /**
     * Returns the value of field "serviceRegisterConfirmation".It is only
     * valid to call this method if hasServiceRegisterConfirmation() returns
     * true. Otherwise the behavior is not specified.
     *
     * If the meaning of "serviceRegisterConfirmation" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ServiceRegisterConfirmation& getServiceRegisterConfirmation() const ;

    /**
     * Retrieves the value of the field "serviceRegisterConfirmation" as a
     * mutable object. Any modifications on the returned object will affect
     * the containing object.
     *
     * It is only valid to call this method if isServiceRegisterConfirmation()
     * returns true. Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ServiceRegisterConfirmation& getServiceRegisterConfirmationMutable();

    /**
     * Release the object stored in the field "serviceRegisterConfirmation".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "serviceRegisterConfirmation" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "serviceRegisterConfirmation"
     */
    inline ServiceRegisterConfirmation* releaseServiceRegisterConfirmation();

    /**
     * Replace the field "serviceRegisterConfirmation".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceServiceRegisterConfirmation (ServiceRegisterConfirmation* serviceRegisterConfirmation);

    /**
     * Sets the value of the field "serviceRegisterConfirmation". A field
     * which was previously set will be cleared.
     *
     * If the meaning of "serviceRegisterConfirmation" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setServiceRegisterConfirmation (const ServiceRegisterConfirmation& value);

    // API of field "serviceStatus"

    static const int kServiceStatus = 68;

    /**
     * Returns true if the field "serviceStatus" has a value.
     *
     * If the meaning of "serviceStatus" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "serviceStatus", otherwise false
     */
    inline bool hasServiceStatus () const;

    /**
     * Returns the value of field "serviceStatus".It is only valid to call
     * this method if hasServiceStatus() returns true. Otherwise the behavior
     * is not specified.
     *
     * If the meaning of "serviceStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ServiceStatus& getServiceStatus() const ;

    /**
     * Retrieves the value of the field "serviceStatus" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isServiceStatus() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ServiceStatus& getServiceStatusMutable();

    /**
     * Release the object stored in the field "serviceStatus".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "serviceStatus" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "serviceStatus"
     */
    inline ServiceStatus* releaseServiceStatus();

    /**
     * Replace the field "serviceStatus".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceServiceStatus (ServiceStatus* serviceStatus);

    /**
     * Sets the value of the field "serviceStatus". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "serviceStatus" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setServiceStatus (const ServiceStatus& value);

    // API of field "serviceData"

    static const int kServiceData = 69;

    /**
     * Returns true if the field "serviceData" has a value.
     *
     * If the meaning of "serviceData" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "serviceData", otherwise false
     */
    inline bool hasServiceData () const;

    /**
     * Returns the value of field "serviceData".It is only valid to call this
     * method if hasServiceData() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "serviceData" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ServiceData& getServiceData() const ;

    /**
     * Retrieves the value of the field "serviceData" as a mutable object. Any
     * modifications on the returned object will affect the containing object.
     *
     * It is only valid to call this method if isServiceData() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ServiceData& getServiceDataMutable();

    /**
     * Release the object stored in the field "serviceData".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "serviceData" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "serviceData"
     */
    inline ServiceData* releaseServiceData();

    /**
     * Replace the field "serviceData".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceServiceData (ServiceData* serviceData);

    /**
     * Sets the value of the field "serviceData". A field which was previously
     * set will be cleared.
     *
     * If the meaning of "serviceData" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setServiceData (const ServiceData& value);

    // API of field "srvSupplierRegister"

    static const int kSrvSupplierRegister = 70;

    /**
     * Returns true if the field "srvSupplierRegister" has a value.
     *
     * If the meaning of "srvSupplierRegister" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "srvSupplierRegister", otherwise false
     */
    inline bool hasSrvSupplierRegister () const;

    /**
     * Returns the value of field "srvSupplierRegister".It is only valid to
     * call this method if hasSrvSupplierRegister() returns true. Otherwise
     * the behavior is not specified.
     *
     * If the meaning of "srvSupplierRegister" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SrvSupplierRegister& getSrvSupplierRegister() const ;

    /**
     * Retrieves the value of the field "srvSupplierRegister" as a mutable
     * object. Any modifications on the returned object will affect the
     * containing object.
     *
     * It is only valid to call this method if isSrvSupplierRegister() returns
     * true. Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SrvSupplierRegister& getSrvSupplierRegisterMutable();

    /**
     * Release the object stored in the field "srvSupplierRegister".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "srvSupplierRegister" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "srvSupplierRegister"
     */
    inline SrvSupplierRegister* releaseSrvSupplierRegister();

    /**
     * Replace the field "srvSupplierRegister".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSrvSupplierRegister (SrvSupplierRegister* srvSupplierRegister);

    /**
     * Sets the value of the field "srvSupplierRegister". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "srvSupplierRegister" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSrvSupplierRegister (const SrvSupplierRegister& value);

    // API of field "srvSupplierStatus"

    static const int kSrvSupplierStatus = 71;

    /**
     * Returns true if the field "srvSupplierStatus" has a value.
     *
     * If the meaning of "srvSupplierStatus" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "srvSupplierStatus", otherwise false
     */
    inline bool hasSrvSupplierStatus () const;

    /**
     * Returns the value of field "srvSupplierStatus".It is only valid to call
     * this method if hasSrvSupplierStatus() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "srvSupplierStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SrvSupplierStatus& getSrvSupplierStatus() const ;

    /**
     * Retrieves the value of the field "srvSupplierStatus" as a mutable
     * object. Any modifications on the returned object will affect the
     * containing object.
     *
     * It is only valid to call this method if isSrvSupplierStatus() returns
     * true. Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SrvSupplierStatus& getSrvSupplierStatusMutable();

    /**
     * Release the object stored in the field "srvSupplierStatus".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "srvSupplierStatus" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "srvSupplierStatus"
     */
    inline SrvSupplierStatus* releaseSrvSupplierStatus();

    /**
     * Replace the field "srvSupplierStatus".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSrvSupplierStatus (SrvSupplierStatus* srvSupplierStatus);

    /**
     * Sets the value of the field "srvSupplierStatus". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "srvSupplierStatus" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSrvSupplierStatus (const SrvSupplierStatus& value);

    // API of field "srvSupplierUnregister"

    static const int kSrvSupplierUnregister = 72;

    /**
     * Returns true if the field "srvSupplierUnregister" has a value.
     *
     * If the meaning of "srvSupplierUnregister" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "srvSupplierUnregister", otherwise false
     */
    inline bool hasSrvSupplierUnregister () const;

    /**
     * Returns the value of field "srvSupplierUnregister".It is only valid to
     * call this method if hasSrvSupplierUnregister() returns true. Otherwise
     * the behavior is not specified.
     *
     * If the meaning of "srvSupplierUnregister" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SrvSupplierUnregister& getSrvSupplierUnregister() const ;

    /**
     * Retrieves the value of the field "srvSupplierUnregister" as a mutable
     * object. Any modifications on the returned object will affect the
     * containing object.
     *
     * It is only valid to call this method if isSrvSupplierUnregister()
     * returns true. Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SrvSupplierUnregister& getSrvSupplierUnregisterMutable();

    /**
     * Release the object stored in the field "srvSupplierUnregister".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "srvSupplierUnregister" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "srvSupplierUnregister"
     */
    inline SrvSupplierUnregister* releaseSrvSupplierUnregister();

    /**
     * Replace the field "srvSupplierUnregister".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSrvSupplierUnregister (SrvSupplierUnregister* srvSupplierUnregister);

    /**
     * Sets the value of the field "srvSupplierUnregister". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "srvSupplierUnregister" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSrvSupplierUnregister (const SrvSupplierUnregister& value);

    // API of field "appInfoRegister"

    static const int kAppInfoRegister = 73;

    /**
     * Returns true if the field "appInfoRegister" has a value.
     *
     * If the meaning of "appInfoRegister" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "appInfoRegister", otherwise false
     */
    inline bool hasAppInfoRegister () const;

    /**
     * Returns the value of field "appInfoRegister".It is only valid to call
     * this method if hasAppInfoRegister() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "appInfoRegister" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const AppInfoRegister& getAppInfoRegister() const ;

    /**
     * Retrieves the value of the field "appInfoRegister" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isAppInfoRegister() returns
     * true. Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline AppInfoRegister& getAppInfoRegisterMutable();

    /**
     * Release the object stored in the field "appInfoRegister".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "appInfoRegister" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "appInfoRegister"
     */
    inline AppInfoRegister* releaseAppInfoRegister();

    /**
     * Replace the field "appInfoRegister".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceAppInfoRegister (AppInfoRegister* appInfoRegister);

    /**
     * Sets the value of the field "appInfoRegister". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "appInfoRegister" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setAppInfoRegister (const AppInfoRegister& value);

    // API of field "appInfoStatus"

    static const int kAppInfoStatus = 80;

    /**
     * Returns true if the field "appInfoStatus" has a value.
     *
     * If the meaning of "appInfoStatus" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "appInfoStatus", otherwise false
     */
    inline bool hasAppInfoStatus () const;

    /**
     * Returns the value of field "appInfoStatus".It is only valid to call
     * this method if hasAppInfoStatus() returns true. Otherwise the behavior
     * is not specified.
     *
     * If the meaning of "appInfoStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const AppInfoStatus& getAppInfoStatus() const ;

    /**
     * Retrieves the value of the field "appInfoStatus" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isAppInfoStatus() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline AppInfoStatus& getAppInfoStatusMutable();

    /**
     * Release the object stored in the field "appInfoStatus".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "appInfoStatus" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "appInfoStatus"
     */
    inline AppInfoStatus* releaseAppInfoStatus();

    /**
     * Replace the field "appInfoStatus".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceAppInfoStatus (AppInfoStatus* appInfoStatus);

    /**
     * Sets the value of the field "appInfoStatus". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "appInfoStatus" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setAppInfoStatus (const AppInfoStatus& value);

    // API of field "appInfoUnregister"

    static const int kAppInfoUnregister = 81;

    /**
     * Returns true if the field "appInfoUnregister" has a value.
     *
     * If the meaning of "appInfoUnregister" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "appInfoUnregister", otherwise false
     */
    inline bool hasAppInfoUnregister () const;

    /**
     * Returns the value of field "appInfoUnregister".It is only valid to call
     * this method if hasAppInfoUnregister() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "appInfoUnregister" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const AppInfoUnregister& getAppInfoUnregister() const ;

    /**
     * Retrieves the value of the field "appInfoUnregister" as a mutable
     * object. Any modifications on the returned object will affect the
     * containing object.
     *
     * It is only valid to call this method if isAppInfoUnregister() returns
     * true. Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline AppInfoUnregister& getAppInfoUnregisterMutable();

    /**
     * Release the object stored in the field "appInfoUnregister".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "appInfoUnregister" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "appInfoUnregister"
     */
    inline AppInfoUnregister* releaseAppInfoUnregister();

    /**
     * Replace the field "appInfoUnregister".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceAppInfoUnregister (AppInfoUnregister* appInfoUnregister);

    /**
     * Sets the value of the field "appInfoUnregister". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "appInfoUnregister" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setAppInfoUnregister (const AppInfoUnregister& value);

    static const CcaMessageExtension &getDefaultInstance();

private:

    inline void cloneData (const CcaMessageExtension& rhs);

    inline void deleteData ();

    CcaMessageExtensionField __field;

    union {
        PowerMessage* powerMessage_;
        ServiceRegister* serviceRegister_;
        ServiceUnregister* serviceUnregister_;
        ServiceRegisterConfirmation* serviceRegisterConfirmation_;
        ServiceStatus* serviceStatus_;
        ServiceData* serviceData_;
        SrvSupplierRegister* srvSupplierRegister_;
        SrvSupplierStatus* srvSupplierStatus_;
        SrvSupplierRegister* srvSupplierUnregister_;
        AppInfoRegister* appInfoRegister_;
        AppInfoStatus* appInfoStatus_;
        AppInfoRegister* appInfoUnregister_;
    } _data;

};

/**
 * If the meaning of "CcaMessageHeader" isn't clear, then there should be a description here.
 */
class CcaMessageHeader {
public:

    /**
     * Default constructor
     */
    inline  CcaMessageHeader ();

    /**
     * Copy constructor
     */
    inline  CcaMessageHeader (const CcaMessageHeader &rhs);

    /**
     * All fields constructor
     */
    inline  CcaMessageHeader (uint16 sourceAppId_, uint16 destAppId_, uint32 size_, uint16 version_, uint8 context_, uint16 sourceSubId_, uint16 destSubId_, uint32 timestamp_, const CcaMessageExtension& extension_);

    /**
     * Destructor
     */
    inline  ~CcaMessageHeader();

    /**
     * Assignment operator
     */
    inline CcaMessageHeader& operator = (const CcaMessageHeader& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CcaMessageHeader& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CcaMessageHeader& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CcaMessageHeader& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CcaMessageHeader& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sourceAppId"

    static const int kSourceAppId = 0;

    /**
     * Clears the field "sourceAppId".
     *
     * The field will be set to its default value. The hasSourceAppId()
     * method will return false.
     */
    inline void clearSourceAppId();

    /**
     * Checks whether the field "sourceAppId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceAppId()). Otherwise it will return false.
     */
    inline bool hasSourceAppId () const;

    /**
     * Returns the value of the member "sourceAppId".
     *
     * The applicationId of the sender of the message
     *
     * @return The value of the field "sourceAppId"
     */
    inline uint16 getSourceAppId () const;

    /**
     * Sets the value of the member "sourceAppId".
     *
     * The applicationId of the sender of the message
     *
     * @param sourceAppId The value which will be set
     */
    inline void setSourceAppId (uint16 sourceAppId_);

    // API of field "destAppId"

    static const int kDestAppId = 1;

    /**
     * Clears the field "destAppId".
     *
     * The field will be set to its default value. The hasDestAppId()
     * method will return false.
     */
    inline void clearDestAppId();

    /**
     * Checks whether the field "destAppId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestAppId()). Otherwise it will return false.
     */
    inline bool hasDestAppId () const;

    /**
     * Returns the value of the member "destAppId".
     *
     * The applicationId of the receiver of the message
     *
     * @return The value of the field "destAppId"
     */
    inline uint16 getDestAppId () const;

    /**
     * Sets the value of the member "destAppId".
     *
     * The applicationId of the receiver of the message
     *
     * @param destAppId The value which will be set
     */
    inline void setDestAppId (uint16 destAppId_);

    // API of field "size"

    static const int kSize = 2;

    /**
     * Clears the field "size".
     *
     * The field will be set to its default value. The hasSize()
     * method will return false.
     */
    inline void clearSize();

    /**
     * Checks whether the field "size" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSize()). Otherwise it will return false.
     */
    inline bool hasSize () const;

    /**
     * Returns the value of the member "size".
     *
     * Size of message in bytes
     *
     * @return The value of the field "size"
     */
    inline uint32 getSize () const;

    /**
     * Sets the value of the member "size".
     *
     * Size of message in bytes
     *
     * @param size The value which will be set
     */
    inline void setSize (uint32 size_);

    // API of field "version"

    static const int kVersion = 3;

    /**
     * Clears the field "version".
     *
     * The field will be set to its default value. The hasVersion()
     * method will return false.
     */
    inline void clearVersion();

    /**
     * Checks whether the field "version" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVersion()). Otherwise it will return false.
     */
    inline bool hasVersion () const;

    /**
     * Returns the value of the member "version".
     *
     * Version of the message format. For the present definition
     * the message corresponds to the version 0x0002.
     *
     * @return The value of the field "version"
     */
    inline uint16 getVersion () const;

    /**
     * Sets the value of the member "version".
     *
     * Version of the message format. For the present definition
     * the message corresponds to the version 0x0002.
     *
     * @param version The value which will be set
     */
    inline void setVersion (uint16 version_);

    // API of field "context"

    static const int kContext = 4;

    /**
     * Clears the field "context".
     *
     * The field will be set to its default value. The hasContext()
     * method will return false.
     */
    inline void clearContext();

    /**
     * Checks whether the field "context" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setContext()). Otherwise it will return false.
     */
    inline bool hasContext () const;

    /**
     * Returns the value of the member "context".
     *
     * Application context byte (setting for CCA: 0x00)
     *
     * @return The value of the field "context"
     */
    inline uint8 getContext () const;

    /**
     * Sets the value of the member "context".
     *
     * Application context byte (setting for CCA: 0x00)
     *
     * @param context The value which will be set
     */
    inline void setContext (uint8 context_);

    // API of field "sourceSubId"

    static const int kSourceSubId = 5;

    /**
     * Clears the field "sourceSubId".
     *
     * The field will be set to its default value. The hasSourceSubId()
     * method will return false.
     */
    inline void clearSourceSubId();

    /**
     * Checks whether the field "sourceSubId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceSubId()). Otherwise it will return false.
     */
    inline bool hasSourceSubId () const;

    /**
     * Returns the value of the member "sourceSubId".
     *
     * The sender can enter a sub Id of his components. The value 0x0000 is reserved
     * and can be used, if a sub-Id is not needed or recommended or the sender doesn't
     * want to give any information about his internal structure to the receiver.
     *
     * @return The value of the field "sourceSubId"
     */
    inline uint16 getSourceSubId () const;

    /**
     * Sets the value of the member "sourceSubId".
     *
     * The sender can enter a sub Id of his components. The value 0x0000 is reserved
     * and can be used, if a sub-Id is not needed or recommended or the sender doesn't
     * want to give any information about his internal structure to the receiver.
     *
     * @param sourceSubId The value which will be set
     */
    inline void setSourceSubId (uint16 sourceSubId_);

    // API of field "destSubId"

    static const int kDestSubId = 6;

    /**
     * Clears the field "destSubId".
     *
     * The field will be set to its default value. The hasDestSubId()
     * method will return false.
     */
    inline void clearDestSubId();

    /**
     * Checks whether the field "destSubId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestSubId()). Otherwise it will return false.
     */
    inline bool hasDestSubId () const;

    /**
     * Returns the value of the member "destSubId".
     *
     * A sub-Id of the receiver can be entered here. The value 0x0000 is reserved and
     * can be used if a sub-Id is not known.
     *
     * @return The value of the field "destSubId"
     */
    inline uint16 getDestSubId () const;

    /**
     * Sets the value of the member "destSubId".
     *
     * A sub-Id of the receiver can be entered here. The value 0x0000 is reserved and
     * can be used if a sub-Id is not known.
     *
     * @param destSubId The value which will be set
     */
    inline void setDestSubId (uint16 destSubId_);

    // API of field "timestamp"

    static const int kTimestamp = 7;

    /**
     * Clears the field "timestamp".
     *
     * The field will be set to its default value. The hasTimestamp()
     * method will return false.
     */
    inline void clearTimestamp();

    /**
     * Checks whether the field "timestamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTimestamp()). Otherwise it will return false.
     */
    inline bool hasTimestamp () const;

    /**
     * Returns the value of the member "timestamp".
     *
     * This field gives the time in UTC format in which the message is sent. The field
     * contains neither the date of the message creation nor a current time stamp of the
     * application data.
     *
     * @return The value of the field "timestamp"
     */
    inline uint32 getTimestamp () const;

    /**
     * Sets the value of the member "timestamp".
     *
     * This field gives the time in UTC format in which the message is sent. The field
     * contains neither the date of the message creation nor a current time stamp of the
     * application data.
     *
     * @param timestamp The value which will be set
     */
    inline void setTimestamp (uint32 timestamp_);

    // API of field "extension"

    static const int kExtension = 8;

    /**
     * Clears the field "extension".
     *
     * The field will be set to its default value. The hasExtension()
     * method will return false.
     */
    inline void clearExtension();

    /**
     * Checks whether the field "extension" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setExtension()). Otherwise it will return false.
     */
    inline bool hasExtension () const;

    /**
     * Returns the value of the member "extension".
     *
     * If the meaning of "extension" isn't clear, then there should be a description here.
     *
     * @return The value of the field "extension"
     */
    inline const CcaMessageExtension& getExtension () const;

    /**
     * Retrieves the value of the field "extension" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "extension".
     */
    inline CcaMessageExtension& getExtensionMutable ();

    /**
     * Sets the value of the member "extension".
     *
     * If the meaning of "extension" isn't clear, then there should be a description here.
     *
     * @param extension The value which will be set
     */
    inline void setExtension (const CcaMessageExtension& extension_);

    /**
     * Release the object stored in the field "extension".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "extension"
     */
    inline CcaMessageExtension* releaseExtension();

    /**
     * Replace the field "extension".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceExtension (CcaMessageExtension* extension_);

    static const CcaMessageHeader &getDefaultInstance();

private:

    inline void set_has_sourceAppId ();

    inline void clear_has_sourceAppId ();

    inline void set_has_destAppId ();

    inline void clear_has_destAppId ();

    inline void set_has_size ();

    inline void clear_has_size ();

    inline void set_has_version ();

    inline void clear_has_version ();

    inline void set_has_context ();

    inline void clear_has_context ();

    inline void set_has_sourceSubId ();

    inline void clear_has_sourceSubId ();

    inline void set_has_destSubId ();

    inline void clear_has_destSubId ();

    inline void set_has_timestamp ();

    inline void clear_has_timestamp ();

    inline void set_has_extension ();

    inline void clear_has_extension ();

    uint32 _has_bits_[ (9 + 31) / 32];

    uint16 _sourceAppId;

    uint16 _destAppId;

    uint32 _size;

    uint16 _version;

    uint8 _context;

    uint16 _sourceSubId;

    uint16 _destSubId;

    uint32 _timestamp;

    CcaMessageExtension* _extension;

};

/**
 * If the meaning of "DefaultError" isn't clear, then there should be a description here.
 */
class DefaultError  : public ::asf::core::Payload {
public:

    enum DefaultErrorField {
        E_CCA_ERROR_CODE,
        E_SYSTEM_ERROR_CODE
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DefaultError ();

   /**
     * Copy constructor
     */
    inline  DefaultError (const DefaultError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DefaultError();

    /**
     * Assigns a new value to this object.
     */
    inline DefaultError& operator = (const DefaultError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DefaultError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DefaultError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DefaultError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DefaultError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DefaultError::DefaultErrorField getField () const;

    inline void setField(DefaultError::DefaultErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ccaErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ccaErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline CcaErrorCode getCcaErrorCode() const ;

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ccaErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (CcaErrorCode value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "systemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "systemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "systemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (SystemErrorCode value);

    static const DefaultError &getDefaultInstance();

private:

    inline void cloneData (const DefaultError& rhs);

    inline void deleteData ();

    DefaultErrorField __field;

    union {
        int32 ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * DefaultMessage is used for messages without parameters. ASF creates typedefs from
 * a message without parameters to DefaultMessage.
 */
class DefaultMessage  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DefaultMessage ();

    /**
     * Copy constructor
     */
    inline  DefaultMessage (const DefaultMessage &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DefaultMessage();

    /**
     * Assignment operator
     */
    inline DefaultMessage& operator = (const DefaultMessage& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DefaultMessage& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DefaultMessage& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DefaultMessage& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DefaultMessage& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DefaultMessage &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

inline  PowerMessage::PowerMessage ()  :
    _powerType (0u),
    _reserved (0u),
    _data1 (0u),
    _data2 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PowerMessage::PowerMessage (const PowerMessage &rhs)  :
    _powerType (0u),
    _reserved (0u),
    _data1 (0u),
    _data2 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PowerMessage::PowerMessage (uint16 powerType_, uint16 reserved_, uint32 data1_, uint32 data2_)  :
    _powerType (powerType_),
    _reserved (reserved_),
    _data1 (data1_),
    _data2 (data2_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PowerMessage::~PowerMessage() {
}

inline PowerMessage& PowerMessage::operator = (const PowerMessage& rhs) {
    if( this != &rhs ) {
        if (rhs.hasPowerType()) {
            setPowerType(rhs.getPowerType());
        } else {
            clearPowerType();
        }
        if (rhs.hasReserved()) {
            setReserved(rhs.getReserved());
        } else {
            clearReserved();
        }
        if (rhs.hasData1()) {
            setData1(rhs.getData1());
        } else {
            clearData1();
        }
        if (rhs.hasData2()) {
            setData2(rhs.getData2());
        } else {
            clearData2();
        }
    }
    return *this;
}

inline bool PowerMessage::operator == (const PowerMessage& rhs) const {
    return (((!hasPowerType() && !rhs.hasPowerType()) || getPowerType() == rhs.getPowerType()) &&
        ((!hasReserved() && !rhs.hasReserved()) || getReserved() == rhs.getReserved()) &&
        ((!hasData1() && !rhs.hasData1()) || getData1() == rhs.getData1()) &&
        ((!hasData2() && !rhs.hasData2()) || getData2() == rhs.getData2()));
}

inline bool PowerMessage::operator != (const PowerMessage& rhs) const {
    return ! (*this == rhs);
}

inline bool PowerMessage::operator < (const PowerMessage& rhs) const {
    if (hasPowerType() || rhs.hasPowerType()) {
        if (getPowerType() < rhs.getPowerType()) return true;
        if (getPowerType() > rhs.getPowerType()) return false;
    }
    if (hasReserved() || rhs.hasReserved()) {
        if (getReserved() < rhs.getReserved()) return true;
        if (getReserved() > rhs.getReserved()) return false;
    }
    if (hasData1() || rhs.hasData1()) {
        if (getData1() < rhs.getData1()) return true;
        if (getData1() > rhs.getData1()) return false;
    }
    if (hasData2() || rhs.hasData2()) {
        if (getData2() < rhs.getData2()) return true;
        if (getData2() > rhs.getData2()) return false;
    }
    return false;
}

inline bool PowerMessage::operator > (const PowerMessage& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PowerMessage::clear() {
    clearPowerType();
    clearReserved();
    clearData1();
    clearData2();
}

inline void PowerMessage::clearPowerType() {
    if (hasPowerType()) {
         clear_has_powerType();
        _powerType = 0u;
     }
}

inline bool PowerMessage::hasPowerType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 PowerMessage::getPowerType () const {
    return _powerType;
}

inline void PowerMessage::setPowerType (uint16 powerType_) {
    set_has_powerType();
    this->_powerType = powerType_;
}

inline void PowerMessage::clearReserved() {
    if (hasReserved()) {
         clear_has_reserved();
        _reserved = 0u;
     }
}

inline bool PowerMessage::hasReserved () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 PowerMessage::getReserved () const {
    return _reserved;
}

inline void PowerMessage::setReserved (uint16 reserved_) {
    set_has_reserved();
    this->_reserved = reserved_;
}

inline void PowerMessage::clearData1() {
    if (hasData1()) {
         clear_has_data1();
        _data1 = 0u;
     }
}

inline bool PowerMessage::hasData1 () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 PowerMessage::getData1 () const {
    return _data1;
}

inline void PowerMessage::setData1 (uint32 data1_) {
    set_has_data1();
    this->_data1 = data1_;
}

inline void PowerMessage::clearData2() {
    if (hasData2()) {
         clear_has_data2();
        _data2 = 0u;
     }
}

inline bool PowerMessage::hasData2 () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 PowerMessage::getData2 () const {
    return _data2;
}

inline void PowerMessage::setData2 (uint32 data2_) {
    set_has_data2();
    this->_data2 = data2_;
}

inline void PowerMessage::set_has_powerType () {
    _has_bits_[0] |= 1u << 0;
}

inline void PowerMessage::clear_has_powerType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void PowerMessage::set_has_reserved () {
    _has_bits_[0] |= 1u << 1;
}

inline void PowerMessage::clear_has_reserved () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void PowerMessage::set_has_data1 () {
    _has_bits_[0] |= 1u << 2;
}

inline void PowerMessage::clear_has_data1 () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void PowerMessage::set_has_data2 () {
    _has_bits_[0] |= 1u << 3;
}

inline void PowerMessage::clear_has_data2 () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  ServiceRegister::ServiceRegister ()  :
    _serviceId (0u),
    _majorVersion (0u),
    _minorVersion (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ServiceRegister::ServiceRegister (const ServiceRegister &rhs)  :
    _serviceId (0u),
    _majorVersion (0u),
    _minorVersion (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ServiceRegister::ServiceRegister (uint16 serviceId_, uint16 majorVersion_, uint16 minorVersion_)  :
    _serviceId (serviceId_),
    _majorVersion (majorVersion_),
    _minorVersion (minorVersion_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ServiceRegister::~ServiceRegister() {
}

inline ServiceRegister& ServiceRegister::operator = (const ServiceRegister& rhs) {
    if( this != &rhs ) {
        if (rhs.hasServiceId()) {
            setServiceId(rhs.getServiceId());
        } else {
            clearServiceId();
        }
        if (rhs.hasMajorVersion()) {
            setMajorVersion(rhs.getMajorVersion());
        } else {
            clearMajorVersion();
        }
        if (rhs.hasMinorVersion()) {
            setMinorVersion(rhs.getMinorVersion());
        } else {
            clearMinorVersion();
        }
    }
    return *this;
}

inline bool ServiceRegister::operator == (const ServiceRegister& rhs) const {
    return (((!hasServiceId() && !rhs.hasServiceId()) || getServiceId() == rhs.getServiceId()) &&
        ((!hasMajorVersion() && !rhs.hasMajorVersion()) || getMajorVersion() == rhs.getMajorVersion()) &&
        ((!hasMinorVersion() && !rhs.hasMinorVersion()) || getMinorVersion() == rhs.getMinorVersion()));
}

inline bool ServiceRegister::operator != (const ServiceRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ServiceRegister::operator < (const ServiceRegister& rhs) const {
    if (hasServiceId() || rhs.hasServiceId()) {
        if (getServiceId() < rhs.getServiceId()) return true;
        if (getServiceId() > rhs.getServiceId()) return false;
    }
    if (hasMajorVersion() || rhs.hasMajorVersion()) {
        if (getMajorVersion() < rhs.getMajorVersion()) return true;
        if (getMajorVersion() > rhs.getMajorVersion()) return false;
    }
    if (hasMinorVersion() || rhs.hasMinorVersion()) {
        if (getMinorVersion() < rhs.getMinorVersion()) return true;
        if (getMinorVersion() > rhs.getMinorVersion()) return false;
    }
    return false;
}

inline bool ServiceRegister::operator > (const ServiceRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ServiceRegister::clear() {
    clearServiceId();
    clearMajorVersion();
    clearMinorVersion();
}

inline void ServiceRegister::clearServiceId() {
    if (hasServiceId()) {
         clear_has_serviceId();
        _serviceId = 0u;
     }
}

inline bool ServiceRegister::hasServiceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 ServiceRegister::getServiceId () const {
    return _serviceId;
}

inline void ServiceRegister::setServiceId (uint16 serviceId_) {
    set_has_serviceId();
    this->_serviceId = serviceId_;
}

inline void ServiceRegister::clearMajorVersion() {
    if (hasMajorVersion()) {
         clear_has_majorVersion();
        _majorVersion = 0u;
     }
}

inline bool ServiceRegister::hasMajorVersion () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 ServiceRegister::getMajorVersion () const {
    return _majorVersion;
}

inline void ServiceRegister::setMajorVersion (uint16 majorVersion_) {
    set_has_majorVersion();
    this->_majorVersion = majorVersion_;
}

inline void ServiceRegister::clearMinorVersion() {
    if (hasMinorVersion()) {
         clear_has_minorVersion();
        _minorVersion = 0u;
     }
}

inline bool ServiceRegister::hasMinorVersion () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 ServiceRegister::getMinorVersion () const {
    return _minorVersion;
}

inline void ServiceRegister::setMinorVersion (uint16 minorVersion_) {
    set_has_minorVersion();
    this->_minorVersion = minorVersion_;
}

inline void ServiceRegister::set_has_serviceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void ServiceRegister::clear_has_serviceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ServiceRegister::set_has_majorVersion () {
    _has_bits_[0] |= 1u << 1;
}

inline void ServiceRegister::clear_has_majorVersion () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ServiceRegister::set_has_minorVersion () {
    _has_bits_[0] |= 1u << 2;
}

inline void ServiceRegister::clear_has_minorVersion () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  ServiceUnregister::ServiceUnregister ()  :
    _serviceId (0u),
    _registerId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ServiceUnregister::ServiceUnregister (const ServiceUnregister &rhs)  :
    _serviceId (0u),
    _registerId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ServiceUnregister::ServiceUnregister (uint16 serviceId_, uint16 registerId_)  :
    _serviceId (serviceId_),
    _registerId (registerId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ServiceUnregister::~ServiceUnregister() {
}

inline ServiceUnregister& ServiceUnregister::operator = (const ServiceUnregister& rhs) {
    if( this != &rhs ) {
        if (rhs.hasServiceId()) {
            setServiceId(rhs.getServiceId());
        } else {
            clearServiceId();
        }
        if (rhs.hasRegisterId()) {
            setRegisterId(rhs.getRegisterId());
        } else {
            clearRegisterId();
        }
    }
    return *this;
}

inline bool ServiceUnregister::operator == (const ServiceUnregister& rhs) const {
    return (((!hasServiceId() && !rhs.hasServiceId()) || getServiceId() == rhs.getServiceId()) &&
        ((!hasRegisterId() && !rhs.hasRegisterId()) || getRegisterId() == rhs.getRegisterId()));
}

inline bool ServiceUnregister::operator != (const ServiceUnregister& rhs) const {
    return ! (*this == rhs);
}

inline bool ServiceUnregister::operator < (const ServiceUnregister& rhs) const {
    if (hasServiceId() || rhs.hasServiceId()) {
        if (getServiceId() < rhs.getServiceId()) return true;
        if (getServiceId() > rhs.getServiceId()) return false;
    }
    if (hasRegisterId() || rhs.hasRegisterId()) {
        if (getRegisterId() < rhs.getRegisterId()) return true;
        if (getRegisterId() > rhs.getRegisterId()) return false;
    }
    return false;
}

inline bool ServiceUnregister::operator > (const ServiceUnregister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ServiceUnregister::clear() {
    clearServiceId();
    clearRegisterId();
}

inline void ServiceUnregister::clearServiceId() {
    if (hasServiceId()) {
         clear_has_serviceId();
        _serviceId = 0u;
     }
}

inline bool ServiceUnregister::hasServiceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 ServiceUnregister::getServiceId () const {
    return _serviceId;
}

inline void ServiceUnregister::setServiceId (uint16 serviceId_) {
    set_has_serviceId();
    this->_serviceId = serviceId_;
}

inline void ServiceUnregister::clearRegisterId() {
    if (hasRegisterId()) {
         clear_has_registerId();
        _registerId = 0u;
     }
}

inline bool ServiceUnregister::hasRegisterId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 ServiceUnregister::getRegisterId () const {
    return _registerId;
}

inline void ServiceUnregister::setRegisterId (uint16 registerId_) {
    set_has_registerId();
    this->_registerId = registerId_;
}

inline void ServiceUnregister::set_has_serviceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void ServiceUnregister::clear_has_serviceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ServiceUnregister::set_has_registerId () {
    _has_bits_[0] |= 1u << 1;
}

inline void ServiceUnregister::clear_has_registerId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ServiceRegisterConfirmation::ServiceRegisterConfirmation ()  :
    _serviceId (0u),
    _registerId (0u),
    _status (::asf::cca::CcaTypes::RegistrationStatus__NoSuccess),
    _reserverd (0u),
    _majorVersion (0u),
    _minorVersion (0u),
    _patchVersion (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ServiceRegisterConfirmation::ServiceRegisterConfirmation (const ServiceRegisterConfirmation &rhs)  :
    _serviceId (0u),
    _registerId (0u),
    _status (::asf::cca::CcaTypes::RegistrationStatus__NoSuccess),
    _reserverd (0u),
    _majorVersion (0u),
    _minorVersion (0u),
    _patchVersion (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ServiceRegisterConfirmation::ServiceRegisterConfirmation (uint16 serviceId_, uint16 registerId_, RegistrationStatus status_, uint8 reserverd_, uint16 majorVersion_, uint16 minorVersion_, uint16 patchVersion_)  :
    _serviceId (serviceId_),
    _registerId (registerId_),
    _status (status_),
    _reserverd (reserverd_),
    _majorVersion (majorVersion_),
    _minorVersion (minorVersion_),
    _patchVersion (patchVersion_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(RegistrationStatus_IsValid(status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "RegistrationStatus", "status", "ServiceRegisterConfirmation");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ServiceRegisterConfirmation::~ServiceRegisterConfirmation() {
}

inline ServiceRegisterConfirmation& ServiceRegisterConfirmation::operator = (const ServiceRegisterConfirmation& rhs) {
    if( this != &rhs ) {
        if (rhs.hasServiceId()) {
            setServiceId(rhs.getServiceId());
        } else {
            clearServiceId();
        }
        if (rhs.hasRegisterId()) {
            setRegisterId(rhs.getRegisterId());
        } else {
            clearRegisterId();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
        if (rhs.hasReserverd()) {
            setReserverd(rhs.getReserverd());
        } else {
            clearReserverd();
        }
        if (rhs.hasMajorVersion()) {
            setMajorVersion(rhs.getMajorVersion());
        } else {
            clearMajorVersion();
        }
        if (rhs.hasMinorVersion()) {
            setMinorVersion(rhs.getMinorVersion());
        } else {
            clearMinorVersion();
        }
        if (rhs.hasPatchVersion()) {
            setPatchVersion(rhs.getPatchVersion());
        } else {
            clearPatchVersion();
        }
    }
    return *this;
}

inline bool ServiceRegisterConfirmation::operator == (const ServiceRegisterConfirmation& rhs) const {
    return (((!hasServiceId() && !rhs.hasServiceId()) || getServiceId() == rhs.getServiceId()) &&
        ((!hasRegisterId() && !rhs.hasRegisterId()) || getRegisterId() == rhs.getRegisterId()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()) &&
        ((!hasReserverd() && !rhs.hasReserverd()) || getReserverd() == rhs.getReserverd()) &&
        ((!hasMajorVersion() && !rhs.hasMajorVersion()) || getMajorVersion() == rhs.getMajorVersion()) &&
        ((!hasMinorVersion() && !rhs.hasMinorVersion()) || getMinorVersion() == rhs.getMinorVersion()) &&
        ((!hasPatchVersion() && !rhs.hasPatchVersion()) || getPatchVersion() == rhs.getPatchVersion()));
}

inline bool ServiceRegisterConfirmation::operator != (const ServiceRegisterConfirmation& rhs) const {
    return ! (*this == rhs);
}

inline bool ServiceRegisterConfirmation::operator < (const ServiceRegisterConfirmation& rhs) const {
    if (hasServiceId() || rhs.hasServiceId()) {
        if (getServiceId() < rhs.getServiceId()) return true;
        if (getServiceId() > rhs.getServiceId()) return false;
    }
    if (hasRegisterId() || rhs.hasRegisterId()) {
        if (getRegisterId() < rhs.getRegisterId()) return true;
        if (getRegisterId() > rhs.getRegisterId()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    if (hasReserverd() || rhs.hasReserverd()) {
        if (getReserverd() < rhs.getReserverd()) return true;
        if (getReserverd() > rhs.getReserverd()) return false;
    }
    if (hasMajorVersion() || rhs.hasMajorVersion()) {
        if (getMajorVersion() < rhs.getMajorVersion()) return true;
        if (getMajorVersion() > rhs.getMajorVersion()) return false;
    }
    if (hasMinorVersion() || rhs.hasMinorVersion()) {
        if (getMinorVersion() < rhs.getMinorVersion()) return true;
        if (getMinorVersion() > rhs.getMinorVersion()) return false;
    }
    if (hasPatchVersion() || rhs.hasPatchVersion()) {
        if (getPatchVersion() < rhs.getPatchVersion()) return true;
        if (getPatchVersion() > rhs.getPatchVersion()) return false;
    }
    return false;
}

inline bool ServiceRegisterConfirmation::operator > (const ServiceRegisterConfirmation& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ServiceRegisterConfirmation::clear() {
    clearServiceId();
    clearRegisterId();
    clearStatus();
    clearReserverd();
    clearMajorVersion();
    clearMinorVersion();
    clearPatchVersion();
}

inline void ServiceRegisterConfirmation::clearServiceId() {
    if (hasServiceId()) {
         clear_has_serviceId();
        _serviceId = 0u;
     }
}

inline bool ServiceRegisterConfirmation::hasServiceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 ServiceRegisterConfirmation::getServiceId () const {
    return _serviceId;
}

inline void ServiceRegisterConfirmation::setServiceId (uint16 serviceId_) {
    set_has_serviceId();
    this->_serviceId = serviceId_;
}

inline void ServiceRegisterConfirmation::clearRegisterId() {
    if (hasRegisterId()) {
         clear_has_registerId();
        _registerId = 0u;
     }
}

inline bool ServiceRegisterConfirmation::hasRegisterId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 ServiceRegisterConfirmation::getRegisterId () const {
    return _registerId;
}

inline void ServiceRegisterConfirmation::setRegisterId (uint16 registerId_) {
    set_has_registerId();
    this->_registerId = registerId_;
}

inline void ServiceRegisterConfirmation::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = ::asf::cca::CcaTypes::RegistrationStatus__NoSuccess;
     }
}

inline bool ServiceRegisterConfirmation::hasStatus () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline RegistrationStatus ServiceRegisterConfirmation::getStatus () const {
    return _status;
}

inline void ServiceRegisterConfirmation::setStatus (RegistrationStatus status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(RegistrationStatus_IsValid(status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "RegistrationStatus", "status", "ServiceRegisterConfirmation");
    }
    set_has_status();
    this->_status = status_;
}

inline void ServiceRegisterConfirmation::clearReserverd() {
    if (hasReserverd()) {
         clear_has_reserverd();
        _reserverd = 0u;
     }
}

inline bool ServiceRegisterConfirmation::hasReserverd () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 ServiceRegisterConfirmation::getReserverd () const {
    return _reserverd;
}

inline void ServiceRegisterConfirmation::setReserverd (uint8 reserverd_) {
    set_has_reserverd();
    this->_reserverd = reserverd_;
}

inline void ServiceRegisterConfirmation::clearMajorVersion() {
    if (hasMajorVersion()) {
         clear_has_majorVersion();
        _majorVersion = 0u;
     }
}

inline bool ServiceRegisterConfirmation::hasMajorVersion () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint16 ServiceRegisterConfirmation::getMajorVersion () const {
    return _majorVersion;
}

inline void ServiceRegisterConfirmation::setMajorVersion (uint16 majorVersion_) {
    set_has_majorVersion();
    this->_majorVersion = majorVersion_;
}

inline void ServiceRegisterConfirmation::clearMinorVersion() {
    if (hasMinorVersion()) {
         clear_has_minorVersion();
        _minorVersion = 0u;
     }
}

inline bool ServiceRegisterConfirmation::hasMinorVersion () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint16 ServiceRegisterConfirmation::getMinorVersion () const {
    return _minorVersion;
}

inline void ServiceRegisterConfirmation::setMinorVersion (uint16 minorVersion_) {
    set_has_minorVersion();
    this->_minorVersion = minorVersion_;
}

inline void ServiceRegisterConfirmation::clearPatchVersion() {
    if (hasPatchVersion()) {
         clear_has_patchVersion();
        _patchVersion = 0u;
     }
}

inline bool ServiceRegisterConfirmation::hasPatchVersion () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint16 ServiceRegisterConfirmation::getPatchVersion () const {
    return _patchVersion;
}

inline void ServiceRegisterConfirmation::setPatchVersion (uint16 patchVersion_) {
    set_has_patchVersion();
    this->_patchVersion = patchVersion_;
}

inline void ServiceRegisterConfirmation::set_has_serviceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void ServiceRegisterConfirmation::clear_has_serviceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ServiceRegisterConfirmation::set_has_registerId () {
    _has_bits_[0] |= 1u << 1;
}

inline void ServiceRegisterConfirmation::clear_has_registerId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ServiceRegisterConfirmation::set_has_status () {
    _has_bits_[0] |= 1u << 2;
}

inline void ServiceRegisterConfirmation::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ServiceRegisterConfirmation::set_has_reserverd () {
    _has_bits_[0] |= 1u << 3;
}

inline void ServiceRegisterConfirmation::clear_has_reserverd () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void ServiceRegisterConfirmation::set_has_majorVersion () {
    _has_bits_[0] |= 1u << 4;
}

inline void ServiceRegisterConfirmation::clear_has_majorVersion () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void ServiceRegisterConfirmation::set_has_minorVersion () {
    _has_bits_[0] |= 1u << 5;
}

inline void ServiceRegisterConfirmation::clear_has_minorVersion () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void ServiceRegisterConfirmation::set_has_patchVersion () {
    _has_bits_[0] |= 1u << 6;
}

inline void ServiceRegisterConfirmation::clear_has_patchVersion () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline  ServiceStatus::ServiceStatus ()  :
    _serviceId (0u),
    _registerId (0u),
    _state (::asf::cca::CcaTypes::AvailabilityState__Available),
    _reserverd (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ServiceStatus::ServiceStatus (const ServiceStatus &rhs)  :
    _serviceId (0u),
    _registerId (0u),
    _state (::asf::cca::CcaTypes::AvailabilityState__Available),
    _reserverd (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ServiceStatus::ServiceStatus (uint16 serviceId_, uint16 registerId_, AvailabilityState state_, uint8 reserverd_)  :
    _serviceId (serviceId_),
    _registerId (registerId_),
    _state (state_),
    _reserverd (reserverd_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(AvailabilityState_IsValid(state_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", state_, "AvailabilityState", "state", "ServiceStatus");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ServiceStatus::~ServiceStatus() {
}

inline ServiceStatus& ServiceStatus::operator = (const ServiceStatus& rhs) {
    if( this != &rhs ) {
        if (rhs.hasServiceId()) {
            setServiceId(rhs.getServiceId());
        } else {
            clearServiceId();
        }
        if (rhs.hasRegisterId()) {
            setRegisterId(rhs.getRegisterId());
        } else {
            clearRegisterId();
        }
        if (rhs.hasState()) {
            setState(rhs.getState());
        } else {
            clearState();
        }
        if (rhs.hasReserverd()) {
            setReserverd(rhs.getReserverd());
        } else {
            clearReserverd();
        }
    }
    return *this;
}

inline bool ServiceStatus::operator == (const ServiceStatus& rhs) const {
    return (((!hasServiceId() && !rhs.hasServiceId()) || getServiceId() == rhs.getServiceId()) &&
        ((!hasRegisterId() && !rhs.hasRegisterId()) || getRegisterId() == rhs.getRegisterId()) &&
        ((!hasState() && !rhs.hasState()) || getState() == rhs.getState()) &&
        ((!hasReserverd() && !rhs.hasReserverd()) || getReserverd() == rhs.getReserverd()));
}

inline bool ServiceStatus::operator != (const ServiceStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool ServiceStatus::operator < (const ServiceStatus& rhs) const {
    if (hasServiceId() || rhs.hasServiceId()) {
        if (getServiceId() < rhs.getServiceId()) return true;
        if (getServiceId() > rhs.getServiceId()) return false;
    }
    if (hasRegisterId() || rhs.hasRegisterId()) {
        if (getRegisterId() < rhs.getRegisterId()) return true;
        if (getRegisterId() > rhs.getRegisterId()) return false;
    }
    if (hasState() || rhs.hasState()) {
        if ((uint32)getState() < (uint32)rhs.getState()) return true;
        if ((uint32)getState() > (uint32)rhs.getState()) return false;
    }
    if (hasReserverd() || rhs.hasReserverd()) {
        if (getReserverd() < rhs.getReserverd()) return true;
        if (getReserverd() > rhs.getReserverd()) return false;
    }
    return false;
}

inline bool ServiceStatus::operator > (const ServiceStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ServiceStatus::clear() {
    clearServiceId();
    clearRegisterId();
    clearState();
    clearReserverd();
}

inline void ServiceStatus::clearServiceId() {
    if (hasServiceId()) {
         clear_has_serviceId();
        _serviceId = 0u;
     }
}

inline bool ServiceStatus::hasServiceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 ServiceStatus::getServiceId () const {
    return _serviceId;
}

inline void ServiceStatus::setServiceId (uint16 serviceId_) {
    set_has_serviceId();
    this->_serviceId = serviceId_;
}

inline void ServiceStatus::clearRegisterId() {
    if (hasRegisterId()) {
         clear_has_registerId();
        _registerId = 0u;
     }
}

inline bool ServiceStatus::hasRegisterId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 ServiceStatus::getRegisterId () const {
    return _registerId;
}

inline void ServiceStatus::setRegisterId (uint16 registerId_) {
    set_has_registerId();
    this->_registerId = registerId_;
}

inline void ServiceStatus::clearState() {
    if (hasState()) {
         clear_has_state();
        _state = ::asf::cca::CcaTypes::AvailabilityState__Available;
     }
}

inline bool ServiceStatus::hasState () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline AvailabilityState ServiceStatus::getState () const {
    return _state;
}

inline void ServiceStatus::setState (AvailabilityState state_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(AvailabilityState_IsValid(state_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", state_, "AvailabilityState", "state", "ServiceStatus");
    }
    set_has_state();
    this->_state = state_;
}

inline void ServiceStatus::clearReserverd() {
    if (hasReserverd()) {
         clear_has_reserverd();
        _reserverd = 0u;
     }
}

inline bool ServiceStatus::hasReserverd () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 ServiceStatus::getReserverd () const {
    return _reserverd;
}

inline void ServiceStatus::setReserverd (uint8 reserverd_) {
    set_has_reserverd();
    this->_reserverd = reserverd_;
}

inline void ServiceStatus::set_has_serviceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void ServiceStatus::clear_has_serviceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ServiceStatus::set_has_registerId () {
    _has_bits_[0] |= 1u << 1;
}

inline void ServiceStatus::clear_has_registerId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ServiceStatus::set_has_state () {
    _has_bits_[0] |= 1u << 2;
}

inline void ServiceStatus::clear_has_state () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ServiceStatus::set_has_reserverd () {
    _has_bits_[0] |= 1u << 3;
}

inline void ServiceStatus::clear_has_reserverd () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  ServiceData::ServiceData ()  :
    _serviceId (0u),
    _registerId (0u),
    _functionId (0u),
    _opCode (::asf::cca::CcaTypes::ServiceData::OpCode__Set),
    _act (0u),
    _commandCounter (0u),
    _streamType (0u),
    _streamCounter (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ServiceData::ServiceData (const ServiceData &rhs)  :
    _serviceId (0u),
    _registerId (0u),
    _functionId (0u),
    _opCode (::asf::cca::CcaTypes::ServiceData::OpCode__Set),
    _act (0u),
    _commandCounter (0u),
    _streamType (0u),
    _streamCounter (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ServiceData::ServiceData (uint16 serviceId_, uint16 registerId_, uint16 functionId_, ServiceData_OpCode opCode_, uint8 act_, uint16 commandCounter_, uint8 streamType_, uint8 streamCounter_)  :
    _serviceId (serviceId_),
    _registerId (registerId_),
    _functionId (functionId_),
    _opCode (opCode_),
    _act (act_),
    _commandCounter (commandCounter_),
    _streamType (streamType_),
    _streamCounter (streamCounter_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(ServiceData_OpCode_IsValid(opCode_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", opCode_, "OpCode", "opCode", "ServiceData");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ServiceData::~ServiceData() {
}

inline ServiceData& ServiceData::operator = (const ServiceData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasServiceId()) {
            setServiceId(rhs.getServiceId());
        } else {
            clearServiceId();
        }
        if (rhs.hasRegisterId()) {
            setRegisterId(rhs.getRegisterId());
        } else {
            clearRegisterId();
        }
        if (rhs.hasFunctionId()) {
            setFunctionId(rhs.getFunctionId());
        } else {
            clearFunctionId();
        }
        if (rhs.hasOpCode()) {
            setOpCode(rhs.getOpCode());
        } else {
            clearOpCode();
        }
        if (rhs.hasAct()) {
            setAct(rhs.getAct());
        } else {
            clearAct();
        }
        if (rhs.hasCommandCounter()) {
            setCommandCounter(rhs.getCommandCounter());
        } else {
            clearCommandCounter();
        }
        if (rhs.hasStreamType()) {
            setStreamType(rhs.getStreamType());
        } else {
            clearStreamType();
        }
        if (rhs.hasStreamCounter()) {
            setStreamCounter(rhs.getStreamCounter());
        } else {
            clearStreamCounter();
        }
    }
    return *this;
}

inline bool ServiceData::operator == (const ServiceData& rhs) const {
    return (((!hasServiceId() && !rhs.hasServiceId()) || getServiceId() == rhs.getServiceId()) &&
        ((!hasRegisterId() && !rhs.hasRegisterId()) || getRegisterId() == rhs.getRegisterId()) &&
        ((!hasFunctionId() && !rhs.hasFunctionId()) || getFunctionId() == rhs.getFunctionId()) &&
        ((!hasOpCode() && !rhs.hasOpCode()) || getOpCode() == rhs.getOpCode()) &&
        ((!hasAct() && !rhs.hasAct()) || getAct() == rhs.getAct()) &&
        ((!hasCommandCounter() && !rhs.hasCommandCounter()) || getCommandCounter() == rhs.getCommandCounter()) &&
        ((!hasStreamType() && !rhs.hasStreamType()) || getStreamType() == rhs.getStreamType()) &&
        ((!hasStreamCounter() && !rhs.hasStreamCounter()) || getStreamCounter() == rhs.getStreamCounter()));
}

inline bool ServiceData::operator != (const ServiceData& rhs) const {
    return ! (*this == rhs);
}

inline bool ServiceData::operator < (const ServiceData& rhs) const {
    if (hasServiceId() || rhs.hasServiceId()) {
        if (getServiceId() < rhs.getServiceId()) return true;
        if (getServiceId() > rhs.getServiceId()) return false;
    }
    if (hasRegisterId() || rhs.hasRegisterId()) {
        if (getRegisterId() < rhs.getRegisterId()) return true;
        if (getRegisterId() > rhs.getRegisterId()) return false;
    }
    if (hasFunctionId() || rhs.hasFunctionId()) {
        if (getFunctionId() < rhs.getFunctionId()) return true;
        if (getFunctionId() > rhs.getFunctionId()) return false;
    }
    if (hasOpCode() || rhs.hasOpCode()) {
        if ((uint32)getOpCode() < (uint32)rhs.getOpCode()) return true;
        if ((uint32)getOpCode() > (uint32)rhs.getOpCode()) return false;
    }
    if (hasAct() || rhs.hasAct()) {
        if (getAct() < rhs.getAct()) return true;
        if (getAct() > rhs.getAct()) return false;
    }
    if (hasCommandCounter() || rhs.hasCommandCounter()) {
        if (getCommandCounter() < rhs.getCommandCounter()) return true;
        if (getCommandCounter() > rhs.getCommandCounter()) return false;
    }
    if (hasStreamType() || rhs.hasStreamType()) {
        if (getStreamType() < rhs.getStreamType()) return true;
        if (getStreamType() > rhs.getStreamType()) return false;
    }
    if (hasStreamCounter() || rhs.hasStreamCounter()) {
        if (getStreamCounter() < rhs.getStreamCounter()) return true;
        if (getStreamCounter() > rhs.getStreamCounter()) return false;
    }
    return false;
}

inline bool ServiceData::operator > (const ServiceData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ServiceData::clear() {
    clearServiceId();
    clearRegisterId();
    clearFunctionId();
    clearOpCode();
    clearAct();
    clearCommandCounter();
    clearStreamType();
    clearStreamCounter();
}

inline void ServiceData::clearServiceId() {
    if (hasServiceId()) {
         clear_has_serviceId();
        _serviceId = 0u;
     }
}

inline bool ServiceData::hasServiceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 ServiceData::getServiceId () const {
    return _serviceId;
}

inline void ServiceData::setServiceId (uint16 serviceId_) {
    set_has_serviceId();
    this->_serviceId = serviceId_;
}

inline void ServiceData::clearRegisterId() {
    if (hasRegisterId()) {
         clear_has_registerId();
        _registerId = 0u;
     }
}

inline bool ServiceData::hasRegisterId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 ServiceData::getRegisterId () const {
    return _registerId;
}

inline void ServiceData::setRegisterId (uint16 registerId_) {
    set_has_registerId();
    this->_registerId = registerId_;
}

inline void ServiceData::clearFunctionId() {
    if (hasFunctionId()) {
         clear_has_functionId();
        _functionId = 0u;
     }
}

inline bool ServiceData::hasFunctionId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 ServiceData::getFunctionId () const {
    return _functionId;
}

inline void ServiceData::setFunctionId (uint16 functionId_) {
    set_has_functionId();
    this->_functionId = functionId_;
}

inline void ServiceData::clearOpCode() {
    if (hasOpCode()) {
         clear_has_opCode();
        _opCode = ::asf::cca::CcaTypes::ServiceData::OpCode__Set;
     }
}

inline bool ServiceData::hasOpCode () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline ServiceData_OpCode ServiceData::getOpCode () const {
    return _opCode;
}

inline void ServiceData::setOpCode (ServiceData_OpCode opCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(ServiceData_OpCode_IsValid(opCode_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", opCode_, "OpCode", "opCode", "ServiceData");
    }
    set_has_opCode();
    this->_opCode = opCode_;
}

inline void ServiceData::clearAct() {
    if (hasAct()) {
         clear_has_act();
        _act = 0u;
     }
}

inline bool ServiceData::hasAct () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 ServiceData::getAct () const {
    return _act;
}

inline void ServiceData::setAct (uint8 act_) {
    set_has_act();
    this->_act = act_;
}

inline void ServiceData::clearCommandCounter() {
    if (hasCommandCounter()) {
         clear_has_commandCounter();
        _commandCounter = 0u;
     }
}

inline bool ServiceData::hasCommandCounter () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint16 ServiceData::getCommandCounter () const {
    return _commandCounter;
}

inline void ServiceData::setCommandCounter (uint16 commandCounter_) {
    set_has_commandCounter();
    this->_commandCounter = commandCounter_;
}

inline void ServiceData::clearStreamType() {
    if (hasStreamType()) {
         clear_has_streamType();
        _streamType = 0u;
     }
}

inline bool ServiceData::hasStreamType () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 ServiceData::getStreamType () const {
    return _streamType;
}

inline void ServiceData::setStreamType (uint8 streamType_) {
    set_has_streamType();
    this->_streamType = streamType_;
}

inline void ServiceData::clearStreamCounter() {
    if (hasStreamCounter()) {
         clear_has_streamCounter();
        _streamCounter = 0u;
     }
}

inline bool ServiceData::hasStreamCounter () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint8 ServiceData::getStreamCounter () const {
    return _streamCounter;
}

inline void ServiceData::setStreamCounter (uint8 streamCounter_) {
    set_has_streamCounter();
    this->_streamCounter = streamCounter_;
}

inline void ServiceData::set_has_serviceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void ServiceData::clear_has_serviceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ServiceData::set_has_registerId () {
    _has_bits_[0] |= 1u << 1;
}

inline void ServiceData::clear_has_registerId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ServiceData::set_has_functionId () {
    _has_bits_[0] |= 1u << 2;
}

inline void ServiceData::clear_has_functionId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ServiceData::set_has_opCode () {
    _has_bits_[0] |= 1u << 3;
}

inline void ServiceData::clear_has_opCode () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void ServiceData::set_has_act () {
    _has_bits_[0] |= 1u << 4;
}

inline void ServiceData::clear_has_act () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void ServiceData::set_has_commandCounter () {
    _has_bits_[0] |= 1u << 5;
}

inline void ServiceData::clear_has_commandCounter () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void ServiceData::set_has_streamType () {
    _has_bits_[0] |= 1u << 6;
}

inline void ServiceData::clear_has_streamType () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void ServiceData::set_has_streamCounter () {
    _has_bits_[0] |= 1u << 7;
}

inline void ServiceData::clear_has_streamCounter () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline  SrvSupplierRegister::SrvSupplierRegister ()  :
    _serviceId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SrvSupplierRegister::SrvSupplierRegister (const SrvSupplierRegister &rhs)  :
    _serviceId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SrvSupplierRegister::SrvSupplierRegister (uint16 serviceId_)  :
    _serviceId (serviceId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SrvSupplierRegister::~SrvSupplierRegister() {
}

inline SrvSupplierRegister& SrvSupplierRegister::operator = (const SrvSupplierRegister& rhs) {
    if( this != &rhs ) {
        if (rhs.hasServiceId()) {
            setServiceId(rhs.getServiceId());
        } else {
            clearServiceId();
        }
    }
    return *this;
}

inline bool SrvSupplierRegister::operator == (const SrvSupplierRegister& rhs) const {
    return (((!hasServiceId() && !rhs.hasServiceId()) || getServiceId() == rhs.getServiceId()));
}

inline bool SrvSupplierRegister::operator != (const SrvSupplierRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool SrvSupplierRegister::operator < (const SrvSupplierRegister& rhs) const {
    if (hasServiceId() || rhs.hasServiceId()) {
        if (getServiceId() < rhs.getServiceId()) return true;
        if (getServiceId() > rhs.getServiceId()) return false;
    }
    return false;
}

inline bool SrvSupplierRegister::operator > (const SrvSupplierRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SrvSupplierRegister::clear() {
    clearServiceId();
}

inline void SrvSupplierRegister::clearServiceId() {
    if (hasServiceId()) {
         clear_has_serviceId();
        _serviceId = 0u;
     }
}

inline bool SrvSupplierRegister::hasServiceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 SrvSupplierRegister::getServiceId () const {
    return _serviceId;
}

inline void SrvSupplierRegister::setServiceId (uint16 serviceId_) {
    set_has_serviceId();
    this->_serviceId = serviceId_;
}

inline void SrvSupplierRegister::set_has_serviceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void SrvSupplierRegister::clear_has_serviceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SrvSupplierStatus::SrvSupplierStatus ()  :
    _serviceId (0u),
    _appId (0u),
    _status (::asf::cca::CcaTypes::SrvSupplierStatus::Status__Unavailable)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SrvSupplierStatus::SrvSupplierStatus (const SrvSupplierStatus &rhs)  :
    _serviceId (0u),
    _appId (0u),
    _status (::asf::cca::CcaTypes::SrvSupplierStatus::Status__Unavailable)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SrvSupplierStatus::SrvSupplierStatus (uint16 serviceId_, uint16 appId_, SrvSupplierStatus_Status status_)  :
    _serviceId (serviceId_),
    _appId (appId_),
    _status (status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(SrvSupplierStatus_Status_IsValid(status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "Status", "status", "SrvSupplierStatus");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SrvSupplierStatus::~SrvSupplierStatus() {
}

inline SrvSupplierStatus& SrvSupplierStatus::operator = (const SrvSupplierStatus& rhs) {
    if( this != &rhs ) {
        if (rhs.hasServiceId()) {
            setServiceId(rhs.getServiceId());
        } else {
            clearServiceId();
        }
        if (rhs.hasAppId()) {
            setAppId(rhs.getAppId());
        } else {
            clearAppId();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool SrvSupplierStatus::operator == (const SrvSupplierStatus& rhs) const {
    return (((!hasServiceId() && !rhs.hasServiceId()) || getServiceId() == rhs.getServiceId()) &&
        ((!hasAppId() && !rhs.hasAppId()) || getAppId() == rhs.getAppId()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool SrvSupplierStatus::operator != (const SrvSupplierStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SrvSupplierStatus::operator < (const SrvSupplierStatus& rhs) const {
    if (hasServiceId() || rhs.hasServiceId()) {
        if (getServiceId() < rhs.getServiceId()) return true;
        if (getServiceId() > rhs.getServiceId()) return false;
    }
    if (hasAppId() || rhs.hasAppId()) {
        if (getAppId() < rhs.getAppId()) return true;
        if (getAppId() > rhs.getAppId()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline bool SrvSupplierStatus::operator > (const SrvSupplierStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SrvSupplierStatus::clear() {
    clearServiceId();
    clearAppId();
    clearStatus();
}

inline void SrvSupplierStatus::clearServiceId() {
    if (hasServiceId()) {
         clear_has_serviceId();
        _serviceId = 0u;
     }
}

inline bool SrvSupplierStatus::hasServiceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 SrvSupplierStatus::getServiceId () const {
    return _serviceId;
}

inline void SrvSupplierStatus::setServiceId (uint16 serviceId_) {
    set_has_serviceId();
    this->_serviceId = serviceId_;
}

inline void SrvSupplierStatus::clearAppId() {
    if (hasAppId()) {
         clear_has_appId();
        _appId = 0u;
     }
}

inline bool SrvSupplierStatus::hasAppId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 SrvSupplierStatus::getAppId () const {
    return _appId;
}

inline void SrvSupplierStatus::setAppId (uint16 appId_) {
    set_has_appId();
    this->_appId = appId_;
}

inline void SrvSupplierStatus::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = ::asf::cca::CcaTypes::SrvSupplierStatus::Status__Unavailable;
     }
}

inline bool SrvSupplierStatus::hasStatus () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline SrvSupplierStatus_Status SrvSupplierStatus::getStatus () const {
    return _status;
}

inline void SrvSupplierStatus::setStatus (SrvSupplierStatus_Status status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(SrvSupplierStatus_Status_IsValid(status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "Status", "status", "SrvSupplierStatus");
    }
    set_has_status();
    this->_status = status_;
}

inline void SrvSupplierStatus::set_has_serviceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void SrvSupplierStatus::clear_has_serviceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SrvSupplierStatus::set_has_appId () {
    _has_bits_[0] |= 1u << 1;
}

inline void SrvSupplierStatus::clear_has_appId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SrvSupplierStatus::set_has_status () {
    _has_bits_[0] |= 1u << 2;
}

inline void SrvSupplierStatus::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  AppInfoRegister::AppInfoRegister ()  :
    _appId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AppInfoRegister::AppInfoRegister (const AppInfoRegister &rhs)  :
    _appId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AppInfoRegister::AppInfoRegister (uint16 appId_)  :
    _appId (appId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AppInfoRegister::~AppInfoRegister() {
}

inline AppInfoRegister& AppInfoRegister::operator = (const AppInfoRegister& rhs) {
    if( this != &rhs ) {
        if (rhs.hasAppId()) {
            setAppId(rhs.getAppId());
        } else {
            clearAppId();
        }
    }
    return *this;
}

inline bool AppInfoRegister::operator == (const AppInfoRegister& rhs) const {
    return (((!hasAppId() && !rhs.hasAppId()) || getAppId() == rhs.getAppId()));
}

inline bool AppInfoRegister::operator != (const AppInfoRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool AppInfoRegister::operator < (const AppInfoRegister& rhs) const {
    if (hasAppId() || rhs.hasAppId()) {
        if (getAppId() < rhs.getAppId()) return true;
        if (getAppId() > rhs.getAppId()) return false;
    }
    return false;
}

inline bool AppInfoRegister::operator > (const AppInfoRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AppInfoRegister::clear() {
    clearAppId();
}

inline void AppInfoRegister::clearAppId() {
    if (hasAppId()) {
         clear_has_appId();
        _appId = 0u;
     }
}

inline bool AppInfoRegister::hasAppId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 AppInfoRegister::getAppId () const {
    return _appId;
}

inline void AppInfoRegister::setAppId (uint16 appId_) {
    set_has_appId();
    this->_appId = appId_;
}

inline void AppInfoRegister::set_has_appId () {
    _has_bits_[0] |= 1u << 0;
}

inline void AppInfoRegister::clear_has_appId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AppInfoStatus::AppInfoStatus ()  :
    _appId (0u),
    _status (::asf::cca::CcaTypes::AppInfoStatus::Status__Unavailable)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AppInfoStatus::AppInfoStatus (const AppInfoStatus &rhs)  :
    _appId (0u),
    _status (::asf::cca::CcaTypes::AppInfoStatus::Status__Unavailable)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AppInfoStatus::AppInfoStatus (uint16 appId_, AppInfoStatus_Status status_)  :
    _appId (appId_),
    _status (status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(AppInfoStatus_Status_IsValid(status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "Status", "status", "AppInfoStatus");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AppInfoStatus::~AppInfoStatus() {
}

inline AppInfoStatus& AppInfoStatus::operator = (const AppInfoStatus& rhs) {
    if( this != &rhs ) {
        if (rhs.hasAppId()) {
            setAppId(rhs.getAppId());
        } else {
            clearAppId();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool AppInfoStatus::operator == (const AppInfoStatus& rhs) const {
    return (((!hasAppId() && !rhs.hasAppId()) || getAppId() == rhs.getAppId()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool AppInfoStatus::operator != (const AppInfoStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool AppInfoStatus::operator < (const AppInfoStatus& rhs) const {
    if (hasAppId() || rhs.hasAppId()) {
        if (getAppId() < rhs.getAppId()) return true;
        if (getAppId() > rhs.getAppId()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline bool AppInfoStatus::operator > (const AppInfoStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AppInfoStatus::clear() {
    clearAppId();
    clearStatus();
}

inline void AppInfoStatus::clearAppId() {
    if (hasAppId()) {
         clear_has_appId();
        _appId = 0u;
     }
}

inline bool AppInfoStatus::hasAppId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 AppInfoStatus::getAppId () const {
    return _appId;
}

inline void AppInfoStatus::setAppId (uint16 appId_) {
    set_has_appId();
    this->_appId = appId_;
}

inline void AppInfoStatus::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = ::asf::cca::CcaTypes::AppInfoStatus::Status__Unavailable;
     }
}

inline bool AppInfoStatus::hasStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline AppInfoStatus_Status AppInfoStatus::getStatus () const {
    return _status;
}

inline void AppInfoStatus::setStatus (AppInfoStatus_Status status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(AppInfoStatus_Status_IsValid(status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "Status", "status", "AppInfoStatus");
    }
    set_has_status();
    this->_status = status_;
}

inline void AppInfoStatus::set_has_appId () {
    _has_bits_[0] |= 1u << 0;
}

inline void AppInfoStatus::clear_has_appId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AppInfoStatus::set_has_status () {
    _has_bits_[0] |= 1u << 1;
}

inline void AppInfoStatus::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  CcaMessageExtension::CcaMessageExtension () :
    __field (E_POWER_MESSAGE),
    _data()
{
    _data.powerMessage_ = NULL;
}

inline  CcaMessageExtension::CcaMessageExtension (const CcaMessageExtension& rhs) :
    __field (E_POWER_MESSAGE),
    _data()
{
    _data.powerMessage_ = NULL;
    *this = rhs;
}

inline  CcaMessageExtension::~CcaMessageExtension() {
    deleteData ();
}

inline CcaMessageExtension& CcaMessageExtension::operator = (const CcaMessageExtension& rhs) {
    if( this != &rhs ) {
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool CcaMessageExtension::operator == (const CcaMessageExtension& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_POWER_MESSAGE:
            if (_data.powerMessage_ == NULL && rhs._data.powerMessage_ == NULL) {
                return true;
            }
            return (getPowerMessage() == rhs.getPowerMessage());
        case E_SERVICE_REGISTER:
            if (_data.serviceRegister_ == NULL && rhs._data.serviceRegister_ == NULL) {
                return true;
            }
            return (getServiceRegister() == rhs.getServiceRegister());
        case E_SERVICE_UNREGISTER:
            if (_data.serviceUnregister_ == NULL && rhs._data.serviceUnregister_ == NULL) {
                return true;
            }
            return (getServiceUnregister() == rhs.getServiceUnregister());
        case E_SERVICE_REGISTER_CONFIRMATION:
            if (_data.serviceRegisterConfirmation_ == NULL && rhs._data.serviceRegisterConfirmation_ == NULL) {
                return true;
            }
            return (getServiceRegisterConfirmation() == rhs.getServiceRegisterConfirmation());
        case E_SERVICE_STATUS:
            if (_data.serviceStatus_ == NULL && rhs._data.serviceStatus_ == NULL) {
                return true;
            }
            return (getServiceStatus() == rhs.getServiceStatus());
        case E_SERVICE_DATA:
            if (_data.serviceData_ == NULL && rhs._data.serviceData_ == NULL) {
                return true;
            }
            return (getServiceData() == rhs.getServiceData());
        case E_SRV_SUPPLIER_REGISTER:
            if (_data.srvSupplierRegister_ == NULL && rhs._data.srvSupplierRegister_ == NULL) {
                return true;
            }
            return (getSrvSupplierRegister() == rhs.getSrvSupplierRegister());
        case E_SRV_SUPPLIER_STATUS:
            if (_data.srvSupplierStatus_ == NULL && rhs._data.srvSupplierStatus_ == NULL) {
                return true;
            }
            return (getSrvSupplierStatus() == rhs.getSrvSupplierStatus());
        case E_SRV_SUPPLIER_UNREGISTER:
            if (_data.srvSupplierUnregister_ == NULL && rhs._data.srvSupplierUnregister_ == NULL) {
                return true;
            }
            return (getSrvSupplierUnregister() == rhs.getSrvSupplierUnregister());
        case E_APP_INFO_REGISTER:
            if (_data.appInfoRegister_ == NULL && rhs._data.appInfoRegister_ == NULL) {
                return true;
            }
            return (getAppInfoRegister() == rhs.getAppInfoRegister());
        case E_APP_INFO_STATUS:
            if (_data.appInfoStatus_ == NULL && rhs._data.appInfoStatus_ == NULL) {
                return true;
            }
            return (getAppInfoStatus() == rhs.getAppInfoStatus());
        case E_APP_INFO_UNREGISTER:
            if (_data.appInfoUnregister_ == NULL && rhs._data.appInfoUnregister_ == NULL) {
                return true;
            }
            return (getAppInfoUnregister() == rhs.getAppInfoUnregister());
        default:
            return false;
        }
    }
    return false;
}

inline bool CcaMessageExtension::operator != (const CcaMessageExtension& rhs) const {
    return ! (*this == rhs);
}

inline bool CcaMessageExtension::operator < (const CcaMessageExtension& rhs) const  {
    if (hasPowerMessage() && rhs.hasPowerMessage()) {
        if (getPowerMessage() < rhs.getPowerMessage()) return true;
        if (getPowerMessage() > rhs.getPowerMessage()) return false;
    } else {
        if (hasPowerMessage() && !rhs.hasPowerMessage())
            return true;
        else if (!hasPowerMessage() && rhs.hasPowerMessage())
            return false;
    }

    if (hasServiceRegister() && rhs.hasServiceRegister()) {
        if (getServiceRegister() < rhs.getServiceRegister()) return true;
        if (getServiceRegister() > rhs.getServiceRegister()) return false;
    } else {
        if (hasServiceRegister() && !rhs.hasServiceRegister())
            return true;
        else if (!hasServiceRegister() && rhs.hasServiceRegister())
            return false;
    }

    if (hasServiceUnregister() && rhs.hasServiceUnregister()) {
        if (getServiceUnregister() < rhs.getServiceUnregister()) return true;
        if (getServiceUnregister() > rhs.getServiceUnregister()) return false;
    } else {
        if (hasServiceUnregister() && !rhs.hasServiceUnregister())
            return true;
        else if (!hasServiceUnregister() && rhs.hasServiceUnregister())
            return false;
    }

    if (hasServiceRegisterConfirmation() && rhs.hasServiceRegisterConfirmation()) {
        if (getServiceRegisterConfirmation() < rhs.getServiceRegisterConfirmation()) return true;
        if (getServiceRegisterConfirmation() > rhs.getServiceRegisterConfirmation()) return false;
    } else {
        if (hasServiceRegisterConfirmation() && !rhs.hasServiceRegisterConfirmation())
            return true;
        else if (!hasServiceRegisterConfirmation() && rhs.hasServiceRegisterConfirmation())
            return false;
    }

    if (hasServiceStatus() && rhs.hasServiceStatus()) {
        if (getServiceStatus() < rhs.getServiceStatus()) return true;
        if (getServiceStatus() > rhs.getServiceStatus()) return false;
    } else {
        if (hasServiceStatus() && !rhs.hasServiceStatus())
            return true;
        else if (!hasServiceStatus() && rhs.hasServiceStatus())
            return false;
    }

    if (hasServiceData() && rhs.hasServiceData()) {
        if (getServiceData() < rhs.getServiceData()) return true;
        if (getServiceData() > rhs.getServiceData()) return false;
    } else {
        if (hasServiceData() && !rhs.hasServiceData())
            return true;
        else if (!hasServiceData() && rhs.hasServiceData())
            return false;
    }

    if (hasSrvSupplierRegister() && rhs.hasSrvSupplierRegister()) {
        if (getSrvSupplierRegister() < rhs.getSrvSupplierRegister()) return true;
        if (getSrvSupplierRegister() > rhs.getSrvSupplierRegister()) return false;
    } else {
        if (hasSrvSupplierRegister() && !rhs.hasSrvSupplierRegister())
            return true;
        else if (!hasSrvSupplierRegister() && rhs.hasSrvSupplierRegister())
            return false;
    }

    if (hasSrvSupplierStatus() && rhs.hasSrvSupplierStatus()) {
        if (getSrvSupplierStatus() < rhs.getSrvSupplierStatus()) return true;
        if (getSrvSupplierStatus() > rhs.getSrvSupplierStatus()) return false;
    } else {
        if (hasSrvSupplierStatus() && !rhs.hasSrvSupplierStatus())
            return true;
        else if (!hasSrvSupplierStatus() && rhs.hasSrvSupplierStatus())
            return false;
    }

    if (hasSrvSupplierUnregister() && rhs.hasSrvSupplierUnregister()) {
        if (getSrvSupplierUnregister() < rhs.getSrvSupplierUnregister()) return true;
        if (getSrvSupplierUnregister() > rhs.getSrvSupplierUnregister()) return false;
    } else {
        if (hasSrvSupplierUnregister() && !rhs.hasSrvSupplierUnregister())
            return true;
        else if (!hasSrvSupplierUnregister() && rhs.hasSrvSupplierUnregister())
            return false;
    }

    if (hasAppInfoRegister() && rhs.hasAppInfoRegister()) {
        if (getAppInfoRegister() < rhs.getAppInfoRegister()) return true;
        if (getAppInfoRegister() > rhs.getAppInfoRegister()) return false;
    } else {
        if (hasAppInfoRegister() && !rhs.hasAppInfoRegister())
            return true;
        else if (!hasAppInfoRegister() && rhs.hasAppInfoRegister())
            return false;
    }

    if (hasAppInfoStatus() && rhs.hasAppInfoStatus()) {
        if (getAppInfoStatus() < rhs.getAppInfoStatus()) return true;
        if (getAppInfoStatus() > rhs.getAppInfoStatus()) return false;
    } else {
        if (hasAppInfoStatus() && !rhs.hasAppInfoStatus())
            return true;
        else if (!hasAppInfoStatus() && rhs.hasAppInfoStatus())
            return false;
    }

    if (hasAppInfoUnregister() && rhs.hasAppInfoUnregister()) {
        if (getAppInfoUnregister() < rhs.getAppInfoUnregister()) return true;
        if (getAppInfoUnregister() > rhs.getAppInfoUnregister()) return false;
    } else {
        if (hasAppInfoUnregister() && !rhs.hasAppInfoUnregister())
            return true;
        else if (!hasAppInfoUnregister() && rhs.hasAppInfoUnregister())
            return false;
    }

    return false;
}

inline bool CcaMessageExtension::operator > (const CcaMessageExtension& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline CcaMessageExtension::CcaMessageExtensionField CcaMessageExtension::getField () const {
    return __field;
}

inline void CcaMessageExtension::setField(CcaMessageExtension::CcaMessageExtensionField field) {
    deleteData();
    __field = field;
}

inline bool CcaMessageExtension::hasPowerMessage () const {
    return __field == E_POWER_MESSAGE;
}

inline const PowerMessage& CcaMessageExtension::getPowerMessage() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasPowerMessage(), "Can't provide value for union field '%s' of union '%s', have field %d", "powerMessage", "CcaMessageExtension", getField());
    }
    if (hasPowerMessage()) {
        if (_data.powerMessage_ == NULL) {
            return PowerMessage::getDefaultInstance();
        }
        return *_data.powerMessage_;
    }
    abort();
}

inline PowerMessage& CcaMessageExtension::getPowerMessageMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasPowerMessage(), "Can't provide value for union field '%s' of union '%s', have field %d", "powerMessage", "CcaMessageExtension", getField());
    }
    if (hasPowerMessage()) {
        if (_data.powerMessage_ == NULL) {
            _data.powerMessage_ = new PowerMessage();
            CHECK_ALLOCATION( _data.powerMessage_ );
        }
        return *_data.powerMessage_;
    }
    abort();
}

inline PowerMessage* CcaMessageExtension::releasePowerMessage() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasPowerMessage(), "Can't release value for field 'CcaMessageExtension', have field %d", getField());
    }
    if (hasPowerMessage()) {
        if (_data.powerMessage_ == NULL) {
            _data.powerMessage_ = new PowerMessage();
            CHECK_ALLOCATION( _data.powerMessage_ );
        }
        PowerMessage* temp = _data.powerMessage_;
        _data.powerMessage_ = NULL;
        return temp;
    }
    return 0;
}

inline void CcaMessageExtension::replacePowerMessage (PowerMessage* powerMessage) {
    if (__field != E_POWER_MESSAGE || _data.powerMessage_ != powerMessage) {
        deleteData ();
        __field = E_POWER_MESSAGE;
        _data.powerMessage_ = powerMessage;
    }
}

inline void CcaMessageExtension::setPowerMessage (const PowerMessage& value) {
    if (__field == E_POWER_MESSAGE && _data.powerMessage_ != NULL) {
        *_data.powerMessage_ = value;
    } else {
        deleteData ();
        __field = E_POWER_MESSAGE;
        _data.powerMessage_ = new PowerMessage(value);
    }
}

inline bool CcaMessageExtension::hasServiceRegister () const {
    return __field == E_SERVICE_REGISTER;
}

inline const ServiceRegister& CcaMessageExtension::getServiceRegister() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasServiceRegister(), "Can't provide value for union field '%s' of union '%s', have field %d", "serviceRegister", "CcaMessageExtension", getField());
    }
    if (hasServiceRegister()) {
        if (_data.serviceRegister_ == NULL) {
            return ServiceRegister::getDefaultInstance();
        }
        return *_data.serviceRegister_;
    }
    abort();
}

inline ServiceRegister& CcaMessageExtension::getServiceRegisterMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasServiceRegister(), "Can't provide value for union field '%s' of union '%s', have field %d", "serviceRegister", "CcaMessageExtension", getField());
    }
    if (hasServiceRegister()) {
        if (_data.serviceRegister_ == NULL) {
            _data.serviceRegister_ = new ServiceRegister();
            CHECK_ALLOCATION( _data.serviceRegister_ );
        }
        return *_data.serviceRegister_;
    }
    abort();
}

inline ServiceRegister* CcaMessageExtension::releaseServiceRegister() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasServiceRegister(), "Can't release value for field 'CcaMessageExtension', have field %d", getField());
    }
    if (hasServiceRegister()) {
        if (_data.serviceRegister_ == NULL) {
            _data.serviceRegister_ = new ServiceRegister();
            CHECK_ALLOCATION( _data.serviceRegister_ );
        }
        ServiceRegister* temp = _data.serviceRegister_;
        _data.serviceRegister_ = NULL;
        return temp;
    }
    return 0;
}

inline void CcaMessageExtension::replaceServiceRegister (ServiceRegister* serviceRegister) {
    if (__field != E_SERVICE_REGISTER || _data.serviceRegister_ != serviceRegister) {
        deleteData ();
        __field = E_SERVICE_REGISTER;
        _data.serviceRegister_ = serviceRegister;
    }
}

inline void CcaMessageExtension::setServiceRegister (const ServiceRegister& value) {
    if (__field == E_SERVICE_REGISTER && _data.serviceRegister_ != NULL) {
        *_data.serviceRegister_ = value;
    } else {
        deleteData ();
        __field = E_SERVICE_REGISTER;
        _data.serviceRegister_ = new ServiceRegister(value);
    }
}

inline bool CcaMessageExtension::hasServiceUnregister () const {
    return __field == E_SERVICE_UNREGISTER;
}

inline const ServiceUnregister& CcaMessageExtension::getServiceUnregister() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasServiceUnregister(), "Can't provide value for union field '%s' of union '%s', have field %d", "serviceUnregister", "CcaMessageExtension", getField());
    }
    if (hasServiceUnregister()) {
        if (_data.serviceUnregister_ == NULL) {
            return ServiceUnregister::getDefaultInstance();
        }
        return *_data.serviceUnregister_;
    }
    abort();
}

inline ServiceUnregister& CcaMessageExtension::getServiceUnregisterMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasServiceUnregister(), "Can't provide value for union field '%s' of union '%s', have field %d", "serviceUnregister", "CcaMessageExtension", getField());
    }
    if (hasServiceUnregister()) {
        if (_data.serviceUnregister_ == NULL) {
            _data.serviceUnregister_ = new ServiceUnregister();
            CHECK_ALLOCATION( _data.serviceUnregister_ );
        }
        return *_data.serviceUnregister_;
    }
    abort();
}

inline ServiceUnregister* CcaMessageExtension::releaseServiceUnregister() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasServiceUnregister(), "Can't release value for field 'CcaMessageExtension', have field %d", getField());
    }
    if (hasServiceUnregister()) {
        if (_data.serviceUnregister_ == NULL) {
            _data.serviceUnregister_ = new ServiceUnregister();
            CHECK_ALLOCATION( _data.serviceUnregister_ );
        }
        ServiceUnregister* temp = _data.serviceUnregister_;
        _data.serviceUnregister_ = NULL;
        return temp;
    }
    return 0;
}

inline void CcaMessageExtension::replaceServiceUnregister (ServiceUnregister* serviceUnregister) {
    if (__field != E_SERVICE_UNREGISTER || _data.serviceUnregister_ != serviceUnregister) {
        deleteData ();
        __field = E_SERVICE_UNREGISTER;
        _data.serviceUnregister_ = serviceUnregister;
    }
}

inline void CcaMessageExtension::setServiceUnregister (const ServiceUnregister& value) {
    if (__field == E_SERVICE_UNREGISTER && _data.serviceUnregister_ != NULL) {
        *_data.serviceUnregister_ = value;
    } else {
        deleteData ();
        __field = E_SERVICE_UNREGISTER;
        _data.serviceUnregister_ = new ServiceUnregister(value);
    }
}

inline bool CcaMessageExtension::hasServiceRegisterConfirmation () const {
    return __field == E_SERVICE_REGISTER_CONFIRMATION;
}

inline const ServiceRegisterConfirmation& CcaMessageExtension::getServiceRegisterConfirmation() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasServiceRegisterConfirmation(), "Can't provide value for union field '%s' of union '%s', have field %d", "serviceRegisterConfirmation", "CcaMessageExtension", getField());
    }
    if (hasServiceRegisterConfirmation()) {
        if (_data.serviceRegisterConfirmation_ == NULL) {
            return ServiceRegisterConfirmation::getDefaultInstance();
        }
        return *_data.serviceRegisterConfirmation_;
    }
    abort();
}

inline ServiceRegisterConfirmation& CcaMessageExtension::getServiceRegisterConfirmationMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasServiceRegisterConfirmation(), "Can't provide value for union field '%s' of union '%s', have field %d", "serviceRegisterConfirmation", "CcaMessageExtension", getField());
    }
    if (hasServiceRegisterConfirmation()) {
        if (_data.serviceRegisterConfirmation_ == NULL) {
            _data.serviceRegisterConfirmation_ = new ServiceRegisterConfirmation();
            CHECK_ALLOCATION( _data.serviceRegisterConfirmation_ );
        }
        return *_data.serviceRegisterConfirmation_;
    }
    abort();
}

inline ServiceRegisterConfirmation* CcaMessageExtension::releaseServiceRegisterConfirmation() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasServiceRegisterConfirmation(), "Can't release value for field 'CcaMessageExtension', have field %d", getField());
    }
    if (hasServiceRegisterConfirmation()) {
        if (_data.serviceRegisterConfirmation_ == NULL) {
            _data.serviceRegisterConfirmation_ = new ServiceRegisterConfirmation();
            CHECK_ALLOCATION( _data.serviceRegisterConfirmation_ );
        }
        ServiceRegisterConfirmation* temp = _data.serviceRegisterConfirmation_;
        _data.serviceRegisterConfirmation_ = NULL;
        return temp;
    }
    return 0;
}

inline void CcaMessageExtension::replaceServiceRegisterConfirmation (ServiceRegisterConfirmation* serviceRegisterConfirmation) {
    if (__field != E_SERVICE_REGISTER_CONFIRMATION || _data.serviceRegisterConfirmation_ != serviceRegisterConfirmation) {
        deleteData ();
        __field = E_SERVICE_REGISTER_CONFIRMATION;
        _data.serviceRegisterConfirmation_ = serviceRegisterConfirmation;
    }
}

inline void CcaMessageExtension::setServiceRegisterConfirmation (const ServiceRegisterConfirmation& value) {
    if (__field == E_SERVICE_REGISTER_CONFIRMATION && _data.serviceRegisterConfirmation_ != NULL) {
        *_data.serviceRegisterConfirmation_ = value;
    } else {
        deleteData ();
        __field = E_SERVICE_REGISTER_CONFIRMATION;
        _data.serviceRegisterConfirmation_ = new ServiceRegisterConfirmation(value);
    }
}

inline bool CcaMessageExtension::hasServiceStatus () const {
    return __field == E_SERVICE_STATUS;
}

inline const ServiceStatus& CcaMessageExtension::getServiceStatus() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasServiceStatus(), "Can't provide value for union field '%s' of union '%s', have field %d", "serviceStatus", "CcaMessageExtension", getField());
    }
    if (hasServiceStatus()) {
        if (_data.serviceStatus_ == NULL) {
            return ServiceStatus::getDefaultInstance();
        }
        return *_data.serviceStatus_;
    }
    abort();
}

inline ServiceStatus& CcaMessageExtension::getServiceStatusMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasServiceStatus(), "Can't provide value for union field '%s' of union '%s', have field %d", "serviceStatus", "CcaMessageExtension", getField());
    }
    if (hasServiceStatus()) {
        if (_data.serviceStatus_ == NULL) {
            _data.serviceStatus_ = new ServiceStatus();
            CHECK_ALLOCATION( _data.serviceStatus_ );
        }
        return *_data.serviceStatus_;
    }
    abort();
}

inline ServiceStatus* CcaMessageExtension::releaseServiceStatus() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasServiceStatus(), "Can't release value for field 'CcaMessageExtension', have field %d", getField());
    }
    if (hasServiceStatus()) {
        if (_data.serviceStatus_ == NULL) {
            _data.serviceStatus_ = new ServiceStatus();
            CHECK_ALLOCATION( _data.serviceStatus_ );
        }
        ServiceStatus* temp = _data.serviceStatus_;
        _data.serviceStatus_ = NULL;
        return temp;
    }
    return 0;
}

inline void CcaMessageExtension::replaceServiceStatus (ServiceStatus* serviceStatus) {
    if (__field != E_SERVICE_STATUS || _data.serviceStatus_ != serviceStatus) {
        deleteData ();
        __field = E_SERVICE_STATUS;
        _data.serviceStatus_ = serviceStatus;
    }
}

inline void CcaMessageExtension::setServiceStatus (const ServiceStatus& value) {
    if (__field == E_SERVICE_STATUS && _data.serviceStatus_ != NULL) {
        *_data.serviceStatus_ = value;
    } else {
        deleteData ();
        __field = E_SERVICE_STATUS;
        _data.serviceStatus_ = new ServiceStatus(value);
    }
}

inline bool CcaMessageExtension::hasServiceData () const {
    return __field == E_SERVICE_DATA;
}

inline const ServiceData& CcaMessageExtension::getServiceData() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasServiceData(), "Can't provide value for union field '%s' of union '%s', have field %d", "serviceData", "CcaMessageExtension", getField());
    }
    if (hasServiceData()) {
        if (_data.serviceData_ == NULL) {
            return ServiceData::getDefaultInstance();
        }
        return *_data.serviceData_;
    }
    abort();
}

inline ServiceData& CcaMessageExtension::getServiceDataMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasServiceData(), "Can't provide value for union field '%s' of union '%s', have field %d", "serviceData", "CcaMessageExtension", getField());
    }
    if (hasServiceData()) {
        if (_data.serviceData_ == NULL) {
            _data.serviceData_ = new ServiceData();
            CHECK_ALLOCATION( _data.serviceData_ );
        }
        return *_data.serviceData_;
    }
    abort();
}

inline ServiceData* CcaMessageExtension::releaseServiceData() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasServiceData(), "Can't release value for field 'CcaMessageExtension', have field %d", getField());
    }
    if (hasServiceData()) {
        if (_data.serviceData_ == NULL) {
            _data.serviceData_ = new ServiceData();
            CHECK_ALLOCATION( _data.serviceData_ );
        }
        ServiceData* temp = _data.serviceData_;
        _data.serviceData_ = NULL;
        return temp;
    }
    return 0;
}

inline void CcaMessageExtension::replaceServiceData (ServiceData* serviceData) {
    if (__field != E_SERVICE_DATA || _data.serviceData_ != serviceData) {
        deleteData ();
        __field = E_SERVICE_DATA;
        _data.serviceData_ = serviceData;
    }
}

inline void CcaMessageExtension::setServiceData (const ServiceData& value) {
    if (__field == E_SERVICE_DATA && _data.serviceData_ != NULL) {
        *_data.serviceData_ = value;
    } else {
        deleteData ();
        __field = E_SERVICE_DATA;
        _data.serviceData_ = new ServiceData(value);
    }
}

inline bool CcaMessageExtension::hasSrvSupplierRegister () const {
    return __field == E_SRV_SUPPLIER_REGISTER;
}

inline const SrvSupplierRegister& CcaMessageExtension::getSrvSupplierRegister() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSrvSupplierRegister(), "Can't provide value for union field '%s' of union '%s', have field %d", "srvSupplierRegister", "CcaMessageExtension", getField());
    }
    if (hasSrvSupplierRegister()) {
        if (_data.srvSupplierRegister_ == NULL) {
            return SrvSupplierRegister::getDefaultInstance();
        }
        return *_data.srvSupplierRegister_;
    }
    abort();
}

inline SrvSupplierRegister& CcaMessageExtension::getSrvSupplierRegisterMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSrvSupplierRegister(), "Can't provide value for union field '%s' of union '%s', have field %d", "srvSupplierRegister", "CcaMessageExtension", getField());
    }
    if (hasSrvSupplierRegister()) {
        if (_data.srvSupplierRegister_ == NULL) {
            _data.srvSupplierRegister_ = new SrvSupplierRegister();
            CHECK_ALLOCATION( _data.srvSupplierRegister_ );
        }
        return *_data.srvSupplierRegister_;
    }
    abort();
}

inline SrvSupplierRegister* CcaMessageExtension::releaseSrvSupplierRegister() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasSrvSupplierRegister(), "Can't release value for field 'CcaMessageExtension', have field %d", getField());
    }
    if (hasSrvSupplierRegister()) {
        if (_data.srvSupplierRegister_ == NULL) {
            _data.srvSupplierRegister_ = new SrvSupplierRegister();
            CHECK_ALLOCATION( _data.srvSupplierRegister_ );
        }
        SrvSupplierRegister* temp = _data.srvSupplierRegister_;
        _data.srvSupplierRegister_ = NULL;
        return temp;
    }
    return 0;
}

inline void CcaMessageExtension::replaceSrvSupplierRegister (SrvSupplierRegister* srvSupplierRegister) {
    if (__field != E_SRV_SUPPLIER_REGISTER || _data.srvSupplierRegister_ != srvSupplierRegister) {
        deleteData ();
        __field = E_SRV_SUPPLIER_REGISTER;
        _data.srvSupplierRegister_ = srvSupplierRegister;
    }
}

inline void CcaMessageExtension::setSrvSupplierRegister (const SrvSupplierRegister& value) {
    if (__field == E_SRV_SUPPLIER_REGISTER && _data.srvSupplierRegister_ != NULL) {
        *_data.srvSupplierRegister_ = value;
    } else {
        deleteData ();
        __field = E_SRV_SUPPLIER_REGISTER;
        _data.srvSupplierRegister_ = new SrvSupplierRegister(value);
    }
}

inline bool CcaMessageExtension::hasSrvSupplierStatus () const {
    return __field == E_SRV_SUPPLIER_STATUS;
}

inline const SrvSupplierStatus& CcaMessageExtension::getSrvSupplierStatus() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSrvSupplierStatus(), "Can't provide value for union field '%s' of union '%s', have field %d", "srvSupplierStatus", "CcaMessageExtension", getField());
    }
    if (hasSrvSupplierStatus()) {
        if (_data.srvSupplierStatus_ == NULL) {
            return SrvSupplierStatus::getDefaultInstance();
        }
        return *_data.srvSupplierStatus_;
    }
    abort();
}

inline SrvSupplierStatus& CcaMessageExtension::getSrvSupplierStatusMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSrvSupplierStatus(), "Can't provide value for union field '%s' of union '%s', have field %d", "srvSupplierStatus", "CcaMessageExtension", getField());
    }
    if (hasSrvSupplierStatus()) {
        if (_data.srvSupplierStatus_ == NULL) {
            _data.srvSupplierStatus_ = new SrvSupplierStatus();
            CHECK_ALLOCATION( _data.srvSupplierStatus_ );
        }
        return *_data.srvSupplierStatus_;
    }
    abort();
}

inline SrvSupplierStatus* CcaMessageExtension::releaseSrvSupplierStatus() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasSrvSupplierStatus(), "Can't release value for field 'CcaMessageExtension', have field %d", getField());
    }
    if (hasSrvSupplierStatus()) {
        if (_data.srvSupplierStatus_ == NULL) {
            _data.srvSupplierStatus_ = new SrvSupplierStatus();
            CHECK_ALLOCATION( _data.srvSupplierStatus_ );
        }
        SrvSupplierStatus* temp = _data.srvSupplierStatus_;
        _data.srvSupplierStatus_ = NULL;
        return temp;
    }
    return 0;
}

inline void CcaMessageExtension::replaceSrvSupplierStatus (SrvSupplierStatus* srvSupplierStatus) {
    if (__field != E_SRV_SUPPLIER_STATUS || _data.srvSupplierStatus_ != srvSupplierStatus) {
        deleteData ();
        __field = E_SRV_SUPPLIER_STATUS;
        _data.srvSupplierStatus_ = srvSupplierStatus;
    }
}

inline void CcaMessageExtension::setSrvSupplierStatus (const SrvSupplierStatus& value) {
    if (__field == E_SRV_SUPPLIER_STATUS && _data.srvSupplierStatus_ != NULL) {
        *_data.srvSupplierStatus_ = value;
    } else {
        deleteData ();
        __field = E_SRV_SUPPLIER_STATUS;
        _data.srvSupplierStatus_ = new SrvSupplierStatus(value);
    }
}

inline bool CcaMessageExtension::hasSrvSupplierUnregister () const {
    return __field == E_SRV_SUPPLIER_UNREGISTER;
}

inline const SrvSupplierUnregister& CcaMessageExtension::getSrvSupplierUnregister() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSrvSupplierUnregister(), "Can't provide value for union field '%s' of union '%s', have field %d", "srvSupplierUnregister", "CcaMessageExtension", getField());
    }
    if (hasSrvSupplierUnregister()) {
        if (_data.srvSupplierUnregister_ == NULL) {
            return SrvSupplierRegister::getDefaultInstance();
        }
        return *_data.srvSupplierUnregister_;
    }
    abort();
}

inline SrvSupplierUnregister& CcaMessageExtension::getSrvSupplierUnregisterMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSrvSupplierUnregister(), "Can't provide value for union field '%s' of union '%s', have field %d", "srvSupplierUnregister", "CcaMessageExtension", getField());
    }
    if (hasSrvSupplierUnregister()) {
        if (_data.srvSupplierUnregister_ == NULL) {
            _data.srvSupplierUnregister_ = new SrvSupplierUnregister();
            CHECK_ALLOCATION( _data.srvSupplierUnregister_ );
        }
        return *_data.srvSupplierUnregister_;
    }
    abort();
}

inline SrvSupplierUnregister* CcaMessageExtension::releaseSrvSupplierUnregister() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasSrvSupplierUnregister(), "Can't release value for field 'CcaMessageExtension', have field %d", getField());
    }
    if (hasSrvSupplierUnregister()) {
        if (_data.srvSupplierUnregister_ == NULL) {
            _data.srvSupplierUnregister_ = new SrvSupplierUnregister();
            CHECK_ALLOCATION( _data.srvSupplierUnregister_ );
        }
        SrvSupplierUnregister* temp = _data.srvSupplierUnregister_;
        _data.srvSupplierUnregister_ = NULL;
        return temp;
    }
    return 0;
}

inline void CcaMessageExtension::replaceSrvSupplierUnregister (SrvSupplierUnregister* srvSupplierUnregister) {
    if (__field != E_SRV_SUPPLIER_UNREGISTER || _data.srvSupplierUnregister_ != srvSupplierUnregister) {
        deleteData ();
        __field = E_SRV_SUPPLIER_UNREGISTER;
        _data.srvSupplierUnregister_ = srvSupplierUnregister;
    }
}

inline void CcaMessageExtension::setSrvSupplierUnregister (const SrvSupplierUnregister& value) {
    if (__field == E_SRV_SUPPLIER_UNREGISTER && _data.srvSupplierUnregister_ != NULL) {
        *_data.srvSupplierUnregister_ = value;
    } else {
        deleteData ();
        __field = E_SRV_SUPPLIER_UNREGISTER;
        _data.srvSupplierUnregister_ = new SrvSupplierUnregister(value);
    }
}

inline bool CcaMessageExtension::hasAppInfoRegister () const {
    return __field == E_APP_INFO_REGISTER;
}

inline const AppInfoRegister& CcaMessageExtension::getAppInfoRegister() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasAppInfoRegister(), "Can't provide value for union field '%s' of union '%s', have field %d", "appInfoRegister", "CcaMessageExtension", getField());
    }
    if (hasAppInfoRegister()) {
        if (_data.appInfoRegister_ == NULL) {
            return AppInfoRegister::getDefaultInstance();
        }
        return *_data.appInfoRegister_;
    }
    abort();
}

inline AppInfoRegister& CcaMessageExtension::getAppInfoRegisterMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasAppInfoRegister(), "Can't provide value for union field '%s' of union '%s', have field %d", "appInfoRegister", "CcaMessageExtension", getField());
    }
    if (hasAppInfoRegister()) {
        if (_data.appInfoRegister_ == NULL) {
            _data.appInfoRegister_ = new AppInfoRegister();
            CHECK_ALLOCATION( _data.appInfoRegister_ );
        }
        return *_data.appInfoRegister_;
    }
    abort();
}

inline AppInfoRegister* CcaMessageExtension::releaseAppInfoRegister() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasAppInfoRegister(), "Can't release value for field 'CcaMessageExtension', have field %d", getField());
    }
    if (hasAppInfoRegister()) {
        if (_data.appInfoRegister_ == NULL) {
            _data.appInfoRegister_ = new AppInfoRegister();
            CHECK_ALLOCATION( _data.appInfoRegister_ );
        }
        AppInfoRegister* temp = _data.appInfoRegister_;
        _data.appInfoRegister_ = NULL;
        return temp;
    }
    return 0;
}

inline void CcaMessageExtension::replaceAppInfoRegister (AppInfoRegister* appInfoRegister) {
    if (__field != E_APP_INFO_REGISTER || _data.appInfoRegister_ != appInfoRegister) {
        deleteData ();
        __field = E_APP_INFO_REGISTER;
        _data.appInfoRegister_ = appInfoRegister;
    }
}

inline void CcaMessageExtension::setAppInfoRegister (const AppInfoRegister& value) {
    if (__field == E_APP_INFO_REGISTER && _data.appInfoRegister_ != NULL) {
        *_data.appInfoRegister_ = value;
    } else {
        deleteData ();
        __field = E_APP_INFO_REGISTER;
        _data.appInfoRegister_ = new AppInfoRegister(value);
    }
}

inline bool CcaMessageExtension::hasAppInfoStatus () const {
    return __field == E_APP_INFO_STATUS;
}

inline const AppInfoStatus& CcaMessageExtension::getAppInfoStatus() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasAppInfoStatus(), "Can't provide value for union field '%s' of union '%s', have field %d", "appInfoStatus", "CcaMessageExtension", getField());
    }
    if (hasAppInfoStatus()) {
        if (_data.appInfoStatus_ == NULL) {
            return AppInfoStatus::getDefaultInstance();
        }
        return *_data.appInfoStatus_;
    }
    abort();
}

inline AppInfoStatus& CcaMessageExtension::getAppInfoStatusMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasAppInfoStatus(), "Can't provide value for union field '%s' of union '%s', have field %d", "appInfoStatus", "CcaMessageExtension", getField());
    }
    if (hasAppInfoStatus()) {
        if (_data.appInfoStatus_ == NULL) {
            _data.appInfoStatus_ = new AppInfoStatus();
            CHECK_ALLOCATION( _data.appInfoStatus_ );
        }
        return *_data.appInfoStatus_;
    }
    abort();
}

inline AppInfoStatus* CcaMessageExtension::releaseAppInfoStatus() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasAppInfoStatus(), "Can't release value for field 'CcaMessageExtension', have field %d", getField());
    }
    if (hasAppInfoStatus()) {
        if (_data.appInfoStatus_ == NULL) {
            _data.appInfoStatus_ = new AppInfoStatus();
            CHECK_ALLOCATION( _data.appInfoStatus_ );
        }
        AppInfoStatus* temp = _data.appInfoStatus_;
        _data.appInfoStatus_ = NULL;
        return temp;
    }
    return 0;
}

inline void CcaMessageExtension::replaceAppInfoStatus (AppInfoStatus* appInfoStatus) {
    if (__field != E_APP_INFO_STATUS || _data.appInfoStatus_ != appInfoStatus) {
        deleteData ();
        __field = E_APP_INFO_STATUS;
        _data.appInfoStatus_ = appInfoStatus;
    }
}

inline void CcaMessageExtension::setAppInfoStatus (const AppInfoStatus& value) {
    if (__field == E_APP_INFO_STATUS && _data.appInfoStatus_ != NULL) {
        *_data.appInfoStatus_ = value;
    } else {
        deleteData ();
        __field = E_APP_INFO_STATUS;
        _data.appInfoStatus_ = new AppInfoStatus(value);
    }
}

inline bool CcaMessageExtension::hasAppInfoUnregister () const {
    return __field == E_APP_INFO_UNREGISTER;
}

inline const AppInfoUnregister& CcaMessageExtension::getAppInfoUnregister() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasAppInfoUnregister(), "Can't provide value for union field '%s' of union '%s', have field %d", "appInfoUnregister", "CcaMessageExtension", getField());
    }
    if (hasAppInfoUnregister()) {
        if (_data.appInfoUnregister_ == NULL) {
            return AppInfoRegister::getDefaultInstance();
        }
        return *_data.appInfoUnregister_;
    }
    abort();
}

inline AppInfoUnregister& CcaMessageExtension::getAppInfoUnregisterMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasAppInfoUnregister(), "Can't provide value for union field '%s' of union '%s', have field %d", "appInfoUnregister", "CcaMessageExtension", getField());
    }
    if (hasAppInfoUnregister()) {
        if (_data.appInfoUnregister_ == NULL) {
            _data.appInfoUnregister_ = new AppInfoUnregister();
            CHECK_ALLOCATION( _data.appInfoUnregister_ );
        }
        return *_data.appInfoUnregister_;
    }
    abort();
}

inline AppInfoUnregister* CcaMessageExtension::releaseAppInfoUnregister() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasAppInfoUnregister(), "Can't release value for field 'CcaMessageExtension', have field %d", getField());
    }
    if (hasAppInfoUnregister()) {
        if (_data.appInfoUnregister_ == NULL) {
            _data.appInfoUnregister_ = new AppInfoUnregister();
            CHECK_ALLOCATION( _data.appInfoUnregister_ );
        }
        AppInfoUnregister* temp = _data.appInfoUnregister_;
        _data.appInfoUnregister_ = NULL;
        return temp;
    }
    return 0;
}

inline void CcaMessageExtension::replaceAppInfoUnregister (AppInfoUnregister* appInfoUnregister) {
    if (__field != E_APP_INFO_UNREGISTER || _data.appInfoUnregister_ != appInfoUnregister) {
        deleteData ();
        __field = E_APP_INFO_UNREGISTER;
        _data.appInfoUnregister_ = appInfoUnregister;
    }
}

inline void CcaMessageExtension::setAppInfoUnregister (const AppInfoUnregister& value) {
    if (__field == E_APP_INFO_UNREGISTER && _data.appInfoUnregister_ != NULL) {
        *_data.appInfoUnregister_ = value;
    } else {
        deleteData ();
        __field = E_APP_INFO_UNREGISTER;
        _data.appInfoUnregister_ = new AppInfoUnregister(value);
    }
}

inline void CcaMessageExtension::cloneData (const CcaMessageExtension& rhs) {
    switch (rhs.__field) {
    case E_POWER_MESSAGE:
        if (__field == E_POWER_MESSAGE) {
            if (rhs._data.powerMessage_ == NULL)
                deleteData ();
            else {
                if (_data.powerMessage_ != NULL) {
                    *_data.powerMessage_ =  *rhs._data.powerMessage_;
                } else {
                    _data.powerMessage_ = new PowerMessage(*rhs._data.powerMessage_);
                }
            }
        } else {
            if (_data.powerMessage_ != 0) deleteData ();
            if (rhs._data.powerMessage_ != NULL) {
                _data.powerMessage_ = new PowerMessage(*rhs._data.powerMessage_);
            }
        }
        break;
    case E_SERVICE_REGISTER:
        if (__field == E_SERVICE_REGISTER) {
            if (rhs._data.serviceRegister_ == NULL)
                deleteData ();
            else {
                if (_data.serviceRegister_ != NULL) {
                    *_data.serviceRegister_ =  *rhs._data.serviceRegister_;
                } else {
                    _data.serviceRegister_ = new ServiceRegister(*rhs._data.serviceRegister_);
                }
            }
        } else {
            if (_data.serviceRegister_ != 0) deleteData ();
            if (rhs._data.serviceRegister_ != NULL) {
                _data.serviceRegister_ = new ServiceRegister(*rhs._data.serviceRegister_);
            }
        }
        break;
    case E_SERVICE_UNREGISTER:
        if (__field == E_SERVICE_UNREGISTER) {
            if (rhs._data.serviceUnregister_ == NULL)
                deleteData ();
            else {
                if (_data.serviceUnregister_ != NULL) {
                    *_data.serviceUnregister_ =  *rhs._data.serviceUnregister_;
                } else {
                    _data.serviceUnregister_ = new ServiceUnregister(*rhs._data.serviceUnregister_);
                }
            }
        } else {
            if (_data.serviceUnregister_ != 0) deleteData ();
            if (rhs._data.serviceUnregister_ != NULL) {
                _data.serviceUnregister_ = new ServiceUnregister(*rhs._data.serviceUnregister_);
            }
        }
        break;
    case E_SERVICE_REGISTER_CONFIRMATION:
        if (__field == E_SERVICE_REGISTER_CONFIRMATION) {
            if (rhs._data.serviceRegisterConfirmation_ == NULL)
                deleteData ();
            else {
                if (_data.serviceRegisterConfirmation_ != NULL) {
                    *_data.serviceRegisterConfirmation_ =  *rhs._data.serviceRegisterConfirmation_;
                } else {
                    _data.serviceRegisterConfirmation_ = new ServiceRegisterConfirmation(*rhs._data.serviceRegisterConfirmation_);
                }
            }
        } else {
            if (_data.serviceRegisterConfirmation_ != 0) deleteData ();
            if (rhs._data.serviceRegisterConfirmation_ != NULL) {
                _data.serviceRegisterConfirmation_ = new ServiceRegisterConfirmation(*rhs._data.serviceRegisterConfirmation_);
            }
        }
        break;
    case E_SERVICE_STATUS:
        if (__field == E_SERVICE_STATUS) {
            if (rhs._data.serviceStatus_ == NULL)
                deleteData ();
            else {
                if (_data.serviceStatus_ != NULL) {
                    *_data.serviceStatus_ =  *rhs._data.serviceStatus_;
                } else {
                    _data.serviceStatus_ = new ServiceStatus(*rhs._data.serviceStatus_);
                }
            }
        } else {
            if (_data.serviceStatus_ != 0) deleteData ();
            if (rhs._data.serviceStatus_ != NULL) {
                _data.serviceStatus_ = new ServiceStatus(*rhs._data.serviceStatus_);
            }
        }
        break;
    case E_SERVICE_DATA:
        if (__field == E_SERVICE_DATA) {
            if (rhs._data.serviceData_ == NULL)
                deleteData ();
            else {
                if (_data.serviceData_ != NULL) {
                    *_data.serviceData_ =  *rhs._data.serviceData_;
                } else {
                    _data.serviceData_ = new ServiceData(*rhs._data.serviceData_);
                }
            }
        } else {
            if (_data.serviceData_ != 0) deleteData ();
            if (rhs._data.serviceData_ != NULL) {
                _data.serviceData_ = new ServiceData(*rhs._data.serviceData_);
            }
        }
        break;
    case E_SRV_SUPPLIER_REGISTER:
        if (__field == E_SRV_SUPPLIER_REGISTER) {
            if (rhs._data.srvSupplierRegister_ == NULL)
                deleteData ();
            else {
                if (_data.srvSupplierRegister_ != NULL) {
                    *_data.srvSupplierRegister_ =  *rhs._data.srvSupplierRegister_;
                } else {
                    _data.srvSupplierRegister_ = new SrvSupplierRegister(*rhs._data.srvSupplierRegister_);
                }
            }
        } else {
            if (_data.srvSupplierRegister_ != 0) deleteData ();
            if (rhs._data.srvSupplierRegister_ != NULL) {
                _data.srvSupplierRegister_ = new SrvSupplierRegister(*rhs._data.srvSupplierRegister_);
            }
        }
        break;
    case E_SRV_SUPPLIER_STATUS:
        if (__field == E_SRV_SUPPLIER_STATUS) {
            if (rhs._data.srvSupplierStatus_ == NULL)
                deleteData ();
            else {
                if (_data.srvSupplierStatus_ != NULL) {
                    *_data.srvSupplierStatus_ =  *rhs._data.srvSupplierStatus_;
                } else {
                    _data.srvSupplierStatus_ = new SrvSupplierStatus(*rhs._data.srvSupplierStatus_);
                }
            }
        } else {
            if (_data.srvSupplierStatus_ != 0) deleteData ();
            if (rhs._data.srvSupplierStatus_ != NULL) {
                _data.srvSupplierStatus_ = new SrvSupplierStatus(*rhs._data.srvSupplierStatus_);
            }
        }
        break;
    case E_SRV_SUPPLIER_UNREGISTER:
        if (__field == E_SRV_SUPPLIER_UNREGISTER) {
            if (rhs._data.srvSupplierUnregister_ == NULL)
                deleteData ();
            else {
                if (_data.srvSupplierUnregister_ != NULL) {
                    *_data.srvSupplierUnregister_ =  *rhs._data.srvSupplierUnregister_;
                } else {
                    _data.srvSupplierUnregister_ = new SrvSupplierUnregister(*rhs._data.srvSupplierUnregister_);
                }
            }
        } else {
            if (_data.srvSupplierUnregister_ != 0) deleteData ();
            if (rhs._data.srvSupplierUnregister_ != NULL) {
                _data.srvSupplierUnregister_ = new SrvSupplierUnregister(*rhs._data.srvSupplierUnregister_);
            }
        }
        break;
    case E_APP_INFO_REGISTER:
        if (__field == E_APP_INFO_REGISTER) {
            if (rhs._data.appInfoRegister_ == NULL)
                deleteData ();
            else {
                if (_data.appInfoRegister_ != NULL) {
                    *_data.appInfoRegister_ =  *rhs._data.appInfoRegister_;
                } else {
                    _data.appInfoRegister_ = new AppInfoRegister(*rhs._data.appInfoRegister_);
                }
            }
        } else {
            if (_data.appInfoRegister_ != 0) deleteData ();
            if (rhs._data.appInfoRegister_ != NULL) {
                _data.appInfoRegister_ = new AppInfoRegister(*rhs._data.appInfoRegister_);
            }
        }
        break;
    case E_APP_INFO_STATUS:
        if (__field == E_APP_INFO_STATUS) {
            if (rhs._data.appInfoStatus_ == NULL)
                deleteData ();
            else {
                if (_data.appInfoStatus_ != NULL) {
                    *_data.appInfoStatus_ =  *rhs._data.appInfoStatus_;
                } else {
                    _data.appInfoStatus_ = new AppInfoStatus(*rhs._data.appInfoStatus_);
                }
            }
        } else {
            if (_data.appInfoStatus_ != 0) deleteData ();
            if (rhs._data.appInfoStatus_ != NULL) {
                _data.appInfoStatus_ = new AppInfoStatus(*rhs._data.appInfoStatus_);
            }
        }
        break;
    case E_APP_INFO_UNREGISTER:
        if (__field == E_APP_INFO_UNREGISTER) {
            if (rhs._data.appInfoUnregister_ == NULL)
                deleteData ();
            else {
                if (_data.appInfoUnregister_ != NULL) {
                    *_data.appInfoUnregister_ =  *rhs._data.appInfoUnregister_;
                } else {
                    _data.appInfoUnregister_ = new AppInfoUnregister(*rhs._data.appInfoUnregister_);
                }
            }
        } else {
            if (_data.appInfoUnregister_ != 0) deleteData ();
            if (rhs._data.appInfoUnregister_ != NULL) {
                _data.appInfoUnregister_ = new AppInfoUnregister(*rhs._data.appInfoUnregister_);
            }
        }
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void CcaMessageExtension::deleteData () {
    switch (__field) {
    case E_POWER_MESSAGE:
        delete _data.powerMessage_;
        _data.powerMessage_ = NULL;
        break;
    case E_SERVICE_REGISTER:
        delete _data.serviceRegister_;
        _data.serviceRegister_ = NULL;
        break;
    case E_SERVICE_UNREGISTER:
        delete _data.serviceUnregister_;
        _data.serviceUnregister_ = NULL;
        break;
    case E_SERVICE_REGISTER_CONFIRMATION:
        delete _data.serviceRegisterConfirmation_;
        _data.serviceRegisterConfirmation_ = NULL;
        break;
    case E_SERVICE_STATUS:
        delete _data.serviceStatus_;
        _data.serviceStatus_ = NULL;
        break;
    case E_SERVICE_DATA:
        delete _data.serviceData_;
        _data.serviceData_ = NULL;
        break;
    case E_SRV_SUPPLIER_REGISTER:
        delete _data.srvSupplierRegister_;
        _data.srvSupplierRegister_ = NULL;
        break;
    case E_SRV_SUPPLIER_STATUS:
        delete _data.srvSupplierStatus_;
        _data.srvSupplierStatus_ = NULL;
        break;
    case E_SRV_SUPPLIER_UNREGISTER:
        delete _data.srvSupplierUnregister_;
        _data.srvSupplierUnregister_ = NULL;
        break;
    case E_APP_INFO_REGISTER:
        delete _data.appInfoRegister_;
        _data.appInfoRegister_ = NULL;
        break;
    case E_APP_INFO_STATUS:
        delete _data.appInfoStatus_;
        _data.appInfoStatus_ = NULL;
        break;
    case E_APP_INFO_UNREGISTER:
        delete _data.appInfoUnregister_;
        _data.appInfoUnregister_ = NULL;
        break;
    default:
        break;
    }
}

inline  CcaMessageHeader::CcaMessageHeader ()  :
    _sourceAppId (0u),
    _destAppId (0u),
    _size (0u),
    _version (0u),
    _context (0u),
    _sourceSubId (0u),
    _destSubId (0u),
    _timestamp (0u),
    _extension (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CcaMessageHeader::CcaMessageHeader (const CcaMessageHeader &rhs)  :
    _sourceAppId (0u),
    _destAppId (0u),
    _size (0u),
    _version (0u),
    _context (0u),
    _sourceSubId (0u),
    _destSubId (0u),
    _timestamp (0u),
    _extension (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CcaMessageHeader::CcaMessageHeader (uint16 sourceAppId_, uint16 destAppId_, uint32 size_, uint16 version_, uint8 context_, uint16 sourceSubId_, uint16 destSubId_, uint32 timestamp_, const CcaMessageExtension& extension_)  :
    _sourceAppId (sourceAppId_),
    _destAppId (destAppId_),
    _size (size_),
    _version (version_),
    _context (context_),
    _sourceSubId (sourceSubId_),
    _destSubId (destSubId_),
    _timestamp (timestamp_),
    _extension (new CcaMessageExtension(extension_))
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CcaMessageHeader::~CcaMessageHeader() {
    delete _extension;
}

inline CcaMessageHeader& CcaMessageHeader::operator = (const CcaMessageHeader& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSourceAppId()) {
            setSourceAppId(rhs.getSourceAppId());
        } else {
            clearSourceAppId();
        }
        if (rhs.hasDestAppId()) {
            setDestAppId(rhs.getDestAppId());
        } else {
            clearDestAppId();
        }
        if (rhs.hasSize()) {
            setSize(rhs.getSize());
        } else {
            clearSize();
        }
        if (rhs.hasVersion()) {
            setVersion(rhs.getVersion());
        } else {
            clearVersion();
        }
        if (rhs.hasContext()) {
            setContext(rhs.getContext());
        } else {
            clearContext();
        }
        if (rhs.hasSourceSubId()) {
            setSourceSubId(rhs.getSourceSubId());
        } else {
            clearSourceSubId();
        }
        if (rhs.hasDestSubId()) {
            setDestSubId(rhs.getDestSubId());
        } else {
            clearDestSubId();
        }
        if (rhs.hasTimestamp()) {
            setTimestamp(rhs.getTimestamp());
        } else {
            clearTimestamp();
        }
        if (rhs.hasExtension()) {
            setExtension(rhs.getExtension());
        } else {
            clearExtension();
        }
    }
    return *this;
}

inline bool CcaMessageHeader::operator == (const CcaMessageHeader& rhs) const {
    return (((!hasSourceAppId() && !rhs.hasSourceAppId()) || getSourceAppId() == rhs.getSourceAppId()) &&
        ((!hasDestAppId() && !rhs.hasDestAppId()) || getDestAppId() == rhs.getDestAppId()) &&
        ((!hasSize() && !rhs.hasSize()) || getSize() == rhs.getSize()) &&
        ((!hasVersion() && !rhs.hasVersion()) || getVersion() == rhs.getVersion()) &&
        ((!hasContext() && !rhs.hasContext()) || getContext() == rhs.getContext()) &&
        ((!hasSourceSubId() && !rhs.hasSourceSubId()) || getSourceSubId() == rhs.getSourceSubId()) &&
        ((!hasDestSubId() && !rhs.hasDestSubId()) || getDestSubId() == rhs.getDestSubId()) &&
        ((!hasTimestamp() && !rhs.hasTimestamp()) || getTimestamp() == rhs.getTimestamp()) &&
        ((!hasExtension() && !rhs.hasExtension()) || getExtension() == rhs.getExtension()));
}

inline bool CcaMessageHeader::operator != (const CcaMessageHeader& rhs) const {
    return ! (*this == rhs);
}

inline bool CcaMessageHeader::operator < (const CcaMessageHeader& rhs) const {
    if (hasSourceAppId() || rhs.hasSourceAppId()) {
        if (getSourceAppId() < rhs.getSourceAppId()) return true;
        if (getSourceAppId() > rhs.getSourceAppId()) return false;
    }
    if (hasDestAppId() || rhs.hasDestAppId()) {
        if (getDestAppId() < rhs.getDestAppId()) return true;
        if (getDestAppId() > rhs.getDestAppId()) return false;
    }
    if (hasSize() || rhs.hasSize()) {
        if (getSize() < rhs.getSize()) return true;
        if (getSize() > rhs.getSize()) return false;
    }
    if (hasVersion() || rhs.hasVersion()) {
        if (getVersion() < rhs.getVersion()) return true;
        if (getVersion() > rhs.getVersion()) return false;
    }
    if (hasContext() || rhs.hasContext()) {
        if (getContext() < rhs.getContext()) return true;
        if (getContext() > rhs.getContext()) return false;
    }
    if (hasSourceSubId() || rhs.hasSourceSubId()) {
        if (getSourceSubId() < rhs.getSourceSubId()) return true;
        if (getSourceSubId() > rhs.getSourceSubId()) return false;
    }
    if (hasDestSubId() || rhs.hasDestSubId()) {
        if (getDestSubId() < rhs.getDestSubId()) return true;
        if (getDestSubId() > rhs.getDestSubId()) return false;
    }
    if (hasTimestamp() || rhs.hasTimestamp()) {
        if (getTimestamp() < rhs.getTimestamp()) return true;
        if (getTimestamp() > rhs.getTimestamp()) return false;
    }
    if (hasExtension() || rhs.hasExtension()) {
        if (getExtension() < rhs.getExtension()) return true;
        if (getExtension() > rhs.getExtension()) return false;
    }
    return false;
}

inline bool CcaMessageHeader::operator > (const CcaMessageHeader& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CcaMessageHeader::clear() {
    clearSourceAppId();
    clearDestAppId();
    clearSize();
    clearVersion();
    clearContext();
    clearSourceSubId();
    clearDestSubId();
    clearTimestamp();
    clearExtension();
}

inline void CcaMessageHeader::clearSourceAppId() {
    if (hasSourceAppId()) {
         clear_has_sourceAppId();
        _sourceAppId = 0u;
     }
}

inline bool CcaMessageHeader::hasSourceAppId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 CcaMessageHeader::getSourceAppId () const {
    return _sourceAppId;
}

inline void CcaMessageHeader::setSourceAppId (uint16 sourceAppId_) {
    set_has_sourceAppId();
    this->_sourceAppId = sourceAppId_;
}

inline void CcaMessageHeader::clearDestAppId() {
    if (hasDestAppId()) {
         clear_has_destAppId();
        _destAppId = 0u;
     }
}

inline bool CcaMessageHeader::hasDestAppId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 CcaMessageHeader::getDestAppId () const {
    return _destAppId;
}

inline void CcaMessageHeader::setDestAppId (uint16 destAppId_) {
    set_has_destAppId();
    this->_destAppId = destAppId_;
}

inline void CcaMessageHeader::clearSize() {
    if (hasSize()) {
         clear_has_size();
        _size = 0u;
     }
}

inline bool CcaMessageHeader::hasSize () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 CcaMessageHeader::getSize () const {
    return _size;
}

inline void CcaMessageHeader::setSize (uint32 size_) {
    set_has_size();
    this->_size = size_;
}

inline void CcaMessageHeader::clearVersion() {
    if (hasVersion()) {
         clear_has_version();
        _version = 0u;
     }
}

inline bool CcaMessageHeader::hasVersion () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 CcaMessageHeader::getVersion () const {
    return _version;
}

inline void CcaMessageHeader::setVersion (uint16 version_) {
    set_has_version();
    this->_version = version_;
}

inline void CcaMessageHeader::clearContext() {
    if (hasContext()) {
         clear_has_context();
        _context = 0u;
     }
}

inline bool CcaMessageHeader::hasContext () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 CcaMessageHeader::getContext () const {
    return _context;
}

inline void CcaMessageHeader::setContext (uint8 context_) {
    set_has_context();
    this->_context = context_;
}

inline void CcaMessageHeader::clearSourceSubId() {
    if (hasSourceSubId()) {
         clear_has_sourceSubId();
        _sourceSubId = 0u;
     }
}

inline bool CcaMessageHeader::hasSourceSubId () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint16 CcaMessageHeader::getSourceSubId () const {
    return _sourceSubId;
}

inline void CcaMessageHeader::setSourceSubId (uint16 sourceSubId_) {
    set_has_sourceSubId();
    this->_sourceSubId = sourceSubId_;
}

inline void CcaMessageHeader::clearDestSubId() {
    if (hasDestSubId()) {
         clear_has_destSubId();
        _destSubId = 0u;
     }
}

inline bool CcaMessageHeader::hasDestSubId () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint16 CcaMessageHeader::getDestSubId () const {
    return _destSubId;
}

inline void CcaMessageHeader::setDestSubId (uint16 destSubId_) {
    set_has_destSubId();
    this->_destSubId = destSubId_;
}

inline void CcaMessageHeader::clearTimestamp() {
    if (hasTimestamp()) {
         clear_has_timestamp();
        _timestamp = 0u;
     }
}

inline bool CcaMessageHeader::hasTimestamp () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint32 CcaMessageHeader::getTimestamp () const {
    return _timestamp;
}

inline void CcaMessageHeader::setTimestamp (uint32 timestamp_) {
    set_has_timestamp();
    this->_timestamp = timestamp_;
}

inline void CcaMessageHeader::clearExtension() {
    if (hasExtension()) {
         clear_has_extension();
        delete _extension;
        _extension = NULL;
     }
}

inline bool CcaMessageHeader::hasExtension () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const CcaMessageExtension& CcaMessageHeader::getExtension () const {
    if (_extension == NULL) {
        return CcaMessageExtension::getDefaultInstance();
    }
    return *_extension;
}

inline CcaMessageExtension& CcaMessageHeader::getExtensionMutable () {
    set_has_extension();
    if (_extension == NULL) {
        _extension = new CcaMessageExtension ();
        CHECK_ALLOCATION( _extension );
    }
    return *_extension;
}

inline void CcaMessageHeader::setExtension (const CcaMessageExtension& extension_) {
    set_has_extension();
    if (this->_extension == NULL) {
        this->_extension = new CcaMessageExtension (extension_);
        CHECK_ALLOCATION( this->_extension );
    } else {
        *this->_extension = extension_;
    }
}

inline CcaMessageExtension* CcaMessageHeader::releaseExtension() {
    clear_has_extension();
    CcaMessageExtension* temp = _extension;
    this->_extension = NULL;
    return temp;
}

inline void CcaMessageHeader::replaceExtension (CcaMessageExtension* extension_) {
    set_has_extension();
    if (this->_extension != extension_) {
        if (this->_extension != NULL) {
            delete this->_extension;
        }
        this->_extension = extension_;
    }
}

inline void CcaMessageHeader::set_has_sourceAppId () {
    _has_bits_[0] |= 1u << 0;
}

inline void CcaMessageHeader::clear_has_sourceAppId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void CcaMessageHeader::set_has_destAppId () {
    _has_bits_[0] |= 1u << 1;
}

inline void CcaMessageHeader::clear_has_destAppId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void CcaMessageHeader::set_has_size () {
    _has_bits_[0] |= 1u << 2;
}

inline void CcaMessageHeader::clear_has_size () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void CcaMessageHeader::set_has_version () {
    _has_bits_[0] |= 1u << 3;
}

inline void CcaMessageHeader::clear_has_version () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void CcaMessageHeader::set_has_context () {
    _has_bits_[0] |= 1u << 4;
}

inline void CcaMessageHeader::clear_has_context () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void CcaMessageHeader::set_has_sourceSubId () {
    _has_bits_[0] |= 1u << 5;
}

inline void CcaMessageHeader::clear_has_sourceSubId () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void CcaMessageHeader::set_has_destSubId () {
    _has_bits_[0] |= 1u << 6;
}

inline void CcaMessageHeader::clear_has_destSubId () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void CcaMessageHeader::set_has_timestamp () {
    _has_bits_[0] |= 1u << 7;
}

inline void CcaMessageHeader::clear_has_timestamp () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void CcaMessageHeader::set_has_extension () {
    _has_bits_[0] |= 1u << 8;
}

inline void CcaMessageHeader::clear_has_extension () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline  DefaultError::DefaultError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::asf::cca::CcaTypes::CcaErrorCode__Unspecified;
}

inline  DefaultError::DefaultError (const DefaultError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::asf::cca::CcaTypes::CcaErrorCode__Unspecified;
    *this = rhs;
}

inline  DefaultError::~DefaultError() {
    deleteData ();
}

inline DefaultError& DefaultError::operator = (const DefaultError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool DefaultError::operator == (const DefaultError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool DefaultError::operator != (const DefaultError& rhs) const {
    return ! (*this == rhs);
}

inline bool DefaultError::operator < (const DefaultError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if ((uint32)getCcaErrorCode() < (uint32)rhs.getCcaErrorCode()) return true;
        if ((uint32)getCcaErrorCode() > (uint32)rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool DefaultError::operator > (const DefaultError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline DefaultError::DefaultErrorField DefaultError::getField () const {
    return __field;
}

inline void DefaultError::setField(DefaultError::DefaultErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = ::asf::cca::CcaTypes::CcaErrorCode__Unspecified;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* DefaultError::clone() {
    return new DefaultError(*this);
}

inline bool DefaultError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline CcaErrorCode DefaultError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "DefaultError", getField());
    }
    return (CcaErrorCode) _data.ccaErrorCode_;
}

inline void DefaultError::setCcaErrorCode (CcaErrorCode value) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(CcaErrorCode_IsValid(value), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "CcaErrorCode", "ccaErrorCode", "DefaultError");
    }
    if (__field != E_CCA_ERROR_CODE) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
    }
    _data.ccaErrorCode_ = (int32)value;
}

inline bool DefaultError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline SystemErrorCode DefaultError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "DefaultError", getField());
    }
    return (SystemErrorCode) _data.systemErrorCode_;
}

inline void DefaultError::setSystemErrorCode (SystemErrorCode value) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(SystemErrorCode_IsValid(value), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "DefaultError");
    }
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void DefaultError::cloneData (const DefaultError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = rhs._data.ccaErrorCode_;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void DefaultError::deleteData () {
}

inline  DefaultMessage::DefaultMessage () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DefaultMessage::DefaultMessage (const DefaultMessage &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DefaultMessage::~DefaultMessage() {
}

inline DefaultMessage& DefaultMessage::operator = (const DefaultMessage& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool DefaultMessage::operator == (const DefaultMessage& ) const {
    return true;
}

inline bool DefaultMessage::operator != (const DefaultMessage& rhs) const {
    return ! (*this == rhs);
}

inline bool DefaultMessage::operator < (const DefaultMessage& ) const {
    return false;
}

inline ::asf::core::Payload* DefaultMessage::clone() {
    return new DefaultMessage(*this);
}

inline bool DefaultMessage::operator > (const DefaultMessage& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DefaultMessage::clear() {
}

} // namespace CcaTypes
} // namespace cca
} // namespace asf

#endif // ASF_CCA_CCATYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
