/*********************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2019
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 *********************************************************************/

/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 ****************************************************************************/

#ifndef ASF_CCA_CCASERVERHOOK_H
#define ASF_CCA_CCASERVERHOOK_H

#include "asf/core/Blob.h"
#include "asf/core/IncomingOutgoingIF.h"
#include "asf/core/Logger.h"
#include "asf/core/Stub.h"

#include "boost/shared_ptr.hpp"

namespace asf {

namespace core {
class ProvidedPort;
class CommunicationStack;
}  // namespace core

namespace cca {

class CcaStubDelegate;

namespace CcaServerHook {

/**
 * The CcaServerHookStub is the hook to implement the CCA server functionality.
 * It is necessary to derive from this class and implement the pure virtual
 * functions. That's the way to add the functionality to the service.
 */
class CcaServerHookStub : public ::asf::core::Stub {
public:
    /**
     * The derived class has to pass the port name to the CcaServerHookStub. The
     * port name is defined in the "Car Multimedia Component" model.
     */
    CcaServerHookStub();

    virtual ~CcaServerHookStub();

    /**
     * This function will be called if the component receives the client
     * request "ccaMessageRequest". The derived service implementation has to process
     * the request and send the response back. Use the function
     * sendCcaMessage(...) to do that.
     *
     */

    virtual void onCcaMessage(const ::boost::shared_ptr< ::asf::core::Blob >& request) = 0;

    /**
     * Send answer to clients using OSAL Back-channel queue
     */
    virtual void sendCcaMessage(const ::asf::core::Blob& b);

    virtual void sendCcaMessage(const uint8* pu8Data, size_t size);

    void setCommunicationChannel(::asf::core::CommunicationStack* stack,
                                 ::asf::core::ConnectionIFSharedPtr connection) {
        _stack = stack;
        _connection = connection;
    }

private:
    CcaServerHookStub(const CcaServerHookStub&);

    CcaServerHookStub& operator=(const CcaServerHookStub&);

    ::asf::cca::CcaStubDelegate* _ccaStub;

    ::asf::core::ProvidedPort* _provPort;

    ::asf::core::CommunicationStack* _stack;

    ::asf::core::ConnectionIFSharedPtr _connection;

    DECLARE_CLASS_LOGGER();
};

}  // namespace CcaServerHook
}  // namespace cca
}  // namespace asf

#endif  // ASF_CCA_CCASERVERHOOK_H
