/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     CcaProxy.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.kulla@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2012 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/

#ifndef ASF_CCA_CCAPROXY_H
#define ASF_CCA_CCAPROXY_H

#include <boost/shared_ptr.hpp>
#include "asf/cca/CcaTypes.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Proxy.h"

class CcaProxyTest;
class CcaProxyTestOnAvailable;
class CcaMostProxyTest;
class CcaMessageFactoryTest;

namespace asf {
namespace cca {

class CcaProxyDelegate;

class CcaMessage;

class CcaProxyCallback;

/**
 * The CcaProxy class is the base class for representing clients of CCA services
 */
class CcaProxy : public ::asf::core::Proxy {
public:
    /**
     * Set the seed (initial value) of the sourceSubId number range used in CCA proxies.
     *
     * Each CCA proxy gets a unique sourceSubId assigned.
     * By default these ids are starting from 0.
     * With help of the seed the used number range of the sourceSubIds can be influenced.
     * This function can only be called once and must be called before the first CCA
     * proxy of an application is created.
     */
    static void setSourceSubIdSeed(uint16 seed);

    static const uint32 NO_REGISTRATION = 0;

    static const uint32 SERVICE_REGISTER = 1;

    static const uint32 SPM_SERVICE_SUPPLIER = 2;

    virtual void clearAllProperties() = 0;

    uint16 getRequiredMajorVersion() const;

    uint16 getRequiredMinorVersion() const;

    uint16 getHaveMajorVersion() const;

    uint16 getHaveMinorVersion() const;

    uint16 getHavePatchVersion() const;

    uint32 getApplicationId() const;

protected:
    CcaProxy(const std::string& portName,
             uint16 appId,
             uint16 serviceId,
             uint16 majorVersion,
             uint16 minorVersion,
             ::asf::core::ServiceAvailableIF& serviceAvailable,
             ::asf::core::Logger& logger,
             uint32 flags,
             bool isMost = false);

    virtual ~CcaProxy();

    virtual ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback(
        uint16 fid,
        ::asf::cca::CcaTypes::ServiceData::OpCode opCode,
        uint16 commandCounter,
        void* cb) = 0;

    boost::shared_ptr< ::asf::cca::CcaProxyDelegate > _ccaProxyDelegate;

private:
    CcaProxy(const CcaProxy&);

    CcaProxy& operator=(const CcaProxy&);

    ::asf::core::Logger& _logger;

    friend class ::asf::cca::CcaProxyDelegate;
    friend class ::CcaProxyTest;
    friend class ::CcaProxyTestOnAvailable;
    friend class ::CcaMostProxyTest;
    friend class ::CcaMessageFactoryTest;
};
}  // namespace cca
}  // namespace asf

#endif
