/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef VIDEOMANAGER_MAINFITYPES_HEADER
#define VIDEOMANAGER_MAINFITYPES_HEADER


class videomanager_mainfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for videomanager_main_fi message types

fi_tclMessageBase* videomanager_mainfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class videomanager_mainfi_tclMsgBaseMessage : public videomanager_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   videomanager_mainfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class videomanager_mainfi_tclMsgRequestVideoSourceStateMethodStart : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgRequestVideoSourceStateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   videomanager_mainfi_tclMsgRequestVideoSourceStateMethodStart& operator=(const videomanager_mainfi_tclMsgRequestVideoSourceStateMethodStart& coRef);
   videomanager_mainfi_tclMsgRequestVideoSourceStateMethodStart(const videomanager_mainfi_tclMsgRequestVideoSourceStateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   videomanager_fi_tcl_e8_vdmVideoSource tVideoSource;
   videomanager_fi_tcl_e8_vdmRequestedSourceState tRequestedState;
   virtual ~videomanager_mainfi_tclMsgRequestVideoSourceStateMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const videomanager_mainfi_tclMsgRequestVideoSourceStateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgRequestVideoSourceStateMethodResult : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgRequestVideoSourceStateMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   videomanager_mainfi_tclMsgRequestVideoSourceStateMethodResult& operator=(const videomanager_mainfi_tclMsgRequestVideoSourceStateMethodResult& coRef);
   videomanager_mainfi_tclMsgRequestVideoSourceStateMethodResult(const videomanager_mainfi_tclMsgRequestVideoSourceStateMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bSourceChangeGranted;
   virtual ~videomanager_mainfi_tclMsgRequestVideoSourceStateMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const videomanager_mainfi_tclMsgRequestVideoSourceStateMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgRequestVideoSourceStateMethodAbort : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgRequestVideoSourceStateMethodAbort();

   virtual ~videomanager_mainfi_tclMsgRequestVideoSourceStateMethodAbort();

   inline tBool operator==(const videomanager_mainfi_tclMsgRequestVideoSourceStateMethodAbort& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodStart : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodStart& operator=(const videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodStart& coRef);
   videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodStart(const videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   videomanager_fi_tcl_e8_vdmVideoSource tVideoSource;
   virtual ~videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodResult : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodResult& operator=(const videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodResult& coRef);
   videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodResult(const videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bAccessIsGranted;
   virtual ~videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodAbort : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodAbort();

   virtual ~videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodAbort();

   inline tBool operator==(const videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodAbort& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgAcknowledgeStateMethodStart : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgAcknowledgeStateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   videomanager_mainfi_tclMsgAcknowledgeStateMethodStart& operator=(const videomanager_mainfi_tclMsgAcknowledgeStateMethodStart& coRef);
   videomanager_mainfi_tclMsgAcknowledgeStateMethodStart(const videomanager_mainfi_tclMsgAcknowledgeStateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   videomanager_fi_tcl_e8_vdmVideoSource tVideoSource;
   videomanager_fi_tcl_e8_vdmSourceState tVideoState;
   virtual ~videomanager_mainfi_tclMsgAcknowledgeStateMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const videomanager_mainfi_tclMsgAcknowledgeStateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgAcknowledgeStateMethodResult : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgAcknowledgeStateMethodResult();

   virtual ~videomanager_mainfi_tclMsgAcknowledgeStateMethodResult();

   inline tBool operator==(const videomanager_mainfi_tclMsgAcknowledgeStateMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgAcknowledgeStateMethodAbort : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgAcknowledgeStateMethodAbort();

   virtual ~videomanager_mainfi_tclMsgAcknowledgeStateMethodAbort();

   inline tBool operator==(const videomanager_mainfi_tclMsgAcknowledgeStateMethodAbort& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgRVCAUpReg : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgRVCAUpReg();

   virtual ~videomanager_mainfi_tclMsgRVCAUpReg();

   inline tBool operator==(const videomanager_mainfi_tclMsgRVCAUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgRVCARelUpReg : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgRVCARelUpReg();

   virtual ~videomanager_mainfi_tclMsgRVCARelUpReg();

   inline tBool operator==(const videomanager_mainfi_tclMsgRVCARelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgRVCAGet : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgRVCAGet();

   virtual ~videomanager_mainfi_tclMsgRVCAGet();

   inline tBool operator==(const videomanager_mainfi_tclMsgRVCAGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgRVCASet : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgRVCASet();

   virtual ~videomanager_mainfi_tclMsgRVCASet();

   inline tBool operator==(const videomanager_mainfi_tclMsgRVCASet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgRVCAStatus : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgRVCAStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   videomanager_mainfi_tclMsgRVCAStatus& operator=(const videomanager_mainfi_tclMsgRVCAStatus& coRef);
   videomanager_mainfi_tclMsgRVCAStatus(const videomanager_mainfi_tclMsgRVCAStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   videomanager_fi_tcl_e8_vdmSourceState RVCA_StateInfo;
   virtual ~videomanager_mainfi_tclMsgRVCAStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const videomanager_mainfi_tclMsgRVCAStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgRVCDUpReg : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgRVCDUpReg();

   virtual ~videomanager_mainfi_tclMsgRVCDUpReg();

   inline tBool operator==(const videomanager_mainfi_tclMsgRVCDUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgRVCDRelUpReg : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgRVCDRelUpReg();

   virtual ~videomanager_mainfi_tclMsgRVCDRelUpReg();

   inline tBool operator==(const videomanager_mainfi_tclMsgRVCDRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgRVCDGet : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgRVCDGet();

   virtual ~videomanager_mainfi_tclMsgRVCDGet();

   inline tBool operator==(const videomanager_mainfi_tclMsgRVCDGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgRVCDSet : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgRVCDSet();

   virtual ~videomanager_mainfi_tclMsgRVCDSet();

   inline tBool operator==(const videomanager_mainfi_tclMsgRVCDSet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgRVCDStatus : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgRVCDStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   videomanager_mainfi_tclMsgRVCDStatus& operator=(const videomanager_mainfi_tclMsgRVCDStatus& coRef);
   videomanager_mainfi_tclMsgRVCDStatus(const videomanager_mainfi_tclMsgRVCDStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   videomanager_fi_tcl_e8_vdmSourceState RVCD_StateInfo;
   virtual ~videomanager_mainfi_tclMsgRVCDStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const videomanager_mainfi_tclMsgRVCDStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgDTVUpReg : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgDTVUpReg();

   virtual ~videomanager_mainfi_tclMsgDTVUpReg();

   inline tBool operator==(const videomanager_mainfi_tclMsgDTVUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgDTVRelUpReg : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgDTVRelUpReg();

   virtual ~videomanager_mainfi_tclMsgDTVRelUpReg();

   inline tBool operator==(const videomanager_mainfi_tclMsgDTVRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgDTVGet : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgDTVGet();

   virtual ~videomanager_mainfi_tclMsgDTVGet();

   inline tBool operator==(const videomanager_mainfi_tclMsgDTVGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgDTVSet : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgDTVSet();

   virtual ~videomanager_mainfi_tclMsgDTVSet();

   inline tBool operator==(const videomanager_mainfi_tclMsgDTVSet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgDTVStatus : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgDTVStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   videomanager_mainfi_tclMsgDTVStatus& operator=(const videomanager_mainfi_tclMsgDTVStatus& coRef);
   videomanager_mainfi_tclMsgDTVStatus(const videomanager_mainfi_tclMsgDTVStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   videomanager_fi_tcl_e8_vdmSourceState DTV_StateInfo;
   virtual ~videomanager_mainfi_tclMsgDTVStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const videomanager_mainfi_tclMsgDTVStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgSPCXUpReg : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgSPCXUpReg();

   virtual ~videomanager_mainfi_tclMsgSPCXUpReg();

   inline tBool operator==(const videomanager_mainfi_tclMsgSPCXUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgSPCXRelUpReg : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgSPCXRelUpReg();

   virtual ~videomanager_mainfi_tclMsgSPCXRelUpReg();

   inline tBool operator==(const videomanager_mainfi_tclMsgSPCXRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgSPCXGet : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgSPCXGet();

   virtual ~videomanager_mainfi_tclMsgSPCXGet();

   inline tBool operator==(const videomanager_mainfi_tclMsgSPCXGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgSPCXSet : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgSPCXSet();

   virtual ~videomanager_mainfi_tclMsgSPCXSet();

   inline tBool operator==(const videomanager_mainfi_tclMsgSPCXSet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgSPCXStatus : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgSPCXStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   videomanager_mainfi_tclMsgSPCXStatus& operator=(const videomanager_mainfi_tclMsgSPCXStatus& coRef);
   videomanager_mainfi_tclMsgSPCXStatus(const videomanager_mainfi_tclMsgSPCXStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   videomanager_fi_tcl_e8_vdmSourceState SPCX_StateInfo;
   virtual ~videomanager_mainfi_tclMsgSPCXStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const videomanager_mainfi_tclMsgSPCXStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgDVDUpReg : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgDVDUpReg();

   virtual ~videomanager_mainfi_tclMsgDVDUpReg();

   inline tBool operator==(const videomanager_mainfi_tclMsgDVDUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgDVDRelUpReg : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgDVDRelUpReg();

   virtual ~videomanager_mainfi_tclMsgDVDRelUpReg();

   inline tBool operator==(const videomanager_mainfi_tclMsgDVDRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgDVDGet : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgDVDGet();

   virtual ~videomanager_mainfi_tclMsgDVDGet();

   inline tBool operator==(const videomanager_mainfi_tclMsgDVDGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgDVDSet : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgDVDSet();

   virtual ~videomanager_mainfi_tclMsgDVDSet();

   inline tBool operator==(const videomanager_mainfi_tclMsgDVDSet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgDVDStatus : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgDVDStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   videomanager_mainfi_tclMsgDVDStatus& operator=(const videomanager_mainfi_tclMsgDVDStatus& coRef);
   videomanager_mainfi_tclMsgDVDStatus(const videomanager_mainfi_tclMsgDVDStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   videomanager_fi_tcl_e8_vdmSourceState DVD_StateInfo;
   virtual ~videomanager_mainfi_tclMsgDVDStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const videomanager_mainfi_tclMsgDVDStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgUSBUpReg : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgUSBUpReg();

   virtual ~videomanager_mainfi_tclMsgUSBUpReg();

   inline tBool operator==(const videomanager_mainfi_tclMsgUSBUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgUSBRelUpReg : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgUSBRelUpReg();

   virtual ~videomanager_mainfi_tclMsgUSBRelUpReg();

   inline tBool operator==(const videomanager_mainfi_tclMsgUSBRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgUSBGet : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgUSBGet();

   virtual ~videomanager_mainfi_tclMsgUSBGet();

   inline tBool operator==(const videomanager_mainfi_tclMsgUSBGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgUSBSet : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgUSBSet();

   virtual ~videomanager_mainfi_tclMsgUSBSet();

   inline tBool operator==(const videomanager_mainfi_tclMsgUSBSet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgUSBStatus : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgUSBStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   videomanager_mainfi_tclMsgUSBStatus& operator=(const videomanager_mainfi_tclMsgUSBStatus& coRef);
   videomanager_mainfi_tclMsgUSBStatus(const videomanager_mainfi_tclMsgUSBStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   videomanager_fi_tcl_e8_vdmSourceState USB_StateInfo;
   virtual ~videomanager_mainfi_tclMsgUSBStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const videomanager_mainfi_tclMsgUSBStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgDeserializerUsedByUpReg : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgDeserializerUsedByUpReg();

   virtual ~videomanager_mainfi_tclMsgDeserializerUsedByUpReg();

   inline tBool operator==(const videomanager_mainfi_tclMsgDeserializerUsedByUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgDeserializerUsedByRelUpReg : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgDeserializerUsedByRelUpReg();

   virtual ~videomanager_mainfi_tclMsgDeserializerUsedByRelUpReg();

   inline tBool operator==(const videomanager_mainfi_tclMsgDeserializerUsedByRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgDeserializerUsedByGet : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgDeserializerUsedByGet();

   virtual ~videomanager_mainfi_tclMsgDeserializerUsedByGet();

   inline tBool operator==(const videomanager_mainfi_tclMsgDeserializerUsedByGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgDeserializerUsedBySet : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgDeserializerUsedBySet();

   virtual ~videomanager_mainfi_tclMsgDeserializerUsedBySet();

   inline tBool operator==(const videomanager_mainfi_tclMsgDeserializerUsedBySet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class videomanager_mainfi_tclMsgDeserializerUsedByStatus : public videomanager_mainfi_tclMsgBaseMessage
{
public:

   videomanager_mainfi_tclMsgDeserializerUsedByStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   videomanager_mainfi_tclMsgDeserializerUsedByStatus& operator=(const videomanager_mainfi_tclMsgDeserializerUsedByStatus& coRef);
   videomanager_mainfi_tclMsgDeserializerUsedByStatus(const videomanager_mainfi_tclMsgDeserializerUsedByStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   videomanager_fi_tcl_e8_vdmVideoSource Deserializer_SourceInfo;
   virtual ~videomanager_mainfi_tclMsgDeserializerUsedByStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const videomanager_mainfi_tclMsgDeserializerUsedByStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
