/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define VIDEOMANAGER_FI_S_IMPORT_INTERFACE_VIDEOMANAGER_MAINFI_TYPES
#define VIDEOMANAGER_FI_S_IMPORT_INTERFACE_VIDEOMANAGER_MAINFI_FUNCTIONIDS
#define VIDEOMANAGER_FI_S_IMPORT_INTERFACE_VIDEOMANAGER_MAINFI_SERVICEINFO
#include "videomanager_fi_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for videomanager_main_fi message types

fi_tclMessageBase* videomanager_mainfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case videomanager_mainfi_tclToken::EN_MSG_REQUESTVIDEOSOURCESTATEMETHODSTART:
         return OSAL_NEW videomanager_mainfi_tclMsgRequestVideoSourceStateMethodStart;

      case videomanager_mainfi_tclToken::EN_MSG_REQUESTVIDEOSOURCESTATEMETHODRESULT:
         return OSAL_NEW videomanager_mainfi_tclMsgRequestVideoSourceStateMethodResult;

      case videomanager_mainfi_tclToken::EN_MSG_REQUESTVIDEOSOURCESTATEMETHODABORT:
         return OSAL_NEW videomanager_mainfi_tclMsgRequestVideoSourceStateMethodAbort;

      case videomanager_mainfi_tclToken::EN_MSG_REQUESTACCESSTODESERIALIZERMETHODSTART:
         return OSAL_NEW videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodStart;

      case videomanager_mainfi_tclToken::EN_MSG_REQUESTACCESSTODESERIALIZERMETHODRESULT:
         return OSAL_NEW videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodResult;

      case videomanager_mainfi_tclToken::EN_MSG_REQUESTACCESSTODESERIALIZERMETHODABORT:
         return OSAL_NEW videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodAbort;

      case videomanager_mainfi_tclToken::EN_MSG_ACKNOWLEDGESTATEMETHODSTART:
         return OSAL_NEW videomanager_mainfi_tclMsgAcknowledgeStateMethodStart;

      case videomanager_mainfi_tclToken::EN_MSG_ACKNOWLEDGESTATEMETHODRESULT:
         return OSAL_NEW videomanager_mainfi_tclMsgAcknowledgeStateMethodResult;

      case videomanager_mainfi_tclToken::EN_MSG_ACKNOWLEDGESTATEMETHODABORT:
         return OSAL_NEW videomanager_mainfi_tclMsgAcknowledgeStateMethodAbort;

      case videomanager_mainfi_tclToken::EN_MSG_RVCAUPREG:
         return OSAL_NEW videomanager_mainfi_tclMsgRVCAUpReg;

      case videomanager_mainfi_tclToken::EN_MSG_RVCARELUPREG:
         return OSAL_NEW videomanager_mainfi_tclMsgRVCARelUpReg;

      case videomanager_mainfi_tclToken::EN_MSG_RVCAGET:
         return OSAL_NEW videomanager_mainfi_tclMsgRVCAGet;

      case videomanager_mainfi_tclToken::EN_MSG_RVCASET:
         return OSAL_NEW videomanager_mainfi_tclMsgRVCASet;

      case videomanager_mainfi_tclToken::EN_MSG_RVCASTATUS:
         return OSAL_NEW videomanager_mainfi_tclMsgRVCAStatus;

      case videomanager_mainfi_tclToken::EN_MSG_RVCDUPREG:
         return OSAL_NEW videomanager_mainfi_tclMsgRVCDUpReg;

      case videomanager_mainfi_tclToken::EN_MSG_RVCDRELUPREG:
         return OSAL_NEW videomanager_mainfi_tclMsgRVCDRelUpReg;

      case videomanager_mainfi_tclToken::EN_MSG_RVCDGET:
         return OSAL_NEW videomanager_mainfi_tclMsgRVCDGet;

      case videomanager_mainfi_tclToken::EN_MSG_RVCDSET:
         return OSAL_NEW videomanager_mainfi_tclMsgRVCDSet;

      case videomanager_mainfi_tclToken::EN_MSG_RVCDSTATUS:
         return OSAL_NEW videomanager_mainfi_tclMsgRVCDStatus;

      case videomanager_mainfi_tclToken::EN_MSG_DTVUPREG:
         return OSAL_NEW videomanager_mainfi_tclMsgDTVUpReg;

      case videomanager_mainfi_tclToken::EN_MSG_DTVRELUPREG:
         return OSAL_NEW videomanager_mainfi_tclMsgDTVRelUpReg;

      case videomanager_mainfi_tclToken::EN_MSG_DTVGET:
         return OSAL_NEW videomanager_mainfi_tclMsgDTVGet;

      case videomanager_mainfi_tclToken::EN_MSG_DTVSET:
         return OSAL_NEW videomanager_mainfi_tclMsgDTVSet;

      case videomanager_mainfi_tclToken::EN_MSG_DTVSTATUS:
         return OSAL_NEW videomanager_mainfi_tclMsgDTVStatus;

      case videomanager_mainfi_tclToken::EN_MSG_SPCXUPREG:
         return OSAL_NEW videomanager_mainfi_tclMsgSPCXUpReg;

      case videomanager_mainfi_tclToken::EN_MSG_SPCXRELUPREG:
         return OSAL_NEW videomanager_mainfi_tclMsgSPCXRelUpReg;

      case videomanager_mainfi_tclToken::EN_MSG_SPCXGET:
         return OSAL_NEW videomanager_mainfi_tclMsgSPCXGet;

      case videomanager_mainfi_tclToken::EN_MSG_SPCXSET:
         return OSAL_NEW videomanager_mainfi_tclMsgSPCXSet;

      case videomanager_mainfi_tclToken::EN_MSG_SPCXSTATUS:
         return OSAL_NEW videomanager_mainfi_tclMsgSPCXStatus;

      case videomanager_mainfi_tclToken::EN_MSG_DVDUPREG:
         return OSAL_NEW videomanager_mainfi_tclMsgDVDUpReg;

      case videomanager_mainfi_tclToken::EN_MSG_DVDRELUPREG:
         return OSAL_NEW videomanager_mainfi_tclMsgDVDRelUpReg;

      case videomanager_mainfi_tclToken::EN_MSG_DVDGET:
         return OSAL_NEW videomanager_mainfi_tclMsgDVDGet;

      case videomanager_mainfi_tclToken::EN_MSG_DVDSET:
         return OSAL_NEW videomanager_mainfi_tclMsgDVDSet;

      case videomanager_mainfi_tclToken::EN_MSG_DVDSTATUS:
         return OSAL_NEW videomanager_mainfi_tclMsgDVDStatus;

      case videomanager_mainfi_tclToken::EN_MSG_USBUPREG:
         return OSAL_NEW videomanager_mainfi_tclMsgUSBUpReg;

      case videomanager_mainfi_tclToken::EN_MSG_USBRELUPREG:
         return OSAL_NEW videomanager_mainfi_tclMsgUSBRelUpReg;

      case videomanager_mainfi_tclToken::EN_MSG_USBGET:
         return OSAL_NEW videomanager_mainfi_tclMsgUSBGet;

      case videomanager_mainfi_tclToken::EN_MSG_USBSET:
         return OSAL_NEW videomanager_mainfi_tclMsgUSBSet;

      case videomanager_mainfi_tclToken::EN_MSG_USBSTATUS:
         return OSAL_NEW videomanager_mainfi_tclMsgUSBStatus;

      case videomanager_mainfi_tclToken::EN_MSG_DESERIALIZERUSEDBYUPREG:
         return OSAL_NEW videomanager_mainfi_tclMsgDeserializerUsedByUpReg;

      case videomanager_mainfi_tclToken::EN_MSG_DESERIALIZERUSEDBYRELUPREG:
         return OSAL_NEW videomanager_mainfi_tclMsgDeserializerUsedByRelUpReg;

      case videomanager_mainfi_tclToken::EN_MSG_DESERIALIZERUSEDBYGET:
         return OSAL_NEW videomanager_mainfi_tclMsgDeserializerUsedByGet;

      case videomanager_mainfi_tclToken::EN_MSG_DESERIALIZERUSEDBYSET:
         return OSAL_NEW videomanager_mainfi_tclMsgDeserializerUsedBySet;

      case videomanager_mainfi_tclToken::EN_MSG_DESERIALIZERUSEDBYSTATUS:
         return OSAL_NEW videomanager_mainfi_tclMsgDeserializerUsedByStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all videomanager_mainfifi messages

// common functions

tU16 videomanager_mainfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return VIDEOMANAGER_MAINFI_C_U16_SERVICE_ID;
}

tU16 videomanager_mainfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 videomanager_mainfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& videomanager_mainfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& videomanager_mainfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 videomanager_mainfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& videomanager_mainfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& videomanager_mainfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
videomanager_mainfi_tclMsgRequestVideoSourceStateMethodStart::videomanager_mainfi_tclMsgRequestVideoSourceStateMethodStart(const videomanager_mainfi_tclMsgRequestVideoSourceStateMethodStart& coRef)
   : videomanager_mainfi_tclMsgBaseMessage(coRef)
{
   tVideoSource = coRef.tVideoSource;
   tRequestedState = coRef.tRequestedState;
}
videomanager_mainfi_tclMsgRequestVideoSourceStateMethodStart& videomanager_mainfi_tclMsgRequestVideoSourceStateMethodStart::operator=(const videomanager_mainfi_tclMsgRequestVideoSourceStateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   tVideoSource = coRef.tVideoSource;
   tRequestedState = coRef.tRequestedState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

videomanager_mainfi_tclMsgRequestVideoSourceStateMethodStart::videomanager_mainfi_tclMsgRequestVideoSourceStateMethodStart()
:tVideoSource()
,tRequestedState()
 {}

tS32 videomanager_mainfi_tclMsgRequestVideoSourceStateMethodStart::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_REQUESTVIDEOSOURCESTATEMETHODSTART;
}


videomanager_mainfi_tclMsgRequestVideoSourceStateMethodStart::~videomanager_mainfi_tclMsgRequestVideoSourceStateMethodStart()
{}

tU32 videomanager_mainfi_tclMsgRequestVideoSourceStateMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& videomanager_mainfi_tclMsgRequestVideoSourceStateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tVideoSource);
   (tVoid) (oIn >> tRequestedState);
   return oIn;
}

fi_tclOutContext& videomanager_mainfi_tclMsgRequestVideoSourceStateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tVideoSource);
   (tVoid) (oOut << tRequestedState);
   return oOut;
}

tBool videomanager_mainfi_tclMsgRequestVideoSourceStateMethodStart::operator==(const videomanager_mainfi_tclMsgRequestVideoSourceStateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tVideoSource == roRef.tVideoSource);
   bResult = bResult && (tRequestedState == roRef.tRequestedState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
videomanager_mainfi_tclMsgRequestVideoSourceStateMethodResult::videomanager_mainfi_tclMsgRequestVideoSourceStateMethodResult(const videomanager_mainfi_tclMsgRequestVideoSourceStateMethodResult& coRef)
   : videomanager_mainfi_tclMsgBaseMessage(coRef)
{
   bSourceChangeGranted = coRef.bSourceChangeGranted;
}
videomanager_mainfi_tclMsgRequestVideoSourceStateMethodResult& videomanager_mainfi_tclMsgRequestVideoSourceStateMethodResult::operator=(const videomanager_mainfi_tclMsgRequestVideoSourceStateMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bSourceChangeGranted = coRef.bSourceChangeGranted;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

videomanager_mainfi_tclMsgRequestVideoSourceStateMethodResult::videomanager_mainfi_tclMsgRequestVideoSourceStateMethodResult()
:bSourceChangeGranted(0)
 {}

tS32 videomanager_mainfi_tclMsgRequestVideoSourceStateMethodResult::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_REQUESTVIDEOSOURCESTATEMETHODRESULT;
}


videomanager_mainfi_tclMsgRequestVideoSourceStateMethodResult::~videomanager_mainfi_tclMsgRequestVideoSourceStateMethodResult()
{}

tU32 videomanager_mainfi_tclMsgRequestVideoSourceStateMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& videomanager_mainfi_tclMsgRequestVideoSourceStateMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bSourceChangeGranted);
   return oIn;
}

fi_tclOutContext& videomanager_mainfi_tclMsgRequestVideoSourceStateMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bSourceChangeGranted);
   return oOut;
}

tBool videomanager_mainfi_tclMsgRequestVideoSourceStateMethodResult::operator==(const videomanager_mainfi_tclMsgRequestVideoSourceStateMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bSourceChangeGranted == roRef.bSourceChangeGranted);
   return bResult;
}

//=============================================================================

videomanager_mainfi_tclMsgRequestVideoSourceStateMethodAbort::videomanager_mainfi_tclMsgRequestVideoSourceStateMethodAbort()
 {}

tS32 videomanager_mainfi_tclMsgRequestVideoSourceStateMethodAbort::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_REQUESTVIDEOSOURCESTATEMETHODABORT;
}


videomanager_mainfi_tclMsgRequestVideoSourceStateMethodAbort::~videomanager_mainfi_tclMsgRequestVideoSourceStateMethodAbort()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodStart::videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodStart(const videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodStart& coRef)
   : videomanager_mainfi_tclMsgBaseMessage(coRef)
{
   tVideoSource = coRef.tVideoSource;
}
videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodStart& videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodStart::operator=(const videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodStart& coRef)
{
   if (this == &coRef) return *this;
   tVideoSource = coRef.tVideoSource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodStart::videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodStart()
:tVideoSource()
 {}

tS32 videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodStart::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_REQUESTACCESSTODESERIALIZERMETHODSTART;
}


videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodStart::~videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodStart()
{}

tU32 videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tVideoSource);
   return oIn;
}

fi_tclOutContext& videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tVideoSource);
   return oOut;
}

tBool videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodStart::operator==(const videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tVideoSource == roRef.tVideoSource);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodResult::videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodResult(const videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodResult& coRef)
   : videomanager_mainfi_tclMsgBaseMessage(coRef)
{
   bAccessIsGranted = coRef.bAccessIsGranted;
}
videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodResult& videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodResult::operator=(const videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bAccessIsGranted = coRef.bAccessIsGranted;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodResult::videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodResult()
:bAccessIsGranted(0)
 {}

tS32 videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodResult::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_REQUESTACCESSTODESERIALIZERMETHODRESULT;
}


videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodResult::~videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodResult()
{}

tU32 videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bAccessIsGranted);
   return oIn;
}

fi_tclOutContext& videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bAccessIsGranted);
   return oOut;
}

tBool videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodResult::operator==(const videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bAccessIsGranted == roRef.bAccessIsGranted);
   return bResult;
}

//=============================================================================

videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodAbort::videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodAbort()
 {}

tS32 videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodAbort::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_REQUESTACCESSTODESERIALIZERMETHODABORT;
}


videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodAbort::~videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodAbort()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
videomanager_mainfi_tclMsgAcknowledgeStateMethodStart::videomanager_mainfi_tclMsgAcknowledgeStateMethodStart(const videomanager_mainfi_tclMsgAcknowledgeStateMethodStart& coRef)
   : videomanager_mainfi_tclMsgBaseMessage(coRef)
{
   tVideoSource = coRef.tVideoSource;
   tVideoState = coRef.tVideoState;
}
videomanager_mainfi_tclMsgAcknowledgeStateMethodStart& videomanager_mainfi_tclMsgAcknowledgeStateMethodStart::operator=(const videomanager_mainfi_tclMsgAcknowledgeStateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   tVideoSource = coRef.tVideoSource;
   tVideoState = coRef.tVideoState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

videomanager_mainfi_tclMsgAcknowledgeStateMethodStart::videomanager_mainfi_tclMsgAcknowledgeStateMethodStart()
:tVideoSource()
,tVideoState()
 {}

tS32 videomanager_mainfi_tclMsgAcknowledgeStateMethodStart::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_ACKNOWLEDGESTATEMETHODSTART;
}


videomanager_mainfi_tclMsgAcknowledgeStateMethodStart::~videomanager_mainfi_tclMsgAcknowledgeStateMethodStart()
{}

tU32 videomanager_mainfi_tclMsgAcknowledgeStateMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& videomanager_mainfi_tclMsgAcknowledgeStateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tVideoSource);
   (tVoid) (oIn >> tVideoState);
   return oIn;
}

fi_tclOutContext& videomanager_mainfi_tclMsgAcknowledgeStateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tVideoSource);
   (tVoid) (oOut << tVideoState);
   return oOut;
}

tBool videomanager_mainfi_tclMsgAcknowledgeStateMethodStart::operator==(const videomanager_mainfi_tclMsgAcknowledgeStateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tVideoSource == roRef.tVideoSource);
   bResult = bResult && (tVideoState == roRef.tVideoState);
   return bResult;
}

//=============================================================================

videomanager_mainfi_tclMsgAcknowledgeStateMethodResult::videomanager_mainfi_tclMsgAcknowledgeStateMethodResult()
 {}

tS32 videomanager_mainfi_tclMsgAcknowledgeStateMethodResult::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_ACKNOWLEDGESTATEMETHODRESULT;
}


videomanager_mainfi_tclMsgAcknowledgeStateMethodResult::~videomanager_mainfi_tclMsgAcknowledgeStateMethodResult()
{}

//=============================================================================

videomanager_mainfi_tclMsgAcknowledgeStateMethodAbort::videomanager_mainfi_tclMsgAcknowledgeStateMethodAbort()
 {}

tS32 videomanager_mainfi_tclMsgAcknowledgeStateMethodAbort::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_ACKNOWLEDGESTATEMETHODABORT;
}


videomanager_mainfi_tclMsgAcknowledgeStateMethodAbort::~videomanager_mainfi_tclMsgAcknowledgeStateMethodAbort()
{}

//=============================================================================

videomanager_mainfi_tclMsgRVCAUpReg::videomanager_mainfi_tclMsgRVCAUpReg()
 {}

tS32 videomanager_mainfi_tclMsgRVCAUpReg::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_RVCAUPREG;
}


videomanager_mainfi_tclMsgRVCAUpReg::~videomanager_mainfi_tclMsgRVCAUpReg()
{}

//=============================================================================

videomanager_mainfi_tclMsgRVCARelUpReg::videomanager_mainfi_tclMsgRVCARelUpReg()
 {}

tS32 videomanager_mainfi_tclMsgRVCARelUpReg::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_RVCARELUPREG;
}


videomanager_mainfi_tclMsgRVCARelUpReg::~videomanager_mainfi_tclMsgRVCARelUpReg()
{}

//=============================================================================

videomanager_mainfi_tclMsgRVCAGet::videomanager_mainfi_tclMsgRVCAGet()
 {}

tS32 videomanager_mainfi_tclMsgRVCAGet::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_RVCAGET;
}


videomanager_mainfi_tclMsgRVCAGet::~videomanager_mainfi_tclMsgRVCAGet()
{}

//=============================================================================

videomanager_mainfi_tclMsgRVCASet::videomanager_mainfi_tclMsgRVCASet()
 {}

tS32 videomanager_mainfi_tclMsgRVCASet::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_RVCASET;
}


videomanager_mainfi_tclMsgRVCASet::~videomanager_mainfi_tclMsgRVCASet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
videomanager_mainfi_tclMsgRVCAStatus::videomanager_mainfi_tclMsgRVCAStatus(const videomanager_mainfi_tclMsgRVCAStatus& coRef)
   : videomanager_mainfi_tclMsgBaseMessage(coRef)
{
   RVCA_StateInfo = coRef.RVCA_StateInfo;
}
videomanager_mainfi_tclMsgRVCAStatus& videomanager_mainfi_tclMsgRVCAStatus::operator=(const videomanager_mainfi_tclMsgRVCAStatus& coRef)
{
   if (this == &coRef) return *this;
   RVCA_StateInfo = coRef.RVCA_StateInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

videomanager_mainfi_tclMsgRVCAStatus::videomanager_mainfi_tclMsgRVCAStatus()
:RVCA_StateInfo()
 {}

tS32 videomanager_mainfi_tclMsgRVCAStatus::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_RVCASTATUS;
}


videomanager_mainfi_tclMsgRVCAStatus::~videomanager_mainfi_tclMsgRVCAStatus()
{}

tU32 videomanager_mainfi_tclMsgRVCAStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& videomanager_mainfi_tclMsgRVCAStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RVCA_StateInfo);
   return oIn;
}

fi_tclOutContext& videomanager_mainfi_tclMsgRVCAStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RVCA_StateInfo);
   return oOut;
}

tBool videomanager_mainfi_tclMsgRVCAStatus::operator==(const videomanager_mainfi_tclMsgRVCAStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RVCA_StateInfo == roRef.RVCA_StateInfo);
   return bResult;
}

//=============================================================================

videomanager_mainfi_tclMsgRVCDUpReg::videomanager_mainfi_tclMsgRVCDUpReg()
 {}

tS32 videomanager_mainfi_tclMsgRVCDUpReg::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_RVCDUPREG;
}


videomanager_mainfi_tclMsgRVCDUpReg::~videomanager_mainfi_tclMsgRVCDUpReg()
{}

//=============================================================================

videomanager_mainfi_tclMsgRVCDRelUpReg::videomanager_mainfi_tclMsgRVCDRelUpReg()
 {}

tS32 videomanager_mainfi_tclMsgRVCDRelUpReg::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_RVCDRELUPREG;
}


videomanager_mainfi_tclMsgRVCDRelUpReg::~videomanager_mainfi_tclMsgRVCDRelUpReg()
{}

//=============================================================================

videomanager_mainfi_tclMsgRVCDGet::videomanager_mainfi_tclMsgRVCDGet()
 {}

tS32 videomanager_mainfi_tclMsgRVCDGet::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_RVCDGET;
}


videomanager_mainfi_tclMsgRVCDGet::~videomanager_mainfi_tclMsgRVCDGet()
{}

//=============================================================================

videomanager_mainfi_tclMsgRVCDSet::videomanager_mainfi_tclMsgRVCDSet()
 {}

tS32 videomanager_mainfi_tclMsgRVCDSet::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_RVCDSET;
}


videomanager_mainfi_tclMsgRVCDSet::~videomanager_mainfi_tclMsgRVCDSet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
videomanager_mainfi_tclMsgRVCDStatus::videomanager_mainfi_tclMsgRVCDStatus(const videomanager_mainfi_tclMsgRVCDStatus& coRef)
   : videomanager_mainfi_tclMsgBaseMessage(coRef)
{
   RVCD_StateInfo = coRef.RVCD_StateInfo;
}
videomanager_mainfi_tclMsgRVCDStatus& videomanager_mainfi_tclMsgRVCDStatus::operator=(const videomanager_mainfi_tclMsgRVCDStatus& coRef)
{
   if (this == &coRef) return *this;
   RVCD_StateInfo = coRef.RVCD_StateInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

videomanager_mainfi_tclMsgRVCDStatus::videomanager_mainfi_tclMsgRVCDStatus()
:RVCD_StateInfo()
 {}

tS32 videomanager_mainfi_tclMsgRVCDStatus::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_RVCDSTATUS;
}


videomanager_mainfi_tclMsgRVCDStatus::~videomanager_mainfi_tclMsgRVCDStatus()
{}

tU32 videomanager_mainfi_tclMsgRVCDStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& videomanager_mainfi_tclMsgRVCDStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RVCD_StateInfo);
   return oIn;
}

fi_tclOutContext& videomanager_mainfi_tclMsgRVCDStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RVCD_StateInfo);
   return oOut;
}

tBool videomanager_mainfi_tclMsgRVCDStatus::operator==(const videomanager_mainfi_tclMsgRVCDStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RVCD_StateInfo == roRef.RVCD_StateInfo);
   return bResult;
}

//=============================================================================

videomanager_mainfi_tclMsgDTVUpReg::videomanager_mainfi_tclMsgDTVUpReg()
 {}

tS32 videomanager_mainfi_tclMsgDTVUpReg::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_DTVUPREG;
}


videomanager_mainfi_tclMsgDTVUpReg::~videomanager_mainfi_tclMsgDTVUpReg()
{}

//=============================================================================

videomanager_mainfi_tclMsgDTVRelUpReg::videomanager_mainfi_tclMsgDTVRelUpReg()
 {}

tS32 videomanager_mainfi_tclMsgDTVRelUpReg::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_DTVRELUPREG;
}


videomanager_mainfi_tclMsgDTVRelUpReg::~videomanager_mainfi_tclMsgDTVRelUpReg()
{}

//=============================================================================

videomanager_mainfi_tclMsgDTVGet::videomanager_mainfi_tclMsgDTVGet()
 {}

tS32 videomanager_mainfi_tclMsgDTVGet::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_DTVGET;
}


videomanager_mainfi_tclMsgDTVGet::~videomanager_mainfi_tclMsgDTVGet()
{}

//=============================================================================

videomanager_mainfi_tclMsgDTVSet::videomanager_mainfi_tclMsgDTVSet()
 {}

tS32 videomanager_mainfi_tclMsgDTVSet::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_DTVSET;
}


videomanager_mainfi_tclMsgDTVSet::~videomanager_mainfi_tclMsgDTVSet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
videomanager_mainfi_tclMsgDTVStatus::videomanager_mainfi_tclMsgDTVStatus(const videomanager_mainfi_tclMsgDTVStatus& coRef)
   : videomanager_mainfi_tclMsgBaseMessage(coRef)
{
   DTV_StateInfo = coRef.DTV_StateInfo;
}
videomanager_mainfi_tclMsgDTVStatus& videomanager_mainfi_tclMsgDTVStatus::operator=(const videomanager_mainfi_tclMsgDTVStatus& coRef)
{
   if (this == &coRef) return *this;
   DTV_StateInfo = coRef.DTV_StateInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

videomanager_mainfi_tclMsgDTVStatus::videomanager_mainfi_tclMsgDTVStatus()
:DTV_StateInfo()
 {}

tS32 videomanager_mainfi_tclMsgDTVStatus::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_DTVSTATUS;
}


videomanager_mainfi_tclMsgDTVStatus::~videomanager_mainfi_tclMsgDTVStatus()
{}

tU32 videomanager_mainfi_tclMsgDTVStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& videomanager_mainfi_tclMsgDTVStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DTV_StateInfo);
   return oIn;
}

fi_tclOutContext& videomanager_mainfi_tclMsgDTVStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DTV_StateInfo);
   return oOut;
}

tBool videomanager_mainfi_tclMsgDTVStatus::operator==(const videomanager_mainfi_tclMsgDTVStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DTV_StateInfo == roRef.DTV_StateInfo);
   return bResult;
}

//=============================================================================

videomanager_mainfi_tclMsgSPCXUpReg::videomanager_mainfi_tclMsgSPCXUpReg()
 {}

tS32 videomanager_mainfi_tclMsgSPCXUpReg::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_SPCXUPREG;
}


videomanager_mainfi_tclMsgSPCXUpReg::~videomanager_mainfi_tclMsgSPCXUpReg()
{}

//=============================================================================

videomanager_mainfi_tclMsgSPCXRelUpReg::videomanager_mainfi_tclMsgSPCXRelUpReg()
 {}

tS32 videomanager_mainfi_tclMsgSPCXRelUpReg::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_SPCXRELUPREG;
}


videomanager_mainfi_tclMsgSPCXRelUpReg::~videomanager_mainfi_tclMsgSPCXRelUpReg()
{}

//=============================================================================

videomanager_mainfi_tclMsgSPCXGet::videomanager_mainfi_tclMsgSPCXGet()
 {}

tS32 videomanager_mainfi_tclMsgSPCXGet::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_SPCXGET;
}


videomanager_mainfi_tclMsgSPCXGet::~videomanager_mainfi_tclMsgSPCXGet()
{}

//=============================================================================

videomanager_mainfi_tclMsgSPCXSet::videomanager_mainfi_tclMsgSPCXSet()
 {}

tS32 videomanager_mainfi_tclMsgSPCXSet::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_SPCXSET;
}


videomanager_mainfi_tclMsgSPCXSet::~videomanager_mainfi_tclMsgSPCXSet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
videomanager_mainfi_tclMsgSPCXStatus::videomanager_mainfi_tclMsgSPCXStatus(const videomanager_mainfi_tclMsgSPCXStatus& coRef)
   : videomanager_mainfi_tclMsgBaseMessage(coRef)
{
   SPCX_StateInfo = coRef.SPCX_StateInfo;
}
videomanager_mainfi_tclMsgSPCXStatus& videomanager_mainfi_tclMsgSPCXStatus::operator=(const videomanager_mainfi_tclMsgSPCXStatus& coRef)
{
   if (this == &coRef) return *this;
   SPCX_StateInfo = coRef.SPCX_StateInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

videomanager_mainfi_tclMsgSPCXStatus::videomanager_mainfi_tclMsgSPCXStatus()
:SPCX_StateInfo()
 {}

tS32 videomanager_mainfi_tclMsgSPCXStatus::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_SPCXSTATUS;
}


videomanager_mainfi_tclMsgSPCXStatus::~videomanager_mainfi_tclMsgSPCXStatus()
{}

tU32 videomanager_mainfi_tclMsgSPCXStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& videomanager_mainfi_tclMsgSPCXStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SPCX_StateInfo);
   return oIn;
}

fi_tclOutContext& videomanager_mainfi_tclMsgSPCXStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SPCX_StateInfo);
   return oOut;
}

tBool videomanager_mainfi_tclMsgSPCXStatus::operator==(const videomanager_mainfi_tclMsgSPCXStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SPCX_StateInfo == roRef.SPCX_StateInfo);
   return bResult;
}

//=============================================================================

videomanager_mainfi_tclMsgDVDUpReg::videomanager_mainfi_tclMsgDVDUpReg()
 {}

tS32 videomanager_mainfi_tclMsgDVDUpReg::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_DVDUPREG;
}


videomanager_mainfi_tclMsgDVDUpReg::~videomanager_mainfi_tclMsgDVDUpReg()
{}

//=============================================================================

videomanager_mainfi_tclMsgDVDRelUpReg::videomanager_mainfi_tclMsgDVDRelUpReg()
 {}

tS32 videomanager_mainfi_tclMsgDVDRelUpReg::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_DVDRELUPREG;
}


videomanager_mainfi_tclMsgDVDRelUpReg::~videomanager_mainfi_tclMsgDVDRelUpReg()
{}

//=============================================================================

videomanager_mainfi_tclMsgDVDGet::videomanager_mainfi_tclMsgDVDGet()
 {}

tS32 videomanager_mainfi_tclMsgDVDGet::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_DVDGET;
}


videomanager_mainfi_tclMsgDVDGet::~videomanager_mainfi_tclMsgDVDGet()
{}

//=============================================================================

videomanager_mainfi_tclMsgDVDSet::videomanager_mainfi_tclMsgDVDSet()
 {}

tS32 videomanager_mainfi_tclMsgDVDSet::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_DVDSET;
}


videomanager_mainfi_tclMsgDVDSet::~videomanager_mainfi_tclMsgDVDSet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
videomanager_mainfi_tclMsgDVDStatus::videomanager_mainfi_tclMsgDVDStatus(const videomanager_mainfi_tclMsgDVDStatus& coRef)
   : videomanager_mainfi_tclMsgBaseMessage(coRef)
{
   DVD_StateInfo = coRef.DVD_StateInfo;
}
videomanager_mainfi_tclMsgDVDStatus& videomanager_mainfi_tclMsgDVDStatus::operator=(const videomanager_mainfi_tclMsgDVDStatus& coRef)
{
   if (this == &coRef) return *this;
   DVD_StateInfo = coRef.DVD_StateInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

videomanager_mainfi_tclMsgDVDStatus::videomanager_mainfi_tclMsgDVDStatus()
:DVD_StateInfo()
 {}

tS32 videomanager_mainfi_tclMsgDVDStatus::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_DVDSTATUS;
}


videomanager_mainfi_tclMsgDVDStatus::~videomanager_mainfi_tclMsgDVDStatus()
{}

tU32 videomanager_mainfi_tclMsgDVDStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& videomanager_mainfi_tclMsgDVDStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DVD_StateInfo);
   return oIn;
}

fi_tclOutContext& videomanager_mainfi_tclMsgDVDStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DVD_StateInfo);
   return oOut;
}

tBool videomanager_mainfi_tclMsgDVDStatus::operator==(const videomanager_mainfi_tclMsgDVDStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DVD_StateInfo == roRef.DVD_StateInfo);
   return bResult;
}

//=============================================================================

videomanager_mainfi_tclMsgUSBUpReg::videomanager_mainfi_tclMsgUSBUpReg()
 {}

tS32 videomanager_mainfi_tclMsgUSBUpReg::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_USBUPREG;
}


videomanager_mainfi_tclMsgUSBUpReg::~videomanager_mainfi_tclMsgUSBUpReg()
{}

//=============================================================================

videomanager_mainfi_tclMsgUSBRelUpReg::videomanager_mainfi_tclMsgUSBRelUpReg()
 {}

tS32 videomanager_mainfi_tclMsgUSBRelUpReg::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_USBRELUPREG;
}


videomanager_mainfi_tclMsgUSBRelUpReg::~videomanager_mainfi_tclMsgUSBRelUpReg()
{}

//=============================================================================

videomanager_mainfi_tclMsgUSBGet::videomanager_mainfi_tclMsgUSBGet()
 {}

tS32 videomanager_mainfi_tclMsgUSBGet::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_USBGET;
}


videomanager_mainfi_tclMsgUSBGet::~videomanager_mainfi_tclMsgUSBGet()
{}

//=============================================================================

videomanager_mainfi_tclMsgUSBSet::videomanager_mainfi_tclMsgUSBSet()
 {}

tS32 videomanager_mainfi_tclMsgUSBSet::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_USBSET;
}


videomanager_mainfi_tclMsgUSBSet::~videomanager_mainfi_tclMsgUSBSet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
videomanager_mainfi_tclMsgUSBStatus::videomanager_mainfi_tclMsgUSBStatus(const videomanager_mainfi_tclMsgUSBStatus& coRef)
   : videomanager_mainfi_tclMsgBaseMessage(coRef)
{
   USB_StateInfo = coRef.USB_StateInfo;
}
videomanager_mainfi_tclMsgUSBStatus& videomanager_mainfi_tclMsgUSBStatus::operator=(const videomanager_mainfi_tclMsgUSBStatus& coRef)
{
   if (this == &coRef) return *this;
   USB_StateInfo = coRef.USB_StateInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

videomanager_mainfi_tclMsgUSBStatus::videomanager_mainfi_tclMsgUSBStatus()
:USB_StateInfo()
 {}

tS32 videomanager_mainfi_tclMsgUSBStatus::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_USBSTATUS;
}


videomanager_mainfi_tclMsgUSBStatus::~videomanager_mainfi_tclMsgUSBStatus()
{}

tU32 videomanager_mainfi_tclMsgUSBStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& videomanager_mainfi_tclMsgUSBStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> USB_StateInfo);
   return oIn;
}

fi_tclOutContext& videomanager_mainfi_tclMsgUSBStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << USB_StateInfo);
   return oOut;
}

tBool videomanager_mainfi_tclMsgUSBStatus::operator==(const videomanager_mainfi_tclMsgUSBStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (USB_StateInfo == roRef.USB_StateInfo);
   return bResult;
}

//=============================================================================

videomanager_mainfi_tclMsgDeserializerUsedByUpReg::videomanager_mainfi_tclMsgDeserializerUsedByUpReg()
 {}

tS32 videomanager_mainfi_tclMsgDeserializerUsedByUpReg::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_DESERIALIZERUSEDBYUPREG;
}


videomanager_mainfi_tclMsgDeserializerUsedByUpReg::~videomanager_mainfi_tclMsgDeserializerUsedByUpReg()
{}

//=============================================================================

videomanager_mainfi_tclMsgDeserializerUsedByRelUpReg::videomanager_mainfi_tclMsgDeserializerUsedByRelUpReg()
 {}

tS32 videomanager_mainfi_tclMsgDeserializerUsedByRelUpReg::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_DESERIALIZERUSEDBYRELUPREG;
}


videomanager_mainfi_tclMsgDeserializerUsedByRelUpReg::~videomanager_mainfi_tclMsgDeserializerUsedByRelUpReg()
{}

//=============================================================================

videomanager_mainfi_tclMsgDeserializerUsedByGet::videomanager_mainfi_tclMsgDeserializerUsedByGet()
 {}

tS32 videomanager_mainfi_tclMsgDeserializerUsedByGet::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_DESERIALIZERUSEDBYGET;
}


videomanager_mainfi_tclMsgDeserializerUsedByGet::~videomanager_mainfi_tclMsgDeserializerUsedByGet()
{}

//=============================================================================

videomanager_mainfi_tclMsgDeserializerUsedBySet::videomanager_mainfi_tclMsgDeserializerUsedBySet()
 {}

tS32 videomanager_mainfi_tclMsgDeserializerUsedBySet::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_DESERIALIZERUSEDBYSET;
}


videomanager_mainfi_tclMsgDeserializerUsedBySet::~videomanager_mainfi_tclMsgDeserializerUsedBySet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
videomanager_mainfi_tclMsgDeserializerUsedByStatus::videomanager_mainfi_tclMsgDeserializerUsedByStatus(const videomanager_mainfi_tclMsgDeserializerUsedByStatus& coRef)
   : videomanager_mainfi_tclMsgBaseMessage(coRef)
{
   Deserializer_SourceInfo = coRef.Deserializer_SourceInfo;
}
videomanager_mainfi_tclMsgDeserializerUsedByStatus& videomanager_mainfi_tclMsgDeserializerUsedByStatus::operator=(const videomanager_mainfi_tclMsgDeserializerUsedByStatus& coRef)
{
   if (this == &coRef) return *this;
   Deserializer_SourceInfo = coRef.Deserializer_SourceInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

videomanager_mainfi_tclMsgDeserializerUsedByStatus::videomanager_mainfi_tclMsgDeserializerUsedByStatus()
:Deserializer_SourceInfo()
 {}

tS32 videomanager_mainfi_tclMsgDeserializerUsedByStatus::s32GetTypeId() const
{
   return (tS32) videomanager_mainfi_tclToken::EN_MSG_DESERIALIZERUSEDBYSTATUS;
}


videomanager_mainfi_tclMsgDeserializerUsedByStatus::~videomanager_mainfi_tclMsgDeserializerUsedByStatus()
{}

tU32 videomanager_mainfi_tclMsgDeserializerUsedByStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& videomanager_mainfi_tclMsgDeserializerUsedByStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Deserializer_SourceInfo);
   return oIn;
}

fi_tclOutContext& videomanager_mainfi_tclMsgDeserializerUsedByStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Deserializer_SourceInfo);
   return oOut;
}

tBool videomanager_mainfi_tclMsgDeserializerUsedByStatus::operator==(const videomanager_mainfi_tclMsgDeserializerUsedByStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Deserializer_SourceInfo == roRef.Deserializer_SourceInfo);
   return bResult;
}

