/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef VEHICLE_MAINFITYPES_HEADER
#define VEHICLE_MAINFITYPES_HEADER


class vehicle_mainfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for VEHICLE_MAIN_FI message types

fi_tclMessageBase* vehicle_mainfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class vehicle_mainfi_tclMsgBaseMessage : public vehicle_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   vehicle_mainfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class vehicle_mainfi_tclMsgSetLanguageMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSetLanguageMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSetLanguageMethodStart& operator=(const vehicle_mainfi_tclMsgSetLanguageMethodStart& coRef);
   vehicle_mainfi_tclMsgSetLanguageMethodStart(const vehicle_mainfi_tclMsgSetLanguageMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   vehicle_fi_tcl_e8_Language_SourceId SourceId;
   vehicle_fi_tcl_e8_Language_Code Language;
   virtual ~vehicle_mainfi_tclMsgSetLanguageMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSetLanguageMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSetLanguageMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSetLanguageMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSetLanguageMethodResult& operator=(const vehicle_mainfi_tclMsgSetLanguageMethodResult& coRef);
   vehicle_mainfi_tclMsgSetLanguageMethodResult(const vehicle_mainfi_tclMsgSetLanguageMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Result;
   virtual ~vehicle_mainfi_tclMsgSetLanguageMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSetLanguageMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodStart& operator=(const vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodStart& coRef);
   vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodStart(const vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   vehicle_fi_tcl_e8_Meter_SyncRequest RequestId;
   virtual ~vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodResult& operator=(const vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodResult& coRef);
   vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodResult(const vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Result;
   virtual ~vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodStart& operator=(const vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodStart& coRef);
   vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodStart(const vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 BTLinkStatus;
   virtual ~vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodResult& operator=(const vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodResult& coRef);
   vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodResult(const vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodStart& operator=(const vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodStart& coRef);
   vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodStart(const vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 PhoneBookSyncStatusValue;
   virtual ~vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodResult& operator=(const vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodResult& coRef);
   vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodResult(const vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCallHistorySyncStatusMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCallHistorySyncStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCallHistorySyncStatusMethodStart& operator=(const vehicle_mainfi_tclMsgCallHistorySyncStatusMethodStart& coRef);
   vehicle_mainfi_tclMsgCallHistorySyncStatusMethodStart(const vehicle_mainfi_tclMsgCallHistorySyncStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 CallHistorySyncStatusValue;
   virtual ~vehicle_mainfi_tclMsgCallHistorySyncStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCallHistorySyncStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCallHistorySyncStatusMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCallHistorySyncStatusMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCallHistorySyncStatusMethodResult& operator=(const vehicle_mainfi_tclMsgCallHistorySyncStatusMethodResult& coRef);
   vehicle_mainfi_tclMsgCallHistorySyncStatusMethodResult(const vehicle_mainfi_tclMsgCallHistorySyncStatusMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgCallHistorySyncStatusMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCallHistorySyncStatusMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgPhoneStatusRoamingMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgPhoneStatusRoamingMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgPhoneStatusRoamingMethodStart& operator=(const vehicle_mainfi_tclMsgPhoneStatusRoamingMethodStart& coRef);
   vehicle_mainfi_tclMsgPhoneStatusRoamingMethodStart(const vehicle_mainfi_tclMsgPhoneStatusRoamingMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 PhoneStatusRoamingValue;
   virtual ~vehicle_mainfi_tclMsgPhoneStatusRoamingMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgPhoneStatusRoamingMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgPhoneStatusRoamingMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgPhoneStatusRoamingMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgPhoneStatusRoamingMethodResult& operator=(const vehicle_mainfi_tclMsgPhoneStatusRoamingMethodResult& coRef);
   vehicle_mainfi_tclMsgPhoneStatusRoamingMethodResult(const vehicle_mainfi_tclMsgPhoneStatusRoamingMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgPhoneStatusRoamingMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgPhoneStatusRoamingMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCallDurationMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCallDurationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCallDurationMethodStart& operator=(const vehicle_mainfi_tclMsgCallDurationMethodStart& coRef);
   vehicle_mainfi_tclMsgCallDurationMethodStart(const vehicle_mainfi_tclMsgCallDurationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 CallDurationValue;
   virtual ~vehicle_mainfi_tclMsgCallDurationMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCallDurationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCallDurationMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCallDurationMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCallDurationMethodResult& operator=(const vehicle_mainfi_tclMsgCallDurationMethodResult& coRef);
   vehicle_mainfi_tclMsgCallDurationMethodResult(const vehicle_mainfi_tclMsgCallDurationMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgCallDurationMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCallDurationMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgGSMSignalStrengthMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgGSMSignalStrengthMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgGSMSignalStrengthMethodStart& operator=(const vehicle_mainfi_tclMsgGSMSignalStrengthMethodStart& coRef);
   vehicle_mainfi_tclMsgGSMSignalStrengthMethodStart(const vehicle_mainfi_tclMsgGSMSignalStrengthMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 GSMSignalStrengthValue;
   virtual ~vehicle_mainfi_tclMsgGSMSignalStrengthMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgGSMSignalStrengthMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgGSMSignalStrengthMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgGSMSignalStrengthMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgGSMSignalStrengthMethodResult& operator=(const vehicle_mainfi_tclMsgGSMSignalStrengthMethodResult& coRef);
   vehicle_mainfi_tclMsgGSMSignalStrengthMethodResult(const vehicle_mainfi_tclMsgGSMSignalStrengthMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgGSMSignalStrengthMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgGSMSignalStrengthMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgPhoneAvailableStatusMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgPhoneAvailableStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgPhoneAvailableStatusMethodStart& operator=(const vehicle_mainfi_tclMsgPhoneAvailableStatusMethodStart& coRef);
   vehicle_mainfi_tclMsgPhoneAvailableStatusMethodStart(const vehicle_mainfi_tclMsgPhoneAvailableStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 PhoneAvailableStatusValue;
   virtual ~vehicle_mainfi_tclMsgPhoneAvailableStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgPhoneAvailableStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgPhoneAvailableStatusMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgPhoneAvailableStatusMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgPhoneAvailableStatusMethodResult& operator=(const vehicle_mainfi_tclMsgPhoneAvailableStatusMethodResult& coRef);
   vehicle_mainfi_tclMsgPhoneAvailableStatusMethodResult(const vehicle_mainfi_tclMsgPhoneAvailableStatusMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgPhoneAvailableStatusMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgPhoneAvailableStatusMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgPhoneCallStatusMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgPhoneCallStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgPhoneCallStatusMethodStart& operator=(const vehicle_mainfi_tclMsgPhoneCallStatusMethodStart& coRef);
   vehicle_mainfi_tclMsgPhoneCallStatusMethodStart(const vehicle_mainfi_tclMsgPhoneCallStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 CallStatusValue;
   virtual ~vehicle_mainfi_tclMsgPhoneCallStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgPhoneCallStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgPhoneCallStatusMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgPhoneCallStatusMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgPhoneCallStatusMethodResult& operator=(const vehicle_mainfi_tclMsgPhoneCallStatusMethodResult& coRef);
   vehicle_mainfi_tclMsgPhoneCallStatusMethodResult(const vehicle_mainfi_tclMsgPhoneCallStatusMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgPhoneCallStatusMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgPhoneCallStatusMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodStart& operator=(const vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodStart& coRef);
   vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodStart(const vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 PhoneBatteryLevelStatusValue;
   virtual ~vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodResult& operator=(const vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodResult& coRef);
   vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodResult(const vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgPhoneVRAvailableMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgPhoneVRAvailableMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgPhoneVRAvailableMethodStart& operator=(const vehicle_mainfi_tclMsgPhoneVRAvailableMethodStart& coRef);
   vehicle_mainfi_tclMsgPhoneVRAvailableMethodStart(const vehicle_mainfi_tclMsgPhoneVRAvailableMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 PhoneVRAvailableValue;
   virtual ~vehicle_mainfi_tclMsgPhoneVRAvailableMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgPhoneVRAvailableMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgPhoneVRAvailableMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgPhoneVRAvailableMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgPhoneVRAvailableMethodResult& operator=(const vehicle_mainfi_tclMsgPhoneVRAvailableMethodResult& coRef);
   vehicle_mainfi_tclMsgPhoneVRAvailableMethodResult(const vehicle_mainfi_tclMsgPhoneVRAvailableMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgPhoneVRAvailableMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgPhoneVRAvailableMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodStart& operator=(const vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodStart& coRef);
   vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodStart(const vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DeviceStatusWifiStatus;
   virtual ~vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodResult& operator=(const vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodResult& coRef);
   vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodResult(const vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodStart& operator=(const vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodStart& coRef);
   vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodStart(const vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DeviceStatusBTStatusValue;
   virtual ~vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodResult& operator=(const vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodResult& coRef);
   vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodResult(const vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodStart& operator=(const vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodStart& coRef);
   vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodStart(const vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DeviceStatusDABAvailStatusValue;
   virtual ~vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodResult& operator=(const vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodResult& coRef);
   vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodResult(const vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodStart& operator=(const vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodStart& coRef);
   vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodStart(const vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DeviceStatusRadioStatusValue;
   virtual ~vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodResult& operator=(const vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodResult& coRef);
   vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodResult(const vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDeviceStatusNavDataMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDeviceStatusNavDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgDeviceStatusNavDataMethodStart& operator=(const vehicle_mainfi_tclMsgDeviceStatusNavDataMethodStart& coRef);
   vehicle_mainfi_tclMsgDeviceStatusNavDataMethodStart(const vehicle_mainfi_tclMsgDeviceStatusNavDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DeviceStatusNavDataValue;
   virtual ~vehicle_mainfi_tclMsgDeviceStatusNavDataMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgDeviceStatusNavDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDeviceStatusNavDataMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDeviceStatusNavDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgDeviceStatusNavDataMethodResult& operator=(const vehicle_mainfi_tclMsgDeviceStatusNavDataMethodResult& coRef);
   vehicle_mainfi_tclMsgDeviceStatusNavDataMethodResult(const vehicle_mainfi_tclMsgDeviceStatusNavDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgDeviceStatusNavDataMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgDeviceStatusNavDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodStart& operator=(const vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodStart& coRef);
   vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodStart(const vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DeviceStatusUSB1PresentValue;
   virtual ~vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodResult& operator=(const vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodResult& coRef);
   vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodResult(const vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodStart& operator=(const vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodStart& coRef);
   vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodStart(const vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DeviceStatusUSB2PresentValue;
   virtual ~vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodResult& operator=(const vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodResult& coRef);
   vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodResult(const vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodStart& operator=(const vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodStart& coRef);
   vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodStart(const vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DeviceStatusNaviAvailValue;
   virtual ~vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodResult& operator=(const vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodResult& coRef);
   vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodResult(const vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodStart& operator=(const vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodStart& coRef);
   vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodStart(const vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DeviceStatusUSB1SrcValue;
   virtual ~vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodResult& operator=(const vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodResult& coRef);
   vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodResult(const vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodStart& operator=(const vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodStart& coRef);
   vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodStart(const vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DeviceStatusUSB2SrcValue;
   virtual ~vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodResult& operator=(const vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodResult& coRef);
   vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodResult(const vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodStart& operator=(const vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodStart& coRef);
   vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodStart(const vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DeviceStatusAMFMAvailValue;
   virtual ~vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodResult& operator=(const vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodResult& coRef);
   vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodResult(const vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodStart& operator=(const vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodStart& coRef);
   vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodStart(const vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DeviceStatusBluetoothAvailValue;
   virtual ~vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodResult& operator=(const vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodResult& coRef);
   vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodResult(const vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgReq_DeviceInfoMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgReq_DeviceInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgReq_DeviceInfoMethodStart& operator=(const vehicle_mainfi_tclMsgReq_DeviceInfoMethodStart& coRef);
   vehicle_mainfi_tclMsgReq_DeviceInfoMethodStart(const vehicle_mainfi_tclMsgReq_DeviceInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Req_DeviceInfoValue;
   virtual ~vehicle_mainfi_tclMsgReq_DeviceInfoMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgReq_DeviceInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgReq_DeviceInfoMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgReq_DeviceInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgReq_DeviceInfoMethodResult& operator=(const vehicle_mainfi_tclMsgReq_DeviceInfoMethodResult& coRef);
   vehicle_mainfi_tclMsgReq_DeviceInfoMethodResult(const vehicle_mainfi_tclMsgReq_DeviceInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgReq_DeviceInfoMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgReq_DeviceInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgHUS_DM1_StatusMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgHUS_DM1_StatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgHUS_DM1_StatusMethodStart& operator=(const vehicle_mainfi_tclMsgHUS_DM1_StatusMethodStart& coRef);
   vehicle_mainfi_tclMsgHUS_DM1_StatusMethodStart(const vehicle_mainfi_tclMsgHUS_DM1_StatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU64 HUS_DM1_StatusValue;
   virtual ~vehicle_mainfi_tclMsgHUS_DM1_StatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgHUS_DM1_StatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgHUS_DM1_StatusMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgHUS_DM1_StatusMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgHUS_DM1_StatusMethodResult& operator=(const vehicle_mainfi_tclMsgHUS_DM1_StatusMethodResult& coRef);
   vehicle_mainfi_tclMsgHUS_DM1_StatusMethodResult(const vehicle_mainfi_tclMsgHUS_DM1_StatusMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgHUS_DM1_StatusMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgHUS_DM1_StatusMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodStart& operator=(const vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodStart& coRef);
   vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodStart(const vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 VehicleNaviLatitudeValue;
   virtual ~vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodResult& operator=(const vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodResult& coRef);
   vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodResult(const vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodStart& operator=(const vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodStart& coRef);
   vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodStart(const vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 VehicleNaviLongitudeValue;
   virtual ~vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodResult& operator=(const vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodResult& coRef);
   vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodResult(const vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodStart& operator=(const vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodStart& coRef);
   vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodStart(const vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 AudioSource;
   virtual ~vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodResult& operator=(const vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodResult& coRef);
   vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodResult(const vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMediaStatusVolumeMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMediaStatusVolumeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMediaStatusVolumeMethodStart& operator=(const vehicle_mainfi_tclMsgMediaStatusVolumeMethodStart& coRef);
   vehicle_mainfi_tclMsgMediaStatusVolumeMethodStart(const vehicle_mainfi_tclMsgMediaStatusVolumeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 volume;
   virtual ~vehicle_mainfi_tclMsgMediaStatusVolumeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMediaStatusVolumeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMediaStatusVolumeMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMediaStatusVolumeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMediaStatusVolumeMethodResult& operator=(const vehicle_mainfi_tclMsgMediaStatusVolumeMethodResult& coRef);
   vehicle_mainfi_tclMsgMediaStatusVolumeMethodResult(const vehicle_mainfi_tclMsgMediaStatusVolumeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgMediaStatusVolumeMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMediaStatusVolumeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodStart& operator=(const vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodStart& coRef);
   vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodStart(const vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 CabinAudioSource;
   virtual ~vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodResult& operator=(const vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodResult& coRef);
   vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodResult(const vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodStart& operator=(const vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodStart& coRef);
   vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodStart(const vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 CabinVolume;
   virtual ~vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodResult& operator=(const vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodResult& coRef);
   vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodResult(const vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodStart& operator=(const vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodStart& coRef);
   vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodStart(const vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 MediaStatusMuteValue;
   virtual ~vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodResult& operator=(const vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodResult& coRef);
   vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodResult(const vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodStart& operator=(const vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodStart& coRef);
   vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodStart(const vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 CabinMediaStatusMuteValue;
   virtual ~vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodResult& operator=(const vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodResult& coRef);
   vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodResult(const vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodStart& operator=(const vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodStart& coRef);
   vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodStart(const vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 MediaStatusPlayStatusValue;
   virtual ~vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodResult& operator=(const vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodResult& coRef);
   vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodResult(const vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodStart& operator=(const vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodStart& coRef);
   vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodStart(const vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 MediaStatusSeekStatusValue;
   virtual ~vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodResult& operator=(const vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodResult& coRef);
   vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodResult(const vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodStart& operator=(const vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodStart& coRef);
   vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodStart(const vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 MediaStatusRepeatStatusValue;
   virtual ~vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodResult& operator=(const vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodResult& coRef);
   vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodResult(const vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodStart& operator=(const vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodStart& coRef);
   vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodStart(const vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 MediaStatusDABFMStatusValue;
   virtual ~vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodResult& operator=(const vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodResult& coRef);
   vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodResult(const vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodStart& operator=(const vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodStart& coRef);
   vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodStart(const vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 MediaStatusTREGStatusValue;
   virtual ~vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodResult& operator=(const vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodResult& coRef);
   vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodResult(const vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodStart& operator=(const vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodStart& coRef);
   vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodStart(const vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 MediaStatusRDSStatusValue;
   virtual ~vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodResult& operator=(const vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodResult& coRef);
   vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodResult(const vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMediaStatusTAStatusMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMediaStatusTAStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMediaStatusTAStatusMethodStart& operator=(const vehicle_mainfi_tclMsgMediaStatusTAStatusMethodStart& coRef);
   vehicle_mainfi_tclMsgMediaStatusTAStatusMethodStart(const vehicle_mainfi_tclMsgMediaStatusTAStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 MediaStatusTAStatusValue;
   virtual ~vehicle_mainfi_tclMsgMediaStatusTAStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMediaStatusTAStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMediaStatusTAStatusMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMediaStatusTAStatusMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMediaStatusTAStatusMethodResult& operator=(const vehicle_mainfi_tclMsgMediaStatusTAStatusMethodResult& coRef);
   vehicle_mainfi_tclMsgMediaStatusTAStatusMethodResult(const vehicle_mainfi_tclMsgMediaStatusTAStatusMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgMediaStatusTAStatusMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMediaStatusTAStatusMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMediaStatusTPStatusMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMediaStatusTPStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMediaStatusTPStatusMethodStart& operator=(const vehicle_mainfi_tclMsgMediaStatusTPStatusMethodStart& coRef);
   vehicle_mainfi_tclMsgMediaStatusTPStatusMethodStart(const vehicle_mainfi_tclMsgMediaStatusTPStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 MediaStatusTPStatusValue;
   virtual ~vehicle_mainfi_tclMsgMediaStatusTPStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMediaStatusTPStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMediaStatusTPStatusMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMediaStatusTPStatusMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMediaStatusTPStatusMethodResult& operator=(const vehicle_mainfi_tclMsgMediaStatusTPStatusMethodResult& coRef);
   vehicle_mainfi_tclMsgMediaStatusTPStatusMethodResult(const vehicle_mainfi_tclMsgMediaStatusTPStatusMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgMediaStatusTPStatusMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMediaStatusTPStatusMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodStart& operator=(const vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodStart& coRef);
   vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodStart(const vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 MediaStatusTunerBandStatusValue;
   virtual ~vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodResult& operator=(const vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodResult& coRef);
   vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodResult(const vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodStart& operator=(const vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodStart& coRef);
   vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodStart(const vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 MediaStatusTunerPresetStatusValue;
   virtual ~vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodResult& operator=(const vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodResult& coRef);
   vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodResult(const vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMediaStatusMixStateMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMediaStatusMixStateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMediaStatusMixStateMethodStart& operator=(const vehicle_mainfi_tclMsgMediaStatusMixStateMethodStart& coRef);
   vehicle_mainfi_tclMsgMediaStatusMixStateMethodStart(const vehicle_mainfi_tclMsgMediaStatusMixStateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 MediaStatusMixStateValue;
   virtual ~vehicle_mainfi_tclMsgMediaStatusMixStateMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMediaStatusMixStateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMediaStatusMixStateMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMediaStatusMixStateMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMediaStatusMixStateMethodResult& operator=(const vehicle_mainfi_tclMsgMediaStatusMixStateMethodResult& coRef);
   vehicle_mainfi_tclMsgMediaStatusMixStateMethodResult(const vehicle_mainfi_tclMsgMediaStatusMixStateMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgMediaStatusMixStateMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMediaStatusMixStateMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodStart& operator=(const vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodStart& coRef);
   vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodStart(const vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 MediaStatusPlaylistModeValue;
   virtual ~vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodResult& operator=(const vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodResult& coRef);
   vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodResult(const vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodStart& operator=(const vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodStart& coRef);
   vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodStart(const vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 MediaStatusTrackTimeValue;
   virtual ~vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodResult& operator=(const vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodResult& coRef);
   vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodResult(const vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodStart& operator=(const vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodStart& coRef);
   vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodStart(const vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 MediaStatusCurrTrackNumValue;
   virtual ~vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodResult& operator=(const vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodResult& coRef);
   vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodResult(const vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodStart& operator=(const vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodStart& coRef);
   vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodStart(const vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 MediaStatusTREGRTMStatusValue;
   virtual ~vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodResult& operator=(const vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodResult& coRef);
   vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodResult(const vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodStart& operator=(const vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodStart& coRef);
   vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodStart(const vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 CabinMediaStatusTunerBandValue;
   virtual ~vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodResult& operator=(const vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodResult& coRef);
   vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodResult(const vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCSMEngineeringDataMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCSMEngineeringDataMethodStart();

   virtual ~vehicle_mainfi_tclMsgCSMEngineeringDataMethodStart();

   inline tBool operator==(const vehicle_mainfi_tclMsgCSMEngineeringDataMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCSMEngineeringDataMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCSMEngineeringDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCSMEngineeringDataMethodResult& operator=(const vehicle_mainfi_tclMsgCSMEngineeringDataMethodResult& coRef);
   vehicle_mainfi_tclMsgCSMEngineeringDataMethodResult(const vehicle_mainfi_tclMsgCSMEngineeringDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<vehicle_fi_tcl_CAN_Message, std::allocator<vehicle_fi_tcl_CAN_Message> > CanMessageList;
   virtual ~vehicle_mainfi_tclMsgCSMEngineeringDataMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCSMEngineeringDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodStart& operator=(const vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodStart& coRef);
   vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodStart(const vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool OSPAlert;
   tBool DangerousAreaAlert;
   virtual ~vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodResult& operator=(const vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodResult& coRef);
   vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodResult(const vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSendMediaInfoMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSendMediaInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSendMediaInfoMethodStart& operator=(const vehicle_mainfi_tclMsgSendMediaInfoMethodStart& coRef);
   vehicle_mainfi_tclMsgSendMediaInfoMethodStart(const vehicle_mainfi_tclMsgSendMediaInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   vehicle_fi_tcl_CAN_Mesg MediaInfo;
   virtual ~vehicle_mainfi_tclMsgSendMediaInfoMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSendMediaInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSendMediaInfoMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSendMediaInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSendMediaInfoMethodResult& operator=(const vehicle_mainfi_tclMsgSendMediaInfoMethodResult& coRef);
   vehicle_mainfi_tclMsgSendMediaInfoMethodResult(const vehicle_mainfi_tclMsgSendMediaInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~vehicle_mainfi_tclMsgSendMediaInfoMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSendMediaInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSendCallInfoMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSendCallInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSendCallInfoMethodStart& operator=(const vehicle_mainfi_tclMsgSendCallInfoMethodStart& coRef);
   vehicle_mainfi_tclMsgSendCallInfoMethodStart(const vehicle_mainfi_tclMsgSendCallInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   vehicle_fi_tcl_CAN_Mesg CallInfo;
   virtual ~vehicle_mainfi_tclMsgSendCallInfoMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSendCallInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSendCallInfoMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSendCallInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSendCallInfoMethodResult& operator=(const vehicle_mainfi_tclMsgSendCallInfoMethodResult& coRef);
   vehicle_mainfi_tclMsgSendCallInfoMethodResult(const vehicle_mainfi_tclMsgSendCallInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~vehicle_mainfi_tclMsgSendCallInfoMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSendCallInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSendPhoneInfoMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSendPhoneInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSendPhoneInfoMethodStart& operator=(const vehicle_mainfi_tclMsgSendPhoneInfoMethodStart& coRef);
   vehicle_mainfi_tclMsgSendPhoneInfoMethodStart(const vehicle_mainfi_tclMsgSendPhoneInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   vehicle_fi_tcl_CAN_Mesg PhoneInfo;
   virtual ~vehicle_mainfi_tclMsgSendPhoneInfoMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSendPhoneInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSendPhoneInfoMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSendPhoneInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSendPhoneInfoMethodResult& operator=(const vehicle_mainfi_tclMsgSendPhoneInfoMethodResult& coRef);
   vehicle_mainfi_tclMsgSendPhoneInfoMethodResult(const vehicle_mainfi_tclMsgSendPhoneInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~vehicle_mainfi_tclMsgSendPhoneInfoMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSendPhoneInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSendXMInfoMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSendXMInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSendXMInfoMethodStart& operator=(const vehicle_mainfi_tclMsgSendXMInfoMethodStart& coRef);
   vehicle_mainfi_tclMsgSendXMInfoMethodStart(const vehicle_mainfi_tclMsgSendXMInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   vehicle_fi_tcl_CAN_Mesg XMInfo;
   virtual ~vehicle_mainfi_tclMsgSendXMInfoMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSendXMInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSendXMInfoMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSendXMInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSendXMInfoMethodResult& operator=(const vehicle_mainfi_tclMsgSendXMInfoMethodResult& coRef);
   vehicle_mainfi_tclMsgSendXMInfoMethodResult(const vehicle_mainfi_tclMsgSendXMInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~vehicle_mainfi_tclMsgSendXMInfoMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSendXMInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSendMainlineInfoMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSendMainlineInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSendMainlineInfoMethodStart& operator=(const vehicle_mainfi_tclMsgSendMainlineInfoMethodStart& coRef);
   vehicle_mainfi_tclMsgSendMainlineInfoMethodStart(const vehicle_mainfi_tclMsgSendMainlineInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   vehicle_fi_tcl_CAN_Mesg MainlineInfo;
   virtual ~vehicle_mainfi_tclMsgSendMainlineInfoMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSendMainlineInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSendMainlineInfoMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSendMainlineInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSendMainlineInfoMethodResult& operator=(const vehicle_mainfi_tclMsgSendMainlineInfoMethodResult& coRef);
   vehicle_mainfi_tclMsgSendMainlineInfoMethodResult(const vehicle_mainfi_tclMsgSendMainlineInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~vehicle_mainfi_tclMsgSendMainlineInfoMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSendMainlineInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodStart& operator=(const vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodStart& coRef);
   vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodStart(const vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   vehicle_fi_tcl_CAN_Mesg CabinAMediaInfo;
   virtual ~vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodResult& operator=(const vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodResult& coRef);
   vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodResult(const vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodStart& operator=(const vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodStart& coRef);
   vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodStart(const vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   vehicle_fi_tcl_CAN_Mesg CabinAMainlineInfo;
   virtual ~vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodResult& operator=(const vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodResult& coRef);
   vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodResult(const vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSendCabinACallInfoMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSendCabinACallInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSendCabinACallInfoMethodStart& operator=(const vehicle_mainfi_tclMsgSendCabinACallInfoMethodStart& coRef);
   vehicle_mainfi_tclMsgSendCabinACallInfoMethodStart(const vehicle_mainfi_tclMsgSendCabinACallInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   vehicle_fi_tcl_CAN_Mesg CabinACallInfo;
   virtual ~vehicle_mainfi_tclMsgSendCabinACallInfoMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSendCabinACallInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSendCabinACallInfoMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSendCabinACallInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSendCabinACallInfoMethodResult& operator=(const vehicle_mainfi_tclMsgSendCabinACallInfoMethodResult& coRef);
   vehicle_mainfi_tclMsgSendCabinACallInfoMethodResult(const vehicle_mainfi_tclMsgSendCabinACallInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~vehicle_mainfi_tclMsgSendCabinACallInfoMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSendCabinACallInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodStart& operator=(const vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodStart& coRef);
   vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodStart(const vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   vehicle_fi_tcl_CAN_Mesg CabinAPhoneInfo;
   virtual ~vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodResult& operator=(const vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodResult& coRef);
   vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodResult(const vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSendCabinAXMInfoMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSendCabinAXMInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSendCabinAXMInfoMethodStart& operator=(const vehicle_mainfi_tclMsgSendCabinAXMInfoMethodStart& coRef);
   vehicle_mainfi_tclMsgSendCabinAXMInfoMethodStart(const vehicle_mainfi_tclMsgSendCabinAXMInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   vehicle_fi_tcl_CAN_Mesg CabinAXMInfo;
   virtual ~vehicle_mainfi_tclMsgSendCabinAXMInfoMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSendCabinAXMInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSendCabinAXMInfoMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSendCabinAXMInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSendCabinAXMInfoMethodResult& operator=(const vehicle_mainfi_tclMsgSendCabinAXMInfoMethodResult& coRef);
   vehicle_mainfi_tclMsgSendCabinAXMInfoMethodResult(const vehicle_mainfi_tclMsgSendCabinAXMInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~vehicle_mainfi_tclMsgSendCabinAXMInfoMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSendCabinAXMInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodStart& operator=(const vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodStart& coRef);
   vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodStart(const vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   vehicle_fi_tcl_CAN_Mesg NaviCurrentStreetNameInfo;
   virtual ~vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodResult& operator=(const vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodResult& coRef);
   vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodResult(const vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodStart& operator=(const vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodStart& coRef);
   vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodStart(const vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   vehicle_fi_tcl_CAN_Mesg NaviTurnToStreetNameInfo;
   virtual ~vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodResult& operator=(const vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodResult& coRef);
   vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodResult(const vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodStart& operator=(const vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodStart& coRef);
   vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodStart(const vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   vehicle_fi_tcl_CAN_Navi_Mesg NaviDestinationInfo;
   virtual ~vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodResult& operator=(const vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodResult& coRef);
   vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodResult(const vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodStart& operator=(const vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodStart& coRef);
   vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodStart(const vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   vehicle_fi_tcl_CAN_Navi_Mesg NaviTurnToSymbolsInfo;
   virtual ~vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodResult& operator=(const vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodResult& coRef);
   vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodResult(const vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodStart& operator=(const vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodStart& coRef);
   vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodStart(const vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   vehicle_fi_tcl_CAN_Navi_Mesg NaviLaneGuidanceInfo;
   virtual ~vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodResult& operator=(const vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodResult& coRef);
   vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodResult(const vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodStart& operator=(const vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodStart& coRef);
   vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodStart(const vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   vehicle_fi_tcl_CAN_Navi_Mesg NaviNavigationWarningInfo;
   virtual ~vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodResult& operator=(const vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodResult& coRef);
   vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodResult(const vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Status;
   virtual ~vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCam1ManActMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCam1ManActMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCam1ManActMethodStart& operator=(const vehicle_mainfi_tclMsgCam1ManActMethodStart& coRef);
   vehicle_mainfi_tclMsgCam1ManActMethodStart(const vehicle_mainfi_tclMsgCam1ManActMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 RequestId;
   virtual ~vehicle_mainfi_tclMsgCam1ManActMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCam1ManActMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCam1ManActMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCam1ManActMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCam1ManActMethodResult& operator=(const vehicle_mainfi_tclMsgCam1ManActMethodResult& coRef);
   vehicle_mainfi_tclMsgCam1ManActMethodResult(const vehicle_mainfi_tclMsgCam1ManActMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgCam1ManActMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCam1ManActMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCam2ManActMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCam2ManActMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCam2ManActMethodStart& operator=(const vehicle_mainfi_tclMsgCam2ManActMethodStart& coRef);
   vehicle_mainfi_tclMsgCam2ManActMethodStart(const vehicle_mainfi_tclMsgCam2ManActMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 RequestId;
   virtual ~vehicle_mainfi_tclMsgCam2ManActMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCam2ManActMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCam2ManActMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCam2ManActMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCam2ManActMethodResult& operator=(const vehicle_mainfi_tclMsgCam2ManActMethodResult& coRef);
   vehicle_mainfi_tclMsgCam2ManActMethodResult(const vehicle_mainfi_tclMsgCam2ManActMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgCam2ManActMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCam2ManActMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCam3ManActMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCam3ManActMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCam3ManActMethodStart& operator=(const vehicle_mainfi_tclMsgCam3ManActMethodStart& coRef);
   vehicle_mainfi_tclMsgCam3ManActMethodStart(const vehicle_mainfi_tclMsgCam3ManActMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 RequestId;
   virtual ~vehicle_mainfi_tclMsgCam3ManActMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCam3ManActMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCam3ManActMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCam3ManActMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCam3ManActMethodResult& operator=(const vehicle_mainfi_tclMsgCam3ManActMethodResult& coRef);
   vehicle_mainfi_tclMsgCam3ManActMethodResult(const vehicle_mainfi_tclMsgCam3ManActMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgCam3ManActMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCam3ManActMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCam4ManActMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCam4ManActMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCam4ManActMethodStart& operator=(const vehicle_mainfi_tclMsgCam4ManActMethodStart& coRef);
   vehicle_mainfi_tclMsgCam4ManActMethodStart(const vehicle_mainfi_tclMsgCam4ManActMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 RequestId;
   virtual ~vehicle_mainfi_tclMsgCam4ManActMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCam4ManActMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCam4ManActMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCam4ManActMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCam4ManActMethodResult& operator=(const vehicle_mainfi_tclMsgCam4ManActMethodResult& coRef);
   vehicle_mainfi_tclMsgCam4ManActMethodResult(const vehicle_mainfi_tclMsgCam4ManActMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgCam4ManActMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCam4ManActMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCam5ManActMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCam5ManActMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCam5ManActMethodStart& operator=(const vehicle_mainfi_tclMsgCam5ManActMethodStart& coRef);
   vehicle_mainfi_tclMsgCam5ManActMethodStart(const vehicle_mainfi_tclMsgCam5ManActMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 RequestId;
   virtual ~vehicle_mainfi_tclMsgCam5ManActMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCam5ManActMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCam5ManActMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCam5ManActMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCam5ManActMethodResult& operator=(const vehicle_mainfi_tclMsgCam5ManActMethodResult& coRef);
   vehicle_mainfi_tclMsgCam5ManActMethodResult(const vehicle_mainfi_tclMsgCam5ManActMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgCam5ManActMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCam5ManActMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCam6ManActMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCam6ManActMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCam6ManActMethodStart& operator=(const vehicle_mainfi_tclMsgCam6ManActMethodStart& coRef);
   vehicle_mainfi_tclMsgCam6ManActMethodStart(const vehicle_mainfi_tclMsgCam6ManActMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 RequestId;
   virtual ~vehicle_mainfi_tclMsgCam6ManActMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCam6ManActMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCam6ManActMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCam6ManActMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCam6ManActMethodResult& operator=(const vehicle_mainfi_tclMsgCam6ManActMethodResult& coRef);
   vehicle_mainfi_tclMsgCam6ManActMethodResult(const vehicle_mainfi_tclMsgCam6ManActMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgCam6ManActMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCam6ManActMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCam7ManActMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCam7ManActMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCam7ManActMethodStart& operator=(const vehicle_mainfi_tclMsgCam7ManActMethodStart& coRef);
   vehicle_mainfi_tclMsgCam7ManActMethodStart(const vehicle_mainfi_tclMsgCam7ManActMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 RequestId;
   virtual ~vehicle_mainfi_tclMsgCam7ManActMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCam7ManActMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCam7ManActMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCam7ManActMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCam7ManActMethodResult& operator=(const vehicle_mainfi_tclMsgCam7ManActMethodResult& coRef);
   vehicle_mainfi_tclMsgCam7ManActMethodResult(const vehicle_mainfi_tclMsgCam7ManActMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgCam7ManActMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCam7ManActMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCam8ManActMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCam8ManActMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCam8ManActMethodStart& operator=(const vehicle_mainfi_tclMsgCam8ManActMethodStart& coRef);
   vehicle_mainfi_tclMsgCam8ManActMethodStart(const vehicle_mainfi_tclMsgCam8ManActMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 RequestId;
   virtual ~vehicle_mainfi_tclMsgCam8ManActMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCam8ManActMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCam8ManActMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCam8ManActMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCam8ManActMethodResult& operator=(const vehicle_mainfi_tclMsgCam8ManActMethodResult& coRef);
   vehicle_mainfi_tclMsgCam8ManActMethodResult(const vehicle_mainfi_tclMsgCam8ManActMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgCam8ManActMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCam8ManActMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCam9ManActMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCam9ManActMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCam9ManActMethodStart& operator=(const vehicle_mainfi_tclMsgCam9ManActMethodStart& coRef);
   vehicle_mainfi_tclMsgCam9ManActMethodStart(const vehicle_mainfi_tclMsgCam9ManActMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 RequestId;
   virtual ~vehicle_mainfi_tclMsgCam9ManActMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCam9ManActMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCam9ManActMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCam9ManActMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCam9ManActMethodResult& operator=(const vehicle_mainfi_tclMsgCam9ManActMethodResult& coRef);
   vehicle_mainfi_tclMsgCam9ManActMethodResult(const vehicle_mainfi_tclMsgCam9ManActMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgCam9ManActMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCam9ManActMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCam10ManActMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCam10ManActMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCam10ManActMethodStart& operator=(const vehicle_mainfi_tclMsgCam10ManActMethodStart& coRef);
   vehicle_mainfi_tclMsgCam10ManActMethodStart(const vehicle_mainfi_tclMsgCam10ManActMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 RequestId;
   virtual ~vehicle_mainfi_tclMsgCam10ManActMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCam10ManActMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCam10ManActMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCam10ManActMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCam10ManActMethodResult& operator=(const vehicle_mainfi_tclMsgCam10ManActMethodResult& coRef);
   vehicle_mainfi_tclMsgCam10ManActMethodResult(const vehicle_mainfi_tclMsgCam10ManActMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgCam10ManActMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCam10ManActMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCam11ManActMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCam11ManActMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCam11ManActMethodStart& operator=(const vehicle_mainfi_tclMsgCam11ManActMethodStart& coRef);
   vehicle_mainfi_tclMsgCam11ManActMethodStart(const vehicle_mainfi_tclMsgCam11ManActMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 RequestId;
   virtual ~vehicle_mainfi_tclMsgCam11ManActMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCam11ManActMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCam11ManActMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCam11ManActMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCam11ManActMethodResult& operator=(const vehicle_mainfi_tclMsgCam11ManActMethodResult& coRef);
   vehicle_mainfi_tclMsgCam11ManActMethodResult(const vehicle_mainfi_tclMsgCam11ManActMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgCam11ManActMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCam11ManActMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCam12ManActMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCam12ManActMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCam12ManActMethodStart& operator=(const vehicle_mainfi_tclMsgCam12ManActMethodStart& coRef);
   vehicle_mainfi_tclMsgCam12ManActMethodStart(const vehicle_mainfi_tclMsgCam12ManActMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 RequestId;
   virtual ~vehicle_mainfi_tclMsgCam12ManActMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCam12ManActMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCam12ManActMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCam12ManActMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCam12ManActMethodResult& operator=(const vehicle_mainfi_tclMsgCam12ManActMethodResult& coRef);
   vehicle_mainfi_tclMsgCam12ManActMethodResult(const vehicle_mainfi_tclMsgCam12ManActMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgCam12ManActMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCam12ManActMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCam13ManActMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCam13ManActMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCam13ManActMethodStart& operator=(const vehicle_mainfi_tclMsgCam13ManActMethodStart& coRef);
   vehicle_mainfi_tclMsgCam13ManActMethodStart(const vehicle_mainfi_tclMsgCam13ManActMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 RequestId;
   virtual ~vehicle_mainfi_tclMsgCam13ManActMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCam13ManActMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCam13ManActMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCam13ManActMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCam13ManActMethodResult& operator=(const vehicle_mainfi_tclMsgCam13ManActMethodResult& coRef);
   vehicle_mainfi_tclMsgCam13ManActMethodResult(const vehicle_mainfi_tclMsgCam13ManActMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgCam13ManActMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCam13ManActMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCam14ManActMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCam14ManActMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCam14ManActMethodStart& operator=(const vehicle_mainfi_tclMsgCam14ManActMethodStart& coRef);
   vehicle_mainfi_tclMsgCam14ManActMethodStart(const vehicle_mainfi_tclMsgCam14ManActMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 RequestId;
   virtual ~vehicle_mainfi_tclMsgCam14ManActMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCam14ManActMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCam14ManActMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCam14ManActMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCam14ManActMethodResult& operator=(const vehicle_mainfi_tclMsgCam14ManActMethodResult& coRef);
   vehicle_mainfi_tclMsgCam14ManActMethodResult(const vehicle_mainfi_tclMsgCam14ManActMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgCam14ManActMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCam14ManActMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCam15ManActMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCam15ManActMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCam15ManActMethodStart& operator=(const vehicle_mainfi_tclMsgCam15ManActMethodStart& coRef);
   vehicle_mainfi_tclMsgCam15ManActMethodStart(const vehicle_mainfi_tclMsgCam15ManActMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 RequestId;
   virtual ~vehicle_mainfi_tclMsgCam15ManActMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCam15ManActMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCam15ManActMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCam15ManActMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCam15ManActMethodResult& operator=(const vehicle_mainfi_tclMsgCam15ManActMethodResult& coRef);
   vehicle_mainfi_tclMsgCam15ManActMethodResult(const vehicle_mainfi_tclMsgCam15ManActMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgCam15ManActMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCam15ManActMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCam16ManActMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCam16ManActMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCam16ManActMethodStart& operator=(const vehicle_mainfi_tclMsgCam16ManActMethodStart& coRef);
   vehicle_mainfi_tclMsgCam16ManActMethodStart(const vehicle_mainfi_tclMsgCam16ManActMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 RequestId;
   virtual ~vehicle_mainfi_tclMsgCam16ManActMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCam16ManActMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCam16ManActMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCam16ManActMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCam16ManActMethodResult& operator=(const vehicle_mainfi_tclMsgCam16ManActMethodResult& coRef);
   vehicle_mainfi_tclMsgCam16ManActMethodResult(const vehicle_mainfi_tclMsgCam16ManActMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgCam16ManActMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCam16ManActMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCam17ManActMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCam17ManActMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCam17ManActMethodStart& operator=(const vehicle_mainfi_tclMsgCam17ManActMethodStart& coRef);
   vehicle_mainfi_tclMsgCam17ManActMethodStart(const vehicle_mainfi_tclMsgCam17ManActMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 RequestId;
   virtual ~vehicle_mainfi_tclMsgCam17ManActMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCam17ManActMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCam17ManActMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCam17ManActMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCam17ManActMethodResult& operator=(const vehicle_mainfi_tclMsgCam17ManActMethodResult& coRef);
   vehicle_mainfi_tclMsgCam17ManActMethodResult(const vehicle_mainfi_tclMsgCam17ManActMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgCam17ManActMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCam17ManActMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgPrivacyResetAckMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgPrivacyResetAckMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgPrivacyResetAckMethodStart& operator=(const vehicle_mainfi_tclMsgPrivacyResetAckMethodStart& coRef);
   vehicle_mainfi_tclMsgPrivacyResetAckMethodStart(const vehicle_mainfi_tclMsgPrivacyResetAckMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 RequestId;
   virtual ~vehicle_mainfi_tclMsgPrivacyResetAckMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgPrivacyResetAckMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgPrivacyResetAckMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgPrivacyResetAckMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgPrivacyResetAckMethodResult& operator=(const vehicle_mainfi_tclMsgPrivacyResetAckMethodResult& coRef);
   vehicle_mainfi_tclMsgPrivacyResetAckMethodResult(const vehicle_mainfi_tclMsgPrivacyResetAckMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgPrivacyResetAckMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgPrivacyResetAckMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDispCamClsMethodStart : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDispCamClsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgDispCamClsMethodStart& operator=(const vehicle_mainfi_tclMsgDispCamClsMethodStart& coRef);
   vehicle_mainfi_tclMsgDispCamClsMethodStart(const vehicle_mainfi_tclMsgDispCamClsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 RequestId;
   virtual ~vehicle_mainfi_tclMsgDispCamClsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgDispCamClsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDispCamClsMethodResult : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDispCamClsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgDispCamClsMethodResult& operator=(const vehicle_mainfi_tclMsgDispCamClsMethodResult& coRef);
   vehicle_mainfi_tclMsgDispCamClsMethodResult(const vehicle_mainfi_tclMsgDispCamClsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Result;
   virtual ~vehicle_mainfi_tclMsgDispCamClsMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgDispCamClsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDistanceUnitUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDistanceUnitUpReg();

   virtual ~vehicle_mainfi_tclMsgDistanceUnitUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgDistanceUnitUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDistanceUnitRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDistanceUnitRelUpReg();

   virtual ~vehicle_mainfi_tclMsgDistanceUnitRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgDistanceUnitRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDistanceUnitGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDistanceUnitGet();

   virtual ~vehicle_mainfi_tclMsgDistanceUnitGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgDistanceUnitGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDistanceUnitSet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDistanceUnitSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgDistanceUnitSet& operator=(const vehicle_mainfi_tclMsgDistanceUnitSet& coRef);
   vehicle_mainfi_tclMsgDistanceUnitSet(const vehicle_mainfi_tclMsgDistanceUnitSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   vehicle_fi_tcl_e8_Vehicle_DistanceUnit e8DistanceUnit;
   virtual ~vehicle_mainfi_tclMsgDistanceUnitSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgDistanceUnitSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDistanceUnitStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDistanceUnitStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgDistanceUnitStatus& operator=(const vehicle_mainfi_tclMsgDistanceUnitStatus& coRef);
   vehicle_mainfi_tclMsgDistanceUnitStatus(const vehicle_mainfi_tclMsgDistanceUnitStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   vehicle_fi_tcl_e8_Vehicle_DistanceUnit e8DistanceUnit;
   virtual ~vehicle_mainfi_tclMsgDistanceUnitStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgDistanceUnitStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgFuelConsumptionUnitUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgFuelConsumptionUnitUpReg();

   virtual ~vehicle_mainfi_tclMsgFuelConsumptionUnitUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgFuelConsumptionUnitUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgFuelConsumptionUnitRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgFuelConsumptionUnitRelUpReg();

   virtual ~vehicle_mainfi_tclMsgFuelConsumptionUnitRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgFuelConsumptionUnitRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgFuelConsumptionUnitGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgFuelConsumptionUnitGet();

   virtual ~vehicle_mainfi_tclMsgFuelConsumptionUnitGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgFuelConsumptionUnitGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgFuelConsumptionUnitSet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgFuelConsumptionUnitSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgFuelConsumptionUnitSet& operator=(const vehicle_mainfi_tclMsgFuelConsumptionUnitSet& coRef);
   vehicle_mainfi_tclMsgFuelConsumptionUnitSet(const vehicle_mainfi_tclMsgFuelConsumptionUnitSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit e8FuelConsumpUnit;
   virtual ~vehicle_mainfi_tclMsgFuelConsumptionUnitSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgFuelConsumptionUnitSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgFuelConsumptionUnitStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgFuelConsumptionUnitStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgFuelConsumptionUnitStatus& operator=(const vehicle_mainfi_tclMsgFuelConsumptionUnitStatus& coRef);
   vehicle_mainfi_tclMsgFuelConsumptionUnitStatus(const vehicle_mainfi_tclMsgFuelConsumptionUnitStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit e8FuelConsumpUnit;
   virtual ~vehicle_mainfi_tclMsgFuelConsumptionUnitStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgFuelConsumptionUnitStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTemperatureUnitUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTemperatureUnitUpReg();

   virtual ~vehicle_mainfi_tclMsgTemperatureUnitUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgTemperatureUnitUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTemperatureUnitRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTemperatureUnitRelUpReg();

   virtual ~vehicle_mainfi_tclMsgTemperatureUnitRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgTemperatureUnitRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTemperatureUnitGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTemperatureUnitGet();

   virtual ~vehicle_mainfi_tclMsgTemperatureUnitGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgTemperatureUnitGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTemperatureUnitSet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTemperatureUnitSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgTemperatureUnitSet& operator=(const vehicle_mainfi_tclMsgTemperatureUnitSet& coRef);
   vehicle_mainfi_tclMsgTemperatureUnitSet(const vehicle_mainfi_tclMsgTemperatureUnitSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   vehicle_fi_tcl_e8_Vehicle_TemperatureUnit e8TempUnit;
   virtual ~vehicle_mainfi_tclMsgTemperatureUnitSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgTemperatureUnitSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTemperatureUnitStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTemperatureUnitStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgTemperatureUnitStatus& operator=(const vehicle_mainfi_tclMsgTemperatureUnitStatus& coRef);
   vehicle_mainfi_tclMsgTemperatureUnitStatus(const vehicle_mainfi_tclMsgTemperatureUnitStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   vehicle_fi_tcl_e8_Vehicle_TemperatureUnit e8TempUnit;
   virtual ~vehicle_mainfi_tclMsgTemperatureUnitStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgTemperatureUnitStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgLanguageUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgLanguageUpReg();

   virtual ~vehicle_mainfi_tclMsgLanguageUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgLanguageUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgLanguageRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgLanguageRelUpReg();

   virtual ~vehicle_mainfi_tclMsgLanguageRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgLanguageRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgLanguageGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgLanguageGet();

   virtual ~vehicle_mainfi_tclMsgLanguageGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgLanguageGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgLanguageStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgLanguageStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgLanguageStatus& operator=(const vehicle_mainfi_tclMsgLanguageStatus& coRef);
   vehicle_mainfi_tclMsgLanguageStatus(const vehicle_mainfi_tclMsgLanguageStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   vehicle_fi_tcl_e8_Language_Code Language;
   std::vector<vehicle_fi_tcl_Language_SourceTable, std::allocator<vehicle_fi_tcl_Language_SourceTable> > LangTable;
   virtual ~vehicle_mainfi_tclMsgLanguageStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgLanguageStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgLanguageSyncSourceUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgLanguageSyncSourceUpReg();

   virtual ~vehicle_mainfi_tclMsgLanguageSyncSourceUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgLanguageSyncSourceUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgLanguageSyncSourceRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgLanguageSyncSourceRelUpReg();

   virtual ~vehicle_mainfi_tclMsgLanguageSyncSourceRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgLanguageSyncSourceRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgLanguageSyncSourceGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgLanguageSyncSourceGet();

   virtual ~vehicle_mainfi_tclMsgLanguageSyncSourceGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgLanguageSyncSourceGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgLanguageSyncSourceSet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgLanguageSyncSourceSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgLanguageSyncSourceSet& operator=(const vehicle_mainfi_tclMsgLanguageSyncSourceSet& coRef);
   vehicle_mainfi_tclMsgLanguageSyncSourceSet(const vehicle_mainfi_tclMsgLanguageSyncSourceSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   vehicle_fi_tcl_e8_Language_SourceId Language;
   virtual ~vehicle_mainfi_tclMsgLanguageSyncSourceSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgLanguageSyncSourceSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgLanguageSyncSourceStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgLanguageSyncSourceStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgLanguageSyncSourceStatus& operator=(const vehicle_mainfi_tclMsgLanguageSyncSourceStatus& coRef);
   vehicle_mainfi_tclMsgLanguageSyncSourceStatus(const vehicle_mainfi_tclMsgLanguageSyncSourceStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   vehicle_fi_tcl_e8_Language_SourceId Language;
   virtual ~vehicle_mainfi_tclMsgLanguageSyncSourceStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgLanguageSyncSourceStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMeterLanguageKnowledgeUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMeterLanguageKnowledgeUpReg();

   virtual ~vehicle_mainfi_tclMsgMeterLanguageKnowledgeUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgMeterLanguageKnowledgeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMeterLanguageKnowledgeRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMeterLanguageKnowledgeRelUpReg();

   virtual ~vehicle_mainfi_tclMsgMeterLanguageKnowledgeRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgMeterLanguageKnowledgeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMeterLanguageKnowledgeGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMeterLanguageKnowledgeGet();

   virtual ~vehicle_mainfi_tclMsgMeterLanguageKnowledgeGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgMeterLanguageKnowledgeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMeterLanguageKnowledgeStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMeterLanguageKnowledgeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMeterLanguageKnowledgeStatus& operator=(const vehicle_mainfi_tclMsgMeterLanguageKnowledgeStatus& coRef);
   vehicle_mainfi_tclMsgMeterLanguageKnowledgeStatus(const vehicle_mainfi_tclMsgMeterLanguageKnowledgeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   vehicle_fi_tcl_e8_Meter_LangKnowledge State;
   virtual ~vehicle_mainfi_tclMsgMeterLanguageKnowledgeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMeterLanguageKnowledgeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgHandBrakeUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgHandBrakeUpReg();

   virtual ~vehicle_mainfi_tclMsgHandBrakeUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgHandBrakeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgHandBrakeRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgHandBrakeRelUpReg();

   virtual ~vehicle_mainfi_tclMsgHandBrakeRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgHandBrakeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgHandBrakeGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgHandBrakeGet();

   virtual ~vehicle_mainfi_tclMsgHandBrakeGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgHandBrakeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgHandBrakeStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgHandBrakeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgHandBrakeStatus& operator=(const vehicle_mainfi_tclMsgHandBrakeStatus& coRef);
   vehicle_mainfi_tclMsgHandBrakeStatus(const vehicle_mainfi_tclMsgHandBrakeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   vehicle_fi_tcl_e8_Vehicle_HandBrakeStatus e8Status;
   virtual ~vehicle_mainfi_tclMsgHandBrakeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgHandBrakeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgIgnitionUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgIgnitionUpReg();

   virtual ~vehicle_mainfi_tclMsgIgnitionUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgIgnitionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgIgnitionRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgIgnitionRelUpReg();

   virtual ~vehicle_mainfi_tclMsgIgnitionRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgIgnitionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgIgnitionGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgIgnitionGet();

   virtual ~vehicle_mainfi_tclMsgIgnitionGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgIgnitionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgIgnitionStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgIgnitionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgIgnitionStatus& operator=(const vehicle_mainfi_tclMsgIgnitionStatus& coRef);
   vehicle_mainfi_tclMsgIgnitionStatus(const vehicle_mainfi_tclMsgIgnitionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   vehicle_fi_tcl_e8_Vehicle_Ignition e8Status;
   virtual ~vehicle_mainfi_tclMsgIgnitionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgIgnitionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSpeedUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSpeedUpReg();

   virtual ~vehicle_mainfi_tclMsgSpeedUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgSpeedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSpeedRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSpeedRelUpReg();

   virtual ~vehicle_mainfi_tclMsgSpeedRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgSpeedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSpeedGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSpeedGet();

   virtual ~vehicle_mainfi_tclMsgSpeedGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgSpeedGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSpeedStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSpeedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSpeedStatus& operator=(const vehicle_mainfi_tclMsgSpeedStatus& coRef);
   vehicle_mainfi_tclMsgSpeedStatus(const vehicle_mainfi_tclMsgSpeedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 SpeedValue;
   virtual ~vehicle_mainfi_tclMsgSpeedStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSpeedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSpeedLimitUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSpeedLimitUpReg();

   virtual ~vehicle_mainfi_tclMsgSpeedLimitUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgSpeedLimitUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSpeedLimitRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSpeedLimitRelUpReg();

   virtual ~vehicle_mainfi_tclMsgSpeedLimitRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgSpeedLimitRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSpeedLimitGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSpeedLimitGet();

   virtual ~vehicle_mainfi_tclMsgSpeedLimitGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgSpeedLimitGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSpeedLimitStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSpeedLimitStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSpeedLimitStatus& operator=(const vehicle_mainfi_tclMsgSpeedLimitStatus& coRef);
   vehicle_mainfi_tclMsgSpeedLimitStatus(const vehicle_mainfi_tclMsgSpeedLimitStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 SpeedLimit1;
   tU8 SpeedLimit2;
   tU8 Display;
   vehicle_fi_tcl_e8_Vehicle_DistanceUnit DisplayUnit;
   tBool OverSpeed;
   tBool FreeSpeed;
   virtual ~vehicle_mainfi_tclMsgSpeedLimitStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSpeedLimitStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgReverseGearUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgReverseGearUpReg();

   virtual ~vehicle_mainfi_tclMsgReverseGearUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgReverseGearUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgReverseGearRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgReverseGearRelUpReg();

   virtual ~vehicle_mainfi_tclMsgReverseGearRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgReverseGearRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgReverseGearGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgReverseGearGet();

   virtual ~vehicle_mainfi_tclMsgReverseGearGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgReverseGearGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgReverseGearStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgReverseGearStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgReverseGearStatus& operator=(const vehicle_mainfi_tclMsgReverseGearStatus& coRef);
   vehicle_mainfi_tclMsgReverseGearStatus(const vehicle_mainfi_tclMsgReverseGearStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 State;
   virtual ~vehicle_mainfi_tclMsgReverseGearStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgReverseGearStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSpeedLockUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSpeedLockUpReg();

   virtual ~vehicle_mainfi_tclMsgSpeedLockUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgSpeedLockUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSpeedLockRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSpeedLockRelUpReg();

   virtual ~vehicle_mainfi_tclMsgSpeedLockRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgSpeedLockRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSpeedLockGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSpeedLockGet();

   virtual ~vehicle_mainfi_tclMsgSpeedLockGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgSpeedLockGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSpeedLockStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSpeedLockStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSpeedLockStatus& operator=(const vehicle_mainfi_tclMsgSpeedLockStatus& coRef);
   vehicle_mainfi_tclMsgSpeedLockStatus(const vehicle_mainfi_tclMsgSpeedLockStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 State;
   virtual ~vehicle_mainfi_tclMsgSpeedLockStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSpeedLockStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDrivingStateUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDrivingStateUpReg();

   virtual ~vehicle_mainfi_tclMsgDrivingStateUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgDrivingStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDrivingStateRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDrivingStateRelUpReg();

   virtual ~vehicle_mainfi_tclMsgDrivingStateRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgDrivingStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDrivingStateGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDrivingStateGet();

   virtual ~vehicle_mainfi_tclMsgDrivingStateGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgDrivingStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDrivingStateStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDrivingStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgDrivingStateStatus& operator=(const vehicle_mainfi_tclMsgDrivingStateStatus& coRef);
   vehicle_mainfi_tclMsgDrivingStateStatus(const vehicle_mainfi_tclMsgDrivingStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 State;
   virtual ~vehicle_mainfi_tclMsgDrivingStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgDrivingStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgGlobalVehicleWarningStateUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgGlobalVehicleWarningStateUpReg();

   virtual ~vehicle_mainfi_tclMsgGlobalVehicleWarningStateUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgGlobalVehicleWarningStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgGlobalVehicleWarningStateRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgGlobalVehicleWarningStateRelUpReg();

   virtual ~vehicle_mainfi_tclMsgGlobalVehicleWarningStateRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgGlobalVehicleWarningStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgGlobalVehicleWarningStateGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgGlobalVehicleWarningStateGet();

   virtual ~vehicle_mainfi_tclMsgGlobalVehicleWarningStateGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgGlobalVehicleWarningStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgGlobalVehicleWarningStateStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgGlobalVehicleWarningStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgGlobalVehicleWarningStateStatus& operator=(const vehicle_mainfi_tclMsgGlobalVehicleWarningStateStatus& coRef);
   vehicle_mainfi_tclMsgGlobalVehicleWarningStateStatus(const vehicle_mainfi_tclMsgGlobalVehicleWarningStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   vehicle_fi_tcl_e8_Vehicle_WarningState State;
   virtual ~vehicle_mainfi_tclMsgGlobalVehicleWarningStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgGlobalVehicleWarningStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgVehicleStatesUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgVehicleStatesUpReg();

   virtual ~vehicle_mainfi_tclMsgVehicleStatesUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgVehicleStatesUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgVehicleStatesRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgVehicleStatesRelUpReg();

   virtual ~vehicle_mainfi_tclMsgVehicleStatesRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgVehicleStatesRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgVehicleStatesGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgVehicleStatesGet();

   virtual ~vehicle_mainfi_tclMsgVehicleStatesGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgVehicleStatesGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgVehicleStatesStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgVehicleStatesStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgVehicleStatesStatus& operator=(const vehicle_mainfi_tclMsgVehicleStatesStatus& coRef);
   vehicle_mainfi_tclMsgVehicleStatesStatus(const vehicle_mainfi_tclMsgVehicleStatesStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   vehicle_fi_tcl_e8_Vehicle_States State;
   virtual ~vehicle_mainfi_tclMsgVehicleStatesStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgVehicleStatesStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgPartialMuteUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgPartialMuteUpReg();

   virtual ~vehicle_mainfi_tclMsgPartialMuteUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgPartialMuteUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgPartialMuteRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgPartialMuteRelUpReg();

   virtual ~vehicle_mainfi_tclMsgPartialMuteRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgPartialMuteRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgPartialMuteGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgPartialMuteGet();

   virtual ~vehicle_mainfi_tclMsgPartialMuteGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgPartialMuteGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgPartialMuteStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgPartialMuteStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgPartialMuteStatus& operator=(const vehicle_mainfi_tclMsgPartialMuteStatus& coRef);
   vehicle_mainfi_tclMsgPartialMuteStatus(const vehicle_mainfi_tclMsgPartialMuteStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 PartialMuteValue;
   virtual ~vehicle_mainfi_tclMsgPartialMuteStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgPartialMuteStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSwivMonAutoOpenUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSwivMonAutoOpenUpReg();

   virtual ~vehicle_mainfi_tclMsgSwivMonAutoOpenUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgSwivMonAutoOpenUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSwivMonAutoOpenRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSwivMonAutoOpenRelUpReg();

   virtual ~vehicle_mainfi_tclMsgSwivMonAutoOpenRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgSwivMonAutoOpenRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSwivMonAutoOpenGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSwivMonAutoOpenGet();

   virtual ~vehicle_mainfi_tclMsgSwivMonAutoOpenGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgSwivMonAutoOpenGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSwivMonAutoOpenStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSwivMonAutoOpenStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSwivMonAutoOpenStatus& operator=(const vehicle_mainfi_tclMsgSwivMonAutoOpenStatus& coRef);
   vehicle_mainfi_tclMsgSwivMonAutoOpenStatus(const vehicle_mainfi_tclMsgSwivMonAutoOpenStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 SwivMonAutoOpenValue;
   virtual ~vehicle_mainfi_tclMsgSwivMonAutoOpenStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSwivMonAutoOpenStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDateModeUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDateModeUpReg();

   virtual ~vehicle_mainfi_tclMsgDateModeUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgDateModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDateModeRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDateModeRelUpReg();

   virtual ~vehicle_mainfi_tclMsgDateModeRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgDateModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDateModeGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDateModeGet();

   virtual ~vehicle_mainfi_tclMsgDateModeGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgDateModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDateModeStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDateModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgDateModeStatus& operator=(const vehicle_mainfi_tclMsgDateModeStatus& coRef);
   vehicle_mainfi_tclMsgDateModeStatus(const vehicle_mainfi_tclMsgDateModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DateModeValue;
   virtual ~vehicle_mainfi_tclMsgDateModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgDateModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTmModeUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTmModeUpReg();

   virtual ~vehicle_mainfi_tclMsgTmModeUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgTmModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTmModeRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTmModeRelUpReg();

   virtual ~vehicle_mainfi_tclMsgTmModeRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgTmModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTmModeGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTmModeGet();

   virtual ~vehicle_mainfi_tclMsgTmModeGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgTmModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTmModeStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTmModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgTmModeStatus& operator=(const vehicle_mainfi_tclMsgTmModeStatus& coRef);
   vehicle_mainfi_tclMsgTmModeStatus(const vehicle_mainfi_tclMsgTmModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 TmModeValue;
   virtual ~vehicle_mainfi_tclMsgTmModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgTmModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCamTxtUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCamTxtUpReg();

   virtual ~vehicle_mainfi_tclMsgCamTxtUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgCamTxtUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCamTxtRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCamTxtRelUpReg();

   virtual ~vehicle_mainfi_tclMsgCamTxtRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgCamTxtRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCamTxtGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCamTxtGet();

   virtual ~vehicle_mainfi_tclMsgCamTxtGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgCamTxtGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCamTxtStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCamTxtStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCamTxtStatus& operator=(const vehicle_mainfi_tclMsgCamTxtStatus& coRef);
   vehicle_mainfi_tclMsgCamTxtStatus(const vehicle_mainfi_tclMsgCamTxtStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU64 CamTxtValue;
   virtual ~vehicle_mainfi_tclMsgCamTxtStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCamTxtStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam1UpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam1UpReg();

   virtual ~vehicle_mainfi_tclMsgActCam1UpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam1UpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam1RelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam1RelUpReg();

   virtual ~vehicle_mainfi_tclMsgActCam1RelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam1RelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam1Get : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam1Get();

   virtual ~vehicle_mainfi_tclMsgActCam1Get();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam1Get& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam1Status : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam1Status();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgActCam1Status& operator=(const vehicle_mainfi_tclMsgActCam1Status& coRef);
   vehicle_mainfi_tclMsgActCam1Status(const vehicle_mainfi_tclMsgActCam1Status& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ActCam1Value;
   virtual ~vehicle_mainfi_tclMsgActCam1Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgActCam1Status& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam2UpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam2UpReg();

   virtual ~vehicle_mainfi_tclMsgActCam2UpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam2UpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam2RelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam2RelUpReg();

   virtual ~vehicle_mainfi_tclMsgActCam2RelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam2RelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam2Get : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam2Get();

   virtual ~vehicle_mainfi_tclMsgActCam2Get();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam2Get& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam2Status : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam2Status();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgActCam2Status& operator=(const vehicle_mainfi_tclMsgActCam2Status& coRef);
   vehicle_mainfi_tclMsgActCam2Status(const vehicle_mainfi_tclMsgActCam2Status& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ActCam2Value;
   virtual ~vehicle_mainfi_tclMsgActCam2Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgActCam2Status& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam3UpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam3UpReg();

   virtual ~vehicle_mainfi_tclMsgActCam3UpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam3UpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam3RelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam3RelUpReg();

   virtual ~vehicle_mainfi_tclMsgActCam3RelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam3RelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam3Get : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam3Get();

   virtual ~vehicle_mainfi_tclMsgActCam3Get();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam3Get& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam3Status : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam3Status();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgActCam3Status& operator=(const vehicle_mainfi_tclMsgActCam3Status& coRef);
   vehicle_mainfi_tclMsgActCam3Status(const vehicle_mainfi_tclMsgActCam3Status& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ActCam3Value;
   virtual ~vehicle_mainfi_tclMsgActCam3Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgActCam3Status& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam4UpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam4UpReg();

   virtual ~vehicle_mainfi_tclMsgActCam4UpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam4UpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam4RelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam4RelUpReg();

   virtual ~vehicle_mainfi_tclMsgActCam4RelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam4RelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam4Get : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam4Get();

   virtual ~vehicle_mainfi_tclMsgActCam4Get();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam4Get& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam4Status : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam4Status();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgActCam4Status& operator=(const vehicle_mainfi_tclMsgActCam4Status& coRef);
   vehicle_mainfi_tclMsgActCam4Status(const vehicle_mainfi_tclMsgActCam4Status& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ActCam4Value;
   virtual ~vehicle_mainfi_tclMsgActCam4Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgActCam4Status& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam5UpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam5UpReg();

   virtual ~vehicle_mainfi_tclMsgActCam5UpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam5UpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam5RelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam5RelUpReg();

   virtual ~vehicle_mainfi_tclMsgActCam5RelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam5RelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam5Get : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam5Get();

   virtual ~vehicle_mainfi_tclMsgActCam5Get();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam5Get& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam5Status : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam5Status();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgActCam5Status& operator=(const vehicle_mainfi_tclMsgActCam5Status& coRef);
   vehicle_mainfi_tclMsgActCam5Status(const vehicle_mainfi_tclMsgActCam5Status& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ActCam5Value;
   virtual ~vehicle_mainfi_tclMsgActCam5Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgActCam5Status& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam6UpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam6UpReg();

   virtual ~vehicle_mainfi_tclMsgActCam6UpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam6UpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam6RelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam6RelUpReg();

   virtual ~vehicle_mainfi_tclMsgActCam6RelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam6RelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam6Get : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam6Get();

   virtual ~vehicle_mainfi_tclMsgActCam6Get();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam6Get& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam6Status : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam6Status();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgActCam6Status& operator=(const vehicle_mainfi_tclMsgActCam6Status& coRef);
   vehicle_mainfi_tclMsgActCam6Status(const vehicle_mainfi_tclMsgActCam6Status& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ActCam6Value;
   virtual ~vehicle_mainfi_tclMsgActCam6Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgActCam6Status& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam7UpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam7UpReg();

   virtual ~vehicle_mainfi_tclMsgActCam7UpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam7UpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam7RelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam7RelUpReg();

   virtual ~vehicle_mainfi_tclMsgActCam7RelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam7RelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam7Get : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam7Get();

   virtual ~vehicle_mainfi_tclMsgActCam7Get();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam7Get& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam7Status : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam7Status();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgActCam7Status& operator=(const vehicle_mainfi_tclMsgActCam7Status& coRef);
   vehicle_mainfi_tclMsgActCam7Status(const vehicle_mainfi_tclMsgActCam7Status& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ActCam7Value;
   virtual ~vehicle_mainfi_tclMsgActCam7Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgActCam7Status& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDriverDoorOpenUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDriverDoorOpenUpReg();

   virtual ~vehicle_mainfi_tclMsgDriverDoorOpenUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgDriverDoorOpenUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDriverDoorOpenRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDriverDoorOpenRelUpReg();

   virtual ~vehicle_mainfi_tclMsgDriverDoorOpenRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgDriverDoorOpenRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDriverDoorOpenGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDriverDoorOpenGet();

   virtual ~vehicle_mainfi_tclMsgDriverDoorOpenGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgDriverDoorOpenGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDriverDoorOpenStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDriverDoorOpenStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgDriverDoorOpenStatus& operator=(const vehicle_mainfi_tclMsgDriverDoorOpenStatus& coRef);
   vehicle_mainfi_tclMsgDriverDoorOpenStatus(const vehicle_mainfi_tclMsgDriverDoorOpenStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DriverDoorOpenValue;
   virtual ~vehicle_mainfi_tclMsgDriverDoorOpenStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgDriverDoorOpenStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam8UpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam8UpReg();

   virtual ~vehicle_mainfi_tclMsgActCam8UpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam8UpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam8RelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam8RelUpReg();

   virtual ~vehicle_mainfi_tclMsgActCam8RelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam8RelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam8Get : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam8Get();

   virtual ~vehicle_mainfi_tclMsgActCam8Get();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam8Get& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam8Status : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam8Status();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgActCam8Status& operator=(const vehicle_mainfi_tclMsgActCam8Status& coRef);
   vehicle_mainfi_tclMsgActCam8Status(const vehicle_mainfi_tclMsgActCam8Status& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ActCam8Value;
   virtual ~vehicle_mainfi_tclMsgActCam8Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgActCam8Status& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam9UpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam9UpReg();

   virtual ~vehicle_mainfi_tclMsgActCam9UpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam9UpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam9RelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam9RelUpReg();

   virtual ~vehicle_mainfi_tclMsgActCam9RelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam9RelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam9Get : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam9Get();

   virtual ~vehicle_mainfi_tclMsgActCam9Get();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam9Get& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam9Status : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam9Status();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgActCam9Status& operator=(const vehicle_mainfi_tclMsgActCam9Status& coRef);
   vehicle_mainfi_tclMsgActCam9Status(const vehicle_mainfi_tclMsgActCam9Status& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ActCam9Value;
   virtual ~vehicle_mainfi_tclMsgActCam9Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgActCam9Status& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam10UpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam10UpReg();

   virtual ~vehicle_mainfi_tclMsgActCam10UpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam10UpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam10RelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam10RelUpReg();

   virtual ~vehicle_mainfi_tclMsgActCam10RelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam10RelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam10Get : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam10Get();

   virtual ~vehicle_mainfi_tclMsgActCam10Get();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam10Get& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam10Status : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam10Status();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgActCam10Status& operator=(const vehicle_mainfi_tclMsgActCam10Status& coRef);
   vehicle_mainfi_tclMsgActCam10Status(const vehicle_mainfi_tclMsgActCam10Status& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ActCam10Value;
   virtual ~vehicle_mainfi_tclMsgActCam10Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgActCam10Status& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam11UpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam11UpReg();

   virtual ~vehicle_mainfi_tclMsgActCam11UpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam11UpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam11RelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam11RelUpReg();

   virtual ~vehicle_mainfi_tclMsgActCam11RelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam11RelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam11Get : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam11Get();

   virtual ~vehicle_mainfi_tclMsgActCam11Get();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam11Get& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam11Status : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam11Status();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgActCam11Status& operator=(const vehicle_mainfi_tclMsgActCam11Status& coRef);
   vehicle_mainfi_tclMsgActCam11Status(const vehicle_mainfi_tclMsgActCam11Status& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ActCam11Value;
   virtual ~vehicle_mainfi_tclMsgActCam11Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgActCam11Status& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam12UpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam12UpReg();

   virtual ~vehicle_mainfi_tclMsgActCam12UpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam12UpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam12RelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam12RelUpReg();

   virtual ~vehicle_mainfi_tclMsgActCam12RelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam12RelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam12Get : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam12Get();

   virtual ~vehicle_mainfi_tclMsgActCam12Get();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam12Get& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam12Status : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam12Status();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgActCam12Status& operator=(const vehicle_mainfi_tclMsgActCam12Status& coRef);
   vehicle_mainfi_tclMsgActCam12Status(const vehicle_mainfi_tclMsgActCam12Status& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ActCam12Value;
   virtual ~vehicle_mainfi_tclMsgActCam12Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgActCam12Status& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam13UpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam13UpReg();

   virtual ~vehicle_mainfi_tclMsgActCam13UpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam13UpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam13RelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam13RelUpReg();

   virtual ~vehicle_mainfi_tclMsgActCam13RelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam13RelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam13Get : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam13Get();

   virtual ~vehicle_mainfi_tclMsgActCam13Get();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam13Get& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam13Status : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam13Status();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgActCam13Status& operator=(const vehicle_mainfi_tclMsgActCam13Status& coRef);
   vehicle_mainfi_tclMsgActCam13Status(const vehicle_mainfi_tclMsgActCam13Status& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ActCam13Value;
   virtual ~vehicle_mainfi_tclMsgActCam13Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgActCam13Status& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam14UpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam14UpReg();

   virtual ~vehicle_mainfi_tclMsgActCam14UpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam14UpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam14RelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam14RelUpReg();

   virtual ~vehicle_mainfi_tclMsgActCam14RelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam14RelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam14Get : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam14Get();

   virtual ~vehicle_mainfi_tclMsgActCam14Get();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam14Get& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam14Status : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam14Status();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgActCam14Status& operator=(const vehicle_mainfi_tclMsgActCam14Status& coRef);
   vehicle_mainfi_tclMsgActCam14Status(const vehicle_mainfi_tclMsgActCam14Status& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ActCam14Value;
   virtual ~vehicle_mainfi_tclMsgActCam14Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgActCam14Status& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam15UpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam15UpReg();

   virtual ~vehicle_mainfi_tclMsgActCam15UpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam15UpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam15RelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam15RelUpReg();

   virtual ~vehicle_mainfi_tclMsgActCam15RelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam15RelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam15Get : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam15Get();

   virtual ~vehicle_mainfi_tclMsgActCam15Get();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam15Get& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam15Status : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam15Status();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgActCam15Status& operator=(const vehicle_mainfi_tclMsgActCam15Status& coRef);
   vehicle_mainfi_tclMsgActCam15Status(const vehicle_mainfi_tclMsgActCam15Status& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ActCam15Value;
   virtual ~vehicle_mainfi_tclMsgActCam15Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgActCam15Status& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam16UpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam16UpReg();

   virtual ~vehicle_mainfi_tclMsgActCam16UpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam16UpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam16RelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam16RelUpReg();

   virtual ~vehicle_mainfi_tclMsgActCam16RelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam16RelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam16Get : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam16Get();

   virtual ~vehicle_mainfi_tclMsgActCam16Get();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam16Get& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam16Status : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam16Status();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgActCam16Status& operator=(const vehicle_mainfi_tclMsgActCam16Status& coRef);
   vehicle_mainfi_tclMsgActCam16Status(const vehicle_mainfi_tclMsgActCam16Status& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ActCam16Value;
   virtual ~vehicle_mainfi_tclMsgActCam16Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgActCam16Status& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam17UpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam17UpReg();

   virtual ~vehicle_mainfi_tclMsgActCam17UpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam17UpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam17RelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam17RelUpReg();

   virtual ~vehicle_mainfi_tclMsgActCam17RelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam17RelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam17Get : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam17Get();

   virtual ~vehicle_mainfi_tclMsgActCam17Get();

   inline tBool operator==(const vehicle_mainfi_tclMsgActCam17Get& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgActCam17Status : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgActCam17Status();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgActCam17Status& operator=(const vehicle_mainfi_tclMsgActCam17Status& coRef);
   vehicle_mainfi_tclMsgActCam17Status(const vehicle_mainfi_tclMsgActCam17Status& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ActCam17Value;
   virtual ~vehicle_mainfi_tclMsgActCam17Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgActCam17Status& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCamSplitQuadUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCamSplitQuadUpReg();

   virtual ~vehicle_mainfi_tclMsgCamSplitQuadUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgCamSplitQuadUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCamSplitQuadRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCamSplitQuadRelUpReg();

   virtual ~vehicle_mainfi_tclMsgCamSplitQuadRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgCamSplitQuadRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCamSplitQuadGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCamSplitQuadGet();

   virtual ~vehicle_mainfi_tclMsgCamSplitQuadGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgCamSplitQuadGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCamSplitQuadStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCamSplitQuadStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCamSplitQuadStatus& operator=(const vehicle_mainfi_tclMsgCamSplitQuadStatus& coRef);
   vehicle_mainfi_tclMsgCamSplitQuadStatus(const vehicle_mainfi_tclMsgCamSplitQuadStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 CamSplitQuadValue;
   virtual ~vehicle_mainfi_tclMsgCamSplitQuadStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCamSplitQuadStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMuteDevUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMuteDevUpReg();

   virtual ~vehicle_mainfi_tclMsgMuteDevUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgMuteDevUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMuteDevRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMuteDevRelUpReg();

   virtual ~vehicle_mainfi_tclMsgMuteDevRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgMuteDevRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMuteDevGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMuteDevGet();

   virtual ~vehicle_mainfi_tclMsgMuteDevGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgMuteDevGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMuteDevStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMuteDevStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMuteDevStatus& operator=(const vehicle_mainfi_tclMsgMuteDevStatus& coRef);
   vehicle_mainfi_tclMsgMuteDevStatus(const vehicle_mainfi_tclMsgMuteDevStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 MuteDevStatus;
   virtual ~vehicle_mainfi_tclMsgMuteDevStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMuteDevStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSysVoltUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSysVoltUpReg();

   virtual ~vehicle_mainfi_tclMsgSysVoltUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgSysVoltUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSysVoltRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSysVoltRelUpReg();

   virtual ~vehicle_mainfi_tclMsgSysVoltRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgSysVoltRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSysVoltGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSysVoltGet();

   virtual ~vehicle_mainfi_tclMsgSysVoltGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgSysVoltGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSysVoltStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSysVoltStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSysVoltStatus& operator=(const vehicle_mainfi_tclMsgSysVoltStatus& coRef);
   vehicle_mainfi_tclMsgSysVoltStatus(const vehicle_mainfi_tclMsgSysVoltStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 SysVoltStatus;
   virtual ~vehicle_mainfi_tclMsgSysVoltStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSysVoltStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgParkingBreakSwitchUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgParkingBreakSwitchUpReg();

   virtual ~vehicle_mainfi_tclMsgParkingBreakSwitchUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgParkingBreakSwitchUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgParkingBreakSwitchRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgParkingBreakSwitchRelUpReg();

   virtual ~vehicle_mainfi_tclMsgParkingBreakSwitchRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgParkingBreakSwitchRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgParkingBreakSwitchGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgParkingBreakSwitchGet();

   virtual ~vehicle_mainfi_tclMsgParkingBreakSwitchGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgParkingBreakSwitchGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgParkingBreakSwitchStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgParkingBreakSwitchStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgParkingBreakSwitchStatus& operator=(const vehicle_mainfi_tclMsgParkingBreakSwitchStatus& coRef);
   vehicle_mainfi_tclMsgParkingBreakSwitchStatus(const vehicle_mainfi_tclMsgParkingBreakSwitchStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ParkingBreakSwitchValue;
   virtual ~vehicle_mainfi_tclMsgParkingBreakSwitchStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgParkingBreakSwitchStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgRearCamReqUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgRearCamReqUpReg();

   virtual ~vehicle_mainfi_tclMsgRearCamReqUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgRearCamReqUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgRearCamReqRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgRearCamReqRelUpReg();

   virtual ~vehicle_mainfi_tclMsgRearCamReqRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgRearCamReqRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgRearCamReqGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgRearCamReqGet();

   virtual ~vehicle_mainfi_tclMsgRearCamReqGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgRearCamReqGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgRearCamReqStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgRearCamReqStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgRearCamReqStatus& operator=(const vehicle_mainfi_tclMsgRearCamReqStatus& coRef);
   vehicle_mainfi_tclMsgRearCamReqStatus(const vehicle_mainfi_tclMsgRearCamReqStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 RearCamReqValue;
   virtual ~vehicle_mainfi_tclMsgRearCamReqStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgRearCamReqStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgVINUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgVINUpReg();

   virtual ~vehicle_mainfi_tclMsgVINUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgVINUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgVINRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgVINRelUpReg();

   virtual ~vehicle_mainfi_tclMsgVINRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgVINRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgVINGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgVINGet();

   virtual ~vehicle_mainfi_tclMsgVINGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgVINGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgVINStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgVINStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgVINStatus& operator=(const vehicle_mainfi_tclMsgVINStatus& coRef);
   vehicle_mainfi_tclMsgVINStatus(const vehicle_mainfi_tclMsgVINStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 VINValue;
   virtual ~vehicle_mainfi_tclMsgVINStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgVINStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTimeDateUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTimeDateUpReg();

   virtual ~vehicle_mainfi_tclMsgTimeDateUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgTimeDateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTimeDateRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTimeDateRelUpReg();

   virtual ~vehicle_mainfi_tclMsgTimeDateRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgTimeDateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTimeDateGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTimeDateGet();

   virtual ~vehicle_mainfi_tclMsgTimeDateGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgTimeDateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTimeDateStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTimeDateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgTimeDateStatus& operator=(const vehicle_mainfi_tclMsgTimeDateStatus& coRef);
   vehicle_mainfi_tclMsgTimeDateStatus(const vehicle_mainfi_tclMsgTimeDateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU64 TimeDateValue;
   virtual ~vehicle_mainfi_tclMsgTimeDateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgTimeDateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgPrivacyResetRequestUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgPrivacyResetRequestUpReg();

   virtual ~vehicle_mainfi_tclMsgPrivacyResetRequestUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgPrivacyResetRequestUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgPrivacyResetRequestRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgPrivacyResetRequestRelUpReg();

   virtual ~vehicle_mainfi_tclMsgPrivacyResetRequestRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgPrivacyResetRequestRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgPrivacyResetRequestGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgPrivacyResetRequestGet();

   virtual ~vehicle_mainfi_tclMsgPrivacyResetRequestGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgPrivacyResetRequestGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgPrivacyResetRequestStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgPrivacyResetRequestStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgPrivacyResetRequestStatus& operator=(const vehicle_mainfi_tclMsgPrivacyResetRequestStatus& coRef);
   vehicle_mainfi_tclMsgPrivacyResetRequestStatus(const vehicle_mainfi_tclMsgPrivacyResetRequestStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 PrivacyResetRequestValue;
   virtual ~vehicle_mainfi_tclMsgPrivacyResetRequestStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgPrivacyResetRequestStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgPhoneCallCommandUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgPhoneCallCommandUpReg();

   virtual ~vehicle_mainfi_tclMsgPhoneCallCommandUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgPhoneCallCommandUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgPhoneCallCommandRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgPhoneCallCommandRelUpReg();

   virtual ~vehicle_mainfi_tclMsgPhoneCallCommandRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgPhoneCallCommandRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgPhoneCallCommandGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgPhoneCallCommandGet();

   virtual ~vehicle_mainfi_tclMsgPhoneCallCommandGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgPhoneCallCommandGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgPhoneCallCommandStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgPhoneCallCommandStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgPhoneCallCommandStatus& operator=(const vehicle_mainfi_tclMsgPhoneCallCommandStatus& coRef);
   vehicle_mainfi_tclMsgPhoneCallCommandStatus(const vehicle_mainfi_tclMsgPhoneCallCommandStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 PhoneCallCommandValue;
   virtual ~vehicle_mainfi_tclMsgPhoneCallCommandStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgPhoneCallCommandStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgVolumeCommandUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgVolumeCommandUpReg();

   virtual ~vehicle_mainfi_tclMsgVolumeCommandUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgVolumeCommandUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgVolumeCommandRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgVolumeCommandRelUpReg();

   virtual ~vehicle_mainfi_tclMsgVolumeCommandRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgVolumeCommandRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgVolumeCommandGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgVolumeCommandGet();

   virtual ~vehicle_mainfi_tclMsgVolumeCommandGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgVolumeCommandGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgVolumeCommandStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgVolumeCommandStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgVolumeCommandStatus& operator=(const vehicle_mainfi_tclMsgVolumeCommandStatus& coRef);
   vehicle_mainfi_tclMsgVolumeCommandStatus(const vehicle_mainfi_tclMsgVolumeCommandStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 VolumeCommandValue;
   virtual ~vehicle_mainfi_tclMsgVolumeCommandStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgVolumeCommandStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgVoiceRecgCommandUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgVoiceRecgCommandUpReg();

   virtual ~vehicle_mainfi_tclMsgVoiceRecgCommandUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgVoiceRecgCommandUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgVoiceRecgCommandRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgVoiceRecgCommandRelUpReg();

   virtual ~vehicle_mainfi_tclMsgVoiceRecgCommandRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgVoiceRecgCommandRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgVoiceRecgCommandGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgVoiceRecgCommandGet();

   virtual ~vehicle_mainfi_tclMsgVoiceRecgCommandGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgVoiceRecgCommandGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgVoiceRecgCommandStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgVoiceRecgCommandStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgVoiceRecgCommandStatus& operator=(const vehicle_mainfi_tclMsgVoiceRecgCommandStatus& coRef);
   vehicle_mainfi_tclMsgVoiceRecgCommandStatus(const vehicle_mainfi_tclMsgVoiceRecgCommandStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 VoiceRecgCommandValue;
   virtual ~vehicle_mainfi_tclMsgVoiceRecgCommandStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgVoiceRecgCommandStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDeviceInfoSWversionUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDeviceInfoSWversionUpReg();

   virtual ~vehicle_mainfi_tclMsgDeviceInfoSWversionUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgDeviceInfoSWversionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDeviceInfoSWversionRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDeviceInfoSWversionRelUpReg();

   virtual ~vehicle_mainfi_tclMsgDeviceInfoSWversionRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgDeviceInfoSWversionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDeviceInfoSWversionGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDeviceInfoSWversionGet();

   virtual ~vehicle_mainfi_tclMsgDeviceInfoSWversionGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgDeviceInfoSWversionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDeviceInfoSWversionStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDeviceInfoSWversionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgDeviceInfoSWversionStatus& operator=(const vehicle_mainfi_tclMsgDeviceInfoSWversionStatus& coRef);
   vehicle_mainfi_tclMsgDeviceInfoSWversionStatus(const vehicle_mainfi_tclMsgDeviceInfoSWversionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 SWversionValue;
   virtual ~vehicle_mainfi_tclMsgDeviceInfoSWversionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgDeviceInfoSWversionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTrackCommandUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTrackCommandUpReg();

   virtual ~vehicle_mainfi_tclMsgTrackCommandUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgTrackCommandUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTrackCommandRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTrackCommandRelUpReg();

   virtual ~vehicle_mainfi_tclMsgTrackCommandRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgTrackCommandRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTrackCommandGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTrackCommandGet();

   virtual ~vehicle_mainfi_tclMsgTrackCommandGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgTrackCommandGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTrackCommandStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTrackCommandStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgTrackCommandStatus& operator=(const vehicle_mainfi_tclMsgTrackCommandStatus& coRef);
   vehicle_mainfi_tclMsgTrackCommandStatus(const vehicle_mainfi_tclMsgTrackCommandStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 TrackCommandValue;
   virtual ~vehicle_mainfi_tclMsgTrackCommandStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgTrackCommandStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgPhonePwrCmdUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgPhonePwrCmdUpReg();

   virtual ~vehicle_mainfi_tclMsgPhonePwrCmdUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgPhonePwrCmdUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgPhonePwrCmdRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgPhonePwrCmdRelUpReg();

   virtual ~vehicle_mainfi_tclMsgPhonePwrCmdRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgPhonePwrCmdRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgPhonePwrCmdGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgPhonePwrCmdGet();

   virtual ~vehicle_mainfi_tclMsgPhonePwrCmdGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgPhonePwrCmdGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgPhonePwrCmdStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgPhonePwrCmdStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgPhonePwrCmdStatus& operator=(const vehicle_mainfi_tclMsgPhonePwrCmdStatus& coRef);
   vehicle_mainfi_tclMsgPhonePwrCmdStatus(const vehicle_mainfi_tclMsgPhonePwrCmdStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 PhonePwrCmdValue;
   virtual ~vehicle_mainfi_tclMsgPhonePwrCmdStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgPhonePwrCmdStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgRadioPwrCmdUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgRadioPwrCmdUpReg();

   virtual ~vehicle_mainfi_tclMsgRadioPwrCmdUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgRadioPwrCmdUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgRadioPwrCmdRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgRadioPwrCmdRelUpReg();

   virtual ~vehicle_mainfi_tclMsgRadioPwrCmdRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgRadioPwrCmdRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgRadioPwrCmdGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgRadioPwrCmdGet();

   virtual ~vehicle_mainfi_tclMsgRadioPwrCmdGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgRadioPwrCmdGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgRadioPwrCmdStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgRadioPwrCmdStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgRadioPwrCmdStatus& operator=(const vehicle_mainfi_tclMsgRadioPwrCmdStatus& coRef);
   vehicle_mainfi_tclMsgRadioPwrCmdStatus(const vehicle_mainfi_tclMsgRadioPwrCmdStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 RadioPwrCmdValue;
   virtual ~vehicle_mainfi_tclMsgRadioPwrCmdStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgRadioPwrCmdStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgRCNextBtnUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgRCNextBtnUpReg();

   virtual ~vehicle_mainfi_tclMsgRCNextBtnUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgRCNextBtnUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgRCNextBtnRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgRCNextBtnRelUpReg();

   virtual ~vehicle_mainfi_tclMsgRCNextBtnRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgRCNextBtnRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgRCNextBtnGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgRCNextBtnGet();

   virtual ~vehicle_mainfi_tclMsgRCNextBtnGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgRCNextBtnGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgRCNextBtnStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgRCNextBtnStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgRCNextBtnStatus& operator=(const vehicle_mainfi_tclMsgRCNextBtnStatus& coRef);
   vehicle_mainfi_tclMsgRCNextBtnStatus(const vehicle_mainfi_tclMsgRCNextBtnStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 RCNextBtnValue;
   virtual ~vehicle_mainfi_tclMsgRCNextBtnStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgRCNextBtnStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgRCPrevBtnUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgRCPrevBtnUpReg();

   virtual ~vehicle_mainfi_tclMsgRCPrevBtnUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgRCPrevBtnUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgRCPrevBtnRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgRCPrevBtnRelUpReg();

   virtual ~vehicle_mainfi_tclMsgRCPrevBtnRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgRCPrevBtnRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgRCPrevBtnGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgRCPrevBtnGet();

   virtual ~vehicle_mainfi_tclMsgRCPrevBtnGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgRCPrevBtnGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgRCPrevBtnStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgRCPrevBtnStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgRCPrevBtnStatus& operator=(const vehicle_mainfi_tclMsgRCPrevBtnStatus& coRef);
   vehicle_mainfi_tclMsgRCPrevBtnStatus(const vehicle_mainfi_tclMsgRCPrevBtnStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 RCPrevBtnValue;
   virtual ~vehicle_mainfi_tclMsgRCPrevBtnStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgRCPrevBtnStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSourceCommandUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSourceCommandUpReg();

   virtual ~vehicle_mainfi_tclMsgSourceCommandUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgSourceCommandUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSourceCommandRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSourceCommandRelUpReg();

   virtual ~vehicle_mainfi_tclMsgSourceCommandRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgSourceCommandRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSourceCommandGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSourceCommandGet();

   virtual ~vehicle_mainfi_tclMsgSourceCommandGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgSourceCommandGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSourceCommandStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSourceCommandStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSourceCommandStatus& operator=(const vehicle_mainfi_tclMsgSourceCommandStatus& coRef);
   vehicle_mainfi_tclMsgSourceCommandStatus(const vehicle_mainfi_tclMsgSourceCommandStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 SourceCommandValue;
   virtual ~vehicle_mainfi_tclMsgSourceCommandStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSourceCommandStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTunerCommandUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTunerCommandUpReg();

   virtual ~vehicle_mainfi_tclMsgTunerCommandUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgTunerCommandUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTunerCommandRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTunerCommandRelUpReg();

   virtual ~vehicle_mainfi_tclMsgTunerCommandRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgTunerCommandRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTunerCommandGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTunerCommandGet();

   virtual ~vehicle_mainfi_tclMsgTunerCommandGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgTunerCommandGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTunerCommandStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTunerCommandStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgTunerCommandStatus& operator=(const vehicle_mainfi_tclMsgTunerCommandStatus& coRef);
   vehicle_mainfi_tclMsgTunerCommandStatus(const vehicle_mainfi_tclMsgTunerCommandStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 TunerCommandValue;
   virtual ~vehicle_mainfi_tclMsgTunerCommandStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgTunerCommandStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTACommandUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTACommandUpReg();

   virtual ~vehicle_mainfi_tclMsgTACommandUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgTACommandUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTACommandRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTACommandRelUpReg();

   virtual ~vehicle_mainfi_tclMsgTACommandRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgTACommandRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTACommandGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTACommandGet();

   virtual ~vehicle_mainfi_tclMsgTACommandGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgTACommandGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTACommandStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTACommandStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgTACommandStatus& operator=(const vehicle_mainfi_tclMsgTACommandStatus& coRef);
   vehicle_mainfi_tclMsgTACommandStatus(const vehicle_mainfi_tclMsgTACommandStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 TACommandValue;
   virtual ~vehicle_mainfi_tclMsgTACommandStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgTACommandStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgRDSCommandUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgRDSCommandUpReg();

   virtual ~vehicle_mainfi_tclMsgRDSCommandUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgRDSCommandUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgRDSCommandRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgRDSCommandRelUpReg();

   virtual ~vehicle_mainfi_tclMsgRDSCommandRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgRDSCommandRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgRDSCommandGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgRDSCommandGet();

   virtual ~vehicle_mainfi_tclMsgRDSCommandGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgRDSCommandGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgRDSCommandStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgRDSCommandStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgRDSCommandStatus& operator=(const vehicle_mainfi_tclMsgRDSCommandStatus& coRef);
   vehicle_mainfi_tclMsgRDSCommandStatus(const vehicle_mainfi_tclMsgRDSCommandStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 RDSCommandValue;
   virtual ~vehicle_mainfi_tclMsgRDSCommandStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgRDSCommandStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSMARTVRUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSMARTVRUpReg();

   virtual ~vehicle_mainfi_tclMsgSMARTVRUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgSMARTVRUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSMARTVRRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSMARTVRRelUpReg();

   virtual ~vehicle_mainfi_tclMsgSMARTVRRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgSMARTVRRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSMARTVRGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSMARTVRGet();

   virtual ~vehicle_mainfi_tclMsgSMARTVRGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgSMARTVRGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgSMARTVRStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgSMARTVRStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgSMARTVRStatus& operator=(const vehicle_mainfi_tclMsgSMARTVRStatus& coRef);
   vehicle_mainfi_tclMsgSMARTVRStatus(const vehicle_mainfi_tclMsgSMARTVRStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 SMARTVRValue;
   virtual ~vehicle_mainfi_tclMsgSMARTVRStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgSMARTVRStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTotalVehDistDiagUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTotalVehDistDiagUpReg();

   virtual ~vehicle_mainfi_tclMsgTotalVehDistDiagUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgTotalVehDistDiagUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTotalVehDistDiagRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTotalVehDistDiagRelUpReg();

   virtual ~vehicle_mainfi_tclMsgTotalVehDistDiagRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgTotalVehDistDiagRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTotalVehDistDiagGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTotalVehDistDiagGet();

   virtual ~vehicle_mainfi_tclMsgTotalVehDistDiagGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgTotalVehDistDiagGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTotalVehDistDiagStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTotalVehDistDiagStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgTotalVehDistDiagStatus& operator=(const vehicle_mainfi_tclMsgTotalVehDistDiagStatus& coRef);
   vehicle_mainfi_tclMsgTotalVehDistDiagStatus(const vehicle_mainfi_tclMsgTotalVehDistDiagStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 TotalVehDistDiagValue;
   virtual ~vehicle_mainfi_tclMsgTotalVehDistDiagStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgTotalVehDistDiagStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgVIN_64UpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgVIN_64UpReg();

   virtual ~vehicle_mainfi_tclMsgVIN_64UpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgVIN_64UpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgVIN_64RelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgVIN_64RelUpReg();

   virtual ~vehicle_mainfi_tclMsgVIN_64RelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgVIN_64RelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgVIN_64Get : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgVIN_64Get();

   virtual ~vehicle_mainfi_tclMsgVIN_64Get();

   inline tBool operator==(const vehicle_mainfi_tclMsgVIN_64Get& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgVIN_64Status : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgVIN_64Status();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgVIN_64Status& operator=(const vehicle_mainfi_tclMsgVIN_64Status& coRef);
   vehicle_mainfi_tclMsgVIN_64Status(const vehicle_mainfi_tclMsgVIN_64Status& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU64 VIN_64Value;
   virtual ~vehicle_mainfi_tclMsgVIN_64Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgVIN_64Status& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCabinMediaSourceCommandUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCabinMediaSourceCommandUpReg();

   virtual ~vehicle_mainfi_tclMsgCabinMediaSourceCommandUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgCabinMediaSourceCommandUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCabinMediaSourceCommandRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCabinMediaSourceCommandRelUpReg();

   virtual ~vehicle_mainfi_tclMsgCabinMediaSourceCommandRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgCabinMediaSourceCommandRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCabinMediaSourceCommandGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCabinMediaSourceCommandGet();

   virtual ~vehicle_mainfi_tclMsgCabinMediaSourceCommandGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgCabinMediaSourceCommandGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCabinMediaSourceCommandStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCabinMediaSourceCommandStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCabinMediaSourceCommandStatus& operator=(const vehicle_mainfi_tclMsgCabinMediaSourceCommandStatus& coRef);
   vehicle_mainfi_tclMsgCabinMediaSourceCommandStatus(const vehicle_mainfi_tclMsgCabinMediaSourceCommandStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 CabinMediaSourceCommandValue;
   virtual ~vehicle_mainfi_tclMsgCabinMediaSourceCommandStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCabinMediaSourceCommandStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCabinMediaVolumeCommandUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCabinMediaVolumeCommandUpReg();

   virtual ~vehicle_mainfi_tclMsgCabinMediaVolumeCommandUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgCabinMediaVolumeCommandUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCabinMediaVolumeCommandRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCabinMediaVolumeCommandRelUpReg();

   virtual ~vehicle_mainfi_tclMsgCabinMediaVolumeCommandRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgCabinMediaVolumeCommandRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCabinMediaVolumeCommandGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCabinMediaVolumeCommandGet();

   virtual ~vehicle_mainfi_tclMsgCabinMediaVolumeCommandGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgCabinMediaVolumeCommandGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCabinMediaVolumeCommandStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCabinMediaVolumeCommandStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCabinMediaVolumeCommandStatus& operator=(const vehicle_mainfi_tclMsgCabinMediaVolumeCommandStatus& coRef);
   vehicle_mainfi_tclMsgCabinMediaVolumeCommandStatus(const vehicle_mainfi_tclMsgCabinMediaVolumeCommandStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 CabinMediaVolumeCommandValue;
   virtual ~vehicle_mainfi_tclMsgCabinMediaVolumeCommandStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCabinMediaVolumeCommandStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCabinMediaTunerCommandUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCabinMediaTunerCommandUpReg();

   virtual ~vehicle_mainfi_tclMsgCabinMediaTunerCommandUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgCabinMediaTunerCommandUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCabinMediaTunerCommandRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCabinMediaTunerCommandRelUpReg();

   virtual ~vehicle_mainfi_tclMsgCabinMediaTunerCommandRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgCabinMediaTunerCommandRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCabinMediaTunerCommandGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCabinMediaTunerCommandGet();

   virtual ~vehicle_mainfi_tclMsgCabinMediaTunerCommandGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgCabinMediaTunerCommandGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCabinMediaTunerCommandStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCabinMediaTunerCommandStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCabinMediaTunerCommandStatus& operator=(const vehicle_mainfi_tclMsgCabinMediaTunerCommandStatus& coRef);
   vehicle_mainfi_tclMsgCabinMediaTunerCommandStatus(const vehicle_mainfi_tclMsgCabinMediaTunerCommandStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 CabinMediaTunerCommandValue;
   virtual ~vehicle_mainfi_tclMsgCabinMediaTunerCommandStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCabinMediaTunerCommandStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCabinMediaTrackCommandUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCabinMediaTrackCommandUpReg();

   virtual ~vehicle_mainfi_tclMsgCabinMediaTrackCommandUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgCabinMediaTrackCommandUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCabinMediaTrackCommandRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCabinMediaTrackCommandRelUpReg();

   virtual ~vehicle_mainfi_tclMsgCabinMediaTrackCommandRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgCabinMediaTrackCommandRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCabinMediaTrackCommandGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCabinMediaTrackCommandGet();

   virtual ~vehicle_mainfi_tclMsgCabinMediaTrackCommandGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgCabinMediaTrackCommandGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCabinMediaTrackCommandStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCabinMediaTrackCommandStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCabinMediaTrackCommandStatus& operator=(const vehicle_mainfi_tclMsgCabinMediaTrackCommandStatus& coRef);
   vehicle_mainfi_tclMsgCabinMediaTrackCommandStatus(const vehicle_mainfi_tclMsgCabinMediaTrackCommandStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 CabinMediaTrackCommandValue;
   virtual ~vehicle_mainfi_tclMsgCabinMediaTrackCommandStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCabinMediaTrackCommandStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCabinMediaPlaylistCommandUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCabinMediaPlaylistCommandUpReg();

   virtual ~vehicle_mainfi_tclMsgCabinMediaPlaylistCommandUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgCabinMediaPlaylistCommandUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCabinMediaPlaylistCommandRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCabinMediaPlaylistCommandRelUpReg();

   virtual ~vehicle_mainfi_tclMsgCabinMediaPlaylistCommandRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgCabinMediaPlaylistCommandRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCabinMediaPlaylistCommandGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCabinMediaPlaylistCommandGet();

   virtual ~vehicle_mainfi_tclMsgCabinMediaPlaylistCommandGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgCabinMediaPlaylistCommandGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgCabinMediaPlaylistCommandStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgCabinMediaPlaylistCommandStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgCabinMediaPlaylistCommandStatus& operator=(const vehicle_mainfi_tclMsgCabinMediaPlaylistCommandStatus& coRef);
   vehicle_mainfi_tclMsgCabinMediaPlaylistCommandStatus(const vehicle_mainfi_tclMsgCabinMediaPlaylistCommandStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 CabinMediaPlaylistCommandValue;
   virtual ~vehicle_mainfi_tclMsgCabinMediaPlaylistCommandStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgCabinMediaPlaylistCommandStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgNetworkStateUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgNetworkStateUpReg();

   virtual ~vehicle_mainfi_tclMsgNetworkStateUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgNetworkStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgNetworkStateRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgNetworkStateRelUpReg();

   virtual ~vehicle_mainfi_tclMsgNetworkStateRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgNetworkStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgNetworkStateGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgNetworkStateGet();

   virtual ~vehicle_mainfi_tclMsgNetworkStateGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgNetworkStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgNetworkStateStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgNetworkStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgNetworkStateStatus& operator=(const vehicle_mainfi_tclMsgNetworkStateStatus& coRef);
   vehicle_mainfi_tclMsgNetworkStateStatus(const vehicle_mainfi_tclMsgNetworkStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8BusState_MCAN;
   tU8 u8BusState_VCAN;
   tU8 u8MuteState_MCAN;
   tU8 u8MuteState_VCAN;
   std::vector<tU8, std::allocator<tU8> > Listu8AbsentState_ECU;
   std::vector<tU8, std::allocator<tU8> > Listu8MuteStateMCAN_Channel;
   tBool bBusOff_MCAN;
   tBool bBusOff_VCAN;
   tBool bBusOff;
   tBool bMute_MCAN;
   tBool bMute_VCAN;
   virtual ~vehicle_mainfi_tclMsgNetworkStateStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgNetworkStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDistanceTotalizerUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDistanceTotalizerUpReg();

   virtual ~vehicle_mainfi_tclMsgDistanceTotalizerUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgDistanceTotalizerUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDistanceTotalizerRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDistanceTotalizerRelUpReg();

   virtual ~vehicle_mainfi_tclMsgDistanceTotalizerRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgDistanceTotalizerRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDistanceTotalizerGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDistanceTotalizerGet();

   virtual ~vehicle_mainfi_tclMsgDistanceTotalizerGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgDistanceTotalizerGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgDistanceTotalizerStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgDistanceTotalizerStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgDistanceTotalizerStatus& operator=(const vehicle_mainfi_tclMsgDistanceTotalizerStatus& coRef);
   vehicle_mainfi_tclMsgDistanceTotalizerStatus(const vehicle_mainfi_tclMsgDistanceTotalizerStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DisTotal;
   tU32 lastValidDisTotal;
   tU8 Unit;
   tBool DisTotalStatus;
   virtual ~vehicle_mainfi_tclMsgDistanceTotalizerStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgDistanceTotalizerStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMileageUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMileageUpReg();

   virtual ~vehicle_mainfi_tclMsgMileageUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgMileageUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMileageRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMileageRelUpReg();

   virtual ~vehicle_mainfi_tclMsgMileageRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgMileageRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMileageGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMileageGet();

   virtual ~vehicle_mainfi_tclMsgMileageGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgMileageGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgMileageStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgMileageStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgMileageStatus& operator=(const vehicle_mainfi_tclMsgMileageStatus& coRef);
   vehicle_mainfi_tclMsgMileageStatus(const vehicle_mainfi_tclMsgMileageStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Mileage;
   virtual ~vehicle_mainfi_tclMsgMileageStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgMileageStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgAvgFuelEconomyUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgAvgFuelEconomyUpReg();

   virtual ~vehicle_mainfi_tclMsgAvgFuelEconomyUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgAvgFuelEconomyUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgAvgFuelEconomyRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgAvgFuelEconomyRelUpReg();

   virtual ~vehicle_mainfi_tclMsgAvgFuelEconomyRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgAvgFuelEconomyRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgAvgFuelEconomyGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgAvgFuelEconomyGet();

   virtual ~vehicle_mainfi_tclMsgAvgFuelEconomyGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgAvgFuelEconomyGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgAvgFuelEconomyStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgAvgFuelEconomyStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgAvgFuelEconomyStatus& operator=(const vehicle_mainfi_tclMsgAvgFuelEconomyStatus& coRef);
   vehicle_mainfi_tclMsgAvgFuelEconomyStatus(const vehicle_mainfi_tclMsgAvgFuelEconomyStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 FuelEcon;
   virtual ~vehicle_mainfi_tclMsgAvgFuelEconomyStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgAvgFuelEconomyStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTirePressureSupportUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTirePressureSupportUpReg();

   virtual ~vehicle_mainfi_tclMsgTirePressureSupportUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgTirePressureSupportUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTirePressureSupportRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTirePressureSupportRelUpReg();

   virtual ~vehicle_mainfi_tclMsgTirePressureSupportRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgTirePressureSupportRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTirePressureSupportGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTirePressureSupportGet();

   virtual ~vehicle_mainfi_tclMsgTirePressureSupportGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgTirePressureSupportGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTirePressureSupportStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTirePressureSupportStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgTirePressureSupportStatus& operator=(const vehicle_mainfi_tclMsgTirePressureSupportStatus& coRef);
   vehicle_mainfi_tclMsgTirePressureSupportStatus(const vehicle_mainfi_tclMsgTirePressureSupportStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool PressureSupport;
   virtual ~vehicle_mainfi_tclMsgTirePressureSupportStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgTirePressureSupportStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTPMSResetSupportUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTPMSResetSupportUpReg();

   virtual ~vehicle_mainfi_tclMsgTPMSResetSupportUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgTPMSResetSupportUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTPMSResetSupportRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTPMSResetSupportRelUpReg();

   virtual ~vehicle_mainfi_tclMsgTPMSResetSupportRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgTPMSResetSupportRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTPMSResetSupportGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTPMSResetSupportGet();

   virtual ~vehicle_mainfi_tclMsgTPMSResetSupportGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgTPMSResetSupportGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTPMSResetSupportStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTPMSResetSupportStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgTPMSResetSupportStatus& operator=(const vehicle_mainfi_tclMsgTPMSResetSupportStatus& coRef);
   vehicle_mainfi_tclMsgTPMSResetSupportStatus(const vehicle_mainfi_tclMsgTPMSResetSupportStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   vehicle_fi_tcl_e8_Vehicle_TPMSReset TPMSResetInfo;
   virtual ~vehicle_mainfi_tclMsgTPMSResetSupportStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgTPMSResetSupportStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTirePressureSettingUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTirePressureSettingUpReg();

   virtual ~vehicle_mainfi_tclMsgTirePressureSettingUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgTirePressureSettingUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTirePressureSettingRelUpReg : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTirePressureSettingRelUpReg();

   virtual ~vehicle_mainfi_tclMsgTirePressureSettingRelUpReg();

   inline tBool operator==(const vehicle_mainfi_tclMsgTirePressureSettingRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTirePressureSettingGet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTirePressureSettingGet();

   virtual ~vehicle_mainfi_tclMsgTirePressureSettingGet();

   inline tBool operator==(const vehicle_mainfi_tclMsgTirePressureSettingGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTirePressureSettingSet : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTirePressureSettingSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgTirePressureSettingSet& operator=(const vehicle_mainfi_tclMsgTirePressureSettingSet& coRef);
   vehicle_mainfi_tclMsgTirePressureSettingSet(const vehicle_mainfi_tclMsgTirePressureSettingSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   vehicle_fi_tcl_e8_Vehicle_TirePressureInfo TirePressureRequestInfo;
   virtual ~vehicle_mainfi_tclMsgTirePressureSettingSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgTirePressureSettingSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class vehicle_mainfi_tclMsgTirePressureSettingStatus : public vehicle_mainfi_tclMsgBaseMessage
{
public:

   vehicle_mainfi_tclMsgTirePressureSettingStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vehicle_mainfi_tclMsgTirePressureSettingStatus& operator=(const vehicle_mainfi_tclMsgTirePressureSettingStatus& coRef);
   vehicle_mainfi_tclMsgTirePressureSettingStatus(const vehicle_mainfi_tclMsgTirePressureSettingStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 SettingPressureFront;
   tU16 SettingPressureRear;
   virtual ~vehicle_mainfi_tclMsgTirePressureSettingStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const vehicle_mainfi_tclMsgTirePressureSettingStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
