/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define VEHICLE_FI_S_IMPORT_INTERFACE_VEHICLE_MAINFI_TYPES
#define VEHICLE_FI_S_IMPORT_INTERFACE_VEHICLE_MAINFI_FUNCTIONIDS
#define VEHICLE_FI_S_IMPORT_INTERFACE_VEHICLE_MAINFI_SERVICEINFO
#include "vehicle_fi_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for VEHICLE_MAIN_FI message types

fi_tclMessageBase* vehicle_mainfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case vehicle_mainfi_tclToken::EN_MSG_SETLANGUAGEMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgSetLanguageMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_SETLANGUAGEMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgSetLanguageMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_REQUESTMETERLANGUAGESYNCMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_REQUESTMETERLANGUAGESYNCMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_PHONEBTLINKSTATUSMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_PHONEBTLINKSTATUSMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_PHONEBOOKSYNCSTATUSMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_PHONEBOOKSYNCSTATUSMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_CALLHISTORYSYNCSTATUSMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgCallHistorySyncStatusMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_CALLHISTORYSYNCSTATUSMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgCallHistorySyncStatusMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_PHONESTATUSROAMINGMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgPhoneStatusRoamingMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_PHONESTATUSROAMINGMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgPhoneStatusRoamingMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_CALLDURATIONMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgCallDurationMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_CALLDURATIONMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgCallDurationMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_GSMSIGNALSTRENGTHMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgGSMSignalStrengthMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_GSMSIGNALSTRENGTHMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgGSMSignalStrengthMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_PHONEAVAILABLESTATUSMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgPhoneAvailableStatusMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_PHONEAVAILABLESTATUSMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgPhoneAvailableStatusMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_PHONECALLSTATUSMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgPhoneCallStatusMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_PHONECALLSTATUSMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgPhoneCallStatusMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_PHONEBATTERYLEVELSTATUSMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_PHONEBATTERYLEVELSTATUSMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_PHONEVRAVAILABLEMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgPhoneVRAvailableMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_PHONEVRAVAILABLEMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgPhoneVRAvailableMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSWIFIAVAILABLEMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSWIFIAVAILABLEMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSBTSTATUSMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSBTSTATUSMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSDABAVAILSTATUSMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSDABAVAILSTATUSMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSRADIOSTATUSMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSRADIOSTATUSMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSNAVDATAMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgDeviceStatusNavDataMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSNAVDATAMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgDeviceStatusNavDataMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSUSB1PRESENTMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSUSB1PRESENTMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSUSB2PRESENTMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSUSB2PRESENTMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSNAVIAVAILMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSNAVIAVAILMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSUSB1SRCMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSUSB1SRCMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSUSB2SRCMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSUSB2SRCMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSAMFMAVAILMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSAMFMAVAILMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSBLUETOOTHAVAILMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSBLUETOOTHAVAILMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_REQ_DEVICEINFOMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgReq_DeviceInfoMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_REQ_DEVICEINFOMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgReq_DeviceInfoMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_HUS_DM1_STATUSMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgHUS_DM1_StatusMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_HUS_DM1_STATUSMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgHUS_DM1_StatusMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_VEHICLENAVILATITUDEMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_VEHICLENAVILATITUDEMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_VEHICLENAVILONGITUDEMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_VEHICLENAVILONGITUDEMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSAUDIOSOURCEMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSAUDIOSOURCEMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSVOLUMEMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgMediaStatusVolumeMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSVOLUMEMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgMediaStatusVolumeMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_CABINMEDIASTATUSAUDIOSOURCEMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_CABINMEDIASTATUSAUDIOSOURCEMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_CABINMEDIASTATUSVOLUMEMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_CABINMEDIASTATUSVOLUMEMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSMUTESTATUSMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSMUTESTATUSMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_CABINMEDIASTATUSMUTESTATUSMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_CABINMEDIASTATUSMUTESTATUSMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSPLAYSTATUSMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSPLAYSTATUSMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSSEEKSTATUSMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSSEEKSTATUSMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSREPEATSTATUSMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSREPEATSTATUSMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSDABFMSTATUSMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSDABFMSTATUSMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSTREGSTATUSMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSTREGSTATUSMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSRDSSTATUSMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSRDSSTATUSMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSTASTATUSMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgMediaStatusTAStatusMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSTASTATUSMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgMediaStatusTAStatusMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSTPSTATUSMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgMediaStatusTPStatusMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSTPSTATUSMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgMediaStatusTPStatusMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSTUNERBANDSTATUSMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSTUNERBANDSTATUSMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSTUNERPRESETSTATUSMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSTUNERPRESETSTATUSMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSMIXSTATEMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgMediaStatusMixStateMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSMIXSTATEMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgMediaStatusMixStateMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSPLAYLISTMODEMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSPLAYLISTMODEMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSTRACKTIMEMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSTRACKTIMEMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSCURRTRACKNUMMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSCURRTRACKNUMMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSTREGRTMSTATUSMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSTREGRTMSTATUSMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_CABINMEDIASTATUSTUNERBANDMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_CABINMEDIASTATUSTUNERBANDMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_CSMENGINEERINGDATAMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgCSMEngineeringDataMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_CSMENGINEERINGDATAMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgCSMEngineeringDataMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_SETOSPALERTSSTATUSMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_SETOSPALERTSSTATUSMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_SENDMEDIAINFOMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgSendMediaInfoMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_SENDMEDIAINFOMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgSendMediaInfoMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_SENDCALLINFOMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgSendCallInfoMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_SENDCALLINFOMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgSendCallInfoMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_SENDPHONEINFOMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgSendPhoneInfoMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_SENDPHONEINFOMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgSendPhoneInfoMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_SENDXMINFOMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgSendXMInfoMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_SENDXMINFOMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgSendXMInfoMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_SENDMAINLINEINFOMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgSendMainlineInfoMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_SENDMAINLINEINFOMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgSendMainlineInfoMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_SENDCABINAMEDIAINFOMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_SENDCABINAMEDIAINFOMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_SENDCABINAMAINLINEINFOMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_SENDCABINAMAINLINEINFOMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_SENDCABINACALLINFOMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgSendCabinACallInfoMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_SENDCABINACALLINFOMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgSendCabinACallInfoMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_SENDCABINAPHONEINFOMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_SENDCABINAPHONEINFOMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_SENDCABINAXMINFOMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgSendCabinAXMInfoMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_SENDCABINAXMINFOMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgSendCabinAXMInfoMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_SENDNAVICURRENTSTREETNAMEINFOMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_SENDNAVICURRENTSTREETNAMEINFOMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_SENDNAVITURNTOSTREETNAMEINFOMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_SENDNAVITURNTOSTREETNAMEINFOMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_SENDNAVIDESTINATIONINFOMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_SENDNAVIDESTINATIONINFOMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_SENDNAVITURNTOSYMBOLSINFOMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_SENDNAVITURNTOSYMBOLSINFOMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_SENDNAVILANEGUIDANCEINFOMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_SENDNAVILANEGUIDANCEINFOMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_SENDNAVINAVIGATIONWARNINGINFOMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_SENDNAVINAVIGATIONWARNINGINFOMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_CAM1MANACTMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgCam1ManActMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_CAM1MANACTMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgCam1ManActMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_CAM2MANACTMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgCam2ManActMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_CAM2MANACTMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgCam2ManActMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_CAM3MANACTMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgCam3ManActMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_CAM3MANACTMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgCam3ManActMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_CAM4MANACTMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgCam4ManActMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_CAM4MANACTMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgCam4ManActMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_CAM5MANACTMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgCam5ManActMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_CAM5MANACTMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgCam5ManActMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_CAM6MANACTMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgCam6ManActMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_CAM6MANACTMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgCam6ManActMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_CAM7MANACTMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgCam7ManActMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_CAM7MANACTMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgCam7ManActMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_CAM8MANACTMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgCam8ManActMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_CAM8MANACTMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgCam8ManActMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_CAM9MANACTMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgCam9ManActMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_CAM9MANACTMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgCam9ManActMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_CAM10MANACTMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgCam10ManActMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_CAM10MANACTMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgCam10ManActMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_CAM11MANACTMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgCam11ManActMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_CAM11MANACTMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgCam11ManActMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_CAM12MANACTMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgCam12ManActMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_CAM12MANACTMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgCam12ManActMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_CAM13MANACTMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgCam13ManActMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_CAM13MANACTMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgCam13ManActMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_CAM14MANACTMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgCam14ManActMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_CAM14MANACTMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgCam14ManActMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_CAM15MANACTMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgCam15ManActMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_CAM15MANACTMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgCam15ManActMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_CAM16MANACTMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgCam16ManActMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_CAM16MANACTMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgCam16ManActMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_CAM17MANACTMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgCam17ManActMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_CAM17MANACTMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgCam17ManActMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_PRIVACYRESETACKMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgPrivacyResetAckMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_PRIVACYRESETACKMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgPrivacyResetAckMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_DISPCAMCLSMETHODSTART:
         return OSAL_NEW vehicle_mainfi_tclMsgDispCamClsMethodStart;

      case vehicle_mainfi_tclToken::EN_MSG_DISPCAMCLSMETHODRESULT:
         return OSAL_NEW vehicle_mainfi_tclMsgDispCamClsMethodResult;

      case vehicle_mainfi_tclToken::EN_MSG_DISTANCEUNITUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgDistanceUnitUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_DISTANCEUNITRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgDistanceUnitRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_DISTANCEUNITGET:
         return OSAL_NEW vehicle_mainfi_tclMsgDistanceUnitGet;

      case vehicle_mainfi_tclToken::EN_MSG_DISTANCEUNITSET:
         return OSAL_NEW vehicle_mainfi_tclMsgDistanceUnitSet;

      case vehicle_mainfi_tclToken::EN_MSG_DISTANCEUNITSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgDistanceUnitStatus;

      case vehicle_mainfi_tclToken::EN_MSG_FUELCONSUMPTIONUNITUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgFuelConsumptionUnitUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_FUELCONSUMPTIONUNITRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgFuelConsumptionUnitRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_FUELCONSUMPTIONUNITGET:
         return OSAL_NEW vehicle_mainfi_tclMsgFuelConsumptionUnitGet;

      case vehicle_mainfi_tclToken::EN_MSG_FUELCONSUMPTIONUNITSET:
         return OSAL_NEW vehicle_mainfi_tclMsgFuelConsumptionUnitSet;

      case vehicle_mainfi_tclToken::EN_MSG_FUELCONSUMPTIONUNITSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgFuelConsumptionUnitStatus;

      case vehicle_mainfi_tclToken::EN_MSG_TEMPERATUREUNITUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgTemperatureUnitUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_TEMPERATUREUNITRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgTemperatureUnitRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_TEMPERATUREUNITGET:
         return OSAL_NEW vehicle_mainfi_tclMsgTemperatureUnitGet;

      case vehicle_mainfi_tclToken::EN_MSG_TEMPERATUREUNITSET:
         return OSAL_NEW vehicle_mainfi_tclMsgTemperatureUnitSet;

      case vehicle_mainfi_tclToken::EN_MSG_TEMPERATUREUNITSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgTemperatureUnitStatus;

      case vehicle_mainfi_tclToken::EN_MSG_LANGUAGEUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgLanguageUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_LANGUAGERELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgLanguageRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_LANGUAGEGET:
         return OSAL_NEW vehicle_mainfi_tclMsgLanguageGet;

      case vehicle_mainfi_tclToken::EN_MSG_LANGUAGESTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgLanguageStatus;

      case vehicle_mainfi_tclToken::EN_MSG_LANGUAGESYNCSOURCEUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgLanguageSyncSourceUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_LANGUAGESYNCSOURCERELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgLanguageSyncSourceRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_LANGUAGESYNCSOURCEGET:
         return OSAL_NEW vehicle_mainfi_tclMsgLanguageSyncSourceGet;

      case vehicle_mainfi_tclToken::EN_MSG_LANGUAGESYNCSOURCESET:
         return OSAL_NEW vehicle_mainfi_tclMsgLanguageSyncSourceSet;

      case vehicle_mainfi_tclToken::EN_MSG_LANGUAGESYNCSOURCESTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgLanguageSyncSourceStatus;

      case vehicle_mainfi_tclToken::EN_MSG_METERLANGUAGEKNOWLEDGEUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgMeterLanguageKnowledgeUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_METERLANGUAGEKNOWLEDGERELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgMeterLanguageKnowledgeRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_METERLANGUAGEKNOWLEDGEGET:
         return OSAL_NEW vehicle_mainfi_tclMsgMeterLanguageKnowledgeGet;

      case vehicle_mainfi_tclToken::EN_MSG_METERLANGUAGEKNOWLEDGESTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgMeterLanguageKnowledgeStatus;

      case vehicle_mainfi_tclToken::EN_MSG_HANDBRAKEUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgHandBrakeUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_HANDBRAKERELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgHandBrakeRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_HANDBRAKEGET:
         return OSAL_NEW vehicle_mainfi_tclMsgHandBrakeGet;

      case vehicle_mainfi_tclToken::EN_MSG_HANDBRAKESTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgHandBrakeStatus;

      case vehicle_mainfi_tclToken::EN_MSG_IGNITIONUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgIgnitionUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_IGNITIONRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgIgnitionRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_IGNITIONGET:
         return OSAL_NEW vehicle_mainfi_tclMsgIgnitionGet;

      case vehicle_mainfi_tclToken::EN_MSG_IGNITIONSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgIgnitionStatus;

      case vehicle_mainfi_tclToken::EN_MSG_SPEEDUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgSpeedUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_SPEEDRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgSpeedRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_SPEEDGET:
         return OSAL_NEW vehicle_mainfi_tclMsgSpeedGet;

      case vehicle_mainfi_tclToken::EN_MSG_SPEEDSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgSpeedStatus;

      case vehicle_mainfi_tclToken::EN_MSG_SPEEDLIMITUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgSpeedLimitUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_SPEEDLIMITRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgSpeedLimitRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_SPEEDLIMITGET:
         return OSAL_NEW vehicle_mainfi_tclMsgSpeedLimitGet;

      case vehicle_mainfi_tclToken::EN_MSG_SPEEDLIMITSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgSpeedLimitStatus;

      case vehicle_mainfi_tclToken::EN_MSG_REVERSEGEARUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgReverseGearUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_REVERSEGEARRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgReverseGearRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_REVERSEGEARGET:
         return OSAL_NEW vehicle_mainfi_tclMsgReverseGearGet;

      case vehicle_mainfi_tclToken::EN_MSG_REVERSEGEARSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgReverseGearStatus;

      case vehicle_mainfi_tclToken::EN_MSG_SPEEDLOCKUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgSpeedLockUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_SPEEDLOCKRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgSpeedLockRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_SPEEDLOCKGET:
         return OSAL_NEW vehicle_mainfi_tclMsgSpeedLockGet;

      case vehicle_mainfi_tclToken::EN_MSG_SPEEDLOCKSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgSpeedLockStatus;

      case vehicle_mainfi_tclToken::EN_MSG_DRIVINGSTATEUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgDrivingStateUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_DRIVINGSTATERELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgDrivingStateRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_DRIVINGSTATEGET:
         return OSAL_NEW vehicle_mainfi_tclMsgDrivingStateGet;

      case vehicle_mainfi_tclToken::EN_MSG_DRIVINGSTATESTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgDrivingStateStatus;

      case vehicle_mainfi_tclToken::EN_MSG_GLOBALVEHICLEWARNINGSTATEUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgGlobalVehicleWarningStateUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_GLOBALVEHICLEWARNINGSTATERELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgGlobalVehicleWarningStateRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_GLOBALVEHICLEWARNINGSTATEGET:
         return OSAL_NEW vehicle_mainfi_tclMsgGlobalVehicleWarningStateGet;

      case vehicle_mainfi_tclToken::EN_MSG_GLOBALVEHICLEWARNINGSTATESTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgGlobalVehicleWarningStateStatus;

      case vehicle_mainfi_tclToken::EN_MSG_VEHICLESTATESUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgVehicleStatesUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_VEHICLESTATESRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgVehicleStatesRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_VEHICLESTATESGET:
         return OSAL_NEW vehicle_mainfi_tclMsgVehicleStatesGet;

      case vehicle_mainfi_tclToken::EN_MSG_VEHICLESTATESSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgVehicleStatesStatus;

      case vehicle_mainfi_tclToken::EN_MSG_PARTIALMUTEUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgPartialMuteUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_PARTIALMUTERELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgPartialMuteRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_PARTIALMUTEGET:
         return OSAL_NEW vehicle_mainfi_tclMsgPartialMuteGet;

      case vehicle_mainfi_tclToken::EN_MSG_PARTIALMUTESTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgPartialMuteStatus;

      case vehicle_mainfi_tclToken::EN_MSG_SWIVMONAUTOOPENUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgSwivMonAutoOpenUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_SWIVMONAUTOOPENRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgSwivMonAutoOpenRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_SWIVMONAUTOOPENGET:
         return OSAL_NEW vehicle_mainfi_tclMsgSwivMonAutoOpenGet;

      case vehicle_mainfi_tclToken::EN_MSG_SWIVMONAUTOOPENSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgSwivMonAutoOpenStatus;

      case vehicle_mainfi_tclToken::EN_MSG_DATEMODEUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgDateModeUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_DATEMODERELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgDateModeRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_DATEMODEGET:
         return OSAL_NEW vehicle_mainfi_tclMsgDateModeGet;

      case vehicle_mainfi_tclToken::EN_MSG_DATEMODESTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgDateModeStatus;

      case vehicle_mainfi_tclToken::EN_MSG_TMMODEUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgTmModeUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_TMMODERELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgTmModeRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_TMMODEGET:
         return OSAL_NEW vehicle_mainfi_tclMsgTmModeGet;

      case vehicle_mainfi_tclToken::EN_MSG_TMMODESTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgTmModeStatus;

      case vehicle_mainfi_tclToken::EN_MSG_CAMTXTUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgCamTxtUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_CAMTXTRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgCamTxtRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_CAMTXTGET:
         return OSAL_NEW vehicle_mainfi_tclMsgCamTxtGet;

      case vehicle_mainfi_tclToken::EN_MSG_CAMTXTSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgCamTxtStatus;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM1UPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam1UpReg;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM1RELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam1RelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM1GET:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam1Get;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM1STATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam1Status;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM2UPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam2UpReg;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM2RELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam2RelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM2GET:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam2Get;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM2STATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam2Status;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM3UPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam3UpReg;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM3RELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam3RelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM3GET:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam3Get;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM3STATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam3Status;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM4UPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam4UpReg;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM4RELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam4RelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM4GET:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam4Get;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM4STATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam4Status;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM5UPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam5UpReg;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM5RELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam5RelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM5GET:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam5Get;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM5STATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam5Status;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM6UPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam6UpReg;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM6RELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam6RelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM6GET:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam6Get;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM6STATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam6Status;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM7UPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam7UpReg;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM7RELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam7RelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM7GET:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam7Get;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM7STATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam7Status;

      case vehicle_mainfi_tclToken::EN_MSG_DRIVERDOOROPENUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgDriverDoorOpenUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_DRIVERDOOROPENRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgDriverDoorOpenRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_DRIVERDOOROPENGET:
         return OSAL_NEW vehicle_mainfi_tclMsgDriverDoorOpenGet;

      case vehicle_mainfi_tclToken::EN_MSG_DRIVERDOOROPENSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgDriverDoorOpenStatus;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM8UPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam8UpReg;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM8RELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam8RelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM8GET:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam8Get;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM8STATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam8Status;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM9UPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam9UpReg;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM9RELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam9RelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM9GET:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam9Get;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM9STATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam9Status;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM10UPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam10UpReg;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM10RELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam10RelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM10GET:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam10Get;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM10STATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam10Status;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM11UPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam11UpReg;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM11RELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam11RelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM11GET:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam11Get;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM11STATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam11Status;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM12UPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam12UpReg;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM12RELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam12RelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM12GET:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam12Get;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM12STATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam12Status;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM13UPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam13UpReg;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM13RELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam13RelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM13GET:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam13Get;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM13STATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam13Status;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM14UPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam14UpReg;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM14RELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam14RelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM14GET:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam14Get;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM14STATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam14Status;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM15UPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam15UpReg;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM15RELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam15RelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM15GET:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam15Get;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM15STATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam15Status;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM16UPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam16UpReg;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM16RELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam16RelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM16GET:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam16Get;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM16STATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam16Status;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM17UPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam17UpReg;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM17RELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam17RelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM17GET:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam17Get;

      case vehicle_mainfi_tclToken::EN_MSG_ACTCAM17STATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgActCam17Status;

      case vehicle_mainfi_tclToken::EN_MSG_CAMSPLITQUADUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgCamSplitQuadUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_CAMSPLITQUADRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgCamSplitQuadRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_CAMSPLITQUADGET:
         return OSAL_NEW vehicle_mainfi_tclMsgCamSplitQuadGet;

      case vehicle_mainfi_tclToken::EN_MSG_CAMSPLITQUADSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgCamSplitQuadStatus;

      case vehicle_mainfi_tclToken::EN_MSG_MUTEDEVUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgMuteDevUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_MUTEDEVRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgMuteDevRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_MUTEDEVGET:
         return OSAL_NEW vehicle_mainfi_tclMsgMuteDevGet;

      case vehicle_mainfi_tclToken::EN_MSG_MUTEDEVSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgMuteDevStatus;

      case vehicle_mainfi_tclToken::EN_MSG_SYSVOLTUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgSysVoltUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_SYSVOLTRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgSysVoltRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_SYSVOLTGET:
         return OSAL_NEW vehicle_mainfi_tclMsgSysVoltGet;

      case vehicle_mainfi_tclToken::EN_MSG_SYSVOLTSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgSysVoltStatus;

      case vehicle_mainfi_tclToken::EN_MSG_PARKINGBREAKSWITCHUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgParkingBreakSwitchUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_PARKINGBREAKSWITCHRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgParkingBreakSwitchRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_PARKINGBREAKSWITCHGET:
         return OSAL_NEW vehicle_mainfi_tclMsgParkingBreakSwitchGet;

      case vehicle_mainfi_tclToken::EN_MSG_PARKINGBREAKSWITCHSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgParkingBreakSwitchStatus;

      case vehicle_mainfi_tclToken::EN_MSG_REARCAMREQUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgRearCamReqUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_REARCAMREQRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgRearCamReqRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_REARCAMREQGET:
         return OSAL_NEW vehicle_mainfi_tclMsgRearCamReqGet;

      case vehicle_mainfi_tclToken::EN_MSG_REARCAMREQSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgRearCamReqStatus;

      case vehicle_mainfi_tclToken::EN_MSG_VINUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgVINUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_VINRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgVINRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_VINGET:
         return OSAL_NEW vehicle_mainfi_tclMsgVINGet;

      case vehicle_mainfi_tclToken::EN_MSG_VINSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgVINStatus;

      case vehicle_mainfi_tclToken::EN_MSG_TIMEDATEUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgTimeDateUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_TIMEDATERELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgTimeDateRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_TIMEDATEGET:
         return OSAL_NEW vehicle_mainfi_tclMsgTimeDateGet;

      case vehicle_mainfi_tclToken::EN_MSG_TIMEDATESTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgTimeDateStatus;

      case vehicle_mainfi_tclToken::EN_MSG_PRIVACYRESETREQUESTUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgPrivacyResetRequestUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_PRIVACYRESETREQUESTRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgPrivacyResetRequestRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_PRIVACYRESETREQUESTGET:
         return OSAL_NEW vehicle_mainfi_tclMsgPrivacyResetRequestGet;

      case vehicle_mainfi_tclToken::EN_MSG_PRIVACYRESETREQUESTSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgPrivacyResetRequestStatus;

      case vehicle_mainfi_tclToken::EN_MSG_PHONECALLCOMMANDUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgPhoneCallCommandUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_PHONECALLCOMMANDRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgPhoneCallCommandRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_PHONECALLCOMMANDGET:
         return OSAL_NEW vehicle_mainfi_tclMsgPhoneCallCommandGet;

      case vehicle_mainfi_tclToken::EN_MSG_PHONECALLCOMMANDSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgPhoneCallCommandStatus;

      case vehicle_mainfi_tclToken::EN_MSG_VOLUMECOMMANDUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgVolumeCommandUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_VOLUMECOMMANDRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgVolumeCommandRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_VOLUMECOMMANDGET:
         return OSAL_NEW vehicle_mainfi_tclMsgVolumeCommandGet;

      case vehicle_mainfi_tclToken::EN_MSG_VOLUMECOMMANDSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgVolumeCommandStatus;

      case vehicle_mainfi_tclToken::EN_MSG_VOICERECGCOMMANDUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgVoiceRecgCommandUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_VOICERECGCOMMANDRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgVoiceRecgCommandRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_VOICERECGCOMMANDGET:
         return OSAL_NEW vehicle_mainfi_tclMsgVoiceRecgCommandGet;

      case vehicle_mainfi_tclToken::EN_MSG_VOICERECGCOMMANDSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgVoiceRecgCommandStatus;

      case vehicle_mainfi_tclToken::EN_MSG_DEVICEINFOSWVERSIONUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgDeviceInfoSWversionUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_DEVICEINFOSWVERSIONRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgDeviceInfoSWversionRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_DEVICEINFOSWVERSIONGET:
         return OSAL_NEW vehicle_mainfi_tclMsgDeviceInfoSWversionGet;

      case vehicle_mainfi_tclToken::EN_MSG_DEVICEINFOSWVERSIONSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgDeviceInfoSWversionStatus;

      case vehicle_mainfi_tclToken::EN_MSG_TRACKCOMMANDUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgTrackCommandUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_TRACKCOMMANDRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgTrackCommandRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_TRACKCOMMANDGET:
         return OSAL_NEW vehicle_mainfi_tclMsgTrackCommandGet;

      case vehicle_mainfi_tclToken::EN_MSG_TRACKCOMMANDSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgTrackCommandStatus;

      case vehicle_mainfi_tclToken::EN_MSG_PHONEPWRCMDUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgPhonePwrCmdUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_PHONEPWRCMDRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgPhonePwrCmdRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_PHONEPWRCMDGET:
         return OSAL_NEW vehicle_mainfi_tclMsgPhonePwrCmdGet;

      case vehicle_mainfi_tclToken::EN_MSG_PHONEPWRCMDSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgPhonePwrCmdStatus;

      case vehicle_mainfi_tclToken::EN_MSG_RADIOPWRCMDUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgRadioPwrCmdUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_RADIOPWRCMDRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgRadioPwrCmdRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_RADIOPWRCMDGET:
         return OSAL_NEW vehicle_mainfi_tclMsgRadioPwrCmdGet;

      case vehicle_mainfi_tclToken::EN_MSG_RADIOPWRCMDSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgRadioPwrCmdStatus;

      case vehicle_mainfi_tclToken::EN_MSG_RCNEXTBTNUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgRCNextBtnUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_RCNEXTBTNRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgRCNextBtnRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_RCNEXTBTNGET:
         return OSAL_NEW vehicle_mainfi_tclMsgRCNextBtnGet;

      case vehicle_mainfi_tclToken::EN_MSG_RCNEXTBTNSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgRCNextBtnStatus;

      case vehicle_mainfi_tclToken::EN_MSG_RCPREVBTNUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgRCPrevBtnUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_RCPREVBTNRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgRCPrevBtnRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_RCPREVBTNGET:
         return OSAL_NEW vehicle_mainfi_tclMsgRCPrevBtnGet;

      case vehicle_mainfi_tclToken::EN_MSG_RCPREVBTNSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgRCPrevBtnStatus;

      case vehicle_mainfi_tclToken::EN_MSG_SOURCECOMMANDUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgSourceCommandUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_SOURCECOMMANDRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgSourceCommandRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_SOURCECOMMANDGET:
         return OSAL_NEW vehicle_mainfi_tclMsgSourceCommandGet;

      case vehicle_mainfi_tclToken::EN_MSG_SOURCECOMMANDSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgSourceCommandStatus;

      case vehicle_mainfi_tclToken::EN_MSG_TUNERCOMMANDUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgTunerCommandUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_TUNERCOMMANDRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgTunerCommandRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_TUNERCOMMANDGET:
         return OSAL_NEW vehicle_mainfi_tclMsgTunerCommandGet;

      case vehicle_mainfi_tclToken::EN_MSG_TUNERCOMMANDSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgTunerCommandStatus;

      case vehicle_mainfi_tclToken::EN_MSG_TACOMMANDUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgTACommandUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_TACOMMANDRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgTACommandRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_TACOMMANDGET:
         return OSAL_NEW vehicle_mainfi_tclMsgTACommandGet;

      case vehicle_mainfi_tclToken::EN_MSG_TACOMMANDSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgTACommandStatus;

      case vehicle_mainfi_tclToken::EN_MSG_RDSCOMMANDUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgRDSCommandUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_RDSCOMMANDRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgRDSCommandRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_RDSCOMMANDGET:
         return OSAL_NEW vehicle_mainfi_tclMsgRDSCommandGet;

      case vehicle_mainfi_tclToken::EN_MSG_RDSCOMMANDSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgRDSCommandStatus;

      case vehicle_mainfi_tclToken::EN_MSG_SMARTVRUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgSMARTVRUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_SMARTVRRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgSMARTVRRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_SMARTVRGET:
         return OSAL_NEW vehicle_mainfi_tclMsgSMARTVRGet;

      case vehicle_mainfi_tclToken::EN_MSG_SMARTVRSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgSMARTVRStatus;

      case vehicle_mainfi_tclToken::EN_MSG_TOTALVEHDISTDIAGUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgTotalVehDistDiagUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_TOTALVEHDISTDIAGRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgTotalVehDistDiagRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_TOTALVEHDISTDIAGGET:
         return OSAL_NEW vehicle_mainfi_tclMsgTotalVehDistDiagGet;

      case vehicle_mainfi_tclToken::EN_MSG_TOTALVEHDISTDIAGSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgTotalVehDistDiagStatus;

      case vehicle_mainfi_tclToken::EN_MSG_VIN_64UPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgVIN_64UpReg;

      case vehicle_mainfi_tclToken::EN_MSG_VIN_64RELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgVIN_64RelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_VIN_64GET:
         return OSAL_NEW vehicle_mainfi_tclMsgVIN_64Get;

      case vehicle_mainfi_tclToken::EN_MSG_VIN_64STATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgVIN_64Status;

      case vehicle_mainfi_tclToken::EN_MSG_CABINMEDIASOURCECOMMANDUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgCabinMediaSourceCommandUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_CABINMEDIASOURCECOMMANDRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgCabinMediaSourceCommandRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_CABINMEDIASOURCECOMMANDGET:
         return OSAL_NEW vehicle_mainfi_tclMsgCabinMediaSourceCommandGet;

      case vehicle_mainfi_tclToken::EN_MSG_CABINMEDIASOURCECOMMANDSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgCabinMediaSourceCommandStatus;

      case vehicle_mainfi_tclToken::EN_MSG_CABINMEDIAVOLUMECOMMANDUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgCabinMediaVolumeCommandUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_CABINMEDIAVOLUMECOMMANDRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgCabinMediaVolumeCommandRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_CABINMEDIAVOLUMECOMMANDGET:
         return OSAL_NEW vehicle_mainfi_tclMsgCabinMediaVolumeCommandGet;

      case vehicle_mainfi_tclToken::EN_MSG_CABINMEDIAVOLUMECOMMANDSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgCabinMediaVolumeCommandStatus;

      case vehicle_mainfi_tclToken::EN_MSG_CABINMEDIATUNERCOMMANDUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgCabinMediaTunerCommandUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_CABINMEDIATUNERCOMMANDRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgCabinMediaTunerCommandRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_CABINMEDIATUNERCOMMANDGET:
         return OSAL_NEW vehicle_mainfi_tclMsgCabinMediaTunerCommandGet;

      case vehicle_mainfi_tclToken::EN_MSG_CABINMEDIATUNERCOMMANDSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgCabinMediaTunerCommandStatus;

      case vehicle_mainfi_tclToken::EN_MSG_CABINMEDIATRACKCOMMANDUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgCabinMediaTrackCommandUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_CABINMEDIATRACKCOMMANDRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgCabinMediaTrackCommandRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_CABINMEDIATRACKCOMMANDGET:
         return OSAL_NEW vehicle_mainfi_tclMsgCabinMediaTrackCommandGet;

      case vehicle_mainfi_tclToken::EN_MSG_CABINMEDIATRACKCOMMANDSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgCabinMediaTrackCommandStatus;

      case vehicle_mainfi_tclToken::EN_MSG_CABINMEDIAPLAYLISTCOMMANDUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgCabinMediaPlaylistCommandUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_CABINMEDIAPLAYLISTCOMMANDRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgCabinMediaPlaylistCommandRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_CABINMEDIAPLAYLISTCOMMANDGET:
         return OSAL_NEW vehicle_mainfi_tclMsgCabinMediaPlaylistCommandGet;

      case vehicle_mainfi_tclToken::EN_MSG_CABINMEDIAPLAYLISTCOMMANDSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgCabinMediaPlaylistCommandStatus;

      case vehicle_mainfi_tclToken::EN_MSG_NETWORKSTATEUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgNetworkStateUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_NETWORKSTATERELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgNetworkStateRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_NETWORKSTATEGET:
         return OSAL_NEW vehicle_mainfi_tclMsgNetworkStateGet;

      case vehicle_mainfi_tclToken::EN_MSG_NETWORKSTATESTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgNetworkStateStatus;

      case vehicle_mainfi_tclToken::EN_MSG_DISTANCETOTALIZERUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgDistanceTotalizerUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_DISTANCETOTALIZERRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgDistanceTotalizerRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_DISTANCETOTALIZERGET:
         return OSAL_NEW vehicle_mainfi_tclMsgDistanceTotalizerGet;

      case vehicle_mainfi_tclToken::EN_MSG_DISTANCETOTALIZERSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgDistanceTotalizerStatus;

      case vehicle_mainfi_tclToken::EN_MSG_MILEAGEUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgMileageUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_MILEAGERELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgMileageRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_MILEAGEGET:
         return OSAL_NEW vehicle_mainfi_tclMsgMileageGet;

      case vehicle_mainfi_tclToken::EN_MSG_MILEAGESTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgMileageStatus;

      case vehicle_mainfi_tclToken::EN_MSG_AVGFUELECONOMYUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgAvgFuelEconomyUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_AVGFUELECONOMYRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgAvgFuelEconomyRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_AVGFUELECONOMYGET:
         return OSAL_NEW vehicle_mainfi_tclMsgAvgFuelEconomyGet;

      case vehicle_mainfi_tclToken::EN_MSG_AVGFUELECONOMYSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgAvgFuelEconomyStatus;

      case vehicle_mainfi_tclToken::EN_MSG_TIREPRESSURESUPPORTUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgTirePressureSupportUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_TIREPRESSURESUPPORTRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgTirePressureSupportRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_TIREPRESSURESUPPORTGET:
         return OSAL_NEW vehicle_mainfi_tclMsgTirePressureSupportGet;

      case vehicle_mainfi_tclToken::EN_MSG_TIREPRESSURESUPPORTSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgTirePressureSupportStatus;

      case vehicle_mainfi_tclToken::EN_MSG_TPMSRESETSUPPORTUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgTPMSResetSupportUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_TPMSRESETSUPPORTRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgTPMSResetSupportRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_TPMSRESETSUPPORTGET:
         return OSAL_NEW vehicle_mainfi_tclMsgTPMSResetSupportGet;

      case vehicle_mainfi_tclToken::EN_MSG_TPMSRESETSUPPORTSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgTPMSResetSupportStatus;

      case vehicle_mainfi_tclToken::EN_MSG_TIREPRESSURESETTINGUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgTirePressureSettingUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_TIREPRESSURESETTINGRELUPREG:
         return OSAL_NEW vehicle_mainfi_tclMsgTirePressureSettingRelUpReg;

      case vehicle_mainfi_tclToken::EN_MSG_TIREPRESSURESETTINGGET:
         return OSAL_NEW vehicle_mainfi_tclMsgTirePressureSettingGet;

      case vehicle_mainfi_tclToken::EN_MSG_TIREPRESSURESETTINGSET:
         return OSAL_NEW vehicle_mainfi_tclMsgTirePressureSettingSet;

      case vehicle_mainfi_tclToken::EN_MSG_TIREPRESSURESETTINGSTATUS:
         return OSAL_NEW vehicle_mainfi_tclMsgTirePressureSettingStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all vehicle_mainfifi messages

// common functions

tU16 vehicle_mainfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return VEHICLE_MAINFI_C_U16_SERVICE_ID;
}

tU16 vehicle_mainfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 vehicle_mainfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& vehicle_mainfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& vehicle_mainfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 vehicle_mainfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& vehicle_mainfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& vehicle_mainfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSetLanguageMethodStart::vehicle_mainfi_tclMsgSetLanguageMethodStart(const vehicle_mainfi_tclMsgSetLanguageMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   SourceId = coRef.SourceId;
   Language = coRef.Language;
}
vehicle_mainfi_tclMsgSetLanguageMethodStart& vehicle_mainfi_tclMsgSetLanguageMethodStart::operator=(const vehicle_mainfi_tclMsgSetLanguageMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SourceId = coRef.SourceId;
   Language = coRef.Language;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgSetLanguageMethodStart::vehicle_mainfi_tclMsgSetLanguageMethodStart()
:SourceId()
,Language()
 {}

tS32 vehicle_mainfi_tclMsgSetLanguageMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SETLANGUAGEMETHODSTART;
}


vehicle_mainfi_tclMsgSetLanguageMethodStart::~vehicle_mainfi_tclMsgSetLanguageMethodStart()
{}

tU32 vehicle_mainfi_tclMsgSetLanguageMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& vehicle_mainfi_tclMsgSetLanguageMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SourceId);
   (tVoid) (oIn >> Language);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSetLanguageMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SourceId);
   (tVoid) (oOut << Language);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSetLanguageMethodStart::operator==(const vehicle_mainfi_tclMsgSetLanguageMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SourceId == roRef.SourceId);
   bResult = bResult && (Language == roRef.Language);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSetLanguageMethodResult::vehicle_mainfi_tclMsgSetLanguageMethodResult(const vehicle_mainfi_tclMsgSetLanguageMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgSetLanguageMethodResult& vehicle_mainfi_tclMsgSetLanguageMethodResult::operator=(const vehicle_mainfi_tclMsgSetLanguageMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgSetLanguageMethodResult::vehicle_mainfi_tclMsgSetLanguageMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgSetLanguageMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SETLANGUAGEMETHODRESULT;
}


vehicle_mainfi_tclMsgSetLanguageMethodResult::~vehicle_mainfi_tclMsgSetLanguageMethodResult()
{}

tU32 vehicle_mainfi_tclMsgSetLanguageMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgSetLanguageMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSetLanguageMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSetLanguageMethodResult::operator==(const vehicle_mainfi_tclMsgSetLanguageMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodStart::vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodStart(const vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   RequestId = coRef.RequestId;
}
vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodStart& vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodStart::operator=(const vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RequestId = coRef.RequestId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodStart::vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodStart()
:RequestId()
 {}

tS32 vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_REQUESTMETERLANGUAGESYNCMETHODSTART;
}


vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodStart::~vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodStart()
{}

tU32 vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RequestId);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RequestId);
   return oOut;
}

tBool vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodStart::operator==(const vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RequestId == roRef.RequestId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodResult::vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodResult(const vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodResult& vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodResult::operator=(const vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodResult::vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_REQUESTMETERLANGUAGESYNCMETHODRESULT;
}


vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodResult::~vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodResult()
{}

tU32 vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodResult::operator==(const vehicle_mainfi_tclMsgRequestMeterLanguageSyncMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodStart::vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodStart(const vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   BTLinkStatus = coRef.BTLinkStatus;
}
vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodStart& vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodStart::operator=(const vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   BTLinkStatus = coRef.BTLinkStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodStart::vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodStart()
:BTLinkStatus(0)
 {}

tS32 vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_PHONEBTLINKSTATUSMETHODSTART;
}


vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodStart::~vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodStart()
{}

tU32 vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BTLinkStatus);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BTLinkStatus);
   return oOut;
}

tBool vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodStart::operator==(const vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BTLinkStatus == roRef.BTLinkStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodResult::vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodResult(const vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodResult& vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodResult::operator=(const vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodResult::vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_PHONEBTLINKSTATUSMETHODRESULT;
}


vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodResult::~vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodResult()
{}

tU32 vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodResult::operator==(const vehicle_mainfi_tclMsgPhoneBTLinkStatusMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodStart::vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodStart(const vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   PhoneBookSyncStatusValue = coRef.PhoneBookSyncStatusValue;
}
vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodStart& vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodStart::operator=(const vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   PhoneBookSyncStatusValue = coRef.PhoneBookSyncStatusValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodStart::vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodStart()
:PhoneBookSyncStatusValue(0)
 {}

tS32 vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_PHONEBOOKSYNCSTATUSMETHODSTART;
}


vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodStart::~vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodStart()
{}

tU32 vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PhoneBookSyncStatusValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PhoneBookSyncStatusValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodStart::operator==(const vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PhoneBookSyncStatusValue == roRef.PhoneBookSyncStatusValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodResult::vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodResult(const vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodResult& vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodResult::operator=(const vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodResult::vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_PHONEBOOKSYNCSTATUSMETHODRESULT;
}


vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodResult::~vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodResult()
{}

tU32 vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodResult::operator==(const vehicle_mainfi_tclMsgPhoneBookSyncstatusMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCallHistorySyncStatusMethodStart::vehicle_mainfi_tclMsgCallHistorySyncStatusMethodStart(const vehicle_mainfi_tclMsgCallHistorySyncStatusMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   CallHistorySyncStatusValue = coRef.CallHistorySyncStatusValue;
}
vehicle_mainfi_tclMsgCallHistorySyncStatusMethodStart& vehicle_mainfi_tclMsgCallHistorySyncStatusMethodStart::operator=(const vehicle_mainfi_tclMsgCallHistorySyncStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   CallHistorySyncStatusValue = coRef.CallHistorySyncStatusValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCallHistorySyncStatusMethodStart::vehicle_mainfi_tclMsgCallHistorySyncStatusMethodStart()
:CallHistorySyncStatusValue(0)
 {}

tS32 vehicle_mainfi_tclMsgCallHistorySyncStatusMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CALLHISTORYSYNCSTATUSMETHODSTART;
}


vehicle_mainfi_tclMsgCallHistorySyncStatusMethodStart::~vehicle_mainfi_tclMsgCallHistorySyncStatusMethodStart()
{}

tU32 vehicle_mainfi_tclMsgCallHistorySyncStatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCallHistorySyncStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CallHistorySyncStatusValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCallHistorySyncStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CallHistorySyncStatusValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCallHistorySyncStatusMethodStart::operator==(const vehicle_mainfi_tclMsgCallHistorySyncStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CallHistorySyncStatusValue == roRef.CallHistorySyncStatusValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCallHistorySyncStatusMethodResult::vehicle_mainfi_tclMsgCallHistorySyncStatusMethodResult(const vehicle_mainfi_tclMsgCallHistorySyncStatusMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgCallHistorySyncStatusMethodResult& vehicle_mainfi_tclMsgCallHistorySyncStatusMethodResult::operator=(const vehicle_mainfi_tclMsgCallHistorySyncStatusMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCallHistorySyncStatusMethodResult::vehicle_mainfi_tclMsgCallHistorySyncStatusMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgCallHistorySyncStatusMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CALLHISTORYSYNCSTATUSMETHODRESULT;
}


vehicle_mainfi_tclMsgCallHistorySyncStatusMethodResult::~vehicle_mainfi_tclMsgCallHistorySyncStatusMethodResult()
{}

tU32 vehicle_mainfi_tclMsgCallHistorySyncStatusMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCallHistorySyncStatusMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCallHistorySyncStatusMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCallHistorySyncStatusMethodResult::operator==(const vehicle_mainfi_tclMsgCallHistorySyncStatusMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgPhoneStatusRoamingMethodStart::vehicle_mainfi_tclMsgPhoneStatusRoamingMethodStart(const vehicle_mainfi_tclMsgPhoneStatusRoamingMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   PhoneStatusRoamingValue = coRef.PhoneStatusRoamingValue;
}
vehicle_mainfi_tclMsgPhoneStatusRoamingMethodStart& vehicle_mainfi_tclMsgPhoneStatusRoamingMethodStart::operator=(const vehicle_mainfi_tclMsgPhoneStatusRoamingMethodStart& coRef)
{
   if (this == &coRef) return *this;
   PhoneStatusRoamingValue = coRef.PhoneStatusRoamingValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgPhoneStatusRoamingMethodStart::vehicle_mainfi_tclMsgPhoneStatusRoamingMethodStart()
:PhoneStatusRoamingValue(0)
 {}

tS32 vehicle_mainfi_tclMsgPhoneStatusRoamingMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_PHONESTATUSROAMINGMETHODSTART;
}


vehicle_mainfi_tclMsgPhoneStatusRoamingMethodStart::~vehicle_mainfi_tclMsgPhoneStatusRoamingMethodStart()
{}

tU32 vehicle_mainfi_tclMsgPhoneStatusRoamingMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgPhoneStatusRoamingMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PhoneStatusRoamingValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgPhoneStatusRoamingMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PhoneStatusRoamingValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgPhoneStatusRoamingMethodStart::operator==(const vehicle_mainfi_tclMsgPhoneStatusRoamingMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PhoneStatusRoamingValue == roRef.PhoneStatusRoamingValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgPhoneStatusRoamingMethodResult::vehicle_mainfi_tclMsgPhoneStatusRoamingMethodResult(const vehicle_mainfi_tclMsgPhoneStatusRoamingMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgPhoneStatusRoamingMethodResult& vehicle_mainfi_tclMsgPhoneStatusRoamingMethodResult::operator=(const vehicle_mainfi_tclMsgPhoneStatusRoamingMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgPhoneStatusRoamingMethodResult::vehicle_mainfi_tclMsgPhoneStatusRoamingMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgPhoneStatusRoamingMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_PHONESTATUSROAMINGMETHODRESULT;
}


vehicle_mainfi_tclMsgPhoneStatusRoamingMethodResult::~vehicle_mainfi_tclMsgPhoneStatusRoamingMethodResult()
{}

tU32 vehicle_mainfi_tclMsgPhoneStatusRoamingMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgPhoneStatusRoamingMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgPhoneStatusRoamingMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgPhoneStatusRoamingMethodResult::operator==(const vehicle_mainfi_tclMsgPhoneStatusRoamingMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCallDurationMethodStart::vehicle_mainfi_tclMsgCallDurationMethodStart(const vehicle_mainfi_tclMsgCallDurationMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   CallDurationValue = coRef.CallDurationValue;
}
vehicle_mainfi_tclMsgCallDurationMethodStart& vehicle_mainfi_tclMsgCallDurationMethodStart::operator=(const vehicle_mainfi_tclMsgCallDurationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   CallDurationValue = coRef.CallDurationValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCallDurationMethodStart::vehicle_mainfi_tclMsgCallDurationMethodStart()
:CallDurationValue(0)
 {}

tS32 vehicle_mainfi_tclMsgCallDurationMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CALLDURATIONMETHODSTART;
}


vehicle_mainfi_tclMsgCallDurationMethodStart::~vehicle_mainfi_tclMsgCallDurationMethodStart()
{}

tU32 vehicle_mainfi_tclMsgCallDurationMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& vehicle_mainfi_tclMsgCallDurationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CallDurationValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCallDurationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CallDurationValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCallDurationMethodStart::operator==(const vehicle_mainfi_tclMsgCallDurationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CallDurationValue == roRef.CallDurationValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCallDurationMethodResult::vehicle_mainfi_tclMsgCallDurationMethodResult(const vehicle_mainfi_tclMsgCallDurationMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgCallDurationMethodResult& vehicle_mainfi_tclMsgCallDurationMethodResult::operator=(const vehicle_mainfi_tclMsgCallDurationMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCallDurationMethodResult::vehicle_mainfi_tclMsgCallDurationMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgCallDurationMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CALLDURATIONMETHODRESULT;
}


vehicle_mainfi_tclMsgCallDurationMethodResult::~vehicle_mainfi_tclMsgCallDurationMethodResult()
{}

tU32 vehicle_mainfi_tclMsgCallDurationMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCallDurationMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCallDurationMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCallDurationMethodResult::operator==(const vehicle_mainfi_tclMsgCallDurationMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgGSMSignalStrengthMethodStart::vehicle_mainfi_tclMsgGSMSignalStrengthMethodStart(const vehicle_mainfi_tclMsgGSMSignalStrengthMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   GSMSignalStrengthValue = coRef.GSMSignalStrengthValue;
}
vehicle_mainfi_tclMsgGSMSignalStrengthMethodStart& vehicle_mainfi_tclMsgGSMSignalStrengthMethodStart::operator=(const vehicle_mainfi_tclMsgGSMSignalStrengthMethodStart& coRef)
{
   if (this == &coRef) return *this;
   GSMSignalStrengthValue = coRef.GSMSignalStrengthValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgGSMSignalStrengthMethodStart::vehicle_mainfi_tclMsgGSMSignalStrengthMethodStart()
:GSMSignalStrengthValue(0)
 {}

tS32 vehicle_mainfi_tclMsgGSMSignalStrengthMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_GSMSIGNALSTRENGTHMETHODSTART;
}


vehicle_mainfi_tclMsgGSMSignalStrengthMethodStart::~vehicle_mainfi_tclMsgGSMSignalStrengthMethodStart()
{}

tU32 vehicle_mainfi_tclMsgGSMSignalStrengthMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgGSMSignalStrengthMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GSMSignalStrengthValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgGSMSignalStrengthMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GSMSignalStrengthValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgGSMSignalStrengthMethodStart::operator==(const vehicle_mainfi_tclMsgGSMSignalStrengthMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GSMSignalStrengthValue == roRef.GSMSignalStrengthValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgGSMSignalStrengthMethodResult::vehicle_mainfi_tclMsgGSMSignalStrengthMethodResult(const vehicle_mainfi_tclMsgGSMSignalStrengthMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgGSMSignalStrengthMethodResult& vehicle_mainfi_tclMsgGSMSignalStrengthMethodResult::operator=(const vehicle_mainfi_tclMsgGSMSignalStrengthMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgGSMSignalStrengthMethodResult::vehicle_mainfi_tclMsgGSMSignalStrengthMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgGSMSignalStrengthMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_GSMSIGNALSTRENGTHMETHODRESULT;
}


vehicle_mainfi_tclMsgGSMSignalStrengthMethodResult::~vehicle_mainfi_tclMsgGSMSignalStrengthMethodResult()
{}

tU32 vehicle_mainfi_tclMsgGSMSignalStrengthMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgGSMSignalStrengthMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgGSMSignalStrengthMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgGSMSignalStrengthMethodResult::operator==(const vehicle_mainfi_tclMsgGSMSignalStrengthMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgPhoneAvailableStatusMethodStart::vehicle_mainfi_tclMsgPhoneAvailableStatusMethodStart(const vehicle_mainfi_tclMsgPhoneAvailableStatusMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   PhoneAvailableStatusValue = coRef.PhoneAvailableStatusValue;
}
vehicle_mainfi_tclMsgPhoneAvailableStatusMethodStart& vehicle_mainfi_tclMsgPhoneAvailableStatusMethodStart::operator=(const vehicle_mainfi_tclMsgPhoneAvailableStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   PhoneAvailableStatusValue = coRef.PhoneAvailableStatusValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgPhoneAvailableStatusMethodStart::vehicle_mainfi_tclMsgPhoneAvailableStatusMethodStart()
:PhoneAvailableStatusValue(0)
 {}

tS32 vehicle_mainfi_tclMsgPhoneAvailableStatusMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_PHONEAVAILABLESTATUSMETHODSTART;
}


vehicle_mainfi_tclMsgPhoneAvailableStatusMethodStart::~vehicle_mainfi_tclMsgPhoneAvailableStatusMethodStart()
{}

tU32 vehicle_mainfi_tclMsgPhoneAvailableStatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgPhoneAvailableStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PhoneAvailableStatusValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgPhoneAvailableStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PhoneAvailableStatusValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgPhoneAvailableStatusMethodStart::operator==(const vehicle_mainfi_tclMsgPhoneAvailableStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PhoneAvailableStatusValue == roRef.PhoneAvailableStatusValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgPhoneAvailableStatusMethodResult::vehicle_mainfi_tclMsgPhoneAvailableStatusMethodResult(const vehicle_mainfi_tclMsgPhoneAvailableStatusMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgPhoneAvailableStatusMethodResult& vehicle_mainfi_tclMsgPhoneAvailableStatusMethodResult::operator=(const vehicle_mainfi_tclMsgPhoneAvailableStatusMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgPhoneAvailableStatusMethodResult::vehicle_mainfi_tclMsgPhoneAvailableStatusMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgPhoneAvailableStatusMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_PHONEAVAILABLESTATUSMETHODRESULT;
}


vehicle_mainfi_tclMsgPhoneAvailableStatusMethodResult::~vehicle_mainfi_tclMsgPhoneAvailableStatusMethodResult()
{}

tU32 vehicle_mainfi_tclMsgPhoneAvailableStatusMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgPhoneAvailableStatusMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgPhoneAvailableStatusMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgPhoneAvailableStatusMethodResult::operator==(const vehicle_mainfi_tclMsgPhoneAvailableStatusMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgPhoneCallStatusMethodStart::vehicle_mainfi_tclMsgPhoneCallStatusMethodStart(const vehicle_mainfi_tclMsgPhoneCallStatusMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   CallStatusValue = coRef.CallStatusValue;
}
vehicle_mainfi_tclMsgPhoneCallStatusMethodStart& vehicle_mainfi_tclMsgPhoneCallStatusMethodStart::operator=(const vehicle_mainfi_tclMsgPhoneCallStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   CallStatusValue = coRef.CallStatusValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgPhoneCallStatusMethodStart::vehicle_mainfi_tclMsgPhoneCallStatusMethodStart()
:CallStatusValue(0)
 {}

tS32 vehicle_mainfi_tclMsgPhoneCallStatusMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_PHONECALLSTATUSMETHODSTART;
}


vehicle_mainfi_tclMsgPhoneCallStatusMethodStart::~vehicle_mainfi_tclMsgPhoneCallStatusMethodStart()
{}

tU32 vehicle_mainfi_tclMsgPhoneCallStatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgPhoneCallStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CallStatusValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgPhoneCallStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CallStatusValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgPhoneCallStatusMethodStart::operator==(const vehicle_mainfi_tclMsgPhoneCallStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CallStatusValue == roRef.CallStatusValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgPhoneCallStatusMethodResult::vehicle_mainfi_tclMsgPhoneCallStatusMethodResult(const vehicle_mainfi_tclMsgPhoneCallStatusMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgPhoneCallStatusMethodResult& vehicle_mainfi_tclMsgPhoneCallStatusMethodResult::operator=(const vehicle_mainfi_tclMsgPhoneCallStatusMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgPhoneCallStatusMethodResult::vehicle_mainfi_tclMsgPhoneCallStatusMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgPhoneCallStatusMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_PHONECALLSTATUSMETHODRESULT;
}


vehicle_mainfi_tclMsgPhoneCallStatusMethodResult::~vehicle_mainfi_tclMsgPhoneCallStatusMethodResult()
{}

tU32 vehicle_mainfi_tclMsgPhoneCallStatusMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgPhoneCallStatusMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgPhoneCallStatusMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgPhoneCallStatusMethodResult::operator==(const vehicle_mainfi_tclMsgPhoneCallStatusMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodStart::vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodStart(const vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   PhoneBatteryLevelStatusValue = coRef.PhoneBatteryLevelStatusValue;
}
vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodStart& vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodStart::operator=(const vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   PhoneBatteryLevelStatusValue = coRef.PhoneBatteryLevelStatusValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodStart::vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodStart()
:PhoneBatteryLevelStatusValue(0)
 {}

tS32 vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_PHONEBATTERYLEVELSTATUSMETHODSTART;
}


vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodStart::~vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodStart()
{}

tU32 vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PhoneBatteryLevelStatusValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PhoneBatteryLevelStatusValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodStart::operator==(const vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PhoneBatteryLevelStatusValue == roRef.PhoneBatteryLevelStatusValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodResult::vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodResult(const vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodResult& vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodResult::operator=(const vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodResult::vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_PHONEBATTERYLEVELSTATUSMETHODRESULT;
}


vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodResult::~vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodResult()
{}

tU32 vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodResult::operator==(const vehicle_mainfi_tclMsgPhoneBatteryLevelStatusMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgPhoneVRAvailableMethodStart::vehicle_mainfi_tclMsgPhoneVRAvailableMethodStart(const vehicle_mainfi_tclMsgPhoneVRAvailableMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   PhoneVRAvailableValue = coRef.PhoneVRAvailableValue;
}
vehicle_mainfi_tclMsgPhoneVRAvailableMethodStart& vehicle_mainfi_tclMsgPhoneVRAvailableMethodStart::operator=(const vehicle_mainfi_tclMsgPhoneVRAvailableMethodStart& coRef)
{
   if (this == &coRef) return *this;
   PhoneVRAvailableValue = coRef.PhoneVRAvailableValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgPhoneVRAvailableMethodStart::vehicle_mainfi_tclMsgPhoneVRAvailableMethodStart()
:PhoneVRAvailableValue(0)
 {}

tS32 vehicle_mainfi_tclMsgPhoneVRAvailableMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_PHONEVRAVAILABLEMETHODSTART;
}


vehicle_mainfi_tclMsgPhoneVRAvailableMethodStart::~vehicle_mainfi_tclMsgPhoneVRAvailableMethodStart()
{}

tU32 vehicle_mainfi_tclMsgPhoneVRAvailableMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgPhoneVRAvailableMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PhoneVRAvailableValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgPhoneVRAvailableMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PhoneVRAvailableValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgPhoneVRAvailableMethodStart::operator==(const vehicle_mainfi_tclMsgPhoneVRAvailableMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PhoneVRAvailableValue == roRef.PhoneVRAvailableValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgPhoneVRAvailableMethodResult::vehicle_mainfi_tclMsgPhoneVRAvailableMethodResult(const vehicle_mainfi_tclMsgPhoneVRAvailableMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgPhoneVRAvailableMethodResult& vehicle_mainfi_tclMsgPhoneVRAvailableMethodResult::operator=(const vehicle_mainfi_tclMsgPhoneVRAvailableMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgPhoneVRAvailableMethodResult::vehicle_mainfi_tclMsgPhoneVRAvailableMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgPhoneVRAvailableMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_PHONEVRAVAILABLEMETHODRESULT;
}


vehicle_mainfi_tclMsgPhoneVRAvailableMethodResult::~vehicle_mainfi_tclMsgPhoneVRAvailableMethodResult()
{}

tU32 vehicle_mainfi_tclMsgPhoneVRAvailableMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgPhoneVRAvailableMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgPhoneVRAvailableMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgPhoneVRAvailableMethodResult::operator==(const vehicle_mainfi_tclMsgPhoneVRAvailableMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodStart::vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodStart(const vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   DeviceStatusWifiStatus = coRef.DeviceStatusWifiStatus;
}
vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodStart& vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodStart::operator=(const vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceStatusWifiStatus = coRef.DeviceStatusWifiStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodStart::vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodStart()
:DeviceStatusWifiStatus(0)
 {}

tS32 vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSWIFIAVAILABLEMETHODSTART;
}


vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodStart::~vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodStart()
{}

tU32 vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceStatusWifiStatus);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceStatusWifiStatus);
   return oOut;
}

tBool vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodStart::operator==(const vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceStatusWifiStatus == roRef.DeviceStatusWifiStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodResult::vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodResult(const vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodResult& vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodResult::operator=(const vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodResult::vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSWIFIAVAILABLEMETHODRESULT;
}


vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodResult::~vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodResult()
{}

tU32 vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodResult::operator==(const vehicle_mainfi_tclMsgDeviceStatusWifiAvailableMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodStart::vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodStart(const vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   DeviceStatusBTStatusValue = coRef.DeviceStatusBTStatusValue;
}
vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodStart& vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodStart::operator=(const vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceStatusBTStatusValue = coRef.DeviceStatusBTStatusValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodStart::vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodStart()
:DeviceStatusBTStatusValue(0)
 {}

tS32 vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSBTSTATUSMETHODSTART;
}


vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodStart::~vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodStart()
{}

tU32 vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceStatusBTStatusValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceStatusBTStatusValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodStart::operator==(const vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceStatusBTStatusValue == roRef.DeviceStatusBTStatusValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodResult::vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodResult(const vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodResult& vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodResult::operator=(const vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodResult::vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSBTSTATUSMETHODRESULT;
}


vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodResult::~vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodResult()
{}

tU32 vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodResult::operator==(const vehicle_mainfi_tclMsgDeviceStatusBTStatusMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodStart::vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodStart(const vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   DeviceStatusDABAvailStatusValue = coRef.DeviceStatusDABAvailStatusValue;
}
vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodStart& vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodStart::operator=(const vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceStatusDABAvailStatusValue = coRef.DeviceStatusDABAvailStatusValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodStart::vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodStart()
:DeviceStatusDABAvailStatusValue(0)
 {}

tS32 vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSDABAVAILSTATUSMETHODSTART;
}


vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodStart::~vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodStart()
{}

tU32 vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceStatusDABAvailStatusValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceStatusDABAvailStatusValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodStart::operator==(const vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceStatusDABAvailStatusValue == roRef.DeviceStatusDABAvailStatusValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodResult::vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodResult(const vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodResult& vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodResult::operator=(const vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodResult::vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSDABAVAILSTATUSMETHODRESULT;
}


vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodResult::~vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodResult()
{}

tU32 vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodResult::operator==(const vehicle_mainfi_tclMsgDeviceStatusDABAvailStatusMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodStart::vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodStart(const vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   DeviceStatusRadioStatusValue = coRef.DeviceStatusRadioStatusValue;
}
vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodStart& vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodStart::operator=(const vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceStatusRadioStatusValue = coRef.DeviceStatusRadioStatusValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodStart::vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodStart()
:DeviceStatusRadioStatusValue(0)
 {}

tS32 vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSRADIOSTATUSMETHODSTART;
}


vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodStart::~vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodStart()
{}

tU32 vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceStatusRadioStatusValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceStatusRadioStatusValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodStart::operator==(const vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceStatusRadioStatusValue == roRef.DeviceStatusRadioStatusValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodResult::vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodResult(const vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodResult& vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodResult::operator=(const vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodResult::vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSRADIOSTATUSMETHODRESULT;
}


vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodResult::~vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodResult()
{}

tU32 vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodResult::operator==(const vehicle_mainfi_tclMsgDeviceStatusRadioStatusMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgDeviceStatusNavDataMethodStart::vehicle_mainfi_tclMsgDeviceStatusNavDataMethodStart(const vehicle_mainfi_tclMsgDeviceStatusNavDataMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   DeviceStatusNavDataValue = coRef.DeviceStatusNavDataValue;
}
vehicle_mainfi_tclMsgDeviceStatusNavDataMethodStart& vehicle_mainfi_tclMsgDeviceStatusNavDataMethodStart::operator=(const vehicle_mainfi_tclMsgDeviceStatusNavDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceStatusNavDataValue = coRef.DeviceStatusNavDataValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgDeviceStatusNavDataMethodStart::vehicle_mainfi_tclMsgDeviceStatusNavDataMethodStart()
:DeviceStatusNavDataValue(0)
 {}

tS32 vehicle_mainfi_tclMsgDeviceStatusNavDataMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSNAVDATAMETHODSTART;
}


vehicle_mainfi_tclMsgDeviceStatusNavDataMethodStart::~vehicle_mainfi_tclMsgDeviceStatusNavDataMethodStart()
{}

tU32 vehicle_mainfi_tclMsgDeviceStatusNavDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgDeviceStatusNavDataMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceStatusNavDataValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgDeviceStatusNavDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceStatusNavDataValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgDeviceStatusNavDataMethodStart::operator==(const vehicle_mainfi_tclMsgDeviceStatusNavDataMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceStatusNavDataValue == roRef.DeviceStatusNavDataValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgDeviceStatusNavDataMethodResult::vehicle_mainfi_tclMsgDeviceStatusNavDataMethodResult(const vehicle_mainfi_tclMsgDeviceStatusNavDataMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgDeviceStatusNavDataMethodResult& vehicle_mainfi_tclMsgDeviceStatusNavDataMethodResult::operator=(const vehicle_mainfi_tclMsgDeviceStatusNavDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgDeviceStatusNavDataMethodResult::vehicle_mainfi_tclMsgDeviceStatusNavDataMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgDeviceStatusNavDataMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSNAVDATAMETHODRESULT;
}


vehicle_mainfi_tclMsgDeviceStatusNavDataMethodResult::~vehicle_mainfi_tclMsgDeviceStatusNavDataMethodResult()
{}

tU32 vehicle_mainfi_tclMsgDeviceStatusNavDataMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgDeviceStatusNavDataMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgDeviceStatusNavDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgDeviceStatusNavDataMethodResult::operator==(const vehicle_mainfi_tclMsgDeviceStatusNavDataMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodStart::vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodStart(const vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   DeviceStatusUSB1PresentValue = coRef.DeviceStatusUSB1PresentValue;
}
vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodStart& vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodStart::operator=(const vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceStatusUSB1PresentValue = coRef.DeviceStatusUSB1PresentValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodStart::vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodStart()
:DeviceStatusUSB1PresentValue(0)
 {}

tS32 vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSUSB1PRESENTMETHODSTART;
}


vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodStart::~vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodStart()
{}

tU32 vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceStatusUSB1PresentValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceStatusUSB1PresentValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodStart::operator==(const vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceStatusUSB1PresentValue == roRef.DeviceStatusUSB1PresentValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodResult::vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodResult(const vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodResult& vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodResult::operator=(const vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodResult::vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSUSB1PRESENTMETHODRESULT;
}


vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodResult::~vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodResult()
{}

tU32 vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodResult::operator==(const vehicle_mainfi_tclMsgDeviceStatusUSB1PresentMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodStart::vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodStart(const vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   DeviceStatusUSB2PresentValue = coRef.DeviceStatusUSB2PresentValue;
}
vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodStart& vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodStart::operator=(const vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceStatusUSB2PresentValue = coRef.DeviceStatusUSB2PresentValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodStart::vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodStart()
:DeviceStatusUSB2PresentValue(0)
 {}

tS32 vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSUSB2PRESENTMETHODSTART;
}


vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodStart::~vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodStart()
{}

tU32 vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceStatusUSB2PresentValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceStatusUSB2PresentValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodStart::operator==(const vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceStatusUSB2PresentValue == roRef.DeviceStatusUSB2PresentValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodResult::vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodResult(const vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodResult& vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodResult::operator=(const vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodResult::vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSUSB2PRESENTMETHODRESULT;
}


vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodResult::~vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodResult()
{}

tU32 vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodResult::operator==(const vehicle_mainfi_tclMsgDeviceStatusUSB2PresentMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodStart::vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodStart(const vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   DeviceStatusNaviAvailValue = coRef.DeviceStatusNaviAvailValue;
}
vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodStart& vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodStart::operator=(const vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceStatusNaviAvailValue = coRef.DeviceStatusNaviAvailValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodStart::vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodStart()
:DeviceStatusNaviAvailValue(0)
 {}

tS32 vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSNAVIAVAILMETHODSTART;
}


vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodStart::~vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodStart()
{}

tU32 vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceStatusNaviAvailValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceStatusNaviAvailValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodStart::operator==(const vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceStatusNaviAvailValue == roRef.DeviceStatusNaviAvailValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodResult::vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodResult(const vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodResult& vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodResult::operator=(const vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodResult::vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSNAVIAVAILMETHODRESULT;
}


vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodResult::~vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodResult()
{}

tU32 vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodResult::operator==(const vehicle_mainfi_tclMsgDeviceStatusNaviAvailMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodStart::vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodStart(const vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   DeviceStatusUSB1SrcValue = coRef.DeviceStatusUSB1SrcValue;
}
vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodStart& vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodStart::operator=(const vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceStatusUSB1SrcValue = coRef.DeviceStatusUSB1SrcValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodStart::vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodStart()
:DeviceStatusUSB1SrcValue(0)
 {}

tS32 vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSUSB1SRCMETHODSTART;
}


vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodStart::~vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodStart()
{}

tU32 vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceStatusUSB1SrcValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceStatusUSB1SrcValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodStart::operator==(const vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceStatusUSB1SrcValue == roRef.DeviceStatusUSB1SrcValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodResult::vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodResult(const vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodResult& vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodResult::operator=(const vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodResult::vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSUSB1SRCMETHODRESULT;
}


vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodResult::~vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodResult()
{}

tU32 vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodResult::operator==(const vehicle_mainfi_tclMsgDeviceStatusUSB1SrcMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodStart::vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodStart(const vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   DeviceStatusUSB2SrcValue = coRef.DeviceStatusUSB2SrcValue;
}
vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodStart& vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodStart::operator=(const vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceStatusUSB2SrcValue = coRef.DeviceStatusUSB2SrcValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodStart::vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodStart()
:DeviceStatusUSB2SrcValue(0)
 {}

tS32 vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSUSB2SRCMETHODSTART;
}


vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodStart::~vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodStart()
{}

tU32 vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceStatusUSB2SrcValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceStatusUSB2SrcValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodStart::operator==(const vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceStatusUSB2SrcValue == roRef.DeviceStatusUSB2SrcValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodResult::vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodResult(const vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodResult& vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodResult::operator=(const vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodResult::vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSUSB2SRCMETHODRESULT;
}


vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodResult::~vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodResult()
{}

tU32 vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodResult::operator==(const vehicle_mainfi_tclMsgDeviceStatusUSB2SrcMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodStart::vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodStart(const vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   DeviceStatusAMFMAvailValue = coRef.DeviceStatusAMFMAvailValue;
}
vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodStart& vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodStart::operator=(const vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceStatusAMFMAvailValue = coRef.DeviceStatusAMFMAvailValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodStart::vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodStart()
:DeviceStatusAMFMAvailValue(0)
 {}

tS32 vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSAMFMAVAILMETHODSTART;
}


vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodStart::~vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodStart()
{}

tU32 vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceStatusAMFMAvailValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceStatusAMFMAvailValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodStart::operator==(const vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceStatusAMFMAvailValue == roRef.DeviceStatusAMFMAvailValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodResult::vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodResult(const vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodResult& vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodResult::operator=(const vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodResult::vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSAMFMAVAILMETHODRESULT;
}


vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodResult::~vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodResult()
{}

tU32 vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodResult::operator==(const vehicle_mainfi_tclMsgDeviceStatusAMFMAvailMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodStart::vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodStart(const vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   DeviceStatusBluetoothAvailValue = coRef.DeviceStatusBluetoothAvailValue;
}
vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodStart& vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodStart::operator=(const vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceStatusBluetoothAvailValue = coRef.DeviceStatusBluetoothAvailValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodStart::vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodStart()
:DeviceStatusBluetoothAvailValue(0)
 {}

tS32 vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSBLUETOOTHAVAILMETHODSTART;
}


vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodStart::~vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodStart()
{}

tU32 vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceStatusBluetoothAvailValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceStatusBluetoothAvailValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodStart::operator==(const vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceStatusBluetoothAvailValue == roRef.DeviceStatusBluetoothAvailValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodResult::vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodResult(const vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodResult& vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodResult::operator=(const vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodResult::vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DEVICESTATUSBLUETOOTHAVAILMETHODRESULT;
}


vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodResult::~vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodResult()
{}

tU32 vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodResult::operator==(const vehicle_mainfi_tclMsgDeviceStatusBluetoothAvailMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgReq_DeviceInfoMethodStart::vehicle_mainfi_tclMsgReq_DeviceInfoMethodStart(const vehicle_mainfi_tclMsgReq_DeviceInfoMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Req_DeviceInfoValue = coRef.Req_DeviceInfoValue;
}
vehicle_mainfi_tclMsgReq_DeviceInfoMethodStart& vehicle_mainfi_tclMsgReq_DeviceInfoMethodStart::operator=(const vehicle_mainfi_tclMsgReq_DeviceInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Req_DeviceInfoValue = coRef.Req_DeviceInfoValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgReq_DeviceInfoMethodStart::vehicle_mainfi_tclMsgReq_DeviceInfoMethodStart()
:Req_DeviceInfoValue(0)
 {}

tS32 vehicle_mainfi_tclMsgReq_DeviceInfoMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_REQ_DEVICEINFOMETHODSTART;
}


vehicle_mainfi_tclMsgReq_DeviceInfoMethodStart::~vehicle_mainfi_tclMsgReq_DeviceInfoMethodStart()
{}

tU32 vehicle_mainfi_tclMsgReq_DeviceInfoMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgReq_DeviceInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Req_DeviceInfoValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgReq_DeviceInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Req_DeviceInfoValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgReq_DeviceInfoMethodStart::operator==(const vehicle_mainfi_tclMsgReq_DeviceInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Req_DeviceInfoValue == roRef.Req_DeviceInfoValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgReq_DeviceInfoMethodResult::vehicle_mainfi_tclMsgReq_DeviceInfoMethodResult(const vehicle_mainfi_tclMsgReq_DeviceInfoMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgReq_DeviceInfoMethodResult& vehicle_mainfi_tclMsgReq_DeviceInfoMethodResult::operator=(const vehicle_mainfi_tclMsgReq_DeviceInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgReq_DeviceInfoMethodResult::vehicle_mainfi_tclMsgReq_DeviceInfoMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgReq_DeviceInfoMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_REQ_DEVICEINFOMETHODRESULT;
}


vehicle_mainfi_tclMsgReq_DeviceInfoMethodResult::~vehicle_mainfi_tclMsgReq_DeviceInfoMethodResult()
{}

tU32 vehicle_mainfi_tclMsgReq_DeviceInfoMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgReq_DeviceInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgReq_DeviceInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgReq_DeviceInfoMethodResult::operator==(const vehicle_mainfi_tclMsgReq_DeviceInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgHUS_DM1_StatusMethodStart::vehicle_mainfi_tclMsgHUS_DM1_StatusMethodStart(const vehicle_mainfi_tclMsgHUS_DM1_StatusMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   HUS_DM1_StatusValue = coRef.HUS_DM1_StatusValue;
}
vehicle_mainfi_tclMsgHUS_DM1_StatusMethodStart& vehicle_mainfi_tclMsgHUS_DM1_StatusMethodStart::operator=(const vehicle_mainfi_tclMsgHUS_DM1_StatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   HUS_DM1_StatusValue = coRef.HUS_DM1_StatusValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgHUS_DM1_StatusMethodStart::vehicle_mainfi_tclMsgHUS_DM1_StatusMethodStart()
:HUS_DM1_StatusValue(0)
 {}

tS32 vehicle_mainfi_tclMsgHUS_DM1_StatusMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_HUS_DM1_STATUSMETHODSTART;
}


vehicle_mainfi_tclMsgHUS_DM1_StatusMethodStart::~vehicle_mainfi_tclMsgHUS_DM1_StatusMethodStart()
{}

tU32 vehicle_mainfi_tclMsgHUS_DM1_StatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& vehicle_mainfi_tclMsgHUS_DM1_StatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> HUS_DM1_StatusValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgHUS_DM1_StatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << HUS_DM1_StatusValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgHUS_DM1_StatusMethodStart::operator==(const vehicle_mainfi_tclMsgHUS_DM1_StatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (HUS_DM1_StatusValue == roRef.HUS_DM1_StatusValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgHUS_DM1_StatusMethodResult::vehicle_mainfi_tclMsgHUS_DM1_StatusMethodResult(const vehicle_mainfi_tclMsgHUS_DM1_StatusMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgHUS_DM1_StatusMethodResult& vehicle_mainfi_tclMsgHUS_DM1_StatusMethodResult::operator=(const vehicle_mainfi_tclMsgHUS_DM1_StatusMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgHUS_DM1_StatusMethodResult::vehicle_mainfi_tclMsgHUS_DM1_StatusMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgHUS_DM1_StatusMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_HUS_DM1_STATUSMETHODRESULT;
}


vehicle_mainfi_tclMsgHUS_DM1_StatusMethodResult::~vehicle_mainfi_tclMsgHUS_DM1_StatusMethodResult()
{}

tU32 vehicle_mainfi_tclMsgHUS_DM1_StatusMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgHUS_DM1_StatusMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgHUS_DM1_StatusMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgHUS_DM1_StatusMethodResult::operator==(const vehicle_mainfi_tclMsgHUS_DM1_StatusMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodStart::vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodStart(const vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   VehicleNaviLatitudeValue = coRef.VehicleNaviLatitudeValue;
}
vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodStart& vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodStart::operator=(const vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   VehicleNaviLatitudeValue = coRef.VehicleNaviLatitudeValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodStart::vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodStart()
:VehicleNaviLatitudeValue(0)
 {}

tS32 vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_VEHICLENAVILATITUDEMETHODSTART;
}


vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodStart::~vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodStart()
{}

tU32 vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VehicleNaviLatitudeValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VehicleNaviLatitudeValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodStart::operator==(const vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VehicleNaviLatitudeValue == roRef.VehicleNaviLatitudeValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodResult::vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodResult(const vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodResult& vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodResult::operator=(const vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodResult::vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_VEHICLENAVILATITUDEMETHODRESULT;
}


vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodResult::~vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodResult()
{}

tU32 vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodResult::operator==(const vehicle_mainfi_tclMsgVehicleNaviLatitudeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodStart::vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodStart(const vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   VehicleNaviLongitudeValue = coRef.VehicleNaviLongitudeValue;
}
vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodStart& vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodStart::operator=(const vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   VehicleNaviLongitudeValue = coRef.VehicleNaviLongitudeValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodStart::vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodStart()
:VehicleNaviLongitudeValue(0)
 {}

tS32 vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_VEHICLENAVILONGITUDEMETHODSTART;
}


vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodStart::~vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodStart()
{}

tU32 vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VehicleNaviLongitudeValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VehicleNaviLongitudeValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodStart::operator==(const vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VehicleNaviLongitudeValue == roRef.VehicleNaviLongitudeValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodResult::vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodResult(const vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodResult& vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodResult::operator=(const vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodResult::vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_VEHICLENAVILONGITUDEMETHODRESULT;
}


vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodResult::~vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodResult()
{}

tU32 vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodResult::operator==(const vehicle_mainfi_tclMsgVehicleNaviLongitudeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodStart::vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodStart(const vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   AudioSource = coRef.AudioSource;
}
vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodStart& vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodStart::operator=(const vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   AudioSource = coRef.AudioSource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodStart::vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodStart()
:AudioSource(0)
 {}

tS32 vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSAUDIOSOURCEMETHODSTART;
}


vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodStart::~vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodStart()
{}

tU32 vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AudioSource);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AudioSource);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodStart::operator==(const vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AudioSource == roRef.AudioSource);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodResult::vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodResult(const vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodResult& vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodResult::operator=(const vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodResult::vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSAUDIOSOURCEMETHODRESULT;
}


vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodResult::~vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodResult()
{}

tU32 vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodResult::operator==(const vehicle_mainfi_tclMsgMediaStatusAudioSourceMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMediaStatusVolumeMethodStart::vehicle_mainfi_tclMsgMediaStatusVolumeMethodStart(const vehicle_mainfi_tclMsgMediaStatusVolumeMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   volume = coRef.volume;
}
vehicle_mainfi_tclMsgMediaStatusVolumeMethodStart& vehicle_mainfi_tclMsgMediaStatusVolumeMethodStart::operator=(const vehicle_mainfi_tclMsgMediaStatusVolumeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   volume = coRef.volume;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMediaStatusVolumeMethodStart::vehicle_mainfi_tclMsgMediaStatusVolumeMethodStart()
:volume(0)
 {}

tS32 vehicle_mainfi_tclMsgMediaStatusVolumeMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSVOLUMEMETHODSTART;
}


vehicle_mainfi_tclMsgMediaStatusVolumeMethodStart::~vehicle_mainfi_tclMsgMediaStatusVolumeMethodStart()
{}

tU32 vehicle_mainfi_tclMsgMediaStatusVolumeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgMediaStatusVolumeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> volume);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMediaStatusVolumeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << volume);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMediaStatusVolumeMethodStart::operator==(const vehicle_mainfi_tclMsgMediaStatusVolumeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (volume == roRef.volume);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMediaStatusVolumeMethodResult::vehicle_mainfi_tclMsgMediaStatusVolumeMethodResult(const vehicle_mainfi_tclMsgMediaStatusVolumeMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgMediaStatusVolumeMethodResult& vehicle_mainfi_tclMsgMediaStatusVolumeMethodResult::operator=(const vehicle_mainfi_tclMsgMediaStatusVolumeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMediaStatusVolumeMethodResult::vehicle_mainfi_tclMsgMediaStatusVolumeMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgMediaStatusVolumeMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSVOLUMEMETHODRESULT;
}


vehicle_mainfi_tclMsgMediaStatusVolumeMethodResult::~vehicle_mainfi_tclMsgMediaStatusVolumeMethodResult()
{}

tU32 vehicle_mainfi_tclMsgMediaStatusVolumeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgMediaStatusVolumeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMediaStatusVolumeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMediaStatusVolumeMethodResult::operator==(const vehicle_mainfi_tclMsgMediaStatusVolumeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodStart::vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodStart(const vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   CabinAudioSource = coRef.CabinAudioSource;
}
vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodStart& vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodStart::operator=(const vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   CabinAudioSource = coRef.CabinAudioSource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodStart::vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodStart()
:CabinAudioSource(0)
 {}

tS32 vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CABINMEDIASTATUSAUDIOSOURCEMETHODSTART;
}


vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodStart::~vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodStart()
{}

tU32 vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CabinAudioSource);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CabinAudioSource);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodStart::operator==(const vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CabinAudioSource == roRef.CabinAudioSource);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodResult::vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodResult(const vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodResult& vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodResult::operator=(const vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodResult::vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CABINMEDIASTATUSAUDIOSOURCEMETHODRESULT;
}


vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodResult::~vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodResult()
{}

tU32 vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodResult::operator==(const vehicle_mainfi_tclMsgCabinMediaStatusAudioSourceMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodStart::vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodStart(const vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   CabinVolume = coRef.CabinVolume;
}
vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodStart& vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodStart::operator=(const vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   CabinVolume = coRef.CabinVolume;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodStart::vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodStart()
:CabinVolume(0)
 {}

tS32 vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CABINMEDIASTATUSVOLUMEMETHODSTART;
}


vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodStart::~vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodStart()
{}

tU32 vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CabinVolume);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CabinVolume);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodStart::operator==(const vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CabinVolume == roRef.CabinVolume);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodResult::vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodResult(const vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodResult& vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodResult::operator=(const vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodResult::vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CABINMEDIASTATUSVOLUMEMETHODRESULT;
}


vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodResult::~vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodResult()
{}

tU32 vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodResult::operator==(const vehicle_mainfi_tclMsgCabinMediaStatusVolumeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodStart::vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodStart(const vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   MediaStatusMuteValue = coRef.MediaStatusMuteValue;
}
vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodStart& vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodStart::operator=(const vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MediaStatusMuteValue = coRef.MediaStatusMuteValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodStart::vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodStart()
:MediaStatusMuteValue(0)
 {}

tS32 vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSMUTESTATUSMETHODSTART;
}


vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodStart::~vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodStart()
{}

tU32 vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MediaStatusMuteValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MediaStatusMuteValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodStart::operator==(const vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MediaStatusMuteValue == roRef.MediaStatusMuteValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodResult::vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodResult(const vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodResult& vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodResult::operator=(const vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodResult::vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSMUTESTATUSMETHODRESULT;
}


vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodResult::~vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodResult()
{}

tU32 vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodResult::operator==(const vehicle_mainfi_tclMsgMediaStatusMuteStatusMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodStart::vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodStart(const vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   CabinMediaStatusMuteValue = coRef.CabinMediaStatusMuteValue;
}
vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodStart& vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodStart::operator=(const vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   CabinMediaStatusMuteValue = coRef.CabinMediaStatusMuteValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodStart::vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodStart()
:CabinMediaStatusMuteValue(0)
 {}

tS32 vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CABINMEDIASTATUSMUTESTATUSMETHODSTART;
}


vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodStart::~vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodStart()
{}

tU32 vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CabinMediaStatusMuteValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CabinMediaStatusMuteValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodStart::operator==(const vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CabinMediaStatusMuteValue == roRef.CabinMediaStatusMuteValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodResult::vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodResult(const vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodResult& vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodResult::operator=(const vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodResult::vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CABINMEDIASTATUSMUTESTATUSMETHODRESULT;
}


vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodResult::~vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodResult()
{}

tU32 vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodResult::operator==(const vehicle_mainfi_tclMsgCabinMediaStatusMuteStatusMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodStart::vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodStart(const vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   MediaStatusPlayStatusValue = coRef.MediaStatusPlayStatusValue;
}
vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodStart& vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodStart::operator=(const vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MediaStatusPlayStatusValue = coRef.MediaStatusPlayStatusValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodStart::vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodStart()
:MediaStatusPlayStatusValue(0)
 {}

tS32 vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSPLAYSTATUSMETHODSTART;
}


vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodStart::~vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodStart()
{}

tU32 vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MediaStatusPlayStatusValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MediaStatusPlayStatusValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodStart::operator==(const vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MediaStatusPlayStatusValue == roRef.MediaStatusPlayStatusValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodResult::vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodResult(const vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodResult& vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodResult::operator=(const vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodResult::vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSPLAYSTATUSMETHODRESULT;
}


vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodResult::~vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodResult()
{}

tU32 vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodResult::operator==(const vehicle_mainfi_tclMsgMediaStatusPlayStatusMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodStart::vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodStart(const vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   MediaStatusSeekStatusValue = coRef.MediaStatusSeekStatusValue;
}
vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodStart& vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodStart::operator=(const vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MediaStatusSeekStatusValue = coRef.MediaStatusSeekStatusValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodStart::vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodStart()
:MediaStatusSeekStatusValue(0)
 {}

tS32 vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSSEEKSTATUSMETHODSTART;
}


vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodStart::~vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodStart()
{}

tU32 vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MediaStatusSeekStatusValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MediaStatusSeekStatusValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodStart::operator==(const vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MediaStatusSeekStatusValue == roRef.MediaStatusSeekStatusValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodResult::vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodResult(const vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodResult& vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodResult::operator=(const vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodResult::vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSSEEKSTATUSMETHODRESULT;
}


vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodResult::~vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodResult()
{}

tU32 vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodResult::operator==(const vehicle_mainfi_tclMsgMediaStatusSeekStatusMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodStart::vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodStart(const vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   MediaStatusRepeatStatusValue = coRef.MediaStatusRepeatStatusValue;
}
vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodStart& vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodStart::operator=(const vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MediaStatusRepeatStatusValue = coRef.MediaStatusRepeatStatusValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodStart::vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodStart()
:MediaStatusRepeatStatusValue(0)
 {}

tS32 vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSREPEATSTATUSMETHODSTART;
}


vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodStart::~vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodStart()
{}

tU32 vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MediaStatusRepeatStatusValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MediaStatusRepeatStatusValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodStart::operator==(const vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MediaStatusRepeatStatusValue == roRef.MediaStatusRepeatStatusValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodResult::vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodResult(const vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodResult& vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodResult::operator=(const vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodResult::vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSREPEATSTATUSMETHODRESULT;
}


vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodResult::~vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodResult()
{}

tU32 vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodResult::operator==(const vehicle_mainfi_tclMsgMediaStatusRepeatStatusMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodStart::vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodStart(const vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   MediaStatusDABFMStatusValue = coRef.MediaStatusDABFMStatusValue;
}
vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodStart& vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodStart::operator=(const vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MediaStatusDABFMStatusValue = coRef.MediaStatusDABFMStatusValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodStart::vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodStart()
:MediaStatusDABFMStatusValue(0)
 {}

tS32 vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSDABFMSTATUSMETHODSTART;
}


vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodStart::~vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodStart()
{}

tU32 vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MediaStatusDABFMStatusValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MediaStatusDABFMStatusValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodStart::operator==(const vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MediaStatusDABFMStatusValue == roRef.MediaStatusDABFMStatusValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodResult::vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodResult(const vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodResult& vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodResult::operator=(const vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodResult::vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSDABFMSTATUSMETHODRESULT;
}


vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodResult::~vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodResult()
{}

tU32 vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodResult::operator==(const vehicle_mainfi_tclMsgMediaStatusDABFMStatusMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodStart::vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodStart(const vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   MediaStatusTREGStatusValue = coRef.MediaStatusTREGStatusValue;
}
vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodStart& vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodStart::operator=(const vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MediaStatusTREGStatusValue = coRef.MediaStatusTREGStatusValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodStart::vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodStart()
:MediaStatusTREGStatusValue(0)
 {}

tS32 vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSTREGSTATUSMETHODSTART;
}


vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodStart::~vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodStart()
{}

tU32 vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MediaStatusTREGStatusValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MediaStatusTREGStatusValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodStart::operator==(const vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MediaStatusTREGStatusValue == roRef.MediaStatusTREGStatusValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodResult::vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodResult(const vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodResult& vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodResult::operator=(const vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodResult::vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSTREGSTATUSMETHODRESULT;
}


vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodResult::~vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodResult()
{}

tU32 vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodResult::operator==(const vehicle_mainfi_tclMsgMediaStatusTREGStatusMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodStart::vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodStart(const vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   MediaStatusRDSStatusValue = coRef.MediaStatusRDSStatusValue;
}
vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodStart& vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodStart::operator=(const vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MediaStatusRDSStatusValue = coRef.MediaStatusRDSStatusValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodStart::vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodStart()
:MediaStatusRDSStatusValue(0)
 {}

tS32 vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSRDSSTATUSMETHODSTART;
}


vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodStart::~vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodStart()
{}

tU32 vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MediaStatusRDSStatusValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MediaStatusRDSStatusValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodStart::operator==(const vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MediaStatusRDSStatusValue == roRef.MediaStatusRDSStatusValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodResult::vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodResult(const vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodResult& vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodResult::operator=(const vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodResult::vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSRDSSTATUSMETHODRESULT;
}


vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodResult::~vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodResult()
{}

tU32 vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodResult::operator==(const vehicle_mainfi_tclMsgMediaStatusRDSStatusMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMediaStatusTAStatusMethodStart::vehicle_mainfi_tclMsgMediaStatusTAStatusMethodStart(const vehicle_mainfi_tclMsgMediaStatusTAStatusMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   MediaStatusTAStatusValue = coRef.MediaStatusTAStatusValue;
}
vehicle_mainfi_tclMsgMediaStatusTAStatusMethodStart& vehicle_mainfi_tclMsgMediaStatusTAStatusMethodStart::operator=(const vehicle_mainfi_tclMsgMediaStatusTAStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MediaStatusTAStatusValue = coRef.MediaStatusTAStatusValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMediaStatusTAStatusMethodStart::vehicle_mainfi_tclMsgMediaStatusTAStatusMethodStart()
:MediaStatusTAStatusValue(0)
 {}

tS32 vehicle_mainfi_tclMsgMediaStatusTAStatusMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSTASTATUSMETHODSTART;
}


vehicle_mainfi_tclMsgMediaStatusTAStatusMethodStart::~vehicle_mainfi_tclMsgMediaStatusTAStatusMethodStart()
{}

tU32 vehicle_mainfi_tclMsgMediaStatusTAStatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgMediaStatusTAStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MediaStatusTAStatusValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMediaStatusTAStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MediaStatusTAStatusValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMediaStatusTAStatusMethodStart::operator==(const vehicle_mainfi_tclMsgMediaStatusTAStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MediaStatusTAStatusValue == roRef.MediaStatusTAStatusValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMediaStatusTAStatusMethodResult::vehicle_mainfi_tclMsgMediaStatusTAStatusMethodResult(const vehicle_mainfi_tclMsgMediaStatusTAStatusMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgMediaStatusTAStatusMethodResult& vehicle_mainfi_tclMsgMediaStatusTAStatusMethodResult::operator=(const vehicle_mainfi_tclMsgMediaStatusTAStatusMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMediaStatusTAStatusMethodResult::vehicle_mainfi_tclMsgMediaStatusTAStatusMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgMediaStatusTAStatusMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSTASTATUSMETHODRESULT;
}


vehicle_mainfi_tclMsgMediaStatusTAStatusMethodResult::~vehicle_mainfi_tclMsgMediaStatusTAStatusMethodResult()
{}

tU32 vehicle_mainfi_tclMsgMediaStatusTAStatusMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgMediaStatusTAStatusMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMediaStatusTAStatusMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMediaStatusTAStatusMethodResult::operator==(const vehicle_mainfi_tclMsgMediaStatusTAStatusMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMediaStatusTPStatusMethodStart::vehicle_mainfi_tclMsgMediaStatusTPStatusMethodStart(const vehicle_mainfi_tclMsgMediaStatusTPStatusMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   MediaStatusTPStatusValue = coRef.MediaStatusTPStatusValue;
}
vehicle_mainfi_tclMsgMediaStatusTPStatusMethodStart& vehicle_mainfi_tclMsgMediaStatusTPStatusMethodStart::operator=(const vehicle_mainfi_tclMsgMediaStatusTPStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MediaStatusTPStatusValue = coRef.MediaStatusTPStatusValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMediaStatusTPStatusMethodStart::vehicle_mainfi_tclMsgMediaStatusTPStatusMethodStart()
:MediaStatusTPStatusValue(0)
 {}

tS32 vehicle_mainfi_tclMsgMediaStatusTPStatusMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSTPSTATUSMETHODSTART;
}


vehicle_mainfi_tclMsgMediaStatusTPStatusMethodStart::~vehicle_mainfi_tclMsgMediaStatusTPStatusMethodStart()
{}

tU32 vehicle_mainfi_tclMsgMediaStatusTPStatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgMediaStatusTPStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MediaStatusTPStatusValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMediaStatusTPStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MediaStatusTPStatusValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMediaStatusTPStatusMethodStart::operator==(const vehicle_mainfi_tclMsgMediaStatusTPStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MediaStatusTPStatusValue == roRef.MediaStatusTPStatusValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMediaStatusTPStatusMethodResult::vehicle_mainfi_tclMsgMediaStatusTPStatusMethodResult(const vehicle_mainfi_tclMsgMediaStatusTPStatusMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgMediaStatusTPStatusMethodResult& vehicle_mainfi_tclMsgMediaStatusTPStatusMethodResult::operator=(const vehicle_mainfi_tclMsgMediaStatusTPStatusMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMediaStatusTPStatusMethodResult::vehicle_mainfi_tclMsgMediaStatusTPStatusMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgMediaStatusTPStatusMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSTPSTATUSMETHODRESULT;
}


vehicle_mainfi_tclMsgMediaStatusTPStatusMethodResult::~vehicle_mainfi_tclMsgMediaStatusTPStatusMethodResult()
{}

tU32 vehicle_mainfi_tclMsgMediaStatusTPStatusMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgMediaStatusTPStatusMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMediaStatusTPStatusMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMediaStatusTPStatusMethodResult::operator==(const vehicle_mainfi_tclMsgMediaStatusTPStatusMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodStart::vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodStart(const vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   MediaStatusTunerBandStatusValue = coRef.MediaStatusTunerBandStatusValue;
}
vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodStart& vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodStart::operator=(const vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MediaStatusTunerBandStatusValue = coRef.MediaStatusTunerBandStatusValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodStart::vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodStart()
:MediaStatusTunerBandStatusValue(0)
 {}

tS32 vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSTUNERBANDSTATUSMETHODSTART;
}


vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodStart::~vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodStart()
{}

tU32 vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MediaStatusTunerBandStatusValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MediaStatusTunerBandStatusValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodStart::operator==(const vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MediaStatusTunerBandStatusValue == roRef.MediaStatusTunerBandStatusValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodResult::vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodResult(const vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodResult& vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodResult::operator=(const vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodResult::vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSTUNERBANDSTATUSMETHODRESULT;
}


vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodResult::~vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodResult()
{}

tU32 vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodResult::operator==(const vehicle_mainfi_tclMsgMediaStatusTunerBandStatusMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodStart::vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodStart(const vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   MediaStatusTunerPresetStatusValue = coRef.MediaStatusTunerPresetStatusValue;
}
vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodStart& vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodStart::operator=(const vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MediaStatusTunerPresetStatusValue = coRef.MediaStatusTunerPresetStatusValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodStart::vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodStart()
:MediaStatusTunerPresetStatusValue(0)
 {}

tS32 vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSTUNERPRESETSTATUSMETHODSTART;
}


vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodStart::~vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodStart()
{}

tU32 vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MediaStatusTunerPresetStatusValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MediaStatusTunerPresetStatusValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodStart::operator==(const vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MediaStatusTunerPresetStatusValue == roRef.MediaStatusTunerPresetStatusValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodResult::vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodResult(const vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodResult& vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodResult::operator=(const vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodResult::vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSTUNERPRESETSTATUSMETHODRESULT;
}


vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodResult::~vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodResult()
{}

tU32 vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodResult::operator==(const vehicle_mainfi_tclMsgMediaStatusTunerPresetStatusMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMediaStatusMixStateMethodStart::vehicle_mainfi_tclMsgMediaStatusMixStateMethodStart(const vehicle_mainfi_tclMsgMediaStatusMixStateMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   MediaStatusMixStateValue = coRef.MediaStatusMixStateValue;
}
vehicle_mainfi_tclMsgMediaStatusMixStateMethodStart& vehicle_mainfi_tclMsgMediaStatusMixStateMethodStart::operator=(const vehicle_mainfi_tclMsgMediaStatusMixStateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MediaStatusMixStateValue = coRef.MediaStatusMixStateValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMediaStatusMixStateMethodStart::vehicle_mainfi_tclMsgMediaStatusMixStateMethodStart()
:MediaStatusMixStateValue(0)
 {}

tS32 vehicle_mainfi_tclMsgMediaStatusMixStateMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSMIXSTATEMETHODSTART;
}


vehicle_mainfi_tclMsgMediaStatusMixStateMethodStart::~vehicle_mainfi_tclMsgMediaStatusMixStateMethodStart()
{}

tU32 vehicle_mainfi_tclMsgMediaStatusMixStateMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgMediaStatusMixStateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MediaStatusMixStateValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMediaStatusMixStateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MediaStatusMixStateValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMediaStatusMixStateMethodStart::operator==(const vehicle_mainfi_tclMsgMediaStatusMixStateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MediaStatusMixStateValue == roRef.MediaStatusMixStateValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMediaStatusMixStateMethodResult::vehicle_mainfi_tclMsgMediaStatusMixStateMethodResult(const vehicle_mainfi_tclMsgMediaStatusMixStateMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgMediaStatusMixStateMethodResult& vehicle_mainfi_tclMsgMediaStatusMixStateMethodResult::operator=(const vehicle_mainfi_tclMsgMediaStatusMixStateMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMediaStatusMixStateMethodResult::vehicle_mainfi_tclMsgMediaStatusMixStateMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgMediaStatusMixStateMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSMIXSTATEMETHODRESULT;
}


vehicle_mainfi_tclMsgMediaStatusMixStateMethodResult::~vehicle_mainfi_tclMsgMediaStatusMixStateMethodResult()
{}

tU32 vehicle_mainfi_tclMsgMediaStatusMixStateMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgMediaStatusMixStateMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMediaStatusMixStateMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMediaStatusMixStateMethodResult::operator==(const vehicle_mainfi_tclMsgMediaStatusMixStateMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodStart::vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodStart(const vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   MediaStatusPlaylistModeValue = coRef.MediaStatusPlaylistModeValue;
}
vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodStart& vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodStart::operator=(const vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MediaStatusPlaylistModeValue = coRef.MediaStatusPlaylistModeValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodStart::vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodStart()
:MediaStatusPlaylistModeValue(0)
 {}

tS32 vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSPLAYLISTMODEMETHODSTART;
}


vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodStart::~vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodStart()
{}

tU32 vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MediaStatusPlaylistModeValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MediaStatusPlaylistModeValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodStart::operator==(const vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MediaStatusPlaylistModeValue == roRef.MediaStatusPlaylistModeValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodResult::vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodResult(const vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodResult& vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodResult::operator=(const vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodResult::vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSPLAYLISTMODEMETHODRESULT;
}


vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodResult::~vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodResult()
{}

tU32 vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodResult::operator==(const vehicle_mainfi_tclMsgMediaStatusPlaylistModeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodStart::vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodStart(const vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   MediaStatusTrackTimeValue = coRef.MediaStatusTrackTimeValue;
}
vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodStart& vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodStart::operator=(const vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MediaStatusTrackTimeValue = coRef.MediaStatusTrackTimeValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodStart::vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodStart()
:MediaStatusTrackTimeValue(0)
 {}

tS32 vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSTRACKTIMEMETHODSTART;
}


vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodStart::~vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodStart()
{}

tU32 vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MediaStatusTrackTimeValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MediaStatusTrackTimeValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodStart::operator==(const vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MediaStatusTrackTimeValue == roRef.MediaStatusTrackTimeValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodResult::vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodResult(const vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodResult& vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodResult::operator=(const vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodResult::vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSTRACKTIMEMETHODRESULT;
}


vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodResult::~vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodResult()
{}

tU32 vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodResult::operator==(const vehicle_mainfi_tclMsgMediaStatusTrackTimeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodStart::vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodStart(const vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   MediaStatusCurrTrackNumValue = coRef.MediaStatusCurrTrackNumValue;
}
vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodStart& vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodStart::operator=(const vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MediaStatusCurrTrackNumValue = coRef.MediaStatusCurrTrackNumValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodStart::vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodStart()
:MediaStatusCurrTrackNumValue(0)
 {}

tS32 vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSCURRTRACKNUMMETHODSTART;
}


vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodStart::~vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodStart()
{}

tU32 vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MediaStatusCurrTrackNumValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MediaStatusCurrTrackNumValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodStart::operator==(const vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MediaStatusCurrTrackNumValue == roRef.MediaStatusCurrTrackNumValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodResult::vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodResult(const vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodResult& vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodResult::operator=(const vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodResult::vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSCURRTRACKNUMMETHODRESULT;
}


vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodResult::~vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodResult()
{}

tU32 vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodResult::operator==(const vehicle_mainfi_tclMsgMediaStatusCurrTrackNumMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodStart::vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodStart(const vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   MediaStatusTREGRTMStatusValue = coRef.MediaStatusTREGRTMStatusValue;
}
vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodStart& vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodStart::operator=(const vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MediaStatusTREGRTMStatusValue = coRef.MediaStatusTREGRTMStatusValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodStart::vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodStart()
:MediaStatusTREGRTMStatusValue(0)
 {}

tS32 vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSTREGRTMSTATUSMETHODSTART;
}


vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodStart::~vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodStart()
{}

tU32 vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MediaStatusTREGRTMStatusValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MediaStatusTREGRTMStatusValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodStart::operator==(const vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MediaStatusTREGRTMStatusValue == roRef.MediaStatusTREGRTMStatusValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodResult::vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodResult(const vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodResult& vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodResult::operator=(const vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodResult::vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MEDIASTATUSTREGRTMSTATUSMETHODRESULT;
}


vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodResult::~vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodResult()
{}

tU32 vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodResult::operator==(const vehicle_mainfi_tclMsgMediaStatusTREGRTMStatusMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodStart::vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodStart(const vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   CabinMediaStatusTunerBandValue = coRef.CabinMediaStatusTunerBandValue;
}
vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodStart& vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodStart::operator=(const vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodStart& coRef)
{
   if (this == &coRef) return *this;
   CabinMediaStatusTunerBandValue = coRef.CabinMediaStatusTunerBandValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodStart::vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodStart()
:CabinMediaStatusTunerBandValue(0)
 {}

tS32 vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CABINMEDIASTATUSTUNERBANDMETHODSTART;
}


vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodStart::~vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodStart()
{}

tU32 vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CabinMediaStatusTunerBandValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CabinMediaStatusTunerBandValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodStart::operator==(const vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CabinMediaStatusTunerBandValue == roRef.CabinMediaStatusTunerBandValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodResult::vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodResult(const vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodResult& vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodResult::operator=(const vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodResult::vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CABINMEDIASTATUSTUNERBANDMETHODRESULT;
}


vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodResult::~vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodResult()
{}

tU32 vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodResult::operator==(const vehicle_mainfi_tclMsgCabinMediaStatusTunerBandMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgCSMEngineeringDataMethodStart::vehicle_mainfi_tclMsgCSMEngineeringDataMethodStart()
 {}

tS32 vehicle_mainfi_tclMsgCSMEngineeringDataMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CSMENGINEERINGDATAMETHODSTART;
}


vehicle_mainfi_tclMsgCSMEngineeringDataMethodStart::~vehicle_mainfi_tclMsgCSMEngineeringDataMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCSMEngineeringDataMethodResult::vehicle_mainfi_tclMsgCSMEngineeringDataMethodResult(const vehicle_mainfi_tclMsgCSMEngineeringDataMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   CanMessageList = coRef.CanMessageList;
}
vehicle_mainfi_tclMsgCSMEngineeringDataMethodResult& vehicle_mainfi_tclMsgCSMEngineeringDataMethodResult::operator=(const vehicle_mainfi_tclMsgCSMEngineeringDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   CanMessageList = coRef.CanMessageList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid vehicle_mainfi_tclMsgCSMEngineeringDataMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < CanMessageList.size(); ++u32Idx)
         CanMessageList[u32Idx].vDestroy();
   CanMessageList.clear();
   }
}

vehicle_mainfi_tclMsgCSMEngineeringDataMethodResult::vehicle_mainfi_tclMsgCSMEngineeringDataMethodResult()

 {}

tS32 vehicle_mainfi_tclMsgCSMEngineeringDataMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CSMENGINEERINGDATAMETHODRESULT;
}


vehicle_mainfi_tclMsgCSMEngineeringDataMethodResult::~vehicle_mainfi_tclMsgCSMEngineeringDataMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 vehicle_mainfi_tclMsgCSMEngineeringDataMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < CanMessageList.size(); ++u32ListIdx)
      u32DynamicSize += CanMessageList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& vehicle_mainfi_tclMsgCSMEngineeringDataMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CanMessageList.size(); ++u32Idx)
      {
         CanMessageList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      CanMessageList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> CanMessageList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCSMEngineeringDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)CanMessageList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < CanMessageList.size(); ++u32Idx)
         (tVoid) (oOut << CanMessageList[u32Idx]);
   }
   return oOut;
}

tBool vehicle_mainfi_tclMsgCSMEngineeringDataMethodResult::operator==(const vehicle_mainfi_tclMsgCSMEngineeringDataMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (CanMessageList.size() == roRef.CanMessageList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CanMessageList.size()); ++u32Idx)
            bResult = bResult && (CanMessageList[u32Idx] == roRef.CanMessageList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodStart::vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodStart(const vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   OSPAlert = coRef.OSPAlert;
   DangerousAreaAlert = coRef.DangerousAreaAlert;
}
vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodStart& vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodStart::operator=(const vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   OSPAlert = coRef.OSPAlert;
   DangerousAreaAlert = coRef.DangerousAreaAlert;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodStart::vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodStart()
:OSPAlert(0)
,DangerousAreaAlert(0)
 {}

tS32 vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SETOSPALERTSSTATUSMETHODSTART;
}


vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodStart::~vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodStart()
{}

tU32 vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> OSPAlert);
   (tVoid) (oIn >> DangerousAreaAlert);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << OSPAlert);
   (tVoid) (oOut << DangerousAreaAlert);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodStart::operator==(const vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (OSPAlert == roRef.OSPAlert);
   bResult = bResult && (DangerousAreaAlert == roRef.DangerousAreaAlert);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodResult::vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodResult(const vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodResult& vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodResult::operator=(const vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodResult::vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodResult()
:Status(0)
 {}

tS32 vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SETOSPALERTSSTATUSMETHODRESULT;
}


vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodResult::~vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodResult()
{}

tU32 vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodResult::operator==(const vehicle_mainfi_tclMsgSetOSPAlertsStatusMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSendMediaInfoMethodStart::vehicle_mainfi_tclMsgSendMediaInfoMethodStart(const vehicle_mainfi_tclMsgSendMediaInfoMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   MediaInfo = coRef.MediaInfo;
}
vehicle_mainfi_tclMsgSendMediaInfoMethodStart& vehicle_mainfi_tclMsgSendMediaInfoMethodStart::operator=(const vehicle_mainfi_tclMsgSendMediaInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MediaInfo = coRef.MediaInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid vehicle_mainfi_tclMsgSendMediaInfoMethodStart::vDestroy()
{
   MediaInfo.vDestroy(); 
}

vehicle_mainfi_tclMsgSendMediaInfoMethodStart::vehicle_mainfi_tclMsgSendMediaInfoMethodStart()
:MediaInfo()
 {}

tS32 vehicle_mainfi_tclMsgSendMediaInfoMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SENDMEDIAINFOMETHODSTART;
}


vehicle_mainfi_tclMsgSendMediaInfoMethodStart::~vehicle_mainfi_tclMsgSendMediaInfoMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 vehicle_mainfi_tclMsgSendMediaInfoMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+MediaInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& vehicle_mainfi_tclMsgSendMediaInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MediaInfo);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSendMediaInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MediaInfo);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSendMediaInfoMethodStart::operator==(const vehicle_mainfi_tclMsgSendMediaInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MediaInfo == roRef.MediaInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSendMediaInfoMethodResult::vehicle_mainfi_tclMsgSendMediaInfoMethodResult(const vehicle_mainfi_tclMsgSendMediaInfoMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
vehicle_mainfi_tclMsgSendMediaInfoMethodResult& vehicle_mainfi_tclMsgSendMediaInfoMethodResult::operator=(const vehicle_mainfi_tclMsgSendMediaInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgSendMediaInfoMethodResult::vehicle_mainfi_tclMsgSendMediaInfoMethodResult()
:Status(0)
 {}

tS32 vehicle_mainfi_tclMsgSendMediaInfoMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SENDMEDIAINFOMETHODRESULT;
}


vehicle_mainfi_tclMsgSendMediaInfoMethodResult::~vehicle_mainfi_tclMsgSendMediaInfoMethodResult()
{}

tU32 vehicle_mainfi_tclMsgSendMediaInfoMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgSendMediaInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSendMediaInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSendMediaInfoMethodResult::operator==(const vehicle_mainfi_tclMsgSendMediaInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSendCallInfoMethodStart::vehicle_mainfi_tclMsgSendCallInfoMethodStart(const vehicle_mainfi_tclMsgSendCallInfoMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   CallInfo = coRef.CallInfo;
}
vehicle_mainfi_tclMsgSendCallInfoMethodStart& vehicle_mainfi_tclMsgSendCallInfoMethodStart::operator=(const vehicle_mainfi_tclMsgSendCallInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   CallInfo = coRef.CallInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid vehicle_mainfi_tclMsgSendCallInfoMethodStart::vDestroy()
{
   CallInfo.vDestroy(); 
}

vehicle_mainfi_tclMsgSendCallInfoMethodStart::vehicle_mainfi_tclMsgSendCallInfoMethodStart()
:CallInfo()
 {}

tS32 vehicle_mainfi_tclMsgSendCallInfoMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SENDCALLINFOMETHODSTART;
}


vehicle_mainfi_tclMsgSendCallInfoMethodStart::~vehicle_mainfi_tclMsgSendCallInfoMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 vehicle_mainfi_tclMsgSendCallInfoMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+CallInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& vehicle_mainfi_tclMsgSendCallInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CallInfo);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSendCallInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CallInfo);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSendCallInfoMethodStart::operator==(const vehicle_mainfi_tclMsgSendCallInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CallInfo == roRef.CallInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSendCallInfoMethodResult::vehicle_mainfi_tclMsgSendCallInfoMethodResult(const vehicle_mainfi_tclMsgSendCallInfoMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
vehicle_mainfi_tclMsgSendCallInfoMethodResult& vehicle_mainfi_tclMsgSendCallInfoMethodResult::operator=(const vehicle_mainfi_tclMsgSendCallInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgSendCallInfoMethodResult::vehicle_mainfi_tclMsgSendCallInfoMethodResult()
:Status(0)
 {}

tS32 vehicle_mainfi_tclMsgSendCallInfoMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SENDCALLINFOMETHODRESULT;
}


vehicle_mainfi_tclMsgSendCallInfoMethodResult::~vehicle_mainfi_tclMsgSendCallInfoMethodResult()
{}

tU32 vehicle_mainfi_tclMsgSendCallInfoMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgSendCallInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSendCallInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSendCallInfoMethodResult::operator==(const vehicle_mainfi_tclMsgSendCallInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSendPhoneInfoMethodStart::vehicle_mainfi_tclMsgSendPhoneInfoMethodStart(const vehicle_mainfi_tclMsgSendPhoneInfoMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   PhoneInfo = coRef.PhoneInfo;
}
vehicle_mainfi_tclMsgSendPhoneInfoMethodStart& vehicle_mainfi_tclMsgSendPhoneInfoMethodStart::operator=(const vehicle_mainfi_tclMsgSendPhoneInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   PhoneInfo = coRef.PhoneInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid vehicle_mainfi_tclMsgSendPhoneInfoMethodStart::vDestroy()
{
   PhoneInfo.vDestroy(); 
}

vehicle_mainfi_tclMsgSendPhoneInfoMethodStart::vehicle_mainfi_tclMsgSendPhoneInfoMethodStart()
:PhoneInfo()
 {}

tS32 vehicle_mainfi_tclMsgSendPhoneInfoMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SENDPHONEINFOMETHODSTART;
}


vehicle_mainfi_tclMsgSendPhoneInfoMethodStart::~vehicle_mainfi_tclMsgSendPhoneInfoMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 vehicle_mainfi_tclMsgSendPhoneInfoMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+PhoneInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& vehicle_mainfi_tclMsgSendPhoneInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PhoneInfo);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSendPhoneInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PhoneInfo);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSendPhoneInfoMethodStart::operator==(const vehicle_mainfi_tclMsgSendPhoneInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PhoneInfo == roRef.PhoneInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSendPhoneInfoMethodResult::vehicle_mainfi_tclMsgSendPhoneInfoMethodResult(const vehicle_mainfi_tclMsgSendPhoneInfoMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
vehicle_mainfi_tclMsgSendPhoneInfoMethodResult& vehicle_mainfi_tclMsgSendPhoneInfoMethodResult::operator=(const vehicle_mainfi_tclMsgSendPhoneInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgSendPhoneInfoMethodResult::vehicle_mainfi_tclMsgSendPhoneInfoMethodResult()
:Status(0)
 {}

tS32 vehicle_mainfi_tclMsgSendPhoneInfoMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SENDPHONEINFOMETHODRESULT;
}


vehicle_mainfi_tclMsgSendPhoneInfoMethodResult::~vehicle_mainfi_tclMsgSendPhoneInfoMethodResult()
{}

tU32 vehicle_mainfi_tclMsgSendPhoneInfoMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgSendPhoneInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSendPhoneInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSendPhoneInfoMethodResult::operator==(const vehicle_mainfi_tclMsgSendPhoneInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSendXMInfoMethodStart::vehicle_mainfi_tclMsgSendXMInfoMethodStart(const vehicle_mainfi_tclMsgSendXMInfoMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   XMInfo = coRef.XMInfo;
}
vehicle_mainfi_tclMsgSendXMInfoMethodStart& vehicle_mainfi_tclMsgSendXMInfoMethodStart::operator=(const vehicle_mainfi_tclMsgSendXMInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   XMInfo = coRef.XMInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid vehicle_mainfi_tclMsgSendXMInfoMethodStart::vDestroy()
{
   XMInfo.vDestroy(); 
}

vehicle_mainfi_tclMsgSendXMInfoMethodStart::vehicle_mainfi_tclMsgSendXMInfoMethodStart()
:XMInfo()
 {}

tS32 vehicle_mainfi_tclMsgSendXMInfoMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SENDXMINFOMETHODSTART;
}


vehicle_mainfi_tclMsgSendXMInfoMethodStart::~vehicle_mainfi_tclMsgSendXMInfoMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 vehicle_mainfi_tclMsgSendXMInfoMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+XMInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& vehicle_mainfi_tclMsgSendXMInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> XMInfo);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSendXMInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << XMInfo);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSendXMInfoMethodStart::operator==(const vehicle_mainfi_tclMsgSendXMInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (XMInfo == roRef.XMInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSendXMInfoMethodResult::vehicle_mainfi_tclMsgSendXMInfoMethodResult(const vehicle_mainfi_tclMsgSendXMInfoMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
vehicle_mainfi_tclMsgSendXMInfoMethodResult& vehicle_mainfi_tclMsgSendXMInfoMethodResult::operator=(const vehicle_mainfi_tclMsgSendXMInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgSendXMInfoMethodResult::vehicle_mainfi_tclMsgSendXMInfoMethodResult()
:Status(0)
 {}

tS32 vehicle_mainfi_tclMsgSendXMInfoMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SENDXMINFOMETHODRESULT;
}


vehicle_mainfi_tclMsgSendXMInfoMethodResult::~vehicle_mainfi_tclMsgSendXMInfoMethodResult()
{}

tU32 vehicle_mainfi_tclMsgSendXMInfoMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgSendXMInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSendXMInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSendXMInfoMethodResult::operator==(const vehicle_mainfi_tclMsgSendXMInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSendMainlineInfoMethodStart::vehicle_mainfi_tclMsgSendMainlineInfoMethodStart(const vehicle_mainfi_tclMsgSendMainlineInfoMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   MainlineInfo = coRef.MainlineInfo;
}
vehicle_mainfi_tclMsgSendMainlineInfoMethodStart& vehicle_mainfi_tclMsgSendMainlineInfoMethodStart::operator=(const vehicle_mainfi_tclMsgSendMainlineInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MainlineInfo = coRef.MainlineInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid vehicle_mainfi_tclMsgSendMainlineInfoMethodStart::vDestroy()
{
   MainlineInfo.vDestroy(); 
}

vehicle_mainfi_tclMsgSendMainlineInfoMethodStart::vehicle_mainfi_tclMsgSendMainlineInfoMethodStart()
:MainlineInfo()
 {}

tS32 vehicle_mainfi_tclMsgSendMainlineInfoMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SENDMAINLINEINFOMETHODSTART;
}


vehicle_mainfi_tclMsgSendMainlineInfoMethodStart::~vehicle_mainfi_tclMsgSendMainlineInfoMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 vehicle_mainfi_tclMsgSendMainlineInfoMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+MainlineInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& vehicle_mainfi_tclMsgSendMainlineInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MainlineInfo);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSendMainlineInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MainlineInfo);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSendMainlineInfoMethodStart::operator==(const vehicle_mainfi_tclMsgSendMainlineInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MainlineInfo == roRef.MainlineInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSendMainlineInfoMethodResult::vehicle_mainfi_tclMsgSendMainlineInfoMethodResult(const vehicle_mainfi_tclMsgSendMainlineInfoMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
vehicle_mainfi_tclMsgSendMainlineInfoMethodResult& vehicle_mainfi_tclMsgSendMainlineInfoMethodResult::operator=(const vehicle_mainfi_tclMsgSendMainlineInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgSendMainlineInfoMethodResult::vehicle_mainfi_tclMsgSendMainlineInfoMethodResult()
:Status(0)
 {}

tS32 vehicle_mainfi_tclMsgSendMainlineInfoMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SENDMAINLINEINFOMETHODRESULT;
}


vehicle_mainfi_tclMsgSendMainlineInfoMethodResult::~vehicle_mainfi_tclMsgSendMainlineInfoMethodResult()
{}

tU32 vehicle_mainfi_tclMsgSendMainlineInfoMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgSendMainlineInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSendMainlineInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSendMainlineInfoMethodResult::operator==(const vehicle_mainfi_tclMsgSendMainlineInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodStart::vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodStart(const vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   CabinAMediaInfo = coRef.CabinAMediaInfo;
}
vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodStart& vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodStart::operator=(const vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   CabinAMediaInfo = coRef.CabinAMediaInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodStart::vDestroy()
{
   CabinAMediaInfo.vDestroy(); 
}

vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodStart::vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodStart()
:CabinAMediaInfo()
 {}

tS32 vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SENDCABINAMEDIAINFOMETHODSTART;
}


vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodStart::~vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+CabinAMediaInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CabinAMediaInfo);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CabinAMediaInfo);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodStart::operator==(const vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CabinAMediaInfo == roRef.CabinAMediaInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodResult::vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodResult(const vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodResult& vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodResult::operator=(const vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodResult::vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodResult()
:Status(0)
 {}

tS32 vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SENDCABINAMEDIAINFOMETHODRESULT;
}


vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodResult::~vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodResult()
{}

tU32 vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodResult::operator==(const vehicle_mainfi_tclMsgSendCabinAMediaInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodStart::vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodStart(const vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   CabinAMainlineInfo = coRef.CabinAMainlineInfo;
}
vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodStart& vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodStart::operator=(const vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   CabinAMainlineInfo = coRef.CabinAMainlineInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodStart::vDestroy()
{
   CabinAMainlineInfo.vDestroy(); 
}

vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodStart::vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodStart()
:CabinAMainlineInfo()
 {}

tS32 vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SENDCABINAMAINLINEINFOMETHODSTART;
}


vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodStart::~vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+CabinAMainlineInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CabinAMainlineInfo);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CabinAMainlineInfo);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodStart::operator==(const vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CabinAMainlineInfo == roRef.CabinAMainlineInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodResult::vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodResult(const vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodResult& vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodResult::operator=(const vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodResult::vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodResult()
:Status(0)
 {}

tS32 vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SENDCABINAMAINLINEINFOMETHODRESULT;
}


vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodResult::~vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodResult()
{}

tU32 vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodResult::operator==(const vehicle_mainfi_tclMsgSendCabinAMainlineInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSendCabinACallInfoMethodStart::vehicle_mainfi_tclMsgSendCabinACallInfoMethodStart(const vehicle_mainfi_tclMsgSendCabinACallInfoMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   CabinACallInfo = coRef.CabinACallInfo;
}
vehicle_mainfi_tclMsgSendCabinACallInfoMethodStart& vehicle_mainfi_tclMsgSendCabinACallInfoMethodStart::operator=(const vehicle_mainfi_tclMsgSendCabinACallInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   CabinACallInfo = coRef.CabinACallInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid vehicle_mainfi_tclMsgSendCabinACallInfoMethodStart::vDestroy()
{
   CabinACallInfo.vDestroy(); 
}

vehicle_mainfi_tclMsgSendCabinACallInfoMethodStart::vehicle_mainfi_tclMsgSendCabinACallInfoMethodStart()
:CabinACallInfo()
 {}

tS32 vehicle_mainfi_tclMsgSendCabinACallInfoMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SENDCABINACALLINFOMETHODSTART;
}


vehicle_mainfi_tclMsgSendCabinACallInfoMethodStart::~vehicle_mainfi_tclMsgSendCabinACallInfoMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 vehicle_mainfi_tclMsgSendCabinACallInfoMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+CabinACallInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& vehicle_mainfi_tclMsgSendCabinACallInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CabinACallInfo);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSendCabinACallInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CabinACallInfo);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSendCabinACallInfoMethodStart::operator==(const vehicle_mainfi_tclMsgSendCabinACallInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CabinACallInfo == roRef.CabinACallInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSendCabinACallInfoMethodResult::vehicle_mainfi_tclMsgSendCabinACallInfoMethodResult(const vehicle_mainfi_tclMsgSendCabinACallInfoMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
vehicle_mainfi_tclMsgSendCabinACallInfoMethodResult& vehicle_mainfi_tclMsgSendCabinACallInfoMethodResult::operator=(const vehicle_mainfi_tclMsgSendCabinACallInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgSendCabinACallInfoMethodResult::vehicle_mainfi_tclMsgSendCabinACallInfoMethodResult()
:Status(0)
 {}

tS32 vehicle_mainfi_tclMsgSendCabinACallInfoMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SENDCABINACALLINFOMETHODRESULT;
}


vehicle_mainfi_tclMsgSendCabinACallInfoMethodResult::~vehicle_mainfi_tclMsgSendCabinACallInfoMethodResult()
{}

tU32 vehicle_mainfi_tclMsgSendCabinACallInfoMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgSendCabinACallInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSendCabinACallInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSendCabinACallInfoMethodResult::operator==(const vehicle_mainfi_tclMsgSendCabinACallInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodStart::vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodStart(const vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   CabinAPhoneInfo = coRef.CabinAPhoneInfo;
}
vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodStart& vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodStart::operator=(const vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   CabinAPhoneInfo = coRef.CabinAPhoneInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodStart::vDestroy()
{
   CabinAPhoneInfo.vDestroy(); 
}

vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodStart::vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodStart()
:CabinAPhoneInfo()
 {}

tS32 vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SENDCABINAPHONEINFOMETHODSTART;
}


vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodStart::~vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+CabinAPhoneInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CabinAPhoneInfo);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CabinAPhoneInfo);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodStart::operator==(const vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CabinAPhoneInfo == roRef.CabinAPhoneInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodResult::vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodResult(const vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodResult& vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodResult::operator=(const vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodResult::vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodResult()
:Status(0)
 {}

tS32 vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SENDCABINAPHONEINFOMETHODRESULT;
}


vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodResult::~vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodResult()
{}

tU32 vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodResult::operator==(const vehicle_mainfi_tclMsgSendCabinAPhoneInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSendCabinAXMInfoMethodStart::vehicle_mainfi_tclMsgSendCabinAXMInfoMethodStart(const vehicle_mainfi_tclMsgSendCabinAXMInfoMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   CabinAXMInfo = coRef.CabinAXMInfo;
}
vehicle_mainfi_tclMsgSendCabinAXMInfoMethodStart& vehicle_mainfi_tclMsgSendCabinAXMInfoMethodStart::operator=(const vehicle_mainfi_tclMsgSendCabinAXMInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   CabinAXMInfo = coRef.CabinAXMInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid vehicle_mainfi_tclMsgSendCabinAXMInfoMethodStart::vDestroy()
{
   CabinAXMInfo.vDestroy(); 
}

vehicle_mainfi_tclMsgSendCabinAXMInfoMethodStart::vehicle_mainfi_tclMsgSendCabinAXMInfoMethodStart()
:CabinAXMInfo()
 {}

tS32 vehicle_mainfi_tclMsgSendCabinAXMInfoMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SENDCABINAXMINFOMETHODSTART;
}


vehicle_mainfi_tclMsgSendCabinAXMInfoMethodStart::~vehicle_mainfi_tclMsgSendCabinAXMInfoMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 vehicle_mainfi_tclMsgSendCabinAXMInfoMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+CabinAXMInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& vehicle_mainfi_tclMsgSendCabinAXMInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CabinAXMInfo);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSendCabinAXMInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CabinAXMInfo);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSendCabinAXMInfoMethodStart::operator==(const vehicle_mainfi_tclMsgSendCabinAXMInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CabinAXMInfo == roRef.CabinAXMInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSendCabinAXMInfoMethodResult::vehicle_mainfi_tclMsgSendCabinAXMInfoMethodResult(const vehicle_mainfi_tclMsgSendCabinAXMInfoMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
vehicle_mainfi_tclMsgSendCabinAXMInfoMethodResult& vehicle_mainfi_tclMsgSendCabinAXMInfoMethodResult::operator=(const vehicle_mainfi_tclMsgSendCabinAXMInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgSendCabinAXMInfoMethodResult::vehicle_mainfi_tclMsgSendCabinAXMInfoMethodResult()
:Status(0)
 {}

tS32 vehicle_mainfi_tclMsgSendCabinAXMInfoMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SENDCABINAXMINFOMETHODRESULT;
}


vehicle_mainfi_tclMsgSendCabinAXMInfoMethodResult::~vehicle_mainfi_tclMsgSendCabinAXMInfoMethodResult()
{}

tU32 vehicle_mainfi_tclMsgSendCabinAXMInfoMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgSendCabinAXMInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSendCabinAXMInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSendCabinAXMInfoMethodResult::operator==(const vehicle_mainfi_tclMsgSendCabinAXMInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodStart::vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodStart(const vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   NaviCurrentStreetNameInfo = coRef.NaviCurrentStreetNameInfo;
}
vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodStart& vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodStart::operator=(const vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   NaviCurrentStreetNameInfo = coRef.NaviCurrentStreetNameInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodStart::vDestroy()
{
   NaviCurrentStreetNameInfo.vDestroy(); 
}

vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodStart::vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodStart()
:NaviCurrentStreetNameInfo()
 {}

tS32 vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SENDNAVICURRENTSTREETNAMEINFOMETHODSTART;
}


vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodStart::~vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+NaviCurrentStreetNameInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> NaviCurrentStreetNameInfo);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << NaviCurrentStreetNameInfo);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodStart::operator==(const vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (NaviCurrentStreetNameInfo == roRef.NaviCurrentStreetNameInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodResult::vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodResult(const vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodResult& vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodResult::operator=(const vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodResult::vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodResult()
:Status(0)
 {}

tS32 vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SENDNAVICURRENTSTREETNAMEINFOMETHODRESULT;
}


vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodResult::~vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodResult()
{}

tU32 vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodResult::operator==(const vehicle_mainfi_tclMsgSendNaviCurrentStreetNameInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodStart::vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodStart(const vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   NaviTurnToStreetNameInfo = coRef.NaviTurnToStreetNameInfo;
}
vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodStart& vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodStart::operator=(const vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   NaviTurnToStreetNameInfo = coRef.NaviTurnToStreetNameInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodStart::vDestroy()
{
   NaviTurnToStreetNameInfo.vDestroy(); 
}

vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodStart::vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodStart()
:NaviTurnToStreetNameInfo()
 {}

tS32 vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SENDNAVITURNTOSTREETNAMEINFOMETHODSTART;
}


vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodStart::~vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+NaviTurnToStreetNameInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> NaviTurnToStreetNameInfo);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << NaviTurnToStreetNameInfo);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodStart::operator==(const vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (NaviTurnToStreetNameInfo == roRef.NaviTurnToStreetNameInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodResult::vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodResult(const vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodResult& vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodResult::operator=(const vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodResult::vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodResult()
:Status(0)
 {}

tS32 vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SENDNAVITURNTOSTREETNAMEINFOMETHODRESULT;
}


vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodResult::~vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodResult()
{}

tU32 vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodResult::operator==(const vehicle_mainfi_tclMsgSendNaviTurnToStreetNameInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodStart::vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodStart(const vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   NaviDestinationInfo = coRef.NaviDestinationInfo;
}
vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodStart& vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodStart::operator=(const vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   NaviDestinationInfo = coRef.NaviDestinationInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodStart::vDestroy()
{
   NaviDestinationInfo.vDestroy(); 
}

vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodStart::vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodStart()
:NaviDestinationInfo()
 {}

tS32 vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SENDNAVIDESTINATIONINFOMETHODSTART;
}


vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodStart::~vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+NaviDestinationInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> NaviDestinationInfo);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << NaviDestinationInfo);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodStart::operator==(const vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (NaviDestinationInfo == roRef.NaviDestinationInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodResult::vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodResult(const vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodResult& vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodResult::operator=(const vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodResult::vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodResult()
:Status(0)
 {}

tS32 vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SENDNAVIDESTINATIONINFOMETHODRESULT;
}


vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodResult::~vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodResult()
{}

tU32 vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodResult::operator==(const vehicle_mainfi_tclMsgSendNaviDestinationInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodStart::vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodStart(const vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   NaviTurnToSymbolsInfo = coRef.NaviTurnToSymbolsInfo;
}
vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodStart& vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodStart::operator=(const vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   NaviTurnToSymbolsInfo = coRef.NaviTurnToSymbolsInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodStart::vDestroy()
{
   NaviTurnToSymbolsInfo.vDestroy(); 
}

vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodStart::vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodStart()
:NaviTurnToSymbolsInfo()
 {}

tS32 vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SENDNAVITURNTOSYMBOLSINFOMETHODSTART;
}


vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodStart::~vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+NaviTurnToSymbolsInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> NaviTurnToSymbolsInfo);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << NaviTurnToSymbolsInfo);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodStart::operator==(const vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (NaviTurnToSymbolsInfo == roRef.NaviTurnToSymbolsInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodResult::vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodResult(const vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodResult& vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodResult::operator=(const vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodResult::vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodResult()
:Status(0)
 {}

tS32 vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SENDNAVITURNTOSYMBOLSINFOMETHODRESULT;
}


vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodResult::~vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodResult()
{}

tU32 vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodResult::operator==(const vehicle_mainfi_tclMsgSendNaviTurnToSymbolsInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodStart::vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodStart(const vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   NaviLaneGuidanceInfo = coRef.NaviLaneGuidanceInfo;
}
vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodStart& vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodStart::operator=(const vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   NaviLaneGuidanceInfo = coRef.NaviLaneGuidanceInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodStart::vDestroy()
{
   NaviLaneGuidanceInfo.vDestroy(); 
}

vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodStart::vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodStart()
:NaviLaneGuidanceInfo()
 {}

tS32 vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SENDNAVILANEGUIDANCEINFOMETHODSTART;
}


vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodStart::~vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+NaviLaneGuidanceInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> NaviLaneGuidanceInfo);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << NaviLaneGuidanceInfo);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodStart::operator==(const vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (NaviLaneGuidanceInfo == roRef.NaviLaneGuidanceInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodResult::vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodResult(const vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodResult& vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodResult::operator=(const vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodResult::vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodResult()
:Status(0)
 {}

tS32 vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SENDNAVILANEGUIDANCEINFOMETHODRESULT;
}


vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodResult::~vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodResult()
{}

tU32 vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodResult::operator==(const vehicle_mainfi_tclMsgSendNaviLaneGuidanceInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodStart::vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodStart(const vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   NaviNavigationWarningInfo = coRef.NaviNavigationWarningInfo;
}
vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodStart& vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodStart::operator=(const vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   NaviNavigationWarningInfo = coRef.NaviNavigationWarningInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodStart::vDestroy()
{
   NaviNavigationWarningInfo.vDestroy(); 
}

vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodStart::vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodStart()
:NaviNavigationWarningInfo()
 {}

tS32 vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SENDNAVINAVIGATIONWARNINGINFOMETHODSTART;
}


vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodStart::~vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+NaviNavigationWarningInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> NaviNavigationWarningInfo);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << NaviNavigationWarningInfo);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodStart::operator==(const vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (NaviNavigationWarningInfo == roRef.NaviNavigationWarningInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodResult::vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodResult(const vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodResult& vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodResult::operator=(const vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodResult::vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodResult()
:Status(0)
 {}

tS32 vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SENDNAVINAVIGATIONWARNINGINFOMETHODRESULT;
}


vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodResult::~vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodResult()
{}

tU32 vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodResult::operator==(const vehicle_mainfi_tclMsgSendNaviNavigationWarningInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCam1ManActMethodStart::vehicle_mainfi_tclMsgCam1ManActMethodStart(const vehicle_mainfi_tclMsgCam1ManActMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   RequestId = coRef.RequestId;
}
vehicle_mainfi_tclMsgCam1ManActMethodStart& vehicle_mainfi_tclMsgCam1ManActMethodStart::operator=(const vehicle_mainfi_tclMsgCam1ManActMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RequestId = coRef.RequestId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCam1ManActMethodStart::vehicle_mainfi_tclMsgCam1ManActMethodStart()
:RequestId(0)
 {}

tS32 vehicle_mainfi_tclMsgCam1ManActMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAM1MANACTMETHODSTART;
}


vehicle_mainfi_tclMsgCam1ManActMethodStart::~vehicle_mainfi_tclMsgCam1ManActMethodStart()
{}

tU32 vehicle_mainfi_tclMsgCam1ManActMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCam1ManActMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RequestId);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCam1ManActMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RequestId);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCam1ManActMethodStart::operator==(const vehicle_mainfi_tclMsgCam1ManActMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RequestId == roRef.RequestId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCam1ManActMethodResult::vehicle_mainfi_tclMsgCam1ManActMethodResult(const vehicle_mainfi_tclMsgCam1ManActMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgCam1ManActMethodResult& vehicle_mainfi_tclMsgCam1ManActMethodResult::operator=(const vehicle_mainfi_tclMsgCam1ManActMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCam1ManActMethodResult::vehicle_mainfi_tclMsgCam1ManActMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgCam1ManActMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAM1MANACTMETHODRESULT;
}


vehicle_mainfi_tclMsgCam1ManActMethodResult::~vehicle_mainfi_tclMsgCam1ManActMethodResult()
{}

tU32 vehicle_mainfi_tclMsgCam1ManActMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCam1ManActMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCam1ManActMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCam1ManActMethodResult::operator==(const vehicle_mainfi_tclMsgCam1ManActMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCam2ManActMethodStart::vehicle_mainfi_tclMsgCam2ManActMethodStart(const vehicle_mainfi_tclMsgCam2ManActMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   RequestId = coRef.RequestId;
}
vehicle_mainfi_tclMsgCam2ManActMethodStart& vehicle_mainfi_tclMsgCam2ManActMethodStart::operator=(const vehicle_mainfi_tclMsgCam2ManActMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RequestId = coRef.RequestId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCam2ManActMethodStart::vehicle_mainfi_tclMsgCam2ManActMethodStart()
:RequestId(0)
 {}

tS32 vehicle_mainfi_tclMsgCam2ManActMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAM2MANACTMETHODSTART;
}


vehicle_mainfi_tclMsgCam2ManActMethodStart::~vehicle_mainfi_tclMsgCam2ManActMethodStart()
{}

tU32 vehicle_mainfi_tclMsgCam2ManActMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCam2ManActMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RequestId);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCam2ManActMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RequestId);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCam2ManActMethodStart::operator==(const vehicle_mainfi_tclMsgCam2ManActMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RequestId == roRef.RequestId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCam2ManActMethodResult::vehicle_mainfi_tclMsgCam2ManActMethodResult(const vehicle_mainfi_tclMsgCam2ManActMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgCam2ManActMethodResult& vehicle_mainfi_tclMsgCam2ManActMethodResult::operator=(const vehicle_mainfi_tclMsgCam2ManActMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCam2ManActMethodResult::vehicle_mainfi_tclMsgCam2ManActMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgCam2ManActMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAM2MANACTMETHODRESULT;
}


vehicle_mainfi_tclMsgCam2ManActMethodResult::~vehicle_mainfi_tclMsgCam2ManActMethodResult()
{}

tU32 vehicle_mainfi_tclMsgCam2ManActMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCam2ManActMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCam2ManActMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCam2ManActMethodResult::operator==(const vehicle_mainfi_tclMsgCam2ManActMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCam3ManActMethodStart::vehicle_mainfi_tclMsgCam3ManActMethodStart(const vehicle_mainfi_tclMsgCam3ManActMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   RequestId = coRef.RequestId;
}
vehicle_mainfi_tclMsgCam3ManActMethodStart& vehicle_mainfi_tclMsgCam3ManActMethodStart::operator=(const vehicle_mainfi_tclMsgCam3ManActMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RequestId = coRef.RequestId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCam3ManActMethodStart::vehicle_mainfi_tclMsgCam3ManActMethodStart()
:RequestId(0)
 {}

tS32 vehicle_mainfi_tclMsgCam3ManActMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAM3MANACTMETHODSTART;
}


vehicle_mainfi_tclMsgCam3ManActMethodStart::~vehicle_mainfi_tclMsgCam3ManActMethodStart()
{}

tU32 vehicle_mainfi_tclMsgCam3ManActMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCam3ManActMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RequestId);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCam3ManActMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RequestId);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCam3ManActMethodStart::operator==(const vehicle_mainfi_tclMsgCam3ManActMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RequestId == roRef.RequestId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCam3ManActMethodResult::vehicle_mainfi_tclMsgCam3ManActMethodResult(const vehicle_mainfi_tclMsgCam3ManActMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgCam3ManActMethodResult& vehicle_mainfi_tclMsgCam3ManActMethodResult::operator=(const vehicle_mainfi_tclMsgCam3ManActMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCam3ManActMethodResult::vehicle_mainfi_tclMsgCam3ManActMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgCam3ManActMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAM3MANACTMETHODRESULT;
}


vehicle_mainfi_tclMsgCam3ManActMethodResult::~vehicle_mainfi_tclMsgCam3ManActMethodResult()
{}

tU32 vehicle_mainfi_tclMsgCam3ManActMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCam3ManActMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCam3ManActMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCam3ManActMethodResult::operator==(const vehicle_mainfi_tclMsgCam3ManActMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCam4ManActMethodStart::vehicle_mainfi_tclMsgCam4ManActMethodStart(const vehicle_mainfi_tclMsgCam4ManActMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   RequestId = coRef.RequestId;
}
vehicle_mainfi_tclMsgCam4ManActMethodStart& vehicle_mainfi_tclMsgCam4ManActMethodStart::operator=(const vehicle_mainfi_tclMsgCam4ManActMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RequestId = coRef.RequestId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCam4ManActMethodStart::vehicle_mainfi_tclMsgCam4ManActMethodStart()
:RequestId(0)
 {}

tS32 vehicle_mainfi_tclMsgCam4ManActMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAM4MANACTMETHODSTART;
}


vehicle_mainfi_tclMsgCam4ManActMethodStart::~vehicle_mainfi_tclMsgCam4ManActMethodStart()
{}

tU32 vehicle_mainfi_tclMsgCam4ManActMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCam4ManActMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RequestId);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCam4ManActMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RequestId);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCam4ManActMethodStart::operator==(const vehicle_mainfi_tclMsgCam4ManActMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RequestId == roRef.RequestId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCam4ManActMethodResult::vehicle_mainfi_tclMsgCam4ManActMethodResult(const vehicle_mainfi_tclMsgCam4ManActMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgCam4ManActMethodResult& vehicle_mainfi_tclMsgCam4ManActMethodResult::operator=(const vehicle_mainfi_tclMsgCam4ManActMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCam4ManActMethodResult::vehicle_mainfi_tclMsgCam4ManActMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgCam4ManActMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAM4MANACTMETHODRESULT;
}


vehicle_mainfi_tclMsgCam4ManActMethodResult::~vehicle_mainfi_tclMsgCam4ManActMethodResult()
{}

tU32 vehicle_mainfi_tclMsgCam4ManActMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCam4ManActMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCam4ManActMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCam4ManActMethodResult::operator==(const vehicle_mainfi_tclMsgCam4ManActMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCam5ManActMethodStart::vehicle_mainfi_tclMsgCam5ManActMethodStart(const vehicle_mainfi_tclMsgCam5ManActMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   RequestId = coRef.RequestId;
}
vehicle_mainfi_tclMsgCam5ManActMethodStart& vehicle_mainfi_tclMsgCam5ManActMethodStart::operator=(const vehicle_mainfi_tclMsgCam5ManActMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RequestId = coRef.RequestId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCam5ManActMethodStart::vehicle_mainfi_tclMsgCam5ManActMethodStart()
:RequestId(0)
 {}

tS32 vehicle_mainfi_tclMsgCam5ManActMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAM5MANACTMETHODSTART;
}


vehicle_mainfi_tclMsgCam5ManActMethodStart::~vehicle_mainfi_tclMsgCam5ManActMethodStart()
{}

tU32 vehicle_mainfi_tclMsgCam5ManActMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCam5ManActMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RequestId);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCam5ManActMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RequestId);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCam5ManActMethodStart::operator==(const vehicle_mainfi_tclMsgCam5ManActMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RequestId == roRef.RequestId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCam5ManActMethodResult::vehicle_mainfi_tclMsgCam5ManActMethodResult(const vehicle_mainfi_tclMsgCam5ManActMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgCam5ManActMethodResult& vehicle_mainfi_tclMsgCam5ManActMethodResult::operator=(const vehicle_mainfi_tclMsgCam5ManActMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCam5ManActMethodResult::vehicle_mainfi_tclMsgCam5ManActMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgCam5ManActMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAM5MANACTMETHODRESULT;
}


vehicle_mainfi_tclMsgCam5ManActMethodResult::~vehicle_mainfi_tclMsgCam5ManActMethodResult()
{}

tU32 vehicle_mainfi_tclMsgCam5ManActMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCam5ManActMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCam5ManActMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCam5ManActMethodResult::operator==(const vehicle_mainfi_tclMsgCam5ManActMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCam6ManActMethodStart::vehicle_mainfi_tclMsgCam6ManActMethodStart(const vehicle_mainfi_tclMsgCam6ManActMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   RequestId = coRef.RequestId;
}
vehicle_mainfi_tclMsgCam6ManActMethodStart& vehicle_mainfi_tclMsgCam6ManActMethodStart::operator=(const vehicle_mainfi_tclMsgCam6ManActMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RequestId = coRef.RequestId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCam6ManActMethodStart::vehicle_mainfi_tclMsgCam6ManActMethodStart()
:RequestId(0)
 {}

tS32 vehicle_mainfi_tclMsgCam6ManActMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAM6MANACTMETHODSTART;
}


vehicle_mainfi_tclMsgCam6ManActMethodStart::~vehicle_mainfi_tclMsgCam6ManActMethodStart()
{}

tU32 vehicle_mainfi_tclMsgCam6ManActMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCam6ManActMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RequestId);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCam6ManActMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RequestId);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCam6ManActMethodStart::operator==(const vehicle_mainfi_tclMsgCam6ManActMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RequestId == roRef.RequestId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCam6ManActMethodResult::vehicle_mainfi_tclMsgCam6ManActMethodResult(const vehicle_mainfi_tclMsgCam6ManActMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgCam6ManActMethodResult& vehicle_mainfi_tclMsgCam6ManActMethodResult::operator=(const vehicle_mainfi_tclMsgCam6ManActMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCam6ManActMethodResult::vehicle_mainfi_tclMsgCam6ManActMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgCam6ManActMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAM6MANACTMETHODRESULT;
}


vehicle_mainfi_tclMsgCam6ManActMethodResult::~vehicle_mainfi_tclMsgCam6ManActMethodResult()
{}

tU32 vehicle_mainfi_tclMsgCam6ManActMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCam6ManActMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCam6ManActMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCam6ManActMethodResult::operator==(const vehicle_mainfi_tclMsgCam6ManActMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCam7ManActMethodStart::vehicle_mainfi_tclMsgCam7ManActMethodStart(const vehicle_mainfi_tclMsgCam7ManActMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   RequestId = coRef.RequestId;
}
vehicle_mainfi_tclMsgCam7ManActMethodStart& vehicle_mainfi_tclMsgCam7ManActMethodStart::operator=(const vehicle_mainfi_tclMsgCam7ManActMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RequestId = coRef.RequestId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCam7ManActMethodStart::vehicle_mainfi_tclMsgCam7ManActMethodStart()
:RequestId(0)
 {}

tS32 vehicle_mainfi_tclMsgCam7ManActMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAM7MANACTMETHODSTART;
}


vehicle_mainfi_tclMsgCam7ManActMethodStart::~vehicle_mainfi_tclMsgCam7ManActMethodStart()
{}

tU32 vehicle_mainfi_tclMsgCam7ManActMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCam7ManActMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RequestId);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCam7ManActMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RequestId);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCam7ManActMethodStart::operator==(const vehicle_mainfi_tclMsgCam7ManActMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RequestId == roRef.RequestId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCam7ManActMethodResult::vehicle_mainfi_tclMsgCam7ManActMethodResult(const vehicle_mainfi_tclMsgCam7ManActMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgCam7ManActMethodResult& vehicle_mainfi_tclMsgCam7ManActMethodResult::operator=(const vehicle_mainfi_tclMsgCam7ManActMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCam7ManActMethodResult::vehicle_mainfi_tclMsgCam7ManActMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgCam7ManActMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAM7MANACTMETHODRESULT;
}


vehicle_mainfi_tclMsgCam7ManActMethodResult::~vehicle_mainfi_tclMsgCam7ManActMethodResult()
{}

tU32 vehicle_mainfi_tclMsgCam7ManActMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCam7ManActMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCam7ManActMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCam7ManActMethodResult::operator==(const vehicle_mainfi_tclMsgCam7ManActMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCam8ManActMethodStart::vehicle_mainfi_tclMsgCam8ManActMethodStart(const vehicle_mainfi_tclMsgCam8ManActMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   RequestId = coRef.RequestId;
}
vehicle_mainfi_tclMsgCam8ManActMethodStart& vehicle_mainfi_tclMsgCam8ManActMethodStart::operator=(const vehicle_mainfi_tclMsgCam8ManActMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RequestId = coRef.RequestId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCam8ManActMethodStart::vehicle_mainfi_tclMsgCam8ManActMethodStart()
:RequestId(0)
 {}

tS32 vehicle_mainfi_tclMsgCam8ManActMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAM8MANACTMETHODSTART;
}


vehicle_mainfi_tclMsgCam8ManActMethodStart::~vehicle_mainfi_tclMsgCam8ManActMethodStart()
{}

tU32 vehicle_mainfi_tclMsgCam8ManActMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCam8ManActMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RequestId);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCam8ManActMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RequestId);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCam8ManActMethodStart::operator==(const vehicle_mainfi_tclMsgCam8ManActMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RequestId == roRef.RequestId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCam8ManActMethodResult::vehicle_mainfi_tclMsgCam8ManActMethodResult(const vehicle_mainfi_tclMsgCam8ManActMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgCam8ManActMethodResult& vehicle_mainfi_tclMsgCam8ManActMethodResult::operator=(const vehicle_mainfi_tclMsgCam8ManActMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCam8ManActMethodResult::vehicle_mainfi_tclMsgCam8ManActMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgCam8ManActMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAM8MANACTMETHODRESULT;
}


vehicle_mainfi_tclMsgCam8ManActMethodResult::~vehicle_mainfi_tclMsgCam8ManActMethodResult()
{}

tU32 vehicle_mainfi_tclMsgCam8ManActMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCam8ManActMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCam8ManActMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCam8ManActMethodResult::operator==(const vehicle_mainfi_tclMsgCam8ManActMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCam9ManActMethodStart::vehicle_mainfi_tclMsgCam9ManActMethodStart(const vehicle_mainfi_tclMsgCam9ManActMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   RequestId = coRef.RequestId;
}
vehicle_mainfi_tclMsgCam9ManActMethodStart& vehicle_mainfi_tclMsgCam9ManActMethodStart::operator=(const vehicle_mainfi_tclMsgCam9ManActMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RequestId = coRef.RequestId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCam9ManActMethodStart::vehicle_mainfi_tclMsgCam9ManActMethodStart()
:RequestId(0)
 {}

tS32 vehicle_mainfi_tclMsgCam9ManActMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAM9MANACTMETHODSTART;
}


vehicle_mainfi_tclMsgCam9ManActMethodStart::~vehicle_mainfi_tclMsgCam9ManActMethodStart()
{}

tU32 vehicle_mainfi_tclMsgCam9ManActMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCam9ManActMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RequestId);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCam9ManActMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RequestId);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCam9ManActMethodStart::operator==(const vehicle_mainfi_tclMsgCam9ManActMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RequestId == roRef.RequestId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCam9ManActMethodResult::vehicle_mainfi_tclMsgCam9ManActMethodResult(const vehicle_mainfi_tclMsgCam9ManActMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgCam9ManActMethodResult& vehicle_mainfi_tclMsgCam9ManActMethodResult::operator=(const vehicle_mainfi_tclMsgCam9ManActMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCam9ManActMethodResult::vehicle_mainfi_tclMsgCam9ManActMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgCam9ManActMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAM9MANACTMETHODRESULT;
}


vehicle_mainfi_tclMsgCam9ManActMethodResult::~vehicle_mainfi_tclMsgCam9ManActMethodResult()
{}

tU32 vehicle_mainfi_tclMsgCam9ManActMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCam9ManActMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCam9ManActMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCam9ManActMethodResult::operator==(const vehicle_mainfi_tclMsgCam9ManActMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCam10ManActMethodStart::vehicle_mainfi_tclMsgCam10ManActMethodStart(const vehicle_mainfi_tclMsgCam10ManActMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   RequestId = coRef.RequestId;
}
vehicle_mainfi_tclMsgCam10ManActMethodStart& vehicle_mainfi_tclMsgCam10ManActMethodStart::operator=(const vehicle_mainfi_tclMsgCam10ManActMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RequestId = coRef.RequestId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCam10ManActMethodStart::vehicle_mainfi_tclMsgCam10ManActMethodStart()
:RequestId(0)
 {}

tS32 vehicle_mainfi_tclMsgCam10ManActMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAM10MANACTMETHODSTART;
}


vehicle_mainfi_tclMsgCam10ManActMethodStart::~vehicle_mainfi_tclMsgCam10ManActMethodStart()
{}

tU32 vehicle_mainfi_tclMsgCam10ManActMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCam10ManActMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RequestId);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCam10ManActMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RequestId);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCam10ManActMethodStart::operator==(const vehicle_mainfi_tclMsgCam10ManActMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RequestId == roRef.RequestId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCam10ManActMethodResult::vehicle_mainfi_tclMsgCam10ManActMethodResult(const vehicle_mainfi_tclMsgCam10ManActMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgCam10ManActMethodResult& vehicle_mainfi_tclMsgCam10ManActMethodResult::operator=(const vehicle_mainfi_tclMsgCam10ManActMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCam10ManActMethodResult::vehicle_mainfi_tclMsgCam10ManActMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgCam10ManActMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAM10MANACTMETHODRESULT;
}


vehicle_mainfi_tclMsgCam10ManActMethodResult::~vehicle_mainfi_tclMsgCam10ManActMethodResult()
{}

tU32 vehicle_mainfi_tclMsgCam10ManActMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCam10ManActMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCam10ManActMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCam10ManActMethodResult::operator==(const vehicle_mainfi_tclMsgCam10ManActMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCam11ManActMethodStart::vehicle_mainfi_tclMsgCam11ManActMethodStart(const vehicle_mainfi_tclMsgCam11ManActMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   RequestId = coRef.RequestId;
}
vehicle_mainfi_tclMsgCam11ManActMethodStart& vehicle_mainfi_tclMsgCam11ManActMethodStart::operator=(const vehicle_mainfi_tclMsgCam11ManActMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RequestId = coRef.RequestId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCam11ManActMethodStart::vehicle_mainfi_tclMsgCam11ManActMethodStart()
:RequestId(0)
 {}

tS32 vehicle_mainfi_tclMsgCam11ManActMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAM11MANACTMETHODSTART;
}


vehicle_mainfi_tclMsgCam11ManActMethodStart::~vehicle_mainfi_tclMsgCam11ManActMethodStart()
{}

tU32 vehicle_mainfi_tclMsgCam11ManActMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCam11ManActMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RequestId);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCam11ManActMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RequestId);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCam11ManActMethodStart::operator==(const vehicle_mainfi_tclMsgCam11ManActMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RequestId == roRef.RequestId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCam11ManActMethodResult::vehicle_mainfi_tclMsgCam11ManActMethodResult(const vehicle_mainfi_tclMsgCam11ManActMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgCam11ManActMethodResult& vehicle_mainfi_tclMsgCam11ManActMethodResult::operator=(const vehicle_mainfi_tclMsgCam11ManActMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCam11ManActMethodResult::vehicle_mainfi_tclMsgCam11ManActMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgCam11ManActMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAM11MANACTMETHODRESULT;
}


vehicle_mainfi_tclMsgCam11ManActMethodResult::~vehicle_mainfi_tclMsgCam11ManActMethodResult()
{}

tU32 vehicle_mainfi_tclMsgCam11ManActMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCam11ManActMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCam11ManActMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCam11ManActMethodResult::operator==(const vehicle_mainfi_tclMsgCam11ManActMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCam12ManActMethodStart::vehicle_mainfi_tclMsgCam12ManActMethodStart(const vehicle_mainfi_tclMsgCam12ManActMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   RequestId = coRef.RequestId;
}
vehicle_mainfi_tclMsgCam12ManActMethodStart& vehicle_mainfi_tclMsgCam12ManActMethodStart::operator=(const vehicle_mainfi_tclMsgCam12ManActMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RequestId = coRef.RequestId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCam12ManActMethodStart::vehicle_mainfi_tclMsgCam12ManActMethodStart()
:RequestId(0)
 {}

tS32 vehicle_mainfi_tclMsgCam12ManActMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAM12MANACTMETHODSTART;
}


vehicle_mainfi_tclMsgCam12ManActMethodStart::~vehicle_mainfi_tclMsgCam12ManActMethodStart()
{}

tU32 vehicle_mainfi_tclMsgCam12ManActMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCam12ManActMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RequestId);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCam12ManActMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RequestId);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCam12ManActMethodStart::operator==(const vehicle_mainfi_tclMsgCam12ManActMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RequestId == roRef.RequestId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCam12ManActMethodResult::vehicle_mainfi_tclMsgCam12ManActMethodResult(const vehicle_mainfi_tclMsgCam12ManActMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgCam12ManActMethodResult& vehicle_mainfi_tclMsgCam12ManActMethodResult::operator=(const vehicle_mainfi_tclMsgCam12ManActMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCam12ManActMethodResult::vehicle_mainfi_tclMsgCam12ManActMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgCam12ManActMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAM12MANACTMETHODRESULT;
}


vehicle_mainfi_tclMsgCam12ManActMethodResult::~vehicle_mainfi_tclMsgCam12ManActMethodResult()
{}

tU32 vehicle_mainfi_tclMsgCam12ManActMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCam12ManActMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCam12ManActMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCam12ManActMethodResult::operator==(const vehicle_mainfi_tclMsgCam12ManActMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCam13ManActMethodStart::vehicle_mainfi_tclMsgCam13ManActMethodStart(const vehicle_mainfi_tclMsgCam13ManActMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   RequestId = coRef.RequestId;
}
vehicle_mainfi_tclMsgCam13ManActMethodStart& vehicle_mainfi_tclMsgCam13ManActMethodStart::operator=(const vehicle_mainfi_tclMsgCam13ManActMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RequestId = coRef.RequestId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCam13ManActMethodStart::vehicle_mainfi_tclMsgCam13ManActMethodStart()
:RequestId(0)
 {}

tS32 vehicle_mainfi_tclMsgCam13ManActMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAM13MANACTMETHODSTART;
}


vehicle_mainfi_tclMsgCam13ManActMethodStart::~vehicle_mainfi_tclMsgCam13ManActMethodStart()
{}

tU32 vehicle_mainfi_tclMsgCam13ManActMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCam13ManActMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RequestId);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCam13ManActMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RequestId);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCam13ManActMethodStart::operator==(const vehicle_mainfi_tclMsgCam13ManActMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RequestId == roRef.RequestId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCam13ManActMethodResult::vehicle_mainfi_tclMsgCam13ManActMethodResult(const vehicle_mainfi_tclMsgCam13ManActMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgCam13ManActMethodResult& vehicle_mainfi_tclMsgCam13ManActMethodResult::operator=(const vehicle_mainfi_tclMsgCam13ManActMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCam13ManActMethodResult::vehicle_mainfi_tclMsgCam13ManActMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgCam13ManActMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAM13MANACTMETHODRESULT;
}


vehicle_mainfi_tclMsgCam13ManActMethodResult::~vehicle_mainfi_tclMsgCam13ManActMethodResult()
{}

tU32 vehicle_mainfi_tclMsgCam13ManActMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCam13ManActMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCam13ManActMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCam13ManActMethodResult::operator==(const vehicle_mainfi_tclMsgCam13ManActMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCam14ManActMethodStart::vehicle_mainfi_tclMsgCam14ManActMethodStart(const vehicle_mainfi_tclMsgCam14ManActMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   RequestId = coRef.RequestId;
}
vehicle_mainfi_tclMsgCam14ManActMethodStart& vehicle_mainfi_tclMsgCam14ManActMethodStart::operator=(const vehicle_mainfi_tclMsgCam14ManActMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RequestId = coRef.RequestId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCam14ManActMethodStart::vehicle_mainfi_tclMsgCam14ManActMethodStart()
:RequestId(0)
 {}

tS32 vehicle_mainfi_tclMsgCam14ManActMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAM14MANACTMETHODSTART;
}


vehicle_mainfi_tclMsgCam14ManActMethodStart::~vehicle_mainfi_tclMsgCam14ManActMethodStart()
{}

tU32 vehicle_mainfi_tclMsgCam14ManActMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCam14ManActMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RequestId);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCam14ManActMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RequestId);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCam14ManActMethodStart::operator==(const vehicle_mainfi_tclMsgCam14ManActMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RequestId == roRef.RequestId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCam14ManActMethodResult::vehicle_mainfi_tclMsgCam14ManActMethodResult(const vehicle_mainfi_tclMsgCam14ManActMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgCam14ManActMethodResult& vehicle_mainfi_tclMsgCam14ManActMethodResult::operator=(const vehicle_mainfi_tclMsgCam14ManActMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCam14ManActMethodResult::vehicle_mainfi_tclMsgCam14ManActMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgCam14ManActMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAM14MANACTMETHODRESULT;
}


vehicle_mainfi_tclMsgCam14ManActMethodResult::~vehicle_mainfi_tclMsgCam14ManActMethodResult()
{}

tU32 vehicle_mainfi_tclMsgCam14ManActMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCam14ManActMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCam14ManActMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCam14ManActMethodResult::operator==(const vehicle_mainfi_tclMsgCam14ManActMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCam15ManActMethodStart::vehicle_mainfi_tclMsgCam15ManActMethodStart(const vehicle_mainfi_tclMsgCam15ManActMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   RequestId = coRef.RequestId;
}
vehicle_mainfi_tclMsgCam15ManActMethodStart& vehicle_mainfi_tclMsgCam15ManActMethodStart::operator=(const vehicle_mainfi_tclMsgCam15ManActMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RequestId = coRef.RequestId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCam15ManActMethodStart::vehicle_mainfi_tclMsgCam15ManActMethodStart()
:RequestId(0)
 {}

tS32 vehicle_mainfi_tclMsgCam15ManActMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAM15MANACTMETHODSTART;
}


vehicle_mainfi_tclMsgCam15ManActMethodStart::~vehicle_mainfi_tclMsgCam15ManActMethodStart()
{}

tU32 vehicle_mainfi_tclMsgCam15ManActMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCam15ManActMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RequestId);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCam15ManActMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RequestId);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCam15ManActMethodStart::operator==(const vehicle_mainfi_tclMsgCam15ManActMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RequestId == roRef.RequestId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCam15ManActMethodResult::vehicle_mainfi_tclMsgCam15ManActMethodResult(const vehicle_mainfi_tclMsgCam15ManActMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgCam15ManActMethodResult& vehicle_mainfi_tclMsgCam15ManActMethodResult::operator=(const vehicle_mainfi_tclMsgCam15ManActMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCam15ManActMethodResult::vehicle_mainfi_tclMsgCam15ManActMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgCam15ManActMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAM15MANACTMETHODRESULT;
}


vehicle_mainfi_tclMsgCam15ManActMethodResult::~vehicle_mainfi_tclMsgCam15ManActMethodResult()
{}

tU32 vehicle_mainfi_tclMsgCam15ManActMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCam15ManActMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCam15ManActMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCam15ManActMethodResult::operator==(const vehicle_mainfi_tclMsgCam15ManActMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCam16ManActMethodStart::vehicle_mainfi_tclMsgCam16ManActMethodStart(const vehicle_mainfi_tclMsgCam16ManActMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   RequestId = coRef.RequestId;
}
vehicle_mainfi_tclMsgCam16ManActMethodStart& vehicle_mainfi_tclMsgCam16ManActMethodStart::operator=(const vehicle_mainfi_tclMsgCam16ManActMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RequestId = coRef.RequestId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCam16ManActMethodStart::vehicle_mainfi_tclMsgCam16ManActMethodStart()
:RequestId(0)
 {}

tS32 vehicle_mainfi_tclMsgCam16ManActMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAM16MANACTMETHODSTART;
}


vehicle_mainfi_tclMsgCam16ManActMethodStart::~vehicle_mainfi_tclMsgCam16ManActMethodStart()
{}

tU32 vehicle_mainfi_tclMsgCam16ManActMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCam16ManActMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RequestId);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCam16ManActMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RequestId);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCam16ManActMethodStart::operator==(const vehicle_mainfi_tclMsgCam16ManActMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RequestId == roRef.RequestId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCam16ManActMethodResult::vehicle_mainfi_tclMsgCam16ManActMethodResult(const vehicle_mainfi_tclMsgCam16ManActMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgCam16ManActMethodResult& vehicle_mainfi_tclMsgCam16ManActMethodResult::operator=(const vehicle_mainfi_tclMsgCam16ManActMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCam16ManActMethodResult::vehicle_mainfi_tclMsgCam16ManActMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgCam16ManActMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAM16MANACTMETHODRESULT;
}


vehicle_mainfi_tclMsgCam16ManActMethodResult::~vehicle_mainfi_tclMsgCam16ManActMethodResult()
{}

tU32 vehicle_mainfi_tclMsgCam16ManActMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCam16ManActMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCam16ManActMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCam16ManActMethodResult::operator==(const vehicle_mainfi_tclMsgCam16ManActMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCam17ManActMethodStart::vehicle_mainfi_tclMsgCam17ManActMethodStart(const vehicle_mainfi_tclMsgCam17ManActMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   RequestId = coRef.RequestId;
}
vehicle_mainfi_tclMsgCam17ManActMethodStart& vehicle_mainfi_tclMsgCam17ManActMethodStart::operator=(const vehicle_mainfi_tclMsgCam17ManActMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RequestId = coRef.RequestId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCam17ManActMethodStart::vehicle_mainfi_tclMsgCam17ManActMethodStart()
:RequestId(0)
 {}

tS32 vehicle_mainfi_tclMsgCam17ManActMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAM17MANACTMETHODSTART;
}


vehicle_mainfi_tclMsgCam17ManActMethodStart::~vehicle_mainfi_tclMsgCam17ManActMethodStart()
{}

tU32 vehicle_mainfi_tclMsgCam17ManActMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCam17ManActMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RequestId);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCam17ManActMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RequestId);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCam17ManActMethodStart::operator==(const vehicle_mainfi_tclMsgCam17ManActMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RequestId == roRef.RequestId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCam17ManActMethodResult::vehicle_mainfi_tclMsgCam17ManActMethodResult(const vehicle_mainfi_tclMsgCam17ManActMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgCam17ManActMethodResult& vehicle_mainfi_tclMsgCam17ManActMethodResult::operator=(const vehicle_mainfi_tclMsgCam17ManActMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCam17ManActMethodResult::vehicle_mainfi_tclMsgCam17ManActMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgCam17ManActMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAM17MANACTMETHODRESULT;
}


vehicle_mainfi_tclMsgCam17ManActMethodResult::~vehicle_mainfi_tclMsgCam17ManActMethodResult()
{}

tU32 vehicle_mainfi_tclMsgCam17ManActMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCam17ManActMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCam17ManActMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCam17ManActMethodResult::operator==(const vehicle_mainfi_tclMsgCam17ManActMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgPrivacyResetAckMethodStart::vehicle_mainfi_tclMsgPrivacyResetAckMethodStart(const vehicle_mainfi_tclMsgPrivacyResetAckMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   RequestId = coRef.RequestId;
}
vehicle_mainfi_tclMsgPrivacyResetAckMethodStart& vehicle_mainfi_tclMsgPrivacyResetAckMethodStart::operator=(const vehicle_mainfi_tclMsgPrivacyResetAckMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RequestId = coRef.RequestId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgPrivacyResetAckMethodStart::vehicle_mainfi_tclMsgPrivacyResetAckMethodStart()
:RequestId(0)
 {}

tS32 vehicle_mainfi_tclMsgPrivacyResetAckMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_PRIVACYRESETACKMETHODSTART;
}


vehicle_mainfi_tclMsgPrivacyResetAckMethodStart::~vehicle_mainfi_tclMsgPrivacyResetAckMethodStart()
{}

tU32 vehicle_mainfi_tclMsgPrivacyResetAckMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgPrivacyResetAckMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RequestId);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgPrivacyResetAckMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RequestId);
   return oOut;
}

tBool vehicle_mainfi_tclMsgPrivacyResetAckMethodStart::operator==(const vehicle_mainfi_tclMsgPrivacyResetAckMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RequestId == roRef.RequestId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgPrivacyResetAckMethodResult::vehicle_mainfi_tclMsgPrivacyResetAckMethodResult(const vehicle_mainfi_tclMsgPrivacyResetAckMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgPrivacyResetAckMethodResult& vehicle_mainfi_tclMsgPrivacyResetAckMethodResult::operator=(const vehicle_mainfi_tclMsgPrivacyResetAckMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgPrivacyResetAckMethodResult::vehicle_mainfi_tclMsgPrivacyResetAckMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgPrivacyResetAckMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_PRIVACYRESETACKMETHODRESULT;
}


vehicle_mainfi_tclMsgPrivacyResetAckMethodResult::~vehicle_mainfi_tclMsgPrivacyResetAckMethodResult()
{}

tU32 vehicle_mainfi_tclMsgPrivacyResetAckMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgPrivacyResetAckMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgPrivacyResetAckMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgPrivacyResetAckMethodResult::operator==(const vehicle_mainfi_tclMsgPrivacyResetAckMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgDispCamClsMethodStart::vehicle_mainfi_tclMsgDispCamClsMethodStart(const vehicle_mainfi_tclMsgDispCamClsMethodStart& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   RequestId = coRef.RequestId;
}
vehicle_mainfi_tclMsgDispCamClsMethodStart& vehicle_mainfi_tclMsgDispCamClsMethodStart::operator=(const vehicle_mainfi_tclMsgDispCamClsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RequestId = coRef.RequestId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgDispCamClsMethodStart::vehicle_mainfi_tclMsgDispCamClsMethodStart()
:RequestId(0)
 {}

tS32 vehicle_mainfi_tclMsgDispCamClsMethodStart::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DISPCAMCLSMETHODSTART;
}


vehicle_mainfi_tclMsgDispCamClsMethodStart::~vehicle_mainfi_tclMsgDispCamClsMethodStart()
{}

tU32 vehicle_mainfi_tclMsgDispCamClsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgDispCamClsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RequestId);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgDispCamClsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RequestId);
   return oOut;
}

tBool vehicle_mainfi_tclMsgDispCamClsMethodStart::operator==(const vehicle_mainfi_tclMsgDispCamClsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RequestId == roRef.RequestId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgDispCamClsMethodResult::vehicle_mainfi_tclMsgDispCamClsMethodResult(const vehicle_mainfi_tclMsgDispCamClsMethodResult& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
vehicle_mainfi_tclMsgDispCamClsMethodResult& vehicle_mainfi_tclMsgDispCamClsMethodResult::operator=(const vehicle_mainfi_tclMsgDispCamClsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgDispCamClsMethodResult::vehicle_mainfi_tclMsgDispCamClsMethodResult()
:Result(0)
 {}

tS32 vehicle_mainfi_tclMsgDispCamClsMethodResult::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DISPCAMCLSMETHODRESULT;
}


vehicle_mainfi_tclMsgDispCamClsMethodResult::~vehicle_mainfi_tclMsgDispCamClsMethodResult()
{}

tU32 vehicle_mainfi_tclMsgDispCamClsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgDispCamClsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgDispCamClsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool vehicle_mainfi_tclMsgDispCamClsMethodResult::operator==(const vehicle_mainfi_tclMsgDispCamClsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgDistanceUnitUpReg::vehicle_mainfi_tclMsgDistanceUnitUpReg()
 {}

tS32 vehicle_mainfi_tclMsgDistanceUnitUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DISTANCEUNITUPREG;
}


vehicle_mainfi_tclMsgDistanceUnitUpReg::~vehicle_mainfi_tclMsgDistanceUnitUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgDistanceUnitRelUpReg::vehicle_mainfi_tclMsgDistanceUnitRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgDistanceUnitRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DISTANCEUNITRELUPREG;
}


vehicle_mainfi_tclMsgDistanceUnitRelUpReg::~vehicle_mainfi_tclMsgDistanceUnitRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgDistanceUnitGet::vehicle_mainfi_tclMsgDistanceUnitGet()
 {}

tS32 vehicle_mainfi_tclMsgDistanceUnitGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DISTANCEUNITGET;
}


vehicle_mainfi_tclMsgDistanceUnitGet::~vehicle_mainfi_tclMsgDistanceUnitGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgDistanceUnitSet::vehicle_mainfi_tclMsgDistanceUnitSet(const vehicle_mainfi_tclMsgDistanceUnitSet& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   e8DistanceUnit = coRef.e8DistanceUnit;
}
vehicle_mainfi_tclMsgDistanceUnitSet& vehicle_mainfi_tclMsgDistanceUnitSet::operator=(const vehicle_mainfi_tclMsgDistanceUnitSet& coRef)
{
   if (this == &coRef) return *this;
   e8DistanceUnit = coRef.e8DistanceUnit;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgDistanceUnitSet::vehicle_mainfi_tclMsgDistanceUnitSet()
:e8DistanceUnit()
 {}

tS32 vehicle_mainfi_tclMsgDistanceUnitSet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DISTANCEUNITSET;
}


vehicle_mainfi_tclMsgDistanceUnitSet::~vehicle_mainfi_tclMsgDistanceUnitSet()
{}

tU32 vehicle_mainfi_tclMsgDistanceUnitSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgDistanceUnitSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8DistanceUnit);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgDistanceUnitSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8DistanceUnit);
   return oOut;
}

tBool vehicle_mainfi_tclMsgDistanceUnitSet::operator==(const vehicle_mainfi_tclMsgDistanceUnitSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8DistanceUnit == roRef.e8DistanceUnit);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgDistanceUnitStatus::vehicle_mainfi_tclMsgDistanceUnitStatus(const vehicle_mainfi_tclMsgDistanceUnitStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   e8DistanceUnit = coRef.e8DistanceUnit;
}
vehicle_mainfi_tclMsgDistanceUnitStatus& vehicle_mainfi_tclMsgDistanceUnitStatus::operator=(const vehicle_mainfi_tclMsgDistanceUnitStatus& coRef)
{
   if (this == &coRef) return *this;
   e8DistanceUnit = coRef.e8DistanceUnit;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgDistanceUnitStatus::vehicle_mainfi_tclMsgDistanceUnitStatus()
:e8DistanceUnit()
 {}

tS32 vehicle_mainfi_tclMsgDistanceUnitStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DISTANCEUNITSTATUS;
}


vehicle_mainfi_tclMsgDistanceUnitStatus::~vehicle_mainfi_tclMsgDistanceUnitStatus()
{}

tU32 vehicle_mainfi_tclMsgDistanceUnitStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgDistanceUnitStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8DistanceUnit);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgDistanceUnitStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8DistanceUnit);
   return oOut;
}

tBool vehicle_mainfi_tclMsgDistanceUnitStatus::operator==(const vehicle_mainfi_tclMsgDistanceUnitStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8DistanceUnit == roRef.e8DistanceUnit);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgFuelConsumptionUnitUpReg::vehicle_mainfi_tclMsgFuelConsumptionUnitUpReg()
 {}

tS32 vehicle_mainfi_tclMsgFuelConsumptionUnitUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_FUELCONSUMPTIONUNITUPREG;
}


vehicle_mainfi_tclMsgFuelConsumptionUnitUpReg::~vehicle_mainfi_tclMsgFuelConsumptionUnitUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgFuelConsumptionUnitRelUpReg::vehicle_mainfi_tclMsgFuelConsumptionUnitRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgFuelConsumptionUnitRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_FUELCONSUMPTIONUNITRELUPREG;
}


vehicle_mainfi_tclMsgFuelConsumptionUnitRelUpReg::~vehicle_mainfi_tclMsgFuelConsumptionUnitRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgFuelConsumptionUnitGet::vehicle_mainfi_tclMsgFuelConsumptionUnitGet()
 {}

tS32 vehicle_mainfi_tclMsgFuelConsumptionUnitGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_FUELCONSUMPTIONUNITGET;
}


vehicle_mainfi_tclMsgFuelConsumptionUnitGet::~vehicle_mainfi_tclMsgFuelConsumptionUnitGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgFuelConsumptionUnitSet::vehicle_mainfi_tclMsgFuelConsumptionUnitSet(const vehicle_mainfi_tclMsgFuelConsumptionUnitSet& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   e8FuelConsumpUnit = coRef.e8FuelConsumpUnit;
}
vehicle_mainfi_tclMsgFuelConsumptionUnitSet& vehicle_mainfi_tclMsgFuelConsumptionUnitSet::operator=(const vehicle_mainfi_tclMsgFuelConsumptionUnitSet& coRef)
{
   if (this == &coRef) return *this;
   e8FuelConsumpUnit = coRef.e8FuelConsumpUnit;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgFuelConsumptionUnitSet::vehicle_mainfi_tclMsgFuelConsumptionUnitSet()
:e8FuelConsumpUnit()
 {}

tS32 vehicle_mainfi_tclMsgFuelConsumptionUnitSet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_FUELCONSUMPTIONUNITSET;
}


vehicle_mainfi_tclMsgFuelConsumptionUnitSet::~vehicle_mainfi_tclMsgFuelConsumptionUnitSet()
{}

tU32 vehicle_mainfi_tclMsgFuelConsumptionUnitSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgFuelConsumptionUnitSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8FuelConsumpUnit);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgFuelConsumptionUnitSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8FuelConsumpUnit);
   return oOut;
}

tBool vehicle_mainfi_tclMsgFuelConsumptionUnitSet::operator==(const vehicle_mainfi_tclMsgFuelConsumptionUnitSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8FuelConsumpUnit == roRef.e8FuelConsumpUnit);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgFuelConsumptionUnitStatus::vehicle_mainfi_tclMsgFuelConsumptionUnitStatus(const vehicle_mainfi_tclMsgFuelConsumptionUnitStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   e8FuelConsumpUnit = coRef.e8FuelConsumpUnit;
}
vehicle_mainfi_tclMsgFuelConsumptionUnitStatus& vehicle_mainfi_tclMsgFuelConsumptionUnitStatus::operator=(const vehicle_mainfi_tclMsgFuelConsumptionUnitStatus& coRef)
{
   if (this == &coRef) return *this;
   e8FuelConsumpUnit = coRef.e8FuelConsumpUnit;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgFuelConsumptionUnitStatus::vehicle_mainfi_tclMsgFuelConsumptionUnitStatus()
:e8FuelConsumpUnit()
 {}

tS32 vehicle_mainfi_tclMsgFuelConsumptionUnitStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_FUELCONSUMPTIONUNITSTATUS;
}


vehicle_mainfi_tclMsgFuelConsumptionUnitStatus::~vehicle_mainfi_tclMsgFuelConsumptionUnitStatus()
{}

tU32 vehicle_mainfi_tclMsgFuelConsumptionUnitStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgFuelConsumptionUnitStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8FuelConsumpUnit);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgFuelConsumptionUnitStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8FuelConsumpUnit);
   return oOut;
}

tBool vehicle_mainfi_tclMsgFuelConsumptionUnitStatus::operator==(const vehicle_mainfi_tclMsgFuelConsumptionUnitStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8FuelConsumpUnit == roRef.e8FuelConsumpUnit);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgTemperatureUnitUpReg::vehicle_mainfi_tclMsgTemperatureUnitUpReg()
 {}

tS32 vehicle_mainfi_tclMsgTemperatureUnitUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TEMPERATUREUNITUPREG;
}


vehicle_mainfi_tclMsgTemperatureUnitUpReg::~vehicle_mainfi_tclMsgTemperatureUnitUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgTemperatureUnitRelUpReg::vehicle_mainfi_tclMsgTemperatureUnitRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgTemperatureUnitRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TEMPERATUREUNITRELUPREG;
}


vehicle_mainfi_tclMsgTemperatureUnitRelUpReg::~vehicle_mainfi_tclMsgTemperatureUnitRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgTemperatureUnitGet::vehicle_mainfi_tclMsgTemperatureUnitGet()
 {}

tS32 vehicle_mainfi_tclMsgTemperatureUnitGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TEMPERATUREUNITGET;
}


vehicle_mainfi_tclMsgTemperatureUnitGet::~vehicle_mainfi_tclMsgTemperatureUnitGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgTemperatureUnitSet::vehicle_mainfi_tclMsgTemperatureUnitSet(const vehicle_mainfi_tclMsgTemperatureUnitSet& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   e8TempUnit = coRef.e8TempUnit;
}
vehicle_mainfi_tclMsgTemperatureUnitSet& vehicle_mainfi_tclMsgTemperatureUnitSet::operator=(const vehicle_mainfi_tclMsgTemperatureUnitSet& coRef)
{
   if (this == &coRef) return *this;
   e8TempUnit = coRef.e8TempUnit;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgTemperatureUnitSet::vehicle_mainfi_tclMsgTemperatureUnitSet()
:e8TempUnit()
 {}

tS32 vehicle_mainfi_tclMsgTemperatureUnitSet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TEMPERATUREUNITSET;
}


vehicle_mainfi_tclMsgTemperatureUnitSet::~vehicle_mainfi_tclMsgTemperatureUnitSet()
{}

tU32 vehicle_mainfi_tclMsgTemperatureUnitSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgTemperatureUnitSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8TempUnit);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgTemperatureUnitSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8TempUnit);
   return oOut;
}

tBool vehicle_mainfi_tclMsgTemperatureUnitSet::operator==(const vehicle_mainfi_tclMsgTemperatureUnitSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8TempUnit == roRef.e8TempUnit);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgTemperatureUnitStatus::vehicle_mainfi_tclMsgTemperatureUnitStatus(const vehicle_mainfi_tclMsgTemperatureUnitStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   e8TempUnit = coRef.e8TempUnit;
}
vehicle_mainfi_tclMsgTemperatureUnitStatus& vehicle_mainfi_tclMsgTemperatureUnitStatus::operator=(const vehicle_mainfi_tclMsgTemperatureUnitStatus& coRef)
{
   if (this == &coRef) return *this;
   e8TempUnit = coRef.e8TempUnit;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgTemperatureUnitStatus::vehicle_mainfi_tclMsgTemperatureUnitStatus()
:e8TempUnit()
 {}

tS32 vehicle_mainfi_tclMsgTemperatureUnitStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TEMPERATUREUNITSTATUS;
}


vehicle_mainfi_tclMsgTemperatureUnitStatus::~vehicle_mainfi_tclMsgTemperatureUnitStatus()
{}

tU32 vehicle_mainfi_tclMsgTemperatureUnitStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgTemperatureUnitStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8TempUnit);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgTemperatureUnitStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8TempUnit);
   return oOut;
}

tBool vehicle_mainfi_tclMsgTemperatureUnitStatus::operator==(const vehicle_mainfi_tclMsgTemperatureUnitStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8TempUnit == roRef.e8TempUnit);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgLanguageUpReg::vehicle_mainfi_tclMsgLanguageUpReg()
 {}

tS32 vehicle_mainfi_tclMsgLanguageUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_LANGUAGEUPREG;
}


vehicle_mainfi_tclMsgLanguageUpReg::~vehicle_mainfi_tclMsgLanguageUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgLanguageRelUpReg::vehicle_mainfi_tclMsgLanguageRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgLanguageRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_LANGUAGERELUPREG;
}


vehicle_mainfi_tclMsgLanguageRelUpReg::~vehicle_mainfi_tclMsgLanguageRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgLanguageGet::vehicle_mainfi_tclMsgLanguageGet()
 {}

tS32 vehicle_mainfi_tclMsgLanguageGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_LANGUAGEGET;
}


vehicle_mainfi_tclMsgLanguageGet::~vehicle_mainfi_tclMsgLanguageGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgLanguageStatus::vehicle_mainfi_tclMsgLanguageStatus(const vehicle_mainfi_tclMsgLanguageStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Language = coRef.Language;
   LangTable = coRef.LangTable;
}
vehicle_mainfi_tclMsgLanguageStatus& vehicle_mainfi_tclMsgLanguageStatus::operator=(const vehicle_mainfi_tclMsgLanguageStatus& coRef)
{
   if (this == &coRef) return *this;
   Language = coRef.Language;
   LangTable = coRef.LangTable;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid vehicle_mainfi_tclMsgLanguageStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < LangTable.size(); ++u32Idx)
         LangTable[u32Idx].vDestroy();
   LangTable.clear();
   }
}

vehicle_mainfi_tclMsgLanguageStatus::vehicle_mainfi_tclMsgLanguageStatus()
:Language()

 {}

tS32 vehicle_mainfi_tclMsgLanguageStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_LANGUAGESTATUS;
}


vehicle_mainfi_tclMsgLanguageStatus::~vehicle_mainfi_tclMsgLanguageStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 vehicle_mainfi_tclMsgLanguageStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+ static_cast<tU32>(LangTable.size()*3);
}

fi_tclInContext& vehicle_mainfi_tclMsgLanguageStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Language);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < LangTable.size(); ++u32Idx)
      {
         LangTable[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      LangTable.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> LangTable[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgLanguageStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Language);
   (tVoid) (oOut << (tU32)LangTable.size());
   {
      for (tU32 u32Idx = 0; u32Idx < LangTable.size(); ++u32Idx)
         (tVoid) (oOut << LangTable[u32Idx]);
   }
   return oOut;
}

tBool vehicle_mainfi_tclMsgLanguageStatus::operator==(const vehicle_mainfi_tclMsgLanguageStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Language == roRef.Language);
      bResult = bResult && (LangTable.size() == roRef.LangTable.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < LangTable.size()); ++u32Idx)
            bResult = bResult && (LangTable[u32Idx] == roRef.LangTable[u32Idx]);
      }
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgLanguageSyncSourceUpReg::vehicle_mainfi_tclMsgLanguageSyncSourceUpReg()
 {}

tS32 vehicle_mainfi_tclMsgLanguageSyncSourceUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_LANGUAGESYNCSOURCEUPREG;
}


vehicle_mainfi_tclMsgLanguageSyncSourceUpReg::~vehicle_mainfi_tclMsgLanguageSyncSourceUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgLanguageSyncSourceRelUpReg::vehicle_mainfi_tclMsgLanguageSyncSourceRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgLanguageSyncSourceRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_LANGUAGESYNCSOURCERELUPREG;
}


vehicle_mainfi_tclMsgLanguageSyncSourceRelUpReg::~vehicle_mainfi_tclMsgLanguageSyncSourceRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgLanguageSyncSourceGet::vehicle_mainfi_tclMsgLanguageSyncSourceGet()
 {}

tS32 vehicle_mainfi_tclMsgLanguageSyncSourceGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_LANGUAGESYNCSOURCEGET;
}


vehicle_mainfi_tclMsgLanguageSyncSourceGet::~vehicle_mainfi_tclMsgLanguageSyncSourceGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgLanguageSyncSourceSet::vehicle_mainfi_tclMsgLanguageSyncSourceSet(const vehicle_mainfi_tclMsgLanguageSyncSourceSet& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Language = coRef.Language;
}
vehicle_mainfi_tclMsgLanguageSyncSourceSet& vehicle_mainfi_tclMsgLanguageSyncSourceSet::operator=(const vehicle_mainfi_tclMsgLanguageSyncSourceSet& coRef)
{
   if (this == &coRef) return *this;
   Language = coRef.Language;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgLanguageSyncSourceSet::vehicle_mainfi_tclMsgLanguageSyncSourceSet()
:Language()
 {}

tS32 vehicle_mainfi_tclMsgLanguageSyncSourceSet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_LANGUAGESYNCSOURCESET;
}


vehicle_mainfi_tclMsgLanguageSyncSourceSet::~vehicle_mainfi_tclMsgLanguageSyncSourceSet()
{}

tU32 vehicle_mainfi_tclMsgLanguageSyncSourceSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgLanguageSyncSourceSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Language);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgLanguageSyncSourceSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Language);
   return oOut;
}

tBool vehicle_mainfi_tclMsgLanguageSyncSourceSet::operator==(const vehicle_mainfi_tclMsgLanguageSyncSourceSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Language == roRef.Language);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgLanguageSyncSourceStatus::vehicle_mainfi_tclMsgLanguageSyncSourceStatus(const vehicle_mainfi_tclMsgLanguageSyncSourceStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Language = coRef.Language;
}
vehicle_mainfi_tclMsgLanguageSyncSourceStatus& vehicle_mainfi_tclMsgLanguageSyncSourceStatus::operator=(const vehicle_mainfi_tclMsgLanguageSyncSourceStatus& coRef)
{
   if (this == &coRef) return *this;
   Language = coRef.Language;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgLanguageSyncSourceStatus::vehicle_mainfi_tclMsgLanguageSyncSourceStatus()
:Language()
 {}

tS32 vehicle_mainfi_tclMsgLanguageSyncSourceStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_LANGUAGESYNCSOURCESTATUS;
}


vehicle_mainfi_tclMsgLanguageSyncSourceStatus::~vehicle_mainfi_tclMsgLanguageSyncSourceStatus()
{}

tU32 vehicle_mainfi_tclMsgLanguageSyncSourceStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgLanguageSyncSourceStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Language);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgLanguageSyncSourceStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Language);
   return oOut;
}

tBool vehicle_mainfi_tclMsgLanguageSyncSourceStatus::operator==(const vehicle_mainfi_tclMsgLanguageSyncSourceStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Language == roRef.Language);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgMeterLanguageKnowledgeUpReg::vehicle_mainfi_tclMsgMeterLanguageKnowledgeUpReg()
 {}

tS32 vehicle_mainfi_tclMsgMeterLanguageKnowledgeUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_METERLANGUAGEKNOWLEDGEUPREG;
}


vehicle_mainfi_tclMsgMeterLanguageKnowledgeUpReg::~vehicle_mainfi_tclMsgMeterLanguageKnowledgeUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgMeterLanguageKnowledgeRelUpReg::vehicle_mainfi_tclMsgMeterLanguageKnowledgeRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgMeterLanguageKnowledgeRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_METERLANGUAGEKNOWLEDGERELUPREG;
}


vehicle_mainfi_tclMsgMeterLanguageKnowledgeRelUpReg::~vehicle_mainfi_tclMsgMeterLanguageKnowledgeRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgMeterLanguageKnowledgeGet::vehicle_mainfi_tclMsgMeterLanguageKnowledgeGet()
 {}

tS32 vehicle_mainfi_tclMsgMeterLanguageKnowledgeGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_METERLANGUAGEKNOWLEDGEGET;
}


vehicle_mainfi_tclMsgMeterLanguageKnowledgeGet::~vehicle_mainfi_tclMsgMeterLanguageKnowledgeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMeterLanguageKnowledgeStatus::vehicle_mainfi_tclMsgMeterLanguageKnowledgeStatus(const vehicle_mainfi_tclMsgMeterLanguageKnowledgeStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   State = coRef.State;
}
vehicle_mainfi_tclMsgMeterLanguageKnowledgeStatus& vehicle_mainfi_tclMsgMeterLanguageKnowledgeStatus::operator=(const vehicle_mainfi_tclMsgMeterLanguageKnowledgeStatus& coRef)
{
   if (this == &coRef) return *this;
   State = coRef.State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMeterLanguageKnowledgeStatus::vehicle_mainfi_tclMsgMeterLanguageKnowledgeStatus()
:State()
 {}

tS32 vehicle_mainfi_tclMsgMeterLanguageKnowledgeStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_METERLANGUAGEKNOWLEDGESTATUS;
}


vehicle_mainfi_tclMsgMeterLanguageKnowledgeStatus::~vehicle_mainfi_tclMsgMeterLanguageKnowledgeStatus()
{}

tU32 vehicle_mainfi_tclMsgMeterLanguageKnowledgeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgMeterLanguageKnowledgeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> State);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMeterLanguageKnowledgeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << State);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMeterLanguageKnowledgeStatus::operator==(const vehicle_mainfi_tclMsgMeterLanguageKnowledgeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (State == roRef.State);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgHandBrakeUpReg::vehicle_mainfi_tclMsgHandBrakeUpReg()
 {}

tS32 vehicle_mainfi_tclMsgHandBrakeUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_HANDBRAKEUPREG;
}


vehicle_mainfi_tclMsgHandBrakeUpReg::~vehicle_mainfi_tclMsgHandBrakeUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgHandBrakeRelUpReg::vehicle_mainfi_tclMsgHandBrakeRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgHandBrakeRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_HANDBRAKERELUPREG;
}


vehicle_mainfi_tclMsgHandBrakeRelUpReg::~vehicle_mainfi_tclMsgHandBrakeRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgHandBrakeGet::vehicle_mainfi_tclMsgHandBrakeGet()
 {}

tS32 vehicle_mainfi_tclMsgHandBrakeGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_HANDBRAKEGET;
}


vehicle_mainfi_tclMsgHandBrakeGet::~vehicle_mainfi_tclMsgHandBrakeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgHandBrakeStatus::vehicle_mainfi_tclMsgHandBrakeStatus(const vehicle_mainfi_tclMsgHandBrakeStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   e8Status = coRef.e8Status;
}
vehicle_mainfi_tclMsgHandBrakeStatus& vehicle_mainfi_tclMsgHandBrakeStatus::operator=(const vehicle_mainfi_tclMsgHandBrakeStatus& coRef)
{
   if (this == &coRef) return *this;
   e8Status = coRef.e8Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgHandBrakeStatus::vehicle_mainfi_tclMsgHandBrakeStatus()
:e8Status()
 {}

tS32 vehicle_mainfi_tclMsgHandBrakeStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_HANDBRAKESTATUS;
}


vehicle_mainfi_tclMsgHandBrakeStatus::~vehicle_mainfi_tclMsgHandBrakeStatus()
{}

tU32 vehicle_mainfi_tclMsgHandBrakeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgHandBrakeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Status);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgHandBrakeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Status);
   return oOut;
}

tBool vehicle_mainfi_tclMsgHandBrakeStatus::operator==(const vehicle_mainfi_tclMsgHandBrakeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Status == roRef.e8Status);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgIgnitionUpReg::vehicle_mainfi_tclMsgIgnitionUpReg()
 {}

tS32 vehicle_mainfi_tclMsgIgnitionUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_IGNITIONUPREG;
}


vehicle_mainfi_tclMsgIgnitionUpReg::~vehicle_mainfi_tclMsgIgnitionUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgIgnitionRelUpReg::vehicle_mainfi_tclMsgIgnitionRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgIgnitionRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_IGNITIONRELUPREG;
}


vehicle_mainfi_tclMsgIgnitionRelUpReg::~vehicle_mainfi_tclMsgIgnitionRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgIgnitionGet::vehicle_mainfi_tclMsgIgnitionGet()
 {}

tS32 vehicle_mainfi_tclMsgIgnitionGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_IGNITIONGET;
}


vehicle_mainfi_tclMsgIgnitionGet::~vehicle_mainfi_tclMsgIgnitionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgIgnitionStatus::vehicle_mainfi_tclMsgIgnitionStatus(const vehicle_mainfi_tclMsgIgnitionStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   e8Status = coRef.e8Status;
}
vehicle_mainfi_tclMsgIgnitionStatus& vehicle_mainfi_tclMsgIgnitionStatus::operator=(const vehicle_mainfi_tclMsgIgnitionStatus& coRef)
{
   if (this == &coRef) return *this;
   e8Status = coRef.e8Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgIgnitionStatus::vehicle_mainfi_tclMsgIgnitionStatus()
:e8Status()
 {}

tS32 vehicle_mainfi_tclMsgIgnitionStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_IGNITIONSTATUS;
}


vehicle_mainfi_tclMsgIgnitionStatus::~vehicle_mainfi_tclMsgIgnitionStatus()
{}

tU32 vehicle_mainfi_tclMsgIgnitionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgIgnitionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Status);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgIgnitionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Status);
   return oOut;
}

tBool vehicle_mainfi_tclMsgIgnitionStatus::operator==(const vehicle_mainfi_tclMsgIgnitionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Status == roRef.e8Status);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgSpeedUpReg::vehicle_mainfi_tclMsgSpeedUpReg()
 {}

tS32 vehicle_mainfi_tclMsgSpeedUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SPEEDUPREG;
}


vehicle_mainfi_tclMsgSpeedUpReg::~vehicle_mainfi_tclMsgSpeedUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgSpeedRelUpReg::vehicle_mainfi_tclMsgSpeedRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgSpeedRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SPEEDRELUPREG;
}


vehicle_mainfi_tclMsgSpeedRelUpReg::~vehicle_mainfi_tclMsgSpeedRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgSpeedGet::vehicle_mainfi_tclMsgSpeedGet()
 {}

tS32 vehicle_mainfi_tclMsgSpeedGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SPEEDGET;
}


vehicle_mainfi_tclMsgSpeedGet::~vehicle_mainfi_tclMsgSpeedGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSpeedStatus::vehicle_mainfi_tclMsgSpeedStatus(const vehicle_mainfi_tclMsgSpeedStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   SpeedValue = coRef.SpeedValue;
}
vehicle_mainfi_tclMsgSpeedStatus& vehicle_mainfi_tclMsgSpeedStatus::operator=(const vehicle_mainfi_tclMsgSpeedStatus& coRef)
{
   if (this == &coRef) return *this;
   SpeedValue = coRef.SpeedValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgSpeedStatus::vehicle_mainfi_tclMsgSpeedStatus()
:SpeedValue(0)
 {}

tS32 vehicle_mainfi_tclMsgSpeedStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SPEEDSTATUS;
}


vehicle_mainfi_tclMsgSpeedStatus::~vehicle_mainfi_tclMsgSpeedStatus()
{}

tU32 vehicle_mainfi_tclMsgSpeedStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& vehicle_mainfi_tclMsgSpeedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SpeedValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSpeedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SpeedValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSpeedStatus::operator==(const vehicle_mainfi_tclMsgSpeedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SpeedValue == roRef.SpeedValue);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgSpeedLimitUpReg::vehicle_mainfi_tclMsgSpeedLimitUpReg()
 {}

tS32 vehicle_mainfi_tclMsgSpeedLimitUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SPEEDLIMITUPREG;
}


vehicle_mainfi_tclMsgSpeedLimitUpReg::~vehicle_mainfi_tclMsgSpeedLimitUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgSpeedLimitRelUpReg::vehicle_mainfi_tclMsgSpeedLimitRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgSpeedLimitRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SPEEDLIMITRELUPREG;
}


vehicle_mainfi_tclMsgSpeedLimitRelUpReg::~vehicle_mainfi_tclMsgSpeedLimitRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgSpeedLimitGet::vehicle_mainfi_tclMsgSpeedLimitGet()
 {}

tS32 vehicle_mainfi_tclMsgSpeedLimitGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SPEEDLIMITGET;
}


vehicle_mainfi_tclMsgSpeedLimitGet::~vehicle_mainfi_tclMsgSpeedLimitGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSpeedLimitStatus::vehicle_mainfi_tclMsgSpeedLimitStatus(const vehicle_mainfi_tclMsgSpeedLimitStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   SpeedLimit1 = coRef.SpeedLimit1;
   SpeedLimit2 = coRef.SpeedLimit2;
   Display = coRef.Display;
   DisplayUnit = coRef.DisplayUnit;
   OverSpeed = coRef.OverSpeed;
   FreeSpeed = coRef.FreeSpeed;
}
vehicle_mainfi_tclMsgSpeedLimitStatus& vehicle_mainfi_tclMsgSpeedLimitStatus::operator=(const vehicle_mainfi_tclMsgSpeedLimitStatus& coRef)
{
   if (this == &coRef) return *this;
   SpeedLimit1 = coRef.SpeedLimit1;
   SpeedLimit2 = coRef.SpeedLimit2;
   Display = coRef.Display;
   DisplayUnit = coRef.DisplayUnit;
   OverSpeed = coRef.OverSpeed;
   FreeSpeed = coRef.FreeSpeed;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgSpeedLimitStatus::vehicle_mainfi_tclMsgSpeedLimitStatus()
:SpeedLimit1(0)
,SpeedLimit2(0)
,Display(0)
,DisplayUnit()
,OverSpeed(0)
,FreeSpeed(0)
 {}

tS32 vehicle_mainfi_tclMsgSpeedLimitStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SPEEDLIMITSTATUS;
}


vehicle_mainfi_tclMsgSpeedLimitStatus::~vehicle_mainfi_tclMsgSpeedLimitStatus()
{}

tU32 vehicle_mainfi_tclMsgSpeedLimitStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& vehicle_mainfi_tclMsgSpeedLimitStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SpeedLimit1);
   (tVoid) (oIn >> SpeedLimit2);
   (tVoid) (oIn >> Display);
   (tVoid) (oIn >> DisplayUnit);
   (tVoid) (oIn >> OverSpeed);
   (tVoid) (oIn >> FreeSpeed);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSpeedLimitStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SpeedLimit1);
   (tVoid) (oOut << SpeedLimit2);
   (tVoid) (oOut << Display);
   (tVoid) (oOut << DisplayUnit);
   (tVoid) (oOut << OverSpeed);
   (tVoid) (oOut << FreeSpeed);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSpeedLimitStatus::operator==(const vehicle_mainfi_tclMsgSpeedLimitStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SpeedLimit1 == roRef.SpeedLimit1);
   bResult = bResult && (SpeedLimit2 == roRef.SpeedLimit2);
   bResult = bResult && (Display == roRef.Display);
   bResult = bResult && (DisplayUnit == roRef.DisplayUnit);
   bResult = bResult && (OverSpeed == roRef.OverSpeed);
   bResult = bResult && (FreeSpeed == roRef.FreeSpeed);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgReverseGearUpReg::vehicle_mainfi_tclMsgReverseGearUpReg()
 {}

tS32 vehicle_mainfi_tclMsgReverseGearUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_REVERSEGEARUPREG;
}


vehicle_mainfi_tclMsgReverseGearUpReg::~vehicle_mainfi_tclMsgReverseGearUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgReverseGearRelUpReg::vehicle_mainfi_tclMsgReverseGearRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgReverseGearRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_REVERSEGEARRELUPREG;
}


vehicle_mainfi_tclMsgReverseGearRelUpReg::~vehicle_mainfi_tclMsgReverseGearRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgReverseGearGet::vehicle_mainfi_tclMsgReverseGearGet()
 {}

tS32 vehicle_mainfi_tclMsgReverseGearGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_REVERSEGEARGET;
}


vehicle_mainfi_tclMsgReverseGearGet::~vehicle_mainfi_tclMsgReverseGearGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgReverseGearStatus::vehicle_mainfi_tclMsgReverseGearStatus(const vehicle_mainfi_tclMsgReverseGearStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   State = coRef.State;
}
vehicle_mainfi_tclMsgReverseGearStatus& vehicle_mainfi_tclMsgReverseGearStatus::operator=(const vehicle_mainfi_tclMsgReverseGearStatus& coRef)
{
   if (this == &coRef) return *this;
   State = coRef.State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgReverseGearStatus::vehicle_mainfi_tclMsgReverseGearStatus()
:State(0)
 {}

tS32 vehicle_mainfi_tclMsgReverseGearStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_REVERSEGEARSTATUS;
}


vehicle_mainfi_tclMsgReverseGearStatus::~vehicle_mainfi_tclMsgReverseGearStatus()
{}

tU32 vehicle_mainfi_tclMsgReverseGearStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgReverseGearStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> State);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgReverseGearStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << State);
   return oOut;
}

tBool vehicle_mainfi_tclMsgReverseGearStatus::operator==(const vehicle_mainfi_tclMsgReverseGearStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (State == roRef.State);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgSpeedLockUpReg::vehicle_mainfi_tclMsgSpeedLockUpReg()
 {}

tS32 vehicle_mainfi_tclMsgSpeedLockUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SPEEDLOCKUPREG;
}


vehicle_mainfi_tclMsgSpeedLockUpReg::~vehicle_mainfi_tclMsgSpeedLockUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgSpeedLockRelUpReg::vehicle_mainfi_tclMsgSpeedLockRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgSpeedLockRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SPEEDLOCKRELUPREG;
}


vehicle_mainfi_tclMsgSpeedLockRelUpReg::~vehicle_mainfi_tclMsgSpeedLockRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgSpeedLockGet::vehicle_mainfi_tclMsgSpeedLockGet()
 {}

tS32 vehicle_mainfi_tclMsgSpeedLockGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SPEEDLOCKGET;
}


vehicle_mainfi_tclMsgSpeedLockGet::~vehicle_mainfi_tclMsgSpeedLockGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSpeedLockStatus::vehicle_mainfi_tclMsgSpeedLockStatus(const vehicle_mainfi_tclMsgSpeedLockStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   State = coRef.State;
}
vehicle_mainfi_tclMsgSpeedLockStatus& vehicle_mainfi_tclMsgSpeedLockStatus::operator=(const vehicle_mainfi_tclMsgSpeedLockStatus& coRef)
{
   if (this == &coRef) return *this;
   State = coRef.State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgSpeedLockStatus::vehicle_mainfi_tclMsgSpeedLockStatus()
:State(0)
 {}

tS32 vehicle_mainfi_tclMsgSpeedLockStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SPEEDLOCKSTATUS;
}


vehicle_mainfi_tclMsgSpeedLockStatus::~vehicle_mainfi_tclMsgSpeedLockStatus()
{}

tU32 vehicle_mainfi_tclMsgSpeedLockStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgSpeedLockStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> State);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSpeedLockStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << State);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSpeedLockStatus::operator==(const vehicle_mainfi_tclMsgSpeedLockStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (State == roRef.State);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgDrivingStateUpReg::vehicle_mainfi_tclMsgDrivingStateUpReg()
 {}

tS32 vehicle_mainfi_tclMsgDrivingStateUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DRIVINGSTATEUPREG;
}


vehicle_mainfi_tclMsgDrivingStateUpReg::~vehicle_mainfi_tclMsgDrivingStateUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgDrivingStateRelUpReg::vehicle_mainfi_tclMsgDrivingStateRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgDrivingStateRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DRIVINGSTATERELUPREG;
}


vehicle_mainfi_tclMsgDrivingStateRelUpReg::~vehicle_mainfi_tclMsgDrivingStateRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgDrivingStateGet::vehicle_mainfi_tclMsgDrivingStateGet()
 {}

tS32 vehicle_mainfi_tclMsgDrivingStateGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DRIVINGSTATEGET;
}


vehicle_mainfi_tclMsgDrivingStateGet::~vehicle_mainfi_tclMsgDrivingStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgDrivingStateStatus::vehicle_mainfi_tclMsgDrivingStateStatus(const vehicle_mainfi_tclMsgDrivingStateStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   State = coRef.State;
}
vehicle_mainfi_tclMsgDrivingStateStatus& vehicle_mainfi_tclMsgDrivingStateStatus::operator=(const vehicle_mainfi_tclMsgDrivingStateStatus& coRef)
{
   if (this == &coRef) return *this;
   State = coRef.State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgDrivingStateStatus::vehicle_mainfi_tclMsgDrivingStateStatus()
:State(0)
 {}

tS32 vehicle_mainfi_tclMsgDrivingStateStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DRIVINGSTATESTATUS;
}


vehicle_mainfi_tclMsgDrivingStateStatus::~vehicle_mainfi_tclMsgDrivingStateStatus()
{}

tU32 vehicle_mainfi_tclMsgDrivingStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgDrivingStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> State);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgDrivingStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << State);
   return oOut;
}

tBool vehicle_mainfi_tclMsgDrivingStateStatus::operator==(const vehicle_mainfi_tclMsgDrivingStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (State == roRef.State);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgGlobalVehicleWarningStateUpReg::vehicle_mainfi_tclMsgGlobalVehicleWarningStateUpReg()
 {}

tS32 vehicle_mainfi_tclMsgGlobalVehicleWarningStateUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_GLOBALVEHICLEWARNINGSTATEUPREG;
}


vehicle_mainfi_tclMsgGlobalVehicleWarningStateUpReg::~vehicle_mainfi_tclMsgGlobalVehicleWarningStateUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgGlobalVehicleWarningStateRelUpReg::vehicle_mainfi_tclMsgGlobalVehicleWarningStateRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgGlobalVehicleWarningStateRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_GLOBALVEHICLEWARNINGSTATERELUPREG;
}


vehicle_mainfi_tclMsgGlobalVehicleWarningStateRelUpReg::~vehicle_mainfi_tclMsgGlobalVehicleWarningStateRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgGlobalVehicleWarningStateGet::vehicle_mainfi_tclMsgGlobalVehicleWarningStateGet()
 {}

tS32 vehicle_mainfi_tclMsgGlobalVehicleWarningStateGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_GLOBALVEHICLEWARNINGSTATEGET;
}


vehicle_mainfi_tclMsgGlobalVehicleWarningStateGet::~vehicle_mainfi_tclMsgGlobalVehicleWarningStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgGlobalVehicleWarningStateStatus::vehicle_mainfi_tclMsgGlobalVehicleWarningStateStatus(const vehicle_mainfi_tclMsgGlobalVehicleWarningStateStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   State = coRef.State;
}
vehicle_mainfi_tclMsgGlobalVehicleWarningStateStatus& vehicle_mainfi_tclMsgGlobalVehicleWarningStateStatus::operator=(const vehicle_mainfi_tclMsgGlobalVehicleWarningStateStatus& coRef)
{
   if (this == &coRef) return *this;
   State = coRef.State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgGlobalVehicleWarningStateStatus::vehicle_mainfi_tclMsgGlobalVehicleWarningStateStatus()
:State()
 {}

tS32 vehicle_mainfi_tclMsgGlobalVehicleWarningStateStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_GLOBALVEHICLEWARNINGSTATESTATUS;
}


vehicle_mainfi_tclMsgGlobalVehicleWarningStateStatus::~vehicle_mainfi_tclMsgGlobalVehicleWarningStateStatus()
{}

tU32 vehicle_mainfi_tclMsgGlobalVehicleWarningStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgGlobalVehicleWarningStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> State);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgGlobalVehicleWarningStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << State);
   return oOut;
}

tBool vehicle_mainfi_tclMsgGlobalVehicleWarningStateStatus::operator==(const vehicle_mainfi_tclMsgGlobalVehicleWarningStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (State == roRef.State);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgVehicleStatesUpReg::vehicle_mainfi_tclMsgVehicleStatesUpReg()
 {}

tS32 vehicle_mainfi_tclMsgVehicleStatesUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_VEHICLESTATESUPREG;
}


vehicle_mainfi_tclMsgVehicleStatesUpReg::~vehicle_mainfi_tclMsgVehicleStatesUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgVehicleStatesRelUpReg::vehicle_mainfi_tclMsgVehicleStatesRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgVehicleStatesRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_VEHICLESTATESRELUPREG;
}


vehicle_mainfi_tclMsgVehicleStatesRelUpReg::~vehicle_mainfi_tclMsgVehicleStatesRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgVehicleStatesGet::vehicle_mainfi_tclMsgVehicleStatesGet()
 {}

tS32 vehicle_mainfi_tclMsgVehicleStatesGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_VEHICLESTATESGET;
}


vehicle_mainfi_tclMsgVehicleStatesGet::~vehicle_mainfi_tclMsgVehicleStatesGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgVehicleStatesStatus::vehicle_mainfi_tclMsgVehicleStatesStatus(const vehicle_mainfi_tclMsgVehicleStatesStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   State = coRef.State;
}
vehicle_mainfi_tclMsgVehicleStatesStatus& vehicle_mainfi_tclMsgVehicleStatesStatus::operator=(const vehicle_mainfi_tclMsgVehicleStatesStatus& coRef)
{
   if (this == &coRef) return *this;
   State = coRef.State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgVehicleStatesStatus::vehicle_mainfi_tclMsgVehicleStatesStatus()
:State()
 {}

tS32 vehicle_mainfi_tclMsgVehicleStatesStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_VEHICLESTATESSTATUS;
}


vehicle_mainfi_tclMsgVehicleStatesStatus::~vehicle_mainfi_tclMsgVehicleStatesStatus()
{}

tU32 vehicle_mainfi_tclMsgVehicleStatesStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgVehicleStatesStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> State);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgVehicleStatesStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << State);
   return oOut;
}

tBool vehicle_mainfi_tclMsgVehicleStatesStatus::operator==(const vehicle_mainfi_tclMsgVehicleStatesStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (State == roRef.State);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgPartialMuteUpReg::vehicle_mainfi_tclMsgPartialMuteUpReg()
 {}

tS32 vehicle_mainfi_tclMsgPartialMuteUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_PARTIALMUTEUPREG;
}


vehicle_mainfi_tclMsgPartialMuteUpReg::~vehicle_mainfi_tclMsgPartialMuteUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgPartialMuteRelUpReg::vehicle_mainfi_tclMsgPartialMuteRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgPartialMuteRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_PARTIALMUTERELUPREG;
}


vehicle_mainfi_tclMsgPartialMuteRelUpReg::~vehicle_mainfi_tclMsgPartialMuteRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgPartialMuteGet::vehicle_mainfi_tclMsgPartialMuteGet()
 {}

tS32 vehicle_mainfi_tclMsgPartialMuteGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_PARTIALMUTEGET;
}


vehicle_mainfi_tclMsgPartialMuteGet::~vehicle_mainfi_tclMsgPartialMuteGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgPartialMuteStatus::vehicle_mainfi_tclMsgPartialMuteStatus(const vehicle_mainfi_tclMsgPartialMuteStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   PartialMuteValue = coRef.PartialMuteValue;
}
vehicle_mainfi_tclMsgPartialMuteStatus& vehicle_mainfi_tclMsgPartialMuteStatus::operator=(const vehicle_mainfi_tclMsgPartialMuteStatus& coRef)
{
   if (this == &coRef) return *this;
   PartialMuteValue = coRef.PartialMuteValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgPartialMuteStatus::vehicle_mainfi_tclMsgPartialMuteStatus()
:PartialMuteValue(0)
 {}

tS32 vehicle_mainfi_tclMsgPartialMuteStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_PARTIALMUTESTATUS;
}


vehicle_mainfi_tclMsgPartialMuteStatus::~vehicle_mainfi_tclMsgPartialMuteStatus()
{}

tU32 vehicle_mainfi_tclMsgPartialMuteStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgPartialMuteStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PartialMuteValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgPartialMuteStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PartialMuteValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgPartialMuteStatus::operator==(const vehicle_mainfi_tclMsgPartialMuteStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PartialMuteValue == roRef.PartialMuteValue);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgSwivMonAutoOpenUpReg::vehicle_mainfi_tclMsgSwivMonAutoOpenUpReg()
 {}

tS32 vehicle_mainfi_tclMsgSwivMonAutoOpenUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SWIVMONAUTOOPENUPREG;
}


vehicle_mainfi_tclMsgSwivMonAutoOpenUpReg::~vehicle_mainfi_tclMsgSwivMonAutoOpenUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgSwivMonAutoOpenRelUpReg::vehicle_mainfi_tclMsgSwivMonAutoOpenRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgSwivMonAutoOpenRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SWIVMONAUTOOPENRELUPREG;
}


vehicle_mainfi_tclMsgSwivMonAutoOpenRelUpReg::~vehicle_mainfi_tclMsgSwivMonAutoOpenRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgSwivMonAutoOpenGet::vehicle_mainfi_tclMsgSwivMonAutoOpenGet()
 {}

tS32 vehicle_mainfi_tclMsgSwivMonAutoOpenGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SWIVMONAUTOOPENGET;
}


vehicle_mainfi_tclMsgSwivMonAutoOpenGet::~vehicle_mainfi_tclMsgSwivMonAutoOpenGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSwivMonAutoOpenStatus::vehicle_mainfi_tclMsgSwivMonAutoOpenStatus(const vehicle_mainfi_tclMsgSwivMonAutoOpenStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   SwivMonAutoOpenValue = coRef.SwivMonAutoOpenValue;
}
vehicle_mainfi_tclMsgSwivMonAutoOpenStatus& vehicle_mainfi_tclMsgSwivMonAutoOpenStatus::operator=(const vehicle_mainfi_tclMsgSwivMonAutoOpenStatus& coRef)
{
   if (this == &coRef) return *this;
   SwivMonAutoOpenValue = coRef.SwivMonAutoOpenValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgSwivMonAutoOpenStatus::vehicle_mainfi_tclMsgSwivMonAutoOpenStatus()
:SwivMonAutoOpenValue(0)
 {}

tS32 vehicle_mainfi_tclMsgSwivMonAutoOpenStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SWIVMONAUTOOPENSTATUS;
}


vehicle_mainfi_tclMsgSwivMonAutoOpenStatus::~vehicle_mainfi_tclMsgSwivMonAutoOpenStatus()
{}

tU32 vehicle_mainfi_tclMsgSwivMonAutoOpenStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgSwivMonAutoOpenStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SwivMonAutoOpenValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSwivMonAutoOpenStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SwivMonAutoOpenValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSwivMonAutoOpenStatus::operator==(const vehicle_mainfi_tclMsgSwivMonAutoOpenStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SwivMonAutoOpenValue == roRef.SwivMonAutoOpenValue);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgDateModeUpReg::vehicle_mainfi_tclMsgDateModeUpReg()
 {}

tS32 vehicle_mainfi_tclMsgDateModeUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DATEMODEUPREG;
}


vehicle_mainfi_tclMsgDateModeUpReg::~vehicle_mainfi_tclMsgDateModeUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgDateModeRelUpReg::vehicle_mainfi_tclMsgDateModeRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgDateModeRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DATEMODERELUPREG;
}


vehicle_mainfi_tclMsgDateModeRelUpReg::~vehicle_mainfi_tclMsgDateModeRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgDateModeGet::vehicle_mainfi_tclMsgDateModeGet()
 {}

tS32 vehicle_mainfi_tclMsgDateModeGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DATEMODEGET;
}


vehicle_mainfi_tclMsgDateModeGet::~vehicle_mainfi_tclMsgDateModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgDateModeStatus::vehicle_mainfi_tclMsgDateModeStatus(const vehicle_mainfi_tclMsgDateModeStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   DateModeValue = coRef.DateModeValue;
}
vehicle_mainfi_tclMsgDateModeStatus& vehicle_mainfi_tclMsgDateModeStatus::operator=(const vehicle_mainfi_tclMsgDateModeStatus& coRef)
{
   if (this == &coRef) return *this;
   DateModeValue = coRef.DateModeValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgDateModeStatus::vehicle_mainfi_tclMsgDateModeStatus()
:DateModeValue(0)
 {}

tS32 vehicle_mainfi_tclMsgDateModeStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DATEMODESTATUS;
}


vehicle_mainfi_tclMsgDateModeStatus::~vehicle_mainfi_tclMsgDateModeStatus()
{}

tU32 vehicle_mainfi_tclMsgDateModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgDateModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DateModeValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgDateModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DateModeValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgDateModeStatus::operator==(const vehicle_mainfi_tclMsgDateModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DateModeValue == roRef.DateModeValue);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgTmModeUpReg::vehicle_mainfi_tclMsgTmModeUpReg()
 {}

tS32 vehicle_mainfi_tclMsgTmModeUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TMMODEUPREG;
}


vehicle_mainfi_tclMsgTmModeUpReg::~vehicle_mainfi_tclMsgTmModeUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgTmModeRelUpReg::vehicle_mainfi_tclMsgTmModeRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgTmModeRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TMMODERELUPREG;
}


vehicle_mainfi_tclMsgTmModeRelUpReg::~vehicle_mainfi_tclMsgTmModeRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgTmModeGet::vehicle_mainfi_tclMsgTmModeGet()
 {}

tS32 vehicle_mainfi_tclMsgTmModeGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TMMODEGET;
}


vehicle_mainfi_tclMsgTmModeGet::~vehicle_mainfi_tclMsgTmModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgTmModeStatus::vehicle_mainfi_tclMsgTmModeStatus(const vehicle_mainfi_tclMsgTmModeStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   TmModeValue = coRef.TmModeValue;
}
vehicle_mainfi_tclMsgTmModeStatus& vehicle_mainfi_tclMsgTmModeStatus::operator=(const vehicle_mainfi_tclMsgTmModeStatus& coRef)
{
   if (this == &coRef) return *this;
   TmModeValue = coRef.TmModeValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgTmModeStatus::vehicle_mainfi_tclMsgTmModeStatus()
:TmModeValue(0)
 {}

tS32 vehicle_mainfi_tclMsgTmModeStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TMMODESTATUS;
}


vehicle_mainfi_tclMsgTmModeStatus::~vehicle_mainfi_tclMsgTmModeStatus()
{}

tU32 vehicle_mainfi_tclMsgTmModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgTmModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TmModeValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgTmModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TmModeValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgTmModeStatus::operator==(const vehicle_mainfi_tclMsgTmModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TmModeValue == roRef.TmModeValue);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgCamTxtUpReg::vehicle_mainfi_tclMsgCamTxtUpReg()
 {}

tS32 vehicle_mainfi_tclMsgCamTxtUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAMTXTUPREG;
}


vehicle_mainfi_tclMsgCamTxtUpReg::~vehicle_mainfi_tclMsgCamTxtUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgCamTxtRelUpReg::vehicle_mainfi_tclMsgCamTxtRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgCamTxtRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAMTXTRELUPREG;
}


vehicle_mainfi_tclMsgCamTxtRelUpReg::~vehicle_mainfi_tclMsgCamTxtRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgCamTxtGet::vehicle_mainfi_tclMsgCamTxtGet()
 {}

tS32 vehicle_mainfi_tclMsgCamTxtGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAMTXTGET;
}


vehicle_mainfi_tclMsgCamTxtGet::~vehicle_mainfi_tclMsgCamTxtGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCamTxtStatus::vehicle_mainfi_tclMsgCamTxtStatus(const vehicle_mainfi_tclMsgCamTxtStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   CamTxtValue = coRef.CamTxtValue;
}
vehicle_mainfi_tclMsgCamTxtStatus& vehicle_mainfi_tclMsgCamTxtStatus::operator=(const vehicle_mainfi_tclMsgCamTxtStatus& coRef)
{
   if (this == &coRef) return *this;
   CamTxtValue = coRef.CamTxtValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCamTxtStatus::vehicle_mainfi_tclMsgCamTxtStatus()
:CamTxtValue(0)
 {}

tS32 vehicle_mainfi_tclMsgCamTxtStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAMTXTSTATUS;
}


vehicle_mainfi_tclMsgCamTxtStatus::~vehicle_mainfi_tclMsgCamTxtStatus()
{}

tU32 vehicle_mainfi_tclMsgCamTxtStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& vehicle_mainfi_tclMsgCamTxtStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CamTxtValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCamTxtStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CamTxtValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCamTxtStatus::operator==(const vehicle_mainfi_tclMsgCamTxtStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CamTxtValue == roRef.CamTxtValue);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgActCam1UpReg::vehicle_mainfi_tclMsgActCam1UpReg()
 {}

tS32 vehicle_mainfi_tclMsgActCam1UpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM1UPREG;
}


vehicle_mainfi_tclMsgActCam1UpReg::~vehicle_mainfi_tclMsgActCam1UpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgActCam1RelUpReg::vehicle_mainfi_tclMsgActCam1RelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgActCam1RelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM1RELUPREG;
}


vehicle_mainfi_tclMsgActCam1RelUpReg::~vehicle_mainfi_tclMsgActCam1RelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgActCam1Get::vehicle_mainfi_tclMsgActCam1Get()
 {}

tS32 vehicle_mainfi_tclMsgActCam1Get::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM1GET;
}


vehicle_mainfi_tclMsgActCam1Get::~vehicle_mainfi_tclMsgActCam1Get()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgActCam1Status::vehicle_mainfi_tclMsgActCam1Status(const vehicle_mainfi_tclMsgActCam1Status& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   ActCam1Value = coRef.ActCam1Value;
}
vehicle_mainfi_tclMsgActCam1Status& vehicle_mainfi_tclMsgActCam1Status::operator=(const vehicle_mainfi_tclMsgActCam1Status& coRef)
{
   if (this == &coRef) return *this;
   ActCam1Value = coRef.ActCam1Value;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgActCam1Status::vehicle_mainfi_tclMsgActCam1Status()
:ActCam1Value(0)
 {}

tS32 vehicle_mainfi_tclMsgActCam1Status::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM1STATUS;
}


vehicle_mainfi_tclMsgActCam1Status::~vehicle_mainfi_tclMsgActCam1Status()
{}

tU32 vehicle_mainfi_tclMsgActCam1Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgActCam1Status::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ActCam1Value);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgActCam1Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ActCam1Value);
   return oOut;
}

tBool vehicle_mainfi_tclMsgActCam1Status::operator==(const vehicle_mainfi_tclMsgActCam1Status& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ActCam1Value == roRef.ActCam1Value);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgActCam2UpReg::vehicle_mainfi_tclMsgActCam2UpReg()
 {}

tS32 vehicle_mainfi_tclMsgActCam2UpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM2UPREG;
}


vehicle_mainfi_tclMsgActCam2UpReg::~vehicle_mainfi_tclMsgActCam2UpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgActCam2RelUpReg::vehicle_mainfi_tclMsgActCam2RelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgActCam2RelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM2RELUPREG;
}


vehicle_mainfi_tclMsgActCam2RelUpReg::~vehicle_mainfi_tclMsgActCam2RelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgActCam2Get::vehicle_mainfi_tclMsgActCam2Get()
 {}

tS32 vehicle_mainfi_tclMsgActCam2Get::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM2GET;
}


vehicle_mainfi_tclMsgActCam2Get::~vehicle_mainfi_tclMsgActCam2Get()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgActCam2Status::vehicle_mainfi_tclMsgActCam2Status(const vehicle_mainfi_tclMsgActCam2Status& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   ActCam2Value = coRef.ActCam2Value;
}
vehicle_mainfi_tclMsgActCam2Status& vehicle_mainfi_tclMsgActCam2Status::operator=(const vehicle_mainfi_tclMsgActCam2Status& coRef)
{
   if (this == &coRef) return *this;
   ActCam2Value = coRef.ActCam2Value;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgActCam2Status::vehicle_mainfi_tclMsgActCam2Status()
:ActCam2Value(0)
 {}

tS32 vehicle_mainfi_tclMsgActCam2Status::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM2STATUS;
}


vehicle_mainfi_tclMsgActCam2Status::~vehicle_mainfi_tclMsgActCam2Status()
{}

tU32 vehicle_mainfi_tclMsgActCam2Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgActCam2Status::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ActCam2Value);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgActCam2Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ActCam2Value);
   return oOut;
}

tBool vehicle_mainfi_tclMsgActCam2Status::operator==(const vehicle_mainfi_tclMsgActCam2Status& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ActCam2Value == roRef.ActCam2Value);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgActCam3UpReg::vehicle_mainfi_tclMsgActCam3UpReg()
 {}

tS32 vehicle_mainfi_tclMsgActCam3UpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM3UPREG;
}


vehicle_mainfi_tclMsgActCam3UpReg::~vehicle_mainfi_tclMsgActCam3UpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgActCam3RelUpReg::vehicle_mainfi_tclMsgActCam3RelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgActCam3RelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM3RELUPREG;
}


vehicle_mainfi_tclMsgActCam3RelUpReg::~vehicle_mainfi_tclMsgActCam3RelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgActCam3Get::vehicle_mainfi_tclMsgActCam3Get()
 {}

tS32 vehicle_mainfi_tclMsgActCam3Get::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM3GET;
}


vehicle_mainfi_tclMsgActCam3Get::~vehicle_mainfi_tclMsgActCam3Get()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgActCam3Status::vehicle_mainfi_tclMsgActCam3Status(const vehicle_mainfi_tclMsgActCam3Status& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   ActCam3Value = coRef.ActCam3Value;
}
vehicle_mainfi_tclMsgActCam3Status& vehicle_mainfi_tclMsgActCam3Status::operator=(const vehicle_mainfi_tclMsgActCam3Status& coRef)
{
   if (this == &coRef) return *this;
   ActCam3Value = coRef.ActCam3Value;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgActCam3Status::vehicle_mainfi_tclMsgActCam3Status()
:ActCam3Value(0)
 {}

tS32 vehicle_mainfi_tclMsgActCam3Status::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM3STATUS;
}


vehicle_mainfi_tclMsgActCam3Status::~vehicle_mainfi_tclMsgActCam3Status()
{}

tU32 vehicle_mainfi_tclMsgActCam3Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgActCam3Status::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ActCam3Value);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgActCam3Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ActCam3Value);
   return oOut;
}

tBool vehicle_mainfi_tclMsgActCam3Status::operator==(const vehicle_mainfi_tclMsgActCam3Status& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ActCam3Value == roRef.ActCam3Value);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgActCam4UpReg::vehicle_mainfi_tclMsgActCam4UpReg()
 {}

tS32 vehicle_mainfi_tclMsgActCam4UpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM4UPREG;
}


vehicle_mainfi_tclMsgActCam4UpReg::~vehicle_mainfi_tclMsgActCam4UpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgActCam4RelUpReg::vehicle_mainfi_tclMsgActCam4RelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgActCam4RelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM4RELUPREG;
}


vehicle_mainfi_tclMsgActCam4RelUpReg::~vehicle_mainfi_tclMsgActCam4RelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgActCam4Get::vehicle_mainfi_tclMsgActCam4Get()
 {}

tS32 vehicle_mainfi_tclMsgActCam4Get::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM4GET;
}


vehicle_mainfi_tclMsgActCam4Get::~vehicle_mainfi_tclMsgActCam4Get()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgActCam4Status::vehicle_mainfi_tclMsgActCam4Status(const vehicle_mainfi_tclMsgActCam4Status& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   ActCam4Value = coRef.ActCam4Value;
}
vehicle_mainfi_tclMsgActCam4Status& vehicle_mainfi_tclMsgActCam4Status::operator=(const vehicle_mainfi_tclMsgActCam4Status& coRef)
{
   if (this == &coRef) return *this;
   ActCam4Value = coRef.ActCam4Value;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgActCam4Status::vehicle_mainfi_tclMsgActCam4Status()
:ActCam4Value(0)
 {}

tS32 vehicle_mainfi_tclMsgActCam4Status::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM4STATUS;
}


vehicle_mainfi_tclMsgActCam4Status::~vehicle_mainfi_tclMsgActCam4Status()
{}

tU32 vehicle_mainfi_tclMsgActCam4Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgActCam4Status::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ActCam4Value);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgActCam4Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ActCam4Value);
   return oOut;
}

tBool vehicle_mainfi_tclMsgActCam4Status::operator==(const vehicle_mainfi_tclMsgActCam4Status& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ActCam4Value == roRef.ActCam4Value);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgActCam5UpReg::vehicle_mainfi_tclMsgActCam5UpReg()
 {}

tS32 vehicle_mainfi_tclMsgActCam5UpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM5UPREG;
}


vehicle_mainfi_tclMsgActCam5UpReg::~vehicle_mainfi_tclMsgActCam5UpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgActCam5RelUpReg::vehicle_mainfi_tclMsgActCam5RelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgActCam5RelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM5RELUPREG;
}


vehicle_mainfi_tclMsgActCam5RelUpReg::~vehicle_mainfi_tclMsgActCam5RelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgActCam5Get::vehicle_mainfi_tclMsgActCam5Get()
 {}

tS32 vehicle_mainfi_tclMsgActCam5Get::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM5GET;
}


vehicle_mainfi_tclMsgActCam5Get::~vehicle_mainfi_tclMsgActCam5Get()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgActCam5Status::vehicle_mainfi_tclMsgActCam5Status(const vehicle_mainfi_tclMsgActCam5Status& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   ActCam5Value = coRef.ActCam5Value;
}
vehicle_mainfi_tclMsgActCam5Status& vehicle_mainfi_tclMsgActCam5Status::operator=(const vehicle_mainfi_tclMsgActCam5Status& coRef)
{
   if (this == &coRef) return *this;
   ActCam5Value = coRef.ActCam5Value;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgActCam5Status::vehicle_mainfi_tclMsgActCam5Status()
:ActCam5Value(0)
 {}

tS32 vehicle_mainfi_tclMsgActCam5Status::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM5STATUS;
}


vehicle_mainfi_tclMsgActCam5Status::~vehicle_mainfi_tclMsgActCam5Status()
{}

tU32 vehicle_mainfi_tclMsgActCam5Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgActCam5Status::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ActCam5Value);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgActCam5Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ActCam5Value);
   return oOut;
}

tBool vehicle_mainfi_tclMsgActCam5Status::operator==(const vehicle_mainfi_tclMsgActCam5Status& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ActCam5Value == roRef.ActCam5Value);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgActCam6UpReg::vehicle_mainfi_tclMsgActCam6UpReg()
 {}

tS32 vehicle_mainfi_tclMsgActCam6UpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM6UPREG;
}


vehicle_mainfi_tclMsgActCam6UpReg::~vehicle_mainfi_tclMsgActCam6UpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgActCam6RelUpReg::vehicle_mainfi_tclMsgActCam6RelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgActCam6RelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM6RELUPREG;
}


vehicle_mainfi_tclMsgActCam6RelUpReg::~vehicle_mainfi_tclMsgActCam6RelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgActCam6Get::vehicle_mainfi_tclMsgActCam6Get()
 {}

tS32 vehicle_mainfi_tclMsgActCam6Get::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM6GET;
}


vehicle_mainfi_tclMsgActCam6Get::~vehicle_mainfi_tclMsgActCam6Get()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgActCam6Status::vehicle_mainfi_tclMsgActCam6Status(const vehicle_mainfi_tclMsgActCam6Status& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   ActCam6Value = coRef.ActCam6Value;
}
vehicle_mainfi_tclMsgActCam6Status& vehicle_mainfi_tclMsgActCam6Status::operator=(const vehicle_mainfi_tclMsgActCam6Status& coRef)
{
   if (this == &coRef) return *this;
   ActCam6Value = coRef.ActCam6Value;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgActCam6Status::vehicle_mainfi_tclMsgActCam6Status()
:ActCam6Value(0)
 {}

tS32 vehicle_mainfi_tclMsgActCam6Status::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM6STATUS;
}


vehicle_mainfi_tclMsgActCam6Status::~vehicle_mainfi_tclMsgActCam6Status()
{}

tU32 vehicle_mainfi_tclMsgActCam6Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgActCam6Status::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ActCam6Value);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgActCam6Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ActCam6Value);
   return oOut;
}

tBool vehicle_mainfi_tclMsgActCam6Status::operator==(const vehicle_mainfi_tclMsgActCam6Status& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ActCam6Value == roRef.ActCam6Value);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgActCam7UpReg::vehicle_mainfi_tclMsgActCam7UpReg()
 {}

tS32 vehicle_mainfi_tclMsgActCam7UpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM7UPREG;
}


vehicle_mainfi_tclMsgActCam7UpReg::~vehicle_mainfi_tclMsgActCam7UpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgActCam7RelUpReg::vehicle_mainfi_tclMsgActCam7RelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgActCam7RelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM7RELUPREG;
}


vehicle_mainfi_tclMsgActCam7RelUpReg::~vehicle_mainfi_tclMsgActCam7RelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgActCam7Get::vehicle_mainfi_tclMsgActCam7Get()
 {}

tS32 vehicle_mainfi_tclMsgActCam7Get::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM7GET;
}


vehicle_mainfi_tclMsgActCam7Get::~vehicle_mainfi_tclMsgActCam7Get()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgActCam7Status::vehicle_mainfi_tclMsgActCam7Status(const vehicle_mainfi_tclMsgActCam7Status& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   ActCam7Value = coRef.ActCam7Value;
}
vehicle_mainfi_tclMsgActCam7Status& vehicle_mainfi_tclMsgActCam7Status::operator=(const vehicle_mainfi_tclMsgActCam7Status& coRef)
{
   if (this == &coRef) return *this;
   ActCam7Value = coRef.ActCam7Value;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgActCam7Status::vehicle_mainfi_tclMsgActCam7Status()
:ActCam7Value(0)
 {}

tS32 vehicle_mainfi_tclMsgActCam7Status::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM7STATUS;
}


vehicle_mainfi_tclMsgActCam7Status::~vehicle_mainfi_tclMsgActCam7Status()
{}

tU32 vehicle_mainfi_tclMsgActCam7Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgActCam7Status::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ActCam7Value);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgActCam7Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ActCam7Value);
   return oOut;
}

tBool vehicle_mainfi_tclMsgActCam7Status::operator==(const vehicle_mainfi_tclMsgActCam7Status& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ActCam7Value == roRef.ActCam7Value);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgDriverDoorOpenUpReg::vehicle_mainfi_tclMsgDriverDoorOpenUpReg()
 {}

tS32 vehicle_mainfi_tclMsgDriverDoorOpenUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DRIVERDOOROPENUPREG;
}


vehicle_mainfi_tclMsgDriverDoorOpenUpReg::~vehicle_mainfi_tclMsgDriverDoorOpenUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgDriverDoorOpenRelUpReg::vehicle_mainfi_tclMsgDriverDoorOpenRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgDriverDoorOpenRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DRIVERDOOROPENRELUPREG;
}


vehicle_mainfi_tclMsgDriverDoorOpenRelUpReg::~vehicle_mainfi_tclMsgDriverDoorOpenRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgDriverDoorOpenGet::vehicle_mainfi_tclMsgDriverDoorOpenGet()
 {}

tS32 vehicle_mainfi_tclMsgDriverDoorOpenGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DRIVERDOOROPENGET;
}


vehicle_mainfi_tclMsgDriverDoorOpenGet::~vehicle_mainfi_tclMsgDriverDoorOpenGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgDriverDoorOpenStatus::vehicle_mainfi_tclMsgDriverDoorOpenStatus(const vehicle_mainfi_tclMsgDriverDoorOpenStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   DriverDoorOpenValue = coRef.DriverDoorOpenValue;
}
vehicle_mainfi_tclMsgDriverDoorOpenStatus& vehicle_mainfi_tclMsgDriverDoorOpenStatus::operator=(const vehicle_mainfi_tclMsgDriverDoorOpenStatus& coRef)
{
   if (this == &coRef) return *this;
   DriverDoorOpenValue = coRef.DriverDoorOpenValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgDriverDoorOpenStatus::vehicle_mainfi_tclMsgDriverDoorOpenStatus()
:DriverDoorOpenValue(0)
 {}

tS32 vehicle_mainfi_tclMsgDriverDoorOpenStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DRIVERDOOROPENSTATUS;
}


vehicle_mainfi_tclMsgDriverDoorOpenStatus::~vehicle_mainfi_tclMsgDriverDoorOpenStatus()
{}

tU32 vehicle_mainfi_tclMsgDriverDoorOpenStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgDriverDoorOpenStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DriverDoorOpenValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgDriverDoorOpenStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DriverDoorOpenValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgDriverDoorOpenStatus::operator==(const vehicle_mainfi_tclMsgDriverDoorOpenStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DriverDoorOpenValue == roRef.DriverDoorOpenValue);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgActCam8UpReg::vehicle_mainfi_tclMsgActCam8UpReg()
 {}

tS32 vehicle_mainfi_tclMsgActCam8UpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM8UPREG;
}


vehicle_mainfi_tclMsgActCam8UpReg::~vehicle_mainfi_tclMsgActCam8UpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgActCam8RelUpReg::vehicle_mainfi_tclMsgActCam8RelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgActCam8RelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM8RELUPREG;
}


vehicle_mainfi_tclMsgActCam8RelUpReg::~vehicle_mainfi_tclMsgActCam8RelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgActCam8Get::vehicle_mainfi_tclMsgActCam8Get()
 {}

tS32 vehicle_mainfi_tclMsgActCam8Get::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM8GET;
}


vehicle_mainfi_tclMsgActCam8Get::~vehicle_mainfi_tclMsgActCam8Get()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgActCam8Status::vehicle_mainfi_tclMsgActCam8Status(const vehicle_mainfi_tclMsgActCam8Status& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   ActCam8Value = coRef.ActCam8Value;
}
vehicle_mainfi_tclMsgActCam8Status& vehicle_mainfi_tclMsgActCam8Status::operator=(const vehicle_mainfi_tclMsgActCam8Status& coRef)
{
   if (this == &coRef) return *this;
   ActCam8Value = coRef.ActCam8Value;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgActCam8Status::vehicle_mainfi_tclMsgActCam8Status()
:ActCam8Value(0)
 {}

tS32 vehicle_mainfi_tclMsgActCam8Status::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM8STATUS;
}


vehicle_mainfi_tclMsgActCam8Status::~vehicle_mainfi_tclMsgActCam8Status()
{}

tU32 vehicle_mainfi_tclMsgActCam8Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgActCam8Status::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ActCam8Value);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgActCam8Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ActCam8Value);
   return oOut;
}

tBool vehicle_mainfi_tclMsgActCam8Status::operator==(const vehicle_mainfi_tclMsgActCam8Status& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ActCam8Value == roRef.ActCam8Value);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgActCam9UpReg::vehicle_mainfi_tclMsgActCam9UpReg()
 {}

tS32 vehicle_mainfi_tclMsgActCam9UpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM9UPREG;
}


vehicle_mainfi_tclMsgActCam9UpReg::~vehicle_mainfi_tclMsgActCam9UpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgActCam9RelUpReg::vehicle_mainfi_tclMsgActCam9RelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgActCam9RelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM9RELUPREG;
}


vehicle_mainfi_tclMsgActCam9RelUpReg::~vehicle_mainfi_tclMsgActCam9RelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgActCam9Get::vehicle_mainfi_tclMsgActCam9Get()
 {}

tS32 vehicle_mainfi_tclMsgActCam9Get::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM9GET;
}


vehicle_mainfi_tclMsgActCam9Get::~vehicle_mainfi_tclMsgActCam9Get()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgActCam9Status::vehicle_mainfi_tclMsgActCam9Status(const vehicle_mainfi_tclMsgActCam9Status& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   ActCam9Value = coRef.ActCam9Value;
}
vehicle_mainfi_tclMsgActCam9Status& vehicle_mainfi_tclMsgActCam9Status::operator=(const vehicle_mainfi_tclMsgActCam9Status& coRef)
{
   if (this == &coRef) return *this;
   ActCam9Value = coRef.ActCam9Value;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgActCam9Status::vehicle_mainfi_tclMsgActCam9Status()
:ActCam9Value(0)
 {}

tS32 vehicle_mainfi_tclMsgActCam9Status::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM9STATUS;
}


vehicle_mainfi_tclMsgActCam9Status::~vehicle_mainfi_tclMsgActCam9Status()
{}

tU32 vehicle_mainfi_tclMsgActCam9Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgActCam9Status::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ActCam9Value);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgActCam9Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ActCam9Value);
   return oOut;
}

tBool vehicle_mainfi_tclMsgActCam9Status::operator==(const vehicle_mainfi_tclMsgActCam9Status& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ActCam9Value == roRef.ActCam9Value);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgActCam10UpReg::vehicle_mainfi_tclMsgActCam10UpReg()
 {}

tS32 vehicle_mainfi_tclMsgActCam10UpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM10UPREG;
}


vehicle_mainfi_tclMsgActCam10UpReg::~vehicle_mainfi_tclMsgActCam10UpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgActCam10RelUpReg::vehicle_mainfi_tclMsgActCam10RelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgActCam10RelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM10RELUPREG;
}


vehicle_mainfi_tclMsgActCam10RelUpReg::~vehicle_mainfi_tclMsgActCam10RelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgActCam10Get::vehicle_mainfi_tclMsgActCam10Get()
 {}

tS32 vehicle_mainfi_tclMsgActCam10Get::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM10GET;
}


vehicle_mainfi_tclMsgActCam10Get::~vehicle_mainfi_tclMsgActCam10Get()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgActCam10Status::vehicle_mainfi_tclMsgActCam10Status(const vehicle_mainfi_tclMsgActCam10Status& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   ActCam10Value = coRef.ActCam10Value;
}
vehicle_mainfi_tclMsgActCam10Status& vehicle_mainfi_tclMsgActCam10Status::operator=(const vehicle_mainfi_tclMsgActCam10Status& coRef)
{
   if (this == &coRef) return *this;
   ActCam10Value = coRef.ActCam10Value;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgActCam10Status::vehicle_mainfi_tclMsgActCam10Status()
:ActCam10Value(0)
 {}

tS32 vehicle_mainfi_tclMsgActCam10Status::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM10STATUS;
}


vehicle_mainfi_tclMsgActCam10Status::~vehicle_mainfi_tclMsgActCam10Status()
{}

tU32 vehicle_mainfi_tclMsgActCam10Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgActCam10Status::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ActCam10Value);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgActCam10Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ActCam10Value);
   return oOut;
}

tBool vehicle_mainfi_tclMsgActCam10Status::operator==(const vehicle_mainfi_tclMsgActCam10Status& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ActCam10Value == roRef.ActCam10Value);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgActCam11UpReg::vehicle_mainfi_tclMsgActCam11UpReg()
 {}

tS32 vehicle_mainfi_tclMsgActCam11UpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM11UPREG;
}


vehicle_mainfi_tclMsgActCam11UpReg::~vehicle_mainfi_tclMsgActCam11UpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgActCam11RelUpReg::vehicle_mainfi_tclMsgActCam11RelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgActCam11RelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM11RELUPREG;
}


vehicle_mainfi_tclMsgActCam11RelUpReg::~vehicle_mainfi_tclMsgActCam11RelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgActCam11Get::vehicle_mainfi_tclMsgActCam11Get()
 {}

tS32 vehicle_mainfi_tclMsgActCam11Get::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM11GET;
}


vehicle_mainfi_tclMsgActCam11Get::~vehicle_mainfi_tclMsgActCam11Get()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgActCam11Status::vehicle_mainfi_tclMsgActCam11Status(const vehicle_mainfi_tclMsgActCam11Status& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   ActCam11Value = coRef.ActCam11Value;
}
vehicle_mainfi_tclMsgActCam11Status& vehicle_mainfi_tclMsgActCam11Status::operator=(const vehicle_mainfi_tclMsgActCam11Status& coRef)
{
   if (this == &coRef) return *this;
   ActCam11Value = coRef.ActCam11Value;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgActCam11Status::vehicle_mainfi_tclMsgActCam11Status()
:ActCam11Value(0)
 {}

tS32 vehicle_mainfi_tclMsgActCam11Status::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM11STATUS;
}


vehicle_mainfi_tclMsgActCam11Status::~vehicle_mainfi_tclMsgActCam11Status()
{}

tU32 vehicle_mainfi_tclMsgActCam11Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgActCam11Status::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ActCam11Value);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgActCam11Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ActCam11Value);
   return oOut;
}

tBool vehicle_mainfi_tclMsgActCam11Status::operator==(const vehicle_mainfi_tclMsgActCam11Status& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ActCam11Value == roRef.ActCam11Value);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgActCam12UpReg::vehicle_mainfi_tclMsgActCam12UpReg()
 {}

tS32 vehicle_mainfi_tclMsgActCam12UpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM12UPREG;
}


vehicle_mainfi_tclMsgActCam12UpReg::~vehicle_mainfi_tclMsgActCam12UpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgActCam12RelUpReg::vehicle_mainfi_tclMsgActCam12RelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgActCam12RelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM12RELUPREG;
}


vehicle_mainfi_tclMsgActCam12RelUpReg::~vehicle_mainfi_tclMsgActCam12RelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgActCam12Get::vehicle_mainfi_tclMsgActCam12Get()
 {}

tS32 vehicle_mainfi_tclMsgActCam12Get::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM12GET;
}


vehicle_mainfi_tclMsgActCam12Get::~vehicle_mainfi_tclMsgActCam12Get()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgActCam12Status::vehicle_mainfi_tclMsgActCam12Status(const vehicle_mainfi_tclMsgActCam12Status& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   ActCam12Value = coRef.ActCam12Value;
}
vehicle_mainfi_tclMsgActCam12Status& vehicle_mainfi_tclMsgActCam12Status::operator=(const vehicle_mainfi_tclMsgActCam12Status& coRef)
{
   if (this == &coRef) return *this;
   ActCam12Value = coRef.ActCam12Value;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgActCam12Status::vehicle_mainfi_tclMsgActCam12Status()
:ActCam12Value(0)
 {}

tS32 vehicle_mainfi_tclMsgActCam12Status::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM12STATUS;
}


vehicle_mainfi_tclMsgActCam12Status::~vehicle_mainfi_tclMsgActCam12Status()
{}

tU32 vehicle_mainfi_tclMsgActCam12Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgActCam12Status::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ActCam12Value);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgActCam12Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ActCam12Value);
   return oOut;
}

tBool vehicle_mainfi_tclMsgActCam12Status::operator==(const vehicle_mainfi_tclMsgActCam12Status& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ActCam12Value == roRef.ActCam12Value);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgActCam13UpReg::vehicle_mainfi_tclMsgActCam13UpReg()
 {}

tS32 vehicle_mainfi_tclMsgActCam13UpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM13UPREG;
}


vehicle_mainfi_tclMsgActCam13UpReg::~vehicle_mainfi_tclMsgActCam13UpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgActCam13RelUpReg::vehicle_mainfi_tclMsgActCam13RelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgActCam13RelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM13RELUPREG;
}


vehicle_mainfi_tclMsgActCam13RelUpReg::~vehicle_mainfi_tclMsgActCam13RelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgActCam13Get::vehicle_mainfi_tclMsgActCam13Get()
 {}

tS32 vehicle_mainfi_tclMsgActCam13Get::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM13GET;
}


vehicle_mainfi_tclMsgActCam13Get::~vehicle_mainfi_tclMsgActCam13Get()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgActCam13Status::vehicle_mainfi_tclMsgActCam13Status(const vehicle_mainfi_tclMsgActCam13Status& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   ActCam13Value = coRef.ActCam13Value;
}
vehicle_mainfi_tclMsgActCam13Status& vehicle_mainfi_tclMsgActCam13Status::operator=(const vehicle_mainfi_tclMsgActCam13Status& coRef)
{
   if (this == &coRef) return *this;
   ActCam13Value = coRef.ActCam13Value;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgActCam13Status::vehicle_mainfi_tclMsgActCam13Status()
:ActCam13Value(0)
 {}

tS32 vehicle_mainfi_tclMsgActCam13Status::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM13STATUS;
}


vehicle_mainfi_tclMsgActCam13Status::~vehicle_mainfi_tclMsgActCam13Status()
{}

tU32 vehicle_mainfi_tclMsgActCam13Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgActCam13Status::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ActCam13Value);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgActCam13Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ActCam13Value);
   return oOut;
}

tBool vehicle_mainfi_tclMsgActCam13Status::operator==(const vehicle_mainfi_tclMsgActCam13Status& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ActCam13Value == roRef.ActCam13Value);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgActCam14UpReg::vehicle_mainfi_tclMsgActCam14UpReg()
 {}

tS32 vehicle_mainfi_tclMsgActCam14UpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM14UPREG;
}


vehicle_mainfi_tclMsgActCam14UpReg::~vehicle_mainfi_tclMsgActCam14UpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgActCam14RelUpReg::vehicle_mainfi_tclMsgActCam14RelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgActCam14RelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM14RELUPREG;
}


vehicle_mainfi_tclMsgActCam14RelUpReg::~vehicle_mainfi_tclMsgActCam14RelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgActCam14Get::vehicle_mainfi_tclMsgActCam14Get()
 {}

tS32 vehicle_mainfi_tclMsgActCam14Get::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM14GET;
}


vehicle_mainfi_tclMsgActCam14Get::~vehicle_mainfi_tclMsgActCam14Get()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgActCam14Status::vehicle_mainfi_tclMsgActCam14Status(const vehicle_mainfi_tclMsgActCam14Status& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   ActCam14Value = coRef.ActCam14Value;
}
vehicle_mainfi_tclMsgActCam14Status& vehicle_mainfi_tclMsgActCam14Status::operator=(const vehicle_mainfi_tclMsgActCam14Status& coRef)
{
   if (this == &coRef) return *this;
   ActCam14Value = coRef.ActCam14Value;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgActCam14Status::vehicle_mainfi_tclMsgActCam14Status()
:ActCam14Value(0)
 {}

tS32 vehicle_mainfi_tclMsgActCam14Status::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM14STATUS;
}


vehicle_mainfi_tclMsgActCam14Status::~vehicle_mainfi_tclMsgActCam14Status()
{}

tU32 vehicle_mainfi_tclMsgActCam14Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgActCam14Status::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ActCam14Value);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgActCam14Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ActCam14Value);
   return oOut;
}

tBool vehicle_mainfi_tclMsgActCam14Status::operator==(const vehicle_mainfi_tclMsgActCam14Status& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ActCam14Value == roRef.ActCam14Value);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgActCam15UpReg::vehicle_mainfi_tclMsgActCam15UpReg()
 {}

tS32 vehicle_mainfi_tclMsgActCam15UpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM15UPREG;
}


vehicle_mainfi_tclMsgActCam15UpReg::~vehicle_mainfi_tclMsgActCam15UpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgActCam15RelUpReg::vehicle_mainfi_tclMsgActCam15RelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgActCam15RelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM15RELUPREG;
}


vehicle_mainfi_tclMsgActCam15RelUpReg::~vehicle_mainfi_tclMsgActCam15RelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgActCam15Get::vehicle_mainfi_tclMsgActCam15Get()
 {}

tS32 vehicle_mainfi_tclMsgActCam15Get::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM15GET;
}


vehicle_mainfi_tclMsgActCam15Get::~vehicle_mainfi_tclMsgActCam15Get()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgActCam15Status::vehicle_mainfi_tclMsgActCam15Status(const vehicle_mainfi_tclMsgActCam15Status& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   ActCam15Value = coRef.ActCam15Value;
}
vehicle_mainfi_tclMsgActCam15Status& vehicle_mainfi_tclMsgActCam15Status::operator=(const vehicle_mainfi_tclMsgActCam15Status& coRef)
{
   if (this == &coRef) return *this;
   ActCam15Value = coRef.ActCam15Value;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgActCam15Status::vehicle_mainfi_tclMsgActCam15Status()
:ActCam15Value(0)
 {}

tS32 vehicle_mainfi_tclMsgActCam15Status::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM15STATUS;
}


vehicle_mainfi_tclMsgActCam15Status::~vehicle_mainfi_tclMsgActCam15Status()
{}

tU32 vehicle_mainfi_tclMsgActCam15Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgActCam15Status::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ActCam15Value);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgActCam15Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ActCam15Value);
   return oOut;
}

tBool vehicle_mainfi_tclMsgActCam15Status::operator==(const vehicle_mainfi_tclMsgActCam15Status& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ActCam15Value == roRef.ActCam15Value);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgActCam16UpReg::vehicle_mainfi_tclMsgActCam16UpReg()
 {}

tS32 vehicle_mainfi_tclMsgActCam16UpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM16UPREG;
}


vehicle_mainfi_tclMsgActCam16UpReg::~vehicle_mainfi_tclMsgActCam16UpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgActCam16RelUpReg::vehicle_mainfi_tclMsgActCam16RelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgActCam16RelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM16RELUPREG;
}


vehicle_mainfi_tclMsgActCam16RelUpReg::~vehicle_mainfi_tclMsgActCam16RelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgActCam16Get::vehicle_mainfi_tclMsgActCam16Get()
 {}

tS32 vehicle_mainfi_tclMsgActCam16Get::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM16GET;
}


vehicle_mainfi_tclMsgActCam16Get::~vehicle_mainfi_tclMsgActCam16Get()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgActCam16Status::vehicle_mainfi_tclMsgActCam16Status(const vehicle_mainfi_tclMsgActCam16Status& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   ActCam16Value = coRef.ActCam16Value;
}
vehicle_mainfi_tclMsgActCam16Status& vehicle_mainfi_tclMsgActCam16Status::operator=(const vehicle_mainfi_tclMsgActCam16Status& coRef)
{
   if (this == &coRef) return *this;
   ActCam16Value = coRef.ActCam16Value;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgActCam16Status::vehicle_mainfi_tclMsgActCam16Status()
:ActCam16Value(0)
 {}

tS32 vehicle_mainfi_tclMsgActCam16Status::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM16STATUS;
}


vehicle_mainfi_tclMsgActCam16Status::~vehicle_mainfi_tclMsgActCam16Status()
{}

tU32 vehicle_mainfi_tclMsgActCam16Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgActCam16Status::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ActCam16Value);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgActCam16Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ActCam16Value);
   return oOut;
}

tBool vehicle_mainfi_tclMsgActCam16Status::operator==(const vehicle_mainfi_tclMsgActCam16Status& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ActCam16Value == roRef.ActCam16Value);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgActCam17UpReg::vehicle_mainfi_tclMsgActCam17UpReg()
 {}

tS32 vehicle_mainfi_tclMsgActCam17UpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM17UPREG;
}


vehicle_mainfi_tclMsgActCam17UpReg::~vehicle_mainfi_tclMsgActCam17UpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgActCam17RelUpReg::vehicle_mainfi_tclMsgActCam17RelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgActCam17RelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM17RELUPREG;
}


vehicle_mainfi_tclMsgActCam17RelUpReg::~vehicle_mainfi_tclMsgActCam17RelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgActCam17Get::vehicle_mainfi_tclMsgActCam17Get()
 {}

tS32 vehicle_mainfi_tclMsgActCam17Get::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM17GET;
}


vehicle_mainfi_tclMsgActCam17Get::~vehicle_mainfi_tclMsgActCam17Get()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgActCam17Status::vehicle_mainfi_tclMsgActCam17Status(const vehicle_mainfi_tclMsgActCam17Status& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   ActCam17Value = coRef.ActCam17Value;
}
vehicle_mainfi_tclMsgActCam17Status& vehicle_mainfi_tclMsgActCam17Status::operator=(const vehicle_mainfi_tclMsgActCam17Status& coRef)
{
   if (this == &coRef) return *this;
   ActCam17Value = coRef.ActCam17Value;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgActCam17Status::vehicle_mainfi_tclMsgActCam17Status()
:ActCam17Value(0)
 {}

tS32 vehicle_mainfi_tclMsgActCam17Status::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_ACTCAM17STATUS;
}


vehicle_mainfi_tclMsgActCam17Status::~vehicle_mainfi_tclMsgActCam17Status()
{}

tU32 vehicle_mainfi_tclMsgActCam17Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgActCam17Status::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ActCam17Value);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgActCam17Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ActCam17Value);
   return oOut;
}

tBool vehicle_mainfi_tclMsgActCam17Status::operator==(const vehicle_mainfi_tclMsgActCam17Status& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ActCam17Value == roRef.ActCam17Value);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgCamSplitQuadUpReg::vehicle_mainfi_tclMsgCamSplitQuadUpReg()
 {}

tS32 vehicle_mainfi_tclMsgCamSplitQuadUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAMSPLITQUADUPREG;
}


vehicle_mainfi_tclMsgCamSplitQuadUpReg::~vehicle_mainfi_tclMsgCamSplitQuadUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgCamSplitQuadRelUpReg::vehicle_mainfi_tclMsgCamSplitQuadRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgCamSplitQuadRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAMSPLITQUADRELUPREG;
}


vehicle_mainfi_tclMsgCamSplitQuadRelUpReg::~vehicle_mainfi_tclMsgCamSplitQuadRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgCamSplitQuadGet::vehicle_mainfi_tclMsgCamSplitQuadGet()
 {}

tS32 vehicle_mainfi_tclMsgCamSplitQuadGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAMSPLITQUADGET;
}


vehicle_mainfi_tclMsgCamSplitQuadGet::~vehicle_mainfi_tclMsgCamSplitQuadGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCamSplitQuadStatus::vehicle_mainfi_tclMsgCamSplitQuadStatus(const vehicle_mainfi_tclMsgCamSplitQuadStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   CamSplitQuadValue = coRef.CamSplitQuadValue;
}
vehicle_mainfi_tclMsgCamSplitQuadStatus& vehicle_mainfi_tclMsgCamSplitQuadStatus::operator=(const vehicle_mainfi_tclMsgCamSplitQuadStatus& coRef)
{
   if (this == &coRef) return *this;
   CamSplitQuadValue = coRef.CamSplitQuadValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCamSplitQuadStatus::vehicle_mainfi_tclMsgCamSplitQuadStatus()
:CamSplitQuadValue(0)
 {}

tS32 vehicle_mainfi_tclMsgCamSplitQuadStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CAMSPLITQUADSTATUS;
}


vehicle_mainfi_tclMsgCamSplitQuadStatus::~vehicle_mainfi_tclMsgCamSplitQuadStatus()
{}

tU32 vehicle_mainfi_tclMsgCamSplitQuadStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCamSplitQuadStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CamSplitQuadValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCamSplitQuadStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CamSplitQuadValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCamSplitQuadStatus::operator==(const vehicle_mainfi_tclMsgCamSplitQuadStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CamSplitQuadValue == roRef.CamSplitQuadValue);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgMuteDevUpReg::vehicle_mainfi_tclMsgMuteDevUpReg()
 {}

tS32 vehicle_mainfi_tclMsgMuteDevUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MUTEDEVUPREG;
}


vehicle_mainfi_tclMsgMuteDevUpReg::~vehicle_mainfi_tclMsgMuteDevUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgMuteDevRelUpReg::vehicle_mainfi_tclMsgMuteDevRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgMuteDevRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MUTEDEVRELUPREG;
}


vehicle_mainfi_tclMsgMuteDevRelUpReg::~vehicle_mainfi_tclMsgMuteDevRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgMuteDevGet::vehicle_mainfi_tclMsgMuteDevGet()
 {}

tS32 vehicle_mainfi_tclMsgMuteDevGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MUTEDEVGET;
}


vehicle_mainfi_tclMsgMuteDevGet::~vehicle_mainfi_tclMsgMuteDevGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMuteDevStatus::vehicle_mainfi_tclMsgMuteDevStatus(const vehicle_mainfi_tclMsgMuteDevStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   MuteDevStatus = coRef.MuteDevStatus;
}
vehicle_mainfi_tclMsgMuteDevStatus& vehicle_mainfi_tclMsgMuteDevStatus::operator=(const vehicle_mainfi_tclMsgMuteDevStatus& coRef)
{
   if (this == &coRef) return *this;
   MuteDevStatus = coRef.MuteDevStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMuteDevStatus::vehicle_mainfi_tclMsgMuteDevStatus()
:MuteDevStatus(0)
 {}

tS32 vehicle_mainfi_tclMsgMuteDevStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MUTEDEVSTATUS;
}


vehicle_mainfi_tclMsgMuteDevStatus::~vehicle_mainfi_tclMsgMuteDevStatus()
{}

tU32 vehicle_mainfi_tclMsgMuteDevStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgMuteDevStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MuteDevStatus);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMuteDevStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MuteDevStatus);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMuteDevStatus::operator==(const vehicle_mainfi_tclMsgMuteDevStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MuteDevStatus == roRef.MuteDevStatus);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgSysVoltUpReg::vehicle_mainfi_tclMsgSysVoltUpReg()
 {}

tS32 vehicle_mainfi_tclMsgSysVoltUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SYSVOLTUPREG;
}


vehicle_mainfi_tclMsgSysVoltUpReg::~vehicle_mainfi_tclMsgSysVoltUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgSysVoltRelUpReg::vehicle_mainfi_tclMsgSysVoltRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgSysVoltRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SYSVOLTRELUPREG;
}


vehicle_mainfi_tclMsgSysVoltRelUpReg::~vehicle_mainfi_tclMsgSysVoltRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgSysVoltGet::vehicle_mainfi_tclMsgSysVoltGet()
 {}

tS32 vehicle_mainfi_tclMsgSysVoltGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SYSVOLTGET;
}


vehicle_mainfi_tclMsgSysVoltGet::~vehicle_mainfi_tclMsgSysVoltGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSysVoltStatus::vehicle_mainfi_tclMsgSysVoltStatus(const vehicle_mainfi_tclMsgSysVoltStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   SysVoltStatus = coRef.SysVoltStatus;
}
vehicle_mainfi_tclMsgSysVoltStatus& vehicle_mainfi_tclMsgSysVoltStatus::operator=(const vehicle_mainfi_tclMsgSysVoltStatus& coRef)
{
   if (this == &coRef) return *this;
   SysVoltStatus = coRef.SysVoltStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgSysVoltStatus::vehicle_mainfi_tclMsgSysVoltStatus()
:SysVoltStatus(0)
 {}

tS32 vehicle_mainfi_tclMsgSysVoltStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SYSVOLTSTATUS;
}


vehicle_mainfi_tclMsgSysVoltStatus::~vehicle_mainfi_tclMsgSysVoltStatus()
{}

tU32 vehicle_mainfi_tclMsgSysVoltStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgSysVoltStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SysVoltStatus);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSysVoltStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SysVoltStatus);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSysVoltStatus::operator==(const vehicle_mainfi_tclMsgSysVoltStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SysVoltStatus == roRef.SysVoltStatus);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgParkingBreakSwitchUpReg::vehicle_mainfi_tclMsgParkingBreakSwitchUpReg()
 {}

tS32 vehicle_mainfi_tclMsgParkingBreakSwitchUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_PARKINGBREAKSWITCHUPREG;
}


vehicle_mainfi_tclMsgParkingBreakSwitchUpReg::~vehicle_mainfi_tclMsgParkingBreakSwitchUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgParkingBreakSwitchRelUpReg::vehicle_mainfi_tclMsgParkingBreakSwitchRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgParkingBreakSwitchRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_PARKINGBREAKSWITCHRELUPREG;
}


vehicle_mainfi_tclMsgParkingBreakSwitchRelUpReg::~vehicle_mainfi_tclMsgParkingBreakSwitchRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgParkingBreakSwitchGet::vehicle_mainfi_tclMsgParkingBreakSwitchGet()
 {}

tS32 vehicle_mainfi_tclMsgParkingBreakSwitchGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_PARKINGBREAKSWITCHGET;
}


vehicle_mainfi_tclMsgParkingBreakSwitchGet::~vehicle_mainfi_tclMsgParkingBreakSwitchGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgParkingBreakSwitchStatus::vehicle_mainfi_tclMsgParkingBreakSwitchStatus(const vehicle_mainfi_tclMsgParkingBreakSwitchStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   ParkingBreakSwitchValue = coRef.ParkingBreakSwitchValue;
}
vehicle_mainfi_tclMsgParkingBreakSwitchStatus& vehicle_mainfi_tclMsgParkingBreakSwitchStatus::operator=(const vehicle_mainfi_tclMsgParkingBreakSwitchStatus& coRef)
{
   if (this == &coRef) return *this;
   ParkingBreakSwitchValue = coRef.ParkingBreakSwitchValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgParkingBreakSwitchStatus::vehicle_mainfi_tclMsgParkingBreakSwitchStatus()
:ParkingBreakSwitchValue(0)
 {}

tS32 vehicle_mainfi_tclMsgParkingBreakSwitchStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_PARKINGBREAKSWITCHSTATUS;
}


vehicle_mainfi_tclMsgParkingBreakSwitchStatus::~vehicle_mainfi_tclMsgParkingBreakSwitchStatus()
{}

tU32 vehicle_mainfi_tclMsgParkingBreakSwitchStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgParkingBreakSwitchStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ParkingBreakSwitchValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgParkingBreakSwitchStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ParkingBreakSwitchValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgParkingBreakSwitchStatus::operator==(const vehicle_mainfi_tclMsgParkingBreakSwitchStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ParkingBreakSwitchValue == roRef.ParkingBreakSwitchValue);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgRearCamReqUpReg::vehicle_mainfi_tclMsgRearCamReqUpReg()
 {}

tS32 vehicle_mainfi_tclMsgRearCamReqUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_REARCAMREQUPREG;
}


vehicle_mainfi_tclMsgRearCamReqUpReg::~vehicle_mainfi_tclMsgRearCamReqUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgRearCamReqRelUpReg::vehicle_mainfi_tclMsgRearCamReqRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgRearCamReqRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_REARCAMREQRELUPREG;
}


vehicle_mainfi_tclMsgRearCamReqRelUpReg::~vehicle_mainfi_tclMsgRearCamReqRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgRearCamReqGet::vehicle_mainfi_tclMsgRearCamReqGet()
 {}

tS32 vehicle_mainfi_tclMsgRearCamReqGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_REARCAMREQGET;
}


vehicle_mainfi_tclMsgRearCamReqGet::~vehicle_mainfi_tclMsgRearCamReqGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgRearCamReqStatus::vehicle_mainfi_tclMsgRearCamReqStatus(const vehicle_mainfi_tclMsgRearCamReqStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   RearCamReqValue = coRef.RearCamReqValue;
}
vehicle_mainfi_tclMsgRearCamReqStatus& vehicle_mainfi_tclMsgRearCamReqStatus::operator=(const vehicle_mainfi_tclMsgRearCamReqStatus& coRef)
{
   if (this == &coRef) return *this;
   RearCamReqValue = coRef.RearCamReqValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgRearCamReqStatus::vehicle_mainfi_tclMsgRearCamReqStatus()
:RearCamReqValue(0)
 {}

tS32 vehicle_mainfi_tclMsgRearCamReqStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_REARCAMREQSTATUS;
}


vehicle_mainfi_tclMsgRearCamReqStatus::~vehicle_mainfi_tclMsgRearCamReqStatus()
{}

tU32 vehicle_mainfi_tclMsgRearCamReqStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgRearCamReqStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RearCamReqValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgRearCamReqStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RearCamReqValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgRearCamReqStatus::operator==(const vehicle_mainfi_tclMsgRearCamReqStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RearCamReqValue == roRef.RearCamReqValue);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgVINUpReg::vehicle_mainfi_tclMsgVINUpReg()
 {}

tS32 vehicle_mainfi_tclMsgVINUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_VINUPREG;
}


vehicle_mainfi_tclMsgVINUpReg::~vehicle_mainfi_tclMsgVINUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgVINRelUpReg::vehicle_mainfi_tclMsgVINRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgVINRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_VINRELUPREG;
}


vehicle_mainfi_tclMsgVINRelUpReg::~vehicle_mainfi_tclMsgVINRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgVINGet::vehicle_mainfi_tclMsgVINGet()
 {}

tS32 vehicle_mainfi_tclMsgVINGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_VINGET;
}


vehicle_mainfi_tclMsgVINGet::~vehicle_mainfi_tclMsgVINGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgVINStatus::vehicle_mainfi_tclMsgVINStatus(const vehicle_mainfi_tclMsgVINStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   VINValue = coRef.VINValue;
}
vehicle_mainfi_tclMsgVINStatus& vehicle_mainfi_tclMsgVINStatus::operator=(const vehicle_mainfi_tclMsgVINStatus& coRef)
{
   if (this == &coRef) return *this;
   VINValue = coRef.VINValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgVINStatus::vehicle_mainfi_tclMsgVINStatus()
:VINValue(0)
 {}

tS32 vehicle_mainfi_tclMsgVINStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_VINSTATUS;
}


vehicle_mainfi_tclMsgVINStatus::~vehicle_mainfi_tclMsgVINStatus()
{}

tU32 vehicle_mainfi_tclMsgVINStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& vehicle_mainfi_tclMsgVINStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VINValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgVINStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VINValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgVINStatus::operator==(const vehicle_mainfi_tclMsgVINStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VINValue == roRef.VINValue);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgTimeDateUpReg::vehicle_mainfi_tclMsgTimeDateUpReg()
 {}

tS32 vehicle_mainfi_tclMsgTimeDateUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TIMEDATEUPREG;
}


vehicle_mainfi_tclMsgTimeDateUpReg::~vehicle_mainfi_tclMsgTimeDateUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgTimeDateRelUpReg::vehicle_mainfi_tclMsgTimeDateRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgTimeDateRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TIMEDATERELUPREG;
}


vehicle_mainfi_tclMsgTimeDateRelUpReg::~vehicle_mainfi_tclMsgTimeDateRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgTimeDateGet::vehicle_mainfi_tclMsgTimeDateGet()
 {}

tS32 vehicle_mainfi_tclMsgTimeDateGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TIMEDATEGET;
}


vehicle_mainfi_tclMsgTimeDateGet::~vehicle_mainfi_tclMsgTimeDateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgTimeDateStatus::vehicle_mainfi_tclMsgTimeDateStatus(const vehicle_mainfi_tclMsgTimeDateStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   TimeDateValue = coRef.TimeDateValue;
}
vehicle_mainfi_tclMsgTimeDateStatus& vehicle_mainfi_tclMsgTimeDateStatus::operator=(const vehicle_mainfi_tclMsgTimeDateStatus& coRef)
{
   if (this == &coRef) return *this;
   TimeDateValue = coRef.TimeDateValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgTimeDateStatus::vehicle_mainfi_tclMsgTimeDateStatus()
:TimeDateValue(0)
 {}

tS32 vehicle_mainfi_tclMsgTimeDateStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TIMEDATESTATUS;
}


vehicle_mainfi_tclMsgTimeDateStatus::~vehicle_mainfi_tclMsgTimeDateStatus()
{}

tU32 vehicle_mainfi_tclMsgTimeDateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& vehicle_mainfi_tclMsgTimeDateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TimeDateValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgTimeDateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TimeDateValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgTimeDateStatus::operator==(const vehicle_mainfi_tclMsgTimeDateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TimeDateValue == roRef.TimeDateValue);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgPrivacyResetRequestUpReg::vehicle_mainfi_tclMsgPrivacyResetRequestUpReg()
 {}

tS32 vehicle_mainfi_tclMsgPrivacyResetRequestUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_PRIVACYRESETREQUESTUPREG;
}


vehicle_mainfi_tclMsgPrivacyResetRequestUpReg::~vehicle_mainfi_tclMsgPrivacyResetRequestUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgPrivacyResetRequestRelUpReg::vehicle_mainfi_tclMsgPrivacyResetRequestRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgPrivacyResetRequestRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_PRIVACYRESETREQUESTRELUPREG;
}


vehicle_mainfi_tclMsgPrivacyResetRequestRelUpReg::~vehicle_mainfi_tclMsgPrivacyResetRequestRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgPrivacyResetRequestGet::vehicle_mainfi_tclMsgPrivacyResetRequestGet()
 {}

tS32 vehicle_mainfi_tclMsgPrivacyResetRequestGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_PRIVACYRESETREQUESTGET;
}


vehicle_mainfi_tclMsgPrivacyResetRequestGet::~vehicle_mainfi_tclMsgPrivacyResetRequestGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgPrivacyResetRequestStatus::vehicle_mainfi_tclMsgPrivacyResetRequestStatus(const vehicle_mainfi_tclMsgPrivacyResetRequestStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   PrivacyResetRequestValue = coRef.PrivacyResetRequestValue;
}
vehicle_mainfi_tclMsgPrivacyResetRequestStatus& vehicle_mainfi_tclMsgPrivacyResetRequestStatus::operator=(const vehicle_mainfi_tclMsgPrivacyResetRequestStatus& coRef)
{
   if (this == &coRef) return *this;
   PrivacyResetRequestValue = coRef.PrivacyResetRequestValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgPrivacyResetRequestStatus::vehicle_mainfi_tclMsgPrivacyResetRequestStatus()
:PrivacyResetRequestValue(0)
 {}

tS32 vehicle_mainfi_tclMsgPrivacyResetRequestStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_PRIVACYRESETREQUESTSTATUS;
}


vehicle_mainfi_tclMsgPrivacyResetRequestStatus::~vehicle_mainfi_tclMsgPrivacyResetRequestStatus()
{}

tU32 vehicle_mainfi_tclMsgPrivacyResetRequestStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgPrivacyResetRequestStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PrivacyResetRequestValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgPrivacyResetRequestStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PrivacyResetRequestValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgPrivacyResetRequestStatus::operator==(const vehicle_mainfi_tclMsgPrivacyResetRequestStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PrivacyResetRequestValue == roRef.PrivacyResetRequestValue);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgPhoneCallCommandUpReg::vehicle_mainfi_tclMsgPhoneCallCommandUpReg()
 {}

tS32 vehicle_mainfi_tclMsgPhoneCallCommandUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_PHONECALLCOMMANDUPREG;
}


vehicle_mainfi_tclMsgPhoneCallCommandUpReg::~vehicle_mainfi_tclMsgPhoneCallCommandUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgPhoneCallCommandRelUpReg::vehicle_mainfi_tclMsgPhoneCallCommandRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgPhoneCallCommandRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_PHONECALLCOMMANDRELUPREG;
}


vehicle_mainfi_tclMsgPhoneCallCommandRelUpReg::~vehicle_mainfi_tclMsgPhoneCallCommandRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgPhoneCallCommandGet::vehicle_mainfi_tclMsgPhoneCallCommandGet()
 {}

tS32 vehicle_mainfi_tclMsgPhoneCallCommandGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_PHONECALLCOMMANDGET;
}


vehicle_mainfi_tclMsgPhoneCallCommandGet::~vehicle_mainfi_tclMsgPhoneCallCommandGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgPhoneCallCommandStatus::vehicle_mainfi_tclMsgPhoneCallCommandStatus(const vehicle_mainfi_tclMsgPhoneCallCommandStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   PhoneCallCommandValue = coRef.PhoneCallCommandValue;
}
vehicle_mainfi_tclMsgPhoneCallCommandStatus& vehicle_mainfi_tclMsgPhoneCallCommandStatus::operator=(const vehicle_mainfi_tclMsgPhoneCallCommandStatus& coRef)
{
   if (this == &coRef) return *this;
   PhoneCallCommandValue = coRef.PhoneCallCommandValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgPhoneCallCommandStatus::vehicle_mainfi_tclMsgPhoneCallCommandStatus()
:PhoneCallCommandValue(0)
 {}

tS32 vehicle_mainfi_tclMsgPhoneCallCommandStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_PHONECALLCOMMANDSTATUS;
}


vehicle_mainfi_tclMsgPhoneCallCommandStatus::~vehicle_mainfi_tclMsgPhoneCallCommandStatus()
{}

tU32 vehicle_mainfi_tclMsgPhoneCallCommandStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgPhoneCallCommandStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PhoneCallCommandValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgPhoneCallCommandStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PhoneCallCommandValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgPhoneCallCommandStatus::operator==(const vehicle_mainfi_tclMsgPhoneCallCommandStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PhoneCallCommandValue == roRef.PhoneCallCommandValue);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgVolumeCommandUpReg::vehicle_mainfi_tclMsgVolumeCommandUpReg()
 {}

tS32 vehicle_mainfi_tclMsgVolumeCommandUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_VOLUMECOMMANDUPREG;
}


vehicle_mainfi_tclMsgVolumeCommandUpReg::~vehicle_mainfi_tclMsgVolumeCommandUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgVolumeCommandRelUpReg::vehicle_mainfi_tclMsgVolumeCommandRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgVolumeCommandRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_VOLUMECOMMANDRELUPREG;
}


vehicle_mainfi_tclMsgVolumeCommandRelUpReg::~vehicle_mainfi_tclMsgVolumeCommandRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgVolumeCommandGet::vehicle_mainfi_tclMsgVolumeCommandGet()
 {}

tS32 vehicle_mainfi_tclMsgVolumeCommandGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_VOLUMECOMMANDGET;
}


vehicle_mainfi_tclMsgVolumeCommandGet::~vehicle_mainfi_tclMsgVolumeCommandGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgVolumeCommandStatus::vehicle_mainfi_tclMsgVolumeCommandStatus(const vehicle_mainfi_tclMsgVolumeCommandStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   VolumeCommandValue = coRef.VolumeCommandValue;
}
vehicle_mainfi_tclMsgVolumeCommandStatus& vehicle_mainfi_tclMsgVolumeCommandStatus::operator=(const vehicle_mainfi_tclMsgVolumeCommandStatus& coRef)
{
   if (this == &coRef) return *this;
   VolumeCommandValue = coRef.VolumeCommandValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgVolumeCommandStatus::vehicle_mainfi_tclMsgVolumeCommandStatus()
:VolumeCommandValue(0)
 {}

tS32 vehicle_mainfi_tclMsgVolumeCommandStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_VOLUMECOMMANDSTATUS;
}


vehicle_mainfi_tclMsgVolumeCommandStatus::~vehicle_mainfi_tclMsgVolumeCommandStatus()
{}

tU32 vehicle_mainfi_tclMsgVolumeCommandStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgVolumeCommandStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VolumeCommandValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgVolumeCommandStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VolumeCommandValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgVolumeCommandStatus::operator==(const vehicle_mainfi_tclMsgVolumeCommandStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VolumeCommandValue == roRef.VolumeCommandValue);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgVoiceRecgCommandUpReg::vehicle_mainfi_tclMsgVoiceRecgCommandUpReg()
 {}

tS32 vehicle_mainfi_tclMsgVoiceRecgCommandUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_VOICERECGCOMMANDUPREG;
}


vehicle_mainfi_tclMsgVoiceRecgCommandUpReg::~vehicle_mainfi_tclMsgVoiceRecgCommandUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgVoiceRecgCommandRelUpReg::vehicle_mainfi_tclMsgVoiceRecgCommandRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgVoiceRecgCommandRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_VOICERECGCOMMANDRELUPREG;
}


vehicle_mainfi_tclMsgVoiceRecgCommandRelUpReg::~vehicle_mainfi_tclMsgVoiceRecgCommandRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgVoiceRecgCommandGet::vehicle_mainfi_tclMsgVoiceRecgCommandGet()
 {}

tS32 vehicle_mainfi_tclMsgVoiceRecgCommandGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_VOICERECGCOMMANDGET;
}


vehicle_mainfi_tclMsgVoiceRecgCommandGet::~vehicle_mainfi_tclMsgVoiceRecgCommandGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgVoiceRecgCommandStatus::vehicle_mainfi_tclMsgVoiceRecgCommandStatus(const vehicle_mainfi_tclMsgVoiceRecgCommandStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   VoiceRecgCommandValue = coRef.VoiceRecgCommandValue;
}
vehicle_mainfi_tclMsgVoiceRecgCommandStatus& vehicle_mainfi_tclMsgVoiceRecgCommandStatus::operator=(const vehicle_mainfi_tclMsgVoiceRecgCommandStatus& coRef)
{
   if (this == &coRef) return *this;
   VoiceRecgCommandValue = coRef.VoiceRecgCommandValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgVoiceRecgCommandStatus::vehicle_mainfi_tclMsgVoiceRecgCommandStatus()
:VoiceRecgCommandValue(0)
 {}

tS32 vehicle_mainfi_tclMsgVoiceRecgCommandStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_VOICERECGCOMMANDSTATUS;
}


vehicle_mainfi_tclMsgVoiceRecgCommandStatus::~vehicle_mainfi_tclMsgVoiceRecgCommandStatus()
{}

tU32 vehicle_mainfi_tclMsgVoiceRecgCommandStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgVoiceRecgCommandStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VoiceRecgCommandValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgVoiceRecgCommandStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VoiceRecgCommandValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgVoiceRecgCommandStatus::operator==(const vehicle_mainfi_tclMsgVoiceRecgCommandStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VoiceRecgCommandValue == roRef.VoiceRecgCommandValue);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgDeviceInfoSWversionUpReg::vehicle_mainfi_tclMsgDeviceInfoSWversionUpReg()
 {}

tS32 vehicle_mainfi_tclMsgDeviceInfoSWversionUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DEVICEINFOSWVERSIONUPREG;
}


vehicle_mainfi_tclMsgDeviceInfoSWversionUpReg::~vehicle_mainfi_tclMsgDeviceInfoSWversionUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgDeviceInfoSWversionRelUpReg::vehicle_mainfi_tclMsgDeviceInfoSWversionRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgDeviceInfoSWversionRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DEVICEINFOSWVERSIONRELUPREG;
}


vehicle_mainfi_tclMsgDeviceInfoSWversionRelUpReg::~vehicle_mainfi_tclMsgDeviceInfoSWversionRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgDeviceInfoSWversionGet::vehicle_mainfi_tclMsgDeviceInfoSWversionGet()
 {}

tS32 vehicle_mainfi_tclMsgDeviceInfoSWversionGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DEVICEINFOSWVERSIONGET;
}


vehicle_mainfi_tclMsgDeviceInfoSWversionGet::~vehicle_mainfi_tclMsgDeviceInfoSWversionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgDeviceInfoSWversionStatus::vehicle_mainfi_tclMsgDeviceInfoSWversionStatus(const vehicle_mainfi_tclMsgDeviceInfoSWversionStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   SWversionValue = coRef.SWversionValue;
}
vehicle_mainfi_tclMsgDeviceInfoSWversionStatus& vehicle_mainfi_tclMsgDeviceInfoSWversionStatus::operator=(const vehicle_mainfi_tclMsgDeviceInfoSWversionStatus& coRef)
{
   if (this == &coRef) return *this;
   SWversionValue = coRef.SWversionValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgDeviceInfoSWversionStatus::vehicle_mainfi_tclMsgDeviceInfoSWversionStatus()
:SWversionValue(0)
 {}

tS32 vehicle_mainfi_tclMsgDeviceInfoSWversionStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DEVICEINFOSWVERSIONSTATUS;
}


vehicle_mainfi_tclMsgDeviceInfoSWversionStatus::~vehicle_mainfi_tclMsgDeviceInfoSWversionStatus()
{}

tU32 vehicle_mainfi_tclMsgDeviceInfoSWversionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& vehicle_mainfi_tclMsgDeviceInfoSWversionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SWversionValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgDeviceInfoSWversionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SWversionValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgDeviceInfoSWversionStatus::operator==(const vehicle_mainfi_tclMsgDeviceInfoSWversionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SWversionValue == roRef.SWversionValue);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgTrackCommandUpReg::vehicle_mainfi_tclMsgTrackCommandUpReg()
 {}

tS32 vehicle_mainfi_tclMsgTrackCommandUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TRACKCOMMANDUPREG;
}


vehicle_mainfi_tclMsgTrackCommandUpReg::~vehicle_mainfi_tclMsgTrackCommandUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgTrackCommandRelUpReg::vehicle_mainfi_tclMsgTrackCommandRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgTrackCommandRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TRACKCOMMANDRELUPREG;
}


vehicle_mainfi_tclMsgTrackCommandRelUpReg::~vehicle_mainfi_tclMsgTrackCommandRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgTrackCommandGet::vehicle_mainfi_tclMsgTrackCommandGet()
 {}

tS32 vehicle_mainfi_tclMsgTrackCommandGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TRACKCOMMANDGET;
}


vehicle_mainfi_tclMsgTrackCommandGet::~vehicle_mainfi_tclMsgTrackCommandGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgTrackCommandStatus::vehicle_mainfi_tclMsgTrackCommandStatus(const vehicle_mainfi_tclMsgTrackCommandStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   TrackCommandValue = coRef.TrackCommandValue;
}
vehicle_mainfi_tclMsgTrackCommandStatus& vehicle_mainfi_tclMsgTrackCommandStatus::operator=(const vehicle_mainfi_tclMsgTrackCommandStatus& coRef)
{
   if (this == &coRef) return *this;
   TrackCommandValue = coRef.TrackCommandValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgTrackCommandStatus::vehicle_mainfi_tclMsgTrackCommandStatus()
:TrackCommandValue(0)
 {}

tS32 vehicle_mainfi_tclMsgTrackCommandStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TRACKCOMMANDSTATUS;
}


vehicle_mainfi_tclMsgTrackCommandStatus::~vehicle_mainfi_tclMsgTrackCommandStatus()
{}

tU32 vehicle_mainfi_tclMsgTrackCommandStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgTrackCommandStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TrackCommandValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgTrackCommandStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TrackCommandValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgTrackCommandStatus::operator==(const vehicle_mainfi_tclMsgTrackCommandStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TrackCommandValue == roRef.TrackCommandValue);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgPhonePwrCmdUpReg::vehicle_mainfi_tclMsgPhonePwrCmdUpReg()
 {}

tS32 vehicle_mainfi_tclMsgPhonePwrCmdUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_PHONEPWRCMDUPREG;
}


vehicle_mainfi_tclMsgPhonePwrCmdUpReg::~vehicle_mainfi_tclMsgPhonePwrCmdUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgPhonePwrCmdRelUpReg::vehicle_mainfi_tclMsgPhonePwrCmdRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgPhonePwrCmdRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_PHONEPWRCMDRELUPREG;
}


vehicle_mainfi_tclMsgPhonePwrCmdRelUpReg::~vehicle_mainfi_tclMsgPhonePwrCmdRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgPhonePwrCmdGet::vehicle_mainfi_tclMsgPhonePwrCmdGet()
 {}

tS32 vehicle_mainfi_tclMsgPhonePwrCmdGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_PHONEPWRCMDGET;
}


vehicle_mainfi_tclMsgPhonePwrCmdGet::~vehicle_mainfi_tclMsgPhonePwrCmdGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgPhonePwrCmdStatus::vehicle_mainfi_tclMsgPhonePwrCmdStatus(const vehicle_mainfi_tclMsgPhonePwrCmdStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   PhonePwrCmdValue = coRef.PhonePwrCmdValue;
}
vehicle_mainfi_tclMsgPhonePwrCmdStatus& vehicle_mainfi_tclMsgPhonePwrCmdStatus::operator=(const vehicle_mainfi_tclMsgPhonePwrCmdStatus& coRef)
{
   if (this == &coRef) return *this;
   PhonePwrCmdValue = coRef.PhonePwrCmdValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgPhonePwrCmdStatus::vehicle_mainfi_tclMsgPhonePwrCmdStatus()
:PhonePwrCmdValue(0)
 {}

tS32 vehicle_mainfi_tclMsgPhonePwrCmdStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_PHONEPWRCMDSTATUS;
}


vehicle_mainfi_tclMsgPhonePwrCmdStatus::~vehicle_mainfi_tclMsgPhonePwrCmdStatus()
{}

tU32 vehicle_mainfi_tclMsgPhonePwrCmdStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgPhonePwrCmdStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PhonePwrCmdValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgPhonePwrCmdStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PhonePwrCmdValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgPhonePwrCmdStatus::operator==(const vehicle_mainfi_tclMsgPhonePwrCmdStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PhonePwrCmdValue == roRef.PhonePwrCmdValue);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgRadioPwrCmdUpReg::vehicle_mainfi_tclMsgRadioPwrCmdUpReg()
 {}

tS32 vehicle_mainfi_tclMsgRadioPwrCmdUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_RADIOPWRCMDUPREG;
}


vehicle_mainfi_tclMsgRadioPwrCmdUpReg::~vehicle_mainfi_tclMsgRadioPwrCmdUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgRadioPwrCmdRelUpReg::vehicle_mainfi_tclMsgRadioPwrCmdRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgRadioPwrCmdRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_RADIOPWRCMDRELUPREG;
}


vehicle_mainfi_tclMsgRadioPwrCmdRelUpReg::~vehicle_mainfi_tclMsgRadioPwrCmdRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgRadioPwrCmdGet::vehicle_mainfi_tclMsgRadioPwrCmdGet()
 {}

tS32 vehicle_mainfi_tclMsgRadioPwrCmdGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_RADIOPWRCMDGET;
}


vehicle_mainfi_tclMsgRadioPwrCmdGet::~vehicle_mainfi_tclMsgRadioPwrCmdGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgRadioPwrCmdStatus::vehicle_mainfi_tclMsgRadioPwrCmdStatus(const vehicle_mainfi_tclMsgRadioPwrCmdStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   RadioPwrCmdValue = coRef.RadioPwrCmdValue;
}
vehicle_mainfi_tclMsgRadioPwrCmdStatus& vehicle_mainfi_tclMsgRadioPwrCmdStatus::operator=(const vehicle_mainfi_tclMsgRadioPwrCmdStatus& coRef)
{
   if (this == &coRef) return *this;
   RadioPwrCmdValue = coRef.RadioPwrCmdValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgRadioPwrCmdStatus::vehicle_mainfi_tclMsgRadioPwrCmdStatus()
:RadioPwrCmdValue(0)
 {}

tS32 vehicle_mainfi_tclMsgRadioPwrCmdStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_RADIOPWRCMDSTATUS;
}


vehicle_mainfi_tclMsgRadioPwrCmdStatus::~vehicle_mainfi_tclMsgRadioPwrCmdStatus()
{}

tU32 vehicle_mainfi_tclMsgRadioPwrCmdStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgRadioPwrCmdStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RadioPwrCmdValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgRadioPwrCmdStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RadioPwrCmdValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgRadioPwrCmdStatus::operator==(const vehicle_mainfi_tclMsgRadioPwrCmdStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RadioPwrCmdValue == roRef.RadioPwrCmdValue);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgRCNextBtnUpReg::vehicle_mainfi_tclMsgRCNextBtnUpReg()
 {}

tS32 vehicle_mainfi_tclMsgRCNextBtnUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_RCNEXTBTNUPREG;
}


vehicle_mainfi_tclMsgRCNextBtnUpReg::~vehicle_mainfi_tclMsgRCNextBtnUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgRCNextBtnRelUpReg::vehicle_mainfi_tclMsgRCNextBtnRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgRCNextBtnRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_RCNEXTBTNRELUPREG;
}


vehicle_mainfi_tclMsgRCNextBtnRelUpReg::~vehicle_mainfi_tclMsgRCNextBtnRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgRCNextBtnGet::vehicle_mainfi_tclMsgRCNextBtnGet()
 {}

tS32 vehicle_mainfi_tclMsgRCNextBtnGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_RCNEXTBTNGET;
}


vehicle_mainfi_tclMsgRCNextBtnGet::~vehicle_mainfi_tclMsgRCNextBtnGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgRCNextBtnStatus::vehicle_mainfi_tclMsgRCNextBtnStatus(const vehicle_mainfi_tclMsgRCNextBtnStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   RCNextBtnValue = coRef.RCNextBtnValue;
}
vehicle_mainfi_tclMsgRCNextBtnStatus& vehicle_mainfi_tclMsgRCNextBtnStatus::operator=(const vehicle_mainfi_tclMsgRCNextBtnStatus& coRef)
{
   if (this == &coRef) return *this;
   RCNextBtnValue = coRef.RCNextBtnValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgRCNextBtnStatus::vehicle_mainfi_tclMsgRCNextBtnStatus()
:RCNextBtnValue(0)
 {}

tS32 vehicle_mainfi_tclMsgRCNextBtnStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_RCNEXTBTNSTATUS;
}


vehicle_mainfi_tclMsgRCNextBtnStatus::~vehicle_mainfi_tclMsgRCNextBtnStatus()
{}

tU32 vehicle_mainfi_tclMsgRCNextBtnStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgRCNextBtnStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RCNextBtnValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgRCNextBtnStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RCNextBtnValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgRCNextBtnStatus::operator==(const vehicle_mainfi_tclMsgRCNextBtnStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RCNextBtnValue == roRef.RCNextBtnValue);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgRCPrevBtnUpReg::vehicle_mainfi_tclMsgRCPrevBtnUpReg()
 {}

tS32 vehicle_mainfi_tclMsgRCPrevBtnUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_RCPREVBTNUPREG;
}


vehicle_mainfi_tclMsgRCPrevBtnUpReg::~vehicle_mainfi_tclMsgRCPrevBtnUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgRCPrevBtnRelUpReg::vehicle_mainfi_tclMsgRCPrevBtnRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgRCPrevBtnRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_RCPREVBTNRELUPREG;
}


vehicle_mainfi_tclMsgRCPrevBtnRelUpReg::~vehicle_mainfi_tclMsgRCPrevBtnRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgRCPrevBtnGet::vehicle_mainfi_tclMsgRCPrevBtnGet()
 {}

tS32 vehicle_mainfi_tclMsgRCPrevBtnGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_RCPREVBTNGET;
}


vehicle_mainfi_tclMsgRCPrevBtnGet::~vehicle_mainfi_tclMsgRCPrevBtnGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgRCPrevBtnStatus::vehicle_mainfi_tclMsgRCPrevBtnStatus(const vehicle_mainfi_tclMsgRCPrevBtnStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   RCPrevBtnValue = coRef.RCPrevBtnValue;
}
vehicle_mainfi_tclMsgRCPrevBtnStatus& vehicle_mainfi_tclMsgRCPrevBtnStatus::operator=(const vehicle_mainfi_tclMsgRCPrevBtnStatus& coRef)
{
   if (this == &coRef) return *this;
   RCPrevBtnValue = coRef.RCPrevBtnValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgRCPrevBtnStatus::vehicle_mainfi_tclMsgRCPrevBtnStatus()
:RCPrevBtnValue(0)
 {}

tS32 vehicle_mainfi_tclMsgRCPrevBtnStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_RCPREVBTNSTATUS;
}


vehicle_mainfi_tclMsgRCPrevBtnStatus::~vehicle_mainfi_tclMsgRCPrevBtnStatus()
{}

tU32 vehicle_mainfi_tclMsgRCPrevBtnStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgRCPrevBtnStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RCPrevBtnValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgRCPrevBtnStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RCPrevBtnValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgRCPrevBtnStatus::operator==(const vehicle_mainfi_tclMsgRCPrevBtnStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RCPrevBtnValue == roRef.RCPrevBtnValue);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgSourceCommandUpReg::vehicle_mainfi_tclMsgSourceCommandUpReg()
 {}

tS32 vehicle_mainfi_tclMsgSourceCommandUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SOURCECOMMANDUPREG;
}


vehicle_mainfi_tclMsgSourceCommandUpReg::~vehicle_mainfi_tclMsgSourceCommandUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgSourceCommandRelUpReg::vehicle_mainfi_tclMsgSourceCommandRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgSourceCommandRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SOURCECOMMANDRELUPREG;
}


vehicle_mainfi_tclMsgSourceCommandRelUpReg::~vehicle_mainfi_tclMsgSourceCommandRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgSourceCommandGet::vehicle_mainfi_tclMsgSourceCommandGet()
 {}

tS32 vehicle_mainfi_tclMsgSourceCommandGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SOURCECOMMANDGET;
}


vehicle_mainfi_tclMsgSourceCommandGet::~vehicle_mainfi_tclMsgSourceCommandGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSourceCommandStatus::vehicle_mainfi_tclMsgSourceCommandStatus(const vehicle_mainfi_tclMsgSourceCommandStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   SourceCommandValue = coRef.SourceCommandValue;
}
vehicle_mainfi_tclMsgSourceCommandStatus& vehicle_mainfi_tclMsgSourceCommandStatus::operator=(const vehicle_mainfi_tclMsgSourceCommandStatus& coRef)
{
   if (this == &coRef) return *this;
   SourceCommandValue = coRef.SourceCommandValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgSourceCommandStatus::vehicle_mainfi_tclMsgSourceCommandStatus()
:SourceCommandValue(0)
 {}

tS32 vehicle_mainfi_tclMsgSourceCommandStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SOURCECOMMANDSTATUS;
}


vehicle_mainfi_tclMsgSourceCommandStatus::~vehicle_mainfi_tclMsgSourceCommandStatus()
{}

tU32 vehicle_mainfi_tclMsgSourceCommandStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgSourceCommandStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SourceCommandValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSourceCommandStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SourceCommandValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSourceCommandStatus::operator==(const vehicle_mainfi_tclMsgSourceCommandStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SourceCommandValue == roRef.SourceCommandValue);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgTunerCommandUpReg::vehicle_mainfi_tclMsgTunerCommandUpReg()
 {}

tS32 vehicle_mainfi_tclMsgTunerCommandUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TUNERCOMMANDUPREG;
}


vehicle_mainfi_tclMsgTunerCommandUpReg::~vehicle_mainfi_tclMsgTunerCommandUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgTunerCommandRelUpReg::vehicle_mainfi_tclMsgTunerCommandRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgTunerCommandRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TUNERCOMMANDRELUPREG;
}


vehicle_mainfi_tclMsgTunerCommandRelUpReg::~vehicle_mainfi_tclMsgTunerCommandRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgTunerCommandGet::vehicle_mainfi_tclMsgTunerCommandGet()
 {}

tS32 vehicle_mainfi_tclMsgTunerCommandGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TUNERCOMMANDGET;
}


vehicle_mainfi_tclMsgTunerCommandGet::~vehicle_mainfi_tclMsgTunerCommandGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgTunerCommandStatus::vehicle_mainfi_tclMsgTunerCommandStatus(const vehicle_mainfi_tclMsgTunerCommandStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   TunerCommandValue = coRef.TunerCommandValue;
}
vehicle_mainfi_tclMsgTunerCommandStatus& vehicle_mainfi_tclMsgTunerCommandStatus::operator=(const vehicle_mainfi_tclMsgTunerCommandStatus& coRef)
{
   if (this == &coRef) return *this;
   TunerCommandValue = coRef.TunerCommandValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgTunerCommandStatus::vehicle_mainfi_tclMsgTunerCommandStatus()
:TunerCommandValue(0)
 {}

tS32 vehicle_mainfi_tclMsgTunerCommandStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TUNERCOMMANDSTATUS;
}


vehicle_mainfi_tclMsgTunerCommandStatus::~vehicle_mainfi_tclMsgTunerCommandStatus()
{}

tU32 vehicle_mainfi_tclMsgTunerCommandStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgTunerCommandStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerCommandValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgTunerCommandStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerCommandValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgTunerCommandStatus::operator==(const vehicle_mainfi_tclMsgTunerCommandStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerCommandValue == roRef.TunerCommandValue);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgTACommandUpReg::vehicle_mainfi_tclMsgTACommandUpReg()
 {}

tS32 vehicle_mainfi_tclMsgTACommandUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TACOMMANDUPREG;
}


vehicle_mainfi_tclMsgTACommandUpReg::~vehicle_mainfi_tclMsgTACommandUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgTACommandRelUpReg::vehicle_mainfi_tclMsgTACommandRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgTACommandRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TACOMMANDRELUPREG;
}


vehicle_mainfi_tclMsgTACommandRelUpReg::~vehicle_mainfi_tclMsgTACommandRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgTACommandGet::vehicle_mainfi_tclMsgTACommandGet()
 {}

tS32 vehicle_mainfi_tclMsgTACommandGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TACOMMANDGET;
}


vehicle_mainfi_tclMsgTACommandGet::~vehicle_mainfi_tclMsgTACommandGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgTACommandStatus::vehicle_mainfi_tclMsgTACommandStatus(const vehicle_mainfi_tclMsgTACommandStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   TACommandValue = coRef.TACommandValue;
}
vehicle_mainfi_tclMsgTACommandStatus& vehicle_mainfi_tclMsgTACommandStatus::operator=(const vehicle_mainfi_tclMsgTACommandStatus& coRef)
{
   if (this == &coRef) return *this;
   TACommandValue = coRef.TACommandValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgTACommandStatus::vehicle_mainfi_tclMsgTACommandStatus()
:TACommandValue(0)
 {}

tS32 vehicle_mainfi_tclMsgTACommandStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TACOMMANDSTATUS;
}


vehicle_mainfi_tclMsgTACommandStatus::~vehicle_mainfi_tclMsgTACommandStatus()
{}

tU32 vehicle_mainfi_tclMsgTACommandStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgTACommandStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TACommandValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgTACommandStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TACommandValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgTACommandStatus::operator==(const vehicle_mainfi_tclMsgTACommandStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TACommandValue == roRef.TACommandValue);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgRDSCommandUpReg::vehicle_mainfi_tclMsgRDSCommandUpReg()
 {}

tS32 vehicle_mainfi_tclMsgRDSCommandUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_RDSCOMMANDUPREG;
}


vehicle_mainfi_tclMsgRDSCommandUpReg::~vehicle_mainfi_tclMsgRDSCommandUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgRDSCommandRelUpReg::vehicle_mainfi_tclMsgRDSCommandRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgRDSCommandRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_RDSCOMMANDRELUPREG;
}


vehicle_mainfi_tclMsgRDSCommandRelUpReg::~vehicle_mainfi_tclMsgRDSCommandRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgRDSCommandGet::vehicle_mainfi_tclMsgRDSCommandGet()
 {}

tS32 vehicle_mainfi_tclMsgRDSCommandGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_RDSCOMMANDGET;
}


vehicle_mainfi_tclMsgRDSCommandGet::~vehicle_mainfi_tclMsgRDSCommandGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgRDSCommandStatus::vehicle_mainfi_tclMsgRDSCommandStatus(const vehicle_mainfi_tclMsgRDSCommandStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   RDSCommandValue = coRef.RDSCommandValue;
}
vehicle_mainfi_tclMsgRDSCommandStatus& vehicle_mainfi_tclMsgRDSCommandStatus::operator=(const vehicle_mainfi_tclMsgRDSCommandStatus& coRef)
{
   if (this == &coRef) return *this;
   RDSCommandValue = coRef.RDSCommandValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgRDSCommandStatus::vehicle_mainfi_tclMsgRDSCommandStatus()
:RDSCommandValue(0)
 {}

tS32 vehicle_mainfi_tclMsgRDSCommandStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_RDSCOMMANDSTATUS;
}


vehicle_mainfi_tclMsgRDSCommandStatus::~vehicle_mainfi_tclMsgRDSCommandStatus()
{}

tU32 vehicle_mainfi_tclMsgRDSCommandStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgRDSCommandStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RDSCommandValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgRDSCommandStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RDSCommandValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgRDSCommandStatus::operator==(const vehicle_mainfi_tclMsgRDSCommandStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RDSCommandValue == roRef.RDSCommandValue);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgSMARTVRUpReg::vehicle_mainfi_tclMsgSMARTVRUpReg()
 {}

tS32 vehicle_mainfi_tclMsgSMARTVRUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SMARTVRUPREG;
}


vehicle_mainfi_tclMsgSMARTVRUpReg::~vehicle_mainfi_tclMsgSMARTVRUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgSMARTVRRelUpReg::vehicle_mainfi_tclMsgSMARTVRRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgSMARTVRRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SMARTVRRELUPREG;
}


vehicle_mainfi_tclMsgSMARTVRRelUpReg::~vehicle_mainfi_tclMsgSMARTVRRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgSMARTVRGet::vehicle_mainfi_tclMsgSMARTVRGet()
 {}

tS32 vehicle_mainfi_tclMsgSMARTVRGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SMARTVRGET;
}


vehicle_mainfi_tclMsgSMARTVRGet::~vehicle_mainfi_tclMsgSMARTVRGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgSMARTVRStatus::vehicle_mainfi_tclMsgSMARTVRStatus(const vehicle_mainfi_tclMsgSMARTVRStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   SMARTVRValue = coRef.SMARTVRValue;
}
vehicle_mainfi_tclMsgSMARTVRStatus& vehicle_mainfi_tclMsgSMARTVRStatus::operator=(const vehicle_mainfi_tclMsgSMARTVRStatus& coRef)
{
   if (this == &coRef) return *this;
   SMARTVRValue = coRef.SMARTVRValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgSMARTVRStatus::vehicle_mainfi_tclMsgSMARTVRStatus()
:SMARTVRValue(0)
 {}

tS32 vehicle_mainfi_tclMsgSMARTVRStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_SMARTVRSTATUS;
}


vehicle_mainfi_tclMsgSMARTVRStatus::~vehicle_mainfi_tclMsgSMARTVRStatus()
{}

tU32 vehicle_mainfi_tclMsgSMARTVRStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgSMARTVRStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SMARTVRValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgSMARTVRStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SMARTVRValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgSMARTVRStatus::operator==(const vehicle_mainfi_tclMsgSMARTVRStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SMARTVRValue == roRef.SMARTVRValue);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgTotalVehDistDiagUpReg::vehicle_mainfi_tclMsgTotalVehDistDiagUpReg()
 {}

tS32 vehicle_mainfi_tclMsgTotalVehDistDiagUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TOTALVEHDISTDIAGUPREG;
}


vehicle_mainfi_tclMsgTotalVehDistDiagUpReg::~vehicle_mainfi_tclMsgTotalVehDistDiagUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgTotalVehDistDiagRelUpReg::vehicle_mainfi_tclMsgTotalVehDistDiagRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgTotalVehDistDiagRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TOTALVEHDISTDIAGRELUPREG;
}


vehicle_mainfi_tclMsgTotalVehDistDiagRelUpReg::~vehicle_mainfi_tclMsgTotalVehDistDiagRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgTotalVehDistDiagGet::vehicle_mainfi_tclMsgTotalVehDistDiagGet()
 {}

tS32 vehicle_mainfi_tclMsgTotalVehDistDiagGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TOTALVEHDISTDIAGGET;
}


vehicle_mainfi_tclMsgTotalVehDistDiagGet::~vehicle_mainfi_tclMsgTotalVehDistDiagGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgTotalVehDistDiagStatus::vehicle_mainfi_tclMsgTotalVehDistDiagStatus(const vehicle_mainfi_tclMsgTotalVehDistDiagStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   TotalVehDistDiagValue = coRef.TotalVehDistDiagValue;
}
vehicle_mainfi_tclMsgTotalVehDistDiagStatus& vehicle_mainfi_tclMsgTotalVehDistDiagStatus::operator=(const vehicle_mainfi_tclMsgTotalVehDistDiagStatus& coRef)
{
   if (this == &coRef) return *this;
   TotalVehDistDiagValue = coRef.TotalVehDistDiagValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgTotalVehDistDiagStatus::vehicle_mainfi_tclMsgTotalVehDistDiagStatus()
:TotalVehDistDiagValue(0)
 {}

tS32 vehicle_mainfi_tclMsgTotalVehDistDiagStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TOTALVEHDISTDIAGSTATUS;
}


vehicle_mainfi_tclMsgTotalVehDistDiagStatus::~vehicle_mainfi_tclMsgTotalVehDistDiagStatus()
{}

tU32 vehicle_mainfi_tclMsgTotalVehDistDiagStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& vehicle_mainfi_tclMsgTotalVehDistDiagStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TotalVehDistDiagValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgTotalVehDistDiagStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TotalVehDistDiagValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgTotalVehDistDiagStatus::operator==(const vehicle_mainfi_tclMsgTotalVehDistDiagStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TotalVehDistDiagValue == roRef.TotalVehDistDiagValue);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgVIN_64UpReg::vehicle_mainfi_tclMsgVIN_64UpReg()
 {}

tS32 vehicle_mainfi_tclMsgVIN_64UpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_VIN_64UPREG;
}


vehicle_mainfi_tclMsgVIN_64UpReg::~vehicle_mainfi_tclMsgVIN_64UpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgVIN_64RelUpReg::vehicle_mainfi_tclMsgVIN_64RelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgVIN_64RelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_VIN_64RELUPREG;
}


vehicle_mainfi_tclMsgVIN_64RelUpReg::~vehicle_mainfi_tclMsgVIN_64RelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgVIN_64Get::vehicle_mainfi_tclMsgVIN_64Get()
 {}

tS32 vehicle_mainfi_tclMsgVIN_64Get::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_VIN_64GET;
}


vehicle_mainfi_tclMsgVIN_64Get::~vehicle_mainfi_tclMsgVIN_64Get()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgVIN_64Status::vehicle_mainfi_tclMsgVIN_64Status(const vehicle_mainfi_tclMsgVIN_64Status& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   VIN_64Value = coRef.VIN_64Value;
}
vehicle_mainfi_tclMsgVIN_64Status& vehicle_mainfi_tclMsgVIN_64Status::operator=(const vehicle_mainfi_tclMsgVIN_64Status& coRef)
{
   if (this == &coRef) return *this;
   VIN_64Value = coRef.VIN_64Value;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgVIN_64Status::vehicle_mainfi_tclMsgVIN_64Status()
:VIN_64Value(0)
 {}

tS32 vehicle_mainfi_tclMsgVIN_64Status::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_VIN_64STATUS;
}


vehicle_mainfi_tclMsgVIN_64Status::~vehicle_mainfi_tclMsgVIN_64Status()
{}

tU32 vehicle_mainfi_tclMsgVIN_64Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& vehicle_mainfi_tclMsgVIN_64Status::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VIN_64Value);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgVIN_64Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VIN_64Value);
   return oOut;
}

tBool vehicle_mainfi_tclMsgVIN_64Status::operator==(const vehicle_mainfi_tclMsgVIN_64Status& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VIN_64Value == roRef.VIN_64Value);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgCabinMediaSourceCommandUpReg::vehicle_mainfi_tclMsgCabinMediaSourceCommandUpReg()
 {}

tS32 vehicle_mainfi_tclMsgCabinMediaSourceCommandUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CABINMEDIASOURCECOMMANDUPREG;
}


vehicle_mainfi_tclMsgCabinMediaSourceCommandUpReg::~vehicle_mainfi_tclMsgCabinMediaSourceCommandUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgCabinMediaSourceCommandRelUpReg::vehicle_mainfi_tclMsgCabinMediaSourceCommandRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgCabinMediaSourceCommandRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CABINMEDIASOURCECOMMANDRELUPREG;
}


vehicle_mainfi_tclMsgCabinMediaSourceCommandRelUpReg::~vehicle_mainfi_tclMsgCabinMediaSourceCommandRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgCabinMediaSourceCommandGet::vehicle_mainfi_tclMsgCabinMediaSourceCommandGet()
 {}

tS32 vehicle_mainfi_tclMsgCabinMediaSourceCommandGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CABINMEDIASOURCECOMMANDGET;
}


vehicle_mainfi_tclMsgCabinMediaSourceCommandGet::~vehicle_mainfi_tclMsgCabinMediaSourceCommandGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCabinMediaSourceCommandStatus::vehicle_mainfi_tclMsgCabinMediaSourceCommandStatus(const vehicle_mainfi_tclMsgCabinMediaSourceCommandStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   CabinMediaSourceCommandValue = coRef.CabinMediaSourceCommandValue;
}
vehicle_mainfi_tclMsgCabinMediaSourceCommandStatus& vehicle_mainfi_tclMsgCabinMediaSourceCommandStatus::operator=(const vehicle_mainfi_tclMsgCabinMediaSourceCommandStatus& coRef)
{
   if (this == &coRef) return *this;
   CabinMediaSourceCommandValue = coRef.CabinMediaSourceCommandValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCabinMediaSourceCommandStatus::vehicle_mainfi_tclMsgCabinMediaSourceCommandStatus()
:CabinMediaSourceCommandValue(0)
 {}

tS32 vehicle_mainfi_tclMsgCabinMediaSourceCommandStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CABINMEDIASOURCECOMMANDSTATUS;
}


vehicle_mainfi_tclMsgCabinMediaSourceCommandStatus::~vehicle_mainfi_tclMsgCabinMediaSourceCommandStatus()
{}

tU32 vehicle_mainfi_tclMsgCabinMediaSourceCommandStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCabinMediaSourceCommandStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CabinMediaSourceCommandValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCabinMediaSourceCommandStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CabinMediaSourceCommandValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCabinMediaSourceCommandStatus::operator==(const vehicle_mainfi_tclMsgCabinMediaSourceCommandStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CabinMediaSourceCommandValue == roRef.CabinMediaSourceCommandValue);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgCabinMediaVolumeCommandUpReg::vehicle_mainfi_tclMsgCabinMediaVolumeCommandUpReg()
 {}

tS32 vehicle_mainfi_tclMsgCabinMediaVolumeCommandUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CABINMEDIAVOLUMECOMMANDUPREG;
}


vehicle_mainfi_tclMsgCabinMediaVolumeCommandUpReg::~vehicle_mainfi_tclMsgCabinMediaVolumeCommandUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgCabinMediaVolumeCommandRelUpReg::vehicle_mainfi_tclMsgCabinMediaVolumeCommandRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgCabinMediaVolumeCommandRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CABINMEDIAVOLUMECOMMANDRELUPREG;
}


vehicle_mainfi_tclMsgCabinMediaVolumeCommandRelUpReg::~vehicle_mainfi_tclMsgCabinMediaVolumeCommandRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgCabinMediaVolumeCommandGet::vehicle_mainfi_tclMsgCabinMediaVolumeCommandGet()
 {}

tS32 vehicle_mainfi_tclMsgCabinMediaVolumeCommandGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CABINMEDIAVOLUMECOMMANDGET;
}


vehicle_mainfi_tclMsgCabinMediaVolumeCommandGet::~vehicle_mainfi_tclMsgCabinMediaVolumeCommandGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCabinMediaVolumeCommandStatus::vehicle_mainfi_tclMsgCabinMediaVolumeCommandStatus(const vehicle_mainfi_tclMsgCabinMediaVolumeCommandStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   CabinMediaVolumeCommandValue = coRef.CabinMediaVolumeCommandValue;
}
vehicle_mainfi_tclMsgCabinMediaVolumeCommandStatus& vehicle_mainfi_tclMsgCabinMediaVolumeCommandStatus::operator=(const vehicle_mainfi_tclMsgCabinMediaVolumeCommandStatus& coRef)
{
   if (this == &coRef) return *this;
   CabinMediaVolumeCommandValue = coRef.CabinMediaVolumeCommandValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCabinMediaVolumeCommandStatus::vehicle_mainfi_tclMsgCabinMediaVolumeCommandStatus()
:CabinMediaVolumeCommandValue(0)
 {}

tS32 vehicle_mainfi_tclMsgCabinMediaVolumeCommandStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CABINMEDIAVOLUMECOMMANDSTATUS;
}


vehicle_mainfi_tclMsgCabinMediaVolumeCommandStatus::~vehicle_mainfi_tclMsgCabinMediaVolumeCommandStatus()
{}

tU32 vehicle_mainfi_tclMsgCabinMediaVolumeCommandStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCabinMediaVolumeCommandStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CabinMediaVolumeCommandValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCabinMediaVolumeCommandStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CabinMediaVolumeCommandValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCabinMediaVolumeCommandStatus::operator==(const vehicle_mainfi_tclMsgCabinMediaVolumeCommandStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CabinMediaVolumeCommandValue == roRef.CabinMediaVolumeCommandValue);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgCabinMediaTunerCommandUpReg::vehicle_mainfi_tclMsgCabinMediaTunerCommandUpReg()
 {}

tS32 vehicle_mainfi_tclMsgCabinMediaTunerCommandUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CABINMEDIATUNERCOMMANDUPREG;
}


vehicle_mainfi_tclMsgCabinMediaTunerCommandUpReg::~vehicle_mainfi_tclMsgCabinMediaTunerCommandUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgCabinMediaTunerCommandRelUpReg::vehicle_mainfi_tclMsgCabinMediaTunerCommandRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgCabinMediaTunerCommandRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CABINMEDIATUNERCOMMANDRELUPREG;
}


vehicle_mainfi_tclMsgCabinMediaTunerCommandRelUpReg::~vehicle_mainfi_tclMsgCabinMediaTunerCommandRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgCabinMediaTunerCommandGet::vehicle_mainfi_tclMsgCabinMediaTunerCommandGet()
 {}

tS32 vehicle_mainfi_tclMsgCabinMediaTunerCommandGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CABINMEDIATUNERCOMMANDGET;
}


vehicle_mainfi_tclMsgCabinMediaTunerCommandGet::~vehicle_mainfi_tclMsgCabinMediaTunerCommandGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCabinMediaTunerCommandStatus::vehicle_mainfi_tclMsgCabinMediaTunerCommandStatus(const vehicle_mainfi_tclMsgCabinMediaTunerCommandStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   CabinMediaTunerCommandValue = coRef.CabinMediaTunerCommandValue;
}
vehicle_mainfi_tclMsgCabinMediaTunerCommandStatus& vehicle_mainfi_tclMsgCabinMediaTunerCommandStatus::operator=(const vehicle_mainfi_tclMsgCabinMediaTunerCommandStatus& coRef)
{
   if (this == &coRef) return *this;
   CabinMediaTunerCommandValue = coRef.CabinMediaTunerCommandValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCabinMediaTunerCommandStatus::vehicle_mainfi_tclMsgCabinMediaTunerCommandStatus()
:CabinMediaTunerCommandValue(0)
 {}

tS32 vehicle_mainfi_tclMsgCabinMediaTunerCommandStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CABINMEDIATUNERCOMMANDSTATUS;
}


vehicle_mainfi_tclMsgCabinMediaTunerCommandStatus::~vehicle_mainfi_tclMsgCabinMediaTunerCommandStatus()
{}

tU32 vehicle_mainfi_tclMsgCabinMediaTunerCommandStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCabinMediaTunerCommandStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CabinMediaTunerCommandValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCabinMediaTunerCommandStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CabinMediaTunerCommandValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCabinMediaTunerCommandStatus::operator==(const vehicle_mainfi_tclMsgCabinMediaTunerCommandStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CabinMediaTunerCommandValue == roRef.CabinMediaTunerCommandValue);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgCabinMediaTrackCommandUpReg::vehicle_mainfi_tclMsgCabinMediaTrackCommandUpReg()
 {}

tS32 vehicle_mainfi_tclMsgCabinMediaTrackCommandUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CABINMEDIATRACKCOMMANDUPREG;
}


vehicle_mainfi_tclMsgCabinMediaTrackCommandUpReg::~vehicle_mainfi_tclMsgCabinMediaTrackCommandUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgCabinMediaTrackCommandRelUpReg::vehicle_mainfi_tclMsgCabinMediaTrackCommandRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgCabinMediaTrackCommandRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CABINMEDIATRACKCOMMANDRELUPREG;
}


vehicle_mainfi_tclMsgCabinMediaTrackCommandRelUpReg::~vehicle_mainfi_tclMsgCabinMediaTrackCommandRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgCabinMediaTrackCommandGet::vehicle_mainfi_tclMsgCabinMediaTrackCommandGet()
 {}

tS32 vehicle_mainfi_tclMsgCabinMediaTrackCommandGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CABINMEDIATRACKCOMMANDGET;
}


vehicle_mainfi_tclMsgCabinMediaTrackCommandGet::~vehicle_mainfi_tclMsgCabinMediaTrackCommandGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCabinMediaTrackCommandStatus::vehicle_mainfi_tclMsgCabinMediaTrackCommandStatus(const vehicle_mainfi_tclMsgCabinMediaTrackCommandStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   CabinMediaTrackCommandValue = coRef.CabinMediaTrackCommandValue;
}
vehicle_mainfi_tclMsgCabinMediaTrackCommandStatus& vehicle_mainfi_tclMsgCabinMediaTrackCommandStatus::operator=(const vehicle_mainfi_tclMsgCabinMediaTrackCommandStatus& coRef)
{
   if (this == &coRef) return *this;
   CabinMediaTrackCommandValue = coRef.CabinMediaTrackCommandValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCabinMediaTrackCommandStatus::vehicle_mainfi_tclMsgCabinMediaTrackCommandStatus()
:CabinMediaTrackCommandValue(0)
 {}

tS32 vehicle_mainfi_tclMsgCabinMediaTrackCommandStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CABINMEDIATRACKCOMMANDSTATUS;
}


vehicle_mainfi_tclMsgCabinMediaTrackCommandStatus::~vehicle_mainfi_tclMsgCabinMediaTrackCommandStatus()
{}

tU32 vehicle_mainfi_tclMsgCabinMediaTrackCommandStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCabinMediaTrackCommandStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CabinMediaTrackCommandValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCabinMediaTrackCommandStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CabinMediaTrackCommandValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCabinMediaTrackCommandStatus::operator==(const vehicle_mainfi_tclMsgCabinMediaTrackCommandStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CabinMediaTrackCommandValue == roRef.CabinMediaTrackCommandValue);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgCabinMediaPlaylistCommandUpReg::vehicle_mainfi_tclMsgCabinMediaPlaylistCommandUpReg()
 {}

tS32 vehicle_mainfi_tclMsgCabinMediaPlaylistCommandUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CABINMEDIAPLAYLISTCOMMANDUPREG;
}


vehicle_mainfi_tclMsgCabinMediaPlaylistCommandUpReg::~vehicle_mainfi_tclMsgCabinMediaPlaylistCommandUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgCabinMediaPlaylistCommandRelUpReg::vehicle_mainfi_tclMsgCabinMediaPlaylistCommandRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgCabinMediaPlaylistCommandRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CABINMEDIAPLAYLISTCOMMANDRELUPREG;
}


vehicle_mainfi_tclMsgCabinMediaPlaylistCommandRelUpReg::~vehicle_mainfi_tclMsgCabinMediaPlaylistCommandRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgCabinMediaPlaylistCommandGet::vehicle_mainfi_tclMsgCabinMediaPlaylistCommandGet()
 {}

tS32 vehicle_mainfi_tclMsgCabinMediaPlaylistCommandGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CABINMEDIAPLAYLISTCOMMANDGET;
}


vehicle_mainfi_tclMsgCabinMediaPlaylistCommandGet::~vehicle_mainfi_tclMsgCabinMediaPlaylistCommandGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgCabinMediaPlaylistCommandStatus::vehicle_mainfi_tclMsgCabinMediaPlaylistCommandStatus(const vehicle_mainfi_tclMsgCabinMediaPlaylistCommandStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   CabinMediaPlaylistCommandValue = coRef.CabinMediaPlaylistCommandValue;
}
vehicle_mainfi_tclMsgCabinMediaPlaylistCommandStatus& vehicle_mainfi_tclMsgCabinMediaPlaylistCommandStatus::operator=(const vehicle_mainfi_tclMsgCabinMediaPlaylistCommandStatus& coRef)
{
   if (this == &coRef) return *this;
   CabinMediaPlaylistCommandValue = coRef.CabinMediaPlaylistCommandValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgCabinMediaPlaylistCommandStatus::vehicle_mainfi_tclMsgCabinMediaPlaylistCommandStatus()
:CabinMediaPlaylistCommandValue(0)
 {}

tS32 vehicle_mainfi_tclMsgCabinMediaPlaylistCommandStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_CABINMEDIAPLAYLISTCOMMANDSTATUS;
}


vehicle_mainfi_tclMsgCabinMediaPlaylistCommandStatus::~vehicle_mainfi_tclMsgCabinMediaPlaylistCommandStatus()
{}

tU32 vehicle_mainfi_tclMsgCabinMediaPlaylistCommandStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgCabinMediaPlaylistCommandStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CabinMediaPlaylistCommandValue);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgCabinMediaPlaylistCommandStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CabinMediaPlaylistCommandValue);
   return oOut;
}

tBool vehicle_mainfi_tclMsgCabinMediaPlaylistCommandStatus::operator==(const vehicle_mainfi_tclMsgCabinMediaPlaylistCommandStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CabinMediaPlaylistCommandValue == roRef.CabinMediaPlaylistCommandValue);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgNetworkStateUpReg::vehicle_mainfi_tclMsgNetworkStateUpReg()
 {}

tS32 vehicle_mainfi_tclMsgNetworkStateUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_NETWORKSTATEUPREG;
}


vehicle_mainfi_tclMsgNetworkStateUpReg::~vehicle_mainfi_tclMsgNetworkStateUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgNetworkStateRelUpReg::vehicle_mainfi_tclMsgNetworkStateRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgNetworkStateRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_NETWORKSTATERELUPREG;
}


vehicle_mainfi_tclMsgNetworkStateRelUpReg::~vehicle_mainfi_tclMsgNetworkStateRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgNetworkStateGet::vehicle_mainfi_tclMsgNetworkStateGet()
 {}

tS32 vehicle_mainfi_tclMsgNetworkStateGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_NETWORKSTATEGET;
}


vehicle_mainfi_tclMsgNetworkStateGet::~vehicle_mainfi_tclMsgNetworkStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgNetworkStateStatus::vehicle_mainfi_tclMsgNetworkStateStatus(const vehicle_mainfi_tclMsgNetworkStateStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   u8BusState_MCAN = coRef.u8BusState_MCAN;
   u8BusState_VCAN = coRef.u8BusState_VCAN;
   u8MuteState_MCAN = coRef.u8MuteState_MCAN;
   u8MuteState_VCAN = coRef.u8MuteState_VCAN;
   Listu8AbsentState_ECU = coRef.Listu8AbsentState_ECU;
   Listu8MuteStateMCAN_Channel = coRef.Listu8MuteStateMCAN_Channel;
   bBusOff_MCAN = coRef.bBusOff_MCAN;
   bBusOff_VCAN = coRef.bBusOff_VCAN;
   bBusOff = coRef.bBusOff;
   bMute_MCAN = coRef.bMute_MCAN;
   bMute_VCAN = coRef.bMute_VCAN;
}
vehicle_mainfi_tclMsgNetworkStateStatus& vehicle_mainfi_tclMsgNetworkStateStatus::operator=(const vehicle_mainfi_tclMsgNetworkStateStatus& coRef)
{
   if (this == &coRef) return *this;
   u8BusState_MCAN = coRef.u8BusState_MCAN;
   u8BusState_VCAN = coRef.u8BusState_VCAN;
   u8MuteState_MCAN = coRef.u8MuteState_MCAN;
   u8MuteState_VCAN = coRef.u8MuteState_VCAN;
   Listu8AbsentState_ECU = coRef.Listu8AbsentState_ECU;
   Listu8MuteStateMCAN_Channel = coRef.Listu8MuteStateMCAN_Channel;
   bBusOff_MCAN = coRef.bBusOff_MCAN;
   bBusOff_VCAN = coRef.bBusOff_VCAN;
   bBusOff = coRef.bBusOff;
   bMute_MCAN = coRef.bMute_MCAN;
   bMute_VCAN = coRef.bMute_VCAN;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid vehicle_mainfi_tclMsgNetworkStateStatus::vDestroy()
{
   {
   Listu8AbsentState_ECU.clear();
   }
   {
   Listu8MuteStateMCAN_Channel.clear();
   }
}

vehicle_mainfi_tclMsgNetworkStateStatus::vehicle_mainfi_tclMsgNetworkStateStatus()
:u8BusState_MCAN(0)
,u8BusState_VCAN(0)
,u8MuteState_MCAN(0)
,u8MuteState_VCAN(0)


,bBusOff_MCAN(0)
,bBusOff_VCAN(0)
,bBusOff(0)
,bMute_MCAN(0)
,bMute_VCAN(0)
 {}

tS32 vehicle_mainfi_tclMsgNetworkStateStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_NETWORKSTATESTATUS;
}


vehicle_mainfi_tclMsgNetworkStateStatus::~vehicle_mainfi_tclMsgNetworkStateStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 vehicle_mainfi_tclMsgNetworkStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 17+ static_cast<tU32>(Listu8AbsentState_ECU.size()*1)+ static_cast<tU32>(Listu8MuteStateMCAN_Channel.size()*1);
}

fi_tclInContext& vehicle_mainfi_tclMsgNetworkStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8BusState_MCAN);
   (tVoid) (oIn >> u8BusState_VCAN);
   (tVoid) (oIn >> u8MuteState_MCAN);
   (tVoid) (oIn >> u8MuteState_VCAN);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      Listu8AbsentState_ECU.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Listu8AbsentState_ECU[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      Listu8MuteStateMCAN_Channel.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Listu8MuteStateMCAN_Channel[u32Idx]);
      }
   }
   (tVoid) (oIn >> bBusOff_MCAN);
   (tVoid) (oIn >> bBusOff_VCAN);
   (tVoid) (oIn >> bBusOff);
   (tVoid) (oIn >> bMute_MCAN);
   (tVoid) (oIn >> bMute_VCAN);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgNetworkStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8BusState_MCAN);
   (tVoid) (oOut << u8BusState_VCAN);
   (tVoid) (oOut << u8MuteState_MCAN);
   (tVoid) (oOut << u8MuteState_VCAN);
   (tVoid) (oOut << (tU32)Listu8AbsentState_ECU.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Listu8AbsentState_ECU.size(); ++u32Idx)
         (tVoid) (oOut << Listu8AbsentState_ECU[u32Idx]);
   }
   (tVoid) (oOut << (tU32)Listu8MuteStateMCAN_Channel.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Listu8MuteStateMCAN_Channel.size(); ++u32Idx)
         (tVoid) (oOut << Listu8MuteStateMCAN_Channel[u32Idx]);
   }
   (tVoid) (oOut << bBusOff_MCAN);
   (tVoid) (oOut << bBusOff_VCAN);
   (tVoid) (oOut << bBusOff);
   (tVoid) (oOut << bMute_MCAN);
   (tVoid) (oOut << bMute_VCAN);
   return oOut;
}

tBool vehicle_mainfi_tclMsgNetworkStateStatus::operator==(const vehicle_mainfi_tclMsgNetworkStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8BusState_MCAN == roRef.u8BusState_MCAN);
   bResult = bResult && (u8BusState_VCAN == roRef.u8BusState_VCAN);
   bResult = bResult && (u8MuteState_MCAN == roRef.u8MuteState_MCAN);
   bResult = bResult && (u8MuteState_VCAN == roRef.u8MuteState_VCAN);
      bResult = bResult && (Listu8AbsentState_ECU.size() == roRef.Listu8AbsentState_ECU.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Listu8AbsentState_ECU.size()); ++u32Idx)
            bResult = bResult && (Listu8AbsentState_ECU[u32Idx] == roRef.Listu8AbsentState_ECU[u32Idx]);
      }
      bResult = bResult && (Listu8MuteStateMCAN_Channel.size() == roRef.Listu8MuteStateMCAN_Channel.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Listu8MuteStateMCAN_Channel.size()); ++u32Idx)
            bResult = bResult && (Listu8MuteStateMCAN_Channel[u32Idx] == roRef.Listu8MuteStateMCAN_Channel[u32Idx]);
      }
   bResult = bResult && (bBusOff_MCAN == roRef.bBusOff_MCAN);
   bResult = bResult && (bBusOff_VCAN == roRef.bBusOff_VCAN);
   bResult = bResult && (bBusOff == roRef.bBusOff);
   bResult = bResult && (bMute_MCAN == roRef.bMute_MCAN);
   bResult = bResult && (bMute_VCAN == roRef.bMute_VCAN);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgDistanceTotalizerUpReg::vehicle_mainfi_tclMsgDistanceTotalizerUpReg()
 {}

tS32 vehicle_mainfi_tclMsgDistanceTotalizerUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DISTANCETOTALIZERUPREG;
}


vehicle_mainfi_tclMsgDistanceTotalizerUpReg::~vehicle_mainfi_tclMsgDistanceTotalizerUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgDistanceTotalizerRelUpReg::vehicle_mainfi_tclMsgDistanceTotalizerRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgDistanceTotalizerRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DISTANCETOTALIZERRELUPREG;
}


vehicle_mainfi_tclMsgDistanceTotalizerRelUpReg::~vehicle_mainfi_tclMsgDistanceTotalizerRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgDistanceTotalizerGet::vehicle_mainfi_tclMsgDistanceTotalizerGet()
 {}

tS32 vehicle_mainfi_tclMsgDistanceTotalizerGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DISTANCETOTALIZERGET;
}


vehicle_mainfi_tclMsgDistanceTotalizerGet::~vehicle_mainfi_tclMsgDistanceTotalizerGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgDistanceTotalizerStatus::vehicle_mainfi_tclMsgDistanceTotalizerStatus(const vehicle_mainfi_tclMsgDistanceTotalizerStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   DisTotal = coRef.DisTotal;
   lastValidDisTotal = coRef.lastValidDisTotal;
   Unit = coRef.Unit;
   DisTotalStatus = coRef.DisTotalStatus;
}
vehicle_mainfi_tclMsgDistanceTotalizerStatus& vehicle_mainfi_tclMsgDistanceTotalizerStatus::operator=(const vehicle_mainfi_tclMsgDistanceTotalizerStatus& coRef)
{
   if (this == &coRef) return *this;
   DisTotal = coRef.DisTotal;
   lastValidDisTotal = coRef.lastValidDisTotal;
   Unit = coRef.Unit;
   DisTotalStatus = coRef.DisTotalStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgDistanceTotalizerStatus::vehicle_mainfi_tclMsgDistanceTotalizerStatus()
:DisTotal(0)
,lastValidDisTotal(0)
,Unit(0)
,DisTotalStatus(0)
 {}

tS32 vehicle_mainfi_tclMsgDistanceTotalizerStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_DISTANCETOTALIZERSTATUS;
}


vehicle_mainfi_tclMsgDistanceTotalizerStatus::~vehicle_mainfi_tclMsgDistanceTotalizerStatus()
{}

tU32 vehicle_mainfi_tclMsgDistanceTotalizerStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& vehicle_mainfi_tclMsgDistanceTotalizerStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DisTotal);
   (tVoid) (oIn >> lastValidDisTotal);
   (tVoid) (oIn >> Unit);
   (tVoid) (oIn >> DisTotalStatus);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgDistanceTotalizerStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DisTotal);
   (tVoid) (oOut << lastValidDisTotal);
   (tVoid) (oOut << Unit);
   (tVoid) (oOut << DisTotalStatus);
   return oOut;
}

tBool vehicle_mainfi_tclMsgDistanceTotalizerStatus::operator==(const vehicle_mainfi_tclMsgDistanceTotalizerStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DisTotal == roRef.DisTotal);
   bResult = bResult && (lastValidDisTotal == roRef.lastValidDisTotal);
   bResult = bResult && (Unit == roRef.Unit);
   bResult = bResult && (DisTotalStatus == roRef.DisTotalStatus);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgMileageUpReg::vehicle_mainfi_tclMsgMileageUpReg()
 {}

tS32 vehicle_mainfi_tclMsgMileageUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MILEAGEUPREG;
}


vehicle_mainfi_tclMsgMileageUpReg::~vehicle_mainfi_tclMsgMileageUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgMileageRelUpReg::vehicle_mainfi_tclMsgMileageRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgMileageRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MILEAGERELUPREG;
}


vehicle_mainfi_tclMsgMileageRelUpReg::~vehicle_mainfi_tclMsgMileageRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgMileageGet::vehicle_mainfi_tclMsgMileageGet()
 {}

tS32 vehicle_mainfi_tclMsgMileageGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MILEAGEGET;
}


vehicle_mainfi_tclMsgMileageGet::~vehicle_mainfi_tclMsgMileageGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgMileageStatus::vehicle_mainfi_tclMsgMileageStatus(const vehicle_mainfi_tclMsgMileageStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   Mileage = coRef.Mileage;
}
vehicle_mainfi_tclMsgMileageStatus& vehicle_mainfi_tclMsgMileageStatus::operator=(const vehicle_mainfi_tclMsgMileageStatus& coRef)
{
   if (this == &coRef) return *this;
   Mileage = coRef.Mileage;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgMileageStatus::vehicle_mainfi_tclMsgMileageStatus()
:Mileage(0)
 {}

tS32 vehicle_mainfi_tclMsgMileageStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_MILEAGESTATUS;
}


vehicle_mainfi_tclMsgMileageStatus::~vehicle_mainfi_tclMsgMileageStatus()
{}

tU32 vehicle_mainfi_tclMsgMileageStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& vehicle_mainfi_tclMsgMileageStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Mileage);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgMileageStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Mileage);
   return oOut;
}

tBool vehicle_mainfi_tclMsgMileageStatus::operator==(const vehicle_mainfi_tclMsgMileageStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Mileage == roRef.Mileage);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgAvgFuelEconomyUpReg::vehicle_mainfi_tclMsgAvgFuelEconomyUpReg()
 {}

tS32 vehicle_mainfi_tclMsgAvgFuelEconomyUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_AVGFUELECONOMYUPREG;
}


vehicle_mainfi_tclMsgAvgFuelEconomyUpReg::~vehicle_mainfi_tclMsgAvgFuelEconomyUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgAvgFuelEconomyRelUpReg::vehicle_mainfi_tclMsgAvgFuelEconomyRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgAvgFuelEconomyRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_AVGFUELECONOMYRELUPREG;
}


vehicle_mainfi_tclMsgAvgFuelEconomyRelUpReg::~vehicle_mainfi_tclMsgAvgFuelEconomyRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgAvgFuelEconomyGet::vehicle_mainfi_tclMsgAvgFuelEconomyGet()
 {}

tS32 vehicle_mainfi_tclMsgAvgFuelEconomyGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_AVGFUELECONOMYGET;
}


vehicle_mainfi_tclMsgAvgFuelEconomyGet::~vehicle_mainfi_tclMsgAvgFuelEconomyGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgAvgFuelEconomyStatus::vehicle_mainfi_tclMsgAvgFuelEconomyStatus(const vehicle_mainfi_tclMsgAvgFuelEconomyStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   FuelEcon = coRef.FuelEcon;
}
vehicle_mainfi_tclMsgAvgFuelEconomyStatus& vehicle_mainfi_tclMsgAvgFuelEconomyStatus::operator=(const vehicle_mainfi_tclMsgAvgFuelEconomyStatus& coRef)
{
   if (this == &coRef) return *this;
   FuelEcon = coRef.FuelEcon;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgAvgFuelEconomyStatus::vehicle_mainfi_tclMsgAvgFuelEconomyStatus()
:FuelEcon(0)
 {}

tS32 vehicle_mainfi_tclMsgAvgFuelEconomyStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_AVGFUELECONOMYSTATUS;
}


vehicle_mainfi_tclMsgAvgFuelEconomyStatus::~vehicle_mainfi_tclMsgAvgFuelEconomyStatus()
{}

tU32 vehicle_mainfi_tclMsgAvgFuelEconomyStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& vehicle_mainfi_tclMsgAvgFuelEconomyStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FuelEcon);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgAvgFuelEconomyStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FuelEcon);
   return oOut;
}

tBool vehicle_mainfi_tclMsgAvgFuelEconomyStatus::operator==(const vehicle_mainfi_tclMsgAvgFuelEconomyStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FuelEcon == roRef.FuelEcon);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgTirePressureSupportUpReg::vehicle_mainfi_tclMsgTirePressureSupportUpReg()
 {}

tS32 vehicle_mainfi_tclMsgTirePressureSupportUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TIREPRESSURESUPPORTUPREG;
}


vehicle_mainfi_tclMsgTirePressureSupportUpReg::~vehicle_mainfi_tclMsgTirePressureSupportUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgTirePressureSupportRelUpReg::vehicle_mainfi_tclMsgTirePressureSupportRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgTirePressureSupportRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TIREPRESSURESUPPORTRELUPREG;
}


vehicle_mainfi_tclMsgTirePressureSupportRelUpReg::~vehicle_mainfi_tclMsgTirePressureSupportRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgTirePressureSupportGet::vehicle_mainfi_tclMsgTirePressureSupportGet()
 {}

tS32 vehicle_mainfi_tclMsgTirePressureSupportGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TIREPRESSURESUPPORTGET;
}


vehicle_mainfi_tclMsgTirePressureSupportGet::~vehicle_mainfi_tclMsgTirePressureSupportGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgTirePressureSupportStatus::vehicle_mainfi_tclMsgTirePressureSupportStatus(const vehicle_mainfi_tclMsgTirePressureSupportStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   PressureSupport = coRef.PressureSupport;
}
vehicle_mainfi_tclMsgTirePressureSupportStatus& vehicle_mainfi_tclMsgTirePressureSupportStatus::operator=(const vehicle_mainfi_tclMsgTirePressureSupportStatus& coRef)
{
   if (this == &coRef) return *this;
   PressureSupport = coRef.PressureSupport;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgTirePressureSupportStatus::vehicle_mainfi_tclMsgTirePressureSupportStatus()
:PressureSupport(0)
 {}

tS32 vehicle_mainfi_tclMsgTirePressureSupportStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TIREPRESSURESUPPORTSTATUS;
}


vehicle_mainfi_tclMsgTirePressureSupportStatus::~vehicle_mainfi_tclMsgTirePressureSupportStatus()
{}

tU32 vehicle_mainfi_tclMsgTirePressureSupportStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgTirePressureSupportStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PressureSupport);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgTirePressureSupportStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PressureSupport);
   return oOut;
}

tBool vehicle_mainfi_tclMsgTirePressureSupportStatus::operator==(const vehicle_mainfi_tclMsgTirePressureSupportStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PressureSupport == roRef.PressureSupport);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgTPMSResetSupportUpReg::vehicle_mainfi_tclMsgTPMSResetSupportUpReg()
 {}

tS32 vehicle_mainfi_tclMsgTPMSResetSupportUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TPMSRESETSUPPORTUPREG;
}


vehicle_mainfi_tclMsgTPMSResetSupportUpReg::~vehicle_mainfi_tclMsgTPMSResetSupportUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgTPMSResetSupportRelUpReg::vehicle_mainfi_tclMsgTPMSResetSupportRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgTPMSResetSupportRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TPMSRESETSUPPORTRELUPREG;
}


vehicle_mainfi_tclMsgTPMSResetSupportRelUpReg::~vehicle_mainfi_tclMsgTPMSResetSupportRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgTPMSResetSupportGet::vehicle_mainfi_tclMsgTPMSResetSupportGet()
 {}

tS32 vehicle_mainfi_tclMsgTPMSResetSupportGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TPMSRESETSUPPORTGET;
}


vehicle_mainfi_tclMsgTPMSResetSupportGet::~vehicle_mainfi_tclMsgTPMSResetSupportGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgTPMSResetSupportStatus::vehicle_mainfi_tclMsgTPMSResetSupportStatus(const vehicle_mainfi_tclMsgTPMSResetSupportStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   TPMSResetInfo = coRef.TPMSResetInfo;
}
vehicle_mainfi_tclMsgTPMSResetSupportStatus& vehicle_mainfi_tclMsgTPMSResetSupportStatus::operator=(const vehicle_mainfi_tclMsgTPMSResetSupportStatus& coRef)
{
   if (this == &coRef) return *this;
   TPMSResetInfo = coRef.TPMSResetInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgTPMSResetSupportStatus::vehicle_mainfi_tclMsgTPMSResetSupportStatus()
:TPMSResetInfo()
 {}

tS32 vehicle_mainfi_tclMsgTPMSResetSupportStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TPMSRESETSUPPORTSTATUS;
}


vehicle_mainfi_tclMsgTPMSResetSupportStatus::~vehicle_mainfi_tclMsgTPMSResetSupportStatus()
{}

tU32 vehicle_mainfi_tclMsgTPMSResetSupportStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgTPMSResetSupportStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TPMSResetInfo);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgTPMSResetSupportStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TPMSResetInfo);
   return oOut;
}

tBool vehicle_mainfi_tclMsgTPMSResetSupportStatus::operator==(const vehicle_mainfi_tclMsgTPMSResetSupportStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TPMSResetInfo == roRef.TPMSResetInfo);
   return bResult;
}

//=============================================================================

vehicle_mainfi_tclMsgTirePressureSettingUpReg::vehicle_mainfi_tclMsgTirePressureSettingUpReg()
 {}

tS32 vehicle_mainfi_tclMsgTirePressureSettingUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TIREPRESSURESETTINGUPREG;
}


vehicle_mainfi_tclMsgTirePressureSettingUpReg::~vehicle_mainfi_tclMsgTirePressureSettingUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgTirePressureSettingRelUpReg::vehicle_mainfi_tclMsgTirePressureSettingRelUpReg()
 {}

tS32 vehicle_mainfi_tclMsgTirePressureSettingRelUpReg::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TIREPRESSURESETTINGRELUPREG;
}


vehicle_mainfi_tclMsgTirePressureSettingRelUpReg::~vehicle_mainfi_tclMsgTirePressureSettingRelUpReg()
{}

//=============================================================================

vehicle_mainfi_tclMsgTirePressureSettingGet::vehicle_mainfi_tclMsgTirePressureSettingGet()
 {}

tS32 vehicle_mainfi_tclMsgTirePressureSettingGet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TIREPRESSURESETTINGGET;
}


vehicle_mainfi_tclMsgTirePressureSettingGet::~vehicle_mainfi_tclMsgTirePressureSettingGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgTirePressureSettingSet::vehicle_mainfi_tclMsgTirePressureSettingSet(const vehicle_mainfi_tclMsgTirePressureSettingSet& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   TirePressureRequestInfo = coRef.TirePressureRequestInfo;
}
vehicle_mainfi_tclMsgTirePressureSettingSet& vehicle_mainfi_tclMsgTirePressureSettingSet::operator=(const vehicle_mainfi_tclMsgTirePressureSettingSet& coRef)
{
   if (this == &coRef) return *this;
   TirePressureRequestInfo = coRef.TirePressureRequestInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgTirePressureSettingSet::vehicle_mainfi_tclMsgTirePressureSettingSet()
:TirePressureRequestInfo()
 {}

tS32 vehicle_mainfi_tclMsgTirePressureSettingSet::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TIREPRESSURESETTINGSET;
}


vehicle_mainfi_tclMsgTirePressureSettingSet::~vehicle_mainfi_tclMsgTirePressureSettingSet()
{}

tU32 vehicle_mainfi_tclMsgTirePressureSettingSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_mainfi_tclMsgTirePressureSettingSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TirePressureRequestInfo);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgTirePressureSettingSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TirePressureRequestInfo);
   return oOut;
}

tBool vehicle_mainfi_tclMsgTirePressureSettingSet::operator==(const vehicle_mainfi_tclMsgTirePressureSettingSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TirePressureRequestInfo == roRef.TirePressureRequestInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_mainfi_tclMsgTirePressureSettingStatus::vehicle_mainfi_tclMsgTirePressureSettingStatus(const vehicle_mainfi_tclMsgTirePressureSettingStatus& coRef)
   : vehicle_mainfi_tclMsgBaseMessage(coRef)
{
   SettingPressureFront = coRef.SettingPressureFront;
   SettingPressureRear = coRef.SettingPressureRear;
}
vehicle_mainfi_tclMsgTirePressureSettingStatus& vehicle_mainfi_tclMsgTirePressureSettingStatus::operator=(const vehicle_mainfi_tclMsgTirePressureSettingStatus& coRef)
{
   if (this == &coRef) return *this;
   SettingPressureFront = coRef.SettingPressureFront;
   SettingPressureRear = coRef.SettingPressureRear;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_mainfi_tclMsgTirePressureSettingStatus::vehicle_mainfi_tclMsgTirePressureSettingStatus()
:SettingPressureFront(0)
,SettingPressureRear(0)
 {}

tS32 vehicle_mainfi_tclMsgTirePressureSettingStatus::s32GetTypeId() const
{
   return (tS32) vehicle_mainfi_tclToken::EN_MSG_TIREPRESSURESETTINGSTATUS;
}


vehicle_mainfi_tclMsgTirePressureSettingStatus::~vehicle_mainfi_tclMsgTirePressureSettingStatus()
{}

tU32 vehicle_mainfi_tclMsgTirePressureSettingStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& vehicle_mainfi_tclMsgTirePressureSettingStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SettingPressureFront);
   (tVoid) (oIn >> SettingPressureRear);
   return oIn;
}

fi_tclOutContext& vehicle_mainfi_tclMsgTirePressureSettingStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SettingPressureFront);
   (tVoid) (oOut << SettingPressureRear);
   return oOut;
}

tBool vehicle_mainfi_tclMsgTirePressureSettingStatus::operator==(const vehicle_mainfi_tclMsgTirePressureSettingStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SettingPressureFront == roRef.SettingPressureFront);
   bResult = bResult && (SettingPressureRear == roRef.SettingPressureRear);
   return bResult;
}

