/************************************************************************
 
 *FILE:           alltypes.cpp
 
 *SW-COMPONENT:   FI Functional Interface
 
 *DESCRIPTION:    Interface fuer alle Typdefinitionen
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#if !defined(FI_S_NO_STRING_ACCESS_METHODS) || !defined(FI_S_UTFMODE_TRANSPARENT)
   #define UTFUTIL_S_IMPORT_INTERFACE_GENERIC
   #include "utf_if.h"
#endif

#define VEHICLE_FI_S_IMPORT_INTERFACE_FI_TYPES
#include "vehicle_fi_if.h"
// -----------------------------------------------------------------------------

fi_tclOutContext& vehicle_fi_tclU8::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u8Value);
  return oOut;
}

fi_tclInContext& vehicle_fi_tclU8::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u8Value);
  return oIn;
}

tU32 vehicle_fi_tclU8::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& vehicle_fi_tclS8::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s8Value);
  return oOut;
}

fi_tclInContext& vehicle_fi_tclS8::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s8Value);
  return oIn;
}

tU32 vehicle_fi_tclS8::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& vehicle_fi_tclU16::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u16Value);
  return oOut;
}

fi_tclInContext& vehicle_fi_tclU16::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u16Value);
  return oIn;
}

tU32 vehicle_fi_tclU16::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& vehicle_fi_tclS16::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s16Value);
  return oOut;
}

fi_tclInContext& vehicle_fi_tclS16::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s16Value);
  return oIn;
}

tU32 vehicle_fi_tclS16::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& vehicle_fi_tclU24::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u24Value);
  return oOut;
}

fi_tclInContext& vehicle_fi_tclU24::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u24Value);
  return oIn;
}

tU32 vehicle_fi_tclU24::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& vehicle_fi_tclS24::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s24Value);
  return oOut;
}

fi_tclInContext& vehicle_fi_tclS24::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s24Value);
  return oIn;
}

tU32 vehicle_fi_tclS24::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& vehicle_fi_tclU32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u32Value);
  return oOut;
}

fi_tclInContext& vehicle_fi_tclU32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u32Value);
  return oIn;
}

tU32 vehicle_fi_tclU32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& vehicle_fi_tclU64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u64Value);
  return oOut;
}

fi_tclInContext& vehicle_fi_tclU64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u64Value);
  return oIn;
}

tU32 vehicle_fi_tclU64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& vehicle_fi_tclS32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s32Value);
  return oOut;
}

fi_tclInContext& vehicle_fi_tclS32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s32Value);
  return oIn;
}

tU32 vehicle_fi_tclS32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& vehicle_fi_tclS64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s64Value);
  return oOut;
}

fi_tclInContext& vehicle_fi_tclS64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s64Value);
  return oIn;
}

tU32 vehicle_fi_tclS64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& vehicle_fi_tclF32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(f32Value);
  return oOut;
}

fi_tclInContext& vehicle_fi_tclF32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(f32Value);
  return oIn;
}

tU32 vehicle_fi_tclF32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& vehicle_fi_tclF64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(f64Value);
  return oOut;
}

fi_tclInContext& vehicle_fi_tclF64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(f64Value);
  return oIn;
}

tU32 vehicle_fi_tclF64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
  return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& vehicle_fi_tclBool::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(bValue);
  return oOut;
}

fi_tclInContext& vehicle_fi_tclBool::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(bValue);
  return oIn;
}

tU32 vehicle_fi_tclBool::u32GetSize(tU16 /*u16MajorVersion*/) const
{
  return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& vehicle_fi_tclString::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(szValue);
  return oOut;
}

tVoid vehicle_fi_tclString::vDestroy() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_fi_tclString::~vehicle_fi_tclString() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

vehicle_fi_tclString& vehicle_fi_tclString::operator=(const vehicle_fi_tclString& coRef)
{
   if (this == &coRef) return *this;

   OSAL_DELETE[] szValue;
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
	  if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
   return *this;
}

vehicle_fi_tclString::vehicle_fi_tclString(const vehicle_fi_tclString& coRef):vehicle_fi_tclVisitableTypeBase(coRef)
{
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
}
#endif

fi_tclInContext& vehicle_fi_tclString::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(szValue);
  return oIn;
}

tBool vehicle_fi_tclString::operator==(const vehicle_fi_tclString& roRef) const
{
   if ((szValue == OSAL_NULL) || (roRef.szValue == OSAL_NULL))
   {
      if (szValue == roRef.szValue)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(roRef.szValue) == 0);
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,roRef.szValue));
   }
}

tU32 vehicle_fi_tclString::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return FI_u32StringLength(szValue) + 1;
}

#ifndef FI_DO_NOT_USE_TSTRING
vehicle_fi_tclString& vehicle_fi_tclString::operator=(tCString coszString) // ADDED
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      // nothing to convert, just copy (UTF-8) string into member field
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      OSAL_DELETE[] szValue;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
   return *this;
}

//fi_tclString::fi_tclString(const tString& coszString) // ADDED (changed from const tString to const tString&)
vehicle_fi_tclString::vehicle_fi_tclString(tCString coszString) // ADDED (changed from const tString& to tCString)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
}

tBool vehicle_fi_tclString::operator==(tCString coszString) const // ADDED
{
   if ((szValue == OSAL_NULL) || (coszString == OSAL_NULL))
   {
      if (szValue == coszString)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(coszString) == 0); //lint !e668 : same constellation as in other compare operator, which is ok for LINT
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,coszString));
   }
}

vehicle_fi_tclString::operator tString&() // ADDED
{
   return szValue;
}

vehicle_fi_tclString::operator const tChar* () const // ADDED
{
   return szValue;
}

tBool vehicle_fi_tclString::operator!=(intptr_t iNULL) const // ADDED
{
   return szValue != (char*)iNULL;
}

static tChar vehicle_FI_C_U8_NULLCHAR = '\0';

tChar* vehicle_fi_tclString::operator+(int iOffset) // ADDED
{
   if (szValue)
      return szValue + iOffset;
   else
      return OSAL_NULL;
}

tChar* vehicle_fi_tclString::operator+(tU8  u8Offset) // ADDED
{
   if (szValue)
      return szValue + u8Offset;
   else
      return OSAL_NULL;
}

tChar* vehicle_fi_tclString::operator+(tU32 u32Offset) // ADDED
{
   if (szValue)
      return szValue + u32Offset;
   else
      return OSAL_NULL;
}

tChar& vehicle_fi_tclString::operator[](tU16 u16Index) //ADDED
{
   if (szValue)
      return szValue[u16Index];
   else
      return vehicle_FI_C_U8_NULLCHAR;
}

tChar& vehicle_fi_tclString::operator[](tU32 u32Index) //ADDED
{
   if (szValue)
      return szValue[u32Index];
   else
      return vehicle_FI_C_U8_NULLCHAR;
}

tChar& vehicle_fi_tclString::operator[](tS32 s32Index) //ADDED
{
   if (szValue)
      return szValue[s32Index];
   else
      return vehicle_FI_C_U8_NULLCHAR;
}
#endif

#ifndef FI_S_NO_STRING_ACCESS_METHODS

tBool vehicle_fi_tclString::bSet(const vehicle_fi_tclString& corfoInit, tenCharSet enCharSet)
{
   return bSet(corfoInit.szValue, enCharSet);
}

//tBool figroup_fi_tclString::bSet(const tString& coszInit, tenCharSet enCharSet)
tBool vehicle_fi_tclString::bSet(tCString coszInit, tenCharSet enCharSet)
{
   tBool bSuccess = true;
   if (coszInit != OSAL_NULL)
   {
   switch (enCharSet)
   {
   case FI_EN_UTF8:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // nothing to convert, just copy UTF-8 string into member field
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#else
         // input is UTF8, FI assumes ISO-Mod internally, thus convert input
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
            0,
            0,
            coszInit,
            u32UTFStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            utfutil_u32ConvertUTF82ISOMod(
               szValue,
               u32ISOStringLength,
               coszInit,
               u32UTFStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_ISO8859_15M:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            utfutil_u32ConvertISOMod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
case FI_EN_ISO8859_1M :
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = util_u32ConvertISO8859_1Mod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            util_u32ConvertISO8859_1Mod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_UNDEFINED:
   default:
      bSuccess = false;
   }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
   return bSuccess;
}

tString vehicle_fi_tclString::szGet(tenCharSet enCharSet) const
{
   tString szRetVal = 0;
   if (OSAL_NULL != szValue)
   {
      switch (enCharSet)
      {
      case FI_EN_UTF8:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // nothing to convert, just copy internal member value
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#else
            // internal member is ISO-Mod, export as UTF8
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
               0,
               0,
               szValue,
               u32ISOStringLength
               );
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertISOMod2UTF8(
                  szRetVal,
                  u32UTFStringLength,
                  szValue,
                  u32ISOStringLength
                  );
            }
#endif
         } break;
      case FI_EN_ISO8859_15M:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // internal member is UTF8, export as ISO-Mod
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
               0,
               0,
               szValue,
               u32UTFStringLength
               );
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertUTF82ISOMod(
                  szRetVal,
                  u32ISOStringLength,
                  szValue,
                  u32UTFStringLength
                  );
            }
#else
            // nothing to convert, just copy internal member value
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#endif
         } break;
      case FI_EN_UNDEFINED:
      default:
         szRetVal = OSAL_NULL;
      }
   }
   return szRetVal;
}
#endif

// -----------------------------------------------------------------------------

fi_tclOutContext& vehicle_fi_tclList::oWrite(fi_tclOutContext& oOut) const 
{
   // --Schreibe die Listenlaenge in den Kontext
   (tVoid) oOut.oWrite(u32ListSize);
   return oOut;
}

fi_tclInContext& vehicle_fi_tclList::oRead(fi_tclInContext& oIn) 
{
  // --Lese die Listenlaenge aus dem Kontext
  (tVoid) oIn.oRead(u32ListSize);
  return oIn;
}

tBool vehicle_fi_tclList::operator==(const vehicle_fi_tclList& roRef) const
{
   return roRef.u32ListSize == u32ListSize;
}

tU32 vehicle_fi_tclList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& vehicle_fi_tclMultiLanguageString::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(szValue);
  return oOut;
}

tVoid vehicle_fi_tclMultiLanguageString::vDestroy() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_fi_tclMultiLanguageString::~vehicle_fi_tclMultiLanguageString() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

vehicle_fi_tclMultiLanguageString& vehicle_fi_tclMultiLanguageString::operator=(const vehicle_fi_tclMultiLanguageString& coRef)
{
   if (this == &coRef) return *this;

   OSAL_DELETE[] szValue;
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
	  if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
   return *this;
}

vehicle_fi_tclMultiLanguageString::vehicle_fi_tclMultiLanguageString(const vehicle_fi_tclMultiLanguageString& coRef):vehicle_fi_tclVisitableTypeBase(coRef)
{
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
}
#endif

fi_tclInContext& vehicle_fi_tclMultiLanguageString::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(szValue);
  return oIn;
}

tBool vehicle_fi_tclMultiLanguageString::operator==(const vehicle_fi_tclMultiLanguageString& roRef) const
{
   if ((szValue == OSAL_NULL) || (roRef.szValue == OSAL_NULL))
   {
      if (szValue == roRef.szValue)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(roRef.szValue) == 0);
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,roRef.szValue));
   }
}

tU32 vehicle_fi_tclMultiLanguageString::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return FI_u32StringLength(szValue) + 1;
}

#ifndef FI_DO_NOT_USE_TSTRING
vehicle_fi_tclMultiLanguageString& vehicle_fi_tclMultiLanguageString::operator=(tCString coszString) // ADDED
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      // nothing to convert, just copy (UTF-8) string into member field
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      OSAL_DELETE[] szValue;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
   return *this;
}

//fi_tclMultiLanguageString::fi_tclMultiLanguageString(const tString& coszString) // ADDED (changed from const tString to const tString&)
vehicle_fi_tclMultiLanguageString::vehicle_fi_tclMultiLanguageString(tCString coszString) // ADDED (changed from const tString& to tCString)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
}

tBool vehicle_fi_tclMultiLanguageString::operator==(tCString coszString) const // ADDED
{
   if ((szValue == OSAL_NULL) || (coszString == OSAL_NULL))
   {
      if (szValue == coszString)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(coszString) == 0); //lint !e668 : same constellation as in other compare operator, which is ok for LINT
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,coszString));
   }
}

vehicle_fi_tclMultiLanguageString::operator tString&() // ADDED
{
   return szValue;
}

vehicle_fi_tclMultiLanguageString::operator const tChar* () const // ADDED
{
   return szValue;
}

tBool vehicle_fi_tclMultiLanguageString::operator!=(intptr_t iNULL) const// ADDED
{
   return szValue != (char*)iNULL;
}

tChar* vehicle_fi_tclMultiLanguageString::operator+(int iOffset) // ADDED
{
   if (szValue)
      return szValue + iOffset;
   else
      return OSAL_NULL;
}

tChar* vehicle_fi_tclMultiLanguageString::operator+(tU8  u8Offset) // ADDED
{
   if (szValue)
      return szValue + u8Offset;
   else
      return OSAL_NULL;
}

tChar* vehicle_fi_tclMultiLanguageString::operator+(tU32 u32Offset) // ADDED
{
   if (szValue)
      return szValue + u32Offset;
   else
      return OSAL_NULL;
}

tChar& vehicle_fi_tclMultiLanguageString::operator[](tU16 u16Index) //ADDED
{
   if (szValue)
      return szValue[u16Index];
   else
      return vehicle_FI_C_U8_NULLCHAR;
}

tChar& vehicle_fi_tclMultiLanguageString::operator[](tU32 u32Index) //ADDED
{
   if (szValue)
      return szValue[u32Index];
   else
      return vehicle_FI_C_U8_NULLCHAR;
}

tChar& vehicle_fi_tclMultiLanguageString::operator[](tS32 s32Index) //ADDED
{
   if (szValue)
      return szValue[s32Index];
   else
      return vehicle_FI_C_U8_NULLCHAR;
}
#endif

#ifndef FI_S_NO_STRING_ACCESS_METHODS

tBool vehicle_fi_tclMultiLanguageString::bSet(const vehicle_fi_tclMultiLanguageString& corfoInit, tenCharSet enCharSet)
{
   return bSet(corfoInit.szValue, enCharSet);
}

//tBool figroup_fi_tclMultiLanguageString::bSet(const tString& coszInit, tenCharSet enCharSet)
tBool vehicle_fi_tclMultiLanguageString::bSet(tCString coszInit, tenCharSet enCharSet)
{
   tBool bSuccess = true;
   if (coszInit != OSAL_NULL)
   {
   switch (enCharSet)
   {
   case FI_EN_UTF8:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // nothing to convert, just copy UTF-8 string into member field
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#else
         // input is UTF8, FI assumes ISO-Mod internally, thus convert input
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
            0,
            0,
            coszInit,
            u32UTFStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            utfutil_u32ConvertUTF82ISOMod(
               szValue,
               u32ISOStringLength,
               coszInit,
               u32UTFStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_ISO8859_15M:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            utfutil_u32ConvertISOMod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_UNDEFINED:
   default:
      bSuccess = false;
   }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }

   return bSuccess;
}

tString vehicle_fi_tclMultiLanguageString::szGet(tenCharSet enCharSet) const
{
   tString szRetVal = 0;
   if (OSAL_NULL != szValue)
   {
      switch (enCharSet)
      {
      case FI_EN_UTF8:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // nothing to convert, just copy internal member value
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#else
            // internal member is ISO-Mod, export as UTF8
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
               0,
               0,
               szValue,
               u32ISOStringLength
               );
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertISOMod2UTF8(
                  szRetVal,
                  u32UTFStringLength,
                  szValue,
                  u32ISOStringLength
                  );
            }
#endif
         } break;
      case FI_EN_ISO8859_15M:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // internal member is UTF8, export as ISO-Mod
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
               0,
               0,
               szValue,
               u32UTFStringLength
               );
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertUTF82ISOMod(
                  szRetVal,
                  u32ISOStringLength,
                  szValue,
                  u32UTFStringLength
                  );
            }
#else
            // nothing to convert, just copy internal member value
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#endif
         } break;
      case FI_EN_UNDEFINED:
      default:
         szRetVal = OSAL_NULL;
      }
   }
   return szRetVal;
}
#endif

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_fi_tcl_BinContainer::vehicle_fi_tcl_BinContainer(const vehicle_fi_tcl_BinContainer& coRef)
   : vehicle_fi_tclVisitableTypeBase(coRef)
{
   ContainerDataList = coRef.ContainerDataList;
}
vehicle_fi_tcl_BinContainer& vehicle_fi_tcl_BinContainer::operator=(const vehicle_fi_tcl_BinContainer& coRef)
{
   if (this == &coRef) return *this;
   ContainerDataList = coRef.ContainerDataList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid vehicle_fi_tcl_BinContainer::vDestroy()
{
   {
   ContainerDataList.clear();
   }
}

vehicle_fi_tcl_BinContainer::vehicle_fi_tcl_BinContainer()

 {}

tS32 vehicle_fi_tcl_BinContainer::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_BINCONTAINER;
}


vehicle_fi_tcl_BinContainer::~vehicle_fi_tcl_BinContainer()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 vehicle_fi_tcl_BinContainer::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(ContainerDataList.size()*1);
}

fi_tclInContext& vehicle_fi_tcl_BinContainer::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ContainerDataList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ContainerDataList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& vehicle_fi_tcl_BinContainer::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ContainerDataList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ContainerDataList.size(); ++u32Idx)
         (tVoid) (oOut << ContainerDataList[u32Idx]);
   }
   return oOut;
}

tBool vehicle_fi_tcl_BinContainer::operator==(const vehicle_fi_tcl_BinContainer& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ContainerDataList.size() == roRef.ContainerDataList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ContainerDataList.size()); ++u32Idx)
            bResult = bResult && (ContainerDataList[u32Idx] == roRef.ContainerDataList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

vehicle_fi_tcl_Reserved::vehicle_fi_tcl_Reserved()
 {}

tS32 vehicle_fi_tcl_Reserved::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_RESERVED;
}


vehicle_fi_tcl_Reserved::~vehicle_fi_tcl_Reserved()
{}

tU32 vehicle_fi_tcl_Reserved::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

fi_tclInContext& vehicle_fi_tcl_Reserved::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& vehicle_fi_tcl_Reserved::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_u8_Percent::vehicle_fi_tcl_u8_Percent(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 vehicle_fi_tcl_u8_Percent::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_U8_PERCENT;
}


vehicle_fi_tcl_u8_Percent::~vehicle_fi_tcl_u8_Percent()
{}

tU32 vehicle_fi_tcl_u8_Percent::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_fi_tcl_u8_Percent::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& vehicle_fi_tcl_u8_Percent::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_s16_PerThousand::vehicle_fi_tcl_s16_PerThousand(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 vehicle_fi_tcl_s16_PerThousand::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_S16_PERTHOUSAND;
}


vehicle_fi_tcl_s16_PerThousand::~vehicle_fi_tcl_s16_PerThousand()
{}

tU32 vehicle_fi_tcl_s16_PerThousand::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& vehicle_fi_tcl_s16_PerThousand::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& vehicle_fi_tcl_s16_PerThousand::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_u16_IndexInReferenceList::vehicle_fi_tcl_u16_IndexInReferenceList(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 vehicle_fi_tcl_u16_IndexInReferenceList::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_U16_INDEXINREFERENCELIST;
}


vehicle_fi_tcl_u16_IndexInReferenceList::~vehicle_fi_tcl_u16_IndexInReferenceList()
{}

tU32 vehicle_fi_tcl_u16_IndexInReferenceList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& vehicle_fi_tcl_u16_IndexInReferenceList::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& vehicle_fi_tcl_u16_IndexInReferenceList::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_u16_ErrorCode::vehicle_fi_tcl_u16_ErrorCode(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 vehicle_fi_tcl_u16_ErrorCode::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_U16_ERRORCODE;
}


vehicle_fi_tcl_u16_ErrorCode::~vehicle_fi_tcl_u16_ErrorCode()
{}

tU32 vehicle_fi_tcl_u16_ErrorCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& vehicle_fi_tcl_u16_ErrorCode::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& vehicle_fi_tcl_u16_ErrorCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_u16_RPM::vehicle_fi_tcl_u16_RPM(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 vehicle_fi_tcl_u16_RPM::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_U16_RPM;
}


vehicle_fi_tcl_u16_RPM::~vehicle_fi_tcl_u16_RPM()
{}

tU32 vehicle_fi_tcl_u16_RPM::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& vehicle_fi_tcl_u16_RPM::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& vehicle_fi_tcl_u16_RPM::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_s32_Kilogram::vehicle_fi_tcl_s32_Kilogram(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 vehicle_fi_tcl_s32_Kilogram::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_S32_KILOGRAM;
}


vehicle_fi_tcl_s32_Kilogram::~vehicle_fi_tcl_s32_Kilogram()
{}

tU32 vehicle_fi_tcl_s32_Kilogram::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& vehicle_fi_tcl_s32_Kilogram::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& vehicle_fi_tcl_s32_Kilogram::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_s32_Pound::vehicle_fi_tcl_s32_Pound(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 vehicle_fi_tcl_s32_Pound::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_S32_POUND;
}


vehicle_fi_tcl_s32_Pound::~vehicle_fi_tcl_s32_Pound()
{}

tU32 vehicle_fi_tcl_s32_Pound::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& vehicle_fi_tcl_s32_Pound::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& vehicle_fi_tcl_s32_Pound::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_s16_Meter::vehicle_fi_tcl_s16_Meter(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 vehicle_fi_tcl_s16_Meter::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_S16_METER;
}


vehicle_fi_tcl_s16_Meter::~vehicle_fi_tcl_s16_Meter()
{}

tU32 vehicle_fi_tcl_s16_Meter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& vehicle_fi_tcl_s16_Meter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& vehicle_fi_tcl_s16_Meter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_s32_Meter::vehicle_fi_tcl_s32_Meter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 vehicle_fi_tcl_s32_Meter::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_S32_METER;
}


vehicle_fi_tcl_s32_Meter::~vehicle_fi_tcl_s32_Meter()
{}

tU32 vehicle_fi_tcl_s32_Meter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& vehicle_fi_tcl_s32_Meter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& vehicle_fi_tcl_s32_Meter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_s32_Yards::vehicle_fi_tcl_s32_Yards(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 vehicle_fi_tcl_s32_Yards::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_S32_YARDS;
}


vehicle_fi_tcl_s32_Yards::~vehicle_fi_tcl_s32_Yards()
{}

tU32 vehicle_fi_tcl_s32_Yards::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& vehicle_fi_tcl_s32_Yards::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& vehicle_fi_tcl_s32_Yards::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_s32_Foot::vehicle_fi_tcl_s32_Foot(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 vehicle_fi_tcl_s32_Foot::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_S32_FOOT;
}


vehicle_fi_tcl_s32_Foot::~vehicle_fi_tcl_s32_Foot()
{}

tU32 vehicle_fi_tcl_s32_Foot::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& vehicle_fi_tcl_s32_Foot::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& vehicle_fi_tcl_s32_Foot::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_s32_Centimeter::vehicle_fi_tcl_s32_Centimeter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 vehicle_fi_tcl_s32_Centimeter::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_S32_CENTIMETER;
}


vehicle_fi_tcl_s32_Centimeter::~vehicle_fi_tcl_s32_Centimeter()
{}

tU32 vehicle_fi_tcl_s32_Centimeter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& vehicle_fi_tcl_s32_Centimeter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& vehicle_fi_tcl_s32_Centimeter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_s32_Inch::vehicle_fi_tcl_s32_Inch(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 vehicle_fi_tcl_s32_Inch::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_S32_INCH;
}


vehicle_fi_tcl_s32_Inch::~vehicle_fi_tcl_s32_Inch()
{}

tU32 vehicle_fi_tcl_s32_Inch::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& vehicle_fi_tcl_s32_Inch::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& vehicle_fi_tcl_s32_Inch::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_s32_Millimeter::vehicle_fi_tcl_s32_Millimeter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 vehicle_fi_tcl_s32_Millimeter::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_S32_MILLIMETER;
}


vehicle_fi_tcl_s32_Millimeter::~vehicle_fi_tcl_s32_Millimeter()
{}

tU32 vehicle_fi_tcl_s32_Millimeter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& vehicle_fi_tcl_s32_Millimeter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& vehicle_fi_tcl_s32_Millimeter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_s32_Microliter::vehicle_fi_tcl_s32_Microliter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 vehicle_fi_tcl_s32_Microliter::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_S32_MICROLITER;
}


vehicle_fi_tcl_s32_Microliter::~vehicle_fi_tcl_s32_Microliter()
{}

tU32 vehicle_fi_tcl_s32_Microliter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& vehicle_fi_tcl_s32_Microliter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& vehicle_fi_tcl_s32_Microliter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_s32_Second::vehicle_fi_tcl_s32_Second(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 vehicle_fi_tcl_s32_Second::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_S32_SECOND;
}


vehicle_fi_tcl_s32_Second::~vehicle_fi_tcl_s32_Second()
{}

tU32 vehicle_fi_tcl_s32_Second::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& vehicle_fi_tcl_s32_Second::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& vehicle_fi_tcl_s32_Second::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_u16_MilliSecond::vehicle_fi_tcl_u16_MilliSecond(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 vehicle_fi_tcl_u16_MilliSecond::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_U16_MILLISECOND;
}


vehicle_fi_tcl_u16_MilliSecond::~vehicle_fi_tcl_u16_MilliSecond()
{}

tU32 vehicle_fi_tcl_u16_MilliSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& vehicle_fi_tcl_u16_MilliSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& vehicle_fi_tcl_u16_MilliSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_s32_MilliSecond::vehicle_fi_tcl_s32_MilliSecond(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 vehicle_fi_tcl_s32_MilliSecond::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_S32_MILLISECOND;
}


vehicle_fi_tcl_s32_MilliSecond::~vehicle_fi_tcl_s32_MilliSecond()
{}

tU32 vehicle_fi_tcl_s32_MilliSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& vehicle_fi_tcl_s32_MilliSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& vehicle_fi_tcl_s32_MilliSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_fi_tcl_POSIXTime::vehicle_fi_tcl_POSIXTime(const vehicle_fi_tcl_POSIXTime& coRef)
   : vehicle_fi_tclVisitableTypeBase(coRef)
{
   Time = coRef.Time;
}
vehicle_fi_tcl_POSIXTime& vehicle_fi_tcl_POSIXTime::operator=(const vehicle_fi_tcl_POSIXTime& coRef)
{
   if (this == &coRef) return *this;
   Time = coRef.Time;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_POSIXTime::vehicle_fi_tcl_POSIXTime()
:Time(0)
 {}

tS32 vehicle_fi_tcl_POSIXTime::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_POSIXTIME;
}


vehicle_fi_tcl_POSIXTime::~vehicle_fi_tcl_POSIXTime()
{}

tU32 vehicle_fi_tcl_POSIXTime::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& vehicle_fi_tcl_POSIXTime::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Time);
   return oIn;
}

fi_tclOutContext& vehicle_fi_tcl_POSIXTime::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Time);
   return oOut;
}

tBool vehicle_fi_tcl_POSIXTime::operator==(const vehicle_fi_tcl_POSIXTime& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Time == roRef.Time);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_e8_DST_State::vehicle_fi_tcl_e8_DST_State():enType(FI_EN_T_STANDARDTIME) {}

tS32 vehicle_fi_tcl_e8_DST_State::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_E8_DST_STATE;
}


vehicle_fi_tcl_e8_DST_State::~vehicle_fi_tcl_e8_DST_State()
{}

tU32 vehicle_fi_tcl_e8_DST_State::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_fi_tcl_e8_DST_State::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& vehicle_fi_tcl_e8_DST_State::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_fi_tcl_TimeZoneElement::vehicle_fi_tcl_TimeZoneElement(const vehicle_fi_tcl_TimeZoneElement& coRef)
   : vehicle_fi_tclVisitableTypeBase(coRef)
{
   Abbreviation_StandardTime = coRef.Abbreviation_StandardTime;
   Abbreviation_DST_in_effect = coRef.Abbreviation_DST_in_effect;
   TimeZoneDifference = coRef.TimeZoneDifference;
   DST_State = coRef.DST_State;
   DSTDifference = coRef.DSTDifference;
   DST_TimeDomain = coRef.DST_TimeDomain;
}
vehicle_fi_tcl_TimeZoneElement& vehicle_fi_tcl_TimeZoneElement::operator=(const vehicle_fi_tcl_TimeZoneElement& coRef)
{
   if (this == &coRef) return *this;
   Abbreviation_StandardTime = coRef.Abbreviation_StandardTime;
   Abbreviation_DST_in_effect = coRef.Abbreviation_DST_in_effect;
   TimeZoneDifference = coRef.TimeZoneDifference;
   DST_State = coRef.DST_State;
   DSTDifference = coRef.DSTDifference;
   DST_TimeDomain = coRef.DST_TimeDomain;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid vehicle_fi_tcl_TimeZoneElement::vDestroy()
{
   Abbreviation_StandardTime.vDestroy();
   Abbreviation_DST_in_effect.vDestroy();
   {
   DST_TimeDomain.clear();
   }
}

vehicle_fi_tcl_TimeZoneElement::vehicle_fi_tcl_TimeZoneElement()
:Abbreviation_StandardTime(0)
,Abbreviation_DST_in_effect(0)
,TimeZoneDifference()
,DST_State()
,DSTDifference()

 {}

tS32 vehicle_fi_tcl_TimeZoneElement::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_TIMEZONEELEMENT;
}


vehicle_fi_tcl_TimeZoneElement::~vehicle_fi_tcl_TimeZoneElement()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 vehicle_fi_tcl_TimeZoneElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 13+Abbreviation_StandardTime.u32GetSize(u16MajorVersion)+Abbreviation_DST_in_effect.u32GetSize(u16MajorVersion)+ static_cast<tU32>(DST_TimeDomain.size()*1);
}

fi_tclInContext& vehicle_fi_tcl_TimeZoneElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Abbreviation_StandardTime);
   (tVoid) (oIn >> Abbreviation_DST_in_effect);
   (tVoid) (oIn >> TimeZoneDifference);
   (tVoid) (oIn >> DST_State);
   (tVoid) (oIn >> DSTDifference);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      DST_TimeDomain.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DST_TimeDomain[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& vehicle_fi_tcl_TimeZoneElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Abbreviation_StandardTime);
   (tVoid) (oOut << Abbreviation_DST_in_effect);
   (tVoid) (oOut << TimeZoneDifference);
   (tVoid) (oOut << DST_State);
   (tVoid) (oOut << DSTDifference);
   (tVoid) (oOut << (tU32)DST_TimeDomain.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DST_TimeDomain.size(); ++u32Idx)
         (tVoid) (oOut << DST_TimeDomain[u32Idx]);
   }
   return oOut;
}

tBool vehicle_fi_tcl_TimeZoneElement::operator==(const vehicle_fi_tcl_TimeZoneElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Abbreviation_StandardTime == roRef.Abbreviation_StandardTime);
   bResult = bResult && (Abbreviation_DST_in_effect == roRef.Abbreviation_DST_in_effect);
   bResult = bResult && (TimeZoneDifference == roRef.TimeZoneDifference);
   bResult = bResult && (DST_State == roRef.DST_State);
   bResult = bResult && (DSTDifference == roRef.DSTDifference);
      bResult = bResult && (DST_TimeDomain.size() == roRef.DST_TimeDomain.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DST_TimeDomain.size()); ++u32Idx)
            bResult = bResult && (DST_TimeDomain[u32Idx] == roRef.DST_TimeDomain[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_s16_KmPerHour::vehicle_fi_tcl_s16_KmPerHour(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 vehicle_fi_tcl_s16_KmPerHour::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_S16_KMPERHOUR;
}


vehicle_fi_tcl_s16_KmPerHour::~vehicle_fi_tcl_s16_KmPerHour()
{}

tU32 vehicle_fi_tcl_s16_KmPerHour::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& vehicle_fi_tcl_s16_KmPerHour::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& vehicle_fi_tcl_s16_KmPerHour::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_s16_MilesPerHour::vehicle_fi_tcl_s16_MilesPerHour(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 vehicle_fi_tcl_s16_MilesPerHour::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_S16_MILESPERHOUR;
}


vehicle_fi_tcl_s16_MilesPerHour::~vehicle_fi_tcl_s16_MilesPerHour()
{}

tU32 vehicle_fi_tcl_s16_MilesPerHour::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& vehicle_fi_tcl_s16_MilesPerHour::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& vehicle_fi_tcl_s16_MilesPerHour::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_s16_Knot::vehicle_fi_tcl_s16_Knot(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 vehicle_fi_tcl_s16_Knot::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_S16_KNOT;
}


vehicle_fi_tcl_s16_Knot::~vehicle_fi_tcl_s16_Knot()
{}

tU32 vehicle_fi_tcl_s16_Knot::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& vehicle_fi_tcl_s16_Knot::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& vehicle_fi_tcl_s16_Knot::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_s16_CentimeterSecond::vehicle_fi_tcl_s16_CentimeterSecond(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 vehicle_fi_tcl_s16_CentimeterSecond::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_S16_CENTIMETERSECOND;
}


vehicle_fi_tcl_s16_CentimeterSecond::~vehicle_fi_tcl_s16_CentimeterSecond()
{}

tU32 vehicle_fi_tcl_s16_CentimeterSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& vehicle_fi_tcl_s16_CentimeterSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& vehicle_fi_tcl_s16_CentimeterSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_s16_Kelvin::vehicle_fi_tcl_s16_Kelvin(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 vehicle_fi_tcl_s16_Kelvin::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_S16_KELVIN;
}


vehicle_fi_tcl_s16_Kelvin::~vehicle_fi_tcl_s16_Kelvin()
{}

tU32 vehicle_fi_tcl_s16_Kelvin::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& vehicle_fi_tcl_s16_Kelvin::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& vehicle_fi_tcl_s16_Kelvin::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_s16_Fahrenheit::vehicle_fi_tcl_s16_Fahrenheit(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 vehicle_fi_tcl_s16_Fahrenheit::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_S16_FAHRENHEIT;
}


vehicle_fi_tcl_s16_Fahrenheit::~vehicle_fi_tcl_s16_Fahrenheit()
{}

tU32 vehicle_fi_tcl_s16_Fahrenheit::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& vehicle_fi_tcl_s16_Fahrenheit::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& vehicle_fi_tcl_s16_Fahrenheit::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_s32_Pascal::vehicle_fi_tcl_s32_Pascal(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 vehicle_fi_tcl_s32_Pascal::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_S32_PASCAL;
}


vehicle_fi_tcl_s32_Pascal::~vehicle_fi_tcl_s32_Pascal()
{}

tU32 vehicle_fi_tcl_s32_Pascal::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& vehicle_fi_tcl_s32_Pascal::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& vehicle_fi_tcl_s32_Pascal::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_s32_Watt::vehicle_fi_tcl_s32_Watt(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 vehicle_fi_tcl_s32_Watt::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_S32_WATT;
}


vehicle_fi_tcl_s32_Watt::~vehicle_fi_tcl_s32_Watt()
{}

tU32 vehicle_fi_tcl_s32_Watt::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& vehicle_fi_tcl_s32_Watt::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& vehicle_fi_tcl_s32_Watt::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_fi_tcl_FIVersion::vehicle_fi_tcl_FIVersion(const vehicle_fi_tcl_FIVersion& coRef)
   : vehicle_fi_tclVisitableTypeBase(coRef)
{
   MajorVersion = coRef.MajorVersion;
   MinorVersion = coRef.MinorVersion;
   PatchVersion = coRef.PatchVersion;
}
vehicle_fi_tcl_FIVersion& vehicle_fi_tcl_FIVersion::operator=(const vehicle_fi_tcl_FIVersion& coRef)
{
   if (this == &coRef) return *this;
   MajorVersion = coRef.MajorVersion;
   MinorVersion = coRef.MinorVersion;
   PatchVersion = coRef.PatchVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_FIVersion::vehicle_fi_tcl_FIVersion()
:MajorVersion(0)
,MinorVersion(0)
,PatchVersion(0)
 {}

tS32 vehicle_fi_tcl_FIVersion::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_FIVERSION;
}


vehicle_fi_tcl_FIVersion::~vehicle_fi_tcl_FIVersion()
{}

tU32 vehicle_fi_tcl_FIVersion::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& vehicle_fi_tcl_FIVersion::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MajorVersion);
   (tVoid) (oIn >> MinorVersion);
   (tVoid) (oIn >> PatchVersion);
   return oIn;
}

fi_tclOutContext& vehicle_fi_tcl_FIVersion::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MajorVersion);
   (tVoid) (oOut << MinorVersion);
   (tVoid) (oOut << PatchVersion);
   return oOut;
}

tBool vehicle_fi_tcl_FIVersion::operator==(const vehicle_fi_tcl_FIVersion& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MajorVersion == roRef.MajorVersion);
   bResult = bResult && (MinorVersion == roRef.MinorVersion);
   bResult = bResult && (PatchVersion == roRef.PatchVersion);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_s32_Longitude::vehicle_fi_tcl_s32_Longitude(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 vehicle_fi_tcl_s32_Longitude::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_S32_LONGITUDE;
}


vehicle_fi_tcl_s32_Longitude::~vehicle_fi_tcl_s32_Longitude()
{}

tU32 vehicle_fi_tcl_s32_Longitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& vehicle_fi_tcl_s32_Longitude::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& vehicle_fi_tcl_s32_Longitude::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_s32_Latitude::vehicle_fi_tcl_s32_Latitude(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 vehicle_fi_tcl_s32_Latitude::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_S32_LATITUDE;
}


vehicle_fi_tcl_s32_Latitude::~vehicle_fi_tcl_s32_Latitude()
{}

tU32 vehicle_fi_tcl_s32_Latitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& vehicle_fi_tcl_s32_Latitude::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& vehicle_fi_tcl_s32_Latitude::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_fi_tcl_PositionWGS84::vehicle_fi_tcl_PositionWGS84(const vehicle_fi_tcl_PositionWGS84& coRef)
   : vehicle_fi_tclVisitableTypeBase(coRef)
{
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
}
vehicle_fi_tcl_PositionWGS84& vehicle_fi_tcl_PositionWGS84::operator=(const vehicle_fi_tcl_PositionWGS84& coRef)
{
   if (this == &coRef) return *this;
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_PositionWGS84::vehicle_fi_tcl_PositionWGS84()
:Longitude()
,Latitude()
 {}

tS32 vehicle_fi_tcl_PositionWGS84::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_POSITIONWGS84;
}


vehicle_fi_tcl_PositionWGS84::~vehicle_fi_tcl_PositionWGS84()
{}

tU32 vehicle_fi_tcl_PositionWGS84::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& vehicle_fi_tcl_PositionWGS84::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Longitude);
   (tVoid) (oIn >> Latitude);
   return oIn;
}

fi_tclOutContext& vehicle_fi_tcl_PositionWGS84::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Longitude);
   (tVoid) (oOut << Latitude);
   return oOut;
}

tBool vehicle_fi_tcl_PositionWGS84::operator==(const vehicle_fi_tcl_PositionWGS84& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Longitude == roRef.Longitude);
   bResult = bResult && (Latitude == roRef.Latitude);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_fi_tcl_RectangleWGS84::vehicle_fi_tcl_RectangleWGS84(const vehicle_fi_tcl_RectangleWGS84& coRef)
   : vehicle_fi_tclVisitableTypeBase(coRef)
{
   LongitudeMin = coRef.LongitudeMin;
   LatitudeMin = coRef.LatitudeMin;
   LongitudeMax = coRef.LongitudeMax;
   LatitudeMax = coRef.LatitudeMax;
}
vehicle_fi_tcl_RectangleWGS84& vehicle_fi_tcl_RectangleWGS84::operator=(const vehicle_fi_tcl_RectangleWGS84& coRef)
{
   if (this == &coRef) return *this;
   LongitudeMin = coRef.LongitudeMin;
   LatitudeMin = coRef.LatitudeMin;
   LongitudeMax = coRef.LongitudeMax;
   LatitudeMax = coRef.LatitudeMax;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_RectangleWGS84::vehicle_fi_tcl_RectangleWGS84()
:LongitudeMin()
,LatitudeMin()
,LongitudeMax()
,LatitudeMax()
 {}

tS32 vehicle_fi_tcl_RectangleWGS84::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_RECTANGLEWGS84;
}


vehicle_fi_tcl_RectangleWGS84::~vehicle_fi_tcl_RectangleWGS84()
{}

tU32 vehicle_fi_tcl_RectangleWGS84::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

fi_tclInContext& vehicle_fi_tcl_RectangleWGS84::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LongitudeMin);
   (tVoid) (oIn >> LatitudeMin);
   (tVoid) (oIn >> LongitudeMax);
   (tVoid) (oIn >> LatitudeMax);
   return oIn;
}

fi_tclOutContext& vehicle_fi_tcl_RectangleWGS84::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LongitudeMin);
   (tVoid) (oOut << LatitudeMin);
   (tVoid) (oOut << LongitudeMax);
   (tVoid) (oOut << LatitudeMax);
   return oOut;
}

tBool vehicle_fi_tcl_RectangleWGS84::operator==(const vehicle_fi_tcl_RectangleWGS84& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LongitudeMin == roRef.LongitudeMin);
   bResult = bResult && (LatitudeMin == roRef.LatitudeMin);
   bResult = bResult && (LongitudeMax == roRef.LongitudeMax);
   bResult = bResult && (LatitudeMax == roRef.LatitudeMax);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_e16_ISOCountryCode::vehicle_fi_tcl_e16_ISOCountryCode():enType(FI_EN_ISO_ALPHA_3_UNDEFINED) {}

tS32 vehicle_fi_tcl_e16_ISOCountryCode::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_E16_ISOCOUNTRYCODE;
}


vehicle_fi_tcl_e16_ISOCountryCode::~vehicle_fi_tcl_e16_ISOCountryCode()
{}

tU32 vehicle_fi_tcl_e16_ISOCountryCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& vehicle_fi_tcl_e16_ISOCountryCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& vehicle_fi_tcl_e16_ISOCountryCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_e16_ISOLanguageCode::vehicle_fi_tcl_e16_ISOLanguageCode():enType(FI_EN_ISO_639_1_UNDEFINED) {}

tS32 vehicle_fi_tcl_e16_ISOLanguageCode::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_E16_ISOLANGUAGECODE;
}


vehicle_fi_tcl_e16_ISOLanguageCode::~vehicle_fi_tcl_e16_ISOLanguageCode()
{}

tU32 vehicle_fi_tcl_e16_ISOLanguageCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& vehicle_fi_tcl_e16_ISOLanguageCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& vehicle_fi_tcl_e16_ISOLanguageCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_fi_tcl_LanguageID::vehicle_fi_tcl_LanguageID(const vehicle_fi_tcl_LanguageID& coRef)
   : vehicle_fi_tclVisitableTypeBase(coRef)
{
   ISO639_LanguageCode = coRef.ISO639_LanguageCode;
   ISO3166_CountryCode = coRef.ISO3166_CountryCode;
}
vehicle_fi_tcl_LanguageID& vehicle_fi_tcl_LanguageID::operator=(const vehicle_fi_tcl_LanguageID& coRef)
{
   if (this == &coRef) return *this;
   ISO639_LanguageCode = coRef.ISO639_LanguageCode;
   ISO3166_CountryCode = coRef.ISO3166_CountryCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_LanguageID::vehicle_fi_tcl_LanguageID()
:ISO639_LanguageCode()
,ISO3166_CountryCode()
 {}

tS32 vehicle_fi_tcl_LanguageID::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_LANGUAGEID;
}


vehicle_fi_tcl_LanguageID::~vehicle_fi_tcl_LanguageID()
{}

tU32 vehicle_fi_tcl_LanguageID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& vehicle_fi_tcl_LanguageID::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ISO639_LanguageCode);
   (tVoid) (oIn >> ISO3166_CountryCode);
   return oIn;
}

fi_tclOutContext& vehicle_fi_tcl_LanguageID::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ISO639_LanguageCode);
   (tVoid) (oOut << ISO3166_CountryCode);
   return oOut;
}

tBool vehicle_fi_tcl_LanguageID::operator==(const vehicle_fi_tcl_LanguageID& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ISO639_LanguageCode == roRef.ISO639_LanguageCode);
   bResult = bResult && (ISO3166_CountryCode == roRef.ISO3166_CountryCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_u8_DirectionAbsolute::vehicle_fi_tcl_u8_DirectionAbsolute(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 vehicle_fi_tcl_u8_DirectionAbsolute::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_U8_DIRECTIONABSOLUTE;
}


vehicle_fi_tcl_u8_DirectionAbsolute::~vehicle_fi_tcl_u8_DirectionAbsolute()
{}

tU32 vehicle_fi_tcl_u8_DirectionAbsolute::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_fi_tcl_u8_DirectionAbsolute::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& vehicle_fi_tcl_u8_DirectionAbsolute::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_u8_DirectionRelative::vehicle_fi_tcl_u8_DirectionRelative(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 vehicle_fi_tcl_u8_DirectionRelative::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_U8_DIRECTIONRELATIVE;
}


vehicle_fi_tcl_u8_DirectionRelative::~vehicle_fi_tcl_u8_DirectionRelative()
{}

tU32 vehicle_fi_tcl_u8_DirectionRelative::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_fi_tcl_u8_DirectionRelative::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& vehicle_fi_tcl_u8_DirectionRelative::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_s16_CentiDegree::vehicle_fi_tcl_s16_CentiDegree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 vehicle_fi_tcl_s16_CentiDegree::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_S16_CENTIDEGREE;
}


vehicle_fi_tcl_s16_CentiDegree::~vehicle_fi_tcl_s16_CentiDegree()
{}

tU32 vehicle_fi_tcl_s16_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& vehicle_fi_tcl_s16_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& vehicle_fi_tcl_s16_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_s16_Degree::vehicle_fi_tcl_s16_Degree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 vehicle_fi_tcl_s16_Degree::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_S16_DEGREE;
}


vehicle_fi_tcl_s16_Degree::~vehicle_fi_tcl_s16_Degree()
{}

tU32 vehicle_fi_tcl_s16_Degree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& vehicle_fi_tcl_s16_Degree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& vehicle_fi_tcl_s16_Degree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_u16_DirectionAbsolute_CentiDegree::vehicle_fi_tcl_u16_DirectionAbsolute_CentiDegree(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 vehicle_fi_tcl_u16_DirectionAbsolute_CentiDegree::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_U16_DIRECTIONABSOLUTE_CENTIDEGREE;
}


vehicle_fi_tcl_u16_DirectionAbsolute_CentiDegree::~vehicle_fi_tcl_u16_DirectionAbsolute_CentiDegree()
{}

tU32 vehicle_fi_tcl_u16_DirectionAbsolute_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& vehicle_fi_tcl_u16_DirectionAbsolute_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& vehicle_fi_tcl_u16_DirectionAbsolute_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_s16_DirectionRelative_CentiDegree::vehicle_fi_tcl_s16_DirectionRelative_CentiDegree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 vehicle_fi_tcl_s16_DirectionRelative_CentiDegree::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_S16_DIRECTIONRELATIVE_CENTIDEGREE;
}


vehicle_fi_tcl_s16_DirectionRelative_CentiDegree::~vehicle_fi_tcl_s16_DirectionRelative_CentiDegree()
{}

tU32 vehicle_fi_tcl_s16_DirectionRelative_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& vehicle_fi_tcl_s16_DirectionRelative_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& vehicle_fi_tcl_s16_DirectionRelative_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_e8_FuelType::vehicle_fi_tcl_e8_FuelType():enType(FI_EN_RESERVED) {}

tS32 vehicle_fi_tcl_e8_FuelType::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_E8_FUELTYPE;
}


vehicle_fi_tcl_e8_FuelType::~vehicle_fi_tcl_e8_FuelType()
{}

tU32 vehicle_fi_tcl_e8_FuelType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_fi_tcl_e8_FuelType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& vehicle_fi_tcl_e8_FuelType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_fi_tcl_DistTimeFuel::vehicle_fi_tcl_DistTimeFuel(const vehicle_fi_tcl_DistTimeFuel& coRef)
   : vehicle_fi_tclVisitableTypeBase(coRef)
{
   Distance = coRef.Distance;
   Time = coRef.Time;
   Fuel = coRef.Fuel;
}
vehicle_fi_tcl_DistTimeFuel& vehicle_fi_tcl_DistTimeFuel::operator=(const vehicle_fi_tcl_DistTimeFuel& coRef)
{
   if (this == &coRef) return *this;
   Distance = coRef.Distance;
   Time = coRef.Time;
   Fuel = coRef.Fuel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_DistTimeFuel::vehicle_fi_tcl_DistTimeFuel()
:Distance()
,Time()
,Fuel()
 {}

tS32 vehicle_fi_tcl_DistTimeFuel::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_DISTTIMEFUEL;
}


vehicle_fi_tcl_DistTimeFuel::~vehicle_fi_tcl_DistTimeFuel()
{}

tU32 vehicle_fi_tcl_DistTimeFuel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& vehicle_fi_tcl_DistTimeFuel::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Distance);
   (tVoid) (oIn >> Time);
   (tVoid) (oIn >> Fuel);
   return oIn;
}

fi_tclOutContext& vehicle_fi_tcl_DistTimeFuel::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Distance);
   (tVoid) (oOut << Time);
   (tVoid) (oOut << Fuel);
   return oOut;
}

tBool vehicle_fi_tcl_DistTimeFuel::operator==(const vehicle_fi_tcl_DistTimeFuel& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Distance == roRef.Distance);
   bResult = bResult && (Time == roRef.Time);
   bResult = bResult && (Fuel == roRef.Fuel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_e8_Language_Code::vehicle_fi_tcl_e8_Language_Code():enType(FI_EN_UNKNOWN) {}

tS32 vehicle_fi_tcl_e8_Language_Code::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_E8_LANGUAGE_CODE;
}


vehicle_fi_tcl_e8_Language_Code::~vehicle_fi_tcl_e8_Language_Code()
{}

tU32 vehicle_fi_tcl_e8_Language_Code::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_fi_tcl_e8_Language_Code::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& vehicle_fi_tcl_e8_Language_Code::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_e8_Vehicle_DistanceUnit::vehicle_fi_tcl_e8_Vehicle_DistanceUnit():enType(FI_EN_UNKNOWN) {}

tS32 vehicle_fi_tcl_e8_Vehicle_DistanceUnit::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_E8_VEHICLE_DISTANCEUNIT;
}


vehicle_fi_tcl_e8_Vehicle_DistanceUnit::~vehicle_fi_tcl_e8_Vehicle_DistanceUnit()
{}

tU32 vehicle_fi_tcl_e8_Vehicle_DistanceUnit::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_fi_tcl_e8_Vehicle_DistanceUnit::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& vehicle_fi_tcl_e8_Vehicle_DistanceUnit::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit::vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit():enType(FI_EN_UNKNOWN) {}

tS32 vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_E8_VEHICLE_FUELCONSUMPTIONUNIT;
}


vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit::~vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit()
{}

tU32 vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_e8_Vehicle_TemperatureUnit::vehicle_fi_tcl_e8_Vehicle_TemperatureUnit():enType(FI_EN_UNKNOWN) {}

tS32 vehicle_fi_tcl_e8_Vehicle_TemperatureUnit::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_E8_VEHICLE_TEMPERATUREUNIT;
}


vehicle_fi_tcl_e8_Vehicle_TemperatureUnit::~vehicle_fi_tcl_e8_Vehicle_TemperatureUnit()
{}

tU32 vehicle_fi_tcl_e8_Vehicle_TemperatureUnit::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_fi_tcl_e8_Vehicle_TemperatureUnit::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& vehicle_fi_tcl_e8_Vehicle_TemperatureUnit::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_e8_Vehicle_HandBrakeStatus::vehicle_fi_tcl_e8_Vehicle_HandBrakeStatus():enType(FI_EN_UNKNOWN) {}

tS32 vehicle_fi_tcl_e8_Vehicle_HandBrakeStatus::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_E8_VEHICLE_HANDBRAKESTATUS;
}


vehicle_fi_tcl_e8_Vehicle_HandBrakeStatus::~vehicle_fi_tcl_e8_Vehicle_HandBrakeStatus()
{}

tU32 vehicle_fi_tcl_e8_Vehicle_HandBrakeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_fi_tcl_e8_Vehicle_HandBrakeStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& vehicle_fi_tcl_e8_Vehicle_HandBrakeStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_e8_Vehicle_Ignition::vehicle_fi_tcl_e8_Vehicle_Ignition():enType(FI_EN_UNKNOWN) {}

tS32 vehicle_fi_tcl_e8_Vehicle_Ignition::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_E8_VEHICLE_IGNITION;
}


vehicle_fi_tcl_e8_Vehicle_Ignition::~vehicle_fi_tcl_e8_Vehicle_Ignition()
{}

tU32 vehicle_fi_tcl_e8_Vehicle_Ignition::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_fi_tcl_e8_Vehicle_Ignition::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& vehicle_fi_tcl_e8_Vehicle_Ignition::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_e8_Language_SourceId::vehicle_fi_tcl_e8_Language_SourceId():enType(FI_EN_HMI) {}

tS32 vehicle_fi_tcl_e8_Language_SourceId::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_E8_LANGUAGE_SOURCEID;
}


vehicle_fi_tcl_e8_Language_SourceId::~vehicle_fi_tcl_e8_Language_SourceId()
{}

tU32 vehicle_fi_tcl_e8_Language_SourceId::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_fi_tcl_e8_Language_SourceId::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& vehicle_fi_tcl_e8_Language_SourceId::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_fi_tcl_Language_SourceTable::vehicle_fi_tcl_Language_SourceTable(const vehicle_fi_tcl_Language_SourceTable& coRef)
   : vehicle_fi_tclVisitableTypeBase(coRef)
{
   enLangSrcId = coRef.enLangSrcId;
   enLanguage = coRef.enLanguage;
   bHasChanged = coRef.bHasChanged;
}
vehicle_fi_tcl_Language_SourceTable& vehicle_fi_tcl_Language_SourceTable::operator=(const vehicle_fi_tcl_Language_SourceTable& coRef)
{
   if (this == &coRef) return *this;
   enLangSrcId = coRef.enLangSrcId;
   enLanguage = coRef.enLanguage;
   bHasChanged = coRef.bHasChanged;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_Language_SourceTable::vehicle_fi_tcl_Language_SourceTable()
:enLangSrcId()
,enLanguage()
,bHasChanged(0)
 {}

tS32 vehicle_fi_tcl_Language_SourceTable::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_LANGUAGE_SOURCETABLE;
}


vehicle_fi_tcl_Language_SourceTable::~vehicle_fi_tcl_Language_SourceTable()
{}

tU32 vehicle_fi_tcl_Language_SourceTable::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& vehicle_fi_tcl_Language_SourceTable::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enLangSrcId);
   (tVoid) (oIn >> enLanguage);
   (tVoid) (oIn >> bHasChanged);
   return oIn;
}

fi_tclOutContext& vehicle_fi_tcl_Language_SourceTable::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enLangSrcId);
   (tVoid) (oOut << enLanguage);
   (tVoid) (oOut << bHasChanged);
   return oOut;
}

tBool vehicle_fi_tcl_Language_SourceTable::operator==(const vehicle_fi_tcl_Language_SourceTable& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enLangSrcId == roRef.enLangSrcId);
   bResult = bResult && (enLanguage == roRef.enLanguage);
   bResult = bResult && (bHasChanged == roRef.bHasChanged);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_e8_Meter_SyncRequest::vehicle_fi_tcl_e8_Meter_SyncRequest():enType(FI_EN_NO_REQUEST) {}

tS32 vehicle_fi_tcl_e8_Meter_SyncRequest::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_E8_METER_SYNCREQUEST;
}


vehicle_fi_tcl_e8_Meter_SyncRequest::~vehicle_fi_tcl_e8_Meter_SyncRequest()
{}

tU32 vehicle_fi_tcl_e8_Meter_SyncRequest::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_fi_tcl_e8_Meter_SyncRequest::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& vehicle_fi_tcl_e8_Meter_SyncRequest::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_e8_Meter_LangKnowledge::vehicle_fi_tcl_e8_Meter_LangKnowledge():enType(FI_EN_NO_REQUEST) {}

tS32 vehicle_fi_tcl_e8_Meter_LangKnowledge::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_E8_METER_LANGKNOWLEDGE;
}


vehicle_fi_tcl_e8_Meter_LangKnowledge::~vehicle_fi_tcl_e8_Meter_LangKnowledge()
{}

tU32 vehicle_fi_tcl_e8_Meter_LangKnowledge::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_fi_tcl_e8_Meter_LangKnowledge::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& vehicle_fi_tcl_e8_Meter_LangKnowledge::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_e8_Vehicle_TPMSReset::vehicle_fi_tcl_e8_Vehicle_TPMSReset():enType(FI_EN_NOT_SUPPORT_THIS_FUNCTION) {}

tS32 vehicle_fi_tcl_e8_Vehicle_TPMSReset::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_E8_VEHICLE_TPMSRESET;
}


vehicle_fi_tcl_e8_Vehicle_TPMSReset::~vehicle_fi_tcl_e8_Vehicle_TPMSReset()
{}

tU32 vehicle_fi_tcl_e8_Vehicle_TPMSReset::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_fi_tcl_e8_Vehicle_TPMSReset::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& vehicle_fi_tcl_e8_Vehicle_TPMSReset::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_e8_Vehicle_TirePressureInfo::vehicle_fi_tcl_e8_Vehicle_TirePressureInfo():enType(FI_EN_NO_REQUEST) {}

tS32 vehicle_fi_tcl_e8_Vehicle_TirePressureInfo::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_E8_VEHICLE_TIREPRESSUREINFO;
}


vehicle_fi_tcl_e8_Vehicle_TirePressureInfo::~vehicle_fi_tcl_e8_Vehicle_TirePressureInfo()
{}

tU32 vehicle_fi_tcl_e8_Vehicle_TirePressureInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_fi_tcl_e8_Vehicle_TirePressureInfo::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& vehicle_fi_tcl_e8_Vehicle_TirePressureInfo::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_e8_Vehicle_WarningState::vehicle_fi_tcl_e8_Vehicle_WarningState():enType(FI_EN_NO_GLOBAL_VEHICLE_FAULT) {}

tS32 vehicle_fi_tcl_e8_Vehicle_WarningState::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_E8_VEHICLE_WARNINGSTATE;
}


vehicle_fi_tcl_e8_Vehicle_WarningState::~vehicle_fi_tcl_e8_Vehicle_WarningState()
{}

tU32 vehicle_fi_tcl_e8_Vehicle_WarningState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_fi_tcl_e8_Vehicle_WarningState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& vehicle_fi_tcl_e8_Vehicle_WarningState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

vehicle_fi_tcl_e8_Vehicle_States::vehicle_fi_tcl_e8_Vehicle_States():enType(FI_EN_SLEEPING) {}

tS32 vehicle_fi_tcl_e8_Vehicle_States::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_E8_VEHICLE_STATES;
}


vehicle_fi_tcl_e8_Vehicle_States::~vehicle_fi_tcl_e8_Vehicle_States()
{}

tU32 vehicle_fi_tcl_e8_Vehicle_States::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& vehicle_fi_tcl_e8_Vehicle_States::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& vehicle_fi_tcl_e8_Vehicle_States::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_fi_tcl_CAN_Message::vehicle_fi_tcl_CAN_Message(const vehicle_fi_tcl_CAN_Message& coRef)
   : vehicle_fi_tclVisitableTypeBase(coRef)
{
   u32MessageStatus = coRef.u32MessageStatus;
   u32MessageId = coRef.u32MessageId;
   listData = coRef.listData;
}
vehicle_fi_tcl_CAN_Message& vehicle_fi_tcl_CAN_Message::operator=(const vehicle_fi_tcl_CAN_Message& coRef)
{
   if (this == &coRef) return *this;
   u32MessageStatus = coRef.u32MessageStatus;
   u32MessageId = coRef.u32MessageId;
   listData = coRef.listData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid vehicle_fi_tcl_CAN_Message::vDestroy()
{
   {
   listData.clear();
   }
}

vehicle_fi_tcl_CAN_Message::vehicle_fi_tcl_CAN_Message()
:u32MessageStatus(0)
,u32MessageId(0)

 {}

tS32 vehicle_fi_tcl_CAN_Message::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_CAN_MESSAGE;
}


vehicle_fi_tcl_CAN_Message::~vehicle_fi_tcl_CAN_Message()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 vehicle_fi_tcl_CAN_Message::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12+ static_cast<tU32>(listData.size()*1);
}

fi_tclInContext& vehicle_fi_tcl_CAN_Message::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32MessageStatus);
   (tVoid) (oIn >> u32MessageId);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      listData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> listData[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& vehicle_fi_tcl_CAN_Message::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32MessageStatus);
   (tVoid) (oOut << u32MessageId);
   (tVoid) (oOut << (tU32)listData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < listData.size(); ++u32Idx)
         (tVoid) (oOut << listData[u32Idx]);
   }
   return oOut;
}

tBool vehicle_fi_tcl_CAN_Message::operator==(const vehicle_fi_tcl_CAN_Message& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32MessageStatus == roRef.u32MessageStatus);
   bResult = bResult && (u32MessageId == roRef.u32MessageId);
      bResult = bResult && (listData.size() == roRef.listData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < listData.size()); ++u32Idx)
            bResult = bResult && (listData[u32Idx] == roRef.listData[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_fi_tcl_CAN_Mesg::vehicle_fi_tcl_CAN_Mesg(const vehicle_fi_tcl_CAN_Mesg& coRef)
   : vehicle_fi_tclVisitableTypeBase(coRef)
{
   u8MediaType = coRef.u8MediaType;
   listData = coRef.listData;
}
vehicle_fi_tcl_CAN_Mesg& vehicle_fi_tcl_CAN_Mesg::operator=(const vehicle_fi_tcl_CAN_Mesg& coRef)
{
   if (this == &coRef) return *this;
   u8MediaType = coRef.u8MediaType;
   listData = coRef.listData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid vehicle_fi_tcl_CAN_Mesg::vDestroy()
{
   {
   listData.clear();
   }
}

vehicle_fi_tcl_CAN_Mesg::vehicle_fi_tcl_CAN_Mesg()
:u8MediaType(0)

 {}

tS32 vehicle_fi_tcl_CAN_Mesg::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_CAN_MESG;
}


vehicle_fi_tcl_CAN_Mesg::~vehicle_fi_tcl_CAN_Mesg()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 vehicle_fi_tcl_CAN_Mesg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+ static_cast<tU32>(listData.size()*1);
}

fi_tclInContext& vehicle_fi_tcl_CAN_Mesg::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8MediaType);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      listData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> listData[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& vehicle_fi_tcl_CAN_Mesg::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8MediaType);
   (tVoid) (oOut << (tU32)listData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < listData.size(); ++u32Idx)
         (tVoid) (oOut << listData[u32Idx]);
   }
   return oOut;
}

tBool vehicle_fi_tcl_CAN_Mesg::operator==(const vehicle_fi_tcl_CAN_Mesg& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8MediaType == roRef.u8MediaType);
      bResult = bResult && (listData.size() == roRef.listData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < listData.size()); ++u32Idx)
            bResult = bResult && (listData[u32Idx] == roRef.listData[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
vehicle_fi_tcl_CAN_Navi_Mesg::vehicle_fi_tcl_CAN_Navi_Mesg(const vehicle_fi_tcl_CAN_Navi_Mesg& coRef)
   : vehicle_fi_tclVisitableTypeBase(coRef)
{
   listData = coRef.listData;
}
vehicle_fi_tcl_CAN_Navi_Mesg& vehicle_fi_tcl_CAN_Navi_Mesg::operator=(const vehicle_fi_tcl_CAN_Navi_Mesg& coRef)
{
   if (this == &coRef) return *this;
   listData = coRef.listData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid vehicle_fi_tcl_CAN_Navi_Mesg::vDestroy()
{
   {
   listData.clear();
   }
}

vehicle_fi_tcl_CAN_Navi_Mesg::vehicle_fi_tcl_CAN_Navi_Mesg()

 {}

tS32 vehicle_fi_tcl_CAN_Navi_Mesg::s32GetTypeId() const
{
   return (tS32) vehicle_typesfi_tclToken::EN_CAN_NAVI_MESG;
}


vehicle_fi_tcl_CAN_Navi_Mesg::~vehicle_fi_tcl_CAN_Navi_Mesg()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 vehicle_fi_tcl_CAN_Navi_Mesg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(listData.size()*1);
}

fi_tclInContext& vehicle_fi_tcl_CAN_Navi_Mesg::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      listData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> listData[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& vehicle_fi_tcl_CAN_Navi_Mesg::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)listData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < listData.size(); ++u32Idx)
         (tVoid) (oOut << listData[u32Idx]);
   }
   return oOut;
}

tBool vehicle_fi_tcl_CAN_Navi_Mesg::operator==(const vehicle_fi_tcl_CAN_Navi_Mesg& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (listData.size() == roRef.listData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < listData.size()); ++u32Idx)
            bResult = bResult && (listData[u32Idx] == roRef.listData[u32Idx]);
      }
   return bResult;
}

