#ifndef VEHICLE_FIVISITOR_HEADER
#define VEHICLE_FIVISITOR_HEADER

// --Basisklasse fuer eine FI-Besucher-Klasse

class vehicle_fi_tclOutput {
public:
   vehicle_fi_tclOutput();
   virtual ~vehicle_fi_tclOutput(){};

   virtual tVoid vPrintLine(tCString coszLine) = 0;
};

class vehicle_fi_tclFileOutput : public vehicle_fi_tclOutput 
{
public:
   vehicle_fi_tclFileOutput(OSAL_tIODescriptor rIOD):fd(rIOD) {}
   virtual tVoid vPrintLine(tCString coszLine);
protected:
   OSAL_tIODescriptor fd;
private:
   vehicle_fi_tclFileOutput(); //lint !e1704
   vehicle_fi_tclFileOutput& operator=(const vehicle_fi_tclFileOutput& coRef);
   vehicle_fi_tclFileOutput(const vehicle_fi_tclFileOutput& coRef); //lint !e1704
};

class vehicle_fi_tclMemOutput : public vehicle_fi_tclOutput
{
public:
   vehicle_fi_tclMemOutput(tU32 u32MemSize);
   virtual ~vehicle_fi_tclMemOutput();
   virtual tVoid vPrintLine(tCString coszLine);
   tString szGetBuffer();
protected:
   tChar* szBuf;
   tChar* szEndBuf;
   tChar* s8BufPos;
private:
   vehicle_fi_tclMemOutput(); //lint !e1704
   vehicle_fi_tclMemOutput(const vehicle_fi_tclMemOutput& coRef); //lint !e1704
   vehicle_fi_tclMemOutput& operator=(const vehicle_fi_tclMemOutput& coRef); //lint !e1704
};

class MY_DECL vehicle_fi_tclVisitorBase {
public:

   // --Konstruktor
   vehicle_fi_tclVisitorBase():bBreakNow(FALSE),bIsVisitorValid(FALSE) {}
   virtual ~vehicle_fi_tclVisitorBase() {}

   tBool bIsValid() const { return bIsVisitorValid; }
   tVoid vInvalidate() { bIsVisitorValid=FALSE; }
   tVoid vValidate() { bIsVisitorValid=TRUE; }
   tBool bBreak() const { return bBreakNow; }
   tVoid vReleaseBreak() { bBreakNow = FALSE; }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(vehicle_fi_tclU8& oU8);
   virtual tVoid vVisitS8(vehicle_fi_tclS8& oS8);
   virtual tVoid vVisitU16(vehicle_fi_tclU16& oU16);
   virtual tVoid vVisitS16(vehicle_fi_tclS16& oS16);
   virtual tVoid vVisitU24(vehicle_fi_tclU24& oU24);
   virtual tVoid vVisitS24(vehicle_fi_tclS24& oS24);
   virtual tVoid vVisitU32(vehicle_fi_tclU32& oU32);
   virtual tVoid vVisitS32(vehicle_fi_tclS32& oS32);
   virtual tVoid vVisitU64(vehicle_fi_tclU64& oU64);
   virtual tVoid vVisitS64(vehicle_fi_tclS64& oS64);
   virtual tVoid vVisitF32(vehicle_fi_tclF32& oF32);
   virtual tVoid vVisitF64(vehicle_fi_tclF64& oF64);
   virtual tVoid vVisitBool(vehicle_fi_tclBool& oBool);
   virtual tVoid vVisitString(vehicle_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(vehicle_fi_tclMultiLanguageString& oString);

   virtual tVoid vVisitList(vehicle_fi_tclList& oList);
   virtual tVoid vVisit_BinContainer(vehicle_fi_tcl_BinContainer& oBinContainer);

   virtual tVoid vVisit_Reserved(vehicle_fi_tcl_Reserved& oReserved);

   virtual tVoid vVisit_u8_Percent(vehicle_fi_tcl_u8_Percent& ou8_Percent);

   virtual tVoid vVisit_s16_PerThousand(vehicle_fi_tcl_s16_PerThousand& os16_PerThousand);

   virtual tVoid vVisit_u16_IndexInReferenceList(vehicle_fi_tcl_u16_IndexInReferenceList& ou16_IndexInReferenceList);

   virtual tVoid vVisit_u16_ErrorCode(vehicle_fi_tcl_u16_ErrorCode& ou16_ErrorCode);

   virtual tVoid vVisit_u16_RPM(vehicle_fi_tcl_u16_RPM& ou16_RPM);

   virtual tVoid vVisit_s32_Kilogram(vehicle_fi_tcl_s32_Kilogram& os32_Kilogram);

   virtual tVoid vVisit_s32_Pound(vehicle_fi_tcl_s32_Pound& os32_Pound);

   virtual tVoid vVisit_s16_Meter(vehicle_fi_tcl_s16_Meter& os16_Meter);

   virtual tVoid vVisit_s32_Meter(vehicle_fi_tcl_s32_Meter& os32_Meter);

   virtual tVoid vVisit_s32_Yards(vehicle_fi_tcl_s32_Yards& os32_Yards);

   virtual tVoid vVisit_s32_Foot(vehicle_fi_tcl_s32_Foot& os32_Foot);

   virtual tVoid vVisit_s32_Centimeter(vehicle_fi_tcl_s32_Centimeter& os32_Centimeter);

   virtual tVoid vVisit_s32_Inch(vehicle_fi_tcl_s32_Inch& os32_Inch);

   virtual tVoid vVisit_s32_Millimeter(vehicle_fi_tcl_s32_Millimeter& os32_Millimeter);

   virtual tVoid vVisit_s32_Microliter(vehicle_fi_tcl_s32_Microliter& os32_Microliter);

   virtual tVoid vVisit_s32_Second(vehicle_fi_tcl_s32_Second& os32_Second);

   virtual tVoid vVisit_u16_MilliSecond(vehicle_fi_tcl_u16_MilliSecond& ou16_MilliSecond);

   virtual tVoid vVisit_s32_MilliSecond(vehicle_fi_tcl_s32_MilliSecond& os32_MilliSecond);

   virtual tVoid vVisit_POSIXTime(vehicle_fi_tcl_POSIXTime& oPOSIXTime);

   virtual tVoid vVisit_e8_DST_State(vehicle_fi_tcl_e8_DST_State& oe8_DST_State);

   virtual tVoid vVisit_TimeZoneElement(vehicle_fi_tcl_TimeZoneElement& oTimeZoneElement);

   virtual tVoid vVisit_s16_KmPerHour(vehicle_fi_tcl_s16_KmPerHour& os16_KmPerHour);

   virtual tVoid vVisit_s16_MilesPerHour(vehicle_fi_tcl_s16_MilesPerHour& os16_MilesPerHour);

   virtual tVoid vVisit_s16_Knot(vehicle_fi_tcl_s16_Knot& os16_Knot);

   virtual tVoid vVisit_s16_CentimeterSecond(vehicle_fi_tcl_s16_CentimeterSecond& os16_CentimeterSecond);

   virtual tVoid vVisit_s16_Kelvin(vehicle_fi_tcl_s16_Kelvin& os16_Kelvin);

   virtual tVoid vVisit_s16_Fahrenheit(vehicle_fi_tcl_s16_Fahrenheit& os16_Fahrenheit);

   virtual tVoid vVisit_s32_Pascal(vehicle_fi_tcl_s32_Pascal& os32_Pascal);

   virtual tVoid vVisit_s32_Watt(vehicle_fi_tcl_s32_Watt& os32_Watt);

   virtual tVoid vVisit_FIVersion(vehicle_fi_tcl_FIVersion& oFIVersion);

   virtual tVoid vVisit_s32_Longitude(vehicle_fi_tcl_s32_Longitude& os32_Longitude);

   virtual tVoid vVisit_s32_Latitude(vehicle_fi_tcl_s32_Latitude& os32_Latitude);

   virtual tVoid vVisit_PositionWGS84(vehicle_fi_tcl_PositionWGS84& oPositionWGS84);

   virtual tVoid vVisit_RectangleWGS84(vehicle_fi_tcl_RectangleWGS84& oRectangleWGS84);

   virtual tVoid vVisit_e16_ISOCountryCode(vehicle_fi_tcl_e16_ISOCountryCode& oe16_ISOCountryCode);

   virtual tVoid vVisit_e16_ISOLanguageCode(vehicle_fi_tcl_e16_ISOLanguageCode& oe16_ISOLanguageCode);

   virtual tVoid vVisit_LanguageID(vehicle_fi_tcl_LanguageID& oLanguageID);

   virtual tVoid vVisit_u8_DirectionAbsolute(vehicle_fi_tcl_u8_DirectionAbsolute& ou8_DirectionAbsolute);

   virtual tVoid vVisit_u8_DirectionRelative(vehicle_fi_tcl_u8_DirectionRelative& ou8_DirectionRelative);

   virtual tVoid vVisit_s16_CentiDegree(vehicle_fi_tcl_s16_CentiDegree& os16_CentiDegree);

   virtual tVoid vVisit_s16_Degree(vehicle_fi_tcl_s16_Degree& os16_Degree);

   virtual tVoid vVisit_u16_DirectionAbsolute_CentiDegree(vehicle_fi_tcl_u16_DirectionAbsolute_CentiDegree& ou16_DirectionAbsolute_CentiDegree);

   virtual tVoid vVisit_s16_DirectionRelative_CentiDegree(vehicle_fi_tcl_s16_DirectionRelative_CentiDegree& os16_DirectionRelative_CentiDegree);

   virtual tVoid vVisit_e8_FuelType(vehicle_fi_tcl_e8_FuelType& oe8_FuelType);

   virtual tVoid vVisit_DistTimeFuel(vehicle_fi_tcl_DistTimeFuel& oDistTimeFuel);

   virtual tVoid vVisit_e8_Language_Code(vehicle_fi_tcl_e8_Language_Code& oe8_Language_Code);

   virtual tVoid vVisit_e8_Vehicle_DistanceUnit(vehicle_fi_tcl_e8_Vehicle_DistanceUnit& oe8_Vehicle_DistanceUnit);

   virtual tVoid vVisit_e8_Vehicle_FuelConsumptionUnit(vehicle_fi_tcl_e8_Vehicle_FuelConsumptionUnit& oe8_Vehicle_FuelConsumptionUnit);

   virtual tVoid vVisit_e8_Vehicle_TemperatureUnit(vehicle_fi_tcl_e8_Vehicle_TemperatureUnit& oe8_Vehicle_TemperatureUnit);

   virtual tVoid vVisit_e8_Vehicle_HandBrakeStatus(vehicle_fi_tcl_e8_Vehicle_HandBrakeStatus& oe8_Vehicle_HandBrakeStatus);

   virtual tVoid vVisit_e8_Vehicle_Ignition(vehicle_fi_tcl_e8_Vehicle_Ignition& oe8_Vehicle_Ignition);

   virtual tVoid vVisit_e8_Language_SourceId(vehicle_fi_tcl_e8_Language_SourceId& oe8_Language_SourceId);

   virtual tVoid vVisit_Language_SourceTable(vehicle_fi_tcl_Language_SourceTable& oLanguage_SourceTable);

   virtual tVoid vVisit_e8_Meter_SyncRequest(vehicle_fi_tcl_e8_Meter_SyncRequest& oe8_Meter_SyncRequest);

   virtual tVoid vVisit_e8_Meter_LangKnowledge(vehicle_fi_tcl_e8_Meter_LangKnowledge& oe8_Meter_LangKnowledge);

   virtual tVoid vVisit_e8_Vehicle_TPMSReset(vehicle_fi_tcl_e8_Vehicle_TPMSReset& oe8_Vehicle_TPMSReset);

   virtual tVoid vVisit_e8_Vehicle_TirePressureInfo(vehicle_fi_tcl_e8_Vehicle_TirePressureInfo& oe8_Vehicle_TirePressureInfo);

   virtual tVoid vVisit_e8_Vehicle_WarningState(vehicle_fi_tcl_e8_Vehicle_WarningState& oe8_Vehicle_WarningState);

   virtual tVoid vVisit_e8_Vehicle_States(vehicle_fi_tcl_e8_Vehicle_States& oe8_Vehicle_States);

   virtual tVoid vVisit_CAN_Message(vehicle_fi_tcl_CAN_Message& oCAN_Message);

   virtual tVoid vVisit_CAN_Mesg(vehicle_fi_tcl_CAN_Mesg& oCAN_Mesg);

   virtual tVoid vVisit_CAN_Navi_Mesg(vehicle_fi_tcl_CAN_Navi_Mesg& oCAN_Navi_Mesg);


 	fi_tclTraversePath<fi_tclKnot>::tclIterator oIterator;		
	
protected:
	tBool bBreakNow;
	tBool bIsVisitorValid;
private:

};

#endif
