/*****************************************************************************
* FILE:         LanguageList.h
* PROJECT:      RN A-IVI
* SW-COMPONENT: vd_VehicleData
*----------------------------------------------------------------------------
*
* DESCRIPTION: Generated from genLang.py using LanguageMapping.xml as the input
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
*****************************************************************************/
#ifndef _LANGUAGELIST_H_
#define _LANGUAGELIST_H_

#define LANGUAGELIST_H_VERSION 1

//! Macro Defines for all the Regions
#define USA  0
#define CAN  1
#define MEX  2
#define UK  3
#define TKY  4
#define RUS  5
#define OTHER_EUR  6
#define PRC  7
#define TWN  8
#define HKG  9
#define GCC  10
#define EGP  11
#define ASNZ  12
#define BRA  13
#define AGT  14
#define OTHER_LAC  15
#define SAF  16
#define THI  17
#define SGP  18
#define MLY  19
#define BRN  20
#define INN  21
#define VNM  22
#define PHL  23
#define IND  24
#define JPN  25
#define KOR  26
#define OTHER_GOM  27
#define ISR  28


//! Macro Defines for all the languages
#define ALBANESE  1
#define ARABIC  2
#define BULGARIAN  3
#define CHINESE_CANTONESE_SIMPLE  4
#define CHINESE_CANTONESE_TRADITIONAL  5
#define CHINESE_MANDARIN  6
#define CROATIAN  7
#define CZECH  8
#define DANISH  9
#define DUTCH  10
#define AUS_EN  11
#define UK_EN  12
#define US_EN  13
#define US_EN_JPN  14
#define US_EN_PRC  15
#define CAN_EN  16
#define INDIA_EN  17
#define ESTONIAN  18
#define FINNISH  19
#define FLEMISH  20
#define FRENCH  21
#define FRENCH_CAN  22
#define GERMAN  23
#define GREEK  24
#define HEBREW  25
#define HINDI  26
#define HUNGARIAN  27
#define INDONESIAN  28
#define ITALIAN  29
#define JAPANESE  30
#define KOREAN  31
#define LATVIAN  32
#define LITHUANIAN  33
#define MALAY  34
#define NORWEGIAN  35
#define PERSIAN  36
#define PHILLIPINES  37
#define POLISH  38
#define PORTUGUESE  39
#define PORTUGUESE_BRAZILIAN  40
#define ROMANIAN  41
#define RUSSIAN  42
#define SERBIAN  43
#define SLOVAKIAN  44
#define SLOVENIAN  45
#define SPANISH  46
#define SPANISH_LATIN_AMERICAN  47
#define SPANISH_MEXICAN  48
#define SWEDISH  49
#define TAIWANESE  50
#define THAI  51
#define TURKISH  52
#define UKRAINIAN  53
#define VIETNAMESE  54


//! Macro Defines for all the Meter languages received from CAN


typedef struct 
{
   const tU8 u8Region;
   const tU8 u8DefaultLanguage;
   const tBool bDefaultMode;
   const tU8* const pu8LangList;
   const tU8 u8SizeOfLangArray;
}sMapRegionLanguage;

typedef struct 
{
   const tU8 u8Region;
   const tU8* const pu8LangList;
   const tU8 u8SizeOfLangArray;
}sMapRegionSdsLanguage;

typedef struct
{
   const tU8 u8MeterLanguage;
   const tU8 u8SystemLanguage;
}sMapMeterLanguage;


const tU8 u8LangListForRegionUSA[] = { 
        US_EN, 
        FRENCH_CAN, 
        SPANISH_LATIN_AMERICAN, 
        UK_EN
    };

const tU8 u8LangListForRegionCAN[] = { 
        US_EN, 
        FRENCH_CAN, 
        SPANISH_MEXICAN
    };

const tU8 u8LangListForRegionMEX[] = { 
        US_EN, 
        FRENCH_CAN, 
        SPANISH_MEXICAN
    };

const tU8 u8LangListForRegionUK[] = { 
        UK_EN, 
        FRENCH, 
        GERMAN, 
        ITALIAN, 
        PORTUGUESE, 
        DUTCH, 
        SPANISH, 
        DANISH, 
        SWEDISH, 
        NORWEGIAN, 
        FINNISH, 
        POLISH, 
        CZECH, 
        SLOVAKIAN, 
        HUNGARIAN, 
        ROMANIAN, 
        GREEK, 
        TURKISH, 
        RUSSIAN
    };

const tU8 u8LangListForRegionTKY[] = { 
        UK_EN, 
        FRENCH, 
        GERMAN, 
        ITALIAN, 
        PORTUGUESE, 
        DUTCH, 
        SPANISH, 
        DANISH, 
        SWEDISH, 
        NORWEGIAN, 
        FINNISH, 
        POLISH, 
        CZECH, 
        SLOVAKIAN, 
        HUNGARIAN, 
        ROMANIAN, 
        GREEK, 
        TURKISH, 
        RUSSIAN
    };

const tU8 u8LangListForRegionRUS[] = { 
        UK_EN, 
        FRENCH, 
        GERMAN, 
        ITALIAN, 
        PORTUGUESE, 
        DUTCH, 
        SPANISH, 
        DANISH, 
        SWEDISH, 
        NORWEGIAN, 
        FINNISH, 
        POLISH, 
        CZECH, 
        SLOVAKIAN, 
        HUNGARIAN, 
        ROMANIAN, 
        GREEK, 
        TURKISH, 
        RUSSIAN
    };

const tU8 u8LangListForRegionOTHER_EUR[] = { 
        UK_EN, 
        US_EN, 
        FRENCH, 
        GERMAN, 
        ITALIAN, 
        PORTUGUESE, 
        DUTCH, 
        SPANISH, 
        DANISH, 
        SWEDISH, 
        NORWEGIAN, 
        FINNISH, 
        POLISH, 
        CZECH, 
        SLOVAKIAN, 
        HUNGARIAN, 
        ROMANIAN, 
        GREEK, 
        TURKISH, 
        RUSSIAN, 
        BULGARIAN, 
        CROATIAN, 
        SLOVENIAN
    };

const tU8 u8LangListForRegionPRC[] = { 
        CHINESE_MANDARIN, 
        CHINESE_CANTONESE_TRADITIONAL, 
        US_EN
    };

const tU8 u8LangListForRegionTWN[] = { 
        CHINESE_CANTONESE_TRADITIONAL, 
        US_EN
    };

const tU8 u8LangListForRegionHKG[] = { 
        CHINESE_MANDARIN, 
        CHINESE_CANTONESE_TRADITIONAL, 
        US_EN
    };

const tU8 u8LangListForRegionGCC[] = { 
        ARABIC, 
        UK_EN, 
        FRENCH, 
        SPANISH
    };

const tU8 u8LangListForRegionEGP[] = { 
        ARABIC, 
        HEBREW, 
        UK_EN
    };

const tU8 u8LangListForRegionASNZ[] = { 
        UK_EN, 
        FRENCH, 
        GERMAN, 
        ITALIAN, 
        PORTUGUESE, 
        DUTCH, 
        SPANISH, 
        TURKISH, 
        PORTUGUESE_BRAZILIAN, 
        THAI
    };

const tU8 u8LangListForRegionBRA[] = { 
        US_EN, 
        UK_EN, 
        FRENCH_CAN, 
        FRENCH, 
        GERMAN, 
        ITALIAN, 
        PORTUGUESE_BRAZILIAN, 
        PORTUGUESE, 
        DUTCH, 
        SPANISH_MEXICAN, 
        SPANISH, 
        TURKISH
    };

const tU8 u8LangListForRegionAGT[] = { 
        US_EN, 
        UK_EN, 
        FRENCH_CAN, 
        FRENCH, 
        GERMAN, 
        ITALIAN, 
        PORTUGUESE_BRAZILIAN, 
        PORTUGUESE, 
        DUTCH, 
        SPANISH_MEXICAN, 
        SPANISH, 
        TURKISH
    };

const tU8 u8LangListForRegionOTHER_LAC[] = { 
        US_EN, 
        UK_EN, 
        FRENCH_CAN, 
        FRENCH, 
        GERMAN, 
        ITALIAN, 
        PORTUGUESE_BRAZILIAN, 
        PORTUGUESE, 
        DUTCH, 
        SPANISH_MEXICAN, 
        SPANISH, 
        TURKISH, 
        THAI
    };

const tU8 u8LangListForRegionSAF[] = { 
        UK_EN, 
        FRENCH, 
        GERMAN, 
        ITALIAN, 
        PORTUGUESE, 
        DUTCH, 
        SPANISH, 
        GREEK, 
        TURKISH
    };

const tU8 u8LangListForRegionTHI[] = { 
        THAI, 
        US_EN, 
        FRENCH, 
        GERMAN, 
        ITALIAN, 
        PORTUGUESE, 
        PORTUGUESE_BRAZILIAN, 
        SPANISH, 
        DUTCH, 
        TURKISH, 
        CHINESE_CANTONESE_SIMPLE, 
        CHINESE_CANTONESE_TRADITIONAL
    };

const tU8 u8LangListForRegionSGP[] = { 
        US_EN, 
        FRENCH, 
        SPANISH, 
        CHINESE_CANTONESE_SIMPLE, 
        CHINESE_CANTONESE_TRADITIONAL
    };

const tU8 u8LangListForRegionMLY[] = { 
        US_EN, 
        FRENCH, 
        SPANISH, 
        CHINESE_CANTONESE_SIMPLE, 
        CHINESE_CANTONESE_TRADITIONAL
    };

const tU8 u8LangListForRegionBRN[] = { 
        US_EN, 
        FRENCH, 
        SPANISH
    };

const tU8 u8LangListForRegionINN[] = { 
        INDONESIAN, 
        US_EN
    };

const tU8 u8LangListForRegionVNM[] = { 
        UK_EN, 
        US_EN, 
        FRENCH, 
        RUSSIAN, 
        CHINESE_CANTONESE_SIMPLE, 
        CHINESE_CANTONESE_TRADITIONAL
    };

const tU8 u8LangListForRegionPHL[] = { 
        US_EN, 
        SPANISH, 
        CHINESE_CANTONESE_SIMPLE
    };

const tU8 u8LangListForRegionIND[] = { 
        US_EN
    };

const tU8 u8LangListForRegionJPN[] = { 
        JAPANESE, 
        US_EN
    };

const tU8 u8LangListForRegionKOR[] = { 
        KOREAN, 
        US_EN, 
        FRENCH, 
        SPANISH
    };

const tU8 u8LangListForRegionOTHER_GOM[] = { 
        US_EN, 
        UK_EN, 
        FRENCH, 
        GERMAN, 
        ITALIAN, 
        PORTUGUESE_BRAZILIAN, 
        PORTUGUESE, 
        DUTCH, 
        SPANISH_MEXICAN, 
        SPANISH, 
        TURKISH, 
        THAI, 
        CHINESE_CANTONESE_SIMPLE, 
        CHINESE_CANTONESE_TRADITIONAL, 
        TAIWANESE
    };

const tU8 u8LangListForRegionISR[] = { 
        HEBREW, 
        ARABIC, 
        UK_EN
    };





const sMapRegionLanguage mapRegionAndLanguage[] = {
    // Region    //DefaultLang  // Auto    // Pointer To Language Table     // Size Of Array
    { USA,      US_EN,            true,      u8LangListForRegionUSA,                 4 }, 
    { CAN,      US_EN,            true,      u8LangListForRegionCAN,                 3 }, 
    { MEX,      SPANISH_MEXICAN,            true,      u8LangListForRegionMEX,                 3 }, 
    { UK,      UK_EN,            true,      u8LangListForRegionUK,                 19 }, 
    { TKY,      TURKISH,            true,      u8LangListForRegionTKY,                 19 }, 
    { RUS,      RUSSIAN,            true,      u8LangListForRegionRUS,                 19 }, 
    { OTHER_EUR,      UK_EN,            true,      u8LangListForRegionOTHER_EUR,                 23 }, 
    { PRC,      CHINESE_MANDARIN,            true,      u8LangListForRegionPRC,                 3 }, 
    { TWN,      CHINESE_CANTONESE_TRADITIONAL,            true,      u8LangListForRegionTWN,                 2 }, 
    { HKG,      CHINESE_CANTONESE_TRADITIONAL,            true,      u8LangListForRegionHKG,                 3 }, 
    { GCC,      ARABIC,            true,      u8LangListForRegionGCC,                 4 }, 
    { EGP,      ARABIC,            true,      u8LangListForRegionEGP,                 3 }, 
    { ASNZ,      UK_EN,            true,      u8LangListForRegionASNZ,                 10 }, 
    { BRA,      PORTUGUESE_BRAZILIAN,            true,      u8LangListForRegionBRA,                 12 }, 
    { AGT,      SPANISH_MEXICAN,            true,      u8LangListForRegionAGT,                 12 }, 
    { OTHER_LAC,      SPANISH_MEXICAN,            true,      u8LangListForRegionOTHER_LAC,                 13 }, 
    { SAF,      UK_EN,            true,      u8LangListForRegionSAF,                 9 }, 
    { THI,      THAI,            true,      u8LangListForRegionTHI,                 12 }, 
    { SGP,      US_EN,            true,      u8LangListForRegionSGP,                 5 }, 
    { MLY,      US_EN,            true,      u8LangListForRegionMLY,                 5 }, 
    { BRN,      US_EN,            true,      u8LangListForRegionBRN,                 3 }, 
    { INN,      INDONESIAN,            true,      u8LangListForRegionINN,                 2 }, 
    { VNM,      US_EN,            true,      u8LangListForRegionVNM,                 6 }, 
    { PHL,      US_EN,            true,      u8LangListForRegionPHL,                 3 }, 
    { IND,      US_EN,            true,      u8LangListForRegionIND,                 1 }, 
    { JPN,      JAPANESE,            true,      u8LangListForRegionJPN,                 2 }, 
    { KOR,      KOREAN,            true,      u8LangListForRegionKOR,                 4 }, 
    { OTHER_GOM,      UK_EN,            true,      u8LangListForRegionOTHER_GOM,                 15 }, 
    { ISR,      UK_EN,            true,      u8LangListForRegionISR,                 3 }, 

};



const tU8 u8SdsLangListForRegionUSA[] = { 

    };

const tU8 u8SdsLangListForRegionCAN[] = { 

    };

const tU8 u8SdsLangListForRegionMEX[] = { 

    };

const tU8 u8SdsLangListForRegionUK[] = { 

    };

const tU8 u8SdsLangListForRegionTKY[] = { 

    };

const tU8 u8SdsLangListForRegionRUS[] = { 

    };

const tU8 u8SdsLangListForRegionOTHER_EUR[] = { 

    };

const tU8 u8SdsLangListForRegionPRC[] = { 

    };

const tU8 u8SdsLangListForRegionTWN[] = { 

    };

const tU8 u8SdsLangListForRegionHKG[] = { 

    };

const tU8 u8SdsLangListForRegionGCC[] = { 

    };

const tU8 u8SdsLangListForRegionEGP[] = { 

    };

const tU8 u8SdsLangListForRegionASNZ[] = { 

    };

const tU8 u8SdsLangListForRegionBRA[] = { 

    };

const tU8 u8SdsLangListForRegionAGT[] = { 

    };

const tU8 u8SdsLangListForRegionOTHER_LAC[] = { 

    };

const tU8 u8SdsLangListForRegionSAF[] = { 

    };

const tU8 u8SdsLangListForRegionTHI[] = { 

    };

const tU8 u8SdsLangListForRegionSGP[] = { 

    };

const tU8 u8SdsLangListForRegionMLY[] = { 

    };

const tU8 u8SdsLangListForRegionBRN[] = { 

    };

const tU8 u8SdsLangListForRegionINN[] = { 

    };

const tU8 u8SdsLangListForRegionVNM[] = { 

    };

const tU8 u8SdsLangListForRegionPHL[] = { 

    };

const tU8 u8SdsLangListForRegionIND[] = { 

    };

const tU8 u8SdsLangListForRegionJPN[] = { 

    };

const tU8 u8SdsLangListForRegionKOR[] = { 

    };

const tU8 u8SdsLangListForRegionOTHER_GOM[] = { 

    };

const tU8 u8SdsLangListForRegionISR[] = { 

    };



const sMapRegionSdsLanguage mapRegionAndSdsLanguage[] = {
    // Region    // Pointer To Language Table                         // Size Of Array
    { USA,             u8SdsLangListForRegionUSA,                                    0 }, 
    { CAN,             u8SdsLangListForRegionCAN,                                    0 }, 
    { MEX,             u8SdsLangListForRegionMEX,                                    0 }, 
    { UK,             u8SdsLangListForRegionUK,                                    0 }, 
    { TKY,             u8SdsLangListForRegionTKY,                                    0 }, 
    { RUS,             u8SdsLangListForRegionRUS,                                    0 }, 
    { OTHER_EUR,             u8SdsLangListForRegionOTHER_EUR,                                    0 }, 
    { PRC,             u8SdsLangListForRegionPRC,                                    0 }, 
    { TWN,             u8SdsLangListForRegionTWN,                                    0 }, 
    { HKG,             u8SdsLangListForRegionHKG,                                    0 }, 
    { GCC,             u8SdsLangListForRegionGCC,                                    0 }, 
    { EGP,             u8SdsLangListForRegionEGP,                                    0 }, 
    { ASNZ,             u8SdsLangListForRegionASNZ,                                    0 }, 
    { BRA,             u8SdsLangListForRegionBRA,                                    0 }, 
    { AGT,             u8SdsLangListForRegionAGT,                                    0 }, 
    { OTHER_LAC,             u8SdsLangListForRegionOTHER_LAC,                                    0 }, 
    { SAF,             u8SdsLangListForRegionSAF,                                    0 }, 
    { THI,             u8SdsLangListForRegionTHI,                                    0 }, 
    { SGP,             u8SdsLangListForRegionSGP,                                    0 }, 
    { MLY,             u8SdsLangListForRegionMLY,                                    0 }, 
    { BRN,             u8SdsLangListForRegionBRN,                                    0 }, 
    { INN,             u8SdsLangListForRegionINN,                                    0 }, 
    { VNM,             u8SdsLangListForRegionVNM,                                    0 }, 
    { PHL,             u8SdsLangListForRegionPHL,                                    0 }, 
    { IND,             u8SdsLangListForRegionIND,                                    0 }, 
    { JPN,             u8SdsLangListForRegionJPN,                                    0 }, 
    { KOR,             u8SdsLangListForRegionKOR,                                    0 }, 
    { OTHER_GOM,             u8SdsLangListForRegionOTHER_GOM,                                    0 }, 
    { ISR,             u8SdsLangListForRegionISR,                                    0 }, 

};


#endif // _LANGUAGELIST_H_

