/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef TIMESTAMPSYNC_MAINFITYPES_HEADER
#define TIMESTAMPSYNC_MAINFITYPES_HEADER


class timestampsync_mainfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for timestampsync_main_fi message types

fi_tclMessageBase* timestampsync_mainfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class timestampsync_mainfi_tclMsgBaseMessage : public timestampsync_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   timestampsync_mainfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class timestampsync_mainfi_tclMsgU8EchoGet : public timestampsync_mainfi_tclMsgBaseMessage
{
public:

   timestampsync_mainfi_tclMsgU8EchoGet();

   virtual ~timestampsync_mainfi_tclMsgU8EchoGet();

   inline tBool operator==(const timestampsync_mainfi_tclMsgU8EchoGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class timestampsync_mainfi_tclMsgU8EchoStatus : public timestampsync_mainfi_tclMsgBaseMessage
{
public:

   timestampsync_mainfi_tclMsgU8EchoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   timestampsync_mainfi_tclMsgU8EchoStatus& operator=(const timestampsync_mainfi_tclMsgU8EchoStatus& coRef);
   timestampsync_mainfi_tclMsgU8EchoStatus(const timestampsync_mainfi_tclMsgU8EchoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8Data;
   virtual ~timestampsync_mainfi_tclMsgU8EchoStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const timestampsync_mainfi_tclMsgU8EchoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
