/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define TIMESTAMPSYNC_FI_S_IMPORT_INTERFACE_TIMESTAMPSYNC_MAINFI_TYPES
#define TIMESTAMPSYNC_FI_S_IMPORT_INTERFACE_TIMESTAMPSYNC_MAINFI_FUNCTIONIDS
#define TIMESTAMPSYNC_FI_S_IMPORT_INTERFACE_TIMESTAMPSYNC_MAINFI_SERVICEINFO
#include "timestampsync_fi_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for timestampsync_main_fi message types

fi_tclMessageBase* timestampsync_mainfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case timestampsync_mainfi_tclToken::EN_MSG_U8ECHOGET:
         return OSAL_NEW timestampsync_mainfi_tclMsgU8EchoGet;

      case timestampsync_mainfi_tclToken::EN_MSG_U8ECHOSTATUS:
         return OSAL_NEW timestampsync_mainfi_tclMsgU8EchoStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all timestampsync_mainfifi messages

// common functions

tU16 timestampsync_mainfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return TIMESTAMPSYNC_MAINFI_C_U16_SERVICE_ID;
}

tU16 timestampsync_mainfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 timestampsync_mainfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& timestampsync_mainfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& timestampsync_mainfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 timestampsync_mainfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& timestampsync_mainfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& timestampsync_mainfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

timestampsync_mainfi_tclMsgU8EchoGet::timestampsync_mainfi_tclMsgU8EchoGet()
 {}

tS32 timestampsync_mainfi_tclMsgU8EchoGet::s32GetTypeId() const
{
   return (tS32) timestampsync_mainfi_tclToken::EN_MSG_U8ECHOGET;
}


timestampsync_mainfi_tclMsgU8EchoGet::~timestampsync_mainfi_tclMsgU8EchoGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
timestampsync_mainfi_tclMsgU8EchoStatus::timestampsync_mainfi_tclMsgU8EchoStatus(const timestampsync_mainfi_tclMsgU8EchoStatus& coRef)
   : timestampsync_mainfi_tclMsgBaseMessage(coRef)
{
   u8Data = coRef.u8Data;
}
timestampsync_mainfi_tclMsgU8EchoStatus& timestampsync_mainfi_tclMsgU8EchoStatus::operator=(const timestampsync_mainfi_tclMsgU8EchoStatus& coRef)
{
   if (this == &coRef) return *this;
   u8Data = coRef.u8Data;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

timestampsync_mainfi_tclMsgU8EchoStatus::timestampsync_mainfi_tclMsgU8EchoStatus()
:u8Data(0)
 {}

tS32 timestampsync_mainfi_tclMsgU8EchoStatus::s32GetTypeId() const
{
   return (tS32) timestampsync_mainfi_tclToken::EN_MSG_U8ECHOSTATUS;
}


timestampsync_mainfi_tclMsgU8EchoStatus::~timestampsync_mainfi_tclMsgU8EchoStatus()
{}

tU32 timestampsync_mainfi_tclMsgU8EchoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& timestampsync_mainfi_tclMsgU8EchoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Data);
   return oIn;
}

fi_tclOutContext& timestampsync_mainfi_tclMsgU8EchoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Data);
   return oOut;
}

tBool timestampsync_mainfi_tclMsgU8EchoStatus::operator==(const timestampsync_mainfi_tclMsgU8EchoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Data == roRef.u8Data);
   return bResult;
}

