#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define TIMESTAMPSYNC_FI_S_IMPORT_INTERFACE_TIMESTAMPSYNC_MAINFI_STDVISITORS
#include "timestampsync_fi_if.h"

tBool timestampsync_mainfi_tclDescription::bInitMessage(timestampsync_mainfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case timestampsync_mainfi_tclToken::EN_LAST_TOKEN:
   case timestampsync_mainfi_tclToken::EN_LIST:
   case timestampsync_mainfi_tclToken::EN_END_OF_STRUCT:
   case timestampsync_mainfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;

   // include the expansions for the messages
   case timestampsync_mainfi_tclToken::EN_MSG_U8ECHOSTATUS:
   {
      bResult = oPath.bGoDown(timestampsync_mainfi_tclKnot(timestampsync_mainfi_tclToken::EN_U8,timestampsync_mainfi_tclSemanticDomain::EN_MSG_U8DATA)) && bResult;
   } break;
   case timestampsync_mainfi_tclToken::EN_MSG_U8ECHOGET:
   case timestampsync_mainfi_tclToken::EN_BINCONTAINER:
   case timestampsync_mainfi_tclToken::EN_U8:   
   case timestampsync_mainfi_tclToken::EN_S8:   
   case timestampsync_mainfi_tclToken::EN_U16:   
   case timestampsync_mainfi_tclToken::EN_S16:   
   case timestampsync_mainfi_tclToken::EN_U24:   
   case timestampsync_mainfi_tclToken::EN_S24:   
   case timestampsync_mainfi_tclToken::EN_U32:   
   case timestampsync_mainfi_tclToken::EN_S32:   
   case timestampsync_mainfi_tclToken::EN_U64:   
   case timestampsync_mainfi_tclToken::EN_S64:   
   case timestampsync_mainfi_tclToken::EN_F32:   
   case timestampsync_mainfi_tclToken::EN_F64:   
   case timestampsync_mainfi_tclToken::EN_BOOL:   
   case timestampsync_mainfi_tclToken::EN_STRING:   
   case timestampsync_mainfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(timestampsync_mainfi_tclKnot(enMsgToken,timestampsync_mainfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool timestampsync_mainfi_tclDescription::bDoIt(timestampsync_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool timestampsync_mainfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      timestampsync_mainfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      timestampsync_mainfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      timestampsync_mainfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == timestampsync_mainfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(timestampsync_mainfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(timestampsync_mainfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(timestampsync_mainfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case timestampsync_mainfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == timestampsync_mainfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case timestampsync_mainfi_tclToken::EN_LIST: 
      {
         timestampsync_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            timestampsync_mainfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(timestampsync_mainfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            timestampsync_mainfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(timestampsync_mainfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case timestampsync_mainfi_tclToken::EN_U8: 
      {
         timestampsync_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case timestampsync_mainfi_tclToken::EN_U16: 
      {
         timestampsync_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case timestampsync_mainfi_tclToken::EN_U24: 
      {
         timestampsync_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case timestampsync_mainfi_tclToken::EN_U32: 
      {
         timestampsync_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case timestampsync_mainfi_tclToken::EN_U64: 
      {
         timestampsync_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case timestampsync_mainfi_tclToken::EN_S8: 
      {
         timestampsync_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case timestampsync_mainfi_tclToken::EN_S16: 
      {
         timestampsync_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case timestampsync_mainfi_tclToken::EN_S24: 
      {
         timestampsync_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case timestampsync_mainfi_tclToken::EN_S32: 
      {
         timestampsync_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case timestampsync_mainfi_tclToken::EN_S64: 
      {
         timestampsync_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case timestampsync_mainfi_tclToken::EN_F32: 
      {
         timestampsync_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case timestampsync_mainfi_tclToken::EN_F64: 
      {
         timestampsync_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case timestampsync_mainfi_tclToken::EN_BOOL: 
      {
         timestampsync_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case timestampsync_mainfi_tclToken::EN_STRING: 
      {
         timestampsync_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case timestampsync_mainfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         timestampsync_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case timestampsync_mainfi_tclToken::EN_MSG_U8ECHOGET:
      case timestampsync_mainfi_tclToken::EN_MSG_U8ECHOSTATUS:
         (tVoid) bInitMessage(enToken);
         break;
      case timestampsync_mainfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(timestampsync_mainfi_tclKnot(timestampsync_mainfi_tclToken::EN_END_OF_STRUCT,timestampsync_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(timestampsync_mainfi_tclKnot(timestampsync_mainfi_tclToken::EN_U8,timestampsync_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(timestampsync_mainfi_tclKnot(timestampsync_mainfi_tclToken::EN_LIST,timestampsync_mainfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         timestampsync_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case timestampsync_mainfi_tclToken::EN_UNKNOWN:
      case timestampsync_mainfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

