/************************************************************************
 
 *FILE:           alltypes.cpp
 
 *SW-COMPONENT:   FI Functional Interface
 
 *DESCRIPTION:    Interface fuer alle Typdefinitionen
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#if !defined(FI_S_NO_STRING_ACCESS_METHODS) || !defined(FI_S_UTFMODE_TRANSPARENT)
   #define UTFUTIL_S_IMPORT_INTERFACE_GENERIC
   #include "utf_if.h"
#endif

#define TCU_USB_FI_S_IMPORT_INTERFACE_FI_TYPES
#include "tcu_usb_fi_if.h"
// -----------------------------------------------------------------------------

fi_tclOutContext& tcu_usb_fi_tclU8::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u8Value);
  return oOut;
}

fi_tclInContext& tcu_usb_fi_tclU8::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u8Value);
  return oIn;
}

tU32 tcu_usb_fi_tclU8::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& tcu_usb_fi_tclS8::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s8Value);
  return oOut;
}

fi_tclInContext& tcu_usb_fi_tclS8::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s8Value);
  return oIn;
}

tU32 tcu_usb_fi_tclS8::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& tcu_usb_fi_tclU16::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u16Value);
  return oOut;
}

fi_tclInContext& tcu_usb_fi_tclU16::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u16Value);
  return oIn;
}

tU32 tcu_usb_fi_tclU16::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& tcu_usb_fi_tclS16::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s16Value);
  return oOut;
}

fi_tclInContext& tcu_usb_fi_tclS16::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s16Value);
  return oIn;
}

tU32 tcu_usb_fi_tclS16::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& tcu_usb_fi_tclU24::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u24Value);
  return oOut;
}

fi_tclInContext& tcu_usb_fi_tclU24::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u24Value);
  return oIn;
}

tU32 tcu_usb_fi_tclU24::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& tcu_usb_fi_tclS24::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s24Value);
  return oOut;
}

fi_tclInContext& tcu_usb_fi_tclS24::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s24Value);
  return oIn;
}

tU32 tcu_usb_fi_tclS24::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& tcu_usb_fi_tclU32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u32Value);
  return oOut;
}

fi_tclInContext& tcu_usb_fi_tclU32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u32Value);
  return oIn;
}

tU32 tcu_usb_fi_tclU32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& tcu_usb_fi_tclU64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u64Value);
  return oOut;
}

fi_tclInContext& tcu_usb_fi_tclU64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u64Value);
  return oIn;
}

tU32 tcu_usb_fi_tclU64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& tcu_usb_fi_tclS32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s32Value);
  return oOut;
}

fi_tclInContext& tcu_usb_fi_tclS32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s32Value);
  return oIn;
}

tU32 tcu_usb_fi_tclS32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& tcu_usb_fi_tclS64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s64Value);
  return oOut;
}

fi_tclInContext& tcu_usb_fi_tclS64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s64Value);
  return oIn;
}

tU32 tcu_usb_fi_tclS64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& tcu_usb_fi_tclF32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(f32Value);
  return oOut;
}

fi_tclInContext& tcu_usb_fi_tclF32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(f32Value);
  return oIn;
}

tU32 tcu_usb_fi_tclF32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& tcu_usb_fi_tclF64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(f64Value);
  return oOut;
}

fi_tclInContext& tcu_usb_fi_tclF64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(f64Value);
  return oIn;
}

tU32 tcu_usb_fi_tclF64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
  return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& tcu_usb_fi_tclBool::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(bValue);
  return oOut;
}

fi_tclInContext& tcu_usb_fi_tclBool::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(bValue);
  return oIn;
}

tU32 tcu_usb_fi_tclBool::u32GetSize(tU16 /*u16MajorVersion*/) const
{
  return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& tcu_usb_fi_tclString::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(szValue);
  return oOut;
}

tVoid tcu_usb_fi_tclString::vDestroy() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tclString::~tcu_usb_fi_tclString() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

tcu_usb_fi_tclString& tcu_usb_fi_tclString::operator=(const tcu_usb_fi_tclString& coRef)
{
   if (this == &coRef) return *this;

   OSAL_DELETE[] szValue;
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
	  if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
   return *this;
}

tcu_usb_fi_tclString::tcu_usb_fi_tclString(const tcu_usb_fi_tclString& coRef):tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
}
#endif

fi_tclInContext& tcu_usb_fi_tclString::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(szValue);
  return oIn;
}

tBool tcu_usb_fi_tclString::operator==(const tcu_usb_fi_tclString& roRef) const
{
   if ((szValue == OSAL_NULL) || (roRef.szValue == OSAL_NULL))
   {
      if (szValue == roRef.szValue)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(roRef.szValue) == 0);
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,roRef.szValue));
   }
}

tU32 tcu_usb_fi_tclString::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return FI_u32StringLength(szValue) + 1;
}

#ifndef FI_DO_NOT_USE_TSTRING
tcu_usb_fi_tclString& tcu_usb_fi_tclString::operator=(tCString coszString) // ADDED
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      // nothing to convert, just copy (UTF-8) string into member field
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      OSAL_DELETE[] szValue;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
   return *this;
}

//fi_tclString::fi_tclString(const tString& coszString) // ADDED (changed from const tString to const tString&)
tcu_usb_fi_tclString::tcu_usb_fi_tclString(tCString coszString) // ADDED (changed from const tString& to tCString)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
}

tBool tcu_usb_fi_tclString::operator==(tCString coszString) const // ADDED
{
   if ((szValue == OSAL_NULL) || (coszString == OSAL_NULL))
   {
      if (szValue == coszString)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(coszString) == 0); //lint !e668 : same constellation as in other compare operator, which is ok for LINT
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,coszString));
   }
}

tcu_usb_fi_tclString::operator tString&() // ADDED
{
   return szValue;
}

tcu_usb_fi_tclString::operator const tChar* () const // ADDED
{
   return szValue;
}

tBool tcu_usb_fi_tclString::operator!=(intptr_t iNULL) const // ADDED
{
   return szValue != (char*)iNULL;
}

static tChar tcu_usb_FI_C_U8_NULLCHAR = '\0';

tChar* tcu_usb_fi_tclString::operator+(int iOffset) // ADDED
{
   if (szValue)
      return szValue + iOffset;
   else
      return OSAL_NULL;
}

tChar* tcu_usb_fi_tclString::operator+(tU8  u8Offset) // ADDED
{
   if (szValue)
      return szValue + u8Offset;
   else
      return OSAL_NULL;
}

tChar* tcu_usb_fi_tclString::operator+(tU32 u32Offset) // ADDED
{
   if (szValue)
      return szValue + u32Offset;
   else
      return OSAL_NULL;
}

tChar& tcu_usb_fi_tclString::operator[](tU16 u16Index) //ADDED
{
   if (szValue)
      return szValue[u16Index];
   else
      return tcu_usb_FI_C_U8_NULLCHAR;
}

tChar& tcu_usb_fi_tclString::operator[](tU32 u32Index) //ADDED
{
   if (szValue)
      return szValue[u32Index];
   else
      return tcu_usb_FI_C_U8_NULLCHAR;
}

tChar& tcu_usb_fi_tclString::operator[](tS32 s32Index) //ADDED
{
   if (szValue)
      return szValue[s32Index];
   else
      return tcu_usb_FI_C_U8_NULLCHAR;
}
#endif

#ifndef FI_S_NO_STRING_ACCESS_METHODS

tBool tcu_usb_fi_tclString::bSet(const tcu_usb_fi_tclString& corfoInit, tenCharSet enCharSet)
{
   return bSet(corfoInit.szValue, enCharSet);
}

//tBool figroup_fi_tclString::bSet(const tString& coszInit, tenCharSet enCharSet)
tBool tcu_usb_fi_tclString::bSet(tCString coszInit, tenCharSet enCharSet)
{
   tBool bSuccess = true;
   if (coszInit != OSAL_NULL)
   {
   switch (enCharSet)
   {
   case FI_EN_UTF8:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // nothing to convert, just copy UTF-8 string into member field
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#else
         // input is UTF8, FI assumes ISO-Mod internally, thus convert input
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
            0,
            0,
            coszInit,
            u32UTFStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            utfutil_u32ConvertUTF82ISOMod(
               szValue,
               u32ISOStringLength,
               coszInit,
               u32UTFStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_ISO8859_15M:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            utfutil_u32ConvertISOMod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
case FI_EN_ISO8859_1M :
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = util_u32ConvertISO8859_1Mod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            util_u32ConvertISO8859_1Mod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_UNDEFINED:
   default:
      bSuccess = false;
   }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
   return bSuccess;
}

tString tcu_usb_fi_tclString::szGet(tenCharSet enCharSet) const
{
   tString szRetVal = 0;
   if (OSAL_NULL != szValue)
   {
      switch (enCharSet)
      {
      case FI_EN_UTF8:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // nothing to convert, just copy internal member value
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#else
            // internal member is ISO-Mod, export as UTF8
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
               0,
               0,
               szValue,
               u32ISOStringLength
               );
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertISOMod2UTF8(
                  szRetVal,
                  u32UTFStringLength,
                  szValue,
                  u32ISOStringLength
                  );
            }
#endif
         } break;
      case FI_EN_ISO8859_15M:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // internal member is UTF8, export as ISO-Mod
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
               0,
               0,
               szValue,
               u32UTFStringLength
               );
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertUTF82ISOMod(
                  szRetVal,
                  u32ISOStringLength,
                  szValue,
                  u32UTFStringLength
                  );
            }
#else
            // nothing to convert, just copy internal member value
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#endif
         } break;
      case FI_EN_UNDEFINED:
      default:
         szRetVal = OSAL_NULL;
      }
   }
   return szRetVal;
}
#endif

// -----------------------------------------------------------------------------

fi_tclOutContext& tcu_usb_fi_tclList::oWrite(fi_tclOutContext& oOut) const 
{
   // --Schreibe die Listenlaenge in den Kontext
   (tVoid) oOut.oWrite(u32ListSize);
   return oOut;
}

fi_tclInContext& tcu_usb_fi_tclList::oRead(fi_tclInContext& oIn) 
{
  // --Lese die Listenlaenge aus dem Kontext
  (tVoid) oIn.oRead(u32ListSize);
  return oIn;
}

tBool tcu_usb_fi_tclList::operator==(const tcu_usb_fi_tclList& roRef) const
{
   return roRef.u32ListSize == u32ListSize;
}

tU32 tcu_usb_fi_tclList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& tcu_usb_fi_tclMultiLanguageString::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(szValue);
  return oOut;
}

tVoid tcu_usb_fi_tclMultiLanguageString::vDestroy() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tclMultiLanguageString::~tcu_usb_fi_tclMultiLanguageString() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

tcu_usb_fi_tclMultiLanguageString& tcu_usb_fi_tclMultiLanguageString::operator=(const tcu_usb_fi_tclMultiLanguageString& coRef)
{
   if (this == &coRef) return *this;

   OSAL_DELETE[] szValue;
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
	  if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
   return *this;
}

tcu_usb_fi_tclMultiLanguageString::tcu_usb_fi_tclMultiLanguageString(const tcu_usb_fi_tclMultiLanguageString& coRef):tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
}
#endif

fi_tclInContext& tcu_usb_fi_tclMultiLanguageString::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(szValue);
  return oIn;
}

tBool tcu_usb_fi_tclMultiLanguageString::operator==(const tcu_usb_fi_tclMultiLanguageString& roRef) const
{
   if ((szValue == OSAL_NULL) || (roRef.szValue == OSAL_NULL))
   {
      if (szValue == roRef.szValue)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(roRef.szValue) == 0);
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,roRef.szValue));
   }
}

tU32 tcu_usb_fi_tclMultiLanguageString::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return FI_u32StringLength(szValue) + 1;
}

#ifndef FI_DO_NOT_USE_TSTRING
tcu_usb_fi_tclMultiLanguageString& tcu_usb_fi_tclMultiLanguageString::operator=(tCString coszString) // ADDED
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      // nothing to convert, just copy (UTF-8) string into member field
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      OSAL_DELETE[] szValue;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
   return *this;
}

//fi_tclMultiLanguageString::fi_tclMultiLanguageString(const tString& coszString) // ADDED (changed from const tString to const tString&)
tcu_usb_fi_tclMultiLanguageString::tcu_usb_fi_tclMultiLanguageString(tCString coszString) // ADDED (changed from const tString& to tCString)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
}

tBool tcu_usb_fi_tclMultiLanguageString::operator==(tCString coszString) const // ADDED
{
   if ((szValue == OSAL_NULL) || (coszString == OSAL_NULL))
   {
      if (szValue == coszString)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(coszString) == 0); //lint !e668 : same constellation as in other compare operator, which is ok for LINT
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,coszString));
   }
}

tcu_usb_fi_tclMultiLanguageString::operator tString&() // ADDED
{
   return szValue;
}

tcu_usb_fi_tclMultiLanguageString::operator const tChar* () const // ADDED
{
   return szValue;
}

tBool tcu_usb_fi_tclMultiLanguageString::operator!=(intptr_t iNULL) const// ADDED
{
   return szValue != (char*)iNULL;
}

tChar* tcu_usb_fi_tclMultiLanguageString::operator+(int iOffset) // ADDED
{
   if (szValue)
      return szValue + iOffset;
   else
      return OSAL_NULL;
}

tChar* tcu_usb_fi_tclMultiLanguageString::operator+(tU8  u8Offset) // ADDED
{
   if (szValue)
      return szValue + u8Offset;
   else
      return OSAL_NULL;
}

tChar* tcu_usb_fi_tclMultiLanguageString::operator+(tU32 u32Offset) // ADDED
{
   if (szValue)
      return szValue + u32Offset;
   else
      return OSAL_NULL;
}

tChar& tcu_usb_fi_tclMultiLanguageString::operator[](tU16 u16Index) //ADDED
{
   if (szValue)
      return szValue[u16Index];
   else
      return tcu_usb_FI_C_U8_NULLCHAR;
}

tChar& tcu_usb_fi_tclMultiLanguageString::operator[](tU32 u32Index) //ADDED
{
   if (szValue)
      return szValue[u32Index];
   else
      return tcu_usb_FI_C_U8_NULLCHAR;
}

tChar& tcu_usb_fi_tclMultiLanguageString::operator[](tS32 s32Index) //ADDED
{
   if (szValue)
      return szValue[s32Index];
   else
      return tcu_usb_FI_C_U8_NULLCHAR;
}
#endif

#ifndef FI_S_NO_STRING_ACCESS_METHODS

tBool tcu_usb_fi_tclMultiLanguageString::bSet(const tcu_usb_fi_tclMultiLanguageString& corfoInit, tenCharSet enCharSet)
{
   return bSet(corfoInit.szValue, enCharSet);
}

//tBool figroup_fi_tclMultiLanguageString::bSet(const tString& coszInit, tenCharSet enCharSet)
tBool tcu_usb_fi_tclMultiLanguageString::bSet(tCString coszInit, tenCharSet enCharSet)
{
   tBool bSuccess = true;
   if (coszInit != OSAL_NULL)
   {
   switch (enCharSet)
   {
   case FI_EN_UTF8:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // nothing to convert, just copy UTF-8 string into member field
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#else
         // input is UTF8, FI assumes ISO-Mod internally, thus convert input
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
            0,
            0,
            coszInit,
            u32UTFStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            utfutil_u32ConvertUTF82ISOMod(
               szValue,
               u32ISOStringLength,
               coszInit,
               u32UTFStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_ISO8859_15M:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            utfutil_u32ConvertISOMod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_UNDEFINED:
   default:
      bSuccess = false;
   }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }

   return bSuccess;
}

tString tcu_usb_fi_tclMultiLanguageString::szGet(tenCharSet enCharSet) const
{
   tString szRetVal = 0;
   if (OSAL_NULL != szValue)
   {
      switch (enCharSet)
      {
      case FI_EN_UTF8:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // nothing to convert, just copy internal member value
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#else
            // internal member is ISO-Mod, export as UTF8
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
               0,
               0,
               szValue,
               u32ISOStringLength
               );
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertISOMod2UTF8(
                  szRetVal,
                  u32UTFStringLength,
                  szValue,
                  u32ISOStringLength
                  );
            }
#endif
         } break;
      case FI_EN_ISO8859_15M:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // internal member is UTF8, export as ISO-Mod
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
               0,
               0,
               szValue,
               u32UTFStringLength
               );
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertUTF82ISOMod(
                  szRetVal,
                  u32ISOStringLength,
                  szValue,
                  u32UTFStringLength
                  );
            }
#else
            // nothing to convert, just copy internal member value
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#endif
         } break;
      case FI_EN_UNDEFINED:
      default:
         szRetVal = OSAL_NULL;
      }
   }
   return szRetVal;
}
#endif

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_BinContainer::tcu_usb_fi_tcl_BinContainer(const tcu_usb_fi_tcl_BinContainer& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   ContainerDataList = coRef.ContainerDataList;
}
tcu_usb_fi_tcl_BinContainer& tcu_usb_fi_tcl_BinContainer::operator=(const tcu_usb_fi_tcl_BinContainer& coRef)
{
   if (this == &coRef) return *this;
   ContainerDataList = coRef.ContainerDataList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_fi_tcl_BinContainer::vDestroy()
{
   {
   ContainerDataList.clear();
   }
}

tcu_usb_fi_tcl_BinContainer::tcu_usb_fi_tcl_BinContainer()

 {}

tS32 tcu_usb_fi_tcl_BinContainer::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_BINCONTAINER;
}


tcu_usb_fi_tcl_BinContainer::~tcu_usb_fi_tcl_BinContainer()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_fi_tcl_BinContainer::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(ContainerDataList.size()*1);
}

fi_tclInContext& tcu_usb_fi_tcl_BinContainer::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ContainerDataList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ContainerDataList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_BinContainer::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ContainerDataList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ContainerDataList.size(); ++u32Idx)
         (tVoid) (oOut << ContainerDataList[u32Idx]);
   }
   return oOut;
}

tBool tcu_usb_fi_tcl_BinContainer::operator==(const tcu_usb_fi_tcl_BinContainer& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ContainerDataList.size() == roRef.ContainerDataList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ContainerDataList.size()); ++u32Idx)
            bResult = bResult && (ContainerDataList[u32Idx] == roRef.ContainerDataList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

tcu_usb_fi_tcl_Reserved::tcu_usb_fi_tcl_Reserved()
 {}

tS32 tcu_usb_fi_tcl_Reserved::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_RESERVED;
}


tcu_usb_fi_tcl_Reserved::~tcu_usb_fi_tcl_Reserved()
{}

tU32 tcu_usb_fi_tcl_Reserved::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

fi_tclInContext& tcu_usb_fi_tcl_Reserved::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_Reserved::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_u8_Percent::tcu_usb_fi_tcl_u8_Percent(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 tcu_usb_fi_tcl_u8_Percent::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_U8_PERCENT;
}


tcu_usb_fi_tcl_u8_Percent::~tcu_usb_fi_tcl_u8_Percent()
{}

tU32 tcu_usb_fi_tcl_u8_Percent::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_fi_tcl_u8_Percent::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& tcu_usb_fi_tcl_u8_Percent::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_s16_PerThousand::tcu_usb_fi_tcl_s16_PerThousand(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 tcu_usb_fi_tcl_s16_PerThousand::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_S16_PERTHOUSAND;
}


tcu_usb_fi_tcl_s16_PerThousand::~tcu_usb_fi_tcl_s16_PerThousand()
{}

tU32 tcu_usb_fi_tcl_s16_PerThousand::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& tcu_usb_fi_tcl_s16_PerThousand::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& tcu_usb_fi_tcl_s16_PerThousand::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_u16_IndexInReferenceList::tcu_usb_fi_tcl_u16_IndexInReferenceList(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 tcu_usb_fi_tcl_u16_IndexInReferenceList::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_U16_INDEXINREFERENCELIST;
}


tcu_usb_fi_tcl_u16_IndexInReferenceList::~tcu_usb_fi_tcl_u16_IndexInReferenceList()
{}

tU32 tcu_usb_fi_tcl_u16_IndexInReferenceList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& tcu_usb_fi_tcl_u16_IndexInReferenceList::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& tcu_usb_fi_tcl_u16_IndexInReferenceList::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_u16_ErrorCode::tcu_usb_fi_tcl_u16_ErrorCode(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 tcu_usb_fi_tcl_u16_ErrorCode::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_U16_ERRORCODE;
}


tcu_usb_fi_tcl_u16_ErrorCode::~tcu_usb_fi_tcl_u16_ErrorCode()
{}

tU32 tcu_usb_fi_tcl_u16_ErrorCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& tcu_usb_fi_tcl_u16_ErrorCode::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& tcu_usb_fi_tcl_u16_ErrorCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_u16_RPM::tcu_usb_fi_tcl_u16_RPM(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 tcu_usb_fi_tcl_u16_RPM::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_U16_RPM;
}


tcu_usb_fi_tcl_u16_RPM::~tcu_usb_fi_tcl_u16_RPM()
{}

tU32 tcu_usb_fi_tcl_u16_RPM::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& tcu_usb_fi_tcl_u16_RPM::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& tcu_usb_fi_tcl_u16_RPM::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_s32_Kilogram::tcu_usb_fi_tcl_s32_Kilogram(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 tcu_usb_fi_tcl_s32_Kilogram::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_S32_KILOGRAM;
}


tcu_usb_fi_tcl_s32_Kilogram::~tcu_usb_fi_tcl_s32_Kilogram()
{}

tU32 tcu_usb_fi_tcl_s32_Kilogram::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& tcu_usb_fi_tcl_s32_Kilogram::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& tcu_usb_fi_tcl_s32_Kilogram::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_s32_Pound::tcu_usb_fi_tcl_s32_Pound(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 tcu_usb_fi_tcl_s32_Pound::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_S32_POUND;
}


tcu_usb_fi_tcl_s32_Pound::~tcu_usb_fi_tcl_s32_Pound()
{}

tU32 tcu_usb_fi_tcl_s32_Pound::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& tcu_usb_fi_tcl_s32_Pound::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& tcu_usb_fi_tcl_s32_Pound::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_s16_Meter::tcu_usb_fi_tcl_s16_Meter(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 tcu_usb_fi_tcl_s16_Meter::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_S16_METER;
}


tcu_usb_fi_tcl_s16_Meter::~tcu_usb_fi_tcl_s16_Meter()
{}

tU32 tcu_usb_fi_tcl_s16_Meter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& tcu_usb_fi_tcl_s16_Meter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& tcu_usb_fi_tcl_s16_Meter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_s32_Meter::tcu_usb_fi_tcl_s32_Meter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 tcu_usb_fi_tcl_s32_Meter::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_S32_METER;
}


tcu_usb_fi_tcl_s32_Meter::~tcu_usb_fi_tcl_s32_Meter()
{}

tU32 tcu_usb_fi_tcl_s32_Meter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& tcu_usb_fi_tcl_s32_Meter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& tcu_usb_fi_tcl_s32_Meter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_s32_Yards::tcu_usb_fi_tcl_s32_Yards(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 tcu_usb_fi_tcl_s32_Yards::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_S32_YARDS;
}


tcu_usb_fi_tcl_s32_Yards::~tcu_usb_fi_tcl_s32_Yards()
{}

tU32 tcu_usb_fi_tcl_s32_Yards::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& tcu_usb_fi_tcl_s32_Yards::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& tcu_usb_fi_tcl_s32_Yards::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_s32_Foot::tcu_usb_fi_tcl_s32_Foot(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 tcu_usb_fi_tcl_s32_Foot::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_S32_FOOT;
}


tcu_usb_fi_tcl_s32_Foot::~tcu_usb_fi_tcl_s32_Foot()
{}

tU32 tcu_usb_fi_tcl_s32_Foot::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& tcu_usb_fi_tcl_s32_Foot::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& tcu_usb_fi_tcl_s32_Foot::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_s32_Centimeter::tcu_usb_fi_tcl_s32_Centimeter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 tcu_usb_fi_tcl_s32_Centimeter::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_S32_CENTIMETER;
}


tcu_usb_fi_tcl_s32_Centimeter::~tcu_usb_fi_tcl_s32_Centimeter()
{}

tU32 tcu_usb_fi_tcl_s32_Centimeter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& tcu_usb_fi_tcl_s32_Centimeter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& tcu_usb_fi_tcl_s32_Centimeter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_s32_Inch::tcu_usb_fi_tcl_s32_Inch(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 tcu_usb_fi_tcl_s32_Inch::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_S32_INCH;
}


tcu_usb_fi_tcl_s32_Inch::~tcu_usb_fi_tcl_s32_Inch()
{}

tU32 tcu_usb_fi_tcl_s32_Inch::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& tcu_usb_fi_tcl_s32_Inch::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& tcu_usb_fi_tcl_s32_Inch::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_s32_Millimeter::tcu_usb_fi_tcl_s32_Millimeter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 tcu_usb_fi_tcl_s32_Millimeter::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_S32_MILLIMETER;
}


tcu_usb_fi_tcl_s32_Millimeter::~tcu_usb_fi_tcl_s32_Millimeter()
{}

tU32 tcu_usb_fi_tcl_s32_Millimeter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& tcu_usb_fi_tcl_s32_Millimeter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& tcu_usb_fi_tcl_s32_Millimeter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_s32_Microliter::tcu_usb_fi_tcl_s32_Microliter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 tcu_usb_fi_tcl_s32_Microliter::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_S32_MICROLITER;
}


tcu_usb_fi_tcl_s32_Microliter::~tcu_usb_fi_tcl_s32_Microliter()
{}

tU32 tcu_usb_fi_tcl_s32_Microliter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& tcu_usb_fi_tcl_s32_Microliter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& tcu_usb_fi_tcl_s32_Microliter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_s32_Second::tcu_usb_fi_tcl_s32_Second(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 tcu_usb_fi_tcl_s32_Second::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_S32_SECOND;
}


tcu_usb_fi_tcl_s32_Second::~tcu_usb_fi_tcl_s32_Second()
{}

tU32 tcu_usb_fi_tcl_s32_Second::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& tcu_usb_fi_tcl_s32_Second::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& tcu_usb_fi_tcl_s32_Second::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_u16_MilliSecond::tcu_usb_fi_tcl_u16_MilliSecond(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 tcu_usb_fi_tcl_u16_MilliSecond::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_U16_MILLISECOND;
}


tcu_usb_fi_tcl_u16_MilliSecond::~tcu_usb_fi_tcl_u16_MilliSecond()
{}

tU32 tcu_usb_fi_tcl_u16_MilliSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& tcu_usb_fi_tcl_u16_MilliSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& tcu_usb_fi_tcl_u16_MilliSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_s32_MilliSecond::tcu_usb_fi_tcl_s32_MilliSecond(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 tcu_usb_fi_tcl_s32_MilliSecond::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_S32_MILLISECOND;
}


tcu_usb_fi_tcl_s32_MilliSecond::~tcu_usb_fi_tcl_s32_MilliSecond()
{}

tU32 tcu_usb_fi_tcl_s32_MilliSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& tcu_usb_fi_tcl_s32_MilliSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& tcu_usb_fi_tcl_s32_MilliSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_POSIXTime::tcu_usb_fi_tcl_POSIXTime(const tcu_usb_fi_tcl_POSIXTime& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   Time = coRef.Time;
}
tcu_usb_fi_tcl_POSIXTime& tcu_usb_fi_tcl_POSIXTime::operator=(const tcu_usb_fi_tcl_POSIXTime& coRef)
{
   if (this == &coRef) return *this;
   Time = coRef.Time;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_POSIXTime::tcu_usb_fi_tcl_POSIXTime()
:Time(0)
 {}

tS32 tcu_usb_fi_tcl_POSIXTime::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_POSIXTIME;
}


tcu_usb_fi_tcl_POSIXTime::~tcu_usb_fi_tcl_POSIXTime()
{}

tU32 tcu_usb_fi_tcl_POSIXTime::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& tcu_usb_fi_tcl_POSIXTime::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Time);
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_POSIXTime::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Time);
   return oOut;
}

tBool tcu_usb_fi_tcl_POSIXTime::operator==(const tcu_usb_fi_tcl_POSIXTime& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Time == roRef.Time);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_e8_DST_State::tcu_usb_fi_tcl_e8_DST_State():enType(FI_EN_T_STANDARDTIME) {}

tS32 tcu_usb_fi_tcl_e8_DST_State::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_E8_DST_STATE;
}


tcu_usb_fi_tcl_e8_DST_State::~tcu_usb_fi_tcl_e8_DST_State()
{}

tU32 tcu_usb_fi_tcl_e8_DST_State::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_fi_tcl_e8_DST_State::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_e8_DST_State::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_TimeZoneElement::tcu_usb_fi_tcl_TimeZoneElement(const tcu_usb_fi_tcl_TimeZoneElement& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   Abbreviation_StandardTime = coRef.Abbreviation_StandardTime;
   Abbreviation_DST_in_effect = coRef.Abbreviation_DST_in_effect;
   TimeZoneDifference = coRef.TimeZoneDifference;
   DST_State = coRef.DST_State;
   DSTDifference = coRef.DSTDifference;
   DST_TimeDomain = coRef.DST_TimeDomain;
}
tcu_usb_fi_tcl_TimeZoneElement& tcu_usb_fi_tcl_TimeZoneElement::operator=(const tcu_usb_fi_tcl_TimeZoneElement& coRef)
{
   if (this == &coRef) return *this;
   Abbreviation_StandardTime = coRef.Abbreviation_StandardTime;
   Abbreviation_DST_in_effect = coRef.Abbreviation_DST_in_effect;
   TimeZoneDifference = coRef.TimeZoneDifference;
   DST_State = coRef.DST_State;
   DSTDifference = coRef.DSTDifference;
   DST_TimeDomain = coRef.DST_TimeDomain;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_fi_tcl_TimeZoneElement::vDestroy()
{
   Abbreviation_StandardTime.vDestroy();
   Abbreviation_DST_in_effect.vDestroy();
   {
   DST_TimeDomain.clear();
   }
}

tcu_usb_fi_tcl_TimeZoneElement::tcu_usb_fi_tcl_TimeZoneElement()
:Abbreviation_StandardTime(0)
,Abbreviation_DST_in_effect(0)
,TimeZoneDifference()
,DST_State()
,DSTDifference()

 {}

tS32 tcu_usb_fi_tcl_TimeZoneElement::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_TIMEZONEELEMENT;
}


tcu_usb_fi_tcl_TimeZoneElement::~tcu_usb_fi_tcl_TimeZoneElement()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_fi_tcl_TimeZoneElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 13+Abbreviation_StandardTime.u32GetSize(u16MajorVersion)+Abbreviation_DST_in_effect.u32GetSize(u16MajorVersion)+ static_cast<tU32>(DST_TimeDomain.size()*1);
}

fi_tclInContext& tcu_usb_fi_tcl_TimeZoneElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Abbreviation_StandardTime);
   (tVoid) (oIn >> Abbreviation_DST_in_effect);
   (tVoid) (oIn >> TimeZoneDifference);
   (tVoid) (oIn >> DST_State);
   (tVoid) (oIn >> DSTDifference);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      DST_TimeDomain.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DST_TimeDomain[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_TimeZoneElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Abbreviation_StandardTime);
   (tVoid) (oOut << Abbreviation_DST_in_effect);
   (tVoid) (oOut << TimeZoneDifference);
   (tVoid) (oOut << DST_State);
   (tVoid) (oOut << DSTDifference);
   (tVoid) (oOut << (tU32)DST_TimeDomain.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DST_TimeDomain.size(); ++u32Idx)
         (tVoid) (oOut << DST_TimeDomain[u32Idx]);
   }
   return oOut;
}

tBool tcu_usb_fi_tcl_TimeZoneElement::operator==(const tcu_usb_fi_tcl_TimeZoneElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Abbreviation_StandardTime == roRef.Abbreviation_StandardTime);
   bResult = bResult && (Abbreviation_DST_in_effect == roRef.Abbreviation_DST_in_effect);
   bResult = bResult && (TimeZoneDifference == roRef.TimeZoneDifference);
   bResult = bResult && (DST_State == roRef.DST_State);
   bResult = bResult && (DSTDifference == roRef.DSTDifference);
      bResult = bResult && (DST_TimeDomain.size() == roRef.DST_TimeDomain.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DST_TimeDomain.size()); ++u32Idx)
            bResult = bResult && (DST_TimeDomain[u32Idx] == roRef.DST_TimeDomain[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_s16_KmPerHour::tcu_usb_fi_tcl_s16_KmPerHour(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 tcu_usb_fi_tcl_s16_KmPerHour::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_S16_KMPERHOUR;
}


tcu_usb_fi_tcl_s16_KmPerHour::~tcu_usb_fi_tcl_s16_KmPerHour()
{}

tU32 tcu_usb_fi_tcl_s16_KmPerHour::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& tcu_usb_fi_tcl_s16_KmPerHour::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& tcu_usb_fi_tcl_s16_KmPerHour::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_s16_MilesPerHour::tcu_usb_fi_tcl_s16_MilesPerHour(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 tcu_usb_fi_tcl_s16_MilesPerHour::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_S16_MILESPERHOUR;
}


tcu_usb_fi_tcl_s16_MilesPerHour::~tcu_usb_fi_tcl_s16_MilesPerHour()
{}

tU32 tcu_usb_fi_tcl_s16_MilesPerHour::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& tcu_usb_fi_tcl_s16_MilesPerHour::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& tcu_usb_fi_tcl_s16_MilesPerHour::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_s16_Knot::tcu_usb_fi_tcl_s16_Knot(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 tcu_usb_fi_tcl_s16_Knot::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_S16_KNOT;
}


tcu_usb_fi_tcl_s16_Knot::~tcu_usb_fi_tcl_s16_Knot()
{}

tU32 tcu_usb_fi_tcl_s16_Knot::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& tcu_usb_fi_tcl_s16_Knot::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& tcu_usb_fi_tcl_s16_Knot::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_s16_CentimeterSecond::tcu_usb_fi_tcl_s16_CentimeterSecond(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 tcu_usb_fi_tcl_s16_CentimeterSecond::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_S16_CENTIMETERSECOND;
}


tcu_usb_fi_tcl_s16_CentimeterSecond::~tcu_usb_fi_tcl_s16_CentimeterSecond()
{}

tU32 tcu_usb_fi_tcl_s16_CentimeterSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& tcu_usb_fi_tcl_s16_CentimeterSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& tcu_usb_fi_tcl_s16_CentimeterSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_s16_Kelvin::tcu_usb_fi_tcl_s16_Kelvin(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 tcu_usb_fi_tcl_s16_Kelvin::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_S16_KELVIN;
}


tcu_usb_fi_tcl_s16_Kelvin::~tcu_usb_fi_tcl_s16_Kelvin()
{}

tU32 tcu_usb_fi_tcl_s16_Kelvin::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& tcu_usb_fi_tcl_s16_Kelvin::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& tcu_usb_fi_tcl_s16_Kelvin::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_s16_Fahrenheit::tcu_usb_fi_tcl_s16_Fahrenheit(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 tcu_usb_fi_tcl_s16_Fahrenheit::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_S16_FAHRENHEIT;
}


tcu_usb_fi_tcl_s16_Fahrenheit::~tcu_usb_fi_tcl_s16_Fahrenheit()
{}

tU32 tcu_usb_fi_tcl_s16_Fahrenheit::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& tcu_usb_fi_tcl_s16_Fahrenheit::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& tcu_usb_fi_tcl_s16_Fahrenheit::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_s32_Pascal::tcu_usb_fi_tcl_s32_Pascal(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 tcu_usb_fi_tcl_s32_Pascal::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_S32_PASCAL;
}


tcu_usb_fi_tcl_s32_Pascal::~tcu_usb_fi_tcl_s32_Pascal()
{}

tU32 tcu_usb_fi_tcl_s32_Pascal::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& tcu_usb_fi_tcl_s32_Pascal::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& tcu_usb_fi_tcl_s32_Pascal::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_s32_Watt::tcu_usb_fi_tcl_s32_Watt(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 tcu_usb_fi_tcl_s32_Watt::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_S32_WATT;
}


tcu_usb_fi_tcl_s32_Watt::~tcu_usb_fi_tcl_s32_Watt()
{}

tU32 tcu_usb_fi_tcl_s32_Watt::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& tcu_usb_fi_tcl_s32_Watt::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& tcu_usb_fi_tcl_s32_Watt::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_FIVersion::tcu_usb_fi_tcl_FIVersion(const tcu_usb_fi_tcl_FIVersion& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   MajorVersion = coRef.MajorVersion;
   MinorVersion = coRef.MinorVersion;
   PatchVersion = coRef.PatchVersion;
}
tcu_usb_fi_tcl_FIVersion& tcu_usb_fi_tcl_FIVersion::operator=(const tcu_usb_fi_tcl_FIVersion& coRef)
{
   if (this == &coRef) return *this;
   MajorVersion = coRef.MajorVersion;
   MinorVersion = coRef.MinorVersion;
   PatchVersion = coRef.PatchVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_FIVersion::tcu_usb_fi_tcl_FIVersion()
:MajorVersion(0)
,MinorVersion(0)
,PatchVersion(0)
 {}

tS32 tcu_usb_fi_tcl_FIVersion::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_FIVERSION;
}


tcu_usb_fi_tcl_FIVersion::~tcu_usb_fi_tcl_FIVersion()
{}

tU32 tcu_usb_fi_tcl_FIVersion::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& tcu_usb_fi_tcl_FIVersion::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MajorVersion);
   (tVoid) (oIn >> MinorVersion);
   (tVoid) (oIn >> PatchVersion);
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_FIVersion::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MajorVersion);
   (tVoid) (oOut << MinorVersion);
   (tVoid) (oOut << PatchVersion);
   return oOut;
}

tBool tcu_usb_fi_tcl_FIVersion::operator==(const tcu_usb_fi_tcl_FIVersion& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MajorVersion == roRef.MajorVersion);
   bResult = bResult && (MinorVersion == roRef.MinorVersion);
   bResult = bResult && (PatchVersion == roRef.PatchVersion);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_s32_Longitude::tcu_usb_fi_tcl_s32_Longitude(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 tcu_usb_fi_tcl_s32_Longitude::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_S32_LONGITUDE;
}


tcu_usb_fi_tcl_s32_Longitude::~tcu_usb_fi_tcl_s32_Longitude()
{}

tU32 tcu_usb_fi_tcl_s32_Longitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& tcu_usb_fi_tcl_s32_Longitude::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& tcu_usb_fi_tcl_s32_Longitude::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_s32_Latitude::tcu_usb_fi_tcl_s32_Latitude(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 tcu_usb_fi_tcl_s32_Latitude::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_S32_LATITUDE;
}


tcu_usb_fi_tcl_s32_Latitude::~tcu_usb_fi_tcl_s32_Latitude()
{}

tU32 tcu_usb_fi_tcl_s32_Latitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& tcu_usb_fi_tcl_s32_Latitude::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& tcu_usb_fi_tcl_s32_Latitude::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_PositionWGS84::tcu_usb_fi_tcl_PositionWGS84(const tcu_usb_fi_tcl_PositionWGS84& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
}
tcu_usb_fi_tcl_PositionWGS84& tcu_usb_fi_tcl_PositionWGS84::operator=(const tcu_usb_fi_tcl_PositionWGS84& coRef)
{
   if (this == &coRef) return *this;
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_PositionWGS84::tcu_usb_fi_tcl_PositionWGS84()
:Longitude()
,Latitude()
 {}

tS32 tcu_usb_fi_tcl_PositionWGS84::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_POSITIONWGS84;
}


tcu_usb_fi_tcl_PositionWGS84::~tcu_usb_fi_tcl_PositionWGS84()
{}

tU32 tcu_usb_fi_tcl_PositionWGS84::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& tcu_usb_fi_tcl_PositionWGS84::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Longitude);
   (tVoid) (oIn >> Latitude);
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_PositionWGS84::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Longitude);
   (tVoid) (oOut << Latitude);
   return oOut;
}

tBool tcu_usb_fi_tcl_PositionWGS84::operator==(const tcu_usb_fi_tcl_PositionWGS84& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Longitude == roRef.Longitude);
   bResult = bResult && (Latitude == roRef.Latitude);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_RectangleWGS84::tcu_usb_fi_tcl_RectangleWGS84(const tcu_usb_fi_tcl_RectangleWGS84& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   LongitudeMin = coRef.LongitudeMin;
   LatitudeMin = coRef.LatitudeMin;
   LongitudeMax = coRef.LongitudeMax;
   LatitudeMax = coRef.LatitudeMax;
}
tcu_usb_fi_tcl_RectangleWGS84& tcu_usb_fi_tcl_RectangleWGS84::operator=(const tcu_usb_fi_tcl_RectangleWGS84& coRef)
{
   if (this == &coRef) return *this;
   LongitudeMin = coRef.LongitudeMin;
   LatitudeMin = coRef.LatitudeMin;
   LongitudeMax = coRef.LongitudeMax;
   LatitudeMax = coRef.LatitudeMax;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_RectangleWGS84::tcu_usb_fi_tcl_RectangleWGS84()
:LongitudeMin()
,LatitudeMin()
,LongitudeMax()
,LatitudeMax()
 {}

tS32 tcu_usb_fi_tcl_RectangleWGS84::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_RECTANGLEWGS84;
}


tcu_usb_fi_tcl_RectangleWGS84::~tcu_usb_fi_tcl_RectangleWGS84()
{}

tU32 tcu_usb_fi_tcl_RectangleWGS84::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

fi_tclInContext& tcu_usb_fi_tcl_RectangleWGS84::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LongitudeMin);
   (tVoid) (oIn >> LatitudeMin);
   (tVoid) (oIn >> LongitudeMax);
   (tVoid) (oIn >> LatitudeMax);
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_RectangleWGS84::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LongitudeMin);
   (tVoid) (oOut << LatitudeMin);
   (tVoid) (oOut << LongitudeMax);
   (tVoid) (oOut << LatitudeMax);
   return oOut;
}

tBool tcu_usb_fi_tcl_RectangleWGS84::operator==(const tcu_usb_fi_tcl_RectangleWGS84& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LongitudeMin == roRef.LongitudeMin);
   bResult = bResult && (LatitudeMin == roRef.LatitudeMin);
   bResult = bResult && (LongitudeMax == roRef.LongitudeMax);
   bResult = bResult && (LatitudeMax == roRef.LatitudeMax);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_e16_ISOCountryCode::tcu_usb_fi_tcl_e16_ISOCountryCode():enType(FI_EN_ISO_ALPHA_3_UNDEFINED) {}

tS32 tcu_usb_fi_tcl_e16_ISOCountryCode::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_E16_ISOCOUNTRYCODE;
}


tcu_usb_fi_tcl_e16_ISOCountryCode::~tcu_usb_fi_tcl_e16_ISOCountryCode()
{}

tU32 tcu_usb_fi_tcl_e16_ISOCountryCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& tcu_usb_fi_tcl_e16_ISOCountryCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_e16_ISOCountryCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_e16_ISOLanguageCode::tcu_usb_fi_tcl_e16_ISOLanguageCode():enType(FI_EN_ISO_639_1_UNDEFINED) {}

tS32 tcu_usb_fi_tcl_e16_ISOLanguageCode::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_E16_ISOLANGUAGECODE;
}


tcu_usb_fi_tcl_e16_ISOLanguageCode::~tcu_usb_fi_tcl_e16_ISOLanguageCode()
{}

tU32 tcu_usb_fi_tcl_e16_ISOLanguageCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& tcu_usb_fi_tcl_e16_ISOLanguageCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_e16_ISOLanguageCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_LanguageID::tcu_usb_fi_tcl_LanguageID(const tcu_usb_fi_tcl_LanguageID& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   ISO639_LanguageCode = coRef.ISO639_LanguageCode;
   ISO3166_CountryCode = coRef.ISO3166_CountryCode;
}
tcu_usb_fi_tcl_LanguageID& tcu_usb_fi_tcl_LanguageID::operator=(const tcu_usb_fi_tcl_LanguageID& coRef)
{
   if (this == &coRef) return *this;
   ISO639_LanguageCode = coRef.ISO639_LanguageCode;
   ISO3166_CountryCode = coRef.ISO3166_CountryCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_LanguageID::tcu_usb_fi_tcl_LanguageID()
:ISO639_LanguageCode()
,ISO3166_CountryCode()
 {}

tS32 tcu_usb_fi_tcl_LanguageID::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_LANGUAGEID;
}


tcu_usb_fi_tcl_LanguageID::~tcu_usb_fi_tcl_LanguageID()
{}

tU32 tcu_usb_fi_tcl_LanguageID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& tcu_usb_fi_tcl_LanguageID::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ISO639_LanguageCode);
   (tVoid) (oIn >> ISO3166_CountryCode);
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_LanguageID::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ISO639_LanguageCode);
   (tVoid) (oOut << ISO3166_CountryCode);
   return oOut;
}

tBool tcu_usb_fi_tcl_LanguageID::operator==(const tcu_usb_fi_tcl_LanguageID& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ISO639_LanguageCode == roRef.ISO639_LanguageCode);
   bResult = bResult && (ISO3166_CountryCode == roRef.ISO3166_CountryCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_u8_DirectionAbsolute::tcu_usb_fi_tcl_u8_DirectionAbsolute(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 tcu_usb_fi_tcl_u8_DirectionAbsolute::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_U8_DIRECTIONABSOLUTE;
}


tcu_usb_fi_tcl_u8_DirectionAbsolute::~tcu_usb_fi_tcl_u8_DirectionAbsolute()
{}

tU32 tcu_usb_fi_tcl_u8_DirectionAbsolute::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_fi_tcl_u8_DirectionAbsolute::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& tcu_usb_fi_tcl_u8_DirectionAbsolute::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_u8_DirectionRelative::tcu_usb_fi_tcl_u8_DirectionRelative(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 tcu_usb_fi_tcl_u8_DirectionRelative::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_U8_DIRECTIONRELATIVE;
}


tcu_usb_fi_tcl_u8_DirectionRelative::~tcu_usb_fi_tcl_u8_DirectionRelative()
{}

tU32 tcu_usb_fi_tcl_u8_DirectionRelative::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_fi_tcl_u8_DirectionRelative::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& tcu_usb_fi_tcl_u8_DirectionRelative::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_s16_CentiDegree::tcu_usb_fi_tcl_s16_CentiDegree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 tcu_usb_fi_tcl_s16_CentiDegree::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_S16_CENTIDEGREE;
}


tcu_usb_fi_tcl_s16_CentiDegree::~tcu_usb_fi_tcl_s16_CentiDegree()
{}

tU32 tcu_usb_fi_tcl_s16_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& tcu_usb_fi_tcl_s16_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& tcu_usb_fi_tcl_s16_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_s16_Degree::tcu_usb_fi_tcl_s16_Degree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 tcu_usb_fi_tcl_s16_Degree::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_S16_DEGREE;
}


tcu_usb_fi_tcl_s16_Degree::~tcu_usb_fi_tcl_s16_Degree()
{}

tU32 tcu_usb_fi_tcl_s16_Degree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& tcu_usb_fi_tcl_s16_Degree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& tcu_usb_fi_tcl_s16_Degree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_u16_DirectionAbsolute_CentiDegree::tcu_usb_fi_tcl_u16_DirectionAbsolute_CentiDegree(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 tcu_usb_fi_tcl_u16_DirectionAbsolute_CentiDegree::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_U16_DIRECTIONABSOLUTE_CENTIDEGREE;
}


tcu_usb_fi_tcl_u16_DirectionAbsolute_CentiDegree::~tcu_usb_fi_tcl_u16_DirectionAbsolute_CentiDegree()
{}

tU32 tcu_usb_fi_tcl_u16_DirectionAbsolute_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& tcu_usb_fi_tcl_u16_DirectionAbsolute_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& tcu_usb_fi_tcl_u16_DirectionAbsolute_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_s16_DirectionRelative_CentiDegree::tcu_usb_fi_tcl_s16_DirectionRelative_CentiDegree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 tcu_usb_fi_tcl_s16_DirectionRelative_CentiDegree::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_S16_DIRECTIONRELATIVE_CENTIDEGREE;
}


tcu_usb_fi_tcl_s16_DirectionRelative_CentiDegree::~tcu_usb_fi_tcl_s16_DirectionRelative_CentiDegree()
{}

tU32 tcu_usb_fi_tcl_s16_DirectionRelative_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& tcu_usb_fi_tcl_s16_DirectionRelative_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& tcu_usb_fi_tcl_s16_DirectionRelative_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_e8_FuelType::tcu_usb_fi_tcl_e8_FuelType():enType(FI_EN_RESERVED) {}

tS32 tcu_usb_fi_tcl_e8_FuelType::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_E8_FUELTYPE;
}


tcu_usb_fi_tcl_e8_FuelType::~tcu_usb_fi_tcl_e8_FuelType()
{}

tU32 tcu_usb_fi_tcl_e8_FuelType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_fi_tcl_e8_FuelType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_e8_FuelType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_DistTimeFuel::tcu_usb_fi_tcl_DistTimeFuel(const tcu_usb_fi_tcl_DistTimeFuel& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   Distance = coRef.Distance;
   Time = coRef.Time;
   Fuel = coRef.Fuel;
}
tcu_usb_fi_tcl_DistTimeFuel& tcu_usb_fi_tcl_DistTimeFuel::operator=(const tcu_usb_fi_tcl_DistTimeFuel& coRef)
{
   if (this == &coRef) return *this;
   Distance = coRef.Distance;
   Time = coRef.Time;
   Fuel = coRef.Fuel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_DistTimeFuel::tcu_usb_fi_tcl_DistTimeFuel()
:Distance()
,Time()
,Fuel()
 {}

tS32 tcu_usb_fi_tcl_DistTimeFuel::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_DISTTIMEFUEL;
}


tcu_usb_fi_tcl_DistTimeFuel::~tcu_usb_fi_tcl_DistTimeFuel()
{}

tU32 tcu_usb_fi_tcl_DistTimeFuel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& tcu_usb_fi_tcl_DistTimeFuel::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Distance);
   (tVoid) (oIn >> Time);
   (tVoid) (oIn >> Fuel);
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_DistTimeFuel::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Distance);
   (tVoid) (oOut << Time);
   (tVoid) (oOut << Fuel);
   return oOut;
}

tBool tcu_usb_fi_tcl_DistTimeFuel::operator==(const tcu_usb_fi_tcl_DistTimeFuel& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Distance == roRef.Distance);
   bResult = bResult && (Time == roRef.Time);
   bResult = bResult && (Fuel == roRef.Fuel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_e16_DataConnectionError::tcu_usb_fi_tcl_e16_DataConnectionError():enType(FI_EN_USB_TCU_DATA_CONNECTION_ERROR_ADDITIONAL_DOWNLOAD_FAILED) {}

tS32 tcu_usb_fi_tcl_e16_DataConnectionError::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_E16_DATACONNECTIONERROR;
}


tcu_usb_fi_tcl_e16_DataConnectionError::~tcu_usb_fi_tcl_e16_DataConnectionError()
{}

tU32 tcu_usb_fi_tcl_e16_DataConnectionError::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& tcu_usb_fi_tcl_e16_DataConnectionError::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_e16_DataConnectionError::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_e8_DataConnectionStatus::tcu_usb_fi_tcl_e8_DataConnectionStatus():enType(FI_EN_USB_TCU_DATA_CONNECTION_STATUS_DISCONNECTED) {}

tS32 tcu_usb_fi_tcl_e8_DataConnectionStatus::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_E8_DATACONNECTIONSTATUS;
}


tcu_usb_fi_tcl_e8_DataConnectionStatus::~tcu_usb_fi_tcl_e8_DataConnectionStatus()
{}

tU32 tcu_usb_fi_tcl_e8_DataConnectionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_fi_tcl_e8_DataConnectionStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_e8_DataConnectionStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_e8_ServiceType::tcu_usb_fi_tcl_e8_ServiceType():enType(FI_EN_USB_TCU_SERVICE_TYPE_NONE) {}

tS32 tcu_usb_fi_tcl_e8_ServiceType::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_E8_SERVICETYPE;
}


tcu_usb_fi_tcl_e8_ServiceType::~tcu_usb_fi_tcl_e8_ServiceType()
{}

tU32 tcu_usb_fi_tcl_e8_ServiceType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_fi_tcl_e8_ServiceType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_e8_ServiceType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_usb_tcu_Charging_Stations_Request_Info::tcu_usb_fi_tcl_usb_tcu_Charging_Stations_Request_Info(const tcu_usb_fi_tcl_usb_tcu_Charging_Stations_Request_Info& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   u16MaxNumberOfPOI = coRef.u16MaxNumberOfPOI;
   u16SearchRange = coRef.u16SearchRange;
   u16XCoordinate = coRef.u16XCoordinate;
   u16YCoordinate = coRef.u16YCoordinate;
   u32MeshID = coRef.u32MeshID;
}
tcu_usb_fi_tcl_usb_tcu_Charging_Stations_Request_Info& tcu_usb_fi_tcl_usb_tcu_Charging_Stations_Request_Info::operator=(const tcu_usb_fi_tcl_usb_tcu_Charging_Stations_Request_Info& coRef)
{
   if (this == &coRef) return *this;
   u16MaxNumberOfPOI = coRef.u16MaxNumberOfPOI;
   u16SearchRange = coRef.u16SearchRange;
   u16XCoordinate = coRef.u16XCoordinate;
   u16YCoordinate = coRef.u16YCoordinate;
   u32MeshID = coRef.u32MeshID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_usb_tcu_Charging_Stations_Request_Info::tcu_usb_fi_tcl_usb_tcu_Charging_Stations_Request_Info()
:u16MaxNumberOfPOI(0)
,u16SearchRange(0)
,u16XCoordinate(0)
,u16YCoordinate(0)
,u32MeshID(0)
 {}

tS32 tcu_usb_fi_tcl_usb_tcu_Charging_Stations_Request_Info::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_USB_TCU_CHARGING_STATIONS_REQUEST_INFO;
}


tcu_usb_fi_tcl_usb_tcu_Charging_Stations_Request_Info::~tcu_usb_fi_tcl_usb_tcu_Charging_Stations_Request_Info()
{}

tU32 tcu_usb_fi_tcl_usb_tcu_Charging_Stations_Request_Info::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& tcu_usb_fi_tcl_usb_tcu_Charging_Stations_Request_Info::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16MaxNumberOfPOI);
   (tVoid) (oIn >> u16SearchRange);
   (tVoid) (oIn >> u16XCoordinate);
   (tVoid) (oIn >> u16YCoordinate);
   (tVoid) (oIn >> u32MeshID);
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_usb_tcu_Charging_Stations_Request_Info::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16MaxNumberOfPOI);
   (tVoid) (oOut << u16SearchRange);
   (tVoid) (oOut << u16XCoordinate);
   (tVoid) (oOut << u16YCoordinate);
   (tVoid) (oOut << u32MeshID);
   return oOut;
}

tBool tcu_usb_fi_tcl_usb_tcu_Charging_Stations_Request_Info::operator==(const tcu_usb_fi_tcl_usb_tcu_Charging_Stations_Request_Info& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16MaxNumberOfPOI == roRef.u16MaxNumberOfPOI);
   bResult = bResult && (u16SearchRange == roRef.u16SearchRange);
   bResult = bResult && (u16XCoordinate == roRef.u16XCoordinate);
   bResult = bResult && (u16YCoordinate == roRef.u16YCoordinate);
   bResult = bResult && (u32MeshID == roRef.u32MeshID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_usb_tcu_POIID_List::tcu_usb_fi_tcl_usb_tcu_POIID_List(const tcu_usb_fi_tcl_usb_tcu_POIID_List& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   POIIDList = coRef.POIIDList;
}
tcu_usb_fi_tcl_usb_tcu_POIID_List& tcu_usb_fi_tcl_usb_tcu_POIID_List::operator=(const tcu_usb_fi_tcl_usb_tcu_POIID_List& coRef)
{
   if (this == &coRef) return *this;
   POIIDList = coRef.POIIDList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_fi_tcl_usb_tcu_POIID_List::vDestroy()
{
   {
   POIIDList.clear();
   }
}

tcu_usb_fi_tcl_usb_tcu_POIID_List::tcu_usb_fi_tcl_usb_tcu_POIID_List()

 {}

tS32 tcu_usb_fi_tcl_usb_tcu_POIID_List::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_USB_TCU_POIID_LIST;
}


tcu_usb_fi_tcl_usb_tcu_POIID_List::~tcu_usb_fi_tcl_usb_tcu_POIID_List()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_fi_tcl_usb_tcu_POIID_List::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(POIIDList.size()*4);
}

fi_tclInContext& tcu_usb_fi_tcl_usb_tcu_POIID_List::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      POIIDList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> POIIDList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_usb_tcu_POIID_List::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)POIIDList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < POIIDList.size(); ++u32Idx)
         (tVoid) (oOut << POIIDList[u32Idx]);
   }
   return oOut;
}

tBool tcu_usb_fi_tcl_usb_tcu_POIID_List::operator==(const tcu_usb_fi_tcl_usb_tcu_POIID_List& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (POIIDList.size() == roRef.POIIDList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < POIIDList.size()); ++u32Idx)
            bResult = bResult && (POIIDList[u32Idx] == roRef.POIIDList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_usb_tcu_Vacancy_Stations_Request_Info::tcu_usb_fi_tcl_usb_tcu_Vacancy_Stations_Request_Info(const tcu_usb_fi_tcl_usb_tcu_Vacancy_Stations_Request_Info& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   u16CruisingDistance = coRef.u16CruisingDistance;
   u16Lat_second = coRef.u16Lat_second;
   u16Long_second = coRef.u16Long_second;
   u16RemainingBatteryCapacity = coRef.u16RemainingBatteryCapacity;
   u8CoordinateSystem = coRef.u8CoordinateSystem;
   u8Lat_Degree = coRef.u8Lat_Degree;
   u8Lat_minute = coRef.u8Lat_minute;
   u8Long_Degree = coRef.u8Long_Degree;
   u8Long_minute = coRef.u8Long_minute;
}
tcu_usb_fi_tcl_usb_tcu_Vacancy_Stations_Request_Info& tcu_usb_fi_tcl_usb_tcu_Vacancy_Stations_Request_Info::operator=(const tcu_usb_fi_tcl_usb_tcu_Vacancy_Stations_Request_Info& coRef)
{
   if (this == &coRef) return *this;
   u16CruisingDistance = coRef.u16CruisingDistance;
   u16Lat_second = coRef.u16Lat_second;
   u16Long_second = coRef.u16Long_second;
   u16RemainingBatteryCapacity = coRef.u16RemainingBatteryCapacity;
   u8CoordinateSystem = coRef.u8CoordinateSystem;
   u8Lat_Degree = coRef.u8Lat_Degree;
   u8Lat_minute = coRef.u8Lat_minute;
   u8Long_Degree = coRef.u8Long_Degree;
   u8Long_minute = coRef.u8Long_minute;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_usb_tcu_Vacancy_Stations_Request_Info::tcu_usb_fi_tcl_usb_tcu_Vacancy_Stations_Request_Info()
:u16CruisingDistance(0)
,u16Lat_second(0)
,u16Long_second(0)
,u16RemainingBatteryCapacity(0)
,u8CoordinateSystem(0)
,u8Lat_Degree(0)
,u8Lat_minute(0)
,u8Long_Degree(0)
,u8Long_minute(0)
 {}

tS32 tcu_usb_fi_tcl_usb_tcu_Vacancy_Stations_Request_Info::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_USB_TCU_VACANCY_STATIONS_REQUEST_INFO;
}


tcu_usb_fi_tcl_usb_tcu_Vacancy_Stations_Request_Info::~tcu_usb_fi_tcl_usb_tcu_Vacancy_Stations_Request_Info()
{}

tU32 tcu_usb_fi_tcl_usb_tcu_Vacancy_Stations_Request_Info::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& tcu_usb_fi_tcl_usb_tcu_Vacancy_Stations_Request_Info::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16CruisingDistance);
   (tVoid) (oIn >> u16Lat_second);
   (tVoid) (oIn >> u16Long_second);
   (tVoid) (oIn >> u16RemainingBatteryCapacity);
   (tVoid) (oIn >> u8CoordinateSystem);
   (tVoid) (oIn >> u8Lat_Degree);
   (tVoid) (oIn >> u8Lat_minute);
   (tVoid) (oIn >> u8Long_Degree);
   (tVoid) (oIn >> u8Long_minute);
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_usb_tcu_Vacancy_Stations_Request_Info::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16CruisingDistance);
   (tVoid) (oOut << u16Lat_second);
   (tVoid) (oOut << u16Long_second);
   (tVoid) (oOut << u16RemainingBatteryCapacity);
   (tVoid) (oOut << u8CoordinateSystem);
   (tVoid) (oOut << u8Lat_Degree);
   (tVoid) (oOut << u8Lat_minute);
   (tVoid) (oOut << u8Long_Degree);
   (tVoid) (oOut << u8Long_minute);
   return oOut;
}

tBool tcu_usb_fi_tcl_usb_tcu_Vacancy_Stations_Request_Info::operator==(const tcu_usb_fi_tcl_usb_tcu_Vacancy_Stations_Request_Info& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16CruisingDistance == roRef.u16CruisingDistance);
   bResult = bResult && (u16Lat_second == roRef.u16Lat_second);
   bResult = bResult && (u16Long_second == roRef.u16Long_second);
   bResult = bResult && (u16RemainingBatteryCapacity == roRef.u16RemainingBatteryCapacity);
   bResult = bResult && (u8CoordinateSystem == roRef.u8CoordinateSystem);
   bResult = bResult && (u8Lat_Degree == roRef.u8Lat_Degree);
   bResult = bResult && (u8Lat_minute == roRef.u8Lat_minute);
   bResult = bResult && (u8Long_Degree == roRef.u8Long_Degree);
   bResult = bResult && (u8Long_minute == roRef.u8Long_minute);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_usb_tcu_Favorite_channel_info::tcu_usb_fi_tcl_usb_tcu_Favorite_channel_info(const tcu_usb_fi_tcl_usb_tcu_Favorite_channel_info& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   strChannelName = coRef.strChannelName;
   strChannelNameForTTS = coRef.strChannelNameForTTS;
   u16ChannelID = coRef.u16ChannelID;
   u8FavoriteChannelListID = coRef.u8FavoriteChannelListID;
}
tcu_usb_fi_tcl_usb_tcu_Favorite_channel_info& tcu_usb_fi_tcl_usb_tcu_Favorite_channel_info::operator=(const tcu_usb_fi_tcl_usb_tcu_Favorite_channel_info& coRef)
{
   if (this == &coRef) return *this;
   strChannelName = coRef.strChannelName;
   strChannelNameForTTS = coRef.strChannelNameForTTS;
   u16ChannelID = coRef.u16ChannelID;
   u8FavoriteChannelListID = coRef.u8FavoriteChannelListID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_fi_tcl_usb_tcu_Favorite_channel_info::vDestroy()
{
   strChannelName.vDestroy();
   strChannelNameForTTS.vDestroy();
}

tcu_usb_fi_tcl_usb_tcu_Favorite_channel_info::tcu_usb_fi_tcl_usb_tcu_Favorite_channel_info()
:strChannelName()
,strChannelNameForTTS()
,u16ChannelID(0)
,u8FavoriteChannelListID(0)
 {}

tS32 tcu_usb_fi_tcl_usb_tcu_Favorite_channel_info::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_USB_TCU_FAVORITE_CHANNEL_INFO;
}


tcu_usb_fi_tcl_usb_tcu_Favorite_channel_info::~tcu_usb_fi_tcl_usb_tcu_Favorite_channel_info()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_fi_tcl_usb_tcu_Favorite_channel_info::u32GetSize(tU16 u16MajorVersion) const
{
   return 3+strChannelName.u32GetSize(u16MajorVersion)+strChannelNameForTTS.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_fi_tcl_usb_tcu_Favorite_channel_info::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strChannelName);
   (tVoid) (oIn >> strChannelNameForTTS);
   (tVoid) (oIn >> u16ChannelID);
   (tVoid) (oIn >> u8FavoriteChannelListID);
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_usb_tcu_Favorite_channel_info::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strChannelName);
   (tVoid) (oOut << strChannelNameForTTS);
   (tVoid) (oOut << u16ChannelID);
   (tVoid) (oOut << u8FavoriteChannelListID);
   return oOut;
}

tBool tcu_usb_fi_tcl_usb_tcu_Favorite_channel_info::operator==(const tcu_usb_fi_tcl_usb_tcu_Favorite_channel_info& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strChannelName == roRef.strChannelName);
   bResult = bResult && (strChannelNameForTTS == roRef.strChannelNameForTTS);
   bResult = bResult && (u16ChannelID == roRef.u16ChannelID);
   bResult = bResult && (u8FavoriteChannelListID == roRef.u8FavoriteChannelListID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_usb_tcu_Favorite_Feed_List::tcu_usb_fi_tcl_usb_tcu_Favorite_Feed_List(const tcu_usb_fi_tcl_usb_tcu_Favorite_Feed_List& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   FavoriteChannelInfoList = coRef.FavoriteChannelInfoList;
}
tcu_usb_fi_tcl_usb_tcu_Favorite_Feed_List& tcu_usb_fi_tcl_usb_tcu_Favorite_Feed_List::operator=(const tcu_usb_fi_tcl_usb_tcu_Favorite_Feed_List& coRef)
{
   if (this == &coRef) return *this;
   FavoriteChannelInfoList = coRef.FavoriteChannelInfoList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_fi_tcl_usb_tcu_Favorite_Feed_List::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < FavoriteChannelInfoList.size(); ++u32Idx)
         FavoriteChannelInfoList[u32Idx].vDestroy();
   FavoriteChannelInfoList.clear();
   }
}

tcu_usb_fi_tcl_usb_tcu_Favorite_Feed_List::tcu_usb_fi_tcl_usb_tcu_Favorite_Feed_List()

 {}

tS32 tcu_usb_fi_tcl_usb_tcu_Favorite_Feed_List::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_USB_TCU_FAVORITE_FEED_LIST;
}


tcu_usb_fi_tcl_usb_tcu_Favorite_Feed_List::~tcu_usb_fi_tcl_usb_tcu_Favorite_Feed_List()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_fi_tcl_usb_tcu_Favorite_Feed_List::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < FavoriteChannelInfoList.size(); ++u32ListIdx)
      u32DynamicSize += FavoriteChannelInfoList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& tcu_usb_fi_tcl_usb_tcu_Favorite_Feed_List::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < FavoriteChannelInfoList.size(); ++u32Idx)
      {
         FavoriteChannelInfoList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      FavoriteChannelInfoList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> FavoriteChannelInfoList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_usb_tcu_Favorite_Feed_List::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)FavoriteChannelInfoList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < FavoriteChannelInfoList.size(); ++u32Idx)
         (tVoid) (oOut << FavoriteChannelInfoList[u32Idx]);
   }
   return oOut;
}

tBool tcu_usb_fi_tcl_usb_tcu_Favorite_Feed_List::operator==(const tcu_usb_fi_tcl_usb_tcu_Favorite_Feed_List& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (FavoriteChannelInfoList.size() == roRef.FavoriteChannelInfoList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < FavoriteChannelInfoList.size()); ++u32Idx)
            bResult = bResult && (FavoriteChannelInfoList[u32Idx] == roRef.FavoriteChannelInfoList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_e8_TCU_ProbePermitSetting::tcu_usb_fi_tcl_e8_TCU_ProbePermitSetting():enType(FI_EN_OFF) {}

tS32 tcu_usb_fi_tcl_e8_TCU_ProbePermitSetting::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_E8_TCU_PROBEPERMITSETTING;
}


tcu_usb_fi_tcl_e8_TCU_ProbePermitSetting::~tcu_usb_fi_tcl_e8_TCU_ProbePermitSetting()
{}

tU32 tcu_usb_fi_tcl_e8_TCU_ProbePermitSetting::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_fi_tcl_e8_TCU_ProbePermitSetting::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_e8_TCU_ProbePermitSetting::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_e8_tcu_NotiResult::tcu_usb_fi_tcl_e8_tcu_NotiResult():enType(FI_EN_USB_TCU_NOTI_RESULT_TYPE_FAVORITE_UPLOAD_NG) {}

tS32 tcu_usb_fi_tcl_e8_tcu_NotiResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_E8_TCU_NOTIRESULT;
}


tcu_usb_fi_tcl_e8_tcu_NotiResult::~tcu_usb_fi_tcl_e8_tcu_NotiResult()
{}

tU32 tcu_usb_fi_tcl_e8_tcu_NotiResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_fi_tcl_e8_tcu_NotiResult::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_e8_tcu_NotiResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_e8_tcu_Authentication_Result::tcu_usb_fi_tcl_e8_tcu_Authentication_Result():enType(FI_EN_USB_TCU_AUTH_RESULT_TYPE_NG) {}

tS32 tcu_usb_fi_tcl_e8_tcu_Authentication_Result::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_E8_TCU_AUTHENTICATION_RESULT;
}


tcu_usb_fi_tcl_e8_tcu_Authentication_Result::~tcu_usb_fi_tcl_e8_tcu_Authentication_Result()
{}

tU32 tcu_usb_fi_tcl_e8_tcu_Authentication_Result::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_fi_tcl_e8_tcu_Authentication_Result::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_e8_tcu_Authentication_Result::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_e8_tcu_VICS_Response_Data::tcu_usb_fi_tcl_e8_tcu_VICS_Response_Data(const tcu_usb_fi_tcl_e8_tcu_VICS_Response_Data& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   VICSResponseData = coRef.VICSResponseData;
}
tcu_usb_fi_tcl_e8_tcu_VICS_Response_Data& tcu_usb_fi_tcl_e8_tcu_VICS_Response_Data::operator=(const tcu_usb_fi_tcl_e8_tcu_VICS_Response_Data& coRef)
{
   if (this == &coRef) return *this;
   VICSResponseData = coRef.VICSResponseData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_fi_tcl_e8_tcu_VICS_Response_Data::vDestroy()
{
   {
   VICSResponseData.clear();
   }
}

tcu_usb_fi_tcl_e8_tcu_VICS_Response_Data::tcu_usb_fi_tcl_e8_tcu_VICS_Response_Data()

 {}

tS32 tcu_usb_fi_tcl_e8_tcu_VICS_Response_Data::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_E8_TCU_VICS_RESPONSE_DATA;
}


tcu_usb_fi_tcl_e8_tcu_VICS_Response_Data::~tcu_usb_fi_tcl_e8_tcu_VICS_Response_Data()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_fi_tcl_e8_tcu_VICS_Response_Data::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(VICSResponseData.size()*1);
}

fi_tclInContext& tcu_usb_fi_tcl_e8_tcu_VICS_Response_Data::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      VICSResponseData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> VICSResponseData[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_e8_tcu_VICS_Response_Data::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)VICSResponseData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < VICSResponseData.size(); ++u32Idx)
         (tVoid) (oOut << VICSResponseData[u32Idx]);
   }
   return oOut;
}

tBool tcu_usb_fi_tcl_e8_tcu_VICS_Response_Data::operator==(const tcu_usb_fi_tcl_e8_tcu_VICS_Response_Data& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (VICSResponseData.size() == roRef.VICSResponseData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < VICSResponseData.size()); ++u32Idx)
            bResult = bResult && (VICSResponseData[u32Idx] == roRef.VICSResponseData[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_tcu_Block_Data_List::tcu_usb_fi_tcl_tcu_Block_Data_List(const tcu_usb_fi_tcl_tcu_Block_Data_List& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   u16NumberOfSecondLevelMesh = coRef.u16NumberOfSecondLevelMesh;
   u8PredectedDate = coRef.u8PredectedDate;
   u16PredectedDate = coRef.u16PredectedDate;
   u16RequestInformationType = coRef.u16RequestInformationType;
   u16Reserved = coRef.u16Reserved;
   u8InformationSourceID = coRef.u8InformationSourceID;
   SecondLevelMeshCoordinateList = coRef.SecondLevelMeshCoordinateList;
}
tcu_usb_fi_tcl_tcu_Block_Data_List& tcu_usb_fi_tcl_tcu_Block_Data_List::operator=(const tcu_usb_fi_tcl_tcu_Block_Data_List& coRef)
{
   if (this == &coRef) return *this;
   u16NumberOfSecondLevelMesh = coRef.u16NumberOfSecondLevelMesh;
   u8PredectedDate = coRef.u8PredectedDate;
   u16PredectedDate = coRef.u16PredectedDate;
   u16RequestInformationType = coRef.u16RequestInformationType;
   u16Reserved = coRef.u16Reserved;
   u8InformationSourceID = coRef.u8InformationSourceID;
   SecondLevelMeshCoordinateList = coRef.SecondLevelMeshCoordinateList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_fi_tcl_tcu_Block_Data_List::vDestroy()
{
   {
   SecondLevelMeshCoordinateList.clear();
   }
}

tcu_usb_fi_tcl_tcu_Block_Data_List::tcu_usb_fi_tcl_tcu_Block_Data_List()
:u16NumberOfSecondLevelMesh(0)
,u8PredectedDate(0)
,u16PredectedDate(0)
,u16RequestInformationType(0)
,u16Reserved(0)
,u8InformationSourceID(0)

 {}

tS32 tcu_usb_fi_tcl_tcu_Block_Data_List::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_TCU_BLOCK_DATA_LIST;
}


tcu_usb_fi_tcl_tcu_Block_Data_List::~tcu_usb_fi_tcl_tcu_Block_Data_List()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_fi_tcl_tcu_Block_Data_List::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 14+ static_cast<tU32>(SecondLevelMeshCoordinateList.size()*2);
}

fi_tclInContext& tcu_usb_fi_tcl_tcu_Block_Data_List::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16NumberOfSecondLevelMesh);
   (tVoid) (oIn >> u8PredectedDate);
   (tVoid) (oIn >> u16PredectedDate);
   (tVoid) (oIn >> u16RequestInformationType);
   (tVoid) (oIn >> u16Reserved);
   (tVoid) (oIn >> u8InformationSourceID);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      SecondLevelMeshCoordinateList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SecondLevelMeshCoordinateList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_tcu_Block_Data_List::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16NumberOfSecondLevelMesh);
   (tVoid) (oOut << u8PredectedDate);
   (tVoid) (oOut << u16PredectedDate);
   (tVoid) (oOut << u16RequestInformationType);
   (tVoid) (oOut << u16Reserved);
   (tVoid) (oOut << u8InformationSourceID);
   (tVoid) (oOut << (tU32)SecondLevelMeshCoordinateList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SecondLevelMeshCoordinateList.size(); ++u32Idx)
         (tVoid) (oOut << SecondLevelMeshCoordinateList[u32Idx]);
   }
   return oOut;
}

tBool tcu_usb_fi_tcl_tcu_Block_Data_List::operator==(const tcu_usb_fi_tcl_tcu_Block_Data_List& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16NumberOfSecondLevelMesh == roRef.u16NumberOfSecondLevelMesh);
   bResult = bResult && (u8PredectedDate == roRef.u8PredectedDate);
   bResult = bResult && (u16PredectedDate == roRef.u16PredectedDate);
   bResult = bResult && (u16RequestInformationType == roRef.u16RequestInformationType);
   bResult = bResult && (u16Reserved == roRef.u16Reserved);
   bResult = bResult && (u8InformationSourceID == roRef.u8InformationSourceID);
      bResult = bResult && (SecondLevelMeshCoordinateList.size() == roRef.SecondLevelMeshCoordinateList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SecondLevelMeshCoordinateList.size()); ++u32Idx)
            bResult = bResult && (SecondLevelMeshCoordinateList[u32Idx] == roRef.SecondLevelMeshCoordinateList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_tcu_Japan_Location::tcu_usb_fi_tcl_tcu_Japan_Location(const tcu_usb_fi_tcl_tcu_Japan_Location& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   u16SecondLevelMesh_CoordinateId = coRef.u16SecondLevelMesh_CoordinateId;
   u16SecondLevelMesh_XCoordinate = coRef.u16SecondLevelMesh_XCoordinate;
   u16SecondLevelMesh_YCoordinate = coRef.u16SecondLevelMesh_YCoordinate;
}
tcu_usb_fi_tcl_tcu_Japan_Location& tcu_usb_fi_tcl_tcu_Japan_Location::operator=(const tcu_usb_fi_tcl_tcu_Japan_Location& coRef)
{
   if (this == &coRef) return *this;
   u16SecondLevelMesh_CoordinateId = coRef.u16SecondLevelMesh_CoordinateId;
   u16SecondLevelMesh_XCoordinate = coRef.u16SecondLevelMesh_XCoordinate;
   u16SecondLevelMesh_YCoordinate = coRef.u16SecondLevelMesh_YCoordinate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_tcu_Japan_Location::tcu_usb_fi_tcl_tcu_Japan_Location()
:u16SecondLevelMesh_CoordinateId(0)
,u16SecondLevelMesh_XCoordinate(0)
,u16SecondLevelMesh_YCoordinate(0)
 {}

tS32 tcu_usb_fi_tcl_tcu_Japan_Location::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_TCU_JAPAN_LOCATION;
}


tcu_usb_fi_tcl_tcu_Japan_Location::~tcu_usb_fi_tcl_tcu_Japan_Location()
{}

tU32 tcu_usb_fi_tcl_tcu_Japan_Location::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& tcu_usb_fi_tcl_tcu_Japan_Location::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16SecondLevelMesh_CoordinateId);
   (tVoid) (oIn >> u16SecondLevelMesh_XCoordinate);
   (tVoid) (oIn >> u16SecondLevelMesh_YCoordinate);
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_tcu_Japan_Location::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16SecondLevelMesh_CoordinateId);
   (tVoid) (oOut << u16SecondLevelMesh_XCoordinate);
   (tVoid) (oOut << u16SecondLevelMesh_YCoordinate);
   return oOut;
}

tBool tcu_usb_fi_tcl_tcu_Japan_Location::operator==(const tcu_usb_fi_tcl_tcu_Japan_Location& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16SecondLevelMesh_CoordinateId == roRef.u16SecondLevelMesh_CoordinateId);
   bResult = bResult && (u16SecondLevelMesh_XCoordinate == roRef.u16SecondLevelMesh_XCoordinate);
   bResult = bResult && (u16SecondLevelMesh_YCoordinate == roRef.u16SecondLevelMesh_YCoordinate);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_tcu_navigation_setting_information::tcu_usb_fi_tcl_tcu_navigation_setting_information(const tcu_usb_fi_tcl_tcu_navigation_setting_information& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   CurrentLocationInfo = coRef.CurrentLocationInfo;
   DepartureInfo = coRef.DepartureInfo;
   DestinationInfo = coRef.DestinationInfo;
   ScrollPointInfo = coRef.ScrollPointInfo;
   u16SearchConditionInfo = coRef.u16SearchConditionInfo;
   u16VehicleDirectionInfo = coRef.u16VehicleDirectionInfo;
   u8InformationFlag = coRef.u8InformationFlag;
   u8WaypointNumber = coRef.u8WaypointNumber;
   WaypointList = coRef.WaypointList;
}
tcu_usb_fi_tcl_tcu_navigation_setting_information& tcu_usb_fi_tcl_tcu_navigation_setting_information::operator=(const tcu_usb_fi_tcl_tcu_navigation_setting_information& coRef)
{
   if (this == &coRef) return *this;
   CurrentLocationInfo = coRef.CurrentLocationInfo;
   DepartureInfo = coRef.DepartureInfo;
   DestinationInfo = coRef.DestinationInfo;
   ScrollPointInfo = coRef.ScrollPointInfo;
   u16SearchConditionInfo = coRef.u16SearchConditionInfo;
   u16VehicleDirectionInfo = coRef.u16VehicleDirectionInfo;
   u8InformationFlag = coRef.u8InformationFlag;
   u8WaypointNumber = coRef.u8WaypointNumber;
   WaypointList = coRef.WaypointList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_fi_tcl_tcu_navigation_setting_information::vDestroy()
{
   CurrentLocationInfo.vDestroy(); 
   DepartureInfo.vDestroy(); 
   DestinationInfo.vDestroy(); 
   ScrollPointInfo.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < WaypointList.size(); ++u32Idx)
         WaypointList[u32Idx].vDestroy();
   WaypointList.clear();
   }
}

tcu_usb_fi_tcl_tcu_navigation_setting_information::tcu_usb_fi_tcl_tcu_navigation_setting_information()
:CurrentLocationInfo()
,DepartureInfo()
,DestinationInfo()
,ScrollPointInfo()
,u16SearchConditionInfo(0)
,u16VehicleDirectionInfo(0)
,u8InformationFlag(0)
,u8WaypointNumber(0)

 {}

tS32 tcu_usb_fi_tcl_tcu_navigation_setting_information::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_TCU_NAVIGATION_SETTING_INFORMATION;
}


tcu_usb_fi_tcl_tcu_navigation_setting_information::~tcu_usb_fi_tcl_tcu_navigation_setting_information()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_fi_tcl_tcu_navigation_setting_information::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 34+ static_cast<tU32>(WaypointList.size()*6);
}

fi_tclInContext& tcu_usb_fi_tcl_tcu_navigation_setting_information::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CurrentLocationInfo);
   (tVoid) (oIn >> DepartureInfo);
   (tVoid) (oIn >> DestinationInfo);
   (tVoid) (oIn >> ScrollPointInfo);
   (tVoid) (oIn >> u16SearchConditionInfo);
   (tVoid) (oIn >> u16VehicleDirectionInfo);
   (tVoid) (oIn >> u8InformationFlag);
   (tVoid) (oIn >> u8WaypointNumber);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < WaypointList.size(); ++u32Idx)
      {
         WaypointList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      WaypointList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> WaypointList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_tcu_navigation_setting_information::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CurrentLocationInfo);
   (tVoid) (oOut << DepartureInfo);
   (tVoid) (oOut << DestinationInfo);
   (tVoid) (oOut << ScrollPointInfo);
   (tVoid) (oOut << u16SearchConditionInfo);
   (tVoid) (oOut << u16VehicleDirectionInfo);
   (tVoid) (oOut << u8InformationFlag);
   (tVoid) (oOut << u8WaypointNumber);
   (tVoid) (oOut << (tU32)WaypointList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < WaypointList.size(); ++u32Idx)
         (tVoid) (oOut << WaypointList[u32Idx]);
   }
   return oOut;
}

tBool tcu_usb_fi_tcl_tcu_navigation_setting_information::operator==(const tcu_usb_fi_tcl_tcu_navigation_setting_information& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CurrentLocationInfo == roRef.CurrentLocationInfo);
   bResult = bResult && (DepartureInfo == roRef.DepartureInfo);
   bResult = bResult && (DestinationInfo == roRef.DestinationInfo);
   bResult = bResult && (ScrollPointInfo == roRef.ScrollPointInfo);
   bResult = bResult && (u16SearchConditionInfo == roRef.u16SearchConditionInfo);
   bResult = bResult && (u16VehicleDirectionInfo == roRef.u16VehicleDirectionInfo);
   bResult = bResult && (u8InformationFlag == roRef.u8InformationFlag);
   bResult = bResult && (u8WaypointNumber == roRef.u8WaypointNumber);
      bResult = bResult && (WaypointList.size() == roRef.WaypointList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < WaypointList.size()); ++u32Idx)
            bResult = bResult && (WaypointList[u32Idx] == roRef.WaypointList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_json_file_path::tcu_usb_fi_tcl_json_file_path(const tcu_usb_fi_tcl_json_file_path& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   strFilePath = coRef.strFilePath;
}
tcu_usb_fi_tcl_json_file_path& tcu_usb_fi_tcl_json_file_path::operator=(const tcu_usb_fi_tcl_json_file_path& coRef)
{
   if (this == &coRef) return *this;
   strFilePath = coRef.strFilePath;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_fi_tcl_json_file_path::vDestroy()
{
   strFilePath.vDestroy();
}

tcu_usb_fi_tcl_json_file_path::tcu_usb_fi_tcl_json_file_path()
:strFilePath()
 {}

tS32 tcu_usb_fi_tcl_json_file_path::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_JSON_FILE_PATH;
}


tcu_usb_fi_tcl_json_file_path::~tcu_usb_fi_tcl_json_file_path()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_fi_tcl_json_file_path::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+strFilePath.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_fi_tcl_json_file_path::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strFilePath);
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_json_file_path::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strFilePath);
   return oOut;
}

tBool tcu_usb_fi_tcl_json_file_path::operator==(const tcu_usb_fi_tcl_json_file_path& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strFilePath == roRef.strFilePath);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_e8_tcu_LogLevel::tcu_usb_fi_tcl_e8_tcu_LogLevel():enType(FI_EN_USB_TCU_LOG_LEVEL_DEBUG) {}

tS32 tcu_usb_fi_tcl_e8_tcu_LogLevel::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_E8_TCU_LOGLEVEL;
}


tcu_usb_fi_tcl_e8_tcu_LogLevel::~tcu_usb_fi_tcl_e8_tcu_LogLevel()
{}

tU32 tcu_usb_fi_tcl_e8_tcu_LogLevel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_fi_tcl_e8_tcu_LogLevel::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_e8_tcu_LogLevel::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_e8_AutoDownloadInterval::tcu_usb_fi_tcl_e8_AutoDownloadInterval():enType(FI_EN_USB_TCU_AUTO_DOWNLOAD_INTERVAL_EVERY_120_MIN) {}

tS32 tcu_usb_fi_tcl_e8_AutoDownloadInterval::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_E8_AUTODOWNLOADINTERVAL;
}


tcu_usb_fi_tcl_e8_AutoDownloadInterval::~tcu_usb_fi_tcl_e8_AutoDownloadInterval()
{}

tU32 tcu_usb_fi_tcl_e8_AutoDownloadInterval::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_fi_tcl_e8_AutoDownloadInterval::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_e8_AutoDownloadInterval::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_e8_ConnectedSearchServiceType::tcu_usb_fi_tcl_e8_ConnectedSearchServiceType():enType(FI_EN_USB_TCU_CONNECTED_SEARCH_SERVICE_TYPE_ASSISTED_SEARCH_VIA_IVR) {}

tS32 tcu_usb_fi_tcl_e8_ConnectedSearchServiceType::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_E8_CONNECTEDSEARCHSERVICETYPE;
}


tcu_usb_fi_tcl_e8_ConnectedSearchServiceType::~tcu_usb_fi_tcl_e8_ConnectedSearchServiceType()
{}

tU32 tcu_usb_fi_tcl_e8_ConnectedSearchServiceType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_fi_tcl_e8_ConnectedSearchServiceType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_e8_ConnectedSearchServiceType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_e8_tcu_AudioActivity::tcu_usb_fi_tcl_e8_tcu_AudioActivity():enType(FI_EN_NONE) {}

tS32 tcu_usb_fi_tcl_e8_tcu_AudioActivity::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_E8_TCU_AUDIOACTIVITY;
}


tcu_usb_fi_tcl_e8_tcu_AudioActivity::~tcu_usb_fi_tcl_e8_tcu_AudioActivity()
{}

tU32 tcu_usb_fi_tcl_e8_tcu_AudioActivity::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_fi_tcl_e8_tcu_AudioActivity::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_e8_tcu_AudioActivity::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_e8_tcu_ExecType::tcu_usb_fi_tcl_e8_tcu_ExecType():enType(FI_EN_AUTO_PLAY) {}

tS32 tcu_usb_fi_tcl_e8_tcu_ExecType::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_E8_TCU_EXECTYPE;
}


tcu_usb_fi_tcl_e8_tcu_ExecType::~tcu_usb_fi_tcl_e8_tcu_ExecType()
{}

tU32 tcu_usb_fi_tcl_e8_tcu_ExecType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_fi_tcl_e8_tcu_ExecType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_e8_tcu_ExecType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_tcu_VICS_Request_Data::tcu_usb_fi_tcl_tcu_VICS_Request_Data(const tcu_usb_fi_tcl_tcu_VICS_Request_Data& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   NavigationSettingInformation = coRef.NavigationSettingInformation;
   BlockDataList = coRef.BlockDataList;
}
tcu_usb_fi_tcl_tcu_VICS_Request_Data& tcu_usb_fi_tcl_tcu_VICS_Request_Data::operator=(const tcu_usb_fi_tcl_tcu_VICS_Request_Data& coRef)
{
   if (this == &coRef) return *this;
   NavigationSettingInformation = coRef.NavigationSettingInformation;
   BlockDataList = coRef.BlockDataList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_fi_tcl_tcu_VICS_Request_Data::vDestroy()
{
   NavigationSettingInformation.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < BlockDataList.size(); ++u32Idx)
         BlockDataList[u32Idx].vDestroy();
   BlockDataList.clear();
   }
}

tcu_usb_fi_tcl_tcu_VICS_Request_Data::tcu_usb_fi_tcl_tcu_VICS_Request_Data()
:NavigationSettingInformation()

 {}

tS32 tcu_usb_fi_tcl_tcu_VICS_Request_Data::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_TCU_VICS_REQUEST_DATA;
}


tcu_usb_fi_tcl_tcu_VICS_Request_Data::~tcu_usb_fi_tcl_tcu_VICS_Request_Data()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_fi_tcl_tcu_VICS_Request_Data::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < BlockDataList.size(); ++u32ListIdx)
      u32DynamicSize += BlockDataList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4+NavigationSettingInformation.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_fi_tcl_tcu_VICS_Request_Data::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> NavigationSettingInformation);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < BlockDataList.size(); ++u32Idx)
      {
         BlockDataList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      BlockDataList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> BlockDataList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_tcu_VICS_Request_Data::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << NavigationSettingInformation);
   (tVoid) (oOut << (tU32)BlockDataList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < BlockDataList.size(); ++u32Idx)
         (tVoid) (oOut << BlockDataList[u32Idx]);
   }
   return oOut;
}

tBool tcu_usb_fi_tcl_tcu_VICS_Request_Data::operator==(const tcu_usb_fi_tcl_tcu_VICS_Request_Data& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (NavigationSettingInformation == roRef.NavigationSettingInformation);
      bResult = bResult && (BlockDataList.size() == roRef.BlockDataList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < BlockDataList.size()); ++u32Idx)
            bResult = bResult && (BlockDataList[u32Idx] == roRef.BlockDataList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_usb_tcu_Channel_definition_information::tcu_usb_fi_tcl_usb_tcu_Channel_definition_information(const tcu_usb_fi_tcl_usb_tcu_Channel_definition_information& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   strChannelName = coRef.strChannelName;
   u16ChannelIconID = coRef.u16ChannelIconID;
   u16ChannelID = coRef.u16ChannelID;
   u16FolderID = coRef.u16FolderID;
   u16SizeOfChannelDefInfo = coRef.u16SizeOfChannelDefInfo;
   u8FixedData1 = coRef.u8FixedData1;
   u8FixedData2 = coRef.u8FixedData2;
   u8FixedData3 = coRef.u8FixedData3;
   u8FixedData6 = coRef.u8FixedData6;
   u8FixedData7 = coRef.u8FixedData7;
   u8FixedData8 = coRef.u8FixedData8;
   u8FixedData9 = coRef.u8FixedData9;
   u8FlagOfChannelInfo = coRef.u8FlagOfChannelInfo;
   u8SizeOfChannelName = coRef.u8SizeOfChannelName;
   FixedData4 = coRef.FixedData4;
   FixedData5 = coRef.FixedData5;
}
tcu_usb_fi_tcl_usb_tcu_Channel_definition_information& tcu_usb_fi_tcl_usb_tcu_Channel_definition_information::operator=(const tcu_usb_fi_tcl_usb_tcu_Channel_definition_information& coRef)
{
   if (this == &coRef) return *this;
   strChannelName = coRef.strChannelName;
   u16ChannelIconID = coRef.u16ChannelIconID;
   u16ChannelID = coRef.u16ChannelID;
   u16FolderID = coRef.u16FolderID;
   u16SizeOfChannelDefInfo = coRef.u16SizeOfChannelDefInfo;
   u8FixedData1 = coRef.u8FixedData1;
   u8FixedData2 = coRef.u8FixedData2;
   u8FixedData3 = coRef.u8FixedData3;
   u8FixedData6 = coRef.u8FixedData6;
   u8FixedData7 = coRef.u8FixedData7;
   u8FixedData8 = coRef.u8FixedData8;
   u8FixedData9 = coRef.u8FixedData9;
   u8FlagOfChannelInfo = coRef.u8FlagOfChannelInfo;
   u8SizeOfChannelName = coRef.u8SizeOfChannelName;
   FixedData4 = coRef.FixedData4;
   FixedData5 = coRef.FixedData5;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_fi_tcl_usb_tcu_Channel_definition_information::vDestroy()
{
   strChannelName.vDestroy();
   {
   FixedData4.clear();
   }
   {
   FixedData5.clear();
   }
}

tcu_usb_fi_tcl_usb_tcu_Channel_definition_information::tcu_usb_fi_tcl_usb_tcu_Channel_definition_information()
:strChannelName()
,u16ChannelIconID(0)
,u16ChannelID(0)
,u16FolderID(0)
,u16SizeOfChannelDefInfo(0)
,u8FixedData1(0)
,u8FixedData2(0)
,u8FixedData3(0)
,u8FixedData6(0)
,u8FixedData7(0)
,u8FixedData8(0)
,u8FixedData9(0)
,u8FlagOfChannelInfo(0)
,u8SizeOfChannelName(0)


 {}

tS32 tcu_usb_fi_tcl_usb_tcu_Channel_definition_information::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_USB_TCU_CHANNEL_DEFINITION_INFORMATION;
}


tcu_usb_fi_tcl_usb_tcu_Channel_definition_information::~tcu_usb_fi_tcl_usb_tcu_Channel_definition_information()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_fi_tcl_usb_tcu_Channel_definition_information::u32GetSize(tU16 u16MajorVersion) const
{
   return 25+strChannelName.u32GetSize(u16MajorVersion)+ static_cast<tU32>(FixedData4.size()*1)+ static_cast<tU32>(FixedData5.size()*1);
}

fi_tclInContext& tcu_usb_fi_tcl_usb_tcu_Channel_definition_information::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strChannelName);
   (tVoid) (oIn >> u16ChannelIconID);
   (tVoid) (oIn >> u16ChannelID);
   (tVoid) (oIn >> u16FolderID);
   (tVoid) (oIn >> u16SizeOfChannelDefInfo);
   (tVoid) (oIn >> u8FixedData1);
   (tVoid) (oIn >> u8FixedData2);
   (tVoid) (oIn >> u8FixedData3);
   (tVoid) (oIn >> u8FixedData6);
   (tVoid) (oIn >> u8FixedData7);
   (tVoid) (oIn >> u8FixedData8);
   (tVoid) (oIn >> u8FixedData9);
   (tVoid) (oIn >> u8FlagOfChannelInfo);
   (tVoid) (oIn >> u8SizeOfChannelName);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      FixedData4.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> FixedData4[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      FixedData5.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> FixedData5[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_usb_tcu_Channel_definition_information::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strChannelName);
   (tVoid) (oOut << u16ChannelIconID);
   (tVoid) (oOut << u16ChannelID);
   (tVoid) (oOut << u16FolderID);
   (tVoid) (oOut << u16SizeOfChannelDefInfo);
   (tVoid) (oOut << u8FixedData1);
   (tVoid) (oOut << u8FixedData2);
   (tVoid) (oOut << u8FixedData3);
   (tVoid) (oOut << u8FixedData6);
   (tVoid) (oOut << u8FixedData7);
   (tVoid) (oOut << u8FixedData8);
   (tVoid) (oOut << u8FixedData9);
   (tVoid) (oOut << u8FlagOfChannelInfo);
   (tVoid) (oOut << u8SizeOfChannelName);
   (tVoid) (oOut << (tU32)FixedData4.size());
   {
      for (tU32 u32Idx = 0; u32Idx < FixedData4.size(); ++u32Idx)
         (tVoid) (oOut << FixedData4[u32Idx]);
   }
   (tVoid) (oOut << (tU32)FixedData5.size());
   {
      for (tU32 u32Idx = 0; u32Idx < FixedData5.size(); ++u32Idx)
         (tVoid) (oOut << FixedData5[u32Idx]);
   }
   return oOut;
}

tBool tcu_usb_fi_tcl_usb_tcu_Channel_definition_information::operator==(const tcu_usb_fi_tcl_usb_tcu_Channel_definition_information& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strChannelName == roRef.strChannelName);
   bResult = bResult && (u16ChannelIconID == roRef.u16ChannelIconID);
   bResult = bResult && (u16ChannelID == roRef.u16ChannelID);
   bResult = bResult && (u16FolderID == roRef.u16FolderID);
   bResult = bResult && (u16SizeOfChannelDefInfo == roRef.u16SizeOfChannelDefInfo);
   bResult = bResult && (u8FixedData1 == roRef.u8FixedData1);
   bResult = bResult && (u8FixedData2 == roRef.u8FixedData2);
   bResult = bResult && (u8FixedData3 == roRef.u8FixedData3);
   bResult = bResult && (u8FixedData6 == roRef.u8FixedData6);
   bResult = bResult && (u8FixedData7 == roRef.u8FixedData7);
   bResult = bResult && (u8FixedData8 == roRef.u8FixedData8);
   bResult = bResult && (u8FixedData9 == roRef.u8FixedData9);
   bResult = bResult && (u8FlagOfChannelInfo == roRef.u8FlagOfChannelInfo);
   bResult = bResult && (u8SizeOfChannelName == roRef.u8SizeOfChannelName);
      bResult = bResult && (FixedData4.size() == roRef.FixedData4.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < FixedData4.size()); ++u32Idx)
            bResult = bResult && (FixedData4[u32Idx] == roRef.FixedData4[u32Idx]);
      }
      bResult = bResult && (FixedData5.size() == roRef.FixedData5.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < FixedData5.size()); ++u32Idx)
            bResult = bResult && (FixedData5[u32Idx] == roRef.FixedData5[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_usb_tcu_Channel_Info::tcu_usb_fi_tcl_usb_tcu_Channel_Info(const tcu_usb_fi_tcl_usb_tcu_Channel_Info& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   u8ResumeDownload = coRef.u8ResumeDownload;
   u16ChannelID = coRef.u16ChannelID;
   u8ChannelContentID = coRef.u8ChannelContentID;
}
tcu_usb_fi_tcl_usb_tcu_Channel_Info& tcu_usb_fi_tcl_usb_tcu_Channel_Info::operator=(const tcu_usb_fi_tcl_usb_tcu_Channel_Info& coRef)
{
   if (this == &coRef) return *this;
   u8ResumeDownload = coRef.u8ResumeDownload;
   u16ChannelID = coRef.u16ChannelID;
   u8ChannelContentID = coRef.u8ChannelContentID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_usb_tcu_Channel_Info::tcu_usb_fi_tcl_usb_tcu_Channel_Info()
:u8ResumeDownload(0)
,u16ChannelID(0)
,u8ChannelContentID(0)
 {}

tS32 tcu_usb_fi_tcl_usb_tcu_Channel_Info::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_USB_TCU_CHANNEL_INFO;
}


tcu_usb_fi_tcl_usb_tcu_Channel_Info::~tcu_usb_fi_tcl_usb_tcu_Channel_Info()
{}

tU32 tcu_usb_fi_tcl_usb_tcu_Channel_Info::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& tcu_usb_fi_tcl_usb_tcu_Channel_Info::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8ResumeDownload);
   (tVoid) (oIn >> u16ChannelID);
   (tVoid) (oIn >> u8ChannelContentID);
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_usb_tcu_Channel_Info::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8ResumeDownload);
   (tVoid) (oOut << u16ChannelID);
   (tVoid) (oOut << u8ChannelContentID);
   return oOut;
}

tBool tcu_usb_fi_tcl_usb_tcu_Channel_Info::operator==(const tcu_usb_fi_tcl_usb_tcu_Channel_Info& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8ResumeDownload == roRef.u8ResumeDownload);
   bResult = bResult && (u16ChannelID == roRef.u16ChannelID);
   bResult = bResult && (u8ChannelContentID == roRef.u8ChannelContentID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_usb_tcu_Channel_Info_List::tcu_usb_fi_tcl_usb_tcu_Channel_Info_List(const tcu_usb_fi_tcl_usb_tcu_Channel_Info_List& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   ChannelInfoList = coRef.ChannelInfoList;
}
tcu_usb_fi_tcl_usb_tcu_Channel_Info_List& tcu_usb_fi_tcl_usb_tcu_Channel_Info_List::operator=(const tcu_usb_fi_tcl_usb_tcu_Channel_Info_List& coRef)
{
   if (this == &coRef) return *this;
   ChannelInfoList = coRef.ChannelInfoList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_fi_tcl_usb_tcu_Channel_Info_List::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ChannelInfoList.size(); ++u32Idx)
         ChannelInfoList[u32Idx].vDestroy();
   ChannelInfoList.clear();
   }
}

tcu_usb_fi_tcl_usb_tcu_Channel_Info_List::tcu_usb_fi_tcl_usb_tcu_Channel_Info_List()

 {}

tS32 tcu_usb_fi_tcl_usb_tcu_Channel_Info_List::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_USB_TCU_CHANNEL_INFO_LIST;
}


tcu_usb_fi_tcl_usb_tcu_Channel_Info_List::~tcu_usb_fi_tcl_usb_tcu_Channel_Info_List()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_fi_tcl_usb_tcu_Channel_Info_List::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(ChannelInfoList.size()*4);
}

fi_tclInContext& tcu_usb_fi_tcl_usb_tcu_Channel_Info_List::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ChannelInfoList.size(); ++u32Idx)
      {
         ChannelInfoList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ChannelInfoList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ChannelInfoList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_usb_tcu_Channel_Info_List::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ChannelInfoList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ChannelInfoList.size(); ++u32Idx)
         (tVoid) (oOut << ChannelInfoList[u32Idx]);
   }
   return oOut;
}

tBool tcu_usb_fi_tcl_usb_tcu_Channel_Info_List::operator==(const tcu_usb_fi_tcl_usb_tcu_Channel_Info_List& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ChannelInfoList.size() == roRef.ChannelInfoList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ChannelInfoList.size()); ++u32Idx)
            bResult = bResult && (ChannelInfoList[u32Idx] == roRef.ChannelInfoList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_usb_tcu_channel_master_data_header::tcu_usb_fi_tcl_usb_tcu_channel_master_data_header(const tcu_usb_fi_tcl_usb_tcu_channel_master_data_header& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   u16NumOfChannelDefInfo = coRef.u16NumOfChannelDefInfo;
   u8NumOfFolderDefInfo = coRef.u8NumOfFolderDefInfo;
}
tcu_usb_fi_tcl_usb_tcu_channel_master_data_header& tcu_usb_fi_tcl_usb_tcu_channel_master_data_header::operator=(const tcu_usb_fi_tcl_usb_tcu_channel_master_data_header& coRef)
{
   if (this == &coRef) return *this;
   u16NumOfChannelDefInfo = coRef.u16NumOfChannelDefInfo;
   u8NumOfFolderDefInfo = coRef.u8NumOfFolderDefInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_usb_tcu_channel_master_data_header::tcu_usb_fi_tcl_usb_tcu_channel_master_data_header()
:u16NumOfChannelDefInfo(0)
,u8NumOfFolderDefInfo(0)
 {}

tS32 tcu_usb_fi_tcl_usb_tcu_channel_master_data_header::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_USB_TCU_CHANNEL_MASTER_DATA_HEADER;
}


tcu_usb_fi_tcl_usb_tcu_channel_master_data_header::~tcu_usb_fi_tcl_usb_tcu_channel_master_data_header()
{}

tU32 tcu_usb_fi_tcl_usb_tcu_channel_master_data_header::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& tcu_usb_fi_tcl_usb_tcu_channel_master_data_header::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16NumOfChannelDefInfo);
   (tVoid) (oIn >> u8NumOfFolderDefInfo);
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_usb_tcu_channel_master_data_header::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16NumOfChannelDefInfo);
   (tVoid) (oOut << u8NumOfFolderDefInfo);
   return oOut;
}

tBool tcu_usb_fi_tcl_usb_tcu_channel_master_data_header::operator==(const tcu_usb_fi_tcl_usb_tcu_channel_master_data_header& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16NumOfChannelDefInfo == roRef.u16NumOfChannelDefInfo);
   bResult = bResult && (u8NumOfFolderDefInfo == roRef.u8NumOfFolderDefInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_usb_tcu_Folder_definition_information::tcu_usb_fi_tcl_usb_tcu_Folder_definition_information(const tcu_usb_fi_tcl_usb_tcu_Folder_definition_information& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   strFolderName = coRef.strFolderName;
   u16FolderIconID = coRef.u16FolderIconID;
   u16FolderID = coRef.u16FolderID;
   u16SizeOfFolderDefInfo = coRef.u16SizeOfFolderDefInfo;
   u8FixedData1 = coRef.u8FixedData1;
   u8FixedData2 = coRef.u8FixedData2;
   u8SizeOfFolderName = coRef.u8SizeOfFolderName;
}
tcu_usb_fi_tcl_usb_tcu_Folder_definition_information& tcu_usb_fi_tcl_usb_tcu_Folder_definition_information::operator=(const tcu_usb_fi_tcl_usb_tcu_Folder_definition_information& coRef)
{
   if (this == &coRef) return *this;
   strFolderName = coRef.strFolderName;
   u16FolderIconID = coRef.u16FolderIconID;
   u16FolderID = coRef.u16FolderID;
   u16SizeOfFolderDefInfo = coRef.u16SizeOfFolderDefInfo;
   u8FixedData1 = coRef.u8FixedData1;
   u8FixedData2 = coRef.u8FixedData2;
   u8SizeOfFolderName = coRef.u8SizeOfFolderName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_fi_tcl_usb_tcu_Folder_definition_information::vDestroy()
{
   strFolderName.vDestroy();
}

tcu_usb_fi_tcl_usb_tcu_Folder_definition_information::tcu_usb_fi_tcl_usb_tcu_Folder_definition_information()
:strFolderName()
,u16FolderIconID(0)
,u16FolderID(0)
,u16SizeOfFolderDefInfo(0)
,u8FixedData1(0)
,u8FixedData2(0)
,u8SizeOfFolderName(0)
 {}

tS32 tcu_usb_fi_tcl_usb_tcu_Folder_definition_information::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_USB_TCU_FOLDER_DEFINITION_INFORMATION;
}


tcu_usb_fi_tcl_usb_tcu_Folder_definition_information::~tcu_usb_fi_tcl_usb_tcu_Folder_definition_information()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_fi_tcl_usb_tcu_Folder_definition_information::u32GetSize(tU16 u16MajorVersion) const
{
   return 9+strFolderName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_fi_tcl_usb_tcu_Folder_definition_information::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strFolderName);
   (tVoid) (oIn >> u16FolderIconID);
   (tVoid) (oIn >> u16FolderID);
   (tVoid) (oIn >> u16SizeOfFolderDefInfo);
   (tVoid) (oIn >> u8FixedData1);
   (tVoid) (oIn >> u8FixedData2);
   (tVoid) (oIn >> u8SizeOfFolderName);
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_usb_tcu_Folder_definition_information::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strFolderName);
   (tVoid) (oOut << u16FolderIconID);
   (tVoid) (oOut << u16FolderID);
   (tVoid) (oOut << u16SizeOfFolderDefInfo);
   (tVoid) (oOut << u8FixedData1);
   (tVoid) (oOut << u8FixedData2);
   (tVoid) (oOut << u8SizeOfFolderName);
   return oOut;
}

tBool tcu_usb_fi_tcl_usb_tcu_Folder_definition_information::operator==(const tcu_usb_fi_tcl_usb_tcu_Folder_definition_information& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strFolderName == roRef.strFolderName);
   bResult = bResult && (u16FolderIconID == roRef.u16FolderIconID);
   bResult = bResult && (u16FolderID == roRef.u16FolderID);
   bResult = bResult && (u16SizeOfFolderDefInfo == roRef.u16SizeOfFolderDefInfo);
   bResult = bResult && (u8FixedData1 == roRef.u8FixedData1);
   bResult = bResult && (u8FixedData2 == roRef.u8FixedData2);
   bResult = bResult && (u8SizeOfFolderName == roRef.u8SizeOfFolderName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_usb_tcu_Location::tcu_usb_fi_tcl_usb_tcu_Location(const tcu_usb_fi_tcl_usb_tcu_Location& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   u16Latitude_second = coRef.u16Latitude_second;
   u16Longitude_second = coRef.u16Longitude_second;
   u8Direction = coRef.u8Direction;
   u8Latitude_degree = coRef.u8Latitude_degree;
   u8Latitude_minute = coRef.u8Latitude_minute;
   u8Longitude_Degree = coRef.u8Longitude_Degree;
   u8Longitude_minute = coRef.u8Longitude_minute;
   u8Reserved = coRef.u8Reserved;
}
tcu_usb_fi_tcl_usb_tcu_Location& tcu_usb_fi_tcl_usb_tcu_Location::operator=(const tcu_usb_fi_tcl_usb_tcu_Location& coRef)
{
   if (this == &coRef) return *this;
   u16Latitude_second = coRef.u16Latitude_second;
   u16Longitude_second = coRef.u16Longitude_second;
   u8Direction = coRef.u8Direction;
   u8Latitude_degree = coRef.u8Latitude_degree;
   u8Latitude_minute = coRef.u8Latitude_minute;
   u8Longitude_Degree = coRef.u8Longitude_Degree;
   u8Longitude_minute = coRef.u8Longitude_minute;
   u8Reserved = coRef.u8Reserved;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_usb_tcu_Location::tcu_usb_fi_tcl_usb_tcu_Location()
:u16Latitude_second(0)
,u16Longitude_second(0)
,u8Direction(0)
,u8Latitude_degree(0)
,u8Latitude_minute(0)
,u8Longitude_Degree(0)
,u8Longitude_minute(0)
,u8Reserved(0)
 {}

tS32 tcu_usb_fi_tcl_usb_tcu_Location::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_USB_TCU_LOCATION;
}


tcu_usb_fi_tcl_usb_tcu_Location::~tcu_usb_fi_tcl_usb_tcu_Location()
{}

tU32 tcu_usb_fi_tcl_usb_tcu_Location::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& tcu_usb_fi_tcl_usb_tcu_Location::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16Latitude_second);
   (tVoid) (oIn >> u16Longitude_second);
   (tVoid) (oIn >> u8Direction);
   (tVoid) (oIn >> u8Latitude_degree);
   (tVoid) (oIn >> u8Latitude_minute);
   (tVoid) (oIn >> u8Longitude_Degree);
   (tVoid) (oIn >> u8Longitude_minute);
   (tVoid) (oIn >> u8Reserved);
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_usb_tcu_Location::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16Latitude_second);
   (tVoid) (oOut << u16Longitude_second);
   (tVoid) (oOut << u8Direction);
   (tVoid) (oOut << u8Latitude_degree);
   (tVoid) (oOut << u8Latitude_minute);
   (tVoid) (oOut << u8Longitude_Degree);
   (tVoid) (oOut << u8Longitude_minute);
   (tVoid) (oOut << u8Reserved);
   return oOut;
}

tBool tcu_usb_fi_tcl_usb_tcu_Location::operator==(const tcu_usb_fi_tcl_usb_tcu_Location& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16Latitude_second == roRef.u16Latitude_second);
   bResult = bResult && (u16Longitude_second == roRef.u16Longitude_second);
   bResult = bResult && (u8Direction == roRef.u8Direction);
   bResult = bResult && (u8Latitude_degree == roRef.u8Latitude_degree);
   bResult = bResult && (u8Latitude_minute == roRef.u8Latitude_minute);
   bResult = bResult && (u8Longitude_Degree == roRef.u8Longitude_Degree);
   bResult = bResult && (u8Longitude_minute == roRef.u8Longitude_minute);
   bResult = bResult && (u8Reserved == roRef.u8Reserved);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_usb_tcu_Data_Header_Part::tcu_usb_fi_tcl_usb_tcu_Data_Header_Part(const tcu_usb_fi_tcl_usb_tcu_Data_Header_Part& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   u8NumOfPOI = coRef.u8NumOfPOI;
}
tcu_usb_fi_tcl_usb_tcu_Data_Header_Part& tcu_usb_fi_tcl_usb_tcu_Data_Header_Part::operator=(const tcu_usb_fi_tcl_usb_tcu_Data_Header_Part& coRef)
{
   if (this == &coRef) return *this;
   u8NumOfPOI = coRef.u8NumOfPOI;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_usb_tcu_Data_Header_Part::tcu_usb_fi_tcl_usb_tcu_Data_Header_Part()
:u8NumOfPOI(0)
 {}

tS32 tcu_usb_fi_tcl_usb_tcu_Data_Header_Part::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_USB_TCU_DATA_HEADER_PART;
}


tcu_usb_fi_tcl_usb_tcu_Data_Header_Part::~tcu_usb_fi_tcl_usb_tcu_Data_Header_Part()
{}

tU32 tcu_usb_fi_tcl_usb_tcu_Data_Header_Part::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_fi_tcl_usb_tcu_Data_Header_Part::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8NumOfPOI);
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_usb_tcu_Data_Header_Part::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8NumOfPOI);
   return oOut;
}

tBool tcu_usb_fi_tcl_usb_tcu_Data_Header_Part::operator==(const tcu_usb_fi_tcl_usb_tcu_Data_Header_Part& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8NumOfPOI == roRef.u8NumOfPOI);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_usb_tcu_Data_Record::tcu_usb_fi_tcl_usb_tcu_Data_Record(const tcu_usb_fi_tcl_usb_tcu_Data_Record& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   Location = coRef.Location;
   strAddress = coRef.strAddress;
   strCategory = coRef.strCategory;
   strPhoneNumber = coRef.strPhoneNumber;
   strPhoneNumberForDisp = coRef.strPhoneNumberForDisp;
   strPOIName = coRef.strPOIName;
   u8SizeOfAddress = coRef.u8SizeOfAddress;
   u8SizeOfCategory = coRef.u8SizeOfCategory;
   u8SizeOfPhoneNumber = coRef.u8SizeOfPhoneNumber;
   u8SizeOfPhoneNumberForDisp = coRef.u8SizeOfPhoneNumberForDisp;
   u8SizeOfPOIName = coRef.u8SizeOfPOIName;
}
tcu_usb_fi_tcl_usb_tcu_Data_Record& tcu_usb_fi_tcl_usb_tcu_Data_Record::operator=(const tcu_usb_fi_tcl_usb_tcu_Data_Record& coRef)
{
   if (this == &coRef) return *this;
   Location = coRef.Location;
   strAddress = coRef.strAddress;
   strCategory = coRef.strCategory;
   strPhoneNumber = coRef.strPhoneNumber;
   strPhoneNumberForDisp = coRef.strPhoneNumberForDisp;
   strPOIName = coRef.strPOIName;
   u8SizeOfAddress = coRef.u8SizeOfAddress;
   u8SizeOfCategory = coRef.u8SizeOfCategory;
   u8SizeOfPhoneNumber = coRef.u8SizeOfPhoneNumber;
   u8SizeOfPhoneNumberForDisp = coRef.u8SizeOfPhoneNumberForDisp;
   u8SizeOfPOIName = coRef.u8SizeOfPOIName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_fi_tcl_usb_tcu_Data_Record::vDestroy()
{
   Location.vDestroy(); 
   strAddress.vDestroy();
   strCategory.vDestroy();
   strPhoneNumber.vDestroy();
   strPhoneNumberForDisp.vDestroy();
   strPOIName.vDestroy();
}

tcu_usb_fi_tcl_usb_tcu_Data_Record::tcu_usb_fi_tcl_usb_tcu_Data_Record()
:Location()
,strAddress()
,strCategory()
,strPhoneNumber()
,strPhoneNumberForDisp()
,strPOIName()
,u8SizeOfAddress(0)
,u8SizeOfCategory(0)
,u8SizeOfPhoneNumber(0)
,u8SizeOfPhoneNumberForDisp(0)
,u8SizeOfPOIName(0)
 {}

tS32 tcu_usb_fi_tcl_usb_tcu_Data_Record::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_USB_TCU_DATA_RECORD;
}


tcu_usb_fi_tcl_usb_tcu_Data_Record::~tcu_usb_fi_tcl_usb_tcu_Data_Record()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_fi_tcl_usb_tcu_Data_Record::u32GetSize(tU16 u16MajorVersion) const
{
   return 15+strAddress.u32GetSize(u16MajorVersion)+strCategory.u32GetSize(u16MajorVersion)+strPhoneNumber.u32GetSize(u16MajorVersion)+strPhoneNumberForDisp.u32GetSize(u16MajorVersion)+strPOIName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_fi_tcl_usb_tcu_Data_Record::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Location);
   (tVoid) (oIn >> strAddress);
   (tVoid) (oIn >> strCategory);
   (tVoid) (oIn >> strPhoneNumber);
   (tVoid) (oIn >> strPhoneNumberForDisp);
   (tVoid) (oIn >> strPOIName);
   (tVoid) (oIn >> u8SizeOfAddress);
   (tVoid) (oIn >> u8SizeOfCategory);
   (tVoid) (oIn >> u8SizeOfPhoneNumber);
   (tVoid) (oIn >> u8SizeOfPhoneNumberForDisp);
   (tVoid) (oIn >> u8SizeOfPOIName);
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_usb_tcu_Data_Record::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Location);
   (tVoid) (oOut << strAddress);
   (tVoid) (oOut << strCategory);
   (tVoid) (oOut << strPhoneNumber);
   (tVoid) (oOut << strPhoneNumberForDisp);
   (tVoid) (oOut << strPOIName);
   (tVoid) (oOut << u8SizeOfAddress);
   (tVoid) (oOut << u8SizeOfCategory);
   (tVoid) (oOut << u8SizeOfPhoneNumber);
   (tVoid) (oOut << u8SizeOfPhoneNumberForDisp);
   (tVoid) (oOut << u8SizeOfPOIName);
   return oOut;
}

tBool tcu_usb_fi_tcl_usb_tcu_Data_Record::operator==(const tcu_usb_fi_tcl_usb_tcu_Data_Record& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Location == roRef.Location);
   bResult = bResult && (strAddress == roRef.strAddress);
   bResult = bResult && (strCategory == roRef.strCategory);
   bResult = bResult && (strPhoneNumber == roRef.strPhoneNumber);
   bResult = bResult && (strPhoneNumberForDisp == roRef.strPhoneNumberForDisp);
   bResult = bResult && (strPOIName == roRef.strPOIName);
   bResult = bResult && (u8SizeOfAddress == roRef.u8SizeOfAddress);
   bResult = bResult && (u8SizeOfCategory == roRef.u8SizeOfCategory);
   bResult = bResult && (u8SizeOfPhoneNumber == roRef.u8SizeOfPhoneNumber);
   bResult = bResult && (u8SizeOfPhoneNumberForDisp == roRef.u8SizeOfPhoneNumberForDisp);
   bResult = bResult && (u8SizeOfPOIName == roRef.u8SizeOfPOIName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_usb_tcu_channel_master_data::tcu_usb_fi_tcl_usb_tcu_channel_master_data(const tcu_usb_fi_tcl_usb_tcu_channel_master_data& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   ChannelMasterDataHeader = coRef.ChannelMasterDataHeader;
   ChannelDefinitionInformation = coRef.ChannelDefinitionInformation;
   FolderDefinitionInformation = coRef.FolderDefinitionInformation;
}
tcu_usb_fi_tcl_usb_tcu_channel_master_data& tcu_usb_fi_tcl_usb_tcu_channel_master_data::operator=(const tcu_usb_fi_tcl_usb_tcu_channel_master_data& coRef)
{
   if (this == &coRef) return *this;
   ChannelMasterDataHeader = coRef.ChannelMasterDataHeader;
   ChannelDefinitionInformation = coRef.ChannelDefinitionInformation;
   FolderDefinitionInformation = coRef.FolderDefinitionInformation;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_fi_tcl_usb_tcu_channel_master_data::vDestroy()
{
   ChannelMasterDataHeader.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < ChannelDefinitionInformation.size(); ++u32Idx)
         ChannelDefinitionInformation[u32Idx].vDestroy();
   ChannelDefinitionInformation.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < FolderDefinitionInformation.size(); ++u32Idx)
         FolderDefinitionInformation[u32Idx].vDestroy();
   FolderDefinitionInformation.clear();
   }
}

tcu_usb_fi_tcl_usb_tcu_channel_master_data::tcu_usb_fi_tcl_usb_tcu_channel_master_data()
:ChannelMasterDataHeader()


 {}

tS32 tcu_usb_fi_tcl_usb_tcu_channel_master_data::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_USB_TCU_CHANNEL_MASTER_DATA;
}


tcu_usb_fi_tcl_usb_tcu_channel_master_data::~tcu_usb_fi_tcl_usb_tcu_channel_master_data()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_fi_tcl_usb_tcu_channel_master_data::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ChannelDefinitionInformation.size(); ++u32ListIdx)
      u32DynamicSize += ChannelDefinitionInformation[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < FolderDefinitionInformation.size(); ++u32ListIdx)
      u32DynamicSize += FolderDefinitionInformation[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+11;
}

fi_tclInContext& tcu_usb_fi_tcl_usb_tcu_channel_master_data::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ChannelMasterDataHeader);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ChannelDefinitionInformation.size(); ++u32Idx)
      {
         ChannelDefinitionInformation[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ChannelDefinitionInformation.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ChannelDefinitionInformation[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < FolderDefinitionInformation.size(); ++u32Idx)
      {
         FolderDefinitionInformation[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      FolderDefinitionInformation.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> FolderDefinitionInformation[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_usb_tcu_channel_master_data::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ChannelMasterDataHeader);
   (tVoid) (oOut << (tU32)ChannelDefinitionInformation.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ChannelDefinitionInformation.size(); ++u32Idx)
         (tVoid) (oOut << ChannelDefinitionInformation[u32Idx]);
   }
   (tVoid) (oOut << (tU32)FolderDefinitionInformation.size());
   {
      for (tU32 u32Idx = 0; u32Idx < FolderDefinitionInformation.size(); ++u32Idx)
         (tVoid) (oOut << FolderDefinitionInformation[u32Idx]);
   }
   return oOut;
}

tBool tcu_usb_fi_tcl_usb_tcu_channel_master_data::operator==(const tcu_usb_fi_tcl_usb_tcu_channel_master_data& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ChannelMasterDataHeader == roRef.ChannelMasterDataHeader);
      bResult = bResult && (ChannelDefinitionInformation.size() == roRef.ChannelDefinitionInformation.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ChannelDefinitionInformation.size()); ++u32Idx)
            bResult = bResult && (ChannelDefinitionInformation[u32Idx] == roRef.ChannelDefinitionInformation[u32Idx]);
      }
      bResult = bResult && (FolderDefinitionInformation.size() == roRef.FolderDefinitionInformation.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < FolderDefinitionInformation.size()); ++u32Idx)
            bResult = bResult && (FolderDefinitionInformation[u32Idx] == roRef.FolderDefinitionInformation[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_usb_tcu_GroupA_Authorization_Info::tcu_usb_fi_tcl_usb_tcu_GroupA_Authorization_Info(const tcu_usb_fi_tcl_usb_tcu_GroupA_Authorization_Info& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   strNaviID = coRef.strNaviID;
   strSimID = coRef.strSimID;
   strVinID = coRef.strVinID;
}
tcu_usb_fi_tcl_usb_tcu_GroupA_Authorization_Info& tcu_usb_fi_tcl_usb_tcu_GroupA_Authorization_Info::operator=(const tcu_usb_fi_tcl_usb_tcu_GroupA_Authorization_Info& coRef)
{
   if (this == &coRef) return *this;
   strNaviID = coRef.strNaviID;
   strSimID = coRef.strSimID;
   strVinID = coRef.strVinID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_fi_tcl_usb_tcu_GroupA_Authorization_Info::vDestroy()
{
   strNaviID.vDestroy();
   strSimID.vDestroy();
   strVinID.vDestroy();
}

tcu_usb_fi_tcl_usb_tcu_GroupA_Authorization_Info::tcu_usb_fi_tcl_usb_tcu_GroupA_Authorization_Info()
:strNaviID()
,strSimID()
,strVinID()
 {}

tS32 tcu_usb_fi_tcl_usb_tcu_GroupA_Authorization_Info::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_USB_TCU_GROUPA_AUTHORIZATION_INFO;
}


tcu_usb_fi_tcl_usb_tcu_GroupA_Authorization_Info::~tcu_usb_fi_tcl_usb_tcu_GroupA_Authorization_Info()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_fi_tcl_usb_tcu_GroupA_Authorization_Info::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+strNaviID.u32GetSize(u16MajorVersion)+strSimID.u32GetSize(u16MajorVersion)+strVinID.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_fi_tcl_usb_tcu_GroupA_Authorization_Info::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strNaviID);
   (tVoid) (oIn >> strSimID);
   (tVoid) (oIn >> strVinID);
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_usb_tcu_GroupA_Authorization_Info::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strNaviID);
   (tVoid) (oOut << strSimID);
   (tVoid) (oOut << strVinID);
   return oOut;
}

tBool tcu_usb_fi_tcl_usb_tcu_GroupA_Authorization_Info::operator==(const tcu_usb_fi_tcl_usb_tcu_GroupA_Authorization_Info& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strNaviID == roRef.strNaviID);
   bResult = bResult && (strSimID == roRef.strSimID);
   bResult = bResult && (strVinID == roRef.strVinID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_usb_tcu_GroupA_BasicServices_Info::tcu_usb_fi_tcl_usb_tcu_GroupA_BasicServices_Info(const tcu_usb_fi_tcl_usb_tcu_GroupA_BasicServices_Info& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   strDatum = coRef.strDatum;
   strDcmVersion = coRef.strDcmVersion;
   strLanguage = coRef.strLanguage;
   strLatitude = coRef.strLatitude;
   strLongitude = coRef.strLongitude;
   strMapVersion = coRef.strMapVersion;
   strNaviSWVersion = coRef.strNaviSWVersion;
}
tcu_usb_fi_tcl_usb_tcu_GroupA_BasicServices_Info& tcu_usb_fi_tcl_usb_tcu_GroupA_BasicServices_Info::operator=(const tcu_usb_fi_tcl_usb_tcu_GroupA_BasicServices_Info& coRef)
{
   if (this == &coRef) return *this;
   strDatum = coRef.strDatum;
   strDcmVersion = coRef.strDcmVersion;
   strLanguage = coRef.strLanguage;
   strLatitude = coRef.strLatitude;
   strLongitude = coRef.strLongitude;
   strMapVersion = coRef.strMapVersion;
   strNaviSWVersion = coRef.strNaviSWVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_fi_tcl_usb_tcu_GroupA_BasicServices_Info::vDestroy()
{
   strDatum.vDestroy();
   strDcmVersion.vDestroy();
   strLanguage.vDestroy();
   strLatitude.vDestroy();
   strLongitude.vDestroy();
   strMapVersion.vDestroy();
   strNaviSWVersion.vDestroy();
}

tcu_usb_fi_tcl_usb_tcu_GroupA_BasicServices_Info::tcu_usb_fi_tcl_usb_tcu_GroupA_BasicServices_Info()
:strDatum()
,strDcmVersion()
,strLanguage()
,strLatitude()
,strLongitude()
,strMapVersion()
,strNaviSWVersion()
 {}

tS32 tcu_usb_fi_tcl_usb_tcu_GroupA_BasicServices_Info::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_USB_TCU_GROUPA_BASICSERVICES_INFO;
}


tcu_usb_fi_tcl_usb_tcu_GroupA_BasicServices_Info::~tcu_usb_fi_tcl_usb_tcu_GroupA_BasicServices_Info()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_fi_tcl_usb_tcu_GroupA_BasicServices_Info::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+strDatum.u32GetSize(u16MajorVersion)+strDcmVersion.u32GetSize(u16MajorVersion)+strLanguage.u32GetSize(u16MajorVersion)+strLatitude.u32GetSize(u16MajorVersion)+strLongitude.u32GetSize(u16MajorVersion)+strMapVersion.u32GetSize(u16MajorVersion)+strNaviSWVersion.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_fi_tcl_usb_tcu_GroupA_BasicServices_Info::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strDatum);
   (tVoid) (oIn >> strDcmVersion);
   (tVoid) (oIn >> strLanguage);
   (tVoid) (oIn >> strLatitude);
   (tVoid) (oIn >> strLongitude);
   (tVoid) (oIn >> strMapVersion);
   (tVoid) (oIn >> strNaviSWVersion);
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_usb_tcu_GroupA_BasicServices_Info::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strDatum);
   (tVoid) (oOut << strDcmVersion);
   (tVoid) (oOut << strLanguage);
   (tVoid) (oOut << strLatitude);
   (tVoid) (oOut << strLongitude);
   (tVoid) (oOut << strMapVersion);
   (tVoid) (oOut << strNaviSWVersion);
   return oOut;
}

tBool tcu_usb_fi_tcl_usb_tcu_GroupA_BasicServices_Info::operator==(const tcu_usb_fi_tcl_usb_tcu_GroupA_BasicServices_Info& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strDatum == roRef.strDatum);
   bResult = bResult && (strDcmVersion == roRef.strDcmVersion);
   bResult = bResult && (strLanguage == roRef.strLanguage);
   bResult = bResult && (strLatitude == roRef.strLatitude);
   bResult = bResult && (strLongitude == roRef.strLongitude);
   bResult = bResult && (strMapVersion == roRef.strMapVersion);
   bResult = bResult && (strNaviSWVersion == roRef.strNaviSWVersion);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_usb_tcu_GroupA_Info::tcu_usb_fi_tcl_usb_tcu_GroupA_Info(const tcu_usb_fi_tcl_usb_tcu_GroupA_Info& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   GroupA_Authorization_Info = coRef.GroupA_Authorization_Info;
   GroupA_BasicServices_Info = coRef.GroupA_BasicServices_Info;
}
tcu_usb_fi_tcl_usb_tcu_GroupA_Info& tcu_usb_fi_tcl_usb_tcu_GroupA_Info::operator=(const tcu_usb_fi_tcl_usb_tcu_GroupA_Info& coRef)
{
   if (this == &coRef) return *this;
   GroupA_Authorization_Info = coRef.GroupA_Authorization_Info;
   GroupA_BasicServices_Info = coRef.GroupA_BasicServices_Info;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_fi_tcl_usb_tcu_GroupA_Info::vDestroy()
{
   GroupA_Authorization_Info.vDestroy(); 
   GroupA_BasicServices_Info.vDestroy(); 
}

tcu_usb_fi_tcl_usb_tcu_GroupA_Info::tcu_usb_fi_tcl_usb_tcu_GroupA_Info()
:GroupA_Authorization_Info()
,GroupA_BasicServices_Info()
 {}

tS32 tcu_usb_fi_tcl_usb_tcu_GroupA_Info::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_USB_TCU_GROUPA_INFO;
}


tcu_usb_fi_tcl_usb_tcu_GroupA_Info::~tcu_usb_fi_tcl_usb_tcu_GroupA_Info()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_fi_tcl_usb_tcu_GroupA_Info::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+GroupA_Authorization_Info.u32GetSize(u16MajorVersion)+GroupA_BasicServices_Info.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_fi_tcl_usb_tcu_GroupA_Info::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GroupA_Authorization_Info);
   (tVoid) (oIn >> GroupA_BasicServices_Info);
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_usb_tcu_GroupA_Info::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GroupA_Authorization_Info);
   (tVoid) (oOut << GroupA_BasicServices_Info);
   return oOut;
}

tBool tcu_usb_fi_tcl_usb_tcu_GroupA_Info::operator==(const tcu_usb_fi_tcl_usb_tcu_GroupA_Info& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GroupA_Authorization_Info == roRef.GroupA_Authorization_Info);
   bResult = bResult && (GroupA_BasicServices_Info == roRef.GroupA_BasicServices_Info);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_usb_tcu_connected_search_result::tcu_usb_fi_tcl_usb_tcu_connected_search_result(const tcu_usb_fi_tcl_usb_tcu_connected_search_result& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   u8NumOfPOI = coRef.u8NumOfPOI;
   DataRecord = coRef.DataRecord;
}
tcu_usb_fi_tcl_usb_tcu_connected_search_result& tcu_usb_fi_tcl_usb_tcu_connected_search_result::operator=(const tcu_usb_fi_tcl_usb_tcu_connected_search_result& coRef)
{
   if (this == &coRef) return *this;
   u8NumOfPOI = coRef.u8NumOfPOI;
   DataRecord = coRef.DataRecord;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_fi_tcl_usb_tcu_connected_search_result::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DataRecord.size(); ++u32Idx)
         DataRecord[u32Idx].vDestroy();
   DataRecord.clear();
   }
}

tcu_usb_fi_tcl_usb_tcu_connected_search_result::tcu_usb_fi_tcl_usb_tcu_connected_search_result()
:u8NumOfPOI(0)

 {}

tS32 tcu_usb_fi_tcl_usb_tcu_connected_search_result::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_USB_TCU_CONNECTED_SEARCH_RESULT;
}


tcu_usb_fi_tcl_usb_tcu_connected_search_result::~tcu_usb_fi_tcl_usb_tcu_connected_search_result()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_fi_tcl_usb_tcu_connected_search_result::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < DataRecord.size(); ++u32ListIdx)
      u32DynamicSize += DataRecord[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+5;
}

fi_tclInContext& tcu_usb_fi_tcl_usb_tcu_connected_search_result::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8NumOfPOI);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DataRecord.size(); ++u32Idx)
      {
         DataRecord[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DataRecord.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DataRecord[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_usb_tcu_connected_search_result::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8NumOfPOI);
   (tVoid) (oOut << (tU32)DataRecord.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DataRecord.size(); ++u32Idx)
         (tVoid) (oOut << DataRecord[u32Idx]);
   }
   return oOut;
}

tBool tcu_usb_fi_tcl_usb_tcu_connected_search_result::operator==(const tcu_usb_fi_tcl_usb_tcu_connected_search_result& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8NumOfPOI == roRef.u8NumOfPOI);
      bResult = bResult && (DataRecord.size() == roRef.DataRecord.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DataRecord.size()); ++u32Idx)
            bResult = bResult && (DataRecord[u32Idx] == roRef.DataRecord[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_tcu_charging_spot_data::tcu_usb_fi_tcl_tcu_charging_spot_data(const tcu_usb_fi_tcl_tcu_charging_spot_data& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   Location = coRef.Location;
   strAreaCode1 = coRef.strAreaCode1;
   strAreaCode2 = coRef.strAreaCode2;
   strAreaCode3 = coRef.strAreaCode3;
   strAreaCode4 = coRef.strAreaCode4;
   strAreaCode5 = coRef.strAreaCode5;
   strAreaCode6 = coRef.strAreaCode6;
   strAreaCode7 = coRef.strAreaCode7;
   strAreaCode8 = coRef.strAreaCode8;
   strPOIName = coRef.strPOIName;
   strStreetAndHouseNo = coRef.strStreetAndHouseNo;
   strTelephonenumber = coRef.strTelephonenumber;
   u16Categorycode = coRef.u16Categorycode;
   u16ClosedhourInformation = coRef.u16ClosedhourInformation;
   u16OpeninghourInformation = coRef.u16OpeninghourInformation;
   u16Parkingnumber = coRef.u16Parkingnumber;
   u16Paymenttypeinformation = coRef.u16Paymenttypeinformation;
   u16Sizeofdetailinformation = coRef.u16Sizeofdetailinformation;
   u16Subcategorycode = coRef.u16Subcategorycode;
   u32POIID = coRef.u32POIID;
   u32UserrestrictionID = coRef.u32UserrestrictionID;
   u8_24hoursadayinformation = coRef.u8_24hoursadayinformation;
   u8Businessdayoftheweekinformation = coRef.u8Businessdayoftheweekinformation;
   u8Chargingfeeinformation = coRef.u8Chargingfeeinformation;
   u8Chargingtype = coRef.u8Chargingtype;
   u8Detailsinformation = coRef.u8Detailsinformation;
   u8Entranceinformation = coRef.u8Entranceinformation;
   u8Expresswaygeneraltype = coRef.u8Expresswaygeneraltype;
   u8Fixedvalue1 = coRef.u8Fixedvalue1;
   u8Fixedvalue2 = coRef.u8Fixedvalue2;
   u8Informationreliability = coRef.u8Informationreliability;
   u8Installationfacilityinformation = coRef.u8Installationfacilityinformation;
   u8Nearthefacilityinformation = coRef.u8Nearthefacilityinformation;
   u8Officehoursunknowninformation = coRef.u8Officehoursunknowninformation;
   u8Partnersfacilityinformation = coRef.u8Partnersfacilityinformation;
   u8SizeOfPOIName = coRef.u8SizeOfPOIName;
   u8SizeOfStreetAndHouseNo = coRef.u8SizeOfStreetAndHouseNo;
   u8SizeOfTelephonenumber = coRef.u8SizeOfTelephonenumber;
   u8Thenumberofentranceinformation = coRef.u8Thenumberofentranceinformation;
   u8Thenumberofinstallationfacilityinformation = coRef.u8Thenumberofinstallationfacilityinformation;
   u8Thenumberofpartnersfacilityinformation = coRef.u8Thenumberofpartnersfacilityinformation;
   u8Thetotalnumberofchargingtype = coRef.u8Thetotalnumberofchargingtype;
   u8Userrestriction = coRef.u8Userrestriction;
}
tcu_usb_fi_tcl_tcu_charging_spot_data& tcu_usb_fi_tcl_tcu_charging_spot_data::operator=(const tcu_usb_fi_tcl_tcu_charging_spot_data& coRef)
{
   if (this == &coRef) return *this;
   Location = coRef.Location;
   strAreaCode1 = coRef.strAreaCode1;
   strAreaCode2 = coRef.strAreaCode2;
   strAreaCode3 = coRef.strAreaCode3;
   strAreaCode4 = coRef.strAreaCode4;
   strAreaCode5 = coRef.strAreaCode5;
   strAreaCode6 = coRef.strAreaCode6;
   strAreaCode7 = coRef.strAreaCode7;
   strAreaCode8 = coRef.strAreaCode8;
   strPOIName = coRef.strPOIName;
   strStreetAndHouseNo = coRef.strStreetAndHouseNo;
   strTelephonenumber = coRef.strTelephonenumber;
   u16Categorycode = coRef.u16Categorycode;
   u16ClosedhourInformation = coRef.u16ClosedhourInformation;
   u16OpeninghourInformation = coRef.u16OpeninghourInformation;
   u16Parkingnumber = coRef.u16Parkingnumber;
   u16Paymenttypeinformation = coRef.u16Paymenttypeinformation;
   u16Sizeofdetailinformation = coRef.u16Sizeofdetailinformation;
   u16Subcategorycode = coRef.u16Subcategorycode;
   u32POIID = coRef.u32POIID;
   u32UserrestrictionID = coRef.u32UserrestrictionID;
   u8_24hoursadayinformation = coRef.u8_24hoursadayinformation;
   u8Businessdayoftheweekinformation = coRef.u8Businessdayoftheweekinformation;
   u8Chargingfeeinformation = coRef.u8Chargingfeeinformation;
   u8Chargingtype = coRef.u8Chargingtype;
   u8Detailsinformation = coRef.u8Detailsinformation;
   u8Entranceinformation = coRef.u8Entranceinformation;
   u8Expresswaygeneraltype = coRef.u8Expresswaygeneraltype;
   u8Fixedvalue1 = coRef.u8Fixedvalue1;
   u8Fixedvalue2 = coRef.u8Fixedvalue2;
   u8Informationreliability = coRef.u8Informationreliability;
   u8Installationfacilityinformation = coRef.u8Installationfacilityinformation;
   u8Nearthefacilityinformation = coRef.u8Nearthefacilityinformation;
   u8Officehoursunknowninformation = coRef.u8Officehoursunknowninformation;
   u8Partnersfacilityinformation = coRef.u8Partnersfacilityinformation;
   u8SizeOfPOIName = coRef.u8SizeOfPOIName;
   u8SizeOfStreetAndHouseNo = coRef.u8SizeOfStreetAndHouseNo;
   u8SizeOfTelephonenumber = coRef.u8SizeOfTelephonenumber;
   u8Thenumberofentranceinformation = coRef.u8Thenumberofentranceinformation;
   u8Thenumberofinstallationfacilityinformation = coRef.u8Thenumberofinstallationfacilityinformation;
   u8Thenumberofpartnersfacilityinformation = coRef.u8Thenumberofpartnersfacilityinformation;
   u8Thetotalnumberofchargingtype = coRef.u8Thetotalnumberofchargingtype;
   u8Userrestriction = coRef.u8Userrestriction;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_fi_tcl_tcu_charging_spot_data::vDestroy()
{
   Location.vDestroy(); 
   strAreaCode1.vDestroy();
   strAreaCode2.vDestroy();
   strAreaCode3.vDestroy();
   strAreaCode4.vDestroy();
   strAreaCode5.vDestroy();
   strAreaCode6.vDestroy();
   strAreaCode7.vDestroy();
   strAreaCode8.vDestroy();
   strPOIName.vDestroy();
   strStreetAndHouseNo.vDestroy();
   strTelephonenumber.vDestroy();
}

tcu_usb_fi_tcl_tcu_charging_spot_data::tcu_usb_fi_tcl_tcu_charging_spot_data()
:Location()
,strAreaCode1()
,strAreaCode2()
,strAreaCode3()
,strAreaCode4()
,strAreaCode5()
,strAreaCode6()
,strAreaCode7()
,strAreaCode8()
,strPOIName()
,strStreetAndHouseNo()
,strTelephonenumber()
,u16Categorycode(0)
,u16ClosedhourInformation(0)
,u16OpeninghourInformation(0)
,u16Parkingnumber(0)
,u16Paymenttypeinformation(0)
,u16Sizeofdetailinformation(0)
,u16Subcategorycode(0)
,u32POIID(0)
,u32UserrestrictionID(0)
,u8_24hoursadayinformation(0)
,u8Businessdayoftheweekinformation(0)
,u8Chargingfeeinformation(0)
,u8Chargingtype(0)
,u8Detailsinformation(0)
,u8Entranceinformation(0)
,u8Expresswaygeneraltype(0)
,u8Fixedvalue1(0)
,u8Fixedvalue2(0)
,u8Informationreliability(0)
,u8Installationfacilityinformation(0)
,u8Nearthefacilityinformation(0)
,u8Officehoursunknowninformation(0)
,u8Partnersfacilityinformation(0)
,u8SizeOfPOIName(0)
,u8SizeOfStreetAndHouseNo(0)
,u8SizeOfTelephonenumber(0)
,u8Thenumberofentranceinformation(0)
,u8Thenumberofinstallationfacilityinformation(0)
,u8Thenumberofpartnersfacilityinformation(0)
,u8Thetotalnumberofchargingtype(0)
,u8Userrestriction(0)
 {}

tS32 tcu_usb_fi_tcl_tcu_charging_spot_data::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_TCU_CHARGING_SPOT_DATA;
}


tcu_usb_fi_tcl_tcu_charging_spot_data::~tcu_usb_fi_tcl_tcu_charging_spot_data()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_fi_tcl_tcu_charging_spot_data::u32GetSize(tU16 u16MajorVersion) const
{
   return 54+strAreaCode1.u32GetSize(u16MajorVersion)+strAreaCode2.u32GetSize(u16MajorVersion)+strAreaCode3.u32GetSize(u16MajorVersion)+strAreaCode4.u32GetSize(u16MajorVersion)+strAreaCode5.u32GetSize(u16MajorVersion)+strAreaCode6.u32GetSize(u16MajorVersion)+strAreaCode7.u32GetSize(u16MajorVersion)+strAreaCode8.u32GetSize(u16MajorVersion)+strPOIName.u32GetSize(u16MajorVersion)+strStreetAndHouseNo.u32GetSize(u16MajorVersion)+strTelephonenumber.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_fi_tcl_tcu_charging_spot_data::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Location);
   (tVoid) (oIn >> strAreaCode1);
   (tVoid) (oIn >> strAreaCode2);
   (tVoid) (oIn >> strAreaCode3);
   (tVoid) (oIn >> strAreaCode4);
   (tVoid) (oIn >> strAreaCode5);
   (tVoid) (oIn >> strAreaCode6);
   (tVoid) (oIn >> strAreaCode7);
   (tVoid) (oIn >> strAreaCode8);
   (tVoid) (oIn >> strPOIName);
   (tVoid) (oIn >> strStreetAndHouseNo);
   (tVoid) (oIn >> strTelephonenumber);
   (tVoid) (oIn >> u16Categorycode);
   (tVoid) (oIn >> u16ClosedhourInformation);
   (tVoid) (oIn >> u16OpeninghourInformation);
   (tVoid) (oIn >> u16Parkingnumber);
   (tVoid) (oIn >> u16Paymenttypeinformation);
   (tVoid) (oIn >> u16Sizeofdetailinformation);
   (tVoid) (oIn >> u16Subcategorycode);
   (tVoid) (oIn >> u32POIID);
   (tVoid) (oIn >> u32UserrestrictionID);
   (tVoid) (oIn >> u8_24hoursadayinformation);
   (tVoid) (oIn >> u8Businessdayoftheweekinformation);
   (tVoid) (oIn >> u8Chargingfeeinformation);
   (tVoid) (oIn >> u8Chargingtype);
   (tVoid) (oIn >> u8Detailsinformation);
   (tVoid) (oIn >> u8Entranceinformation);
   (tVoid) (oIn >> u8Expresswaygeneraltype);
   (tVoid) (oIn >> u8Fixedvalue1);
   (tVoid) (oIn >> u8Fixedvalue2);
   (tVoid) (oIn >> u8Informationreliability);
   (tVoid) (oIn >> u8Installationfacilityinformation);
   (tVoid) (oIn >> u8Nearthefacilityinformation);
   (tVoid) (oIn >> u8Officehoursunknowninformation);
   (tVoid) (oIn >> u8Partnersfacilityinformation);
   (tVoid) (oIn >> u8SizeOfPOIName);
   (tVoid) (oIn >> u8SizeOfStreetAndHouseNo);
   (tVoid) (oIn >> u8SizeOfTelephonenumber);
   (tVoid) (oIn >> u8Thenumberofentranceinformation);
   (tVoid) (oIn >> u8Thenumberofinstallationfacilityinformation);
   (tVoid) (oIn >> u8Thenumberofpartnersfacilityinformation);
   (tVoid) (oIn >> u8Thetotalnumberofchargingtype);
   (tVoid) (oIn >> u8Userrestriction);
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_tcu_charging_spot_data::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Location);
   (tVoid) (oOut << strAreaCode1);
   (tVoid) (oOut << strAreaCode2);
   (tVoid) (oOut << strAreaCode3);
   (tVoid) (oOut << strAreaCode4);
   (tVoid) (oOut << strAreaCode5);
   (tVoid) (oOut << strAreaCode6);
   (tVoid) (oOut << strAreaCode7);
   (tVoid) (oOut << strAreaCode8);
   (tVoid) (oOut << strPOIName);
   (tVoid) (oOut << strStreetAndHouseNo);
   (tVoid) (oOut << strTelephonenumber);
   (tVoid) (oOut << u16Categorycode);
   (tVoid) (oOut << u16ClosedhourInformation);
   (tVoid) (oOut << u16OpeninghourInformation);
   (tVoid) (oOut << u16Parkingnumber);
   (tVoid) (oOut << u16Paymenttypeinformation);
   (tVoid) (oOut << u16Sizeofdetailinformation);
   (tVoid) (oOut << u16Subcategorycode);
   (tVoid) (oOut << u32POIID);
   (tVoid) (oOut << u32UserrestrictionID);
   (tVoid) (oOut << u8_24hoursadayinformation);
   (tVoid) (oOut << u8Businessdayoftheweekinformation);
   (tVoid) (oOut << u8Chargingfeeinformation);
   (tVoid) (oOut << u8Chargingtype);
   (tVoid) (oOut << u8Detailsinformation);
   (tVoid) (oOut << u8Entranceinformation);
   (tVoid) (oOut << u8Expresswaygeneraltype);
   (tVoid) (oOut << u8Fixedvalue1);
   (tVoid) (oOut << u8Fixedvalue2);
   (tVoid) (oOut << u8Informationreliability);
   (tVoid) (oOut << u8Installationfacilityinformation);
   (tVoid) (oOut << u8Nearthefacilityinformation);
   (tVoid) (oOut << u8Officehoursunknowninformation);
   (tVoid) (oOut << u8Partnersfacilityinformation);
   (tVoid) (oOut << u8SizeOfPOIName);
   (tVoid) (oOut << u8SizeOfStreetAndHouseNo);
   (tVoid) (oOut << u8SizeOfTelephonenumber);
   (tVoid) (oOut << u8Thenumberofentranceinformation);
   (tVoid) (oOut << u8Thenumberofinstallationfacilityinformation);
   (tVoid) (oOut << u8Thenumberofpartnersfacilityinformation);
   (tVoid) (oOut << u8Thetotalnumberofchargingtype);
   (tVoid) (oOut << u8Userrestriction);
   return oOut;
}

tBool tcu_usb_fi_tcl_tcu_charging_spot_data::operator==(const tcu_usb_fi_tcl_tcu_charging_spot_data& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Location == roRef.Location);
   bResult = bResult && (strAreaCode1 == roRef.strAreaCode1);
   bResult = bResult && (strAreaCode2 == roRef.strAreaCode2);
   bResult = bResult && (strAreaCode3 == roRef.strAreaCode3);
   bResult = bResult && (strAreaCode4 == roRef.strAreaCode4);
   bResult = bResult && (strAreaCode5 == roRef.strAreaCode5);
   bResult = bResult && (strAreaCode6 == roRef.strAreaCode6);
   bResult = bResult && (strAreaCode7 == roRef.strAreaCode7);
   bResult = bResult && (strAreaCode8 == roRef.strAreaCode8);
   bResult = bResult && (strPOIName == roRef.strPOIName);
   bResult = bResult && (strStreetAndHouseNo == roRef.strStreetAndHouseNo);
   bResult = bResult && (strTelephonenumber == roRef.strTelephonenumber);
   bResult = bResult && (u16Categorycode == roRef.u16Categorycode);
   bResult = bResult && (u16ClosedhourInformation == roRef.u16ClosedhourInformation);
   bResult = bResult && (u16OpeninghourInformation == roRef.u16OpeninghourInformation);
   bResult = bResult && (u16Parkingnumber == roRef.u16Parkingnumber);
   bResult = bResult && (u16Paymenttypeinformation == roRef.u16Paymenttypeinformation);
   bResult = bResult && (u16Sizeofdetailinformation == roRef.u16Sizeofdetailinformation);
   bResult = bResult && (u16Subcategorycode == roRef.u16Subcategorycode);
   bResult = bResult && (u32POIID == roRef.u32POIID);
   bResult = bResult && (u32UserrestrictionID == roRef.u32UserrestrictionID);
   bResult = bResult && (u8_24hoursadayinformation == roRef.u8_24hoursadayinformation);
   bResult = bResult && (u8Businessdayoftheweekinformation == roRef.u8Businessdayoftheweekinformation);
   bResult = bResult && (u8Chargingfeeinformation == roRef.u8Chargingfeeinformation);
   bResult = bResult && (u8Chargingtype == roRef.u8Chargingtype);
   bResult = bResult && (u8Detailsinformation == roRef.u8Detailsinformation);
   bResult = bResult && (u8Entranceinformation == roRef.u8Entranceinformation);
   bResult = bResult && (u8Expresswaygeneraltype == roRef.u8Expresswaygeneraltype);
   bResult = bResult && (u8Fixedvalue1 == roRef.u8Fixedvalue1);
   bResult = bResult && (u8Fixedvalue2 == roRef.u8Fixedvalue2);
   bResult = bResult && (u8Informationreliability == roRef.u8Informationreliability);
   bResult = bResult && (u8Installationfacilityinformation == roRef.u8Installationfacilityinformation);
   bResult = bResult && (u8Nearthefacilityinformation == roRef.u8Nearthefacilityinformation);
   bResult = bResult && (u8Officehoursunknowninformation == roRef.u8Officehoursunknowninformation);
   bResult = bResult && (u8Partnersfacilityinformation == roRef.u8Partnersfacilityinformation);
   bResult = bResult && (u8SizeOfPOIName == roRef.u8SizeOfPOIName);
   bResult = bResult && (u8SizeOfStreetAndHouseNo == roRef.u8SizeOfStreetAndHouseNo);
   bResult = bResult && (u8SizeOfTelephonenumber == roRef.u8SizeOfTelephonenumber);
   bResult = bResult && (u8Thenumberofentranceinformation == roRef.u8Thenumberofentranceinformation);
   bResult = bResult && (u8Thenumberofinstallationfacilityinformation == roRef.u8Thenumberofinstallationfacilityinformation);
   bResult = bResult && (u8Thenumberofpartnersfacilityinformation == roRef.u8Thenumberofpartnersfacilityinformation);
   bResult = bResult && (u8Thetotalnumberofchargingtype == roRef.u8Thetotalnumberofchargingtype);
   bResult = bResult && (u8Userrestriction == roRef.u8Userrestriction);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_tcu_response_charging_spot_data_result::tcu_usb_fi_tcl_tcu_response_charging_spot_data_result(const tcu_usb_fi_tcl_tcu_response_charging_spot_data_result& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   ChargingSpotData = coRef.ChargingSpotData;
}
tcu_usb_fi_tcl_tcu_response_charging_spot_data_result& tcu_usb_fi_tcl_tcu_response_charging_spot_data_result::operator=(const tcu_usb_fi_tcl_tcu_response_charging_spot_data_result& coRef)
{
   if (this == &coRef) return *this;
   ChargingSpotData = coRef.ChargingSpotData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_fi_tcl_tcu_response_charging_spot_data_result::vDestroy()
{
   ChargingSpotData.vDestroy(); 
}

tcu_usb_fi_tcl_tcu_response_charging_spot_data_result::tcu_usb_fi_tcl_tcu_response_charging_spot_data_result()
:ChargingSpotData()
 {}

tS32 tcu_usb_fi_tcl_tcu_response_charging_spot_data_result::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_TCU_RESPONSE_CHARGING_SPOT_DATA_RESULT;
}


tcu_usb_fi_tcl_tcu_response_charging_spot_data_result::~tcu_usb_fi_tcl_tcu_response_charging_spot_data_result()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_fi_tcl_tcu_response_charging_spot_data_result::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+ChargingSpotData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_fi_tcl_tcu_response_charging_spot_data_result::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ChargingSpotData);
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_tcu_response_charging_spot_data_result::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ChargingSpotData);
   return oOut;
}

tBool tcu_usb_fi_tcl_tcu_response_charging_spot_data_result::operator==(const tcu_usb_fi_tcl_tcu_response_charging_spot_data_result& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ChargingSpotData == roRef.ChargingSpotData);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_tcu_charging_stations_info::tcu_usb_fi_tcl_tcu_charging_stations_info(const tcu_usb_fi_tcl_tcu_charging_stations_info& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   Location = coRef.Location;
   u32POIID = coRef.u32POIID;
   u32POIIDVersion = coRef.u32POIIDVersion;
}
tcu_usb_fi_tcl_tcu_charging_stations_info& tcu_usb_fi_tcl_tcu_charging_stations_info::operator=(const tcu_usb_fi_tcl_tcu_charging_stations_info& coRef)
{
   if (this == &coRef) return *this;
   Location = coRef.Location;
   u32POIID = coRef.u32POIID;
   u32POIIDVersion = coRef.u32POIIDVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_tcu_charging_stations_info::tcu_usb_fi_tcl_tcu_charging_stations_info()
:Location()
,u32POIID(0)
,u32POIIDVersion(0)
 {}

tS32 tcu_usb_fi_tcl_tcu_charging_stations_info::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_TCU_CHARGING_STATIONS_INFO;
}


tcu_usb_fi_tcl_tcu_charging_stations_info::~tcu_usb_fi_tcl_tcu_charging_stations_info()
{}

tU32 tcu_usb_fi_tcl_tcu_charging_stations_info::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 18;
}

fi_tclInContext& tcu_usb_fi_tcl_tcu_charging_stations_info::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Location);
   (tVoid) (oIn >> u32POIID);
   (tVoid) (oIn >> u32POIIDVersion);
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_tcu_charging_stations_info::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Location);
   (tVoid) (oOut << u32POIID);
   (tVoid) (oOut << u32POIIDVersion);
   return oOut;
}

tBool tcu_usb_fi_tcl_tcu_charging_stations_info::operator==(const tcu_usb_fi_tcl_tcu_charging_stations_info& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Location == roRef.Location);
   bResult = bResult && (u32POIID == roRef.u32POIID);
   bResult = bResult && (u32POIIDVersion == roRef.u32POIIDVersion);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_tcu_charging_stations_data::tcu_usb_fi_tcl_tcu_charging_stations_data(const tcu_usb_fi_tcl_tcu_charging_stations_data& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   u32NumberOfPOIID = coRef.u32NumberOfPOIID;
   u32POIDataSetIdentificationID = coRef.u32POIDataSetIdentificationID;
   u8POIDataSetIdentificationIDType = coRef.u8POIDataSetIdentificationIDType;
   ChargingStationsInfoList = coRef.ChargingStationsInfoList;
}
tcu_usb_fi_tcl_tcu_charging_stations_data& tcu_usb_fi_tcl_tcu_charging_stations_data::operator=(const tcu_usb_fi_tcl_tcu_charging_stations_data& coRef)
{
   if (this == &coRef) return *this;
   u32NumberOfPOIID = coRef.u32NumberOfPOIID;
   u32POIDataSetIdentificationID = coRef.u32POIDataSetIdentificationID;
   u8POIDataSetIdentificationIDType = coRef.u8POIDataSetIdentificationIDType;
   ChargingStationsInfoList = coRef.ChargingStationsInfoList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_fi_tcl_tcu_charging_stations_data::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ChargingStationsInfoList.size(); ++u32Idx)
         ChargingStationsInfoList[u32Idx].vDestroy();
   ChargingStationsInfoList.clear();
   }
}

tcu_usb_fi_tcl_tcu_charging_stations_data::tcu_usb_fi_tcl_tcu_charging_stations_data()
:u32NumberOfPOIID(0)
,u32POIDataSetIdentificationID(0)
,u8POIDataSetIdentificationIDType(0)

 {}

tS32 tcu_usb_fi_tcl_tcu_charging_stations_data::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_TCU_CHARGING_STATIONS_DATA;
}


tcu_usb_fi_tcl_tcu_charging_stations_data::~tcu_usb_fi_tcl_tcu_charging_stations_data()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_fi_tcl_tcu_charging_stations_data::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13+ static_cast<tU32>(ChargingStationsInfoList.size()*18);
}

fi_tclInContext& tcu_usb_fi_tcl_tcu_charging_stations_data::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32NumberOfPOIID);
   (tVoid) (oIn >> u32POIDataSetIdentificationID);
   (tVoid) (oIn >> u8POIDataSetIdentificationIDType);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ChargingStationsInfoList.size(); ++u32Idx)
      {
         ChargingStationsInfoList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ChargingStationsInfoList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ChargingStationsInfoList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_tcu_charging_stations_data::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32NumberOfPOIID);
   (tVoid) (oOut << u32POIDataSetIdentificationID);
   (tVoid) (oOut << u8POIDataSetIdentificationIDType);
   (tVoid) (oOut << (tU32)ChargingStationsInfoList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ChargingStationsInfoList.size(); ++u32Idx)
         (tVoid) (oOut << ChargingStationsInfoList[u32Idx]);
   }
   return oOut;
}

tBool tcu_usb_fi_tcl_tcu_charging_stations_data::operator==(const tcu_usb_fi_tcl_tcu_charging_stations_data& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32NumberOfPOIID == roRef.u32NumberOfPOIID);
   bResult = bResult && (u32POIDataSetIdentificationID == roRef.u32POIDataSetIdentificationID);
   bResult = bResult && (u8POIDataSetIdentificationIDType == roRef.u8POIDataSetIdentificationIDType);
      bResult = bResult && (ChargingStationsInfoList.size() == roRef.ChargingStationsInfoList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ChargingStationsInfoList.size()); ++u32Idx)
            bResult = bResult && (ChargingStationsInfoList[u32Idx] == roRef.ChargingStationsInfoList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_tcu_response_charging_stations_list_result::tcu_usb_fi_tcl_tcu_response_charging_stations_list_result(const tcu_usb_fi_tcl_tcu_response_charging_stations_list_result& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   ChargingStationsData = coRef.ChargingStationsData;
}
tcu_usb_fi_tcl_tcu_response_charging_stations_list_result& tcu_usb_fi_tcl_tcu_response_charging_stations_list_result::operator=(const tcu_usb_fi_tcl_tcu_response_charging_stations_list_result& coRef)
{
   if (this == &coRef) return *this;
   ChargingStationsData = coRef.ChargingStationsData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_fi_tcl_tcu_response_charging_stations_list_result::vDestroy()
{
   ChargingStationsData.vDestroy(); 
}

tcu_usb_fi_tcl_tcu_response_charging_stations_list_result::tcu_usb_fi_tcl_tcu_response_charging_stations_list_result()
:ChargingStationsData()
 {}

tS32 tcu_usb_fi_tcl_tcu_response_charging_stations_list_result::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_TCU_RESPONSE_CHARGING_STATIONS_LIST_RESULT;
}


tcu_usb_fi_tcl_tcu_response_charging_stations_list_result::~tcu_usb_fi_tcl_tcu_response_charging_stations_list_result()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_fi_tcl_tcu_response_charging_stations_list_result::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+ChargingStationsData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_fi_tcl_tcu_response_charging_stations_list_result::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ChargingStationsData);
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_tcu_response_charging_stations_list_result::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ChargingStationsData);
   return oOut;
}

tBool tcu_usb_fi_tcl_tcu_response_charging_stations_list_result::operator==(const tcu_usb_fi_tcl_tcu_response_charging_stations_list_result& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ChargingStationsData == roRef.ChargingStationsData);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_tcu_vacancy_stations_info::tcu_usb_fi_tcl_tcu_vacancy_stations_info(const tcu_usb_fi_tcl_tcu_vacancy_stations_info& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   Location = coRef.Location;
   u32POIID = coRef.u32POIID;
}
tcu_usb_fi_tcl_tcu_vacancy_stations_info& tcu_usb_fi_tcl_tcu_vacancy_stations_info::operator=(const tcu_usb_fi_tcl_tcu_vacancy_stations_info& coRef)
{
   if (this == &coRef) return *this;
   Location = coRef.Location;
   u32POIID = coRef.u32POIID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_tcu_vacancy_stations_info::tcu_usb_fi_tcl_tcu_vacancy_stations_info()
:Location()
,u32POIID(0)
 {}

tS32 tcu_usb_fi_tcl_tcu_vacancy_stations_info::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_TCU_VACANCY_STATIONS_INFO;
}


tcu_usb_fi_tcl_tcu_vacancy_stations_info::~tcu_usb_fi_tcl_tcu_vacancy_stations_info()
{}

tU32 tcu_usb_fi_tcl_tcu_vacancy_stations_info::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 14;
}

fi_tclInContext& tcu_usb_fi_tcl_tcu_vacancy_stations_info::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Location);
   (tVoid) (oIn >> u32POIID);
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_tcu_vacancy_stations_info::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Location);
   (tVoid) (oOut << u32POIID);
   return oOut;
}

tBool tcu_usb_fi_tcl_tcu_vacancy_stations_info::operator==(const tcu_usb_fi_tcl_tcu_vacancy_stations_info& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Location == roRef.Location);
   bResult = bResult && (u32POIID == roRef.u32POIID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_tcu_vacancy_stations_data::tcu_usb_fi_tcl_tcu_vacancy_stations_data(const tcu_usb_fi_tcl_tcu_vacancy_stations_data& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   VacancyStationsInfoList = coRef.VacancyStationsInfoList;
}
tcu_usb_fi_tcl_tcu_vacancy_stations_data& tcu_usb_fi_tcl_tcu_vacancy_stations_data::operator=(const tcu_usb_fi_tcl_tcu_vacancy_stations_data& coRef)
{
   if (this == &coRef) return *this;
   VacancyStationsInfoList = coRef.VacancyStationsInfoList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_fi_tcl_tcu_vacancy_stations_data::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < VacancyStationsInfoList.size(); ++u32Idx)
         VacancyStationsInfoList[u32Idx].vDestroy();
   VacancyStationsInfoList.clear();
   }
}

tcu_usb_fi_tcl_tcu_vacancy_stations_data::tcu_usb_fi_tcl_tcu_vacancy_stations_data()

 {}

tS32 tcu_usb_fi_tcl_tcu_vacancy_stations_data::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_TCU_VACANCY_STATIONS_DATA;
}


tcu_usb_fi_tcl_tcu_vacancy_stations_data::~tcu_usb_fi_tcl_tcu_vacancy_stations_data()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_fi_tcl_tcu_vacancy_stations_data::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(VacancyStationsInfoList.size()*14);
}

fi_tclInContext& tcu_usb_fi_tcl_tcu_vacancy_stations_data::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < VacancyStationsInfoList.size(); ++u32Idx)
      {
         VacancyStationsInfoList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      VacancyStationsInfoList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> VacancyStationsInfoList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_tcu_vacancy_stations_data::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)VacancyStationsInfoList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < VacancyStationsInfoList.size(); ++u32Idx)
         (tVoid) (oOut << VacancyStationsInfoList[u32Idx]);
   }
   return oOut;
}

tBool tcu_usb_fi_tcl_tcu_vacancy_stations_data::operator==(const tcu_usb_fi_tcl_tcu_vacancy_stations_data& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (VacancyStationsInfoList.size() == roRef.VacancyStationsInfoList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < VacancyStationsInfoList.size()); ++u32Idx)
            bResult = bResult && (VacancyStationsInfoList[u32Idx] == roRef.VacancyStationsInfoList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_tcu_response_vacancy_stations_list_result::tcu_usb_fi_tcl_tcu_response_vacancy_stations_list_result(const tcu_usb_fi_tcl_tcu_response_vacancy_stations_list_result& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   VacancyStationsData = coRef.VacancyStationsData;
}
tcu_usb_fi_tcl_tcu_response_vacancy_stations_list_result& tcu_usb_fi_tcl_tcu_response_vacancy_stations_list_result::operator=(const tcu_usb_fi_tcl_tcu_response_vacancy_stations_list_result& coRef)
{
   if (this == &coRef) return *this;
   VacancyStationsData = coRef.VacancyStationsData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_fi_tcl_tcu_response_vacancy_stations_list_result::vDestroy()
{
   VacancyStationsData.vDestroy(); 
}

tcu_usb_fi_tcl_tcu_response_vacancy_stations_list_result::tcu_usb_fi_tcl_tcu_response_vacancy_stations_list_result()
:VacancyStationsData()
 {}

tS32 tcu_usb_fi_tcl_tcu_response_vacancy_stations_list_result::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_TCU_RESPONSE_VACANCY_STATIONS_LIST_RESULT;
}


tcu_usb_fi_tcl_tcu_response_vacancy_stations_list_result::~tcu_usb_fi_tcl_tcu_response_vacancy_stations_list_result()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_fi_tcl_tcu_response_vacancy_stations_list_result::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+VacancyStationsData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_fi_tcl_tcu_response_vacancy_stations_list_result::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VacancyStationsData);
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_tcu_response_vacancy_stations_list_result::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VacancyStationsData);
   return oOut;
}

tBool tcu_usb_fi_tcl_tcu_response_vacancy_stations_list_result::operator==(const tcu_usb_fi_tcl_tcu_response_vacancy_stations_list_result& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VacancyStationsData == roRef.VacancyStationsData);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_tcu_vacancy_spot_data::tcu_usb_fi_tcl_tcu_vacancy_spot_data(const tcu_usb_fi_tcl_tcu_vacancy_spot_data& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   Location = coRef.Location;
   strAreaCode1 = coRef.strAreaCode1;
   strAreaCode2 = coRef.strAreaCode2;
   strAreaCode3 = coRef.strAreaCode3;
   strAreaCode4 = coRef.strAreaCode4;
   strAreaCode5 = coRef.strAreaCode5;
   strAreaCode6 = coRef.strAreaCode6;
   strAreaCode7 = coRef.strAreaCode7;
   strAreaCode8 = coRef.strAreaCode8;
   strPOIName = coRef.strPOIName;
   strStreetAndHouseNo = coRef.strStreetAndHouseNo;
   strTelephonenumber = coRef.strTelephonenumber;
   u16Categorycode = coRef.u16Categorycode;
   u16ClosedhourInformation = coRef.u16ClosedhourInformation;
   u16OpeninghourInformation = coRef.u16OpeninghourInformation;
   u16Parkingnumber = coRef.u16Parkingnumber;
   u16Paymenttypeinformation = coRef.u16Paymenttypeinformation;
   u16Sizeofdetailinformation = coRef.u16Sizeofdetailinformation;
   u16Subcategorycode = coRef.u16Subcategorycode;
   u32POIID = coRef.u32POIID;
   u32UserrestrictionID = coRef.u32UserrestrictionID;
   u8_24hoursadayinformation = coRef.u8_24hoursadayinformation;
   u8Businessdayoftheweekinformation = coRef.u8Businessdayoftheweekinformation;
   u8Chargingfeeinformation = coRef.u8Chargingfeeinformation;
   u8Chargingtype = coRef.u8Chargingtype;
   u8Detailsinformation = coRef.u8Detailsinformation;
   u8Entranceinformation = coRef.u8Entranceinformation;
   u8Expresswaygeneraltype = coRef.u8Expresswaygeneraltype;
   u8Fixedvalue1 = coRef.u8Fixedvalue1;
   u8Fixedvalue2 = coRef.u8Fixedvalue2;
   u8Informationreliability = coRef.u8Informationreliability;
   u8Installationfacilityinformation = coRef.u8Installationfacilityinformation;
   u8Nearthefacilityinformation = coRef.u8Nearthefacilityinformation;
   u8Officehoursunknowninformation = coRef.u8Officehoursunknowninformation;
   u8Partnersfacilityinformation = coRef.u8Partnersfacilityinformation;
   u8SizeOfPOIName = coRef.u8SizeOfPOIName;
   u8SizeOfStreetAndHouseNo = coRef.u8SizeOfStreetAndHouseNo;
   u8SizeOfTelephonenumber = coRef.u8SizeOfTelephonenumber;
   u8Thenumberofentranceinformation = coRef.u8Thenumberofentranceinformation;
   u8Thenumberofinstallationfacilityinformation = coRef.u8Thenumberofinstallationfacilityinformation;
   u8Thenumberofpartnersfacilityinformation = coRef.u8Thenumberofpartnersfacilityinformation;
   u8Thetotalnumberofchargingtype = coRef.u8Thetotalnumberofchargingtype;
   u8Userrestriction = coRef.u8Userrestriction;
}
tcu_usb_fi_tcl_tcu_vacancy_spot_data& tcu_usb_fi_tcl_tcu_vacancy_spot_data::operator=(const tcu_usb_fi_tcl_tcu_vacancy_spot_data& coRef)
{
   if (this == &coRef) return *this;
   Location = coRef.Location;
   strAreaCode1 = coRef.strAreaCode1;
   strAreaCode2 = coRef.strAreaCode2;
   strAreaCode3 = coRef.strAreaCode3;
   strAreaCode4 = coRef.strAreaCode4;
   strAreaCode5 = coRef.strAreaCode5;
   strAreaCode6 = coRef.strAreaCode6;
   strAreaCode7 = coRef.strAreaCode7;
   strAreaCode8 = coRef.strAreaCode8;
   strPOIName = coRef.strPOIName;
   strStreetAndHouseNo = coRef.strStreetAndHouseNo;
   strTelephonenumber = coRef.strTelephonenumber;
   u16Categorycode = coRef.u16Categorycode;
   u16ClosedhourInformation = coRef.u16ClosedhourInformation;
   u16OpeninghourInformation = coRef.u16OpeninghourInformation;
   u16Parkingnumber = coRef.u16Parkingnumber;
   u16Paymenttypeinformation = coRef.u16Paymenttypeinformation;
   u16Sizeofdetailinformation = coRef.u16Sizeofdetailinformation;
   u16Subcategorycode = coRef.u16Subcategorycode;
   u32POIID = coRef.u32POIID;
   u32UserrestrictionID = coRef.u32UserrestrictionID;
   u8_24hoursadayinformation = coRef.u8_24hoursadayinformation;
   u8Businessdayoftheweekinformation = coRef.u8Businessdayoftheweekinformation;
   u8Chargingfeeinformation = coRef.u8Chargingfeeinformation;
   u8Chargingtype = coRef.u8Chargingtype;
   u8Detailsinformation = coRef.u8Detailsinformation;
   u8Entranceinformation = coRef.u8Entranceinformation;
   u8Expresswaygeneraltype = coRef.u8Expresswaygeneraltype;
   u8Fixedvalue1 = coRef.u8Fixedvalue1;
   u8Fixedvalue2 = coRef.u8Fixedvalue2;
   u8Informationreliability = coRef.u8Informationreliability;
   u8Installationfacilityinformation = coRef.u8Installationfacilityinformation;
   u8Nearthefacilityinformation = coRef.u8Nearthefacilityinformation;
   u8Officehoursunknowninformation = coRef.u8Officehoursunknowninformation;
   u8Partnersfacilityinformation = coRef.u8Partnersfacilityinformation;
   u8SizeOfPOIName = coRef.u8SizeOfPOIName;
   u8SizeOfStreetAndHouseNo = coRef.u8SizeOfStreetAndHouseNo;
   u8SizeOfTelephonenumber = coRef.u8SizeOfTelephonenumber;
   u8Thenumberofentranceinformation = coRef.u8Thenumberofentranceinformation;
   u8Thenumberofinstallationfacilityinformation = coRef.u8Thenumberofinstallationfacilityinformation;
   u8Thenumberofpartnersfacilityinformation = coRef.u8Thenumberofpartnersfacilityinformation;
   u8Thetotalnumberofchargingtype = coRef.u8Thetotalnumberofchargingtype;
   u8Userrestriction = coRef.u8Userrestriction;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_fi_tcl_tcu_vacancy_spot_data::vDestroy()
{
   Location.vDestroy(); 
   strAreaCode1.vDestroy();
   strAreaCode2.vDestroy();
   strAreaCode3.vDestroy();
   strAreaCode4.vDestroy();
   strAreaCode5.vDestroy();
   strAreaCode6.vDestroy();
   strAreaCode7.vDestroy();
   strAreaCode8.vDestroy();
   strPOIName.vDestroy();
   strStreetAndHouseNo.vDestroy();
   strTelephonenumber.vDestroy();
}

tcu_usb_fi_tcl_tcu_vacancy_spot_data::tcu_usb_fi_tcl_tcu_vacancy_spot_data()
:Location()
,strAreaCode1()
,strAreaCode2()
,strAreaCode3()
,strAreaCode4()
,strAreaCode5()
,strAreaCode6()
,strAreaCode7()
,strAreaCode8()
,strPOIName()
,strStreetAndHouseNo()
,strTelephonenumber()
,u16Categorycode(0)
,u16ClosedhourInformation(0)
,u16OpeninghourInformation(0)
,u16Parkingnumber(0)
,u16Paymenttypeinformation(0)
,u16Sizeofdetailinformation(0)
,u16Subcategorycode(0)
,u32POIID(0)
,u32UserrestrictionID(0)
,u8_24hoursadayinformation(0)
,u8Businessdayoftheweekinformation(0)
,u8Chargingfeeinformation(0)
,u8Chargingtype(0)
,u8Detailsinformation(0)
,u8Entranceinformation(0)
,u8Expresswaygeneraltype(0)
,u8Fixedvalue1(0)
,u8Fixedvalue2(0)
,u8Informationreliability(0)
,u8Installationfacilityinformation(0)
,u8Nearthefacilityinformation(0)
,u8Officehoursunknowninformation(0)
,u8Partnersfacilityinformation(0)
,u8SizeOfPOIName(0)
,u8SizeOfStreetAndHouseNo(0)
,u8SizeOfTelephonenumber(0)
,u8Thenumberofentranceinformation(0)
,u8Thenumberofinstallationfacilityinformation(0)
,u8Thenumberofpartnersfacilityinformation(0)
,u8Thetotalnumberofchargingtype(0)
,u8Userrestriction(0)
 {}

tS32 tcu_usb_fi_tcl_tcu_vacancy_spot_data::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_TCU_VACANCY_SPOT_DATA;
}


tcu_usb_fi_tcl_tcu_vacancy_spot_data::~tcu_usb_fi_tcl_tcu_vacancy_spot_data()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_fi_tcl_tcu_vacancy_spot_data::u32GetSize(tU16 u16MajorVersion) const
{
   return 54+strAreaCode1.u32GetSize(u16MajorVersion)+strAreaCode2.u32GetSize(u16MajorVersion)+strAreaCode3.u32GetSize(u16MajorVersion)+strAreaCode4.u32GetSize(u16MajorVersion)+strAreaCode5.u32GetSize(u16MajorVersion)+strAreaCode6.u32GetSize(u16MajorVersion)+strAreaCode7.u32GetSize(u16MajorVersion)+strAreaCode8.u32GetSize(u16MajorVersion)+strPOIName.u32GetSize(u16MajorVersion)+strStreetAndHouseNo.u32GetSize(u16MajorVersion)+strTelephonenumber.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_fi_tcl_tcu_vacancy_spot_data::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Location);
   (tVoid) (oIn >> strAreaCode1);
   (tVoid) (oIn >> strAreaCode2);
   (tVoid) (oIn >> strAreaCode3);
   (tVoid) (oIn >> strAreaCode4);
   (tVoid) (oIn >> strAreaCode5);
   (tVoid) (oIn >> strAreaCode6);
   (tVoid) (oIn >> strAreaCode7);
   (tVoid) (oIn >> strAreaCode8);
   (tVoid) (oIn >> strPOIName);
   (tVoid) (oIn >> strStreetAndHouseNo);
   (tVoid) (oIn >> strTelephonenumber);
   (tVoid) (oIn >> u16Categorycode);
   (tVoid) (oIn >> u16ClosedhourInformation);
   (tVoid) (oIn >> u16OpeninghourInformation);
   (tVoid) (oIn >> u16Parkingnumber);
   (tVoid) (oIn >> u16Paymenttypeinformation);
   (tVoid) (oIn >> u16Sizeofdetailinformation);
   (tVoid) (oIn >> u16Subcategorycode);
   (tVoid) (oIn >> u32POIID);
   (tVoid) (oIn >> u32UserrestrictionID);
   (tVoid) (oIn >> u8_24hoursadayinformation);
   (tVoid) (oIn >> u8Businessdayoftheweekinformation);
   (tVoid) (oIn >> u8Chargingfeeinformation);
   (tVoid) (oIn >> u8Chargingtype);
   (tVoid) (oIn >> u8Detailsinformation);
   (tVoid) (oIn >> u8Entranceinformation);
   (tVoid) (oIn >> u8Expresswaygeneraltype);
   (tVoid) (oIn >> u8Fixedvalue1);
   (tVoid) (oIn >> u8Fixedvalue2);
   (tVoid) (oIn >> u8Informationreliability);
   (tVoid) (oIn >> u8Installationfacilityinformation);
   (tVoid) (oIn >> u8Nearthefacilityinformation);
   (tVoid) (oIn >> u8Officehoursunknowninformation);
   (tVoid) (oIn >> u8Partnersfacilityinformation);
   (tVoid) (oIn >> u8SizeOfPOIName);
   (tVoid) (oIn >> u8SizeOfStreetAndHouseNo);
   (tVoid) (oIn >> u8SizeOfTelephonenumber);
   (tVoid) (oIn >> u8Thenumberofentranceinformation);
   (tVoid) (oIn >> u8Thenumberofinstallationfacilityinformation);
   (tVoid) (oIn >> u8Thenumberofpartnersfacilityinformation);
   (tVoid) (oIn >> u8Thetotalnumberofchargingtype);
   (tVoid) (oIn >> u8Userrestriction);
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_tcu_vacancy_spot_data::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Location);
   (tVoid) (oOut << strAreaCode1);
   (tVoid) (oOut << strAreaCode2);
   (tVoid) (oOut << strAreaCode3);
   (tVoid) (oOut << strAreaCode4);
   (tVoid) (oOut << strAreaCode5);
   (tVoid) (oOut << strAreaCode6);
   (tVoid) (oOut << strAreaCode7);
   (tVoid) (oOut << strAreaCode8);
   (tVoid) (oOut << strPOIName);
   (tVoid) (oOut << strStreetAndHouseNo);
   (tVoid) (oOut << strTelephonenumber);
   (tVoid) (oOut << u16Categorycode);
   (tVoid) (oOut << u16ClosedhourInformation);
   (tVoid) (oOut << u16OpeninghourInformation);
   (tVoid) (oOut << u16Parkingnumber);
   (tVoid) (oOut << u16Paymenttypeinformation);
   (tVoid) (oOut << u16Sizeofdetailinformation);
   (tVoid) (oOut << u16Subcategorycode);
   (tVoid) (oOut << u32POIID);
   (tVoid) (oOut << u32UserrestrictionID);
   (tVoid) (oOut << u8_24hoursadayinformation);
   (tVoid) (oOut << u8Businessdayoftheweekinformation);
   (tVoid) (oOut << u8Chargingfeeinformation);
   (tVoid) (oOut << u8Chargingtype);
   (tVoid) (oOut << u8Detailsinformation);
   (tVoid) (oOut << u8Entranceinformation);
   (tVoid) (oOut << u8Expresswaygeneraltype);
   (tVoid) (oOut << u8Fixedvalue1);
   (tVoid) (oOut << u8Fixedvalue2);
   (tVoid) (oOut << u8Informationreliability);
   (tVoid) (oOut << u8Installationfacilityinformation);
   (tVoid) (oOut << u8Nearthefacilityinformation);
   (tVoid) (oOut << u8Officehoursunknowninformation);
   (tVoid) (oOut << u8Partnersfacilityinformation);
   (tVoid) (oOut << u8SizeOfPOIName);
   (tVoid) (oOut << u8SizeOfStreetAndHouseNo);
   (tVoid) (oOut << u8SizeOfTelephonenumber);
   (tVoid) (oOut << u8Thenumberofentranceinformation);
   (tVoid) (oOut << u8Thenumberofinstallationfacilityinformation);
   (tVoid) (oOut << u8Thenumberofpartnersfacilityinformation);
   (tVoid) (oOut << u8Thetotalnumberofchargingtype);
   (tVoid) (oOut << u8Userrestriction);
   return oOut;
}

tBool tcu_usb_fi_tcl_tcu_vacancy_spot_data::operator==(const tcu_usb_fi_tcl_tcu_vacancy_spot_data& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Location == roRef.Location);
   bResult = bResult && (strAreaCode1 == roRef.strAreaCode1);
   bResult = bResult && (strAreaCode2 == roRef.strAreaCode2);
   bResult = bResult && (strAreaCode3 == roRef.strAreaCode3);
   bResult = bResult && (strAreaCode4 == roRef.strAreaCode4);
   bResult = bResult && (strAreaCode5 == roRef.strAreaCode5);
   bResult = bResult && (strAreaCode6 == roRef.strAreaCode6);
   bResult = bResult && (strAreaCode7 == roRef.strAreaCode7);
   bResult = bResult && (strAreaCode8 == roRef.strAreaCode8);
   bResult = bResult && (strPOIName == roRef.strPOIName);
   bResult = bResult && (strStreetAndHouseNo == roRef.strStreetAndHouseNo);
   bResult = bResult && (strTelephonenumber == roRef.strTelephonenumber);
   bResult = bResult && (u16Categorycode == roRef.u16Categorycode);
   bResult = bResult && (u16ClosedhourInformation == roRef.u16ClosedhourInformation);
   bResult = bResult && (u16OpeninghourInformation == roRef.u16OpeninghourInformation);
   bResult = bResult && (u16Parkingnumber == roRef.u16Parkingnumber);
   bResult = bResult && (u16Paymenttypeinformation == roRef.u16Paymenttypeinformation);
   bResult = bResult && (u16Sizeofdetailinformation == roRef.u16Sizeofdetailinformation);
   bResult = bResult && (u16Subcategorycode == roRef.u16Subcategorycode);
   bResult = bResult && (u32POIID == roRef.u32POIID);
   bResult = bResult && (u32UserrestrictionID == roRef.u32UserrestrictionID);
   bResult = bResult && (u8_24hoursadayinformation == roRef.u8_24hoursadayinformation);
   bResult = bResult && (u8Businessdayoftheweekinformation == roRef.u8Businessdayoftheweekinformation);
   bResult = bResult && (u8Chargingfeeinformation == roRef.u8Chargingfeeinformation);
   bResult = bResult && (u8Chargingtype == roRef.u8Chargingtype);
   bResult = bResult && (u8Detailsinformation == roRef.u8Detailsinformation);
   bResult = bResult && (u8Entranceinformation == roRef.u8Entranceinformation);
   bResult = bResult && (u8Expresswaygeneraltype == roRef.u8Expresswaygeneraltype);
   bResult = bResult && (u8Fixedvalue1 == roRef.u8Fixedvalue1);
   bResult = bResult && (u8Fixedvalue2 == roRef.u8Fixedvalue2);
   bResult = bResult && (u8Informationreliability == roRef.u8Informationreliability);
   bResult = bResult && (u8Installationfacilityinformation == roRef.u8Installationfacilityinformation);
   bResult = bResult && (u8Nearthefacilityinformation == roRef.u8Nearthefacilityinformation);
   bResult = bResult && (u8Officehoursunknowninformation == roRef.u8Officehoursunknowninformation);
   bResult = bResult && (u8Partnersfacilityinformation == roRef.u8Partnersfacilityinformation);
   bResult = bResult && (u8SizeOfPOIName == roRef.u8SizeOfPOIName);
   bResult = bResult && (u8SizeOfStreetAndHouseNo == roRef.u8SizeOfStreetAndHouseNo);
   bResult = bResult && (u8SizeOfTelephonenumber == roRef.u8SizeOfTelephonenumber);
   bResult = bResult && (u8Thenumberofentranceinformation == roRef.u8Thenumberofentranceinformation);
   bResult = bResult && (u8Thenumberofinstallationfacilityinformation == roRef.u8Thenumberofinstallationfacilityinformation);
   bResult = bResult && (u8Thenumberofpartnersfacilityinformation == roRef.u8Thenumberofpartnersfacilityinformation);
   bResult = bResult && (u8Thetotalnumberofchargingtype == roRef.u8Thetotalnumberofchargingtype);
   bResult = bResult && (u8Userrestriction == roRef.u8Userrestriction);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_tcu_response_vacancy_spot_data_result::tcu_usb_fi_tcl_tcu_response_vacancy_spot_data_result(const tcu_usb_fi_tcl_tcu_response_vacancy_spot_data_result& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   VacancySpotData = coRef.VacancySpotData;
}
tcu_usb_fi_tcl_tcu_response_vacancy_spot_data_result& tcu_usb_fi_tcl_tcu_response_vacancy_spot_data_result::operator=(const tcu_usb_fi_tcl_tcu_response_vacancy_spot_data_result& coRef)
{
   if (this == &coRef) return *this;
   VacancySpotData = coRef.VacancySpotData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_fi_tcl_tcu_response_vacancy_spot_data_result::vDestroy()
{
   VacancySpotData.vDestroy(); 
}

tcu_usb_fi_tcl_tcu_response_vacancy_spot_data_result::tcu_usb_fi_tcl_tcu_response_vacancy_spot_data_result()
:VacancySpotData()
 {}

tS32 tcu_usb_fi_tcl_tcu_response_vacancy_spot_data_result::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_TCU_RESPONSE_VACANCY_SPOT_DATA_RESULT;
}


tcu_usb_fi_tcl_tcu_response_vacancy_spot_data_result::~tcu_usb_fi_tcl_tcu_response_vacancy_spot_data_result()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_fi_tcl_tcu_response_vacancy_spot_data_result::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+VacancySpotData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_fi_tcl_tcu_response_vacancy_spot_data_result::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VacancySpotData);
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_tcu_response_vacancy_spot_data_result::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VacancySpotData);
   return oOut;
}

tBool tcu_usb_fi_tcl_tcu_response_vacancy_spot_data_result::operator==(const tcu_usb_fi_tcl_tcu_response_vacancy_spot_data_result& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VacancySpotData == roRef.VacancySpotData);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_usb_tcu_Server_Info::tcu_usb_fi_tcl_usb_tcu_Server_Info(const tcu_usb_fi_tcl_usb_tcu_Server_Info& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   strServerAddress = coRef.strServerAddress;
   strServerName = coRef.strServerName;
   u8ServerId = coRef.u8ServerId;
}
tcu_usb_fi_tcl_usb_tcu_Server_Info& tcu_usb_fi_tcl_usb_tcu_Server_Info::operator=(const tcu_usb_fi_tcl_usb_tcu_Server_Info& coRef)
{
   if (this == &coRef) return *this;
   strServerAddress = coRef.strServerAddress;
   strServerName = coRef.strServerName;
   u8ServerId = coRef.u8ServerId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_fi_tcl_usb_tcu_Server_Info::vDestroy()
{
   strServerAddress.vDestroy();
   strServerName.vDestroy();
}

tcu_usb_fi_tcl_usb_tcu_Server_Info::tcu_usb_fi_tcl_usb_tcu_Server_Info()
:strServerAddress()
,strServerName()
,u8ServerId(0)
 {}

tS32 tcu_usb_fi_tcl_usb_tcu_Server_Info::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_USB_TCU_SERVER_INFO;
}


tcu_usb_fi_tcl_usb_tcu_Server_Info::~tcu_usb_fi_tcl_usb_tcu_Server_Info()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_fi_tcl_usb_tcu_Server_Info::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+strServerAddress.u32GetSize(u16MajorVersion)+strServerName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_fi_tcl_usb_tcu_Server_Info::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strServerAddress);
   (tVoid) (oIn >> strServerName);
   (tVoid) (oIn >> u8ServerId);
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_usb_tcu_Server_Info::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strServerAddress);
   (tVoid) (oOut << strServerName);
   (tVoid) (oOut << u8ServerId);
   return oOut;
}

tBool tcu_usb_fi_tcl_usb_tcu_Server_Info::operator==(const tcu_usb_fi_tcl_usb_tcu_Server_Info& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strServerAddress == roRef.strServerAddress);
   bResult = bResult && (strServerName == roRef.strServerName);
   bResult = bResult && (u8ServerId == roRef.u8ServerId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_usb_tcu_Server_Info_List::tcu_usb_fi_tcl_usb_tcu_Server_Info_List(const tcu_usb_fi_tcl_usb_tcu_Server_Info_List& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   ServerInfoList = coRef.ServerInfoList;
}
tcu_usb_fi_tcl_usb_tcu_Server_Info_List& tcu_usb_fi_tcl_usb_tcu_Server_Info_List::operator=(const tcu_usb_fi_tcl_usb_tcu_Server_Info_List& coRef)
{
   if (this == &coRef) return *this;
   ServerInfoList = coRef.ServerInfoList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_fi_tcl_usb_tcu_Server_Info_List::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ServerInfoList.size(); ++u32Idx)
         ServerInfoList[u32Idx].vDestroy();
   ServerInfoList.clear();
   }
}

tcu_usb_fi_tcl_usb_tcu_Server_Info_List::tcu_usb_fi_tcl_usb_tcu_Server_Info_List()

 {}

tS32 tcu_usb_fi_tcl_usb_tcu_Server_Info_List::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_USB_TCU_SERVER_INFO_LIST;
}


tcu_usb_fi_tcl_usb_tcu_Server_Info_List::~tcu_usb_fi_tcl_usb_tcu_Server_Info_List()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_fi_tcl_usb_tcu_Server_Info_List::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ServerInfoList.size(); ++u32ListIdx)
      u32DynamicSize += ServerInfoList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& tcu_usb_fi_tcl_usb_tcu_Server_Info_List::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ServerInfoList.size(); ++u32Idx)
      {
         ServerInfoList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ServerInfoList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ServerInfoList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_usb_tcu_Server_Info_List::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ServerInfoList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ServerInfoList.size(); ++u32Idx)
         (tVoid) (oOut << ServerInfoList[u32Idx]);
   }
   return oOut;
}

tBool tcu_usb_fi_tcl_usb_tcu_Server_Info_List::operator==(const tcu_usb_fi_tcl_usb_tcu_Server_Info_List& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ServerInfoList.size() == roRef.ServerInfoList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ServerInfoList.size()); ++u32Idx)
            bResult = bResult && (ServerInfoList[u32Idx] == roRef.ServerInfoList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_e8_ModemType::tcu_usb_fi_tcl_e8_ModemType():enType(FI_EN_2_9G) {}

tS32 tcu_usb_fi_tcl_e8_ModemType::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_E8_MODEMTYPE;
}


tcu_usb_fi_tcl_e8_ModemType::~tcu_usb_fi_tcl_e8_ModemType()
{}

tU32 tcu_usb_fi_tcl_e8_ModemType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_fi_tcl_e8_ModemType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_e8_ModemType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_usb_tcu_TCUDevice_Info::tcu_usb_fi_tcl_usb_tcu_TCUDevice_Info(const tcu_usb_fi_tcl_usb_tcu_TCUDevice_Info& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   eModemType = coRef.eModemType;
   bUSBConnectionStatus = coRef.bUSBConnectionStatus;
}
tcu_usb_fi_tcl_usb_tcu_TCUDevice_Info& tcu_usb_fi_tcl_usb_tcu_TCUDevice_Info::operator=(const tcu_usb_fi_tcl_usb_tcu_TCUDevice_Info& coRef)
{
   if (this == &coRef) return *this;
   eModemType = coRef.eModemType;
   bUSBConnectionStatus = coRef.bUSBConnectionStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_usb_tcu_TCUDevice_Info::tcu_usb_fi_tcl_usb_tcu_TCUDevice_Info()
:eModemType()
,bUSBConnectionStatus(0)
 {}

tS32 tcu_usb_fi_tcl_usb_tcu_TCUDevice_Info::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_USB_TCU_TCUDEVICE_INFO;
}


tcu_usb_fi_tcl_usb_tcu_TCUDevice_Info::~tcu_usb_fi_tcl_usb_tcu_TCUDevice_Info()
{}

tU32 tcu_usb_fi_tcl_usb_tcu_TCUDevice_Info::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& tcu_usb_fi_tcl_usb_tcu_TCUDevice_Info::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> eModemType);
   (tVoid) (oIn >> bUSBConnectionStatus);
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_usb_tcu_TCUDevice_Info::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << eModemType);
   (tVoid) (oOut << bUSBConnectionStatus);
   return oOut;
}

tBool tcu_usb_fi_tcl_usb_tcu_TCUDevice_Info::operator==(const tcu_usb_fi_tcl_usb_tcu_TCUDevice_Info& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (eModemType == roRef.eModemType);
   bResult = bResult && (bUSBConnectionStatus == roRef.bUSBConnectionStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_e8_DatabaseServiceType::tcu_usb_fi_tcl_e8_DatabaseServiceType():enType(FI_EN_USB_TCU_DATABASE_SERVICE_TYPE_AUTO_CHANNEL_DOWNLOAD) {}

tS32 tcu_usb_fi_tcl_e8_DatabaseServiceType::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_E8_DATABASESERVICETYPE;
}


tcu_usb_fi_tcl_e8_DatabaseServiceType::~tcu_usb_fi_tcl_e8_DatabaseServiceType()
{}

tU32 tcu_usb_fi_tcl_e8_DatabaseServiceType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_fi_tcl_e8_DatabaseServiceType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_e8_DatabaseServiceType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_e8_DatabaseStatus::tcu_usb_fi_tcl_e8_DatabaseStatus():enType(FI_EN_DATABASE_STATUS_DELETING_IFL) {}

tS32 tcu_usb_fi_tcl_e8_DatabaseStatus::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_E8_DATABASESTATUS;
}


tcu_usb_fi_tcl_e8_DatabaseStatus::~tcu_usb_fi_tcl_e8_DatabaseStatus()
{}

tU32 tcu_usb_fi_tcl_e8_DatabaseStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_fi_tcl_e8_DatabaseStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_e8_DatabaseStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_e8_CancelRequestType::tcu_usb_fi_tcl_e8_CancelRequestType():enType(FI_EN_USB_TCU_CANCEL_REQUEST_TYPE_CONNECTED_SEARCH) {}

tS32 tcu_usb_fi_tcl_e8_CancelRequestType::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_E8_CANCELREQUESTTYPE;
}


tcu_usb_fi_tcl_e8_CancelRequestType::~tcu_usb_fi_tcl_e8_CancelRequestType()
{}

tU32 tcu_usb_fi_tcl_e8_CancelRequestType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_fi_tcl_e8_CancelRequestType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_e8_CancelRequestType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_e8_UserAuthenticationResultType::tcu_usb_fi_tcl_e8_UserAuthenticationResultType():enType(FI_EN_USB_TCU_USER_AUTHENTICATION_RESULT_SUCCESS) {}

tS32 tcu_usb_fi_tcl_e8_UserAuthenticationResultType::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_E8_USERAUTHENTICATIONRESULTTYPE;
}


tcu_usb_fi_tcl_e8_UserAuthenticationResultType::~tcu_usb_fi_tcl_e8_UserAuthenticationResultType()
{}

tU32 tcu_usb_fi_tcl_e8_UserAuthenticationResultType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_fi_tcl_e8_UserAuthenticationResultType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_e8_UserAuthenticationResultType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_fi_tcl_usb_tcu_UserAuthentication_DecodedToken_Info::tcu_usb_fi_tcl_usb_tcu_UserAuthentication_DecodedToken_Info(const tcu_usb_fi_tcl_usb_tcu_UserAuthentication_DecodedToken_Info& coRef)
   : tcu_usb_fi_tclVisitableTypeBase(coRef)
{
   KID = coRef.KID;
}
tcu_usb_fi_tcl_usb_tcu_UserAuthentication_DecodedToken_Info& tcu_usb_fi_tcl_usb_tcu_UserAuthentication_DecodedToken_Info::operator=(const tcu_usb_fi_tcl_usb_tcu_UserAuthentication_DecodedToken_Info& coRef)
{
   if (this == &coRef) return *this;
   KID = coRef.KID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_fi_tcl_usb_tcu_UserAuthentication_DecodedToken_Info::vDestroy()
{
   KID.vDestroy();
}

tcu_usb_fi_tcl_usb_tcu_UserAuthentication_DecodedToken_Info::tcu_usb_fi_tcl_usb_tcu_UserAuthentication_DecodedToken_Info()
:KID()
 {}

tS32 tcu_usb_fi_tcl_usb_tcu_UserAuthentication_DecodedToken_Info::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_USB_TCU_USERAUTHENTICATION_DECODEDTOKEN_INFO;
}


tcu_usb_fi_tcl_usb_tcu_UserAuthentication_DecodedToken_Info::~tcu_usb_fi_tcl_usb_tcu_UserAuthentication_DecodedToken_Info()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_fi_tcl_usb_tcu_UserAuthentication_DecodedToken_Info::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+KID.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_fi_tcl_usb_tcu_UserAuthentication_DecodedToken_Info::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> KID);
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_usb_tcu_UserAuthentication_DecodedToken_Info::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << KID);
   return oOut;
}

tBool tcu_usb_fi_tcl_usb_tcu_UserAuthentication_DecodedToken_Info::operator==(const tcu_usb_fi_tcl_usb_tcu_UserAuthentication_DecodedToken_Info& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (KID == roRef.KID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_fi_tcl_e8_tcu_Regions::tcu_usb_fi_tcl_e8_tcu_Regions():enType(FI_EN_REGION_AGT) {}

tS32 tcu_usb_fi_tcl_e8_tcu_Regions::s32GetTypeId() const
{
   return (tS32) tcu_usb_typesfi_tclToken::EN_E8_TCU_REGIONS;
}


tcu_usb_fi_tcl_e8_tcu_Regions::~tcu_usb_fi_tcl_e8_tcu_Regions()
{}

tU32 tcu_usb_fi_tcl_e8_tcu_Regions::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_fi_tcl_e8_tcu_Regions::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& tcu_usb_fi_tcl_e8_tcu_Regions::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

