#ifndef TCU_USB_FIVISITOR_HEADER
#define TCU_USB_FIVISITOR_HEADER

// --Basisklasse fuer eine FI-Besucher-Klasse

class tcu_usb_fi_tclOutput {
public:
   tcu_usb_fi_tclOutput();
   virtual ~tcu_usb_fi_tclOutput(){};

   virtual tVoid vPrintLine(tCString coszLine) = 0;
};

class tcu_usb_fi_tclFileOutput : public tcu_usb_fi_tclOutput 
{
public:
   tcu_usb_fi_tclFileOutput(OSAL_tIODescriptor rIOD):fd(rIOD) {}
   virtual tVoid vPrintLine(tCString coszLine);
protected:
   OSAL_tIODescriptor fd;
private:
   tcu_usb_fi_tclFileOutput(); //lint !e1704
   tcu_usb_fi_tclFileOutput& operator=(const tcu_usb_fi_tclFileOutput& coRef);
   tcu_usb_fi_tclFileOutput(const tcu_usb_fi_tclFileOutput& coRef); //lint !e1704
};

class tcu_usb_fi_tclMemOutput : public tcu_usb_fi_tclOutput
{
public:
   tcu_usb_fi_tclMemOutput(tU32 u32MemSize);
   virtual ~tcu_usb_fi_tclMemOutput();
   virtual tVoid vPrintLine(tCString coszLine);
   tString szGetBuffer();
protected:
   tChar* szBuf;
   tChar* szEndBuf;
   tChar* s8BufPos;
private:
   tcu_usb_fi_tclMemOutput(); //lint !e1704
   tcu_usb_fi_tclMemOutput(const tcu_usb_fi_tclMemOutput& coRef); //lint !e1704
   tcu_usb_fi_tclMemOutput& operator=(const tcu_usb_fi_tclMemOutput& coRef); //lint !e1704
};

class MY_DECL tcu_usb_fi_tclVisitorBase {
public:

   // --Konstruktor
   tcu_usb_fi_tclVisitorBase():bBreakNow(FALSE),bIsVisitorValid(FALSE) {}
   virtual ~tcu_usb_fi_tclVisitorBase() {}

   tBool bIsValid() const { return bIsVisitorValid; }
   tVoid vInvalidate() { bIsVisitorValid=FALSE; }
   tVoid vValidate() { bIsVisitorValid=TRUE; }
   tBool bBreak() const { return bBreakNow; }
   tVoid vReleaseBreak() { bBreakNow = FALSE; }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(tcu_usb_fi_tclU8& oU8);
   virtual tVoid vVisitS8(tcu_usb_fi_tclS8& oS8);
   virtual tVoid vVisitU16(tcu_usb_fi_tclU16& oU16);
   virtual tVoid vVisitS16(tcu_usb_fi_tclS16& oS16);
   virtual tVoid vVisitU24(tcu_usb_fi_tclU24& oU24);
   virtual tVoid vVisitS24(tcu_usb_fi_tclS24& oS24);
   virtual tVoid vVisitU32(tcu_usb_fi_tclU32& oU32);
   virtual tVoid vVisitS32(tcu_usb_fi_tclS32& oS32);
   virtual tVoid vVisitU64(tcu_usb_fi_tclU64& oU64);
   virtual tVoid vVisitS64(tcu_usb_fi_tclS64& oS64);
   virtual tVoid vVisitF32(tcu_usb_fi_tclF32& oF32);
   virtual tVoid vVisitF64(tcu_usb_fi_tclF64& oF64);
   virtual tVoid vVisitBool(tcu_usb_fi_tclBool& oBool);
   virtual tVoid vVisitString(tcu_usb_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(tcu_usb_fi_tclMultiLanguageString& oString);

   virtual tVoid vVisitList(tcu_usb_fi_tclList& oList);
   virtual tVoid vVisit_BinContainer(tcu_usb_fi_tcl_BinContainer& oBinContainer);

   virtual tVoid vVisit_Reserved(tcu_usb_fi_tcl_Reserved& oReserved);

   virtual tVoid vVisit_u8_Percent(tcu_usb_fi_tcl_u8_Percent& ou8_Percent);

   virtual tVoid vVisit_s16_PerThousand(tcu_usb_fi_tcl_s16_PerThousand& os16_PerThousand);

   virtual tVoid vVisit_u16_IndexInReferenceList(tcu_usb_fi_tcl_u16_IndexInReferenceList& ou16_IndexInReferenceList);

   virtual tVoid vVisit_u16_ErrorCode(tcu_usb_fi_tcl_u16_ErrorCode& ou16_ErrorCode);

   virtual tVoid vVisit_u16_RPM(tcu_usb_fi_tcl_u16_RPM& ou16_RPM);

   virtual tVoid vVisit_s32_Kilogram(tcu_usb_fi_tcl_s32_Kilogram& os32_Kilogram);

   virtual tVoid vVisit_s32_Pound(tcu_usb_fi_tcl_s32_Pound& os32_Pound);

   virtual tVoid vVisit_s16_Meter(tcu_usb_fi_tcl_s16_Meter& os16_Meter);

   virtual tVoid vVisit_s32_Meter(tcu_usb_fi_tcl_s32_Meter& os32_Meter);

   virtual tVoid vVisit_s32_Yards(tcu_usb_fi_tcl_s32_Yards& os32_Yards);

   virtual tVoid vVisit_s32_Foot(tcu_usb_fi_tcl_s32_Foot& os32_Foot);

   virtual tVoid vVisit_s32_Centimeter(tcu_usb_fi_tcl_s32_Centimeter& os32_Centimeter);

   virtual tVoid vVisit_s32_Inch(tcu_usb_fi_tcl_s32_Inch& os32_Inch);

   virtual tVoid vVisit_s32_Millimeter(tcu_usb_fi_tcl_s32_Millimeter& os32_Millimeter);

   virtual tVoid vVisit_s32_Microliter(tcu_usb_fi_tcl_s32_Microliter& os32_Microliter);

   virtual tVoid vVisit_s32_Second(tcu_usb_fi_tcl_s32_Second& os32_Second);

   virtual tVoid vVisit_u16_MilliSecond(tcu_usb_fi_tcl_u16_MilliSecond& ou16_MilliSecond);

   virtual tVoid vVisit_s32_MilliSecond(tcu_usb_fi_tcl_s32_MilliSecond& os32_MilliSecond);

   virtual tVoid vVisit_POSIXTime(tcu_usb_fi_tcl_POSIXTime& oPOSIXTime);

   virtual tVoid vVisit_e8_DST_State(tcu_usb_fi_tcl_e8_DST_State& oe8_DST_State);

   virtual tVoid vVisit_TimeZoneElement(tcu_usb_fi_tcl_TimeZoneElement& oTimeZoneElement);

   virtual tVoid vVisit_s16_KmPerHour(tcu_usb_fi_tcl_s16_KmPerHour& os16_KmPerHour);

   virtual tVoid vVisit_s16_MilesPerHour(tcu_usb_fi_tcl_s16_MilesPerHour& os16_MilesPerHour);

   virtual tVoid vVisit_s16_Knot(tcu_usb_fi_tcl_s16_Knot& os16_Knot);

   virtual tVoid vVisit_s16_CentimeterSecond(tcu_usb_fi_tcl_s16_CentimeterSecond& os16_CentimeterSecond);

   virtual tVoid vVisit_s16_Kelvin(tcu_usb_fi_tcl_s16_Kelvin& os16_Kelvin);

   virtual tVoid vVisit_s16_Fahrenheit(tcu_usb_fi_tcl_s16_Fahrenheit& os16_Fahrenheit);

   virtual tVoid vVisit_s32_Pascal(tcu_usb_fi_tcl_s32_Pascal& os32_Pascal);

   virtual tVoid vVisit_s32_Watt(tcu_usb_fi_tcl_s32_Watt& os32_Watt);

   virtual tVoid vVisit_FIVersion(tcu_usb_fi_tcl_FIVersion& oFIVersion);

   virtual tVoid vVisit_s32_Longitude(tcu_usb_fi_tcl_s32_Longitude& os32_Longitude);

   virtual tVoid vVisit_s32_Latitude(tcu_usb_fi_tcl_s32_Latitude& os32_Latitude);

   virtual tVoid vVisit_PositionWGS84(tcu_usb_fi_tcl_PositionWGS84& oPositionWGS84);

   virtual tVoid vVisit_RectangleWGS84(tcu_usb_fi_tcl_RectangleWGS84& oRectangleWGS84);

   virtual tVoid vVisit_e16_ISOCountryCode(tcu_usb_fi_tcl_e16_ISOCountryCode& oe16_ISOCountryCode);

   virtual tVoid vVisit_e16_ISOLanguageCode(tcu_usb_fi_tcl_e16_ISOLanguageCode& oe16_ISOLanguageCode);

   virtual tVoid vVisit_LanguageID(tcu_usb_fi_tcl_LanguageID& oLanguageID);

   virtual tVoid vVisit_u8_DirectionAbsolute(tcu_usb_fi_tcl_u8_DirectionAbsolute& ou8_DirectionAbsolute);

   virtual tVoid vVisit_u8_DirectionRelative(tcu_usb_fi_tcl_u8_DirectionRelative& ou8_DirectionRelative);

   virtual tVoid vVisit_s16_CentiDegree(tcu_usb_fi_tcl_s16_CentiDegree& os16_CentiDegree);

   virtual tVoid vVisit_s16_Degree(tcu_usb_fi_tcl_s16_Degree& os16_Degree);

   virtual tVoid vVisit_u16_DirectionAbsolute_CentiDegree(tcu_usb_fi_tcl_u16_DirectionAbsolute_CentiDegree& ou16_DirectionAbsolute_CentiDegree);

   virtual tVoid vVisit_s16_DirectionRelative_CentiDegree(tcu_usb_fi_tcl_s16_DirectionRelative_CentiDegree& os16_DirectionRelative_CentiDegree);

   virtual tVoid vVisit_e8_FuelType(tcu_usb_fi_tcl_e8_FuelType& oe8_FuelType);

   virtual tVoid vVisit_DistTimeFuel(tcu_usb_fi_tcl_DistTimeFuel& oDistTimeFuel);

   virtual tVoid vVisit_e16_DataConnectionError(tcu_usb_fi_tcl_e16_DataConnectionError& oe16_DataConnectionError);

   virtual tVoid vVisit_e8_DataConnectionStatus(tcu_usb_fi_tcl_e8_DataConnectionStatus& oe8_DataConnectionStatus);

   virtual tVoid vVisit_e8_ServiceType(tcu_usb_fi_tcl_e8_ServiceType& oe8_ServiceType);

   virtual tVoid vVisit_usb_tcu_Charging_Stations_Request_Info(tcu_usb_fi_tcl_usb_tcu_Charging_Stations_Request_Info& ousb_tcu_Charging_Stations_Request_Info);

   virtual tVoid vVisit_usb_tcu_POIID_List(tcu_usb_fi_tcl_usb_tcu_POIID_List& ousb_tcu_POIID_List);

   virtual tVoid vVisit_usb_tcu_Vacancy_Stations_Request_Info(tcu_usb_fi_tcl_usb_tcu_Vacancy_Stations_Request_Info& ousb_tcu_Vacancy_Stations_Request_Info);

   virtual tVoid vVisit_usb_tcu_Favorite_channel_info(tcu_usb_fi_tcl_usb_tcu_Favorite_channel_info& ousb_tcu_Favorite_channel_info);

   virtual tVoid vVisit_usb_tcu_Favorite_Feed_List(tcu_usb_fi_tcl_usb_tcu_Favorite_Feed_List& ousb_tcu_Favorite_Feed_List);

   virtual tVoid vVisit_e8_TCU_ProbePermitSetting(tcu_usb_fi_tcl_e8_TCU_ProbePermitSetting& oe8_TCU_ProbePermitSetting);

   virtual tVoid vVisit_e8_tcu_NotiResult(tcu_usb_fi_tcl_e8_tcu_NotiResult& oe8_tcu_NotiResult);

   virtual tVoid vVisit_e8_tcu_Authentication_Result(tcu_usb_fi_tcl_e8_tcu_Authentication_Result& oe8_tcu_Authentication_Result);

   virtual tVoid vVisit_e8_tcu_VICS_Response_Data(tcu_usb_fi_tcl_e8_tcu_VICS_Response_Data& oe8_tcu_VICS_Response_Data);

   virtual tVoid vVisit_tcu_Block_Data_List(tcu_usb_fi_tcl_tcu_Block_Data_List& otcu_Block_Data_List);

   virtual tVoid vVisit_tcu_Japan_Location(tcu_usb_fi_tcl_tcu_Japan_Location& otcu_Japan_Location);

   virtual tVoid vVisit_tcu_navigation_setting_information(tcu_usb_fi_tcl_tcu_navigation_setting_information& otcu_navigation_setting_information);

   virtual tVoid vVisit_json_file_path(tcu_usb_fi_tcl_json_file_path& ojson_file_path);

   virtual tVoid vVisit_e8_tcu_LogLevel(tcu_usb_fi_tcl_e8_tcu_LogLevel& oe8_tcu_LogLevel);

   virtual tVoid vVisit_e8_AutoDownloadInterval(tcu_usb_fi_tcl_e8_AutoDownloadInterval& oe8_AutoDownloadInterval);

   virtual tVoid vVisit_e8_ConnectedSearchServiceType(tcu_usb_fi_tcl_e8_ConnectedSearchServiceType& oe8_ConnectedSearchServiceType);

   virtual tVoid vVisit_e8_tcu_AudioActivity(tcu_usb_fi_tcl_e8_tcu_AudioActivity& oe8_tcu_AudioActivity);

   virtual tVoid vVisit_e8_tcu_ExecType(tcu_usb_fi_tcl_e8_tcu_ExecType& oe8_tcu_ExecType);

   virtual tVoid vVisit_tcu_VICS_Request_Data(tcu_usb_fi_tcl_tcu_VICS_Request_Data& otcu_VICS_Request_Data);

   virtual tVoid vVisit_usb_tcu_Channel_definition_information(tcu_usb_fi_tcl_usb_tcu_Channel_definition_information& ousb_tcu_Channel_definition_information);

   virtual tVoid vVisit_usb_tcu_Channel_Info(tcu_usb_fi_tcl_usb_tcu_Channel_Info& ousb_tcu_Channel_Info);

   virtual tVoid vVisit_usb_tcu_Channel_Info_List(tcu_usb_fi_tcl_usb_tcu_Channel_Info_List& ousb_tcu_Channel_Info_List);

   virtual tVoid vVisit_usb_tcu_channel_master_data_header(tcu_usb_fi_tcl_usb_tcu_channel_master_data_header& ousb_tcu_channel_master_data_header);

   virtual tVoid vVisit_usb_tcu_Folder_definition_information(tcu_usb_fi_tcl_usb_tcu_Folder_definition_information& ousb_tcu_Folder_definition_information);

   virtual tVoid vVisit_usb_tcu_Location(tcu_usb_fi_tcl_usb_tcu_Location& ousb_tcu_Location);

   virtual tVoid vVisit_usb_tcu_Data_Header_Part(tcu_usb_fi_tcl_usb_tcu_Data_Header_Part& ousb_tcu_Data_Header_Part);

   virtual tVoid vVisit_usb_tcu_Data_Record(tcu_usb_fi_tcl_usb_tcu_Data_Record& ousb_tcu_Data_Record);

   virtual tVoid vVisit_usb_tcu_channel_master_data(tcu_usb_fi_tcl_usb_tcu_channel_master_data& ousb_tcu_channel_master_data);

   virtual tVoid vVisit_usb_tcu_GroupA_Authorization_Info(tcu_usb_fi_tcl_usb_tcu_GroupA_Authorization_Info& ousb_tcu_GroupA_Authorization_Info);

   virtual tVoid vVisit_usb_tcu_GroupA_BasicServices_Info(tcu_usb_fi_tcl_usb_tcu_GroupA_BasicServices_Info& ousb_tcu_GroupA_BasicServices_Info);

   virtual tVoid vVisit_usb_tcu_GroupA_Info(tcu_usb_fi_tcl_usb_tcu_GroupA_Info& ousb_tcu_GroupA_Info);

   virtual tVoid vVisit_usb_tcu_connected_search_result(tcu_usb_fi_tcl_usb_tcu_connected_search_result& ousb_tcu_connected_search_result);

   virtual tVoid vVisit_tcu_charging_spot_data(tcu_usb_fi_tcl_tcu_charging_spot_data& otcu_charging_spot_data);

   virtual tVoid vVisit_tcu_response_charging_spot_data_result(tcu_usb_fi_tcl_tcu_response_charging_spot_data_result& otcu_response_charging_spot_data_result);

   virtual tVoid vVisit_tcu_charging_stations_info(tcu_usb_fi_tcl_tcu_charging_stations_info& otcu_charging_stations_info);

   virtual tVoid vVisit_tcu_charging_stations_data(tcu_usb_fi_tcl_tcu_charging_stations_data& otcu_charging_stations_data);

   virtual tVoid vVisit_tcu_response_charging_stations_list_result(tcu_usb_fi_tcl_tcu_response_charging_stations_list_result& otcu_response_charging_stations_list_result);

   virtual tVoid vVisit_tcu_vacancy_stations_info(tcu_usb_fi_tcl_tcu_vacancy_stations_info& otcu_vacancy_stations_info);

   virtual tVoid vVisit_tcu_vacancy_stations_data(tcu_usb_fi_tcl_tcu_vacancy_stations_data& otcu_vacancy_stations_data);

   virtual tVoid vVisit_tcu_response_vacancy_stations_list_result(tcu_usb_fi_tcl_tcu_response_vacancy_stations_list_result& otcu_response_vacancy_stations_list_result);

   virtual tVoid vVisit_tcu_vacancy_spot_data(tcu_usb_fi_tcl_tcu_vacancy_spot_data& otcu_vacancy_spot_data);

   virtual tVoid vVisit_tcu_response_vacancy_spot_data_result(tcu_usb_fi_tcl_tcu_response_vacancy_spot_data_result& otcu_response_vacancy_spot_data_result);

   virtual tVoid vVisit_usb_tcu_Server_Info(tcu_usb_fi_tcl_usb_tcu_Server_Info& ousb_tcu_Server_Info);

   virtual tVoid vVisit_usb_tcu_Server_Info_List(tcu_usb_fi_tcl_usb_tcu_Server_Info_List& ousb_tcu_Server_Info_List);

   virtual tVoid vVisit_e8_ModemType(tcu_usb_fi_tcl_e8_ModemType& oe8_ModemType);

   virtual tVoid vVisit_usb_tcu_TCUDevice_Info(tcu_usb_fi_tcl_usb_tcu_TCUDevice_Info& ousb_tcu_TCUDevice_Info);

   virtual tVoid vVisit_e8_DatabaseServiceType(tcu_usb_fi_tcl_e8_DatabaseServiceType& oe8_DatabaseServiceType);

   virtual tVoid vVisit_e8_DatabaseStatus(tcu_usb_fi_tcl_e8_DatabaseStatus& oe8_DatabaseStatus);

   virtual tVoid vVisit_e8_CancelRequestType(tcu_usb_fi_tcl_e8_CancelRequestType& oe8_CancelRequestType);

   virtual tVoid vVisit_e8_UserAuthenticationResultType(tcu_usb_fi_tcl_e8_UserAuthenticationResultType& oe8_UserAuthenticationResultType);

   virtual tVoid vVisit_usb_tcu_UserAuthentication_DecodedToken_Info(tcu_usb_fi_tcl_usb_tcu_UserAuthentication_DecodedToken_Info& ousb_tcu_UserAuthentication_DecodedToken_Info);

   virtual tVoid vVisit_e8_tcu_Regions(tcu_usb_fi_tcl_e8_tcu_Regions& oe8_tcu_Regions);


 	fi_tclTraversePath<fi_tclKnot>::tclIterator oIterator;		
	
protected:
	tBool bBreakNow;
	tBool bIsVisitorValid;
private:

};

#endif
