/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef TCU_USB_MAINFITYPES_HEADER
#define TCU_USB_MAINFITYPES_HEADER


class tcu_usb_mainfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for tcu_usb_main_fi message types

fi_tclMessageBase* tcu_usb_mainfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class tcu_usb_mainfi_tclMsgBaseMessage : public tcu_usb_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   tcu_usb_mainfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class tcu_usb_mainfi_tclMsgGetChannelDataMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgGetChannelDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgGetChannelDataMethodStart& operator=(const tcu_usb_mainfi_tclMsgGetChannelDataMethodStart& coRef);
   tcu_usb_mainfi_tclMsgGetChannelDataMethodStart(const tcu_usb_mainfi_tclMsgGetChannelDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_usb_tcu_Channel_Info_List Channel_Info_List;
   tBool bBackgroundDownloadType;
   virtual ~tcu_usb_mainfi_tclMsgGetChannelDataMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgGetChannelDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgGetChannelDataMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgGetChannelDataMethodResult();

   virtual ~tcu_usb_mainfi_tclMsgGetChannelDataMethodResult();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgGetChannelDataMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgGetConnectedSearchResultMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgGetConnectedSearchResultMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgGetConnectedSearchResultMethodStart& operator=(const tcu_usb_mainfi_tclMsgGetConnectedSearchResultMethodStart& coRef);
   tcu_usb_mainfi_tclMsgGetConnectedSearchResultMethodStart(const tcu_usb_mainfi_tclMsgGetConnectedSearchResultMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8SizeOfKeyWord;
   tcu_usb_fi_tclString strKeyWord;
   virtual ~tcu_usb_mainfi_tclMsgGetConnectedSearchResultMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgGetConnectedSearchResultMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgGetConnectedSearchResultMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgGetConnectedSearchResultMethodResult();

   virtual ~tcu_usb_mainfi_tclMsgGetConnectedSearchResultMethodResult();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgGetConnectedSearchResultMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgGetChannelMasterDataMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgGetChannelMasterDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgGetChannelMasterDataMethodStart& operator=(const tcu_usb_mainfi_tclMsgGetChannelMasterDataMethodStart& coRef);
   tcu_usb_mainfi_tclMsgGetChannelMasterDataMethodStart(const tcu_usb_mainfi_tclMsgGetChannelMasterDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bBackgroundDownloadType;
   virtual ~tcu_usb_mainfi_tclMsgGetChannelMasterDataMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgGetChannelMasterDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgGetChannelMasterDataMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgGetChannelMasterDataMethodResult();

   virtual ~tcu_usb_mainfi_tclMsgGetChannelMasterDataMethodResult();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgGetChannelMasterDataMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodStart& operator=(const tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodStart& coRef);
   tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodStart(const tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tclString TextAndTags;
   tU16 u16ChannelID;
   tU8 u8ChannelContentsID;
   tBool bHoldAudioChannel;
   virtual ~tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodResultFirst : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodResultFirst();

   virtual ~tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodResultFirst();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodResultFirst& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodResultMiddle : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodResultMiddle();

   virtual ~tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodResultMiddle();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodResultMiddle& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodResultLast : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodResultLast();

   virtual ~tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodResultLast();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodResultLast& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgAbortPromptMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgAbortPromptMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgAbortPromptMethodStart& operator=(const tcu_usb_mainfi_tclMsgAbortPromptMethodStart& coRef);
   tcu_usb_mainfi_tclMsgAbortPromptMethodStart(const tcu_usb_mainfi_tclMsgAbortPromptMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bHoldAudioChannel;
   virtual ~tcu_usb_mainfi_tclMsgAbortPromptMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgAbortPromptMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgAbortPromptMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgAbortPromptMethodResult();

   virtual ~tcu_usb_mainfi_tclMsgAbortPromptMethodResult();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgAbortPromptMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgPausePromptMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgPausePromptMethodStart();

   virtual ~tcu_usb_mainfi_tclMsgPausePromptMethodStart();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgPausePromptMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgPausePromptMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgPausePromptMethodResult();

   virtual ~tcu_usb_mainfi_tclMsgPausePromptMethodResult();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgPausePromptMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgContinuePromptMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgContinuePromptMethodStart();

   virtual ~tcu_usb_mainfi_tclMsgContinuePromptMethodStart();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgContinuePromptMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgContinuePromptMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgContinuePromptMethodResult();

   virtual ~tcu_usb_mainfi_tclMsgContinuePromptMethodResult();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgContinuePromptMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgCancelRequestMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgCancelRequestMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgCancelRequestMethodStart& operator=(const tcu_usb_mainfi_tclMsgCancelRequestMethodStart& coRef);
   tcu_usb_mainfi_tclMsgCancelRequestMethodStart(const tcu_usb_mainfi_tclMsgCancelRequestMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_e8_CancelRequestType eCancelRequestType;
   virtual ~tcu_usb_mainfi_tclMsgCancelRequestMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgCancelRequestMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgCancelRequestMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgCancelRequestMethodResult();

   virtual ~tcu_usb_mainfi_tclMsgCancelRequestMethodResult();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgCancelRequestMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgSendGroupADataMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgSendGroupADataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgSendGroupADataMethodStart& operator=(const tcu_usb_mainfi_tclMsgSendGroupADataMethodStart& coRef);
   tcu_usb_mainfi_tclMsgSendGroupADataMethodStart(const tcu_usb_mainfi_tclMsgSendGroupADataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_usb_tcu_GroupA_Info GroupA_Info;
   virtual ~tcu_usb_mainfi_tclMsgSendGroupADataMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgSendGroupADataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgSendGroupADataMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgSendGroupADataMethodResult();

   virtual ~tcu_usb_mainfi_tclMsgSendGroupADataMethodResult();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgSendGroupADataMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgDeleteInVehicleMessageMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgDeleteInVehicleMessageMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgDeleteInVehicleMessageMethodStart& operator=(const tcu_usb_mainfi_tclMsgDeleteInVehicleMessageMethodStart& coRef);
   tcu_usb_mainfi_tclMsgDeleteInVehicleMessageMethodStart(const tcu_usb_mainfi_tclMsgDeleteInVehicleMessageMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS64 s64IndexInternal;
   tU8 u8ChannelContentsID;
   virtual ~tcu_usb_mainfi_tclMsgDeleteInVehicleMessageMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgDeleteInVehicleMessageMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgDeleteInVehicleMessageMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgDeleteInVehicleMessageMethodResult();

   virtual ~tcu_usb_mainfi_tclMsgDeleteInVehicleMessageMethodResult();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgDeleteInVehicleMessageMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgResetDatabaseMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgResetDatabaseMethodStart();

   virtual ~tcu_usb_mainfi_tclMsgResetDatabaseMethodStart();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgResetDatabaseMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgResetDatabaseMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgResetDatabaseMethodResult();

   virtual ~tcu_usb_mainfi_tclMsgResetDatabaseMethodResult();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgResetDatabaseMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgGetServerListMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgGetServerListMethodStart();

   virtual ~tcu_usb_mainfi_tclMsgGetServerListMethodStart();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgGetServerListMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgGetServerListMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgGetServerListMethodResult();

   virtual ~tcu_usb_mainfi_tclMsgGetServerListMethodResult();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgGetServerListMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgSelectServerMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgSelectServerMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgSelectServerMethodStart& operator=(const tcu_usb_mainfi_tclMsgSelectServerMethodStart& coRef);
   tcu_usb_mainfi_tclMsgSelectServerMethodStart(const tcu_usb_mainfi_tclMsgSelectServerMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8ServerId;
   virtual ~tcu_usb_mainfi_tclMsgSelectServerMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgSelectServerMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgSelectServerMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgSelectServerMethodResult();

   virtual ~tcu_usb_mainfi_tclMsgSelectServerMethodResult();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgSelectServerMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgRetryGetChannelDataMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgRetryGetChannelDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgRetryGetChannelDataMethodStart& operator=(const tcu_usb_mainfi_tclMsgRetryGetChannelDataMethodStart& coRef);
   tcu_usb_mainfi_tclMsgRetryGetChannelDataMethodStart(const tcu_usb_mainfi_tclMsgRetryGetChannelDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16ChannelID;
   virtual ~tcu_usb_mainfi_tclMsgRetryGetChannelDataMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgRetryGetChannelDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgRetryGetChannelDataMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgRetryGetChannelDataMethodResult();

   virtual ~tcu_usb_mainfi_tclMsgRetryGetChannelDataMethodResult();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgRetryGetChannelDataMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgOverwriteIVMTotalContentsMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgOverwriteIVMTotalContentsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgOverwriteIVMTotalContentsMethodStart& operator=(const tcu_usb_mainfi_tclMsgOverwriteIVMTotalContentsMethodStart& coRef);
   tcu_usb_mainfi_tclMsgOverwriteIVMTotalContentsMethodStart(const tcu_usb_mainfi_tclMsgOverwriteIVMTotalContentsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16ChannelID;
   tS64 s64IndexInternal;
   virtual ~tcu_usb_mainfi_tclMsgOverwriteIVMTotalContentsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgOverwriteIVMTotalContentsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgOverwriteIVMTotalContentsMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgOverwriteIVMTotalContentsMethodResult();

   virtual ~tcu_usb_mainfi_tclMsgOverwriteIVMTotalContentsMethodResult();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgOverwriteIVMTotalContentsMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgStoreCSHistoryMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgStoreCSHistoryMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgStoreCSHistoryMethodStart& operator=(const tcu_usb_mainfi_tclMsgStoreCSHistoryMethodStart& coRef);
   tcu_usb_mainfi_tclMsgStoreCSHistoryMethodStart(const tcu_usb_mainfi_tclMsgStoreCSHistoryMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tclString strKeyWord;
   virtual ~tcu_usb_mainfi_tclMsgStoreCSHistoryMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgStoreCSHistoryMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgStoreCSHistoryMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgStoreCSHistoryMethodResult();

   virtual ~tcu_usb_mainfi_tclMsgStoreCSHistoryMethodResult();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgStoreCSHistoryMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgGetTCUDeviceInfoMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgGetTCUDeviceInfoMethodStart();

   virtual ~tcu_usb_mainfi_tclMsgGetTCUDeviceInfoMethodStart();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgGetTCUDeviceInfoMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgGetTCUDeviceInfoMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgGetTCUDeviceInfoMethodResult();

   virtual ~tcu_usb_mainfi_tclMsgGetTCUDeviceInfoMethodResult();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgGetTCUDeviceInfoMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgSetLogLevelMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgSetLogLevelMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgSetLogLevelMethodStart& operator=(const tcu_usb_mainfi_tclMsgSetLogLevelMethodStart& coRef);
   tcu_usb_mainfi_tclMsgSetLogLevelMethodStart(const tcu_usb_mainfi_tclMsgSetLogLevelMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_e8_tcu_LogLevel u8LogLevel;
   virtual ~tcu_usb_mainfi_tclMsgSetLogLevelMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgSetLogLevelMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgSetLogLevelMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgSetLogLevelMethodResult();

   virtual ~tcu_usb_mainfi_tclMsgSetLogLevelMethodResult();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgSetLogLevelMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgRestoreFactorySettingsMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgRestoreFactorySettingsMethodStart();

   virtual ~tcu_usb_mainfi_tclMsgRestoreFactorySettingsMethodStart();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgRestoreFactorySettingsMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgRestoreFactorySettingsMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgRestoreFactorySettingsMethodResult();

   virtual ~tcu_usb_mainfi_tclMsgRestoreFactorySettingsMethodResult();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgRestoreFactorySettingsMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgDeleteMessageBoxMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgDeleteMessageBoxMethodStart();

   virtual ~tcu_usb_mainfi_tclMsgDeleteMessageBoxMethodStart();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgDeleteMessageBoxMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgDeleteMessageBoxMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgDeleteMessageBoxMethodResult();

   virtual ~tcu_usb_mainfi_tclMsgDeleteMessageBoxMethodResult();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgDeleteMessageBoxMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgInitializeFeedListMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgInitializeFeedListMethodStart();

   virtual ~tcu_usb_mainfi_tclMsgInitializeFeedListMethodStart();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgInitializeFeedListMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgInitializeFeedListMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgInitializeFeedListMethodResult();

   virtual ~tcu_usb_mainfi_tclMsgInitializeFeedListMethodResult();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgInitializeFeedListMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgSetAutoDownloadIntervalMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgSetAutoDownloadIntervalMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgSetAutoDownloadIntervalMethodStart& operator=(const tcu_usb_mainfi_tclMsgSetAutoDownloadIntervalMethodStart& coRef);
   tcu_usb_mainfi_tclMsgSetAutoDownloadIntervalMethodStart(const tcu_usb_mainfi_tclMsgSetAutoDownloadIntervalMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_e8_AutoDownloadInterval AutoDownloadInterval;
   virtual ~tcu_usb_mainfi_tclMsgSetAutoDownloadIntervalMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgSetAutoDownloadIntervalMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgSetAutoDownloadIntervalMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgSetAutoDownloadIntervalMethodResult();

   virtual ~tcu_usb_mainfi_tclMsgSetAutoDownloadIntervalMethodResult();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgSetAutoDownloadIntervalMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgGetAutoDownloadIntervalMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgGetAutoDownloadIntervalMethodStart();

   virtual ~tcu_usb_mainfi_tclMsgGetAutoDownloadIntervalMethodStart();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgGetAutoDownloadIntervalMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgGetAutoDownloadIntervalMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgGetAutoDownloadIntervalMethodResult();

   virtual ~tcu_usb_mainfi_tclMsgGetAutoDownloadIntervalMethodResult();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgGetAutoDownloadIntervalMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgSetAutoDownloadChannelMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgSetAutoDownloadChannelMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgSetAutoDownloadChannelMethodStart& operator=(const tcu_usb_mainfi_tclMsgSetAutoDownloadChannelMethodStart& coRef);
   tcu_usb_mainfi_tclMsgSetAutoDownloadChannelMethodStart(const tcu_usb_mainfi_tclMsgSetAutoDownloadChannelMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_usb_tcu_Channel_Info_List Channel_Info_List;
   virtual ~tcu_usb_mainfi_tclMsgSetAutoDownloadChannelMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgSetAutoDownloadChannelMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgSetAutoDownloadChannelMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgSetAutoDownloadChannelMethodResult();

   virtual ~tcu_usb_mainfi_tclMsgSetAutoDownloadChannelMethodResult();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgSetAutoDownloadChannelMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgGetFavoriteChannelListMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgGetFavoriteChannelListMethodStart();

   virtual ~tcu_usb_mainfi_tclMsgGetFavoriteChannelListMethodStart();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgGetFavoriteChannelListMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgGetFavoriteChannelListMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgGetFavoriteChannelListMethodResult();

   virtual ~tcu_usb_mainfi_tclMsgGetFavoriteChannelListMethodResult();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgGetFavoriteChannelListMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgSetFavoriteChannelMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgSetFavoriteChannelMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgSetFavoriteChannelMethodStart& operator=(const tcu_usb_mainfi_tclMsgSetFavoriteChannelMethodStart& coRef);
   tcu_usb_mainfi_tclMsgSetFavoriteChannelMethodStart(const tcu_usb_mainfi_tclMsgSetFavoriteChannelMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_usb_tcu_Channel_Info_List Channel_Info_List;
   virtual ~tcu_usb_mainfi_tclMsgSetFavoriteChannelMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgSetFavoriteChannelMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgSetFavoriteChannelMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgSetFavoriteChannelMethodResult();

   virtual ~tcu_usb_mainfi_tclMsgSetFavoriteChannelMethodResult();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgSetFavoriteChannelMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgReadFavoriteFeedsMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgReadFavoriteFeedsMethodStart();

   virtual ~tcu_usb_mainfi_tclMsgReadFavoriteFeedsMethodStart();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgReadFavoriteFeedsMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgReadFavoriteFeedsMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgReadFavoriteFeedsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgReadFavoriteFeedsMethodResult& operator=(const tcu_usb_mainfi_tclMsgReadFavoriteFeedsMethodResult& coRef);
   tcu_usb_mainfi_tclMsgReadFavoriteFeedsMethodResult(const tcu_usb_mainfi_tclMsgReadFavoriteFeedsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_usb_tcu_Favorite_Feed_List Favorite_Feed_List;
   virtual ~tcu_usb_mainfi_tclMsgReadFavoriteFeedsMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgReadFavoriteFeedsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgSelectFavoriteFeedsMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgSelectFavoriteFeedsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgSelectFavoriteFeedsMethodStart& operator=(const tcu_usb_mainfi_tclMsgSelectFavoriteFeedsMethodStart& coRef);
   tcu_usb_mainfi_tclMsgSelectFavoriteFeedsMethodStart(const tcu_usb_mainfi_tclMsgSelectFavoriteFeedsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16ChannelID;
   virtual ~tcu_usb_mainfi_tclMsgSelectFavoriteFeedsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgSelectFavoriteFeedsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgSelectFavoriteFeedsMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgSelectFavoriteFeedsMethodResult();

   virtual ~tcu_usb_mainfi_tclMsgSelectFavoriteFeedsMethodResult();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgSelectFavoriteFeedsMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgDeleteInfoHistoryMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgDeleteInfoHistoryMethodStart();

   virtual ~tcu_usb_mainfi_tclMsgDeleteInfoHistoryMethodStart();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgDeleteInfoHistoryMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgDeleteInfoHistoryMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgDeleteInfoHistoryMethodResult();

   virtual ~tcu_usb_mainfi_tclMsgDeleteInfoHistoryMethodResult();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgDeleteInfoHistoryMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgGetVICSTrafficDataMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgGetVICSTrafficDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgGetVICSTrafficDataMethodStart& operator=(const tcu_usb_mainfi_tclMsgGetVICSTrafficDataMethodStart& coRef);
   tcu_usb_mainfi_tclMsgGetVICSTrafficDataMethodStart(const tcu_usb_mainfi_tclMsgGetVICSTrafficDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_tcu_VICS_Request_Data VICSRequestData;
   virtual ~tcu_usb_mainfi_tclMsgGetVICSTrafficDataMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgGetVICSTrafficDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgGetVICSTrafficDataMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgGetVICSTrafficDataMethodResult();

   virtual ~tcu_usb_mainfi_tclMsgGetVICSTrafficDataMethodResult();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgGetVICSTrafficDataMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgGetChargingStationsListMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgGetChargingStationsListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgGetChargingStationsListMethodStart& operator=(const tcu_usb_mainfi_tclMsgGetChargingStationsListMethodStart& coRef);
   tcu_usb_mainfi_tclMsgGetChargingStationsListMethodStart(const tcu_usb_mainfi_tclMsgGetChargingStationsListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_usb_tcu_Charging_Stations_Request_Info ChargingStationsRequestInfo;
   virtual ~tcu_usb_mainfi_tclMsgGetChargingStationsListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgGetChargingStationsListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgGetChargingStationsListMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgGetChargingStationsListMethodResult();

   virtual ~tcu_usb_mainfi_tclMsgGetChargingStationsListMethodResult();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgGetChargingStationsListMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgGetChargingSpotDataMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgGetChargingSpotDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgGetChargingSpotDataMethodStart& operator=(const tcu_usb_mainfi_tclMsgGetChargingSpotDataMethodStart& coRef);
   tcu_usb_mainfi_tclMsgGetChargingSpotDataMethodStart(const tcu_usb_mainfi_tclMsgGetChargingSpotDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_usb_tcu_POIID_List POIIDList;
   virtual ~tcu_usb_mainfi_tclMsgGetChargingSpotDataMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgGetChargingSpotDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgGetChargingSpotDataMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgGetChargingSpotDataMethodResult();

   virtual ~tcu_usb_mainfi_tclMsgGetChargingSpotDataMethodResult();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgGetChargingSpotDataMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgGetVacancySpotDataMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgGetVacancySpotDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgGetVacancySpotDataMethodStart& operator=(const tcu_usb_mainfi_tclMsgGetVacancySpotDataMethodStart& coRef);
   tcu_usb_mainfi_tclMsgGetVacancySpotDataMethodStart(const tcu_usb_mainfi_tclMsgGetVacancySpotDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_usb_tcu_POIID_List POIIDList;
   virtual ~tcu_usb_mainfi_tclMsgGetVacancySpotDataMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgGetVacancySpotDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgGetVacancySpotDataMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgGetVacancySpotDataMethodResult();

   virtual ~tcu_usb_mainfi_tclMsgGetVacancySpotDataMethodResult();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgGetVacancySpotDataMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgGetVacancyStationsListMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgGetVacancyStationsListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgGetVacancyStationsListMethodStart& operator=(const tcu_usb_mainfi_tclMsgGetVacancyStationsListMethodStart& coRef);
   tcu_usb_mainfi_tclMsgGetVacancyStationsListMethodStart(const tcu_usb_mainfi_tclMsgGetVacancyStationsListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_usb_tcu_Vacancy_Stations_Request_Info VacancyStationsRequestInfo;
   virtual ~tcu_usb_mainfi_tclMsgGetVacancyStationsListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgGetVacancyStationsListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgGetVacancyStationsListMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgGetVacancyStationsListMethodResult();

   virtual ~tcu_usb_mainfi_tclMsgGetVacancyStationsListMethodResult();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgGetVacancyStationsListMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgSendUserCredentialsMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgSendUserCredentialsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgSendUserCredentialsMethodStart& operator=(const tcu_usb_mainfi_tclMsgSendUserCredentialsMethodStart& coRef);
   tcu_usb_mainfi_tclMsgSendUserCredentialsMethodStart(const tcu_usb_mainfi_tclMsgSendUserCredentialsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tclString sUserId;
   tcu_usb_fi_tclString sPassword;
   tBool bClearData;
   virtual ~tcu_usb_mainfi_tclMsgSendUserCredentialsMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgSendUserCredentialsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgSendUserCredentialsMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgSendUserCredentialsMethodResult();

   virtual ~tcu_usb_mainfi_tclMsgSendUserCredentialsMethodResult();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgSendUserCredentialsMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgDeleteChannelInformationMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgDeleteChannelInformationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgDeleteChannelInformationMethodStart& operator=(const tcu_usb_mainfi_tclMsgDeleteChannelInformationMethodStart& coRef);
   tcu_usb_mainfi_tclMsgDeleteChannelInformationMethodStart(const tcu_usb_mainfi_tclMsgDeleteChannelInformationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16ChannelID;
   virtual ~tcu_usb_mainfi_tclMsgDeleteChannelInformationMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgDeleteChannelInformationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgDeleteChannelInformationMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgDeleteChannelInformationMethodResult();

   virtual ~tcu_usb_mainfi_tclMsgDeleteChannelInformationMethodResult();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgDeleteChannelInformationMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgDownloadPartAuthDataMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgDownloadPartAuthDataMethodStart();

   virtual ~tcu_usb_mainfi_tclMsgDownloadPartAuthDataMethodStart();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgDownloadPartAuthDataMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgDownloadPartAuthDataMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgDownloadPartAuthDataMethodResult();

   virtual ~tcu_usb_mainfi_tclMsgDownloadPartAuthDataMethodResult();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgDownloadPartAuthDataMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodStart& operator=(const tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodStart& coRef);
   tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodStart(const tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tclString sUserId;
   tcu_usb_fi_tclString sPassword;
   virtual ~tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodResult& operator=(const tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodResult& coRef);
   tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodResult(const tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_e8_UserAuthenticationResultType Result;
   tcu_usb_fi_tclString Token;
   virtual ~tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgRenewAccessTokenMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgRenewAccessTokenMethodStart();

   virtual ~tcu_usb_mainfi_tclMsgRenewAccessTokenMethodStart();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgRenewAccessTokenMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgRenewAccessTokenMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgRenewAccessTokenMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgRenewAccessTokenMethodResult& operator=(const tcu_usb_mainfi_tclMsgRenewAccessTokenMethodResult& coRef);
   tcu_usb_mainfi_tclMsgRenewAccessTokenMethodResult(const tcu_usb_mainfi_tclMsgRenewAccessTokenMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_e8_UserAuthenticationResultType Result;
   tcu_usb_fi_tclString Token;
   virtual ~tcu_usb_mainfi_tclMsgRenewAccessTokenMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgRenewAccessTokenMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgGetAccessTokenMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgGetAccessTokenMethodStart();

   virtual ~tcu_usb_mainfi_tclMsgGetAccessTokenMethodStart();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgGetAccessTokenMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgGetAccessTokenMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgGetAccessTokenMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgGetAccessTokenMethodResult& operator=(const tcu_usb_mainfi_tclMsgGetAccessTokenMethodResult& coRef);
   tcu_usb_mainfi_tclMsgGetAccessTokenMethodResult(const tcu_usb_mainfi_tclMsgGetAccessTokenMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_e8_UserAuthenticationResultType Result;
   tcu_usb_fi_tclString Token;
   virtual ~tcu_usb_mainfi_tclMsgGetAccessTokenMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgGetAccessTokenMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodStart& operator=(const tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodStart& coRef);
   tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodStart(const tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tclString sUserId;
   tcu_usb_fi_tclString sPassword;
   virtual ~tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodResult& operator=(const tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodResult& coRef);
   tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodResult(const tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_e8_UserAuthenticationResultType Result;
   virtual ~tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgCancelUserValidationRenewTokenMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgCancelUserValidationRenewTokenMethodStart();

   virtual ~tcu_usb_mainfi_tclMsgCancelUserValidationRenewTokenMethodStart();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgCancelUserValidationRenewTokenMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgCancelUserValidationRenewTokenMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgCancelUserValidationRenewTokenMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgCancelUserValidationRenewTokenMethodResult& operator=(const tcu_usb_mainfi_tclMsgCancelUserValidationRenewTokenMethodResult& coRef);
   tcu_usb_mainfi_tclMsgCancelUserValidationRenewTokenMethodResult(const tcu_usb_mainfi_tclMsgCancelUserValidationRenewTokenMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_e8_UserAuthenticationResultType Result;
   virtual ~tcu_usb_mainfi_tclMsgCancelUserValidationRenewTokenMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgCancelUserValidationRenewTokenMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgDecodeIdTokenMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgDecodeIdTokenMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgDecodeIdTokenMethodStart& operator=(const tcu_usb_mainfi_tclMsgDecodeIdTokenMethodStart& coRef);
   tcu_usb_mainfi_tclMsgDecodeIdTokenMethodStart(const tcu_usb_mainfi_tclMsgDecodeIdTokenMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tclString Token;
   virtual ~tcu_usb_mainfi_tclMsgDecodeIdTokenMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgDecodeIdTokenMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgDecodeIdTokenMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgDecodeIdTokenMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgDecodeIdTokenMethodResult& operator=(const tcu_usb_mainfi_tclMsgDecodeIdTokenMethodResult& coRef);
   tcu_usb_mainfi_tclMsgDecodeIdTokenMethodResult(const tcu_usb_mainfi_tclMsgDecodeIdTokenMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_usb_tcu_UserAuthentication_DecodedToken_Info Result;
   virtual ~tcu_usb_mainfi_tclMsgDecodeIdTokenMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgDecodeIdTokenMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgResetNCSSettingsMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgResetNCSSettingsMethodStart();

   virtual ~tcu_usb_mainfi_tclMsgResetNCSSettingsMethodStart();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgResetNCSSettingsMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgResetNCSSettingsMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgResetNCSSettingsMethodResult();

   virtual ~tcu_usb_mainfi_tclMsgResetNCSSettingsMethodResult();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgResetNCSSettingsMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgGetProbeUploadPermitMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgGetProbeUploadPermitMethodStart();

   virtual ~tcu_usb_mainfi_tclMsgGetProbeUploadPermitMethodStart();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgGetProbeUploadPermitMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgGetProbeUploadPermitMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgGetProbeUploadPermitMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgGetProbeUploadPermitMethodResult& operator=(const tcu_usb_mainfi_tclMsgGetProbeUploadPermitMethodResult& coRef);
   tcu_usb_mainfi_tclMsgGetProbeUploadPermitMethodResult(const tcu_usb_mainfi_tclMsgGetProbeUploadPermitMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_e8_TCU_ProbePermitSetting e8ProbePermitSetting;
   virtual ~tcu_usb_mainfi_tclMsgGetProbeUploadPermitMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgGetProbeUploadPermitMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodStart& operator=(const tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodStart& coRef);
   tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodStart(const tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_e8_TCU_ProbePermitSetting e8ProbePermitSetting;
   virtual ~tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodResult& operator=(const tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodResult& coRef);
   tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodResult(const tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_e8_TCU_ProbePermitSetting e8ProbePermitSetting;
   virtual ~tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgSetProbeInfoDeleteMethodStart : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgSetProbeInfoDeleteMethodStart();

   virtual ~tcu_usb_mainfi_tclMsgSetProbeInfoDeleteMethodStart();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgSetProbeInfoDeleteMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgSetProbeInfoDeleteMethodResult : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgSetProbeInfoDeleteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgSetProbeInfoDeleteMethodResult& operator=(const tcu_usb_mainfi_tclMsgSetProbeInfoDeleteMethodResult& coRef);
   tcu_usb_mainfi_tclMsgSetProbeInfoDeleteMethodResult(const tcu_usb_mainfi_tclMsgSetProbeInfoDeleteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bStatusFromTCU;
   virtual ~tcu_usb_mainfi_tclMsgSetProbeInfoDeleteMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgSetProbeInfoDeleteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgUserCredentialStatusUpReg : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgUserCredentialStatusUpReg();

   virtual ~tcu_usb_mainfi_tclMsgUserCredentialStatusUpReg();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgUserCredentialStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgUserCredentialStatusRelUpReg : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgUserCredentialStatusRelUpReg();

   virtual ~tcu_usb_mainfi_tclMsgUserCredentialStatusRelUpReg();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgUserCredentialStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgUserCredentialStatusStatus : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgUserCredentialStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgUserCredentialStatusStatus& operator=(const tcu_usb_mainfi_tclMsgUserCredentialStatusStatus& coRef);
   tcu_usb_mainfi_tclMsgUserCredentialStatusStatus(const tcu_usb_mainfi_tclMsgUserCredentialStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tclString sDisplayMessage;
   tcu_usb_fi_tclString sTTSTextMessage;
   tcu_usb_fi_tcl_e8_tcu_Authentication_Result e8AuthenticationResult;
   virtual ~tcu_usb_mainfi_tclMsgUserCredentialStatusStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgUserCredentialStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgNotifyTokenRenewalErrorStatus : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgNotifyTokenRenewalErrorStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgNotifyTokenRenewalErrorStatus& operator=(const tcu_usb_mainfi_tclMsgNotifyTokenRenewalErrorStatus& coRef);
   tcu_usb_mainfi_tclMsgNotifyTokenRenewalErrorStatus(const tcu_usb_mainfi_tclMsgNotifyTokenRenewalErrorStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool ShowCredentialsScreen;
   virtual ~tcu_usb_mainfi_tclMsgNotifyTokenRenewalErrorStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgNotifyTokenRenewalErrorStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgConnectedSearchResultUpReg : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgConnectedSearchResultUpReg();

   virtual ~tcu_usb_mainfi_tclMsgConnectedSearchResultUpReg();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgConnectedSearchResultUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgConnectedSearchResultRelUpReg : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgConnectedSearchResultRelUpReg();

   virtual ~tcu_usb_mainfi_tclMsgConnectedSearchResultRelUpReg();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgConnectedSearchResultRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgConnectedSearchResultStatus : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgConnectedSearchResultStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgConnectedSearchResultStatus& operator=(const tcu_usb_mainfi_tclMsgConnectedSearchResultStatus& coRef);
   tcu_usb_mainfi_tclMsgConnectedSearchResultStatus(const tcu_usb_mainfi_tclMsgConnectedSearchResultStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_usb_tcu_connected_search_result ConnectedSearch;
   tcu_usb_fi_tcl_e8_ConnectedSearchServiceType ServiceType;
   tcu_usb_fi_tcl_e8_tcu_ExecType u8ExecType;
   virtual ~tcu_usb_mainfi_tclMsgConnectedSearchResultStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgConnectedSearchResultStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgChannelMasterDataUpReg : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgChannelMasterDataUpReg();

   virtual ~tcu_usb_mainfi_tclMsgChannelMasterDataUpReg();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgChannelMasterDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgChannelMasterDataRelUpReg : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgChannelMasterDataRelUpReg();

   virtual ~tcu_usb_mainfi_tclMsgChannelMasterDataRelUpReg();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgChannelMasterDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgChannelMasterDataStatus : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgChannelMasterDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgChannelMasterDataStatus& operator=(const tcu_usb_mainfi_tclMsgChannelMasterDataStatus& coRef);
   tcu_usb_mainfi_tclMsgChannelMasterDataStatus(const tcu_usb_mainfi_tclMsgChannelMasterDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_usb_tcu_channel_master_data ChannelMasterData;
   virtual ~tcu_usb_mainfi_tclMsgChannelMasterDataStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgChannelMasterDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgTtsAudioStateRequestUpReg : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgTtsAudioStateRequestUpReg();

   virtual ~tcu_usb_mainfi_tclMsgTtsAudioStateRequestUpReg();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgTtsAudioStateRequestUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgTtsAudioStateRequestRelUpReg : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgTtsAudioStateRequestRelUpReg();

   virtual ~tcu_usb_mainfi_tclMsgTtsAudioStateRequestRelUpReg();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgTtsAudioStateRequestRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgTtsAudioStateRequestStatus : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgTtsAudioStateRequestStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgTtsAudioStateRequestStatus& operator=(const tcu_usb_mainfi_tclMsgTtsAudioStateRequestStatus& coRef);
   tcu_usb_mainfi_tclMsgTtsAudioStateRequestStatus(const tcu_usb_mainfi_tclMsgTtsAudioStateRequestStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_e8_tcu_AudioActivity AudioActivity;
   virtual ~tcu_usb_mainfi_tclMsgTtsAudioStateRequestStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgTtsAudioStateRequestStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgDatabaseStatusUpReg : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgDatabaseStatusUpReg();

   virtual ~tcu_usb_mainfi_tclMsgDatabaseStatusUpReg();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgDatabaseStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgDatabaseStatusRelUpReg : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgDatabaseStatusRelUpReg();

   virtual ~tcu_usb_mainfi_tclMsgDatabaseStatusRelUpReg();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgDatabaseStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgDatabaseStatusStatus : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgDatabaseStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgDatabaseStatusStatus& operator=(const tcu_usb_mainfi_tclMsgDatabaseStatusStatus& coRef);
   tcu_usb_mainfi_tclMsgDatabaseStatusStatus(const tcu_usb_mainfi_tclMsgDatabaseStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_e8_DatabaseStatus DatabaseStatus;
   tcu_usb_fi_tclString Databasepath;
   tcu_usb_fi_tcl_e8_DatabaseServiceType DatabaseServiceType;
   tBool PopupEnabled;
   virtual ~tcu_usb_mainfi_tclMsgDatabaseStatusStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgDatabaseStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgDatabaseStatusSet : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgDatabaseStatusSet();

   virtual ~tcu_usb_mainfi_tclMsgDatabaseStatusSet();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgDatabaseStatusSet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgDataConnectionStatusUpReg : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgDataConnectionStatusUpReg();

   virtual ~tcu_usb_mainfi_tclMsgDataConnectionStatusUpReg();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgDataConnectionStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgDataConnectionStatusRelUpReg : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgDataConnectionStatusRelUpReg();

   virtual ~tcu_usb_mainfi_tclMsgDataConnectionStatusRelUpReg();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgDataConnectionStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgDataConnectionStatusStatus : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgDataConnectionStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgDataConnectionStatusStatus& operator=(const tcu_usb_mainfi_tclMsgDataConnectionStatusStatus& coRef);
   tcu_usb_mainfi_tclMsgDataConnectionStatusStatus(const tcu_usb_mainfi_tclMsgDataConnectionStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_e8_DataConnectionStatus DataConnectionStatus;
   virtual ~tcu_usb_mainfi_tclMsgDataConnectionStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgDataConnectionStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgDataConnectionErrorUpReg : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgDataConnectionErrorUpReg();

   virtual ~tcu_usb_mainfi_tclMsgDataConnectionErrorUpReg();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgDataConnectionErrorUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgDataConnectionErrorRelUpReg : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgDataConnectionErrorRelUpReg();

   virtual ~tcu_usb_mainfi_tclMsgDataConnectionErrorRelUpReg();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgDataConnectionErrorRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgDataConnectionErrorStatus : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgDataConnectionErrorStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgDataConnectionErrorStatus& operator=(const tcu_usb_mainfi_tclMsgDataConnectionErrorStatus& coRef);
   tcu_usb_mainfi_tclMsgDataConnectionErrorStatus(const tcu_usb_mainfi_tclMsgDataConnectionErrorStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_e16_DataConnectionError DataConnectionError;
   tcu_usb_fi_tcl_e8_ServiceType ServiceType;
   virtual ~tcu_usb_mainfi_tclMsgDataConnectionErrorStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgDataConnectionErrorStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgServerListUpReg : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgServerListUpReg();

   virtual ~tcu_usb_mainfi_tclMsgServerListUpReg();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgServerListUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgServerListRelUpReg : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgServerListRelUpReg();

   virtual ~tcu_usb_mainfi_tclMsgServerListRelUpReg();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgServerListRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgServerListStatus : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgServerListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgServerListStatus& operator=(const tcu_usb_mainfi_tclMsgServerListStatus& coRef);
   tcu_usb_mainfi_tclMsgServerListStatus(const tcu_usb_mainfi_tclMsgServerListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_usb_tcu_Server_Info_List ServerInfoList;
   tU8 u8ActiveServerId;
   virtual ~tcu_usb_mainfi_tclMsgServerListStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgServerListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgTCUDeviceInfoUpReg : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgTCUDeviceInfoUpReg();

   virtual ~tcu_usb_mainfi_tclMsgTCUDeviceInfoUpReg();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgTCUDeviceInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgTCUDeviceInfoRelUpReg : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgTCUDeviceInfoRelUpReg();

   virtual ~tcu_usb_mainfi_tclMsgTCUDeviceInfoRelUpReg();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgTCUDeviceInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgTCUDeviceInfoStatus : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgTCUDeviceInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgTCUDeviceInfoStatus& operator=(const tcu_usb_mainfi_tclMsgTCUDeviceInfoStatus& coRef);
   tcu_usb_mainfi_tclMsgTCUDeviceInfoStatus(const tcu_usb_mainfi_tclMsgTCUDeviceInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_usb_tcu_TCUDevice_Info TCUDeviceInfo;
   virtual ~tcu_usb_mainfi_tclMsgTCUDeviceInfoStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgTCUDeviceInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalUpReg : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalUpReg();

   virtual ~tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalUpReg();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalRelUpReg : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalRelUpReg();

   virtual ~tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalRelUpReg();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalStatus : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalStatus& operator=(const tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalStatus& coRef);
   tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalStatus(const tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_e8_AutoDownloadInterval AutoDownloadInterval;
   virtual ~tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgGeneralNotificationMessageUpReg : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgGeneralNotificationMessageUpReg();

   virtual ~tcu_usb_mainfi_tclMsgGeneralNotificationMessageUpReg();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgGeneralNotificationMessageUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgGeneralNotificationMessageRelUpReg : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgGeneralNotificationMessageRelUpReg();

   virtual ~tcu_usb_mainfi_tclMsgGeneralNotificationMessageRelUpReg();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgGeneralNotificationMessageRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgGeneralNotificationMessageStatus : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgGeneralNotificationMessageStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgGeneralNotificationMessageStatus& operator=(const tcu_usb_mainfi_tclMsgGeneralNotificationMessageStatus& coRef);
   tcu_usb_mainfi_tclMsgGeneralNotificationMessageStatus(const tcu_usb_mainfi_tclMsgGeneralNotificationMessageStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_e8_tcu_NotiResult GeneralNotificationResult;
   tcu_usb_fi_tclString DisplayMessage;
   tcu_usb_fi_tclString TTSTextMessage;
   virtual ~tcu_usb_mainfi_tclMsgGeneralNotificationMessageStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgGeneralNotificationMessageStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgAuthenticationResultDataUpReg : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgAuthenticationResultDataUpReg();

   virtual ~tcu_usb_mainfi_tclMsgAuthenticationResultDataUpReg();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgAuthenticationResultDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgAuthenticationResultDataRelUpReg : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgAuthenticationResultDataRelUpReg();

   virtual ~tcu_usb_mainfi_tclMsgAuthenticationResultDataRelUpReg();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgAuthenticationResultDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgAuthenticationResultDataStatus : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgAuthenticationResultDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgAuthenticationResultDataStatus& operator=(const tcu_usb_mainfi_tclMsgAuthenticationResultDataStatus& coRef);
   tcu_usb_mainfi_tclMsgAuthenticationResultDataStatus(const tcu_usb_mainfi_tclMsgAuthenticationResultDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tclString DisplayMessage;
   tcu_usb_fi_tclString TTSTextMessage;
   virtual ~tcu_usb_mainfi_tclMsgAuthenticationResultDataStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgAuthenticationResultDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgVICSTrafficDataUpReg : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgVICSTrafficDataUpReg();

   virtual ~tcu_usb_mainfi_tclMsgVICSTrafficDataUpReg();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgVICSTrafficDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgVICSTrafficDataRelUpReg : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgVICSTrafficDataRelUpReg();

   virtual ~tcu_usb_mainfi_tclMsgVICSTrafficDataRelUpReg();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgVICSTrafficDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgVICSTrafficDataStatus : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgVICSTrafficDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgVICSTrafficDataStatus& operator=(const tcu_usb_mainfi_tclMsgVICSTrafficDataStatus& coRef);
   tcu_usb_mainfi_tclMsgVICSTrafficDataStatus(const tcu_usb_mainfi_tclMsgVICSTrafficDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tclString strFilePathWithFileName;
   tcu_usb_fi_tcl_e8_tcu_VICS_Response_Data VICSResponseData;
   virtual ~tcu_usb_mainfi_tclMsgVICSTrafficDataStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgVICSTrafficDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgChargingStationsListUpReg : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgChargingStationsListUpReg();

   virtual ~tcu_usb_mainfi_tclMsgChargingStationsListUpReg();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgChargingStationsListUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgChargingStationsListRelUpReg : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgChargingStationsListRelUpReg();

   virtual ~tcu_usb_mainfi_tclMsgChargingStationsListRelUpReg();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgChargingStationsListRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgChargingStationsListStatus : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgChargingStationsListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgChargingStationsListStatus& operator=(const tcu_usb_mainfi_tclMsgChargingStationsListStatus& coRef);
   tcu_usb_mainfi_tclMsgChargingStationsListStatus(const tcu_usb_mainfi_tclMsgChargingStationsListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_tcu_response_charging_stations_list_result ChargingStationsList;
   virtual ~tcu_usb_mainfi_tclMsgChargingStationsListStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgChargingStationsListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgChargingSpotDataUpReg : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgChargingSpotDataUpReg();

   virtual ~tcu_usb_mainfi_tclMsgChargingSpotDataUpReg();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgChargingSpotDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgChargingSpotDataRelUpReg : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgChargingSpotDataRelUpReg();

   virtual ~tcu_usb_mainfi_tclMsgChargingSpotDataRelUpReg();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgChargingSpotDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgChargingSpotDataStatus : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgChargingSpotDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgChargingSpotDataStatus& operator=(const tcu_usb_mainfi_tclMsgChargingSpotDataStatus& coRef);
   tcu_usb_mainfi_tclMsgChargingSpotDataStatus(const tcu_usb_mainfi_tclMsgChargingSpotDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_tcu_response_charging_spot_data_result ChargingSpotData;
   virtual ~tcu_usb_mainfi_tclMsgChargingSpotDataStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgChargingSpotDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgVacancyStationsListUpReg : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgVacancyStationsListUpReg();

   virtual ~tcu_usb_mainfi_tclMsgVacancyStationsListUpReg();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgVacancyStationsListUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgVacancyStationsListRelUpReg : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgVacancyStationsListRelUpReg();

   virtual ~tcu_usb_mainfi_tclMsgVacancyStationsListRelUpReg();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgVacancyStationsListRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgVacancyStationsListStatus : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgVacancyStationsListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgVacancyStationsListStatus& operator=(const tcu_usb_mainfi_tclMsgVacancyStationsListStatus& coRef);
   tcu_usb_mainfi_tclMsgVacancyStationsListStatus(const tcu_usb_mainfi_tclMsgVacancyStationsListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_tcu_response_vacancy_stations_list_result VacancyStationsList;
   virtual ~tcu_usb_mainfi_tclMsgVacancyStationsListStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgVacancyStationsListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgVacancySpotDataUpReg : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgVacancySpotDataUpReg();

   virtual ~tcu_usb_mainfi_tclMsgVacancySpotDataUpReg();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgVacancySpotDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgVacancySpotDataRelUpReg : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgVacancySpotDataRelUpReg();

   virtual ~tcu_usb_mainfi_tclMsgVacancySpotDataRelUpReg();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgVacancySpotDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgVacancySpotDataStatus : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgVacancySpotDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgVacancySpotDataStatus& operator=(const tcu_usb_mainfi_tclMsgVacancySpotDataStatus& coRef);
   tcu_usb_mainfi_tclMsgVacancySpotDataStatus(const tcu_usb_mainfi_tclMsgVacancySpotDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_tcu_response_vacancy_spot_data_result VacancySpotData;
   virtual ~tcu_usb_mainfi_tclMsgVacancySpotDataStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgVacancySpotDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgGeneralResponseErrorUpReg : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgGeneralResponseErrorUpReg();

   virtual ~tcu_usb_mainfi_tclMsgGeneralResponseErrorUpReg();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgGeneralResponseErrorUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgGeneralResponseErrorRelUpReg : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgGeneralResponseErrorRelUpReg();

   virtual ~tcu_usb_mainfi_tclMsgGeneralResponseErrorRelUpReg();

   inline tBool operator==(const tcu_usb_mainfi_tclMsgGeneralResponseErrorRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class tcu_usb_mainfi_tclMsgGeneralResponseErrorStatus : public tcu_usb_mainfi_tclMsgBaseMessage
{
public:

   tcu_usb_mainfi_tclMsgGeneralResponseErrorStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_mainfi_tclMsgGeneralResponseErrorStatus& operator=(const tcu_usb_mainfi_tclMsgGeneralResponseErrorStatus& coRef);
   tcu_usb_mainfi_tclMsgGeneralResponseErrorStatus(const tcu_usb_mainfi_tclMsgGeneralResponseErrorStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool GeneralResponseDataError;
   virtual ~tcu_usb_mainfi_tclMsgGeneralResponseErrorStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_mainfi_tclMsgGeneralResponseErrorStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
