/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define TCU_USB_FI_S_IMPORT_INTERFACE_TCU_USB_MAINFI_TYPES
#define TCU_USB_FI_S_IMPORT_INTERFACE_TCU_USB_MAINFI_FUNCTIONIDS
#define TCU_USB_FI_S_IMPORT_INTERFACE_TCU_USB_MAINFI_SERVICEINFO
#include "tcu_usb_fi_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for tcu_usb_main_fi message types

fi_tclMessageBase* tcu_usb_mainfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case tcu_usb_mainfi_tclToken::EN_MSG_GETCHANNELDATAMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgGetChannelDataMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_GETCHANNELDATAMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgGetChannelDataMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_GETCONNECTEDSEARCHRESULTMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgGetConnectedSearchResultMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_GETCONNECTEDSEARCHRESULTMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgGetConnectedSearchResultMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_GETCHANNELMASTERDATAMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgGetChannelMasterDataMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_GETCHANNELMASTERDATAMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgGetChannelMasterDataMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_SYNTHESIZESPEAKMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_SYNTHESIZESPEAKMETHODRESULTFIRST:
         return OSAL_NEW tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodResultFirst;

      case tcu_usb_mainfi_tclToken::EN_MSG_SYNTHESIZESPEAKMETHODRESULTMIDDLE:
         return OSAL_NEW tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodResultMiddle;

      case tcu_usb_mainfi_tclToken::EN_MSG_SYNTHESIZESPEAKMETHODRESULTLAST:
         return OSAL_NEW tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodResultLast;

      case tcu_usb_mainfi_tclToken::EN_MSG_ABORTPROMPTMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgAbortPromptMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_ABORTPROMPTMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgAbortPromptMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_PAUSEPROMPTMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgPausePromptMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_PAUSEPROMPTMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgPausePromptMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_CONTINUEPROMPTMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgContinuePromptMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_CONTINUEPROMPTMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgContinuePromptMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_CANCELREQUESTMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgCancelRequestMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_CANCELREQUESTMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgCancelRequestMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_SENDGROUPADATAMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgSendGroupADataMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_SENDGROUPADATAMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgSendGroupADataMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_DELETEINVEHICLEMESSAGEMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgDeleteInVehicleMessageMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_DELETEINVEHICLEMESSAGEMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgDeleteInVehicleMessageMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_RESETDATABASEMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgResetDatabaseMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_RESETDATABASEMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgResetDatabaseMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_GETSERVERLISTMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgGetServerListMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_GETSERVERLISTMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgGetServerListMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_SELECTSERVERMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgSelectServerMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_SELECTSERVERMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgSelectServerMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_RETRYGETCHANNELDATAMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgRetryGetChannelDataMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_RETRYGETCHANNELDATAMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgRetryGetChannelDataMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_OVERWRITEIVMTOTALCONTENTSMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgOverwriteIVMTotalContentsMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_OVERWRITEIVMTOTALCONTENTSMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgOverwriteIVMTotalContentsMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_STORECSHISTORYMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgStoreCSHistoryMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_STORECSHISTORYMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgStoreCSHistoryMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_GETTCUDEVICEINFOMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgGetTCUDeviceInfoMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_GETTCUDEVICEINFOMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgGetTCUDeviceInfoMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_SETLOGLEVELMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgSetLogLevelMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_SETLOGLEVELMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgSetLogLevelMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_RESTOREFACTORYSETTINGSMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgRestoreFactorySettingsMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_RESTOREFACTORYSETTINGSMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgRestoreFactorySettingsMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_DELETEMESSAGEBOXMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgDeleteMessageBoxMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_DELETEMESSAGEBOXMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgDeleteMessageBoxMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_INITIALIZEFEEDLISTMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgInitializeFeedListMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_INITIALIZEFEEDLISTMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgInitializeFeedListMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_SETAUTODOWNLOADINTERVALMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgSetAutoDownloadIntervalMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_SETAUTODOWNLOADINTERVALMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgSetAutoDownloadIntervalMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_GETAUTODOWNLOADINTERVALMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgGetAutoDownloadIntervalMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_GETAUTODOWNLOADINTERVALMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgGetAutoDownloadIntervalMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_SETAUTODOWNLOADCHANNELMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgSetAutoDownloadChannelMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_SETAUTODOWNLOADCHANNELMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgSetAutoDownloadChannelMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_GETFAVORITECHANNELLISTMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgGetFavoriteChannelListMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_GETFAVORITECHANNELLISTMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgGetFavoriteChannelListMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_SETFAVORITECHANNELMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgSetFavoriteChannelMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_SETFAVORITECHANNELMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgSetFavoriteChannelMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_READFAVORITEFEEDSMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgReadFavoriteFeedsMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_READFAVORITEFEEDSMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgReadFavoriteFeedsMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_SELECTFAVORITEFEEDSMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgSelectFavoriteFeedsMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_SELECTFAVORITEFEEDSMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgSelectFavoriteFeedsMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_DELETEINFOHISTORYMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgDeleteInfoHistoryMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_DELETEINFOHISTORYMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgDeleteInfoHistoryMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_GETVICSTRAFFICDATAMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgGetVICSTrafficDataMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_GETVICSTRAFFICDATAMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgGetVICSTrafficDataMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_GETCHARGINGSTATIONSLISTMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgGetChargingStationsListMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_GETCHARGINGSTATIONSLISTMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgGetChargingStationsListMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_GETCHARGINGSPOTDATAMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgGetChargingSpotDataMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_GETCHARGINGSPOTDATAMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgGetChargingSpotDataMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_GETVACANCYSPOTDATAMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgGetVacancySpotDataMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_GETVACANCYSPOTDATAMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgGetVacancySpotDataMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_GETVACANCYSTATIONSLISTMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgGetVacancyStationsListMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_GETVACANCYSTATIONSLISTMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgGetVacancyStationsListMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_SENDUSERCREDENTIALSMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgSendUserCredentialsMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_SENDUSERCREDENTIALSMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgSendUserCredentialsMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_DELETECHANNELINFORMATIONMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgDeleteChannelInformationMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_DELETECHANNELINFORMATIONMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgDeleteChannelInformationMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_DOWNLOADPARTAUTHDATAMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgDownloadPartAuthDataMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_DOWNLOADPARTAUTHDATAMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgDownloadPartAuthDataMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_VALIDATEUSERCREDENTIALSMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_VALIDATEUSERCREDENTIALSMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_RENEWACCESSTOKENMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgRenewAccessTokenMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_RENEWACCESSTOKENMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgRenewAccessTokenMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_GETACCESSTOKENMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgGetAccessTokenMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_GETACCESSTOKENMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgGetAccessTokenMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_VALIDATEUSERCREDENTIALSONTOKENRENEWALERRORMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_VALIDATEUSERCREDENTIALSONTOKENRENEWALERRORMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_CANCELUSERVALIDATIONRENEWTOKENMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgCancelUserValidationRenewTokenMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_CANCELUSERVALIDATIONRENEWTOKENMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgCancelUserValidationRenewTokenMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_DECODEIDTOKENMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgDecodeIdTokenMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_DECODEIDTOKENMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgDecodeIdTokenMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_RESETNCSSETTINGSMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgResetNCSSettingsMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_RESETNCSSETTINGSMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgResetNCSSettingsMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_GETPROBEUPLOADPERMITMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgGetProbeUploadPermitMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_GETPROBEUPLOADPERMITMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgGetProbeUploadPermitMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_SETPROBEUPLOADPERMITMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_SETPROBEUPLOADPERMITMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_SETPROBEINFODELETEMETHODSTART:
         return OSAL_NEW tcu_usb_mainfi_tclMsgSetProbeInfoDeleteMethodStart;

      case tcu_usb_mainfi_tclToken::EN_MSG_SETPROBEINFODELETEMETHODRESULT:
         return OSAL_NEW tcu_usb_mainfi_tclMsgSetProbeInfoDeleteMethodResult;

      case tcu_usb_mainfi_tclToken::EN_MSG_USERCREDENTIALSTATUSUPREG:
         return OSAL_NEW tcu_usb_mainfi_tclMsgUserCredentialStatusUpReg;

      case tcu_usb_mainfi_tclToken::EN_MSG_USERCREDENTIALSTATUSRELUPREG:
         return OSAL_NEW tcu_usb_mainfi_tclMsgUserCredentialStatusRelUpReg;

      case tcu_usb_mainfi_tclToken::EN_MSG_USERCREDENTIALSTATUSSTATUS:
         return OSAL_NEW tcu_usb_mainfi_tclMsgUserCredentialStatusStatus;

      case tcu_usb_mainfi_tclToken::EN_MSG_NOTIFYTOKENRENEWALERRORSTATUS:
         return OSAL_NEW tcu_usb_mainfi_tclMsgNotifyTokenRenewalErrorStatus;

      case tcu_usb_mainfi_tclToken::EN_MSG_CONNECTEDSEARCHRESULTUPREG:
         return OSAL_NEW tcu_usb_mainfi_tclMsgConnectedSearchResultUpReg;

      case tcu_usb_mainfi_tclToken::EN_MSG_CONNECTEDSEARCHRESULTRELUPREG:
         return OSAL_NEW tcu_usb_mainfi_tclMsgConnectedSearchResultRelUpReg;

      case tcu_usb_mainfi_tclToken::EN_MSG_CONNECTEDSEARCHRESULTSTATUS:
         return OSAL_NEW tcu_usb_mainfi_tclMsgConnectedSearchResultStatus;

      case tcu_usb_mainfi_tclToken::EN_MSG_CHANNELMASTERDATAUPREG:
         return OSAL_NEW tcu_usb_mainfi_tclMsgChannelMasterDataUpReg;

      case tcu_usb_mainfi_tclToken::EN_MSG_CHANNELMASTERDATARELUPREG:
         return OSAL_NEW tcu_usb_mainfi_tclMsgChannelMasterDataRelUpReg;

      case tcu_usb_mainfi_tclToken::EN_MSG_CHANNELMASTERDATASTATUS:
         return OSAL_NEW tcu_usb_mainfi_tclMsgChannelMasterDataStatus;

      case tcu_usb_mainfi_tclToken::EN_MSG_TTSAUDIOSTATEREQUESTUPREG:
         return OSAL_NEW tcu_usb_mainfi_tclMsgTtsAudioStateRequestUpReg;

      case tcu_usb_mainfi_tclToken::EN_MSG_TTSAUDIOSTATEREQUESTRELUPREG:
         return OSAL_NEW tcu_usb_mainfi_tclMsgTtsAudioStateRequestRelUpReg;

      case tcu_usb_mainfi_tclToken::EN_MSG_TTSAUDIOSTATEREQUESTSTATUS:
         return OSAL_NEW tcu_usb_mainfi_tclMsgTtsAudioStateRequestStatus;

      case tcu_usb_mainfi_tclToken::EN_MSG_DATABASESTATUSUPREG:
         return OSAL_NEW tcu_usb_mainfi_tclMsgDatabaseStatusUpReg;

      case tcu_usb_mainfi_tclToken::EN_MSG_DATABASESTATUSRELUPREG:
         return OSAL_NEW tcu_usb_mainfi_tclMsgDatabaseStatusRelUpReg;

      case tcu_usb_mainfi_tclToken::EN_MSG_DATABASESTATUSSTATUS:
         return OSAL_NEW tcu_usb_mainfi_tclMsgDatabaseStatusStatus;

      case tcu_usb_mainfi_tclToken::EN_MSG_DATABASESTATUSSET:
         return OSAL_NEW tcu_usb_mainfi_tclMsgDatabaseStatusSet;

      case tcu_usb_mainfi_tclToken::EN_MSG_DATACONNECTIONSTATUSUPREG:
         return OSAL_NEW tcu_usb_mainfi_tclMsgDataConnectionStatusUpReg;

      case tcu_usb_mainfi_tclToken::EN_MSG_DATACONNECTIONSTATUSRELUPREG:
         return OSAL_NEW tcu_usb_mainfi_tclMsgDataConnectionStatusRelUpReg;

      case tcu_usb_mainfi_tclToken::EN_MSG_DATACONNECTIONSTATUSSTATUS:
         return OSAL_NEW tcu_usb_mainfi_tclMsgDataConnectionStatusStatus;

      case tcu_usb_mainfi_tclToken::EN_MSG_DATACONNECTIONERRORUPREG:
         return OSAL_NEW tcu_usb_mainfi_tclMsgDataConnectionErrorUpReg;

      case tcu_usb_mainfi_tclToken::EN_MSG_DATACONNECTIONERRORRELUPREG:
         return OSAL_NEW tcu_usb_mainfi_tclMsgDataConnectionErrorRelUpReg;

      case tcu_usb_mainfi_tclToken::EN_MSG_DATACONNECTIONERRORSTATUS:
         return OSAL_NEW tcu_usb_mainfi_tclMsgDataConnectionErrorStatus;

      case tcu_usb_mainfi_tclToken::EN_MSG_SERVERLISTUPREG:
         return OSAL_NEW tcu_usb_mainfi_tclMsgServerListUpReg;

      case tcu_usb_mainfi_tclToken::EN_MSG_SERVERLISTRELUPREG:
         return OSAL_NEW tcu_usb_mainfi_tclMsgServerListRelUpReg;

      case tcu_usb_mainfi_tclToken::EN_MSG_SERVERLISTSTATUS:
         return OSAL_NEW tcu_usb_mainfi_tclMsgServerListStatus;

      case tcu_usb_mainfi_tclToken::EN_MSG_TCUDEVICEINFOUPREG:
         return OSAL_NEW tcu_usb_mainfi_tclMsgTCUDeviceInfoUpReg;

      case tcu_usb_mainfi_tclToken::EN_MSG_TCUDEVICEINFORELUPREG:
         return OSAL_NEW tcu_usb_mainfi_tclMsgTCUDeviceInfoRelUpReg;

      case tcu_usb_mainfi_tclToken::EN_MSG_TCUDEVICEINFOSTATUS:
         return OSAL_NEW tcu_usb_mainfi_tclMsgTCUDeviceInfoStatus;

      case tcu_usb_mainfi_tclToken::EN_MSG_NOTIFYAUTODOWNLOADINTERVALUPREG:
         return OSAL_NEW tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalUpReg;

      case tcu_usb_mainfi_tclToken::EN_MSG_NOTIFYAUTODOWNLOADINTERVALRELUPREG:
         return OSAL_NEW tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalRelUpReg;

      case tcu_usb_mainfi_tclToken::EN_MSG_NOTIFYAUTODOWNLOADINTERVALSTATUS:
         return OSAL_NEW tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalStatus;

      case tcu_usb_mainfi_tclToken::EN_MSG_GENERALNOTIFICATIONMESSAGEUPREG:
         return OSAL_NEW tcu_usb_mainfi_tclMsgGeneralNotificationMessageUpReg;

      case tcu_usb_mainfi_tclToken::EN_MSG_GENERALNOTIFICATIONMESSAGERELUPREG:
         return OSAL_NEW tcu_usb_mainfi_tclMsgGeneralNotificationMessageRelUpReg;

      case tcu_usb_mainfi_tclToken::EN_MSG_GENERALNOTIFICATIONMESSAGESTATUS:
         return OSAL_NEW tcu_usb_mainfi_tclMsgGeneralNotificationMessageStatus;

      case tcu_usb_mainfi_tclToken::EN_MSG_AUTHENTICATIONRESULTDATAUPREG:
         return OSAL_NEW tcu_usb_mainfi_tclMsgAuthenticationResultDataUpReg;

      case tcu_usb_mainfi_tclToken::EN_MSG_AUTHENTICATIONRESULTDATARELUPREG:
         return OSAL_NEW tcu_usb_mainfi_tclMsgAuthenticationResultDataRelUpReg;

      case tcu_usb_mainfi_tclToken::EN_MSG_AUTHENTICATIONRESULTDATASTATUS:
         return OSAL_NEW tcu_usb_mainfi_tclMsgAuthenticationResultDataStatus;

      case tcu_usb_mainfi_tclToken::EN_MSG_VICSTRAFFICDATAUPREG:
         return OSAL_NEW tcu_usb_mainfi_tclMsgVICSTrafficDataUpReg;

      case tcu_usb_mainfi_tclToken::EN_MSG_VICSTRAFFICDATARELUPREG:
         return OSAL_NEW tcu_usb_mainfi_tclMsgVICSTrafficDataRelUpReg;

      case tcu_usb_mainfi_tclToken::EN_MSG_VICSTRAFFICDATASTATUS:
         return OSAL_NEW tcu_usb_mainfi_tclMsgVICSTrafficDataStatus;

      case tcu_usb_mainfi_tclToken::EN_MSG_CHARGINGSTATIONSLISTUPREG:
         return OSAL_NEW tcu_usb_mainfi_tclMsgChargingStationsListUpReg;

      case tcu_usb_mainfi_tclToken::EN_MSG_CHARGINGSTATIONSLISTRELUPREG:
         return OSAL_NEW tcu_usb_mainfi_tclMsgChargingStationsListRelUpReg;

      case tcu_usb_mainfi_tclToken::EN_MSG_CHARGINGSTATIONSLISTSTATUS:
         return OSAL_NEW tcu_usb_mainfi_tclMsgChargingStationsListStatus;

      case tcu_usb_mainfi_tclToken::EN_MSG_CHARGINGSPOTDATAUPREG:
         return OSAL_NEW tcu_usb_mainfi_tclMsgChargingSpotDataUpReg;

      case tcu_usb_mainfi_tclToken::EN_MSG_CHARGINGSPOTDATARELUPREG:
         return OSAL_NEW tcu_usb_mainfi_tclMsgChargingSpotDataRelUpReg;

      case tcu_usb_mainfi_tclToken::EN_MSG_CHARGINGSPOTDATASTATUS:
         return OSAL_NEW tcu_usb_mainfi_tclMsgChargingSpotDataStatus;

      case tcu_usb_mainfi_tclToken::EN_MSG_VACANCYSTATIONSLISTUPREG:
         return OSAL_NEW tcu_usb_mainfi_tclMsgVacancyStationsListUpReg;

      case tcu_usb_mainfi_tclToken::EN_MSG_VACANCYSTATIONSLISTRELUPREG:
         return OSAL_NEW tcu_usb_mainfi_tclMsgVacancyStationsListRelUpReg;

      case tcu_usb_mainfi_tclToken::EN_MSG_VACANCYSTATIONSLISTSTATUS:
         return OSAL_NEW tcu_usb_mainfi_tclMsgVacancyStationsListStatus;

      case tcu_usb_mainfi_tclToken::EN_MSG_VACANCYSPOTDATAUPREG:
         return OSAL_NEW tcu_usb_mainfi_tclMsgVacancySpotDataUpReg;

      case tcu_usb_mainfi_tclToken::EN_MSG_VACANCYSPOTDATARELUPREG:
         return OSAL_NEW tcu_usb_mainfi_tclMsgVacancySpotDataRelUpReg;

      case tcu_usb_mainfi_tclToken::EN_MSG_VACANCYSPOTDATASTATUS:
         return OSAL_NEW tcu_usb_mainfi_tclMsgVacancySpotDataStatus;

      case tcu_usb_mainfi_tclToken::EN_MSG_GENERALRESPONSEERRORUPREG:
         return OSAL_NEW tcu_usb_mainfi_tclMsgGeneralResponseErrorUpReg;

      case tcu_usb_mainfi_tclToken::EN_MSG_GENERALRESPONSEERRORRELUPREG:
         return OSAL_NEW tcu_usb_mainfi_tclMsgGeneralResponseErrorRelUpReg;

      case tcu_usb_mainfi_tclToken::EN_MSG_GENERALRESPONSEERRORSTATUS:
         return OSAL_NEW tcu_usb_mainfi_tclMsgGeneralResponseErrorStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all tcu_usb_mainfifi messages

// common functions

tU16 tcu_usb_mainfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return TCU_USB_MAINFI_C_U16_SERVICE_ID;
}

tU16 tcu_usb_mainfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 tcu_usb_mainfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& tcu_usb_mainfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& tcu_usb_mainfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 tcu_usb_mainfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& tcu_usb_mainfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgGetChannelDataMethodStart::tcu_usb_mainfi_tclMsgGetChannelDataMethodStart(const tcu_usb_mainfi_tclMsgGetChannelDataMethodStart& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   Channel_Info_List = coRef.Channel_Info_List;
   bBackgroundDownloadType = coRef.bBackgroundDownloadType;
}
tcu_usb_mainfi_tclMsgGetChannelDataMethodStart& tcu_usb_mainfi_tclMsgGetChannelDataMethodStart::operator=(const tcu_usb_mainfi_tclMsgGetChannelDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Channel_Info_List = coRef.Channel_Info_List;
   bBackgroundDownloadType = coRef.bBackgroundDownloadType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_mainfi_tclMsgGetChannelDataMethodStart::vDestroy()
{
   Channel_Info_List.vDestroy(); 
}

tcu_usb_mainfi_tclMsgGetChannelDataMethodStart::tcu_usb_mainfi_tclMsgGetChannelDataMethodStart()
:Channel_Info_List()
,bBackgroundDownloadType(0)
 {}

tS32 tcu_usb_mainfi_tclMsgGetChannelDataMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_GETCHANNELDATAMETHODSTART;
}


tcu_usb_mainfi_tclMsgGetChannelDataMethodStart::~tcu_usb_mainfi_tclMsgGetChannelDataMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_mainfi_tclMsgGetChannelDataMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+Channel_Info_List.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_mainfi_tclMsgGetChannelDataMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Channel_Info_List);
   (tVoid) (oIn >> bBackgroundDownloadType);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgGetChannelDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Channel_Info_List);
   (tVoid) (oOut << bBackgroundDownloadType);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgGetChannelDataMethodStart::operator==(const tcu_usb_mainfi_tclMsgGetChannelDataMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Channel_Info_List == roRef.Channel_Info_List);
   bResult = bResult && (bBackgroundDownloadType == roRef.bBackgroundDownloadType);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgGetChannelDataMethodResult::tcu_usb_mainfi_tclMsgGetChannelDataMethodResult()
 {}

tS32 tcu_usb_mainfi_tclMsgGetChannelDataMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_GETCHANNELDATAMETHODRESULT;
}


tcu_usb_mainfi_tclMsgGetChannelDataMethodResult::~tcu_usb_mainfi_tclMsgGetChannelDataMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgGetConnectedSearchResultMethodStart::tcu_usb_mainfi_tclMsgGetConnectedSearchResultMethodStart(const tcu_usb_mainfi_tclMsgGetConnectedSearchResultMethodStart& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   u8SizeOfKeyWord = coRef.u8SizeOfKeyWord;
   strKeyWord = coRef.strKeyWord;
}
tcu_usb_mainfi_tclMsgGetConnectedSearchResultMethodStart& tcu_usb_mainfi_tclMsgGetConnectedSearchResultMethodStart::operator=(const tcu_usb_mainfi_tclMsgGetConnectedSearchResultMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8SizeOfKeyWord = coRef.u8SizeOfKeyWord;
   strKeyWord = coRef.strKeyWord;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_mainfi_tclMsgGetConnectedSearchResultMethodStart::vDestroy()
{
   strKeyWord.vDestroy();
}

tcu_usb_mainfi_tclMsgGetConnectedSearchResultMethodStart::tcu_usb_mainfi_tclMsgGetConnectedSearchResultMethodStart()
:u8SizeOfKeyWord(0)
,strKeyWord()
 {}

tS32 tcu_usb_mainfi_tclMsgGetConnectedSearchResultMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_GETCONNECTEDSEARCHRESULTMETHODSTART;
}


tcu_usb_mainfi_tclMsgGetConnectedSearchResultMethodStart::~tcu_usb_mainfi_tclMsgGetConnectedSearchResultMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_mainfi_tclMsgGetConnectedSearchResultMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+strKeyWord.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_mainfi_tclMsgGetConnectedSearchResultMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8SizeOfKeyWord);
   (tVoid) (oIn >> strKeyWord);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgGetConnectedSearchResultMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8SizeOfKeyWord);
   (tVoid) (oOut << strKeyWord);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgGetConnectedSearchResultMethodStart::operator==(const tcu_usb_mainfi_tclMsgGetConnectedSearchResultMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8SizeOfKeyWord == roRef.u8SizeOfKeyWord);
   bResult = bResult && (strKeyWord == roRef.strKeyWord);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgGetConnectedSearchResultMethodResult::tcu_usb_mainfi_tclMsgGetConnectedSearchResultMethodResult()
 {}

tS32 tcu_usb_mainfi_tclMsgGetConnectedSearchResultMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_GETCONNECTEDSEARCHRESULTMETHODRESULT;
}


tcu_usb_mainfi_tclMsgGetConnectedSearchResultMethodResult::~tcu_usb_mainfi_tclMsgGetConnectedSearchResultMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgGetChannelMasterDataMethodStart::tcu_usb_mainfi_tclMsgGetChannelMasterDataMethodStart(const tcu_usb_mainfi_tclMsgGetChannelMasterDataMethodStart& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   bBackgroundDownloadType = coRef.bBackgroundDownloadType;
}
tcu_usb_mainfi_tclMsgGetChannelMasterDataMethodStart& tcu_usb_mainfi_tclMsgGetChannelMasterDataMethodStart::operator=(const tcu_usb_mainfi_tclMsgGetChannelMasterDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bBackgroundDownloadType = coRef.bBackgroundDownloadType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_mainfi_tclMsgGetChannelMasterDataMethodStart::tcu_usb_mainfi_tclMsgGetChannelMasterDataMethodStart()
:bBackgroundDownloadType(0)
 {}

tS32 tcu_usb_mainfi_tclMsgGetChannelMasterDataMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_GETCHANNELMASTERDATAMETHODSTART;
}


tcu_usb_mainfi_tclMsgGetChannelMasterDataMethodStart::~tcu_usb_mainfi_tclMsgGetChannelMasterDataMethodStart()
{}

tU32 tcu_usb_mainfi_tclMsgGetChannelMasterDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_mainfi_tclMsgGetChannelMasterDataMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bBackgroundDownloadType);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgGetChannelMasterDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bBackgroundDownloadType);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgGetChannelMasterDataMethodStart::operator==(const tcu_usb_mainfi_tclMsgGetChannelMasterDataMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bBackgroundDownloadType == roRef.bBackgroundDownloadType);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgGetChannelMasterDataMethodResult::tcu_usb_mainfi_tclMsgGetChannelMasterDataMethodResult()
 {}

tS32 tcu_usb_mainfi_tclMsgGetChannelMasterDataMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_GETCHANNELMASTERDATAMETHODRESULT;
}


tcu_usb_mainfi_tclMsgGetChannelMasterDataMethodResult::~tcu_usb_mainfi_tclMsgGetChannelMasterDataMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodStart::tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodStart(const tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodStart& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   TextAndTags = coRef.TextAndTags;
   u16ChannelID = coRef.u16ChannelID;
   u8ChannelContentsID = coRef.u8ChannelContentsID;
   bHoldAudioChannel = coRef.bHoldAudioChannel;
}
tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodStart& tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodStart::operator=(const tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TextAndTags = coRef.TextAndTags;
   u16ChannelID = coRef.u16ChannelID;
   u8ChannelContentsID = coRef.u8ChannelContentsID;
   bHoldAudioChannel = coRef.bHoldAudioChannel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodStart::vDestroy()
{
   TextAndTags.vDestroy();
}

tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodStart::tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodStart()
:TextAndTags()
,u16ChannelID(0)
,u8ChannelContentsID(0)
,bHoldAudioChannel(0)
 {}

tS32 tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_SYNTHESIZESPEAKMETHODSTART;
}


tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodStart::~tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+TextAndTags.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TextAndTags);
   (tVoid) (oIn >> u16ChannelID);
   (tVoid) (oIn >> u8ChannelContentsID);
   (tVoid) (oIn >> bHoldAudioChannel);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TextAndTags);
   (tVoid) (oOut << u16ChannelID);
   (tVoid) (oOut << u8ChannelContentsID);
   (tVoid) (oOut << bHoldAudioChannel);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodStart::operator==(const tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TextAndTags == roRef.TextAndTags);
   bResult = bResult && (u16ChannelID == roRef.u16ChannelID);
   bResult = bResult && (u8ChannelContentsID == roRef.u8ChannelContentsID);
   bResult = bResult && (bHoldAudioChannel == roRef.bHoldAudioChannel);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodResultFirst::tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodResultFirst()
 {}

tS32 tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodResultFirst::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_SYNTHESIZESPEAKMETHODRESULTFIRST;
}


tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodResultFirst::~tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodResultFirst()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodResultMiddle::tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodResultMiddle()
 {}

tS32 tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodResultMiddle::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_SYNTHESIZESPEAKMETHODRESULTMIDDLE;
}


tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodResultMiddle::~tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodResultMiddle()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodResultLast::tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodResultLast()
 {}

tS32 tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodResultLast::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_SYNTHESIZESPEAKMETHODRESULTLAST;
}


tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodResultLast::~tcu_usb_mainfi_tclMsgSynthesizeSpeakMethodResultLast()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgAbortPromptMethodStart::tcu_usb_mainfi_tclMsgAbortPromptMethodStart(const tcu_usb_mainfi_tclMsgAbortPromptMethodStart& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   bHoldAudioChannel = coRef.bHoldAudioChannel;
}
tcu_usb_mainfi_tclMsgAbortPromptMethodStart& tcu_usb_mainfi_tclMsgAbortPromptMethodStart::operator=(const tcu_usb_mainfi_tclMsgAbortPromptMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bHoldAudioChannel = coRef.bHoldAudioChannel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_mainfi_tclMsgAbortPromptMethodStart::tcu_usb_mainfi_tclMsgAbortPromptMethodStart()
:bHoldAudioChannel(0)
 {}

tS32 tcu_usb_mainfi_tclMsgAbortPromptMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_ABORTPROMPTMETHODSTART;
}


tcu_usb_mainfi_tclMsgAbortPromptMethodStart::~tcu_usb_mainfi_tclMsgAbortPromptMethodStart()
{}

tU32 tcu_usb_mainfi_tclMsgAbortPromptMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_mainfi_tclMsgAbortPromptMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bHoldAudioChannel);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgAbortPromptMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bHoldAudioChannel);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgAbortPromptMethodStart::operator==(const tcu_usb_mainfi_tclMsgAbortPromptMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bHoldAudioChannel == roRef.bHoldAudioChannel);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgAbortPromptMethodResult::tcu_usb_mainfi_tclMsgAbortPromptMethodResult()
 {}

tS32 tcu_usb_mainfi_tclMsgAbortPromptMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_ABORTPROMPTMETHODRESULT;
}


tcu_usb_mainfi_tclMsgAbortPromptMethodResult::~tcu_usb_mainfi_tclMsgAbortPromptMethodResult()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgPausePromptMethodStart::tcu_usb_mainfi_tclMsgPausePromptMethodStart()
 {}

tS32 tcu_usb_mainfi_tclMsgPausePromptMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_PAUSEPROMPTMETHODSTART;
}


tcu_usb_mainfi_tclMsgPausePromptMethodStart::~tcu_usb_mainfi_tclMsgPausePromptMethodStart()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgPausePromptMethodResult::tcu_usb_mainfi_tclMsgPausePromptMethodResult()
 {}

tS32 tcu_usb_mainfi_tclMsgPausePromptMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_PAUSEPROMPTMETHODRESULT;
}


tcu_usb_mainfi_tclMsgPausePromptMethodResult::~tcu_usb_mainfi_tclMsgPausePromptMethodResult()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgContinuePromptMethodStart::tcu_usb_mainfi_tclMsgContinuePromptMethodStart()
 {}

tS32 tcu_usb_mainfi_tclMsgContinuePromptMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_CONTINUEPROMPTMETHODSTART;
}


tcu_usb_mainfi_tclMsgContinuePromptMethodStart::~tcu_usb_mainfi_tclMsgContinuePromptMethodStart()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgContinuePromptMethodResult::tcu_usb_mainfi_tclMsgContinuePromptMethodResult()
 {}

tS32 tcu_usb_mainfi_tclMsgContinuePromptMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_CONTINUEPROMPTMETHODRESULT;
}


tcu_usb_mainfi_tclMsgContinuePromptMethodResult::~tcu_usb_mainfi_tclMsgContinuePromptMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgCancelRequestMethodStart::tcu_usb_mainfi_tclMsgCancelRequestMethodStart(const tcu_usb_mainfi_tclMsgCancelRequestMethodStart& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   eCancelRequestType = coRef.eCancelRequestType;
}
tcu_usb_mainfi_tclMsgCancelRequestMethodStart& tcu_usb_mainfi_tclMsgCancelRequestMethodStart::operator=(const tcu_usb_mainfi_tclMsgCancelRequestMethodStart& coRef)
{
   if (this == &coRef) return *this;
   eCancelRequestType = coRef.eCancelRequestType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_mainfi_tclMsgCancelRequestMethodStart::tcu_usb_mainfi_tclMsgCancelRequestMethodStart()
:eCancelRequestType()
 {}

tS32 tcu_usb_mainfi_tclMsgCancelRequestMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_CANCELREQUESTMETHODSTART;
}


tcu_usb_mainfi_tclMsgCancelRequestMethodStart::~tcu_usb_mainfi_tclMsgCancelRequestMethodStart()
{}

tU32 tcu_usb_mainfi_tclMsgCancelRequestMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_mainfi_tclMsgCancelRequestMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> eCancelRequestType);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgCancelRequestMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << eCancelRequestType);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgCancelRequestMethodStart::operator==(const tcu_usb_mainfi_tclMsgCancelRequestMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (eCancelRequestType == roRef.eCancelRequestType);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgCancelRequestMethodResult::tcu_usb_mainfi_tclMsgCancelRequestMethodResult()
 {}

tS32 tcu_usb_mainfi_tclMsgCancelRequestMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_CANCELREQUESTMETHODRESULT;
}


tcu_usb_mainfi_tclMsgCancelRequestMethodResult::~tcu_usb_mainfi_tclMsgCancelRequestMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgSendGroupADataMethodStart::tcu_usb_mainfi_tclMsgSendGroupADataMethodStart(const tcu_usb_mainfi_tclMsgSendGroupADataMethodStart& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   GroupA_Info = coRef.GroupA_Info;
}
tcu_usb_mainfi_tclMsgSendGroupADataMethodStart& tcu_usb_mainfi_tclMsgSendGroupADataMethodStart::operator=(const tcu_usb_mainfi_tclMsgSendGroupADataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   GroupA_Info = coRef.GroupA_Info;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_mainfi_tclMsgSendGroupADataMethodStart::vDestroy()
{
   GroupA_Info.vDestroy(); 
}

tcu_usb_mainfi_tclMsgSendGroupADataMethodStart::tcu_usb_mainfi_tclMsgSendGroupADataMethodStart()
:GroupA_Info()
 {}

tS32 tcu_usb_mainfi_tclMsgSendGroupADataMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_SENDGROUPADATAMETHODSTART;
}


tcu_usb_mainfi_tclMsgSendGroupADataMethodStart::~tcu_usb_mainfi_tclMsgSendGroupADataMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_mainfi_tclMsgSendGroupADataMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+GroupA_Info.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_mainfi_tclMsgSendGroupADataMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GroupA_Info);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgSendGroupADataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GroupA_Info);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgSendGroupADataMethodStart::operator==(const tcu_usb_mainfi_tclMsgSendGroupADataMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GroupA_Info == roRef.GroupA_Info);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgSendGroupADataMethodResult::tcu_usb_mainfi_tclMsgSendGroupADataMethodResult()
 {}

tS32 tcu_usb_mainfi_tclMsgSendGroupADataMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_SENDGROUPADATAMETHODRESULT;
}


tcu_usb_mainfi_tclMsgSendGroupADataMethodResult::~tcu_usb_mainfi_tclMsgSendGroupADataMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgDeleteInVehicleMessageMethodStart::tcu_usb_mainfi_tclMsgDeleteInVehicleMessageMethodStart(const tcu_usb_mainfi_tclMsgDeleteInVehicleMessageMethodStart& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   s64IndexInternal = coRef.s64IndexInternal;
   u8ChannelContentsID = coRef.u8ChannelContentsID;
}
tcu_usb_mainfi_tclMsgDeleteInVehicleMessageMethodStart& tcu_usb_mainfi_tclMsgDeleteInVehicleMessageMethodStart::operator=(const tcu_usb_mainfi_tclMsgDeleteInVehicleMessageMethodStart& coRef)
{
   if (this == &coRef) return *this;
   s64IndexInternal = coRef.s64IndexInternal;
   u8ChannelContentsID = coRef.u8ChannelContentsID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_mainfi_tclMsgDeleteInVehicleMessageMethodStart::tcu_usb_mainfi_tclMsgDeleteInVehicleMessageMethodStart()
:s64IndexInternal(0)
,u8ChannelContentsID(0)
 {}

tS32 tcu_usb_mainfi_tclMsgDeleteInVehicleMessageMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_DELETEINVEHICLEMESSAGEMETHODSTART;
}


tcu_usb_mainfi_tclMsgDeleteInVehicleMessageMethodStart::~tcu_usb_mainfi_tclMsgDeleteInVehicleMessageMethodStart()
{}

tU32 tcu_usb_mainfi_tclMsgDeleteInVehicleMessageMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& tcu_usb_mainfi_tclMsgDeleteInVehicleMessageMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s64IndexInternal);
   (tVoid) (oIn >> u8ChannelContentsID);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgDeleteInVehicleMessageMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s64IndexInternal);
   (tVoid) (oOut << u8ChannelContentsID);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgDeleteInVehicleMessageMethodStart::operator==(const tcu_usb_mainfi_tclMsgDeleteInVehicleMessageMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s64IndexInternal == roRef.s64IndexInternal);
   bResult = bResult && (u8ChannelContentsID == roRef.u8ChannelContentsID);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgDeleteInVehicleMessageMethodResult::tcu_usb_mainfi_tclMsgDeleteInVehicleMessageMethodResult()
 {}

tS32 tcu_usb_mainfi_tclMsgDeleteInVehicleMessageMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_DELETEINVEHICLEMESSAGEMETHODRESULT;
}


tcu_usb_mainfi_tclMsgDeleteInVehicleMessageMethodResult::~tcu_usb_mainfi_tclMsgDeleteInVehicleMessageMethodResult()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgResetDatabaseMethodStart::tcu_usb_mainfi_tclMsgResetDatabaseMethodStart()
 {}

tS32 tcu_usb_mainfi_tclMsgResetDatabaseMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_RESETDATABASEMETHODSTART;
}


tcu_usb_mainfi_tclMsgResetDatabaseMethodStart::~tcu_usb_mainfi_tclMsgResetDatabaseMethodStart()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgResetDatabaseMethodResult::tcu_usb_mainfi_tclMsgResetDatabaseMethodResult()
 {}

tS32 tcu_usb_mainfi_tclMsgResetDatabaseMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_RESETDATABASEMETHODRESULT;
}


tcu_usb_mainfi_tclMsgResetDatabaseMethodResult::~tcu_usb_mainfi_tclMsgResetDatabaseMethodResult()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgGetServerListMethodStart::tcu_usb_mainfi_tclMsgGetServerListMethodStart()
 {}

tS32 tcu_usb_mainfi_tclMsgGetServerListMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_GETSERVERLISTMETHODSTART;
}


tcu_usb_mainfi_tclMsgGetServerListMethodStart::~tcu_usb_mainfi_tclMsgGetServerListMethodStart()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgGetServerListMethodResult::tcu_usb_mainfi_tclMsgGetServerListMethodResult()
 {}

tS32 tcu_usb_mainfi_tclMsgGetServerListMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_GETSERVERLISTMETHODRESULT;
}


tcu_usb_mainfi_tclMsgGetServerListMethodResult::~tcu_usb_mainfi_tclMsgGetServerListMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgSelectServerMethodStart::tcu_usb_mainfi_tclMsgSelectServerMethodStart(const tcu_usb_mainfi_tclMsgSelectServerMethodStart& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   u8ServerId = coRef.u8ServerId;
}
tcu_usb_mainfi_tclMsgSelectServerMethodStart& tcu_usb_mainfi_tclMsgSelectServerMethodStart::operator=(const tcu_usb_mainfi_tclMsgSelectServerMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8ServerId = coRef.u8ServerId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_mainfi_tclMsgSelectServerMethodStart::tcu_usb_mainfi_tclMsgSelectServerMethodStart()
:u8ServerId(0)
 {}

tS32 tcu_usb_mainfi_tclMsgSelectServerMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_SELECTSERVERMETHODSTART;
}


tcu_usb_mainfi_tclMsgSelectServerMethodStart::~tcu_usb_mainfi_tclMsgSelectServerMethodStart()
{}

tU32 tcu_usb_mainfi_tclMsgSelectServerMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_mainfi_tclMsgSelectServerMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8ServerId);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgSelectServerMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8ServerId);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgSelectServerMethodStart::operator==(const tcu_usb_mainfi_tclMsgSelectServerMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8ServerId == roRef.u8ServerId);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgSelectServerMethodResult::tcu_usb_mainfi_tclMsgSelectServerMethodResult()
 {}

tS32 tcu_usb_mainfi_tclMsgSelectServerMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_SELECTSERVERMETHODRESULT;
}


tcu_usb_mainfi_tclMsgSelectServerMethodResult::~tcu_usb_mainfi_tclMsgSelectServerMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgRetryGetChannelDataMethodStart::tcu_usb_mainfi_tclMsgRetryGetChannelDataMethodStart(const tcu_usb_mainfi_tclMsgRetryGetChannelDataMethodStart& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   u16ChannelID = coRef.u16ChannelID;
}
tcu_usb_mainfi_tclMsgRetryGetChannelDataMethodStart& tcu_usb_mainfi_tclMsgRetryGetChannelDataMethodStart::operator=(const tcu_usb_mainfi_tclMsgRetryGetChannelDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16ChannelID = coRef.u16ChannelID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_mainfi_tclMsgRetryGetChannelDataMethodStart::tcu_usb_mainfi_tclMsgRetryGetChannelDataMethodStart()
:u16ChannelID(0)
 {}

tS32 tcu_usb_mainfi_tclMsgRetryGetChannelDataMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_RETRYGETCHANNELDATAMETHODSTART;
}


tcu_usb_mainfi_tclMsgRetryGetChannelDataMethodStart::~tcu_usb_mainfi_tclMsgRetryGetChannelDataMethodStart()
{}

tU32 tcu_usb_mainfi_tclMsgRetryGetChannelDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& tcu_usb_mainfi_tclMsgRetryGetChannelDataMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16ChannelID);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgRetryGetChannelDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16ChannelID);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgRetryGetChannelDataMethodStart::operator==(const tcu_usb_mainfi_tclMsgRetryGetChannelDataMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16ChannelID == roRef.u16ChannelID);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgRetryGetChannelDataMethodResult::tcu_usb_mainfi_tclMsgRetryGetChannelDataMethodResult()
 {}

tS32 tcu_usb_mainfi_tclMsgRetryGetChannelDataMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_RETRYGETCHANNELDATAMETHODRESULT;
}


tcu_usb_mainfi_tclMsgRetryGetChannelDataMethodResult::~tcu_usb_mainfi_tclMsgRetryGetChannelDataMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgOverwriteIVMTotalContentsMethodStart::tcu_usb_mainfi_tclMsgOverwriteIVMTotalContentsMethodStart(const tcu_usb_mainfi_tclMsgOverwriteIVMTotalContentsMethodStart& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   u16ChannelID = coRef.u16ChannelID;
   s64IndexInternal = coRef.s64IndexInternal;
}
tcu_usb_mainfi_tclMsgOverwriteIVMTotalContentsMethodStart& tcu_usb_mainfi_tclMsgOverwriteIVMTotalContentsMethodStart::operator=(const tcu_usb_mainfi_tclMsgOverwriteIVMTotalContentsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16ChannelID = coRef.u16ChannelID;
   s64IndexInternal = coRef.s64IndexInternal;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_mainfi_tclMsgOverwriteIVMTotalContentsMethodStart::tcu_usb_mainfi_tclMsgOverwriteIVMTotalContentsMethodStart()
:u16ChannelID(0)
,s64IndexInternal(0)
 {}

tS32 tcu_usb_mainfi_tclMsgOverwriteIVMTotalContentsMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_OVERWRITEIVMTOTALCONTENTSMETHODSTART;
}


tcu_usb_mainfi_tclMsgOverwriteIVMTotalContentsMethodStart::~tcu_usb_mainfi_tclMsgOverwriteIVMTotalContentsMethodStart()
{}

tU32 tcu_usb_mainfi_tclMsgOverwriteIVMTotalContentsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& tcu_usb_mainfi_tclMsgOverwriteIVMTotalContentsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16ChannelID);
   (tVoid) (oIn >> s64IndexInternal);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgOverwriteIVMTotalContentsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16ChannelID);
   (tVoid) (oOut << s64IndexInternal);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgOverwriteIVMTotalContentsMethodStart::operator==(const tcu_usb_mainfi_tclMsgOverwriteIVMTotalContentsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16ChannelID == roRef.u16ChannelID);
   bResult = bResult && (s64IndexInternal == roRef.s64IndexInternal);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgOverwriteIVMTotalContentsMethodResult::tcu_usb_mainfi_tclMsgOverwriteIVMTotalContentsMethodResult()
 {}

tS32 tcu_usb_mainfi_tclMsgOverwriteIVMTotalContentsMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_OVERWRITEIVMTOTALCONTENTSMETHODRESULT;
}


tcu_usb_mainfi_tclMsgOverwriteIVMTotalContentsMethodResult::~tcu_usb_mainfi_tclMsgOverwriteIVMTotalContentsMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgStoreCSHistoryMethodStart::tcu_usb_mainfi_tclMsgStoreCSHistoryMethodStart(const tcu_usb_mainfi_tclMsgStoreCSHistoryMethodStart& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   strKeyWord = coRef.strKeyWord;
}
tcu_usb_mainfi_tclMsgStoreCSHistoryMethodStart& tcu_usb_mainfi_tclMsgStoreCSHistoryMethodStart::operator=(const tcu_usb_mainfi_tclMsgStoreCSHistoryMethodStart& coRef)
{
   if (this == &coRef) return *this;
   strKeyWord = coRef.strKeyWord;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_mainfi_tclMsgStoreCSHistoryMethodStart::vDestroy()
{
   strKeyWord.vDestroy();
}

tcu_usb_mainfi_tclMsgStoreCSHistoryMethodStart::tcu_usb_mainfi_tclMsgStoreCSHistoryMethodStart()
:strKeyWord()
 {}

tS32 tcu_usb_mainfi_tclMsgStoreCSHistoryMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_STORECSHISTORYMETHODSTART;
}


tcu_usb_mainfi_tclMsgStoreCSHistoryMethodStart::~tcu_usb_mainfi_tclMsgStoreCSHistoryMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_mainfi_tclMsgStoreCSHistoryMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+strKeyWord.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_mainfi_tclMsgStoreCSHistoryMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strKeyWord);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgStoreCSHistoryMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strKeyWord);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgStoreCSHistoryMethodStart::operator==(const tcu_usb_mainfi_tclMsgStoreCSHistoryMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strKeyWord == roRef.strKeyWord);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgStoreCSHistoryMethodResult::tcu_usb_mainfi_tclMsgStoreCSHistoryMethodResult()
 {}

tS32 tcu_usb_mainfi_tclMsgStoreCSHistoryMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_STORECSHISTORYMETHODRESULT;
}


tcu_usb_mainfi_tclMsgStoreCSHistoryMethodResult::~tcu_usb_mainfi_tclMsgStoreCSHistoryMethodResult()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgGetTCUDeviceInfoMethodStart::tcu_usb_mainfi_tclMsgGetTCUDeviceInfoMethodStart()
 {}

tS32 tcu_usb_mainfi_tclMsgGetTCUDeviceInfoMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_GETTCUDEVICEINFOMETHODSTART;
}


tcu_usb_mainfi_tclMsgGetTCUDeviceInfoMethodStart::~tcu_usb_mainfi_tclMsgGetTCUDeviceInfoMethodStart()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgGetTCUDeviceInfoMethodResult::tcu_usb_mainfi_tclMsgGetTCUDeviceInfoMethodResult()
 {}

tS32 tcu_usb_mainfi_tclMsgGetTCUDeviceInfoMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_GETTCUDEVICEINFOMETHODRESULT;
}


tcu_usb_mainfi_tclMsgGetTCUDeviceInfoMethodResult::~tcu_usb_mainfi_tclMsgGetTCUDeviceInfoMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgSetLogLevelMethodStart::tcu_usb_mainfi_tclMsgSetLogLevelMethodStart(const tcu_usb_mainfi_tclMsgSetLogLevelMethodStart& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   u8LogLevel = coRef.u8LogLevel;
}
tcu_usb_mainfi_tclMsgSetLogLevelMethodStart& tcu_usb_mainfi_tclMsgSetLogLevelMethodStart::operator=(const tcu_usb_mainfi_tclMsgSetLogLevelMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8LogLevel = coRef.u8LogLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_mainfi_tclMsgSetLogLevelMethodStart::tcu_usb_mainfi_tclMsgSetLogLevelMethodStart()
:u8LogLevel()
 {}

tS32 tcu_usb_mainfi_tclMsgSetLogLevelMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_SETLOGLEVELMETHODSTART;
}


tcu_usb_mainfi_tclMsgSetLogLevelMethodStart::~tcu_usb_mainfi_tclMsgSetLogLevelMethodStart()
{}

tU32 tcu_usb_mainfi_tclMsgSetLogLevelMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_mainfi_tclMsgSetLogLevelMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8LogLevel);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgSetLogLevelMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8LogLevel);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgSetLogLevelMethodStart::operator==(const tcu_usb_mainfi_tclMsgSetLogLevelMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8LogLevel == roRef.u8LogLevel);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgSetLogLevelMethodResult::tcu_usb_mainfi_tclMsgSetLogLevelMethodResult()
 {}

tS32 tcu_usb_mainfi_tclMsgSetLogLevelMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_SETLOGLEVELMETHODRESULT;
}


tcu_usb_mainfi_tclMsgSetLogLevelMethodResult::~tcu_usb_mainfi_tclMsgSetLogLevelMethodResult()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgRestoreFactorySettingsMethodStart::tcu_usb_mainfi_tclMsgRestoreFactorySettingsMethodStart()
 {}

tS32 tcu_usb_mainfi_tclMsgRestoreFactorySettingsMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_RESTOREFACTORYSETTINGSMETHODSTART;
}


tcu_usb_mainfi_tclMsgRestoreFactorySettingsMethodStart::~tcu_usb_mainfi_tclMsgRestoreFactorySettingsMethodStart()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgRestoreFactorySettingsMethodResult::tcu_usb_mainfi_tclMsgRestoreFactorySettingsMethodResult()
 {}

tS32 tcu_usb_mainfi_tclMsgRestoreFactorySettingsMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_RESTOREFACTORYSETTINGSMETHODRESULT;
}


tcu_usb_mainfi_tclMsgRestoreFactorySettingsMethodResult::~tcu_usb_mainfi_tclMsgRestoreFactorySettingsMethodResult()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgDeleteMessageBoxMethodStart::tcu_usb_mainfi_tclMsgDeleteMessageBoxMethodStart()
 {}

tS32 tcu_usb_mainfi_tclMsgDeleteMessageBoxMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_DELETEMESSAGEBOXMETHODSTART;
}


tcu_usb_mainfi_tclMsgDeleteMessageBoxMethodStart::~tcu_usb_mainfi_tclMsgDeleteMessageBoxMethodStart()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgDeleteMessageBoxMethodResult::tcu_usb_mainfi_tclMsgDeleteMessageBoxMethodResult()
 {}

tS32 tcu_usb_mainfi_tclMsgDeleteMessageBoxMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_DELETEMESSAGEBOXMETHODRESULT;
}


tcu_usb_mainfi_tclMsgDeleteMessageBoxMethodResult::~tcu_usb_mainfi_tclMsgDeleteMessageBoxMethodResult()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgInitializeFeedListMethodStart::tcu_usb_mainfi_tclMsgInitializeFeedListMethodStart()
 {}

tS32 tcu_usb_mainfi_tclMsgInitializeFeedListMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_INITIALIZEFEEDLISTMETHODSTART;
}


tcu_usb_mainfi_tclMsgInitializeFeedListMethodStart::~tcu_usb_mainfi_tclMsgInitializeFeedListMethodStart()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgInitializeFeedListMethodResult::tcu_usb_mainfi_tclMsgInitializeFeedListMethodResult()
 {}

tS32 tcu_usb_mainfi_tclMsgInitializeFeedListMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_INITIALIZEFEEDLISTMETHODRESULT;
}


tcu_usb_mainfi_tclMsgInitializeFeedListMethodResult::~tcu_usb_mainfi_tclMsgInitializeFeedListMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgSetAutoDownloadIntervalMethodStart::tcu_usb_mainfi_tclMsgSetAutoDownloadIntervalMethodStart(const tcu_usb_mainfi_tclMsgSetAutoDownloadIntervalMethodStart& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   AutoDownloadInterval = coRef.AutoDownloadInterval;
}
tcu_usb_mainfi_tclMsgSetAutoDownloadIntervalMethodStart& tcu_usb_mainfi_tclMsgSetAutoDownloadIntervalMethodStart::operator=(const tcu_usb_mainfi_tclMsgSetAutoDownloadIntervalMethodStart& coRef)
{
   if (this == &coRef) return *this;
   AutoDownloadInterval = coRef.AutoDownloadInterval;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_mainfi_tclMsgSetAutoDownloadIntervalMethodStart::tcu_usb_mainfi_tclMsgSetAutoDownloadIntervalMethodStart()
:AutoDownloadInterval()
 {}

tS32 tcu_usb_mainfi_tclMsgSetAutoDownloadIntervalMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_SETAUTODOWNLOADINTERVALMETHODSTART;
}


tcu_usb_mainfi_tclMsgSetAutoDownloadIntervalMethodStart::~tcu_usb_mainfi_tclMsgSetAutoDownloadIntervalMethodStart()
{}

tU32 tcu_usb_mainfi_tclMsgSetAutoDownloadIntervalMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_mainfi_tclMsgSetAutoDownloadIntervalMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AutoDownloadInterval);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgSetAutoDownloadIntervalMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AutoDownloadInterval);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgSetAutoDownloadIntervalMethodStart::operator==(const tcu_usb_mainfi_tclMsgSetAutoDownloadIntervalMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AutoDownloadInterval == roRef.AutoDownloadInterval);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgSetAutoDownloadIntervalMethodResult::tcu_usb_mainfi_tclMsgSetAutoDownloadIntervalMethodResult()
 {}

tS32 tcu_usb_mainfi_tclMsgSetAutoDownloadIntervalMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_SETAUTODOWNLOADINTERVALMETHODRESULT;
}


tcu_usb_mainfi_tclMsgSetAutoDownloadIntervalMethodResult::~tcu_usb_mainfi_tclMsgSetAutoDownloadIntervalMethodResult()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgGetAutoDownloadIntervalMethodStart::tcu_usb_mainfi_tclMsgGetAutoDownloadIntervalMethodStart()
 {}

tS32 tcu_usb_mainfi_tclMsgGetAutoDownloadIntervalMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_GETAUTODOWNLOADINTERVALMETHODSTART;
}


tcu_usb_mainfi_tclMsgGetAutoDownloadIntervalMethodStart::~tcu_usb_mainfi_tclMsgGetAutoDownloadIntervalMethodStart()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgGetAutoDownloadIntervalMethodResult::tcu_usb_mainfi_tclMsgGetAutoDownloadIntervalMethodResult()
 {}

tS32 tcu_usb_mainfi_tclMsgGetAutoDownloadIntervalMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_GETAUTODOWNLOADINTERVALMETHODRESULT;
}


tcu_usb_mainfi_tclMsgGetAutoDownloadIntervalMethodResult::~tcu_usb_mainfi_tclMsgGetAutoDownloadIntervalMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgSetAutoDownloadChannelMethodStart::tcu_usb_mainfi_tclMsgSetAutoDownloadChannelMethodStart(const tcu_usb_mainfi_tclMsgSetAutoDownloadChannelMethodStart& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   Channel_Info_List = coRef.Channel_Info_List;
}
tcu_usb_mainfi_tclMsgSetAutoDownloadChannelMethodStart& tcu_usb_mainfi_tclMsgSetAutoDownloadChannelMethodStart::operator=(const tcu_usb_mainfi_tclMsgSetAutoDownloadChannelMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Channel_Info_List = coRef.Channel_Info_List;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_mainfi_tclMsgSetAutoDownloadChannelMethodStart::vDestroy()
{
   Channel_Info_List.vDestroy(); 
}

tcu_usb_mainfi_tclMsgSetAutoDownloadChannelMethodStart::tcu_usb_mainfi_tclMsgSetAutoDownloadChannelMethodStart()
:Channel_Info_List()
 {}

tS32 tcu_usb_mainfi_tclMsgSetAutoDownloadChannelMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_SETAUTODOWNLOADCHANNELMETHODSTART;
}


tcu_usb_mainfi_tclMsgSetAutoDownloadChannelMethodStart::~tcu_usb_mainfi_tclMsgSetAutoDownloadChannelMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_mainfi_tclMsgSetAutoDownloadChannelMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Channel_Info_List.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_mainfi_tclMsgSetAutoDownloadChannelMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Channel_Info_List);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgSetAutoDownloadChannelMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Channel_Info_List);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgSetAutoDownloadChannelMethodStart::operator==(const tcu_usb_mainfi_tclMsgSetAutoDownloadChannelMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Channel_Info_List == roRef.Channel_Info_List);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgSetAutoDownloadChannelMethodResult::tcu_usb_mainfi_tclMsgSetAutoDownloadChannelMethodResult()
 {}

tS32 tcu_usb_mainfi_tclMsgSetAutoDownloadChannelMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_SETAUTODOWNLOADCHANNELMETHODRESULT;
}


tcu_usb_mainfi_tclMsgSetAutoDownloadChannelMethodResult::~tcu_usb_mainfi_tclMsgSetAutoDownloadChannelMethodResult()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgGetFavoriteChannelListMethodStart::tcu_usb_mainfi_tclMsgGetFavoriteChannelListMethodStart()
 {}

tS32 tcu_usb_mainfi_tclMsgGetFavoriteChannelListMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_GETFAVORITECHANNELLISTMETHODSTART;
}


tcu_usb_mainfi_tclMsgGetFavoriteChannelListMethodStart::~tcu_usb_mainfi_tclMsgGetFavoriteChannelListMethodStart()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgGetFavoriteChannelListMethodResult::tcu_usb_mainfi_tclMsgGetFavoriteChannelListMethodResult()
 {}

tS32 tcu_usb_mainfi_tclMsgGetFavoriteChannelListMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_GETFAVORITECHANNELLISTMETHODRESULT;
}


tcu_usb_mainfi_tclMsgGetFavoriteChannelListMethodResult::~tcu_usb_mainfi_tclMsgGetFavoriteChannelListMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgSetFavoriteChannelMethodStart::tcu_usb_mainfi_tclMsgSetFavoriteChannelMethodStart(const tcu_usb_mainfi_tclMsgSetFavoriteChannelMethodStart& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   Channel_Info_List = coRef.Channel_Info_List;
}
tcu_usb_mainfi_tclMsgSetFavoriteChannelMethodStart& tcu_usb_mainfi_tclMsgSetFavoriteChannelMethodStart::operator=(const tcu_usb_mainfi_tclMsgSetFavoriteChannelMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Channel_Info_List = coRef.Channel_Info_List;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_mainfi_tclMsgSetFavoriteChannelMethodStart::vDestroy()
{
   Channel_Info_List.vDestroy(); 
}

tcu_usb_mainfi_tclMsgSetFavoriteChannelMethodStart::tcu_usb_mainfi_tclMsgSetFavoriteChannelMethodStart()
:Channel_Info_List()
 {}

tS32 tcu_usb_mainfi_tclMsgSetFavoriteChannelMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_SETFAVORITECHANNELMETHODSTART;
}


tcu_usb_mainfi_tclMsgSetFavoriteChannelMethodStart::~tcu_usb_mainfi_tclMsgSetFavoriteChannelMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_mainfi_tclMsgSetFavoriteChannelMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Channel_Info_List.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_mainfi_tclMsgSetFavoriteChannelMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Channel_Info_List);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgSetFavoriteChannelMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Channel_Info_List);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgSetFavoriteChannelMethodStart::operator==(const tcu_usb_mainfi_tclMsgSetFavoriteChannelMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Channel_Info_List == roRef.Channel_Info_List);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgSetFavoriteChannelMethodResult::tcu_usb_mainfi_tclMsgSetFavoriteChannelMethodResult()
 {}

tS32 tcu_usb_mainfi_tclMsgSetFavoriteChannelMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_SETFAVORITECHANNELMETHODRESULT;
}


tcu_usb_mainfi_tclMsgSetFavoriteChannelMethodResult::~tcu_usb_mainfi_tclMsgSetFavoriteChannelMethodResult()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgReadFavoriteFeedsMethodStart::tcu_usb_mainfi_tclMsgReadFavoriteFeedsMethodStart()
 {}

tS32 tcu_usb_mainfi_tclMsgReadFavoriteFeedsMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_READFAVORITEFEEDSMETHODSTART;
}


tcu_usb_mainfi_tclMsgReadFavoriteFeedsMethodStart::~tcu_usb_mainfi_tclMsgReadFavoriteFeedsMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgReadFavoriteFeedsMethodResult::tcu_usb_mainfi_tclMsgReadFavoriteFeedsMethodResult(const tcu_usb_mainfi_tclMsgReadFavoriteFeedsMethodResult& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   Favorite_Feed_List = coRef.Favorite_Feed_List;
}
tcu_usb_mainfi_tclMsgReadFavoriteFeedsMethodResult& tcu_usb_mainfi_tclMsgReadFavoriteFeedsMethodResult::operator=(const tcu_usb_mainfi_tclMsgReadFavoriteFeedsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Favorite_Feed_List = coRef.Favorite_Feed_List;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_mainfi_tclMsgReadFavoriteFeedsMethodResult::vDestroy()
{
   Favorite_Feed_List.vDestroy(); 
}

tcu_usb_mainfi_tclMsgReadFavoriteFeedsMethodResult::tcu_usb_mainfi_tclMsgReadFavoriteFeedsMethodResult()
:Favorite_Feed_List()
 {}

tS32 tcu_usb_mainfi_tclMsgReadFavoriteFeedsMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_READFAVORITEFEEDSMETHODRESULT;
}


tcu_usb_mainfi_tclMsgReadFavoriteFeedsMethodResult::~tcu_usb_mainfi_tclMsgReadFavoriteFeedsMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_mainfi_tclMsgReadFavoriteFeedsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Favorite_Feed_List.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_mainfi_tclMsgReadFavoriteFeedsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Favorite_Feed_List);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgReadFavoriteFeedsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Favorite_Feed_List);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgReadFavoriteFeedsMethodResult::operator==(const tcu_usb_mainfi_tclMsgReadFavoriteFeedsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Favorite_Feed_List == roRef.Favorite_Feed_List);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgSelectFavoriteFeedsMethodStart::tcu_usb_mainfi_tclMsgSelectFavoriteFeedsMethodStart(const tcu_usb_mainfi_tclMsgSelectFavoriteFeedsMethodStart& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   u16ChannelID = coRef.u16ChannelID;
}
tcu_usb_mainfi_tclMsgSelectFavoriteFeedsMethodStart& tcu_usb_mainfi_tclMsgSelectFavoriteFeedsMethodStart::operator=(const tcu_usb_mainfi_tclMsgSelectFavoriteFeedsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16ChannelID = coRef.u16ChannelID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_mainfi_tclMsgSelectFavoriteFeedsMethodStart::tcu_usb_mainfi_tclMsgSelectFavoriteFeedsMethodStart()
:u16ChannelID(0)
 {}

tS32 tcu_usb_mainfi_tclMsgSelectFavoriteFeedsMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_SELECTFAVORITEFEEDSMETHODSTART;
}


tcu_usb_mainfi_tclMsgSelectFavoriteFeedsMethodStart::~tcu_usb_mainfi_tclMsgSelectFavoriteFeedsMethodStart()
{}

tU32 tcu_usb_mainfi_tclMsgSelectFavoriteFeedsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& tcu_usb_mainfi_tclMsgSelectFavoriteFeedsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16ChannelID);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgSelectFavoriteFeedsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16ChannelID);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgSelectFavoriteFeedsMethodStart::operator==(const tcu_usb_mainfi_tclMsgSelectFavoriteFeedsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16ChannelID == roRef.u16ChannelID);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgSelectFavoriteFeedsMethodResult::tcu_usb_mainfi_tclMsgSelectFavoriteFeedsMethodResult()
 {}

tS32 tcu_usb_mainfi_tclMsgSelectFavoriteFeedsMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_SELECTFAVORITEFEEDSMETHODRESULT;
}


tcu_usb_mainfi_tclMsgSelectFavoriteFeedsMethodResult::~tcu_usb_mainfi_tclMsgSelectFavoriteFeedsMethodResult()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgDeleteInfoHistoryMethodStart::tcu_usb_mainfi_tclMsgDeleteInfoHistoryMethodStart()
 {}

tS32 tcu_usb_mainfi_tclMsgDeleteInfoHistoryMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_DELETEINFOHISTORYMETHODSTART;
}


tcu_usb_mainfi_tclMsgDeleteInfoHistoryMethodStart::~tcu_usb_mainfi_tclMsgDeleteInfoHistoryMethodStart()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgDeleteInfoHistoryMethodResult::tcu_usb_mainfi_tclMsgDeleteInfoHistoryMethodResult()
 {}

tS32 tcu_usb_mainfi_tclMsgDeleteInfoHistoryMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_DELETEINFOHISTORYMETHODRESULT;
}


tcu_usb_mainfi_tclMsgDeleteInfoHistoryMethodResult::~tcu_usb_mainfi_tclMsgDeleteInfoHistoryMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgGetVICSTrafficDataMethodStart::tcu_usb_mainfi_tclMsgGetVICSTrafficDataMethodStart(const tcu_usb_mainfi_tclMsgGetVICSTrafficDataMethodStart& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   VICSRequestData = coRef.VICSRequestData;
}
tcu_usb_mainfi_tclMsgGetVICSTrafficDataMethodStart& tcu_usb_mainfi_tclMsgGetVICSTrafficDataMethodStart::operator=(const tcu_usb_mainfi_tclMsgGetVICSTrafficDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   VICSRequestData = coRef.VICSRequestData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_mainfi_tclMsgGetVICSTrafficDataMethodStart::vDestroy()
{
   VICSRequestData.vDestroy(); 
}

tcu_usb_mainfi_tclMsgGetVICSTrafficDataMethodStart::tcu_usb_mainfi_tclMsgGetVICSTrafficDataMethodStart()
:VICSRequestData()
 {}

tS32 tcu_usb_mainfi_tclMsgGetVICSTrafficDataMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_GETVICSTRAFFICDATAMETHODSTART;
}


tcu_usb_mainfi_tclMsgGetVICSTrafficDataMethodStart::~tcu_usb_mainfi_tclMsgGetVICSTrafficDataMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_mainfi_tclMsgGetVICSTrafficDataMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+VICSRequestData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_mainfi_tclMsgGetVICSTrafficDataMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VICSRequestData);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgGetVICSTrafficDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VICSRequestData);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgGetVICSTrafficDataMethodStart::operator==(const tcu_usb_mainfi_tclMsgGetVICSTrafficDataMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VICSRequestData == roRef.VICSRequestData);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgGetVICSTrafficDataMethodResult::tcu_usb_mainfi_tclMsgGetVICSTrafficDataMethodResult()
 {}

tS32 tcu_usb_mainfi_tclMsgGetVICSTrafficDataMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_GETVICSTRAFFICDATAMETHODRESULT;
}


tcu_usb_mainfi_tclMsgGetVICSTrafficDataMethodResult::~tcu_usb_mainfi_tclMsgGetVICSTrafficDataMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgGetChargingStationsListMethodStart::tcu_usb_mainfi_tclMsgGetChargingStationsListMethodStart(const tcu_usb_mainfi_tclMsgGetChargingStationsListMethodStart& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   ChargingStationsRequestInfo = coRef.ChargingStationsRequestInfo;
}
tcu_usb_mainfi_tclMsgGetChargingStationsListMethodStart& tcu_usb_mainfi_tclMsgGetChargingStationsListMethodStart::operator=(const tcu_usb_mainfi_tclMsgGetChargingStationsListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ChargingStationsRequestInfo = coRef.ChargingStationsRequestInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_mainfi_tclMsgGetChargingStationsListMethodStart::tcu_usb_mainfi_tclMsgGetChargingStationsListMethodStart()
:ChargingStationsRequestInfo()
 {}

tS32 tcu_usb_mainfi_tclMsgGetChargingStationsListMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_GETCHARGINGSTATIONSLISTMETHODSTART;
}


tcu_usb_mainfi_tclMsgGetChargingStationsListMethodStart::~tcu_usb_mainfi_tclMsgGetChargingStationsListMethodStart()
{}

tU32 tcu_usb_mainfi_tclMsgGetChargingStationsListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& tcu_usb_mainfi_tclMsgGetChargingStationsListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ChargingStationsRequestInfo);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgGetChargingStationsListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ChargingStationsRequestInfo);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgGetChargingStationsListMethodStart::operator==(const tcu_usb_mainfi_tclMsgGetChargingStationsListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ChargingStationsRequestInfo == roRef.ChargingStationsRequestInfo);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgGetChargingStationsListMethodResult::tcu_usb_mainfi_tclMsgGetChargingStationsListMethodResult()
 {}

tS32 tcu_usb_mainfi_tclMsgGetChargingStationsListMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_GETCHARGINGSTATIONSLISTMETHODRESULT;
}


tcu_usb_mainfi_tclMsgGetChargingStationsListMethodResult::~tcu_usb_mainfi_tclMsgGetChargingStationsListMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgGetChargingSpotDataMethodStart::tcu_usb_mainfi_tclMsgGetChargingSpotDataMethodStart(const tcu_usb_mainfi_tclMsgGetChargingSpotDataMethodStart& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   POIIDList = coRef.POIIDList;
}
tcu_usb_mainfi_tclMsgGetChargingSpotDataMethodStart& tcu_usb_mainfi_tclMsgGetChargingSpotDataMethodStart::operator=(const tcu_usb_mainfi_tclMsgGetChargingSpotDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   POIIDList = coRef.POIIDList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_mainfi_tclMsgGetChargingSpotDataMethodStart::vDestroy()
{
   POIIDList.vDestroy(); 
}

tcu_usb_mainfi_tclMsgGetChargingSpotDataMethodStart::tcu_usb_mainfi_tclMsgGetChargingSpotDataMethodStart()
:POIIDList()
 {}

tS32 tcu_usb_mainfi_tclMsgGetChargingSpotDataMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_GETCHARGINGSPOTDATAMETHODSTART;
}


tcu_usb_mainfi_tclMsgGetChargingSpotDataMethodStart::~tcu_usb_mainfi_tclMsgGetChargingSpotDataMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_mainfi_tclMsgGetChargingSpotDataMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+POIIDList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_mainfi_tclMsgGetChargingSpotDataMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> POIIDList);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgGetChargingSpotDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << POIIDList);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgGetChargingSpotDataMethodStart::operator==(const tcu_usb_mainfi_tclMsgGetChargingSpotDataMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (POIIDList == roRef.POIIDList);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgGetChargingSpotDataMethodResult::tcu_usb_mainfi_tclMsgGetChargingSpotDataMethodResult()
 {}

tS32 tcu_usb_mainfi_tclMsgGetChargingSpotDataMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_GETCHARGINGSPOTDATAMETHODRESULT;
}


tcu_usb_mainfi_tclMsgGetChargingSpotDataMethodResult::~tcu_usb_mainfi_tclMsgGetChargingSpotDataMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgGetVacancySpotDataMethodStart::tcu_usb_mainfi_tclMsgGetVacancySpotDataMethodStart(const tcu_usb_mainfi_tclMsgGetVacancySpotDataMethodStart& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   POIIDList = coRef.POIIDList;
}
tcu_usb_mainfi_tclMsgGetVacancySpotDataMethodStart& tcu_usb_mainfi_tclMsgGetVacancySpotDataMethodStart::operator=(const tcu_usb_mainfi_tclMsgGetVacancySpotDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   POIIDList = coRef.POIIDList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_mainfi_tclMsgGetVacancySpotDataMethodStart::vDestroy()
{
   POIIDList.vDestroy(); 
}

tcu_usb_mainfi_tclMsgGetVacancySpotDataMethodStart::tcu_usb_mainfi_tclMsgGetVacancySpotDataMethodStart()
:POIIDList()
 {}

tS32 tcu_usb_mainfi_tclMsgGetVacancySpotDataMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_GETVACANCYSPOTDATAMETHODSTART;
}


tcu_usb_mainfi_tclMsgGetVacancySpotDataMethodStart::~tcu_usb_mainfi_tclMsgGetVacancySpotDataMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_mainfi_tclMsgGetVacancySpotDataMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+POIIDList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_mainfi_tclMsgGetVacancySpotDataMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> POIIDList);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgGetVacancySpotDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << POIIDList);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgGetVacancySpotDataMethodStart::operator==(const tcu_usb_mainfi_tclMsgGetVacancySpotDataMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (POIIDList == roRef.POIIDList);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgGetVacancySpotDataMethodResult::tcu_usb_mainfi_tclMsgGetVacancySpotDataMethodResult()
 {}

tS32 tcu_usb_mainfi_tclMsgGetVacancySpotDataMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_GETVACANCYSPOTDATAMETHODRESULT;
}


tcu_usb_mainfi_tclMsgGetVacancySpotDataMethodResult::~tcu_usb_mainfi_tclMsgGetVacancySpotDataMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgGetVacancyStationsListMethodStart::tcu_usb_mainfi_tclMsgGetVacancyStationsListMethodStart(const tcu_usb_mainfi_tclMsgGetVacancyStationsListMethodStart& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   VacancyStationsRequestInfo = coRef.VacancyStationsRequestInfo;
}
tcu_usb_mainfi_tclMsgGetVacancyStationsListMethodStart& tcu_usb_mainfi_tclMsgGetVacancyStationsListMethodStart::operator=(const tcu_usb_mainfi_tclMsgGetVacancyStationsListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   VacancyStationsRequestInfo = coRef.VacancyStationsRequestInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_mainfi_tclMsgGetVacancyStationsListMethodStart::tcu_usb_mainfi_tclMsgGetVacancyStationsListMethodStart()
:VacancyStationsRequestInfo()
 {}

tS32 tcu_usb_mainfi_tclMsgGetVacancyStationsListMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_GETVACANCYSTATIONSLISTMETHODSTART;
}


tcu_usb_mainfi_tclMsgGetVacancyStationsListMethodStart::~tcu_usb_mainfi_tclMsgGetVacancyStationsListMethodStart()
{}

tU32 tcu_usb_mainfi_tclMsgGetVacancyStationsListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& tcu_usb_mainfi_tclMsgGetVacancyStationsListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VacancyStationsRequestInfo);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgGetVacancyStationsListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VacancyStationsRequestInfo);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgGetVacancyStationsListMethodStart::operator==(const tcu_usb_mainfi_tclMsgGetVacancyStationsListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VacancyStationsRequestInfo == roRef.VacancyStationsRequestInfo);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgGetVacancyStationsListMethodResult::tcu_usb_mainfi_tclMsgGetVacancyStationsListMethodResult()
 {}

tS32 tcu_usb_mainfi_tclMsgGetVacancyStationsListMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_GETVACANCYSTATIONSLISTMETHODRESULT;
}


tcu_usb_mainfi_tclMsgGetVacancyStationsListMethodResult::~tcu_usb_mainfi_tclMsgGetVacancyStationsListMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgSendUserCredentialsMethodStart::tcu_usb_mainfi_tclMsgSendUserCredentialsMethodStart(const tcu_usb_mainfi_tclMsgSendUserCredentialsMethodStart& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   sUserId = coRef.sUserId;
   sPassword = coRef.sPassword;
   bClearData = coRef.bClearData;
}
tcu_usb_mainfi_tclMsgSendUserCredentialsMethodStart& tcu_usb_mainfi_tclMsgSendUserCredentialsMethodStart::operator=(const tcu_usb_mainfi_tclMsgSendUserCredentialsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sUserId = coRef.sUserId;
   sPassword = coRef.sPassword;
   bClearData = coRef.bClearData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_mainfi_tclMsgSendUserCredentialsMethodStart::vDestroy()
{
   sUserId.vDestroy();
   sPassword.vDestroy();
}

tcu_usb_mainfi_tclMsgSendUserCredentialsMethodStart::tcu_usb_mainfi_tclMsgSendUserCredentialsMethodStart()
:sUserId()
,sPassword()
,bClearData(0)
 {}

tS32 tcu_usb_mainfi_tclMsgSendUserCredentialsMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_SENDUSERCREDENTIALSMETHODSTART;
}


tcu_usb_mainfi_tclMsgSendUserCredentialsMethodStart::~tcu_usb_mainfi_tclMsgSendUserCredentialsMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_mainfi_tclMsgSendUserCredentialsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+sUserId.u32GetSize(u16MajorVersion)+sPassword.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_mainfi_tclMsgSendUserCredentialsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sUserId);
   (tVoid) (oIn >> sPassword);
   (tVoid) (oIn >> bClearData);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgSendUserCredentialsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sUserId);
   (tVoid) (oOut << sPassword);
   (tVoid) (oOut << bClearData);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgSendUserCredentialsMethodStart::operator==(const tcu_usb_mainfi_tclMsgSendUserCredentialsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sUserId == roRef.sUserId);
   bResult = bResult && (sPassword == roRef.sPassword);
   bResult = bResult && (bClearData == roRef.bClearData);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgSendUserCredentialsMethodResult::tcu_usb_mainfi_tclMsgSendUserCredentialsMethodResult()
 {}

tS32 tcu_usb_mainfi_tclMsgSendUserCredentialsMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_SENDUSERCREDENTIALSMETHODRESULT;
}


tcu_usb_mainfi_tclMsgSendUserCredentialsMethodResult::~tcu_usb_mainfi_tclMsgSendUserCredentialsMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgDeleteChannelInformationMethodStart::tcu_usb_mainfi_tclMsgDeleteChannelInformationMethodStart(const tcu_usb_mainfi_tclMsgDeleteChannelInformationMethodStart& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   u16ChannelID = coRef.u16ChannelID;
}
tcu_usb_mainfi_tclMsgDeleteChannelInformationMethodStart& tcu_usb_mainfi_tclMsgDeleteChannelInformationMethodStart::operator=(const tcu_usb_mainfi_tclMsgDeleteChannelInformationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16ChannelID = coRef.u16ChannelID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_mainfi_tclMsgDeleteChannelInformationMethodStart::tcu_usb_mainfi_tclMsgDeleteChannelInformationMethodStart()
:u16ChannelID(0)
 {}

tS32 tcu_usb_mainfi_tclMsgDeleteChannelInformationMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_DELETECHANNELINFORMATIONMETHODSTART;
}


tcu_usb_mainfi_tclMsgDeleteChannelInformationMethodStart::~tcu_usb_mainfi_tclMsgDeleteChannelInformationMethodStart()
{}

tU32 tcu_usb_mainfi_tclMsgDeleteChannelInformationMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& tcu_usb_mainfi_tclMsgDeleteChannelInformationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16ChannelID);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgDeleteChannelInformationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16ChannelID);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgDeleteChannelInformationMethodStart::operator==(const tcu_usb_mainfi_tclMsgDeleteChannelInformationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16ChannelID == roRef.u16ChannelID);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgDeleteChannelInformationMethodResult::tcu_usb_mainfi_tclMsgDeleteChannelInformationMethodResult()
 {}

tS32 tcu_usb_mainfi_tclMsgDeleteChannelInformationMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_DELETECHANNELINFORMATIONMETHODRESULT;
}


tcu_usb_mainfi_tclMsgDeleteChannelInformationMethodResult::~tcu_usb_mainfi_tclMsgDeleteChannelInformationMethodResult()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgDownloadPartAuthDataMethodStart::tcu_usb_mainfi_tclMsgDownloadPartAuthDataMethodStart()
 {}

tS32 tcu_usb_mainfi_tclMsgDownloadPartAuthDataMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_DOWNLOADPARTAUTHDATAMETHODSTART;
}


tcu_usb_mainfi_tclMsgDownloadPartAuthDataMethodStart::~tcu_usb_mainfi_tclMsgDownloadPartAuthDataMethodStart()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgDownloadPartAuthDataMethodResult::tcu_usb_mainfi_tclMsgDownloadPartAuthDataMethodResult()
 {}

tS32 tcu_usb_mainfi_tclMsgDownloadPartAuthDataMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_DOWNLOADPARTAUTHDATAMETHODRESULT;
}


tcu_usb_mainfi_tclMsgDownloadPartAuthDataMethodResult::~tcu_usb_mainfi_tclMsgDownloadPartAuthDataMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodStart::tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodStart(const tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodStart& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   sUserId = coRef.sUserId;
   sPassword = coRef.sPassword;
}
tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodStart& tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodStart::operator=(const tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sUserId = coRef.sUserId;
   sPassword = coRef.sPassword;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodStart::vDestroy()
{
   sUserId.vDestroy();
   sPassword.vDestroy();
}

tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodStart::tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodStart()
:sUserId()
,sPassword()
 {}

tS32 tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_VALIDATEUSERCREDENTIALSMETHODSTART;
}


tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodStart::~tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+sUserId.u32GetSize(u16MajorVersion)+sPassword.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sUserId);
   (tVoid) (oIn >> sPassword);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sUserId);
   (tVoid) (oOut << sPassword);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodStart::operator==(const tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sUserId == roRef.sUserId);
   bResult = bResult && (sPassword == roRef.sPassword);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodResult::tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodResult(const tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodResult& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
   Token = coRef.Token;
}
tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodResult& tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodResult::operator=(const tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   Token = coRef.Token;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodResult::vDestroy()
{
   Token.vDestroy();
}

tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodResult::tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodResult()
:Result()
,Token()
 {}

tS32 tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_VALIDATEUSERCREDENTIALSMETHODRESULT;
}


tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodResult::~tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+Token.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   (tVoid) (oIn >> Token);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   (tVoid) (oOut << Token);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodResult::operator==(const tcu_usb_mainfi_tclMsgValidateUserCredentialsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   bResult = bResult && (Token == roRef.Token);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgRenewAccessTokenMethodStart::tcu_usb_mainfi_tclMsgRenewAccessTokenMethodStart()
 {}

tS32 tcu_usb_mainfi_tclMsgRenewAccessTokenMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_RENEWACCESSTOKENMETHODSTART;
}


tcu_usb_mainfi_tclMsgRenewAccessTokenMethodStart::~tcu_usb_mainfi_tclMsgRenewAccessTokenMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgRenewAccessTokenMethodResult::tcu_usb_mainfi_tclMsgRenewAccessTokenMethodResult(const tcu_usb_mainfi_tclMsgRenewAccessTokenMethodResult& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
   Token = coRef.Token;
}
tcu_usb_mainfi_tclMsgRenewAccessTokenMethodResult& tcu_usb_mainfi_tclMsgRenewAccessTokenMethodResult::operator=(const tcu_usb_mainfi_tclMsgRenewAccessTokenMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   Token = coRef.Token;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_mainfi_tclMsgRenewAccessTokenMethodResult::vDestroy()
{
   Token.vDestroy();
}

tcu_usb_mainfi_tclMsgRenewAccessTokenMethodResult::tcu_usb_mainfi_tclMsgRenewAccessTokenMethodResult()
:Result()
,Token()
 {}

tS32 tcu_usb_mainfi_tclMsgRenewAccessTokenMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_RENEWACCESSTOKENMETHODRESULT;
}


tcu_usb_mainfi_tclMsgRenewAccessTokenMethodResult::~tcu_usb_mainfi_tclMsgRenewAccessTokenMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_mainfi_tclMsgRenewAccessTokenMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+Token.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_mainfi_tclMsgRenewAccessTokenMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   (tVoid) (oIn >> Token);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgRenewAccessTokenMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   (tVoid) (oOut << Token);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgRenewAccessTokenMethodResult::operator==(const tcu_usb_mainfi_tclMsgRenewAccessTokenMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   bResult = bResult && (Token == roRef.Token);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgGetAccessTokenMethodStart::tcu_usb_mainfi_tclMsgGetAccessTokenMethodStart()
 {}

tS32 tcu_usb_mainfi_tclMsgGetAccessTokenMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_GETACCESSTOKENMETHODSTART;
}


tcu_usb_mainfi_tclMsgGetAccessTokenMethodStart::~tcu_usb_mainfi_tclMsgGetAccessTokenMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgGetAccessTokenMethodResult::tcu_usb_mainfi_tclMsgGetAccessTokenMethodResult(const tcu_usb_mainfi_tclMsgGetAccessTokenMethodResult& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
   Token = coRef.Token;
}
tcu_usb_mainfi_tclMsgGetAccessTokenMethodResult& tcu_usb_mainfi_tclMsgGetAccessTokenMethodResult::operator=(const tcu_usb_mainfi_tclMsgGetAccessTokenMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   Token = coRef.Token;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_mainfi_tclMsgGetAccessTokenMethodResult::vDestroy()
{
   Token.vDestroy();
}

tcu_usb_mainfi_tclMsgGetAccessTokenMethodResult::tcu_usb_mainfi_tclMsgGetAccessTokenMethodResult()
:Result()
,Token()
 {}

tS32 tcu_usb_mainfi_tclMsgGetAccessTokenMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_GETACCESSTOKENMETHODRESULT;
}


tcu_usb_mainfi_tclMsgGetAccessTokenMethodResult::~tcu_usb_mainfi_tclMsgGetAccessTokenMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_mainfi_tclMsgGetAccessTokenMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+Token.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_mainfi_tclMsgGetAccessTokenMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   (tVoid) (oIn >> Token);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgGetAccessTokenMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   (tVoid) (oOut << Token);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgGetAccessTokenMethodResult::operator==(const tcu_usb_mainfi_tclMsgGetAccessTokenMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   bResult = bResult && (Token == roRef.Token);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodStart::tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodStart(const tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodStart& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   sUserId = coRef.sUserId;
   sPassword = coRef.sPassword;
}
tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodStart& tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodStart::operator=(const tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sUserId = coRef.sUserId;
   sPassword = coRef.sPassword;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodStart::vDestroy()
{
   sUserId.vDestroy();
   sPassword.vDestroy();
}

tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodStart::tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodStart()
:sUserId()
,sPassword()
 {}

tS32 tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_VALIDATEUSERCREDENTIALSONTOKENRENEWALERRORMETHODSTART;
}


tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodStart::~tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+sUserId.u32GetSize(u16MajorVersion)+sPassword.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sUserId);
   (tVoid) (oIn >> sPassword);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sUserId);
   (tVoid) (oOut << sPassword);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodStart::operator==(const tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sUserId == roRef.sUserId);
   bResult = bResult && (sPassword == roRef.sPassword);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodResult::tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodResult(const tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodResult& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodResult& tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodResult::operator=(const tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodResult::tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodResult()
:Result()
 {}

tS32 tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_VALIDATEUSERCREDENTIALSONTOKENRENEWALERRORMETHODRESULT;
}


tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodResult::~tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodResult()
{}

tU32 tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodResult::operator==(const tcu_usb_mainfi_tclMsgValidateUserCredentialsOnTokenRenewalErrorMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgCancelUserValidationRenewTokenMethodStart::tcu_usb_mainfi_tclMsgCancelUserValidationRenewTokenMethodStart()
 {}

tS32 tcu_usb_mainfi_tclMsgCancelUserValidationRenewTokenMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_CANCELUSERVALIDATIONRENEWTOKENMETHODSTART;
}


tcu_usb_mainfi_tclMsgCancelUserValidationRenewTokenMethodStart::~tcu_usb_mainfi_tclMsgCancelUserValidationRenewTokenMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgCancelUserValidationRenewTokenMethodResult::tcu_usb_mainfi_tclMsgCancelUserValidationRenewTokenMethodResult(const tcu_usb_mainfi_tclMsgCancelUserValidationRenewTokenMethodResult& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
tcu_usb_mainfi_tclMsgCancelUserValidationRenewTokenMethodResult& tcu_usb_mainfi_tclMsgCancelUserValidationRenewTokenMethodResult::operator=(const tcu_usb_mainfi_tclMsgCancelUserValidationRenewTokenMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_mainfi_tclMsgCancelUserValidationRenewTokenMethodResult::tcu_usb_mainfi_tclMsgCancelUserValidationRenewTokenMethodResult()
:Result()
 {}

tS32 tcu_usb_mainfi_tclMsgCancelUserValidationRenewTokenMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_CANCELUSERVALIDATIONRENEWTOKENMETHODRESULT;
}


tcu_usb_mainfi_tclMsgCancelUserValidationRenewTokenMethodResult::~tcu_usb_mainfi_tclMsgCancelUserValidationRenewTokenMethodResult()
{}

tU32 tcu_usb_mainfi_tclMsgCancelUserValidationRenewTokenMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_mainfi_tclMsgCancelUserValidationRenewTokenMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgCancelUserValidationRenewTokenMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgCancelUserValidationRenewTokenMethodResult::operator==(const tcu_usb_mainfi_tclMsgCancelUserValidationRenewTokenMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgDecodeIdTokenMethodStart::tcu_usb_mainfi_tclMsgDecodeIdTokenMethodStart(const tcu_usb_mainfi_tclMsgDecodeIdTokenMethodStart& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   Token = coRef.Token;
}
tcu_usb_mainfi_tclMsgDecodeIdTokenMethodStart& tcu_usb_mainfi_tclMsgDecodeIdTokenMethodStart::operator=(const tcu_usb_mainfi_tclMsgDecodeIdTokenMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Token = coRef.Token;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_mainfi_tclMsgDecodeIdTokenMethodStart::vDestroy()
{
   Token.vDestroy();
}

tcu_usb_mainfi_tclMsgDecodeIdTokenMethodStart::tcu_usb_mainfi_tclMsgDecodeIdTokenMethodStart()
:Token()
 {}

tS32 tcu_usb_mainfi_tclMsgDecodeIdTokenMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_DECODEIDTOKENMETHODSTART;
}


tcu_usb_mainfi_tclMsgDecodeIdTokenMethodStart::~tcu_usb_mainfi_tclMsgDecodeIdTokenMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_mainfi_tclMsgDecodeIdTokenMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Token.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_mainfi_tclMsgDecodeIdTokenMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Token);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgDecodeIdTokenMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Token);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgDecodeIdTokenMethodStart::operator==(const tcu_usb_mainfi_tclMsgDecodeIdTokenMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Token == roRef.Token);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgDecodeIdTokenMethodResult::tcu_usb_mainfi_tclMsgDecodeIdTokenMethodResult(const tcu_usb_mainfi_tclMsgDecodeIdTokenMethodResult& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
tcu_usb_mainfi_tclMsgDecodeIdTokenMethodResult& tcu_usb_mainfi_tclMsgDecodeIdTokenMethodResult::operator=(const tcu_usb_mainfi_tclMsgDecodeIdTokenMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_mainfi_tclMsgDecodeIdTokenMethodResult::vDestroy()
{
   Result.vDestroy(); 
}

tcu_usb_mainfi_tclMsgDecodeIdTokenMethodResult::tcu_usb_mainfi_tclMsgDecodeIdTokenMethodResult()
:Result()
 {}

tS32 tcu_usb_mainfi_tclMsgDecodeIdTokenMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_DECODEIDTOKENMETHODRESULT;
}


tcu_usb_mainfi_tclMsgDecodeIdTokenMethodResult::~tcu_usb_mainfi_tclMsgDecodeIdTokenMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_mainfi_tclMsgDecodeIdTokenMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Result.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_mainfi_tclMsgDecodeIdTokenMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgDecodeIdTokenMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgDecodeIdTokenMethodResult::operator==(const tcu_usb_mainfi_tclMsgDecodeIdTokenMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgResetNCSSettingsMethodStart::tcu_usb_mainfi_tclMsgResetNCSSettingsMethodStart()
 {}

tS32 tcu_usb_mainfi_tclMsgResetNCSSettingsMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_RESETNCSSETTINGSMETHODSTART;
}


tcu_usb_mainfi_tclMsgResetNCSSettingsMethodStart::~tcu_usb_mainfi_tclMsgResetNCSSettingsMethodStart()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgResetNCSSettingsMethodResult::tcu_usb_mainfi_tclMsgResetNCSSettingsMethodResult()
 {}

tS32 tcu_usb_mainfi_tclMsgResetNCSSettingsMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_RESETNCSSETTINGSMETHODRESULT;
}


tcu_usb_mainfi_tclMsgResetNCSSettingsMethodResult::~tcu_usb_mainfi_tclMsgResetNCSSettingsMethodResult()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgGetProbeUploadPermitMethodStart::tcu_usb_mainfi_tclMsgGetProbeUploadPermitMethodStart()
 {}

tS32 tcu_usb_mainfi_tclMsgGetProbeUploadPermitMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_GETPROBEUPLOADPERMITMETHODSTART;
}


tcu_usb_mainfi_tclMsgGetProbeUploadPermitMethodStart::~tcu_usb_mainfi_tclMsgGetProbeUploadPermitMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgGetProbeUploadPermitMethodResult::tcu_usb_mainfi_tclMsgGetProbeUploadPermitMethodResult(const tcu_usb_mainfi_tclMsgGetProbeUploadPermitMethodResult& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   e8ProbePermitSetting = coRef.e8ProbePermitSetting;
}
tcu_usb_mainfi_tclMsgGetProbeUploadPermitMethodResult& tcu_usb_mainfi_tclMsgGetProbeUploadPermitMethodResult::operator=(const tcu_usb_mainfi_tclMsgGetProbeUploadPermitMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8ProbePermitSetting = coRef.e8ProbePermitSetting;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_mainfi_tclMsgGetProbeUploadPermitMethodResult::tcu_usb_mainfi_tclMsgGetProbeUploadPermitMethodResult()
:e8ProbePermitSetting()
 {}

tS32 tcu_usb_mainfi_tclMsgGetProbeUploadPermitMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_GETPROBEUPLOADPERMITMETHODRESULT;
}


tcu_usb_mainfi_tclMsgGetProbeUploadPermitMethodResult::~tcu_usb_mainfi_tclMsgGetProbeUploadPermitMethodResult()
{}

tU32 tcu_usb_mainfi_tclMsgGetProbeUploadPermitMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_mainfi_tclMsgGetProbeUploadPermitMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ProbePermitSetting);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgGetProbeUploadPermitMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ProbePermitSetting);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgGetProbeUploadPermitMethodResult::operator==(const tcu_usb_mainfi_tclMsgGetProbeUploadPermitMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ProbePermitSetting == roRef.e8ProbePermitSetting);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodStart::tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodStart(const tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodStart& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   e8ProbePermitSetting = coRef.e8ProbePermitSetting;
}
tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodStart& tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodStart::operator=(const tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8ProbePermitSetting = coRef.e8ProbePermitSetting;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodStart::tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodStart()
:e8ProbePermitSetting()
 {}

tS32 tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_SETPROBEUPLOADPERMITMETHODSTART;
}


tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodStart::~tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodStart()
{}

tU32 tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ProbePermitSetting);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ProbePermitSetting);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodStart::operator==(const tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ProbePermitSetting == roRef.e8ProbePermitSetting);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodResult::tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodResult(const tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodResult& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   e8ProbePermitSetting = coRef.e8ProbePermitSetting;
}
tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodResult& tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodResult::operator=(const tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8ProbePermitSetting = coRef.e8ProbePermitSetting;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodResult::tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodResult()
:e8ProbePermitSetting()
 {}

tS32 tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_SETPROBEUPLOADPERMITMETHODRESULT;
}


tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodResult::~tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodResult()
{}

tU32 tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ProbePermitSetting);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ProbePermitSetting);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodResult::operator==(const tcu_usb_mainfi_tclMsgSetProbeUploadPermitMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ProbePermitSetting == roRef.e8ProbePermitSetting);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgSetProbeInfoDeleteMethodStart::tcu_usb_mainfi_tclMsgSetProbeInfoDeleteMethodStart()
 {}

tS32 tcu_usb_mainfi_tclMsgSetProbeInfoDeleteMethodStart::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_SETPROBEINFODELETEMETHODSTART;
}


tcu_usb_mainfi_tclMsgSetProbeInfoDeleteMethodStart::~tcu_usb_mainfi_tclMsgSetProbeInfoDeleteMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgSetProbeInfoDeleteMethodResult::tcu_usb_mainfi_tclMsgSetProbeInfoDeleteMethodResult(const tcu_usb_mainfi_tclMsgSetProbeInfoDeleteMethodResult& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   bStatusFromTCU = coRef.bStatusFromTCU;
}
tcu_usb_mainfi_tclMsgSetProbeInfoDeleteMethodResult& tcu_usb_mainfi_tclMsgSetProbeInfoDeleteMethodResult::operator=(const tcu_usb_mainfi_tclMsgSetProbeInfoDeleteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bStatusFromTCU = coRef.bStatusFromTCU;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_mainfi_tclMsgSetProbeInfoDeleteMethodResult::tcu_usb_mainfi_tclMsgSetProbeInfoDeleteMethodResult()
:bStatusFromTCU(0)
 {}

tS32 tcu_usb_mainfi_tclMsgSetProbeInfoDeleteMethodResult::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_SETPROBEINFODELETEMETHODRESULT;
}


tcu_usb_mainfi_tclMsgSetProbeInfoDeleteMethodResult::~tcu_usb_mainfi_tclMsgSetProbeInfoDeleteMethodResult()
{}

tU32 tcu_usb_mainfi_tclMsgSetProbeInfoDeleteMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_mainfi_tclMsgSetProbeInfoDeleteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bStatusFromTCU);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgSetProbeInfoDeleteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bStatusFromTCU);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgSetProbeInfoDeleteMethodResult::operator==(const tcu_usb_mainfi_tclMsgSetProbeInfoDeleteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bStatusFromTCU == roRef.bStatusFromTCU);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgUserCredentialStatusUpReg::tcu_usb_mainfi_tclMsgUserCredentialStatusUpReg()
 {}

tS32 tcu_usb_mainfi_tclMsgUserCredentialStatusUpReg::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_USERCREDENTIALSTATUSUPREG;
}


tcu_usb_mainfi_tclMsgUserCredentialStatusUpReg::~tcu_usb_mainfi_tclMsgUserCredentialStatusUpReg()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgUserCredentialStatusRelUpReg::tcu_usb_mainfi_tclMsgUserCredentialStatusRelUpReg()
 {}

tS32 tcu_usb_mainfi_tclMsgUserCredentialStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_USERCREDENTIALSTATUSRELUPREG;
}


tcu_usb_mainfi_tclMsgUserCredentialStatusRelUpReg::~tcu_usb_mainfi_tclMsgUserCredentialStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgUserCredentialStatusStatus::tcu_usb_mainfi_tclMsgUserCredentialStatusStatus(const tcu_usb_mainfi_tclMsgUserCredentialStatusStatus& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   sDisplayMessage = coRef.sDisplayMessage;
   sTTSTextMessage = coRef.sTTSTextMessage;
   e8AuthenticationResult = coRef.e8AuthenticationResult;
}
tcu_usb_mainfi_tclMsgUserCredentialStatusStatus& tcu_usb_mainfi_tclMsgUserCredentialStatusStatus::operator=(const tcu_usb_mainfi_tclMsgUserCredentialStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   sDisplayMessage = coRef.sDisplayMessage;
   sTTSTextMessage = coRef.sTTSTextMessage;
   e8AuthenticationResult = coRef.e8AuthenticationResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_mainfi_tclMsgUserCredentialStatusStatus::vDestroy()
{
   sDisplayMessage.vDestroy();
   sTTSTextMessage.vDestroy();
}

tcu_usb_mainfi_tclMsgUserCredentialStatusStatus::tcu_usb_mainfi_tclMsgUserCredentialStatusStatus()
:sDisplayMessage()
,sTTSTextMessage()
,e8AuthenticationResult()
 {}

tS32 tcu_usb_mainfi_tclMsgUserCredentialStatusStatus::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_USERCREDENTIALSTATUSSTATUS;
}


tcu_usb_mainfi_tclMsgUserCredentialStatusStatus::~tcu_usb_mainfi_tclMsgUserCredentialStatusStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_mainfi_tclMsgUserCredentialStatusStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+sDisplayMessage.u32GetSize(u16MajorVersion)+sTTSTextMessage.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_mainfi_tclMsgUserCredentialStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sDisplayMessage);
   (tVoid) (oIn >> sTTSTextMessage);
   (tVoid) (oIn >> e8AuthenticationResult);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgUserCredentialStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sDisplayMessage);
   (tVoid) (oOut << sTTSTextMessage);
   (tVoid) (oOut << e8AuthenticationResult);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgUserCredentialStatusStatus::operator==(const tcu_usb_mainfi_tclMsgUserCredentialStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sDisplayMessage == roRef.sDisplayMessage);
   bResult = bResult && (sTTSTextMessage == roRef.sTTSTextMessage);
   bResult = bResult && (e8AuthenticationResult == roRef.e8AuthenticationResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgNotifyTokenRenewalErrorStatus::tcu_usb_mainfi_tclMsgNotifyTokenRenewalErrorStatus(const tcu_usb_mainfi_tclMsgNotifyTokenRenewalErrorStatus& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   ShowCredentialsScreen = coRef.ShowCredentialsScreen;
}
tcu_usb_mainfi_tclMsgNotifyTokenRenewalErrorStatus& tcu_usb_mainfi_tclMsgNotifyTokenRenewalErrorStatus::operator=(const tcu_usb_mainfi_tclMsgNotifyTokenRenewalErrorStatus& coRef)
{
   if (this == &coRef) return *this;
   ShowCredentialsScreen = coRef.ShowCredentialsScreen;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_mainfi_tclMsgNotifyTokenRenewalErrorStatus::tcu_usb_mainfi_tclMsgNotifyTokenRenewalErrorStatus()
:ShowCredentialsScreen(0)
 {}

tS32 tcu_usb_mainfi_tclMsgNotifyTokenRenewalErrorStatus::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_NOTIFYTOKENRENEWALERRORSTATUS;
}


tcu_usb_mainfi_tclMsgNotifyTokenRenewalErrorStatus::~tcu_usb_mainfi_tclMsgNotifyTokenRenewalErrorStatus()
{}

tU32 tcu_usb_mainfi_tclMsgNotifyTokenRenewalErrorStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_mainfi_tclMsgNotifyTokenRenewalErrorStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ShowCredentialsScreen);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgNotifyTokenRenewalErrorStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ShowCredentialsScreen);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgNotifyTokenRenewalErrorStatus::operator==(const tcu_usb_mainfi_tclMsgNotifyTokenRenewalErrorStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ShowCredentialsScreen == roRef.ShowCredentialsScreen);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgConnectedSearchResultUpReg::tcu_usb_mainfi_tclMsgConnectedSearchResultUpReg()
 {}

tS32 tcu_usb_mainfi_tclMsgConnectedSearchResultUpReg::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_CONNECTEDSEARCHRESULTUPREG;
}


tcu_usb_mainfi_tclMsgConnectedSearchResultUpReg::~tcu_usb_mainfi_tclMsgConnectedSearchResultUpReg()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgConnectedSearchResultRelUpReg::tcu_usb_mainfi_tclMsgConnectedSearchResultRelUpReg()
 {}

tS32 tcu_usb_mainfi_tclMsgConnectedSearchResultRelUpReg::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_CONNECTEDSEARCHRESULTRELUPREG;
}


tcu_usb_mainfi_tclMsgConnectedSearchResultRelUpReg::~tcu_usb_mainfi_tclMsgConnectedSearchResultRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgConnectedSearchResultStatus::tcu_usb_mainfi_tclMsgConnectedSearchResultStatus(const tcu_usb_mainfi_tclMsgConnectedSearchResultStatus& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   ConnectedSearch = coRef.ConnectedSearch;
   ServiceType = coRef.ServiceType;
   u8ExecType = coRef.u8ExecType;
}
tcu_usb_mainfi_tclMsgConnectedSearchResultStatus& tcu_usb_mainfi_tclMsgConnectedSearchResultStatus::operator=(const tcu_usb_mainfi_tclMsgConnectedSearchResultStatus& coRef)
{
   if (this == &coRef) return *this;
   ConnectedSearch = coRef.ConnectedSearch;
   ServiceType = coRef.ServiceType;
   u8ExecType = coRef.u8ExecType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_mainfi_tclMsgConnectedSearchResultStatus::vDestroy()
{
   ConnectedSearch.vDestroy(); 
}

tcu_usb_mainfi_tclMsgConnectedSearchResultStatus::tcu_usb_mainfi_tclMsgConnectedSearchResultStatus()
:ConnectedSearch()
,ServiceType()
,u8ExecType()
 {}

tS32 tcu_usb_mainfi_tclMsgConnectedSearchResultStatus::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_CONNECTEDSEARCHRESULTSTATUS;
}


tcu_usb_mainfi_tclMsgConnectedSearchResultStatus::~tcu_usb_mainfi_tclMsgConnectedSearchResultStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_mainfi_tclMsgConnectedSearchResultStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+ConnectedSearch.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_mainfi_tclMsgConnectedSearchResultStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ConnectedSearch);
   (tVoid) (oIn >> ServiceType);
   (tVoid) (oIn >> u8ExecType);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgConnectedSearchResultStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ConnectedSearch);
   (tVoid) (oOut << ServiceType);
   (tVoid) (oOut << u8ExecType);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgConnectedSearchResultStatus::operator==(const tcu_usb_mainfi_tclMsgConnectedSearchResultStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ConnectedSearch == roRef.ConnectedSearch);
   bResult = bResult && (ServiceType == roRef.ServiceType);
   bResult = bResult && (u8ExecType == roRef.u8ExecType);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgChannelMasterDataUpReg::tcu_usb_mainfi_tclMsgChannelMasterDataUpReg()
 {}

tS32 tcu_usb_mainfi_tclMsgChannelMasterDataUpReg::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_CHANNELMASTERDATAUPREG;
}


tcu_usb_mainfi_tclMsgChannelMasterDataUpReg::~tcu_usb_mainfi_tclMsgChannelMasterDataUpReg()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgChannelMasterDataRelUpReg::tcu_usb_mainfi_tclMsgChannelMasterDataRelUpReg()
 {}

tS32 tcu_usb_mainfi_tclMsgChannelMasterDataRelUpReg::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_CHANNELMASTERDATARELUPREG;
}


tcu_usb_mainfi_tclMsgChannelMasterDataRelUpReg::~tcu_usb_mainfi_tclMsgChannelMasterDataRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgChannelMasterDataStatus::tcu_usb_mainfi_tclMsgChannelMasterDataStatus(const tcu_usb_mainfi_tclMsgChannelMasterDataStatus& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   ChannelMasterData = coRef.ChannelMasterData;
}
tcu_usb_mainfi_tclMsgChannelMasterDataStatus& tcu_usb_mainfi_tclMsgChannelMasterDataStatus::operator=(const tcu_usb_mainfi_tclMsgChannelMasterDataStatus& coRef)
{
   if (this == &coRef) return *this;
   ChannelMasterData = coRef.ChannelMasterData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_mainfi_tclMsgChannelMasterDataStatus::vDestroy()
{
   ChannelMasterData.vDestroy(); 
}

tcu_usb_mainfi_tclMsgChannelMasterDataStatus::tcu_usb_mainfi_tclMsgChannelMasterDataStatus()
:ChannelMasterData()
 {}

tS32 tcu_usb_mainfi_tclMsgChannelMasterDataStatus::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_CHANNELMASTERDATASTATUS;
}


tcu_usb_mainfi_tclMsgChannelMasterDataStatus::~tcu_usb_mainfi_tclMsgChannelMasterDataStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_mainfi_tclMsgChannelMasterDataStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+ChannelMasterData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_mainfi_tclMsgChannelMasterDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ChannelMasterData);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgChannelMasterDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ChannelMasterData);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgChannelMasterDataStatus::operator==(const tcu_usb_mainfi_tclMsgChannelMasterDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ChannelMasterData == roRef.ChannelMasterData);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgTtsAudioStateRequestUpReg::tcu_usb_mainfi_tclMsgTtsAudioStateRequestUpReg()
 {}

tS32 tcu_usb_mainfi_tclMsgTtsAudioStateRequestUpReg::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_TTSAUDIOSTATEREQUESTUPREG;
}


tcu_usb_mainfi_tclMsgTtsAudioStateRequestUpReg::~tcu_usb_mainfi_tclMsgTtsAudioStateRequestUpReg()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgTtsAudioStateRequestRelUpReg::tcu_usb_mainfi_tclMsgTtsAudioStateRequestRelUpReg()
 {}

tS32 tcu_usb_mainfi_tclMsgTtsAudioStateRequestRelUpReg::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_TTSAUDIOSTATEREQUESTRELUPREG;
}


tcu_usb_mainfi_tclMsgTtsAudioStateRequestRelUpReg::~tcu_usb_mainfi_tclMsgTtsAudioStateRequestRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgTtsAudioStateRequestStatus::tcu_usb_mainfi_tclMsgTtsAudioStateRequestStatus(const tcu_usb_mainfi_tclMsgTtsAudioStateRequestStatus& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   AudioActivity = coRef.AudioActivity;
}
tcu_usb_mainfi_tclMsgTtsAudioStateRequestStatus& tcu_usb_mainfi_tclMsgTtsAudioStateRequestStatus::operator=(const tcu_usb_mainfi_tclMsgTtsAudioStateRequestStatus& coRef)
{
   if (this == &coRef) return *this;
   AudioActivity = coRef.AudioActivity;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_mainfi_tclMsgTtsAudioStateRequestStatus::tcu_usb_mainfi_tclMsgTtsAudioStateRequestStatus()
:AudioActivity()
 {}

tS32 tcu_usb_mainfi_tclMsgTtsAudioStateRequestStatus::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_TTSAUDIOSTATEREQUESTSTATUS;
}


tcu_usb_mainfi_tclMsgTtsAudioStateRequestStatus::~tcu_usb_mainfi_tclMsgTtsAudioStateRequestStatus()
{}

tU32 tcu_usb_mainfi_tclMsgTtsAudioStateRequestStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_mainfi_tclMsgTtsAudioStateRequestStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AudioActivity);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgTtsAudioStateRequestStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AudioActivity);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgTtsAudioStateRequestStatus::operator==(const tcu_usb_mainfi_tclMsgTtsAudioStateRequestStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AudioActivity == roRef.AudioActivity);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgDatabaseStatusUpReg::tcu_usb_mainfi_tclMsgDatabaseStatusUpReg()
 {}

tS32 tcu_usb_mainfi_tclMsgDatabaseStatusUpReg::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_DATABASESTATUSUPREG;
}


tcu_usb_mainfi_tclMsgDatabaseStatusUpReg::~tcu_usb_mainfi_tclMsgDatabaseStatusUpReg()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgDatabaseStatusRelUpReg::tcu_usb_mainfi_tclMsgDatabaseStatusRelUpReg()
 {}

tS32 tcu_usb_mainfi_tclMsgDatabaseStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_DATABASESTATUSRELUPREG;
}


tcu_usb_mainfi_tclMsgDatabaseStatusRelUpReg::~tcu_usb_mainfi_tclMsgDatabaseStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgDatabaseStatusStatus::tcu_usb_mainfi_tclMsgDatabaseStatusStatus(const tcu_usb_mainfi_tclMsgDatabaseStatusStatus& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   DatabaseStatus = coRef.DatabaseStatus;
   Databasepath = coRef.Databasepath;
   DatabaseServiceType = coRef.DatabaseServiceType;
   PopupEnabled = coRef.PopupEnabled;
}
tcu_usb_mainfi_tclMsgDatabaseStatusStatus& tcu_usb_mainfi_tclMsgDatabaseStatusStatus::operator=(const tcu_usb_mainfi_tclMsgDatabaseStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   DatabaseStatus = coRef.DatabaseStatus;
   Databasepath = coRef.Databasepath;
   DatabaseServiceType = coRef.DatabaseServiceType;
   PopupEnabled = coRef.PopupEnabled;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_mainfi_tclMsgDatabaseStatusStatus::vDestroy()
{
   Databasepath.vDestroy();
}

tcu_usb_mainfi_tclMsgDatabaseStatusStatus::tcu_usb_mainfi_tclMsgDatabaseStatusStatus()
:DatabaseStatus()
,Databasepath()
,DatabaseServiceType()
,PopupEnabled(0)
 {}

tS32 tcu_usb_mainfi_tclMsgDatabaseStatusStatus::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_DATABASESTATUSSTATUS;
}


tcu_usb_mainfi_tclMsgDatabaseStatusStatus::~tcu_usb_mainfi_tclMsgDatabaseStatusStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_mainfi_tclMsgDatabaseStatusStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 3+Databasepath.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_mainfi_tclMsgDatabaseStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DatabaseStatus);
   (tVoid) (oIn >> Databasepath);
   (tVoid) (oIn >> DatabaseServiceType);
   (tVoid) (oIn >> PopupEnabled);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgDatabaseStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DatabaseStatus);
   (tVoid) (oOut << Databasepath);
   (tVoid) (oOut << DatabaseServiceType);
   (tVoid) (oOut << PopupEnabled);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgDatabaseStatusStatus::operator==(const tcu_usb_mainfi_tclMsgDatabaseStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DatabaseStatus == roRef.DatabaseStatus);
   bResult = bResult && (Databasepath == roRef.Databasepath);
   bResult = bResult && (DatabaseServiceType == roRef.DatabaseServiceType);
   bResult = bResult && (PopupEnabled == roRef.PopupEnabled);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgDatabaseStatusSet::tcu_usb_mainfi_tclMsgDatabaseStatusSet()
 {}

tS32 tcu_usb_mainfi_tclMsgDatabaseStatusSet::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_DATABASESTATUSSET;
}


tcu_usb_mainfi_tclMsgDatabaseStatusSet::~tcu_usb_mainfi_tclMsgDatabaseStatusSet()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgDataConnectionStatusUpReg::tcu_usb_mainfi_tclMsgDataConnectionStatusUpReg()
 {}

tS32 tcu_usb_mainfi_tclMsgDataConnectionStatusUpReg::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_DATACONNECTIONSTATUSUPREG;
}


tcu_usb_mainfi_tclMsgDataConnectionStatusUpReg::~tcu_usb_mainfi_tclMsgDataConnectionStatusUpReg()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgDataConnectionStatusRelUpReg::tcu_usb_mainfi_tclMsgDataConnectionStatusRelUpReg()
 {}

tS32 tcu_usb_mainfi_tclMsgDataConnectionStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_DATACONNECTIONSTATUSRELUPREG;
}


tcu_usb_mainfi_tclMsgDataConnectionStatusRelUpReg::~tcu_usb_mainfi_tclMsgDataConnectionStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgDataConnectionStatusStatus::tcu_usb_mainfi_tclMsgDataConnectionStatusStatus(const tcu_usb_mainfi_tclMsgDataConnectionStatusStatus& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   DataConnectionStatus = coRef.DataConnectionStatus;
}
tcu_usb_mainfi_tclMsgDataConnectionStatusStatus& tcu_usb_mainfi_tclMsgDataConnectionStatusStatus::operator=(const tcu_usb_mainfi_tclMsgDataConnectionStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   DataConnectionStatus = coRef.DataConnectionStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_mainfi_tclMsgDataConnectionStatusStatus::tcu_usb_mainfi_tclMsgDataConnectionStatusStatus()
:DataConnectionStatus()
 {}

tS32 tcu_usb_mainfi_tclMsgDataConnectionStatusStatus::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_DATACONNECTIONSTATUSSTATUS;
}


tcu_usb_mainfi_tclMsgDataConnectionStatusStatus::~tcu_usb_mainfi_tclMsgDataConnectionStatusStatus()
{}

tU32 tcu_usb_mainfi_tclMsgDataConnectionStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_mainfi_tclMsgDataConnectionStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DataConnectionStatus);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgDataConnectionStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DataConnectionStatus);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgDataConnectionStatusStatus::operator==(const tcu_usb_mainfi_tclMsgDataConnectionStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DataConnectionStatus == roRef.DataConnectionStatus);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgDataConnectionErrorUpReg::tcu_usb_mainfi_tclMsgDataConnectionErrorUpReg()
 {}

tS32 tcu_usb_mainfi_tclMsgDataConnectionErrorUpReg::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_DATACONNECTIONERRORUPREG;
}


tcu_usb_mainfi_tclMsgDataConnectionErrorUpReg::~tcu_usb_mainfi_tclMsgDataConnectionErrorUpReg()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgDataConnectionErrorRelUpReg::tcu_usb_mainfi_tclMsgDataConnectionErrorRelUpReg()
 {}

tS32 tcu_usb_mainfi_tclMsgDataConnectionErrorRelUpReg::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_DATACONNECTIONERRORRELUPREG;
}


tcu_usb_mainfi_tclMsgDataConnectionErrorRelUpReg::~tcu_usb_mainfi_tclMsgDataConnectionErrorRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgDataConnectionErrorStatus::tcu_usb_mainfi_tclMsgDataConnectionErrorStatus(const tcu_usb_mainfi_tclMsgDataConnectionErrorStatus& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   DataConnectionError = coRef.DataConnectionError;
   ServiceType = coRef.ServiceType;
}
tcu_usb_mainfi_tclMsgDataConnectionErrorStatus& tcu_usb_mainfi_tclMsgDataConnectionErrorStatus::operator=(const tcu_usb_mainfi_tclMsgDataConnectionErrorStatus& coRef)
{
   if (this == &coRef) return *this;
   DataConnectionError = coRef.DataConnectionError;
   ServiceType = coRef.ServiceType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_mainfi_tclMsgDataConnectionErrorStatus::tcu_usb_mainfi_tclMsgDataConnectionErrorStatus()
:DataConnectionError()
,ServiceType()
 {}

tS32 tcu_usb_mainfi_tclMsgDataConnectionErrorStatus::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_DATACONNECTIONERRORSTATUS;
}


tcu_usb_mainfi_tclMsgDataConnectionErrorStatus::~tcu_usb_mainfi_tclMsgDataConnectionErrorStatus()
{}

tU32 tcu_usb_mainfi_tclMsgDataConnectionErrorStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& tcu_usb_mainfi_tclMsgDataConnectionErrorStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DataConnectionError);
   (tVoid) (oIn >> ServiceType);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgDataConnectionErrorStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DataConnectionError);
   (tVoid) (oOut << ServiceType);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgDataConnectionErrorStatus::operator==(const tcu_usb_mainfi_tclMsgDataConnectionErrorStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DataConnectionError == roRef.DataConnectionError);
   bResult = bResult && (ServiceType == roRef.ServiceType);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgServerListUpReg::tcu_usb_mainfi_tclMsgServerListUpReg()
 {}

tS32 tcu_usb_mainfi_tclMsgServerListUpReg::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_SERVERLISTUPREG;
}


tcu_usb_mainfi_tclMsgServerListUpReg::~tcu_usb_mainfi_tclMsgServerListUpReg()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgServerListRelUpReg::tcu_usb_mainfi_tclMsgServerListRelUpReg()
 {}

tS32 tcu_usb_mainfi_tclMsgServerListRelUpReg::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_SERVERLISTRELUPREG;
}


tcu_usb_mainfi_tclMsgServerListRelUpReg::~tcu_usb_mainfi_tclMsgServerListRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgServerListStatus::tcu_usb_mainfi_tclMsgServerListStatus(const tcu_usb_mainfi_tclMsgServerListStatus& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   ServerInfoList = coRef.ServerInfoList;
   u8ActiveServerId = coRef.u8ActiveServerId;
}
tcu_usb_mainfi_tclMsgServerListStatus& tcu_usb_mainfi_tclMsgServerListStatus::operator=(const tcu_usb_mainfi_tclMsgServerListStatus& coRef)
{
   if (this == &coRef) return *this;
   ServerInfoList = coRef.ServerInfoList;
   u8ActiveServerId = coRef.u8ActiveServerId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_mainfi_tclMsgServerListStatus::vDestroy()
{
   ServerInfoList.vDestroy(); 
}

tcu_usb_mainfi_tclMsgServerListStatus::tcu_usb_mainfi_tclMsgServerListStatus()
:ServerInfoList()
,u8ActiveServerId(0)
 {}

tS32 tcu_usb_mainfi_tclMsgServerListStatus::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_SERVERLISTSTATUS;
}


tcu_usb_mainfi_tclMsgServerListStatus::~tcu_usb_mainfi_tclMsgServerListStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_mainfi_tclMsgServerListStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+ServerInfoList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_mainfi_tclMsgServerListStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ServerInfoList);
   (tVoid) (oIn >> u8ActiveServerId);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgServerListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ServerInfoList);
   (tVoid) (oOut << u8ActiveServerId);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgServerListStatus::operator==(const tcu_usb_mainfi_tclMsgServerListStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ServerInfoList == roRef.ServerInfoList);
   bResult = bResult && (u8ActiveServerId == roRef.u8ActiveServerId);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgTCUDeviceInfoUpReg::tcu_usb_mainfi_tclMsgTCUDeviceInfoUpReg()
 {}

tS32 tcu_usb_mainfi_tclMsgTCUDeviceInfoUpReg::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_TCUDEVICEINFOUPREG;
}


tcu_usb_mainfi_tclMsgTCUDeviceInfoUpReg::~tcu_usb_mainfi_tclMsgTCUDeviceInfoUpReg()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgTCUDeviceInfoRelUpReg::tcu_usb_mainfi_tclMsgTCUDeviceInfoRelUpReg()
 {}

tS32 tcu_usb_mainfi_tclMsgTCUDeviceInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_TCUDEVICEINFORELUPREG;
}


tcu_usb_mainfi_tclMsgTCUDeviceInfoRelUpReg::~tcu_usb_mainfi_tclMsgTCUDeviceInfoRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgTCUDeviceInfoStatus::tcu_usb_mainfi_tclMsgTCUDeviceInfoStatus(const tcu_usb_mainfi_tclMsgTCUDeviceInfoStatus& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   TCUDeviceInfo = coRef.TCUDeviceInfo;
}
tcu_usb_mainfi_tclMsgTCUDeviceInfoStatus& tcu_usb_mainfi_tclMsgTCUDeviceInfoStatus::operator=(const tcu_usb_mainfi_tclMsgTCUDeviceInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   TCUDeviceInfo = coRef.TCUDeviceInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_mainfi_tclMsgTCUDeviceInfoStatus::tcu_usb_mainfi_tclMsgTCUDeviceInfoStatus()
:TCUDeviceInfo()
 {}

tS32 tcu_usb_mainfi_tclMsgTCUDeviceInfoStatus::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_TCUDEVICEINFOSTATUS;
}


tcu_usb_mainfi_tclMsgTCUDeviceInfoStatus::~tcu_usb_mainfi_tclMsgTCUDeviceInfoStatus()
{}

tU32 tcu_usb_mainfi_tclMsgTCUDeviceInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& tcu_usb_mainfi_tclMsgTCUDeviceInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TCUDeviceInfo);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgTCUDeviceInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TCUDeviceInfo);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgTCUDeviceInfoStatus::operator==(const tcu_usb_mainfi_tclMsgTCUDeviceInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TCUDeviceInfo == roRef.TCUDeviceInfo);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalUpReg::tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalUpReg()
 {}

tS32 tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalUpReg::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_NOTIFYAUTODOWNLOADINTERVALUPREG;
}


tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalUpReg::~tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalUpReg()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalRelUpReg::tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalRelUpReg()
 {}

tS32 tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalRelUpReg::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_NOTIFYAUTODOWNLOADINTERVALRELUPREG;
}


tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalRelUpReg::~tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalStatus::tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalStatus(const tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalStatus& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   AutoDownloadInterval = coRef.AutoDownloadInterval;
}
tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalStatus& tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalStatus::operator=(const tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalStatus& coRef)
{
   if (this == &coRef) return *this;
   AutoDownloadInterval = coRef.AutoDownloadInterval;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalStatus::tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalStatus()
:AutoDownloadInterval()
 {}

tS32 tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalStatus::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_NOTIFYAUTODOWNLOADINTERVALSTATUS;
}


tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalStatus::~tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalStatus()
{}

tU32 tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AutoDownloadInterval);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AutoDownloadInterval);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalStatus::operator==(const tcu_usb_mainfi_tclMsgNotifyAutoDownloadIntervalStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AutoDownloadInterval == roRef.AutoDownloadInterval);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgGeneralNotificationMessageUpReg::tcu_usb_mainfi_tclMsgGeneralNotificationMessageUpReg()
 {}

tS32 tcu_usb_mainfi_tclMsgGeneralNotificationMessageUpReg::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_GENERALNOTIFICATIONMESSAGEUPREG;
}


tcu_usb_mainfi_tclMsgGeneralNotificationMessageUpReg::~tcu_usb_mainfi_tclMsgGeneralNotificationMessageUpReg()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgGeneralNotificationMessageRelUpReg::tcu_usb_mainfi_tclMsgGeneralNotificationMessageRelUpReg()
 {}

tS32 tcu_usb_mainfi_tclMsgGeneralNotificationMessageRelUpReg::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_GENERALNOTIFICATIONMESSAGERELUPREG;
}


tcu_usb_mainfi_tclMsgGeneralNotificationMessageRelUpReg::~tcu_usb_mainfi_tclMsgGeneralNotificationMessageRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgGeneralNotificationMessageStatus::tcu_usb_mainfi_tclMsgGeneralNotificationMessageStatus(const tcu_usb_mainfi_tclMsgGeneralNotificationMessageStatus& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   GeneralNotificationResult = coRef.GeneralNotificationResult;
   DisplayMessage = coRef.DisplayMessage;
   TTSTextMessage = coRef.TTSTextMessage;
}
tcu_usb_mainfi_tclMsgGeneralNotificationMessageStatus& tcu_usb_mainfi_tclMsgGeneralNotificationMessageStatus::operator=(const tcu_usb_mainfi_tclMsgGeneralNotificationMessageStatus& coRef)
{
   if (this == &coRef) return *this;
   GeneralNotificationResult = coRef.GeneralNotificationResult;
   DisplayMessage = coRef.DisplayMessage;
   TTSTextMessage = coRef.TTSTextMessage;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_mainfi_tclMsgGeneralNotificationMessageStatus::vDestroy()
{
   DisplayMessage.vDestroy();
   TTSTextMessage.vDestroy();
}

tcu_usb_mainfi_tclMsgGeneralNotificationMessageStatus::tcu_usb_mainfi_tclMsgGeneralNotificationMessageStatus()
:GeneralNotificationResult()
,DisplayMessage()
,TTSTextMessage()
 {}

tS32 tcu_usb_mainfi_tclMsgGeneralNotificationMessageStatus::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_GENERALNOTIFICATIONMESSAGESTATUS;
}


tcu_usb_mainfi_tclMsgGeneralNotificationMessageStatus::~tcu_usb_mainfi_tclMsgGeneralNotificationMessageStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_mainfi_tclMsgGeneralNotificationMessageStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+DisplayMessage.u32GetSize(u16MajorVersion)+TTSTextMessage.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_mainfi_tclMsgGeneralNotificationMessageStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GeneralNotificationResult);
   (tVoid) (oIn >> DisplayMessage);
   (tVoid) (oIn >> TTSTextMessage);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgGeneralNotificationMessageStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GeneralNotificationResult);
   (tVoid) (oOut << DisplayMessage);
   (tVoid) (oOut << TTSTextMessage);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgGeneralNotificationMessageStatus::operator==(const tcu_usb_mainfi_tclMsgGeneralNotificationMessageStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GeneralNotificationResult == roRef.GeneralNotificationResult);
   bResult = bResult && (DisplayMessage == roRef.DisplayMessage);
   bResult = bResult && (TTSTextMessage == roRef.TTSTextMessage);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgAuthenticationResultDataUpReg::tcu_usb_mainfi_tclMsgAuthenticationResultDataUpReg()
 {}

tS32 tcu_usb_mainfi_tclMsgAuthenticationResultDataUpReg::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_AUTHENTICATIONRESULTDATAUPREG;
}


tcu_usb_mainfi_tclMsgAuthenticationResultDataUpReg::~tcu_usb_mainfi_tclMsgAuthenticationResultDataUpReg()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgAuthenticationResultDataRelUpReg::tcu_usb_mainfi_tclMsgAuthenticationResultDataRelUpReg()
 {}

tS32 tcu_usb_mainfi_tclMsgAuthenticationResultDataRelUpReg::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_AUTHENTICATIONRESULTDATARELUPREG;
}


tcu_usb_mainfi_tclMsgAuthenticationResultDataRelUpReg::~tcu_usb_mainfi_tclMsgAuthenticationResultDataRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgAuthenticationResultDataStatus::tcu_usb_mainfi_tclMsgAuthenticationResultDataStatus(const tcu_usb_mainfi_tclMsgAuthenticationResultDataStatus& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   DisplayMessage = coRef.DisplayMessage;
   TTSTextMessage = coRef.TTSTextMessage;
}
tcu_usb_mainfi_tclMsgAuthenticationResultDataStatus& tcu_usb_mainfi_tclMsgAuthenticationResultDataStatus::operator=(const tcu_usb_mainfi_tclMsgAuthenticationResultDataStatus& coRef)
{
   if (this == &coRef) return *this;
   DisplayMessage = coRef.DisplayMessage;
   TTSTextMessage = coRef.TTSTextMessage;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_mainfi_tclMsgAuthenticationResultDataStatus::vDestroy()
{
   DisplayMessage.vDestroy();
   TTSTextMessage.vDestroy();
}

tcu_usb_mainfi_tclMsgAuthenticationResultDataStatus::tcu_usb_mainfi_tclMsgAuthenticationResultDataStatus()
:DisplayMessage()
,TTSTextMessage()
 {}

tS32 tcu_usb_mainfi_tclMsgAuthenticationResultDataStatus::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_AUTHENTICATIONRESULTDATASTATUS;
}


tcu_usb_mainfi_tclMsgAuthenticationResultDataStatus::~tcu_usb_mainfi_tclMsgAuthenticationResultDataStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_mainfi_tclMsgAuthenticationResultDataStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+DisplayMessage.u32GetSize(u16MajorVersion)+TTSTextMessage.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_mainfi_tclMsgAuthenticationResultDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DisplayMessage);
   (tVoid) (oIn >> TTSTextMessage);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgAuthenticationResultDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DisplayMessage);
   (tVoid) (oOut << TTSTextMessage);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgAuthenticationResultDataStatus::operator==(const tcu_usb_mainfi_tclMsgAuthenticationResultDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DisplayMessage == roRef.DisplayMessage);
   bResult = bResult && (TTSTextMessage == roRef.TTSTextMessage);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgVICSTrafficDataUpReg::tcu_usb_mainfi_tclMsgVICSTrafficDataUpReg()
 {}

tS32 tcu_usb_mainfi_tclMsgVICSTrafficDataUpReg::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_VICSTRAFFICDATAUPREG;
}


tcu_usb_mainfi_tclMsgVICSTrafficDataUpReg::~tcu_usb_mainfi_tclMsgVICSTrafficDataUpReg()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgVICSTrafficDataRelUpReg::tcu_usb_mainfi_tclMsgVICSTrafficDataRelUpReg()
 {}

tS32 tcu_usb_mainfi_tclMsgVICSTrafficDataRelUpReg::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_VICSTRAFFICDATARELUPREG;
}


tcu_usb_mainfi_tclMsgVICSTrafficDataRelUpReg::~tcu_usb_mainfi_tclMsgVICSTrafficDataRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgVICSTrafficDataStatus::tcu_usb_mainfi_tclMsgVICSTrafficDataStatus(const tcu_usb_mainfi_tclMsgVICSTrafficDataStatus& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   strFilePathWithFileName = coRef.strFilePathWithFileName;
   VICSResponseData = coRef.VICSResponseData;
}
tcu_usb_mainfi_tclMsgVICSTrafficDataStatus& tcu_usb_mainfi_tclMsgVICSTrafficDataStatus::operator=(const tcu_usb_mainfi_tclMsgVICSTrafficDataStatus& coRef)
{
   if (this == &coRef) return *this;
   strFilePathWithFileName = coRef.strFilePathWithFileName;
   VICSResponseData = coRef.VICSResponseData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_mainfi_tclMsgVICSTrafficDataStatus::vDestroy()
{
   strFilePathWithFileName.vDestroy();
   VICSResponseData.vDestroy(); 
}

tcu_usb_mainfi_tclMsgVICSTrafficDataStatus::tcu_usb_mainfi_tclMsgVICSTrafficDataStatus()
:strFilePathWithFileName()
,VICSResponseData()
 {}

tS32 tcu_usb_mainfi_tclMsgVICSTrafficDataStatus::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_VICSTRAFFICDATASTATUS;
}


tcu_usb_mainfi_tclMsgVICSTrafficDataStatus::~tcu_usb_mainfi_tclMsgVICSTrafficDataStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_mainfi_tclMsgVICSTrafficDataStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+strFilePathWithFileName.u32GetSize(u16MajorVersion)+VICSResponseData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_mainfi_tclMsgVICSTrafficDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strFilePathWithFileName);
   (tVoid) (oIn >> VICSResponseData);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgVICSTrafficDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strFilePathWithFileName);
   (tVoid) (oOut << VICSResponseData);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgVICSTrafficDataStatus::operator==(const tcu_usb_mainfi_tclMsgVICSTrafficDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strFilePathWithFileName == roRef.strFilePathWithFileName);
   bResult = bResult && (VICSResponseData == roRef.VICSResponseData);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgChargingStationsListUpReg::tcu_usb_mainfi_tclMsgChargingStationsListUpReg()
 {}

tS32 tcu_usb_mainfi_tclMsgChargingStationsListUpReg::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_CHARGINGSTATIONSLISTUPREG;
}


tcu_usb_mainfi_tclMsgChargingStationsListUpReg::~tcu_usb_mainfi_tclMsgChargingStationsListUpReg()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgChargingStationsListRelUpReg::tcu_usb_mainfi_tclMsgChargingStationsListRelUpReg()
 {}

tS32 tcu_usb_mainfi_tclMsgChargingStationsListRelUpReg::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_CHARGINGSTATIONSLISTRELUPREG;
}


tcu_usb_mainfi_tclMsgChargingStationsListRelUpReg::~tcu_usb_mainfi_tclMsgChargingStationsListRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgChargingStationsListStatus::tcu_usb_mainfi_tclMsgChargingStationsListStatus(const tcu_usb_mainfi_tclMsgChargingStationsListStatus& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   ChargingStationsList = coRef.ChargingStationsList;
}
tcu_usb_mainfi_tclMsgChargingStationsListStatus& tcu_usb_mainfi_tclMsgChargingStationsListStatus::operator=(const tcu_usb_mainfi_tclMsgChargingStationsListStatus& coRef)
{
   if (this == &coRef) return *this;
   ChargingStationsList = coRef.ChargingStationsList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_mainfi_tclMsgChargingStationsListStatus::vDestroy()
{
   ChargingStationsList.vDestroy(); 
}

tcu_usb_mainfi_tclMsgChargingStationsListStatus::tcu_usb_mainfi_tclMsgChargingStationsListStatus()
:ChargingStationsList()
 {}

tS32 tcu_usb_mainfi_tclMsgChargingStationsListStatus::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_CHARGINGSTATIONSLISTSTATUS;
}


tcu_usb_mainfi_tclMsgChargingStationsListStatus::~tcu_usb_mainfi_tclMsgChargingStationsListStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_mainfi_tclMsgChargingStationsListStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+ChargingStationsList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_mainfi_tclMsgChargingStationsListStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ChargingStationsList);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgChargingStationsListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ChargingStationsList);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgChargingStationsListStatus::operator==(const tcu_usb_mainfi_tclMsgChargingStationsListStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ChargingStationsList == roRef.ChargingStationsList);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgChargingSpotDataUpReg::tcu_usb_mainfi_tclMsgChargingSpotDataUpReg()
 {}

tS32 tcu_usb_mainfi_tclMsgChargingSpotDataUpReg::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_CHARGINGSPOTDATAUPREG;
}


tcu_usb_mainfi_tclMsgChargingSpotDataUpReg::~tcu_usb_mainfi_tclMsgChargingSpotDataUpReg()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgChargingSpotDataRelUpReg::tcu_usb_mainfi_tclMsgChargingSpotDataRelUpReg()
 {}

tS32 tcu_usb_mainfi_tclMsgChargingSpotDataRelUpReg::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_CHARGINGSPOTDATARELUPREG;
}


tcu_usb_mainfi_tclMsgChargingSpotDataRelUpReg::~tcu_usb_mainfi_tclMsgChargingSpotDataRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgChargingSpotDataStatus::tcu_usb_mainfi_tclMsgChargingSpotDataStatus(const tcu_usb_mainfi_tclMsgChargingSpotDataStatus& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   ChargingSpotData = coRef.ChargingSpotData;
}
tcu_usb_mainfi_tclMsgChargingSpotDataStatus& tcu_usb_mainfi_tclMsgChargingSpotDataStatus::operator=(const tcu_usb_mainfi_tclMsgChargingSpotDataStatus& coRef)
{
   if (this == &coRef) return *this;
   ChargingSpotData = coRef.ChargingSpotData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_mainfi_tclMsgChargingSpotDataStatus::vDestroy()
{
   ChargingSpotData.vDestroy(); 
}

tcu_usb_mainfi_tclMsgChargingSpotDataStatus::tcu_usb_mainfi_tclMsgChargingSpotDataStatus()
:ChargingSpotData()
 {}

tS32 tcu_usb_mainfi_tclMsgChargingSpotDataStatus::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_CHARGINGSPOTDATASTATUS;
}


tcu_usb_mainfi_tclMsgChargingSpotDataStatus::~tcu_usb_mainfi_tclMsgChargingSpotDataStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_mainfi_tclMsgChargingSpotDataStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+ChargingSpotData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_mainfi_tclMsgChargingSpotDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ChargingSpotData);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgChargingSpotDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ChargingSpotData);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgChargingSpotDataStatus::operator==(const tcu_usb_mainfi_tclMsgChargingSpotDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ChargingSpotData == roRef.ChargingSpotData);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgVacancyStationsListUpReg::tcu_usb_mainfi_tclMsgVacancyStationsListUpReg()
 {}

tS32 tcu_usb_mainfi_tclMsgVacancyStationsListUpReg::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_VACANCYSTATIONSLISTUPREG;
}


tcu_usb_mainfi_tclMsgVacancyStationsListUpReg::~tcu_usb_mainfi_tclMsgVacancyStationsListUpReg()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgVacancyStationsListRelUpReg::tcu_usb_mainfi_tclMsgVacancyStationsListRelUpReg()
 {}

tS32 tcu_usb_mainfi_tclMsgVacancyStationsListRelUpReg::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_VACANCYSTATIONSLISTRELUPREG;
}


tcu_usb_mainfi_tclMsgVacancyStationsListRelUpReg::~tcu_usb_mainfi_tclMsgVacancyStationsListRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgVacancyStationsListStatus::tcu_usb_mainfi_tclMsgVacancyStationsListStatus(const tcu_usb_mainfi_tclMsgVacancyStationsListStatus& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   VacancyStationsList = coRef.VacancyStationsList;
}
tcu_usb_mainfi_tclMsgVacancyStationsListStatus& tcu_usb_mainfi_tclMsgVacancyStationsListStatus::operator=(const tcu_usb_mainfi_tclMsgVacancyStationsListStatus& coRef)
{
   if (this == &coRef) return *this;
   VacancyStationsList = coRef.VacancyStationsList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_mainfi_tclMsgVacancyStationsListStatus::vDestroy()
{
   VacancyStationsList.vDestroy(); 
}

tcu_usb_mainfi_tclMsgVacancyStationsListStatus::tcu_usb_mainfi_tclMsgVacancyStationsListStatus()
:VacancyStationsList()
 {}

tS32 tcu_usb_mainfi_tclMsgVacancyStationsListStatus::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_VACANCYSTATIONSLISTSTATUS;
}


tcu_usb_mainfi_tclMsgVacancyStationsListStatus::~tcu_usb_mainfi_tclMsgVacancyStationsListStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_mainfi_tclMsgVacancyStationsListStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+VacancyStationsList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_mainfi_tclMsgVacancyStationsListStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VacancyStationsList);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgVacancyStationsListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VacancyStationsList);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgVacancyStationsListStatus::operator==(const tcu_usb_mainfi_tclMsgVacancyStationsListStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VacancyStationsList == roRef.VacancyStationsList);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgVacancySpotDataUpReg::tcu_usb_mainfi_tclMsgVacancySpotDataUpReg()
 {}

tS32 tcu_usb_mainfi_tclMsgVacancySpotDataUpReg::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_VACANCYSPOTDATAUPREG;
}


tcu_usb_mainfi_tclMsgVacancySpotDataUpReg::~tcu_usb_mainfi_tclMsgVacancySpotDataUpReg()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgVacancySpotDataRelUpReg::tcu_usb_mainfi_tclMsgVacancySpotDataRelUpReg()
 {}

tS32 tcu_usb_mainfi_tclMsgVacancySpotDataRelUpReg::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_VACANCYSPOTDATARELUPREG;
}


tcu_usb_mainfi_tclMsgVacancySpotDataRelUpReg::~tcu_usb_mainfi_tclMsgVacancySpotDataRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgVacancySpotDataStatus::tcu_usb_mainfi_tclMsgVacancySpotDataStatus(const tcu_usb_mainfi_tclMsgVacancySpotDataStatus& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   VacancySpotData = coRef.VacancySpotData;
}
tcu_usb_mainfi_tclMsgVacancySpotDataStatus& tcu_usb_mainfi_tclMsgVacancySpotDataStatus::operator=(const tcu_usb_mainfi_tclMsgVacancySpotDataStatus& coRef)
{
   if (this == &coRef) return *this;
   VacancySpotData = coRef.VacancySpotData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid tcu_usb_mainfi_tclMsgVacancySpotDataStatus::vDestroy()
{
   VacancySpotData.vDestroy(); 
}

tcu_usb_mainfi_tclMsgVacancySpotDataStatus::tcu_usb_mainfi_tclMsgVacancySpotDataStatus()
:VacancySpotData()
 {}

tS32 tcu_usb_mainfi_tclMsgVacancySpotDataStatus::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_VACANCYSPOTDATASTATUS;
}


tcu_usb_mainfi_tclMsgVacancySpotDataStatus::~tcu_usb_mainfi_tclMsgVacancySpotDataStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 tcu_usb_mainfi_tclMsgVacancySpotDataStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+VacancySpotData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& tcu_usb_mainfi_tclMsgVacancySpotDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VacancySpotData);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgVacancySpotDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VacancySpotData);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgVacancySpotDataStatus::operator==(const tcu_usb_mainfi_tclMsgVacancySpotDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VacancySpotData == roRef.VacancySpotData);
   return bResult;
}

//=============================================================================

tcu_usb_mainfi_tclMsgGeneralResponseErrorUpReg::tcu_usb_mainfi_tclMsgGeneralResponseErrorUpReg()
 {}

tS32 tcu_usb_mainfi_tclMsgGeneralResponseErrorUpReg::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_GENERALRESPONSEERRORUPREG;
}


tcu_usb_mainfi_tclMsgGeneralResponseErrorUpReg::~tcu_usb_mainfi_tclMsgGeneralResponseErrorUpReg()
{}

//=============================================================================

tcu_usb_mainfi_tclMsgGeneralResponseErrorRelUpReg::tcu_usb_mainfi_tclMsgGeneralResponseErrorRelUpReg()
 {}

tS32 tcu_usb_mainfi_tclMsgGeneralResponseErrorRelUpReg::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_GENERALRESPONSEERRORRELUPREG;
}


tcu_usb_mainfi_tclMsgGeneralResponseErrorRelUpReg::~tcu_usb_mainfi_tclMsgGeneralResponseErrorRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
tcu_usb_mainfi_tclMsgGeneralResponseErrorStatus::tcu_usb_mainfi_tclMsgGeneralResponseErrorStatus(const tcu_usb_mainfi_tclMsgGeneralResponseErrorStatus& coRef)
   : tcu_usb_mainfi_tclMsgBaseMessage(coRef)
{
   GeneralResponseDataError = coRef.GeneralResponseDataError;
}
tcu_usb_mainfi_tclMsgGeneralResponseErrorStatus& tcu_usb_mainfi_tclMsgGeneralResponseErrorStatus::operator=(const tcu_usb_mainfi_tclMsgGeneralResponseErrorStatus& coRef)
{
   if (this == &coRef) return *this;
   GeneralResponseDataError = coRef.GeneralResponseDataError;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tcu_usb_mainfi_tclMsgGeneralResponseErrorStatus::tcu_usb_mainfi_tclMsgGeneralResponseErrorStatus()
:GeneralResponseDataError(0)
 {}

tS32 tcu_usb_mainfi_tclMsgGeneralResponseErrorStatus::s32GetTypeId() const
{
   return (tS32) tcu_usb_mainfi_tclToken::EN_MSG_GENERALRESPONSEERRORSTATUS;
}


tcu_usb_mainfi_tclMsgGeneralResponseErrorStatus::~tcu_usb_mainfi_tclMsgGeneralResponseErrorStatus()
{}

tU32 tcu_usb_mainfi_tclMsgGeneralResponseErrorStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& tcu_usb_mainfi_tclMsgGeneralResponseErrorStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GeneralResponseDataError);
   return oIn;
}

fi_tclOutContext& tcu_usb_mainfi_tclMsgGeneralResponseErrorStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GeneralResponseDataError);
   return oOut;
}

tBool tcu_usb_mainfi_tclMsgGeneralResponseErrorStatus::operator==(const tcu_usb_mainfi_tclMsgGeneralResponseErrorStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GeneralResponseDataError == roRef.GeneralResponseDataError);
   return bResult;
}

