#ifndef TCU_USB_MAINFILANGUAGE_HEADER
#define TCU_USB_MAINFILANGUAGE_HEADER

class tcu_usb_mainfi_tclInContext;
class tcu_usb_mainfi_tclOutContext;
class tcu_usb_mainfi_tclVisitorBase;

class MY_DECL tcu_usb_mainfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  tcu_usb_mainfi_tclDescription(fi_tclInContext* poIn, tcu_usb_mainfi_tclVisitorBase* poVisit);
  tcu_usb_mainfi_tclDescription(fi_tclOutContext* poOut, tcu_usb_mainfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(tcu_usb_mainfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(tcu_usb_fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ tcu_usb_mainfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  tcu_usb_mainfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<tcu_usb_mainfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<tcu_usb_mainfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline tcu_usb_mainfi_tclDescription::tcu_usb_mainfi_tclDescription(fi_tclInContext* poIn, tcu_usb_mainfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline tcu_usb_mainfi_tclDescription::tcu_usb_mainfi_tclDescription(fi_tclOutContext* poOut, tcu_usb_mainfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

