#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define TCU_USB_FI_S_IMPORT_INTERFACE_TCU_USB_MAINFI_STDVISITORS
#include "tcu_usb_fi_if.h"

tBool tcu_usb_mainfi_tclDescription::bInitMessage(tcu_usb_mainfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case tcu_usb_mainfi_tclToken::EN_LAST_TOKEN:
   case tcu_usb_mainfi_tclToken::EN_LIST:
   case tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT:
   case tcu_usb_mainfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;

   // include the expansions for the messages
   case tcu_usb_mainfi_tclToken::EN_MSG_GETCHANNELDATAMETHODSTART:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_BOOL,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_BBACKGROUNDDOWNLOADTYPE)) && bResult;
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_USB_TCU_CHANNEL_INFO_LIST,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_CHANNEL_INFO_LIST)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_GETCONNECTEDSEARCHRESULTMETHODSTART:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_STRKEYWORD)) && bResult;
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_U8SIZEOFKEYWORD)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_GETCHANNELMASTERDATAMETHODSTART:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_BOOL,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_BBACKGROUNDDOWNLOADTYPE)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_SYNTHESIZESPEAKMETHODSTART:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_BOOL,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_BHOLDAUDIOCHANNEL)) && bResult;
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_U8CHANNELCONTENTSID)) && bResult;
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_U16CHANNELID)) && bResult;
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_TEXTANDTAGS)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_ABORTPROMPTMETHODSTART:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_BOOL,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_BHOLDAUDIOCHANNEL)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_CANCELREQUESTMETHODSTART:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_E8_CANCELREQUESTTYPE,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_ECANCELREQUESTTYPE)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_SENDGROUPADATAMETHODSTART:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_USB_TCU_GROUPA_INFO,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_GROUPA_INFO)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_DELETEINVEHICLEMESSAGEMETHODSTART:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_U8CHANNELCONTENTSID)) && bResult;
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_S64,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_S64INDEXINTERNAL)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_SELECTSERVERMETHODSTART:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_U8SERVERID)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_RETRYGETCHANNELDATAMETHODSTART:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_U16CHANNELID)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_OVERWRITEIVMTOTALCONTENTSMETHODSTART:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_S64,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_S64INDEXINTERNAL)) && bResult;
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_U16CHANNELID)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_STORECSHISTORYMETHODSTART:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_STRKEYWORD)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_SETLOGLEVELMETHODSTART:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_E8_TCU_LOGLEVEL,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_U8LOGLEVEL)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_SETAUTODOWNLOADINTERVALMETHODSTART:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_E8_AUTODOWNLOADINTERVAL,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_AUTODOWNLOADINTERVAL)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_SETAUTODOWNLOADCHANNELMETHODSTART:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_USB_TCU_CHANNEL_INFO_LIST,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_CHANNEL_INFO_LIST)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_SETFAVORITECHANNELMETHODSTART:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_USB_TCU_CHANNEL_INFO_LIST,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_CHANNEL_INFO_LIST)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_READFAVORITEFEEDSMETHODRESULT:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_USB_TCU_FAVORITE_FEED_LIST,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_FAVORITE_FEED_LIST)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_SELECTFAVORITEFEEDSMETHODSTART:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_U16CHANNELID)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_GETVICSTRAFFICDATAMETHODSTART:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_TCU_VICS_REQUEST_DATA,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_VICSREQUESTDATA)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_GETCHARGINGSTATIONSLISTMETHODSTART:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_USB_TCU_CHARGING_STATIONS_REQUEST_INFO,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_CHARGINGSTATIONSREQUESTINFO)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_GETCHARGINGSPOTDATAMETHODSTART:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_USB_TCU_POIID_LIST,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_POIIDLIST)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_GETVACANCYSPOTDATAMETHODSTART:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_USB_TCU_POIID_LIST,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_POIIDLIST)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_GETVACANCYSTATIONSLISTMETHODSTART:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_USB_TCU_VACANCY_STATIONS_REQUEST_INFO,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_VACANCYSTATIONSREQUESTINFO)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_SENDUSERCREDENTIALSMETHODSTART:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_BOOL,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_BCLEARDATA)) && bResult;
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_SPASSWORD)) && bResult;
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_SUSERID)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_DELETECHANNELINFORMATIONMETHODSTART:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_U16CHANNELID)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_VALIDATEUSERCREDENTIALSMETHODSTART:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_SPASSWORD)) && bResult;
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_SUSERID)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_VALIDATEUSERCREDENTIALSMETHODRESULT:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_TOKEN)) && bResult;
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_E8_USERAUTHENTICATIONRESULTTYPE,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_RENEWACCESSTOKENMETHODRESULT:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_TOKEN)) && bResult;
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_E8_USERAUTHENTICATIONRESULTTYPE,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_GETACCESSTOKENMETHODRESULT:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_TOKEN)) && bResult;
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_E8_USERAUTHENTICATIONRESULTTYPE,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_VALIDATEUSERCREDENTIALSONTOKENRENEWALERRORMETHODSTART:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_SPASSWORD)) && bResult;
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_SUSERID)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_VALIDATEUSERCREDENTIALSONTOKENRENEWALERRORMETHODRESULT:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_E8_USERAUTHENTICATIONRESULTTYPE,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_CANCELUSERVALIDATIONRENEWTOKENMETHODRESULT:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_E8_USERAUTHENTICATIONRESULTTYPE,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_DECODEIDTOKENMETHODSTART:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_TOKEN)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_DECODEIDTOKENMETHODRESULT:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_USB_TCU_USERAUTHENTICATION_DECODEDTOKEN_INFO,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_GETPROBEUPLOADPERMITMETHODRESULT:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_E8_TCU_PROBEPERMITSETTING,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_E8PROBEPERMITSETTING)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_SETPROBEUPLOADPERMITMETHODSTART:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_E8_TCU_PROBEPERMITSETTING,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_E8PROBEPERMITSETTING)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_SETPROBEUPLOADPERMITMETHODRESULT:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_E8_TCU_PROBEPERMITSETTING,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_E8PROBEPERMITSETTING)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_SETPROBEINFODELETEMETHODRESULT:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_BOOL,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_BSTATUSFROMTCU)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_USERCREDENTIALSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_E8_TCU_AUTHENTICATION_RESULT,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_E8AUTHENTICATIONRESULT)) && bResult;
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_STTSTEXTMESSAGE)) && bResult;
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_SDISPLAYMESSAGE)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_NOTIFYTOKENRENEWALERRORSTATUS:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_BOOL,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_SHOWCREDENTIALSSCREEN)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_CONNECTEDSEARCHRESULTSTATUS:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_E8_TCU_EXECTYPE,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_U8EXECTYPE)) && bResult;
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_E8_CONNECTEDSEARCHSERVICETYPE,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_SERVICETYPE)) && bResult;
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_USB_TCU_CONNECTED_SEARCH_RESULT,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_CONNECTEDSEARCH)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_CHANNELMASTERDATASTATUS:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_USB_TCU_CHANNEL_MASTER_DATA,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_CHANNELMASTERDATA)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_TTSAUDIOSTATEREQUESTSTATUS:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_E8_TCU_AUDIOACTIVITY,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_AUDIOACTIVITY)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_DATABASESTATUSSTATUS:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_BOOL,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_POPUPENABLED)) && bResult;
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_E8_DATABASESERVICETYPE,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_DATABASESERVICETYPE)) && bResult;
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_DATABASEPATH)) && bResult;
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_E8_DATABASESTATUS,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_DATABASESTATUS)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_DATACONNECTIONSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_E8_DATACONNECTIONSTATUS,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_DATACONNECTIONSTATUS)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_DATACONNECTIONERRORSTATUS:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_E8_SERVICETYPE,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_SERVICETYPE)) && bResult;
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_E16_DATACONNECTIONERROR,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_DATACONNECTIONERROR)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_SERVERLISTSTATUS:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_U8ACTIVESERVERID)) && bResult;
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_USB_TCU_SERVER_INFO_LIST,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_SERVERINFOLIST)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_TCUDEVICEINFOSTATUS:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_USB_TCU_TCUDEVICE_INFO,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_TCUDEVICEINFO)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_NOTIFYAUTODOWNLOADINTERVALSTATUS:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_E8_AUTODOWNLOADINTERVAL,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_AUTODOWNLOADINTERVAL)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_GENERALNOTIFICATIONMESSAGESTATUS:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_TTSTEXTMESSAGE)) && bResult;
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_DISPLAYMESSAGE)) && bResult;
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_E8_TCU_NOTIRESULT,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_GENERALNOTIFICATIONRESULT)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_AUTHENTICATIONRESULTDATASTATUS:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_TTSTEXTMESSAGE)) && bResult;
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_DISPLAYMESSAGE)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_VICSTRAFFICDATASTATUS:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_E8_TCU_VICS_RESPONSE_DATA,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_VICSRESPONSEDATA)) && bResult;
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_STRFILEPATHWITHFILENAME)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_CHARGINGSTATIONSLISTSTATUS:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_TCU_RESPONSE_CHARGING_STATIONS_LIST_RESULT,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_CHARGINGSTATIONSLIST)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_CHARGINGSPOTDATASTATUS:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_TCU_RESPONSE_CHARGING_SPOT_DATA_RESULT,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_CHARGINGSPOTDATA)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_VACANCYSTATIONSLISTSTATUS:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_TCU_RESPONSE_VACANCY_STATIONS_LIST_RESULT,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_VACANCYSTATIONSLIST)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_VACANCYSPOTDATASTATUS:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_TCU_RESPONSE_VACANCY_SPOT_DATA_RESULT,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_VACANCYSPOTDATA)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_GENERALRESPONSEERRORSTATUS:
   {
      bResult = oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_BOOL,tcu_usb_mainfi_tclSemanticDomain::EN_MSG_GENERALRESPONSEDATAERROR)) && bResult;
   } break;
   case tcu_usb_mainfi_tclToken::EN_MSG_GETCHANNELDATAMETHODRESULT:
   case tcu_usb_mainfi_tclToken::EN_MSG_GETCONNECTEDSEARCHRESULTMETHODRESULT:
   case tcu_usb_mainfi_tclToken::EN_MSG_GETCHANNELMASTERDATAMETHODRESULT:
   case tcu_usb_mainfi_tclToken::EN_MSG_SYNTHESIZESPEAKMETHODRESULTFIRST:
   case tcu_usb_mainfi_tclToken::EN_MSG_SYNTHESIZESPEAKMETHODRESULTMIDDLE:
   case tcu_usb_mainfi_tclToken::EN_MSG_SYNTHESIZESPEAKMETHODRESULTLAST:
   case tcu_usb_mainfi_tclToken::EN_MSG_ABORTPROMPTMETHODRESULT:
   case tcu_usb_mainfi_tclToken::EN_MSG_PAUSEPROMPTMETHODSTART:
   case tcu_usb_mainfi_tclToken::EN_MSG_PAUSEPROMPTMETHODRESULT:
   case tcu_usb_mainfi_tclToken::EN_MSG_CONTINUEPROMPTMETHODSTART:
   case tcu_usb_mainfi_tclToken::EN_MSG_CONTINUEPROMPTMETHODRESULT:
   case tcu_usb_mainfi_tclToken::EN_MSG_CANCELREQUESTMETHODRESULT:
   case tcu_usb_mainfi_tclToken::EN_MSG_SENDGROUPADATAMETHODRESULT:
   case tcu_usb_mainfi_tclToken::EN_MSG_DELETEINVEHICLEMESSAGEMETHODRESULT:
   case tcu_usb_mainfi_tclToken::EN_MSG_RESETDATABASEMETHODSTART:
   case tcu_usb_mainfi_tclToken::EN_MSG_RESETDATABASEMETHODRESULT:
   case tcu_usb_mainfi_tclToken::EN_MSG_GETSERVERLISTMETHODSTART:
   case tcu_usb_mainfi_tclToken::EN_MSG_GETSERVERLISTMETHODRESULT:
   case tcu_usb_mainfi_tclToken::EN_MSG_SELECTSERVERMETHODRESULT:
   case tcu_usb_mainfi_tclToken::EN_MSG_RETRYGETCHANNELDATAMETHODRESULT:
   case tcu_usb_mainfi_tclToken::EN_MSG_OVERWRITEIVMTOTALCONTENTSMETHODRESULT:
   case tcu_usb_mainfi_tclToken::EN_MSG_STORECSHISTORYMETHODRESULT:
   case tcu_usb_mainfi_tclToken::EN_MSG_GETTCUDEVICEINFOMETHODSTART:
   case tcu_usb_mainfi_tclToken::EN_MSG_GETTCUDEVICEINFOMETHODRESULT:
   case tcu_usb_mainfi_tclToken::EN_MSG_SETLOGLEVELMETHODRESULT:
   case tcu_usb_mainfi_tclToken::EN_MSG_RESTOREFACTORYSETTINGSMETHODSTART:
   case tcu_usb_mainfi_tclToken::EN_MSG_RESTOREFACTORYSETTINGSMETHODRESULT:
   case tcu_usb_mainfi_tclToken::EN_MSG_DELETEMESSAGEBOXMETHODSTART:
   case tcu_usb_mainfi_tclToken::EN_MSG_DELETEMESSAGEBOXMETHODRESULT:
   case tcu_usb_mainfi_tclToken::EN_MSG_INITIALIZEFEEDLISTMETHODSTART:
   case tcu_usb_mainfi_tclToken::EN_MSG_INITIALIZEFEEDLISTMETHODRESULT:
   case tcu_usb_mainfi_tclToken::EN_MSG_SETAUTODOWNLOADINTERVALMETHODRESULT:
   case tcu_usb_mainfi_tclToken::EN_MSG_GETAUTODOWNLOADINTERVALMETHODSTART:
   case tcu_usb_mainfi_tclToken::EN_MSG_GETAUTODOWNLOADINTERVALMETHODRESULT:
   case tcu_usb_mainfi_tclToken::EN_MSG_SETAUTODOWNLOADCHANNELMETHODRESULT:
   case tcu_usb_mainfi_tclToken::EN_MSG_GETFAVORITECHANNELLISTMETHODSTART:
   case tcu_usb_mainfi_tclToken::EN_MSG_GETFAVORITECHANNELLISTMETHODRESULT:
   case tcu_usb_mainfi_tclToken::EN_MSG_SETFAVORITECHANNELMETHODRESULT:
   case tcu_usb_mainfi_tclToken::EN_MSG_READFAVORITEFEEDSMETHODSTART:
   case tcu_usb_mainfi_tclToken::EN_MSG_SELECTFAVORITEFEEDSMETHODRESULT:
   case tcu_usb_mainfi_tclToken::EN_MSG_DELETEINFOHISTORYMETHODSTART:
   case tcu_usb_mainfi_tclToken::EN_MSG_DELETEINFOHISTORYMETHODRESULT:
   case tcu_usb_mainfi_tclToken::EN_MSG_GETVICSTRAFFICDATAMETHODRESULT:
   case tcu_usb_mainfi_tclToken::EN_MSG_GETCHARGINGSTATIONSLISTMETHODRESULT:
   case tcu_usb_mainfi_tclToken::EN_MSG_GETCHARGINGSPOTDATAMETHODRESULT:
   case tcu_usb_mainfi_tclToken::EN_MSG_GETVACANCYSPOTDATAMETHODRESULT:
   case tcu_usb_mainfi_tclToken::EN_MSG_GETVACANCYSTATIONSLISTMETHODRESULT:
   case tcu_usb_mainfi_tclToken::EN_MSG_SENDUSERCREDENTIALSMETHODRESULT:
   case tcu_usb_mainfi_tclToken::EN_MSG_DELETECHANNELINFORMATIONMETHODRESULT:
   case tcu_usb_mainfi_tclToken::EN_MSG_DOWNLOADPARTAUTHDATAMETHODSTART:
   case tcu_usb_mainfi_tclToken::EN_MSG_DOWNLOADPARTAUTHDATAMETHODRESULT:
   case tcu_usb_mainfi_tclToken::EN_MSG_RENEWACCESSTOKENMETHODSTART:
   case tcu_usb_mainfi_tclToken::EN_MSG_GETACCESSTOKENMETHODSTART:
   case tcu_usb_mainfi_tclToken::EN_MSG_CANCELUSERVALIDATIONRENEWTOKENMETHODSTART:
   case tcu_usb_mainfi_tclToken::EN_MSG_RESETNCSSETTINGSMETHODSTART:
   case tcu_usb_mainfi_tclToken::EN_MSG_RESETNCSSETTINGSMETHODRESULT:
   case tcu_usb_mainfi_tclToken::EN_MSG_GETPROBEUPLOADPERMITMETHODSTART:
   case tcu_usb_mainfi_tclToken::EN_MSG_SETPROBEINFODELETEMETHODSTART:
   case tcu_usb_mainfi_tclToken::EN_MSG_USERCREDENTIALSTATUSUPREG:
   case tcu_usb_mainfi_tclToken::EN_MSG_USERCREDENTIALSTATUSRELUPREG:
   case tcu_usb_mainfi_tclToken::EN_MSG_CONNECTEDSEARCHRESULTUPREG:
   case tcu_usb_mainfi_tclToken::EN_MSG_CONNECTEDSEARCHRESULTRELUPREG:
   case tcu_usb_mainfi_tclToken::EN_MSG_CHANNELMASTERDATAUPREG:
   case tcu_usb_mainfi_tclToken::EN_MSG_CHANNELMASTERDATARELUPREG:
   case tcu_usb_mainfi_tclToken::EN_MSG_TTSAUDIOSTATEREQUESTUPREG:
   case tcu_usb_mainfi_tclToken::EN_MSG_TTSAUDIOSTATEREQUESTRELUPREG:
   case tcu_usb_mainfi_tclToken::EN_MSG_DATABASESTATUSUPREG:
   case tcu_usb_mainfi_tclToken::EN_MSG_DATABASESTATUSRELUPREG:
   case tcu_usb_mainfi_tclToken::EN_MSG_DATABASESTATUSSET:
   case tcu_usb_mainfi_tclToken::EN_MSG_DATACONNECTIONSTATUSUPREG:
   case tcu_usb_mainfi_tclToken::EN_MSG_DATACONNECTIONSTATUSRELUPREG:
   case tcu_usb_mainfi_tclToken::EN_MSG_DATACONNECTIONERRORUPREG:
   case tcu_usb_mainfi_tclToken::EN_MSG_DATACONNECTIONERRORRELUPREG:
   case tcu_usb_mainfi_tclToken::EN_MSG_SERVERLISTUPREG:
   case tcu_usb_mainfi_tclToken::EN_MSG_SERVERLISTRELUPREG:
   case tcu_usb_mainfi_tclToken::EN_MSG_TCUDEVICEINFOUPREG:
   case tcu_usb_mainfi_tclToken::EN_MSG_TCUDEVICEINFORELUPREG:
   case tcu_usb_mainfi_tclToken::EN_MSG_NOTIFYAUTODOWNLOADINTERVALUPREG:
   case tcu_usb_mainfi_tclToken::EN_MSG_NOTIFYAUTODOWNLOADINTERVALRELUPREG:
   case tcu_usb_mainfi_tclToken::EN_MSG_GENERALNOTIFICATIONMESSAGEUPREG:
   case tcu_usb_mainfi_tclToken::EN_MSG_GENERALNOTIFICATIONMESSAGERELUPREG:
   case tcu_usb_mainfi_tclToken::EN_MSG_AUTHENTICATIONRESULTDATAUPREG:
   case tcu_usb_mainfi_tclToken::EN_MSG_AUTHENTICATIONRESULTDATARELUPREG:
   case tcu_usb_mainfi_tclToken::EN_MSG_VICSTRAFFICDATAUPREG:
   case tcu_usb_mainfi_tclToken::EN_MSG_VICSTRAFFICDATARELUPREG:
   case tcu_usb_mainfi_tclToken::EN_MSG_CHARGINGSTATIONSLISTUPREG:
   case tcu_usb_mainfi_tclToken::EN_MSG_CHARGINGSTATIONSLISTRELUPREG:
   case tcu_usb_mainfi_tclToken::EN_MSG_CHARGINGSPOTDATAUPREG:
   case tcu_usb_mainfi_tclToken::EN_MSG_CHARGINGSPOTDATARELUPREG:
   case tcu_usb_mainfi_tclToken::EN_MSG_VACANCYSTATIONSLISTUPREG:
   case tcu_usb_mainfi_tclToken::EN_MSG_VACANCYSTATIONSLISTRELUPREG:
   case tcu_usb_mainfi_tclToken::EN_MSG_VACANCYSPOTDATAUPREG:
   case tcu_usb_mainfi_tclToken::EN_MSG_VACANCYSPOTDATARELUPREG:
   case tcu_usb_mainfi_tclToken::EN_MSG_GENERALRESPONSEERRORUPREG:
   case tcu_usb_mainfi_tclToken::EN_MSG_GENERALRESPONSEERRORRELUPREG:
   case tcu_usb_mainfi_tclToken::EN_BINCONTAINER:
   case tcu_usb_mainfi_tclToken::EN_E16_DATACONNECTIONERROR:
   case tcu_usb_mainfi_tclToken::EN_E8_DATACONNECTIONSTATUS:
   case tcu_usb_mainfi_tclToken::EN_E8_SERVICETYPE:
   case tcu_usb_mainfi_tclToken::EN_USB_TCU_CHARGING_STATIONS_REQUEST_INFO:
   case tcu_usb_mainfi_tclToken::EN_USB_TCU_POIID_LIST:
   case tcu_usb_mainfi_tclToken::EN_USB_TCU_VACANCY_STATIONS_REQUEST_INFO:
   case tcu_usb_mainfi_tclToken::EN_USB_TCU_FAVORITE_CHANNEL_INFO:
   case tcu_usb_mainfi_tclToken::EN_USB_TCU_FAVORITE_FEED_LIST:
   case tcu_usb_mainfi_tclToken::EN_E8_TCU_PROBEPERMITSETTING:
   case tcu_usb_mainfi_tclToken::EN_E8_TCU_NOTIRESULT:
   case tcu_usb_mainfi_tclToken::EN_E8_TCU_AUTHENTICATION_RESULT:
   case tcu_usb_mainfi_tclToken::EN_E8_TCU_VICS_RESPONSE_DATA:
   case tcu_usb_mainfi_tclToken::EN_TCU_BLOCK_DATA_LIST:
   case tcu_usb_mainfi_tclToken::EN_TCU_JAPAN_LOCATION:
   case tcu_usb_mainfi_tclToken::EN_TCU_NAVIGATION_SETTING_INFORMATION:
   case tcu_usb_mainfi_tclToken::EN_E8_TCU_LOGLEVEL:
   case tcu_usb_mainfi_tclToken::EN_E8_AUTODOWNLOADINTERVAL:
   case tcu_usb_mainfi_tclToken::EN_E8_CONNECTEDSEARCHSERVICETYPE:
   case tcu_usb_mainfi_tclToken::EN_E8_TCU_AUDIOACTIVITY:
   case tcu_usb_mainfi_tclToken::EN_E8_TCU_EXECTYPE:
   case tcu_usb_mainfi_tclToken::EN_TCU_VICS_REQUEST_DATA:
   case tcu_usb_mainfi_tclToken::EN_USB_TCU_CHANNEL_DEFINITION_INFORMATION:
   case tcu_usb_mainfi_tclToken::EN_USB_TCU_CHANNEL_INFO:
   case tcu_usb_mainfi_tclToken::EN_USB_TCU_CHANNEL_INFO_LIST:
   case tcu_usb_mainfi_tclToken::EN_USB_TCU_CHANNEL_MASTER_DATA_HEADER:
   case tcu_usb_mainfi_tclToken::EN_USB_TCU_FOLDER_DEFINITION_INFORMATION:
   case tcu_usb_mainfi_tclToken::EN_USB_TCU_LOCATION:
   case tcu_usb_mainfi_tclToken::EN_USB_TCU_DATA_RECORD:
   case tcu_usb_mainfi_tclToken::EN_USB_TCU_CHANNEL_MASTER_DATA:
   case tcu_usb_mainfi_tclToken::EN_USB_TCU_GROUPA_AUTHORIZATION_INFO:
   case tcu_usb_mainfi_tclToken::EN_USB_TCU_GROUPA_BASICSERVICES_INFO:
   case tcu_usb_mainfi_tclToken::EN_USB_TCU_GROUPA_INFO:
   case tcu_usb_mainfi_tclToken::EN_USB_TCU_CONNECTED_SEARCH_RESULT:
   case tcu_usb_mainfi_tclToken::EN_TCU_CHARGING_SPOT_DATA:
   case tcu_usb_mainfi_tclToken::EN_TCU_RESPONSE_CHARGING_SPOT_DATA_RESULT:
   case tcu_usb_mainfi_tclToken::EN_TCU_CHARGING_STATIONS_INFO:
   case tcu_usb_mainfi_tclToken::EN_TCU_CHARGING_STATIONS_DATA:
   case tcu_usb_mainfi_tclToken::EN_TCU_RESPONSE_CHARGING_STATIONS_LIST_RESULT:
   case tcu_usb_mainfi_tclToken::EN_TCU_VACANCY_STATIONS_INFO:
   case tcu_usb_mainfi_tclToken::EN_TCU_VACANCY_STATIONS_DATA:
   case tcu_usb_mainfi_tclToken::EN_TCU_RESPONSE_VACANCY_STATIONS_LIST_RESULT:
   case tcu_usb_mainfi_tclToken::EN_TCU_VACANCY_SPOT_DATA:
   case tcu_usb_mainfi_tclToken::EN_TCU_RESPONSE_VACANCY_SPOT_DATA_RESULT:
   case tcu_usb_mainfi_tclToken::EN_USB_TCU_SERVER_INFO:
   case tcu_usb_mainfi_tclToken::EN_USB_TCU_SERVER_INFO_LIST:
   case tcu_usb_mainfi_tclToken::EN_E8_MODEMTYPE:
   case tcu_usb_mainfi_tclToken::EN_USB_TCU_TCUDEVICE_INFO:
   case tcu_usb_mainfi_tclToken::EN_E8_DATABASESERVICETYPE:
   case tcu_usb_mainfi_tclToken::EN_E8_DATABASESTATUS:
   case tcu_usb_mainfi_tclToken::EN_E8_CANCELREQUESTTYPE:
   case tcu_usb_mainfi_tclToken::EN_E8_USERAUTHENTICATIONRESULTTYPE:
   case tcu_usb_mainfi_tclToken::EN_USB_TCU_USERAUTHENTICATION_DECODEDTOKEN_INFO:
   case tcu_usb_mainfi_tclToken::EN_U8:   
   case tcu_usb_mainfi_tclToken::EN_S8:   
   case tcu_usb_mainfi_tclToken::EN_U16:   
   case tcu_usb_mainfi_tclToken::EN_S16:   
   case tcu_usb_mainfi_tclToken::EN_U24:   
   case tcu_usb_mainfi_tclToken::EN_S24:   
   case tcu_usb_mainfi_tclToken::EN_U32:   
   case tcu_usb_mainfi_tclToken::EN_S32:   
   case tcu_usb_mainfi_tclToken::EN_U64:   
   case tcu_usb_mainfi_tclToken::EN_S64:   
   case tcu_usb_mainfi_tclToken::EN_F32:   
   case tcu_usb_mainfi_tclToken::EN_F64:   
   case tcu_usb_mainfi_tclToken::EN_BOOL:   
   case tcu_usb_mainfi_tclToken::EN_STRING:   
   case tcu_usb_mainfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(enMsgToken,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool tcu_usb_mainfi_tclDescription::bDoIt(tcu_usb_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool tcu_usb_mainfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      tcu_usb_mainfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      tcu_usb_mainfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      tcu_usb_mainfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == tcu_usb_mainfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(tcu_usb_mainfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == tcu_usb_mainfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case tcu_usb_mainfi_tclToken::EN_LIST: 
      {
         tcu_usb_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            tcu_usb_mainfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            tcu_usb_mainfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case tcu_usb_mainfi_tclToken::EN_U8: 
      {
         tcu_usb_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case tcu_usb_mainfi_tclToken::EN_U16: 
      {
         tcu_usb_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case tcu_usb_mainfi_tclToken::EN_U24: 
      {
         tcu_usb_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case tcu_usb_mainfi_tclToken::EN_U32: 
      {
         tcu_usb_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case tcu_usb_mainfi_tclToken::EN_U64: 
      {
         tcu_usb_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case tcu_usb_mainfi_tclToken::EN_S8: 
      {
         tcu_usb_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case tcu_usb_mainfi_tclToken::EN_S16: 
      {
         tcu_usb_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case tcu_usb_mainfi_tclToken::EN_S24: 
      {
         tcu_usb_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case tcu_usb_mainfi_tclToken::EN_S32: 
      {
         tcu_usb_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case tcu_usb_mainfi_tclToken::EN_S64: 
      {
         tcu_usb_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case tcu_usb_mainfi_tclToken::EN_F32: 
      {
         tcu_usb_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case tcu_usb_mainfi_tclToken::EN_F64: 
      {
         tcu_usb_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case tcu_usb_mainfi_tclToken::EN_BOOL: 
      {
         tcu_usb_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case tcu_usb_mainfi_tclToken::EN_STRING: 
      {
         tcu_usb_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case tcu_usb_mainfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         tcu_usb_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case tcu_usb_mainfi_tclToken::EN_MSG_GETCHANNELDATAMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_GETCHANNELDATAMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_GETCONNECTEDSEARCHRESULTMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_GETCONNECTEDSEARCHRESULTMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_GETCHANNELMASTERDATAMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_GETCHANNELMASTERDATAMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_SYNTHESIZESPEAKMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_SYNTHESIZESPEAKMETHODRESULTFIRST:
      case tcu_usb_mainfi_tclToken::EN_MSG_SYNTHESIZESPEAKMETHODRESULTMIDDLE:
      case tcu_usb_mainfi_tclToken::EN_MSG_SYNTHESIZESPEAKMETHODRESULTLAST:
      case tcu_usb_mainfi_tclToken::EN_MSG_ABORTPROMPTMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_ABORTPROMPTMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_PAUSEPROMPTMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_PAUSEPROMPTMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_CONTINUEPROMPTMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_CONTINUEPROMPTMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_CANCELREQUESTMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_CANCELREQUESTMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_SENDGROUPADATAMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_SENDGROUPADATAMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_DELETEINVEHICLEMESSAGEMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_DELETEINVEHICLEMESSAGEMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_RESETDATABASEMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_RESETDATABASEMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_GETSERVERLISTMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_GETSERVERLISTMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_SELECTSERVERMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_SELECTSERVERMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_RETRYGETCHANNELDATAMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_RETRYGETCHANNELDATAMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_OVERWRITEIVMTOTALCONTENTSMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_OVERWRITEIVMTOTALCONTENTSMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_STORECSHISTORYMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_STORECSHISTORYMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_GETTCUDEVICEINFOMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_GETTCUDEVICEINFOMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_SETLOGLEVELMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_SETLOGLEVELMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_RESTOREFACTORYSETTINGSMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_RESTOREFACTORYSETTINGSMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_DELETEMESSAGEBOXMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_DELETEMESSAGEBOXMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_INITIALIZEFEEDLISTMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_INITIALIZEFEEDLISTMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_SETAUTODOWNLOADINTERVALMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_SETAUTODOWNLOADINTERVALMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_GETAUTODOWNLOADINTERVALMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_GETAUTODOWNLOADINTERVALMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_SETAUTODOWNLOADCHANNELMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_SETAUTODOWNLOADCHANNELMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_GETFAVORITECHANNELLISTMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_GETFAVORITECHANNELLISTMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_SETFAVORITECHANNELMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_SETFAVORITECHANNELMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_READFAVORITEFEEDSMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_READFAVORITEFEEDSMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_SELECTFAVORITEFEEDSMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_SELECTFAVORITEFEEDSMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_DELETEINFOHISTORYMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_DELETEINFOHISTORYMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_GETVICSTRAFFICDATAMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_GETVICSTRAFFICDATAMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_GETCHARGINGSTATIONSLISTMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_GETCHARGINGSTATIONSLISTMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_GETCHARGINGSPOTDATAMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_GETCHARGINGSPOTDATAMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_GETVACANCYSPOTDATAMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_GETVACANCYSPOTDATAMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_GETVACANCYSTATIONSLISTMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_GETVACANCYSTATIONSLISTMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_SENDUSERCREDENTIALSMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_SENDUSERCREDENTIALSMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_DELETECHANNELINFORMATIONMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_DELETECHANNELINFORMATIONMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_DOWNLOADPARTAUTHDATAMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_DOWNLOADPARTAUTHDATAMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_VALIDATEUSERCREDENTIALSMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_VALIDATEUSERCREDENTIALSMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_RENEWACCESSTOKENMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_RENEWACCESSTOKENMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_GETACCESSTOKENMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_GETACCESSTOKENMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_VALIDATEUSERCREDENTIALSONTOKENRENEWALERRORMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_VALIDATEUSERCREDENTIALSONTOKENRENEWALERRORMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_CANCELUSERVALIDATIONRENEWTOKENMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_CANCELUSERVALIDATIONRENEWTOKENMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_DECODEIDTOKENMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_DECODEIDTOKENMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_RESETNCSSETTINGSMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_RESETNCSSETTINGSMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_GETPROBEUPLOADPERMITMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_GETPROBEUPLOADPERMITMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_SETPROBEUPLOADPERMITMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_SETPROBEUPLOADPERMITMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_SETPROBEINFODELETEMETHODSTART:
      case tcu_usb_mainfi_tclToken::EN_MSG_SETPROBEINFODELETEMETHODRESULT:
      case tcu_usb_mainfi_tclToken::EN_MSG_USERCREDENTIALSTATUSUPREG:
      case tcu_usb_mainfi_tclToken::EN_MSG_USERCREDENTIALSTATUSRELUPREG:
      case tcu_usb_mainfi_tclToken::EN_MSG_USERCREDENTIALSTATUSSTATUS:
      case tcu_usb_mainfi_tclToken::EN_MSG_NOTIFYTOKENRENEWALERRORSTATUS:
      case tcu_usb_mainfi_tclToken::EN_MSG_CONNECTEDSEARCHRESULTUPREG:
      case tcu_usb_mainfi_tclToken::EN_MSG_CONNECTEDSEARCHRESULTRELUPREG:
      case tcu_usb_mainfi_tclToken::EN_MSG_CONNECTEDSEARCHRESULTSTATUS:
      case tcu_usb_mainfi_tclToken::EN_MSG_CHANNELMASTERDATAUPREG:
      case tcu_usb_mainfi_tclToken::EN_MSG_CHANNELMASTERDATARELUPREG:
      case tcu_usb_mainfi_tclToken::EN_MSG_CHANNELMASTERDATASTATUS:
      case tcu_usb_mainfi_tclToken::EN_MSG_TTSAUDIOSTATEREQUESTUPREG:
      case tcu_usb_mainfi_tclToken::EN_MSG_TTSAUDIOSTATEREQUESTRELUPREG:
      case tcu_usb_mainfi_tclToken::EN_MSG_TTSAUDIOSTATEREQUESTSTATUS:
      case tcu_usb_mainfi_tclToken::EN_MSG_DATABASESTATUSUPREG:
      case tcu_usb_mainfi_tclToken::EN_MSG_DATABASESTATUSRELUPREG:
      case tcu_usb_mainfi_tclToken::EN_MSG_DATABASESTATUSSTATUS:
      case tcu_usb_mainfi_tclToken::EN_MSG_DATABASESTATUSSET:
      case tcu_usb_mainfi_tclToken::EN_MSG_DATACONNECTIONSTATUSUPREG:
      case tcu_usb_mainfi_tclToken::EN_MSG_DATACONNECTIONSTATUSRELUPREG:
      case tcu_usb_mainfi_tclToken::EN_MSG_DATACONNECTIONSTATUSSTATUS:
      case tcu_usb_mainfi_tclToken::EN_MSG_DATACONNECTIONERRORUPREG:
      case tcu_usb_mainfi_tclToken::EN_MSG_DATACONNECTIONERRORRELUPREG:
      case tcu_usb_mainfi_tclToken::EN_MSG_DATACONNECTIONERRORSTATUS:
      case tcu_usb_mainfi_tclToken::EN_MSG_SERVERLISTUPREG:
      case tcu_usb_mainfi_tclToken::EN_MSG_SERVERLISTRELUPREG:
      case tcu_usb_mainfi_tclToken::EN_MSG_SERVERLISTSTATUS:
      case tcu_usb_mainfi_tclToken::EN_MSG_TCUDEVICEINFOUPREG:
      case tcu_usb_mainfi_tclToken::EN_MSG_TCUDEVICEINFORELUPREG:
      case tcu_usb_mainfi_tclToken::EN_MSG_TCUDEVICEINFOSTATUS:
      case tcu_usb_mainfi_tclToken::EN_MSG_NOTIFYAUTODOWNLOADINTERVALUPREG:
      case tcu_usb_mainfi_tclToken::EN_MSG_NOTIFYAUTODOWNLOADINTERVALRELUPREG:
      case tcu_usb_mainfi_tclToken::EN_MSG_NOTIFYAUTODOWNLOADINTERVALSTATUS:
      case tcu_usb_mainfi_tclToken::EN_MSG_GENERALNOTIFICATIONMESSAGEUPREG:
      case tcu_usb_mainfi_tclToken::EN_MSG_GENERALNOTIFICATIONMESSAGERELUPREG:
      case tcu_usb_mainfi_tclToken::EN_MSG_GENERALNOTIFICATIONMESSAGESTATUS:
      case tcu_usb_mainfi_tclToken::EN_MSG_AUTHENTICATIONRESULTDATAUPREG:
      case tcu_usb_mainfi_tclToken::EN_MSG_AUTHENTICATIONRESULTDATARELUPREG:
      case tcu_usb_mainfi_tclToken::EN_MSG_AUTHENTICATIONRESULTDATASTATUS:
      case tcu_usb_mainfi_tclToken::EN_MSG_VICSTRAFFICDATAUPREG:
      case tcu_usb_mainfi_tclToken::EN_MSG_VICSTRAFFICDATARELUPREG:
      case tcu_usb_mainfi_tclToken::EN_MSG_VICSTRAFFICDATASTATUS:
      case tcu_usb_mainfi_tclToken::EN_MSG_CHARGINGSTATIONSLISTUPREG:
      case tcu_usb_mainfi_tclToken::EN_MSG_CHARGINGSTATIONSLISTRELUPREG:
      case tcu_usb_mainfi_tclToken::EN_MSG_CHARGINGSTATIONSLISTSTATUS:
      case tcu_usb_mainfi_tclToken::EN_MSG_CHARGINGSPOTDATAUPREG:
      case tcu_usb_mainfi_tclToken::EN_MSG_CHARGINGSPOTDATARELUPREG:
      case tcu_usb_mainfi_tclToken::EN_MSG_CHARGINGSPOTDATASTATUS:
      case tcu_usb_mainfi_tclToken::EN_MSG_VACANCYSTATIONSLISTUPREG:
      case tcu_usb_mainfi_tclToken::EN_MSG_VACANCYSTATIONSLISTRELUPREG:
      case tcu_usb_mainfi_tclToken::EN_MSG_VACANCYSTATIONSLISTSTATUS:
      case tcu_usb_mainfi_tclToken::EN_MSG_VACANCYSPOTDATAUPREG:
      case tcu_usb_mainfi_tclToken::EN_MSG_VACANCYSPOTDATARELUPREG:
      case tcu_usb_mainfi_tclToken::EN_MSG_VACANCYSPOTDATASTATUS:
      case tcu_usb_mainfi_tclToken::EN_MSG_GENERALRESPONSEERRORUPREG:
      case tcu_usb_mainfi_tclToken::EN_MSG_GENERALRESPONSEERRORRELUPREG:
      case tcu_usb_mainfi_tclToken::EN_MSG_GENERALRESPONSEERRORSTATUS:
         (tVoid) bInitMessage(enToken);
         break;
      case tcu_usb_mainfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_LIST,tcu_usb_mainfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         tcu_usb_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_E16_DATACONNECTIONERROR:
      {
         tcu_usb_fi_tcl_e16_DataConnectionError o_e16_DataConnectionError;
         if (!bDoIt(o_e16_DataConnectionError))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case tcu_usb_mainfi_tclToken::EN_E8_DATACONNECTIONSTATUS:
      {
         tcu_usb_fi_tcl_e8_DataConnectionStatus o_e8_DataConnectionStatus;
         if (!bDoIt(o_e8_DataConnectionStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case tcu_usb_mainfi_tclToken::EN_E8_SERVICETYPE:
      {
         tcu_usb_fi_tcl_e8_ServiceType o_e8_ServiceType;
         if (!bDoIt(o_e8_ServiceType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case tcu_usb_mainfi_tclToken::EN_USB_TCU_CHARGING_STATIONS_REQUEST_INFO:
      {
      if (poVisitor->bDoExpand_usb_tcu_Charging_Stations_Request_Info(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U32,tcu_usb_mainfi_tclSemanticDomain::EN_U32MESHID));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16YCOORDINATE));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16XCOORDINATE));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16SEARCHRANGE));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16MAXNUMBEROFPOI));
      }
      else
      {
         tcu_usb_fi_tcl_usb_tcu_Charging_Stations_Request_Info o_usb_tcu_Charging_Stations_Request_Info;
         if (!bDoIt(o_usb_tcu_Charging_Stations_Request_Info))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_Charging_Stations_Request_Info.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_Charging_Stations_Request_Info.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_USB_TCU_POIID_LIST:
      {
      if (poVisitor->bDoExpand_usb_tcu_POIID_List(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U32,tcu_usb_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_LIST,tcu_usb_mainfi_tclSemanticDomain::EN_POIIDLIST));
      }
      else
      {
         tcu_usb_fi_tcl_usb_tcu_POIID_List o_usb_tcu_POIID_List;
         if (!bDoIt(o_usb_tcu_POIID_List))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_POIID_List.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_POIID_List.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_USB_TCU_VACANCY_STATIONS_REQUEST_INFO:
      {
      if (poVisitor->bDoExpand_usb_tcu_Vacancy_Stations_Request_Info(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8LONG_MINUTE));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8LONG_DEGREE));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8LAT_MINUTE));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8LAT_DEGREE));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8COORDINATESYSTEM));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16REMAININGBATTERYCAPACITY));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16LONG_SECOND));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16LAT_SECOND));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16CRUISINGDISTANCE));
      }
      else
      {
         tcu_usb_fi_tcl_usb_tcu_Vacancy_Stations_Request_Info o_usb_tcu_Vacancy_Stations_Request_Info;
         if (!bDoIt(o_usb_tcu_Vacancy_Stations_Request_Info))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_Vacancy_Stations_Request_Info.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_Vacancy_Stations_Request_Info.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_USB_TCU_FAVORITE_CHANNEL_INFO:
      {
      if (poVisitor->bDoExpand_usb_tcu_Favorite_channel_info(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8FAVORITECHANNELLISTID));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16CHANNELID));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRCHANNELNAMEFORTTS));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRCHANNELNAME));
      }
      else
      {
         tcu_usb_fi_tcl_usb_tcu_Favorite_channel_info o_usb_tcu_Favorite_channel_info;
         if (!bDoIt(o_usb_tcu_Favorite_channel_info))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_Favorite_channel_info.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_Favorite_channel_info.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_USB_TCU_FAVORITE_FEED_LIST:
      {
      if (poVisitor->bDoExpand_usb_tcu_Favorite_Feed_List(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_USB_TCU_FAVORITE_CHANNEL_INFO,tcu_usb_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_LIST,tcu_usb_mainfi_tclSemanticDomain::EN_FAVORITECHANNELINFOLIST));
      }
      else
      {
         tcu_usb_fi_tcl_usb_tcu_Favorite_Feed_List o_usb_tcu_Favorite_Feed_List;
         if (!bDoIt(o_usb_tcu_Favorite_Feed_List))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_Favorite_Feed_List.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_Favorite_Feed_List.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_E8_TCU_PROBEPERMITSETTING:
      {
         tcu_usb_fi_tcl_e8_TCU_ProbePermitSetting o_e8_TCU_ProbePermitSetting;
         if (!bDoIt(o_e8_TCU_ProbePermitSetting))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case tcu_usb_mainfi_tclToken::EN_E8_TCU_NOTIRESULT:
      {
         tcu_usb_fi_tcl_e8_tcu_NotiResult o_e8_tcu_NotiResult;
         if (!bDoIt(o_e8_tcu_NotiResult))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case tcu_usb_mainfi_tclToken::EN_E8_TCU_AUTHENTICATION_RESULT:
      {
         tcu_usb_fi_tcl_e8_tcu_Authentication_Result o_e8_tcu_Authentication_Result;
         if (!bDoIt(o_e8_tcu_Authentication_Result))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case tcu_usb_mainfi_tclToken::EN_E8_TCU_VICS_RESPONSE_DATA:
      {
      if (poVisitor->bDoExpand_e8_tcu_VICS_Response_Data(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_LIST,tcu_usb_mainfi_tclSemanticDomain::EN_VICSRESPONSEDATA));
      }
      else
      {
         tcu_usb_fi_tcl_e8_tcu_VICS_Response_Data o_e8_tcu_VICS_Response_Data;
         if (!bDoIt(o_e8_tcu_VICS_Response_Data))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_e8_tcu_VICS_Response_Data.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_e8_tcu_VICS_Response_Data.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_TCU_BLOCK_DATA_LIST:
      {
      if (poVisitor->bDoExpand_tcu_Block_Data_List(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_LIST,tcu_usb_mainfi_tclSemanticDomain::EN_SECONDLEVELMESHCOORDINATELIST));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8INFORMATIONSOURCEID));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16RESERVED));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16REQUESTINFORMATIONTYPE));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16PREDECTEDDATE));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8PREDECTEDDATE));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16NUMBEROFSECONDLEVELMESH));
      }
      else
      {
         tcu_usb_fi_tcl_tcu_Block_Data_List o_tcu_Block_Data_List;
         if (!bDoIt(o_tcu_Block_Data_List))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_tcu_Block_Data_List.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_tcu_Block_Data_List.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_TCU_JAPAN_LOCATION:
      {
      if (poVisitor->bDoExpand_tcu_Japan_Location(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16SECONDLEVELMESH_YCOORDINATE));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16SECONDLEVELMESH_XCOORDINATE));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16SECONDLEVELMESH_COORDINATEID));
      }
      else
      {
         tcu_usb_fi_tcl_tcu_Japan_Location o_tcu_Japan_Location;
         if (!bDoIt(o_tcu_Japan_Location))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_tcu_Japan_Location.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_tcu_Japan_Location.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_TCU_NAVIGATION_SETTING_INFORMATION:
      {
      if (poVisitor->bDoExpand_tcu_navigation_setting_information(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_TCU_JAPAN_LOCATION,tcu_usb_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_LIST,tcu_usb_mainfi_tclSemanticDomain::EN_WAYPOINTLIST));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8WAYPOINTNUMBER));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8INFORMATIONFLAG));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16VEHICLEDIRECTIONINFO));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16SEARCHCONDITIONINFO));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_TCU_JAPAN_LOCATION,tcu_usb_mainfi_tclSemanticDomain::EN_SCROLLPOINTINFO));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_TCU_JAPAN_LOCATION,tcu_usb_mainfi_tclSemanticDomain::EN_DESTINATIONINFO));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_TCU_JAPAN_LOCATION,tcu_usb_mainfi_tclSemanticDomain::EN_DEPARTUREINFO));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_TCU_JAPAN_LOCATION,tcu_usb_mainfi_tclSemanticDomain::EN_CURRENTLOCATIONINFO));
      }
      else
      {
         tcu_usb_fi_tcl_tcu_navigation_setting_information o_tcu_navigation_setting_information;
         if (!bDoIt(o_tcu_navigation_setting_information))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_tcu_navigation_setting_information.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_tcu_navigation_setting_information.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_E8_TCU_LOGLEVEL:
      {
         tcu_usb_fi_tcl_e8_tcu_LogLevel o_e8_tcu_LogLevel;
         if (!bDoIt(o_e8_tcu_LogLevel))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case tcu_usb_mainfi_tclToken::EN_E8_AUTODOWNLOADINTERVAL:
      {
         tcu_usb_fi_tcl_e8_AutoDownloadInterval o_e8_AutoDownloadInterval;
         if (!bDoIt(o_e8_AutoDownloadInterval))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case tcu_usb_mainfi_tclToken::EN_E8_CONNECTEDSEARCHSERVICETYPE:
      {
         tcu_usb_fi_tcl_e8_ConnectedSearchServiceType o_e8_ConnectedSearchServiceType;
         if (!bDoIt(o_e8_ConnectedSearchServiceType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case tcu_usb_mainfi_tclToken::EN_E8_TCU_AUDIOACTIVITY:
      {
         tcu_usb_fi_tcl_e8_tcu_AudioActivity o_e8_tcu_AudioActivity;
         if (!bDoIt(o_e8_tcu_AudioActivity))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case tcu_usb_mainfi_tclToken::EN_E8_TCU_EXECTYPE:
      {
         tcu_usb_fi_tcl_e8_tcu_ExecType o_e8_tcu_ExecType;
         if (!bDoIt(o_e8_tcu_ExecType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case tcu_usb_mainfi_tclToken::EN_TCU_VICS_REQUEST_DATA:
      {
      if (poVisitor->bDoExpand_tcu_VICS_Request_Data(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_TCU_BLOCK_DATA_LIST,tcu_usb_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_LIST,tcu_usb_mainfi_tclSemanticDomain::EN_BLOCKDATALIST));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_TCU_NAVIGATION_SETTING_INFORMATION,tcu_usb_mainfi_tclSemanticDomain::EN_NAVIGATIONSETTINGINFORMATION));
      }
      else
      {
         tcu_usb_fi_tcl_tcu_VICS_Request_Data o_tcu_VICS_Request_Data;
         if (!bDoIt(o_tcu_VICS_Request_Data))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_tcu_VICS_Request_Data.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_tcu_VICS_Request_Data.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_USB_TCU_CHANNEL_DEFINITION_INFORMATION:
      {
      if (poVisitor->bDoExpand_usb_tcu_Channel_definition_information(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_LIST,tcu_usb_mainfi_tclSemanticDomain::EN_FIXEDDATA5));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_LIST,tcu_usb_mainfi_tclSemanticDomain::EN_FIXEDDATA4));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8SIZEOFCHANNELNAME));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8FLAGOFCHANNELINFO));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8FIXEDDATA9));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8FIXEDDATA8));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8FIXEDDATA7));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8FIXEDDATA6));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8FIXEDDATA3));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8FIXEDDATA2));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8FIXEDDATA1));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16SIZEOFCHANNELDEFINFO));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16FOLDERID));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16CHANNELID));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16CHANNELICONID));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRCHANNELNAME));
      }
      else
      {
         tcu_usb_fi_tcl_usb_tcu_Channel_definition_information o_usb_tcu_Channel_definition_information;
         if (!bDoIt(o_usb_tcu_Channel_definition_information))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_Channel_definition_information.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_Channel_definition_information.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_USB_TCU_CHANNEL_INFO:
      {
      if (poVisitor->bDoExpand_usb_tcu_Channel_Info(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8CHANNELCONTENTID));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16CHANNELID));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_BOOL,tcu_usb_mainfi_tclSemanticDomain::EN_U8RESUMEDOWNLOAD));
      }
      else
      {
         tcu_usb_fi_tcl_usb_tcu_Channel_Info o_usb_tcu_Channel_Info;
         if (!bDoIt(o_usb_tcu_Channel_Info))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_Channel_Info.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_Channel_Info.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_USB_TCU_CHANNEL_INFO_LIST:
      {
      if (poVisitor->bDoExpand_usb_tcu_Channel_Info_List(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_USB_TCU_CHANNEL_INFO,tcu_usb_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_LIST,tcu_usb_mainfi_tclSemanticDomain::EN_CHANNELINFOLIST));
      }
      else
      {
         tcu_usb_fi_tcl_usb_tcu_Channel_Info_List o_usb_tcu_Channel_Info_List;
         if (!bDoIt(o_usb_tcu_Channel_Info_List))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_Channel_Info_List.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_Channel_Info_List.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_USB_TCU_CHANNEL_MASTER_DATA_HEADER:
      {
      if (poVisitor->bDoExpand_usb_tcu_channel_master_data_header(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8NUMOFFOLDERDEFINFO));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16NUMOFCHANNELDEFINFO));
      }
      else
      {
         tcu_usb_fi_tcl_usb_tcu_channel_master_data_header o_usb_tcu_channel_master_data_header;
         if (!bDoIt(o_usb_tcu_channel_master_data_header))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_channel_master_data_header.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_channel_master_data_header.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_USB_TCU_FOLDER_DEFINITION_INFORMATION:
      {
      if (poVisitor->bDoExpand_usb_tcu_Folder_definition_information(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8SIZEOFFOLDERNAME));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8FIXEDDATA2));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8FIXEDDATA1));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16SIZEOFFOLDERDEFINFO));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16FOLDERID));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16FOLDERICONID));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRFOLDERNAME));
      }
      else
      {
         tcu_usb_fi_tcl_usb_tcu_Folder_definition_information o_usb_tcu_Folder_definition_information;
         if (!bDoIt(o_usb_tcu_Folder_definition_information))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_Folder_definition_information.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_Folder_definition_information.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_USB_TCU_LOCATION:
      {
      if (poVisitor->bDoExpand_usb_tcu_Location(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8RESERVED));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8LONGITUDE_MINUTE));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8LONGITUDE_DEGREE));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8LATITUDE_MINUTE));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8LATITUDE_DEGREE));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8DIRECTION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16LONGITUDE_SECOND));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16LATITUDE_SECOND));
      }
      else
      {
         tcu_usb_fi_tcl_usb_tcu_Location o_usb_tcu_Location;
         if (!bDoIt(o_usb_tcu_Location))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_Location.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_Location.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_USB_TCU_DATA_RECORD:
      {
      if (poVisitor->bDoExpand_usb_tcu_Data_Record(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8SIZEOFPOINAME));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8SIZEOFPHONENUMBERFORDISP));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8SIZEOFPHONENUMBER));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8SIZEOFCATEGORY));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8SIZEOFADDRESS));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRPOINAME));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRPHONENUMBERFORDISP));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRPHONENUMBER));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRCATEGORY));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRADDRESS));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_USB_TCU_LOCATION,tcu_usb_mainfi_tclSemanticDomain::EN_LOCATION));
      }
      else
      {
         tcu_usb_fi_tcl_usb_tcu_Data_Record o_usb_tcu_Data_Record;
         if (!bDoIt(o_usb_tcu_Data_Record))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_Data_Record.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_Data_Record.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_USB_TCU_CHANNEL_MASTER_DATA:
      {
      if (poVisitor->bDoExpand_usb_tcu_channel_master_data(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_USB_TCU_FOLDER_DEFINITION_INFORMATION,tcu_usb_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_LIST,tcu_usb_mainfi_tclSemanticDomain::EN_FOLDERDEFINITIONINFORMATION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_USB_TCU_CHANNEL_DEFINITION_INFORMATION,tcu_usb_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_LIST,tcu_usb_mainfi_tclSemanticDomain::EN_CHANNELDEFINITIONINFORMATION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_USB_TCU_CHANNEL_MASTER_DATA_HEADER,tcu_usb_mainfi_tclSemanticDomain::EN_CHANNELMASTERDATAHEADER));
      }
      else
      {
         tcu_usb_fi_tcl_usb_tcu_channel_master_data o_usb_tcu_channel_master_data;
         if (!bDoIt(o_usb_tcu_channel_master_data))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_channel_master_data.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_channel_master_data.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_USB_TCU_GROUPA_AUTHORIZATION_INFO:
      {
      if (poVisitor->bDoExpand_usb_tcu_GroupA_Authorization_Info(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRVINID));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRSIMID));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRNAVIID));
      }
      else
      {
         tcu_usb_fi_tcl_usb_tcu_GroupA_Authorization_Info o_usb_tcu_GroupA_Authorization_Info;
         if (!bDoIt(o_usb_tcu_GroupA_Authorization_Info))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_GroupA_Authorization_Info.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_GroupA_Authorization_Info.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_USB_TCU_GROUPA_BASICSERVICES_INFO:
      {
      if (poVisitor->bDoExpand_usb_tcu_GroupA_BasicServices_Info(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRNAVISWVERSION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRMAPVERSION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRLONGITUDE));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRLATITUDE));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRLANGUAGE));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRDCMVERSION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRDATUM));
      }
      else
      {
         tcu_usb_fi_tcl_usb_tcu_GroupA_BasicServices_Info o_usb_tcu_GroupA_BasicServices_Info;
         if (!bDoIt(o_usb_tcu_GroupA_BasicServices_Info))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_GroupA_BasicServices_Info.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_GroupA_BasicServices_Info.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_USB_TCU_GROUPA_INFO:
      {
      if (poVisitor->bDoExpand_usb_tcu_GroupA_Info(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_USB_TCU_GROUPA_BASICSERVICES_INFO,tcu_usb_mainfi_tclSemanticDomain::EN_GROUPA_BASICSERVICES_INFO));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_USB_TCU_GROUPA_AUTHORIZATION_INFO,tcu_usb_mainfi_tclSemanticDomain::EN_GROUPA_AUTHORIZATION_INFO));
      }
      else
      {
         tcu_usb_fi_tcl_usb_tcu_GroupA_Info o_usb_tcu_GroupA_Info;
         if (!bDoIt(o_usb_tcu_GroupA_Info))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_GroupA_Info.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_GroupA_Info.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_USB_TCU_CONNECTED_SEARCH_RESULT:
      {
      if (poVisitor->bDoExpand_usb_tcu_connected_search_result(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_USB_TCU_DATA_RECORD,tcu_usb_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_LIST,tcu_usb_mainfi_tclSemanticDomain::EN_DATARECORD));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8NUMOFPOI));
      }
      else
      {
         tcu_usb_fi_tcl_usb_tcu_connected_search_result o_usb_tcu_connected_search_result;
         if (!bDoIt(o_usb_tcu_connected_search_result))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_connected_search_result.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_connected_search_result.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_TCU_CHARGING_SPOT_DATA:
      {
      if (poVisitor->bDoExpand_tcu_charging_spot_data(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8USERRESTRICTION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8THETOTALNUMBEROFCHARGINGTYPE));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8THENUMBEROFPARTNERSFACILITYINFORMATION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8THENUMBEROFINSTALLATIONFACILITYINFORMATION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8THENUMBEROFENTRANCEINFORMATION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8SIZEOFTELEPHONENUMBER));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8SIZEOFSTREETANDHOUSENO));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8SIZEOFPOINAME));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8PARTNERSFACILITYINFORMATION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8OFFICEHOURSUNKNOWNINFORMATION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8NEARTHEFACILITYINFORMATION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8INSTALLATIONFACILITYINFORMATION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8INFORMATIONRELIABILITY));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8FIXEDVALUE2));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8FIXEDVALUE1));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8EXPRESSWAYGENERALTYPE));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8ENTRANCEINFORMATION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8DETAILSINFORMATION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8CHARGINGTYPE));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8CHARGINGFEEINFORMATION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8BUSINESSDAYOFTHEWEEKINFORMATION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8_24HOURSADAYINFORMATION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U32,tcu_usb_mainfi_tclSemanticDomain::EN_U32USERRESTRICTIONID));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U32,tcu_usb_mainfi_tclSemanticDomain::EN_U32POIID));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16SUBCATEGORYCODE));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16SIZEOFDETAILINFORMATION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16PAYMENTTYPEINFORMATION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16PARKINGNUMBER));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16OPENINGHOURINFORMATION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16CLOSEDHOURINFORMATION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16CATEGORYCODE));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRTELEPHONENUMBER));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRSTREETANDHOUSENO));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRPOINAME));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRAREACODE8));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRAREACODE7));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRAREACODE6));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRAREACODE5));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRAREACODE4));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRAREACODE3));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRAREACODE2));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRAREACODE1));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_USB_TCU_LOCATION,tcu_usb_mainfi_tclSemanticDomain::EN_LOCATION));
      }
      else
      {
         tcu_usb_fi_tcl_tcu_charging_spot_data o_tcu_charging_spot_data;
         if (!bDoIt(o_tcu_charging_spot_data))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_tcu_charging_spot_data.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_tcu_charging_spot_data.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_TCU_RESPONSE_CHARGING_SPOT_DATA_RESULT:
      {
      if (poVisitor->bDoExpand_tcu_response_charging_spot_data_result(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_TCU_CHARGING_SPOT_DATA,tcu_usb_mainfi_tclSemanticDomain::EN_CHARGINGSPOTDATA));
      }
      else
      {
         tcu_usb_fi_tcl_tcu_response_charging_spot_data_result o_tcu_response_charging_spot_data_result;
         if (!bDoIt(o_tcu_response_charging_spot_data_result))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_tcu_response_charging_spot_data_result.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_tcu_response_charging_spot_data_result.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_TCU_CHARGING_STATIONS_INFO:
      {
      if (poVisitor->bDoExpand_tcu_charging_stations_info(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U32,tcu_usb_mainfi_tclSemanticDomain::EN_U32POIIDVERSION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U32,tcu_usb_mainfi_tclSemanticDomain::EN_U32POIID));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_USB_TCU_LOCATION,tcu_usb_mainfi_tclSemanticDomain::EN_LOCATION));
      }
      else
      {
         tcu_usb_fi_tcl_tcu_charging_stations_info o_tcu_charging_stations_info;
         if (!bDoIt(o_tcu_charging_stations_info))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_tcu_charging_stations_info.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_tcu_charging_stations_info.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_TCU_CHARGING_STATIONS_DATA:
      {
      if (poVisitor->bDoExpand_tcu_charging_stations_data(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_TCU_CHARGING_STATIONS_INFO,tcu_usb_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_LIST,tcu_usb_mainfi_tclSemanticDomain::EN_CHARGINGSTATIONSINFOLIST));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8POIDATASETIDENTIFICATIONIDTYPE));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U32,tcu_usb_mainfi_tclSemanticDomain::EN_U32POIDATASETIDENTIFICATIONID));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U32,tcu_usb_mainfi_tclSemanticDomain::EN_U32NUMBEROFPOIID));
      }
      else
      {
         tcu_usb_fi_tcl_tcu_charging_stations_data o_tcu_charging_stations_data;
         if (!bDoIt(o_tcu_charging_stations_data))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_tcu_charging_stations_data.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_tcu_charging_stations_data.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_TCU_RESPONSE_CHARGING_STATIONS_LIST_RESULT:
      {
      if (poVisitor->bDoExpand_tcu_response_charging_stations_list_result(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_TCU_CHARGING_STATIONS_DATA,tcu_usb_mainfi_tclSemanticDomain::EN_CHARGINGSTATIONSDATA));
      }
      else
      {
         tcu_usb_fi_tcl_tcu_response_charging_stations_list_result o_tcu_response_charging_stations_list_result;
         if (!bDoIt(o_tcu_response_charging_stations_list_result))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_tcu_response_charging_stations_list_result.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_tcu_response_charging_stations_list_result.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_TCU_VACANCY_STATIONS_INFO:
      {
      if (poVisitor->bDoExpand_tcu_vacancy_stations_info(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U32,tcu_usb_mainfi_tclSemanticDomain::EN_U32POIID));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_USB_TCU_LOCATION,tcu_usb_mainfi_tclSemanticDomain::EN_LOCATION));
      }
      else
      {
         tcu_usb_fi_tcl_tcu_vacancy_stations_info o_tcu_vacancy_stations_info;
         if (!bDoIt(o_tcu_vacancy_stations_info))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_tcu_vacancy_stations_info.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_tcu_vacancy_stations_info.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_TCU_VACANCY_STATIONS_DATA:
      {
      if (poVisitor->bDoExpand_tcu_vacancy_stations_data(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_TCU_VACANCY_STATIONS_INFO,tcu_usb_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_LIST,tcu_usb_mainfi_tclSemanticDomain::EN_VACANCYSTATIONSINFOLIST));
      }
      else
      {
         tcu_usb_fi_tcl_tcu_vacancy_stations_data o_tcu_vacancy_stations_data;
         if (!bDoIt(o_tcu_vacancy_stations_data))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_tcu_vacancy_stations_data.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_tcu_vacancy_stations_data.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_TCU_RESPONSE_VACANCY_STATIONS_LIST_RESULT:
      {
      if (poVisitor->bDoExpand_tcu_response_vacancy_stations_list_result(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_TCU_VACANCY_STATIONS_DATA,tcu_usb_mainfi_tclSemanticDomain::EN_VACANCYSTATIONSDATA));
      }
      else
      {
         tcu_usb_fi_tcl_tcu_response_vacancy_stations_list_result o_tcu_response_vacancy_stations_list_result;
         if (!bDoIt(o_tcu_response_vacancy_stations_list_result))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_tcu_response_vacancy_stations_list_result.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_tcu_response_vacancy_stations_list_result.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_TCU_VACANCY_SPOT_DATA:
      {
      if (poVisitor->bDoExpand_tcu_vacancy_spot_data(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8USERRESTRICTION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8THETOTALNUMBEROFCHARGINGTYPE));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8THENUMBEROFPARTNERSFACILITYINFORMATION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8THENUMBEROFINSTALLATIONFACILITYINFORMATION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8THENUMBEROFENTRANCEINFORMATION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8SIZEOFTELEPHONENUMBER));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8SIZEOFSTREETANDHOUSENO));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8SIZEOFPOINAME));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8PARTNERSFACILITYINFORMATION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8OFFICEHOURSUNKNOWNINFORMATION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8NEARTHEFACILITYINFORMATION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8INSTALLATIONFACILITYINFORMATION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8INFORMATIONRELIABILITY));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8FIXEDVALUE2));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8FIXEDVALUE1));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8EXPRESSWAYGENERALTYPE));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8ENTRANCEINFORMATION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8DETAILSINFORMATION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8CHARGINGTYPE));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8CHARGINGFEEINFORMATION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8BUSINESSDAYOFTHEWEEKINFORMATION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8_24HOURSADAYINFORMATION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U32,tcu_usb_mainfi_tclSemanticDomain::EN_U32USERRESTRICTIONID));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U32,tcu_usb_mainfi_tclSemanticDomain::EN_U32POIID));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16SUBCATEGORYCODE));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16SIZEOFDETAILINFORMATION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16PAYMENTTYPEINFORMATION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16PARKINGNUMBER));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16OPENINGHOURINFORMATION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16CLOSEDHOURINFORMATION));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U16,tcu_usb_mainfi_tclSemanticDomain::EN_U16CATEGORYCODE));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRTELEPHONENUMBER));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRSTREETANDHOUSENO));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRPOINAME));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRAREACODE8));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRAREACODE7));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRAREACODE6));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRAREACODE5));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRAREACODE4));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRAREACODE3));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRAREACODE2));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRAREACODE1));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_USB_TCU_LOCATION,tcu_usb_mainfi_tclSemanticDomain::EN_LOCATION));
      }
      else
      {
         tcu_usb_fi_tcl_tcu_vacancy_spot_data o_tcu_vacancy_spot_data;
         if (!bDoIt(o_tcu_vacancy_spot_data))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_tcu_vacancy_spot_data.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_tcu_vacancy_spot_data.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_TCU_RESPONSE_VACANCY_SPOT_DATA_RESULT:
      {
      if (poVisitor->bDoExpand_tcu_response_vacancy_spot_data_result(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_TCU_VACANCY_SPOT_DATA,tcu_usb_mainfi_tclSemanticDomain::EN_VACANCYSPOTDATA));
      }
      else
      {
         tcu_usb_fi_tcl_tcu_response_vacancy_spot_data_result o_tcu_response_vacancy_spot_data_result;
         if (!bDoIt(o_tcu_response_vacancy_spot_data_result))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_tcu_response_vacancy_spot_data_result.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_tcu_response_vacancy_spot_data_result.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_USB_TCU_SERVER_INFO:
      {
      if (poVisitor->bDoExpand_usb_tcu_Server_Info(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_U8,tcu_usb_mainfi_tclSemanticDomain::EN_U8SERVERID));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRSERVERNAME));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_STRSERVERADDRESS));
      }
      else
      {
         tcu_usb_fi_tcl_usb_tcu_Server_Info o_usb_tcu_Server_Info;
         if (!bDoIt(o_usb_tcu_Server_Info))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_Server_Info.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_Server_Info.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_USB_TCU_SERVER_INFO_LIST:
      {
      if (poVisitor->bDoExpand_usb_tcu_Server_Info_List(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_USB_TCU_SERVER_INFO,tcu_usb_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_LIST,tcu_usb_mainfi_tclSemanticDomain::EN_SERVERINFOLIST));
      }
      else
      {
         tcu_usb_fi_tcl_usb_tcu_Server_Info_List o_usb_tcu_Server_Info_List;
         if (!bDoIt(o_usb_tcu_Server_Info_List))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_Server_Info_List.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_Server_Info_List.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_E8_MODEMTYPE:
      {
         tcu_usb_fi_tcl_e8_ModemType o_e8_ModemType;
         if (!bDoIt(o_e8_ModemType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case tcu_usb_mainfi_tclToken::EN_USB_TCU_TCUDEVICE_INFO:
      {
      if (poVisitor->bDoExpand_usb_tcu_TCUDevice_Info(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_BOOL,tcu_usb_mainfi_tclSemanticDomain::EN_BUSBCONNECTIONSTATUS));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_E8_MODEMTYPE,tcu_usb_mainfi_tclSemanticDomain::EN_EMODEMTYPE));
      }
      else
      {
         tcu_usb_fi_tcl_usb_tcu_TCUDevice_Info o_usb_tcu_TCUDevice_Info;
         if (!bDoIt(o_usb_tcu_TCUDevice_Info))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_TCUDevice_Info.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_TCUDevice_Info.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_E8_DATABASESERVICETYPE:
      {
         tcu_usb_fi_tcl_e8_DatabaseServiceType o_e8_DatabaseServiceType;
         if (!bDoIt(o_e8_DatabaseServiceType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case tcu_usb_mainfi_tclToken::EN_E8_DATABASESTATUS:
      {
         tcu_usb_fi_tcl_e8_DatabaseStatus o_e8_DatabaseStatus;
         if (!bDoIt(o_e8_DatabaseStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case tcu_usb_mainfi_tclToken::EN_E8_CANCELREQUESTTYPE:
      {
         tcu_usb_fi_tcl_e8_CancelRequestType o_e8_CancelRequestType;
         if (!bDoIt(o_e8_CancelRequestType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case tcu_usb_mainfi_tclToken::EN_E8_USERAUTHENTICATIONRESULTTYPE:
      {
         tcu_usb_fi_tcl_e8_UserAuthenticationResultType o_e8_UserAuthenticationResultType;
         if (!bDoIt(o_e8_UserAuthenticationResultType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case tcu_usb_mainfi_tclToken::EN_USB_TCU_USERAUTHENTICATION_DECODEDTOKEN_INFO:
      {
      if (poVisitor->bDoExpand_usb_tcu_UserAuthentication_DecodedToken_Info(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_END_OF_STRUCT,tcu_usb_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(tcu_usb_mainfi_tclKnot(tcu_usb_mainfi_tclToken::EN_STRING,tcu_usb_mainfi_tclSemanticDomain::EN_KID));
      }
      else
      {
         tcu_usb_fi_tcl_usb_tcu_UserAuthentication_DecodedToken_Info o_usb_tcu_UserAuthentication_DecodedToken_Info;
         if (!bDoIt(o_usb_tcu_UserAuthentication_DecodedToken_Info))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_UserAuthentication_DecodedToken_Info.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_usb_tcu_UserAuthentication_DecodedToken_Info.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case tcu_usb_mainfi_tclToken::EN_UNKNOWN:
      case tcu_usb_mainfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

