/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef SYNCDISPLAY_MAINFITYPES_HEADER
#define SYNCDISPLAY_MAINFITYPES_HEADER


class syncdisplay_mainfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for syncdisplay_main_fi message types

fi_tclMessageBase* syncdisplay_mainfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class syncdisplay_mainfi_tclMsgBaseMessage : public syncdisplay_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   syncdisplay_mainfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodStart : public syncdisplay_mainfi_tclMsgBaseMessage
{
public:

   syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodStart& operator=(const syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodStart& coRef);
   syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodStart(const syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 T_tU8_ScreenType;
   virtual ~syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodResult : public syncdisplay_mainfi_tclMsgBaseMessage
{
public:

   syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodResult();

   virtual ~syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodResult();

   inline tBool operator==(const syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class syncdisplay_mainfi_tclMsgSetAnimationRunMethodStart : public syncdisplay_mainfi_tclMsgBaseMessage
{
public:

   syncdisplay_mainfi_tclMsgSetAnimationRunMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   syncdisplay_mainfi_tclMsgSetAnimationRunMethodStart& operator=(const syncdisplay_mainfi_tclMsgSetAnimationRunMethodStart& coRef);
   syncdisplay_mainfi_tclMsgSetAnimationRunMethodStart(const syncdisplay_mainfi_tclMsgSetAnimationRunMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 T_tU8_PlayRun;
   virtual ~syncdisplay_mainfi_tclMsgSetAnimationRunMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const syncdisplay_mainfi_tclMsgSetAnimationRunMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class syncdisplay_mainfi_tclMsgSetAnimationRunMethodResult : public syncdisplay_mainfi_tclMsgBaseMessage
{
public:

   syncdisplay_mainfi_tclMsgSetAnimationRunMethodResult();

   virtual ~syncdisplay_mainfi_tclMsgSetAnimationRunMethodResult();

   inline tBool operator==(const syncdisplay_mainfi_tclMsgSetAnimationRunMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class syncdisplay_mainfi_tclMsgSetAnimationStopMethodStart : public syncdisplay_mainfi_tclMsgBaseMessage
{
public:

   syncdisplay_mainfi_tclMsgSetAnimationStopMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   syncdisplay_mainfi_tclMsgSetAnimationStopMethodStart& operator=(const syncdisplay_mainfi_tclMsgSetAnimationStopMethodStart& coRef);
   syncdisplay_mainfi_tclMsgSetAnimationStopMethodStart(const syncdisplay_mainfi_tclMsgSetAnimationStopMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 T_tU8_PlayStop;
   virtual ~syncdisplay_mainfi_tclMsgSetAnimationStopMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const syncdisplay_mainfi_tclMsgSetAnimationStopMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class syncdisplay_mainfi_tclMsgSetAnimationStopMethodResult : public syncdisplay_mainfi_tclMsgBaseMessage
{
public:

   syncdisplay_mainfi_tclMsgSetAnimationStopMethodResult();

   virtual ~syncdisplay_mainfi_tclMsgSetAnimationStopMethodResult();

   inline tBool operator==(const syncdisplay_mainfi_tclMsgSetAnimationStopMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusUpReg : public syncdisplay_mainfi_tclMsgBaseMessage
{
public:

   syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusUpReg();

   virtual ~syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusUpReg();

   inline tBool operator==(const syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusRelUpReg : public syncdisplay_mainfi_tclMsgBaseMessage
{
public:

   syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusRelUpReg();

   virtual ~syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusRelUpReg();

   inline tBool operator==(const syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusGet : public syncdisplay_mainfi_tclMsgBaseMessage
{
public:

   syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusGet();

   virtual ~syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusGet();

   inline tBool operator==(const syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusStatus : public syncdisplay_mainfi_tclMsgBaseMessage
{
public:

   syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusStatus& operator=(const syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusStatus& coRef);
   syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusStatus(const syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   syncdisplay_fi_tcl_e8_EarlyVideoLayer_Status eEarlyVideoLayerStatus;
   virtual ~syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class syncdisplay_mainfi_tclMsgAnimationStatusUpReg : public syncdisplay_mainfi_tclMsgBaseMessage
{
public:

   syncdisplay_mainfi_tclMsgAnimationStatusUpReg();

   virtual ~syncdisplay_mainfi_tclMsgAnimationStatusUpReg();

   inline tBool operator==(const syncdisplay_mainfi_tclMsgAnimationStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class syncdisplay_mainfi_tclMsgAnimationStatusRelUpReg : public syncdisplay_mainfi_tclMsgBaseMessage
{
public:

   syncdisplay_mainfi_tclMsgAnimationStatusRelUpReg();

   virtual ~syncdisplay_mainfi_tclMsgAnimationStatusRelUpReg();

   inline tBool operator==(const syncdisplay_mainfi_tclMsgAnimationStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class syncdisplay_mainfi_tclMsgAnimationStatusGet : public syncdisplay_mainfi_tclMsgBaseMessage
{
public:

   syncdisplay_mainfi_tclMsgAnimationStatusGet();

   virtual ~syncdisplay_mainfi_tclMsgAnimationStatusGet();

   inline tBool operator==(const syncdisplay_mainfi_tclMsgAnimationStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class syncdisplay_mainfi_tclMsgAnimationStatusStatus : public syncdisplay_mainfi_tclMsgBaseMessage
{
public:

   syncdisplay_mainfi_tclMsgAnimationStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   syncdisplay_mainfi_tclMsgAnimationStatusStatus& operator=(const syncdisplay_mainfi_tclMsgAnimationStatusStatus& coRef);
   syncdisplay_mainfi_tclMsgAnimationStatusStatus(const syncdisplay_mainfi_tclMsgAnimationStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   syncdisplay_fi_tcl_e8_Animation_Status T_e8_Animation_Status;
   virtual ~syncdisplay_mainfi_tclMsgAnimationStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const syncdisplay_mainfi_tclMsgAnimationStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
