/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define SYNCDISPLAY_FI_S_IMPORT_INTERFACE_SYNCDISPLAY_MAINFI_TYPES
#define SYNCDISPLAY_FI_S_IMPORT_INTERFACE_SYNCDISPLAY_MAINFI_FUNCTIONIDS
#define SYNCDISPLAY_FI_S_IMPORT_INTERFACE_SYNCDISPLAY_MAINFI_SERVICEINFO
#include "syncdisplay_fi_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for syncdisplay_main_fi message types

fi_tclMessageBase* syncdisplay_mainfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case syncdisplay_mainfi_tclToken::EN_MSG_SETFIRSTSCREENREADYMETHODSTART:
         return OSAL_NEW syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodStart;

      case syncdisplay_mainfi_tclToken::EN_MSG_SETFIRSTSCREENREADYMETHODRESULT:
         return OSAL_NEW syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodResult;

      case syncdisplay_mainfi_tclToken::EN_MSG_SETANIMATIONRUNMETHODSTART:
         return OSAL_NEW syncdisplay_mainfi_tclMsgSetAnimationRunMethodStart;

      case syncdisplay_mainfi_tclToken::EN_MSG_SETANIMATIONRUNMETHODRESULT:
         return OSAL_NEW syncdisplay_mainfi_tclMsgSetAnimationRunMethodResult;

      case syncdisplay_mainfi_tclToken::EN_MSG_SETANIMATIONSTOPMETHODSTART:
         return OSAL_NEW syncdisplay_mainfi_tclMsgSetAnimationStopMethodStart;

      case syncdisplay_mainfi_tclToken::EN_MSG_SETANIMATIONSTOPMETHODRESULT:
         return OSAL_NEW syncdisplay_mainfi_tclMsgSetAnimationStopMethodResult;

      case syncdisplay_mainfi_tclToken::EN_MSG_EARLYVIDEOLAYERSTATUSUPREG:
         return OSAL_NEW syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusUpReg;

      case syncdisplay_mainfi_tclToken::EN_MSG_EARLYVIDEOLAYERSTATUSRELUPREG:
         return OSAL_NEW syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusRelUpReg;

      case syncdisplay_mainfi_tclToken::EN_MSG_EARLYVIDEOLAYERSTATUSGET:
         return OSAL_NEW syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusGet;

      case syncdisplay_mainfi_tclToken::EN_MSG_EARLYVIDEOLAYERSTATUSSTATUS:
         return OSAL_NEW syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusStatus;

      case syncdisplay_mainfi_tclToken::EN_MSG_ANIMATIONSTATUSUPREG:
         return OSAL_NEW syncdisplay_mainfi_tclMsgAnimationStatusUpReg;

      case syncdisplay_mainfi_tclToken::EN_MSG_ANIMATIONSTATUSRELUPREG:
         return OSAL_NEW syncdisplay_mainfi_tclMsgAnimationStatusRelUpReg;

      case syncdisplay_mainfi_tclToken::EN_MSG_ANIMATIONSTATUSGET:
         return OSAL_NEW syncdisplay_mainfi_tclMsgAnimationStatusGet;

      case syncdisplay_mainfi_tclToken::EN_MSG_ANIMATIONSTATUSSTATUS:
         return OSAL_NEW syncdisplay_mainfi_tclMsgAnimationStatusStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all syncdisplay_mainfifi messages

// common functions

tU16 syncdisplay_mainfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return SYNCDISPLAY_MAINFI_C_U16_SERVICE_ID;
}

tU16 syncdisplay_mainfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 syncdisplay_mainfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& syncdisplay_mainfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& syncdisplay_mainfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 syncdisplay_mainfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& syncdisplay_mainfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& syncdisplay_mainfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodStart::syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodStart(const syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodStart& coRef)
   : syncdisplay_mainfi_tclMsgBaseMessage(coRef)
{
   T_tU8_ScreenType = coRef.T_tU8_ScreenType;
}
syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodStart& syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodStart::operator=(const syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodStart& coRef)
{
   if (this == &coRef) return *this;
   T_tU8_ScreenType = coRef.T_tU8_ScreenType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodStart::syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodStart()
:T_tU8_ScreenType(0)
 {}

tS32 syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodStart::s32GetTypeId() const
{
   return (tS32) syncdisplay_mainfi_tclToken::EN_MSG_SETFIRSTSCREENREADYMETHODSTART;
}


syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodStart::~syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodStart()
{}

tU32 syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> T_tU8_ScreenType);
   return oIn;
}

fi_tclOutContext& syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << T_tU8_ScreenType);
   return oOut;
}

tBool syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodStart::operator==(const syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (T_tU8_ScreenType == roRef.T_tU8_ScreenType);
   return bResult;
}

//=============================================================================

syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodResult::syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodResult()
 {}

tS32 syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodResult::s32GetTypeId() const
{
   return (tS32) syncdisplay_mainfi_tclToken::EN_MSG_SETFIRSTSCREENREADYMETHODRESULT;
}


syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodResult::~syncdisplay_mainfi_tclMsgSetFirstScreenReadyMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
syncdisplay_mainfi_tclMsgSetAnimationRunMethodStart::syncdisplay_mainfi_tclMsgSetAnimationRunMethodStart(const syncdisplay_mainfi_tclMsgSetAnimationRunMethodStart& coRef)
   : syncdisplay_mainfi_tclMsgBaseMessage(coRef)
{
   T_tU8_PlayRun = coRef.T_tU8_PlayRun;
}
syncdisplay_mainfi_tclMsgSetAnimationRunMethodStart& syncdisplay_mainfi_tclMsgSetAnimationRunMethodStart::operator=(const syncdisplay_mainfi_tclMsgSetAnimationRunMethodStart& coRef)
{
   if (this == &coRef) return *this;
   T_tU8_PlayRun = coRef.T_tU8_PlayRun;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

syncdisplay_mainfi_tclMsgSetAnimationRunMethodStart::syncdisplay_mainfi_tclMsgSetAnimationRunMethodStart()
:T_tU8_PlayRun(0)
 {}

tS32 syncdisplay_mainfi_tclMsgSetAnimationRunMethodStart::s32GetTypeId() const
{
   return (tS32) syncdisplay_mainfi_tclToken::EN_MSG_SETANIMATIONRUNMETHODSTART;
}


syncdisplay_mainfi_tclMsgSetAnimationRunMethodStart::~syncdisplay_mainfi_tclMsgSetAnimationRunMethodStart()
{}

tU32 syncdisplay_mainfi_tclMsgSetAnimationRunMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& syncdisplay_mainfi_tclMsgSetAnimationRunMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> T_tU8_PlayRun);
   return oIn;
}

fi_tclOutContext& syncdisplay_mainfi_tclMsgSetAnimationRunMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << T_tU8_PlayRun);
   return oOut;
}

tBool syncdisplay_mainfi_tclMsgSetAnimationRunMethodStart::operator==(const syncdisplay_mainfi_tclMsgSetAnimationRunMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (T_tU8_PlayRun == roRef.T_tU8_PlayRun);
   return bResult;
}

//=============================================================================

syncdisplay_mainfi_tclMsgSetAnimationRunMethodResult::syncdisplay_mainfi_tclMsgSetAnimationRunMethodResult()
 {}

tS32 syncdisplay_mainfi_tclMsgSetAnimationRunMethodResult::s32GetTypeId() const
{
   return (tS32) syncdisplay_mainfi_tclToken::EN_MSG_SETANIMATIONRUNMETHODRESULT;
}


syncdisplay_mainfi_tclMsgSetAnimationRunMethodResult::~syncdisplay_mainfi_tclMsgSetAnimationRunMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
syncdisplay_mainfi_tclMsgSetAnimationStopMethodStart::syncdisplay_mainfi_tclMsgSetAnimationStopMethodStart(const syncdisplay_mainfi_tclMsgSetAnimationStopMethodStart& coRef)
   : syncdisplay_mainfi_tclMsgBaseMessage(coRef)
{
   T_tU8_PlayStop = coRef.T_tU8_PlayStop;
}
syncdisplay_mainfi_tclMsgSetAnimationStopMethodStart& syncdisplay_mainfi_tclMsgSetAnimationStopMethodStart::operator=(const syncdisplay_mainfi_tclMsgSetAnimationStopMethodStart& coRef)
{
   if (this == &coRef) return *this;
   T_tU8_PlayStop = coRef.T_tU8_PlayStop;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

syncdisplay_mainfi_tclMsgSetAnimationStopMethodStart::syncdisplay_mainfi_tclMsgSetAnimationStopMethodStart()
:T_tU8_PlayStop(0)
 {}

tS32 syncdisplay_mainfi_tclMsgSetAnimationStopMethodStart::s32GetTypeId() const
{
   return (tS32) syncdisplay_mainfi_tclToken::EN_MSG_SETANIMATIONSTOPMETHODSTART;
}


syncdisplay_mainfi_tclMsgSetAnimationStopMethodStart::~syncdisplay_mainfi_tclMsgSetAnimationStopMethodStart()
{}

tU32 syncdisplay_mainfi_tclMsgSetAnimationStopMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& syncdisplay_mainfi_tclMsgSetAnimationStopMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> T_tU8_PlayStop);
   return oIn;
}

fi_tclOutContext& syncdisplay_mainfi_tclMsgSetAnimationStopMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << T_tU8_PlayStop);
   return oOut;
}

tBool syncdisplay_mainfi_tclMsgSetAnimationStopMethodStart::operator==(const syncdisplay_mainfi_tclMsgSetAnimationStopMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (T_tU8_PlayStop == roRef.T_tU8_PlayStop);
   return bResult;
}

//=============================================================================

syncdisplay_mainfi_tclMsgSetAnimationStopMethodResult::syncdisplay_mainfi_tclMsgSetAnimationStopMethodResult()
 {}

tS32 syncdisplay_mainfi_tclMsgSetAnimationStopMethodResult::s32GetTypeId() const
{
   return (tS32) syncdisplay_mainfi_tclToken::EN_MSG_SETANIMATIONSTOPMETHODRESULT;
}


syncdisplay_mainfi_tclMsgSetAnimationStopMethodResult::~syncdisplay_mainfi_tclMsgSetAnimationStopMethodResult()
{}

//=============================================================================

syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusUpReg::syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusUpReg()
 {}

tS32 syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusUpReg::s32GetTypeId() const
{
   return (tS32) syncdisplay_mainfi_tclToken::EN_MSG_EARLYVIDEOLAYERSTATUSUPREG;
}


syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusUpReg::~syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusUpReg()
{}

//=============================================================================

syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusRelUpReg::syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusRelUpReg()
 {}

tS32 syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) syncdisplay_mainfi_tclToken::EN_MSG_EARLYVIDEOLAYERSTATUSRELUPREG;
}


syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusRelUpReg::~syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusRelUpReg()
{}

//=============================================================================

syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusGet::syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusGet()
 {}

tS32 syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusGet::s32GetTypeId() const
{
   return (tS32) syncdisplay_mainfi_tclToken::EN_MSG_EARLYVIDEOLAYERSTATUSGET;
}


syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusGet::~syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusStatus::syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusStatus(const syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusStatus& coRef)
   : syncdisplay_mainfi_tclMsgBaseMessage(coRef)
{
   eEarlyVideoLayerStatus = coRef.eEarlyVideoLayerStatus;
}
syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusStatus& syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusStatus::operator=(const syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   eEarlyVideoLayerStatus = coRef.eEarlyVideoLayerStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusStatus::syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusStatus()
:eEarlyVideoLayerStatus()
 {}

tS32 syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusStatus::s32GetTypeId() const
{
   return (tS32) syncdisplay_mainfi_tclToken::EN_MSG_EARLYVIDEOLAYERSTATUSSTATUS;
}


syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusStatus::~syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusStatus()
{}

tU32 syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> eEarlyVideoLayerStatus);
   return oIn;
}

fi_tclOutContext& syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << eEarlyVideoLayerStatus);
   return oOut;
}

tBool syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusStatus::operator==(const syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (eEarlyVideoLayerStatus == roRef.eEarlyVideoLayerStatus);
   return bResult;
}

//=============================================================================

syncdisplay_mainfi_tclMsgAnimationStatusUpReg::syncdisplay_mainfi_tclMsgAnimationStatusUpReg()
 {}

tS32 syncdisplay_mainfi_tclMsgAnimationStatusUpReg::s32GetTypeId() const
{
   return (tS32) syncdisplay_mainfi_tclToken::EN_MSG_ANIMATIONSTATUSUPREG;
}


syncdisplay_mainfi_tclMsgAnimationStatusUpReg::~syncdisplay_mainfi_tclMsgAnimationStatusUpReg()
{}

//=============================================================================

syncdisplay_mainfi_tclMsgAnimationStatusRelUpReg::syncdisplay_mainfi_tclMsgAnimationStatusRelUpReg()
 {}

tS32 syncdisplay_mainfi_tclMsgAnimationStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) syncdisplay_mainfi_tclToken::EN_MSG_ANIMATIONSTATUSRELUPREG;
}


syncdisplay_mainfi_tclMsgAnimationStatusRelUpReg::~syncdisplay_mainfi_tclMsgAnimationStatusRelUpReg()
{}

//=============================================================================

syncdisplay_mainfi_tclMsgAnimationStatusGet::syncdisplay_mainfi_tclMsgAnimationStatusGet()
 {}

tS32 syncdisplay_mainfi_tclMsgAnimationStatusGet::s32GetTypeId() const
{
   return (tS32) syncdisplay_mainfi_tclToken::EN_MSG_ANIMATIONSTATUSGET;
}


syncdisplay_mainfi_tclMsgAnimationStatusGet::~syncdisplay_mainfi_tclMsgAnimationStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
syncdisplay_mainfi_tclMsgAnimationStatusStatus::syncdisplay_mainfi_tclMsgAnimationStatusStatus(const syncdisplay_mainfi_tclMsgAnimationStatusStatus& coRef)
   : syncdisplay_mainfi_tclMsgBaseMessage(coRef)
{
   T_e8_Animation_Status = coRef.T_e8_Animation_Status;
}
syncdisplay_mainfi_tclMsgAnimationStatusStatus& syncdisplay_mainfi_tclMsgAnimationStatusStatus::operator=(const syncdisplay_mainfi_tclMsgAnimationStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   T_e8_Animation_Status = coRef.T_e8_Animation_Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

syncdisplay_mainfi_tclMsgAnimationStatusStatus::syncdisplay_mainfi_tclMsgAnimationStatusStatus()
:T_e8_Animation_Status()
 {}

tS32 syncdisplay_mainfi_tclMsgAnimationStatusStatus::s32GetTypeId() const
{
   return (tS32) syncdisplay_mainfi_tclToken::EN_MSG_ANIMATIONSTATUSSTATUS;
}


syncdisplay_mainfi_tclMsgAnimationStatusStatus::~syncdisplay_mainfi_tclMsgAnimationStatusStatus()
{}

tU32 syncdisplay_mainfi_tclMsgAnimationStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& syncdisplay_mainfi_tclMsgAnimationStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> T_e8_Animation_Status);
   return oIn;
}

fi_tclOutContext& syncdisplay_mainfi_tclMsgAnimationStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << T_e8_Animation_Status);
   return oOut;
}

tBool syncdisplay_mainfi_tclMsgAnimationStatusStatus::operator==(const syncdisplay_mainfi_tclMsgAnimationStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (T_e8_Animation_Status == roRef.T_e8_Animation_Status);
   return bResult;
}

