/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef SWITCHCTRL_MAINFITYPES_HEADER
#define SWITCHCTRL_MAINFITYPES_HEADER


class switchctrl_mainfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for switchctrl_main_fi message types

fi_tclMessageBase* switchctrl_mainfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class switchctrl_mainfi_tclMsgBaseMessage : public switchctrl_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   switchctrl_mainfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class switchctrl_mainfi_tclMsgResetHistoryMethodStart : public switchctrl_mainfi_tclMsgBaseMessage
{
public:

   switchctrl_mainfi_tclMsgResetHistoryMethodStart();

   virtual ~switchctrl_mainfi_tclMsgResetHistoryMethodStart();

   inline tBool operator==(const switchctrl_mainfi_tclMsgResetHistoryMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class switchctrl_mainfi_tclMsgResetHistoryMethodResult : public switchctrl_mainfi_tclMsgBaseMessage
{
public:

   switchctrl_mainfi_tclMsgResetHistoryMethodResult();

   virtual ~switchctrl_mainfi_tclMsgResetHistoryMethodResult();

   inline tBool operator==(const switchctrl_mainfi_tclMsgResetHistoryMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class switchctrl_mainfi_tclMsgVersionInfoMethodStart : public switchctrl_mainfi_tclMsgBaseMessage
{
public:

   switchctrl_mainfi_tclMsgVersionInfoMethodStart();

   virtual ~switchctrl_mainfi_tclMsgVersionInfoMethodStart();

   inline tBool operator==(const switchctrl_mainfi_tclMsgVersionInfoMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class switchctrl_mainfi_tclMsgVersionInfoMethodResult : public switchctrl_mainfi_tclMsgBaseMessage
{
public:

   switchctrl_mainfi_tclMsgVersionInfoMethodResult();

   virtual ~switchctrl_mainfi_tclMsgVersionInfoMethodResult();

   inline tBool operator==(const switchctrl_mainfi_tclMsgVersionInfoMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class switchctrl_mainfi_tclMsgBeepInfoMethodStart : public switchctrl_mainfi_tclMsgBaseMessage
{
public:

   switchctrl_mainfi_tclMsgBeepInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   switchctrl_mainfi_tclMsgBeepInfoMethodStart& operator=(const switchctrl_mainfi_tclMsgBeepInfoMethodStart& coRef);
   switchctrl_mainfi_tclMsgBeepInfoMethodStart(const switchctrl_mainfi_tclMsgBeepInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8NoOfBeeps;
   tU8 u8BeepTime;
   tU8 u8Period;
   virtual ~switchctrl_mainfi_tclMsgBeepInfoMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const switchctrl_mainfi_tclMsgBeepInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class switchctrl_mainfi_tclMsgBeepInfoMethodResult : public switchctrl_mainfi_tclMsgBaseMessage
{
public:

   switchctrl_mainfi_tclMsgBeepInfoMethodResult();

   virtual ~switchctrl_mainfi_tclMsgBeepInfoMethodResult();

   inline tBool operator==(const switchctrl_mainfi_tclMsgBeepInfoMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class switchctrl_mainfi_tclMsgRearSeat_ConnectionUpReg : public switchctrl_mainfi_tclMsgBaseMessage
{
public:

   switchctrl_mainfi_tclMsgRearSeat_ConnectionUpReg();

   virtual ~switchctrl_mainfi_tclMsgRearSeat_ConnectionUpReg();

   inline tBool operator==(const switchctrl_mainfi_tclMsgRearSeat_ConnectionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class switchctrl_mainfi_tclMsgRearSeat_ConnectionRelUpReg : public switchctrl_mainfi_tclMsgBaseMessage
{
public:

   switchctrl_mainfi_tclMsgRearSeat_ConnectionRelUpReg();

   virtual ~switchctrl_mainfi_tclMsgRearSeat_ConnectionRelUpReg();

   inline tBool operator==(const switchctrl_mainfi_tclMsgRearSeat_ConnectionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class switchctrl_mainfi_tclMsgRearSeat_ConnectionGet : public switchctrl_mainfi_tclMsgBaseMessage
{
public:

   switchctrl_mainfi_tclMsgRearSeat_ConnectionGet();

   virtual ~switchctrl_mainfi_tclMsgRearSeat_ConnectionGet();

   inline tBool operator==(const switchctrl_mainfi_tclMsgRearSeat_ConnectionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class switchctrl_mainfi_tclMsgRearSeat_ConnectionStatus : public switchctrl_mainfi_tclMsgBaseMessage
{
public:

   switchctrl_mainfi_tclMsgRearSeat_ConnectionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   switchctrl_mainfi_tclMsgRearSeat_ConnectionStatus& operator=(const switchctrl_mainfi_tclMsgRearSeat_ConnectionStatus& coRef);
   switchctrl_mainfi_tclMsgRearSeat_ConnectionStatus(const switchctrl_mainfi_tclMsgRearSeat_ConnectionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   switchctrl_fi_tcl_SwCtrl_ConnectionStatus RSCConnectionStatus;
   virtual ~switchctrl_mainfi_tclMsgRearSeat_ConnectionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const switchctrl_mainfi_tclMsgRearSeat_ConnectionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class switchctrl_mainfi_tclMsgITCommander_ConnectionUpReg : public switchctrl_mainfi_tclMsgBaseMessage
{
public:

   switchctrl_mainfi_tclMsgITCommander_ConnectionUpReg();

   virtual ~switchctrl_mainfi_tclMsgITCommander_ConnectionUpReg();

   inline tBool operator==(const switchctrl_mainfi_tclMsgITCommander_ConnectionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class switchctrl_mainfi_tclMsgITCommander_ConnectionRelUpReg : public switchctrl_mainfi_tclMsgBaseMessage
{
public:

   switchctrl_mainfi_tclMsgITCommander_ConnectionRelUpReg();

   virtual ~switchctrl_mainfi_tclMsgITCommander_ConnectionRelUpReg();

   inline tBool operator==(const switchctrl_mainfi_tclMsgITCommander_ConnectionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class switchctrl_mainfi_tclMsgITCommander_ConnectionGet : public switchctrl_mainfi_tclMsgBaseMessage
{
public:

   switchctrl_mainfi_tclMsgITCommander_ConnectionGet();

   virtual ~switchctrl_mainfi_tclMsgITCommander_ConnectionGet();

   inline tBool operator==(const switchctrl_mainfi_tclMsgITCommander_ConnectionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class switchctrl_mainfi_tclMsgITCommander_ConnectionStatus : public switchctrl_mainfi_tclMsgBaseMessage
{
public:

   switchctrl_mainfi_tclMsgITCommander_ConnectionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   switchctrl_mainfi_tclMsgITCommander_ConnectionStatus& operator=(const switchctrl_mainfi_tclMsgITCommander_ConnectionStatus& coRef);
   switchctrl_mainfi_tclMsgITCommander_ConnectionStatus(const switchctrl_mainfi_tclMsgITCommander_ConnectionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   switchctrl_fi_tcl_SwCtrl_ConnectionStatus ITCommConnStatus;
   virtual ~switchctrl_mainfi_tclMsgITCommander_ConnectionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const switchctrl_mainfi_tclMsgITCommander_ConnectionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class switchctrl_mainfi_tclMsgHardwareVersionUpReg : public switchctrl_mainfi_tclMsgBaseMessage
{
public:

   switchctrl_mainfi_tclMsgHardwareVersionUpReg();

   virtual ~switchctrl_mainfi_tclMsgHardwareVersionUpReg();

   inline tBool operator==(const switchctrl_mainfi_tclMsgHardwareVersionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class switchctrl_mainfi_tclMsgHardwareVersionRelUpReg : public switchctrl_mainfi_tclMsgBaseMessage
{
public:

   switchctrl_mainfi_tclMsgHardwareVersionRelUpReg();

   virtual ~switchctrl_mainfi_tclMsgHardwareVersionRelUpReg();

   inline tBool operator==(const switchctrl_mainfi_tclMsgHardwareVersionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class switchctrl_mainfi_tclMsgHardwareVersionGet : public switchctrl_mainfi_tclMsgBaseMessage
{
public:

   switchctrl_mainfi_tclMsgHardwareVersionGet();

   virtual ~switchctrl_mainfi_tclMsgHardwareVersionGet();

   inline tBool operator==(const switchctrl_mainfi_tclMsgHardwareVersionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class switchctrl_mainfi_tclMsgHardwareVersionStatus : public switchctrl_mainfi_tclMsgBaseMessage
{
public:

   switchctrl_mainfi_tclMsgHardwareVersionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   switchctrl_mainfi_tclMsgHardwareVersionStatus& operator=(const switchctrl_mainfi_tclMsgHardwareVersionStatus& coRef);
   switchctrl_mainfi_tclMsgHardwareVersionStatus(const switchctrl_mainfi_tclMsgHardwareVersionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<switchctrl_fi_tcl_SwitchCtrl_UnitVersion, std::allocator<switchctrl_fi_tcl_SwitchCtrl_UnitVersion> > arHardwareVersionList;
   virtual ~switchctrl_mainfi_tclMsgHardwareVersionStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const switchctrl_mainfi_tclMsgHardwareVersionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class switchctrl_mainfi_tclMsgSoftwareVersionUpReg : public switchctrl_mainfi_tclMsgBaseMessage
{
public:

   switchctrl_mainfi_tclMsgSoftwareVersionUpReg();

   virtual ~switchctrl_mainfi_tclMsgSoftwareVersionUpReg();

   inline tBool operator==(const switchctrl_mainfi_tclMsgSoftwareVersionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class switchctrl_mainfi_tclMsgSoftwareVersionRelUpReg : public switchctrl_mainfi_tclMsgBaseMessage
{
public:

   switchctrl_mainfi_tclMsgSoftwareVersionRelUpReg();

   virtual ~switchctrl_mainfi_tclMsgSoftwareVersionRelUpReg();

   inline tBool operator==(const switchctrl_mainfi_tclMsgSoftwareVersionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class switchctrl_mainfi_tclMsgSoftwareVersionGet : public switchctrl_mainfi_tclMsgBaseMessage
{
public:

   switchctrl_mainfi_tclMsgSoftwareVersionGet();

   virtual ~switchctrl_mainfi_tclMsgSoftwareVersionGet();

   inline tBool operator==(const switchctrl_mainfi_tclMsgSoftwareVersionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class switchctrl_mainfi_tclMsgSoftwareVersionStatus : public switchctrl_mainfi_tclMsgBaseMessage
{
public:

   switchctrl_mainfi_tclMsgSoftwareVersionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   switchctrl_mainfi_tclMsgSoftwareVersionStatus& operator=(const switchctrl_mainfi_tclMsgSoftwareVersionStatus& coRef);
   switchctrl_mainfi_tclMsgSoftwareVersionStatus(const switchctrl_mainfi_tclMsgSoftwareVersionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<switchctrl_fi_tcl_SwitchCtrl_UnitVersion, std::allocator<switchctrl_fi_tcl_SwitchCtrl_UnitVersion> > arSoftwareVersionList;
   virtual ~switchctrl_mainfi_tclMsgSoftwareVersionStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const switchctrl_mainfi_tclMsgSoftwareVersionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionUpReg : public switchctrl_mainfi_tclMsgBaseMessage
{
public:

   switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionUpReg();

   virtual ~switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionUpReg();

   inline tBool operator==(const switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionRelUpReg : public switchctrl_mainfi_tclMsgBaseMessage
{
public:

   switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionRelUpReg();

   virtual ~switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionRelUpReg();

   inline tBool operator==(const switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionGet : public switchctrl_mainfi_tclMsgBaseMessage
{
public:

   switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionGet();

   virtual ~switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionGet();

   inline tBool operator==(const switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionStatus : public switchctrl_mainfi_tclMsgBaseMessage
{
public:

   switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionStatus& operator=(const switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionStatus& coRef);
   switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionStatus(const switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   switchctrl_fi_tcl_SwCtrl_ConnectionStatus PrimarySwitchConnStatus;
   virtual ~switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
