#ifndef SPM_FIVISITOR_HEADER
#define SPM_FIVISITOR_HEADER

// --Basisklasse fuer eine FI-Besucher-Klasse

class spm_fi_tclOutput {
public:
   spm_fi_tclOutput();
   virtual ~spm_fi_tclOutput(){};

   virtual tVoid vPrintLine(tCString coszLine) = 0;
};

class spm_fi_tclFileOutput : public spm_fi_tclOutput 
{
public:
   spm_fi_tclFileOutput(OSAL_tIODescriptor rIOD):fd(rIOD) {}
   virtual tVoid vPrintLine(tCString coszLine);
protected:
   OSAL_tIODescriptor fd;
private:
   spm_fi_tclFileOutput(); //lint !e1704
   spm_fi_tclFileOutput& operator=(const spm_fi_tclFileOutput& coRef);
   spm_fi_tclFileOutput(const spm_fi_tclFileOutput& coRef); //lint !e1704
};

class spm_fi_tclMemOutput : public spm_fi_tclOutput
{
public:
   spm_fi_tclMemOutput(tU32 u32MemSize);
   virtual ~spm_fi_tclMemOutput();
   virtual tVoid vPrintLine(tCString coszLine);
   tString szGetBuffer();
protected:
   tChar* szBuf;
   tChar* szEndBuf;
   tChar* s8BufPos;
private:
   spm_fi_tclMemOutput(); //lint !e1704
   spm_fi_tclMemOutput(const spm_fi_tclMemOutput& coRef); //lint !e1704
   spm_fi_tclMemOutput& operator=(const spm_fi_tclMemOutput& coRef); //lint !e1704
};

class MY_DECL spm_fi_tclVisitorBase {
public:

   // --Konstruktor
   spm_fi_tclVisitorBase():bBreakNow(FALSE),bIsVisitorValid(FALSE) {}
   virtual ~spm_fi_tclVisitorBase() {}

   tBool bIsValid() const { return bIsVisitorValid; }
   tVoid vInvalidate() { bIsVisitorValid=FALSE; }
   tVoid vValidate() { bIsVisitorValid=TRUE; }
   tBool bBreak() const { return bBreakNow; }
   tVoid vReleaseBreak() { bBreakNow = FALSE; }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(spm_fi_tclU8& oU8);
   virtual tVoid vVisitS8(spm_fi_tclS8& oS8);
   virtual tVoid vVisitU16(spm_fi_tclU16& oU16);
   virtual tVoid vVisitS16(spm_fi_tclS16& oS16);
   virtual tVoid vVisitU24(spm_fi_tclU24& oU24);
   virtual tVoid vVisitS24(spm_fi_tclS24& oS24);
   virtual tVoid vVisitU32(spm_fi_tclU32& oU32);
   virtual tVoid vVisitS32(spm_fi_tclS32& oS32);
   virtual tVoid vVisitU64(spm_fi_tclU64& oU64);
   virtual tVoid vVisitS64(spm_fi_tclS64& oS64);
   virtual tVoid vVisitF32(spm_fi_tclF32& oF32);
   virtual tVoid vVisitF64(spm_fi_tclF64& oF64);
   virtual tVoid vVisitBool(spm_fi_tclBool& oBool);
   virtual tVoid vVisitString(spm_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(spm_fi_tclMultiLanguageString& oString);

   virtual tVoid vVisitList(spm_fi_tclList& oList);
   virtual tVoid vVisit_BinContainer(spm_fi_tcl_BinContainer& oBinContainer);

   virtual tVoid vVisit_Reserved(spm_fi_tcl_Reserved& oReserved);

   virtual tVoid vVisit_u8_Percent(spm_fi_tcl_u8_Percent& ou8_Percent);

   virtual tVoid vVisit_s16_PerThousand(spm_fi_tcl_s16_PerThousand& os16_PerThousand);

   virtual tVoid vVisit_u16_IndexInReferenceList(spm_fi_tcl_u16_IndexInReferenceList& ou16_IndexInReferenceList);

   virtual tVoid vVisit_u16_ErrorCode(spm_fi_tcl_u16_ErrorCode& ou16_ErrorCode);

   virtual tVoid vVisit_u16_RPM(spm_fi_tcl_u16_RPM& ou16_RPM);

   virtual tVoid vVisit_s32_Kilogram(spm_fi_tcl_s32_Kilogram& os32_Kilogram);

   virtual tVoid vVisit_s32_Pound(spm_fi_tcl_s32_Pound& os32_Pound);

   virtual tVoid vVisit_s16_Meter(spm_fi_tcl_s16_Meter& os16_Meter);

   virtual tVoid vVisit_s32_Meter(spm_fi_tcl_s32_Meter& os32_Meter);

   virtual tVoid vVisit_s32_Yards(spm_fi_tcl_s32_Yards& os32_Yards);

   virtual tVoid vVisit_s32_Foot(spm_fi_tcl_s32_Foot& os32_Foot);

   virtual tVoid vVisit_s32_Centimeter(spm_fi_tcl_s32_Centimeter& os32_Centimeter);

   virtual tVoid vVisit_s32_Inch(spm_fi_tcl_s32_Inch& os32_Inch);

   virtual tVoid vVisit_s32_Millimeter(spm_fi_tcl_s32_Millimeter& os32_Millimeter);

   virtual tVoid vVisit_s32_Microliter(spm_fi_tcl_s32_Microliter& os32_Microliter);

   virtual tVoid vVisit_s32_Second(spm_fi_tcl_s32_Second& os32_Second);

   virtual tVoid vVisit_u16_MilliSecond(spm_fi_tcl_u16_MilliSecond& ou16_MilliSecond);

   virtual tVoid vVisit_s32_MilliSecond(spm_fi_tcl_s32_MilliSecond& os32_MilliSecond);

   virtual tVoid vVisit_POSIXTime(spm_fi_tcl_POSIXTime& oPOSIXTime);

   virtual tVoid vVisit_e8_DST_State(spm_fi_tcl_e8_DST_State& oe8_DST_State);

   virtual tVoid vVisit_TimeZoneElement(spm_fi_tcl_TimeZoneElement& oTimeZoneElement);

   virtual tVoid vVisit_s16_KmPerHour(spm_fi_tcl_s16_KmPerHour& os16_KmPerHour);

   virtual tVoid vVisit_s16_MilesPerHour(spm_fi_tcl_s16_MilesPerHour& os16_MilesPerHour);

   virtual tVoid vVisit_s16_Knot(spm_fi_tcl_s16_Knot& os16_Knot);

   virtual tVoid vVisit_s16_CentimeterSecond(spm_fi_tcl_s16_CentimeterSecond& os16_CentimeterSecond);

   virtual tVoid vVisit_s16_Kelvin(spm_fi_tcl_s16_Kelvin& os16_Kelvin);

   virtual tVoid vVisit_s16_Fahrenheit(spm_fi_tcl_s16_Fahrenheit& os16_Fahrenheit);

   virtual tVoid vVisit_s32_Pascal(spm_fi_tcl_s32_Pascal& os32_Pascal);

   virtual tVoid vVisit_s32_Watt(spm_fi_tcl_s32_Watt& os32_Watt);

   virtual tVoid vVisit_FIVersion(spm_fi_tcl_FIVersion& oFIVersion);

   virtual tVoid vVisit_s32_Longitude(spm_fi_tcl_s32_Longitude& os32_Longitude);

   virtual tVoid vVisit_s32_Latitude(spm_fi_tcl_s32_Latitude& os32_Latitude);

   virtual tVoid vVisit_PositionWGS84(spm_fi_tcl_PositionWGS84& oPositionWGS84);

   virtual tVoid vVisit_RectangleWGS84(spm_fi_tcl_RectangleWGS84& oRectangleWGS84);

   virtual tVoid vVisit_e16_ISOCountryCode(spm_fi_tcl_e16_ISOCountryCode& oe16_ISOCountryCode);

   virtual tVoid vVisit_e16_ISOLanguageCode(spm_fi_tcl_e16_ISOLanguageCode& oe16_ISOLanguageCode);

   virtual tVoid vVisit_LanguageID(spm_fi_tcl_LanguageID& oLanguageID);

   virtual tVoid vVisit_u8_DirectionAbsolute(spm_fi_tcl_u8_DirectionAbsolute& ou8_DirectionAbsolute);

   virtual tVoid vVisit_u8_DirectionRelative(spm_fi_tcl_u8_DirectionRelative& ou8_DirectionRelative);

   virtual tVoid vVisit_s16_CentiDegree(spm_fi_tcl_s16_CentiDegree& os16_CentiDegree);

   virtual tVoid vVisit_s16_Degree(spm_fi_tcl_s16_Degree& os16_Degree);

   virtual tVoid vVisit_u16_DirectionAbsolute_CentiDegree(spm_fi_tcl_u16_DirectionAbsolute_CentiDegree& ou16_DirectionAbsolute_CentiDegree);

   virtual tVoid vVisit_s16_DirectionRelative_CentiDegree(spm_fi_tcl_s16_DirectionRelative_CentiDegree& os16_DirectionRelative_CentiDegree);

   virtual tVoid vVisit_e8_FuelType(spm_fi_tcl_e8_FuelType& oe8_FuelType);

   virtual tVoid vVisit_DistTimeFuel(spm_fi_tcl_DistTimeFuel& oDistTimeFuel);

   virtual tVoid vVisitTimeDate(spm_fi_tclTimeDate& oimeDate);

   virtual tVoid vVisitSwVersionInfo(spm_fi_tclSwVersionInfo& owVersionInfo);

   virtual tVoid vVisit_b32_SubState0(spm_fi_tcl_b32_SubState0& ob32_SubState0);

   virtual tVoid vVisit_b32_SubState1(spm_fi_tcl_b32_SubState1& ob32_SubState1);

   virtual tVoid vVisit_b32_SubState2(spm_fi_tcl_b32_SubState2& ob32_SubState2);

   virtual tVoid vVisit_b32_SubState3(spm_fi_tcl_b32_SubState3& ob32_SubState3);

   virtual tVoid vVisit_SPM_e32_SubStateType(spm_fi_tcl_SPM_e32_SubStateType& oSPM_e32_SubStateType);

   virtual tVoid vVisit_SPM_e32_OnOffReason(spm_fi_tcl_SPM_e32_OnOffReason& oSPM_e32_OnOffReason);

   virtual tVoid vVisit_SPM_e32_SYSTEM_STATES(spm_fi_tcl_SPM_e32_SYSTEM_STATES& oSPM_e32_SYSTEM_STATES);

   virtual tVoid vVisit_SPM_e32_SYSPWR_BEHAVIOUR(spm_fi_tcl_SPM_e32_SYSPWR_BEHAVIOUR& oSPM_e32_SYSPWR_BEHAVIOUR);

   virtual tVoid vVisit_SPM_e32_HMI_STATE(spm_fi_tcl_SPM_e32_HMI_STATE& oSPM_e32_HMI_STATE);

   virtual tVoid vVisit_SPM_e32_DIM_STATE(spm_fi_tcl_SPM_e32_DIM_STATE& oSPM_e32_DIM_STATE);

   virtual tVoid vVisit_SPM_b32_DIM_STATE(spm_fi_tcl_SPM_b32_DIM_STATE& oSPM_b32_DIM_STATE);

   virtual tVoid vVisit_SPM_e32_BT_STATE(spm_fi_tcl_SPM_e32_BT_STATE& oSPM_e32_BT_STATE);

   virtual tVoid vVisit_SPM_e32_WIFI_STATE(spm_fi_tcl_SPM_e32_WIFI_STATE& oSPM_e32_WIFI_STATE);

   virtual tVoid vVisit_SPM_e32_AUDIO_STATE(spm_fi_tcl_SPM_e32_AUDIO_STATE& oSPM_e32_AUDIO_STATE);

   virtual tVoid vVisit_SPM_e32_SPI_STATE(spm_fi_tcl_SPM_e32_SPI_STATE& oSPM_e32_SPI_STATE);

   virtual tVoid vVisit_SPM_e32_TUNER_STATE(spm_fi_tcl_SPM_e32_TUNER_STATE& oSPM_e32_TUNER_STATE);

   virtual tVoid vVisit_SPM_e32_AUDIO_SOURCE(spm_fi_tcl_SPM_e32_AUDIO_SOURCE& oSPM_e32_AUDIO_SOURCE);

   virtual tVoid vVisit_SPM_e32_CD_INSERT_STATE(spm_fi_tcl_SPM_e32_CD_INSERT_STATE& oSPM_e32_CD_INSERT_STATE);

   virtual tVoid vVisit_SPM_e32_SYS_STATE(spm_fi_tcl_SPM_e32_SYS_STATE& oSPM_e32_SYS_STATE);

   virtual tVoid vVisit_SPM_e32_MOST_EVENT(spm_fi_tcl_SPM_e32_MOST_EVENT& oSPM_e32_MOST_EVENT);

   virtual tVoid vVisit_SPM_e32_MOST_CONFIG_STATE(spm_fi_tcl_SPM_e32_MOST_CONFIG_STATE& oSPM_e32_MOST_CONFIG_STATE);

   virtual tVoid vVisit_SPM_e32_TLA_STATE(spm_fi_tcl_SPM_e32_TLA_STATE& oSPM_e32_TLA_STATE);

   virtual tVoid vVisit_SPM_e32_PROCESSOR_STATE(spm_fi_tcl_SPM_e32_PROCESSOR_STATE& oSPM_e32_PROCESSOR_STATE);

   virtual tVoid vVisit_SPM_e32_STARTUP_STATE(spm_fi_tcl_SPM_e32_STARTUP_STATE& oSPM_e32_STARTUP_STATE);

   virtual tVoid vVisit_SPM_HistoryTrigger(spm_fi_tcl_SPM_HistoryTrigger& oSPM_HistoryTrigger);

   virtual tVoid vVisit_SPM_e32_RESTART_TYPE(spm_fi_tcl_SPM_e32_RESTART_TYPE& oSPM_e32_RESTART_TYPE);

   virtual tVoid vVisit_SPM_e32_CODE_REQUEST(spm_fi_tcl_SPM_e32_CODE_REQUEST& oSPM_e32_CODE_REQUEST);

   virtual tVoid vVisit_SPM_e32_WAKEUP_REASON(spm_fi_tcl_SPM_e32_WAKEUP_REASON& oSPM_e32_WAKEUP_REASON);

   virtual tVoid vVisit_SPM_e32_MEDIA_EJECT_STATE(spm_fi_tcl_SPM_e32_MEDIA_EJECT_STATE& oSPM_e32_MEDIA_EJECT_STATE);

   virtual tVoid vVisit_SPM_e32_KEY_STATE(spm_fi_tcl_SPM_e32_KEY_STATE& oSPM_e32_KEY_STATE);

   virtual tVoid vVisit_SPM_e32_SECURITY_STATE(spm_fi_tcl_SPM_e32_SECURITY_STATE& oSPM_e32_SECURITY_STATE);

   virtual tVoid vVisit_SPM_e32_STARTUP_REASON(spm_fi_tcl_SPM_e32_STARTUP_REASON& oSPM_e32_STARTUP_REASON);

   virtual tVoid vVisit_SPM_e32_PHONE_MUTE_STATE(spm_fi_tcl_SPM_e32_PHONE_MUTE_STATE& oSPM_e32_PHONE_MUTE_STATE);

   virtual tVoid vVisit_e8_ResetReason(spm_fi_tcl_e8_ResetReason& oe8_ResetReason);

   virtual tVoid vVisit_e8_LcmResetReason(spm_fi_tcl_e8_LcmResetReason& oe8_LcmResetReason);

   virtual tVoid vVisit_SPM_e32_CVM_EVENT(spm_fi_tcl_SPM_e32_CVM_EVENT& oSPM_e32_CVM_EVENT);

   virtual tVoid vVisit_SPM_e32_SYSPWRMODE(spm_fi_tcl_SPM_e32_SYSPWRMODE& oSPM_e32_SYSPWRMODE);

   virtual tVoid vVisit_SPM_e8_WAKEUP_LIST_REASON(spm_fi_tcl_SPM_e8_WAKEUP_LIST_REASON& oSPM_e8_WAKEUP_LIST_REASON);

   virtual tVoid vVisit_SPM_TransPortMode(spm_fi_tcl_SPM_TransPortMode& oSPM_TransPortMode);

   virtual tVoid vVisit_SPM_TransPortModeList(spm_fi_tcl_SPM_TransPortModeList& oSPM_TransPortModeList);

   virtual tVoid vVisit_e8_StateModes(spm_fi_tcl_e8_StateModes& oe8_StateModes);

   virtual tVoid vVisit_e8_StateEntryType(spm_fi_tcl_e8_StateEntryType& oe8_StateEntryType);

   virtual tVoid vVisit_SubStateEntry(spm_fi_tcl_SubStateEntry& oSubStateEntry);

   virtual tVoid vVisit_e8_DownloadLockStates(spm_fi_tcl_e8_DownloadLockStates& oe8_DownloadLockStates);

   virtual tVoid vVisit_e8_ProcessState(spm_fi_tcl_e8_ProcessState& oe8_ProcessState);

   virtual tVoid vVisit_ProcessElement(spm_fi_tcl_ProcessElement& oProcessElement);

   virtual tVoid vVisit_SPM_ProcessInfo(spm_fi_tcl_SPM_ProcessInfo& oSPM_ProcessInfo);

   virtual tVoid vVisit_SPM_Vin(spm_fi_tcl_SPM_Vin& oSPM_Vin);

   virtual tVoid vVisit_SPM_VinHistory(spm_fi_tcl_SPM_VinHistory& oSPM_VinHistory);

   virtual tVoid vVisit_ResetElement(spm_fi_tcl_ResetElement& oResetElement);

   virtual tVoid vVisit_WakeupElement(spm_fi_tcl_WakeupElement& oWakeupElement);

   virtual tVoid vVisit_StateChangeElement(spm_fi_tcl_StateChangeElement& oStateChangeElement);

   virtual tVoid vVisit_SwitchOnElement(spm_fi_tcl_SwitchOnElement& oSwitchOnElement);

   virtual tVoid vVisit_SPM_e32_START_PROC_TYPE(spm_fi_tcl_SPM_e32_START_PROC_TYPE& oSPM_e32_START_PROC_TYPE);

   virtual tVoid vVisit_SPM_e32_MRESULT(spm_fi_tcl_SPM_e32_MRESULT& oSPM_e32_MRESULT);

   virtual tVoid vVisit_SPM_e32_RUNLEVEL(spm_fi_tcl_SPM_e32_RUNLEVEL& oSPM_e32_RUNLEVEL);

   virtual tVoid vVisit_SPM_b32_SYSPWRSAVEMODE(spm_fi_tcl_SPM_b32_SYSPWRSAVEMODE& oSPM_b32_SYSPWRSAVEMODE);

   virtual tVoid vVisit_SPM_PartnumberItem(spm_fi_tcl_SPM_PartnumberItem& oSPM_PartnumberItem);

   virtual tVoid vVisit_SPM_PartnumberList(spm_fi_tcl_SPM_PartnumberList& oSPM_PartnumberList);

   virtual tVoid vVisit_SPM_AlphacodeItem(spm_fi_tcl_SPM_AlphacodeItem& oSPM_AlphacodeItem);

   virtual tVoid vVisit_SPM_AlphacodeList(spm_fi_tcl_SPM_AlphacodeList& oSPM_AlphacodeList);

   virtual tVoid vVisit_SPM_e32_REDUCTION_LEVEL(spm_fi_tcl_SPM_e32_REDUCTION_LEVEL& oSPM_e32_REDUCTION_LEVEL);

   virtual tVoid vVisit_SPM_e32_CLEAR_LIST(spm_fi_tcl_SPM_e32_CLEAR_LIST& oSPM_e32_CLEAR_LIST);

   virtual tVoid vVisit_SPM_AppIdList(spm_fi_tcl_SPM_AppIdList& oSPM_AppIdList);

   virtual tVoid vVisit_SPM_RestrictedDlLock(spm_fi_tcl_SPM_RestrictedDlLock& oSPM_RestrictedDlLock);

   virtual tVoid vVisit_e8_UpdateLockCommand(spm_fi_tcl_e8_UpdateLockCommand& oe8_UpdateLockCommand);

   virtual tVoid vVisit_e8_UpdateLockState(spm_fi_tcl_e8_UpdateLockState& oe8_UpdateLockState);

   virtual tVoid vVisit_SPM_UpdateLockState(spm_fi_tcl_SPM_UpdateLockState& oSPM_UpdateLockState);

   virtual tVoid vVisit_SPM_VoltageEventCounter(spm_fi_tcl_SPM_VoltageEventCounter& oSPM_VoltageEventCounter);

   virtual tVoid vVisit_SPM_VoltageRange(spm_fi_tcl_SPM_VoltageRange& oSPM_VoltageRange);

   virtual tVoid vVisit_SPM_SystemStatisticsData(spm_fi_tcl_SPM_SystemStatisticsData& oSPM_SystemStatisticsData);

   virtual tVoid vVisit_SPM_ResetInfoStatisticData(spm_fi_tcl_SPM_ResetInfoStatisticData& oSPM_ResetInfoStatisticData);

   virtual tVoid vVisit_SPM_SWVersionStatisticData(spm_fi_tcl_SPM_SWVersionStatisticData& oSPM_SWVersionStatisticData);

   virtual tVoid vVisit_e8_DefSetMode(spm_fi_tcl_e8_DefSetMode& oe8_DefSetMode);

   virtual tVoid vVisit_e8_DefSetServiceStatus(spm_fi_tcl_e8_DefSetServiceStatus& oe8_DefSetServiceStatus);

   virtual tVoid vVisit_e8_DiaglogDefsetType(spm_fi_tcl_e8_DiaglogDefsetType& oe8_DiaglogDefsetType);

   virtual tVoid vVisit_e8_DefSetGroup(spm_fi_tcl_e8_DefSetGroup& oe8_DefSetGroup);


 	fi_tclTraversePath<fi_tclKnot>::tclIterator oIterator;		
	
protected:
	tBool bBreakNow;
	tBool bIsVisitorValid;
private:

};

#endif
